use crate::blob::blob::Blob;
use azure_core::errors::AzureError;
use azure_core::headers::{date_from_headers, request_id_from_headers};
use azure_core::RequestId;
use chrono::{DateTime, Utc};
use http::HeaderMap;

#[derive(Debug, Clone)]
pub struct GetBlobResponse {
    pub blob: Blob,
    pub request_id: RequestId,
    pub data: Vec<u8>,
    pub date: DateTime<Utc>,
    pub content_range: Option<String>,
}

impl GetBlobResponse {
    pub(crate) fn from_response(
        headers: &HeaderMap,
        blob: Blob,
        body: &[u8],
    ) -> Result<GetBlobResponse, AzureError> {
        debug!("headers == {:#?}", headers);

        let request_id = request_id_from_headers(headers)?;
        let date = date_from_headers(headers)?;

        let content_range = headers
            .get(http::header::CONTENT_RANGE)
            .map(|h| h.to_str().unwrap().to_owned());

        Ok(GetBlobResponse {
            blob,
            request_id,
            data: body.to_vec(),
            date,
            content_range,
        })
    }
}
