#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Component {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ComponentProperties>,
}
impl Component {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComponentProperties {
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[serde(rename = "solutionId", default, skip_serializing_if = "Option::is_none")]
    pub solution_id: Option<String>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<component_properties::WorkloadType>,
    #[serde(rename = "componentName", default, skip_serializing_if = "Option::is_none")]
    pub component_name: Option<String>,
    #[serde(rename = "componentTypeId", default, skip_serializing_if = "Option::is_none")]
    pub component_type_id: Option<String>,
    #[serde(rename = "componentTypeName", default, skip_serializing_if = "Option::is_none")]
    pub component_type_name: Option<String>,
    #[serde(rename = "componentTypeGroupCategory", default, skip_serializing_if = "Option::is_none")]
    pub component_type_group_category: Option<String>,
    #[serde(rename = "healthState", default, skip_serializing_if = "Option::is_none")]
    pub health_state: Option<component_properties::HealthState>,
    #[serde(rename = "healthStateCategory", default, skip_serializing_if = "Option::is_none")]
    pub health_state_category: Option<component_properties::HealthStateCategory>,
    #[serde(rename = "healthStateChangesStartTime", default, skip_serializing_if = "Option::is_none")]
    pub health_state_changes_start_time: Option<String>,
    #[serde(rename = "healthStateChangesEndTime", default, skip_serializing_if = "Option::is_none")]
    pub health_state_changes_end_time: Option<String>,
    #[serde(rename = "lastHealthStateChangeTime", default, skip_serializing_if = "Option::is_none")]
    pub last_health_state_change_time: Option<String>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[serde(rename = "vmTags", default, skip_serializing_if = "Option::is_none")]
    pub vm_tags: Option<serde_json::Value>,
    #[serde(rename = "aggregateProperties", default, skip_serializing_if = "Option::is_none")]
    pub aggregate_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub children: Vec<Component>,
}
impl ComponentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod component_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        #[serde(rename = "BaseOS")]
        BaseOs,
        #[serde(rename = "SQL")]
        Sql,
        #[serde(rename = "IIS")]
        Iis,
        Apache,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthState {
        Error,
        Warning,
        Success,
        Unknown,
        Uninitialized,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthStateCategory {
        Identity,
        CustomGroup,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComponentsCollection {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Component>,
}
impl ComponentsCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorFieldContract {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl ErrorFieldContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorFieldContract>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HealthStateChange {
    #[serde(rename = "healthState", default, skip_serializing_if = "Option::is_none")]
    pub health_state: Option<health_state_change::HealthState>,
    #[serde(rename = "healthStateChangeTime", default, skip_serializing_if = "Option::is_none")]
    pub health_state_change_time: Option<String>,
}
impl HealthStateChange {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod health_state_change {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthState {
        Error,
        Warning,
        Success,
        Unknown,
        Uninitialized,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Monitor {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MonitorProperties>,
}
impl Monitor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MonitorCriteria {
    #[serde(rename = "healthState", default, skip_serializing_if = "Option::is_none")]
    pub health_state: Option<monitor_criteria::HealthState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub threshold: Option<f64>,
    #[serde(rename = "comparisonOperator", default, skip_serializing_if = "Option::is_none")]
    pub comparison_operator: Option<monitor_criteria::ComparisonOperator>,
}
impl MonitorCriteria {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod monitor_criteria {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthState {
        Error,
        Warning,
        Success,
        Unknown,
        Uninitialized,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComparisonOperator {
        Equals,
        GreaterThan,
        GreaterThanOrEqual,
        LessThan,
        LessThanOrEqual,
        NotEquals,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MonitorInstance {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MonitorInstanceProperties>,
}
impl MonitorInstance {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MonitorInstanceProperties {
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[serde(rename = "solutionId", default, skip_serializing_if = "Option::is_none")]
    pub solution_id: Option<String>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<monitor_instance_properties::WorkloadType>,
    #[serde(rename = "componentId", default, skip_serializing_if = "Option::is_none")]
    pub component_id: Option<String>,
    #[serde(rename = "componentName", default, skip_serializing_if = "Option::is_none")]
    pub component_name: Option<String>,
    #[serde(rename = "componentTypeId", default, skip_serializing_if = "Option::is_none")]
    pub component_type_id: Option<String>,
    #[serde(rename = "componentTypeName", default, skip_serializing_if = "Option::is_none")]
    pub component_type_name: Option<String>,
    #[serde(rename = "monitorId", default, skip_serializing_if = "Option::is_none")]
    pub monitor_id: Option<String>,
    #[serde(rename = "monitorName", default, skip_serializing_if = "Option::is_none")]
    pub monitor_name: Option<String>,
    #[serde(rename = "monitorType", default, skip_serializing_if = "Option::is_none")]
    pub monitor_type: Option<monitor_instance_properties::MonitorType>,
    #[serde(rename = "monitorCategory", default, skip_serializing_if = "Option::is_none")]
    pub monitor_category: Option<monitor_instance_properties::MonitorCategory>,
    #[serde(rename = "healthState", default, skip_serializing_if = "Option::is_none")]
    pub health_state: Option<monitor_instance_properties::HealthState>,
    #[serde(rename = "healthStateCategory", default, skip_serializing_if = "Option::is_none")]
    pub health_state_category: Option<monitor_instance_properties::HealthStateCategory>,
    #[serde(rename = "healthStateChanges", default, skip_serializing_if = "Vec::is_empty")]
    pub health_state_changes: Vec<HealthStateChange>,
    #[serde(rename = "healthStateChangesStartTime", default, skip_serializing_if = "Option::is_none")]
    pub health_state_changes_start_time: Option<String>,
    #[serde(rename = "healthStateChangesEndTime", default, skip_serializing_if = "Option::is_none")]
    pub health_state_changes_end_time: Option<String>,
    #[serde(rename = "lastHealthStateChangeTime", default, skip_serializing_if = "Option::is_none")]
    pub last_health_state_change_time: Option<String>,
    #[serde(rename = "alertGeneration", default, skip_serializing_if = "Option::is_none")]
    pub alert_generation: Option<monitor_instance_properties::AlertGeneration>,
    #[serde(rename = "aggregateProperties", default, skip_serializing_if = "Option::is_none")]
    pub aggregate_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub children: Vec<MonitorInstance>,
}
impl MonitorInstanceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod monitor_instance_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        #[serde(rename = "BaseOS")]
        BaseOs,
        #[serde(rename = "SQL")]
        Sql,
        #[serde(rename = "IIS")]
        Iis,
        Apache,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MonitorType {
        Aggregate,
        Dependency,
        Unit,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MonitorCategory {
        AvailabilityHealth,
        Configuration,
        EntityHealth,
        PerformanceHealth,
        Security,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthState {
        Error,
        Warning,
        Success,
        Unknown,
        Uninitialized,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthStateCategory {
        Identity,
        CustomGroup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AlertGeneration {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MonitorInstancesCollection {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MonitorInstance>,
}
impl MonitorInstancesCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MonitorProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "monitorId", default, skip_serializing_if = "Option::is_none")]
    pub monitor_id: Option<String>,
    #[serde(rename = "monitorName", default, skip_serializing_if = "Option::is_none")]
    pub monitor_name: Option<String>,
    #[serde(rename = "monitorDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub monitor_display_name: Option<String>,
    #[serde(rename = "parentMonitorName", default, skip_serializing_if = "Option::is_none")]
    pub parent_monitor_name: Option<String>,
    #[serde(rename = "parentMonitorDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub parent_monitor_display_name: Option<String>,
    #[serde(rename = "monitorType", default, skip_serializing_if = "Option::is_none")]
    pub monitor_type: Option<monitor_properties::MonitorType>,
    #[serde(rename = "monitorCategory", default, skip_serializing_if = "Option::is_none")]
    pub monitor_category: Option<monitor_properties::MonitorCategory>,
    #[serde(rename = "componentTypeId", default, skip_serializing_if = "Option::is_none")]
    pub component_type_id: Option<String>,
    #[serde(rename = "componentTypeName", default, skip_serializing_if = "Option::is_none")]
    pub component_type_name: Option<String>,
    #[serde(rename = "componentTypeDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub component_type_display_name: Option<String>,
    #[serde(rename = "monitorState", default, skip_serializing_if = "Option::is_none")]
    pub monitor_state: Option<monitor_properties::MonitorState>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub criteria: Vec<MonitorCriteria>,
    #[serde(rename = "alertGeneration", default, skip_serializing_if = "Option::is_none")]
    pub alert_generation: Option<monitor_properties::AlertGeneration>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<i32>,
    #[serde(rename = "lookbackDuration", default, skip_serializing_if = "Option::is_none")]
    pub lookback_duration: Option<i32>,
    #[serde(rename = "documentationURL", default, skip_serializing_if = "Option::is_none")]
    pub documentation_url: Option<String>,
    #[serde(rename = "signalName", default, skip_serializing_if = "Option::is_none")]
    pub signal_name: Option<String>,
    #[serde(rename = "signalType", default, skip_serializing_if = "Option::is_none")]
    pub signal_type: Option<String>,
}
impl MonitorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod monitor_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MonitorType {
        Aggregate,
        Dependency,
        Unit,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MonitorCategory {
        AvailabilityHealth,
        Configuration,
        EntityHealth,
        PerformanceHealth,
        Security,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MonitorState {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AlertGeneration {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MonitorsCollection {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Monitor>,
}
impl MonitorsCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationSetting {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NotificationSettingProperties>,
}
impl NotificationSetting {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationSettingProperties {
    #[serde(rename = "actionGroupResourceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub action_group_resource_ids: Vec<String>,
}
impl NotificationSettingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationSettingsCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NotificationSetting>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NotificationSettingsCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
}
impl OperationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
