#![doc = "generated by AutoRust"]
#![allow(unused_mut)]
#![allow(unused_variables)]
#![allow(unused_imports)]
use super::models;
#[derive(Clone)]
pub struct Client {
    endpoint: String,
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    scopes: Vec<String>,
    pipeline: azure_core::Pipeline,
}
#[derive(Clone)]
pub struct ClientBuilder {
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    endpoint: Option<String>,
    scopes: Option<Vec<String>>,
}
pub const DEFAULT_ENDPOINT: &str = azure_core::resource_manager_endpoint::AZURE_PUBLIC_CLOUD;
impl ClientBuilder {
    pub fn new(credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>) -> Self {
        Self {
            credential,
            endpoint: None,
            scopes: None,
        }
    }
    pub fn endpoint(mut self, endpoint: impl Into<String>) -> Self {
        self.endpoint = Some(endpoint.into());
        self
    }
    pub fn scopes(mut self, scopes: &[&str]) -> Self {
        self.scopes = Some(scopes.iter().map(|scope| (*scope).to_owned()).collect());
        self
    }
    pub fn build(self) -> Client {
        let endpoint = self.endpoint.unwrap_or_else(|| DEFAULT_ENDPOINT.to_owned());
        let scopes = self.scopes.unwrap_or_else(|| vec![format!("{}/", endpoint)]);
        Client::new(endpoint, self.credential, scopes)
    }
}
impl Client {
    pub(crate) fn endpoint(&self) -> &str {
        self.endpoint.as_str()
    }
    pub(crate) fn token_credential(&self) -> &dyn azure_core::auth::TokenCredential {
        self.credential.as_ref()
    }
    pub(crate) fn scopes(&self) -> Vec<&str> {
        self.scopes.iter().map(String::as_str).collect()
    }
    pub(crate) async fn send(&self, request: impl Into<azure_core::Request>) -> azure_core::error::Result<azure_core::Response> {
        let mut context = azure_core::Context::default();
        let mut request = request.into();
        self.pipeline.send(&mut context, &mut request).await
    }
    pub fn new(
        endpoint: impl Into<String>,
        credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
        scopes: Vec<String>,
    ) -> Self {
        let endpoint = endpoint.into();
        let pipeline = azure_core::Pipeline::new(
            option_env!("CARGO_PKG_NAME"),
            option_env!("CARGO_PKG_VERSION"),
            azure_core::ClientOptions::default(),
            Vec::new(),
            Vec::new(),
        );
        Self {
            endpoint,
            credential,
            scopes,
            pipeline,
        }
    }
    pub fn web_apps(&self) -> web_apps::Client {
        web_apps::Client(self.clone())
    }
}
#[non_exhaustive]
#[derive(Debug, thiserror :: Error)]
#[allow(non_camel_case_types)]
pub enum Error {
    #[error(transparent)]
    WebApps_List(#[from] web_apps::list::Error),
    #[error(transparent)]
    WebApps_ListByResourceGroup(#[from] web_apps::list_by_resource_group::Error),
    #[error(transparent)]
    WebApps_Get(#[from] web_apps::get::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdate(#[from] web_apps::create_or_update::Error),
    #[error(transparent)]
    WebApps_Update(#[from] web_apps::update::Error),
    #[error(transparent)]
    WebApps_Delete(#[from] web_apps::delete::Error),
    #[error(transparent)]
    WebApps_AnalyzeCustomHostname(#[from] web_apps::analyze_custom_hostname::Error),
    #[error(transparent)]
    WebApps_ApplySlotConfigToProduction(#[from] web_apps::apply_slot_config_to_production::Error),
    #[error(transparent)]
    WebApps_Backup(#[from] web_apps::backup::Error),
    #[error(transparent)]
    WebApps_ListBackups(#[from] web_apps::list_backups::Error),
    #[error(transparent)]
    WebApps_DiscoverRestore(#[from] web_apps::discover_restore::Error),
    #[error(transparent)]
    WebApps_GetBackupStatus(#[from] web_apps::get_backup_status::Error),
    #[error(transparent)]
    WebApps_DeleteBackup(#[from] web_apps::delete_backup::Error),
    #[error(transparent)]
    WebApps_ListBackupStatusSecrets(#[from] web_apps::list_backup_status_secrets::Error),
    #[error(transparent)]
    WebApps_Restore(#[from] web_apps::restore::Error),
    #[error(transparent)]
    WebApps_ListConfigurations(#[from] web_apps::list_configurations::Error),
    #[error(transparent)]
    WebApps_UpdateApplicationSettings(#[from] web_apps::update_application_settings::Error),
    #[error(transparent)]
    WebApps_ListApplicationSettings(#[from] web_apps::list_application_settings::Error),
    #[error(transparent)]
    WebApps_UpdateAuthSettings(#[from] web_apps::update_auth_settings::Error),
    #[error(transparent)]
    WebApps_GetAuthSettings(#[from] web_apps::get_auth_settings::Error),
    #[error(transparent)]
    WebApps_UpdateBackupConfiguration(#[from] web_apps::update_backup_configuration::Error),
    #[error(transparent)]
    WebApps_DeleteBackupConfiguration(#[from] web_apps::delete_backup_configuration::Error),
    #[error(transparent)]
    WebApps_GetBackupConfiguration(#[from] web_apps::get_backup_configuration::Error),
    #[error(transparent)]
    WebApps_UpdateConnectionStrings(#[from] web_apps::update_connection_strings::Error),
    #[error(transparent)]
    WebApps_ListConnectionStrings(#[from] web_apps::list_connection_strings::Error),
    #[error(transparent)]
    WebApps_GetDiagnosticLogsConfiguration(#[from] web_apps::get_diagnostic_logs_configuration::Error),
    #[error(transparent)]
    WebApps_UpdateDiagnosticLogsConfig(#[from] web_apps::update_diagnostic_logs_config::Error),
    #[error(transparent)]
    WebApps_UpdateMetadata(#[from] web_apps::update_metadata::Error),
    #[error(transparent)]
    WebApps_ListMetadata(#[from] web_apps::list_metadata::Error),
    #[error(transparent)]
    WebApps_ListPublishingCredentials(#[from] web_apps::list_publishing_credentials::Error),
    #[error(transparent)]
    WebApps_UpdateSitePushSettings(#[from] web_apps::update_site_push_settings::Error),
    #[error(transparent)]
    WebApps_ListSitePushSettings(#[from] web_apps::list_site_push_settings::Error),
    #[error(transparent)]
    WebApps_ListSlotConfigurationNames(#[from] web_apps::list_slot_configuration_names::Error),
    #[error(transparent)]
    WebApps_UpdateSlotConfigurationNames(#[from] web_apps::update_slot_configuration_names::Error),
    #[error(transparent)]
    WebApps_GetConfiguration(#[from] web_apps::get_configuration::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateConfiguration(#[from] web_apps::create_or_update_configuration::Error),
    #[error(transparent)]
    WebApps_UpdateConfiguration(#[from] web_apps::update_configuration::Error),
    #[error(transparent)]
    WebApps_ListConfigurationSnapshotInfo(#[from] web_apps::list_configuration_snapshot_info::Error),
    #[error(transparent)]
    WebApps_GetConfigurationSnapshot(#[from] web_apps::get_configuration_snapshot::Error),
    #[error(transparent)]
    WebApps_RecoverSiteConfigurationSnapshot(#[from] web_apps::recover_site_configuration_snapshot::Error),
    #[error(transparent)]
    WebApps_GetWebSiteContainerLogs(#[from] web_apps::get_web_site_container_logs::Error),
    #[error(transparent)]
    WebApps_GetWebSiteContainerLogsZip(#[from] web_apps::get_web_site_container_logs_zip::Error),
    #[error(transparent)]
    WebApps_ListContinuousWebJobs(#[from] web_apps::list_continuous_web_jobs::Error),
    #[error(transparent)]
    WebApps_GetContinuousWebJob(#[from] web_apps::get_continuous_web_job::Error),
    #[error(transparent)]
    WebApps_DeleteContinuousWebJob(#[from] web_apps::delete_continuous_web_job::Error),
    #[error(transparent)]
    WebApps_StartContinuousWebJob(#[from] web_apps::start_continuous_web_job::Error),
    #[error(transparent)]
    WebApps_StopContinuousWebJob(#[from] web_apps::stop_continuous_web_job::Error),
    #[error(transparent)]
    WebApps_ListDeployments(#[from] web_apps::list_deployments::Error),
    #[error(transparent)]
    WebApps_GetDeployment(#[from] web_apps::get_deployment::Error),
    #[error(transparent)]
    WebApps_CreateDeployment(#[from] web_apps::create_deployment::Error),
    #[error(transparent)]
    WebApps_DeleteDeployment(#[from] web_apps::delete_deployment::Error),
    #[error(transparent)]
    WebApps_ListDeploymentLog(#[from] web_apps::list_deployment_log::Error),
    #[error(transparent)]
    WebApps_ListDomainOwnershipIdentifiers(#[from] web_apps::list_domain_ownership_identifiers::Error),
    #[error(transparent)]
    WebApps_GetDomainOwnershipIdentifier(#[from] web_apps::get_domain_ownership_identifier::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateDomainOwnershipIdentifier(#[from] web_apps::create_or_update_domain_ownership_identifier::Error),
    #[error(transparent)]
    WebApps_UpdateDomainOwnershipIdentifier(#[from] web_apps::update_domain_ownership_identifier::Error),
    #[error(transparent)]
    WebApps_DeleteDomainOwnershipIdentifier(#[from] web_apps::delete_domain_ownership_identifier::Error),
    #[error(transparent)]
    WebApps_GetMsDeployStatus(#[from] web_apps::get_ms_deploy_status::Error),
    #[error(transparent)]
    WebApps_CreateMsDeployOperation(#[from] web_apps::create_ms_deploy_operation::Error),
    #[error(transparent)]
    WebApps_GetMsDeployLog(#[from] web_apps::get_ms_deploy_log::Error),
    #[error(transparent)]
    WebApps_ListFunctions(#[from] web_apps::list_functions::Error),
    #[error(transparent)]
    WebApps_GetFunctionsAdminToken(#[from] web_apps::get_functions_admin_token::Error),
    #[error(transparent)]
    WebApps_GetFunction(#[from] web_apps::get_function::Error),
    #[error(transparent)]
    WebApps_CreateFunction(#[from] web_apps::create_function::Error),
    #[error(transparent)]
    WebApps_DeleteFunction(#[from] web_apps::delete_function::Error),
    #[error(transparent)]
    WebApps_ListFunctionSecrets(#[from] web_apps::list_function_secrets::Error),
    #[error(transparent)]
    WebApps_ListHostNameBindings(#[from] web_apps::list_host_name_bindings::Error),
    #[error(transparent)]
    WebApps_GetHostNameBinding(#[from] web_apps::get_host_name_binding::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateHostNameBinding(#[from] web_apps::create_or_update_host_name_binding::Error),
    #[error(transparent)]
    WebApps_DeleteHostNameBinding(#[from] web_apps::delete_host_name_binding::Error),
    #[error(transparent)]
    WebApps_GetHybridConnection(#[from] web_apps::get_hybrid_connection::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateHybridConnection(#[from] web_apps::create_or_update_hybrid_connection::Error),
    #[error(transparent)]
    WebApps_UpdateHybridConnection(#[from] web_apps::update_hybrid_connection::Error),
    #[error(transparent)]
    WebApps_DeleteHybridConnection(#[from] web_apps::delete_hybrid_connection::Error),
    #[error(transparent)]
    WebApps_ListHybridConnectionKeys(#[from] web_apps::list_hybrid_connection_keys::Error),
    #[error(transparent)]
    WebApps_ListHybridConnections(#[from] web_apps::list_hybrid_connections::Error),
    #[error(transparent)]
    WebApps_ListRelayServiceConnections(#[from] web_apps::list_relay_service_connections::Error),
    #[error(transparent)]
    WebApps_GetRelayServiceConnection(#[from] web_apps::get_relay_service_connection::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateRelayServiceConnection(#[from] web_apps::create_or_update_relay_service_connection::Error),
    #[error(transparent)]
    WebApps_UpdateRelayServiceConnection(#[from] web_apps::update_relay_service_connection::Error),
    #[error(transparent)]
    WebApps_DeleteRelayServiceConnection(#[from] web_apps::delete_relay_service_connection::Error),
    #[error(transparent)]
    WebApps_ListInstanceIdentifiers(#[from] web_apps::list_instance_identifiers::Error),
    #[error(transparent)]
    WebApps_GetInstanceMsDeployStatus(#[from] web_apps::get_instance_ms_deploy_status::Error),
    #[error(transparent)]
    WebApps_CreateInstanceMsDeployOperation(#[from] web_apps::create_instance_ms_deploy_operation::Error),
    #[error(transparent)]
    WebApps_GetInstanceMsDeployLog(#[from] web_apps::get_instance_ms_deploy_log::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcesses(#[from] web_apps::list_instance_processes::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcess(#[from] web_apps::get_instance_process::Error),
    #[error(transparent)]
    WebApps_DeleteInstanceProcess(#[from] web_apps::delete_instance_process::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessDump(#[from] web_apps::get_instance_process_dump::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessModules(#[from] web_apps::list_instance_process_modules::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessModule(#[from] web_apps::get_instance_process_module::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessThreads(#[from] web_apps::list_instance_process_threads::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessThread(#[from] web_apps::get_instance_process_thread::Error),
    #[error(transparent)]
    WebApps_IsCloneable(#[from] web_apps::is_cloneable::Error),
    #[error(transparent)]
    WebApps_ListSyncFunctionTriggers(#[from] web_apps::list_sync_function_triggers::Error),
    #[error(transparent)]
    WebApps_ListMetricDefinitions(#[from] web_apps::list_metric_definitions::Error),
    #[error(transparent)]
    WebApps_ListMetrics(#[from] web_apps::list_metrics::Error),
    #[error(transparent)]
    WebApps_MigrateStorage(#[from] web_apps::migrate_storage::Error),
    #[error(transparent)]
    WebApps_MigrateMySql(#[from] web_apps::migrate_my_sql::Error),
    #[error(transparent)]
    WebApps_GetMigrateMySqlStatus(#[from] web_apps::get_migrate_my_sql_status::Error),
    #[error(transparent)]
    WebApps_ListNetworkFeatures(#[from] web_apps::list_network_features::Error),
    #[error(transparent)]
    WebApps_StartWebSiteNetworkTrace(#[from] web_apps::start_web_site_network_trace::Error),
    #[error(transparent)]
    WebApps_StopWebSiteNetworkTrace(#[from] web_apps::stop_web_site_network_trace::Error),
    #[error(transparent)]
    WebApps_GenerateNewSitePublishingPassword(#[from] web_apps::generate_new_site_publishing_password::Error),
    #[error(transparent)]
    WebApps_ListPerfMonCounters(#[from] web_apps::list_perf_mon_counters::Error),
    #[error(transparent)]
    WebApps_GetSitePhpErrorLogFlag(#[from] web_apps::get_site_php_error_log_flag::Error),
    #[error(transparent)]
    WebApps_ListPremierAddOns(#[from] web_apps::list_premier_add_ons::Error),
    #[error(transparent)]
    WebApps_GetPremierAddOn(#[from] web_apps::get_premier_add_on::Error),
    #[error(transparent)]
    WebApps_AddPremierAddOn(#[from] web_apps::add_premier_add_on::Error),
    #[error(transparent)]
    WebApps_DeletePremierAddOn(#[from] web_apps::delete_premier_add_on::Error),
    #[error(transparent)]
    WebApps_ListProcesses(#[from] web_apps::list_processes::Error),
    #[error(transparent)]
    WebApps_GetProcess(#[from] web_apps::get_process::Error),
    #[error(transparent)]
    WebApps_DeleteProcess(#[from] web_apps::delete_process::Error),
    #[error(transparent)]
    WebApps_GetProcessDump(#[from] web_apps::get_process_dump::Error),
    #[error(transparent)]
    WebApps_ListProcessModules(#[from] web_apps::list_process_modules::Error),
    #[error(transparent)]
    WebApps_GetProcessModule(#[from] web_apps::get_process_module::Error),
    #[error(transparent)]
    WebApps_ListProcessThreads(#[from] web_apps::list_process_threads::Error),
    #[error(transparent)]
    WebApps_GetProcessThread(#[from] web_apps::get_process_thread::Error),
    #[error(transparent)]
    WebApps_ListPublicCertificates(#[from] web_apps::list_public_certificates::Error),
    #[error(transparent)]
    WebApps_GetPublicCertificate(#[from] web_apps::get_public_certificate::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdatePublicCertificate(#[from] web_apps::create_or_update_public_certificate::Error),
    #[error(transparent)]
    WebApps_DeletePublicCertificate(#[from] web_apps::delete_public_certificate::Error),
    #[error(transparent)]
    WebApps_ListPublishingProfileXmlWithSecrets(#[from] web_apps::list_publishing_profile_xml_with_secrets::Error),
    #[error(transparent)]
    WebApps_Recover(#[from] web_apps::recover::Error),
    #[error(transparent)]
    WebApps_ResetProductionSlotConfig(#[from] web_apps::reset_production_slot_config::Error),
    #[error(transparent)]
    WebApps_Restart(#[from] web_apps::restart::Error),
    #[error(transparent)]
    WebApps_ListSiteExtensions(#[from] web_apps::list_site_extensions::Error),
    #[error(transparent)]
    WebApps_GetSiteExtension(#[from] web_apps::get_site_extension::Error),
    #[error(transparent)]
    WebApps_InstallSiteExtension(#[from] web_apps::install_site_extension::Error),
    #[error(transparent)]
    WebApps_DeleteSiteExtension(#[from] web_apps::delete_site_extension::Error),
    #[error(transparent)]
    WebApps_ListSlots(#[from] web_apps::list_slots::Error),
    #[error(transparent)]
    WebApps_GetSlot(#[from] web_apps::get_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateSlot(#[from] web_apps::create_or_update_slot::Error),
    #[error(transparent)]
    WebApps_UpdateSlot(#[from] web_apps::update_slot::Error),
    #[error(transparent)]
    WebApps_DeleteSlot(#[from] web_apps::delete_slot::Error),
    #[error(transparent)]
    WebApps_AnalyzeCustomHostnameSlot(#[from] web_apps::analyze_custom_hostname_slot::Error),
    #[error(transparent)]
    WebApps_ApplySlotConfigurationSlot(#[from] web_apps::apply_slot_configuration_slot::Error),
    #[error(transparent)]
    WebApps_BackupSlot(#[from] web_apps::backup_slot::Error),
    #[error(transparent)]
    WebApps_ListBackupsSlot(#[from] web_apps::list_backups_slot::Error),
    #[error(transparent)]
    WebApps_DiscoverRestoreSlot(#[from] web_apps::discover_restore_slot::Error),
    #[error(transparent)]
    WebApps_GetBackupStatusSlot(#[from] web_apps::get_backup_status_slot::Error),
    #[error(transparent)]
    WebApps_DeleteBackupSlot(#[from] web_apps::delete_backup_slot::Error),
    #[error(transparent)]
    WebApps_ListBackupStatusSecretsSlot(#[from] web_apps::list_backup_status_secrets_slot::Error),
    #[error(transparent)]
    WebApps_RestoreSlot(#[from] web_apps::restore_slot::Error),
    #[error(transparent)]
    WebApps_ListConfigurationsSlot(#[from] web_apps::list_configurations_slot::Error),
    #[error(transparent)]
    WebApps_UpdateApplicationSettingsSlot(#[from] web_apps::update_application_settings_slot::Error),
    #[error(transparent)]
    WebApps_ListApplicationSettingsSlot(#[from] web_apps::list_application_settings_slot::Error),
    #[error(transparent)]
    WebApps_UpdateAuthSettingsSlot(#[from] web_apps::update_auth_settings_slot::Error),
    #[error(transparent)]
    WebApps_GetAuthSettingsSlot(#[from] web_apps::get_auth_settings_slot::Error),
    #[error(transparent)]
    WebApps_UpdateBackupConfigurationSlot(#[from] web_apps::update_backup_configuration_slot::Error),
    #[error(transparent)]
    WebApps_DeleteBackupConfigurationSlot(#[from] web_apps::delete_backup_configuration_slot::Error),
    #[error(transparent)]
    WebApps_GetBackupConfigurationSlot(#[from] web_apps::get_backup_configuration_slot::Error),
    #[error(transparent)]
    WebApps_UpdateConnectionStringsSlot(#[from] web_apps::update_connection_strings_slot::Error),
    #[error(transparent)]
    WebApps_ListConnectionStringsSlot(#[from] web_apps::list_connection_strings_slot::Error),
    #[error(transparent)]
    WebApps_GetDiagnosticLogsConfigurationSlot(#[from] web_apps::get_diagnostic_logs_configuration_slot::Error),
    #[error(transparent)]
    WebApps_UpdateDiagnosticLogsConfigSlot(#[from] web_apps::update_diagnostic_logs_config_slot::Error),
    #[error(transparent)]
    WebApps_UpdateMetadataSlot(#[from] web_apps::update_metadata_slot::Error),
    #[error(transparent)]
    WebApps_ListMetadataSlot(#[from] web_apps::list_metadata_slot::Error),
    #[error(transparent)]
    WebApps_ListPublishingCredentialsSlot(#[from] web_apps::list_publishing_credentials_slot::Error),
    #[error(transparent)]
    WebApps_UpdateSitePushSettingsSlot(#[from] web_apps::update_site_push_settings_slot::Error),
    #[error(transparent)]
    WebApps_ListSitePushSettingsSlot(#[from] web_apps::list_site_push_settings_slot::Error),
    #[error(transparent)]
    WebApps_GetConfigurationSlot(#[from] web_apps::get_configuration_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateConfigurationSlot(#[from] web_apps::create_or_update_configuration_slot::Error),
    #[error(transparent)]
    WebApps_UpdateConfigurationSlot(#[from] web_apps::update_configuration_slot::Error),
    #[error(transparent)]
    WebApps_ListConfigurationSnapshotInfoSlot(#[from] web_apps::list_configuration_snapshot_info_slot::Error),
    #[error(transparent)]
    WebApps_GetConfigurationSnapshotSlot(#[from] web_apps::get_configuration_snapshot_slot::Error),
    #[error(transparent)]
    WebApps_RecoverSiteConfigurationSnapshotSlot(#[from] web_apps::recover_site_configuration_snapshot_slot::Error),
    #[error(transparent)]
    WebApps_GetWebSiteContainerLogsSlot(#[from] web_apps::get_web_site_container_logs_slot::Error),
    #[error(transparent)]
    WebApps_GetWebSiteContainerLogsZipSlot(#[from] web_apps::get_web_site_container_logs_zip_slot::Error),
    #[error(transparent)]
    WebApps_ListContinuousWebJobsSlot(#[from] web_apps::list_continuous_web_jobs_slot::Error),
    #[error(transparent)]
    WebApps_GetContinuousWebJobSlot(#[from] web_apps::get_continuous_web_job_slot::Error),
    #[error(transparent)]
    WebApps_DeleteContinuousWebJobSlot(#[from] web_apps::delete_continuous_web_job_slot::Error),
    #[error(transparent)]
    WebApps_StartContinuousWebJobSlot(#[from] web_apps::start_continuous_web_job_slot::Error),
    #[error(transparent)]
    WebApps_StopContinuousWebJobSlot(#[from] web_apps::stop_continuous_web_job_slot::Error),
    #[error(transparent)]
    WebApps_ListDeploymentsSlot(#[from] web_apps::list_deployments_slot::Error),
    #[error(transparent)]
    WebApps_GetDeploymentSlot(#[from] web_apps::get_deployment_slot::Error),
    #[error(transparent)]
    WebApps_CreateDeploymentSlot(#[from] web_apps::create_deployment_slot::Error),
    #[error(transparent)]
    WebApps_DeleteDeploymentSlot(#[from] web_apps::delete_deployment_slot::Error),
    #[error(transparent)]
    WebApps_ListDeploymentLogSlot(#[from] web_apps::list_deployment_log_slot::Error),
    #[error(transparent)]
    WebApps_ListDomainOwnershipIdentifiersSlot(#[from] web_apps::list_domain_ownership_identifiers_slot::Error),
    #[error(transparent)]
    WebApps_GetDomainOwnershipIdentifierSlot(#[from] web_apps::get_domain_ownership_identifier_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateDomainOwnershipIdentifierSlot(#[from] web_apps::create_or_update_domain_ownership_identifier_slot::Error),
    #[error(transparent)]
    WebApps_UpdateDomainOwnershipIdentifierSlot(#[from] web_apps::update_domain_ownership_identifier_slot::Error),
    #[error(transparent)]
    WebApps_DeleteDomainOwnershipIdentifierSlot(#[from] web_apps::delete_domain_ownership_identifier_slot::Error),
    #[error(transparent)]
    WebApps_GetMsDeployStatusSlot(#[from] web_apps::get_ms_deploy_status_slot::Error),
    #[error(transparent)]
    WebApps_CreateMsDeployOperationSlot(#[from] web_apps::create_ms_deploy_operation_slot::Error),
    #[error(transparent)]
    WebApps_GetMsDeployLogSlot(#[from] web_apps::get_ms_deploy_log_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceFunctionsSlot(#[from] web_apps::list_instance_functions_slot::Error),
    #[error(transparent)]
    WebApps_GetFunctionsAdminTokenSlot(#[from] web_apps::get_functions_admin_token_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceFunctionSlot(#[from] web_apps::get_instance_function_slot::Error),
    #[error(transparent)]
    WebApps_CreateInstanceFunctionSlot(#[from] web_apps::create_instance_function_slot::Error),
    #[error(transparent)]
    WebApps_DeleteInstanceFunctionSlot(#[from] web_apps::delete_instance_function_slot::Error),
    #[error(transparent)]
    WebApps_ListFunctionSecretsSlot(#[from] web_apps::list_function_secrets_slot::Error),
    #[error(transparent)]
    WebApps_ListHostNameBindingsSlot(#[from] web_apps::list_host_name_bindings_slot::Error),
    #[error(transparent)]
    WebApps_GetHostNameBindingSlot(#[from] web_apps::get_host_name_binding_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateHostNameBindingSlot(#[from] web_apps::create_or_update_host_name_binding_slot::Error),
    #[error(transparent)]
    WebApps_DeleteHostNameBindingSlot(#[from] web_apps::delete_host_name_binding_slot::Error),
    #[error(transparent)]
    WebApps_GetHybridConnectionSlot(#[from] web_apps::get_hybrid_connection_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateHybridConnectionSlot(#[from] web_apps::create_or_update_hybrid_connection_slot::Error),
    #[error(transparent)]
    WebApps_UpdateHybridConnectionSlot(#[from] web_apps::update_hybrid_connection_slot::Error),
    #[error(transparent)]
    WebApps_DeleteHybridConnectionSlot(#[from] web_apps::delete_hybrid_connection_slot::Error),
    #[error(transparent)]
    WebApps_ListHybridConnectionKeysSlot(#[from] web_apps::list_hybrid_connection_keys_slot::Error),
    #[error(transparent)]
    WebApps_ListHybridConnectionsSlot(#[from] web_apps::list_hybrid_connections_slot::Error),
    #[error(transparent)]
    WebApps_ListRelayServiceConnectionsSlot(#[from] web_apps::list_relay_service_connections_slot::Error),
    #[error(transparent)]
    WebApps_GetRelayServiceConnectionSlot(#[from] web_apps::get_relay_service_connection_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateRelayServiceConnectionSlot(#[from] web_apps::create_or_update_relay_service_connection_slot::Error),
    #[error(transparent)]
    WebApps_UpdateRelayServiceConnectionSlot(#[from] web_apps::update_relay_service_connection_slot::Error),
    #[error(transparent)]
    WebApps_DeleteRelayServiceConnectionSlot(#[from] web_apps::delete_relay_service_connection_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceIdentifiersSlot(#[from] web_apps::list_instance_identifiers_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceMsDeployStatusSlot(#[from] web_apps::get_instance_ms_deploy_status_slot::Error),
    #[error(transparent)]
    WebApps_CreateInstanceMsDeployOperationSlot(#[from] web_apps::create_instance_ms_deploy_operation_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceMsDeployLogSlot(#[from] web_apps::get_instance_ms_deploy_log_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessesSlot(#[from] web_apps::list_instance_processes_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessSlot(#[from] web_apps::get_instance_process_slot::Error),
    #[error(transparent)]
    WebApps_DeleteInstanceProcessSlot(#[from] web_apps::delete_instance_process_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessDumpSlot(#[from] web_apps::get_instance_process_dump_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessModulesSlot(#[from] web_apps::list_instance_process_modules_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessModuleSlot(#[from] web_apps::get_instance_process_module_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessThreadsSlot(#[from] web_apps::list_instance_process_threads_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessThreadSlot(#[from] web_apps::get_instance_process_thread_slot::Error),
    #[error(transparent)]
    WebApps_IsCloneableSlot(#[from] web_apps::is_cloneable_slot::Error),
    #[error(transparent)]
    WebApps_ListSyncFunctionTriggersSlot(#[from] web_apps::list_sync_function_triggers_slot::Error),
    #[error(transparent)]
    WebApps_ListMetricDefinitionsSlot(#[from] web_apps::list_metric_definitions_slot::Error),
    #[error(transparent)]
    WebApps_ListMetricsSlot(#[from] web_apps::list_metrics_slot::Error),
    #[error(transparent)]
    WebApps_GetMigrateMySqlStatusSlot(#[from] web_apps::get_migrate_my_sql_status_slot::Error),
    #[error(transparent)]
    WebApps_ListNetworkFeaturesSlot(#[from] web_apps::list_network_features_slot::Error),
    #[error(transparent)]
    WebApps_StartWebSiteNetworkTraceSlot(#[from] web_apps::start_web_site_network_trace_slot::Error),
    #[error(transparent)]
    WebApps_StopWebSiteNetworkTraceSlot(#[from] web_apps::stop_web_site_network_trace_slot::Error),
    #[error(transparent)]
    WebApps_GenerateNewSitePublishingPasswordSlot(#[from] web_apps::generate_new_site_publishing_password_slot::Error),
    #[error(transparent)]
    WebApps_ListPerfMonCountersSlot(#[from] web_apps::list_perf_mon_counters_slot::Error),
    #[error(transparent)]
    WebApps_GetSitePhpErrorLogFlagSlot(#[from] web_apps::get_site_php_error_log_flag_slot::Error),
    #[error(transparent)]
    WebApps_ListPremierAddOnsSlot(#[from] web_apps::list_premier_add_ons_slot::Error),
    #[error(transparent)]
    WebApps_GetPremierAddOnSlot(#[from] web_apps::get_premier_add_on_slot::Error),
    #[error(transparent)]
    WebApps_AddPremierAddOnSlot(#[from] web_apps::add_premier_add_on_slot::Error),
    #[error(transparent)]
    WebApps_DeletePremierAddOnSlot(#[from] web_apps::delete_premier_add_on_slot::Error),
    #[error(transparent)]
    WebApps_ListProcessesSlot(#[from] web_apps::list_processes_slot::Error),
    #[error(transparent)]
    WebApps_GetProcessSlot(#[from] web_apps::get_process_slot::Error),
    #[error(transparent)]
    WebApps_DeleteProcessSlot(#[from] web_apps::delete_process_slot::Error),
    #[error(transparent)]
    WebApps_GetProcessDumpSlot(#[from] web_apps::get_process_dump_slot::Error),
    #[error(transparent)]
    WebApps_ListProcessModulesSlot(#[from] web_apps::list_process_modules_slot::Error),
    #[error(transparent)]
    WebApps_GetProcessModuleSlot(#[from] web_apps::get_process_module_slot::Error),
    #[error(transparent)]
    WebApps_ListProcessThreadsSlot(#[from] web_apps::list_process_threads_slot::Error),
    #[error(transparent)]
    WebApps_GetProcessThreadSlot(#[from] web_apps::get_process_thread_slot::Error),
    #[error(transparent)]
    WebApps_ListPublicCertificatesSlot(#[from] web_apps::list_public_certificates_slot::Error),
    #[error(transparent)]
    WebApps_GetPublicCertificateSlot(#[from] web_apps::get_public_certificate_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdatePublicCertificateSlot(#[from] web_apps::create_or_update_public_certificate_slot::Error),
    #[error(transparent)]
    WebApps_DeletePublicCertificateSlot(#[from] web_apps::delete_public_certificate_slot::Error),
    #[error(transparent)]
    WebApps_ListPublishingProfileXmlWithSecretsSlot(#[from] web_apps::list_publishing_profile_xml_with_secrets_slot::Error),
    #[error(transparent)]
    WebApps_RecoverSlot(#[from] web_apps::recover_slot::Error),
    #[error(transparent)]
    WebApps_ResetSlotConfigurationSlot(#[from] web_apps::reset_slot_configuration_slot::Error),
    #[error(transparent)]
    WebApps_RestartSlot(#[from] web_apps::restart_slot::Error),
    #[error(transparent)]
    WebApps_ListSiteExtensionsSlot(#[from] web_apps::list_site_extensions_slot::Error),
    #[error(transparent)]
    WebApps_GetSiteExtensionSlot(#[from] web_apps::get_site_extension_slot::Error),
    #[error(transparent)]
    WebApps_InstallSiteExtensionSlot(#[from] web_apps::install_site_extension_slot::Error),
    #[error(transparent)]
    WebApps_DeleteSiteExtensionSlot(#[from] web_apps::delete_site_extension_slot::Error),
    #[error(transparent)]
    WebApps_ListSlotDifferencesSlot(#[from] web_apps::list_slot_differences_slot::Error),
    #[error(transparent)]
    WebApps_SwapSlotSlot(#[from] web_apps::swap_slot_slot::Error),
    #[error(transparent)]
    WebApps_ListSnapshotsSlot(#[from] web_apps::list_snapshots_slot::Error),
    #[error(transparent)]
    WebApps_GetSourceControlSlot(#[from] web_apps::get_source_control_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateSourceControlSlot(#[from] web_apps::create_or_update_source_control_slot::Error),
    #[error(transparent)]
    WebApps_UpdateSourceControlSlot(#[from] web_apps::update_source_control_slot::Error),
    #[error(transparent)]
    WebApps_DeleteSourceControlSlot(#[from] web_apps::delete_source_control_slot::Error),
    #[error(transparent)]
    WebApps_StartSlot(#[from] web_apps::start_slot::Error),
    #[error(transparent)]
    WebApps_StopSlot(#[from] web_apps::stop_slot::Error),
    #[error(transparent)]
    WebApps_SyncRepositorySlot(#[from] web_apps::sync_repository_slot::Error),
    #[error(transparent)]
    WebApps_SyncFunctionTriggersSlot(#[from] web_apps::sync_function_triggers_slot::Error),
    #[error(transparent)]
    WebApps_ListTriggeredWebJobsSlot(#[from] web_apps::list_triggered_web_jobs_slot::Error),
    #[error(transparent)]
    WebApps_GetTriggeredWebJobSlot(#[from] web_apps::get_triggered_web_job_slot::Error),
    #[error(transparent)]
    WebApps_DeleteTriggeredWebJobSlot(#[from] web_apps::delete_triggered_web_job_slot::Error),
    #[error(transparent)]
    WebApps_ListTriggeredWebJobHistorySlot(#[from] web_apps::list_triggered_web_job_history_slot::Error),
    #[error(transparent)]
    WebApps_GetTriggeredWebJobHistorySlot(#[from] web_apps::get_triggered_web_job_history_slot::Error),
    #[error(transparent)]
    WebApps_RunTriggeredWebJobSlot(#[from] web_apps::run_triggered_web_job_slot::Error),
    #[error(transparent)]
    WebApps_ListUsagesSlot(#[from] web_apps::list_usages_slot::Error),
    #[error(transparent)]
    WebApps_ListVnetConnectionsSlot(#[from] web_apps::list_vnet_connections_slot::Error),
    #[error(transparent)]
    WebApps_GetVnetConnectionSlot(#[from] web_apps::get_vnet_connection_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateVnetConnectionSlot(#[from] web_apps::create_or_update_vnet_connection_slot::Error),
    #[error(transparent)]
    WebApps_UpdateVnetConnectionSlot(#[from] web_apps::update_vnet_connection_slot::Error),
    #[error(transparent)]
    WebApps_DeleteVnetConnectionSlot(#[from] web_apps::delete_vnet_connection_slot::Error),
    #[error(transparent)]
    WebApps_GetVnetConnectionGatewaySlot(#[from] web_apps::get_vnet_connection_gateway_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateVnetConnectionGatewaySlot(#[from] web_apps::create_or_update_vnet_connection_gateway_slot::Error),
    #[error(transparent)]
    WebApps_UpdateVnetConnectionGatewaySlot(#[from] web_apps::update_vnet_connection_gateway_slot::Error),
    #[error(transparent)]
    WebApps_ListWebJobsSlot(#[from] web_apps::list_web_jobs_slot::Error),
    #[error(transparent)]
    WebApps_GetWebJobSlot(#[from] web_apps::get_web_job_slot::Error),
    #[error(transparent)]
    WebApps_ListSlotDifferencesFromProduction(#[from] web_apps::list_slot_differences_from_production::Error),
    #[error(transparent)]
    WebApps_SwapSlotWithProduction(#[from] web_apps::swap_slot_with_production::Error),
    #[error(transparent)]
    WebApps_ListSnapshots(#[from] web_apps::list_snapshots::Error),
    #[error(transparent)]
    WebApps_GetSourceControl(#[from] web_apps::get_source_control::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateSourceControl(#[from] web_apps::create_or_update_source_control::Error),
    #[error(transparent)]
    WebApps_UpdateSourceControl(#[from] web_apps::update_source_control::Error),
    #[error(transparent)]
    WebApps_DeleteSourceControl(#[from] web_apps::delete_source_control::Error),
    #[error(transparent)]
    WebApps_Start(#[from] web_apps::start::Error),
    #[error(transparent)]
    WebApps_Stop(#[from] web_apps::stop::Error),
    #[error(transparent)]
    WebApps_SyncRepository(#[from] web_apps::sync_repository::Error),
    #[error(transparent)]
    WebApps_SyncFunctionTriggers(#[from] web_apps::sync_function_triggers::Error),
    #[error(transparent)]
    WebApps_ListTriggeredWebJobs(#[from] web_apps::list_triggered_web_jobs::Error),
    #[error(transparent)]
    WebApps_GetTriggeredWebJob(#[from] web_apps::get_triggered_web_job::Error),
    #[error(transparent)]
    WebApps_DeleteTriggeredWebJob(#[from] web_apps::delete_triggered_web_job::Error),
    #[error(transparent)]
    WebApps_ListTriggeredWebJobHistory(#[from] web_apps::list_triggered_web_job_history::Error),
    #[error(transparent)]
    WebApps_GetTriggeredWebJobHistory(#[from] web_apps::get_triggered_web_job_history::Error),
    #[error(transparent)]
    WebApps_RunTriggeredWebJob(#[from] web_apps::run_triggered_web_job::Error),
    #[error(transparent)]
    WebApps_ListUsages(#[from] web_apps::list_usages::Error),
    #[error(transparent)]
    WebApps_ListVnetConnections(#[from] web_apps::list_vnet_connections::Error),
    #[error(transparent)]
    WebApps_GetVnetConnection(#[from] web_apps::get_vnet_connection::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateVnetConnection(#[from] web_apps::create_or_update_vnet_connection::Error),
    #[error(transparent)]
    WebApps_UpdateVnetConnection(#[from] web_apps::update_vnet_connection::Error),
    #[error(transparent)]
    WebApps_DeleteVnetConnection(#[from] web_apps::delete_vnet_connection::Error),
    #[error(transparent)]
    WebApps_GetVnetConnectionGateway(#[from] web_apps::get_vnet_connection_gateway::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateVnetConnectionGateway(#[from] web_apps::create_or_update_vnet_connection_gateway::Error),
    #[error(transparent)]
    WebApps_UpdateVnetConnectionGateway(#[from] web_apps::update_vnet_connection_gateway::Error),
    #[error(transparent)]
    WebApps_ListWebJobs(#[from] web_apps::list_web_jobs::Error),
    #[error(transparent)]
    WebApps_GetWebJob(#[from] web_apps::get_web_job::Error),
}
pub mod web_apps {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Get all apps for a subscription."]
        pub fn list(&self, subscription_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all web, mobile, and API apps in the specified resource group."]
        pub fn list_by_resource_group(
            &self,
            resource_group_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_by_resource_group::Builder {
            list_by_resource_group::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                subscription_id: subscription_id.into(),
                include_slots: None,
            }
        }
        #[doc = "Gets the details of a web, mobile, or API app."]
        pub fn get(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new web, mobile, or API app in an existing resource group, or updates an existing app."]
        pub fn create_or_update(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_envelope: impl Into<models::Site>,
            subscription_id: impl Into<String>,
        ) -> create_or_update::Builder {
            create_or_update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_envelope: site_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new web, mobile, or API app in an existing resource group, or updates an existing app."]
        pub fn update(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_envelope: impl Into<models::SitePatchResource>,
            subscription_id: impl Into<String>,
        ) -> update::Builder {
            update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_envelope: site_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a web, mobile, or API app, or one of the deployment slots."]
        pub fn delete(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                delete_metrics: None,
                delete_empty_server_farm: None,
            }
        }
        #[doc = "Analyze a custom hostname."]
        pub fn analyze_custom_hostname(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> analyze_custom_hostname::Builder {
            analyze_custom_hostname::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                host_name: None,
            }
        }
        #[doc = "Applies the configuration settings from the target slot onto the current slot."]
        pub fn apply_slot_config_to_production(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            subscription_id: impl Into<String>,
        ) -> apply_slot_config_to_production::Builder {
            apply_slot_config_to_production::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a backup of an app."]
        pub fn backup(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            subscription_id: impl Into<String>,
        ) -> backup::Builder {
            backup::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets existing backups of an app."]
        pub fn list_backups(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_backups::Builder {
            list_backups::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Discovers an existing app backup that can be restored from a blob in Azure storage."]
        pub fn discover_restore(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            subscription_id: impl Into<String>,
        ) -> discover_restore::Builder {
            discover_restore::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a backup of an app by its ID."]
        pub fn get_backup_status(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_backup_status::Builder {
            get_backup_status::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a backup of an app by its ID."]
        pub fn delete_backup(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_backup::Builder {
            delete_backup::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body."]
        pub fn list_backup_status_secrets(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            subscription_id: impl Into<String>,
        ) -> list_backup_status_secrets::Builder {
            list_backup_status_secrets::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restores a specific backup to another app (or deployment slot, if specified)."]
        pub fn restore(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            subscription_id: impl Into<String>,
        ) -> restore::Builder {
            restore::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the configurations of an app"]
        pub fn list_configurations(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_configurations::Builder {
            list_configurations::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the application settings of an app."]
        pub fn update_application_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            app_settings: impl Into<models::StringDictionary>,
            subscription_id: impl Into<String>,
        ) -> update_application_settings::Builder {
            update_application_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                app_settings: app_settings.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the application settings of an app."]
        pub fn list_application_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_application_settings::Builder {
            list_application_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Authentication / Authorization settings associated with web app."]
        pub fn update_auth_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_auth_settings: impl Into<models::SiteAuthSettings>,
            subscription_id: impl Into<String>,
        ) -> update_auth_settings::Builder {
            update_auth_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_auth_settings: site_auth_settings.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Authentication/Authorization settings of an app."]
        pub fn get_auth_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_auth_settings::Builder {
            get_auth_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the backup configuration of an app."]
        pub fn update_backup_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            subscription_id: impl Into<String>,
        ) -> update_backup_configuration::Builder {
            update_backup_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes the backup configuration of an app."]
        pub fn delete_backup_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_backup_configuration::Builder {
            delete_backup_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the backup configuration of an app."]
        pub fn get_backup_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_backup_configuration::Builder {
            get_backup_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the connection strings of an app."]
        pub fn update_connection_strings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            connection_strings: impl Into<models::ConnectionStringDictionary>,
            subscription_id: impl Into<String>,
        ) -> update_connection_strings::Builder {
            update_connection_strings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                connection_strings: connection_strings.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the connection strings of an app."]
        pub fn list_connection_strings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_connection_strings::Builder {
            list_connection_strings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the logging configuration of an app."]
        pub fn get_diagnostic_logs_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_diagnostic_logs_configuration::Builder {
            get_diagnostic_logs_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the logging configuration of an app."]
        pub fn update_diagnostic_logs_config(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_logs_config: impl Into<models::SiteLogsConfig>,
            subscription_id: impl Into<String>,
        ) -> update_diagnostic_logs_config::Builder {
            update_diagnostic_logs_config::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_logs_config: site_logs_config.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the metadata of an app."]
        pub fn update_metadata(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            metadata: impl Into<models::StringDictionary>,
            subscription_id: impl Into<String>,
        ) -> update_metadata::Builder {
            update_metadata::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                metadata: metadata.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the metadata of an app."]
        pub fn list_metadata(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metadata::Builder {
            list_metadata::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Git/FTP publishing credentials of an app."]
        pub fn list_publishing_credentials(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_publishing_credentials::Builder {
            list_publishing_credentials::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Push settings associated with web app."]
        pub fn update_site_push_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            push_settings: impl Into<models::PushSettings>,
            subscription_id: impl Into<String>,
        ) -> update_site_push_settings::Builder {
            update_site_push_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                push_settings: push_settings.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Push settings associated with web app."]
        pub fn list_site_push_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_push_settings::Builder {
            list_site_push_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the names of app settings and connection strings that stick to the slot (not swapped)."]
        pub fn list_slot_configuration_names(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_slot_configuration_names::Builder {
            list_slot_configuration_names::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the names of application settings and connection string that remain with the slot during swap operation."]
        pub fn update_slot_configuration_names(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_config_names: impl Into<models::SlotConfigNamesResource>,
            subscription_id: impl Into<String>,
        ) -> update_slot_configuration_names::Builder {
            update_slot_configuration_names::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_config_names: slot_config_names.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc."]
        pub fn get_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_configuration::Builder {
            get_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the configuration of an app."]
        pub fn create_or_update_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_config: impl Into<models::SiteConfigResource>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_configuration::Builder {
            create_or_update_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_config: site_config.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the configuration of an app."]
        pub fn update_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_config: impl Into<models::SiteConfigResource>,
            subscription_id: impl Into<String>,
        ) -> update_configuration::Builder {
            update_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_config: site_config.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot."]
        pub fn list_configuration_snapshot_info(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_configuration_snapshot_info::Builder {
            list_configuration_snapshot_info::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a snapshot of the configuration of an app at a previous point in time."]
        pub fn get_configuration_snapshot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            snapshot_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_configuration_snapshot::Builder {
            get_configuration_snapshot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                snapshot_id: snapshot_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Reverts the configuration of an app to a previous snapshot."]
        pub fn recover_site_configuration_snapshot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            snapshot_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> recover_site_configuration_snapshot::Builder {
            recover_site_configuration_snapshot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                snapshot_id: snapshot_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the last lines of docker logs for the given site"]
        pub fn get_web_site_container_logs(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_site_container_logs::Builder {
            get_web_site_container_logs::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the ZIP archived docker log files for the given site"]
        pub fn get_web_site_container_logs_zip(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_site_container_logs_zip::Builder {
            get_web_site_container_logs_zip::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List continuous web jobs for an app, or a deployment slot."]
        pub fn list_continuous_web_jobs(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_continuous_web_jobs::Builder {
            list_continuous_web_jobs::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a continuous web job by its ID for an app, or a deployment slot."]
        pub fn get_continuous_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_continuous_web_job::Builder {
            get_continuous_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a continuous web job by its ID for an app, or a deployment slot."]
        pub fn delete_continuous_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_continuous_web_job::Builder {
            delete_continuous_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start a continuous web job for an app, or a deployment slot."]
        pub fn start_continuous_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_continuous_web_job::Builder {
            start_continuous_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Stop a continuous web job for an app, or a deployment slot."]
        pub fn stop_continuous_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_continuous_web_job::Builder {
            stop_continuous_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List deployments for an app, or a deployment slot."]
        pub fn list_deployments(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_deployments::Builder {
            list_deployments::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a deployment by its ID for an app, or a deployment slot."]
        pub fn get_deployment(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_deployment::Builder {
            get_deployment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create a deployment for an app, or a deployment slot."]
        pub fn create_deployment(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            deployment: impl Into<models::Deployment>,
            subscription_id: impl Into<String>,
        ) -> create_deployment::Builder {
            create_deployment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                deployment: deployment.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a deployment by its ID for an app, or a deployment slot."]
        pub fn delete_deployment(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_deployment::Builder {
            delete_deployment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List deployment log for specific deployment for an app, or a deployment slot."]
        pub fn list_deployment_log(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_deployment_log::Builder {
            list_deployment_log::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Lists ownership identifiers for domain associated with web app."]
        pub fn list_domain_ownership_identifiers(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_domain_ownership_identifiers::Builder {
            list_domain_ownership_identifiers::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get domain ownership identifier for web app."]
        pub fn get_domain_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_domain_ownership_identifier::Builder {
            get_domain_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a domain ownership identifier for web app, or updates an existing ownership identifier."]
        pub fn create_or_update_domain_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::Identifier>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_domain_ownership_identifier::Builder {
            create_or_update_domain_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a domain ownership identifier for web app, or updates an existing ownership identifier."]
        pub fn update_domain_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::Identifier>,
            subscription_id: impl Into<String>,
        ) -> update_domain_ownership_identifier::Builder {
            update_domain_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a domain ownership identifier for a web app."]
        pub fn delete_domain_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_domain_ownership_identifier::Builder {
            delete_domain_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the status of the last MSDeploy operation."]
        pub fn get_ms_deploy_status(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_ms_deploy_status::Builder {
            get_ms_deploy_status::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Invoke the MSDeploy web app extension."]
        pub fn create_ms_deploy_operation(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            ms_deploy: impl Into<models::MsDeploy>,
            subscription_id: impl Into<String>,
        ) -> create_ms_deploy_operation::Builder {
            create_ms_deploy_operation::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                ms_deploy: ms_deploy.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the MSDeploy Log for the last MSDeploy operation."]
        pub fn get_ms_deploy_log(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_ms_deploy_log::Builder {
            get_ms_deploy_log::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the functions for a web site, or a deployment slot."]
        pub fn list_functions(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_functions::Builder {
            list_functions::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Fetch a short lived token that can be exchanged for a master key."]
        pub fn get_functions_admin_token(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_functions_admin_token::Builder {
            get_functions_admin_token::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get function information by its ID for web site, or a deployment slot."]
        pub fn get_function(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_function::Builder {
            get_function::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create function for web site, or a deployment slot."]
        pub fn create_function(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            function_envelope: impl Into<models::FunctionEnvelope>,
            subscription_id: impl Into<String>,
        ) -> create_function::Builder {
            create_function::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                function_envelope: function_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a function for web site, or a deployment slot."]
        pub fn delete_function(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_function::Builder {
            delete_function::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get function secrets for a function in a web site, or a deployment slot."]
        pub fn list_function_secrets(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_function_secrets::Builder {
            list_function_secrets::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get hostname bindings for an app or a deployment slot."]
        pub fn list_host_name_bindings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_host_name_bindings::Builder {
            list_host_name_bindings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the named hostname binding for an app (or deployment slot, if specified)."]
        pub fn get_host_name_binding(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            host_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_host_name_binding::Builder {
            get_host_name_binding::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                host_name: host_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a hostname binding for an app."]
        pub fn create_or_update_host_name_binding(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            host_name: impl Into<String>,
            host_name_binding: impl Into<models::HostNameBinding>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_host_name_binding::Builder {
            create_or_update_host_name_binding::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                host_name: host_name.into(),
                host_name_binding: host_name_binding.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a hostname binding for an app."]
        pub fn delete_host_name_binding(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            host_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_host_name_binding::Builder {
            delete_host_name_binding::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                host_name: host_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieves a specific Service Bus Hybrid Connection used by this Web App."]
        pub fn get_hybrid_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_hybrid_connection::Builder {
            get_hybrid_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new Hybrid Connection using a Service Bus relay."]
        pub fn create_or_update_hybrid_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            connection_envelope: impl Into<models::HybridConnection>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_hybrid_connection::Builder {
            create_or_update_hybrid_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new Hybrid Connection using a Service Bus relay."]
        pub fn update_hybrid_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            connection_envelope: impl Into<models::HybridConnection>,
            subscription_id: impl Into<String>,
        ) -> update_hybrid_connection::Builder {
            update_hybrid_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Removes a Hybrid Connection from this site."]
        pub fn delete_hybrid_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_hybrid_connection::Builder {
            delete_hybrid_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the send key name and value for a Hybrid Connection."]
        pub fn list_hybrid_connection_keys(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_hybrid_connection_keys::Builder {
            list_hybrid_connection_keys::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieves all Service Bus Hybrid Connections used by this Web App."]
        pub fn list_hybrid_connections(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_hybrid_connections::Builder {
            list_hybrid_connections::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets hybrid connections configured for an app (or deployment slot, if specified)."]
        pub fn list_relay_service_connections(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_relay_service_connections::Builder {
            list_relay_service_connections::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a hybrid connection configuration by its name."]
        pub fn get_relay_service_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_relay_service_connection::Builder {
            get_relay_service_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH)."]
        pub fn create_or_update_relay_service_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            connection_envelope: impl Into<models::RelayServiceConnectionEntity>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_relay_service_connection::Builder {
            create_or_update_relay_service_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH)."]
        pub fn update_relay_service_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            connection_envelope: impl Into<models::RelayServiceConnectionEntity>,
            subscription_id: impl Into<String>,
        ) -> update_relay_service_connection::Builder {
            update_relay_service_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a relay service connection by its name."]
        pub fn delete_relay_service_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_relay_service_connection::Builder {
            delete_relay_service_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all scale-out instances of an app."]
        pub fn list_instance_identifiers(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_identifiers::Builder {
            list_instance_identifiers::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the status of the last MSDeploy operation."]
        pub fn get_instance_ms_deploy_status(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_ms_deploy_status::Builder {
            get_instance_ms_deploy_status::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Invoke the MSDeploy web app extension."]
        pub fn create_instance_ms_deploy_operation(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            instance_id: impl Into<String>,
            ms_deploy: impl Into<models::MsDeploy>,
            subscription_id: impl Into<String>,
        ) -> create_instance_ms_deploy_operation::Builder {
            create_instance_ms_deploy_operation::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                instance_id: instance_id.into(),
                ms_deploy: ms_deploy.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the MSDeploy Log for the last MSDeploy operation."]
        pub fn get_instance_ms_deploy_log(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_ms_deploy_log::Builder {
            get_instance_ms_deploy_log::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site."]
        pub fn list_instance_processes(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_processes::Builder {
            list_instance_processes::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process::Builder {
            get_instance_process::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site."]
        pub fn delete_instance_process(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_instance_process::Builder {
            delete_instance_process::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a memory dump of a process by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_dump(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_dump::Builder {
            get_instance_process_dump::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List module information for a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_instance_process_modules(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_process_modules::Builder {
            list_instance_process_modules::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_module(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            base_address: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_module::Builder {
            get_instance_process_module::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                base_address: base_address.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the threads in a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_instance_process_threads(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_process_threads::Builder {
            list_instance_process_threads::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site."]
        pub fn get_instance_process_thread(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            thread_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_thread::Builder {
            get_instance_process_thread::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                thread_id: thread_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Shows whether an app can be cloned to another resource group or subscription."]
        pub fn is_cloneable(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> is_cloneable::Builder {
            is_cloneable::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "This is to allow calling via powershell and ARM template."]
        pub fn list_sync_function_triggers(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_sync_function_triggers::Builder {
            list_sync_function_triggers::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all metric definitions of an app (or deployment slot, if specified)."]
        pub fn list_metric_definitions(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metric_definitions::Builder {
            list_metric_definitions::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets performance metrics of an app (or deployment slot, if specified)."]
        pub fn list_metrics(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metrics::Builder {
            list_metrics::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                details: None,
                filter: None,
            }
        }
        #[doc = "Restores a web app."]
        pub fn migrate_storage(
            &self,
            subscription_name: impl Into<String>,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            migration_options: impl Into<models::StorageMigrationOptions>,
            subscription_id: impl Into<String>,
        ) -> migrate_storage::Builder {
            migrate_storage::Builder {
                client: self.0.clone(),
                subscription_name: subscription_name.into(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                migration_options: migration_options.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Migrates a local (in-app) MySql database to a remote MySql database."]
        pub fn migrate_my_sql(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            migration_request_envelope: impl Into<models::MigrateMySqlRequest>,
            subscription_id: impl Into<String>,
        ) -> migrate_my_sql::Builder {
            migrate_my_sql::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                migration_request_envelope: migration_request_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled"]
        pub fn get_migrate_my_sql_status(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_migrate_my_sql_status::Builder {
            get_migrate_my_sql_status::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all network features used by the app (or deployment slot, if specified)."]
        pub fn list_network_features(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            view: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_network_features::Builder {
            list_network_features::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                view: view.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start capturing network packets for the site."]
        pub fn start_web_site_network_trace(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_web_site_network_trace::Builder {
            start_web_site_network_trace::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                duration_in_seconds: None,
                max_frame_length: None,
                sas_url: None,
            }
        }
        #[doc = "Stop ongoing capturing network packets for the site."]
        pub fn stop_web_site_network_trace(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_web_site_network_trace::Builder {
            stop_web_site_network_trace::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Generates a new publishing password for an app (or deployment slot, if specified)."]
        pub fn generate_new_site_publishing_password(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> generate_new_site_publishing_password::Builder {
            generate_new_site_publishing_password::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets perfmon counters for web app."]
        pub fn list_perf_mon_counters(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_perf_mon_counters::Builder {
            list_perf_mon_counters::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                filter: None,
            }
        }
        #[doc = "Gets web app's event logs."]
        pub fn get_site_php_error_log_flag(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_php_error_log_flag::Builder {
            get_site_php_error_log_flag::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the premier add-ons of an app."]
        pub fn list_premier_add_ons(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_premier_add_ons::Builder {
            list_premier_add_ons::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named add-on of an app."]
        pub fn get_premier_add_on(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_premier_add_on::Builder {
            get_premier_add_on::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates a named add-on of an app."]
        pub fn add_premier_add_on(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            premier_add_on: impl Into<models::PremierAddOn>,
            subscription_id: impl Into<String>,
        ) -> add_premier_add_on::Builder {
            add_premier_add_on::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                premier_add_on: premier_add_on.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a premier add-on from an app."]
        pub fn delete_premier_add_on(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_premier_add_on::Builder {
            delete_premier_add_on::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site."]
        pub fn list_processes(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_processes::Builder {
            list_processes::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process::Builder {
            get_process::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site."]
        pub fn delete_process(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_process::Builder {
            delete_process::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a memory dump of a process by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_dump(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_dump::Builder {
            get_process_dump::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List module information for a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_process_modules(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_process_modules::Builder {
            list_process_modules::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_module(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            base_address: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_module::Builder {
            get_process_module::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                base_address: base_address.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the threads in a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_process_threads(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_process_threads::Builder {
            list_process_threads::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site."]
        pub fn get_process_thread(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            thread_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_thread::Builder {
            get_process_thread::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                thread_id: thread_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get public certificates for an app or a deployment slot."]
        pub fn list_public_certificates(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_public_certificates::Builder {
            list_public_certificates::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the named public certificate for an app (or deployment slot, if specified)."]
        pub fn get_public_certificate(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            public_certificate_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_public_certificate::Builder {
            get_public_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                public_certificate_name: public_certificate_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a hostname binding for an app."]
        pub fn create_or_update_public_certificate(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            public_certificate_name: impl Into<String>,
            public_certificate: impl Into<models::PublicCertificate>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_public_certificate::Builder {
            create_or_update_public_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                public_certificate_name: public_certificate_name.into(),
                public_certificate: public_certificate.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a hostname binding for an app."]
        pub fn delete_public_certificate(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            public_certificate_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_public_certificate::Builder {
            delete_public_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                public_certificate_name: public_certificate_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the publishing profile for an app (or deployment slot, if specified)."]
        pub fn list_publishing_profile_xml_with_secrets(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            publishing_profile_options: impl Into<models::CsmPublishingProfileOptions>,
            subscription_id: impl Into<String>,
        ) -> list_publishing_profile_xml_with_secrets::Builder {
            list_publishing_profile_xml_with_secrets::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                publishing_profile_options: publishing_profile_options.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Recovers a web app to a previous snapshot."]
        pub fn recover(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            recovery_entity: impl Into<models::SnapshotRecoveryRequest>,
            subscription_id: impl Into<String>,
        ) -> recover::Builder {
            recover::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                recovery_entity: recovery_entity.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Resets the configuration settings of the current slot if they were previously modified by calling the API with POST."]
        pub fn reset_production_slot_config(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> reset_production_slot_config::Builder {
            reset_production_slot_config::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restarts an app (or deployment slot, if specified)."]
        pub fn restart(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> restart::Builder {
            restart::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                soft_restart: None,
                synchronous: None,
            }
        }
        #[doc = "Get list of site extensions for a web site, or a deployment slot."]
        pub fn list_site_extensions(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_extensions::Builder {
            list_site_extensions::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get site extension information by its ID for a web site, or a deployment slot."]
        pub fn get_site_extension(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_extension::Builder {
            get_site_extension::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Install site extension on a web site, or a deployment slot."]
        pub fn install_site_extension(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> install_site_extension::Builder {
            install_site_extension::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Remove a site extension from a web site, or a deployment slot."]
        pub fn delete_site_extension(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_site_extension::Builder {
            delete_site_extension::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets an app's deployment slots."]
        pub fn list_slots(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_slots::Builder {
            list_slots::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the details of a web, mobile, or API app."]
        pub fn get_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_slot::Builder {
            get_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new web, mobile, or API app in an existing resource group, or updates an existing app."]
        pub fn create_or_update_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_envelope: impl Into<models::Site>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_slot::Builder {
            create_or_update_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_envelope: site_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                skip_dns_registration: None,
                skip_custom_domain_verification: None,
                force_dns_registration: None,
                ttl_in_seconds: None,
            }
        }
        #[doc = "Creates a new web, mobile, or API app in an existing resource group, or updates an existing app."]
        pub fn update_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_envelope: impl Into<models::SitePatchResource>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_slot::Builder {
            update_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_envelope: site_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                skip_dns_registration: None,
                skip_custom_domain_verification: None,
                force_dns_registration: None,
                ttl_in_seconds: None,
            }
        }
        #[doc = "Deletes a web, mobile, or API app, or one of the deployment slots."]
        pub fn delete_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_slot::Builder {
            delete_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                delete_metrics: None,
                delete_empty_server_farm: None,
                skip_dns_registration: None,
            }
        }
        #[doc = "Analyze a custom hostname."]
        pub fn analyze_custom_hostname_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> analyze_custom_hostname_slot::Builder {
            analyze_custom_hostname_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                host_name: None,
            }
        }
        #[doc = "Applies the configuration settings from the target slot onto the current slot."]
        pub fn apply_slot_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> apply_slot_configuration_slot::Builder {
            apply_slot_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a backup of an app."]
        pub fn backup_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> backup_slot::Builder {
            backup_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets existing backups of an app."]
        pub fn list_backups_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_backups_slot::Builder {
            list_backups_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Discovers an existing app backup that can be restored from a blob in Azure storage."]
        pub fn discover_restore_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> discover_restore_slot::Builder {
            discover_restore_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a backup of an app by its ID."]
        pub fn get_backup_status_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_backup_status_slot::Builder {
            get_backup_status_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a backup of an app by its ID."]
        pub fn delete_backup_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_backup_slot::Builder {
            delete_backup_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body."]
        pub fn list_backup_status_secrets_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_backup_status_secrets_slot::Builder {
            list_backup_status_secrets_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restores a specific backup to another app (or deployment slot, if specified)."]
        pub fn restore_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> restore_slot::Builder {
            restore_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the configurations of an app"]
        pub fn list_configurations_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_configurations_slot::Builder {
            list_configurations_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the application settings of an app."]
        pub fn update_application_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            app_settings: impl Into<models::StringDictionary>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_application_settings_slot::Builder {
            update_application_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                app_settings: app_settings.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the application settings of an app."]
        pub fn list_application_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_application_settings_slot::Builder {
            list_application_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Authentication / Authorization settings associated with web app."]
        pub fn update_auth_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_auth_settings: impl Into<models::SiteAuthSettings>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_auth_settings_slot::Builder {
            update_auth_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_auth_settings: site_auth_settings.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Authentication/Authorization settings of an app."]
        pub fn get_auth_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_auth_settings_slot::Builder {
            get_auth_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the backup configuration of an app."]
        pub fn update_backup_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_backup_configuration_slot::Builder {
            update_backup_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes the backup configuration of an app."]
        pub fn delete_backup_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_backup_configuration_slot::Builder {
            delete_backup_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the backup configuration of an app."]
        pub fn get_backup_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_backup_configuration_slot::Builder {
            get_backup_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the connection strings of an app."]
        pub fn update_connection_strings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            connection_strings: impl Into<models::ConnectionStringDictionary>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_connection_strings_slot::Builder {
            update_connection_strings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                connection_strings: connection_strings.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the connection strings of an app."]
        pub fn list_connection_strings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_connection_strings_slot::Builder {
            list_connection_strings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the logging configuration of an app."]
        pub fn get_diagnostic_logs_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_diagnostic_logs_configuration_slot::Builder {
            get_diagnostic_logs_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the logging configuration of an app."]
        pub fn update_diagnostic_logs_config_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_logs_config: impl Into<models::SiteLogsConfig>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_diagnostic_logs_config_slot::Builder {
            update_diagnostic_logs_config_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_logs_config: site_logs_config.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the metadata of an app."]
        pub fn update_metadata_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            metadata: impl Into<models::StringDictionary>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_metadata_slot::Builder {
            update_metadata_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                metadata: metadata.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the metadata of an app."]
        pub fn list_metadata_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metadata_slot::Builder {
            list_metadata_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Git/FTP publishing credentials of an app."]
        pub fn list_publishing_credentials_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_publishing_credentials_slot::Builder {
            list_publishing_credentials_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Push settings associated with web app."]
        pub fn update_site_push_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            push_settings: impl Into<models::PushSettings>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_site_push_settings_slot::Builder {
            update_site_push_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                push_settings: push_settings.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Push settings associated with web app."]
        pub fn list_site_push_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_push_settings_slot::Builder {
            list_site_push_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc."]
        pub fn get_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_configuration_slot::Builder {
            get_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the configuration of an app."]
        pub fn create_or_update_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_config: impl Into<models::SiteConfigResource>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_configuration_slot::Builder {
            create_or_update_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_config: site_config.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the configuration of an app."]
        pub fn update_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_config: impl Into<models::SiteConfigResource>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_configuration_slot::Builder {
            update_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_config: site_config.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot."]
        pub fn list_configuration_snapshot_info_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_configuration_snapshot_info_slot::Builder {
            list_configuration_snapshot_info_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a snapshot of the configuration of an app at a previous point in time."]
        pub fn get_configuration_snapshot_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            snapshot_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_configuration_snapshot_slot::Builder {
            get_configuration_snapshot_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                snapshot_id: snapshot_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Reverts the configuration of an app to a previous snapshot."]
        pub fn recover_site_configuration_snapshot_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            snapshot_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> recover_site_configuration_snapshot_slot::Builder {
            recover_site_configuration_snapshot_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                snapshot_id: snapshot_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the last lines of docker logs for the given site"]
        pub fn get_web_site_container_logs_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_site_container_logs_slot::Builder {
            get_web_site_container_logs_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the ZIP archived docker log files for the given site"]
        pub fn get_web_site_container_logs_zip_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_site_container_logs_zip_slot::Builder {
            get_web_site_container_logs_zip_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List continuous web jobs for an app, or a deployment slot."]
        pub fn list_continuous_web_jobs_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_continuous_web_jobs_slot::Builder {
            list_continuous_web_jobs_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a continuous web job by its ID for an app, or a deployment slot."]
        pub fn get_continuous_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_continuous_web_job_slot::Builder {
            get_continuous_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a continuous web job by its ID for an app, or a deployment slot."]
        pub fn delete_continuous_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_continuous_web_job_slot::Builder {
            delete_continuous_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start a continuous web job for an app, or a deployment slot."]
        pub fn start_continuous_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_continuous_web_job_slot::Builder {
            start_continuous_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Stop a continuous web job for an app, or a deployment slot."]
        pub fn stop_continuous_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_continuous_web_job_slot::Builder {
            stop_continuous_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List deployments for an app, or a deployment slot."]
        pub fn list_deployments_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_deployments_slot::Builder {
            list_deployments_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a deployment by its ID for an app, or a deployment slot."]
        pub fn get_deployment_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_deployment_slot::Builder {
            get_deployment_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create a deployment for an app, or a deployment slot."]
        pub fn create_deployment_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            deployment: impl Into<models::Deployment>,
            subscription_id: impl Into<String>,
        ) -> create_deployment_slot::Builder {
            create_deployment_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                slot: slot.into(),
                deployment: deployment.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a deployment by its ID for an app, or a deployment slot."]
        pub fn delete_deployment_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_deployment_slot::Builder {
            delete_deployment_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List deployment log for specific deployment for an app, or a deployment slot."]
        pub fn list_deployment_log_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_deployment_log_slot::Builder {
            list_deployment_log_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Lists ownership identifiers for domain associated with web app."]
        pub fn list_domain_ownership_identifiers_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_domain_ownership_identifiers_slot::Builder {
            list_domain_ownership_identifiers_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get domain ownership identifier for web app."]
        pub fn get_domain_ownership_identifier_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_domain_ownership_identifier_slot::Builder {
            get_domain_ownership_identifier_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a domain ownership identifier for web app, or updates an existing ownership identifier."]
        pub fn create_or_update_domain_ownership_identifier_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::Identifier>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_domain_ownership_identifier_slot::Builder {
            create_or_update_domain_ownership_identifier_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a domain ownership identifier for web app, or updates an existing ownership identifier."]
        pub fn update_domain_ownership_identifier_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::Identifier>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_domain_ownership_identifier_slot::Builder {
            update_domain_ownership_identifier_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a domain ownership identifier for a web app."]
        pub fn delete_domain_ownership_identifier_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_domain_ownership_identifier_slot::Builder {
            delete_domain_ownership_identifier_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the status of the last MSDeploy operation."]
        pub fn get_ms_deploy_status_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_ms_deploy_status_slot::Builder {
            get_ms_deploy_status_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Invoke the MSDeploy web app extension."]
        pub fn create_ms_deploy_operation_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            ms_deploy: impl Into<models::MsDeploy>,
            subscription_id: impl Into<String>,
        ) -> create_ms_deploy_operation_slot::Builder {
            create_ms_deploy_operation_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                ms_deploy: ms_deploy.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the MSDeploy Log for the last MSDeploy operation."]
        pub fn get_ms_deploy_log_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_ms_deploy_log_slot::Builder {
            get_ms_deploy_log_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the functions for a web site, or a deployment slot."]
        pub fn list_instance_functions_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_functions_slot::Builder {
            list_instance_functions_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Fetch a short lived token that can be exchanged for a master key."]
        pub fn get_functions_admin_token_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_functions_admin_token_slot::Builder {
            get_functions_admin_token_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get function information by its ID for web site, or a deployment slot."]
        pub fn get_instance_function_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_function_slot::Builder {
            get_instance_function_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create function for web site, or a deployment slot."]
        pub fn create_instance_function_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            slot: impl Into<String>,
            function_envelope: impl Into<models::FunctionEnvelope>,
            subscription_id: impl Into<String>,
        ) -> create_instance_function_slot::Builder {
            create_instance_function_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                slot: slot.into(),
                function_envelope: function_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a function for web site, or a deployment slot."]
        pub fn delete_instance_function_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_instance_function_slot::Builder {
            delete_instance_function_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get function secrets for a function in a web site, or a deployment slot."]
        pub fn list_function_secrets_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_function_secrets_slot::Builder {
            list_function_secrets_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get hostname bindings for an app or a deployment slot."]
        pub fn list_host_name_bindings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_host_name_bindings_slot::Builder {
            list_host_name_bindings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the named hostname binding for an app (or deployment slot, if specified)."]
        pub fn get_host_name_binding_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            host_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_host_name_binding_slot::Builder {
            get_host_name_binding_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                host_name: host_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a hostname binding for an app."]
        pub fn create_or_update_host_name_binding_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            host_name: impl Into<String>,
            host_name_binding: impl Into<models::HostNameBinding>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_host_name_binding_slot::Builder {
            create_or_update_host_name_binding_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                host_name: host_name.into(),
                host_name_binding: host_name_binding.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a hostname binding for an app."]
        pub fn delete_host_name_binding_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            host_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_host_name_binding_slot::Builder {
            delete_host_name_binding_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                host_name: host_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieves a specific Service Bus Hybrid Connection used by this Web App."]
        pub fn get_hybrid_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_hybrid_connection_slot::Builder {
            get_hybrid_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new Hybrid Connection using a Service Bus relay."]
        pub fn create_or_update_hybrid_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            connection_envelope: impl Into<models::HybridConnection>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_hybrid_connection_slot::Builder {
            create_or_update_hybrid_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new Hybrid Connection using a Service Bus relay."]
        pub fn update_hybrid_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            connection_envelope: impl Into<models::HybridConnection>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_hybrid_connection_slot::Builder {
            update_hybrid_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Removes a Hybrid Connection from this site."]
        pub fn delete_hybrid_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_hybrid_connection_slot::Builder {
            delete_hybrid_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the send key name and value for a Hybrid Connection."]
        pub fn list_hybrid_connection_keys_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_hybrid_connection_keys_slot::Builder {
            list_hybrid_connection_keys_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieves all Service Bus Hybrid Connections used by this Web App."]
        pub fn list_hybrid_connections_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_hybrid_connections_slot::Builder {
            list_hybrid_connections_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets hybrid connections configured for an app (or deployment slot, if specified)."]
        pub fn list_relay_service_connections_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_relay_service_connections_slot::Builder {
            list_relay_service_connections_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a hybrid connection configuration by its name."]
        pub fn get_relay_service_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_relay_service_connection_slot::Builder {
            get_relay_service_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH)."]
        pub fn create_or_update_relay_service_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            connection_envelope: impl Into<models::RelayServiceConnectionEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_relay_service_connection_slot::Builder {
            create_or_update_relay_service_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH)."]
        pub fn update_relay_service_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            connection_envelope: impl Into<models::RelayServiceConnectionEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_relay_service_connection_slot::Builder {
            update_relay_service_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a relay service connection by its name."]
        pub fn delete_relay_service_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_relay_service_connection_slot::Builder {
            delete_relay_service_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all scale-out instances of an app."]
        pub fn list_instance_identifiers_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_identifiers_slot::Builder {
            list_instance_identifiers_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the status of the last MSDeploy operation."]
        pub fn get_instance_ms_deploy_status_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_ms_deploy_status_slot::Builder {
            get_instance_ms_deploy_status_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Invoke the MSDeploy web app extension."]
        pub fn create_instance_ms_deploy_operation_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            ms_deploy: impl Into<models::MsDeploy>,
            subscription_id: impl Into<String>,
        ) -> create_instance_ms_deploy_operation_slot::Builder {
            create_instance_ms_deploy_operation_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                ms_deploy: ms_deploy.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the MSDeploy Log for the last MSDeploy operation."]
        pub fn get_instance_ms_deploy_log_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_ms_deploy_log_slot::Builder {
            get_instance_ms_deploy_log_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site."]
        pub fn list_instance_processes_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_processes_slot::Builder {
            list_instance_processes_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_slot::Builder {
            get_instance_process_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site."]
        pub fn delete_instance_process_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_instance_process_slot::Builder {
            delete_instance_process_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a memory dump of a process by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_dump_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_dump_slot::Builder {
            get_instance_process_dump_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List module information for a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_instance_process_modules_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_process_modules_slot::Builder {
            list_instance_process_modules_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_module_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            base_address: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_module_slot::Builder {
            get_instance_process_module_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                base_address: base_address.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the threads in a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_instance_process_threads_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_process_threads_slot::Builder {
            list_instance_process_threads_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site."]
        pub fn get_instance_process_thread_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            thread_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_thread_slot::Builder {
            get_instance_process_thread_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                thread_id: thread_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Shows whether an app can be cloned to another resource group or subscription."]
        pub fn is_cloneable_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> is_cloneable_slot::Builder {
            is_cloneable_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "This is to allow calling via powershell and ARM template."]
        pub fn list_sync_function_triggers_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_sync_function_triggers_slot::Builder {
            list_sync_function_triggers_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all metric definitions of an app (or deployment slot, if specified)."]
        pub fn list_metric_definitions_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metric_definitions_slot::Builder {
            list_metric_definitions_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets performance metrics of an app (or deployment slot, if specified)."]
        pub fn list_metrics_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metrics_slot::Builder {
            list_metrics_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                details: None,
                filter: None,
            }
        }
        #[doc = "Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled"]
        pub fn get_migrate_my_sql_status_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_migrate_my_sql_status_slot::Builder {
            get_migrate_my_sql_status_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all network features used by the app (or deployment slot, if specified)."]
        pub fn list_network_features_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            view: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_network_features_slot::Builder {
            list_network_features_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                view: view.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start capturing network packets for the site."]
        pub fn start_web_site_network_trace_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_web_site_network_trace_slot::Builder {
            start_web_site_network_trace_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                duration_in_seconds: None,
                max_frame_length: None,
                sas_url: None,
            }
        }
        #[doc = "Stop ongoing capturing network packets for the site."]
        pub fn stop_web_site_network_trace_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_web_site_network_trace_slot::Builder {
            stop_web_site_network_trace_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Generates a new publishing password for an app (or deployment slot, if specified)."]
        pub fn generate_new_site_publishing_password_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> generate_new_site_publishing_password_slot::Builder {
            generate_new_site_publishing_password_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets perfmon counters for web app."]
        pub fn list_perf_mon_counters_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_perf_mon_counters_slot::Builder {
            list_perf_mon_counters_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                filter: None,
            }
        }
        #[doc = "Gets web app's event logs."]
        pub fn get_site_php_error_log_flag_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_php_error_log_flag_slot::Builder {
            get_site_php_error_log_flag_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the premier add-ons of an app."]
        pub fn list_premier_add_ons_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_premier_add_ons_slot::Builder {
            list_premier_add_ons_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named add-on of an app."]
        pub fn get_premier_add_on_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_premier_add_on_slot::Builder {
            get_premier_add_on_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates a named add-on of an app."]
        pub fn add_premier_add_on_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            premier_add_on: impl Into<models::PremierAddOn>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> add_premier_add_on_slot::Builder {
            add_premier_add_on_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                premier_add_on: premier_add_on.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a premier add-on from an app."]
        pub fn delete_premier_add_on_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_premier_add_on_slot::Builder {
            delete_premier_add_on_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site."]
        pub fn list_processes_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_processes_slot::Builder {
            list_processes_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_slot::Builder {
            get_process_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site."]
        pub fn delete_process_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_process_slot::Builder {
            delete_process_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a memory dump of a process by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_dump_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_dump_slot::Builder {
            get_process_dump_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List module information for a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_process_modules_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_process_modules_slot::Builder {
            list_process_modules_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_module_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            base_address: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_module_slot::Builder {
            get_process_module_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                base_address: base_address.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the threads in a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_process_threads_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_process_threads_slot::Builder {
            list_process_threads_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site."]
        pub fn get_process_thread_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            thread_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_thread_slot::Builder {
            get_process_thread_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                thread_id: thread_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get public certificates for an app or a deployment slot."]
        pub fn list_public_certificates_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_public_certificates_slot::Builder {
            list_public_certificates_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the named public certificate for an app (or deployment slot, if specified)."]
        pub fn get_public_certificate_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            public_certificate_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_public_certificate_slot::Builder {
            get_public_certificate_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                public_certificate_name: public_certificate_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a hostname binding for an app."]
        pub fn create_or_update_public_certificate_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            public_certificate_name: impl Into<String>,
            public_certificate: impl Into<models::PublicCertificate>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_public_certificate_slot::Builder {
            create_or_update_public_certificate_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                public_certificate_name: public_certificate_name.into(),
                public_certificate: public_certificate.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a hostname binding for an app."]
        pub fn delete_public_certificate_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            public_certificate_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_public_certificate_slot::Builder {
            delete_public_certificate_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                public_certificate_name: public_certificate_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the publishing profile for an app (or deployment slot, if specified)."]
        pub fn list_publishing_profile_xml_with_secrets_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            publishing_profile_options: impl Into<models::CsmPublishingProfileOptions>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_publishing_profile_xml_with_secrets_slot::Builder {
            list_publishing_profile_xml_with_secrets_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                publishing_profile_options: publishing_profile_options.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Recovers a web app to a previous snapshot."]
        pub fn recover_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            recovery_entity: impl Into<models::SnapshotRecoveryRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> recover_slot::Builder {
            recover_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                recovery_entity: recovery_entity.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Resets the configuration settings of the current slot if they were previously modified by calling the API with POST."]
        pub fn reset_slot_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> reset_slot_configuration_slot::Builder {
            reset_slot_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restarts an app (or deployment slot, if specified)."]
        pub fn restart_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> restart_slot::Builder {
            restart_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                soft_restart: None,
                synchronous: None,
            }
        }
        #[doc = "Get list of site extensions for a web site, or a deployment slot."]
        pub fn list_site_extensions_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_extensions_slot::Builder {
            list_site_extensions_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get site extension information by its ID for a web site, or a deployment slot."]
        pub fn get_site_extension_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_extension_slot::Builder {
            get_site_extension_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Install site extension on a web site, or a deployment slot."]
        pub fn install_site_extension_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> install_site_extension_slot::Builder {
            install_site_extension_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Remove a site extension from a web site, or a deployment slot."]
        pub fn delete_site_extension_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_site_extension_slot::Builder {
            delete_site_extension_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the difference in configuration settings between two web app slots."]
        pub fn list_slot_differences_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_slot_differences_slot::Builder {
            list_slot_differences_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Swaps two deployment slots of an app."]
        pub fn swap_slot_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> swap_slot_slot::Builder {
            swap_slot_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Returns all Snapshots to the user."]
        pub fn list_snapshots_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_snapshots_slot::Builder {
            list_snapshots_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the source control configuration of an app."]
        pub fn get_source_control_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_source_control_slot::Builder {
            get_source_control_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the source control configuration of an app."]
        pub fn create_or_update_source_control_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_source_control: impl Into<models::SiteSourceControl>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_source_control_slot::Builder {
            create_or_update_source_control_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_source_control: site_source_control.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the source control configuration of an app."]
        pub fn update_source_control_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_source_control: impl Into<models::SiteSourceControl>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_source_control_slot::Builder {
            update_source_control_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_source_control: site_source_control.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes the source control configuration of an app."]
        pub fn delete_source_control_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_source_control_slot::Builder {
            delete_source_control_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Starts an app (or deployment slot, if specified)."]
        pub fn start_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_slot::Builder {
            start_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Stops an app (or deployment slot, if specified)."]
        pub fn stop_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_slot::Builder {
            stop_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Sync web app repository."]
        pub fn sync_repository_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> sync_repository_slot::Builder {
            sync_repository_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Syncs function trigger metadata to the scale controller"]
        pub fn sync_function_triggers_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> sync_function_triggers_slot::Builder {
            sync_function_triggers_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List triggered web jobs for an app, or a deployment slot."]
        pub fn list_triggered_web_jobs_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_triggered_web_jobs_slot::Builder {
            list_triggered_web_jobs_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a triggered web job by its ID for an app, or a deployment slot."]
        pub fn get_triggered_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_triggered_web_job_slot::Builder {
            get_triggered_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a triggered web job by its ID for an app, or a deployment slot."]
        pub fn delete_triggered_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_triggered_web_job_slot::Builder {
            delete_triggered_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List a triggered web job's history for an app, or a deployment slot."]
        pub fn list_triggered_web_job_history_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_triggered_web_job_history_slot::Builder {
            list_triggered_web_job_history_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a triggered web job's history by its ID for an app, , or a deployment slot."]
        pub fn get_triggered_web_job_history_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_triggered_web_job_history_slot::Builder {
            get_triggered_web_job_history_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                id: id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Run a triggered web job for an app, or a deployment slot."]
        pub fn run_triggered_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> run_triggered_web_job_slot::Builder {
            run_triggered_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the quota usage information of an app (or deployment slot, if specified)."]
        pub fn list_usages_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_usages_slot::Builder {
            list_usages_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                filter: None,
            }
        }
        #[doc = "Gets the virtual networks the app (or deployment slot) is connected to."]
        pub fn list_vnet_connections_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_vnet_connections_slot::Builder {
            list_vnet_connections_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a virtual network the app (or deployment slot) is connected to by name."]
        pub fn get_vnet_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_vnet_connection_slot::Builder {
            get_vnet_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a Virtual Network connection to an app or slot (PUT) or updates the connection properties (PATCH)."]
        pub fn create_or_update_vnet_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetInfo>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_vnet_connection_slot::Builder {
            create_or_update_vnet_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a Virtual Network connection to an app or slot (PUT) or updates the connection properties (PATCH)."]
        pub fn update_vnet_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetInfo>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_vnet_connection_slot::Builder {
            update_vnet_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a connection from an app (or deployment slot to a named virtual network."]
        pub fn delete_vnet_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_vnet_connection_slot::Builder {
            delete_vnet_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets an app's Virtual Network gateway."]
        pub fn get_vnet_connection_gateway_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_vnet_connection_gateway_slot::Builder {
            get_vnet_connection_gateway_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH)."]
        pub fn create_or_update_vnet_connection_gateway_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetGateway>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_vnet_connection_gateway_slot::Builder {
            create_or_update_vnet_connection_gateway_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH)."]
        pub fn update_vnet_connection_gateway_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetGateway>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_vnet_connection_gateway_slot::Builder {
            update_vnet_connection_gateway_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List webjobs for an app, or a deployment slot."]
        pub fn list_web_jobs_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_web_jobs_slot::Builder {
            list_web_jobs_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get webjob information for an app, or a deployment slot."]
        pub fn get_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_job_slot::Builder {
            get_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the difference in configuration settings between two web app slots."]
        pub fn list_slot_differences_from_production(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            subscription_id: impl Into<String>,
        ) -> list_slot_differences_from_production::Builder {
            list_slot_differences_from_production::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Swaps two deployment slots of an app."]
        pub fn swap_slot_with_production(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            subscription_id: impl Into<String>,
        ) -> swap_slot_with_production::Builder {
            swap_slot_with_production::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Returns all Snapshots to the user."]
        pub fn list_snapshots(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_snapshots::Builder {
            list_snapshots::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the source control configuration of an app."]
        pub fn get_source_control(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_source_control::Builder {
            get_source_control::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the source control configuration of an app."]
        pub fn create_or_update_source_control(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_source_control: impl Into<models::SiteSourceControl>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_source_control::Builder {
            create_or_update_source_control::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_source_control: site_source_control.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the source control configuration of an app."]
        pub fn update_source_control(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_source_control: impl Into<models::SiteSourceControl>,
            subscription_id: impl Into<String>,
        ) -> update_source_control::Builder {
            update_source_control::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_source_control: site_source_control.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes the source control configuration of an app."]
        pub fn delete_source_control(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_source_control::Builder {
            delete_source_control::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Starts an app (or deployment slot, if specified)."]
        pub fn start(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start::Builder {
            start::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Stops an app (or deployment slot, if specified)."]
        pub fn stop(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop::Builder {
            stop::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Sync web app repository."]
        pub fn sync_repository(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> sync_repository::Builder {
            sync_repository::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Syncs function trigger metadata to the scale controller"]
        pub fn sync_function_triggers(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> sync_function_triggers::Builder {
            sync_function_triggers::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List triggered web jobs for an app, or a deployment slot."]
        pub fn list_triggered_web_jobs(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_triggered_web_jobs::Builder {
            list_triggered_web_jobs::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a triggered web job by its ID for an app, or a deployment slot."]
        pub fn get_triggered_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_triggered_web_job::Builder {
            get_triggered_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a triggered web job by its ID for an app, or a deployment slot."]
        pub fn delete_triggered_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_triggered_web_job::Builder {
            delete_triggered_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List a triggered web job's history for an app, or a deployment slot."]
        pub fn list_triggered_web_job_history(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_triggered_web_job_history::Builder {
            list_triggered_web_job_history::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a triggered web job's history by its ID for an app, , or a deployment slot."]
        pub fn get_triggered_web_job_history(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_triggered_web_job_history::Builder {
            get_triggered_web_job_history::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                id: id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Run a triggered web job for an app, or a deployment slot."]
        pub fn run_triggered_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> run_triggered_web_job::Builder {
            run_triggered_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the quota usage information of an app (or deployment slot, if specified)."]
        pub fn list_usages(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_usages::Builder {
            list_usages::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                filter: None,
            }
        }
        #[doc = "Gets the virtual networks the app (or deployment slot) is connected to."]
        pub fn list_vnet_connections(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_vnet_connections::Builder {
            list_vnet_connections::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a virtual network the app (or deployment slot) is connected to by name."]
        pub fn get_vnet_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_vnet_connection::Builder {
            get_vnet_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a Virtual Network connection to an app or slot (PUT) or updates the connection properties (PATCH)."]
        pub fn create_or_update_vnet_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetInfo>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_vnet_connection::Builder {
            create_or_update_vnet_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a Virtual Network connection to an app or slot (PUT) or updates the connection properties (PATCH)."]
        pub fn update_vnet_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetInfo>,
            subscription_id: impl Into<String>,
        ) -> update_vnet_connection::Builder {
            update_vnet_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a connection from an app (or deployment slot to a named virtual network."]
        pub fn delete_vnet_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_vnet_connection::Builder {
            delete_vnet_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets an app's Virtual Network gateway."]
        pub fn get_vnet_connection_gateway(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_vnet_connection_gateway::Builder {
            get_vnet_connection_gateway::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH)."]
        pub fn create_or_update_vnet_connection_gateway(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetGateway>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_vnet_connection_gateway::Builder {
            create_or_update_vnet_connection_gateway::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH)."]
        pub fn update_vnet_connection_gateway(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetGateway>,
            subscription_id: impl Into<String>,
        ) -> update_vnet_connection_gateway::Builder {
            update_vnet_connection_gateway::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List webjobs for an app, or a deployment slot."]
        pub fn list_web_jobs(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_web_jobs::Builder {
            list_web_jobs::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get webjob information for an app, or a deployment slot."]
        pub fn get_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_job::Builder {
            get_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::WebAppCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/sites",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::WebAppCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_by_resource_group {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) subscription_id: String,
            pub(crate) include_slots: Option<bool>,
        }
        impl Builder {
            pub fn include_slots(mut self, include_slots: bool) -> Self {
                self.include_slots = Some(include_slots);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::WebAppCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    if let Some(include_slots) = &self.include_slots {
                        url.query_pairs_mut().append_pair("includeSlots", &include_slots.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::WebAppCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Site, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::Site),
            Accepted202(models::Site),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_envelope: models::Site,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::ACCEPTED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Accepted202(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::Site),
            Accepted202(models::Site),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_envelope: models::SitePatchResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::ACCEPTED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Accepted202(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) delete_metrics: Option<bool>,
            pub(crate) delete_empty_server_farm: Option<bool>,
        }
        impl Builder {
            pub fn delete_metrics(mut self, delete_metrics: bool) -> Self {
                self.delete_metrics = Some(delete_metrics);
                self
            }
            pub fn delete_empty_server_farm(mut self, delete_empty_server_farm: bool) -> Self {
                self.delete_empty_server_farm = Some(delete_empty_server_farm);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    if let Some(delete_metrics) = &self.delete_metrics {
                        url.query_pairs_mut().append_pair("deleteMetrics", &delete_metrics.to_string());
                    }
                    if let Some(delete_empty_server_farm) = &self.delete_empty_server_farm {
                        url.query_pairs_mut()
                            .append_pair("deleteEmptyServerFarm", &delete_empty_server_farm.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod analyze_custom_hostname {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) host_name: Option<String>,
        }
        impl Builder {
            pub fn host_name(mut self, host_name: impl Into<String>) -> Self {
                self.host_name = Some(host_name.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::CustomHostnameAnalysisResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/analyzeCustomHostname",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    if let Some(host_name) = &self.host_name {
                        url.query_pairs_mut().append_pair("hostName", host_name);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CustomHostnameAnalysisResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod apply_slot_config_to_production {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot_swap_entity: models::CsmSlotEntity,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/applySlotConfig",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.slot_swap_entity).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod backup {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) request: models::BackupRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItem, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backup",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItem =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_backups {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItemCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItemCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod discover_restore {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) request: models::RestoreRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RestoreRequest, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups/discover",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RestoreRequest =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_backup_status {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItem, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItem =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_backup {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_backup_status_secrets {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) request: models::BackupRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItem, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups/{}/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItem =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod restore {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) request: models::RestoreRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RestoreResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups/{}/restore",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RestoreResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_configurations {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResourceCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResourceCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_application_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) app_settings: models::StringDictionary,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/appsettings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.app_settings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_application_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/appsettings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_auth_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_auth_settings: models::SiteAuthSettings,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteAuthSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/authsettings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_auth_settings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteAuthSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_auth_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteAuthSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/authsettings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteAuthSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_backup_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) request: models::BackupRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupRequest, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/backup",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupRequest =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_backup_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/backup",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_backup_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupRequest, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/backup/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupRequest =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_connection_strings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) connection_strings: models::ConnectionStringDictionary,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ConnectionStringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/connectionstrings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.connection_strings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ConnectionStringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_connection_strings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ConnectionStringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/connectionstrings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ConnectionStringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_diagnostic_logs_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteLogsConfig, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/logs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteLogsConfig =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_diagnostic_logs_config {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_logs_config: models::SiteLogsConfig,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteLogsConfig, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/logs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_logs_config).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteLogsConfig =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_metadata {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) metadata: models::StringDictionary,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/metadata",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.metadata).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_metadata {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/metadata/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_publishing_credentials {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::User, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/publishingcredentials/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::User =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_site_push_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) push_settings: models::PushSettings,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PushSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/pushsettings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.push_settings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PushSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_push_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PushSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/pushsettings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PushSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_slot_configuration_names {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SlotConfigNamesResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/slotConfigNames",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SlotConfigNamesResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_slot_configuration_names {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot_config_names: models::SlotConfigNamesResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SlotConfigNamesResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/slotConfigNames",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.slot_config_names).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SlotConfigNamesResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/web",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_config: models::SiteConfigResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/web",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_config).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_config: models::SiteConfigResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/web",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_config).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_configuration_snapshot_info {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigurationSnapshotInfoCollection, Error>>
            {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/web/snapshots",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigurationSnapshotInfoCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_configuration_snapshot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) snapshot_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/web/snapshots/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.snapshot_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod recover_site_configuration_snapshot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) snapshot_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/web/snapshots/{}/recover",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.snapshot_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_web_site_container_logs {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            NoContent204,
            Ok200(bytes::Bytes),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/containerlogs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(Response::Ok200(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_web_site_container_logs_zip {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            NoContent204,
            Ok200(bytes::Bytes),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/containerlogs/zip/download",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(Response::Ok200(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_continuous_web_jobs {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ContinuousWebJobCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/continuouswebjobs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ContinuousWebJobCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_continuous_web_job {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) web_job_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ContinuousWebJob, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/continuouswebjobs/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.web_job_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ContinuousWebJob =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_continuous_web_job {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) web_job_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/continuouswebjobs/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.web_job_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod start_continuous_web_job {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) web_job_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/continuouswebjobs/{}/start",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.web_job_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod stop_continuous_web_job {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) web_job_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/continuouswebjobs/{}/stop",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.web_job_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_deployments {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeploymentCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/deployments",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DeploymentCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_deployment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Deployment, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/deployments/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Deployment =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_deployment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) id: String,
            pub(crate) deployment: models::Deployment,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Deployment, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/deployments/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.deployment).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Deployment =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_deployment {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/deployments/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_deployment_log {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Deployment, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/deployments/{}/log",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Deployment =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_domain_ownership_identifiers {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::IdentifierCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/domainOwnershipIdentifiers",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::IdentifierCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_domain_ownership_identifier {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) domain_ownership_identifier_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Identifier, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/domainOwnershipIdentifiers/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.domain_ownership_identifier_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Identifier =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_domain_ownership_identifier {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) domain_ownership_identifier_name: String,
            pub(crate) domain_ownership_identifier: models::Identifier,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Identifier, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/domainOwnershipIdentifiers/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.domain_ownership_identifier_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.domain_ownership_identifier).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Identifier =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_domain_ownership_identifier {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) domain_ownership_identifier_name: String,
            pub(crate) domain_ownership_identifier: models::Identifier,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Identifier, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/domainOwnershipIdentifiers/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.domain_ownership_identifier_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.domain_ownership_identifier).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Identifier =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_domain_ownership_identifier {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) domain_ownership_identifier_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/domainOwnershipIdentifiers/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.domain_ownership_identifier_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_ms_deploy_status {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::MsDeployStatus, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/extensions/MSDeploy",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::MsDeployStatus =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_ms_deploy_operation {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            Conflict409 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) ms_deploy: models::MsDeploy,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::MsDeployStatus, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/extensions/MSDeploy",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.ms_deploy).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::MsDeployStatus =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::CONFLICT => Err(Error::Conflict409 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_ms_deploy_log {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::MsDeployLog, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/extensions/MSDeploy/log",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::MsDeployLog =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_functions {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::FunctionEnvelopeCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/functions",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::FunctionEnvelopeCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_functions_admin_token {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<String, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/functions/admin/token",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: String =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_function {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) function_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::FunctionEnvelope, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/functions/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.function_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::FunctionEnvelope =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_function {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) function_name: String,
            pub(crate) function_envelope: models::FunctionEnvelope,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::FunctionEnvelope, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/functions/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.function_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.function_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::FunctionEnvelope =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_function {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) function_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/functions/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.function_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_function_secrets {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) function_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::FunctionSecrets, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/functions/{}/listsecrets",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.function_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::FunctionSecrets =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_host_name_bindings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::HostNameBindingCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hostNameBindings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::HostNameBindingCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_host_name_binding {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) host_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::HostNameBinding, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hostNameBindings/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.host_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::HostNameBinding =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_host_name_binding {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) host_name: String,
            pub(crate) host_name_binding: models::HostNameBinding,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::HostNameBinding, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hostNameBindings/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.host_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.host_name_binding).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::HostNameBinding =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_host_name_binding {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) host_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hostNameBindings/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.host_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_hybrid_connection {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) namespace_name: String,
            pub(crate) relay_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::HybridConnection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridConnectionNamespaces/{}/relays/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.namespace_name,
                        &self.relay_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::HybridConnection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_hybrid_connection {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) namespace_name: String,
            pub(crate) relay_name: String,
            pub(crate) connection_envelope: models::HybridConnection,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::HybridConnection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridConnectionNamespaces/{}/relays/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.namespace_name,
                        &self.relay_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.connection_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::HybridConnection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_hybrid_connection {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) namespace_name: String,
            pub(crate) relay_name: String,
            pub(crate) connection_envelope: models::HybridConnection,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::HybridConnection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridConnectionNamespaces/{}/relays/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.namespace_name,
                        &self.relay_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.connection_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::HybridConnection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_hybrid_connection {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) namespace_name: String,
            pub(crate) relay_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridConnectionNamespaces/{}/relays/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.namespace_name,
                        &self.relay_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_hybrid_connection_keys {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) namespace_name: String,
            pub(crate) relay_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::HybridConnectionKey, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridConnectionNamespaces/{}/relays/{}/listKeys" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . name , & self . namespace_name , & self . relay_name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::HybridConnectionKey =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_hybrid_connections {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::HybridConnection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridConnectionRelays",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::HybridConnection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_relay_service_connections {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::RelayServiceConnectionEntity, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridconnection",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RelayServiceConnectionEntity =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_relay_service_connection {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) entity_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::RelayServiceConnectionEntity, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridconnection/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.entity_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RelayServiceConnectionEntity =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_relay_service_connection {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) entity_name: String,
            pub(crate) connection_envelope: models::RelayServiceConnectionEntity,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::RelayServiceConnectionEntity, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridconnection/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.entity_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.connection_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RelayServiceConnectionEntity =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_relay_service_connection {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) entity_name: String,
            pub(crate) connection_envelope: models::RelayServiceConnectionEntity,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::RelayServiceConnectionEntity, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridconnection/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.entity_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.connection_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RelayServiceConnectionEntity =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_relay_service_connection {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) entity_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/hybridconnection/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.entity_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_instance_identifiers {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::WebAppInstanceCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::WebAppInstanceCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_instance_ms_deploy_status {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::MsDeployStatus, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/extensions/MSDeploy",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::MsDeployStatus =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_instance_ms_deploy_operation {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            Conflict409 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) instance_id: String,
            pub(crate) ms_deploy: models::MsDeploy,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::MsDeployStatus, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/extensions/MSDeploy",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.ms_deploy).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::MsDeployStatus =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::CONFLICT => Err(Error::Conflict409 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_instance_ms_deploy_log {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::MsDeployLog, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/extensions/MSDeploy/log",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::MsDeployLog =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_instance_processes {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessInfoCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/processes",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessInfoCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_instance_process {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessInfo, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/processes/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessInfo =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_instance_process {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/processes/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_instance_process_dump {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<bytes::Bytes, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/processes/{}/dump",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_instance_process_modules {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessModuleInfoCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/processes/{}/modules",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessModuleInfoCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_instance_process_module {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) base_address: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessModuleInfo, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/processes/{}/modules/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id,
                        &self.process_id,
                        &self.base_address
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessModuleInfo =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_instance_process_threads {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessThreadInfoCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/processes/{}/threads",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessThreadInfoCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_instance_process_thread {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) thread_id: String,
            pub(crate) instance_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessThreadInfo, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/instances/{}/processes/{}/threads/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.instance_id,
                        &self.process_id,
                        &self.thread_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessThreadInfo =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod is_cloneable {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteCloneability, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/iscloneable",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteCloneability =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_sync_function_triggers {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::FunctionSecrets, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/listsyncfunctiontriggerstatus",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::FunctionSecrets =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_metric_definitions {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ResourceMetricDefinitionCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/metricdefinitions",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ResourceMetricDefinitionCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_metrics {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) details: Option<bool>,
            pub(crate) filter: Option<String>,
        }
        impl Builder {
            pub fn details(mut self, details: bool) -> Self {
                self.details = Some(details);
                self
            }
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ResourceMetricCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/metrics",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    if let Some(details) = &self.details {
                        url.query_pairs_mut().append_pair("details", &details.to_string());
                    }
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ResourceMetricCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod migrate_storage {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_name: String,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) migration_options: models::StorageMigrationOptions,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StorageMigrationResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/migrate",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let subscription_name = &self.subscription_name;
                    url.query_pairs_mut().append_pair("subscriptionName", subscription_name);
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.migration_options).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageMigrationResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod migrate_my_sql {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) migration_request_envelope: models::MigrateMySqlRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Operation, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/migratemysql",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.migration_request_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Operation =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_migrate_my_sql_status {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::MigrateMySqlStatus, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/migratemysql/status",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::MigrateMySqlStatus =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_network_features {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) view: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NetworkFeatures, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/networkFeatures/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.view
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::NetworkFeatures =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod start_web_site_network_trace {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) duration_in_seconds: Option<i32>,
            pub(crate) max_frame_length: Option<i32>,
            pub(crate) sas_url: Option<String>,
        }
        impl Builder {
            pub fn duration_in_seconds(mut self, duration_in_seconds: i32) -> Self {
                self.duration_in_seconds = Some(duration_in_seconds);
                self
            }
            pub fn max_frame_length(mut self, max_frame_length: i32) -> Self {
                self.max_frame_length = Some(max_frame_length);
                self
            }
            pub fn sas_url(mut self, sas_url: impl Into<String>) -> Self {
                self.sas_url = Some(sas_url.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<String, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/networkTrace/start",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    if let Some(duration_in_seconds) = &self.duration_in_seconds {
                        url.query_pairs_mut()
                            .append_pair("durationInSeconds", &duration_in_seconds.to_string());
                    }
                    if let Some(max_frame_length) = &self.max_frame_length {
                        url.query_pairs_mut().append_pair("maxFrameLength", &max_frame_length.to_string());
                    }
                    if let Some(sas_url) = &self.sas_url {
                        url.query_pairs_mut().append_pair("sasUrl", sas_url);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: String =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod stop_web_site_network_trace {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<String, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/networkTrace/stop",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: String =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod generate_new_site_publishing_password {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/newpassword",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_perf_mon_counters {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) filter: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PerfMonCounterCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/perfcounters",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PerfMonCounterCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_php_error_log_flag {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SitePhpErrorLogFlag, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/phplogging",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SitePhpErrorLogFlag =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_premier_add_ons {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PremierAddOn, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/premieraddons",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PremierAddOn =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_premier_add_on {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) premier_add_on_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PremierAddOn, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/premieraddons/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.premier_add_on_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PremierAddOn =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod add_premier_add_on {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) premier_add_on_name: String,
            pub(crate) premier_add_on: models::PremierAddOn,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PremierAddOn, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/premieraddons/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.premier_add_on_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.premier_add_on).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PremierAddOn =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_premier_add_on {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) premier_add_on_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/premieraddons/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.premier_add_on_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_processes {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessInfoCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/processes",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessInfoCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_process {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessInfo, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/processes/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessInfo =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_process {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/processes/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_process_dump {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<bytes::Bytes, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/processes/{}/dump",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_process_modules {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessModuleInfoCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/processes/{}/modules",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessModuleInfoCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_process_module {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) base_address: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessModuleInfo, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/processes/{}/modules/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.process_id,
                        &self.base_address
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessModuleInfo =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_process_threads {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessThreadInfoCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/processes/{}/threads",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.process_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessThreadInfoCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_process_thread {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) process_id: String,
            pub(crate) thread_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ProcessThreadInfo, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/processes/{}/threads/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.process_id,
                        &self.thread_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ProcessThreadInfo =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_public_certificates {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::PublicCertificateCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/publicCertificates",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PublicCertificateCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_public_certificate {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) public_certificate_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PublicCertificate, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/publicCertificates/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.public_certificate_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PublicCertificate =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_public_certificate {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) public_certificate_name: String,
            pub(crate) public_certificate: models::PublicCertificate,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PublicCertificate, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/publicCertificates/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.public_certificate_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.public_certificate).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PublicCertificate =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_public_certificate {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) public_certificate_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/publicCertificates/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.public_certificate_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_publishing_profile_xml_with_secrets {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) publishing_profile_options: models::CsmPublishingProfileOptions,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<bytes::Bytes, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/publishxml",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.publishing_profile_options).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod recover {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Accepted202,
            Ok200,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) recovery_entity: models::SnapshotRecoveryRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/recover",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.recovery_entity).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(Response::Accepted202),
                        http::StatusCode::OK => Ok(Response::Ok200),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod reset_production_slot_config {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/resetSlotConfig",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod restart {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) soft_restart: Option<bool>,
            pub(crate) synchronous: Option<bool>,
        }
        impl Builder {
            pub fn soft_restart(mut self, soft_restart: bool) -> Self {
                self.soft_restart = Some(soft_restart);
                self
            }
            pub fn synchronous(mut self, synchronous: bool) -> Self {
                self.synchronous = Some(synchronous);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/restart",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    if let Some(soft_restart) = &self.soft_restart {
                        url.query_pairs_mut().append_pair("softRestart", &soft_restart.to_string());
                    }
                    if let Some(synchronous) = &self.synchronous {
                        url.query_pairs_mut().append_pair("synchronous", &synchronous.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_extensions {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteExtensionInfoCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/siteextensions",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteExtensionInfoCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_extension {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_extension_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteExtensionInfo, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/siteextensions/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.site_extension_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteExtensionInfo =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod install_site_extension {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Created201(models::SiteExtensionInfo),
            Ok200(models::SiteExtensionInfo),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            TooManyRequests429 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_extension_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/siteextensions/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.site_extension_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteExtensionInfo =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Created201(rsp_value))
                        }
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteExtensionInfo =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::TOO_MANY_REQUESTS => Err(Error::TooManyRequests429 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_site_extension {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_extension_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/siteextensions/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.site_extension_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_slots {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::WebAppCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::WebAppCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Site, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_slot {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::Site),
            Accepted202(models::Site),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_envelope: models::Site,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
            pub(crate) skip_dns_registration: Option<bool>,
            pub(crate) skip_custom_domain_verification: Option<bool>,
            pub(crate) force_dns_registration: Option<bool>,
            pub(crate) ttl_in_seconds: Option<String>,
        }
        impl Builder {
            pub fn skip_dns_registration(mut self, skip_dns_registration: bool) -> Self {
                self.skip_dns_registration = Some(skip_dns_registration);
                self
            }
            pub fn skip_custom_domain_verification(mut self, skip_custom_domain_verification: bool) -> Self {
                self.skip_custom_domain_verification = Some(skip_custom_domain_verification);
                self
            }
            pub fn force_dns_registration(mut self, force_dns_registration: bool) -> Self {
                self.force_dns_registration = Some(force_dns_registration);
                self
            }
            pub fn ttl_in_seconds(mut self, ttl_in_seconds: impl Into<String>) -> Self {
                self.ttl_in_seconds = Some(ttl_in_seconds.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_envelope).map_err(Error::Serialize)?;
                    if let Some(skip_dns_registration) = &self.skip_dns_registration {
                        url.query_pairs_mut()
                            .append_pair("skipDnsRegistration", &skip_dns_registration.to_string());
                    }
                    if let Some(skip_custom_domain_verification) = &self.skip_custom_domain_verification {
                        url.query_pairs_mut()
                            .append_pair("skipCustomDomainVerification", &skip_custom_domain_verification.to_string());
                    }
                    if let Some(force_dns_registration) = &self.force_dns_registration {
                        url.query_pairs_mut()
                            .append_pair("forceDnsRegistration", &force_dns_registration.to_string());
                    }
                    if let Some(ttl_in_seconds) = &self.ttl_in_seconds {
                        url.query_pairs_mut().append_pair("ttlInSeconds", ttl_in_seconds);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::ACCEPTED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Accepted202(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_slot {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::Site),
            Accepted202(models::Site),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_envelope: models::SitePatchResource,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
            pub(crate) skip_dns_registration: Option<bool>,
            pub(crate) skip_custom_domain_verification: Option<bool>,
            pub(crate) force_dns_registration: Option<bool>,
            pub(crate) ttl_in_seconds: Option<String>,
        }
        impl Builder {
            pub fn skip_dns_registration(mut self, skip_dns_registration: bool) -> Self {
                self.skip_dns_registration = Some(skip_dns_registration);
                self
            }
            pub fn skip_custom_domain_verification(mut self, skip_custom_domain_verification: bool) -> Self {
                self.skip_custom_domain_verification = Some(skip_custom_domain_verification);
                self
            }
            pub fn force_dns_registration(mut self, force_dns_registration: bool) -> Self {
                self.force_dns_registration = Some(force_dns_registration);
                self
            }
            pub fn ttl_in_seconds(mut self, ttl_in_seconds: impl Into<String>) -> Self {
                self.ttl_in_seconds = Some(ttl_in_seconds.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_envelope).map_err(Error::Serialize)?;
                    if let Some(skip_dns_registration) = &self.skip_dns_registration {
                        url.query_pairs_mut()
                            .append_pair("skipDnsRegistration", &skip_dns_registration.to_string());
                    }
                    if let Some(skip_custom_domain_verification) = &self.skip_custom_domain_verification {
                        url.query_pairs_mut()
                            .append_pair("skipCustomDomainVerification", &skip_custom_domain_verification.to_string());
                    }
                    if let Some(force_dns_registration) = &self.force_dns_registration {
                        url.query_pairs_mut()
                            .append_pair("forceDnsRegistration", &force_dns_registration.to_string());
                    }
                    if let Some(ttl_in_seconds) = &self.ttl_in_seconds {
                        url.query_pairs_mut().append_pair("ttlInSeconds", ttl_in_seconds);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::ACCEPTED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Accepted202(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_slot {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
            pub(crate) delete_metrics: Option<bool>,
            pub(crate) delete_empty_server_farm: Option<bool>,
            pub(crate) skip_dns_registration: Option<bool>,
        }
        impl Builder {
            pub fn delete_metrics(mut self, delete_metrics: bool) -> Self {
                self.delete_metrics = Some(delete_metrics);
                self
            }
            pub fn delete_empty_server_farm(mut self, delete_empty_server_farm: bool) -> Self {
                self.delete_empty_server_farm = Some(delete_empty_server_farm);
                self
            }
            pub fn skip_dns_registration(mut self, skip_dns_registration: bool) -> Self {
                self.skip_dns_registration = Some(skip_dns_registration);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    if let Some(delete_metrics) = &self.delete_metrics {
                        url.query_pairs_mut().append_pair("deleteMetrics", &delete_metrics.to_string());
                    }
                    if let Some(delete_empty_server_farm) = &self.delete_empty_server_farm {
                        url.query_pairs_mut()
                            .append_pair("deleteEmptyServerFarm", &delete_empty_server_farm.to_string());
                    }
                    if let Some(skip_dns_registration) = &self.skip_dns_registration {
                        url.query_pairs_mut()
                            .append_pair("skipDnsRegistration", &skip_dns_registration.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod analyze_custom_hostname_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
            pub(crate) host_name: Option<String>,
        }
        impl Builder {
            pub fn host_name(mut self, host_name: impl Into<String>) -> Self {
                self.host_name = Some(host_name.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::CustomHostnameAnalysisResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/analyzeCustomHostname",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    if let Some(host_name) = &self.host_name {
                        url.query_pairs_mut().append_pair("hostName", host_name);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CustomHostnameAnalysisResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod apply_slot_configuration_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot_swap_entity: models::CsmSlotEntity,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/applySlotConfig",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.slot_swap_entity).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod backup_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) request: models::BackupRequest,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItem, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/backup",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItem =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_backups_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItemCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/backups",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItemCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod discover_restore_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) request: models::RestoreRequest,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RestoreRequest, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/backups/discover",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RestoreRequest =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_backup_status_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItem, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/backups/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItem =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_backup_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/backups/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_backup_status_secrets_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) request: models::BackupRequest,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItem, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/backups/{}/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItem =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod restore_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) request: models::RestoreRequest,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RestoreResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/backups/{}/restore",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RestoreResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_configurations_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResourceCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResourceCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_application_settings_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) app_settings: models::StringDictionary,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/appsettings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.app_settings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_application_settings_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/appsettings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_auth_settings_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_auth_settings: models::SiteAuthSettings,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteAuthSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/authsettings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_auth_settings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteAuthSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_auth_settings_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteAuthSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/authsettings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteAuthSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_backup_configuration_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) request: models::BackupRequest,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupRequest, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/backup",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupRequest =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_backup_configuration_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/backup",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_backup_configuration_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupRequest, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/backup/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupRequest =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_connection_strings_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) connection_strings: models::ConnectionStringDictionary,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ConnectionStringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/connectionstrings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.connection_strings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ConnectionStringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_connection_strings_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ConnectionStringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/connectionstrings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ConnectionStringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_diagnostic_logs_configuration_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteLogsConfig, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/logs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteLogsConfig =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_diagnostic_logs_config_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_logs_config: models::SiteLogsConfig,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteLogsConfig, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/logs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_logs_config).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteLogsConfig =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_metadata_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) metadata: models::StringDictionary,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/metadata",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.metadata).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_metadata_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/metadata/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_publishing_credentials_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::User, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/publishingcredentials/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::User =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_site_push_settings_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) push_settings: models::PushSettings,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PushSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/pushsettings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.push_settings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PushSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_push_settings_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PushSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/pushsettings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PushSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_configuration_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/web",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_configuration_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_config: models::SiteConfigResource,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/web",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_config).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_configuration_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_config: models::SiteConfigResource,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/web",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_config).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_configuration_snapshot_info_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigurationSnapshotInfoCollection, Error>>
            {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/web/snapshots",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigurationSnapshotInfoCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_configuration_snapshot_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) snapshot_id: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/web/snapshots/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.snapshot_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod recover_site_configuration_snapshot_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) snapshot_id: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/config/web/snapshots/{}/recover",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.snapshot_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_web_site_container_logs_slot {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            NoContent204,
            Ok200(bytes::Bytes),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/containerlogs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(Response::Ok200(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_web_site_container_logs_zip_slot {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            NoContent204,
            Ok200(bytes::Bytes),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/containerlogs/zip/download",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(Response::Ok200(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_continuous_web_jobs_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ContinuousWebJobCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/continuouswebjobs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ContinuousWebJobCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_continuous_web_job_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) web_job_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ContinuousWebJob, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/continuouswebjobs/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.web_job_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ContinuousWebJob =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_continuous_web_job_slot {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) web_job_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/continuouswebjobs/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.web_job_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod start_continuous_web_job_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) web_job_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/continuouswebjobs/{}/start",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.web_job_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod stop_continuous_web_job_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) web_job_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/continuouswebjobs/{}/stop",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.web_job_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_deployments_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeploymentCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/deployments",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DeploymentCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_deployment_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) id: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Deployment, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/deployments/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Deployment =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_deployment_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) id: String,
            pub(crate) slot: String,
            pub(crate) deployment: models::Deployment,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Deployment, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/deployments/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.deployment).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Deployment =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_deployment_slot {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) id: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/deployments/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.slot,
                        &self.id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2016-08-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_deployment_log_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP 