#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Information about the formal API definition for the app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiDefinitionInfo {
    #[doc = "The URL of the API definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl ApiDefinitionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application logs configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationLogsConfig {
    #[doc = "Application logs to file system configuration."]
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<FileSystemApplicationLogsConfig>,
    #[doc = "Application logs to Azure table storage configuration."]
    #[serde(rename = "azureTableStorage", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_storage: Option<AzureTableStorageApplicationLogsConfig>,
    #[doc = "Application logs azure blob storage configuration."]
    #[serde(rename = "azureBlobStorage", default, skip_serializing_if = "Option::is_none")]
    pub azure_blob_storage: Option<AzureBlobStorageApplicationLogsConfig>,
}
impl ApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Actions which to take by the auto-heal module when a rule is triggered."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealActions {
    #[doc = "Predefined action to be taken."]
    #[serde(rename = "actionType", default, skip_serializing_if = "Option::is_none")]
    pub action_type: Option<auto_heal_actions::ActionType>,
    #[doc = "Custom action to be executed\nwhen an auto heal rule is triggered."]
    #[serde(rename = "customAction", default, skip_serializing_if = "Option::is_none")]
    pub custom_action: Option<AutoHealCustomAction>,
    #[doc = "Minimum time the process must execute\nbefore taking the action"]
    #[serde(rename = "minProcessExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub min_process_execution_time: Option<String>,
}
impl AutoHealActions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod auto_heal_actions {
    use super::*;
    #[doc = "Predefined action to be taken."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActionType {
        Recycle,
        LogEvent,
        CustomAction,
    }
}
#[doc = "Custom action to be executed\nwhen an auto heal rule is triggered."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealCustomAction {
    #[doc = "Executable to be run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exe: Option<String>,
    #[doc = "Parameters for the executable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<String>,
}
impl AutoHealCustomAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Rules that can be defined for auto-heal."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealRules {
    #[doc = "Triggers for auto-heal."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub triggers: Option<AutoHealTriggers>,
    #[doc = "Actions which to take by the auto-heal module when a rule is triggered."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub actions: Option<AutoHealActions>,
}
impl AutoHealRules {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Triggers for auto-heal."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealTriggers {
    #[doc = "Trigger based on total requests."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub requests: Option<RequestsBasedTrigger>,
    #[doc = "A rule based on private bytes."]
    #[serde(rename = "privateBytesInKB", default, skip_serializing_if = "Option::is_none")]
    pub private_bytes_in_kb: Option<i32>,
    #[doc = "A rule based on status codes."]
    #[serde(rename = "statusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub status_codes: Vec<StatusCodesBasedTrigger>,
    #[doc = "Trigger based on request execution time."]
    #[serde(rename = "slowRequests", default, skip_serializing_if = "Option::is_none")]
    pub slow_requests: Option<SlowRequestsBasedTrigger>,
}
impl AutoHealTriggers {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application logs azure blob storage configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobStorageApplicationLogsConfig {
    #[doc = "Log level."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<azure_blob_storage_application_logs_config::Level>,
    #[doc = "SAS url to a azure blob container with read/write/list/delete permissions."]
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
    #[doc = "Retention in days.\nRemove blobs older than X days.\n0 or lower means no retention."]
    #[serde(rename = "retentionInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_days: Option<i32>,
}
impl AzureBlobStorageApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_blob_storage_application_logs_config {
    use super::*;
    #[doc = "Log level."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Off,
        Verbose,
        Information,
        Warning,
        Error,
    }
}
#[doc = "Http logs to azure blob storage configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobStorageHttpLogsConfig {
    #[doc = "SAS url to a azure blob container with read/write/list/delete permissions."]
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
    #[doc = "Retention in days.\nRemove blobs older than X days.\n0 or lower means no retention."]
    #[serde(rename = "retentionInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_days: Option<i32>,
    #[doc = "True if configuration is enabled, false if it is disabled and null if configuration is not set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl AzureBlobStorageHttpLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application logs to Azure table storage configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableStorageApplicationLogsConfig {
    #[doc = "Log level."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<azure_table_storage_application_logs_config::Level>,
    #[doc = "SAS URL to an Azure table with add/query/delete permissions."]
    #[serde(rename = "sasUrl")]
    pub sas_url: String,
}
impl AzureTableStorageApplicationLogsConfig {
    pub fn new(sas_url: String) -> Self {
        Self { level: None, sas_url }
    }
}
pub mod azure_table_storage_application_logs_config {
    use super::*;
    #[doc = "Log level."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Off,
        Verbose,
        Information,
        Warning,
        Error,
    }
}
#[doc = "Backup description."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupItem {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "BackupItem resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<backup_item::Properties>,
}
impl BackupItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_item {
    use super::*;
    #[doc = "BackupItem resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Id of the backup."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<i32>,
        #[doc = "SAS URL for the storage account container which contains this backup."]
        #[serde(rename = "storageAccountUrl", default, skip_serializing_if = "Option::is_none")]
        pub storage_account_url: Option<String>,
        #[doc = "Name of the blob which contains data for this backup."]
        #[serde(rename = "blobName", default, skip_serializing_if = "Option::is_none")]
        pub blob_name: Option<String>,
        #[doc = "Name of this backup."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "Backup status."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[doc = "Size of the backup in bytes."]
        #[serde(rename = "sizeInBytes", default, skip_serializing_if = "Option::is_none")]
        pub size_in_bytes: Option<i64>,
        #[doc = "Timestamp of the backup creation."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub created: Option<String>,
        #[doc = "Details regarding this backup. Might contain an error message."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub log: Option<String>,
        #[doc = "List of databases included in the backup."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub databases: Vec<DatabaseBackupSetting>,
        #[doc = "True if this backup has been created due to a schedule being triggered."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub scheduled: Option<bool>,
        #[doc = "Timestamp of a last restore operation which used this backup."]
        #[serde(rename = "lastRestoreTimeStamp", default, skip_serializing_if = "Option::is_none")]
        pub last_restore_time_stamp: Option<String>,
        #[doc = "Timestamp when this backup finished."]
        #[serde(rename = "finishedTimeStamp", default, skip_serializing_if = "Option::is_none")]
        pub finished_time_stamp: Option<String>,
        #[doc = "Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support."]
        #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
        pub correlation_id: Option<String>,
        #[doc = "Size of the original web app which has been backed up."]
        #[serde(rename = "websiteSizeInBytes", default, skip_serializing_if = "Option::is_none")]
        pub website_size_in_bytes: Option<i64>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Backup status."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            InProgress,
            Failed,
            Succeeded,
            TimedOut,
            Created,
            Skipped,
            PartiallySucceeded,
            DeleteInProgress,
            DeleteFailed,
            Deleted,
        }
    }
}
#[doc = "Collection of backup items."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupItemCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<BackupItem>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BackupItemCollection {
    pub fn new(value: Vec<BackupItem>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Description of a backup which will be performed."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "BackupRequest resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<backup_request::Properties>,
}
impl BackupRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_request {
    use super::*;
    #[doc = "BackupRequest resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[doc = "Name of the backup."]
        pub name: String,
        #[doc = "True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[doc = "SAS URL to the container."]
        #[serde(rename = "storageAccountUrl")]
        pub storage_account_url: String,
        #[doc = "Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy."]
        #[serde(rename = "backupSchedule", default, skip_serializing_if = "Option::is_none")]
        pub backup_schedule: Option<BackupSchedule>,
        #[doc = "Databases included in the backup."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub databases: Vec<DatabaseBackupSetting>,
        #[doc = "Type of the backup."]
        #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
        pub type_: Option<properties::Type>,
    }
    impl Properties {
        pub fn new(name: String, storage_account_url: String) -> Self {
            Self {
                name,
                enabled: None,
                storage_account_url,
                backup_schedule: None,
                databases: Vec::new(),
                type_: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Type of the backup."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Type {
            Default,
            Clone,
            Relocation,
            Snapshot,
        }
    }
}
#[doc = "Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupSchedule {
    #[doc = "How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)"]
    #[serde(rename = "frequencyInterval")]
    pub frequency_interval: i32,
    #[doc = "The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)"]
    #[serde(rename = "frequencyUnit")]
    pub frequency_unit: backup_schedule::FrequencyUnit,
    #[doc = "True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise."]
    #[serde(rename = "keepAtLeastOneBackup")]
    pub keep_at_least_one_backup: bool,
    #[doc = "After how many days backups should be deleted."]
    #[serde(rename = "retentionPeriodInDays")]
    pub retention_period_in_days: i32,
    #[doc = "When the schedule should start working."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "Last time when this schedule was triggered."]
    #[serde(rename = "lastExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub last_execution_time: Option<String>,
}
impl BackupSchedule {
    pub fn new(
        frequency_interval: i32,
        frequency_unit: backup_schedule::FrequencyUnit,
        keep_at_least_one_backup: bool,
        retention_period_in_days: i32,
    ) -> Self {
        Self {
            frequency_interval,
            frequency_unit,
            keep_at_least_one_backup,
            retention_period_in_days,
            start_time: None,
            last_execution_time: None,
        }
    }
}
pub mod backup_schedule {
    use super::*;
    #[doc = "The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FrequencyUnit {
        Day,
        Hour,
    }
    impl Default for FrequencyUnit {
        fn default() -> Self {
            Self::Day
        }
    }
}
#[doc = "Information needed for cloning operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloningInfo {
    #[doc = "Correlation ID of cloning operation. This ID ties multiple cloning operations\ntogether to use the same snapshot."]
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[doc = "<code>true</code> to overwrite destination app; otherwise, <code>false</code>."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub overwrite: Option<bool>,
    #[doc = "<code>true</code> to clone custom hostnames from source app; otherwise, <code>false</code>."]
    #[serde(rename = "cloneCustomHostNames", default, skip_serializing_if = "Option::is_none")]
    pub clone_custom_host_names: Option<bool>,
    #[doc = "<code>true</code> to clone source control from source app; otherwise, <code>false</code>."]
    #[serde(rename = "cloneSourceControl", default, skip_serializing_if = "Option::is_none")]
    pub clone_source_control: Option<bool>,
    #[doc = "ARM resource ID of the source app. App resource ID is of the form \n/subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and \n/subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots."]
    #[serde(rename = "sourceWebAppId")]
    pub source_web_app_id: String,
    #[doc = "App Service Environment."]
    #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
    pub hosting_environment: Option<String>,
    #[doc = "Application setting overrides for cloned app. If specified, these settings override the settings cloned \nfrom source app. Otherwise, application settings from source app are retained."]
    #[serde(rename = "appSettingsOverrides", default, skip_serializing_if = "Option::is_none")]
    pub app_settings_overrides: Option<serde_json::Value>,
    #[doc = "<code>true</code> to configure load balancing for source and destination app."]
    #[serde(rename = "configureLoadBalancing", default, skip_serializing_if = "Option::is_none")]
    pub configure_load_balancing: Option<bool>,
    #[doc = "ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form \n/subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}."]
    #[serde(rename = "trafficManagerProfileId", default, skip_serializing_if = "Option::is_none")]
    pub traffic_manager_profile_id: Option<String>,
    #[doc = "Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist."]
    #[serde(rename = "trafficManagerProfileName", default, skip_serializing_if = "Option::is_none")]
    pub traffic_manager_profile_name: Option<String>,
    #[doc = "<code>true</code> if quotas should be ignored; otherwise, <code>false</code>."]
    #[serde(rename = "ignoreQuotas", default, skip_serializing_if = "Option::is_none")]
    pub ignore_quotas: Option<bool>,
}
impl CloningInfo {
    pub fn new(source_web_app_id: String) -> Self {
        Self {
            correlation_id: None,
            overwrite: None,
            clone_custom_host_names: None,
            clone_source_control: None,
            source_web_app_id,
            hosting_environment: None,
            app_settings_overrides: None,
            configure_load_balancing: None,
            traffic_manager_profile_id: None,
            traffic_manager_profile_name: None,
            ignore_quotas: None,
        }
    }
}
#[doc = "Database connection string information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnStringInfo {
    #[doc = "Name of connection string."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Connection string value."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[doc = "Type of database."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<conn_string_info::Type>,
}
impl ConnStringInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod conn_string_info {
    use super::*;
    #[doc = "Type of database."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        MySql,
        #[serde(rename = "SQLServer")]
        SqlServer,
        #[serde(rename = "SQLAzure")]
        SqlAzure,
        Custom,
        NotificationHub,
        ServiceBus,
        EventHub,
        ApiHub,
        DocDb,
        RedisCache,
        #[serde(rename = "PostgreSQL")]
        PostgreSql,
    }
}
#[doc = "Database connection string value to type pair."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnStringValueTypePair {
    #[doc = "Value of pair."]
    pub value: String,
    #[doc = "Type of database."]
    #[serde(rename = "type")]
    pub type_: conn_string_value_type_pair::Type,
}
impl ConnStringValueTypePair {
    pub fn new(value: String, type_: conn_string_value_type_pair::Type) -> Self {
        Self { value, type_ }
    }
}
pub mod conn_string_value_type_pair {
    use super::*;
    #[doc = "Type of database."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        MySql,
        #[serde(rename = "SQLServer")]
        SqlServer,
        #[serde(rename = "SQLAzure")]
        SqlAzure,
        Custom,
        NotificationHub,
        ServiceBus,
        EventHub,
        ApiHub,
        DocDb,
        RedisCache,
        #[serde(rename = "PostgreSQL")]
        PostgreSql,
    }
}
#[doc = "String dictionary resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionStringDictionary {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "Connection strings."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl ConnectionStringDictionary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Continuous Web Job Information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContinuousWebJob {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "ContinuousWebJob resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<continuous_web_job::Properties>,
}
impl ContinuousWebJob {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod continuous_web_job {
    use super::*;
    #[doc = "ContinuousWebJob resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Job status."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[doc = "Detailed status."]
        #[serde(rename = "detailedStatus", default, skip_serializing_if = "Option::is_none")]
        pub detailed_status: Option<String>,
        #[doc = "Log URL."]
        #[serde(rename = "logUrl", default, skip_serializing_if = "Option::is_none")]
        pub log_url: Option<String>,
        #[doc = "Job name. Used as job identifier in ARM resource URI."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "Run command."]
        #[serde(rename = "runCommand", default, skip_serializing_if = "Option::is_none")]
        pub run_command: Option<String>,
        #[doc = "Job URL."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub url: Option<String>,
        #[doc = "Extra Info URL."]
        #[serde(rename = "extraInfoUrl", default, skip_serializing_if = "Option::is_none")]
        pub extra_info_url: Option<String>,
        #[doc = "Job type."]
        #[serde(rename = "jobType", default, skip_serializing_if = "Option::is_none")]
        pub job_type: Option<properties::JobType>,
        #[doc = "Error information."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub error: Option<String>,
        #[doc = "Using SDK?"]
        #[serde(rename = "usingSdk", default, skip_serializing_if = "Option::is_none")]
        pub using_sdk: Option<bool>,
        #[doc = "Job settings."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub settings: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Job status."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Initializing,
            Starting,
            Running,
            PendingRestart,
            Stopped,
        }
        #[doc = "Job type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum JobType {
            Continuous,
            Triggered,
        }
    }
}
#[doc = "Collection of Kudu continuous web job information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContinuousWebJobCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<ContinuousWebJob>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ContinuousWebJobCollection {
    pub fn new(value: Vec<ContinuousWebJob>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Cross-Origin Resource Sharing (CORS) settings for the app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CorsSettings {
    #[doc = "Gets or sets the list of origins that should be allowed to make cross-origin\ncalls (for example: http://example.com:12345). Use \"*\" to allow all."]
    #[serde(rename = "allowedOrigins", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_origins: Vec<String>,
}
impl CorsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Publishing options for requested profile."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmPublishingProfileOptions {
    #[doc = "Name of the format. Valid values are: \nFileZilla3\nWebDeploy -- default\nFtp"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<csm_publishing_profile_options::Format>,
}
impl CsmPublishingProfileOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod csm_publishing_profile_options {
    use super::*;
    #[doc = "Name of the format. Valid values are: \nFileZilla3\nWebDeploy -- default\nFtp"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Format {
        FileZilla3,
        WebDeploy,
        Ftp,
    }
}
#[doc = "Deployment slot parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CsmSlotEntity {
    #[doc = "Destination deployment slot during swap operation."]
    #[serde(rename = "targetSlot")]
    pub target_slot: String,
    #[doc = "<code>true</code> to preserve Virtual Network to the slot during swap; otherwise, <code>false</code>."]
    #[serde(rename = "preserveVnet")]
    pub preserve_vnet: bool,
}
impl CsmSlotEntity {
    pub fn new(target_slot: String, preserve_vnet: bool) -> Self {
        Self {
            target_slot,
            preserve_vnet,
        }
    }
}
#[doc = "Usage of the quota resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmUsageQuota {
    #[doc = "Units of measurement for the quota resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[doc = "Next reset time for the resource counter."]
    #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
    pub next_reset_time: Option<String>,
    #[doc = "The current value of the resource counter."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[doc = "The resource limit."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "Localizable string object containing the name and a localized value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<LocalizableString>,
}
impl CsmUsageQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of CSM usage quotas."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CsmUsageQuotaCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<CsmUsageQuota>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CsmUsageQuotaCollection {
    pub fn new(value: Vec<CsmUsageQuota>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Custom domain analysis."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomHostnameAnalysisResult {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "CustomHostnameAnalysisResult resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<custom_hostname_analysis_result::Properties>,
}
impl CustomHostnameAnalysisResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod custom_hostname_analysis_result {
    use super::*;
    #[doc = "CustomHostnameAnalysisResult resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "<code>true</code> if hostname is already verified; otherwise, <code>false</code>."]
        #[serde(rename = "isHostnameAlreadyVerified", default, skip_serializing_if = "Option::is_none")]
        pub is_hostname_already_verified: Option<bool>,
        #[doc = "DNS verification test result."]
        #[serde(rename = "customDomainVerificationTest", default, skip_serializing_if = "Option::is_none")]
        pub custom_domain_verification_test: Option<properties::CustomDomainVerificationTest>,
        #[doc = "Body of the error response returned from the API."]
        #[serde(rename = "customDomainVerificationFailureInfo", default, skip_serializing_if = "Option::is_none")]
        pub custom_domain_verification_failure_info: Option<ErrorEntity>,
        #[doc = "<code>true</code> if there is a conflict on a scale unit; otherwise, <code>false</code>."]
        #[serde(rename = "hasConflictOnScaleUnit", default, skip_serializing_if = "Option::is_none")]
        pub has_conflict_on_scale_unit: Option<bool>,
        #[doc = "<code>true</code> if there is a conflict across subscriptions; otherwise, <code>false</code>."]
        #[serde(rename = "hasConflictAcrossSubscription", default, skip_serializing_if = "Option::is_none")]
        pub has_conflict_across_subscription: Option<bool>,
        #[doc = "Name of the conflicting app on scale unit if it's within the same subscription."]
        #[serde(rename = "conflictingAppResourceId", default, skip_serializing_if = "Option::is_none")]
        pub conflicting_app_resource_id: Option<String>,
        #[doc = "CName records controller can see for this hostname."]
        #[serde(rename = "cNameRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub c_name_records: Vec<String>,
        #[doc = "TXT records controller can see for this hostname."]
        #[serde(rename = "txtRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub txt_records: Vec<String>,
        #[doc = "A records controller can see for this hostname."]
        #[serde(rename = "aRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub a_records: Vec<String>,
        #[doc = "Alternate CName records controller can see for this hostname."]
        #[serde(rename = "alternateCNameRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub alternate_c_name_records: Vec<String>,
        #[doc = "Alternate TXT records controller can see for this hostname."]
        #[serde(rename = "alternateTxtRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub alternate_txt_records: Vec<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "DNS verification test result."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum CustomDomainVerificationTest {
            Passed,
            Failed,
            Skipped,
        }
    }
}
#[doc = "Database backup settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseBackupSetting {
    #[doc = "Database type (e.g. SqlAzure / MySql)."]
    #[serde(rename = "databaseType")]
    pub database_type: database_backup_setting::DatabaseType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.\nThis is used during restore with overwrite connection strings options."]
    #[serde(rename = "connectionStringName", default, skip_serializing_if = "Option::is_none")]
    pub connection_string_name: Option<String>,
    #[doc = "Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
}
impl DatabaseBackupSetting {
    pub fn new(database_type: database_backup_setting::DatabaseType) -> Self {
        Self {
            database_type,
            name: None,
            connection_string_name: None,
            connection_string: None,
        }
    }
}
pub mod database_backup_setting {
    use super::*;
    #[doc = "Database type (e.g. SqlAzure / MySql)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DatabaseType {
        SqlAzure,
        MySql,
        LocalMySql,
        PostgreSql,
    }
}
#[doc = "User credentials used for publishing activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Deployment {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "Deployment resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<deployment::Properties>,
}
impl Deployment {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod deployment {
    use super::*;
    #[doc = "Deployment resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Identifier for deployment."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
        #[doc = "Deployment status."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<i32>,
        #[doc = "Details about deployment status."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[doc = "Who authored the deployment."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub author: Option<String>,
        #[doc = "Who performed the deployment."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub deployer: Option<String>,
        #[doc = "Author email."]
        #[serde(rename = "authorEmail", default, skip_serializing_if = "Option::is_none")]
        pub author_email: Option<String>,
        #[doc = "Start time."]
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[doc = "End time."]
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[doc = "True if deployment is currently active, false if completed and null if not started."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub active: Option<bool>,
        #[doc = "Details on deployment."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub details: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of app deployments."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeploymentCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<Deployment>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DeploymentCollection {
    pub fn new(value: Vec<Deployment>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Enabled configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnabledConfig {
    #[doc = "True if configuration is enabled, false if it is disabled and null if configuration is not set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl EnabledConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Body of the error response returned from the API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorEntity {
    #[doc = "Type of error."]
    #[serde(rename = "extendedCode", default, skip_serializing_if = "Option::is_none")]
    pub extended_code: Option<String>,
    #[doc = "Message template."]
    #[serde(rename = "messageTemplate", default, skip_serializing_if = "Option::is_none")]
    pub message_template: Option<String>,
    #[doc = "Parameters for the template."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<String>,
    #[doc = "Inner errors."]
    #[serde(rename = "innerErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub inner_errors: Vec<ErrorEntity>,
    #[doc = "Basic error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Any details of the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Routing rules in production experiments."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Experiments {
    #[doc = "List of ramp-up rules."]
    #[serde(rename = "rampUpRules", default, skip_serializing_if = "Vec::is_empty")]
    pub ramp_up_rules: Vec<RampUpRule>,
}
impl Experiments {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application logs to file system configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileSystemApplicationLogsConfig {
    #[doc = "Log level."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<file_system_application_logs_config::Level>,
}
impl FileSystemApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod file_system_application_logs_config {
    use super::*;
    #[doc = "Log level."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Off,
        Verbose,
        Information,
        Warning,
        Error,
    }
    impl Default for Level {
        fn default() -> Self {
            Self::Off
        }
    }
}
#[doc = "Http logs to file system configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileSystemHttpLogsConfig {
    #[doc = "Maximum size in megabytes that http log files can use.\nWhen reached old log files will be removed to make space for new ones.\nValue can range between 25 and 100."]
    #[serde(rename = "retentionInMb", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_mb: Option<i32>,
    #[doc = "Retention in days.\nRemove files older than X days.\n0 or lower means no retention."]
    #[serde(rename = "retentionInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_days: Option<i32>,
    #[doc = "True if configuration is enabled, false if it is disabled and null if configuration is not set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl FileSystemHttpLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Web Job Information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FunctionEnvelope {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "FunctionEnvelope resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<function_envelope::Properties>,
}
impl FunctionEnvelope {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod function_envelope {
    use super::*;
    #[doc = "FunctionEnvelope resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Function name."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "Function App ID."]
        #[serde(rename = "functionAppId", default, skip_serializing_if = "Option::is_none")]
        pub function_app_id: Option<String>,
        #[doc = "Script root path URI."]
        #[serde(rename = "scriptRootPathHref", default, skip_serializing_if = "Option::is_none")]
        pub script_root_path_href: Option<String>,
        #[doc = "Script URI."]
        #[serde(rename = "scriptHref", default, skip_serializing_if = "Option::is_none")]
        pub script_href: Option<String>,
        #[doc = "Config URI."]
        #[serde(rename = "configHref", default, skip_serializing_if = "Option::is_none")]
        pub config_href: Option<String>,
        #[doc = "Secrets file URI."]
        #[serde(rename = "secretsFileHref", default, skip_serializing_if = "Option::is_none")]
        pub secrets_file_href: Option<String>,
        #[doc = "Function URI."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub href: Option<String>,
        #[doc = "Config information."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub config: Option<serde_json::Value>,
        #[doc = "File list."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub files: Option<serde_json::Value>,
        #[doc = "Test data used when testing via the Azure Portal."]
        #[serde(rename = "testData", default, skip_serializing_if = "Option::is_none")]
        pub test_data: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of Kudu function information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FunctionEnvelopeCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<FunctionEnvelope>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FunctionEnvelopeCollection {
    pub fn new(value: Vec<FunctionEnvelope>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Function secrets."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FunctionSecrets {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "FunctionSecrets resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<function_secrets::Properties>,
}
impl FunctionSecrets {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod function_secrets {
    use super::*;
    #[doc = "FunctionSecrets resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Secret key."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub key: Option<String>,
        #[doc = "Trigger URL."]
        #[serde(rename = "triggerUrl", default, skip_serializing_if = "Option::is_none")]
        pub trigger_url: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "The IIS handler mappings used to define which handler processes HTTP requests with certain extension. \nFor example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HandlerMapping {
    #[doc = "Requests with this extension will be handled using the specified FastCGI application."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub extension: Option<String>,
    #[doc = "The absolute path to the FastCGI application."]
    #[serde(rename = "scriptProcessor", default, skip_serializing_if = "Option::is_none")]
    pub script_processor: Option<String>,
    #[doc = "Command-line arguments to be passed to the script processor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub arguments: Option<String>,
}
impl HandlerMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A hostname binding object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostNameBinding {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "HostNameBinding resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<host_name_binding::Properties>,
}
impl HostNameBinding {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod host_name_binding {
    use super::*;
    #[doc = "HostNameBinding resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "App Service app name."]
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[doc = "Fully qualified ARM domain resource URI."]
        #[serde(rename = "domainId", default, skip_serializing_if = "Option::is_none")]
        pub domain_id: Option<String>,
        #[doc = "Azure resource name."]
        #[serde(rename = "azureResourceName", default, skip_serializing_if = "Option::is_none")]
        pub azure_resource_name: Option<String>,
        #[doc = "Azure resource type."]
        #[serde(rename = "azureResourceType", default, skip_serializing_if = "Option::is_none")]
        pub azure_resource_type: Option<properties::AzureResourceType>,
        #[doc = "Custom DNS record type."]
        #[serde(rename = "customHostNameDnsRecordType", default, skip_serializing_if = "Option::is_none")]
        pub custom_host_name_dns_record_type: Option<properties::CustomHostNameDnsRecordType>,
        #[doc = "Hostname type."]
        #[serde(rename = "hostNameType", default, skip_serializing_if = "Option::is_none")]
        pub host_name_type: Option<properties::HostNameType>,
        #[doc = "SSL type"]
        #[serde(rename = "sslState", default, skip_serializing_if = "Option::is_none")]
        pub ssl_state: Option<properties::SslState>,
        #[doc = "SSL certificate thumbprint"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
        #[doc = "Virtual IP address assigned to the hostname if IP based SSL is enabled."]
        #[serde(rename = "virtualIP", default, skip_serializing_if = "Option::is_none")]
        pub virtual_ip: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Azure resource type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AzureResourceType {
            Website,
            TrafficManager,
        }
        #[doc = "Custom DNS record type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum CustomHostNameDnsRecordType {
            CName,
            A,
        }
        #[doc = "Hostname type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum HostNameType {
            Verified,
            Managed,
        }
        #[doc = "SSL type"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum SslState {
            Disabled,
            SniEnabled,
            IpBasedEnabled,
        }
    }
}
#[doc = "Collection of hostname bindings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HostNameBindingCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<HostNameBinding>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl HostNameBindingCollection {
    pub fn new(value: Vec<HostNameBinding>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "SSL-enabled hostname."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostNameSslState {
    #[doc = "Hostname."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "SSL type."]
    #[serde(rename = "sslState", default, skip_serializing_if = "Option::is_none")]
    pub ssl_state: Option<host_name_ssl_state::SslState>,
    #[doc = "Virtual IP address assigned to the hostname if IP based SSL is enabled."]
    #[serde(rename = "virtualIP", default, skip_serializing_if = "Option::is_none")]
    pub virtual_ip: Option<String>,
    #[doc = "SSL certificate thumbprint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "Set to <code>true</code> to update existing hostname."]
    #[serde(rename = "toUpdate", default, skip_serializing_if = "Option::is_none")]
    pub to_update: Option<bool>,
    #[doc = "Indicates whether the hostname is a standard or repository hostname."]
    #[serde(rename = "hostType", default, skip_serializing_if = "Option::is_none")]
    pub host_type: Option<host_name_ssl_state::HostType>,
}
impl HostNameSslState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod host_name_ssl_state {
    use super::*;
    #[doc = "SSL type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SslState {
        Disabled,
        SniEnabled,
        IpBasedEnabled,
    }
    #[doc = "Indicates whether the hostname is a standard or repository hostname."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HostType {
        Standard,
        Repository,
    }
}
#[doc = "Specification for an App Service Environment to use for this resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentProfile {
    #[doc = "Resource ID of the App Service Environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Name of the App Service Environment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type of the App Service Environment."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl HostingEnvironmentProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Http logs configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpLogsConfig {
    #[doc = "Http logs to file system configuration."]
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<FileSystemHttpLogsConfig>,
    #[doc = "Http logs to azure blob storage configuration."]
    #[serde(rename = "azureBlobStorage", default, skip_serializing_if = "Option::is_none")]
    pub azure_blob_storage: Option<AzureBlobStorageHttpLogsConfig>,
}
impl HttpLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hybrid Connection contract. This is used to configure a Hybrid Connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HybridConnection {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "HybridConnection resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hybrid_connection::Properties>,
}
impl HybridConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hybrid_connection {
    use super::*;
    #[doc = "HybridConnection resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The name of the Service Bus namespace."]
        #[serde(rename = "serviceBusNamespace", default, skip_serializing_if = "Option::is_none")]
        pub service_bus_namespace: Option<String>,
        #[doc = "The name of the Service Bus relay."]
        #[serde(rename = "relayName", default, skip_serializing_if = "Option::is_none")]
        pub relay_name: Option<String>,
        #[doc = "The ARM URI to the Service Bus relay."]
        #[serde(rename = "relayArmUri", default, skip_serializing_if = "Option::is_none")]
        pub relay_arm_uri: Option<String>,
        #[doc = "The hostname of the endpoint."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub hostname: Option<String>,
        #[doc = "The port of the endpoint."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub port: Option<i32>,
        #[doc = "The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus."]
        #[serde(rename = "sendKeyName", default, skip_serializing_if = "Option::is_none")]
        pub send_key_name: Option<String>,
        #[doc = "The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned\nnormally, use the POST /listKeys API instead."]
        #[serde(rename = "sendKeyValue", default, skip_serializing_if = "Option::is_none")]
        pub send_key_value: Option<String>,
        #[doc = "The suffix for the service bus endpoint. By default this is .servicebus.windows.net"]
        #[serde(rename = "serviceBusSuffix", default, skip_serializing_if = "Option::is_none")]
        pub service_bus_suffix: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HybridConnectionKey {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "HybridConnectionKey resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hybrid_connection_key::Properties>,
}
impl HybridConnectionKey {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hybrid_connection_key {
    use super::*;
    #[doc = "HybridConnectionKey resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The name of the send key."]
        #[serde(rename = "sendKeyName", default, skip_serializing_if = "Option::is_none")]
        pub send_key_name: Option<String>,
        #[doc = "The value of the send key."]
        #[serde(rename = "sendKeyValue", default, skip_serializing_if = "Option::is_none")]
        pub send_key_value: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "A domain specific resource identifier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Identifier {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "Identifier resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<identifier::Properties>,
}
impl Identifier {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identifier {
    use super::*;
    #[doc = "Identifier resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "String representation of the identity."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of identifiers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IdentifierCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<Identifier>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IdentifierCollection {
    pub fn new(value: Vec<Identifier>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "IP security restriction on an app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpSecurityRestriction {
    #[doc = "IP address the security restriction is valid for."]
    #[serde(rename = "ipAddress")]
    pub ip_address: String,
    #[doc = "Subnet mask for the range of IP addresses the restriction is valid for."]
    #[serde(rename = "subnetMask", default, skip_serializing_if = "Option::is_none")]
    pub subnet_mask: Option<String>,
}
impl IpSecurityRestriction {
    pub fn new(ip_address: String) -> Self {
        Self {
            ip_address,
            subnet_mask: None,
        }
    }
}
#[doc = "Localizable string object containing the name and a localized value."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalizableString {
    #[doc = "Non-localized name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "Localized name."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl LocalizableString {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "MSDeploy ARM PUT information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeploy {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "MSDeploy ARM PUT core information"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MsDeployCore>,
}
impl MsDeploy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "MSDeploy ARM PUT core information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeployCore {
    #[doc = "Package URI"]
    #[serde(rename = "packageUri", default, skip_serializing_if = "Option::is_none")]
    pub package_uri: Option<String>,
    #[doc = "SQL Connection String"]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[doc = "Database Type"]
    #[serde(rename = "dbType", default, skip_serializing_if = "Option::is_none")]
    pub db_type: Option<String>,
    #[doc = "URI of MSDeploy Parameters file. Must not be set if SetParameters is used."]
    #[serde(rename = "setParametersXmlFileUri", default, skip_serializing_if = "Option::is_none")]
    pub set_parameters_xml_file_uri: Option<String>,
    #[doc = "MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used."]
    #[serde(rename = "setParameters", default, skip_serializing_if = "Option::is_none")]
    pub set_parameters: Option<serde_json::Value>,
    #[doc = "Controls whether the MSDeploy operation skips the App_Data directory.\nIf set to <code>true</code>, the existing App_Data directory on the destination\nwill not be deleted, and any App_Data directory in the source will be ignored.\nSetting is <code>false</code> by default."]
    #[serde(rename = "skipAppData", default, skip_serializing_if = "Option::is_none")]
    pub skip_app_data: Option<bool>,
    #[doc = "Sets the AppOffline rule while the MSDeploy operation executes.\nSetting is <code>false</code> by default."]
    #[serde(rename = "appOffline", default, skip_serializing_if = "Option::is_none")]
    pub app_offline: Option<bool>,
}
impl MsDeployCore {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "MSDeploy log"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeployLog {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "MSDeployLog resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ms_deploy_log::Properties>,
}
impl MsDeployLog {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ms_deploy_log {
    use super::*;
    #[doc = "MSDeployLog resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "List of log entry messages"]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub entries: Vec<MsDeployLogEntry>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "MSDeploy log entry"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeployLogEntry {
    #[doc = "Timestamp of log entry"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[doc = "Log entry type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<ms_deploy_log_entry::Type>,
    #[doc = "Log entry message"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl MsDeployLogEntry {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ms_deploy_log_entry {
    use super::*;
    #[doc = "Log entry type"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Message,
        Warning,
        Error,
    }
}
#[doc = "MSDeploy ARM response"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeployStatus {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "MSDeployStatus resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ms_deploy_status::Properties>,
}
impl MsDeployStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ms_deploy_status {
    use super::*;
    #[doc = "MSDeployStatus resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Username of deployer"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub deployer: Option<String>,
        #[doc = "Provisioning state"]
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[doc = "Start time of deploy operation"]
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[doc = "End time of deploy operation"]
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[doc = "Whether the deployment operation has completed"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub complete: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Provisioning state"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            #[serde(rename = "accepted")]
            Accepted,
            #[serde(rename = "running")]
            Running,
            #[serde(rename = "succeeded")]
            Succeeded,
            #[serde(rename = "failed")]
            Failed,
            #[serde(rename = "canceled")]
            Canceled,
        }
    }
}
#[doc = "Managed service identity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedServiceIdentity {
    #[doc = "Type of managed service identity."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<managed_service_identity::Type>,
    #[doc = "Tenant of managed service identity."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "Principal Id of managed service identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
}
impl ManagedServiceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_service_identity {
    use super::*;
    #[doc = "Type of managed service identity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[doc = "MySQL migration request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrateMySqlRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "MigrateMySqlRequest resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<migrate_my_sql_request::Properties>,
}
impl MigrateMySqlRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod migrate_my_sql_request {
    use super::*;
    #[doc = "MigrateMySqlRequest resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[doc = "Connection string to the remote MySQL database."]
        #[serde(rename = "connectionString")]
        pub connection_string: String,
        #[doc = "The type of migration operation to be done"]
        #[serde(rename = "migrationType")]
        pub migration_type: properties::MigrationType,
    }
    impl Properties {
        pub fn new(connection_string: String, migration_type: properties::MigrationType) -> Self {
            Self {
                connection_string,
                migration_type,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "The type of migration operation to be done"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum MigrationType {
            LocalToRemote,
            RemoteToLocal,
        }
    }
}
#[doc = "MySQL migration status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrateMySqlStatus {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "MigrateMySqlStatus resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<migrate_my_sql_status::Properties>,
}
impl MigrateMySqlStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod migrate_my_sql_status {
    use super::*;
    #[doc = "MigrateMySqlStatus resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Status of the migration task."]
        #[serde(rename = "migrationOperationStatus", default, skip_serializing_if = "Option::is_none")]
        pub migration_operation_status: Option<properties::MigrationOperationStatus>,
        #[doc = "Operation ID for the migration task."]
        #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
        pub operation_id: Option<String>,
        #[doc = "True if the web app has in app MySql enabled"]
        #[serde(rename = "localMySqlEnabled", default, skip_serializing_if = "Option::is_none")]
        pub local_my_sql_enabled: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Status of the migration task."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum MigrationOperationStatus {
            InProgress,
            Failed,
            Succeeded,
            TimedOut,
            Created,
        }
    }
}
#[doc = "Name value pair."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameValuePair {
    #[doc = "Pair name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Pair value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl NameValuePair {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Full view of network features for an app (presently VNET integration and Hybrid Connections)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkFeatures {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "NetworkFeatures resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<network_features::Properties>,
}
impl NetworkFeatures {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_features {
    use super::*;
    #[doc = "NetworkFeatures resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The Virtual Network name."]
        #[serde(rename = "virtualNetworkName", default, skip_serializing_if = "Option::is_none")]
        pub virtual_network_name: Option<String>,
        #[doc = "Virtual Network information contract."]
        #[serde(rename = "virtualNetworkConnection", default, skip_serializing_if = "Option::is_none")]
        pub virtual_network_connection: Option<VnetInfo>,
        #[doc = "The Hybrid Connections summary view."]
        #[serde(rename = "hybridConnections", default, skip_serializing_if = "Vec::is_empty")]
        pub hybrid_connections: Vec<RelayServiceConnectionEntity>,
        #[doc = "The Hybrid Connection V2 (Service Bus) view."]
        #[serde(rename = "hybridConnectionsV2", default, skip_serializing_if = "Vec::is_empty")]
        pub hybrid_connections_v2: Vec<HybridConnection>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "An operation on a resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Operation name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The current status of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<operation::Status>,
    #[doc = "Any errors associate with the operation."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ErrorEntity>,
    #[doc = "Time when operation has started."]
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[doc = "Time when operation has been updated."]
    #[serde(rename = "modifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub modified_time: Option<String>,
    #[doc = "Time when operation will expire."]
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[doc = "Applicable only for stamp operation ids."]
    #[serde(rename = "geoMasterOperationId", default, skip_serializing_if = "Option::is_none")]
    pub geo_master_operation_id: Option<String>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "The current status of the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Failed,
        Succeeded,
        TimedOut,
        Created,
    }
}
#[doc = "Collection of performance monitor counters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PerfMonCounterCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<PerfMonResponse>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PerfMonCounterCollection {
    pub fn new(value: Vec<PerfMonResponse>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Performance monitor API response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerfMonResponse {
    #[doc = "The response code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "Metric information."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<PerfMonSet>,
}
impl PerfMonResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Performance monitor sample in a set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerfMonSample {
    #[doc = "Point in time for which counter was measured."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[doc = "Name of the server on which the measurement is made."]
    #[serde(rename = "instanceName", default, skip_serializing_if = "Option::is_none")]
    pub instance_name: Option<String>,
    #[doc = "Value of counter at a certain time."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
    #[doc = "Core Count of worker. Not a data member"]
    #[serde(rename = "coreCount", default, skip_serializing_if = "Option::is_none")]
    pub core_count: Option<i32>,
}
impl PerfMonSample {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metric information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerfMonSet {
    #[doc = "Unique key name of the counter."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Start time of the period."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "End time of the period."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "Presented time grain."]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[doc = "Collection of workers that are active during this time."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<PerfMonSample>,
}
impl PerfMonSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Premier add-on."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PremierAddOn {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "PremierAddOn resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<premier_add_on::Properties>,
}
impl PremierAddOn {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod premier_add_on {
    use super::*;
    #[doc = "PremierAddOn resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Premier add on SKU."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub sku: Option<String>,
        #[doc = "Premier add on Product."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub product: Option<String>,
        #[doc = "Premier add on Vendor."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub vendor: Option<String>,
        #[doc = "Premier add on Name."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "Premier add on Location."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub location: Option<String>,
        #[doc = "Premier add on Tags."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub tags: Option<serde_json::Value>,
        #[doc = "Premier add on Marketplace publisher."]
        #[serde(rename = "marketplacePublisher", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_publisher: Option<String>,
        #[doc = "Premier add on Marketplace offer."]
        #[serde(rename = "marketplaceOffer", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_offer: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Process Information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "ProcessInfo resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<process_info::Properties>,
}
impl ProcessInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod process_info {
    use super::*;
    #[doc = "ProcessInfo resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "ARM Identifier for deployment."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<i32>,
        #[doc = "Deployment name."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "HRef URI."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub href: Option<String>,
        #[doc = "Minidump URI."]
        #[serde(rename = "miniDump", default, skip_serializing_if = "Option::is_none")]
        pub mini_dump: Option<String>,
        #[doc = "Is profile running?"]
        #[serde(rename = "isProfileRunning", default, skip_serializing_if = "Option::is_none")]
        pub is_profile_running: Option<bool>,
        #[doc = "Is the IIS Profile running?"]
        #[serde(rename = "isIisProfileRunning", default, skip_serializing_if = "Option::is_none")]
        pub is_iis_profile_running: Option<bool>,
        #[doc = "IIS Profile timeout (seconds)."]
        #[serde(rename = "iisProfileTimeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
        pub iis_profile_timeout_in_seconds: Option<f64>,
        #[doc = "Parent process."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub parent: Option<String>,
        #[doc = "Child process list."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub children: Vec<String>,
        #[doc = "Thread list."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub threads: Vec<ProcessThreadInfo>,
        #[doc = "List of open files."]
        #[serde(rename = "openFileHandles", default, skip_serializing_if = "Vec::is_empty")]
        pub open_file_handles: Vec<String>,
        #[doc = "List of modules."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub modules: Vec<ProcessModuleInfo>,
        #[doc = "File name of this process."]
        #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
        pub file_name: Option<String>,
        #[doc = "Command line."]
        #[serde(rename = "commandLine", default, skip_serializing_if = "Option::is_none")]
        pub command_line: Option<String>,
        #[doc = "User name."]
        #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
        pub user_name: Option<String>,
        #[doc = "Handle count."]
        #[serde(rename = "handleCount", default, skip_serializing_if = "Option::is_none")]
        pub handle_count: Option<i32>,
        #[doc = "Module count."]
        #[serde(rename = "moduleCount", default, skip_serializing_if = "Option::is_none")]
        pub module_count: Option<i32>,
        #[doc = "Thread count."]
        #[serde(rename = "threadCount", default, skip_serializing_if = "Option::is_none")]
        pub thread_count: Option<i32>,
        #[doc = "Start time."]
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[doc = "Total CPU time."]
        #[serde(rename = "totalProcessorTime", default, skip_serializing_if = "Option::is_none")]
        pub total_processor_time: Option<String>,
        #[doc = "User CPU time."]
        #[serde(rename = "userProcessorTime", default, skip_serializing_if = "Option::is_none")]
        pub user_processor_time: Option<String>,
        #[doc = "Privileged CPU time."]
        #[serde(rename = "privilegedProcessorTime", default, skip_serializing_if = "Option::is_none")]
        pub privileged_processor_time: Option<String>,
        #[doc = "Working set."]
        #[serde(rename = "workingSet64", default, skip_serializing_if = "Option::is_none")]
        pub working_set64: Option<i64>,
        #[doc = "Peak working set."]
        #[serde(rename = "peakWorkingSet64", default, skip_serializing_if = "Option::is_none")]
        pub peak_working_set64: Option<i64>,
        #[doc = "Private memory size."]
        #[serde(rename = "privateMemorySize64", default, skip_serializing_if = "Option::is_none")]
        pub private_memory_size64: Option<i64>,
        #[doc = "Virtual memory size."]
        #[serde(rename = "virtualMemorySize64", default, skip_serializing_if = "Option::is_none")]
        pub virtual_memory_size64: Option<i64>,
        #[doc = "Peak virtual memory usage."]
        #[serde(rename = "peakVirtualMemorySize64", default, skip_serializing_if = "Option::is_none")]
        pub peak_virtual_memory_size64: Option<i64>,
        #[doc = "Paged system memory."]
        #[serde(rename = "pagedSystemMemorySize64", default, skip_serializing_if = "Option::is_none")]
        pub paged_system_memory_size64: Option<i64>,
        #[doc = "Non-paged system memory."]
        #[serde(rename = "nonpagedSystemMemorySize64", default, skip_serializing_if = "Option::is_none")]
        pub nonpaged_system_memory_size64: Option<i64>,
        #[doc = "Paged memory."]
        #[serde(rename = "pagedMemorySize64", default, skip_serializing_if = "Option::is_none")]
        pub paged_memory_size64: Option<i64>,
        #[doc = "Peak paged memory."]
        #[serde(rename = "peakPagedMemorySize64", default, skip_serializing_if = "Option::is_none")]
        pub peak_paged_memory_size64: Option<i64>,
        #[doc = "Time stamp."]
        #[serde(rename = "timeStamp", default, skip_serializing_if = "Option::is_none")]
        pub time_stamp: Option<String>,
        #[doc = "List of environment variables."]
        #[serde(rename = "environmentVariables", default, skip_serializing_if = "Option::is_none")]
        pub environment_variables: Option<serde_json::Value>,
        #[doc = "Is this the SCM site?"]
        #[serde(rename = "isScmSite", default, skip_serializing_if = "Option::is_none")]
        pub is_scm_site: Option<bool>,
        #[doc = "Is this a Web Job?"]
        #[serde(rename = "isWebJob", default, skip_serializing_if = "Option::is_none")]
        pub is_web_job: Option<bool>,
        #[doc = "Description of process."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of Kudu process information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProcessInfoCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<ProcessInfo>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProcessInfoCollection {
    pub fn new(value: Vec<ProcessInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Process Module Information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessModuleInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "ProcessModuleInfo resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<process_module_info::Properties>,
}
impl ProcessModuleInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod process_module_info {
    use super::*;
    #[doc = "ProcessModuleInfo resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Base address. Used as module identifier in ARM resource URI."]
        #[serde(rename = "baseAddress", default, skip_serializing_if = "Option::is_none")]
        pub base_address: Option<String>,
        #[doc = "File name."]
        #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
        pub file_name: Option<String>,
        #[doc = "HRef URI."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub href: Option<String>,
        #[doc = "File path."]
        #[serde(rename = "filePath", default, skip_serializing_if = "Option::is_none")]
        pub file_path: Option<String>,
        #[doc = "Module memory size."]
        #[serde(rename = "moduleMemorySize", default, skip_serializing_if = "Option::is_none")]
        pub module_memory_size: Option<i32>,
        #[doc = "File version."]
        #[serde(rename = "fileVersion", default, skip_serializing_if = "Option::is_none")]
        pub file_version: Option<String>,
        #[doc = "File description."]
        #[serde(rename = "fileDescription", default, skip_serializing_if = "Option::is_none")]
        pub file_description: Option<String>,
        #[doc = "Product name."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub product: Option<String>,
        #[doc = "Product version."]
        #[serde(rename = "productVersion", default, skip_serializing_if = "Option::is_none")]
        pub product_version: Option<String>,
        #[doc = "Is debug?"]
        #[serde(rename = "isDebug", default, skip_serializing_if = "Option::is_none")]
        pub is_debug: Option<bool>,
        #[doc = "Module language (locale)."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub language: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of Kudu thread information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProcessModuleInfoCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<ProcessModuleInfo>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProcessModuleInfoCollection {
    pub fn new(value: Vec<ProcessModuleInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Process Thread Information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessThreadInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "ProcessThreadInfo resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<process_thread_info::Properties>,
}
impl ProcessThreadInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod process_thread_info {
    use super::*;
    #[doc = "ProcessThreadInfo resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "ARM Identifier for deployment."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<i32>,
        #[doc = "HRef URI."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub href: Option<String>,
        #[doc = "Process URI."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub process: Option<String>,
        #[doc = "Start address."]
        #[serde(rename = "startAddress", default, skip_serializing_if = "Option::is_none")]
        pub start_address: Option<String>,
        #[doc = "Current thread priority."]
        #[serde(rename = "currentPriority", default, skip_serializing_if = "Option::is_none")]
        pub current_priority: Option<i32>,
        #[doc = "Thread priority level."]
        #[serde(rename = "priorityLevel", default, skip_serializing_if = "Option::is_none")]
        pub priority_level: Option<String>,
        #[doc = "Base priority."]
        #[serde(rename = "basePriority", default, skip_serializing_if = "Option::is_none")]
        pub base_priority: Option<i32>,
        #[doc = "Start time."]
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[doc = "Total processor time."]
        #[serde(rename = "totalProcessorTime", default, skip_serializing_if = "Option::is_none")]
        pub total_processor_time: Option<String>,
        #[doc = "User processor time."]
        #[serde(rename = "userProcessorTime", default, skip_serializing_if = "Option::is_none")]
        pub user_processor_time: Option<String>,
        #[doc = "Privileged processor time."]
        #[serde(rename = "priviledgedProcessorTime", default, skip_serializing_if = "Option::is_none")]
        pub priviledged_processor_time: Option<String>,
        #[doc = "Thread state."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<String>,
        #[doc = "Wait reason."]
        #[serde(rename = "waitReason", default, skip_serializing_if = "Option::is_none")]
        pub wait_reason: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of Kudu thread information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProcessThreadInfoCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<ProcessThreadInfo>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProcessThreadInfoCollection {
    pub fn new(value: Vec<ProcessThreadInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Azure proxy only resource. This resource is not tracked by Azure Resource Manager."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyOnlyResource {
    #[doc = "Resource Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource Name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Kind of resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ProxyOnlyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Public certificate object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicCertificate {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "PublicCertificate resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<public_certificate::Properties>,
}
impl PublicCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_certificate {
    use super::*;
    #[doc = "PublicCertificate resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Public Certificate byte array"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub blob: Option<String>,
        #[doc = "Public Certificate Location"]
        #[serde(rename = "publicCertificateLocation", default, skip_serializing_if = "Option::is_none")]
        pub public_certificate_location: Option<properties::PublicCertificateLocation>,
        #[doc = "Certificate Thumbprint"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Public Certificate Location"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum PublicCertificateLocation {
            CurrentUserMy,
            LocalMachineMy,
            Unknown,
        }
    }
}
#[doc = "Collection of public certificates"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PublicCertificateCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<PublicCertificate>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PublicCertificateCollection {
    pub fn new(value: Vec<PublicCertificate>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Push settings for the App."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PushSettings {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "PushSettings resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<push_settings::Properties>,
}
impl PushSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod push_settings {
    use super::*;
    #[doc = "PushSettings resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[doc = "Gets or sets a flag indicating whether the Push endpoint is enabled."]
        #[serde(rename = "isPushEnabled")]
        pub is_push_enabled: bool,
        #[doc = "Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint."]
        #[serde(rename = "tagWhitelistJson", default, skip_serializing_if = "Option::is_none")]
        pub tag_whitelist_json: Option<String>,
        #[doc = "Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.\nTags can consist of alphanumeric characters and the following:\n'_', '@', '#', '.', ':', '-'. \nValidation should be performed at the PushRequestHandler."]
        #[serde(rename = "tagsRequiringAuth", default, skip_serializing_if = "Option::is_none")]
        pub tags_requiring_auth: Option<String>,
        #[doc = "Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint."]
        #[serde(rename = "dynamicTagsJson", default, skip_serializing_if = "Option::is_none")]
        pub dynamic_tags_json: Option<String>,
    }
    impl Properties {
        pub fn new(is_push_enabled: bool) -> Self {
            Self {
                is_push_enabled,
                tag_whitelist_json: None,
                tags_requiring_auth: None,
                dynamic_tags_json: None,
            }
        }
    }
}
#[doc = "Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RampUpRule {
    #[doc = "Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net."]
    #[serde(rename = "actionHostName", default, skip_serializing_if = "Option::is_none")]
    pub action_host_name: Option<String>,
    #[doc = "Percentage of the traffic which will be redirected to <code>ActionHostName</code>."]
    #[serde(rename = "reroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub reroute_percentage: Option<f64>,
    #[doc = "In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \n<code>MinReroutePercentage</code> or <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\nCustom decision algorithm can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>."]
    #[serde(rename = "changeStep", default, skip_serializing_if = "Option::is_none")]
    pub change_step: Option<f64>,
    #[doc = "Specifies interval in minutes to reevaluate ReroutePercentage."]
    #[serde(rename = "changeIntervalInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub change_interval_in_minutes: Option<i32>,
    #[doc = "Specifies lower boundary above which ReroutePercentage will stay."]
    #[serde(rename = "minReroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub min_reroute_percentage: Option<f64>,
    #[doc = "Specifies upper boundary below which ReroutePercentage will stay."]
    #[serde(rename = "maxReroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub max_reroute_percentage: Option<f64>,
    #[doc = "Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.\nhttps://www.siteextensions.net/packages/TiPCallback/"]
    #[serde(rename = "changeDecisionCallbackUrl", default, skip_serializing_if = "Option::is_none")]
    pub change_decision_callback_url: Option<String>,
    #[doc = "Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl RampUpRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hybrid Connection for an App Service app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RelayServiceConnectionEntity {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "RelayServiceConnectionEntity resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<relay_service_connection_entity::Properties>,
}
impl RelayServiceConnectionEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod relay_service_connection_entity {
    use super::*;
    #[doc = "RelayServiceConnectionEntity resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "entityName", default, skip_serializing_if = "Option::is_none")]
        pub entity_name: Option<String>,
        #[serde(rename = "entityConnectionString", default, skip_serializing_if = "Option::is_none")]
        pub entity_connection_string: Option<String>,
        #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
        pub resource_type: Option<String>,
        #[serde(rename = "resourceConnectionString", default, skip_serializing_if = "Option::is_none")]
        pub resource_connection_string: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub hostname: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub port: Option<i32>,
        #[serde(rename = "biztalkUri", default, skip_serializing_if = "Option::is_none")]
        pub biztalk_uri: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Trigger based on total requests."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestsBasedTrigger {
    #[doc = "Request Count."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[doc = "Time interval."]
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl RequestsBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure resource. This resource is tracked in Azure Resource Manager"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "Resource Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource Name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Kind of resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Resource Location."]
    pub location: String,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            kind: None,
            location,
            type_: None,
            tags: None,
        }
    }
}
#[doc = "Object representing a metric for any resource ."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetric {
    #[doc = "Name of a metric for any resource ."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<ResourceMetricName>,
    #[doc = "Metric unit."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[doc = "Metric granularity. E.g PT1H, PT5M, P1D"]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[doc = "Metric start time."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "Metric end time."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "Metric resource Id."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "Resource Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Metric values."]
    #[serde(rename = "metricValues", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_values: Vec<ResourceMetricValue>,
    #[doc = "Resource metric properties collection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<ResourceMetricProperty>,
}
impl ResourceMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metrics availability and retention."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricAvailability {
    #[doc = "Time grain ."]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[doc = "Retention period for the current time grain."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
}
impl ResourceMetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of metric responses."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceMetricCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<ResourceMetric>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceMetricCollection {
    pub fn new(value: Vec<ResourceMetric>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Metadata for the metrics."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricDefinition {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "ResourceMetricDefinition resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<resource_metric_definition::Properties>,
}
impl ResourceMetricDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_metric_definition {
    use super::*;
    #[doc = "ResourceMetricDefinition resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Name of a metric for any resource ."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<ResourceMetricName>,
        #[doc = "Unit of the metric."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub unit: Option<String>,
        #[doc = "Primary aggregation type."]
        #[serde(rename = "primaryAggregationType", default, skip_serializing_if = "Option::is_none")]
        pub primary_aggregation_type: Option<String>,
        #[doc = "List of time grains supported for the metric together with retention period."]
        #[serde(rename = "metricAvailabilities", default, skip_serializing_if = "Vec::is_empty")]
        pub metric_availabilities: Vec<ResourceMetricAvailability>,
        #[doc = "Resource URI."]
        #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
        pub resource_uri: Option<String>,
        #[doc = "Resource ID."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
        #[doc = "Resource metric definition properties."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub properties: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of metric definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceMetricDefinitionCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<ResourceMetricDefinition>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceMetricDefinitionCollection {
    pub fn new(value: Vec<ResourceMetricDefinition>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Name of a metric for any resource ."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricName {
    #[doc = "metric name value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "Localized metric name value."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl ResourceMetricName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Resource metric property."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricProperty {
    #[doc = "Key for resource metric property."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[doc = "Value of pair."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ResourceMetricProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Value of resource metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricValue {
    #[doc = "Value timestamp."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[doc = "Value average."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub average: Option<f32>,
    #[doc = "Value minimum."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f32>,
    #[doc = "Value maximum."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f32>,
    #[doc = "Value total."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<f32>,
    #[doc = "Value count."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<f32>,
    #[doc = "Resource metric properties collection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<ResourceMetricProperty>,
}
impl ResourceMetricValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Description of a restore request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestoreRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "RestoreRequest resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<restore_request::Properties>,
}
impl RestoreRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod restore_request {
    use super::*;
    #[doc = "RestoreRequest resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[doc = "SAS URL to the container."]
        #[serde(rename = "storageAccountUrl")]
        pub storage_account_url: String,
        #[doc = "Name of a blob which contains the backup."]
        #[serde(rename = "blobName", default, skip_serializing_if = "Option::is_none")]
        pub blob_name: Option<String>,
        #[doc = "<code>true</code> if the restore operation can overwrite target app; otherwise, <code>false</code>. <code>true</code> is needed if trying to restore over an existing app."]
        pub overwrite: bool,
        #[doc = "Name of an app."]
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[doc = "Collection of databases which should be restored. This list has to match the list of databases included in the backup."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub databases: Vec<DatabaseBackupSetting>,
        #[doc = "Changes a logic when restoring an app with custom domains. <code>true</code> to remove custom domains automatically. If <code>false</code>, custom domains are added to \nthe app's object when it is being restored, but that might fail due to conflicts during the operation."]
        #[serde(rename = "ignoreConflictingHostNames", default, skip_serializing_if = "Option::is_none")]
        pub ignore_conflicting_host_names: Option<bool>,
        #[doc = "Ignore the databases and only restore the site content"]
        #[serde(rename = "ignoreDatabases", default, skip_serializing_if = "Option::is_none")]
        pub ignore_databases: Option<bool>,
        #[doc = "Specify app service plan that will own restored site."]
        #[serde(rename = "appServicePlan", default, skip_serializing_if = "Option::is_none")]
        pub app_service_plan: Option<String>,
        #[doc = "Operation type."]
        #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
        pub operation_type: Option<properties::OperationType>,
        #[doc = "<code>true</code> if SiteConfig.ConnectionStrings should be set in new app; otherwise, <code>false</code>."]
        #[serde(rename = "adjustConnectionStrings", default, skip_serializing_if = "Option::is_none")]
        pub adjust_connection_strings: Option<bool>,
        #[doc = "App Service Environment name, if needed (only when restoring an app to an App Service Environment)."]
        #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment: Option<String>,
    }
    impl Properties {
        pub fn new(storage_account_url: String, overwrite: bool) -> Self {
            Self {
                storage_account_url,
                blob_name: None,
                overwrite,
                site_name: None,
                databases: Vec::new(),
                ignore_conflicting_host_names: None,
                ignore_databases: None,
                app_service_plan: None,
                operation_type: None,
                adjust_connection_strings: None,
                hosting_environment: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Operation type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum OperationType {
            Default,
            Clone,
            Relocation,
            Snapshot,
        }
        impl Default for OperationType {
            fn default() -> Self {
                Self::Default
            }
        }
    }
}
#[doc = "Response for an app restore request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestoreResponse {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "RestoreResponse resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<restore_response::Properties>,
}
impl RestoreResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod restore_response {
    use super::*;
    #[doc = "RestoreResponse resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "When server starts the restore process, it will return an operation ID identifying that particular restore operation."]
        #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
        pub operation_id: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "A web app, a mobile app backend, or an API app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Site {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Site resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site::Properties>,
    #[doc = "Managed service identity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
}
impl Site {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            identity: None,
        }
    }
}
pub mod site {
    use super::*;
    #[doc = "Site resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Current state of the app."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<String>,
        #[doc = "Hostnames associated with the app."]
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[doc = "Name of the repository site."]
        #[serde(rename = "repositorySiteName", default, skip_serializing_if = "Option::is_none")]
        pub repository_site_name: Option<String>,
        #[doc = "State indicating whether the app has exceeded its quota usage. Read-only."]
        #[serde(rename = "usageState", default, skip_serializing_if = "Option::is_none")]
        pub usage_state: Option<properties::UsageState>,
        #[doc = "<code>true</code> if the app is enabled; otherwise, <code>false</code>. Setting this value to false disables the app (takes the app offline)."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[doc = "Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise,\nthe app is not served on those hostnames."]
        #[serde(rename = "enabledHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub enabled_host_names: Vec<String>,
        #[doc = "Management information availability state for the app."]
        #[serde(rename = "availabilityState", default, skip_serializing_if = "Option::is_none")]
        pub availability_state: Option<properties::AvailabilityState>,
        #[doc = "Hostname SSL states are used to manage the SSL bindings for app's hostnames."]
        #[serde(rename = "hostNameSslStates", default, skip_serializing_if = "Vec::is_empty")]
        pub host_name_ssl_states: Vec<HostNameSslState>,
        #[doc = "Resource ID of the associated App Service plan, formatted as: \"/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}\"."]
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
        #[doc = "<code>true</code> if reserved; otherwise, <code>false</code>."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reserved: Option<bool>,
        #[doc = "Last time the app was modified, in UTC. Read-only."]
        #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
        pub last_modified_time_utc: Option<String>,
        #[doc = "Configuration of an App Service app."]
        #[serde(rename = "siteConfig", default, skip_serializing_if = "Option::is_none")]
        pub site_config: Option<SiteConfig>,
        #[doc = "Azure Traffic Manager hostnames associated with the app. Read-only."]
        #[serde(rename = "trafficManagerHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub traffic_manager_host_names: Vec<String>,
        #[doc = "<code>true</code> to stop SCM (KUDU) site when the app is stopped; otherwise, <code>false</code>. The default is <code>false</code>."]
        #[serde(rename = "scmSiteAlsoStopped", default, skip_serializing_if = "Option::is_none")]
        pub scm_site_also_stopped: Option<bool>,
        #[doc = "Specifies which deployment slot this app will swap into. Read-only."]
        #[serde(rename = "targetSwapSlot", default, skip_serializing_if = "Option::is_none")]
        pub target_swap_slot: Option<String>,
        #[doc = "Specification for an App Service Environment to use for this resource."]
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[doc = "<code>true</code> to enable client affinity; <code>false</code> to stop sending session affinity cookies, which route client requests in the same session to the same instance. Default is <code>true</code>."]
        #[serde(rename = "clientAffinityEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_affinity_enabled: Option<bool>,
        #[doc = "<code>true</code> to enable client certificate authentication (TLS mutual authentication); otherwise, <code>false</code>. Default is <code>false</code>."]
        #[serde(rename = "clientCertEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_cert_enabled: Option<bool>,
        #[doc = "<code>true</code> to disable the public hostnames of the app; otherwise, <code>false</code>.\n If <code>true</code>, the app is only accessible via API management process."]
        #[serde(rename = "hostNamesDisabled", default, skip_serializing_if = "Option::is_none")]
        pub host_names_disabled: Option<bool>,
        #[doc = "List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants that site can be hosted with current settings. Read-only."]
        #[serde(rename = "outboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub outbound_ip_addresses: Option<String>,
        #[doc = "List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all tenants. Read-only."]
        #[serde(rename = "possibleOutboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub possible_outbound_ip_addresses: Option<String>,
        #[doc = "Size of the function container."]
        #[serde(rename = "containerSize", default, skip_serializing_if = "Option::is_none")]
        pub container_size: Option<i32>,
        #[doc = "Maximum allowed daily memory-time quota (applicable on dynamic apps only)."]
        #[serde(rename = "dailyMemoryTimeQuota", default, skip_serializing_if = "Option::is_none")]
        pub daily_memory_time_quota: Option<i32>,
        #[doc = "App suspended till in case memory-time quota is exceeded."]
        #[serde(rename = "suspendedTill", default, skip_serializing_if = "Option::is_none")]
        pub suspended_till: Option<String>,
        #[doc = "Maximum number of workers.\nThis only applies to Functions container."]
        #[serde(rename = "maxNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub max_number_of_workers: Option<i32>,
        #[doc = "Information needed for cloning operation."]
        #[serde(rename = "cloningInfo", default, skip_serializing_if = "Option::is_none")]
        pub cloning_info: Option<CloningInfo>,
        #[doc = "Details about app recovery operation."]
        #[serde(rename = "snapshotInfo", default, skip_serializing_if = "Option::is_none")]
        pub snapshot_info: Option<SnapshotRecoveryRequest>,
        #[doc = "Name of the resource group the app belongs to. Read-only."]
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[doc = "<code>true</code> if the app is a default container; otherwise, <code>false</code>."]
        #[serde(rename = "isDefaultContainer", default, skip_serializing_if = "Option::is_none")]
        pub is_default_container: Option<bool>,
        #[doc = "Default hostname of the app. Read-only."]
        #[serde(rename = "defaultHostName", default, skip_serializing_if = "Option::is_none")]
        pub default_host_name: Option<String>,
        #[doc = "The status of the last successful slot swap operation."]
        #[serde(rename = "slotSwapStatus", default, skip_serializing_if = "Option::is_none")]
        pub slot_swap_status: Option<SlotSwapStatus>,
        #[doc = "HttpsOnly: configures a web site to accept only https requests. Issues redirect for\nhttp requests"]
        #[serde(rename = "httpsOnly", default, skip_serializing_if = "Option::is_none")]
        pub https_only: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "State indicating whether the app has exceeded its quota usage. Read-only."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum UsageState {
            Normal,
            Exceeded,
        }
        #[doc = "Management information availability state for the app."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AvailabilityState {
            Normal,
            Limited,
            DisasterRecoveryMode,
        }
    }
}
#[doc = "Configuration settings for the Azure App Service Authentication / Authorization feature."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteAuthSettings {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SiteAuthSettings resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_auth_settings::Properties>,
}
impl SiteAuthSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_auth_settings {
    use super::*;
    #[doc = "SiteAuthSettings resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "<code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[doc = "The RuntimeVersion of the Authentication / Authorization feature in use for the current app.\nThe setting in this value can control the behavior of certain features in the Authentication / Authorization module."]
        #[serde(rename = "runtimeVersion", default, skip_serializing_if = "Option::is_none")]
        pub runtime_version: Option<String>,
        #[doc = "The action to take when an unauthenticated client attempts to access the app."]
        #[serde(rename = "unauthenticatedClientAction", default, skip_serializing_if = "Option::is_none")]
        pub unauthenticated_client_action: Option<properties::UnauthenticatedClientAction>,
        #[doc = "<code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.\n The default is <code>false</code>."]
        #[serde(rename = "tokenStoreEnabled", default, skip_serializing_if = "Option::is_none")]
        pub token_store_enabled: Option<bool>,
        #[doc = "External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.\nThis is an advanced setting typically only needed by Windows Store application backends.\nNote that URLs within the current domain are always implicitly allowed."]
        #[serde(rename = "allowedExternalRedirectUrls", default, skip_serializing_if = "Vec::is_empty")]
        pub allowed_external_redirect_urls: Vec<String>,
        #[doc = "The default authentication provider to use when multiple providers are configured.\nThis setting is only needed if multiple providers are configured and the unauthenticated client\naction is set to \"RedirectToLoginPage\"."]
        #[serde(rename = "defaultProvider", default, skip_serializing_if = "Option::is_none")]
        pub default_provider: Option<properties::DefaultProvider>,
        #[doc = "The number of hours after session token expiration that a session token can be used to\ncall the token refresh API. The default is 72 hours."]
        #[serde(rename = "tokenRefreshExtensionHours", default, skip_serializing_if = "Option::is_none")]
        pub token_refresh_extension_hours: Option<f64>,
        #[doc = "The Client ID of this relying party application, known as the client_id.\nThis setting is required for enabling OpenID Connection authentication with Azure Active Directory or \nother 3rd party OpenID Connect providers.\nMore information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html"]
        #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
        pub client_id: Option<String>,
        #[doc = "The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).\nThis setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.\nOtherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.\nMore information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html"]
        #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
        pub client_secret: Option<String>,
        #[doc = "The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.\nWhen using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.\nThis URI is a case-sensitive identifier for the token issuer.\nMore information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub issuer: Option<String>,
        #[doc = "Allowed audience values to consider when validating JWTs issued by \nAzure Active Directory. Note that the <code>ClientID</code> value is always considered an\nallowed audience, regardless of this setting."]
        #[serde(rename = "allowedAudiences", default, skip_serializing_if = "Vec::is_empty")]
        pub allowed_audiences: Vec<String>,
        #[doc = "Login parameters to send to the OpenID Connect authorization endpoint when\na user logs in. Each parameter must be in the form \"key=value\"."]
        #[serde(rename = "additionalLoginParams", default, skip_serializing_if = "Vec::is_empty")]
        pub additional_login_params: Vec<String>,
        #[doc = "The OpenID Connect Client ID for the Google web application.\nThis setting is required for enabling Google Sign-In.\nGoogle Sign-In documentation: https://developers.google.com/identity/sign-in/web/"]
        #[serde(rename = "googleClientId", default, skip_serializing_if = "Option::is_none")]
        pub google_client_id: Option<String>,
        #[doc = "The client secret associated with the Google web application.\nThis setting is required for enabling Google Sign-In.\nGoogle Sign-In documentation: https://developers.google.com/identity/sign-in/web/"]
        #[serde(rename = "googleClientSecret", default, skip_serializing_if = "Option::is_none")]
        pub google_client_secret: Option<String>,
        #[doc = "The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.\nThis setting is optional. If not specified, \"openid\", \"profile\", and \"email\" are used as default scopes.\nGoogle Sign-In documentation: https://developers.google.com/identity/sign-in/web/"]
        #[serde(rename = "googleOAuthScopes", default, skip_serializing_if = "Vec::is_empty")]
        pub google_o_auth_scopes: Vec<String>,
        #[doc = "The App ID of the Facebook app used for login.\nThis setting is required for enabling Facebook Login.\nFacebook Login documentation: https://developers.facebook.com/docs/facebook-login"]
        #[serde(rename = "facebookAppId", default, skip_serializing_if = "Option::is_none")]
        pub facebook_app_id: Option<String>,
        #[doc = "The App Secret of the Facebook app used for Facebook Login.\nThis setting is required for enabling Facebook Login.\nFacebook Login documentation: https://developers.facebook.com/docs/facebook-login"]
        #[serde(rename = "facebookAppSecret", default, skip_serializing_if = "Option::is_none")]
        pub facebook_app_secret: Option<String>,
        #[doc = "The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.\nThis setting is optional.\nFacebook Login documentation: https://developers.facebook.com/docs/facebook-login"]
        #[serde(rename = "facebookOAuthScopes", default, skip_serializing_if = "Vec::is_empty")]
        pub facebook_o_auth_scopes: Vec<String>,
        #[doc = "The OAuth 1.0a consumer key of the Twitter application used for sign-in.\nThis setting is required for enabling Twitter Sign-In.\nTwitter Sign-In documentation: https://dev.twitter.com/web/sign-in"]
        #[serde(rename = "twitterConsumerKey", default, skip_serializing_if = "Option::is_none")]
        pub twitter_consumer_key: Option<String>,
        #[doc = "The OAuth 1.0a consumer secret of the Twitter application used for sign-in.\nThis setting is required for enabling Twitter Sign-In.\nTwitter Sign-In documentation: https://dev.twitter.com/web/sign-in"]
        #[serde(rename = "twitterConsumerSecret", default, skip_serializing_if = "Option::is_none")]
        pub twitter_consumer_secret: Option<String>,
        #[doc = "The OAuth 2.0 client ID that was created for the app used for authentication.\nThis setting is required for enabling Microsoft Account authentication.\nMicrosoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm"]
        #[serde(rename = "microsoftAccountClientId", default, skip_serializing_if = "Option::is_none")]
        pub microsoft_account_client_id: Option<String>,
        #[doc = "The OAuth 2.0 client secret that was created for the app used for authentication.\nThis setting is required for enabling Microsoft Account authentication.\nMicrosoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm"]
        #[serde(rename = "microsoftAccountClientSecret", default, skip_serializing_if = "Option::is_none")]
        pub microsoft_account_client_secret: Option<String>,
        #[doc = "The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.\nThis setting is optional. If not specified, \"wl.basic\" is used as the default scope.\nMicrosoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx"]
        #[serde(rename = "microsoftAccountOAuthScopes", default, skip_serializing_if = "Vec::is_empty")]
        pub microsoft_account_o_auth_scopes: Vec<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "The action to take when an unauthenticated client attempts to access the app."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum UnauthenticatedClientAction {
            RedirectToLoginPage,
            AllowAnonymous,
        }
        #[doc = "The default authentication provider to use when multiple providers are configured.\nThis setting is only needed if multiple providers are configured and the unauthenticated client\naction is set to \"RedirectToLoginPage\"."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum DefaultProvider {
            AzureActiveDirectory,
            Facebook,
            Google,
            MicrosoftAccount,
            Twitter,
        }
    }
}
#[doc = "Represents whether or not an app is cloneable."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteCloneability {
    #[doc = "Name of app."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub result: Option<site_cloneability::Result>,
    #[doc = "List of features enabled on app that prevent cloning."]
    #[serde(rename = "blockingFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub blocking_features: Vec<SiteCloneabilityCriterion>,
    #[doc = "List of features enabled on app that are non-blocking but cannot be cloned. The app can still be cloned\nbut the features in this list will not be set up on cloned app."]
    #[serde(rename = "unsupportedFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub unsupported_features: Vec<SiteCloneabilityCriterion>,
    #[doc = "List of blocking application characteristics."]
    #[serde(rename = "blockingCharacteristics", default, skip_serializing_if = "Vec::is_empty")]
    pub blocking_characteristics: Vec<SiteCloneabilityCriterion>,
}
impl SiteCloneability {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_cloneability {
    use super::*;
    #[doc = "Name of app."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Result {
        Cloneable,
        PartiallyCloneable,
        NotCloneable,
    }
}
#[doc = "An app cloneability criterion."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteCloneabilityCriterion {
    #[doc = "Name of criterion."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Description of criterion."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl SiteCloneabilityCriterion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configuration of an App Service app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteConfig {
    #[doc = "Number of workers."]
    #[serde(rename = "numberOfWorkers", default, skip_serializing_if = "Option::is_none")]
    pub number_of_workers: Option<i32>,
    #[doc = "Default documents."]
    #[serde(rename = "defaultDocuments", default, skip_serializing_if = "Vec::is_empty")]
    pub default_documents: Vec<String>,
    #[doc = ".NET Framework version."]
    #[serde(rename = "netFrameworkVersion", default, skip_serializing_if = "Option::is_none")]
    pub net_framework_version: Option<String>,
    #[doc = "Version of PHP."]
    #[serde(rename = "phpVersion", default, skip_serializing_if = "Option::is_none")]
    pub php_version: Option<String>,
    #[doc = "Version of Python."]
    #[serde(rename = "pythonVersion", default, skip_serializing_if = "Option::is_none")]
    pub python_version: Option<String>,
    #[doc = "Version of Node.js."]
    #[serde(rename = "nodeVersion", default, skip_serializing_if = "Option::is_none")]
    pub node_version: Option<String>,
    #[doc = "Linux App Framework and version"]
    #[serde(rename = "linuxFxVersion", default, skip_serializing_if = "Option::is_none")]
    pub linux_fx_version: Option<String>,
    #[doc = "<code>true</code> if request tracing is enabled; otherwise, <code>false</code>."]
    #[serde(rename = "requestTracingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub request_tracing_enabled: Option<bool>,
    #[doc = "Request tracing expiration time."]
    #[serde(rename = "requestTracingExpirationTime", default, skip_serializing_if = "Option::is_none")]
    pub request_tracing_expiration_time: Option<String>,
    #[doc = "<code>true</code> if remote debugging is enabled; otherwise, <code>false</code>."]
    #[serde(rename = "remoteDebuggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub remote_debugging_enabled: Option<bool>,
    #[doc = "Remote debugging version."]
    #[serde(rename = "remoteDebuggingVersion", default, skip_serializing_if = "Option::is_none")]
    pub remote_debugging_version: Option<String>,
    #[doc = "<code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>."]
    #[serde(rename = "httpLoggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub http_logging_enabled: Option<bool>,
    #[doc = "HTTP logs directory size limit."]
    #[serde(rename = "logsDirectorySizeLimit", default, skip_serializing_if = "Option::is_none")]
    pub logs_directory_size_limit: Option<i32>,
    #[doc = "<code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>."]
    #[serde(rename = "detailedErrorLoggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub detailed_error_logging_enabled: Option<bool>,
    #[doc = "Publishing user name."]
    #[serde(rename = "publishingUsername", default, skip_serializing_if = "Option::is_none")]
    pub publishing_username: Option<String>,
    #[doc = "Application settings."]
    #[serde(rename = "appSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub app_settings: Vec<NameValuePair>,
    #[doc = "Connection strings."]
    #[serde(rename = "connectionStrings", default, skip_serializing_if = "Vec::is_empty")]
    pub connection_strings: Vec<ConnStringInfo>,
    #[doc = "MachineKey of an app."]
    #[serde(rename = "machineKey", default, skip_serializing_if = "Option::is_none")]
    pub machine_key: Option<SiteMachineKey>,
    #[doc = "Handler mappings."]
    #[serde(rename = "handlerMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub handler_mappings: Vec<HandlerMapping>,
    #[doc = "Document root."]
    #[serde(rename = "documentRoot", default, skip_serializing_if = "Option::is_none")]
    pub document_root: Option<String>,
    #[doc = "SCM type."]
    #[serde(rename = "scmType", default, skip_serializing_if = "Option::is_none")]
    pub scm_type: Option<site_config::ScmType>,
    #[doc = "<code>true</code> to use 32-bit worker process; otherwise, <code>false</code>."]
    #[serde(rename = "use32BitWorkerProcess", default, skip_serializing_if = "Option::is_none")]
    pub use32_bit_worker_process: Option<bool>,
    #[doc = "<code>true</code> if WebSocket is enabled; otherwise, <code>false</code>."]
    #[serde(rename = "webSocketsEnabled", default, skip_serializing_if = "Option::is_none")]
    pub web_sockets_enabled: Option<bool>,
    #[doc = "<code>true</code> if Always On is enabled; otherwise, <code>false</code>."]
    #[serde(rename = "alwaysOn", default, skip_serializing_if = "Option::is_none")]
    pub always_on: Option<bool>,
    #[doc = "Java version."]
    #[serde(rename = "javaVersion", default, skip_serializing_if = "Option::is_none")]
    pub java_version: Option<String>,
    #[doc = "Java container."]
    #[serde(rename = "javaContainer", default, skip_serializing_if = "Option::is_none")]
    pub java_container: Option<String>,
    #[doc = "Java container version."]
    #[serde(rename = "javaContainerVersion", default, skip_serializing_if = "Option::is_none")]
    pub java_container_version: Option<String>,
    #[doc = "App command line to launch."]
    #[serde(rename = "appCommandLine", default, skip_serializing_if = "Option::is_none")]
    pub app_command_line: Option<String>,
    #[doc = "Managed pipeline mode."]
    #[serde(rename = "managedPipelineMode", default, skip_serializing_if = "Option::is_none")]
    pub managed_pipeline_mode: Option<site_config::ManagedPipelineMode>,
    #[doc = "Virtual applications."]
    #[serde(rename = "virtualApplications", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_applications: Vec<VirtualApplication>,
    #[doc = "Site load balancing."]
    #[serde(rename = "loadBalancing", default, skip_serializing_if = "Option::is_none")]
    pub load_balancing: Option<site_config::LoadBalancing>,
    #[doc = "Routing rules in production experiments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub experiments: Option<Experiments>,
    #[doc = "Metric limits set on an app."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limits: Option<SiteLimits>,
    #[doc = "<code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>."]
    #[serde(rename = "autoHealEnabled", default, skip_serializing_if = "Option::is_none")]
    pub auto_heal_enabled: Option<bool>,
    #[doc = "Rules that can be defined for auto-heal."]
    #[serde(rename = "autoHealRules", default, skip_serializing_if = "Option::is_none")]
    pub auto_heal_rules: Option<AutoHealRules>,
    #[doc = "Tracing options."]
    #[serde(rename = "tracingOptions", default, skip_serializing_if = "Option::is_none")]
    pub tracing_options: Option<String>,
    #[doc = "Virtual Network name."]
    #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_name: Option<String>,
    #[doc = "Cross-Origin Resource Sharing (CORS) settings for the app."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cors: Option<CorsSettings>,
    #[doc = "Push settings for the App."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub push: Option<PushSettings>,
    #[doc = "Information about the formal API definition for the app."]
    #[serde(rename = "apiDefinition", default, skip_serializing_if = "Option::is_none")]
    pub api_definition: Option<ApiDefinitionInfo>,
    #[doc = "Auto-swap slot name."]
    #[serde(rename = "autoSwapSlotName", default, skip_serializing_if = "Option::is_none")]
    pub auto_swap_slot_name: Option<String>,
    #[doc = "<code>true</code> to enable local MySQL; otherwise, <code>false</code>."]
    #[serde(rename = "localMySqlEnabled", default, skip_serializing_if = "Option::is_none")]
    pub local_my_sql_enabled: Option<bool>,
    #[doc = "IP security restrictions."]
    #[serde(rename = "ipSecurityRestrictions", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_security_restrictions: Vec<IpSecurityRestriction>,
    #[doc = "Http20Enabled: configures a web site to allow clients to connect over http2.0"]
    #[serde(rename = "http20Enabled", default, skip_serializing_if = "Option::is_none")]
    pub http20_enabled: Option<bool>,
    #[doc = "MinTlsVersion: configures the minimum version of TLS required for SSL requests"]
    #[serde(rename = "minTlsVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_tls_version: Option<site_config::MinTlsVersion>,
}
impl SiteConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_config {
    use super::*;
    #[doc = "SCM type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScmType {
        None,
        Dropbox,
        Tfs,
        LocalGit,
        GitHub,
        CodePlexGit,
        CodePlexHg,
        BitbucketGit,
        BitbucketHg,
        ExternalGit,
        ExternalHg,
        OneDrive,
        #[serde(rename = "VSO")]
        Vso,
    }
    #[doc = "Managed pipeline mode."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ManagedPipelineMode {
        Integrated,
        Classic,
    }
    #[doc = "Site load balancing."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadBalancing {
        WeightedRoundRobin,
        LeastRequests,
        LeastResponseTime,
        WeightedTotalTraffic,
        RequestHash,
    }
    #[doc = "MinTlsVersion: configures the minimum version of TLS required for SSL requests"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MinTlsVersion {
        #[serde(rename = "1.0")]
        N1_0,
        #[serde(rename = "1.1")]
        N1_1,
        #[serde(rename = "1.2")]
        N1_2,
    }
}
#[doc = "Web app configuration ARM resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteConfigResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "Configuration of an App Service app."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SiteConfig>,
}
impl SiteConfigResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of site configurations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteConfigResourceCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<SiteConfigResource>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SiteConfigResourceCollection {
    pub fn new(value: Vec<SiteConfigResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "A snapshot of a web app configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteConfigurationSnapshotInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SiteConfigurationSnapshotInfo resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_configuration_snapshot_info::Properties>,
}
impl SiteConfigurationSnapshotInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_configuration_snapshot_info {
    use super::*;
    #[doc = "SiteConfigurationSnapshotInfo resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The time the snapshot was taken."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub time: Option<String>,
        #[doc = "The id of the snapshot"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<i32>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of metadata for the app configuration snapshots that can be restored."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteConfigurationSnapshotInfoCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<SiteConfigurationSnapshotInfo>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SiteConfigurationSnapshotInfoCollection {
    pub fn new(value: Vec<SiteConfigurationSnapshotInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Site Extension Information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteExtensionInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SiteExtensionInfo resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_extension_info::Properties>,
}
impl SiteExtensionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_extension_info {
    use super::*;
    #[doc = "SiteExtensionInfo resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Site extension ID."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
        #[doc = "Site extension title."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub title: Option<String>,
        #[doc = "Site extension type."]
        #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
        pub type_: Option<properties::Type>,
        #[doc = "Summary description."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub summary: Option<String>,
        #[doc = "Detailed description."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[doc = "Version information."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub version: Option<String>,
        #[doc = "Extension URL."]
        #[serde(rename = "extensionUrl", default, skip_serializing_if = "Option::is_none")]
        pub extension_url: Option<String>,
        #[doc = "Project URL."]
        #[serde(rename = "projectUrl", default, skip_serializing_if = "Option::is_none")]
        pub project_url: Option<String>,
        #[doc = "Icon URL."]
        #[serde(rename = "iconUrl", default, skip_serializing_if = "Option::is_none")]
        pub icon_url: Option<String>,
        #[doc = "License URL."]
        #[serde(rename = "licenseUrl", default, skip_serializing_if = "Option::is_none")]
        pub license_url: Option<String>,
        #[doc = "Feed URL."]
        #[serde(rename = "feedUrl", default, skip_serializing_if = "Option::is_none")]
        pub feed_url: Option<String>,
        #[doc = "List of authors."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub authors: Vec<String>,
        #[doc = "Installer command line parameters."]
        #[serde(rename = "installationArgs", default, skip_serializing_if = "Option::is_none")]
        pub installation_args: Option<String>,
        #[doc = "Published timestamp."]
        #[serde(rename = "publishedDateTime", default, skip_serializing_if = "Option::is_none")]
        pub published_date_time: Option<String>,
        #[doc = "Count of downloads."]
        #[serde(rename = "downloadCount", default, skip_serializing_if = "Option::is_none")]
        pub download_count: Option<i32>,
        #[doc = "<code>true</code> if the local version is the latest version; <code>false</code> otherwise."]
        #[serde(rename = "localIsLatestVersion", default, skip_serializing_if = "Option::is_none")]
        pub local_is_latest_version: Option<bool>,
        #[doc = "Local path."]
        #[serde(rename = "localPath", default, skip_serializing_if = "Option::is_none")]
        pub local_path: Option<String>,
        #[doc = "Installed timestamp."]
        #[serde(rename = "installedDateTime", default, skip_serializing_if = "Option::is_none")]
        pub installed_date_time: Option<String>,
        #[doc = "Provisioning state."]
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<String>,
        #[doc = "Site Extension comment."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub comment: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Site extension type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Type {
            Gallery,
            WebRoot,
        }
    }
}
#[doc = "Collection of Kudu site extension information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteExtensionInfoCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<SiteExtensionInfo>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SiteExtensionInfoCollection {
    pub fn new(value: Vec<SiteExtensionInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Instance of an app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteInstance {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SiteInstance resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_instance::Properties>,
}
impl SiteInstance {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_instance {
    use super::*;
    #[doc = "SiteInstance resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Name of instance."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Metric limits set on an app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteLimits {
    #[doc = "Maximum allowed CPU usage percentage."]
    #[serde(rename = "maxPercentageCpu", default, skip_serializing_if = "Option::is_none")]
    pub max_percentage_cpu: Option<f64>,
    #[doc = "Maximum allowed memory usage in MB."]
    #[serde(rename = "maxMemoryInMb", default, skip_serializing_if = "Option::is_none")]
    pub max_memory_in_mb: Option<i64>,
    #[doc = "Maximum allowed disk size usage in MB."]
    #[serde(rename = "maxDiskSizeInMb", default, skip_serializing_if = "Option::is_none")]
    pub max_disk_size_in_mb: Option<i64>,
}
impl SiteLimits {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configuration of App Service site logs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteLogsConfig {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SiteLogsConfig resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_logs_config::Properties>,
}
impl SiteLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_logs_config {
    use super::*;
    #[doc = "SiteLogsConfig resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Application logs configuration."]
        #[serde(rename = "applicationLogs", default, skip_serializing_if = "Option::is_none")]
        pub application_logs: Option<ApplicationLogsConfig>,
        #[doc = "Http logs configuration."]
        #[serde(rename = "httpLogs", default, skip_serializing_if = "Option::is_none")]
        pub http_logs: Option<HttpLogsConfig>,
        #[doc = "Enabled configuration."]
        #[serde(rename = "failedRequestsTracing", default, skip_serializing_if = "Option::is_none")]
        pub failed_requests_tracing: Option<EnabledConfig>,
        #[doc = "Enabled configuration."]
        #[serde(rename = "detailedErrorMessages", default, skip_serializing_if = "Option::is_none")]
        pub detailed_error_messages: Option<EnabledConfig>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "MachineKey of an app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteMachineKey {
    #[doc = "MachineKey validation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub validation: Option<String>,
    #[doc = "Validation key."]
    #[serde(rename = "validationKey", default, skip_serializing_if = "Option::is_none")]
    pub validation_key: Option<String>,
    #[doc = "Algorithm used for decryption."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub decryption: Option<String>,
    #[doc = "Decryption key."]
    #[serde(rename = "decryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub decryption_key: Option<String>,
}
impl SiteMachineKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ARM resource for a site."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SitePatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SitePatchResource resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_patch_resource::Properties>,
}
impl SitePatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_patch_resource {
    use super::*;
    #[doc = "SitePatchResource resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Current state of the app."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<String>,
        #[doc = "Hostnames associated with the app."]
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[doc = "Name of the repository site."]
        #[serde(rename = "repositorySiteName", default, skip_serializing_if = "Option::is_none")]
        pub repository_site_name: Option<String>,
        #[doc = "State indicating whether the app has exceeded its quota usage. Read-only."]
        #[serde(rename = "usageState", default, skip_serializing_if = "Option::is_none")]
        pub usage_state: Option<properties::UsageState>,
        #[doc = "<code>true</code> if the app is enabled; otherwise, <code>false</code>. Setting this value to false disables the app (takes the app offline)."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[doc = "Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise,\nthe app is not served on those hostnames."]
        #[serde(rename = "enabledHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub enabled_host_names: Vec<String>,
        #[doc = "Management information availability state for the app."]
        #[serde(rename = "availabilityState", default, skip_serializing_if = "Option::is_none")]
        pub availability_state: Option<properties::AvailabilityState>,
        #[doc = "Hostname SSL states are used to manage the SSL bindings for app's hostnames."]
        #[serde(rename = "hostNameSslStates", default, skip_serializing_if = "Vec::is_empty")]
        pub host_name_ssl_states: Vec<HostNameSslState>,
        #[doc = "Resource ID of the associated App Service plan, formatted as: \"/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}\"."]
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
        #[doc = "<code>true</code> if reserved; otherwise, <code>false</code>."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reserved: Option<bool>,
        #[doc = "Last time the app was modified, in UTC. Read-only."]
        #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
        pub last_modified_time_utc: Option<String>,
        #[doc = "Configuration of an App Service app."]
        #[serde(rename = "siteConfig", default, skip_serializing_if = "Option::is_none")]
        pub site_config: Option<SiteConfig>,
        #[doc = "Azure Traffic Manager hostnames associated with the app. Read-only."]
        #[serde(rename = "trafficManagerHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub traffic_manager_host_names: Vec<String>,
        #[doc = "<code>true</code> to stop SCM (KUDU) site when the app is stopped; otherwise, <code>false</code>. The default is <code>false</code>."]
        #[serde(rename = "scmSiteAlsoStopped", default, skip_serializing_if = "Option::is_none")]
        pub scm_site_also_stopped: Option<bool>,
        #[doc = "Specifies which deployment slot this app will swap into. Read-only."]
        #[serde(rename = "targetSwapSlot", default, skip_serializing_if = "Option::is_none")]
        pub target_swap_slot: Option<String>,
        #[doc = "Specification for an App Service Environment to use for this resource."]
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[doc = "<code>true</code> to enable client affinity; <code>false</code> to stop sending session affinity cookies, which route client requests in the same session to the same instance. Default is <code>true</code>."]
        #[serde(rename = "clientAffinityEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_affinity_enabled: Option<bool>,
        #[doc = "<code>true</code> to enable client certificate authentication (TLS mutual authentication); otherwise, <code>false</code>. Default is <code>false</code>."]
        #[serde(rename = "clientCertEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_cert_enabled: Option<bool>,
        #[doc = "<code>true</code> to disable the public hostnames of the app; otherwise, <code>false</code>.\n If <code>true</code>, the app is only accessible via API management process."]
        #[serde(rename = "hostNamesDisabled", default, skip_serializing_if = "Option::is_none")]
        pub host_names_disabled: Option<bool>,
        #[doc = "List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants that site can be hosted with current settings. Read-only."]
        #[serde(rename = "outboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub outbound_ip_addresses: Option<String>,
        #[doc = "List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all tenants. Read-only."]
        #[serde(rename = "possibleOutboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub possible_outbound_ip_addresses: Option<String>,
        #[doc = "Size of the function container."]
        #[serde(rename = "containerSize", default, skip_serializing_if = "Option::is_none")]
        pub container_size: Option<i32>,
        #[doc = "Maximum allowed daily memory-time quota (applicable on dynamic apps only)."]
        #[serde(rename = "dailyMemoryTimeQuota", default, skip_serializing_if = "Option::is_none")]
        pub daily_memory_time_quota: Option<i32>,
        #[doc = "App suspended till in case memory-time quota is exceeded."]
        #[serde(rename = "suspendedTill", default, skip_serializing_if = "Option::is_none")]
        pub suspended_till: Option<String>,
        #[doc = "Maximum number of workers.\nThis only applies to Functions container."]
        #[serde(rename = "maxNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub max_number_of_workers: Option<i32>,
        #[doc = "Information needed for cloning operation."]
        #[serde(rename = "cloningInfo", default, skip_serializing_if = "Option::is_none")]
        pub cloning_info: Option<CloningInfo>,
        #[doc = "Details about app recovery operation."]
        #[serde(rename = "snapshotInfo", default, skip_serializing_if = "Option::is_none")]
        pub snapshot_info: Option<SnapshotRecoveryRequest>,
        #[doc = "Name of the resource group the app belongs to. Read-only."]
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[doc = "<code>true</code> if the app is a default container; otherwise, <code>false</code>."]
        #[serde(rename = "isDefaultContainer", default, skip_serializing_if = "Option::is_none")]
        pub is_default_container: Option<bool>,
        #[doc = "Default hostname of the app. Read-only."]
        #[serde(rename = "defaultHostName", default, skip_serializing_if = "Option::is_none")]
        pub default_host_name: Option<String>,
        #[doc = "The status of the last successful slot swap operation."]
        #[serde(rename = "slotSwapStatus", default, skip_serializing_if = "Option::is_none")]
        pub slot_swap_status: Option<SlotSwapStatus>,
        #[doc = "HttpsOnly: configures a web site to accept only https requests. Issues redirect for\nhttp requests"]
        #[serde(rename = "httpsOnly", default, skip_serializing_if = "Option::is_none")]
        pub https_only: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "State indicating whether the app has exceeded its quota usage. Read-only."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum UsageState {
            Normal,
            Exceeded,
        }
        #[doc = "Management information availability state for the app."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AvailabilityState {
            Normal,
            Limited,
            DisasterRecoveryMode,
        }
    }
}
#[doc = "Used for getting PHP error logging flag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SitePhpErrorLogFlag {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SitePhpErrorLogFlag resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_php_error_log_flag::Properties>,
}
impl SitePhpErrorLogFlag {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_php_error_log_flag {
    use super::*;
    #[doc = "SitePhpErrorLogFlag resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Local log_errors setting."]
        #[serde(rename = "localLogErrors", default, skip_serializing_if = "Option::is_none")]
        pub local_log_errors: Option<String>,
        #[doc = "Master log_errors setting."]
        #[serde(rename = "masterLogErrors", default, skip_serializing_if = "Option::is_none")]
        pub master_log_errors: Option<String>,
        #[doc = "Local log_errors_max_len setting."]
        #[serde(rename = "localLogErrorsMaxLength", default, skip_serializing_if = "Option::is_none")]
        pub local_log_errors_max_length: Option<String>,
        #[doc = "Master log_errors_max_len setting."]
        #[serde(rename = "masterLogErrorsMaxLength", default, skip_serializing_if = "Option::is_none")]
        pub master_log_errors_max_length: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Source control configuration for an app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteSourceControl {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SiteSourceControl resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_source_control::Properties>,
}
impl SiteSourceControl {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_source_control {
    use super::*;
    #[doc = "SiteSourceControl resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Repository or source control URL."]
        #[serde(rename = "repoUrl", default, skip_serializing_if = "Option::is_none")]
        pub repo_url: Option<String>,
        #[doc = "Name of branch to use for deployment."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub branch: Option<String>,
        #[doc = "<code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub)."]
        #[serde(rename = "isManualIntegration", default, skip_serializing_if = "Option::is_none")]
        pub is_manual_integration: Option<bool>,
        #[doc = "<code>true</code> to enable deployment rollback; otherwise, <code>false</code>."]
        #[serde(rename = "deploymentRollbackEnabled", default, skip_serializing_if = "Option::is_none")]
        pub deployment_rollback_enabled: Option<bool>,
        #[doc = "<code>true</code> for a Mercurial repository; <code>false</code> for a Git repository."]
        #[serde(rename = "isMercurial", default, skip_serializing_if = "Option::is_none")]
        pub is_mercurial: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Names for connection strings and application settings to be marked as sticky to the deployment slot and not moved during a swap operation.\nThis is valid for all deployment slots in an app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotConfigNames {
    #[doc = "List of connection string names."]
    #[serde(rename = "connectionStringNames", default, skip_serializing_if = "Vec::is_empty")]
    pub connection_string_names: Vec<String>,
    #[doc = "List of application settings names."]
    #[serde(rename = "appSettingNames", default, skip_serializing_if = "Vec::is_empty")]
    pub app_setting_names: Vec<String>,
}
impl SlotConfigNames {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Slot Config names azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotConfigNamesResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "Names for connection strings and application settings to be marked as sticky to the deployment slot and not moved during a swap operation.\nThis is valid for all deployment slots in an app."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SlotConfigNames>,
}
impl SlotConfigNamesResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A setting difference between two deployment slots of an app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotDifference {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SlotDifference resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<slot_difference::Properties>,
}
impl SlotDifference {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod slot_difference {
    use super::*;
    #[doc = "SlotDifference resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Type of the difference: Information, Warning or Error."]
        #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
        pub type_: Option<String>,
        #[doc = "The type of the setting: General, AppSetting or ConnectionString."]
        #[serde(rename = "settingType", default, skip_serializing_if = "Option::is_none")]
        pub setting_type: Option<String>,
        #[doc = "Rule that describes how to process the setting difference during a slot swap."]
        #[serde(rename = "diffRule", default, skip_serializing_if = "Option::is_none")]
        pub diff_rule: Option<String>,
        #[doc = "Name of the setting."]
        #[serde(rename = "settingName", default, skip_serializing_if = "Option::is_none")]
        pub setting_name: Option<String>,
        #[doc = "Value of the setting in the current slot."]
        #[serde(rename = "valueInCurrentSlot", default, skip_serializing_if = "Option::is_none")]
        pub value_in_current_slot: Option<String>,
        #[doc = "Value of the setting in the target slot."]
        #[serde(rename = "valueInTargetSlot", default, skip_serializing_if = "Option::is_none")]
        pub value_in_target_slot: Option<String>,
        #[doc = "Description of the setting difference."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of slot differences."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SlotDifferenceCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<SlotDifference>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SlotDifferenceCollection {
    pub fn new(value: Vec<SlotDifference>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "The status of the last successful slot swap operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotSwapStatus {
    #[doc = "The time the last successful slot swap completed."]
    #[serde(rename = "timestampUtc", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_utc: Option<String>,
    #[doc = "The source slot of the last swap operation."]
    #[serde(rename = "sourceSlotName", default, skip_serializing_if = "Option::is_none")]
    pub source_slot_name: Option<String>,
    #[doc = "The destination slot of the last swap operation."]
    #[serde(rename = "destinationSlotName", default, skip_serializing_if = "Option::is_none")]
    pub destination_slot_name: Option<String>,
}
impl SlotSwapStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Trigger based on request execution time."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlowRequestsBasedTrigger {
    #[doc = "Time taken."]
    #[serde(rename = "timeTaken", default, skip_serializing_if = "Option::is_none")]
    pub time_taken: Option<String>,
    #[doc = "Request Count."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[doc = "Time interval."]
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl SlowRequestsBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A snapshot of an app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Snapshot {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "Snapshot resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<snapshot::Properties>,
}
impl Snapshot {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod snapshot {
    use super::*;
    #[doc = "Snapshot resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The time the snapshot was taken."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub time: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of snapshots which can be used to revert an app to a previous time."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnapshotCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<Snapshot>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SnapshotCollection {
    pub fn new(value: Vec<Snapshot>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Details about app recovery operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotRecoveryRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "SnapshotRecoveryRequest resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<snapshot_recovery_request::Properties>,
}
impl SnapshotRecoveryRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod snapshot_recovery_request {
    use super::*;
    #[doc = "SnapshotRecoveryRequest resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[doc = "Point in time in which the app recovery should be attempted, formatted as a DateTime string."]
        #[serde(rename = "snapshotTime", default, skip_serializing_if = "Option::is_none")]
        pub snapshot_time: Option<String>,
        #[doc = "Specifies the web app that snapshot contents will be written to."]
        #[serde(rename = "recoveryTarget", default, skip_serializing_if = "Option::is_none")]
        pub recovery_target: Option<SnapshotRecoveryTarget>,
        #[doc = "If <code>true</code> the recovery operation can overwrite source app; otherwise, <code>false</code>."]
        pub overwrite: bool,
        #[doc = "If true, site configuration, in addition to content, will be reverted."]
        #[serde(rename = "recoverConfiguration", default, skip_serializing_if = "Option::is_none")]
        pub recover_configuration: Option<bool>,
        #[doc = "If true, custom hostname conflicts will be ignored when recovering to a target web app.\nThis setting is only necessary when RecoverConfiguration is enabled."]
        #[serde(rename = "ignoreConflictingHostNames", default, skip_serializing_if = "Option::is_none")]
        pub ignore_conflicting_host_names: Option<bool>,
    }
    impl Properties {
        pub fn new(overwrite: bool) -> Self {
            Self {
                snapshot_time: None,
                recovery_target: None,
                overwrite,
                recover_configuration: None,
                ignore_conflicting_host_names: None,
            }
        }
    }
}
#[doc = "Specifies the web app that snapshot contents will be written to."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotRecoveryTarget {
    #[doc = "Geographical location of the target web app, e.g. SouthEastAsia, SouthCentralUS"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "ARM resource ID of the target app. \n/subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and \n/subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SnapshotRecoveryTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Trigger based on status code."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StatusCodesBasedTrigger {
    #[doc = "HTTP status code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<i32>,
    #[doc = "Request Sub Status."]
    #[serde(rename = "subStatus", default, skip_serializing_if = "Option::is_none")]
    pub sub_status: Option<i32>,
    #[doc = "Win32 error code."]
    #[serde(rename = "win32Status", default, skip_serializing_if = "Option::is_none")]
    pub win32_status: Option<i32>,
    #[doc = "Request Count."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[doc = "Time interval."]
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl StatusCodesBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Options for app content migration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageMigrationOptions {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "StorageMigrationOptions resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<storage_migration_options::Properties>,
}
impl StorageMigrationOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod storage_migration_options {
    use super::*;
    #[doc = "StorageMigrationOptions resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[doc = "AzureFiles connection string."]
        #[serde(rename = "azurefilesConnectionString")]
        pub azurefiles_connection_string: String,
        #[doc = "AzureFiles share."]
        #[serde(rename = "azurefilesShare")]
        pub azurefiles_share: String,
        #[doc = "<code>true</code>if the app should be switched over; otherwise, <code>false</code>."]
        #[serde(rename = "switchSiteAfterMigration", default, skip_serializing_if = "Option::is_none")]
        pub switch_site_after_migration: Option<bool>,
        #[doc = "<code>true</code> if the app should be read only during copy operation; otherwise, <code>false</code>."]
        #[serde(rename = "blockWriteAccessToSite", default, skip_serializing_if = "Option::is_none")]
        pub block_write_access_to_site: Option<bool>,
    }
    impl Properties {
        pub fn new(azurefiles_connection_string: String, azurefiles_share: String) -> Self {
            Self {
                azurefiles_connection_string,
                azurefiles_share,
                switch_site_after_migration: None,
                block_write_access_to_site: None,
            }
        }
    }
}
#[doc = "Response for a migration of app content request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageMigrationResponse {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "StorageMigrationResponse resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<storage_migration_response::Properties>,
}
impl StorageMigrationResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod storage_migration_response {
    use super::*;
    #[doc = "StorageMigrationResponse resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "When server starts the migration process, it will return an operation ID identifying that particular migration operation."]
        #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
        pub operation_id: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "String dictionary resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StringDictionary {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "Settings."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl StringDictionary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Triggered Web Job History. List of Triggered Web Job Run Information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggeredJobHistory {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "TriggeredJobHistory resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<triggered_job_history::Properties>,
}
impl TriggeredJobHistory {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod triggered_job_history {
    use super::*;
    #[doc = "TriggeredJobHistory resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "List of triggered web job runs."]
        #[serde(rename = "triggeredJobRuns", default, skip_serializing_if = "Vec::is_empty")]
        pub triggered_job_runs: Vec<TriggeredJobRun>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Collection of Kudu continuous web job information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggeredJobHistoryCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<TriggeredJobHistory>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TriggeredJobHistoryCollection {
    pub fn new(value: Vec<TriggeredJobHistory>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Triggered Web Job Run Information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggeredJobRun {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "TriggeredJobRun resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<triggered_job_run::Properties>,
}
impl TriggeredJobRun {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod triggered_job_run {
    use super::*;
    #[doc = "TriggeredJobRun resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Job ID."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
        #[doc = "Job name."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "Job status."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[doc = "Start time."]
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[doc = "End time."]
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[doc = "Job duration."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub duration: Option<String>,
        #[doc = "Output URL."]
        #[serde(rename = "outputUrl", default, skip_serializing_if = "Option::is_none")]
        pub output_url: Option<String>,
        #[doc = "Error URL."]
        #[serde(rename = "errorUrl", default, skip_serializing_if = "Option::is_none")]
        pub error_url: Option<String>,
        #[doc = "Job URL."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub url: Option<String>,
        #[doc = "Job name."]
        #[serde(rename = "jobName", default, skip_serializing_if = "Option::is_none")]
        pub job_name: Option<String>,
        #[doc = "Job trigger."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub trigger: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Job status."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Success,
            Failed,
            Error,
        }
    }
}
#[doc = "Triggered Web Job Information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggeredWebJob {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "TriggeredWebJob resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<triggered_web_job::Properties>,
}
impl TriggeredWebJob {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod triggered_web_job {
    use super::*;
    #[doc = "TriggeredWebJob resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Triggered Web Job Run Information."]
        #[serde(rename = "latestRun", default, skip_serializing_if = "Option::is_none")]
        pub latest_run: Option<TriggeredJobRun>,
        #[doc = "History URL."]
        #[serde(rename = "historyUrl", default, skip_serializing_if = "Option::is_none")]
        pub history_url: Option<String>,
        #[doc = "Scheduler Logs URL."]
        #[serde(rename = "schedulerLogsUrl", default, skip_serializing_if = "Option::is_none")]
        pub scheduler_logs_url: Option<String>,
        #[doc = "Job name. Used as job identifier in ARM resource URI."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "Run command."]
        #[serde(rename = "runCommand", default, skip_serializing_if = "Option::is_none")]
        pub run_command: Option<String>,
        #[doc = "Job URL."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub url: Option<String>,
        #[doc = "Extra Info URL."]
        #[serde(rename = "extraInfoUrl", default, skip_serializing_if = "Option::is_none")]
        pub extra_info_url: Option<String>,
        #[doc = "Job type."]
        #[serde(rename = "jobType", default, skip_serializing_if = "Option::is_none")]
        pub job_type: Option<properties::JobType>,
        #[doc = "Error information."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub error: Option<String>,
        #[doc = "Using SDK?"]
        #[serde(rename = "usingSdk", default, skip_serializing_if = "Option::is_none")]
        pub using_sdk: Option<bool>,
        #[doc = "Job settings."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub settings: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Job type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum JobType {
            Continuous,
            Triggered,
        }
    }
}
#[doc = "Collection of Kudu continuous web job information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggeredWebJobCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<TriggeredWebJob>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TriggeredWebJobCollection {
    pub fn new(value: Vec<TriggeredWebJob>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "User credentials used for publishing activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct User {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "User resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<user::Properties>,
}
impl User {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod user {
    use super::*;
    #[doc = "User resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[doc = "Username"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "Username used for publishing."]
        #[serde(rename = "publishingUserName")]
        pub publishing_user_name: String,
        #[doc = "Password used for publishing."]
        #[serde(rename = "publishingPassword", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password: Option<String>,
        #[doc = "Password hash used for publishing."]
        #[serde(rename = "publishingPasswordHash", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password_hash: Option<String>,
        #[doc = "Password hash salt used for publishing."]
        #[serde(rename = "publishingPasswordHashSalt", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password_hash_salt: Option<String>,
    }
    impl Properties {
        pub fn new(publishing_user_name: String) -> Self {
            Self {
                name: None,
                publishing_user_name,
                publishing_password: None,
                publishing_password_hash: None,
                publishing_password_hash_salt: None,
            }
        }
    }
}
#[doc = "Virtual application in an app."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplication {
    #[doc = "Virtual path."]
    #[serde(rename = "virtualPath", default, skip_serializing_if = "Option::is_none")]
    pub virtual_path: Option<String>,
    #[doc = "Physical path."]
    #[serde(rename = "physicalPath", default, skip_serializing_if = "Option::is_none")]
    pub physical_path: Option<String>,
    #[doc = "<code>true</code> if preloading is enabled; otherwise, <code>false</code>."]
    #[serde(rename = "preloadEnabled", default, skip_serializing_if = "Option::is_none")]
    pub preload_enabled: Option<bool>,
    #[doc = "Virtual directories for virtual application."]
    #[serde(rename = "virtualDirectories", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_directories: Vec<VirtualDirectory>,
}
impl VirtualApplication {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Directory for virtual application."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualDirectory {
    #[doc = "Path to virtual application."]
    #[serde(rename = "virtualPath", default, skip_serializing_if = "Option::is_none")]
    pub virtual_path: Option<String>,
    #[doc = "Physical path."]
    #[serde(rename = "physicalPath", default, skip_serializing_if = "Option::is_none")]
    pub physical_path: Option<String>,
}
impl VirtualDirectory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetGateway {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "VnetGateway resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_gateway::Properties>,
}
impl VnetGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_gateway {
    use super::*;
    #[doc = "VnetGateway resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[doc = "The Virtual Network name."]
        #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_name: Option<String>,
        #[doc = "The URI where the VPN package can be downloaded."]
        #[serde(rename = "vpnPackageUri")]
        pub vpn_package_uri: String,
    }
    impl Properties {
        pub fn new(vpn_package_uri: String) -> Self {
            Self {
                vnet_name: None,
                vpn_package_uri,
            }
        }
    }
}
#[doc = "Virtual Network information contract."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "VnetInfo resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_info::Properties>,
}
impl VnetInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_info {
    use super::*;
    #[doc = "VnetInfo resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The Virtual Network's resource ID."]
        #[serde(rename = "vnetResourceId", default, skip_serializing_if = "Option::is_none")]
        pub vnet_resource_id: Option<String>,
        #[doc = "The client certificate thumbprint."]
        #[serde(rename = "certThumbprint", default, skip_serializing_if = "Option::is_none")]
        pub cert_thumbprint: Option<String>,
        #[doc = "A certificate file (.cer) blob containing the public key of the private key used to authenticate a \nPoint-To-Site VPN connection."]
        #[serde(rename = "certBlob", default, skip_serializing_if = "Option::is_none")]
        pub cert_blob: Option<String>,
        #[doc = "The routes that this Virtual Network connection uses."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub routes: Vec<VnetRoute>,
        #[doc = "<code>true</code> if a resync is required; otherwise, <code>false</code>."]
        #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
        pub resync_required: Option<bool>,
        #[doc = "DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses."]
        #[serde(rename = "dnsServers", default, skip_serializing_if = "Option::is_none")]
        pub dns_servers: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Virtual Network route contract used to pass routing information for a Virtual Network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetRoute {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "VnetRoute resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_route::Properties>,
}
impl VnetRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_route {
    use super::*;
    #[doc = "VnetRoute resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The name of this route. This is only returned by the server and does not need to be set by the client."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified."]
        #[serde(rename = "startAddress", default, skip_serializing_if = "Option::is_none")]
        pub start_address: Option<String>,
        #[doc = "The ending address for this route. If the start address is specified in CIDR notation, this must be omitted."]
        #[serde(rename = "endAddress", default, skip_serializing_if = "Option::is_none")]
        pub end_address: Option<String>,
        #[doc = "The type of route this is:\nDEFAULT - By default, every app has routes to the local address ranges specified by RFC1918\nINHERITED - Routes inherited from the real Virtual Network routes\nSTATIC - Static route set on the app only\n\nThese values will be used for syncing an app's routes with those from a Virtual Network."]
        #[serde(rename = "routeType", default, skip_serializing_if = "Option::is_none")]
        pub route_type: Option<properties::RouteType>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "The type of route this is:\nDEFAULT - By default, every app has routes to the local address ranges specified by RFC1918\nINHERITED - Routes inherited from the real Virtual Network routes\nSTATIC - Static route set on the app only\n\nThese values will be used for syncing an app's routes with those from a Virtual Network."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RouteType {
            #[serde(rename = "DEFAULT")]
            Default,
            #[serde(rename = "INHERITED")]
            Inherited,
            #[serde(rename = "STATIC")]
            Static,
        }
    }
}
#[doc = "Collection of App Service apps."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebAppCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<Site>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebAppCollection {
    pub fn new(value: Vec<Site>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Collection of app instances."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebAppInstanceCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<SiteInstance>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebAppInstanceCollection {
    pub fn new(value: Vec<SiteInstance>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Web Job Information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebJob {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[doc = "WebJob resource specific properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<web_job::Properties>,
}
impl WebJob {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod web_job {
    use super::*;
    #[doc = "WebJob resource specific properties"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Job name. Used as job identifier in ARM resource URI."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[doc = "Run command."]
        #[serde(rename = "runCommand", default, skip_serializing_if = "Option::is_none")]
        pub run_command: Option<String>,
        #[doc = "Job URL."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub url: Option<String>,
        #[doc = "Extra Info URL."]
        #[serde(rename = "extraInfoUrl", default, skip_serializing_if = "Option::is_none")]
        pub extra_info_url: Option<String>,
        #[doc = "Job type."]
        #[serde(rename = "jobType", default, skip_serializing_if = "Option::is_none")]
        pub job_type: Option<properties::JobType>,
        #[doc = "Error information."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub error: Option<String>,
        #[doc = "Using SDK?"]
        #[serde(rename = "usingSdk", default, skip_serializing_if = "Option::is_none")]
        pub using_sdk: Option<bool>,
        #[doc = "Job settings."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub settings: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Job type."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum JobType {
            Continuous,
            Triggered,
        }
    }
}
#[doc = "Collection of Kudu web job information elements."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebJobCollection {
    #[doc = "Collection of resources."]
    pub value: Vec<WebJob>,
    #[doc = "Link to next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebJobCollection {
    pub fn new(value: Vec<WebJob>) -> Self {
        Self { value, next_link: None }
    }
}
