#![doc = "generated by AutoRust"]
#![allow(unused_mut)]
#![allow(unused_variables)]
#![allow(unused_imports)]
use super::models;
#[derive(Clone)]
pub struct Client {
    endpoint: String,
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    scopes: Vec<String>,
    pipeline: azure_core::Pipeline,
}
#[derive(Clone)]
pub struct ClientBuilder {
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    endpoint: Option<String>,
    scopes: Option<Vec<String>>,
}
pub const DEFAULT_ENDPOINT: &str = azure_core::resource_manager_endpoint::AZURE_PUBLIC_CLOUD;
impl ClientBuilder {
    pub fn new(credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>) -> Self {
        Self {
            credential,
            endpoint: None,
            scopes: None,
        }
    }
    pub fn endpoint(mut self, endpoint: impl Into<String>) -> Self {
        self.endpoint = Some(endpoint.into());
        self
    }
    pub fn scopes(mut self, scopes: &[&str]) -> Self {
        self.scopes = Some(scopes.iter().map(|scope| (*scope).to_owned()).collect());
        self
    }
    pub fn build(self) -> Client {
        let endpoint = self.endpoint.unwrap_or_else(|| DEFAULT_ENDPOINT.to_owned());
        let scopes = self.scopes.unwrap_or_else(|| vec![format!("{}/", endpoint)]);
        Client::new(endpoint, self.credential, scopes)
    }
}
impl Client {
    pub(crate) fn endpoint(&self) -> &str {
        self.endpoint.as_str()
    }
    pub(crate) fn token_credential(&self) -> &dyn azure_core::auth::TokenCredential {
        self.credential.as_ref()
    }
    pub(crate) fn scopes(&self) -> Vec<&str> {
        self.scopes.iter().map(String::as_str).collect()
    }
    pub(crate) async fn send(&self, request: impl Into<azure_core::Request>) -> Result<azure_core::Response, azure_core::Error> {
        let mut context = azure_core::Context::default();
        let mut request = request.into();
        self.pipeline.send(&mut context, &mut request).await
    }
    pub fn new(
        endpoint: impl Into<String>,
        credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
        scopes: Vec<String>,
    ) -> Self {
        let endpoint = endpoint.into();
        let pipeline = azure_core::Pipeline::new(
            option_env!("CARGO_PKG_NAME"),
            option_env!("CARGO_PKG_VERSION"),
            azure_core::ClientOptions::default(),
            Vec::new(),
            Vec::new(),
        );
        Self {
            endpoint,
            credential,
            scopes,
            pipeline,
        }
    }
    pub fn app_service_certificate_orders(&self) -> app_service_certificate_orders::Client {
        app_service_certificate_orders::Client(self.clone())
    }
    pub fn app_service_environments(&self) -> app_service_environments::Client {
        app_service_environments::Client(self.clone())
    }
    pub fn app_service_plans(&self) -> app_service_plans::Client {
        app_service_plans::Client(self.clone())
    }
    pub fn certificate_registration_provider(&self) -> certificate_registration_provider::Client {
        certificate_registration_provider::Client(self.clone())
    }
    pub fn certificates(&self) -> certificates::Client {
        certificates::Client(self.clone())
    }
    pub fn deleted_web_apps(&self) -> deleted_web_apps::Client {
        deleted_web_apps::Client(self.clone())
    }
    pub fn diagnostics(&self) -> diagnostics::Client {
        diagnostics::Client(self.clone())
    }
    pub fn domain_registration_provider(&self) -> domain_registration_provider::Client {
        domain_registration_provider::Client(self.clone())
    }
    pub fn domains(&self) -> domains::Client {
        domains::Client(self.clone())
    }
    pub fn provider(&self) -> provider::Client {
        provider::Client(self.clone())
    }
    pub fn recommendations(&self) -> recommendations::Client {
        recommendations::Client(self.clone())
    }
    pub fn resource_health_metadata(&self) -> resource_health_metadata::Client {
        resource_health_metadata::Client(self.clone())
    }
    pub fn top_level_domains(&self) -> top_level_domains::Client {
        top_level_domains::Client(self.clone())
    }
    pub fn web_apps(&self) -> web_apps::Client {
        web_apps::Client(self.clone())
    }
}
#[non_exhaustive]
#[derive(Debug, thiserror :: Error)]
#[allow(non_camel_case_types)]
pub enum Error {
    #[error(transparent)]
    AppServiceCertificateOrders_List(#[from] app_service_certificate_orders::list::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_ValidatePurchaseInformation(#[from] app_service_certificate_orders::validate_purchase_information::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_ListByResourceGroup(#[from] app_service_certificate_orders::list_by_resource_group::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_Get(#[from] app_service_certificate_orders::get::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_CreateOrUpdate(#[from] app_service_certificate_orders::create_or_update::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_Update(#[from] app_service_certificate_orders::update::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_Delete(#[from] app_service_certificate_orders::delete::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_ListCertificates(#[from] app_service_certificate_orders::list_certificates::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_GetCertificate(#[from] app_service_certificate_orders::get_certificate::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_CreateOrUpdateCertificate(#[from] app_service_certificate_orders::create_or_update_certificate::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_UpdateCertificate(#[from] app_service_certificate_orders::update_certificate::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_DeleteCertificate(#[from] app_service_certificate_orders::delete_certificate::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_Reissue(#[from] app_service_certificate_orders::reissue::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_Renew(#[from] app_service_certificate_orders::renew::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_ResendEmail(#[from] app_service_certificate_orders::resend_email::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_ResendRequestEmails(#[from] app_service_certificate_orders::resend_request_emails::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_RetrieveSiteSeal(#[from] app_service_certificate_orders::retrieve_site_seal::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_VerifyDomainOwnership(#[from] app_service_certificate_orders::verify_domain_ownership::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_RetrieveCertificateActions(#[from] app_service_certificate_orders::retrieve_certificate_actions::Error),
    #[error(transparent)]
    AppServiceCertificateOrders_RetrieveCertificateEmailHistory(
        #[from] app_service_certificate_orders::retrieve_certificate_email_history::Error,
    ),
    #[error(transparent)]
    CertificateRegistrationProvider_ListOperations(#[from] certificate_registration_provider::list_operations::Error),
    #[error(transparent)]
    Domains_CheckAvailability(#[from] domains::check_availability::Error),
    #[error(transparent)]
    Domains_List(#[from] domains::list::Error),
    #[error(transparent)]
    Domains_GetControlCenterSsoRequest(#[from] domains::get_control_center_sso_request::Error),
    #[error(transparent)]
    Domains_ListRecommendations(#[from] domains::list_recommendations::Error),
    #[error(transparent)]
    Domains_ListByResourceGroup(#[from] domains::list_by_resource_group::Error),
    #[error(transparent)]
    Domains_Get(#[from] domains::get::Error),
    #[error(transparent)]
    Domains_CreateOrUpdate(#[from] domains::create_or_update::Error),
    #[error(transparent)]
    Domains_Update(#[from] domains::update::Error),
    #[error(transparent)]
    Domains_Delete(#[from] domains::delete::Error),
    #[error(transparent)]
    Domains_ListOwnershipIdentifiers(#[from] domains::list_ownership_identifiers::Error),
    #[error(transparent)]
    Domains_GetOwnershipIdentifier(#[from] domains::get_ownership_identifier::Error),
    #[error(transparent)]
    Domains_CreateOrUpdateOwnershipIdentifier(#[from] domains::create_or_update_ownership_identifier::Error),
    #[error(transparent)]
    Domains_UpdateOwnershipIdentifier(#[from] domains::update_ownership_identifier::Error),
    #[error(transparent)]
    Domains_DeleteOwnershipIdentifier(#[from] domains::delete_ownership_identifier::Error),
    #[error(transparent)]
    Domains_Renew(#[from] domains::renew::Error),
    #[error(transparent)]
    TopLevelDomains_List(#[from] top_level_domains::list::Error),
    #[error(transparent)]
    TopLevelDomains_Get(#[from] top_level_domains::get::Error),
    #[error(transparent)]
    TopLevelDomains_ListAgreements(#[from] top_level_domains::list_agreements::Error),
    #[error(transparent)]
    DomainRegistrationProvider_ListOperations(#[from] domain_registration_provider::list_operations::Error),
    #[error(transparent)]
    Certificates_List(#[from] certificates::list::Error),
    #[error(transparent)]
    Certificates_ListByResourceGroup(#[from] certificates::list_by_resource_group::Error),
    #[error(transparent)]
    Certificates_Get(#[from] certificates::get::Error),
    #[error(transparent)]
    Certificates_CreateOrUpdate(#[from] certificates::create_or_update::Error),
    #[error(transparent)]
    Certificates_Update(#[from] certificates::update::Error),
    #[error(transparent)]
    Certificates_Delete(#[from] certificates::delete::Error),
    #[error(transparent)]
    DeletedWebApps_List(#[from] deleted_web_apps::list::Error),
    #[error(transparent)]
    DeletedWebApps_ListByLocation(#[from] deleted_web_apps::list_by_location::Error),
    #[error(transparent)]
    DeletedWebApps_GetDeletedWebAppByLocation(#[from] deleted_web_apps::get_deleted_web_app_by_location::Error),
    #[error(transparent)]
    Diagnostics_ListHostingEnvironmentDetectorResponses(#[from] diagnostics::list_hosting_environment_detector_responses::Error),
    #[error(transparent)]
    Diagnostics_GetHostingEnvironmentDetectorResponse(#[from] diagnostics::get_hosting_environment_detector_response::Error),
    #[error(transparent)]
    Diagnostics_ListSiteDetectorResponses(#[from] diagnostics::list_site_detector_responses::Error),
    #[error(transparent)]
    Diagnostics_GetSiteDetectorResponse(#[from] diagnostics::get_site_detector_response::Error),
    #[error(transparent)]
    Diagnostics_ListSiteDiagnosticCategories(#[from] diagnostics::list_site_diagnostic_categories::Error),
    #[error(transparent)]
    Diagnostics_GetSiteDiagnosticCategory(#[from] diagnostics::get_site_diagnostic_category::Error),
    #[error(transparent)]
    Diagnostics_ListSiteAnalyses(#[from] diagnostics::list_site_analyses::Error),
    #[error(transparent)]
    Diagnostics_GetSiteAnalysis(#[from] diagnostics::get_site_analysis::Error),
    #[error(transparent)]
    Diagnostics_ExecuteSiteAnalysis(#[from] diagnostics::execute_site_analysis::Error),
    #[error(transparent)]
    Diagnostics_ListSiteDetectors(#[from] diagnostics::list_site_detectors::Error),
    #[error(transparent)]
    Diagnostics_GetSiteDetector(#[from] diagnostics::get_site_detector::Error),
    #[error(transparent)]
    Diagnostics_ExecuteSiteDetector(#[from] diagnostics::execute_site_detector::Error),
    #[error(transparent)]
    Diagnostics_ListSiteDetectorResponsesSlot(#[from] diagnostics::list_site_detector_responses_slot::Error),
    #[error(transparent)]
    Diagnostics_GetSiteDetectorResponseSlot(#[from] diagnostics::get_site_detector_response_slot::Error),
    #[error(transparent)]
    Diagnostics_ListSiteDiagnosticCategoriesSlot(#[from] diagnostics::list_site_diagnostic_categories_slot::Error),
    #[error(transparent)]
    Diagnostics_GetSiteDiagnosticCategorySlot(#[from] diagnostics::get_site_diagnostic_category_slot::Error),
    #[error(transparent)]
    Diagnostics_ListSiteAnalysesSlot(#[from] diagnostics::list_site_analyses_slot::Error),
    #[error(transparent)]
    Diagnostics_GetSiteAnalysisSlot(#[from] diagnostics::get_site_analysis_slot::Error),
    #[error(transparent)]
    Diagnostics_ExecuteSiteAnalysisSlot(#[from] diagnostics::execute_site_analysis_slot::Error),
    #[error(transparent)]
    Diagnostics_ListSiteDetectorsSlot(#[from] diagnostics::list_site_detectors_slot::Error),
    #[error(transparent)]
    Diagnostics_GetSiteDetectorSlot(#[from] diagnostics::get_site_detector_slot::Error),
    #[error(transparent)]
    Diagnostics_ExecuteSiteDetectorSlot(#[from] diagnostics::execute_site_detector_slot::Error),
    #[error(transparent)]
    Provider_GetAvailableStacks(#[from] provider::get_available_stacks::Error),
    #[error(transparent)]
    Provider_ListOperations(#[from] provider::list_operations::Error),
    #[error(transparent)]
    Provider_GetAvailableStacksOnPrem(#[from] provider::get_available_stacks_on_prem::Error),
    #[error(transparent)]
    Recommendations_List(#[from] recommendations::list::Error),
    #[error(transparent)]
    Recommendations_ResetAllFilters(#[from] recommendations::reset_all_filters::Error),
    #[error(transparent)]
    Recommendations_DisableRecommendationForSubscription(#[from] recommendations::disable_recommendation_for_subscription::Error),
    #[error(transparent)]
    Recommendations_ListHistoryForHostingEnvironment(#[from] recommendations::list_history_for_hosting_environment::Error),
    #[error(transparent)]
    Recommendations_ListRecommendedRulesForHostingEnvironment(
        #[from] recommendations::list_recommended_rules_for_hosting_environment::Error,
    ),
    #[error(transparent)]
    Recommendations_DisableAllForHostingEnvironment(#[from] recommendations::disable_all_for_hosting_environment::Error),
    #[error(transparent)]
    Recommendations_ResetAllFiltersForHostingEnvironment(#[from] recommendations::reset_all_filters_for_hosting_environment::Error),
    #[error(transparent)]
    Recommendations_GetRuleDetailsByHostingEnvironment(#[from] recommendations::get_rule_details_by_hosting_environment::Error),
    #[error(transparent)]
    Recommendations_DisableRecommendationForHostingEnvironment(
        #[from] recommendations::disable_recommendation_for_hosting_environment::Error,
    ),
    #[error(transparent)]
    Recommendations_ListHistoryForWebApp(#[from] recommendations::list_history_for_web_app::Error),
    #[error(transparent)]
    Recommendations_ListRecommendedRulesForWebApp(#[from] recommendations::list_recommended_rules_for_web_app::Error),
    #[error(transparent)]
    Recommendations_DisableAllForWebApp(#[from] recommendations::disable_all_for_web_app::Error),
    #[error(transparent)]
    Recommendations_ResetAllFiltersForWebApp(#[from] recommendations::reset_all_filters_for_web_app::Error),
    #[error(transparent)]
    Recommendations_GetRuleDetailsByWebApp(#[from] recommendations::get_rule_details_by_web_app::Error),
    #[error(transparent)]
    Recommendations_DisableRecommendationForSite(#[from] recommendations::disable_recommendation_for_site::Error),
    #[error(transparent)]
    GetPublishingUser(#[from] get_publishing_user::Error),
    #[error(transparent)]
    UpdatePublishingUser(#[from] update_publishing_user::Error),
    #[error(transparent)]
    ListSourceControls(#[from] list_source_controls::Error),
    #[error(transparent)]
    GetSourceControl(#[from] get_source_control::Error),
    #[error(transparent)]
    UpdateSourceControl(#[from] update_source_control::Error),
    #[error(transparent)]
    ListBillingMeters(#[from] list_billing_meters::Error),
    #[error(transparent)]
    CheckNameAvailability(#[from] check_name_availability::Error),
    #[error(transparent)]
    GetSubscriptionDeploymentLocations(#[from] get_subscription_deployment_locations::Error),
    #[error(transparent)]
    ListGeoRegions(#[from] list_geo_regions::Error),
    #[error(transparent)]
    ListSiteIdentifiersAssignedToHostName(#[from] list_site_identifiers_assigned_to_host_name::Error),
    #[error(transparent)]
    ListPremierAddOnOffers(#[from] list_premier_add_on_offers::Error),
    #[error(transparent)]
    ListSkus(#[from] list_skus::Error),
    #[error(transparent)]
    VerifyHostingEnvironmentVnet(#[from] verify_hosting_environment_vnet::Error),
    #[error(transparent)]
    Move(#[from] move_::Error),
    #[error(transparent)]
    Validate(#[from] validate::Error),
    #[error(transparent)]
    ValidateContainerSettings(#[from] validate_container_settings::Error),
    #[error(transparent)]
    ValidateMove(#[from] validate_move::Error),
    #[error(transparent)]
    WebApps_List(#[from] web_apps::list::Error),
    #[error(transparent)]
    WebApps_ListByResourceGroup(#[from] web_apps::list_by_resource_group::Error),
    #[error(transparent)]
    WebApps_Get(#[from] web_apps::get::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdate(#[from] web_apps::create_or_update::Error),
    #[error(transparent)]
    WebApps_Update(#[from] web_apps::update::Error),
    #[error(transparent)]
    WebApps_Delete(#[from] web_apps::delete::Error),
    #[error(transparent)]
    WebApps_AnalyzeCustomHostname(#[from] web_apps::analyze_custom_hostname::Error),
    #[error(transparent)]
    WebApps_ApplySlotConfigToProduction(#[from] web_apps::apply_slot_config_to_production::Error),
    #[error(transparent)]
    WebApps_Backup(#[from] web_apps::backup::Error),
    #[error(transparent)]
    WebApps_ListBackups(#[from] web_apps::list_backups::Error),
    #[error(transparent)]
    WebApps_GetBackupStatus(#[from] web_apps::get_backup_status::Error),
    #[error(transparent)]
    WebApps_DeleteBackup(#[from] web_apps::delete_backup::Error),
    #[error(transparent)]
    WebApps_ListBackupStatusSecrets(#[from] web_apps::list_backup_status_secrets::Error),
    #[error(transparent)]
    WebApps_Restore(#[from] web_apps::restore::Error),
    #[error(transparent)]
    WebApps_ListConfigurations(#[from] web_apps::list_configurations::Error),
    #[error(transparent)]
    WebApps_UpdateApplicationSettings(#[from] web_apps::update_application_settings::Error),
    #[error(transparent)]
    WebApps_ListApplicationSettings(#[from] web_apps::list_application_settings::Error),
    #[error(transparent)]
    WebApps_UpdateAuthSettings(#[from] web_apps::update_auth_settings::Error),
    #[error(transparent)]
    WebApps_GetAuthSettings(#[from] web_apps::get_auth_settings::Error),
    #[error(transparent)]
    WebApps_UpdateAzureStorageAccounts(#[from] web_apps::update_azure_storage_accounts::Error),
    #[error(transparent)]
    WebApps_ListAzureStorageAccounts(#[from] web_apps::list_azure_storage_accounts::Error),
    #[error(transparent)]
    WebApps_UpdateBackupConfiguration(#[from] web_apps::update_backup_configuration::Error),
    #[error(transparent)]
    WebApps_DeleteBackupConfiguration(#[from] web_apps::delete_backup_configuration::Error),
    #[error(transparent)]
    WebApps_GetBackupConfiguration(#[from] web_apps::get_backup_configuration::Error),
    #[error(transparent)]
    WebApps_UpdateConnectionStrings(#[from] web_apps::update_connection_strings::Error),
    #[error(transparent)]
    WebApps_ListConnectionStrings(#[from] web_apps::list_connection_strings::Error),
    #[error(transparent)]
    WebApps_GetDiagnosticLogsConfiguration(#[from] web_apps::get_diagnostic_logs_configuration::Error),
    #[error(transparent)]
    WebApps_UpdateDiagnosticLogsConfig(#[from] web_apps::update_diagnostic_logs_config::Error),
    #[error(transparent)]
    WebApps_UpdateMetadata(#[from] web_apps::update_metadata::Error),
    #[error(transparent)]
    WebApps_ListMetadata(#[from] web_apps::list_metadata::Error),
    #[error(transparent)]
    WebApps_ListPublishingCredentials(#[from] web_apps::list_publishing_credentials::Error),
    #[error(transparent)]
    WebApps_UpdateSitePushSettings(#[from] web_apps::update_site_push_settings::Error),
    #[error(transparent)]
    WebApps_ListSitePushSettings(#[from] web_apps::list_site_push_settings::Error),
    #[error(transparent)]
    WebApps_ListSlotConfigurationNames(#[from] web_apps::list_slot_configuration_names::Error),
    #[error(transparent)]
    WebApps_UpdateSlotConfigurationNames(#[from] web_apps::update_slot_configuration_names::Error),
    #[error(transparent)]
    WebApps_GetConfiguration(#[from] web_apps::get_configuration::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateConfiguration(#[from] web_apps::create_or_update_configuration::Error),
    #[error(transparent)]
    WebApps_UpdateConfiguration(#[from] web_apps::update_configuration::Error),
    #[error(transparent)]
    WebApps_ListConfigurationSnapshotInfo(#[from] web_apps::list_configuration_snapshot_info::Error),
    #[error(transparent)]
    WebApps_GetConfigurationSnapshot(#[from] web_apps::get_configuration_snapshot::Error),
    #[error(transparent)]
    WebApps_RecoverSiteConfigurationSnapshot(#[from] web_apps::recover_site_configuration_snapshot::Error),
    #[error(transparent)]
    WebApps_GetWebSiteContainerLogs(#[from] web_apps::get_web_site_container_logs::Error),
    #[error(transparent)]
    WebApps_GetContainerLogsZip(#[from] web_apps::get_container_logs_zip::Error),
    #[error(transparent)]
    WebApps_ListContinuousWebJobs(#[from] web_apps::list_continuous_web_jobs::Error),
    #[error(transparent)]
    WebApps_GetContinuousWebJob(#[from] web_apps::get_continuous_web_job::Error),
    #[error(transparent)]
    WebApps_DeleteContinuousWebJob(#[from] web_apps::delete_continuous_web_job::Error),
    #[error(transparent)]
    WebApps_StartContinuousWebJob(#[from] web_apps::start_continuous_web_job::Error),
    #[error(transparent)]
    WebApps_StopContinuousWebJob(#[from] web_apps::stop_continuous_web_job::Error),
    #[error(transparent)]
    WebApps_ListDeployments(#[from] web_apps::list_deployments::Error),
    #[error(transparent)]
    WebApps_GetDeployment(#[from] web_apps::get_deployment::Error),
    #[error(transparent)]
    WebApps_CreateDeployment(#[from] web_apps::create_deployment::Error),
    #[error(transparent)]
    WebApps_DeleteDeployment(#[from] web_apps::delete_deployment::Error),
    #[error(transparent)]
    WebApps_ListDeploymentLog(#[from] web_apps::list_deployment_log::Error),
    #[error(transparent)]
    WebApps_DiscoverBackup(#[from] web_apps::discover_backup::Error),
    #[error(transparent)]
    WebApps_ListDomainOwnershipIdentifiers(#[from] web_apps::list_domain_ownership_identifiers::Error),
    #[error(transparent)]
    WebApps_GetDomainOwnershipIdentifier(#[from] web_apps::get_domain_ownership_identifier::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateDomainOwnershipIdentifier(#[from] web_apps::create_or_update_domain_ownership_identifier::Error),
    #[error(transparent)]
    WebApps_UpdateDomainOwnershipIdentifier(#[from] web_apps::update_domain_ownership_identifier::Error),
    #[error(transparent)]
    WebApps_DeleteDomainOwnershipIdentifier(#[from] web_apps::delete_domain_ownership_identifier::Error),
    #[error(transparent)]
    WebApps_GetMsDeployStatus(#[from] web_apps::get_ms_deploy_status::Error),
    #[error(transparent)]
    WebApps_CreateMsDeployOperation(#[from] web_apps::create_ms_deploy_operation::Error),
    #[error(transparent)]
    WebApps_GetMsDeployLog(#[from] web_apps::get_ms_deploy_log::Error),
    #[error(transparent)]
    WebApps_ListFunctions(#[from] web_apps::list_functions::Error),
    #[error(transparent)]
    WebApps_GetFunctionsAdminToken(#[from] web_apps::get_functions_admin_token::Error),
    #[error(transparent)]
    WebApps_GetFunction(#[from] web_apps::get_function::Error),
    #[error(transparent)]
    WebApps_CreateFunction(#[from] web_apps::create_function::Error),
    #[error(transparent)]
    WebApps_DeleteFunction(#[from] web_apps::delete_function::Error),
    #[error(transparent)]
    WebApps_ListFunctionSecrets(#[from] web_apps::list_function_secrets::Error),
    #[error(transparent)]
    WebApps_ListHostNameBindings(#[from] web_apps::list_host_name_bindings::Error),
    #[error(transparent)]
    WebApps_GetHostNameBinding(#[from] web_apps::get_host_name_binding::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateHostNameBinding(#[from] web_apps::create_or_update_host_name_binding::Error),
    #[error(transparent)]
    WebApps_DeleteHostNameBinding(#[from] web_apps::delete_host_name_binding::Error),
    #[error(transparent)]
    WebApps_GetHybridConnection(#[from] web_apps::get_hybrid_connection::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateHybridConnection(#[from] web_apps::create_or_update_hybrid_connection::Error),
    #[error(transparent)]
    WebApps_UpdateHybridConnection(#[from] web_apps::update_hybrid_connection::Error),
    #[error(transparent)]
    WebApps_DeleteHybridConnection(#[from] web_apps::delete_hybrid_connection::Error),
    #[error(transparent)]
    WebApps_ListHybridConnectionKeys(#[from] web_apps::list_hybrid_connection_keys::Error),
    #[error(transparent)]
    WebApps_ListHybridConnections(#[from] web_apps::list_hybrid_connections::Error),
    #[error(transparent)]
    WebApps_ListRelayServiceConnections(#[from] web_apps::list_relay_service_connections::Error),
    #[error(transparent)]
    WebApps_GetRelayServiceConnection(#[from] web_apps::get_relay_service_connection::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateRelayServiceConnection(#[from] web_apps::create_or_update_relay_service_connection::Error),
    #[error(transparent)]
    WebApps_UpdateRelayServiceConnection(#[from] web_apps::update_relay_service_connection::Error),
    #[error(transparent)]
    WebApps_DeleteRelayServiceConnection(#[from] web_apps::delete_relay_service_connection::Error),
    #[error(transparent)]
    WebApps_ListInstanceIdentifiers(#[from] web_apps::list_instance_identifiers::Error),
    #[error(transparent)]
    WebApps_GetInstanceMsDeployStatus(#[from] web_apps::get_instance_ms_deploy_status::Error),
    #[error(transparent)]
    WebApps_CreateInstanceMsDeployOperation(#[from] web_apps::create_instance_ms_deploy_operation::Error),
    #[error(transparent)]
    WebApps_GetInstanceMsDeployLog(#[from] web_apps::get_instance_ms_deploy_log::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcesses(#[from] web_apps::list_instance_processes::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcess(#[from] web_apps::get_instance_process::Error),
    #[error(transparent)]
    WebApps_DeleteInstanceProcess(#[from] web_apps::delete_instance_process::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessDump(#[from] web_apps::get_instance_process_dump::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessModules(#[from] web_apps::list_instance_process_modules::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessModule(#[from] web_apps::get_instance_process_module::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessThreads(#[from] web_apps::list_instance_process_threads::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessThread(#[from] web_apps::get_instance_process_thread::Error),
    #[error(transparent)]
    WebApps_IsCloneable(#[from] web_apps::is_cloneable::Error),
    #[error(transparent)]
    WebApps_ListSyncFunctionTriggers(#[from] web_apps::list_sync_function_triggers::Error),
    #[error(transparent)]
    WebApps_ListMetricDefinitions(#[from] web_apps::list_metric_definitions::Error),
    #[error(transparent)]
    WebApps_ListMetrics(#[from] web_apps::list_metrics::Error),
    #[error(transparent)]
    WebApps_MigrateStorage(#[from] web_apps::migrate_storage::Error),
    #[error(transparent)]
    WebApps_MigrateMySql(#[from] web_apps::migrate_my_sql::Error),
    #[error(transparent)]
    WebApps_GetMigrateMySqlStatus(#[from] web_apps::get_migrate_my_sql_status::Error),
    #[error(transparent)]
    WebApps_GetSwiftVirtualNetworkConnection(#[from] web_apps::get_swift_virtual_network_connection::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateSwiftVirtualNetworkConnection(#[from] web_apps::create_or_update_swift_virtual_network_connection::Error),
    #[error(transparent)]
    WebApps_UpdateSwiftVirtualNetworkConnection(#[from] web_apps::update_swift_virtual_network_connection::Error),
    #[error(transparent)]
    WebApps_DeleteSwiftVirtualNetwork(#[from] web_apps::delete_swift_virtual_network::Error),
    #[error(transparent)]
    WebApps_ListNetworkFeatures(#[from] web_apps::list_network_features::Error),
    #[error(transparent)]
    WebApps_GetNetworkTraceOperation(#[from] web_apps::get_network_trace_operation::Error),
    #[error(transparent)]
    WebApps_StartWebSiteNetworkTrace(#[from] web_apps::start_web_site_network_trace::Error),
    #[error(transparent)]
    WebApps_StartWebSiteNetworkTraceOperation(#[from] web_apps::start_web_site_network_trace_operation::Error),
    #[error(transparent)]
    WebApps_StopWebSiteNetworkTrace(#[from] web_apps::stop_web_site_network_trace::Error),
    #[error(transparent)]
    WebApps_GetNetworkTraces(#[from] web_apps::get_network_traces::Error),
    #[error(transparent)]
    WebApps_GetNetworkTraceOperationV2(#[from] web_apps::get_network_trace_operation_v2::Error),
    #[error(transparent)]
    WebApps_GetNetworkTracesV2(#[from] web_apps::get_network_traces_v2::Error),
    #[error(transparent)]
    WebApps_GenerateNewSitePublishingPassword(#[from] web_apps::generate_new_site_publishing_password::Error),
    #[error(transparent)]
    WebApps_ListPerfMonCounters(#[from] web_apps::list_perf_mon_counters::Error),
    #[error(transparent)]
    WebApps_GetSitePhpErrorLogFlag(#[from] web_apps::get_site_php_error_log_flag::Error),
    #[error(transparent)]
    WebApps_ListPremierAddOns(#[from] web_apps::list_premier_add_ons::Error),
    #[error(transparent)]
    WebApps_GetPremierAddOn(#[from] web_apps::get_premier_add_on::Error),
    #[error(transparent)]
    WebApps_AddPremierAddOn(#[from] web_apps::add_premier_add_on::Error),
    #[error(transparent)]
    WebApps_UpdatePremierAddOn(#[from] web_apps::update_premier_add_on::Error),
    #[error(transparent)]
    WebApps_DeletePremierAddOn(#[from] web_apps::delete_premier_add_on::Error),
    #[error(transparent)]
    WebApps_GetPrivateAccess(#[from] web_apps::get_private_access::Error),
    #[error(transparent)]
    WebApps_PutPrivateAccessVnet(#[from] web_apps::put_private_access_vnet::Error),
    #[error(transparent)]
    WebApps_ListProcesses(#[from] web_apps::list_processes::Error),
    #[error(transparent)]
    WebApps_GetProcess(#[from] web_apps::get_process::Error),
    #[error(transparent)]
    WebApps_DeleteProcess(#[from] web_apps::delete_process::Error),
    #[error(transparent)]
    WebApps_GetProcessDump(#[from] web_apps::get_process_dump::Error),
    #[error(transparent)]
    WebApps_ListProcessModules(#[from] web_apps::list_process_modules::Error),
    #[error(transparent)]
    WebApps_GetProcessModule(#[from] web_apps::get_process_module::Error),
    #[error(transparent)]
    WebApps_ListProcessThreads(#[from] web_apps::list_process_threads::Error),
    #[error(transparent)]
    WebApps_GetProcessThread(#[from] web_apps::get_process_thread::Error),
    #[error(transparent)]
    WebApps_ListPublicCertificates(#[from] web_apps::list_public_certificates::Error),
    #[error(transparent)]
    WebApps_GetPublicCertificate(#[from] web_apps::get_public_certificate::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdatePublicCertificate(#[from] web_apps::create_or_update_public_certificate::Error),
    #[error(transparent)]
    WebApps_DeletePublicCertificate(#[from] web_apps::delete_public_certificate::Error),
    #[error(transparent)]
    WebApps_ListPublishingProfileXmlWithSecrets(#[from] web_apps::list_publishing_profile_xml_with_secrets::Error),
    #[error(transparent)]
    WebApps_ResetProductionSlotConfig(#[from] web_apps::reset_production_slot_config::Error),
    #[error(transparent)]
    WebApps_Restart(#[from] web_apps::restart::Error),
    #[error(transparent)]
    WebApps_RestoreFromBackupBlob(#[from] web_apps::restore_from_backup_blob::Error),
    #[error(transparent)]
    WebApps_RestoreFromDeletedApp(#[from] web_apps::restore_from_deleted_app::Error),
    #[error(transparent)]
    WebApps_RestoreSnapshot(#[from] web_apps::restore_snapshot::Error),
    #[error(transparent)]
    WebApps_ListSiteExtensions(#[from] web_apps::list_site_extensions::Error),
    #[error(transparent)]
    WebApps_GetSiteExtension(#[from] web_apps::get_site_extension::Error),
    #[error(transparent)]
    WebApps_InstallSiteExtension(#[from] web_apps::install_site_extension::Error),
    #[error(transparent)]
    WebApps_DeleteSiteExtension(#[from] web_apps::delete_site_extension::Error),
    #[error(transparent)]
    WebApps_ListSlots(#[from] web_apps::list_slots::Error),
    #[error(transparent)]
    WebApps_GetSlot(#[from] web_apps::get_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateSlot(#[from] web_apps::create_or_update_slot::Error),
    #[error(transparent)]
    WebApps_UpdateSlot(#[from] web_apps::update_slot::Error),
    #[error(transparent)]
    WebApps_DeleteSlot(#[from] web_apps::delete_slot::Error),
    #[error(transparent)]
    WebApps_AnalyzeCustomHostnameSlot(#[from] web_apps::analyze_custom_hostname_slot::Error),
    #[error(transparent)]
    WebApps_ApplySlotConfigurationSlot(#[from] web_apps::apply_slot_configuration_slot::Error),
    #[error(transparent)]
    WebApps_BackupSlot(#[from] web_apps::backup_slot::Error),
    #[error(transparent)]
    WebApps_ListBackupsSlot(#[from] web_apps::list_backups_slot::Error),
    #[error(transparent)]
    WebApps_GetBackupStatusSlot(#[from] web_apps::get_backup_status_slot::Error),
    #[error(transparent)]
    WebApps_DeleteBackupSlot(#[from] web_apps::delete_backup_slot::Error),
    #[error(transparent)]
    WebApps_ListBackupStatusSecretsSlot(#[from] web_apps::list_backup_status_secrets_slot::Error),
    #[error(transparent)]
    WebApps_RestoreSlot(#[from] web_apps::restore_slot::Error),
    #[error(transparent)]
    WebApps_ListConfigurationsSlot(#[from] web_apps::list_configurations_slot::Error),
    #[error(transparent)]
    WebApps_UpdateApplicationSettingsSlot(#[from] web_apps::update_application_settings_slot::Error),
    #[error(transparent)]
    WebApps_ListApplicationSettingsSlot(#[from] web_apps::list_application_settings_slot::Error),
    #[error(transparent)]
    WebApps_UpdateAuthSettingsSlot(#[from] web_apps::update_auth_settings_slot::Error),
    #[error(transparent)]
    WebApps_GetAuthSettingsSlot(#[from] web_apps::get_auth_settings_slot::Error),
    #[error(transparent)]
    WebApps_UpdateAzureStorageAccountsSlot(#[from] web_apps::update_azure_storage_accounts_slot::Error),
    #[error(transparent)]
    WebApps_ListAzureStorageAccountsSlot(#[from] web_apps::list_azure_storage_accounts_slot::Error),
    #[error(transparent)]
    WebApps_UpdateBackupConfigurationSlot(#[from] web_apps::update_backup_configuration_slot::Error),
    #[error(transparent)]
    WebApps_DeleteBackupConfigurationSlot(#[from] web_apps::delete_backup_configuration_slot::Error),
    #[error(transparent)]
    WebApps_GetBackupConfigurationSlot(#[from] web_apps::get_backup_configuration_slot::Error),
    #[error(transparent)]
    WebApps_UpdateConnectionStringsSlot(#[from] web_apps::update_connection_strings_slot::Error),
    #[error(transparent)]
    WebApps_ListConnectionStringsSlot(#[from] web_apps::list_connection_strings_slot::Error),
    #[error(transparent)]
    WebApps_GetDiagnosticLogsConfigurationSlot(#[from] web_apps::get_diagnostic_logs_configuration_slot::Error),
    #[error(transparent)]
    WebApps_UpdateDiagnosticLogsConfigSlot(#[from] web_apps::update_diagnostic_logs_config_slot::Error),
    #[error(transparent)]
    WebApps_UpdateMetadataSlot(#[from] web_apps::update_metadata_slot::Error),
    #[error(transparent)]
    WebApps_ListMetadataSlot(#[from] web_apps::list_metadata_slot::Error),
    #[error(transparent)]
    WebApps_ListPublishingCredentialsSlot(#[from] web_apps::list_publishing_credentials_slot::Error),
    #[error(transparent)]
    WebApps_UpdateSitePushSettingsSlot(#[from] web_apps::update_site_push_settings_slot::Error),
    #[error(transparent)]
    WebApps_ListSitePushSettingsSlot(#[from] web_apps::list_site_push_settings_slot::Error),
    #[error(transparent)]
    WebApps_GetConfigurationSlot(#[from] web_apps::get_configuration_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateConfigurationSlot(#[from] web_apps::create_or_update_configuration_slot::Error),
    #[error(transparent)]
    WebApps_UpdateConfigurationSlot(#[from] web_apps::update_configuration_slot::Error),
    #[error(transparent)]
    WebApps_ListConfigurationSnapshotInfoSlot(#[from] web_apps::list_configuration_snapshot_info_slot::Error),
    #[error(transparent)]
    WebApps_GetConfigurationSnapshotSlot(#[from] web_apps::get_configuration_snapshot_slot::Error),
    #[error(transparent)]
    WebApps_RecoverSiteConfigurationSnapshotSlot(#[from] web_apps::recover_site_configuration_snapshot_slot::Error),
    #[error(transparent)]
    WebApps_GetWebSiteContainerLogsSlot(#[from] web_apps::get_web_site_container_logs_slot::Error),
    #[error(transparent)]
    WebApps_GetContainerLogsZipSlot(#[from] web_apps::get_container_logs_zip_slot::Error),
    #[error(transparent)]
    WebApps_ListContinuousWebJobsSlot(#[from] web_apps::list_continuous_web_jobs_slot::Error),
    #[error(transparent)]
    WebApps_GetContinuousWebJobSlot(#[from] web_apps::get_continuous_web_job_slot::Error),
    #[error(transparent)]
    WebApps_DeleteContinuousWebJobSlot(#[from] web_apps::delete_continuous_web_job_slot::Error),
    #[error(transparent)]
    WebApps_StartContinuousWebJobSlot(#[from] web_apps::start_continuous_web_job_slot::Error),
    #[error(transparent)]
    WebApps_StopContinuousWebJobSlot(#[from] web_apps::stop_continuous_web_job_slot::Error),
    #[error(transparent)]
    WebApps_ListDeploymentsSlot(#[from] web_apps::list_deployments_slot::Error),
    #[error(transparent)]
    WebApps_GetDeploymentSlot(#[from] web_apps::get_deployment_slot::Error),
    #[error(transparent)]
    WebApps_CreateDeploymentSlot(#[from] web_apps::create_deployment_slot::Error),
    #[error(transparent)]
    WebApps_DeleteDeploymentSlot(#[from] web_apps::delete_deployment_slot::Error),
    #[error(transparent)]
    WebApps_ListDeploymentLogSlot(#[from] web_apps::list_deployment_log_slot::Error),
    #[error(transparent)]
    WebApps_DiscoverBackupSlot(#[from] web_apps::discover_backup_slot::Error),
    #[error(transparent)]
    WebApps_ListDomainOwnershipIdentifiersSlot(#[from] web_apps::list_domain_ownership_identifiers_slot::Error),
    #[error(transparent)]
    WebApps_GetDomainOwnershipIdentifierSlot(#[from] web_apps::get_domain_ownership_identifier_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateDomainOwnershipIdentifierSlot(#[from] web_apps::create_or_update_domain_ownership_identifier_slot::Error),
    #[error(transparent)]
    WebApps_UpdateDomainOwnershipIdentifierSlot(#[from] web_apps::update_domain_ownership_identifier_slot::Error),
    #[error(transparent)]
    WebApps_DeleteDomainOwnershipIdentifierSlot(#[from] web_apps::delete_domain_ownership_identifier_slot::Error),
    #[error(transparent)]
    WebApps_GetMsDeployStatusSlot(#[from] web_apps::get_ms_deploy_status_slot::Error),
    #[error(transparent)]
    WebApps_CreateMsDeployOperationSlot(#[from] web_apps::create_ms_deploy_operation_slot::Error),
    #[error(transparent)]
    WebApps_GetMsDeployLogSlot(#[from] web_apps::get_ms_deploy_log_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceFunctionsSlot(#[from] web_apps::list_instance_functions_slot::Error),
    #[error(transparent)]
    WebApps_GetFunctionsAdminTokenSlot(#[from] web_apps::get_functions_admin_token_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceFunctionSlot(#[from] web_apps::get_instance_function_slot::Error),
    #[error(transparent)]
    WebApps_CreateInstanceFunctionSlot(#[from] web_apps::create_instance_function_slot::Error),
    #[error(transparent)]
    WebApps_DeleteInstanceFunctionSlot(#[from] web_apps::delete_instance_function_slot::Error),
    #[error(transparent)]
    WebApps_ListFunctionSecretsSlot(#[from] web_apps::list_function_secrets_slot::Error),
    #[error(transparent)]
    WebApps_ListHostNameBindingsSlot(#[from] web_apps::list_host_name_bindings_slot::Error),
    #[error(transparent)]
    WebApps_GetHostNameBindingSlot(#[from] web_apps::get_host_name_binding_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateHostNameBindingSlot(#[from] web_apps::create_or_update_host_name_binding_slot::Error),
    #[error(transparent)]
    WebApps_DeleteHostNameBindingSlot(#[from] web_apps::delete_host_name_binding_slot::Error),
    #[error(transparent)]
    WebApps_GetHybridConnectionSlot(#[from] web_apps::get_hybrid_connection_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateHybridConnectionSlot(#[from] web_apps::create_or_update_hybrid_connection_slot::Error),
    #[error(transparent)]
    WebApps_UpdateHybridConnectionSlot(#[from] web_apps::update_hybrid_connection_slot::Error),
    #[error(transparent)]
    WebApps_DeleteHybridConnectionSlot(#[from] web_apps::delete_hybrid_connection_slot::Error),
    #[error(transparent)]
    WebApps_ListHybridConnectionKeysSlot(#[from] web_apps::list_hybrid_connection_keys_slot::Error),
    #[error(transparent)]
    WebApps_ListHybridConnectionsSlot(#[from] web_apps::list_hybrid_connections_slot::Error),
    #[error(transparent)]
    WebApps_ListRelayServiceConnectionsSlot(#[from] web_apps::list_relay_service_connections_slot::Error),
    #[error(transparent)]
    WebApps_GetRelayServiceConnectionSlot(#[from] web_apps::get_relay_service_connection_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateRelayServiceConnectionSlot(#[from] web_apps::create_or_update_relay_service_connection_slot::Error),
    #[error(transparent)]
    WebApps_UpdateRelayServiceConnectionSlot(#[from] web_apps::update_relay_service_connection_slot::Error),
    #[error(transparent)]
    WebApps_DeleteRelayServiceConnectionSlot(#[from] web_apps::delete_relay_service_connection_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceIdentifiersSlot(#[from] web_apps::list_instance_identifiers_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceMsDeployStatusSlot(#[from] web_apps::get_instance_ms_deploy_status_slot::Error),
    #[error(transparent)]
    WebApps_CreateInstanceMsDeployOperationSlot(#[from] web_apps::create_instance_ms_deploy_operation_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceMsDeployLogSlot(#[from] web_apps::get_instance_ms_deploy_log_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessesSlot(#[from] web_apps::list_instance_processes_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessSlot(#[from] web_apps::get_instance_process_slot::Error),
    #[error(transparent)]
    WebApps_DeleteInstanceProcessSlot(#[from] web_apps::delete_instance_process_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessDumpSlot(#[from] web_apps::get_instance_process_dump_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessModulesSlot(#[from] web_apps::list_instance_process_modules_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessModuleSlot(#[from] web_apps::get_instance_process_module_slot::Error),
    #[error(transparent)]
    WebApps_ListInstanceProcessThreadsSlot(#[from] web_apps::list_instance_process_threads_slot::Error),
    #[error(transparent)]
    WebApps_GetInstanceProcessThreadSlot(#[from] web_apps::get_instance_process_thread_slot::Error),
    #[error(transparent)]
    WebApps_IsCloneableSlot(#[from] web_apps::is_cloneable_slot::Error),
    #[error(transparent)]
    WebApps_ListSyncFunctionTriggersSlot(#[from] web_apps::list_sync_function_triggers_slot::Error),
    #[error(transparent)]
    WebApps_ListMetricDefinitionsSlot(#[from] web_apps::list_metric_definitions_slot::Error),
    #[error(transparent)]
    WebApps_ListMetricsSlot(#[from] web_apps::list_metrics_slot::Error),
    #[error(transparent)]
    WebApps_GetMigrateMySqlStatusSlot(#[from] web_apps::get_migrate_my_sql_status_slot::Error),
    #[error(transparent)]
    WebApps_GetSwiftVirtualNetworkConnectionSlot(#[from] web_apps::get_swift_virtual_network_connection_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateSwiftVirtualNetworkConnectionSlot(
        #[from] web_apps::create_or_update_swift_virtual_network_connection_slot::Error,
    ),
    #[error(transparent)]
    WebApps_UpdateSwiftVirtualNetworkConnectionSlot(#[from] web_apps::update_swift_virtual_network_connection_slot::Error),
    #[error(transparent)]
    WebApps_DeleteSwiftVirtualNetworkSlot(#[from] web_apps::delete_swift_virtual_network_slot::Error),
    #[error(transparent)]
    WebApps_ListNetworkFeaturesSlot(#[from] web_apps::list_network_features_slot::Error),
    #[error(transparent)]
    WebApps_GetNetworkTraceOperationSlot(#[from] web_apps::get_network_trace_operation_slot::Error),
    #[error(transparent)]
    WebApps_StartWebSiteNetworkTraceSlot(#[from] web_apps::start_web_site_network_trace_slot::Error),
    #[error(transparent)]
    WebApps_StartWebSiteNetworkTraceOperationSlot(#[from] web_apps::start_web_site_network_trace_operation_slot::Error),
    #[error(transparent)]
    WebApps_StopWebSiteNetworkTraceSlot(#[from] web_apps::stop_web_site_network_trace_slot::Error),
    #[error(transparent)]
    WebApps_GetNetworkTracesSlot(#[from] web_apps::get_network_traces_slot::Error),
    #[error(transparent)]
    WebApps_GetNetworkTraceOperationSlotV2(#[from] web_apps::get_network_trace_operation_slot_v2::Error),
    #[error(transparent)]
    WebApps_GetNetworkTracesSlotV2(#[from] web_apps::get_network_traces_slot_v2::Error),
    #[error(transparent)]
    WebApps_GenerateNewSitePublishingPasswordSlot(#[from] web_apps::generate_new_site_publishing_password_slot::Error),
    #[error(transparent)]
    WebApps_ListPerfMonCountersSlot(#[from] web_apps::list_perf_mon_counters_slot::Error),
    #[error(transparent)]
    WebApps_GetSitePhpErrorLogFlagSlot(#[from] web_apps::get_site_php_error_log_flag_slot::Error),
    #[error(transparent)]
    WebApps_ListPremierAddOnsSlot(#[from] web_apps::list_premier_add_ons_slot::Error),
    #[error(transparent)]
    WebApps_GetPremierAddOnSlot(#[from] web_apps::get_premier_add_on_slot::Error),
    #[error(transparent)]
    WebApps_AddPremierAddOnSlot(#[from] web_apps::add_premier_add_on_slot::Error),
    #[error(transparent)]
    WebApps_UpdatePremierAddOnSlot(#[from] web_apps::update_premier_add_on_slot::Error),
    #[error(transparent)]
    WebApps_DeletePremierAddOnSlot(#[from] web_apps::delete_premier_add_on_slot::Error),
    #[error(transparent)]
    WebApps_GetPrivateAccessSlot(#[from] web_apps::get_private_access_slot::Error),
    #[error(transparent)]
    WebApps_PutPrivateAccessVnetSlot(#[from] web_apps::put_private_access_vnet_slot::Error),
    #[error(transparent)]
    WebApps_ListProcessesSlot(#[from] web_apps::list_processes_slot::Error),
    #[error(transparent)]
    WebApps_GetProcessSlot(#[from] web_apps::get_process_slot::Error),
    #[error(transparent)]
    WebApps_DeleteProcessSlot(#[from] web_apps::delete_process_slot::Error),
    #[error(transparent)]
    WebApps_GetProcessDumpSlot(#[from] web_apps::get_process_dump_slot::Error),
    #[error(transparent)]
    WebApps_ListProcessModulesSlot(#[from] web_apps::list_process_modules_slot::Error),
    #[error(transparent)]
    WebApps_GetProcessModuleSlot(#[from] web_apps::get_process_module_slot::Error),
    #[error(transparent)]
    WebApps_ListProcessThreadsSlot(#[from] web_apps::list_process_threads_slot::Error),
    #[error(transparent)]
    WebApps_GetProcessThreadSlot(#[from] web_apps::get_process_thread_slot::Error),
    #[error(transparent)]
    WebApps_ListPublicCertificatesSlot(#[from] web_apps::list_public_certificates_slot::Error),
    #[error(transparent)]
    WebApps_GetPublicCertificateSlot(#[from] web_apps::get_public_certificate_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdatePublicCertificateSlot(#[from] web_apps::create_or_update_public_certificate_slot::Error),
    #[error(transparent)]
    WebApps_DeletePublicCertificateSlot(#[from] web_apps::delete_public_certificate_slot::Error),
    #[error(transparent)]
    WebApps_ListPublishingProfileXmlWithSecretsSlot(#[from] web_apps::list_publishing_profile_xml_with_secrets_slot::Error),
    #[error(transparent)]
    WebApps_ResetSlotConfigurationSlot(#[from] web_apps::reset_slot_configuration_slot::Error),
    #[error(transparent)]
    WebApps_RestartSlot(#[from] web_apps::restart_slot::Error),
    #[error(transparent)]
    WebApps_RestoreFromBackupBlobSlot(#[from] web_apps::restore_from_backup_blob_slot::Error),
    #[error(transparent)]
    WebApps_RestoreFromDeletedAppSlot(#[from] web_apps::restore_from_deleted_app_slot::Error),
    #[error(transparent)]
    WebApps_RestoreSnapshotSlot(#[from] web_apps::restore_snapshot_slot::Error),
    #[error(transparent)]
    WebApps_ListSiteExtensionsSlot(#[from] web_apps::list_site_extensions_slot::Error),
    #[error(transparent)]
    WebApps_GetSiteExtensionSlot(#[from] web_apps::get_site_extension_slot::Error),
    #[error(transparent)]
    WebApps_InstallSiteExtensionSlot(#[from] web_apps::install_site_extension_slot::Error),
    #[error(transparent)]
    WebApps_DeleteSiteExtensionSlot(#[from] web_apps::delete_site_extension_slot::Error),
    #[error(transparent)]
    WebApps_ListSlotDifferencesSlot(#[from] web_apps::list_slot_differences_slot::Error),
    #[error(transparent)]
    WebApps_SwapSlotSlot(#[from] web_apps::swap_slot_slot::Error),
    #[error(transparent)]
    WebApps_ListSnapshotsSlot(#[from] web_apps::list_snapshots_slot::Error),
    #[error(transparent)]
    WebApps_ListSnapshotsFromDrSecondarySlot(#[from] web_apps::list_snapshots_from_dr_secondary_slot::Error),
    #[error(transparent)]
    WebApps_GetSourceControlSlot(#[from] web_apps::get_source_control_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateSourceControlSlot(#[from] web_apps::create_or_update_source_control_slot::Error),
    #[error(transparent)]
    WebApps_UpdateSourceControlSlot(#[from] web_apps::update_source_control_slot::Error),
    #[error(transparent)]
    WebApps_DeleteSourceControlSlot(#[from] web_apps::delete_source_control_slot::Error),
    #[error(transparent)]
    WebApps_StartSlot(#[from] web_apps::start_slot::Error),
    #[error(transparent)]
    WebApps_StartNetworkTraceSlot(#[from] web_apps::start_network_trace_slot::Error),
    #[error(transparent)]
    WebApps_StopSlot(#[from] web_apps::stop_slot::Error),
    #[error(transparent)]
    WebApps_StopNetworkTraceSlot(#[from] web_apps::stop_network_trace_slot::Error),
    #[error(transparent)]
    WebApps_SyncRepositorySlot(#[from] web_apps::sync_repository_slot::Error),
    #[error(transparent)]
    WebApps_SyncFunctionTriggersSlot(#[from] web_apps::sync_function_triggers_slot::Error),
    #[error(transparent)]
    WebApps_ListTriggeredWebJobsSlot(#[from] web_apps::list_triggered_web_jobs_slot::Error),
    #[error(transparent)]
    WebApps_GetTriggeredWebJobSlot(#[from] web_apps::get_triggered_web_job_slot::Error),
    #[error(transparent)]
    WebApps_DeleteTriggeredWebJobSlot(#[from] web_apps::delete_triggered_web_job_slot::Error),
    #[error(transparent)]
    WebApps_ListTriggeredWebJobHistorySlot(#[from] web_apps::list_triggered_web_job_history_slot::Error),
    #[error(transparent)]
    WebApps_GetTriggeredWebJobHistorySlot(#[from] web_apps::get_triggered_web_job_history_slot::Error),
    #[error(transparent)]
    WebApps_RunTriggeredWebJobSlot(#[from] web_apps::run_triggered_web_job_slot::Error),
    #[error(transparent)]
    WebApps_ListUsagesSlot(#[from] web_apps::list_usages_slot::Error),
    #[error(transparent)]
    WebApps_ListVnetConnectionsSlot(#[from] web_apps::list_vnet_connections_slot::Error),
    #[error(transparent)]
    WebApps_GetVnetConnectionSlot(#[from] web_apps::get_vnet_connection_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateVnetConnectionSlot(#[from] web_apps::create_or_update_vnet_connection_slot::Error),
    #[error(transparent)]
    WebApps_UpdateVnetConnectionSlot(#[from] web_apps::update_vnet_connection_slot::Error),
    #[error(transparent)]
    WebApps_DeleteVnetConnectionSlot(#[from] web_apps::delete_vnet_connection_slot::Error),
    #[error(transparent)]
    WebApps_GetVnetConnectionGatewaySlot(#[from] web_apps::get_vnet_connection_gateway_slot::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateVnetConnectionGatewaySlot(#[from] web_apps::create_or_update_vnet_connection_gateway_slot::Error),
    #[error(transparent)]
    WebApps_UpdateVnetConnectionGatewaySlot(#[from] web_apps::update_vnet_connection_gateway_slot::Error),
    #[error(transparent)]
    WebApps_ListWebJobsSlot(#[from] web_apps::list_web_jobs_slot::Error),
    #[error(transparent)]
    WebApps_GetWebJobSlot(#[from] web_apps::get_web_job_slot::Error),
    #[error(transparent)]
    WebApps_ListSlotDifferencesFromProduction(#[from] web_apps::list_slot_differences_from_production::Error),
    #[error(transparent)]
    WebApps_SwapSlotWithProduction(#[from] web_apps::swap_slot_with_production::Error),
    #[error(transparent)]
    WebApps_ListSnapshots(#[from] web_apps::list_snapshots::Error),
    #[error(transparent)]
    WebApps_ListSnapshotsFromDrSecondary(#[from] web_apps::list_snapshots_from_dr_secondary::Error),
    #[error(transparent)]
    WebApps_GetSourceControl(#[from] web_apps::get_source_control::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateSourceControl(#[from] web_apps::create_or_update_source_control::Error),
    #[error(transparent)]
    WebApps_UpdateSourceControl(#[from] web_apps::update_source_control::Error),
    #[error(transparent)]
    WebApps_DeleteSourceControl(#[from] web_apps::delete_source_control::Error),
    #[error(transparent)]
    WebApps_Start(#[from] web_apps::start::Error),
    #[error(transparent)]
    WebApps_StartNetworkTrace(#[from] web_apps::start_network_trace::Error),
    #[error(transparent)]
    WebApps_Stop(#[from] web_apps::stop::Error),
    #[error(transparent)]
    WebApps_StopNetworkTrace(#[from] web_apps::stop_network_trace::Error),
    #[error(transparent)]
    WebApps_SyncRepository(#[from] web_apps::sync_repository::Error),
    #[error(transparent)]
    WebApps_SyncFunctionTriggers(#[from] web_apps::sync_function_triggers::Error),
    #[error(transparent)]
    WebApps_ListTriggeredWebJobs(#[from] web_apps::list_triggered_web_jobs::Error),
    #[error(transparent)]
    WebApps_GetTriggeredWebJob(#[from] web_apps::get_triggered_web_job::Error),
    #[error(transparent)]
    WebApps_DeleteTriggeredWebJob(#[from] web_apps::delete_triggered_web_job::Error),
    #[error(transparent)]
    WebApps_ListTriggeredWebJobHistory(#[from] web_apps::list_triggered_web_job_history::Error),
    #[error(transparent)]
    WebApps_GetTriggeredWebJobHistory(#[from] web_apps::get_triggered_web_job_history::Error),
    #[error(transparent)]
    WebApps_RunTriggeredWebJob(#[from] web_apps::run_triggered_web_job::Error),
    #[error(transparent)]
    WebApps_ListUsages(#[from] web_apps::list_usages::Error),
    #[error(transparent)]
    WebApps_ListVnetConnections(#[from] web_apps::list_vnet_connections::Error),
    #[error(transparent)]
    WebApps_GetVnetConnection(#[from] web_apps::get_vnet_connection::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateVnetConnection(#[from] web_apps::create_or_update_vnet_connection::Error),
    #[error(transparent)]
    WebApps_UpdateVnetConnection(#[from] web_apps::update_vnet_connection::Error),
    #[error(transparent)]
    WebApps_DeleteVnetConnection(#[from] web_apps::delete_vnet_connection::Error),
    #[error(transparent)]
    WebApps_GetVnetConnectionGateway(#[from] web_apps::get_vnet_connection_gateway::Error),
    #[error(transparent)]
    WebApps_CreateOrUpdateVnetConnectionGateway(#[from] web_apps::create_or_update_vnet_connection_gateway::Error),
    #[error(transparent)]
    WebApps_UpdateVnetConnectionGateway(#[from] web_apps::update_vnet_connection_gateway::Error),
    #[error(transparent)]
    WebApps_ListWebJobs(#[from] web_apps::list_web_jobs::Error),
    #[error(transparent)]
    WebApps_GetWebJob(#[from] web_apps::get_web_job::Error),
    #[error(transparent)]
    AppServiceEnvironments_List(#[from] app_service_environments::list::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListByResourceGroup(#[from] app_service_environments::list_by_resource_group::Error),
    #[error(transparent)]
    AppServiceEnvironments_Get(#[from] app_service_environments::get::Error),
    #[error(transparent)]
    AppServiceEnvironments_CreateOrUpdate(#[from] app_service_environments::create_or_update::Error),
    #[error(transparent)]
    AppServiceEnvironments_Update(#[from] app_service_environments::update::Error),
    #[error(transparent)]
    AppServiceEnvironments_Delete(#[from] app_service_environments::delete::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListCapacities(#[from] app_service_environments::list_capacities::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListVips(#[from] app_service_environments::list_vips::Error),
    #[error(transparent)]
    AppServiceEnvironments_ChangeVnet(#[from] app_service_environments::change_vnet::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListDiagnostics(#[from] app_service_environments::list_diagnostics::Error),
    #[error(transparent)]
    AppServiceEnvironments_GetDiagnosticsItem(#[from] app_service_environments::get_diagnostics_item::Error),
    #[error(transparent)]
    AppServiceEnvironments_GetInboundNetworkDependenciesEndpoints(
        #[from] app_service_environments::get_inbound_network_dependencies_endpoints::Error,
    ),
    #[error(transparent)]
    AppServiceEnvironments_ListMetricDefinitions(#[from] app_service_environments::list_metric_definitions::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListMetrics(#[from] app_service_environments::list_metrics::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListMultiRolePools(#[from] app_service_environments::list_multi_role_pools::Error),
    #[error(transparent)]
    AppServiceEnvironments_GetMultiRolePool(#[from] app_service_environments::get_multi_role_pool::Error),
    #[error(transparent)]
    AppServiceEnvironments_CreateOrUpdateMultiRolePool(#[from] app_service_environments::create_or_update_multi_role_pool::Error),
    #[error(transparent)]
    AppServiceEnvironments_UpdateMultiRolePool(#[from] app_service_environments::update_multi_role_pool::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListMultiRolePoolInstanceMetricDefinitions(
        #[from] app_service_environments::list_multi_role_pool_instance_metric_definitions::Error,
    ),
    #[error(transparent)]
    AppServiceEnvironments_ListMultiRolePoolInstanceMetrics(#[from] app_service_environments::list_multi_role_pool_instance_metrics::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListMultiRoleMetricDefinitions(#[from] app_service_environments::list_multi_role_metric_definitions::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListMultiRoleMetrics(#[from] app_service_environments::list_multi_role_metrics::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListMultiRolePoolSkus(#[from] app_service_environments::list_multi_role_pool_skus::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListMultiRoleUsages(#[from] app_service_environments::list_multi_role_usages::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListOperations(#[from] app_service_environments::list_operations::Error),
    #[error(transparent)]
    AppServiceEnvironments_GetOutboundNetworkDependenciesEndpoints(
        #[from] app_service_environments::get_outbound_network_dependencies_endpoints::Error,
    ),
    #[error(transparent)]
    AppServiceEnvironments_Reboot(#[from] app_service_environments::reboot::Error),
    #[error(transparent)]
    AppServiceEnvironments_Resume(#[from] app_service_environments::resume::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListAppServicePlans(#[from] app_service_environments::list_app_service_plans::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListWebApps(#[from] app_service_environments::list_web_apps::Error),
    #[error(transparent)]
    AppServiceEnvironments_Suspend(#[from] app_service_environments::suspend::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListUsages(#[from] app_service_environments::list_usages::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListWorkerPools(#[from] app_service_environments::list_worker_pools::Error),
    #[error(transparent)]
    AppServiceEnvironments_GetWorkerPool(#[from] app_service_environments::get_worker_pool::Error),
    #[error(transparent)]
    AppServiceEnvironments_CreateOrUpdateWorkerPool(#[from] app_service_environments::create_or_update_worker_pool::Error),
    #[error(transparent)]
    AppServiceEnvironments_UpdateWorkerPool(#[from] app_service_environments::update_worker_pool::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListWorkerPoolInstanceMetricDefinitions(
        #[from] app_service_environments::list_worker_pool_instance_metric_definitions::Error,
    ),
    #[error(transparent)]
    AppServiceEnvironments_ListWorkerPoolInstanceMetrics(#[from] app_service_environments::list_worker_pool_instance_metrics::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListWebWorkerMetricDefinitions(#[from] app_service_environments::list_web_worker_metric_definitions::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListWebWorkerMetrics(#[from] app_service_environments::list_web_worker_metrics::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListWorkerPoolSkus(#[from] app_service_environments::list_worker_pool_skus::Error),
    #[error(transparent)]
    AppServiceEnvironments_ListWebWorkerUsages(#[from] app_service_environments::list_web_worker_usages::Error),
    #[error(transparent)]
    AppServicePlans_List(#[from] app_service_plans::list::Error),
    #[error(transparent)]
    AppServicePlans_ListByResourceGroup(#[from] app_service_plans::list_by_resource_group::Error),
    #[error(transparent)]
    AppServicePlans_Get(#[from] app_service_plans::get::Error),
    #[error(transparent)]
    AppServicePlans_CreateOrUpdate(#[from] app_service_plans::create_or_update::Error),
    #[error(transparent)]
    AppServicePlans_Update(#[from] app_service_plans::update::Error),
    #[error(transparent)]
    AppServicePlans_Delete(#[from] app_service_plans::delete::Error),
    #[error(transparent)]
    AppServicePlans_ListCapabilities(#[from] app_service_plans::list_capabilities::Error),
    #[error(transparent)]
    AppServicePlans_GetHybridConnection(#[from] app_service_plans::get_hybrid_connection::Error),
    #[error(transparent)]
    AppServicePlans_DeleteHybridConnection(#[from] app_service_plans::delete_hybrid_connection::Error),
    #[error(transparent)]
    AppServicePlans_ListHybridConnectionKeys(#[from] app_service_plans::list_hybrid_connection_keys::Error),
    #[error(transparent)]
    AppServicePlans_ListWebAppsByHybridConnection(#[from] app_service_plans::list_web_apps_by_hybrid_connection::Error),
    #[error(transparent)]
    AppServicePlans_GetHybridConnectionPlanLimit(#[from] app_service_plans::get_hybrid_connection_plan_limit::Error),
    #[error(transparent)]
    AppServicePlans_ListHybridConnections(#[from] app_service_plans::list_hybrid_connections::Error),
    #[error(transparent)]
    AppServicePlans_ListMetricDefintions(#[from] app_service_plans::list_metric_defintions::Error),
    #[error(transparent)]
    AppServicePlans_ListMetrics(#[from] app_service_plans::list_metrics::Error),
    #[error(transparent)]
    AppServicePlans_RestartWebApps(#[from] app_service_plans::restart_web_apps::Error),
    #[error(transparent)]
    AppServicePlans_ListWebApps(#[from] app_service_plans::list_web_apps::Error),
    #[error(transparent)]
    AppServicePlans_GetServerFarmSkus(#[from] app_service_plans::get_server_farm_skus::Error),
    #[error(transparent)]
    AppServicePlans_ListUsages(#[from] app_service_plans::list_usages::Error),
    #[error(transparent)]
    AppServicePlans_ListVnets(#[from] app_service_plans::list_vnets::Error),
    #[error(transparent)]
    AppServicePlans_GetVnetFromServerFarm(#[from] app_service_plans::get_vnet_from_server_farm::Error),
    #[error(transparent)]
    AppServicePlans_GetVnetGateway(#[from] app_service_plans::get_vnet_gateway::Error),
    #[error(transparent)]
    AppServicePlans_UpdateVnetGateway(#[from] app_service_plans::update_vnet_gateway::Error),
    #[error(transparent)]
    AppServicePlans_ListRoutesForVnet(#[from] app_service_plans::list_routes_for_vnet::Error),
    #[error(transparent)]
    AppServicePlans_GetRouteForVnet(#[from] app_service_plans::get_route_for_vnet::Error),
    #[error(transparent)]
    AppServicePlans_CreateOrUpdateVnetRoute(#[from] app_service_plans::create_or_update_vnet_route::Error),
    #[error(transparent)]
    AppServicePlans_UpdateVnetRoute(#[from] app_service_plans::update_vnet_route::Error),
    #[error(transparent)]
    AppServicePlans_DeleteVnetRoute(#[from] app_service_plans::delete_vnet_route::Error),
    #[error(transparent)]
    AppServicePlans_RebootWorker(#[from] app_service_plans::reboot_worker::Error),
    #[error(transparent)]
    ResourceHealthMetadata_List(#[from] resource_health_metadata::list::Error),
    #[error(transparent)]
    ResourceHealthMetadata_ListByResourceGroup(#[from] resource_health_metadata::list_by_resource_group::Error),
    #[error(transparent)]
    ResourceHealthMetadata_ListBySite(#[from] resource_health_metadata::list_by_site::Error),
    #[error(transparent)]
    ResourceHealthMetadata_GetBySite(#[from] resource_health_metadata::get_by_site::Error),
    #[error(transparent)]
    ResourceHealthMetadata_ListBySiteSlot(#[from] resource_health_metadata::list_by_site_slot::Error),
    #[error(transparent)]
    ResourceHealthMetadata_GetBySiteSlot(#[from] resource_health_metadata::get_by_site_slot::Error),
}
pub mod app_service_certificate_orders {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "List all certificate orders in a subscription."]
        pub fn list(&self, subscription_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Validate information for a certificate order."]
        pub fn validate_purchase_information(
            &self,
            app_service_certificate_order: impl Into<models::AppServiceCertificateOrder>,
            subscription_id: impl Into<String>,
        ) -> validate_purchase_information::Builder {
            validate_purchase_information::Builder {
                client: self.0.clone(),
                app_service_certificate_order: app_service_certificate_order.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get certificate orders in a resource group."]
        pub fn list_by_resource_group(
            &self,
            resource_group_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_by_resource_group::Builder {
            list_by_resource_group::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a certificate order."]
        pub fn get(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create or update a certificate purchase order."]
        pub fn create_or_update(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            certificate_distinguished_name: impl Into<models::AppServiceCertificateOrder>,
            subscription_id: impl Into<String>,
        ) -> create_or_update::Builder {
            create_or_update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                certificate_distinguished_name: certificate_distinguished_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create or update a certificate purchase order."]
        pub fn update(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            certificate_distinguished_name: impl Into<models::AppServiceCertificateOrderPatchResource>,
            subscription_id: impl Into<String>,
        ) -> update::Builder {
            update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                certificate_distinguished_name: certificate_distinguished_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete an existing certificate order."]
        pub fn delete(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List all certificates associated with a certificate order."]
        pub fn list_certificates(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_certificates::Builder {
            list_certificates::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the certificate associated with a certificate order."]
        pub fn get_certificate(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_certificate::Builder {
            get_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates or updates a certificate and associates with key vault secret."]
        pub fn create_or_update_certificate(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            name: impl Into<String>,
            key_vault_certificate: impl Into<models::AppServiceCertificateResource>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_certificate::Builder {
            create_or_update_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                name: name.into(),
                key_vault_certificate: key_vault_certificate.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates or updates a certificate and associates with key vault secret."]
        pub fn update_certificate(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            name: impl Into<String>,
            key_vault_certificate: impl Into<models::AppServiceCertificatePatchResource>,
            subscription_id: impl Into<String>,
        ) -> update_certificate::Builder {
            update_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                name: name.into(),
                key_vault_certificate: key_vault_certificate.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete the certificate associated with a certificate order."]
        pub fn delete_certificate(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_certificate::Builder {
            delete_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Reissue an existing certificate order."]
        pub fn reissue(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            reissue_certificate_order_request: impl Into<models::ReissueCertificateOrderRequest>,
            subscription_id: impl Into<String>,
        ) -> reissue::Builder {
            reissue::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                reissue_certificate_order_request: reissue_certificate_order_request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Renew an existing certificate order."]
        pub fn renew(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            renew_certificate_order_request: impl Into<models::RenewCertificateOrderRequest>,
            subscription_id: impl Into<String>,
        ) -> renew::Builder {
            renew::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                renew_certificate_order_request: renew_certificate_order_request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Resend certificate email."]
        pub fn resend_email(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> resend_email::Builder {
            resend_email::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Verify domain ownership for this certificate order."]
        pub fn resend_request_emails(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            name_identifier: impl Into<models::NameIdentifier>,
            subscription_id: impl Into<String>,
        ) -> resend_request_emails::Builder {
            resend_request_emails::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                name_identifier: name_identifier.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Verify domain ownership for this certificate order."]
        pub fn retrieve_site_seal(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            site_seal_request: impl Into<models::SiteSealRequest>,
            subscription_id: impl Into<String>,
        ) -> retrieve_site_seal::Builder {
            retrieve_site_seal::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                site_seal_request: site_seal_request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Verify domain ownership for this certificate order."]
        pub fn verify_domain_ownership(
            &self,
            resource_group_name: impl Into<String>,
            certificate_order_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> verify_domain_ownership::Builder {
            verify_domain_ownership::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                certificate_order_name: certificate_order_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieve the list of certificate actions."]
        pub fn retrieve_certificate_actions(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> retrieve_certificate_actions::Builder {
            retrieve_certificate_actions::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieve email history."]
        pub fn retrieve_certificate_email_history(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> retrieve_certificate_email_history::Builder {
            retrieve_certificate_email_history::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::AppServiceCertificateOrderCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.CertificateRegistration/certificateOrders",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateOrderCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod validate_purchase_information {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) app_service_certificate_order: models::AppServiceCertificateOrder,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.CertificateRegistration/validateCertificateRegistrationInformation",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.app_service_certificate_order).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_by_resource_group {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::AppServiceCertificateOrderCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateOrderCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::AppServiceCertificateOrder, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.certificate_order_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateOrder =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::AppServiceCertificateOrder),
            Created201(models::AppServiceCertificateOrder),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) certificate_distinguished_name: models::AppServiceCertificateOrder,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.certificate_order_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.certificate_distinguished_name).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateOrder =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::CREATED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateOrder =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Created201(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::AppServiceCertificateOrder),
            Created201(models::AppServiceCertificateOrder),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) certificate_distinguished_name: models::AppServiceCertificateOrderPatchResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.certificate_order_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.certificate_distinguished_name).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateOrder =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::CREATED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateOrder =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Created201(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.certificate_order_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_certificates {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::AppServiceCertificateCollection, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/certificates" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . certificate_order_name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_certificate {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::AppServiceCertificateResource, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/certificates/{}" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . certificate_order_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_certificate {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::AppServiceCertificateResource),
            Created201(models::AppServiceCertificateResource),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) name: String,
            pub(crate) key_vault_certificate: models::AppServiceCertificateResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/certificates/{}" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . certificate_order_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.key_vault_certificate).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::CREATED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Created201(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_certificate {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::AppServiceCertificateResource),
            Created201(models::AppServiceCertificateResource),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) name: String,
            pub(crate) key_vault_certificate: models::AppServiceCertificatePatchResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/certificates/{}" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . certificate_order_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.key_vault_certificate).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::CREATED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AppServiceCertificateResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Created201(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_certificate {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/certificates/{}" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . certificate_order_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod reissue {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) reissue_certificate_order_request: models::ReissueCertificateOrderRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/reissue",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.certificate_order_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.reissue_certificate_order_request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod renew {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) renew_certificate_order_request: models::RenewCertificateOrderRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/renew",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.certificate_order_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.renew_certificate_order_request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod resend_email {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/resendEmail" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . certificate_order_name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod resend_request_emails {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) name_identifier: models::NameIdentifier,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/resendRequestEmails" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . certificate_order_name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.name_identifier).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod retrieve_site_seal {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) site_seal_request: models::SiteSealRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteSeal, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/retrieveSiteSeal" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . certificate_order_name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_seal_request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteSeal =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod verify_domain_ownership {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) certificate_order_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/verifyDomainOwnership" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . certificate_order_name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod retrieve_certificate_actions {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<Vec<models::CertificateOrderAction>, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/retrieveCertificateActions" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: Vec<models::CertificateOrderAction> =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod retrieve_certificate_email_history {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Vec<models::CertificateEmail>, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.CertificateRegistration/certificateOrders/{}/retrieveEmailHistory" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: Vec<models::CertificateEmail> =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod certificate_registration_provider {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Implements Csm operations Api to exposes the list of available Csm Apis under the resource provider"]
        pub fn list_operations(&self) -> list_operations::Builder {
            list_operations::Builder { client: self.0.clone() }
        }
    }
    pub mod list_operations {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CsmOperationCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/providers/Microsoft.CertificateRegistration/operations", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CsmOperationCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod domains {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Check if a domain is available for registration."]
        pub fn check_availability(
            &self,
            identifier: impl Into<models::NameIdentifier>,
            subscription_id: impl Into<String>,
        ) -> check_availability::Builder {
            check_availability::Builder {
                client: self.0.clone(),
                identifier: identifier.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get all domains in a subscription."]
        pub fn list(&self, subscription_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Generate a single sign-on request for the domain management portal."]
        pub fn get_control_center_sso_request(&self, subscription_id: impl Into<String>) -> get_control_center_sso_request::Builder {
            get_control_center_sso_request::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get domain name recommendations based on keywords."]
        pub fn list_recommendations(
            &self,
            parameters: impl Into<models::DomainRecommendationSearchParameters>,
            subscription_id: impl Into<String>,
        ) -> list_recommendations::Builder {
            list_recommendations::Builder {
                client: self.0.clone(),
                parameters: parameters.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get all domains in a resource group."]
        pub fn list_by_resource_group(
            &self,
            resource_group_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_by_resource_group::Builder {
            list_by_resource_group::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a domain."]
        pub fn get(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates or updates a domain."]
        pub fn create_or_update(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            domain: impl Into<models::Domain>,
            subscription_id: impl Into<String>,
        ) -> create_or_update::Builder {
            create_or_update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                domain: domain.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates or updates a domain."]
        pub fn update(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            domain: impl Into<models::DomainPatchResource>,
            subscription_id: impl Into<String>,
        ) -> update::Builder {
            update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                domain: domain.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a domain."]
        pub fn delete(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                subscription_id: subscription_id.into(),
                force_hard_delete_domain: None,
            }
        }
        #[doc = "Lists domain ownership identifiers."]
        pub fn list_ownership_identifiers(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_ownership_identifiers::Builder {
            list_ownership_identifiers::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get ownership identifier for domain"]
        pub fn get_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_ownership_identifier::Builder {
            get_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates an ownership identifier for a domain or updates identifier details for an existing identifier"]
        pub fn create_or_update_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::DomainOwnershipIdentifier>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_ownership_identifier::Builder {
            create_or_update_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                name: name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates an ownership identifier for a domain or updates identifier details for an existing identifier"]
        pub fn update_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::DomainOwnershipIdentifier>,
            subscription_id: impl Into<String>,
        ) -> update_ownership_identifier::Builder {
            update_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                name: name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete ownership identifier for domain"]
        pub fn delete_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_ownership_identifier::Builder {
            delete_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Renew a domain."]
        pub fn renew(
            &self,
            resource_group_name: impl Into<String>,
            domain_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> renew::Builder {
            renew::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                domain_name: domain_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
    }
    pub mod check_availability {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) identifier: models::NameIdentifier,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DomainAvailablilityCheckResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.DomainRegistration/checkDomainAvailability",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.identifier).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DomainAvailablilityCheckResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DomainCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.DomainRegistration/domains",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DomainCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_control_center_sso_request {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DomainControlCenterSsoRequest, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.DomainRegistration/generateSsoRequest",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DomainControlCenterSsoRequest =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_recommendations {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) parameters: models::DomainRecommendationSearchParameters,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NameIdentifierCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.DomainRegistration/listDomainRecommendations",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.parameters).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::NameIdentifierCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_by_resource_group {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DomainCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DomainCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Domain, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.domain_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Domain =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Accepted202(models::Domain),
            Ok200(models::Domain),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) domain: models::Domain,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.domain_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.domain).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Domain =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Accepted202(rsp_value))
                        }
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Domain =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Accepted202(models::Domain),
            Ok200(models::Domain),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) domain: models::DomainPatchResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.domain_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.domain).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Domain =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Accepted202(rsp_value))
                        }
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Domain =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) subscription_id: String,
            pub(crate) force_hard_delete_domain: Option<bool>,
        }
        impl Builder {
            pub fn force_hard_delete_domain(mut self, force_hard_delete_domain: bool) -> Self {
                self.force_hard_delete_domain = Some(force_hard_delete_domain);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.domain_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(force_hard_delete_domain) = &self.force_hard_delete_domain {
                        url.query_pairs_mut()
                            .append_pair("forceHardDeleteDomain", &force_hard_delete_domain.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_ownership_identifiers {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DomainOwnershipIdentifierCollection, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}/domainOwnershipIdentifiers" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . domain_name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DomainOwnershipIdentifierCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_ownership_identifier {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DomainOwnershipIdentifier, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}/domainOwnershipIdentifiers/{}" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . domain_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DomainOwnershipIdentifier =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_ownership_identifier {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) name: String,
            pub(crate) domain_ownership_identifier: models::DomainOwnershipIdentifier,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DomainOwnershipIdentifier, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}/domainOwnershipIdentifiers/{}" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . domain_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.domain_ownership_identifier).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DomainOwnershipIdentifier =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_ownership_identifier {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) name: String,
            pub(crate) domain_ownership_identifier: models::DomainOwnershipIdentifier,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DomainOwnershipIdentifier, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}/domainOwnershipIdentifiers/{}" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . domain_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.domain_ownership_identifier).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DomainOwnershipIdentifier =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_ownership_identifier {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}/domainOwnershipIdentifiers/{}" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . domain_name , & self . name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod renew {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            Accepted202,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            BadRequest400 {},
            #[error("Error response #response_type")]
            InternalServerError500 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) domain_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.DomainRegistration/domains/{}/renew",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.domain_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::ACCEPTED => Ok(Response::Accepted202),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        http::StatusCode::BAD_REQUEST => Err(Error::BadRequest400 {}),
                        http::StatusCode::INTERNAL_SERVER_ERROR => Err(Error::InternalServerError500 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod top_level_domains {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Get all top-level domains supported for registration."]
        pub fn list(&self, subscription_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get details of a top-level domain."]
        pub fn get(&self, name: impl Into<String>, subscription_id: impl Into<String>) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all legal agreements that user needs to accept before purchasing a domain."]
        pub fn list_agreements(
            &self,
            name: impl Into<String>,
            agreement_option: impl Into<models::TopLevelDomainAgreementOption>,
            subscription_id: impl Into<String>,
        ) -> list_agreements::Builder {
            list_agreements::Builder {
                client: self.0.clone(),
                name: name.into(),
                agreement_option: agreement_option.into(),
                subscription_id: subscription_id.into(),
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::TopLevelDomainCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.DomainRegistration/topLevelDomains",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::TopLevelDomainCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::TopLevelDomain, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.DomainRegistration/topLevelDomains/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::TopLevelDomain =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_agreements {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) name: String,
            pub(crate) agreement_option: models::TopLevelDomainAgreementOption,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::TldLegalAgreementCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.DomainRegistration/topLevelDomains/{}/listAgreements",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.agreement_option).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::TldLegalAgreementCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod domain_registration_provider {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Implements Csm operations Api to exposes the list of available Csm Apis under the resource provider"]
        pub fn list_operations(&self) -> list_operations::Builder {
            list_operations::Builder { client: self.0.clone() }
        }
    }
    pub mod list_operations {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CsmOperationCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/providers/Microsoft.DomainRegistration/operations", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CsmOperationCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod certificates {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Get all certificates for a subscription."]
        pub fn list(&self, subscription_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get all certificates in a resource group."]
        pub fn list_by_resource_group(
            &self,
            resource_group_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_by_resource_group::Builder {
            list_by_resource_group::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a certificate."]
        pub fn get(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create or update a certificate."]
        pub fn create_or_update(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            certificate_envelope: impl Into<models::Certificate>,
            subscription_id: impl Into<String>,
        ) -> create_or_update::Builder {
            create_or_update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                certificate_envelope: certificate_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create or update a certificate."]
        pub fn update(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            certificate_envelope: impl Into<models::CertificatePatchResource>,
            subscription_id: impl Into<String>,
        ) -> update::Builder {
            update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                certificate_envelope: certificate_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a certificate."]
        pub fn delete(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CertificateCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/certificates",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CertificateCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_by_resource_group {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CertificateCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/certificates",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CertificateCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Certificate, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/certificates/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Certificate =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) certificate_envelope: models::Certificate,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Certificate, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/certificates/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.certificate_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Certificate =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) certificate_envelope: models::CertificatePatchResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Certificate, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/certificates/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.certificate_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Certificate =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/certificates/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod deleted_web_apps {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Get all deleted apps for a subscription."]
        pub fn list(&self, subscription_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get all deleted apps for a subscription at location"]
        pub fn list_by_location(&self, location: impl Into<String>, subscription_id: impl Into<String>) -> list_by_location::Builder {
            list_by_location::Builder {
                client: self.0.clone(),
                location: location.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get deleted app for a subscription at location."]
        pub fn get_deleted_web_app_by_location(
            &self,
            location: impl Into<String>,
            deleted_site_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_deleted_web_app_by_location::Builder {
            get_deleted_web_app_by_location::Builder {
                client: self.0.clone(),
                location: location.into(),
                deleted_site_id: deleted_site_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeletedWebAppCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/deletedSites",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DeletedWebAppCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_by_location {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) location: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeletedWebAppCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/locations/{}/deletedSites",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.location
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DeletedWebAppCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_deleted_web_app_by_location {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) location: String,
            pub(crate) deleted_site_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeletedSite, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/locations/{}/deletedSites/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.location,
                        &self.deleted_site_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DeletedSite =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod diagnostics {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "List Hosting Environment Detector Responses"]
        pub fn list_hosting_environment_detector_responses(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_hosting_environment_detector_responses::Builder {
            list_hosting_environment_detector_responses::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get Hosting Environment Detector Response"]
        pub fn get_hosting_environment_detector_response(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            detector_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_hosting_environment_detector_response::Builder {
            get_hosting_environment_detector_response::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                detector_name: detector_name.into(),
                subscription_id: subscription_id.into(),
                start_time: None,
                end_time: None,
                time_grain: None,
            }
        }
        #[doc = "List Site Detector Responses"]
        pub fn list_site_detector_responses(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_detector_responses::Builder {
            list_site_detector_responses::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get site detector response"]
        pub fn get_site_detector_response(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            detector_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_detector_response::Builder {
            get_site_detector_response::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                detector_name: detector_name.into(),
                subscription_id: subscription_id.into(),
                start_time: None,
                end_time: None,
                time_grain: None,
            }
        }
        #[doc = "Get Diagnostics Categories"]
        pub fn list_site_diagnostic_categories(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_diagnostic_categories::Builder {
            list_site_diagnostic_categories::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get Diagnostics Category"]
        pub fn get_site_diagnostic_category(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_diagnostic_category::Builder {
            get_site_diagnostic_category::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get Site Analyses"]
        pub fn list_site_analyses(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_analyses::Builder {
            list_site_analyses::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get Site Analysis"]
        pub fn get_site_analysis(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            analysis_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_analysis::Builder {
            get_site_analysis::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                analysis_name: analysis_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Execute Analysis"]
        pub fn execute_site_analysis(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            analysis_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> execute_site_analysis::Builder {
            execute_site_analysis::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                analysis_name: analysis_name.into(),
                subscription_id: subscription_id.into(),
                start_time: None,
                end_time: None,
                time_grain: None,
            }
        }
        #[doc = "Get Detectors"]
        pub fn list_site_detectors(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_detectors::Builder {
            list_site_detectors::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get Detector"]
        pub fn get_site_detector(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            detector_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_detector::Builder {
            get_site_detector::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                detector_name: detector_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Execute Detector"]
        pub fn execute_site_detector(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            detector_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> execute_site_detector::Builder {
            execute_site_detector::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                detector_name: detector_name.into(),
                diagnostic_category: diagnostic_category.into(),
                subscription_id: subscription_id.into(),
                start_time: None,
                end_time: None,
                time_grain: None,
            }
        }
        #[doc = "List Site Detector Responses"]
        pub fn list_site_detector_responses_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_detector_responses_slot::Builder {
            list_site_detector_responses_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get site detector response"]
        pub fn get_site_detector_response_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            detector_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_detector_response_slot::Builder {
            get_site_detector_response_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                detector_name: detector_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                start_time: None,
                end_time: None,
                time_grain: None,
            }
        }
        #[doc = "Get Diagnostics Categories"]
        pub fn list_site_diagnostic_categories_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_diagnostic_categories_slot::Builder {
            list_site_diagnostic_categories_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get Diagnostics Category"]
        pub fn get_site_diagnostic_category_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_diagnostic_category_slot::Builder {
            get_site_diagnostic_category_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get Site Analyses"]
        pub fn list_site_analyses_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_analyses_slot::Builder {
            list_site_analyses_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get Site Analysis"]
        pub fn get_site_analysis_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            analysis_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_analysis_slot::Builder {
            get_site_analysis_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                analysis_name: analysis_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Execute Analysis"]
        pub fn execute_site_analysis_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            analysis_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> execute_site_analysis_slot::Builder {
            execute_site_analysis_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                analysis_name: analysis_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                start_time: None,
                end_time: None,
                time_grain: None,
            }
        }
        #[doc = "Get Detectors"]
        pub fn list_site_detectors_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_detectors_slot::Builder {
            list_site_detectors_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get Detector"]
        pub fn get_site_detector_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            detector_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_detector_slot::Builder {
            get_site_detector_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                diagnostic_category: diagnostic_category.into(),
                detector_name: detector_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Execute Detector"]
        pub fn execute_site_detector_slot(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            detector_name: impl Into<String>,
            diagnostic_category: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> execute_site_detector_slot::Builder {
            execute_site_detector_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                detector_name: detector_name.into(),
                diagnostic_category: diagnostic_category.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                start_time: None,
                end_time: None,
                time_grain: None,
            }
        }
    }
    pub mod list_hosting_environment_detector_responses {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DetectorResponseCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/hostingEnvironments/{}/detectors",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DetectorResponseCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_hosting_environment_detector_response {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) detector_name: String,
            pub(crate) subscription_id: String,
            pub(crate) start_time: Option<String>,
            pub(crate) end_time: Option<String>,
            pub(crate) time_grain: Option<String>,
        }
        impl Builder {
            pub fn start_time(mut self, start_time: impl Into<String>) -> Self {
                self.start_time = Some(start_time.into());
                self
            }
            pub fn end_time(mut self, end_time: impl Into<String>) -> Self {
                self.end_time = Some(end_time.into());
                self
            }
            pub fn time_grain(mut self, time_grain: impl Into<String>) -> Self {
                self.time_grain = Some(time_grain.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DetectorResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/hostingEnvironments/{}/detectors/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.detector_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(start_time) = &self.start_time {
                        url.query_pairs_mut().append_pair("startTime", start_time);
                    }
                    if let Some(end_time) = &self.end_time {
                        url.query_pairs_mut().append_pair("endTime", end_time);
                    }
                    if let Some(time_grain) = &self.time_grain {
                        url.query_pairs_mut().append_pair("timeGrain", time_grain);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DetectorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_detector_responses {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DetectorResponseCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/detectors",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DetectorResponseCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_detector_response {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) detector_name: String,
            pub(crate) subscription_id: String,
            pub(crate) start_time: Option<String>,
            pub(crate) end_time: Option<String>,
            pub(crate) time_grain: Option<String>,
        }
        impl Builder {
            pub fn start_time(mut self, start_time: impl Into<String>) -> Self {
                self.start_time = Some(start_time.into());
                self
            }
            pub fn end_time(mut self, end_time: impl Into<String>) -> Self {
                self.end_time = Some(end_time.into());
                self
            }
            pub fn time_grain(mut self, time_grain: impl Into<String>) -> Self {
                self.time_grain = Some(time_grain.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DetectorResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/detectors/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.detector_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(start_time) = &self.start_time {
                        url.query_pairs_mut().append_pair("startTime", start_time);
                    }
                    if let Some(end_time) = &self.end_time {
                        url.query_pairs_mut().append_pair("endTime", end_time);
                    }
                    if let Some(time_grain) = &self.time_grain {
                        url.query_pairs_mut().append_pair("timeGrain", time_grain);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DetectorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_diagnostic_categories {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticCategoryCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/diagnostics",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticCategoryCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_diagnostic_category {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticCategory, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/diagnostics/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.diagnostic_category
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticCategory =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_analyses {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticAnalysisCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/diagnostics/{}/analyses",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.diagnostic_category
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticAnalysisCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_analysis {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) analysis_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticAnalysis, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/diagnostics/{}/analyses/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.diagnostic_category,
                        &self.analysis_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticAnalysis =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod execute_site_analysis {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) analysis_name: String,
            pub(crate) subscription_id: String,
            pub(crate) start_time: Option<String>,
            pub(crate) end_time: Option<String>,
            pub(crate) time_grain: Option<String>,
        }
        impl Builder {
            pub fn start_time(mut self, start_time: impl Into<String>) -> Self {
                self.start_time = Some(start_time.into());
                self
            }
            pub fn end_time(mut self, end_time: impl Into<String>) -> Self {
                self.end_time = Some(end_time.into());
                self
            }
            pub fn time_grain(mut self, time_grain: impl Into<String>) -> Self {
                self.time_grain = Some(time_grain.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticAnalysis, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/diagnostics/{}/analyses/{}/execute",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.diagnostic_category,
                        &self.analysis_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(start_time) = &self.start_time {
                        url.query_pairs_mut().append_pair("startTime", start_time);
                    }
                    if let Some(end_time) = &self.end_time {
                        url.query_pairs_mut().append_pair("endTime", end_time);
                    }
                    if let Some(time_grain) = &self.time_grain {
                        url.query_pairs_mut().append_pair("timeGrain", time_grain);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticAnalysis =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_detectors {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticDetectorCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/diagnostics/{}/detectors",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.diagnostic_category
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticDetectorCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_detector {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) detector_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticDetectorCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/diagnostics/{}/detectors/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.diagnostic_category,
                        &self.detector_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticDetectorCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod execute_site_detector {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) detector_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) subscription_id: String,
            pub(crate) start_time: Option<String>,
            pub(crate) end_time: Option<String>,
            pub(crate) time_grain: Option<String>,
        }
        impl Builder {
            pub fn start_time(mut self, start_time: impl Into<String>) -> Self {
                self.start_time = Some(start_time.into());
                self
            }
            pub fn end_time(mut self, end_time: impl Into<String>) -> Self {
                self.end_time = Some(end_time.into());
                self
            }
            pub fn time_grain(mut self, time_grain: impl Into<String>) -> Self {
                self.time_grain = Some(time_grain.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticDetectorResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/diagnostics/{}/detectors/{}/execute",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.diagnostic_category,
                        &self.detector_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(start_time) = &self.start_time {
                        url.query_pairs_mut().append_pair("startTime", start_time);
                    }
                    if let Some(end_time) = &self.end_time {
                        url.query_pairs_mut().append_pair("endTime", end_time);
                    }
                    if let Some(time_grain) = &self.time_grain {
                        url.query_pairs_mut().append_pair("timeGrain", time_grain);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticDetectorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_detector_responses_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DetectorResponseCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/detectors",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DetectorResponseCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_detector_response_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) detector_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
            pub(crate) start_time: Option<String>,
            pub(crate) end_time: Option<String>,
            pub(crate) time_grain: Option<String>,
        }
        impl Builder {
            pub fn start_time(mut self, start_time: impl Into<String>) -> Self {
                self.start_time = Some(start_time.into());
                self
            }
            pub fn end_time(mut self, end_time: impl Into<String>) -> Self {
                self.end_time = Some(end_time.into());
                self
            }
            pub fn time_grain(mut self, time_grain: impl Into<String>) -> Self {
                self.time_grain = Some(time_grain.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DetectorResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/detectors/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.slot,
                        &self.detector_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(start_time) = &self.start_time {
                        url.query_pairs_mut().append_pair("startTime", start_time);
                    }
                    if let Some(end_time) = &self.end_time {
                        url.query_pairs_mut().append_pair("endTime", end_time);
                    }
                    if let Some(time_grain) = &self.time_grain {
                        url.query_pairs_mut().append_pair("timeGrain", time_grain);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DetectorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_diagnostic_categories_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticCategoryCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/diagnostics",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.slot
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticCategoryCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_diagnostic_category_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticCategory, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/diagnostics/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.slot,
                        &self.diagnostic_category
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticCategory =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_analyses_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticAnalysisCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/diagnostics/{}/analyses",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.slot,
                        &self.diagnostic_category
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticAnalysisCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_analysis_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) analysis_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticAnalysis, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/diagnostics/{}/analyses/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.slot,
                        &self.diagnostic_category,
                        &self.analysis_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticAnalysis =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod execute_site_analysis_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) analysis_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
            pub(crate) start_time: Option<String>,
            pub(crate) end_time: Option<String>,
            pub(crate) time_grain: Option<String>,
        }
        impl Builder {
            pub fn start_time(mut self, start_time: impl Into<String>) -> Self {
                self.start_time = Some(start_time.into());
                self
            }
            pub fn end_time(mut self, end_time: impl Into<String>) -> Self {
                self.end_time = Some(end_time.into());
                self
            }
            pub fn time_grain(mut self, time_grain: impl Into<String>) -> Self {
                self.time_grain = Some(time_grain.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticAnalysis, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/diagnostics/{}/analyses/{}/execute" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . site_name , & self . slot , & self . diagnostic_category , & self . analysis_name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(start_time) = &self.start_time {
                        url.query_pairs_mut().append_pair("startTime", start_time);
                    }
                    if let Some(end_time) = &self.end_time {
                        url.query_pairs_mut().append_pair("endTime", end_time);
                    }
                    if let Some(time_grain) = &self.time_grain {
                        url.query_pairs_mut().append_pair("timeGrain", time_grain);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticAnalysis =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_detectors_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticDetectorCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/diagnostics/{}/detectors",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.slot,
                        &self.diagnostic_category
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticDetectorCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_site_detector_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) detector_name: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticDetectorCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/diagnostics/{}/detectors/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.slot,
                        &self.diagnostic_category,
                        &self.detector_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticDetectorCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod execute_site_detector_slot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) detector_name: String,
            pub(crate) diagnostic_category: String,
            pub(crate) slot: String,
            pub(crate) subscription_id: String,
            pub(crate) start_time: Option<String>,
            pub(crate) end_time: Option<String>,
            pub(crate) time_grain: Option<String>,
        }
        impl Builder {
            pub fn start_time(mut self, start_time: impl Into<String>) -> Self {
                self.start_time = Some(start_time.into());
                self
            }
            pub fn end_time(mut self, end_time: impl Into<String>) -> Self {
                self.end_time = Some(end_time.into());
                self
            }
            pub fn time_grain(mut self, time_grain: impl Into<String>) -> Self {
                self.time_grain = Some(time_grain.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::DiagnosticDetectorResponse, Error>> {
                Box::pin(async move {
                    let url_str = & format ! ("{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/slots/{}/diagnostics/{}/detectors/{}/execute" , self . client . endpoint () , & self . subscription_id , & self . resource_group_name , & self . site_name , & self . slot , & self . diagnostic_category , & self . detector_name) ;
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(start_time) = &self.start_time {
                        url.query_pairs_mut().append_pair("startTime", start_time);
                    }
                    if let Some(end_time) = &self.end_time {
                        url.query_pairs_mut().append_pair("endTime", end_time);
                    }
                    if let Some(time_grain) = &self.time_grain {
                        url.query_pairs_mut().append_pair("timeGrain", time_grain);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DiagnosticDetectorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod provider {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Get available application frameworks and their versions"]
        pub fn get_available_stacks(&self) -> get_available_stacks::Builder {
            get_available_stacks::Builder {
                client: self.0.clone(),
                os_type_selected: None,
            }
        }
        #[doc = "Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions"]
        pub fn list_operations(&self) -> list_operations::Builder {
            list_operations::Builder { client: self.0.clone() }
        }
        #[doc = "Get available application frameworks and their versions"]
        pub fn get_available_stacks_on_prem(&self, subscription_id: impl Into<String>) -> get_available_stacks_on_prem::Builder {
            get_available_stacks_on_prem::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
                os_type_selected: None,
            }
        }
    }
    pub mod get_available_stacks {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) os_type_selected: Option<String>,
        }
        impl Builder {
            pub fn os_type_selected(mut self, os_type_selected: impl Into<String>) -> Self {
                self.os_type_selected = Some(os_type_selected.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationStackCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/providers/Microsoft.Web/availableStacks", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(os_type_selected) = &self.os_type_selected {
                        url.query_pairs_mut().append_pair("osTypeSelected", os_type_selected);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ApplicationStackCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_operations {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CsmOperationCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/providers/Microsoft.Web/operations", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CsmOperationCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_available_stacks_on_prem {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
            pub(crate) os_type_selected: Option<String>,
        }
        impl Builder {
            pub fn os_type_selected(mut self, os_type_selected: impl Into<String>) -> Self {
                self.os_type_selected = Some(os_type_selected.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationStackCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/availableStacks",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(os_type_selected) = &self.os_type_selected {
                        url.query_pairs_mut().append_pair("osTypeSelected", os_type_selected);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ApplicationStackCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod recommendations {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "List all recommendations for a subscription."]
        pub fn list(&self, subscription_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
                featured: None,
                filter: None,
            }
        }
        #[doc = "Reset all recommendation opt-out settings for a subscription."]
        pub fn reset_all_filters(&self, subscription_id: impl Into<String>) -> reset_all_filters::Builder {
            reset_all_filters::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Disables the specified rule so it will not apply to a subscription in the future."]
        pub fn disable_recommendation_for_subscription(
            &self,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> disable_recommendation_for_subscription::Builder {
            disable_recommendation_for_subscription::Builder {
                client: self.0.clone(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get past recommendations for an app, optionally specified by the time range."]
        pub fn list_history_for_hosting_environment(
            &self,
            resource_group_name: impl Into<String>,
            hosting_environment_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_history_for_hosting_environment::Builder {
            list_history_for_hosting_environment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                hosting_environment_name: hosting_environment_name.into(),
                subscription_id: subscription_id.into(),
                expired_only: None,
                filter: None,
            }
        }
        #[doc = "Get all recommendations for an app."]
        pub fn list_recommended_rules_for_hosting_environment(
            &self,
            resource_group_name: impl Into<String>,
            hosting_environment_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_recommended_rules_for_hosting_environment::Builder {
            list_recommended_rules_for_hosting_environment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                hosting_environment_name: hosting_environment_name.into(),
                subscription_id: subscription_id.into(),
                featured: None,
                filter: None,
            }
        }
        #[doc = "Disable all recommendations for an app."]
        pub fn disable_all_for_hosting_environment(
            &self,
            resource_group_name: impl Into<String>,
            environment_name: impl Into<String>,
            hosting_environment_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> disable_all_for_hosting_environment::Builder {
            disable_all_for_hosting_environment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                environment_name: environment_name.into(),
                hosting_environment_name: hosting_environment_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Reset all recommendation opt-out settings for an app."]
        pub fn reset_all_filters_for_hosting_environment(
            &self,
            resource_group_name: impl Into<String>,
            environment_name: impl Into<String>,
            hosting_environment_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> reset_all_filters_for_hosting_environment::Builder {
            reset_all_filters_for_hosting_environment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                environment_name: environment_name.into(),
                hosting_environment_name: hosting_environment_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a recommendation rule for an app."]
        pub fn get_rule_details_by_hosting_environment(
            &self,
            resource_group_name: impl Into<String>,
            hosting_environment_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_rule_details_by_hosting_environment::Builder {
            get_rule_details_by_hosting_environment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                hosting_environment_name: hosting_environment_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                update_seen: None,
                recommendation_id: None,
            }
        }
        #[doc = "Disables the specific rule for a web site permanently."]
        pub fn disable_recommendation_for_hosting_environment(
            &self,
            resource_group_name: impl Into<String>,
            environment_name: impl Into<String>,
            name: impl Into<String>,
            hosting_environment_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> disable_recommendation_for_hosting_environment::Builder {
            disable_recommendation_for_hosting_environment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                environment_name: environment_name.into(),
                name: name.into(),
                hosting_environment_name: hosting_environment_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get past recommendations for an app, optionally specified by the time range."]
        pub fn list_history_for_web_app(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_history_for_web_app::Builder {
            list_history_for_web_app::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                subscription_id: subscription_id.into(),
                expired_only: None,
                filter: None,
            }
        }
        #[doc = "Get all recommendations for an app."]
        pub fn list_recommended_rules_for_web_app(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_recommended_rules_for_web_app::Builder {
            list_recommended_rules_for_web_app::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                subscription_id: subscription_id.into(),
                featured: None,
                filter: None,
            }
        }
        #[doc = "Disable all recommendations for an app."]
        pub fn disable_all_for_web_app(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> disable_all_for_web_app::Builder {
            disable_all_for_web_app::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Reset all recommendation opt-out settings for an app."]
        pub fn reset_all_filters_for_web_app(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> reset_all_filters_for_web_app::Builder {
            reset_all_filters_for_web_app::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a recommendation rule for an app."]
        pub fn get_rule_details_by_web_app(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_rule_details_by_web_app::Builder {
            get_rule_details_by_web_app::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                update_seen: None,
                recommendation_id: None,
            }
        }
        #[doc = "Disables the specific rule for a web site permanently."]
        pub fn disable_recommendation_for_site(
            &self,
            resource_group_name: impl Into<String>,
            site_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> disable_recommendation_for_site::Builder {
            disable_recommendation_for_site::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                site_name: site_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
            pub(crate) featured: Option<bool>,
            pub(crate) filter: Option<String>,
        }
        impl Builder {
            pub fn featured(mut self, featured: bool) -> Self {
                self.featured = Some(featured);
                self
            }
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RecommendationCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/recommendations",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(featured) = &self.featured {
                        url.query_pairs_mut().append_pair("featured", &featured.to_string());
                    }
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RecommendationCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod reset_all_filters {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/recommendations/reset",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod disable_recommendation_for_subscription {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/recommendations/{}/disable",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_history_for_hosting_environment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) hosting_environment_name: String,
            pub(crate) subscription_id: String,
            pub(crate) expired_only: Option<bool>,
            pub(crate) filter: Option<String>,
        }
        impl Builder {
            pub fn expired_only(mut self, expired_only: bool) -> Self {
                self.expired_only = Some(expired_only);
                self
            }
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RecommendationCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/hostingEnvironments/{}/recommendationHistory",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.hosting_environment_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(expired_only) = &self.expired_only {
                        url.query_pairs_mut().append_pair("expiredOnly", &expired_only.to_string());
                    }
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RecommendationCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_recommended_rules_for_hosting_environment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) hosting_environment_name: String,
            pub(crate) subscription_id: String,
            pub(crate) featured: Option<bool>,
            pub(crate) filter: Option<String>,
        }
        impl Builder {
            pub fn featured(mut self, featured: bool) -> Self {
                self.featured = Some(featured);
                self
            }
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RecommendationCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/hostingEnvironments/{}/recommendations",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.hosting_environment_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(featured) = &self.featured {
                        url.query_pairs_mut().append_pair("featured", &featured.to_string());
                    }
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RecommendationCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod disable_all_for_hosting_environment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) environment_name: String,
            pub(crate) hosting_environment_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/hostingEnvironments/{}/recommendations/disable",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.hosting_environment_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let environment_name = &self.environment_name;
                    url.query_pairs_mut().append_pair("environmentName", environment_name);
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod reset_all_filters_for_hosting_environment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) environment_name: String,
            pub(crate) hosting_environment_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/hostingEnvironments/{}/recommendations/reset",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.hosting_environment_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let environment_name = &self.environment_name;
                    url.query_pairs_mut().append_pair("environmentName", environment_name);
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_rule_details_by_hosting_environment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) hosting_environment_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) update_seen: Option<bool>,
            pub(crate) recommendation_id: Option<String>,
        }
        impl Builder {
            pub fn update_seen(mut self, update_seen: bool) -> Self {
                self.update_seen = Some(update_seen);
                self
            }
            pub fn recommendation_id(mut self, recommendation_id: impl Into<String>) -> Self {
                self.recommendation_id = Some(recommendation_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RecommendationRule, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/hostingEnvironments/{}/recommendations/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.hosting_environment_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(update_seen) = &self.update_seen {
                        url.query_pairs_mut().append_pair("updateSeen", &update_seen.to_string());
                    }
                    if let Some(recommendation_id) = &self.recommendation_id {
                        url.query_pairs_mut().append_pair("recommendationId", recommendation_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RecommendationRule =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod disable_recommendation_for_hosting_environment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) environment_name: String,
            pub(crate) name: String,
            pub(crate) hosting_environment_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/hostingEnvironments/{}/recommendations/{}/disable",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.hosting_environment_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let environment_name = &self.environment_name;
                    url.query_pairs_mut().append_pair("environmentName", environment_name);
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_history_for_web_app {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) subscription_id: String,
            pub(crate) expired_only: Option<bool>,
            pub(crate) filter: Option<String>,
        }
        impl Builder {
            pub fn expired_only(mut self, expired_only: bool) -> Self {
                self.expired_only = Some(expired_only);
                self
            }
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RecommendationCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/recommendationHistory",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(expired_only) = &self.expired_only {
                        url.query_pairs_mut().append_pair("expiredOnly", &expired_only.to_string());
                    }
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RecommendationCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_recommended_rules_for_web_app {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) subscription_id: String,
            pub(crate) featured: Option<bool>,
            pub(crate) filter: Option<String>,
        }
        impl Builder {
            pub fn featured(mut self, featured: bool) -> Self {
                self.featured = Some(featured);
                self
            }
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RecommendationCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/recommendations",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(featured) = &self.featured {
                        url.query_pairs_mut().append_pair("featured", &featured.to_string());
                    }
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RecommendationCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod disable_all_for_web_app {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/recommendations/disable",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod reset_all_filters_for_web_app {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/recommendations/reset",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_rule_details_by_web_app {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) update_seen: Option<bool>,
            pub(crate) recommendation_id: Option<String>,
        }
        impl Builder {
            pub fn update_seen(mut self, update_seen: bool) -> Self {
                self.update_seen = Some(update_seen);
                self
            }
            pub fn recommendation_id(mut self, recommendation_id: impl Into<String>) -> Self {
                self.recommendation_id = Some(recommendation_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RecommendationRule, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/recommendations/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    if let Some(update_seen) = &self.update_seen {
                        url.query_pairs_mut().append_pair("updateSeen", &update_seen.to_string());
                    }
                    if let Some(recommendation_id) = &self.recommendation_id {
                        url.query_pairs_mut().append_pair("recommendationId", recommendation_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::RecommendationRule =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod disable_recommendation_for_site {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) site_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/recommendations/{}/disable",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.site_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
}
impl Client {
    #[doc = "Gets publishing user"]
    pub fn get_publishing_user(&self) -> get_publishing_user::Builder {
        get_publishing_user::Builder { client: self.clone() }
    }
    #[doc = "Updates publishing user"]
    pub fn update_publishing_user(&self, user_details: impl Into<models::User>) -> update_publishing_user::Builder {
        update_publishing_user::Builder {
            client: self.clone(),
            user_details: user_details.into(),
        }
    }
    #[doc = "Gets the source controls available for Azure websites."]
    pub fn list_source_controls(&self) -> list_source_controls::Builder {
        list_source_controls::Builder { client: self.clone() }
    }
    #[doc = "Gets source control token"]
    pub fn get_source_control(&self, source_control_type: impl Into<String>) -> get_source_control::Builder {
        get_source_control::Builder {
            client: self.clone(),
            source_control_type: source_control_type.into(),
        }
    }
    #[doc = "Updates source control token"]
    pub fn update_source_control(
        &self,
        source_control_type: impl Into<String>,
        request_message: impl Into<models::SourceControl>,
    ) -> update_source_control::Builder {
        update_source_control::Builder {
            client: self.clone(),
            source_control_type: source_control_type.into(),
            request_message: request_message.into(),
        }
    }
    #[doc = "Gets a list of meters for a given location."]
    pub fn list_billing_meters(&self, subscription_id: impl Into<String>) -> list_billing_meters::Builder {
        list_billing_meters::Builder {
            client: self.clone(),
            subscription_id: subscription_id.into(),
            billing_location: None,
            os_type: None,
        }
    }
    #[doc = "Check if a resource name is available."]
    pub fn check_name_availability(
        &self,
        request: impl Into<models::ResourceNameAvailabilityRequest>,
        subscription_id: impl Into<String>,
    ) -> check_name_availability::Builder {
        check_name_availability::Builder {
            client: self.clone(),
            request: request.into(),
            subscription_id: subscription_id.into(),
        }
    }
    #[doc = "Gets list of available geo regions plus ministamps"]
    pub fn get_subscription_deployment_locations(
        &self,
        subscription_id: impl Into<String>,
    ) -> get_subscription_deployment_locations::Builder {
        get_subscription_deployment_locations::Builder {
            client: self.clone(),
            subscription_id: subscription_id.into(),
        }
    }
    #[doc = "Get a list of available geographical regions."]
    pub fn list_geo_regions(&self, subscription_id: impl Into<String>) -> list_geo_regions::Builder {
        list_geo_regions::Builder {
            client: self.clone(),
            subscription_id: subscription_id.into(),
            sku: None,
            linux_workers_enabled: None,
            xenon_workers_enabled: None,
            linux_dynamic_workers_enabled: None,
        }
    }
    #[doc = "List all apps that are assigned to a hostname."]
    pub fn list_site_identifiers_assigned_to_host_name(
        &self,
        name_identifier: impl Into<models::NameIdentifier>,
        subscription_id: impl Into<String>,
    ) -> list_site_identifiers_assigned_to_host_name::Builder {
        list_site_identifiers_assigned_to_host_name::Builder {
            client: self.clone(),
            name_identifier: name_identifier.into(),
            subscription_id: subscription_id.into(),
        }
    }
    #[doc = "List all premier add-on offers."]
    pub fn list_premier_add_on_offers(&self, subscription_id: impl Into<String>) -> list_premier_add_on_offers::Builder {
        list_premier_add_on_offers::Builder {
            client: self.clone(),
            subscription_id: subscription_id.into(),
        }
    }
    #[doc = "List all SKUs."]
    pub fn list_skus(&self, subscription_id: impl Into<String>) -> list_skus::Builder {
        list_skus::Builder {
            client: self.clone(),
            subscription_id: subscription_id.into(),
        }
    }
    #[doc = "Verifies if this VNET is compatible with an App Service Environment by analyzing the Network Security Group rules."]
    pub fn verify_hosting_environment_vnet(
        &self,
        parameters: impl Into<models::VnetParameters>,
        subscription_id: impl Into<String>,
    ) -> verify_hosting_environment_vnet::Builder {
        verify_hosting_environment_vnet::Builder {
            client: self.clone(),
            parameters: parameters.into(),
            subscription_id: subscription_id.into(),
        }
    }
    #[doc = "Move resources between resource groups."]
    pub fn move_(
        &self,
        resource_group_name: impl Into<String>,
        move_resource_envelope: impl Into<models::CsmMoveResourceEnvelope>,
        subscription_id: impl Into<String>,
    ) -> move_::Builder {
        move_::Builder {
            client: self.clone(),
            resource_group_name: resource_group_name.into(),
            move_resource_envelope: move_resource_envelope.into(),
            subscription_id: subscription_id.into(),
        }
    }
    #[doc = "Validate if a resource can be created."]
    pub fn validate(
        &self,
        resource_group_name: impl Into<String>,
        validate_request: impl Into<models::ValidateRequest>,
        subscription_id: impl Into<String>,
    ) -> validate::Builder {
        validate::Builder {
            client: self.clone(),
            resource_group_name: resource_group_name.into(),
            validate_request: validate_request.into(),
            subscription_id: subscription_id.into(),
        }
    }
    #[doc = "Validate if the container settings are correct."]
    pub fn validate_container_settings(
        &self,
        validate_container_settings_request: impl Into<models::ValidateContainerSettingsRequest>,
        resource_group_name: impl Into<String>,
        subscription_id: impl Into<String>,
    ) -> validate_container_settings::Builder {
        validate_container_settings::Builder {
            client: self.clone(),
            validate_container_settings_request: validate_container_settings_request.into(),
            resource_group_name: resource_group_name.into(),
            subscription_id: subscription_id.into(),
        }
    }
    #[doc = "Validate whether a resource can be moved."]
    pub fn validate_move(
        &self,
        resource_group_name: impl Into<String>,
        move_resource_envelope: impl Into<models::CsmMoveResourceEnvelope>,
        subscription_id: impl Into<String>,
    ) -> validate_move::Builder {
        validate_move::Builder {
            client: self.clone(),
            resource_group_name: resource_group_name.into(),
            move_resource_envelope: move_resource_envelope.into(),
            subscription_id: subscription_id.into(),
        }
    }
}
pub mod get_publishing_user {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::User, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/providers/Microsoft.Web/publishingUsers/web", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::User =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod update_publishing_user {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) user_details: models::User,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::User, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/providers/Microsoft.Web/publishingUsers/web", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::PUT);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.user_details).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::User =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod list_source_controls {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SourceControlCollection, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/providers/Microsoft.Web/sourcecontrols", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::SourceControlCollection =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_source_control {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) source_control_type: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SourceControl, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/providers/Microsoft.Web/sourcecontrols/{}",
                    self.client.endpoint(),
                    &self.source_control_type
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::SourceControl =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod update_source_control {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) source_control_type: String,
        pub(crate) request_message: models::SourceControl,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SourceControl, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/providers/Microsoft.Web/sourcecontrols/{}",
                    self.client.endpoint(),
                    &self.source_control_type
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::PUT);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.request_message).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::SourceControl =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod list_billing_meters {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) subscription_id: String,
        pub(crate) billing_location: Option<String>,
        pub(crate) os_type: Option<String>,
    }
    impl Builder {
        pub fn billing_location(mut self, billing_location: impl Into<String>) -> Self {
            self.billing_location = Some(billing_location.into());
            self
        }
        pub fn os_type(mut self, os_type: impl Into<String>) -> Self {
            self.os_type = Some(os_type.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BillingMeterCollection, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/providers/Microsoft.Web/billingMeters",
                    self.client.endpoint(),
                    &self.subscription_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                if let Some(billing_location) = &self.billing_location {
                    url.query_pairs_mut().append_pair("billingLocation", billing_location);
                }
                if let Some(os_type) = &self.os_type {
                    url.query_pairs_mut().append_pair("osType", os_type);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::BillingMeterCollection =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod check_name_availability {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) request: models::ResourceNameAvailabilityRequest,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ResourceNameAvailability, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/providers/Microsoft.Web/checknameavailability",
                    self.client.endpoint(),
                    &self.subscription_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ResourceNameAvailability =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_subscription_deployment_locations {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeploymentLocations, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/providers/Microsoft.Web/deploymentLocations",
                    self.client.endpoint(),
                    &self.subscription_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeploymentLocations =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod list_geo_regions {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) subscription_id: String,
        pub(crate) sku: Option<String>,
        pub(crate) linux_workers_enabled: Option<bool>,
        pub(crate) xenon_workers_enabled: Option<bool>,
        pub(crate) linux_dynamic_workers_enabled: Option<bool>,
    }
    impl Builder {
        pub fn sku(mut self, sku: impl Into<String>) -> Self {
            self.sku = Some(sku.into());
            self
        }
        pub fn linux_workers_enabled(mut self, linux_workers_enabled: bool) -> Self {
            self.linux_workers_enabled = Some(linux_workers_enabled);
            self
        }
        pub fn xenon_workers_enabled(mut self, xenon_workers_enabled: bool) -> Self {
            self.xenon_workers_enabled = Some(xenon_workers_enabled);
            self
        }
        pub fn linux_dynamic_workers_enabled(mut self, linux_dynamic_workers_enabled: bool) -> Self {
            self.linux_dynamic_workers_enabled = Some(linux_dynamic_workers_enabled);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::GeoRegionCollection, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/providers/Microsoft.Web/geoRegions",
                    self.client.endpoint(),
                    &self.subscription_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                if let Some(sku) = &self.sku {
                    url.query_pairs_mut().append_pair("sku", sku);
                }
                if let Some(linux_workers_enabled) = &self.linux_workers_enabled {
                    url.query_pairs_mut()
                        .append_pair("linuxWorkersEnabled", &linux_workers_enabled.to_string());
                }
                if let Some(xenon_workers_enabled) = &self.xenon_workers_enabled {
                    url.query_pairs_mut()
                        .append_pair("xenonWorkersEnabled", &xenon_workers_enabled.to_string());
                }
                if let Some(linux_dynamic_workers_enabled) = &self.linux_dynamic_workers_enabled {
                    url.query_pairs_mut()
                        .append_pair("linuxDynamicWorkersEnabled", &linux_dynamic_workers_enabled.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::GeoRegionCollection =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod list_site_identifiers_assigned_to_host_name {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_identifier: models::NameIdentifier,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::IdentifierCollection, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/providers/Microsoft.Web/listSitesAssignedToHostName",
                    self.client.endpoint(),
                    &self.subscription_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.name_identifier).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::IdentifierCollection =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod list_premier_add_on_offers {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PremierAddOnOfferCollection, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/providers/Microsoft.Web/premieraddonoffers",
                    self.client.endpoint(),
                    &self.subscription_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PremierAddOnOfferCollection =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod list_skus {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SkuInfos, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/providers/Microsoft.Web/skus",
                    self.client.endpoint(),
                    &self.subscription_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::SkuInfos =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod verify_hosting_environment_vnet {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) parameters: models::VnetParameters,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::VnetValidationFailureDetails, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/providers/Microsoft.Web/verifyHostingEnvironmentVnet",
                    self.client.endpoint(),
                    &self.subscription_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.parameters).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::VnetValidationFailureDetails =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod move_ {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("Unexpected HTTP status code {}", status_code)]
        UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) resource_group_name: String,
        pub(crate) move_resource_envelope: models::CsmMoveResourceEnvelope,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/resourceGroups/{}/moveResources",
                    self.client.endpoint(),
                    &self.subscription_id,
                    &self.resource_group_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.move_resource_envelope).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::NO_CONTENT => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        Err(Error::UnexpectedResponse {
                            status_code,
                            body: rsp_body,
                        })
                    }
                }
            })
        }
    }
}
pub mod validate {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) resource_group_name: String,
        pub(crate) validate_request: models::ValidateRequest,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ValidateResponse, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/validate",
                    self.client.endpoint(),
                    &self.subscription_id,
                    &self.resource_group_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.validate_request).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ValidateResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod validate_container_settings {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::DefaultErrorResponse,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) validate_container_settings_request: models::ValidateContainerSettingsRequest,
        pub(crate) resource_group_name: String,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<serde_json::Value, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/validateContainerSettings",
                    self.client.endpoint(),
                    &self.subscription_id,
                    &self.resource_group_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.validate_container_settings_request).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: serde_json::Value =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DefaultErrorResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod validate_move {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("Unexpected HTTP status code {}", status_code)]
        UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::StreamError),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) resource_group_name: String,
        pub(crate) move_resource_envelope: models::CsmMoveResourceEnvelope,
        pub(crate) subscription_id: String,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/subscriptions/{}/resourceGroups/{}/validateMoveResources",
                    self.client.endpoint(),
                    &self.subscription_id,
                    &self.resource_group_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "2018-02-01");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.move_resource_envelope).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::NO_CONTENT => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        Err(Error::UnexpectedResponse {
                            status_code,
                            body: rsp_body,
                        })
                    }
                }
            })
        }
    }
}
pub mod web_apps {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Get all apps for a subscription."]
        pub fn list(&self, subscription_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all web, mobile, and API apps in the specified resource group."]
        pub fn list_by_resource_group(
            &self,
            resource_group_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_by_resource_group::Builder {
            list_by_resource_group::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                subscription_id: subscription_id.into(),
                include_slots: None,
            }
        }
        #[doc = "Gets the details of a web, mobile, or API app."]
        pub fn get(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new web, mobile, or API app in an existing resource group, or updates an existing app."]
        pub fn create_or_update(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_envelope: impl Into<models::Site>,
            subscription_id: impl Into<String>,
        ) -> create_or_update::Builder {
            create_or_update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_envelope: site_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new web, mobile, or API app in an existing resource group, or updates an existing app."]
        pub fn update(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_envelope: impl Into<models::SitePatchResource>,
            subscription_id: impl Into<String>,
        ) -> update::Builder {
            update::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_envelope: site_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a web, mobile, or API app, or one of the deployment slots."]
        pub fn delete(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                delete_metrics: None,
                delete_empty_server_farm: None,
            }
        }
        #[doc = "Analyze a custom hostname."]
        pub fn analyze_custom_hostname(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> analyze_custom_hostname::Builder {
            analyze_custom_hostname::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                host_name: None,
            }
        }
        #[doc = "Applies the configuration settings from the target slot onto the current slot."]
        pub fn apply_slot_config_to_production(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            subscription_id: impl Into<String>,
        ) -> apply_slot_config_to_production::Builder {
            apply_slot_config_to_production::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a backup of an app."]
        pub fn backup(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            subscription_id: impl Into<String>,
        ) -> backup::Builder {
            backup::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets existing backups of an app."]
        pub fn list_backups(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_backups::Builder {
            list_backups::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a backup of an app by its ID."]
        pub fn get_backup_status(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_backup_status::Builder {
            get_backup_status::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a backup of an app by its ID."]
        pub fn delete_backup(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_backup::Builder {
            delete_backup::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body."]
        pub fn list_backup_status_secrets(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            subscription_id: impl Into<String>,
        ) -> list_backup_status_secrets::Builder {
            list_backup_status_secrets::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restores a specific backup to another app (or deployment slot, if specified)."]
        pub fn restore(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            subscription_id: impl Into<String>,
        ) -> restore::Builder {
            restore::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the configurations of an app"]
        pub fn list_configurations(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_configurations::Builder {
            list_configurations::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the application settings of an app."]
        pub fn update_application_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            app_settings: impl Into<models::StringDictionary>,
            subscription_id: impl Into<String>,
        ) -> update_application_settings::Builder {
            update_application_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                app_settings: app_settings.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the application settings of an app."]
        pub fn list_application_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_application_settings::Builder {
            list_application_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Authentication / Authorization settings associated with web app."]
        pub fn update_auth_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_auth_settings: impl Into<models::SiteAuthSettings>,
            subscription_id: impl Into<String>,
        ) -> update_auth_settings::Builder {
            update_auth_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_auth_settings: site_auth_settings.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Authentication/Authorization settings of an app."]
        pub fn get_auth_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_auth_settings::Builder {
            get_auth_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Azure storage account configurations of an app."]
        pub fn update_azure_storage_accounts(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            azure_storage_accounts: impl Into<models::AzureStoragePropertyDictionaryResource>,
            subscription_id: impl Into<String>,
        ) -> update_azure_storage_accounts::Builder {
            update_azure_storage_accounts::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                azure_storage_accounts: azure_storage_accounts.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Azure storage account configurations of an app."]
        pub fn list_azure_storage_accounts(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_azure_storage_accounts::Builder {
            list_azure_storage_accounts::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the backup configuration of an app."]
        pub fn update_backup_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            subscription_id: impl Into<String>,
        ) -> update_backup_configuration::Builder {
            update_backup_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes the backup configuration of an app."]
        pub fn delete_backup_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_backup_configuration::Builder {
            delete_backup_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the backup configuration of an app."]
        pub fn get_backup_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_backup_configuration::Builder {
            get_backup_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the connection strings of an app."]
        pub fn update_connection_strings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            connection_strings: impl Into<models::ConnectionStringDictionary>,
            subscription_id: impl Into<String>,
        ) -> update_connection_strings::Builder {
            update_connection_strings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                connection_strings: connection_strings.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the connection strings of an app."]
        pub fn list_connection_strings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_connection_strings::Builder {
            list_connection_strings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the logging configuration of an app."]
        pub fn get_diagnostic_logs_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_diagnostic_logs_configuration::Builder {
            get_diagnostic_logs_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the logging configuration of an app."]
        pub fn update_diagnostic_logs_config(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_logs_config: impl Into<models::SiteLogsConfig>,
            subscription_id: impl Into<String>,
        ) -> update_diagnostic_logs_config::Builder {
            update_diagnostic_logs_config::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_logs_config: site_logs_config.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the metadata of an app."]
        pub fn update_metadata(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            metadata: impl Into<models::StringDictionary>,
            subscription_id: impl Into<String>,
        ) -> update_metadata::Builder {
            update_metadata::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                metadata: metadata.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the metadata of an app."]
        pub fn list_metadata(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metadata::Builder {
            list_metadata::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Git/FTP publishing credentials of an app."]
        pub fn list_publishing_credentials(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_publishing_credentials::Builder {
            list_publishing_credentials::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Push settings associated with web app."]
        pub fn update_site_push_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            push_settings: impl Into<models::PushSettings>,
            subscription_id: impl Into<String>,
        ) -> update_site_push_settings::Builder {
            update_site_push_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                push_settings: push_settings.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Push settings associated with web app."]
        pub fn list_site_push_settings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_push_settings::Builder {
            list_site_push_settings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the names of app settings and connection strings that stick to the slot (not swapped)."]
        pub fn list_slot_configuration_names(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_slot_configuration_names::Builder {
            list_slot_configuration_names::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the names of application settings and connection string that remain with the slot during swap operation."]
        pub fn update_slot_configuration_names(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_config_names: impl Into<models::SlotConfigNamesResource>,
            subscription_id: impl Into<String>,
        ) -> update_slot_configuration_names::Builder {
            update_slot_configuration_names::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_config_names: slot_config_names.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc."]
        pub fn get_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_configuration::Builder {
            get_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the configuration of an app."]
        pub fn create_or_update_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_config: impl Into<models::SiteConfigResource>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_configuration::Builder {
            create_or_update_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_config: site_config.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the configuration of an app."]
        pub fn update_configuration(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_config: impl Into<models::SiteConfigResource>,
            subscription_id: impl Into<String>,
        ) -> update_configuration::Builder {
            update_configuration::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_config: site_config.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot."]
        pub fn list_configuration_snapshot_info(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_configuration_snapshot_info::Builder {
            list_configuration_snapshot_info::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a snapshot of the configuration of an app at a previous point in time."]
        pub fn get_configuration_snapshot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            snapshot_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_configuration_snapshot::Builder {
            get_configuration_snapshot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                snapshot_id: snapshot_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Reverts the configuration of an app to a previous snapshot."]
        pub fn recover_site_configuration_snapshot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            snapshot_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> recover_site_configuration_snapshot::Builder {
            recover_site_configuration_snapshot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                snapshot_id: snapshot_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the last lines of docker logs for the given site"]
        pub fn get_web_site_container_logs(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_site_container_logs::Builder {
            get_web_site_container_logs::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the ZIP archived docker log files for the given site"]
        pub fn get_container_logs_zip(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_container_logs_zip::Builder {
            get_container_logs_zip::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List continuous web jobs for an app, or a deployment slot."]
        pub fn list_continuous_web_jobs(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_continuous_web_jobs::Builder {
            list_continuous_web_jobs::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a continuous web job by its ID for an app, or a deployment slot."]
        pub fn get_continuous_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_continuous_web_job::Builder {
            get_continuous_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a continuous web job by its ID for an app, or a deployment slot."]
        pub fn delete_continuous_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_continuous_web_job::Builder {
            delete_continuous_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start a continuous web job for an app, or a deployment slot."]
        pub fn start_continuous_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_continuous_web_job::Builder {
            start_continuous_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Stop a continuous web job for an app, or a deployment slot."]
        pub fn stop_continuous_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_continuous_web_job::Builder {
            stop_continuous_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List deployments for an app, or a deployment slot."]
        pub fn list_deployments(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_deployments::Builder {
            list_deployments::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a deployment by its ID for an app, or a deployment slot."]
        pub fn get_deployment(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_deployment::Builder {
            get_deployment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create a deployment for an app, or a deployment slot."]
        pub fn create_deployment(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            deployment: impl Into<models::Deployment>,
            subscription_id: impl Into<String>,
        ) -> create_deployment::Builder {
            create_deployment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                deployment: deployment.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a deployment by its ID for an app, or a deployment slot."]
        pub fn delete_deployment(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_deployment::Builder {
            delete_deployment::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List deployment log for specific deployment for an app, or a deployment slot."]
        pub fn list_deployment_log(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_deployment_log::Builder {
            list_deployment_log::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup."]
        pub fn discover_backup(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            subscription_id: impl Into<String>,
        ) -> discover_backup::Builder {
            discover_backup::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Lists ownership identifiers for domain associated with web app."]
        pub fn list_domain_ownership_identifiers(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_domain_ownership_identifiers::Builder {
            list_domain_ownership_identifiers::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get domain ownership identifier for web app."]
        pub fn get_domain_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_domain_ownership_identifier::Builder {
            get_domain_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a domain ownership identifier for web app, or updates an existing ownership identifier."]
        pub fn create_or_update_domain_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::Identifier>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_domain_ownership_identifier::Builder {
            create_or_update_domain_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a domain ownership identifier for web app, or updates an existing ownership identifier."]
        pub fn update_domain_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::Identifier>,
            subscription_id: impl Into<String>,
        ) -> update_domain_ownership_identifier::Builder {
            update_domain_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a domain ownership identifier for a web app."]
        pub fn delete_domain_ownership_identifier(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_domain_ownership_identifier::Builder {
            delete_domain_ownership_identifier::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the status of the last MSDeploy operation."]
        pub fn get_ms_deploy_status(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_ms_deploy_status::Builder {
            get_ms_deploy_status::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Invoke the MSDeploy web app extension."]
        pub fn create_ms_deploy_operation(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            ms_deploy: impl Into<models::MsDeploy>,
            subscription_id: impl Into<String>,
        ) -> create_ms_deploy_operation::Builder {
            create_ms_deploy_operation::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                ms_deploy: ms_deploy.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the MSDeploy Log for the last MSDeploy operation."]
        pub fn get_ms_deploy_log(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_ms_deploy_log::Builder {
            get_ms_deploy_log::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the functions for a web site, or a deployment slot."]
        pub fn list_functions(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_functions::Builder {
            list_functions::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Fetch a short lived token that can be exchanged for a master key."]
        pub fn get_functions_admin_token(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_functions_admin_token::Builder {
            get_functions_admin_token::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get function information by its ID for web site, or a deployment slot."]
        pub fn get_function(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_function::Builder {
            get_function::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create function for web site, or a deployment slot."]
        pub fn create_function(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            function_envelope: impl Into<models::FunctionEnvelope>,
            subscription_id: impl Into<String>,
        ) -> create_function::Builder {
            create_function::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                function_envelope: function_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a function for web site, or a deployment slot."]
        pub fn delete_function(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_function::Builder {
            delete_function::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get function secrets for a function in a web site, or a deployment slot."]
        pub fn list_function_secrets(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_function_secrets::Builder {
            list_function_secrets::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get hostname bindings for an app or a deployment slot."]
        pub fn list_host_name_bindings(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_host_name_bindings::Builder {
            list_host_name_bindings::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the named hostname binding for an app (or deployment slot, if specified)."]
        pub fn get_host_name_binding(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            host_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_host_name_binding::Builder {
            get_host_name_binding::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                host_name: host_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a hostname binding for an app."]
        pub fn create_or_update_host_name_binding(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            host_name: impl Into<String>,
            host_name_binding: impl Into<models::HostNameBinding>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_host_name_binding::Builder {
            create_or_update_host_name_binding::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                host_name: host_name.into(),
                host_name_binding: host_name_binding.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a hostname binding for an app."]
        pub fn delete_host_name_binding(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            host_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_host_name_binding::Builder {
            delete_host_name_binding::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                host_name: host_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieves a specific Service Bus Hybrid Connection used by this Web App."]
        pub fn get_hybrid_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_hybrid_connection::Builder {
            get_hybrid_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new Hybrid Connection using a Service Bus relay."]
        pub fn create_or_update_hybrid_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            connection_envelope: impl Into<models::HybridConnection>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_hybrid_connection::Builder {
            create_or_update_hybrid_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new Hybrid Connection using a Service Bus relay."]
        pub fn update_hybrid_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            connection_envelope: impl Into<models::HybridConnection>,
            subscription_id: impl Into<String>,
        ) -> update_hybrid_connection::Builder {
            update_hybrid_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Removes a Hybrid Connection from this site."]
        pub fn delete_hybrid_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_hybrid_connection::Builder {
            delete_hybrid_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the send key name and value for a Hybrid Connection."]
        pub fn list_hybrid_connection_keys(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_hybrid_connection_keys::Builder {
            list_hybrid_connection_keys::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieves all Service Bus Hybrid Connections used by this Web App."]
        pub fn list_hybrid_connections(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_hybrid_connections::Builder {
            list_hybrid_connections::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets hybrid connections configured for an app (or deployment slot, if specified)."]
        pub fn list_relay_service_connections(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_relay_service_connections::Builder {
            list_relay_service_connections::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a hybrid connection configuration by its name."]
        pub fn get_relay_service_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_relay_service_connection::Builder {
            get_relay_service_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH)."]
        pub fn create_or_update_relay_service_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            connection_envelope: impl Into<models::RelayServiceConnectionEntity>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_relay_service_connection::Builder {
            create_or_update_relay_service_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH)."]
        pub fn update_relay_service_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            connection_envelope: impl Into<models::RelayServiceConnectionEntity>,
            subscription_id: impl Into<String>,
        ) -> update_relay_service_connection::Builder {
            update_relay_service_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a relay service connection by its name."]
        pub fn delete_relay_service_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_relay_service_connection::Builder {
            delete_relay_service_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all scale-out instances of an app."]
        pub fn list_instance_identifiers(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_identifiers::Builder {
            list_instance_identifiers::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the status of the last MSDeploy operation."]
        pub fn get_instance_ms_deploy_status(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_ms_deploy_status::Builder {
            get_instance_ms_deploy_status::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Invoke the MSDeploy web app extension."]
        pub fn create_instance_ms_deploy_operation(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            instance_id: impl Into<String>,
            ms_deploy: impl Into<models::MsDeploy>,
            subscription_id: impl Into<String>,
        ) -> create_instance_ms_deploy_operation::Builder {
            create_instance_ms_deploy_operation::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                instance_id: instance_id.into(),
                ms_deploy: ms_deploy.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the MSDeploy Log for the last MSDeploy operation."]
        pub fn get_instance_ms_deploy_log(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_ms_deploy_log::Builder {
            get_instance_ms_deploy_log::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site."]
        pub fn list_instance_processes(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_processes::Builder {
            list_instance_processes::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process::Builder {
            get_instance_process::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site."]
        pub fn delete_instance_process(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_instance_process::Builder {
            delete_instance_process::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a memory dump of a process by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_dump(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_dump::Builder {
            get_instance_process_dump::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List module information for a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_instance_process_modules(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_process_modules::Builder {
            list_instance_process_modules::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_module(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            base_address: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_module::Builder {
            get_instance_process_module::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                base_address: base_address.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the threads in a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_instance_process_threads(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_process_threads::Builder {
            list_instance_process_threads::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site."]
        pub fn get_instance_process_thread(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            thread_id: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_thread::Builder {
            get_instance_process_thread::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                thread_id: thread_id.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Shows whether an app can be cloned to another resource group or subscription."]
        pub fn is_cloneable(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> is_cloneable::Builder {
            is_cloneable::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "This is to allow calling via powershell and ARM template."]
        pub fn list_sync_function_triggers(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_sync_function_triggers::Builder {
            list_sync_function_triggers::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all metric definitions of an app (or deployment slot, if specified)."]
        pub fn list_metric_definitions(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metric_definitions::Builder {
            list_metric_definitions::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets performance metrics of an app (or deployment slot, if specified)."]
        pub fn list_metrics(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metrics::Builder {
            list_metrics::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                details: None,
                filter: None,
            }
        }
        #[doc = "Restores a web app."]
        pub fn migrate_storage(
            &self,
            subscription_name: impl Into<String>,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            migration_options: impl Into<models::StorageMigrationOptions>,
            subscription_id: impl Into<String>,
        ) -> migrate_storage::Builder {
            migrate_storage::Builder {
                client: self.0.clone(),
                subscription_name: subscription_name.into(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                migration_options: migration_options.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Migrates a local (in-app) MySql database to a remote MySql database."]
        pub fn migrate_my_sql(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            migration_request_envelope: impl Into<models::MigrateMySqlRequest>,
            subscription_id: impl Into<String>,
        ) -> migrate_my_sql::Builder {
            migrate_my_sql::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                migration_request_envelope: migration_request_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled"]
        pub fn get_migrate_my_sql_status(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_migrate_my_sql_status::Builder {
            get_migrate_my_sql_status::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a Swift Virtual Network connection."]
        pub fn get_swift_virtual_network_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_swift_virtual_network_connection::Builder {
            get_swift_virtual_network_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Integrates this Web App with a Virtual Network. This requires that 1) \"swiftSupported\" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not\r\nin use by another App Service Plan other than the one this App is in."]
        pub fn create_or_update_swift_virtual_network_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            connection_envelope: impl Into<models::SwiftVirtualNetwork>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_swift_virtual_network_connection::Builder {
            create_or_update_swift_virtual_network_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Integrates this Web App with a Virtual Network. This requires that 1) \"swiftSupported\" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not\r\nin use by another App Service Plan other than the one this App is in."]
        pub fn update_swift_virtual_network_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            connection_envelope: impl Into<models::SwiftVirtualNetwork>,
            subscription_id: impl Into<String>,
        ) -> update_swift_virtual_network_connection::Builder {
            update_swift_virtual_network_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a Swift Virtual Network connection from an app (or deployment slot)."]
        pub fn delete_swift_virtual_network(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_swift_virtual_network::Builder {
            delete_swift_virtual_network::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all network features used by the app (or deployment slot, if specified)."]
        pub fn list_network_features(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            view: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_network_features::Builder {
            list_network_features::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                view: view.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named operation for a network trace capturing (or deployment slot, if specified)."]
        pub fn get_network_trace_operation(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            operation_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_network_trace_operation::Builder {
            get_network_trace_operation::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                operation_id: operation_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start capturing network packets for the site (To be deprecated)."]
        pub fn start_web_site_network_trace(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_web_site_network_trace::Builder {
            start_web_site_network_trace::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                duration_in_seconds: None,
                max_frame_length: None,
                sas_url: None,
            }
        }
        #[doc = "Start capturing network packets for the site."]
        pub fn start_web_site_network_trace_operation(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_web_site_network_trace_operation::Builder {
            start_web_site_network_trace_operation::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                duration_in_seconds: None,
                max_frame_length: None,
                sas_url: None,
            }
        }
        #[doc = "Stop ongoing capturing network packets for the site."]
        pub fn stop_web_site_network_trace(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_web_site_network_trace::Builder {
            stop_web_site_network_trace::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named operation for a network trace capturing (or deployment slot, if specified)."]
        pub fn get_network_traces(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            operation_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_network_traces::Builder {
            get_network_traces::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                operation_id: operation_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named operation for a network trace capturing (or deployment slot, if specified)."]
        pub fn get_network_trace_operation_v2(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            operation_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_network_trace_operation_v2::Builder {
            get_network_trace_operation_v2::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                operation_id: operation_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named operation for a network trace capturing (or deployment slot, if specified)."]
        pub fn get_network_traces_v2(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            operation_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_network_traces_v2::Builder {
            get_network_traces_v2::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                operation_id: operation_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Generates a new publishing password for an app (or deployment slot, if specified)."]
        pub fn generate_new_site_publishing_password(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> generate_new_site_publishing_password::Builder {
            generate_new_site_publishing_password::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets perfmon counters for web app."]
        pub fn list_perf_mon_counters(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_perf_mon_counters::Builder {
            list_perf_mon_counters::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                filter: None,
            }
        }
        #[doc = "Gets web app's event logs."]
        pub fn get_site_php_error_log_flag(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_php_error_log_flag::Builder {
            get_site_php_error_log_flag::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the premier add-ons of an app."]
        pub fn list_premier_add_ons(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_premier_add_ons::Builder {
            list_premier_add_ons::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named add-on of an app."]
        pub fn get_premier_add_on(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_premier_add_on::Builder {
            get_premier_add_on::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates a named add-on of an app."]
        pub fn add_premier_add_on(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            premier_add_on: impl Into<models::PremierAddOn>,
            subscription_id: impl Into<String>,
        ) -> add_premier_add_on::Builder {
            add_premier_add_on::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                premier_add_on: premier_add_on.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates a named add-on of an app."]
        pub fn update_premier_add_on(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            premier_add_on: impl Into<models::PremierAddOnPatchResource>,
            subscription_id: impl Into<String>,
        ) -> update_premier_add_on::Builder {
            update_premier_add_on::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                premier_add_on: premier_add_on.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a premier add-on from an app."]
        pub fn delete_premier_add_on(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_premier_add_on::Builder {
            delete_premier_add_on::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets data around private site access enablement and authorized Virtual Networks that can access the site."]
        pub fn get_private_access(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_private_access::Builder {
            get_private_access::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Sets data around private site access enablement and authorized Virtual Networks that can access the site."]
        pub fn put_private_access_vnet(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            access: impl Into<models::PrivateAccess>,
            subscription_id: impl Into<String>,
        ) -> put_private_access_vnet::Builder {
            put_private_access_vnet::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                access: access.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site."]
        pub fn list_processes(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_processes::Builder {
            list_processes::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process::Builder {
            get_process::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site."]
        pub fn delete_process(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_process::Builder {
            delete_process::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a memory dump of a process by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_dump(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_dump::Builder {
            get_process_dump::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List module information for a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_process_modules(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_process_modules::Builder {
            list_process_modules::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_module(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            base_address: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_module::Builder {
            get_process_module::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                base_address: base_address.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the threads in a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_process_threads(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_process_threads::Builder {
            list_process_threads::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site."]
        pub fn get_process_thread(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            thread_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_thread::Builder {
            get_process_thread::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                thread_id: thread_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get public certificates for an app or a deployment slot."]
        pub fn list_public_certificates(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_public_certificates::Builder {
            list_public_certificates::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the named public certificate for an app (or deployment slot, if specified)."]
        pub fn get_public_certificate(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            public_certificate_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_public_certificate::Builder {
            get_public_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                public_certificate_name: public_certificate_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a hostname binding for an app."]
        pub fn create_or_update_public_certificate(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            public_certificate_name: impl Into<String>,
            public_certificate: impl Into<models::PublicCertificate>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_public_certificate::Builder {
            create_or_update_public_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                public_certificate_name: public_certificate_name.into(),
                public_certificate: public_certificate.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a hostname binding for an app."]
        pub fn delete_public_certificate(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            public_certificate_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_public_certificate::Builder {
            delete_public_certificate::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                public_certificate_name: public_certificate_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the publishing profile for an app (or deployment slot, if specified)."]
        pub fn list_publishing_profile_xml_with_secrets(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            publishing_profile_options: impl Into<models::CsmPublishingProfileOptions>,
            subscription_id: impl Into<String>,
        ) -> list_publishing_profile_xml_with_secrets::Builder {
            list_publishing_profile_xml_with_secrets::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                publishing_profile_options: publishing_profile_options.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Resets the configuration settings of the current slot if they were previously modified by calling the API with POST."]
        pub fn reset_production_slot_config(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> reset_production_slot_config::Builder {
            reset_production_slot_config::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restarts an app (or deployment slot, if specified)."]
        pub fn restart(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> restart::Builder {
            restart::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                soft_restart: None,
                synchronous: None,
            }
        }
        #[doc = "Restores an app from a backup blob in Azure Storage."]
        pub fn restore_from_backup_blob(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            subscription_id: impl Into<String>,
        ) -> restore_from_backup_blob::Builder {
            restore_from_backup_blob::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restores a deleted web app to this web app."]
        pub fn restore_from_deleted_app(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            restore_request: impl Into<models::DeletedAppRestoreRequest>,
            subscription_id: impl Into<String>,
        ) -> restore_from_deleted_app::Builder {
            restore_from_deleted_app::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                restore_request: restore_request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restores a web app from a snapshot."]
        pub fn restore_snapshot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            restore_request: impl Into<models::SnapshotRestoreRequest>,
            subscription_id: impl Into<String>,
        ) -> restore_snapshot::Builder {
            restore_snapshot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                restore_request: restore_request.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of siteextensions for a web site, or a deployment slot."]
        pub fn list_site_extensions(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_extensions::Builder {
            list_site_extensions::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get site extension information by its ID for a web site, or a deployment slot."]
        pub fn get_site_extension(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_extension::Builder {
            get_site_extension::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Install site extension on a web site, or a deployment slot."]
        pub fn install_site_extension(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> install_site_extension::Builder {
            install_site_extension::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Remove a site extension from a web site, or a deployment slot."]
        pub fn delete_site_extension(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_site_extension::Builder {
            delete_site_extension::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets an app's deployment slots."]
        pub fn list_slots(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_slots::Builder {
            list_slots::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the details of a web, mobile, or API app."]
        pub fn get_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_slot::Builder {
            get_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new web, mobile, or API app in an existing resource group, or updates an existing app."]
        pub fn create_or_update_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_envelope: impl Into<models::Site>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_slot::Builder {
            create_or_update_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_envelope: site_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new web, mobile, or API app in an existing resource group, or updates an existing app."]
        pub fn update_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_envelope: impl Into<models::SitePatchResource>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_slot::Builder {
            update_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_envelope: site_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a web, mobile, or API app, or one of the deployment slots."]
        pub fn delete_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_slot::Builder {
            delete_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                delete_metrics: None,
                delete_empty_server_farm: None,
            }
        }
        #[doc = "Analyze a custom hostname."]
        pub fn analyze_custom_hostname_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> analyze_custom_hostname_slot::Builder {
            analyze_custom_hostname_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                host_name: None,
            }
        }
        #[doc = "Applies the configuration settings from the target slot onto the current slot."]
        pub fn apply_slot_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> apply_slot_configuration_slot::Builder {
            apply_slot_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a backup of an app."]
        pub fn backup_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> backup_slot::Builder {
            backup_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets existing backups of an app."]
        pub fn list_backups_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_backups_slot::Builder {
            list_backups_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a backup of an app by its ID."]
        pub fn get_backup_status_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_backup_status_slot::Builder {
            get_backup_status_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a backup of an app by its ID."]
        pub fn delete_backup_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_backup_slot::Builder {
            delete_backup_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body."]
        pub fn list_backup_status_secrets_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_backup_status_secrets_slot::Builder {
            list_backup_status_secrets_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restores a specific backup to another app (or deployment slot, if specified)."]
        pub fn restore_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            backup_id: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> restore_slot::Builder {
            restore_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                backup_id: backup_id.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the configurations of an app"]
        pub fn list_configurations_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_configurations_slot::Builder {
            list_configurations_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the application settings of an app."]
        pub fn update_application_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            app_settings: impl Into<models::StringDictionary>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_application_settings_slot::Builder {
            update_application_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                app_settings: app_settings.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the application settings of an app."]
        pub fn list_application_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_application_settings_slot::Builder {
            list_application_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Authentication / Authorization settings associated with web app."]
        pub fn update_auth_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_auth_settings: impl Into<models::SiteAuthSettings>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_auth_settings_slot::Builder {
            update_auth_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_auth_settings: site_auth_settings.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Authentication/Authorization settings of an app."]
        pub fn get_auth_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_auth_settings_slot::Builder {
            get_auth_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Azure storage account configurations of an app."]
        pub fn update_azure_storage_accounts_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            azure_storage_accounts: impl Into<models::AzureStoragePropertyDictionaryResource>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_azure_storage_accounts_slot::Builder {
            update_azure_storage_accounts_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                azure_storage_accounts: azure_storage_accounts.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Azure storage account configurations of an app."]
        pub fn list_azure_storage_accounts_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_azure_storage_accounts_slot::Builder {
            list_azure_storage_accounts_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the backup configuration of an app."]
        pub fn update_backup_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::BackupRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_backup_configuration_slot::Builder {
            update_backup_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes the backup configuration of an app."]
        pub fn delete_backup_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_backup_configuration_slot::Builder {
            delete_backup_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the backup configuration of an app."]
        pub fn get_backup_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_backup_configuration_slot::Builder {
            get_backup_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the connection strings of an app."]
        pub fn update_connection_strings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            connection_strings: impl Into<models::ConnectionStringDictionary>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_connection_strings_slot::Builder {
            update_connection_strings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                connection_strings: connection_strings.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the connection strings of an app."]
        pub fn list_connection_strings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_connection_strings_slot::Builder {
            list_connection_strings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the logging configuration of an app."]
        pub fn get_diagnostic_logs_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_diagnostic_logs_configuration_slot::Builder {
            get_diagnostic_logs_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the logging configuration of an app."]
        pub fn update_diagnostic_logs_config_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_logs_config: impl Into<models::SiteLogsConfig>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_diagnostic_logs_config_slot::Builder {
            update_diagnostic_logs_config_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_logs_config: site_logs_config.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Replaces the metadata of an app."]
        pub fn update_metadata_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            metadata: impl Into<models::StringDictionary>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_metadata_slot::Builder {
            update_metadata_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                metadata: metadata.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the metadata of an app."]
        pub fn list_metadata_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metadata_slot::Builder {
            list_metadata_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Git/FTP publishing credentials of an app."]
        pub fn list_publishing_credentials_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_publishing_credentials_slot::Builder {
            list_publishing_credentials_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the Push settings associated with web app."]
        pub fn update_site_push_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            push_settings: impl Into<models::PushSettings>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_site_push_settings_slot::Builder {
            update_site_push_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                push_settings: push_settings.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the Push settings associated with web app."]
        pub fn list_site_push_settings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_push_settings_slot::Builder {
            list_site_push_settings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc."]
        pub fn get_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_configuration_slot::Builder {
            get_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the configuration of an app."]
        pub fn create_or_update_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_config: impl Into<models::SiteConfigResource>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_configuration_slot::Builder {
            create_or_update_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_config: site_config.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the configuration of an app."]
        pub fn update_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_config: impl Into<models::SiteConfigResource>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_configuration_slot::Builder {
            update_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_config: site_config.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot."]
        pub fn list_configuration_snapshot_info_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_configuration_snapshot_info_slot::Builder {
            list_configuration_snapshot_info_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a snapshot of the configuration of an app at a previous point in time."]
        pub fn get_configuration_snapshot_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            snapshot_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_configuration_snapshot_slot::Builder {
            get_configuration_snapshot_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                snapshot_id: snapshot_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Reverts the configuration of an app to a previous snapshot."]
        pub fn recover_site_configuration_snapshot_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            snapshot_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> recover_site_configuration_snapshot_slot::Builder {
            recover_site_configuration_snapshot_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                snapshot_id: snapshot_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the last lines of docker logs for the given site"]
        pub fn get_web_site_container_logs_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_site_container_logs_slot::Builder {
            get_web_site_container_logs_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the ZIP archived docker log files for the given site"]
        pub fn get_container_logs_zip_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_container_logs_zip_slot::Builder {
            get_container_logs_zip_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List continuous web jobs for an app, or a deployment slot."]
        pub fn list_continuous_web_jobs_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_continuous_web_jobs_slot::Builder {
            list_continuous_web_jobs_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a continuous web job by its ID for an app, or a deployment slot."]
        pub fn get_continuous_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_continuous_web_job_slot::Builder {
            get_continuous_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a continuous web job by its ID for an app, or a deployment slot."]
        pub fn delete_continuous_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_continuous_web_job_slot::Builder {
            delete_continuous_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start a continuous web job for an app, or a deployment slot."]
        pub fn start_continuous_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_continuous_web_job_slot::Builder {
            start_continuous_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Stop a continuous web job for an app, or a deployment slot."]
        pub fn stop_continuous_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_continuous_web_job_slot::Builder {
            stop_continuous_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List deployments for an app, or a deployment slot."]
        pub fn list_deployments_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_deployments_slot::Builder {
            list_deployments_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a deployment by its ID for an app, or a deployment slot."]
        pub fn get_deployment_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_deployment_slot::Builder {
            get_deployment_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create a deployment for an app, or a deployment slot."]
        pub fn create_deployment_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            deployment: impl Into<models::Deployment>,
            subscription_id: impl Into<String>,
        ) -> create_deployment_slot::Builder {
            create_deployment_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                slot: slot.into(),
                deployment: deployment.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a deployment by its ID for an app, or a deployment slot."]
        pub fn delete_deployment_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_deployment_slot::Builder {
            delete_deployment_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List deployment log for specific deployment for an app, or a deployment slot."]
        pub fn list_deployment_log_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_deployment_log_slot::Builder {
            list_deployment_log_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                id: id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup."]
        pub fn discover_backup_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> discover_backup_slot::Builder {
            discover_backup_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Lists ownership identifiers for domain associated with web app."]
        pub fn list_domain_ownership_identifiers_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_domain_ownership_identifiers_slot::Builder {
            list_domain_ownership_identifiers_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get domain ownership identifier for web app."]
        pub fn get_domain_ownership_identifier_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_domain_ownership_identifier_slot::Builder {
            get_domain_ownership_identifier_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a domain ownership identifier for web app, or updates an existing ownership identifier."]
        pub fn create_or_update_domain_ownership_identifier_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::Identifier>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_domain_ownership_identifier_slot::Builder {
            create_or_update_domain_ownership_identifier_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a domain ownership identifier for web app, or updates an existing ownership identifier."]
        pub fn update_domain_ownership_identifier_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            domain_ownership_identifier: impl Into<models::Identifier>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_domain_ownership_identifier_slot::Builder {
            update_domain_ownership_identifier_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                domain_ownership_identifier: domain_ownership_identifier.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a domain ownership identifier for a web app."]
        pub fn delete_domain_ownership_identifier_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            domain_ownership_identifier_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_domain_ownership_identifier_slot::Builder {
            delete_domain_ownership_identifier_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                domain_ownership_identifier_name: domain_ownership_identifier_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the status of the last MSDeploy operation."]
        pub fn get_ms_deploy_status_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_ms_deploy_status_slot::Builder {
            get_ms_deploy_status_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Invoke the MSDeploy web app extension."]
        pub fn create_ms_deploy_operation_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            ms_deploy: impl Into<models::MsDeploy>,
            subscription_id: impl Into<String>,
        ) -> create_ms_deploy_operation_slot::Builder {
            create_ms_deploy_operation_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                ms_deploy: ms_deploy.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the MSDeploy Log for the last MSDeploy operation."]
        pub fn get_ms_deploy_log_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_ms_deploy_log_slot::Builder {
            get_ms_deploy_log_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the functions for a web site, or a deployment slot."]
        pub fn list_instance_functions_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_functions_slot::Builder {
            list_instance_functions_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Fetch a short lived token that can be exchanged for a master key."]
        pub fn get_functions_admin_token_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_functions_admin_token_slot::Builder {
            get_functions_admin_token_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get function information by its ID for web site, or a deployment slot."]
        pub fn get_instance_function_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_function_slot::Builder {
            get_instance_function_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Create function for web site, or a deployment slot."]
        pub fn create_instance_function_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            slot: impl Into<String>,
            function_envelope: impl Into<models::FunctionEnvelope>,
            subscription_id: impl Into<String>,
        ) -> create_instance_function_slot::Builder {
            create_instance_function_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                slot: slot.into(),
                function_envelope: function_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a function for web site, or a deployment slot."]
        pub fn delete_instance_function_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_instance_function_slot::Builder {
            delete_instance_function_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get function secrets for a function in a web site, or a deployment slot."]
        pub fn list_function_secrets_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            function_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_function_secrets_slot::Builder {
            list_function_secrets_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                function_name: function_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get hostname bindings for an app or a deployment slot."]
        pub fn list_host_name_bindings_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_host_name_bindings_slot::Builder {
            list_host_name_bindings_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the named hostname binding for an app (or deployment slot, if specified)."]
        pub fn get_host_name_binding_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            host_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_host_name_binding_slot::Builder {
            get_host_name_binding_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                host_name: host_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a hostname binding for an app."]
        pub fn create_or_update_host_name_binding_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            host_name: impl Into<String>,
            host_name_binding: impl Into<models::HostNameBinding>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_host_name_binding_slot::Builder {
            create_or_update_host_name_binding_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                host_name: host_name.into(),
                host_name_binding: host_name_binding.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a hostname binding for an app."]
        pub fn delete_host_name_binding_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            host_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_host_name_binding_slot::Builder {
            delete_host_name_binding_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                host_name: host_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieves a specific Service Bus Hybrid Connection used by this Web App."]
        pub fn get_hybrid_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_hybrid_connection_slot::Builder {
            get_hybrid_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new Hybrid Connection using a Service Bus relay."]
        pub fn create_or_update_hybrid_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            connection_envelope: impl Into<models::HybridConnection>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_hybrid_connection_slot::Builder {
            create_or_update_hybrid_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new Hybrid Connection using a Service Bus relay."]
        pub fn update_hybrid_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            connection_envelope: impl Into<models::HybridConnection>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_hybrid_connection_slot::Builder {
            update_hybrid_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Removes a Hybrid Connection from this site."]
        pub fn delete_hybrid_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_hybrid_connection_slot::Builder {
            delete_hybrid_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the send key name and value for a Hybrid Connection."]
        pub fn list_hybrid_connection_keys_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            namespace_name: impl Into<String>,
            relay_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_hybrid_connection_keys_slot::Builder {
            list_hybrid_connection_keys_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                namespace_name: namespace_name.into(),
                relay_name: relay_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Retrieves all Service Bus Hybrid Connections used by this Web App."]
        pub fn list_hybrid_connections_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_hybrid_connections_slot::Builder {
            list_hybrid_connections_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets hybrid connections configured for an app (or deployment slot, if specified)."]
        pub fn list_relay_service_connections_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_relay_service_connections_slot::Builder {
            list_relay_service_connections_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a hybrid connection configuration by its name."]
        pub fn get_relay_service_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_relay_service_connection_slot::Builder {
            get_relay_service_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH)."]
        pub fn create_or_update_relay_service_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            connection_envelope: impl Into<models::RelayServiceConnectionEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_relay_service_connection_slot::Builder {
            create_or_update_relay_service_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH)."]
        pub fn update_relay_service_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            connection_envelope: impl Into<models::RelayServiceConnectionEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_relay_service_connection_slot::Builder {
            update_relay_service_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a relay service connection by its name."]
        pub fn delete_relay_service_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            entity_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_relay_service_connection_slot::Builder {
            delete_relay_service_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                entity_name: entity_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all scale-out instances of an app."]
        pub fn list_instance_identifiers_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_identifiers_slot::Builder {
            list_instance_identifiers_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the status of the last MSDeploy operation."]
        pub fn get_instance_ms_deploy_status_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_ms_deploy_status_slot::Builder {
            get_instance_ms_deploy_status_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Invoke the MSDeploy web app extension."]
        pub fn create_instance_ms_deploy_operation_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            ms_deploy: impl Into<models::MsDeploy>,
            subscription_id: impl Into<String>,
        ) -> create_instance_ms_deploy_operation_slot::Builder {
            create_instance_ms_deploy_operation_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                ms_deploy: ms_deploy.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the MSDeploy Log for the last MSDeploy operation."]
        pub fn get_instance_ms_deploy_log_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_ms_deploy_log_slot::Builder {
            get_instance_ms_deploy_log_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site."]
        pub fn list_instance_processes_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_processes_slot::Builder {
            list_instance_processes_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_slot::Builder {
            get_instance_process_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site."]
        pub fn delete_instance_process_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_instance_process_slot::Builder {
            delete_instance_process_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a memory dump of a process by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_dump_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_dump_slot::Builder {
            get_instance_process_dump_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List module information for a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_instance_process_modules_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_process_modules_slot::Builder {
            list_instance_process_modules_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_instance_process_module_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            base_address: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_module_slot::Builder {
            get_instance_process_module_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                base_address: base_address.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the threads in a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_instance_process_threads_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_instance_process_threads_slot::Builder {
            list_instance_process_threads_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site."]
        pub fn get_instance_process_thread_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            thread_id: impl Into<String>,
            slot: impl Into<String>,
            instance_id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_instance_process_thread_slot::Builder {
            get_instance_process_thread_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                thread_id: thread_id.into(),
                slot: slot.into(),
                instance_id: instance_id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Shows whether an app can be cloned to another resource group or subscription."]
        pub fn is_cloneable_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> is_cloneable_slot::Builder {
            is_cloneable_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "This is to allow calling via powershell and ARM template."]
        pub fn list_sync_function_triggers_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_sync_function_triggers_slot::Builder {
            list_sync_function_triggers_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all metric definitions of an app (or deployment slot, if specified)."]
        pub fn list_metric_definitions_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metric_definitions_slot::Builder {
            list_metric_definitions_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets performance metrics of an app (or deployment slot, if specified)."]
        pub fn list_metrics_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_metrics_slot::Builder {
            list_metrics_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                details: None,
                filter: None,
            }
        }
        #[doc = "Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled"]
        pub fn get_migrate_my_sql_status_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_migrate_my_sql_status_slot::Builder {
            get_migrate_my_sql_status_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a Swift Virtual Network connection."]
        pub fn get_swift_virtual_network_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_swift_virtual_network_connection_slot::Builder {
            get_swift_virtual_network_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Integrates this Web App with a Virtual Network. This requires that 1) \"swiftSupported\" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not\r\nin use by another App Service Plan other than the one this App is in."]
        pub fn create_or_update_swift_virtual_network_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            connection_envelope: impl Into<models::SwiftVirtualNetwork>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_swift_virtual_network_connection_slot::Builder {
            create_or_update_swift_virtual_network_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Integrates this Web App with a Virtual Network. This requires that 1) \"swiftSupported\" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not\r\nin use by another App Service Plan other than the one this App is in."]
        pub fn update_swift_virtual_network_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            connection_envelope: impl Into<models::SwiftVirtualNetwork>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_swift_virtual_network_connection_slot::Builder {
            update_swift_virtual_network_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a Swift Virtual Network connection from an app (or deployment slot)."]
        pub fn delete_swift_virtual_network_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_swift_virtual_network_slot::Builder {
            delete_swift_virtual_network_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets all network features used by the app (or deployment slot, if specified)."]
        pub fn list_network_features_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            view: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_network_features_slot::Builder {
            list_network_features_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                view: view.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named operation for a network trace capturing (or deployment slot, if specified)."]
        pub fn get_network_trace_operation_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            operation_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_network_trace_operation_slot::Builder {
            get_network_trace_operation_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                operation_id: operation_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start capturing network packets for the site (To be deprecated)."]
        pub fn start_web_site_network_trace_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_web_site_network_trace_slot::Builder {
            start_web_site_network_trace_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                duration_in_seconds: None,
                max_frame_length: None,
                sas_url: None,
            }
        }
        #[doc = "Start capturing network packets for the site."]
        pub fn start_web_site_network_trace_operation_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_web_site_network_trace_operation_slot::Builder {
            start_web_site_network_trace_operation_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                duration_in_seconds: None,
                max_frame_length: None,
                sas_url: None,
            }
        }
        #[doc = "Stop ongoing capturing network packets for the site."]
        pub fn stop_web_site_network_trace_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_web_site_network_trace_slot::Builder {
            stop_web_site_network_trace_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named operation for a network trace capturing (or deployment slot, if specified)."]
        pub fn get_network_traces_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            operation_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_network_traces_slot::Builder {
            get_network_traces_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                operation_id: operation_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named operation for a network trace capturing (or deployment slot, if specified)."]
        pub fn get_network_trace_operation_slot_v2(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            operation_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_network_trace_operation_slot_v2::Builder {
            get_network_trace_operation_slot_v2::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                operation_id: operation_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named operation for a network trace capturing (or deployment slot, if specified)."]
        pub fn get_network_traces_slot_v2(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            operation_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_network_traces_slot_v2::Builder {
            get_network_traces_slot_v2::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                operation_id: operation_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Generates a new publishing password for an app (or deployment slot, if specified)."]
        pub fn generate_new_site_publishing_password_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> generate_new_site_publishing_password_slot::Builder {
            generate_new_site_publishing_password_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets perfmon counters for web app."]
        pub fn list_perf_mon_counters_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_perf_mon_counters_slot::Builder {
            list_perf_mon_counters_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                filter: None,
            }
        }
        #[doc = "Gets web app's event logs."]
        pub fn get_site_php_error_log_flag_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_php_error_log_flag_slot::Builder {
            get_site_php_error_log_flag_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the premier add-ons of an app."]
        pub fn list_premier_add_ons_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_premier_add_ons_slot::Builder {
            list_premier_add_ons_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a named add-on of an app."]
        pub fn get_premier_add_on_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_premier_add_on_slot::Builder {
            get_premier_add_on_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates a named add-on of an app."]
        pub fn add_premier_add_on_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            premier_add_on: impl Into<models::PremierAddOn>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> add_premier_add_on_slot::Builder {
            add_premier_add_on_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                premier_add_on: premier_add_on.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates a named add-on of an app."]
        pub fn update_premier_add_on_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            premier_add_on: impl Into<models::PremierAddOnPatchResource>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_premier_add_on_slot::Builder {
            update_premier_add_on_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                premier_add_on: premier_add_on.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a premier add-on from an app."]
        pub fn delete_premier_add_on_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            premier_add_on_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_premier_add_on_slot::Builder {
            delete_premier_add_on_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                premier_add_on_name: premier_add_on_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets data around private site access enablement and authorized Virtual Networks that can access the site."]
        pub fn get_private_access_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_private_access_slot::Builder {
            get_private_access_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Sets data around private site access enablement and authorized Virtual Networks that can access the site."]
        pub fn put_private_access_vnet_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            access: impl Into<models::PrivateAccess>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> put_private_access_vnet_slot::Builder {
            put_private_access_vnet_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                access: access.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site."]
        pub fn list_processes_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_processes_slot::Builder {
            list_processes_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_slot::Builder {
            get_process_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site."]
        pub fn delete_process_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_process_slot::Builder {
            delete_process_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get a memory dump of a process by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_dump_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_dump_slot::Builder {
            get_process_dump_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List module information for a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_process_modules_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_process_modules_slot::Builder {
            list_process_modules_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get process information by its ID for a specific scaled-out instance in a web site."]
        pub fn get_process_module_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            base_address: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_module_slot::Builder {
            get_process_module_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                base_address: base_address.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List the threads in a process by its ID for a specific scaled-out instance in a web site."]
        pub fn list_process_threads_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_process_threads_slot::Builder {
            list_process_threads_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site."]
        pub fn get_process_thread_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            process_id: impl Into<String>,
            thread_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_process_thread_slot::Builder {
            get_process_thread_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                process_id: process_id.into(),
                thread_id: thread_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get public certificates for an app or a deployment slot."]
        pub fn list_public_certificates_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_public_certificates_slot::Builder {
            list_public_certificates_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the named public certificate for an app (or deployment slot, if specified)."]
        pub fn get_public_certificate_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            public_certificate_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_public_certificate_slot::Builder {
            get_public_certificate_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                public_certificate_name: public_certificate_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Creates a hostname binding for an app."]
        pub fn create_or_update_public_certificate_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            public_certificate_name: impl Into<String>,
            public_certificate: impl Into<models::PublicCertificate>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_public_certificate_slot::Builder {
            create_or_update_public_certificate_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                public_certificate_name: public_certificate_name.into(),
                public_certificate: public_certificate.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a hostname binding for an app."]
        pub fn delete_public_certificate_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            public_certificate_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_public_certificate_slot::Builder {
            delete_public_certificate_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                public_certificate_name: public_certificate_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the publishing profile for an app (or deployment slot, if specified)."]
        pub fn list_publishing_profile_xml_with_secrets_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            publishing_profile_options: impl Into<models::CsmPublishingProfileOptions>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_publishing_profile_xml_with_secrets_slot::Builder {
            list_publishing_profile_xml_with_secrets_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                publishing_profile_options: publishing_profile_options.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Resets the configuration settings of the current slot if they were previously modified by calling the API with POST."]
        pub fn reset_slot_configuration_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> reset_slot_configuration_slot::Builder {
            reset_slot_configuration_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restarts an app (or deployment slot, if specified)."]
        pub fn restart_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> restart_slot::Builder {
            restart_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                soft_restart: None,
                synchronous: None,
            }
        }
        #[doc = "Restores an app from a backup blob in Azure Storage."]
        pub fn restore_from_backup_blob_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            request: impl Into<models::RestoreRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> restore_from_backup_blob_slot::Builder {
            restore_from_backup_blob_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                request: request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restores a deleted web app to this web app."]
        pub fn restore_from_deleted_app_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            restore_request: impl Into<models::DeletedAppRestoreRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> restore_from_deleted_app_slot::Builder {
            restore_from_deleted_app_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                restore_request: restore_request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Restores a web app from a snapshot."]
        pub fn restore_snapshot_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            restore_request: impl Into<models::SnapshotRestoreRequest>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> restore_snapshot_slot::Builder {
            restore_snapshot_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                restore_request: restore_request.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get list of siteextensions for a web site, or a deployment slot."]
        pub fn list_site_extensions_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_site_extensions_slot::Builder {
            list_site_extensions_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get site extension information by its ID for a web site, or a deployment slot."]
        pub fn get_site_extension_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_site_extension_slot::Builder {
            get_site_extension_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Install site extension on a web site, or a deployment slot."]
        pub fn install_site_extension_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> install_site_extension_slot::Builder {
            install_site_extension_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Remove a site extension from a web site, or a deployment slot."]
        pub fn delete_site_extension_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_extension_id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_site_extension_slot::Builder {
            delete_site_extension_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_extension_id: site_extension_id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the difference in configuration settings between two web app slots."]
        pub fn list_slot_differences_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_slot_differences_slot::Builder {
            list_slot_differences_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Swaps two deployment slots of an app."]
        pub fn swap_slot_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> swap_slot_slot::Builder {
            swap_slot_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Returns all Snapshots to the user."]
        pub fn list_snapshots_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_snapshots_slot::Builder {
            list_snapshots_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Returns all Snapshots to the user from DRSecondary endpoint."]
        pub fn list_snapshots_from_dr_secondary_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_snapshots_from_dr_secondary_slot::Builder {
            list_snapshots_from_dr_secondary_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the source control configuration of an app."]
        pub fn get_source_control_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_source_control_slot::Builder {
            get_source_control_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the source control configuration of an app."]
        pub fn create_or_update_source_control_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_source_control: impl Into<models::SiteSourceControl>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_source_control_slot::Builder {
            create_or_update_source_control_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_source_control: site_source_control.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the source control configuration of an app."]
        pub fn update_source_control_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_source_control: impl Into<models::SiteSourceControl>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_source_control_slot::Builder {
            update_source_control_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_source_control: site_source_control.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes the source control configuration of an app."]
        pub fn delete_source_control_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_source_control_slot::Builder {
            delete_source_control_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Starts an app (or deployment slot, if specified)."]
        pub fn start_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_slot::Builder {
            start_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start capturing network packets for the site."]
        pub fn start_network_trace_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_network_trace_slot::Builder {
            start_network_trace_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                duration_in_seconds: None,
                max_frame_length: None,
                sas_url: None,
            }
        }
        #[doc = "Stops an app (or deployment slot, if specified)."]
        pub fn stop_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_slot::Builder {
            stop_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Stop ongoing capturing network packets for the site."]
        pub fn stop_network_trace_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_network_trace_slot::Builder {
            stop_network_trace_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Sync web app repository."]
        pub fn sync_repository_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> sync_repository_slot::Builder {
            sync_repository_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Syncs function trigger metadata to the scale controller"]
        pub fn sync_function_triggers_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> sync_function_triggers_slot::Builder {
            sync_function_triggers_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List triggered web jobs for an app, or a deployment slot."]
        pub fn list_triggered_web_jobs_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_triggered_web_jobs_slot::Builder {
            list_triggered_web_jobs_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a triggered web job by its ID for an app, or a deployment slot."]
        pub fn get_triggered_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_triggered_web_job_slot::Builder {
            get_triggered_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a triggered web job by its ID for an app, or a deployment slot."]
        pub fn delete_triggered_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_triggered_web_job_slot::Builder {
            delete_triggered_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List a triggered web job's history for an app, or a deployment slot."]
        pub fn list_triggered_web_job_history_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_triggered_web_job_history_slot::Builder {
            list_triggered_web_job_history_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a triggered web job's history by its ID for an app, , or a deployment slot."]
        pub fn get_triggered_web_job_history_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            id: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_triggered_web_job_history_slot::Builder {
            get_triggered_web_job_history_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                id: id.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Run a triggered web job for an app, or a deployment slot."]
        pub fn run_triggered_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> run_triggered_web_job_slot::Builder {
            run_triggered_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the quota usage information of an app (or deployment slot, if specified)."]
        pub fn list_usages_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_usages_slot::Builder {
            list_usages_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
                filter: None,
            }
        }
        #[doc = "Gets the virtual networks the app (or deployment slot) is connected to."]
        pub fn list_vnet_connections_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_vnet_connections_slot::Builder {
            list_vnet_connections_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a virtual network the app (or deployment slot) is connected to by name."]
        pub fn get_vnet_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_vnet_connection_slot::Builder {
            get_vnet_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a Virtual Network connection to an app or slot (PUT) or updates the connection properties (PATCH)."]
        pub fn create_or_update_vnet_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetInfo>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_vnet_connection_slot::Builder {
            create_or_update_vnet_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a Virtual Network connection to an app or slot (PUT) or updates the connection properties (PATCH)."]
        pub fn update_vnet_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetInfo>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_vnet_connection_slot::Builder {
            update_vnet_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a connection from an app (or deployment slot to a named virtual network."]
        pub fn delete_vnet_connection_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_vnet_connection_slot::Builder {
            delete_vnet_connection_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets an app's Virtual Network gateway."]
        pub fn get_vnet_connection_gateway_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_vnet_connection_gateway_slot::Builder {
            get_vnet_connection_gateway_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH)."]
        pub fn create_or_update_vnet_connection_gateway_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetGateway>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_vnet_connection_gateway_slot::Builder {
            create_or_update_vnet_connection_gateway_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH)."]
        pub fn update_vnet_connection_gateway_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetGateway>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> update_vnet_connection_gateway_slot::Builder {
            update_vnet_connection_gateway_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                connection_envelope: connection_envelope.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List webjobs for an app, or a deployment slot."]
        pub fn list_web_jobs_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_web_jobs_slot::Builder {
            list_web_jobs_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get webjob information for an app, or a deployment slot."]
        pub fn get_web_job_slot(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            slot: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_job_slot::Builder {
            get_web_job_slot::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                slot: slot.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get the difference in configuration settings between two web app slots."]
        pub fn list_slot_differences_from_production(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            subscription_id: impl Into<String>,
        ) -> list_slot_differences_from_production::Builder {
            list_slot_differences_from_production::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Swaps two deployment slots of an app."]
        pub fn swap_slot_with_production(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            slot_swap_entity: impl Into<models::CsmSlotEntity>,
            subscription_id: impl Into<String>,
        ) -> swap_slot_with_production::Builder {
            swap_slot_with_production::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                slot_swap_entity: slot_swap_entity.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Returns all Snapshots to the user."]
        pub fn list_snapshots(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_snapshots::Builder {
            list_snapshots::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Returns all Snapshots to the user from DRSecondary endpoint."]
        pub fn list_snapshots_from_dr_secondary(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_snapshots_from_dr_secondary::Builder {
            list_snapshots_from_dr_secondary::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the source control configuration of an app."]
        pub fn get_source_control(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_source_control::Builder {
            get_source_control::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the source control configuration of an app."]
        pub fn create_or_update_source_control(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_source_control: impl Into<models::SiteSourceControl>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_source_control::Builder {
            create_or_update_source_control::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_source_control: site_source_control.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Updates the source control configuration of an app."]
        pub fn update_source_control(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            site_source_control: impl Into<models::SiteSourceControl>,
            subscription_id: impl Into<String>,
        ) -> update_source_control::Builder {
            update_source_control::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                site_source_control: site_source_control.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes the source control configuration of an app."]
        pub fn delete_source_control(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_source_control::Builder {
            delete_source_control::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Starts an app (or deployment slot, if specified)."]
        pub fn start(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start::Builder {
            start::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Start capturing network packets for the site."]
        pub fn start_network_trace(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> start_network_trace::Builder {
            start_network_trace::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                duration_in_seconds: None,
                max_frame_length: None,
                sas_url: None,
            }
        }
        #[doc = "Stops an app (or deployment slot, if specified)."]
        pub fn stop(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop::Builder {
            stop::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Stop ongoing capturing network packets for the site."]
        pub fn stop_network_trace(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> stop_network_trace::Builder {
            stop_network_trace::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Sync web app repository."]
        pub fn sync_repository(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> sync_repository::Builder {
            sync_repository::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Syncs function trigger metadata to the scale controller"]
        pub fn sync_function_triggers(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> sync_function_triggers::Builder {
            sync_function_triggers::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List triggered web jobs for an app, or a deployment slot."]
        pub fn list_triggered_web_jobs(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_triggered_web_jobs::Builder {
            list_triggered_web_jobs::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a triggered web job by its ID for an app, or a deployment slot."]
        pub fn get_triggered_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_triggered_web_job::Builder {
            get_triggered_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Delete a triggered web job by its ID for an app, or a deployment slot."]
        pub fn delete_triggered_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_triggered_web_job::Builder {
            delete_triggered_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List a triggered web job's history for an app, or a deployment slot."]
        pub fn list_triggered_web_job_history(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_triggered_web_job_history::Builder {
            list_triggered_web_job_history::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a triggered web job's history by its ID for an app, , or a deployment slot."]
        pub fn get_triggered_web_job_history(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            id: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_triggered_web_job_history::Builder {
            get_triggered_web_job_history::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                id: id.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Run a triggered web job for an app, or a deployment slot."]
        pub fn run_triggered_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> run_triggered_web_job::Builder {
            run_triggered_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets the quota usage information of an app (or deployment slot, if specified)."]
        pub fn list_usages(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_usages::Builder {
            list_usages::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
                filter: None,
            }
        }
        #[doc = "Gets the virtual networks the app (or deployment slot) is connected to."]
        pub fn list_vnet_connections(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_vnet_connections::Builder {
            list_vnet_connections::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets a virtual network the app (or deployment slot) is connected to by name."]
        pub fn get_vnet_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_vnet_connection::Builder {
            get_vnet_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a Virtual Network connection to an app or slot (PUT) or updates the connection properties (PATCH)."]
        pub fn create_or_update_vnet_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetInfo>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_vnet_connection::Builder {
            create_or_update_vnet_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a Virtual Network connection to an app or slot (PUT) or updates the connection properties (PATCH)."]
        pub fn update_vnet_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetInfo>,
            subscription_id: impl Into<String>,
        ) -> update_vnet_connection::Builder {
            update_vnet_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Deletes a connection from an app (or deployment slot to a named virtual network."]
        pub fn delete_vnet_connection(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> delete_vnet_connection::Builder {
            delete_vnet_connection::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Gets an app's Virtual Network gateway."]
        pub fn get_vnet_connection_gateway(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_vnet_connection_gateway::Builder {
            get_vnet_connection_gateway::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH)."]
        pub fn create_or_update_vnet_connection_gateway(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetGateway>,
            subscription_id: impl Into<String>,
        ) -> create_or_update_vnet_connection_gateway::Builder {
            create_or_update_vnet_connection_gateway::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH)."]
        pub fn update_vnet_connection_gateway(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            vnet_name: impl Into<String>,
            gateway_name: impl Into<String>,
            connection_envelope: impl Into<models::VnetGateway>,
            subscription_id: impl Into<String>,
        ) -> update_vnet_connection_gateway::Builder {
            update_vnet_connection_gateway::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                vnet_name: vnet_name.into(),
                gateway_name: gateway_name.into(),
                connection_envelope: connection_envelope.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "List webjobs for an app, or a deployment slot."]
        pub fn list_web_jobs(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> list_web_jobs::Builder {
            list_web_jobs::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                subscription_id: subscription_id.into(),
            }
        }
        #[doc = "Get webjob information for an app, or a deployment slot."]
        pub fn get_web_job(
            &self,
            resource_group_name: impl Into<String>,
            name: impl Into<String>,
            web_job_name: impl Into<String>,
            subscription_id: impl Into<String>,
        ) -> get_web_job::Builder {
            get_web_job::Builder {
                client: self.0.clone(),
                resource_group_name: resource_group_name.into(),
                name: name.into(),
                web_job_name: web_job_name.into(),
                subscription_id: subscription_id.into(),
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::WebAppCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/providers/Microsoft.Web/sites",
                        self.client.endpoint(),
                        &self.subscription_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::WebAppCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_by_resource_group {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) subscription_id: String,
            pub(crate) include_slots: Option<bool>,
        }
        impl Builder {
            pub fn include_slots(mut self, include_slots: bool) -> Self {
                self.include_slots = Some(include_slots);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::WebAppCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    if let Some(include_slots) = &self.include_slots {
                        url.query_pairs_mut().append_pair("includeSlots", &include_slots.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::WebAppCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Site, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::Site),
            Accepted202(models::Site),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_envelope: models::Site,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::ACCEPTED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Accepted202(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(models::Site),
            Accepted202(models::Site),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_envelope: models::SitePatchResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_envelope).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::ACCEPTED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Site =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Accepted202(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            NoContent204,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) delete_metrics: Option<bool>,
            pub(crate) delete_empty_server_farm: Option<bool>,
        }
        impl Builder {
            pub fn delete_metrics(mut self, delete_metrics: bool) -> Self {
                self.delete_metrics = Some(delete_metrics);
                self
            }
            pub fn delete_empty_server_farm(mut self, delete_empty_server_farm: bool) -> Self {
                self.delete_empty_server_farm = Some(delete_empty_server_farm);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    if let Some(delete_metrics) = &self.delete_metrics {
                        url.query_pairs_mut().append_pair("deleteMetrics", &delete_metrics.to_string());
                    }
                    if let Some(delete_empty_server_farm) = &self.delete_empty_server_farm {
                        url.query_pairs_mut()
                            .append_pair("deleteEmptyServerFarm", &delete_empty_server_farm.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod analyze_custom_hostname {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
            pub(crate) host_name: Option<String>,
        }
        impl Builder {
            pub fn host_name(mut self, host_name: impl Into<String>) -> Self {
                self.host_name = Some(host_name.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::CustomHostnameAnalysisResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/analyzeCustomHostname",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    if let Some(host_name) = &self.host_name {
                        url.query_pairs_mut().append_pair("hostName", host_name);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CustomHostnameAnalysisResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod apply_slot_config_to_production {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot_swap_entity: models::CsmSlotEntity,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/applySlotConfig",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.slot_swap_entity).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod backup {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) request: models::BackupRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItem, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backup",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItem =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_backups {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItemCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItemCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_backup_status {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItem, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItem =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_backup {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups/{}",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_backup_status_secrets {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) request: models::BackupRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupItem, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups/{}/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupItem =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod restore {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Accepted202,
            Ok200,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) backup_id: String,
            pub(crate) request: models::RestoreRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/backups/{}/restore",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name,
                        &self.backup_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(Response::Accepted202),
                        http::StatusCode::OK => Ok(Response::Ok200),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_configurations {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResourceCollection, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResourceCollection =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_application_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) app_settings: models::StringDictionary,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/appsettings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.app_settings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_application_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/appsettings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_auth_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_auth_settings: models::SiteAuthSettings,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteAuthSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/authsettings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_auth_settings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteAuthSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_auth_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteAuthSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/authsettings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteAuthSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_azure_storage_accounts {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) azure_storage_accounts: models::AzureStoragePropertyDictionaryResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::AzureStoragePropertyDictionaryResource, Error>>
            {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/azurestorageaccounts",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.azure_storage_accounts).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AzureStoragePropertyDictionaryResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_azure_storage_accounts {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::AzureStoragePropertyDictionaryResource, Error>>
            {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/azurestorageaccounts/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AzureStoragePropertyDictionaryResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_backup_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) request: models::BackupRequest,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupRequest, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/backup",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.request).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupRequest =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_backup_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Unexpected HTTP status code {}", status_code)]
            UnexpectedResponse { status_code: http::StatusCode, body: bytes::Bytes },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/backup",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            Err(Error::UnexpectedResponse {
                                status_code,
                                body: rsp_body,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_backup_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupRequest, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/backup/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BackupRequest =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_connection_strings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) connection_strings: models::ConnectionStringDictionary,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ConnectionStringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/connectionstrings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.connection_strings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ConnectionStringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_connection_strings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ConnectionStringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/connectionstrings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ConnectionStringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_diagnostic_logs_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteLogsConfig, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/logs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteLogsConfig =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_diagnostic_logs_config {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_logs_config: models::SiteLogsConfig,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteLogsConfig, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/logs",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_logs_config).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteLogsConfig =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_metadata {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) metadata: models::StringDictionary,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/metadata",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.metadata).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_metadata {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StringDictionary, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/metadata/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StringDictionary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_publishing_credentials {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::User, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/publishingcredentials/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::User =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_site_push_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) push_settings: models::PushSettings,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PushSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/pushsettings",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.push_settings).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PushSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_site_push_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PushSettings, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/pushsettings/list",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PushSettings =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_slot_configuration_names {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SlotConfigNamesResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/slotConfigNames",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SlotConfigNamesResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_slot_configuration_names {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) slot_config_names: models::SlotConfigNamesResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SlotConfigNamesResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/slotConfigNames",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.slot_config_names).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SlotConfigNamesResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/web",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_or_update_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_config: models::SiteConfigResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/web",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_config).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SiteConfigResource =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::DefaultErrorResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_configuration {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::DefaultErrorResponse,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) resource_group_name: String,
            pub(crate) name: String,
            pub(crate) site_config: models::SiteConfigResource,
            pub(crate) subscription_id: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SiteConfigResource, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Web/sites/{}/config/web",
                        self.client.endpoint(),
                        &self.subscription_id,
                        &self.resource_group_name,
                        &self.name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2018-11-01");
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.site_config).map_err(Error::Serialize)?;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        ht