#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AbnormalTimePeriod {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub events: Vec<DetectorAbnormalTimePeriod>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub solutions: Vec<Solution>,
}
impl AbnormalTimePeriod {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Address {
    pub address1: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address2: Option<String>,
    pub city: String,
    pub country: String,
    #[serde(rename = "postalCode")]
    pub postal_code: String,
    pub state: String,
}
impl Address {
    pub fn new(address1: String, city: String, country: String, postal_code: String, state: String) -> Self {
        Self {
            address1,
            address2: None,
            city,
            country,
            postal_code,
            state,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressResponse {
    #[serde(rename = "serviceIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub service_ip_address: Option<String>,
    #[serde(rename = "internalIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub internal_ip_address: Option<String>,
    #[serde(rename = "outboundIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_ip_addresses: Vec<String>,
    #[serde(rename = "vipMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub vip_mappings: Vec<VirtualIpMapping>,
}
impl AddressResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AnalysisData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[serde(rename = "detectorDefinition", default, skip_serializing_if = "Option::is_none")]
    pub detector_definition: Option<DetectorDefinition>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metrics: Vec<DiagnosticMetricSet>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub data: Vec<Vec<NameValuePair>>,
    #[serde(rename = "detectorMetaData", default, skip_serializing_if = "Option::is_none")]
    pub detector_meta_data: Option<ResponseMetaData>,
}
impl AnalysisData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AnalysisDefinition {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<analysis_definition::Properties>,
}
impl AnalysisDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod analysis_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiDefinitionInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl ApiDefinitionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppServiceCertificate {
    #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_id: Option<String>,
    #[serde(rename = "keyVaultSecretName", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_secret_name: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<app_service_certificate::ProvisioningState>,
}
impl AppServiceCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod app_service_certificate {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Initialized,
        WaitingOnCertificateOrder,
        Succeeded,
        CertificateOrderFailed,
        OperationNotPermittedOnKeyVault,
        AzureServiceUnauthorizedToAccessKeyVault,
        KeyVaultDoesNotExist,
        KeyVaultSecretDoesNotExist,
        UnknownError,
        ExternalPrivateKey,
        Unknown,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServiceCertificateCollection {
    pub value: Vec<AppServiceCertificateResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AppServiceCertificateCollection {
    pub fn new(value: Vec<AppServiceCertificateResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServiceCertificateOrder {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<app_service_certificate_order::Properties>,
}
impl AppServiceCertificateOrder {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod app_service_certificate_order {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub certificates: Option<serde_json::Value>,
        #[serde(rename = "distinguishedName", default, skip_serializing_if = "Option::is_none")]
        pub distinguished_name: Option<String>,
        #[serde(rename = "domainVerificationToken", default, skip_serializing_if = "Option::is_none")]
        pub domain_verification_token: Option<String>,
        #[serde(rename = "validityInYears", default, skip_serializing_if = "Option::is_none")]
        pub validity_in_years: Option<i32>,
        #[serde(rename = "keySize", default, skip_serializing_if = "Option::is_none")]
        pub key_size: Option<i32>,
        #[serde(rename = "productType")]
        pub product_type: properties::ProductType,
        #[serde(rename = "autoRenew", default, skip_serializing_if = "Option::is_none")]
        pub auto_renew: Option<bool>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[serde(rename = "signedCertificate", default, skip_serializing_if = "Option::is_none")]
        pub signed_certificate: Option<CertificateDetails>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub csr: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub intermediate: Option<CertificateDetails>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub root: Option<CertificateDetails>,
        #[serde(rename = "serialNumber", default, skip_serializing_if = "Option::is_none")]
        pub serial_number: Option<String>,
        #[serde(rename = "lastCertificateIssuanceTime", default, skip_serializing_if = "Option::is_none")]
        pub last_certificate_issuance_time: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
        #[serde(rename = "isPrivateKeyExternal", default, skip_serializing_if = "Option::is_none")]
        pub is_private_key_external: Option<bool>,
        #[serde(
            rename = "appServiceCertificateNotRenewableReasons",
            default,
            skip_serializing_if = "Vec::is_empty"
        )]
        pub app_service_certificate_not_renewable_reasons: Vec<String>,
        #[serde(rename = "nextAutoRenewalTimeStamp", default, skip_serializing_if = "Option::is_none")]
        pub next_auto_renewal_time_stamp: Option<String>,
    }
    impl Properties {
        pub fn new(product_type: properties::ProductType) -> Self {
            Self {
                certificates: None,
                distinguished_name: None,
                domain_verification_token: None,
                validity_in_years: None,
                key_size: None,
                product_type,
                auto_renew: None,
                provisioning_state: None,
                status: None,
                signed_certificate: None,
                csr: None,
                intermediate: None,
                root: None,
                serial_number: None,
                last_certificate_issuance_time: None,
                expiration_time: None,
                is_private_key_external: None,
                app_service_certificate_not_renewable_reasons: Vec::new(),
                next_auto_renewal_time_stamp: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProductType {
            StandardDomainValidatedSsl,
            StandardDomainValidatedWildCardSsl,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Pendingissuance,
            Issued,
            Revoked,
            Canceled,
            Denied,
            Pendingrevocation,
            PendingRekey,
            Unused,
            Expired,
            NotSubmitted,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServiceCertificateOrderCollection {
    pub value: Vec<AppServiceCertificateOrder>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AppServiceCertificateOrderCollection {
    pub fn new(value: Vec<AppServiceCertificateOrder>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppServiceCertificateOrderPatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<app_service_certificate_order_patch_resource::Properties>,
}
impl AppServiceCertificateOrderPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod app_service_certificate_order_patch_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub certificates: Option<serde_json::Value>,
        #[serde(rename = "distinguishedName", default, skip_serializing_if = "Option::is_none")]
        pub distinguished_name: Option<String>,
        #[serde(rename = "domainVerificationToken", default, skip_serializing_if = "Option::is_none")]
        pub domain_verification_token: Option<String>,
        #[serde(rename = "validityInYears", default, skip_serializing_if = "Option::is_none")]
        pub validity_in_years: Option<i32>,
        #[serde(rename = "keySize", default, skip_serializing_if = "Option::is_none")]
        pub key_size: Option<i32>,
        #[serde(rename = "productType")]
        pub product_type: properties::ProductType,
        #[serde(rename = "autoRenew", default, skip_serializing_if = "Option::is_none")]
        pub auto_renew: Option<bool>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[serde(rename = "signedCertificate", default, skip_serializing_if = "Option::is_none")]
        pub signed_certificate: Option<CertificateDetails>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub csr: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub intermediate: Option<CertificateDetails>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub root: Option<CertificateDetails>,
        #[serde(rename = "serialNumber", default, skip_serializing_if = "Option::is_none")]
        pub serial_number: Option<String>,
        #[serde(rename = "lastCertificateIssuanceTime", default, skip_serializing_if = "Option::is_none")]
        pub last_certificate_issuance_time: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
        #[serde(rename = "isPrivateKeyExternal", default, skip_serializing_if = "Option::is_none")]
        pub is_private_key_external: Option<bool>,
        #[serde(
            rename = "appServiceCertificateNotRenewableReasons",
            default,
            skip_serializing_if = "Vec::is_empty"
        )]
        pub app_service_certificate_not_renewable_reasons: Vec<String>,
        #[serde(rename = "nextAutoRenewalTimeStamp", default, skip_serializing_if = "Option::is_none")]
        pub next_auto_renewal_time_stamp: Option<String>,
    }
    impl Properties {
        pub fn new(product_type: properties::ProductType) -> Self {
            Self {
                certificates: None,
                distinguished_name: None,
                domain_verification_token: None,
                validity_in_years: None,
                key_size: None,
                product_type,
                auto_renew: None,
                provisioning_state: None,
                status: None,
                signed_certificate: None,
                csr: None,
                intermediate: None,
                root: None,
                serial_number: None,
                last_certificate_issuance_time: None,
                expiration_time: None,
                is_private_key_external: None,
                app_service_certificate_not_renewable_reasons: Vec::new(),
                next_auto_renewal_time_stamp: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProductType {
            StandardDomainValidatedSsl,
            StandardDomainValidatedWildCardSsl,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Pendingissuance,
            Issued,
            Revoked,
            Canceled,
            Denied,
            Pendingrevocation,
            PendingRekey,
            Unused,
            Expired,
            NotSubmitted,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppServiceCertificatePatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AppServiceCertificate>,
}
impl AppServiceCertificatePatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServiceCertificateResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AppServiceCertificate>,
}
impl AppServiceCertificateResource {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServiceEnvironment {
    pub name: String,
    pub location: String,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<app_service_environment::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<app_service_environment::Status>,
    #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_name: Option<String>,
    #[serde(rename = "vnetResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_resource_group_name: Option<String>,
    #[serde(rename = "vnetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_subnet_name: Option<String>,
    #[serde(rename = "virtualNetwork")]
    pub virtual_network: VirtualNetworkProfile,
    #[serde(rename = "internalLoadBalancingMode", default, skip_serializing_if = "Option::is_none")]
    pub internal_load_balancing_mode: Option<app_service_environment::InternalLoadBalancingMode>,
    #[serde(rename = "multiSize", default, skip_serializing_if = "Option::is_none")]
    pub multi_size: Option<String>,
    #[serde(rename = "multiRoleCount", default, skip_serializing_if = "Option::is_none")]
    pub multi_role_count: Option<i32>,
    #[serde(rename = "workerPools")]
    pub worker_pools: Vec<WorkerPool>,
    #[serde(rename = "ipsslAddressCount", default, skip_serializing_if = "Option::is_none")]
    pub ipssl_address_count: Option<i32>,
    #[serde(rename = "databaseEdition", default, skip_serializing_if = "Option::is_none")]
    pub database_edition: Option<String>,
    #[serde(rename = "databaseServiceObjective", default, skip_serializing_if = "Option::is_none")]
    pub database_service_objective: Option<String>,
    #[serde(rename = "upgradeDomains", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_domains: Option<i32>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "dnsSuffix", default, skip_serializing_if = "Option::is_none")]
    pub dns_suffix: Option<String>,
    #[serde(rename = "lastAction", default, skip_serializing_if = "Option::is_none")]
    pub last_action: Option<String>,
    #[serde(rename = "lastActionResult", default, skip_serializing_if = "Option::is_none")]
    pub last_action_result: Option<String>,
    #[serde(rename = "allowedMultiSizes", default, skip_serializing_if = "Option::is_none")]
    pub allowed_multi_sizes: Option<String>,
    #[serde(rename = "allowedWorkerSizes", default, skip_serializing_if = "Option::is_none")]
    pub allowed_worker_sizes: Option<String>,
    #[serde(rename = "maximumNumberOfMachines", default, skip_serializing_if = "Option::is_none")]
    pub maximum_number_of_machines: Option<i32>,
    #[serde(rename = "vipMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub vip_mappings: Vec<VirtualIpMapping>,
    #[serde(rename = "environmentCapacities", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_capacities: Vec<StampCapacity>,
    #[serde(rename = "networkAccessControlList", default, skip_serializing_if = "Vec::is_empty")]
    pub network_access_control_list: Vec<NetworkAccessControlEntry>,
    #[serde(rename = "environmentIsHealthy", default, skip_serializing_if = "Option::is_none")]
    pub environment_is_healthy: Option<bool>,
    #[serde(rename = "environmentStatus", default, skip_serializing_if = "Option::is_none")]
    pub environment_status: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "frontEndScaleFactor", default, skip_serializing_if = "Option::is_none")]
    pub front_end_scale_factor: Option<i32>,
    #[serde(rename = "defaultFrontEndScaleFactor", default, skip_serializing_if = "Option::is_none")]
    pub default_front_end_scale_factor: Option<i32>,
    #[serde(rename = "apiManagementAccountId", default, skip_serializing_if = "Option::is_none")]
    pub api_management_account_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub suspended: Option<bool>,
    #[serde(rename = "dynamicCacheEnabled", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_cache_enabled: Option<bool>,
    #[serde(rename = "clusterSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub cluster_settings: Vec<NameValuePair>,
    #[serde(rename = "userWhitelistedIpRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub user_whitelisted_ip_ranges: Vec<String>,
    #[serde(rename = "hasLinuxWorkers", default, skip_serializing_if = "Option::is_none")]
    pub has_linux_workers: Option<bool>,
    #[serde(rename = "sslCertKeyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_key_vault_id: Option<String>,
    #[serde(rename = "sslCertKeyVaultSecretName", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_key_vault_secret_name: Option<String>,
}
impl AppServiceEnvironment {
    pub fn new(name: String, location: String, virtual_network: VirtualNetworkProfile, worker_pools: Vec<WorkerPool>) -> Self {
        Self {
            name,
            location,
            provisioning_state: None,
            status: None,
            vnet_name: None,
            vnet_resource_group_name: None,
            vnet_subnet_name: None,
            virtual_network,
            internal_load_balancing_mode: None,
            multi_size: None,
            multi_role_count: None,
            worker_pools,
            ipssl_address_count: None,
            database_edition: None,
            database_service_objective: None,
            upgrade_domains: None,
            subscription_id: None,
            dns_suffix: None,
            last_action: None,
            last_action_result: None,
            allowed_multi_sizes: None,
            allowed_worker_sizes: None,
            maximum_number_of_machines: None,
            vip_mappings: Vec::new(),
            environment_capacities: Vec::new(),
            network_access_control_list: Vec::new(),
            environment_is_healthy: None,
            environment_status: None,
            resource_group: None,
            front_end_scale_factor: None,
            default_front_end_scale_factor: None,
            api_management_account_id: None,
            suspended: None,
            dynamic_cache_enabled: None,
            cluster_settings: Vec::new(),
            user_whitelisted_ip_ranges: Vec::new(),
            has_linux_workers: None,
            ssl_cert_key_vault_id: None,
            ssl_cert_key_vault_secret_name: None,
        }
    }
}
pub mod app_service_environment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Failed,
        Canceled,
        InProgress,
        Deleting,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Preparing,
        Ready,
        Scaling,
        Deleting,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InternalLoadBalancingMode {
        None,
        Web,
        Publishing,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServiceEnvironmentCollection {
    pub value: Vec<AppServiceEnvironmentResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AppServiceEnvironmentCollection {
    pub fn new(value: Vec<AppServiceEnvironmentResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppServiceEnvironmentPatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AppServiceEnvironment>,
}
impl AppServiceEnvironmentPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServiceEnvironmentResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AppServiceEnvironment>,
}
impl AppServiceEnvironmentResource {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServicePlan {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<app_service_plan::Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<SkuDescription>,
}
impl AppServicePlan {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            sku: None,
        }
    }
}
pub mod app_service_plan {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "workerTierName", default, skip_serializing_if = "Option::is_none")]
        pub worker_tier_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subscription: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "maximumNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub maximum_number_of_workers: Option<i32>,
        #[serde(rename = "geoRegion", default, skip_serializing_if = "Option::is_none")]
        pub geo_region: Option<String>,
        #[serde(rename = "perSiteScaling", default, skip_serializing_if = "Option::is_none")]
        pub per_site_scaling: Option<bool>,
        #[serde(rename = "maximumElasticWorkerCount", default, skip_serializing_if = "Option::is_none")]
        pub maximum_elastic_worker_count: Option<i32>,
        #[serde(rename = "numberOfSites", default, skip_serializing_if = "Option::is_none")]
        pub number_of_sites: Option<i32>,
        #[serde(rename = "isSpot", default, skip_serializing_if = "Option::is_none")]
        pub is_spot: Option<bool>,
        #[serde(rename = "spotExpirationTime", default, skip_serializing_if = "Option::is_none")]
        pub spot_expiration_time: Option<String>,
        #[serde(rename = "freeOfferExpirationTime", default, skip_serializing_if = "Option::is_none")]
        pub free_offer_expiration_time: Option<String>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reserved: Option<bool>,
        #[serde(rename = "isXenon", default, skip_serializing_if = "Option::is_none")]
        pub is_xenon: Option<bool>,
        #[serde(rename = "hyperV", default, skip_serializing_if = "Option::is_none")]
        pub hyper_v: Option<bool>,
        #[serde(rename = "targetWorkerCount", default, skip_serializing_if = "Option::is_none")]
        pub target_worker_count: Option<i32>,
        #[serde(rename = "targetWorkerSizeId", default, skip_serializing_if = "Option::is_none")]
        pub target_worker_size_id: Option<i32>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Ready,
            Pending,
            Creating,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServicePlanCollection {
    pub value: Vec<AppServicePlan>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AppServicePlanCollection {
    pub fn new(value: Vec<AppServicePlan>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppServicePlanPatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<app_service_plan_patch_resource::Properties>,
}
impl AppServicePlanPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod app_service_plan_patch_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "workerTierName", default, skip_serializing_if = "Option::is_none")]
        pub worker_tier_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subscription: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "maximumNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub maximum_number_of_workers: Option<i32>,
        #[serde(rename = "geoRegion", default, skip_serializing_if = "Option::is_none")]
        pub geo_region: Option<String>,
        #[serde(rename = "perSiteScaling", default, skip_serializing_if = "Option::is_none")]
        pub per_site_scaling: Option<bool>,
        #[serde(rename = "maximumElasticWorkerCount", default, skip_serializing_if = "Option::is_none")]
        pub maximum_elastic_worker_count: Option<i32>,
        #[serde(rename = "numberOfSites", default, skip_serializing_if = "Option::is_none")]
        pub number_of_sites: Option<i32>,
        #[serde(rename = "isSpot", default, skip_serializing_if = "Option::is_none")]
        pub is_spot: Option<bool>,
        #[serde(rename = "spotExpirationTime", default, skip_serializing_if = "Option::is_none")]
        pub spot_expiration_time: Option<String>,
        #[serde(rename = "freeOfferExpirationTime", default, skip_serializing_if = "Option::is_none")]
        pub free_offer_expiration_time: Option<String>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reserved: Option<bool>,
        #[serde(rename = "isXenon", default, skip_serializing_if = "Option::is_none")]
        pub is_xenon: Option<bool>,
        #[serde(rename = "hyperV", default, skip_serializing_if = "Option::is_none")]
        pub hyper_v: Option<bool>,
        #[serde(rename = "targetWorkerCount", default, skip_serializing_if = "Option::is_none")]
        pub target_worker_count: Option<i32>,
        #[serde(rename = "targetWorkerSizeId", default, skip_serializing_if = "Option::is_none")]
        pub target_worker_size_id: Option<i32>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Ready,
            Pending,
            Creating,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationLogsConfig {
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<FileSystemApplicationLogsConfig>,
    #[serde(rename = "azureTableStorage", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_storage: Option<AzureTableStorageApplicationLogsConfig>,
    #[serde(rename = "azureBlobStorage", default, skip_serializing_if = "Option::is_none")]
    pub azure_blob_storage: Option<AzureBlobStorageApplicationLogsConfig>,
}
impl ApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationStack {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dependency: Option<String>,
    #[serde(rename = "majorVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub major_versions: Vec<StackMajorVersion>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub frameworks: Vec<ApplicationStack>,
}
impl ApplicationStack {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationStackCollection {
    pub value: Vec<ApplicationStack>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationStackCollection {
    pub fn new(value: Vec<ApplicationStack>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealActions {
    #[serde(rename = "actionType", default, skip_serializing_if = "Option::is_none")]
    pub action_type: Option<auto_heal_actions::ActionType>,
    #[serde(rename = "customAction", default, skip_serializing_if = "Option::is_none")]
    pub custom_action: Option<AutoHealCustomAction>,
    #[serde(rename = "minProcessExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub min_process_execution_time: Option<String>,
}
impl AutoHealActions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod auto_heal_actions {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActionType {
        Recycle,
        LogEvent,
        CustomAction,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealCustomAction {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exe: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<String>,
}
impl AutoHealCustomAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealRules {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub triggers: Option<AutoHealTriggers>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub actions: Option<AutoHealActions>,
}
impl AutoHealRules {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealTriggers {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub requests: Option<RequestsBasedTrigger>,
    #[serde(rename = "privateBytesInKB", default, skip_serializing_if = "Option::is_none")]
    pub private_bytes_in_kb: Option<i32>,
    #[serde(rename = "statusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub status_codes: Vec<StatusCodesBasedTrigger>,
    #[serde(rename = "slowRequests", default, skip_serializing_if = "Option::is_none")]
    pub slow_requests: Option<SlowRequestsBasedTrigger>,
}
impl AutoHealTriggers {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobStorageApplicationLogsConfig {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<azure_blob_storage_application_logs_config::Level>,
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
    #[serde(rename = "retentionInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_days: Option<i32>,
}
impl AzureBlobStorageApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_blob_storage_application_logs_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Off,
        Verbose,
        Information,
        Warning,
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobStorageHttpLogsConfig {
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
    #[serde(rename = "retentionInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_days: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl AzureBlobStorageHttpLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageInfoValue {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<azure_storage_info_value::Type>,
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[serde(rename = "shareName", default, skip_serializing_if = "Option::is_none")]
    pub share_name: Option<String>,
    #[serde(rename = "accessKey", default, skip_serializing_if = "Option::is_none")]
    pub access_key: Option<String>,
    #[serde(rename = "mountPath", default, skip_serializing_if = "Option::is_none")]
    pub mount_path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<azure_storage_info_value::State>,
}
impl AzureStorageInfoValue {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_storage_info_value {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        AzureFiles,
        AzureBlob,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Ok,
        InvalidCredentials,
        InvalidShare,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStoragePropertyDictionaryResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureStoragePropertyDictionaryResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableStorageApplicationLogsConfig {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<azure_table_storage_application_logs_config::Level>,
    #[serde(rename = "sasUrl")]
    pub sas_url: String,
}
impl AzureTableStorageApplicationLogsConfig {
    pub fn new(sas_url: String) -> Self {
        Self { level: None, sas_url }
    }
}
pub mod azure_table_storage_application_logs_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Off,
        Verbose,
        Information,
        Warning,
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupItem {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<backup_item::Properties>,
}
impl BackupItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<i32>,
        #[serde(rename = "storageAccountUrl", default, skip_serializing_if = "Option::is_none")]
        pub storage_account_url: Option<String>,
        #[serde(rename = "blobName", default, skip_serializing_if = "Option::is_none")]
        pub blob_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[serde(rename = "sizeInBytes", default, skip_serializing_if = "Option::is_none")]
        pub size_in_bytes: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub created: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub log: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub databases: Vec<DatabaseBackupSetting>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub scheduled: Option<bool>,
        #[serde(rename = "lastRestoreTimeStamp", default, skip_serializing_if = "Option::is_none")]
        pub last_restore_time_stamp: Option<String>,
        #[serde(rename = "finishedTimeStamp", default, skip_serializing_if = "Option::is_none")]
        pub finished_time_stamp: Option<String>,
        #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
        pub correlation_id: Option<String>,
        #[serde(rename = "websiteSizeInBytes", default, skip_serializing_if = "Option::is_none")]
        pub website_size_in_bytes: Option<i64>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            InProgress,
            Failed,
            Succeeded,
            TimedOut,
            Created,
            Skipped,
            PartiallySucceeded,
            DeleteInProgress,
            DeleteFailed,
            Deleted,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupItemCollection {
    pub value: Vec<BackupItem>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BackupItemCollection {
    pub fn new(value: Vec<BackupItem>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<backup_request::Properties>,
}
impl BackupRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "backupName", default, skip_serializing_if = "Option::is_none")]
        pub backup_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "storageAccountUrl")]
        pub storage_account_url: String,
        #[serde(rename = "backupSchedule", default, skip_serializing_if = "Option::is_none")]
        pub backup_schedule: Option<BackupSchedule>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub databases: Vec<DatabaseBackupSetting>,
    }
    impl Properties {
        pub fn new(storage_account_url: String) -> Self {
            Self {
                backup_name: None,
                enabled: None,
                storage_account_url,
                backup_schedule: None,
                databases: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupSchedule {
    #[serde(rename = "frequencyInterval")]
    pub frequency_interval: i32,
    #[serde(rename = "frequencyUnit")]
    pub frequency_unit: backup_schedule::FrequencyUnit,
    #[serde(rename = "keepAtLeastOneBackup")]
    pub keep_at_least_one_backup: bool,
    #[serde(rename = "retentionPeriodInDays")]
    pub retention_period_in_days: i32,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "lastExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub last_execution_time: Option<String>,
}
impl BackupSchedule {
    pub fn new(
        frequency_interval: i32,
        frequency_unit: backup_schedule::FrequencyUnit,
        keep_at_least_one_backup: bool,
        retention_period_in_days: i32,
    ) -> Self {
        Self {
            frequency_interval,
            frequency_unit,
            keep_at_least_one_backup,
            retention_period_in_days,
            start_time: None,
            last_execution_time: None,
        }
    }
}
pub mod backup_schedule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FrequencyUnit {
        Day,
        Hour,
    }
    impl Default for FrequencyUnit {
        fn default() -> Self {
            Self::Day
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingMeter {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<billing_meter::Properties>,
}
impl BillingMeter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod billing_meter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "meterId", default, skip_serializing_if = "Option::is_none")]
        pub meter_id: Option<String>,
        #[serde(rename = "billingLocation", default, skip_serializing_if = "Option::is_none")]
        pub billing_location: Option<String>,
        #[serde(rename = "shortName", default, skip_serializing_if = "Option::is_none")]
        pub short_name: Option<String>,
        #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
        pub friendly_name: Option<String>,
        #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
        pub resource_type: Option<String>,
        #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
        pub os_type: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BillingMeterCollection {
    pub value: Vec<BillingMeter>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BillingMeterCollection {
    pub fn new(value: Vec<BillingMeter>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Capability {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
}
impl Capability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Certificate {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate::Properties>,
}
impl Certificate {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod certificate {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
        pub friendly_name: Option<String>,
        #[serde(rename = "subjectName", default, skip_serializing_if = "Option::is_none")]
        pub subject_name: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "pfxBlob", default, skip_serializing_if = "Option::is_none")]
        pub pfx_blob: Option<String>,
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[serde(rename = "selfLink", default, skip_serializing_if = "Option::is_none")]
        pub self_link: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub issuer: Option<String>,
        #[serde(rename = "issueDate", default, skip_serializing_if = "Option::is_none")]
        pub issue_date: Option<String>,
        #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
        pub expiration_date: Option<String>,
        pub password: String,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub valid: Option<bool>,
        #[serde(rename = "cerBlob", default, skip_serializing_if = "Option::is_none")]
        pub cer_blob: Option<String>,
        #[serde(rename = "publicKeyHash", default, skip_serializing_if = "Option::is_none")]
        pub public_key_hash: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_id: Option<String>,
        #[serde(rename = "keyVaultSecretName", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_secret_name: Option<String>,
        #[serde(rename = "keyVaultSecretStatus", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_secret_status: Option<properties::KeyVaultSecretStatus>,
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
    }
    impl Properties {
        pub fn new(password: String) -> Self {
            Self {
                friendly_name: None,
                subject_name: None,
                host_names: Vec::new(),
                pfx_blob: None,
                site_name: None,
                self_link: None,
                issuer: None,
                issue_date: None,
                expiration_date: None,
                password,
                thumbprint: None,
                valid: None,
                cer_blob: None,
                public_key_hash: None,
                hosting_environment_profile: None,
                key_vault_id: None,
                key_vault_secret_name: None,
                key_vault_secret_status: None,
                server_farm_id: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum KeyVaultSecretStatus {
            Initialized,
            WaitingOnCertificateOrder,
            Succeeded,
            CertificateOrderFailed,
            OperationNotPermittedOnKeyVault,
            AzureServiceUnauthorizedToAccessKeyVault,
            KeyVaultDoesNotExist,
            KeyVaultSecretDoesNotExist,
            UnknownError,
            ExternalPrivateKey,
            Unknown,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateCollection {
    pub value: Vec<Certificate>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CertificateCollection {
    pub fn new(value: Vec<Certificate>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i32>,
    #[serde(rename = "serialNumber", default, skip_serializing_if = "Option::is_none")]
    pub serial_number: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(rename = "notBefore", default, skip_serializing_if = "Option::is_none")]
    pub not_before: Option<String>,
    #[serde(rename = "notAfter", default, skip_serializing_if = "Option::is_none")]
    pub not_after: Option<String>,
    #[serde(rename = "signatureAlgorithm", default, skip_serializing_if = "Option::is_none")]
    pub signature_algorithm: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub issuer: Option<String>,
    #[serde(rename = "rawData", default, skip_serializing_if = "Option::is_none")]
    pub raw_data: Option<String>,
}
impl CertificateDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateEmail {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate_email::Properties>,
}
impl CertificateEmail {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod certificate_email {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "emailId", default, skip_serializing_if = "Option::is_none")]
        pub email_id: Option<String>,
        #[serde(rename = "timeStamp", default, skip_serializing_if = "Option::is_none")]
        pub time_stamp: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateOrderAction {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate_order_action::Properties>,
}
impl CertificateOrderAction {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod certificate_order_action {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "actionType", default, skip_serializing_if = "Option::is_none")]
        pub action_type: Option<properties::ActionType>,
        #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
        pub created_at: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ActionType {
            CertificateIssued,
            CertificateOrderCanceled,
            CertificateOrderCreated,
            CertificateRevoked,
            DomainValidationComplete,
            FraudDetected,
            OrgNameChange,
            OrgValidationComplete,
            SanDrop,
            FraudCleared,
            CertificateExpired,
            CertificateExpirationWarning,
            FraudDocumentationRequired,
            Unknown,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificatePatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate_patch_resource::Properties>,
}
impl CertificatePatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod certificate_patch_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
        pub friendly_name: Option<String>,
        #[serde(rename = "subjectName", default, skip_serializing_if = "Option::is_none")]
        pub subject_name: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "pfxBlob", default, skip_serializing_if = "Option::is_none")]
        pub pfx_blob: Option<String>,
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[serde(rename = "selfLink", default, skip_serializing_if = "Option::is_none")]
        pub self_link: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub issuer: Option<String>,
        #[serde(rename = "issueDate", default, skip_serializing_if = "Option::is_none")]
        pub issue_date: Option<String>,
        #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
        pub expiration_date: Option<String>,
        pub password: String,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub valid: Option<bool>,
        #[serde(rename = "cerBlob", default, skip_serializing_if = "Option::is_none")]
        pub cer_blob: Option<String>,
        #[serde(rename = "publicKeyHash", default, skip_serializing_if = "Option::is_none")]
        pub public_key_hash: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_id: Option<String>,
        #[serde(rename = "keyVaultSecretName", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_secret_name: Option<String>,
        #[serde(rename = "keyVaultSecretStatus", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_secret_status: Option<properties::KeyVaultSecretStatus>,
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
    }
    impl Properties {
        pub fn new(password: String) -> Self {
            Self {
                friendly_name: None,
                subject_name: None,
                host_names: Vec::new(),
                pfx_blob: None,
                site_name: None,
                self_link: None,
                issuer: None,
                issue_date: None,
                expiration_date: None,
                password,
                thumbprint: None,
                valid: None,
                cer_blob: None,
                public_key_hash: None,
                hosting_environment_profile: None,
                key_vault_id: None,
                key_vault_secret_name: None,
                key_vault_secret_status: None,
                server_farm_id: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum KeyVaultSecretStatus {
            Initialized,
            WaitingOnCertificateOrder,
            Succeeded,
            CertificateOrderFailed,
            OperationNotPermittedOnKeyVault,
            AzureServiceUnauthorizedToAccessKeyVault,
            KeyVaultDoesNotExist,
            KeyVaultSecretDoesNotExist,
            UnknownError,
            ExternalPrivateKey,
            Unknown,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloningInfo {
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub overwrite: Option<bool>,
    #[serde(rename = "cloneCustomHostNames", default, skip_serializing_if = "Option::is_none")]
    pub clone_custom_host_names: Option<bool>,
    #[serde(rename = "cloneSourceControl", default, skip_serializing_if = "Option::is_none")]
    pub clone_source_control: Option<bool>,
    #[serde(rename = "sourceWebAppId")]
    pub source_web_app_id: String,
    #[serde(rename = "sourceWebAppLocation", default, skip_serializing_if = "Option::is_none")]
    pub source_web_app_location: Option<String>,
    #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
    pub hosting_environment: Option<String>,
    #[serde(rename = "appSettingsOverrides", default, skip_serializing_if = "Option::is_none")]
    pub app_settings_overrides: Option<serde_json::Value>,
    #[serde(rename = "configureLoadBalancing", default, skip_serializing_if = "Option::is_none")]
    pub configure_load_balancing: Option<bool>,
    #[serde(rename = "trafficManagerProfileId", default, skip_serializing_if = "Option::is_none")]
    pub traffic_manager_profile_id: Option<String>,
    #[serde(rename = "trafficManagerProfileName", default, skip_serializing_if = "Option::is_none")]
    pub traffic_manager_profile_name: Option<String>,
}
impl CloningInfo {
    pub fn new(source_web_app_id: String) -> Self {
        Self {
            correlation_id: None,
            overwrite: None,
            clone_custom_host_names: None,
            clone_source_control: None,
            source_web_app_id,
            source_web_app_location: None,
            hosting_environment: None,
            app_settings_overrides: None,
            configure_load_balancing: None,
            traffic_manager_profile_id: None,
            traffic_manager_profile_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnStringInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<conn_string_info::Type>,
}
impl ConnStringInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod conn_string_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        MySql,
        #[serde(rename = "SQLServer")]
        SqlServer,
        #[serde(rename = "SQLAzure")]
        SqlAzure,
        Custom,
        NotificationHub,
        ServiceBus,
        EventHub,
        ApiHub,
        DocDb,
        RedisCache,
        #[serde(rename = "PostgreSQL")]
        PostgreSql,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnStringValueTypePair {
    pub value: String,
    #[serde(rename = "type")]
    pub type_: conn_string_value_type_pair::Type,
}
impl ConnStringValueTypePair {
    pub fn new(value: String, type_: conn_string_value_type_pair::Type) -> Self {
        Self { value, type_ }
    }
}
pub mod conn_string_value_type_pair {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        MySql,
        #[serde(rename = "SQLServer")]
        SqlServer,
        #[serde(rename = "SQLAzure")]
        SqlAzure,
        Custom,
        NotificationHub,
        ServiceBus,
        EventHub,
        ApiHub,
        DocDb,
        RedisCache,
        #[serde(rename = "PostgreSQL")]
        PostgreSql,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionStringDictionary {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl ConnectionStringDictionary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Contact {
    #[serde(rename = "addressMailing", default, skip_serializing_if = "Option::is_none")]
    pub address_mailing: Option<Address>,
    pub email: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fax: Option<String>,
    #[serde(rename = "jobTitle", default, skip_serializing_if = "Option::is_none")]
    pub job_title: Option<String>,
    #[serde(rename = "nameFirst")]
    pub name_first: String,
    #[serde(rename = "nameLast")]
    pub name_last: String,
    #[serde(rename = "nameMiddle", default, skip_serializing_if = "Option::is_none")]
    pub name_middle: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub organization: Option<String>,
    pub phone: String,
}
impl Contact {
    pub fn new(email: String, name_first: String, name_last: String, phone: String) -> Self {
        Self {
            address_mailing: None,
            email,
            fax: None,
            job_title: None,
            name_first,
            name_last,
            name_middle: None,
            organization: None,
            phone,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContinuousWebJob {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<continuous_web_job::Properties>,
}
impl ContinuousWebJob {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod continuous_web_job {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub detailed_status: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub log_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub run_command: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub extra_info_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub web_job_type: Option<properties::WebJobType>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub error: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub using_sdk: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub settings: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Initializing,
            Starting,
            Running,
            PendingRestart,
            Stopped,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum WebJobType {
            Continuous,
            Triggered,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContinuousWebJobCollection {
    pub value: Vec<ContinuousWebJob>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ContinuousWebJobCollection {
    pub fn new(value: Vec<ContinuousWebJob>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CorsSettings {
    #[serde(rename = "allowedOrigins", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_origins: Vec<String>,
    #[serde(rename = "supportCredentials", default, skip_serializing_if = "Option::is_none")]
    pub support_credentials: Option<bool>,
}
impl CorsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmMoveResourceEnvelope {
    #[serde(rename = "targetResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<String>,
}
impl CsmMoveResourceEnvelope {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CsmOperationCollection {
    pub value: Vec<CsmOperationDescription>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CsmOperationCollection {
    pub fn new(value: Vec<CsmOperationDescription>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmOperationDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<CsmOperationDisplay>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CsmOperationDescriptionProperties>,
}
impl CsmOperationDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmOperationDescriptionProperties {
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<ServiceSpecification>,
}
impl CsmOperationDescriptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmOperationDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl CsmOperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmPublishingProfileOptions {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<csm_publishing_profile_options::Format>,
    #[serde(rename = "includeDisasterRecoveryEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub include_disaster_recovery_endpoints: Option<bool>,
}
impl CsmPublishingProfileOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod csm_publishing_profile_options {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Format {
        FileZilla3,
        WebDeploy,
        Ftp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CsmSlotEntity {
    #[serde(rename = "targetSlot")]
    pub target_slot: String,
    #[serde(rename = "preserveVnet")]
    pub preserve_vnet: bool,
}
impl CsmSlotEntity {
    pub fn new(target_slot: String, preserve_vnet: bool) -> Self {
        Self {
            target_slot,
            preserve_vnet,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmUsageQuota {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
    pub next_reset_time: Option<String>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<LocalizableString>,
}
impl CsmUsageQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CsmUsageQuotaCollection {
    pub value: Vec<CsmUsageQuota>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CsmUsageQuotaCollection {
    pub fn new(value: Vec<CsmUsageQuota>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomHostnameAnalysisResult {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<custom_hostname_analysis_result::Properties>,
}
impl CustomHostnameAnalysisResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod custom_hostname_analysis_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "isHostnameAlreadyVerified", default, skip_serializing_if = "Option::is_none")]
        pub is_hostname_already_verified: Option<bool>,
        #[serde(rename = "customDomainVerificationTest", default, skip_serializing_if = "Option::is_none")]
        pub custom_domain_verification_test: Option<properties::CustomDomainVerificationTest>,
        #[serde(rename = "customDomainVerificationFailureInfo", default, skip_serializing_if = "Option::is_none")]
        pub custom_domain_verification_failure_info: Option<ErrorEntity>,
        #[serde(rename = "hasConflictOnScaleUnit", default, skip_serializing_if = "Option::is_none")]
        pub has_conflict_on_scale_unit: Option<bool>,
        #[serde(rename = "hasConflictAcrossSubscription", default, skip_serializing_if = "Option::is_none")]
        pub has_conflict_across_subscription: Option<bool>,
        #[serde(rename = "conflictingAppResourceId", default, skip_serializing_if = "Option::is_none")]
        pub conflicting_app_resource_id: Option<String>,
        #[serde(rename = "cNameRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub c_name_records: Vec<String>,
        #[serde(rename = "txtRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub txt_records: Vec<String>,
        #[serde(rename = "aRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub a_records: Vec<String>,
        #[serde(rename = "alternateCNameRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub alternate_c_name_records: Vec<String>,
        #[serde(rename = "alternateTxtRecords", default, skip_serializing_if = "Vec::is_empty")]
        pub alternate_txt_records: Vec<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum CustomDomainVerificationTest {
            Passed,
            Failed,
            Skipped,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataSource {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub instructions: Vec<String>,
    #[serde(rename = "dataSourceUri", default, skip_serializing_if = "Vec::is_empty")]
    pub data_source_uri: Vec<NameValuePair>,
}
impl DataSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataTableResponseColumn {
    #[serde(rename = "columnName", default, skip_serializing_if = "Option::is_none")]
    pub column_name: Option<String>,
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<String>,
    #[serde(rename = "columnType", default, skip_serializing_if = "Option::is_none")]
    pub column_type: Option<String>,
}
impl DataTableResponseColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataTableResponseObject {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<DataTableResponseColumn>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rows: Vec<Vec<String>>,
}
impl DataTableResponseObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseBackupSetting {
    #[serde(rename = "databaseType")]
    pub database_type: database_backup_setting::DatabaseType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "connectionStringName", default, skip_serializing_if = "Option::is_none")]
    pub connection_string_name: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
}
impl DatabaseBackupSetting {
    pub fn new(database_type: database_backup_setting::DatabaseType) -> Self {
        Self {
            database_type,
            name: None,
            connection_string_name: None,
            connection_string: None,
        }
    }
}
pub mod database_backup_setting {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DatabaseType {
        SqlAzure,
        MySql,
        LocalMySql,
        PostgreSql,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<default_error_response::Error>,
}
impl DefaultErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod default_error_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Error {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub code: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub target: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub details: Vec<serde_json::Value>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub innererror: Option<String>,
    }
    impl Error {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeletedAppRestoreRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<deleted_app_restore_request::Properties>,
}
impl DeletedAppRestoreRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod deleted_app_restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "deletedSiteId", default, skip_serializing_if = "Option::is_none")]
        pub deleted_site_id: Option<String>,
        #[serde(rename = "recoverConfiguration", default, skip_serializing_if = "Option::is_none")]
        pub recover_configuration: Option<bool>,
        #[serde(rename = "snapshotTime", default, skip_serializing_if = "Option::is_none")]
        pub snapshot_time: Option<String>,
        #[serde(rename = "useDRSecondary", default, skip_serializing_if = "Option::is_none")]
        pub use_dr_secondary: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeletedSite {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<deleted_site::Properties>,
}
impl DeletedSite {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod deleted_site {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "deletedSiteId", default, skip_serializing_if = "Option::is_none")]
        pub deleted_site_id: Option<i32>,
        #[serde(rename = "deletedTimestamp", default, skip_serializing_if = "Option::is_none")]
        pub deleted_timestamp: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subscription: Option<String>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(rename = "deletedSiteName", default, skip_serializing_if = "Option::is_none")]
        pub deleted_site_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub slot: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub kind: Option<String>,
        #[serde(rename = "geoRegionName", default, skip_serializing_if = "Option::is_none")]
        pub geo_region_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeletedWebAppCollection {
    pub value: Vec<DeletedSite>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DeletedWebAppCollection {
    pub fn new(value: Vec<DeletedSite>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Deployment {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<deployment::Properties>,
}
impl Deployment {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod deployment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub author: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub deployer: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub author_email: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub active: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub details: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeploymentCollection {
    pub value: Vec<Deployment>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DeploymentCollection {
    pub fn new(value: Vec<Deployment>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentLocations {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<GeoRegion>,
    #[serde(rename = "hostingEnvironments", default, skip_serializing_if = "Vec::is_empty")]
    pub hosting_environments: Vec<AppServiceEnvironment>,
    #[serde(rename = "hostingEnvironmentDeploymentInfos", default, skip_serializing_if = "Vec::is_empty")]
    pub hosting_environment_deployment_infos: Vec<HostingEnvironmentDeploymentInfo>,
}
impl DeploymentLocations {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetectorAbnormalTimePeriod {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<f64>,
    #[serde(rename = "metaData", default, skip_serializing_if = "Vec::is_empty")]
    pub meta_data: Vec<Vec<NameValuePair>>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<detector_abnormal_time_period::Type>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub solutions: Vec<Solution>,
}
impl DetectorAbnormalTimePeriod {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod detector_abnormal_time_period {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        ServiceIncident,
        AppDeployment,
        AppCrash,
        RuntimeIssueDetected,
        AseDeployment,
        UserIssue,
        PlatformIssue,
        Other,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetectorDefinition {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<detector_definition::Properties>,
}
impl DetectorDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod detector_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub rank: Option<f64>,
        #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
        pub is_enabled: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetectorInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(rename = "subCategory", default, skip_serializing_if = "Option::is_none")]
    pub sub_category: Option<String>,
    #[serde(rename = "supportTopicId", default, skip_serializing_if = "Option::is_none")]
    pub support_topic_id: Option<String>,
}
impl DetectorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetectorResponse {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<detector_response::Properties>,
}
impl DetectorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod detector_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub metadata: Option<DetectorInfo>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub dataset: Vec<DiagnosticData>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DetectorResponseCollection {
    pub value: Vec<DetectorResponse>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DetectorResponseCollection {
    pub fn new(value: Vec<DetectorResponse>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticAnalysis {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<diagnostic_analysis::Properties>,
}
impl DiagnosticAnalysis {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod diagnostic_analysis {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(rename = "abnormalTimePeriods", default, skip_serializing_if = "Vec::is_empty")]
        pub abnormal_time_periods: Vec<AbnormalTimePeriod>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub payload: Vec<AnalysisData>,
        #[serde(rename = "nonCorrelatedDetectors", default, skip_serializing_if = "Vec::is_empty")]
        pub non_correlated_detectors: Vec<DetectorDefinition>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiagnosticAnalysisCollection {
    pub value: Vec<AnalysisDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiagnosticAnalysisCollection {
    pub fn new(value: Vec<AnalysisDefinition>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticCategory {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<diagnostic_category::Properties>,
}
impl DiagnosticCategory {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod diagnostic_category {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiagnosticCategoryCollection {
    pub value: Vec<DiagnosticCategory>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiagnosticCategoryCollection {
    pub fn new(value: Vec<DiagnosticCategory>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<DataTableResponseObject>,
    #[serde(rename = "renderingProperties", default, skip_serializing_if = "Option::is_none")]
    pub rendering_properties: Option<Rendering>,
}
impl DiagnosticData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiagnosticDetectorCollection {
    pub value: Vec<DetectorDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiagnosticDetectorCollection {
    pub fn new(value: Vec<DetectorDefinition>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticDetectorResponse {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<diagnostic_detector_response::Properties>,
}
impl DiagnosticDetectorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod diagnostic_detector_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(rename = "issueDetected", default, skip_serializing_if = "Option::is_none")]
        pub issue_detected: Option<bool>,
        #[serde(rename = "detectorDefinition", default, skip_serializing_if = "Option::is_none")]
        pub detector_definition: Option<DetectorDefinition>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub metrics: Vec<DiagnosticMetricSet>,
        #[serde(rename = "abnormalTimePeriods", default, skip_serializing_if = "Vec::is_empty")]
        pub abnormal_time_periods: Vec<DetectorAbnormalTimePeriod>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub data: Vec<Vec<NameValuePair>>,
        #[serde(rename = "responseMetaData", default, skip_serializing_if = "Option::is_none")]
        pub response_meta_data: Option<ResponseMetaData>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticMetricSample {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "roleInstance", default, skip_serializing_if = "Option::is_none")]
    pub role_instance: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f64>,
    #[serde(rename = "isAggregated", default, skip_serializing_if = "Option::is_none")]
    pub is_aggregated: Option<bool>,
}
impl DiagnosticMetricSample {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticMetricSet {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<DiagnosticMetricSample>,
}
impl DiagnosticMetricSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "internalName", default, skip_serializing_if = "Option::is_none")]
    pub internal_name: Option<String>,
    #[serde(rename = "toBeExportedForShoebox", default, skip_serializing_if = "Option::is_none")]
    pub to_be_exported_for_shoebox: Option<bool>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Domain {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<domain::Properties>,
}
impl Domain {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod domain {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "contactAdmin")]
        pub contact_admin: Contact,
        #[serde(rename = "contactBilling")]
        pub contact_billing: Contact,
        #[serde(rename = "contactRegistrant")]
        pub contact_registrant: Contact,
        #[serde(rename = "contactTech")]
        pub contact_tech: Contact,
        #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
        pub registration_status: Option<properties::RegistrationStatus>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[serde(rename = "nameServers", default, skip_serializing_if = "Vec::is_empty")]
        pub name_servers: Vec<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub privacy: Option<bool>,
        #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
        pub created_time: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
        #[serde(rename = "lastRenewedTime", default, skip_serializing_if = "Option::is_none")]
        pub last_renewed_time: Option<String>,
        #[serde(rename = "autoRenew", default, skip_serializing_if = "Option::is_none")]
        pub auto_renew: Option<bool>,
        #[serde(rename = "readyForDnsRecordManagement", default, skip_serializing_if = "Option::is_none")]
        pub ready_for_dns_record_management: Option<bool>,
        #[serde(rename = "managedHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub managed_host_names: Vec<HostName>,
        pub consent: DomainPurchaseConsent,
        #[serde(rename = "domainNotRenewableReasons", default, skip_serializing_if = "Vec::is_empty")]
        pub domain_not_renewable_reasons: Vec<String>,
        #[serde(rename = "dnsType", default, skip_serializing_if = "Option::is_none")]
        pub dns_type: Option<properties::DnsType>,
        #[serde(rename = "dnsZoneId", default, skip_serializing_if = "Option::is_none")]
        pub dns_zone_id: Option<String>,
        #[serde(rename = "targetDnsType", default, skip_serializing_if = "Option::is_none")]
        pub target_dns_type: Option<properties::TargetDnsType>,
        #[serde(rename = "authCode", default, skip_serializing_if = "Option::is_none")]
        pub auth_code: Option<String>,
    }
    impl Properties {
        pub fn new(
            contact_admin: Contact,
            contact_billing: Contact,
            contact_registrant: Contact,
            contact_tech: Contact,
            consent: DomainPurchaseConsent,
        ) -> Self {
            Self {
                contact_admin,
                contact_billing,
                contact_registrant,
                contact_tech,
                registration_status: None,
                provisioning_state: None,
                name_servers: Vec::new(),
                privacy: None,
                created_time: None,
                expiration_time: None,
                last_renewed_time: None,
                auto_renew: None,
                ready_for_dns_record_management: None,
                managed_host_names: Vec::new(),
                consent,
                domain_not_renewable_reasons: Vec::new(),
                dns_type: None,
                dns_zone_id: None,
                target_dns_type: None,
                auth_code: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RegistrationStatus {
            Active,
            Awaiting,
            Cancelled,
            Confiscated,
            Disabled,
            Excluded,
            Expired,
            Failed,
            Held,
            Locked,
            Parked,
            Pending,
            Reserved,
            Reverted,
            Suspended,
            Transferred,
            Unknown,
            Unlocked,
            Unparked,
            Updated,
            JsonConverterFailed,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum DnsType {
            AzureDns,
            DefaultDomainRegistrarDns,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum TargetDnsType {
            AzureDns,
            DefaultDomainRegistrarDns,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainAvailablilityCheckResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
    #[serde(rename = "domainType", default, skip_serializing_if = "Option::is_none")]
    pub domain_type: Option<domain_availablility_check_result::DomainType>,
}
impl DomainAvailablilityCheckResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod domain_availablility_check_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DomainType {
        Regular,
        SoftDeleted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DomainCollection {
    pub value: Vec<Domain>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DomainCollection {
    pub fn new(value: Vec<Domain>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainControlCenterSsoRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "postParameterKey", default, skip_serializing_if = "Option::is_none")]
    pub post_parameter_key: Option<String>,
    #[serde(rename = "postParameterValue", default, skip_serializing_if = "Option::is_none")]
    pub post_parameter_value: Option<String>,
}
impl DomainControlCenterSsoRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainOwnershipIdentifier {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<domain_ownership_identifier::Properties>,
}
impl DomainOwnershipIdentifier {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod domain_ownership_identifier {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "ownershipId", default, skip_serializing_if = "Option::is_none")]
        pub ownership_id: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DomainOwnershipIdentifierCollection {
    pub value: Vec<DomainOwnershipIdentifier>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DomainOwnershipIdentifierCollection {
    pub fn new(value: Vec<DomainOwnershipIdentifier>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainPatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<domain_patch_resource::Properties>,
}
impl DomainPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod domain_patch_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "contactAdmin")]
        pub contact_admin: Contact,
        #[serde(rename = "contactBilling")]
        pub contact_billing: Contact,
        #[serde(rename = "contactRegistrant")]
        pub contact_registrant: Contact,
        #[serde(rename = "contactTech")]
        pub contact_tech: Contact,
        #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
        pub registration_status: Option<properties::RegistrationStatus>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[serde(rename = "nameServers", default, skip_serializing_if = "Vec::is_empty")]
        pub name_servers: Vec<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub privacy: Option<bool>,
        #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
        pub created_time: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
        #[serde(rename = "lastRenewedTime", default, skip_serializing_if = "Option::is_none")]
        pub last_renewed_time: Option<String>,
        #[serde(rename = "autoRenew", default, skip_serializing_if = "Option::is_none")]
        pub auto_renew: Option<bool>,
        #[serde(rename = "readyForDnsRecordManagement", default, skip_serializing_if = "Option::is_none")]
        pub ready_for_dns_record_management: Option<bool>,
        #[serde(rename = "managedHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub managed_host_names: Vec<HostName>,
        pub consent: DomainPurchaseConsent,
        #[serde(rename = "domainNotRenewableReasons", default, skip_serializing_if = "Vec::is_empty")]
        pub domain_not_renewable_reasons: Vec<String>,
        #[serde(rename = "dnsType", default, skip_serializing_if = "Option::is_none")]
        pub dns_type: Option<properties::DnsType>,
        #[serde(rename = "dnsZoneId", default, skip_serializing_if = "Option::is_none")]
        pub dns_zone_id: Option<String>,
        #[serde(rename = "targetDnsType", default, skip_serializing_if = "Option::is_none")]
        pub target_dns_type: Option<properties::TargetDnsType>,
        #[serde(rename = "authCode", default, skip_serializing_if = "Option::is_none")]
        pub auth_code: Option<String>,
    }
    impl Properties {
        pub fn new(
            contact_admin: Contact,
            contact_billing: Contact,
            contact_registrant: Contact,
            contact_tech: Contact,
            consent: DomainPurchaseConsent,
        ) -> Self {
            Self {
                contact_admin,
                contact_billing,
                contact_registrant,
                contact_tech,
                registration_status: None,
                provisioning_state: None,
                name_servers: Vec::new(),
                privacy: None,
                created_time: None,
                expiration_time: None,
                last_renewed_time: None,
                auto_renew: None,
                ready_for_dns_record_management: None,
                managed_host_names: Vec::new(),
                consent,
                domain_not_renewable_reasons: Vec::new(),
                dns_type: None,
                dns_zone_id: None,
                target_dns_type: None,
                auth_code: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RegistrationStatus {
            Active,
            Awaiting,
            Cancelled,
            Confiscated,
            Disabled,
            Excluded,
            Expired,
            Failed,
            Held,
            Locked,
            Parked,
            Pending,
            Reserved,
            Reverted,
            Suspended,
            Transferred,
            Unknown,
            Unlocked,
            Unparked,
            Updated,
            JsonConverterFailed,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum DnsType {
            AzureDns,
            DefaultDomainRegistrarDns,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum TargetDnsType {
            AzureDns,
            DefaultDomainRegistrarDns,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainPurchaseConsent {
    #[serde(rename = "agreementKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub agreement_keys: Vec<String>,
    #[serde(rename = "agreedBy", default, skip_serializing_if = "Option::is_none")]
    pub agreed_by: Option<String>,
    #[serde(rename = "agreedAt", default, skip_serializing_if = "Option::is_none")]
    pub agreed_at: Option<String>,
}
impl DomainPurchaseConsent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainRecommendationSearchParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keywords: Option<String>,
    #[serde(rename = "maxDomainRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub max_domain_recommendations: Option<i32>,
}
impl DomainRecommendationSearchParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnabledConfig {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl EnabledConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointDependency {
    #[serde(rename = "domainName", default, skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    #[serde(rename = "endpointDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub endpoint_details: Vec<EndpointDetail>,
}
impl EndpointDependency {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointDetail {
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub latency: Option<f64>,
    #[serde(rename = "isAccessable", default, skip_serializing_if = "Option::is_none")]
    pub is_accessable: Option<bool>,
}
impl EndpointDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorEntity {
    #[serde(rename = "extendedCode", default, skip_serializing_if = "Option::is_none")]
    pub extended_code: Option<String>,
    #[serde(rename = "messageTemplate", default, skip_serializing_if = "Option::is_none")]
    pub message_template: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<String>,
    #[serde(rename = "innerErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub inner_errors: Vec<ErrorEntity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Experiments {
    #[serde(rename = "rampUpRules", default, skip_serializing_if = "Vec::is_empty")]
    pub ramp_up_rules: Vec<RampUpRule>,
}
impl Experiments {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileSystemApplicationLogsConfig {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<file_system_application_logs_config::Level>,
}
impl FileSystemApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod file_system_application_logs_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Off,
        Verbose,
        Information,
        Warning,
        Error,
    }
    impl Default for Level {
        fn default() -> Self {
            Self::Off
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileSystemHttpLogsConfig {
    #[serde(rename = "retentionInMb", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_mb: Option<i32>,
    #[serde(rename = "retentionInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_days: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl FileSystemHttpLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FunctionEnvelope {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<function_envelope::Properties>,
}
impl FunctionEnvelope {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod function_envelope {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub function_app_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub script_root_path_href: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub script_href: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub config_href: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub secrets_file_href: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub href: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub config: Option<serde_json::Value>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub files: Option<serde_json::Value>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub test_data: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FunctionEnvelopeCollection {
    pub value: Vec<FunctionEnvelope>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FunctionEnvelopeCollection {
    pub fn new(value: Vec<FunctionEnvelope>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FunctionSecrets {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<function_secrets::Properties>,
}
impl FunctionSecrets {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod function_secrets {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub key: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub trigger_url: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GeoDistribution {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "numberOfWorkers", default, skip_serializing_if = "Option::is_none")]
    pub number_of_workers: Option<i32>,
}
impl GeoDistribution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GeoRegion {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<geo_region::Properties>,
}
impl GeoRegion {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod geo_region {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GeoRegionCollection {
    pub value: Vec<GeoRegion>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GeoRegionCollection {
    pub fn new(value: Vec<GeoRegion>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GlobalCsmSkuDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<SkuCapacity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
}
impl GlobalCsmSkuDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HandlerMapping {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub extension: Option<String>,
    #[serde(rename = "scriptProcessor", default, skip_serializing_if = "Option::is_none")]
    pub script_processor: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub arguments: Option<String>,
}
impl HandlerMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "siteNames", default, skip_serializing_if = "Vec::is_empty")]
    pub site_names: Vec<String>,
    #[serde(rename = "azureResourceName", default, skip_serializing_if = "Option::is_none")]
    pub azure_resource_name: Option<String>,
    #[serde(rename = "azureResourceType", default, skip_serializing_if = "Option::is_none")]
    pub azure_resource_type: Option<host_name::AzureResourceType>,
    #[serde(rename = "customHostNameDnsRecordType", default, skip_serializing_if = "Option::is_none")]
    pub custom_host_name_dns_record_type: Option<host_name::CustomHostNameDnsRecordType>,
    #[serde(rename = "hostNameType", default, skip_serializing_if = "Option::is_none")]
    pub host_name_type: Option<host_name::HostNameType>,
}
impl HostName {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod host_name {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureResourceType {
        Website,
        TrafficManager,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CustomHostNameDnsRecordType {
        CName,
        A,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HostNameType {
        Verified,
        Managed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostNameBinding {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<host_name_binding::Properties>,
}
impl HostNameBinding {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod host_name_binding {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[serde(rename = "domainId", default, skip_serializing_if = "Option::is_none")]
        pub domain_id: Option<String>,
        #[serde(rename = "azureResourceName", default, skip_serializing_if = "Option::is_none")]
        pub azure_resource_name: Option<String>,
        #[serde(rename = "azureResourceType", default, skip_serializing_if = "Option::is_none")]
        pub azure_resource_type: Option<properties::AzureResourceType>,
        #[serde(rename = "customHostNameDnsRecordType", default, skip_serializing_if = "Option::is_none")]
        pub custom_host_name_dns_record_type: Option<properties::CustomHostNameDnsRecordType>,
        #[serde(rename = "hostNameType", default, skip_serializing_if = "Option::is_none")]
        pub host_name_type: Option<properties::HostNameType>,
        #[serde(rename = "sslState", default, skip_serializing_if = "Option::is_none")]
        pub ssl_state: Option<properties::SslState>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
        #[serde(rename = "virtualIP", default, skip_serializing_if = "Option::is_none")]
        pub virtual_ip: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AzureResourceType {
            Website,
            TrafficManager,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum CustomHostNameDnsRecordType {
            CName,
            A,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum HostNameType {
            Verified,
            Managed,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum SslState {
            Disabled,
            SniEnabled,
            IpBasedEnabled,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HostNameBindingCollection {
    pub value: Vec<HostNameBinding>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl HostNameBindingCollection {
    pub fn new(value: Vec<HostNameBinding>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostNameSslState {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "sslState", default, skip_serializing_if = "Option::is_none")]
    pub ssl_state: Option<host_name_ssl_state::SslState>,
    #[serde(rename = "virtualIP", default, skip_serializing_if = "Option::is_none")]
    pub virtual_ip: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(rename = "toUpdate", default, skip_serializing_if = "Option::is_none")]
    pub to_update: Option<bool>,
    #[serde(rename = "hostType", default, skip_serializing_if = "Option::is_none")]
    pub host_type: Option<host_name_ssl_state::HostType>,
}
impl HostNameSslState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod host_name_ssl_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SslState {
        Disabled,
        SniEnabled,
        IpBasedEnabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HostType {
        Standard,
        Repository,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentDeploymentInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl HostingEnvironmentDeploymentInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentDiagnostics {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "diagnosicsOutput", default, skip_serializing_if = "Option::is_none")]
    pub diagnosics_output: Option<String>,
}
impl HostingEnvironmentDiagnostics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentProfile {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl HostingEnvironmentProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpLogsConfig {
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<FileSystemHttpLogsConfig>,
    #[serde(rename = "azureBlobStorage", default, skip_serializing_if = "Option::is_none")]
    pub azure_blob_storage: Option<AzureBlobStorageHttpLogsConfig>,
}
impl HttpLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HybridConnection {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hybrid_connection::Properties>,
}
impl HybridConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hybrid_connection {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "serviceBusNamespace", default, skip_serializing_if = "Option::is_none")]
        pub service_bus_namespace: Option<String>,
        #[serde(rename = "relayName", default, skip_serializing_if = "Option::is_none")]
        pub relay_name: Option<String>,
        #[serde(rename = "relayArmUri", default, skip_serializing_if = "Option::is_none")]
        pub relay_arm_uri: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub hostname: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub port: Option<i32>,
        #[serde(rename = "sendKeyName", default, skip_serializing_if = "Option::is_none")]
        pub send_key_name: Option<String>,
        #[serde(rename = "sendKeyValue", default, skip_serializing_if = "Option::is_none")]
        pub send_key_value: Option<String>,
        #[serde(rename = "serviceBusSuffix", default, skip_serializing_if = "Option::is_none")]
        pub service_bus_suffix: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HybridConnectionCollection {
    pub value: Vec<HybridConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl HybridConnectionCollection {
    pub fn new(value: Vec<HybridConnection>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HybridConnectionKey {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hybrid_connection_key::Properties>,
}
impl HybridConnectionKey {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hybrid_connection_key {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "sendKeyName", default, skip_serializing_if = "Option::is_none")]
        pub send_key_name: Option<String>,
        #[serde(rename = "sendKeyValue", default, skip_serializing_if = "Option::is_none")]
        pub send_key_value: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HybridConnectionLimits {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hybrid_connection_limits::Properties>,
}
impl HybridConnectionLimits {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hybrid_connection_limits {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub current: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub maximum: Option<i32>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Identifier {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<identifier::Properties>,
}
impl Identifier {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identifier {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IdentifierCollection {
    pub value: Vec<Identifier>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IdentifierCollection {
    pub fn new(value: Vec<Identifier>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundEnvironmentEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub ports: Vec<String>,
}
impl InboundEnvironmentEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundEnvironmentEndpointCollection {
    pub value: Vec<InboundEnvironmentEndpoint>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl InboundEnvironmentEndpointCollection {
    pub fn new(value: Vec<InboundEnvironmentEndpoint>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpSecurityRestriction {
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "subnetMask", default, skip_serializing_if = "Option::is_none")]
    pub subnet_mask: Option<String>,
    #[serde(rename = "vnetSubnetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub vnet_subnet_resource_id: Option<String>,
    #[serde(rename = "vnetTrafficTag", default, skip_serializing_if = "Option::is_none")]
    pub vnet_traffic_tag: Option<i32>,
    #[serde(rename = "subnetTrafficTag", default, skip_serializing_if = "Option::is_none")]
    pub subnet_traffic_tag: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<ip_security_restriction::Tag>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl IpSecurityRestriction {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ip_security_restriction {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tag {
        Default,
        XffProxy,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalizableString {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl LocalizableString {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl LogSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeploy {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MsDeployCore>,
}
impl MsDeploy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeployCore {
    #[serde(rename = "packageUri", default, skip_serializing_if = "Option::is_none")]
    pub package_uri: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(rename = "dbType", default, skip_serializing_if = "Option::is_none")]
    pub db_type: Option<String>,
    #[serde(rename = "setParametersXmlFileUri", default, skip_serializing_if = "Option::is_none")]
    pub set_parameters_xml_file_uri: Option<String>,
    #[serde(rename = "setParameters", default, skip_serializing_if = "Option::is_none")]
    pub set_parameters: Option<serde_json::Value>,
    #[serde(rename = "skipAppData", default, skip_serializing_if = "Option::is_none")]
    pub skip_app_data: Option<bool>,
    #[serde(rename = "appOffline", default, skip_serializing_if = "Option::is_none")]
    pub app_offline: Option<bool>,
}
impl MsDeployCore {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeployLog {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ms_deploy_log::Properties>,
}
impl MsDeployLog {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ms_deploy_log {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub entries: Vec<MsDeployLogEntry>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeployLogEntry {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<ms_deploy_log_entry::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl MsDeployLogEntry {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ms_deploy_log_entry {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Message,
        Warning,
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MsDeployStatus {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ms_deploy_status::Properties>,
}
impl MsDeployStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ms_deploy_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub deployer: Option<String>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub complete: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            #[serde(rename = "accepted")]
            Accepted,
            #[serde(rename = "running")]
            Running,
            #[serde(rename = "succeeded")]
            Succeeded,
            #[serde(rename = "failed")]
            Failed,
            #[serde(rename = "canceled")]
            Canceled,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedServiceIdentity {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<managed_service_identity::Type>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl ManagedServiceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_service_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricAvailabilily {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
}
impl MetricAvailabilily {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricAvailability {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl MetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricDefinition {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<metric_definition::Properties>,
}
impl MetricDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod metric_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub unit: Option<String>,
        #[serde(rename = "primaryAggregationType", default, skip_serializing_if = "Option::is_none")]
        pub primary_aggregation_type: Option<String>,
        #[serde(rename = "metricAvailabilities", default, skip_serializing_if = "Vec::is_empty")]
        pub metric_availabilities: Vec<MetricAvailabilily>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[serde(rename = "supportsInstanceLevelAggregation", default, skip_serializing_if = "Option::is_none")]
    pub supports_instance_level_aggregation: Option<bool>,
    #[serde(rename = "enableRegionalMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub enable_regional_mdm_account: Option<bool>,
    #[serde(rename = "sourceMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_account: Option<String>,
    #[serde(rename = "sourceMdmNamespace", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_namespace: Option<String>,
    #[serde(rename = "metricFilterPattern", default, skip_serializing_if = "Option::is_none")]
    pub metric_filter_pattern: Option<String>,
    #[serde(rename = "fillGapWithZero", default, skip_serializing_if = "Option::is_none")]
    pub fill_gap_with_zero: Option<bool>,
    #[serde(rename = "isInternal", default, skip_serializing_if = "Option::is_none")]
    pub is_internal: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Dimension>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub availabilities: Vec<MetricAvailability>,
}
impl MetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrateMySqlRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<migrate_my_sql_request::Properties>,
}
impl MigrateMySqlRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod migrate_my_sql_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "connectionString")]
        pub connection_string: String,
        #[serde(rename = "migrationType")]
        pub migration_type: properties::MigrationType,
    }
    impl Properties {
        pub fn new(connection_string: String, migration_type: properties::MigrationType) -> Self {
            Self {
                connection_string,
                migration_type,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum MigrationType {
            LocalToRemote,
            RemoteToLocal,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrateMySqlStatus {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<migrate_my_sql_status::Properties>,
}
impl MigrateMySqlStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod migrate_my_sql_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "migrationOperationStatus", default, skip_serializing_if = "Option::is_none")]
        pub migration_operation_status: Option<properties::MigrationOperationStatus>,
        #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
        pub operation_id: Option<String>,
        #[serde(rename = "localMySqlEnabled", default, skip_serializing_if = "Option::is_none")]
        pub local_my_sql_enabled: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum MigrationOperationStatus {
            InProgress,
            Failed,
            Succeeded,
            TimedOut,
            Created,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameIdentifier {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl NameIdentifier {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NameIdentifierCollection {
    pub value: Vec<NameIdentifier>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NameIdentifierCollection {
    pub fn new(value: Vec<NameIdentifier>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameValuePair {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl NameValuePair {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkAccessControlEntry {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<network_access_control_entry::Action>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub order: Option<i32>,
    #[serde(rename = "remoteSubnet", default, skip_serializing_if = "Option::is_none")]
    pub remote_subnet: Option<String>,
}
impl NetworkAccessControlEntry {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_access_control_entry {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Permit,
        Deny,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkFeatures {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<network_features::Properties>,
}
impl NetworkFeatures {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_features {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "virtualNetworkName", default, skip_serializing_if = "Option::is_none")]
        pub virtual_network_name: Option<String>,
        #[serde(rename = "virtualNetworkConnection", default, skip_serializing_if = "Option::is_none")]
        pub virtual_network_connection: Option<VnetInfo>,
        #[serde(rename = "hybridConnections", default, skip_serializing_if = "Vec::is_empty")]
        pub hybrid_connections: Vec<RelayServiceConnectionEntity>,
        #[serde(rename = "hybridConnectionsV2", default, skip_serializing_if = "Vec::is_empty")]
        pub hybrid_connections_v2: Vec<HybridConnection>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkTrace {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl NetworkTrace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<operation::Status>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ErrorEntity>,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "modifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub modified_time: Option<String>,
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[serde(rename = "geoMasterOperationId", default, skip_serializing_if = "Option::is_none")]
    pub geo_master_operation_id: Option<String>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Failed,
        Succeeded,
        TimedOut,
        Created,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OutboundEnvironmentEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<EndpointDependency>,
}
impl OutboundEnvironmentEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutboundEnvironmentEndpointCollection {
    pub value: Vec<OutboundEnvironmentEndpoint>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OutboundEnvironmentEndpointCollection {
    pub fn new(value: Vec<OutboundEnvironmentEndpoint>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PerfMonCounterCollection {
    pub value: Vec<PerfMonResponse>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PerfMonCounterCollection {
    pub fn new(value: Vec<PerfMonResponse>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerfMonResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<PerfMonSet>,
}
impl PerfMonResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerfMonSample {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[serde(rename = "instanceName", default, skip_serializing_if = "Option::is_none")]
    pub instance_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<f64>,
}
impl PerfMonSample {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerfMonSet {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<PerfMonSample>,
}
impl PerfMonSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PremierAddOn {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<premier_add_on::Properties>,
}
impl PremierAddOn {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod premier_add_on {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub sku: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub product: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub vendor: Option<String>,
        #[serde(rename = "marketplacePublisher", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_publisher: Option<String>,
        #[serde(rename = "marketplaceOffer", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_offer: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PremierAddOnOffer {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<premier_add_on_offer::Properties>,
}
impl PremierAddOnOffer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod premier_add_on_offer {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub sku: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub product: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub vendor: Option<String>,
        #[serde(rename = "promoCodeRequired", default, skip_serializing_if = "Option::is_none")]
        pub promo_code_required: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub quota: Option<i32>,
        #[serde(rename = "webHostingPlanRestrictions", default, skip_serializing_if = "Option::is_none")]
        pub web_hosting_plan_restrictions: Option<properties::WebHostingPlanRestrictions>,
        #[serde(rename = "privacyPolicyUrl", default, skip_serializing_if = "Option::is_none")]
        pub privacy_policy_url: Option<String>,
        #[serde(rename = "legalTermsUrl", default, skip_serializing_if = "Option::is_none")]
        pub legal_terms_url: Option<String>,
        #[serde(rename = "marketplacePublisher", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_publisher: Option<String>,
        #[serde(rename = "marketplaceOffer", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_offer: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum WebHostingPlanRestrictions {
            None,
            Free,
            Shared,
            Basic,
            Standard,
            Premium,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PremierAddOnOfferCollection {
    pub value: Vec<PremierAddOnOffer>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PremierAddOnOfferCollection {
    pub fn new(value: Vec<PremierAddOnOffer>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PremierAddOnPatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<premier_add_on_patch_resource::Properties>,
}
impl PremierAddOnPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod premier_add_on_patch_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub sku: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub product: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub vendor: Option<String>,
        #[serde(rename = "marketplacePublisher", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_publisher: Option<String>,
        #[serde(rename = "marketplaceOffer", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_offer: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateAccess {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<private_access::Properties>,
}
impl PrivateAccess {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod private_access {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "virtualNetworks", default, skip_serializing_if = "Vec::is_empty")]
        pub virtual_networks: Vec<PrivateAccessVirtualNetwork>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateAccessSubnet {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<i32>,
}
impl PrivateAccessSubnet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateAccessVirtualNetwork {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<i32>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<PrivateAccessSubnet>,
}
impl PrivateAccessVirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<process_info::Properties>,
}
impl ProcessInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod process_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub identifier: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub deployment_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub href: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub minidump: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub is_profile_running: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub is_iis_profile_running: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub iis_profile_timeout_in_seconds: Option<f64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub parent: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub children: Vec<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub threads: Vec<ProcessThreadInfo>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub open_file_handles: Vec<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub modules: Vec<ProcessModuleInfo>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub file_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub command_line: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub user_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub handle_count: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub module_count: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thread_count: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub total_cpu_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub user_cpu_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub privileged_cpu_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub working_set: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub peak_working_set: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub private_memory: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub virtual_memory: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub peak_virtual_memory: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub paged_system_memory: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub non_paged_system_memory: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub paged_memory: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub peak_paged_memory: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub time_stamp: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub environment_variables: Option<serde_json::Value>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub is_scm_site: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub is_webjob: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProcessInfoCollection {
    pub value: Vec<ProcessInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProcessInfoCollection {
    pub fn new(value: Vec<ProcessInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessModuleInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<process_module_info::Properties>,
}
impl ProcessModuleInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod process_module_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub base_address: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub file_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub href: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub file_path: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub module_memory_size: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub file_version: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub file_description: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub product: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub product_version: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub is_debug: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub language: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProcessModuleInfoCollection {
    pub value: Vec<ProcessModuleInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProcessModuleInfoCollection {
    pub fn new(value: Vec<ProcessModuleInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessThreadInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<process_thread_info::Properties>,
}
impl ProcessThreadInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod process_thread_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub identifier: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub href: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub process: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub start_address: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub current_priority: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub priority_level: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub base_priority: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub total_processor_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub user_processor_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub priviledged_processor_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub wait_reason: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProcessThreadInfoCollection {
    pub value: Vec<ProcessThreadInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProcessThreadInfoCollection {
    pub fn new(value: Vec<ProcessThreadInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyOnlyResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ProxyOnlyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicCertificate {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<public_certificate::Properties>,
}
impl PublicCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_certificate {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub blob: Option<String>,
        #[serde(rename = "publicCertificateLocation", default, skip_serializing_if = "Option::is_none")]
        pub public_certificate_location: Option<properties::PublicCertificateLocation>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum PublicCertificateLocation {
            CurrentUserMy,
            LocalMachineMy,
            Unknown,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PublicCertificateCollection {
    pub value: Vec<PublicCertificate>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PublicCertificateCollection {
    pub fn new(value: Vec<PublicCertificate>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PushSettings {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<push_settings::Properties>,
}
impl PushSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod push_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "isPushEnabled")]
        pub is_push_enabled: bool,
        #[serde(rename = "tagWhitelistJson", default, skip_serializing_if = "Option::is_none")]
        pub tag_whitelist_json: Option<String>,
        #[serde(rename = "tagsRequiringAuth", default, skip_serializing_if = "Option::is_none")]
        pub tags_requiring_auth: Option<String>,
        #[serde(rename = "dynamicTagsJson", default, skip_serializing_if = "Option::is_none")]
        pub dynamic_tags_json: Option<String>,
    }
    impl Properties {
        pub fn new(is_push_enabled: bool) -> Self {
            Self {
                is_push_enabled,
                tag_whitelist_json: None,
                tags_requiring_auth: None,
                dynamic_tags_json: None,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RampUpRule {
    #[serde(rename = "actionHostName", default, skip_serializing_if = "Option::is_none")]
    pub action_host_name: Option<String>,
    #[serde(rename = "reroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub reroute_percentage: Option<f64>,
    #[serde(rename = "changeStep", default, skip_serializing_if = "Option::is_none")]
    pub change_step: Option<f64>,
    #[serde(rename = "changeIntervalInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub change_interval_in_minutes: Option<i32>,
    #[serde(rename = "minReroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub min_reroute_percentage: Option<f64>,
    #[serde(rename = "maxReroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub max_reroute_percentage: Option<f64>,
    #[serde(rename = "changeDecisionCallbackUrl", default, skip_serializing_if = "Option::is_none")]
    pub change_decision_callback_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl RampUpRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Recommendation {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<recommendation::Properties>,
}
impl Recommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recommendation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
        pub creation_time: Option<String>,
        #[serde(rename = "recommendationId", default, skip_serializing_if = "Option::is_none")]
        pub recommendation_id: Option<String>,
        #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
        pub resource_id: Option<String>,
        #[serde(rename = "resourceScope", default, skip_serializing_if = "Option::is_none")]
        pub resource_scope: Option<properties::ResourceScope>,
        #[serde(rename = "ruleName", default, skip_serializing_if = "Option::is_none")]
        pub rule_name: Option<String>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub level: Option<properties::Level>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub channels: Option<properties::Channels>,
        #[serde(rename = "categoryTags", default, skip_serializing_if = "Vec::is_empty")]
        pub category_tags: Vec<String>,
        #[serde(rename = "actionName", default, skip_serializing_if = "Option::is_none")]
        pub action_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<i32>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub states: Vec<String>,
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(rename = "nextNotificationTime", default, skip_serializing_if = "Option::is_none")]
        pub next_notification_time: Option<String>,
        #[serde(rename = "notificationExpirationTime", default, skip_serializing_if = "Option::is_none")]
        pub notification_expiration_time: Option<String>,
        #[serde(rename = "notifiedTime", default, skip_serializing_if = "Option::is_none")]
        pub notified_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub score: Option<f64>,
        #[serde(rename = "isDynamic", default, skip_serializing_if = "Option::is_none")]
        pub is_dynamic: Option<bool>,
        #[serde(rename = "extensionName", default, skip_serializing_if = "Option::is_none")]
        pub extension_name: Option<String>,
        #[serde(rename = "bladeName", default, skip_serializing_if = "Option::is_none")]
        pub blade_name: Option<String>,
        #[serde(rename = "forwardLink", default, skip_serializing_if = "Option::is_none")]
        pub forward_link: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ResourceScope {
            ServerFarm,
            Subscription,
            WebSite,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Level {
            Critical,
            Warning,
            Information,
            NonUrgentSuggestion,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Channels {
            Notification,
            Api,
            Email,
            Webhook,
            All,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecommendationCollection {
    pub value: Vec<Recommendation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecommendationCollection {
    pub fn new(value: Vec<Recommendation>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendationRule {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<recommendation_rule::Properties>,
}
impl RecommendationRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recommendation_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "recommendationName", default, skip_serializing_if = "Option::is_none")]
        pub recommendation_name: Option<String>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(rename = "recommendationId", default, skip_serializing_if = "Option::is_none")]
        pub recommendation_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(rename = "actionName", default, skip_serializing_if = "Option::is_none")]
        pub action_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub level: Option<properties::Level>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub channels: Option<properties::Channels>,
        #[serde(rename = "categoryTags", default, skip_serializing_if = "Vec::is_empty")]
        pub category_tags: Vec<String>,
        #[serde(rename = "isDynamic", default, skip_serializing_if = "Option::is_none")]
        pub is_dynamic: Option<bool>,
        #[serde(rename = "extensionName", default, skip_serializing_if = "Option::is_none")]
        pub extension_name: Option<String>,
        #[serde(rename = "bladeName", default, skip_serializing_if = "Option::is_none")]
        pub blade_name: Option<String>,
        #[serde(rename = "forwardLink", default, skip_serializing_if = "Option::is_none")]
        pub forward_link: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Level {
            Critical,
            Warning,
            Information,
            NonUrgentSuggestion,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Channels {
            Notification,
            Api,
            Email,
            Webhook,
            All,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReissueCertificateOrderRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<reissue_certificate_order_request::Properties>,
}
impl ReissueCertificateOrderRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod reissue_certificate_order_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "keySize", default, skip_serializing_if = "Option::is_none")]
        pub key_size: Option<i32>,
        #[serde(rename = "delayExistingRevokeInHours", default, skip_serializing_if = "Option::is_none")]
        pub delay_existing_revoke_in_hours: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub csr: Option<String>,
        #[serde(rename = "isPrivateKeyExternal", default, skip_serializing_if = "Option::is_none")]
        pub is_private_key_external: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RelayServiceConnectionEntity {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<relay_service_connection_entity::Properties>,
}
impl RelayServiceConnectionEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod relay_service_connection_entity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "entityName", default, skip_serializing_if = "Option::is_none")]
        pub entity_name: Option<String>,
        #[serde(rename = "entityConnectionString", default, skip_serializing_if = "Option::is_none")]
        pub entity_connection_string: Option<String>,
        #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
        pub resource_type: Option<String>,
        #[serde(rename = "resourceConnectionString", default, skip_serializing_if = "Option::is_none")]
        pub resource_connection_string: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub hostname: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub port: Option<i32>,
        #[serde(rename = "biztalkUri", default, skip_serializing_if = "Option::is_none")]
        pub biztalk_uri: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Rendering {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<rendering::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl Rendering {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod rendering {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        NoGraph,
        Table,
        TimeSeries,
        TimeSeriesPerInstance,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RenewCertificateOrderRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<renew_certificate_order_request::Properties>,
}
impl RenewCertificateOrderRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod renew_certificate_order_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "keySize", default, skip_serializing_if = "Option::is_none")]
        pub key_size: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub csr: Option<String>,
        #[serde(rename = "isPrivateKeyExternal", default, skip_serializing_if = "Option::is_none")]
        pub is_private_key_external: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestsBasedTrigger {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl RequestsBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    pub location: String,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            kind: None,
            location,
            type_: None,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceCollection {
    pub value: Vec<String>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceCollection {
    pub fn new(value: Vec<String>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceHealthMetadata {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<resource_health_metadata::Properties>,
}
impl ResourceHealthMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_health_metadata {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub category: Option<String>,
        #[serde(rename = "signalAvailability", default, skip_serializing_if = "Option::is_none")]
        pub signal_availability: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceHealthMetadataCollection {
    pub value: Vec<ResourceHealthMetadata>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceHealthMetadataCollection {
    pub fn new(value: Vec<ResourceHealthMetadata>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetric {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<ResourceMetricName>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "metricValues", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_values: Vec<ResourceMetricValue>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<ResourceMetricProperty>,
}
impl ResourceMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricAvailability {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
}
impl ResourceMetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceMetricCollection {
    pub value: Vec<ResourceMetric>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceMetricCollection {
    pub fn new(value: Vec<ResourceMetric>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricDefinition {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<resource_metric_definition::Properties>,
}
impl ResourceMetricDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_metric_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub unit: Option<String>,
        #[serde(rename = "primaryAggregationType", default, skip_serializing_if = "Option::is_none")]
        pub primary_aggregation_type: Option<String>,
        #[serde(rename = "metricAvailabilities", default, skip_serializing_if = "Vec::is_empty")]
        pub metric_availabilities: Vec<ResourceMetricAvailability>,
        #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
        pub resource_uri: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub properties: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceMetricDefinitionCollection {
    pub value: Vec<ResourceMetricDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceMetricDefinitionCollection {
    pub fn new(value: Vec<ResourceMetricDefinition>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl ResourceMetricName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricProperty {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ResourceMetricProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricValue {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub average: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<f32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<ResourceMetricProperty>,
}
impl ResourceMetricValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNameAvailability {
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<resource_name_availability::Reason>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ResourceNameAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_name_availability {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceNameAvailabilityRequest {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: resource_name_availability_request::Type,
    #[serde(rename = "isFqdn", default, skip_serializing_if = "Option::is_none")]
    pub is_fqdn: Option<bool>,
}
impl ResourceNameAvailabilityRequest {
    pub fn new(name: String, type_: resource_name_availability_request::Type) -> Self {
        Self {
            name,
            type_,
            is_fqdn: None,
        }
    }
}
pub mod resource_name_availability_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Site,
        Slot,
        HostingEnvironment,
        PublishingUser,
        #[serde(rename = "Microsoft.Web/sites")]
        MicrosoftWebSites,
        #[serde(rename = "Microsoft.Web/sites/slots")]
        MicrosoftWebSitesSlots,
        #[serde(rename = "Microsoft.Web/hostingEnvironments")]
        MicrosoftWebHostingEnvironments,
        #[serde(rename = "Microsoft.Web/publishingUsers")]
        MicrosoftWebPublishingUsers,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseMetaData {
    #[serde(rename = "dataSource", default, skip_serializing_if = "Option::is_none")]
    pub data_source: Option<DataSource>,
}
impl ResponseMetaData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestoreRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<restore_request::Properties>,
}
impl RestoreRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "storageAccountUrl")]
        pub storage_account_url: String,
        #[serde(rename = "blobName", default, skip_serializing_if = "Option::is_none")]
        pub blob_name: Option<String>,
        pub overwrite: bool,
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub databases: Vec<DatabaseBackupSetting>,
        #[serde(rename = "ignoreConflictingHostNames", default, skip_serializing_if = "Option::is_none")]
        pub ignore_conflicting_host_names: Option<bool>,
        #[serde(rename = "ignoreDatabases", default, skip_serializing_if = "Option::is_none")]
        pub ignore_databases: Option<bool>,
        #[serde(rename = "appServicePlan", default, skip_serializing_if = "Option::is_none")]
        pub app_service_plan: Option<String>,
        #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
        pub operation_type: Option<properties::OperationType>,
        #[serde(rename = "adjustConnectionStrings", default, skip_serializing_if = "Option::is_none")]
        pub adjust_connection_strings: Option<bool>,
        #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment: Option<String>,
    }
    impl Properties {
        pub fn new(storage_account_url: String, overwrite: bool) -> Self {
            Self {
                storage_account_url,
                blob_name: None,
                overwrite,
                site_name: None,
                databases: Vec::new(),
                ignore_conflicting_host_names: None,
                ignore_databases: None,
                app_service_plan: None,
                operation_type: None,
                adjust_connection_strings: None,
                hosting_environment: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum OperationType {
            Default,
            Clone,
            Relocation,
            Snapshot,
            #[serde(rename = "CloudFS")]
            CloudFs,
        }
        impl Default for OperationType {
            fn default() -> Self {
                Self::Default
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceSpecification {
    #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_specifications: Vec<MetricSpecification>,
    #[serde(rename = "logSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub log_specifications: Vec<LogSpecification>,
}
impl ServiceSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Site {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site::Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
}
impl Site {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            identity: None,
        }
    }
}
pub mod site {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "repositorySiteName", default, skip_serializing_if = "Option::is_none")]
        pub repository_site_name: Option<String>,
        #[serde(rename = "usageState", default, skip_serializing_if = "Option::is_none")]
        pub usage_state: Option<properties::UsageState>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "enabledHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub enabled_host_names: Vec<String>,
        #[serde(rename = "availabilityState", default, skip_serializing_if = "Option::is_none")]
        pub availability_state: Option<properties::AvailabilityState>,
        #[serde(rename = "hostNameSslStates", default, skip_serializing_if = "Vec::is_empty")]
        pub host_name_ssl_states: Vec<HostNameSslState>,
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reserved: Option<bool>,
        #[serde(rename = "isXenon", default, skip_serializing_if = "Option::is_none")]
        pub is_xenon: Option<bool>,
        #[serde(rename = "hyperV", default, skip_serializing_if = "Option::is_none")]
        pub hyper_v: Option<bool>,
        #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
        pub last_modified_time_utc: Option<String>,
        #[serde(rename = "siteConfig", default, skip_serializing_if = "Option::is_none")]
        pub site_config: Option<SiteConfig>,
        #[serde(rename = "trafficManagerHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub traffic_manager_host_names: Vec<String>,
        #[serde(rename = "scmSiteAlsoStopped", default, skip_serializing_if = "Option::is_none")]
        pub scm_site_also_stopped: Option<bool>,
        #[serde(rename = "targetSwapSlot", default, skip_serializing_if = "Option::is_none")]
        pub target_swap_slot: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "clientAffinityEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_affinity_enabled: Option<bool>,
        #[serde(rename = "clientCertEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_cert_enabled: Option<bool>,
        #[serde(rename = "clientCertExclusionPaths", default, skip_serializing_if = "Option::is_none")]
        pub client_cert_exclusion_paths: Option<String>,
        #[serde(rename = "hostNamesDisabled", default, skip_serializing_if = "Option::is_none")]
        pub host_names_disabled: Option<bool>,
        #[serde(rename = "outboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub outbound_ip_addresses: Option<String>,
        #[serde(rename = "possibleOutboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub possible_outbound_ip_addresses: Option<String>,
        #[serde(rename = "containerSize", default, skip_serializing_if = "Option::is_none")]
        pub container_size: Option<i32>,
        #[serde(rename = "dailyMemoryTimeQuota", default, skip_serializing_if = "Option::is_none")]
        pub daily_memory_time_quota: Option<i32>,
        #[serde(rename = "suspendedTill", default, skip_serializing_if = "Option::is_none")]
        pub suspended_till: Option<String>,
        #[serde(rename = "maxNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub max_number_of_workers: Option<i32>,
        #[serde(rename = "cloningInfo", default, skip_serializing_if = "Option::is_none")]
        pub cloning_info: Option<CloningInfo>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(rename = "isDefaultContainer", default, skip_serializing_if = "Option::is_none")]
        pub is_default_container: Option<bool>,
        #[serde(rename = "defaultHostName", default, skip_serializing_if = "Option::is_none")]
        pub default_host_name: Option<String>,
        #[serde(rename = "slotSwapStatus", default, skip_serializing_if = "Option::is_none")]
        pub slot_swap_status: Option<SlotSwapStatus>,
        #[serde(rename = "httpsOnly", default, skip_serializing_if = "Option::is_none")]
        pub https_only: Option<bool>,
        #[serde(rename = "redundancyMode", default, skip_serializing_if = "Option::is_none")]
        pub redundancy_mode: Option<properties::RedundancyMode>,
        #[serde(rename = "inProgressOperationId", default, skip_serializing_if = "Option::is_none")]
        pub in_progress_operation_id: Option<String>,
        #[serde(rename = "geoDistributions", default, skip_serializing_if = "Vec::is_empty")]
        pub geo_distributions: Vec<GeoDistribution>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum UsageState {
            Normal,
            Exceeded,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AvailabilityState {
            Normal,
            Limited,
            DisasterRecoveryMode,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RedundancyMode {
            None,
            Manual,
            Failover,
            ActiveActive,
            GeoRedundant,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteAuthSettings {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_auth_settings::Properties>,
}
impl SiteAuthSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_auth_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "runtimeVersion", default, skip_serializing_if = "Option::is_none")]
        pub runtime_version: Option<String>,
        #[serde(rename = "unauthenticatedClientAction", default, skip_serializing_if = "Option::is_none")]
        pub unauthenticated_client_action: Option<properties::UnauthenticatedClientAction>,
        #[serde(rename = "tokenStoreEnabled", default, skip_serializing_if = "Option::is_none")]
        pub token_store_enabled: Option<bool>,
        #[serde(rename = "allowedExternalRedirectUrls", default, skip_serializing_if = "Vec::is_empty")]
        pub allowed_external_redirect_urls: Vec<String>,
        #[serde(rename = "defaultProvider", default, skip_serializing_if = "Option::is_none")]
        pub default_provider: Option<properties::DefaultProvider>,
        #[serde(rename = "tokenRefreshExtensionHours", default, skip_serializing_if = "Option::is_none")]
        pub token_refresh_extension_hours: Option<f64>,
        #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
        pub client_id: Option<String>,
        #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
        pub client_secret: Option<String>,
        #[serde(rename = "clientSecretCertificateThumbprint", default, skip_serializing_if = "Option::is_none")]
        pub client_secret_certificate_thumbprint: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub issuer: Option<String>,
        #[serde(rename = "validateIssuer", default, skip_serializing_if = "Option::is_none")]
        pub validate_issuer: Option<bool>,
        #[serde(rename = "allowedAudiences", default, skip_serializing_if = "Vec::is_empty")]
        pub allowed_audiences: Vec<String>,
        #[serde(rename = "additionalLoginParams", default, skip_serializing_if = "Vec::is_empty")]
        pub additional_login_params: Vec<String>,
        #[serde(rename = "googleClientId", default, skip_serializing_if = "Option::is_none")]
        pub google_client_id: Option<String>,
        #[serde(rename = "googleClientSecret", default, skip_serializing_if = "Option::is_none")]
        pub google_client_secret: Option<String>,
        #[serde(rename = "googleOAuthScopes", default, skip_serializing_if = "Vec::is_empty")]
        pub google_o_auth_scopes: Vec<String>,
        #[serde(rename = "facebookAppId", default, skip_serializing_if = "Option::is_none")]
        pub facebook_app_id: Option<String>,
        #[serde(rename = "facebookAppSecret", default, skip_serializing_if = "Option::is_none")]
        pub facebook_app_secret: Option<String>,
        #[serde(rename = "facebookOAuthScopes", default, skip_serializing_if = "Vec::is_empty")]
        pub facebook_o_auth_scopes: Vec<String>,
        #[serde(rename = "twitterConsumerKey", default, skip_serializing_if = "Option::is_none")]
        pub twitter_consumer_key: Option<String>,
        #[serde(rename = "twitterConsumerSecret", default, skip_serializing_if = "Option::is_none")]
        pub twitter_consumer_secret: Option<String>,
        #[serde(rename = "microsoftAccountClientId", default, skip_serializing_if = "Option::is_none")]
        pub microsoft_account_client_id: Option<String>,
        #[serde(rename = "microsoftAccountClientSecret", default, skip_serializing_if = "Option::is_none")]
        pub microsoft_account_client_secret: Option<String>,
        #[serde(rename = "microsoftAccountOAuthScopes", default, skip_serializing_if = "Vec::is_empty")]
        pub microsoft_account_o_auth_scopes: Vec<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum UnauthenticatedClientAction {
            RedirectToLoginPage,
            AllowAnonymous,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum DefaultProvider {
            AzureActiveDirectory,
            Facebook,
            Google,
            MicrosoftAccount,
            Twitter,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteCloneability {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub result: Option<site_cloneability::Result>,
    #[serde(rename = "blockingFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub blocking_features: Vec<SiteCloneabilityCriterion>,
    #[serde(rename = "unsupportedFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub unsupported_features: Vec<SiteCloneabilityCriterion>,
    #[serde(rename = "blockingCharacteristics", default, skip_serializing_if = "Vec::is_empty")]
    pub blocking_characteristics: Vec<SiteCloneabilityCriterion>,
}
impl SiteCloneability {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_cloneability {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Result {
        Cloneable,
        PartiallyCloneable,
        NotCloneable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteCloneabilityCriterion {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl SiteCloneabilityCriterion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteConfig {
    #[serde(rename = "numberOfWorkers", default, skip_serializing_if = "Option::is_none")]
    pub number_of_workers: Option<i32>,
    #[serde(rename = "defaultDocuments", default, skip_serializing_if = "Vec::is_empty")]
    pub default_documents: Vec<String>,
    #[serde(rename = "netFrameworkVersion", default, skip_serializing_if = "Option::is_none")]
    pub net_framework_version: Option<String>,
    #[serde(rename = "phpVersion", default, skip_serializing_if = "Option::is_none")]
    pub php_version: Option<String>,
    #[serde(rename = "pythonVersion", default, skip_serializing_if = "Option::is_none")]
    pub python_version: Option<String>,
    #[serde(rename = "nodeVersion", default, skip_serializing_if = "Option::is_none")]
    pub node_version: Option<String>,
    #[serde(rename = "linuxFxVersion", default, skip_serializing_if = "Option::is_none")]
    pub linux_fx_version: Option<String>,
    #[serde(rename = "windowsFxVersion", default, skip_serializing_if = "Option::is_none")]
    pub windows_fx_version: Option<String>,
    #[serde(rename = "requestTracingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub request_tracing_enabled: Option<bool>,
    #[serde(rename = "requestTracingExpirationTime", default, skip_serializing_if = "Option::is_none")]
    pub request_tracing_expiration_time: Option<String>,
    #[serde(rename = "remoteDebuggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub remote_debugging_enabled: Option<bool>,
    #[serde(rename = "remoteDebuggingVersion", default, skip_serializing_if = "Option::is_none")]
    pub remote_debugging_version: Option<String>,
    #[serde(rename = "httpLoggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub http_logging_enabled: Option<bool>,
    #[serde(rename = "logsDirectorySizeLimit", default, skip_serializing_if = "Option::is_none")]
    pub logs_directory_size_limit: Option<i32>,
    #[serde(rename = "detailedErrorLoggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub detailed_error_logging_enabled: Option<bool>,
    #[serde(rename = "publishingUsername", default, skip_serializing_if = "Option::is_none")]
    pub publishing_username: Option<String>,
    #[serde(rename = "appSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub app_settings: Vec<NameValuePair>,
    #[serde(rename = "azureStorageAccounts", default, skip_serializing_if = "Option::is_none")]
    pub azure_storage_accounts: Option<serde_json::Value>,
    #[serde(rename = "connectionStrings", default, skip_serializing_if = "Vec::is_empty")]
    pub connection_strings: Vec<ConnStringInfo>,
    #[serde(rename = "machineKey", default, skip_serializing_if = "Option::is_none")]
    pub machine_key: Option<SiteMachineKey>,
    #[serde(rename = "handlerMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub handler_mappings: Vec<HandlerMapping>,
    #[serde(rename = "documentRoot", default, skip_serializing_if = "Option::is_none")]
    pub document_root: Option<String>,
    #[serde(rename = "scmType", default, skip_serializing_if = "Option::is_none")]
    pub scm_type: Option<site_config::ScmType>,
    #[serde(rename = "use32BitWorkerProcess", default, skip_serializing_if = "Option::is_none")]
    pub use32_bit_worker_process: Option<bool>,
    #[serde(rename = "webSocketsEnabled", default, skip_serializing_if = "Option::is_none")]
    pub web_sockets_enabled: Option<bool>,
    #[serde(rename = "alwaysOn", default, skip_serializing_if = "Option::is_none")]
    pub always_on: Option<bool>,
    #[serde(rename = "javaVersion", default, skip_serializing_if = "Option::is_none")]
    pub java_version: Option<String>,
    #[serde(rename = "javaContainer", default, skip_serializing_if = "Option::is_none")]
    pub java_container: Option<String>,
    #[serde(rename = "javaContainerVersion", default, skip_serializing_if = "Option::is_none")]
    pub java_container_version: Option<String>,
    #[serde(rename = "appCommandLine", default, skip_serializing_if = "Option::is_none")]
    pub app_command_line: Option<String>,
    #[serde(rename = "managedPipelineMode", default, skip_serializing_if = "Option::is_none")]
    pub managed_pipeline_mode: Option<site_config::ManagedPipelineMode>,
    #[serde(rename = "virtualApplications", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_applications: Vec<VirtualApplication>,
    #[serde(rename = "loadBalancing", default, skip_serializing_if = "Option::is_none")]
    pub load_balancing: Option<site_config::LoadBalancing>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub experiments: Option<Experiments>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limits: Option<SiteLimits>,
    #[serde(rename = "autoHealEnabled", default, skip_serializing_if = "Option::is_none")]
    pub auto_heal_enabled: Option<bool>,
    #[serde(rename = "autoHealRules", default, skip_serializing_if = "Option::is_none")]
    pub auto_heal_rules: Option<AutoHealRules>,
    #[serde(rename = "tracingOptions", default, skip_serializing_if = "Option::is_none")]
    pub tracing_options: Option<String>,
    #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cors: Option<CorsSettings>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub push: Option<PushSettings>,
    #[serde(rename = "apiDefinition", default, skip_serializing_if = "Option::is_none")]
    pub api_definition: Option<ApiDefinitionInfo>,
    #[serde(rename = "autoSwapSlotName", default, skip_serializing_if = "Option::is_none")]
    pub auto_swap_slot_name: Option<String>,
    #[serde(rename = "localMySqlEnabled", default, skip_serializing_if = "Option::is_none")]
    pub local_my_sql_enabled: Option<bool>,
    #[serde(rename = "managedServiceIdentityId", default, skip_serializing_if = "Option::is_none")]
    pub managed_service_identity_id: Option<i32>,
    #[serde(rename = "xManagedServiceIdentityId", default, skip_serializing_if = "Option::is_none")]
    pub x_managed_service_identity_id: Option<i32>,
    #[serde(rename = "ipSecurityRestrictions", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_security_restrictions: Vec<IpSecurityRestriction>,
    #[serde(rename = "scmIpSecurityRestrictions", default, skip_serializing_if = "Vec::is_empty")]
    pub scm_ip_security_restrictions: Vec<IpSecurityRestriction>,
    #[serde(rename = "scmIpSecurityRestrictionsUseMain", default, skip_serializing_if = "Option::is_none")]
    pub scm_ip_security_restrictions_use_main: Option<bool>,
    #[serde(rename = "http20Enabled", default, skip_serializing_if = "Option::is_none")]
    pub http20_enabled: Option<bool>,
    #[serde(rename = "minTlsVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_tls_version: Option<site_config::MinTlsVersion>,
    #[serde(rename = "ftpsState", default, skip_serializing_if = "Option::is_none")]
    pub ftps_state: Option<site_config::FtpsState>,
    #[serde(rename = "reservedInstanceCount", default, skip_serializing_if = "Option::is_none")]
    pub reserved_instance_count: Option<i32>,
}
impl SiteConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScmType {
        None,
        Dropbox,
        Tfs,
        LocalGit,
        GitHub,
        CodePlexGit,
        CodePlexHg,
        BitbucketGit,
        BitbucketHg,
        ExternalGit,
        ExternalHg,
        OneDrive,
        #[serde(rename = "VSO")]
        Vso,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ManagedPipelineMode {
        Integrated,
        Classic,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadBalancing {
        WeightedRoundRobin,
        LeastRequests,
        LeastResponseTime,
        WeightedTotalTraffic,
        RequestHash,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MinTlsVersion {
        #[serde(rename = "1.0")]
        N1_0,
        #[serde(rename = "1.1")]
        N1_1,
        #[serde(rename = "1.2")]
        N1_2,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FtpsState {
        AllAllowed,
        FtpsOnly,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteConfigResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SiteConfig>,
}
impl SiteConfigResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteConfigResourceCollection {
    pub value: Vec<SiteConfigResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SiteConfigResourceCollection {
    pub fn new(value: Vec<SiteConfigResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteConfigurationSnapshotInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_configuration_snapshot_info::Properties>,
}
impl SiteConfigurationSnapshotInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_configuration_snapshot_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub time: Option<String>,
        #[serde(rename = "snapshotId", default, skip_serializing_if = "Option::is_none")]
        pub snapshot_id: Option<i32>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteConfigurationSnapshotInfoCollection {
    pub value: Vec<SiteConfigurationSnapshotInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SiteConfigurationSnapshotInfoCollection {
    pub fn new(value: Vec<SiteConfigurationSnapshotInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteExtensionInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_extension_info::Properties>,
}
impl SiteExtensionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_extension_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub extension_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub title: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub extension_type: Option<properties::ExtensionType>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub summary: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub version: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub extension_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub project_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub icon_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub license_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub feed_url: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub authors: Vec<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub installer_command_line_params: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub published_date_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub download_count: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub local_is_latest_version: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub local_path: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub installed_date_time: Option<String>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub comment: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ExtensionType {
            Gallery,
            WebRoot,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteExtensionInfoCollection {
    pub value: Vec<SiteExtensionInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SiteExtensionInfoCollection {
    pub fn new(value: Vec<SiteExtensionInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteInstance {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_instance::Properties>,
}
impl SiteInstance {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_instance {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "siteInstanceName", default, skip_serializing_if = "Option::is_none")]
        pub site_instance_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteLimits {
    #[serde(rename = "maxPercentageCpu", default, skip_serializing_if = "Option::is_none")]
    pub max_percentage_cpu: Option<f64>,
    #[serde(rename = "maxMemoryInMb", default, skip_serializing_if = "Option::is_none")]
    pub max_memory_in_mb: Option<i64>,
    #[serde(rename = "maxDiskSizeInMb", default, skip_serializing_if = "Option::is_none")]
    pub max_disk_size_in_mb: Option<i64>,
}
impl SiteLimits {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteLogsConfig {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_logs_config::Properties>,
}
impl SiteLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_logs_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "applicationLogs", default, skip_serializing_if = "Option::is_none")]
        pub application_logs: Option<ApplicationLogsConfig>,
        #[serde(rename = "httpLogs", default, skip_serializing_if = "Option::is_none")]
        pub http_logs: Option<HttpLogsConfig>,
        #[serde(rename = "failedRequestsTracing", default, skip_serializing_if = "Option::is_none")]
        pub failed_requests_tracing: Option<EnabledConfig>,
        #[serde(rename = "detailedErrorMessages", default, skip_serializing_if = "Option::is_none")]
        pub detailed_error_messages: Option<EnabledConfig>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteMachineKey {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub validation: Option<String>,
    #[serde(rename = "validationKey", default, skip_serializing_if = "Option::is_none")]
    pub validation_key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub decryption: Option<String>,
    #[serde(rename = "decryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub decryption_key: Option<String>,
}
impl SiteMachineKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SitePatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_patch_resource::Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
}
impl SitePatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_patch_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "repositorySiteName", default, skip_serializing_if = "Option::is_none")]
        pub repository_site_name: Option<String>,
        #[serde(rename = "usageState", default, skip_serializing_if = "Option::is_none")]
        pub usage_state: Option<properties::UsageState>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "enabledHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub enabled_host_names: Vec<String>,
        #[serde(rename = "availabilityState", default, skip_serializing_if = "Option::is_none")]
        pub availability_state: Option<properties::AvailabilityState>,
        #[serde(rename = "hostNameSslStates", default, skip_serializing_if = "Vec::is_empty")]
        pub host_name_ssl_states: Vec<HostNameSslState>,
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reserved: Option<bool>,
        #[serde(rename = "isXenon", default, skip_serializing_if = "Option::is_none")]
        pub is_xenon: Option<bool>,
        #[serde(rename = "hyperV", default, skip_serializing_if = "Option::is_none")]
        pub hyper_v: Option<bool>,
        #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
        pub last_modified_time_utc: Option<String>,
        #[serde(rename = "siteConfig", default, skip_serializing_if = "Option::is_none")]
        pub site_config: Option<SiteConfig>,
        #[serde(rename = "trafficManagerHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub traffic_manager_host_names: Vec<String>,
        #[serde(rename = "scmSiteAlsoStopped", default, skip_serializing_if = "Option::is_none")]
        pub scm_site_also_stopped: Option<bool>,
        #[serde(rename = "targetSwapSlot", default, skip_serializing_if = "Option::is_none")]
        pub target_swap_slot: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "clientAffinityEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_affinity_enabled: Option<bool>,
        #[serde(rename = "clientCertEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_cert_enabled: Option<bool>,
        #[serde(rename = "clientCertExclusionPaths", default, skip_serializing_if = "Option::is_none")]
        pub client_cert_exclusion_paths: Option<String>,
        #[serde(rename = "hostNamesDisabled", default, skip_serializing_if = "Option::is_none")]
        pub host_names_disabled: Option<bool>,
        #[serde(rename = "outboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub outbound_ip_addresses: Option<String>,
        #[serde(rename = "possibleOutboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub possible_outbound_ip_addresses: Option<String>,
        #[serde(rename = "containerSize", default, skip_serializing_if = "Option::is_none")]
        pub container_size: Option<i32>,
        #[serde(rename = "dailyMemoryTimeQuota", default, skip_serializing_if = "Option::is_none")]
        pub daily_memory_time_quota: Option<i32>,
        #[serde(rename = "suspendedTill", default, skip_serializing_if = "Option::is_none")]
        pub suspended_till: Option<String>,
        #[serde(rename = "maxNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub max_number_of_workers: Option<i32>,
        #[serde(rename = "cloningInfo", default, skip_serializing_if = "Option::is_none")]
        pub cloning_info: Option<CloningInfo>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(rename = "isDefaultContainer", default, skip_serializing_if = "Option::is_none")]
        pub is_default_container: Option<bool>,
        #[serde(rename = "defaultHostName", default, skip_serializing_if = "Option::is_none")]
        pub default_host_name: Option<String>,
        #[serde(rename = "slotSwapStatus", default, skip_serializing_if = "Option::is_none")]
        pub slot_swap_status: Option<SlotSwapStatus>,
        #[serde(rename = "httpsOnly", default, skip_serializing_if = "Option::is_none")]
        pub https_only: Option<bool>,
        #[serde(rename = "redundancyMode", default, skip_serializing_if = "Option::is_none")]
        pub redundancy_mode: Option<properties::RedundancyMode>,
        #[serde(rename = "inProgressOperationId", default, skip_serializing_if = "Option::is_none")]
        pub in_progress_operation_id: Option<String>,
        #[serde(rename = "geoDistributions", default, skip_serializing_if = "Vec::is_empty")]
        pub geo_distributions: Vec<GeoDistribution>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum UsageState {
            Normal,
            Exceeded,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AvailabilityState {
            Normal,
            Limited,
            DisasterRecoveryMode,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RedundancyMode {
            None,
            Manual,
            Failover,
            ActiveActive,
            GeoRedundant,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SitePhpErrorLogFlag {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_php_error_log_flag::Properties>,
}
impl SitePhpErrorLogFlag {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_php_error_log_flag {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "localLogErrors", default, skip_serializing_if = "Option::is_none")]
        pub local_log_errors: Option<String>,
        #[serde(rename = "masterLogErrors", default, skip_serializing_if = "Option::is_none")]
        pub master_log_errors: Option<String>,
        #[serde(rename = "localLogErrorsMaxLength", default, skip_serializing_if = "Option::is_none")]
        pub local_log_errors_max_length: Option<String>,
        #[serde(rename = "masterLogErrorsMaxLength", default, skip_serializing_if = "Option::is_none")]
        pub master_log_errors_max_length: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteSeal {
    pub html: String,
}
impl SiteSeal {
    pub fn new(html: String) -> Self {
        Self { html }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteSealRequest {
    #[serde(rename = "lightTheme", default, skip_serializing_if = "Option::is_none")]
    pub light_theme: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub locale: Option<String>,
}
impl SiteSealRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteSourceControl {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_source_control::Properties>,
}
impl SiteSourceControl {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_source_control {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "repoUrl", default, skip_serializing_if = "Option::is_none")]
        pub repo_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub branch: Option<String>,
        #[serde(rename = "isManualIntegration", default, skip_serializing_if = "Option::is_none")]
        pub is_manual_integration: Option<bool>,
        #[serde(rename = "deploymentRollbackEnabled", default, skip_serializing_if = "Option::is_none")]
        pub deployment_rollback_enabled: Option<bool>,
        #[serde(rename = "isMercurial", default, skip_serializing_if = "Option::is_none")]
        pub is_mercurial: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<i32>,
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<String>,
}
impl SkuCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
    #[serde(rename = "skuCapacity", default, skip_serializing_if = "Option::is_none")]
    pub sku_capacity: Option<SkuCapacity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
}
impl SkuDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuInfo {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<SkuDescription>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<SkuCapacity>,
}
impl SkuInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SkuInfoCollection {
    pub value: Vec<SkuInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SkuInfoCollection {
    pub fn new(value: Vec<SkuInfo>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuInfos {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub skus: Vec<GlobalCsmSkuDescription>,
}
impl SkuInfos {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotConfigNames {
    #[serde(rename = "connectionStringNames", default, skip_serializing_if = "Vec::is_empty")]
    pub connection_string_names: Vec<String>,
    #[serde(rename = "appSettingNames", default, skip_serializing_if = "Vec::is_empty")]
    pub app_setting_names: Vec<String>,
    #[serde(rename = "azureStorageConfigNames", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_storage_config_names: Vec<String>,
}
impl SlotConfigNames {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotConfigNamesResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SlotConfigNames>,
}
impl SlotConfigNamesResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotDifference {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<slot_difference::Properties>,
}
impl SlotDifference {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod slot_difference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub level: Option<String>,
        #[serde(rename = "settingType", default, skip_serializing_if = "Option::is_none")]
        pub setting_type: Option<String>,
        #[serde(rename = "diffRule", default, skip_serializing_if = "Option::is_none")]
        pub diff_rule: Option<String>,
        #[serde(rename = "settingName", default, skip_serializing_if = "Option::is_none")]
        pub setting_name: Option<String>,
        #[serde(rename = "valueInCurrentSlot", default, skip_serializing_if = "Option::is_none")]
        pub value_in_current_slot: Option<String>,
        #[serde(rename = "valueInTargetSlot", default, skip_serializing_if = "Option::is_none")]
        pub value_in_target_slot: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SlotDifferenceCollection {
    pub value: Vec<SlotDifference>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SlotDifferenceCollection {
    pub fn new(value: Vec<SlotDifference>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotSwapStatus {
    #[serde(rename = "timestampUtc", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_utc: Option<String>,
    #[serde(rename = "sourceSlotName", default, skip_serializing_if = "Option::is_none")]
    pub source_slot_name: Option<String>,
    #[serde(rename = "destinationSlotName", default, skip_serializing_if = "Option::is_none")]
    pub destination_slot_name: Option<String>,
}
impl SlotSwapStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlowRequestsBasedTrigger {
    #[serde(rename = "timeTaken", default, skip_serializing_if = "Option::is_none")]
    pub time_taken: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl SlowRequestsBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Snapshot {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<snapshot::Properties>,
}
impl Snapshot {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod snapshot {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub time: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnapshotCollection {
    pub value: Vec<Snapshot>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SnapshotCollection {
    pub fn new(value: Vec<Snapshot>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotRecoverySource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SnapshotRecoverySource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotRestoreRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<snapshot_restore_request::Properties>,
}
impl SnapshotRestoreRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod snapshot_restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "snapshotTime", default, skip_serializing_if = "Option::is_none")]
        pub snapshot_time: Option<String>,
        #[serde(rename = "recoverySource", default, skip_serializing_if = "Option::is_none")]
        pub recovery_source: Option<SnapshotRecoverySource>,
        pub overwrite: bool,
        #[serde(rename = "recoverConfiguration", default, skip_serializing_if = "Option::is_none")]
        pub recover_configuration: Option<bool>,
        #[serde(rename = "ignoreConflictingHostNames", default, skip_serializing_if = "Option::is_none")]
        pub ignore_conflicting_host_names: Option<bool>,
        #[serde(rename = "useDRSecondary", default, skip_serializing_if = "Option::is_none")]
        pub use_dr_secondary: Option<bool>,
    }
    impl Properties {
        pub fn new(overwrite: bool) -> Self {
            Self {
                snapshot_time: None,
                recovery_source: None,
                overwrite,
                recover_configuration: None,
                ignore_conflicting_host_names: None,
                use_dr_secondary: None,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Solution {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<f64>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub order: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<solution::Type>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub data: Vec<Vec<NameValuePair>>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<Vec<NameValuePair>>,
}
impl Solution {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod solution {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        QuickSolution,
        DeepInvestigation,
        BestPractices,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceControl {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<source_control::Properties>,
}
impl SourceControl {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod source_control {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub token: Option<String>,
        #[serde(rename = "tokenSecret", default, skip_serializing_if = "Option::is_none")]
        pub token_secret: Option<String>,
        #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
        pub refresh_token: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceControlCollection {
    pub value: Vec<SourceControl>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SourceControlCollection {
    pub fn new(value: Vec<SourceControl>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StackMajorVersion {
    #[serde(rename = "displayVersion", default, skip_serializing_if = "Option::is_none")]
    pub display_version: Option<String>,
    #[serde(rename = "runtimeVersion", default, skip_serializing_if = "Option::is_none")]
    pub runtime_version: Option<String>,
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[serde(rename = "minorVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub minor_versions: Vec<StackMinorVersion>,
    #[serde(rename = "applicationInsights", default, skip_serializing_if = "Option::is_none")]
    pub application_insights: Option<bool>,
}
impl StackMajorVersion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StackMinorVersion {
    #[serde(rename = "displayVersion", default, skip_serializing_if = "Option::is_none")]
    pub display_version: Option<String>,
    #[serde(rename = "runtimeVersion", default, skip_serializing_if = "Option::is_none")]
    pub runtime_version: Option<String>,
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[serde(rename = "isRemoteDebuggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_remote_debugging_enabled: Option<bool>,
}
impl StackMinorVersion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StampCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "availableCapacity", default, skip_serializing_if = "Option::is_none")]
    pub available_capacity: Option<i64>,
    #[serde(rename = "totalCapacity", default, skip_serializing_if = "Option::is_none")]
    pub total_capacity: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "computeMode", default, skip_serializing_if = "Option::is_none")]
    pub compute_mode: Option<stamp_capacity::ComputeMode>,
    #[serde(rename = "workerSize", default, skip_serializing_if = "Option::is_none")]
    pub worker_size: Option<stamp_capacity::WorkerSize>,
    #[serde(rename = "workerSizeId", default, skip_serializing_if = "Option::is_none")]
    pub worker_size_id: Option<i32>,
    #[serde(rename = "excludeFromCapacityAllocation", default, skip_serializing_if = "Option::is_none")]
    pub exclude_from_capacity_allocation: Option<bool>,
    #[serde(rename = "isApplicableForAllComputeModes", default, skip_serializing_if = "Option::is_none")]
    pub is_applicable_for_all_compute_modes: Option<bool>,
    #[serde(rename = "siteMode", default, skip_serializing_if = "Option::is_none")]
    pub site_mode: Option<String>,
    #[serde(rename = "isLinux", default, skip_serializing_if = "Option::is_none")]
    pub is_linux: Option<bool>,
}
impl StampCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod stamp_capacity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComputeMode {
        Shared,
        Dedicated,
        Dynamic,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkerSize {
        Small,
        Medium,
        Large,
        D1,
        D2,
        D3,
        Default,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StampCapacityCollection {
    pub value: Vec<StampCapacity>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl StampCapacityCollection {
    pub fn new(value: Vec<StampCapacity>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StatusCodesBasedTrigger {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<i32>,
    #[serde(rename = "subStatus", default, skip_serializing_if = "Option::is_none")]
    pub sub_status: Option<i32>,
    #[serde(rename = "win32Status", default, skip_serializing_if = "Option::is_none")]
    pub win32_status: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl StatusCodesBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageMigrationOptions {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<storage_migration_options::Properties>,
}
impl StorageMigrationOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod storage_migration_options {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "azurefilesConnectionString")]
        pub azurefiles_connection_string: String,
        #[serde(rename = "azurefilesShare")]
        pub azurefiles_share: String,
        #[serde(rename = "switchSiteAfterMigration", default, skip_serializing_if = "Option::is_none")]
        pub switch_site_after_migration: Option<bool>,
        #[serde(rename = "blockWriteAccessToSite", default, skip_serializing_if = "Option::is_none")]
        pub block_write_access_to_site: Option<bool>,
    }
    impl Properties {
        pub fn new(azurefiles_connection_string: String, azurefiles_share: String) -> Self {
            Self {
                azurefiles_connection_string,
                azurefiles_share,
                switch_site_after_migration: None,
                block_write_access_to_site: None,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageMigrationResponse {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<storage_migration_response::Properties>,
}
impl StorageMigrationResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod storage_migration_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
        pub operation_id: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StringDictionary {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl StringDictionary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwiftVirtualNetwork {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<swift_virtual_network::Properties>,
}
impl SwiftVirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod swift_virtual_network {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "subnetResourceId", default, skip_serializing_if = "Option::is_none")]
        pub subnet_resource_id: Option<String>,
        #[serde(rename = "swiftSupported", default, skip_serializing_if = "Option::is_none")]
        pub swift_supported: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TldLegalAgreement {
    #[serde(rename = "agreementKey")]
    pub agreement_key: String,
    pub title: String,
    pub content: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl TldLegalAgreement {
    pub fn new(agreement_key: String, title: String, content: String) -> Self {
        Self {
            agreement_key,
            title,
            content,
            url: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TldLegalAgreementCollection {
    pub value: Vec<TldLegalAgreement>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TldLegalAgreementCollection {
    pub fn new(value: Vec<TldLegalAgreement>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopLevelDomain {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<top_level_domain::Properties>,
}
impl TopLevelDomain {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod top_level_domain {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub privacy: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopLevelDomainAgreementOption {
    #[serde(rename = "includePrivacy", default, skip_serializing_if = "Option::is_none")]
    pub include_privacy: Option<bool>,
    #[serde(rename = "forTransfer", default, skip_serializing_if = "Option::is_none")]
    pub for_transfer: Option<bool>,
}
impl TopLevelDomainAgreementOption {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TopLevelDomainCollection {
    pub value: Vec<TopLevelDomain>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TopLevelDomainCollection {
    pub fn new(value: Vec<TopLevelDomain>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggeredJobHistory {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<triggered_job_history::Properties>,
}
impl TriggeredJobHistory {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod triggered_job_history {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub runs: Vec<TriggeredJobRun>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggeredJobHistoryCollection {
    pub value: Vec<TriggeredJobHistory>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TriggeredJobHistoryCollection {
    pub fn new(value: Vec<TriggeredJobHistory>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggeredJobRun {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<triggered_job_run::Properties>,
}
impl TriggeredJobRun {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod triggered_job_run {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub web_job_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub web_job_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub duration: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub output_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub error_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub job_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub trigger: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Success,
            Failed,
            Error,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggeredWebJob {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<triggered_web_job::Properties>,
}
impl TriggeredWebJob {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod triggered_web_job {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub latest_run: Option<TriggeredJobRun>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub history_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub scheduler_logs_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub run_command: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub extra_info_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub web_job_type: Option<properties::WebJobType>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub error: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub using_sdk: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub settings: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum WebJobType {
            Continuous,
            Triggered,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggeredWebJobCollection {
    pub value: Vec<TriggeredWebJob>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TriggeredWebJobCollection {
    pub fn new(value: Vec<TriggeredWebJob>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Usage {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<usage::Properties>,
}
impl Usage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
        pub resource_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub unit: Option<String>,
        #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
        pub current_value: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub limit: Option<i64>,
        #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
        pub next_reset_time: Option<String>,
        #[serde(rename = "computeMode", default, skip_serializing_if = "Option::is_none")]
        pub compute_mode: Option<properties::ComputeMode>,
        #[serde(rename = "siteMode", default, skip_serializing_if = "Option::is_none")]
        pub site_mode: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ComputeMode {
            Shared,
            Dedicated,
            Dynamic,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UsageCollection {
    pub value: Vec<Usage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UsageCollection {
    pub fn new(value: Vec<Usage>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct User {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<user::Properties>,
}
impl User {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod user {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "publishingUserName")]
        pub publishing_user_name: String,
        #[serde(rename = "publishingPassword", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password: Option<String>,
        #[serde(rename = "publishingPasswordHash", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password_hash: Option<String>,
        #[serde(rename = "publishingPasswordHashSalt", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password_hash_salt: Option<String>,
        #[serde(rename = "scmUri", default, skip_serializing_if = "Option::is_none")]
        pub scm_uri: Option<String>,
    }
    impl Properties {
        pub fn new(publishing_user_name: String) -> Self {
            Self {
                publishing_user_name,
                publishing_password: None,
                publishing_password_hash: None,
                publishing_password_hash_salt: None,
                scm_uri: None,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateContainerSettingsRequest {
    #[serde(rename = "baseUrl", default, skip_serializing_if = "Option::is_none")]
    pub base_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub platform: Option<String>,
}
impl ValidateContainerSettingsRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateProperties {
    #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
    pub server_farm_id: Option<String>,
    #[serde(rename = "skuName", default, skip_serializing_if = "Option::is_none")]
    pub sku_name: Option<String>,
    #[serde(rename = "needLinuxWorkers", default, skip_serializing_if = "Option::is_none")]
    pub need_linux_workers: Option<bool>,
    #[serde(rename = "isSpot", default, skip_serializing_if = "Option::is_none")]
    pub is_spot: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
    #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
    pub hosting_environment: Option<String>,
    #[serde(rename = "isXenon", default, skip_serializing_if = "Option::is_none")]
    pub is_xenon: Option<bool>,
}
impl ValidateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidateRequest {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: validate_request::Type,
    pub location: String,
    pub properties: ValidateProperties,
}
impl ValidateRequest {
    pub fn new(name: String, type_: validate_request::Type, location: String, properties: ValidateProperties) -> Self {
        Self {
            name,
            type_,
            location,
            properties,
        }
    }
}
pub mod validate_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        ServerFarm,
        Site,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ValidateResponseError>,
}
impl ValidateResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateResponseError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ValidateResponseError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplication {
    #[serde(rename = "virtualPath", default, skip_serializing_if = "Option::is_none")]
    pub virtual_path: Option<String>,
    #[serde(rename = "physicalPath", default, skip_serializing_if = "Option::is_none")]
    pub physical_path: Option<String>,
    #[serde(rename = "preloadEnabled", default, skip_serializing_if = "Option::is_none")]
    pub preload_enabled: Option<bool>,
    #[serde(rename = "virtualDirectories", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_directories: Vec<VirtualDirectory>,
}
impl VirtualApplication {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualDirectory {
    #[serde(rename = "virtualPath", default, skip_serializing_if = "Option::is_none")]
    pub virtual_path: Option<String>,
    #[serde(rename = "physicalPath", default, skip_serializing_if = "Option::is_none")]
    pub physical_path: Option<String>,
}
impl VirtualDirectory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualIpMapping {
    #[serde(rename = "virtualIP", default, skip_serializing_if = "Option::is_none")]
    pub virtual_ip: Option<String>,
    #[serde(rename = "internalHttpPort", default, skip_serializing_if = "Option::is_none")]
    pub internal_http_port: Option<i32>,
    #[serde(rename = "internalHttpsPort", default, skip_serializing_if = "Option::is_none")]
    pub internal_https_port: Option<i32>,
    #[serde(rename = "inUse", default, skip_serializing_if = "Option::is_none")]
    pub in_use: Option<bool>,
}
impl VirtualIpMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkProfile {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<String>,
}
impl VirtualNetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetGateway {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_gateway::Properties>,
}
impl VnetGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_gateway {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_name: Option<String>,
        #[serde(rename = "vpnPackageUri")]
        pub vpn_package_uri: String,
    }
    impl Properties {
        pub fn new(vpn_package_uri: String) -> Self {
            Self {
                vnet_name: None,
                vpn_package_uri,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_info::Properties>,
}
impl VnetInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "vnetResourceId", default, skip_serializing_if = "Option::is_none")]
        pub vnet_resource_id: Option<String>,
        #[serde(rename = "certThumbprint", default, skip_serializing_if = "Option::is_none")]
        pub cert_thumbprint: Option<String>,
        #[serde(rename = "certBlob", default, skip_serializing_if = "Option::is_none")]
        pub cert_blob: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub routes: Vec<VnetRoute>,
        #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
        pub resync_required: Option<bool>,
        #[serde(rename = "dnsServers", default, skip_serializing_if = "Option::is_none")]
        pub dns_servers: Option<String>,
        #[serde(rename = "isSwift", default, skip_serializing_if = "Option::is_none")]
        pub is_swift: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetParameters {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_parameters::Properties>,
}
impl VnetParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "vnetResourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub vnet_resource_group: Option<String>,
        #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_name: Option<String>,
        #[serde(rename = "vnetSubnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_subnet_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetRoute {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_route::Properties>,
}
impl VnetRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_route {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "startAddress", default, skip_serializing_if = "Option::is_none")]
        pub start_address: Option<String>,
        #[serde(rename = "endAddress", default, skip_serializing_if = "Option::is_none")]
        pub end_address: Option<String>,
        #[serde(rename = "routeType", default, skip_serializing_if = "Option::is_none")]
        pub route_type: Option<properties::RouteType>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RouteType {
            #[serde(rename = "DEFAULT")]
            Default,
            #[serde(rename = "INHERITED")]
            Inherited,
            #[serde(rename = "STATIC")]
            Static,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetValidationFailureDetails {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_validation_failure_details::Properties>,
}
impl VnetValidationFailureDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_validation_failure_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub failed: Option<bool>,
        #[serde(rename = "failedTests", default, skip_serializing_if = "Vec::is_empty")]
        pub failed_tests: Vec<VnetValidationTestFailure>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetValidationTestFailure {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_validation_test_failure::Properties>,
}
impl VnetValidationTestFailure {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_validation_test_failure {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "testName", default, skip_serializing_if = "Option::is_none")]
        pub test_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub details: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebAppCollection {
    pub value: Vec<Site>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebAppCollection {
    pub fn new(value: Vec<Site>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebAppInstanceCollection {
    pub value: Vec<SiteInstance>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebAppInstanceCollection {
    pub fn new(value: Vec<SiteInstance>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebJob {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<web_job::Properties>,
}
impl WebJob {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod web_job {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub run_command: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub extra_info_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub web_job_type: Option<properties::WebJobType>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub error: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub using_sdk: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub settings: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum WebJobType {
            Continuous,
            Triggered,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebJobCollection {
    pub value: Vec<WebJob>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebJobCollection {
    pub fn new(value: Vec<WebJob>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkerPool {
    #[serde(rename = "workerSizeId", default, skip_serializing_if = "Option::is_none")]
    pub worker_size_id: Option<i32>,
    #[serde(rename = "computeMode", default, skip_serializing_if = "Option::is_none")]
    pub compute_mode: Option<worker_pool::ComputeMode>,
    #[serde(rename = "workerSize", default, skip_serializing_if = "Option::is_none")]
    pub worker_size: Option<String>,
    #[serde(rename = "workerCount", default, skip_serializing_if = "Option::is_none")]
    pub worker_count: Option<i32>,
    #[serde(rename = "instanceNames", default, skip_serializing_if = "Vec::is_empty")]
    pub instance_names: Vec<String>,
}
impl WorkerPool {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod worker_pool {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComputeMode {
        Shared,
        Dedicated,
        Dynamic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkerPoolCollection {
    pub value: Vec<WorkerPoolResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkerPoolCollection {
    pub fn new(value: Vec<WorkerPoolResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkerPoolResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkerPool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<SkuDescription>,
}
impl WorkerPoolResource {
    pub fn new() -> Self {
        Self::default()
    }
}
