#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AbnormalTimePeriod {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub events: Vec<DetectorAbnormalTimePeriod>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub solutions: Vec<Solution>,
}
impl AbnormalTimePeriod {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AnalysisData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[serde(rename = "detectorDefinition", default, skip_serializing_if = "Option::is_none")]
    pub detector_definition: Option<DetectorDefinition>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metrics: Vec<DiagnosticMetricSet>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub data: Vec<Vec<NameValuePair>>,
    #[serde(rename = "detectorMetaData", default, skip_serializing_if = "Option::is_none")]
    pub detector_meta_data: Option<ResponseMetaData>,
}
impl AnalysisData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AnalysisDefinition {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<analysis_definition::Properties>,
}
impl AnalysisDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod analysis_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiDefinitionInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl ApiDefinitionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServiceEnvironment {
    pub name: String,
    pub location: String,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<app_service_environment::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<app_service_environment::Status>,
    #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_name: Option<String>,
    #[serde(rename = "vnetResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_resource_group_name: Option<String>,
    #[serde(rename = "vnetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_subnet_name: Option<String>,
    #[serde(rename = "virtualNetwork")]
    pub virtual_network: VirtualNetworkProfile,
    #[serde(rename = "internalLoadBalancingMode", default, skip_serializing_if = "Option::is_none")]
    pub internal_load_balancing_mode: Option<app_service_environment::InternalLoadBalancingMode>,
    #[serde(rename = "multiSize", default, skip_serializing_if = "Option::is_none")]
    pub multi_size: Option<String>,
    #[serde(rename = "multiRoleCount", default, skip_serializing_if = "Option::is_none")]
    pub multi_role_count: Option<i32>,
    #[serde(rename = "workerPools")]
    pub worker_pools: Vec<WorkerPool>,
    #[serde(rename = "ipsslAddressCount", default, skip_serializing_if = "Option::is_none")]
    pub ipssl_address_count: Option<i32>,
    #[serde(rename = "databaseEdition", default, skip_serializing_if = "Option::is_none")]
    pub database_edition: Option<String>,
    #[serde(rename = "databaseServiceObjective", default, skip_serializing_if = "Option::is_none")]
    pub database_service_objective: Option<String>,
    #[serde(rename = "upgradeDomains", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_domains: Option<i32>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "dnsSuffix", default, skip_serializing_if = "Option::is_none")]
    pub dns_suffix: Option<String>,
    #[serde(rename = "lastAction", default, skip_serializing_if = "Option::is_none")]
    pub last_action: Option<String>,
    #[serde(rename = "lastActionResult", default, skip_serializing_if = "Option::is_none")]
    pub last_action_result: Option<String>,
    #[serde(rename = "allowedMultiSizes", default, skip_serializing_if = "Option::is_none")]
    pub allowed_multi_sizes: Option<String>,
    #[serde(rename = "allowedWorkerSizes", default, skip_serializing_if = "Option::is_none")]
    pub allowed_worker_sizes: Option<String>,
    #[serde(rename = "maximumNumberOfMachines", default, skip_serializing_if = "Option::is_none")]
    pub maximum_number_of_machines: Option<i32>,
    #[serde(rename = "vipMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub vip_mappings: Vec<VirtualIpMapping>,
    #[serde(rename = "environmentCapacities", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_capacities: Vec<StampCapacity>,
    #[serde(rename = "networkAccessControlList", default, skip_serializing_if = "Vec::is_empty")]
    pub network_access_control_list: Vec<NetworkAccessControlEntry>,
    #[serde(rename = "environmentIsHealthy", default, skip_serializing_if = "Option::is_none")]
    pub environment_is_healthy: Option<bool>,
    #[serde(rename = "environmentStatus", default, skip_serializing_if = "Option::is_none")]
    pub environment_status: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "frontEndScaleFactor", default, skip_serializing_if = "Option::is_none")]
    pub front_end_scale_factor: Option<i32>,
    #[serde(rename = "defaultFrontEndScaleFactor", default, skip_serializing_if = "Option::is_none")]
    pub default_front_end_scale_factor: Option<i32>,
    #[serde(rename = "apiManagementAccountId", default, skip_serializing_if = "Option::is_none")]
    pub api_management_account_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub suspended: Option<bool>,
    #[serde(rename = "dynamicCacheEnabled", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_cache_enabled: Option<bool>,
    #[serde(rename = "clusterSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub cluster_settings: Vec<NameValuePair>,
    #[serde(rename = "userWhitelistedIpRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub user_whitelisted_ip_ranges: Vec<String>,
}
impl AppServiceEnvironment {
    pub fn new(name: String, location: String, virtual_network: VirtualNetworkProfile, worker_pools: Vec<WorkerPool>) -> Self {
        Self {
            name,
            location,
            provisioning_state: None,
            status: None,
            vnet_name: None,
            vnet_resource_group_name: None,
            vnet_subnet_name: None,
            virtual_network,
            internal_load_balancing_mode: None,
            multi_size: None,
            multi_role_count: None,
            worker_pools,
            ipssl_address_count: None,
            database_edition: None,
            database_service_objective: None,
            upgrade_domains: None,
            subscription_id: None,
            dns_suffix: None,
            last_action: None,
            last_action_result: None,
            allowed_multi_sizes: None,
            allowed_worker_sizes: None,
            maximum_number_of_machines: None,
            vip_mappings: Vec::new(),
            environment_capacities: Vec::new(),
            network_access_control_list: Vec::new(),
            environment_is_healthy: None,
            environment_status: None,
            resource_group: None,
            front_end_scale_factor: None,
            default_front_end_scale_factor: None,
            api_management_account_id: None,
            suspended: None,
            dynamic_cache_enabled: None,
            cluster_settings: Vec::new(),
            user_whitelisted_ip_ranges: Vec::new(),
        }
    }
}
pub mod app_service_environment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Failed,
        Canceled,
        InProgress,
        Deleting,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Preparing,
        Ready,
        Scaling,
        Deleting,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InternalLoadBalancingMode {
        None,
        Web,
        Publishing,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServicePlan {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<app_service_plan::Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<SkuDescription>,
}
impl AppServicePlan {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            sku: None,
        }
    }
}
pub mod app_service_plan {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        pub name: String,
        #[serde(rename = "workerTierName", default, skip_serializing_if = "Option::is_none")]
        pub worker_tier_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subscription: Option<String>,
        #[serde(rename = "adminSiteName", default, skip_serializing_if = "Option::is_none")]
        pub admin_site_name: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "maximumNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub maximum_number_of_workers: Option<i32>,
        #[serde(rename = "geoRegion", default, skip_serializing_if = "Option::is_none")]
        pub geo_region: Option<String>,
        #[serde(rename = "perSiteScaling", default, skip_serializing_if = "Option::is_none")]
        pub per_site_scaling: Option<bool>,
        #[serde(rename = "numberOfSites", default, skip_serializing_if = "Option::is_none")]
        pub number_of_sites: Option<i32>,
        #[serde(rename = "isSpot", default, skip_serializing_if = "Option::is_none")]
        pub is_spot: Option<bool>,
        #[serde(rename = "spotExpirationTime", default, skip_serializing_if = "Option::is_none")]
        pub spot_expiration_time: Option<String>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reserved: Option<bool>,
        #[serde(rename = "targetWorkerCount", default, skip_serializing_if = "Option::is_none")]
        pub target_worker_count: Option<i32>,
        #[serde(rename = "targetWorkerSizeId", default, skip_serializing_if = "Option::is_none")]
        pub target_worker_size_id: Option<i32>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
    }
    impl Properties {
        pub fn new(name: String) -> Self {
            Self {
                name,
                worker_tier_name: None,
                status: None,
                subscription: None,
                admin_site_name: None,
                hosting_environment_profile: None,
                maximum_number_of_workers: None,
                geo_region: None,
                per_site_scaling: None,
                number_of_sites: None,
                is_spot: None,
                spot_expiration_time: None,
                resource_group: None,
                reserved: None,
                target_worker_count: None,
                target_worker_size_id: None,
                provisioning_state: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Ready,
            Pending,
            Creating,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppServicePlanCollection {
    pub value: Vec<AppServicePlan>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AppServicePlanCollection {
    pub fn new(value: Vec<AppServicePlan>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationStack {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dependency: Option<String>,
    #[serde(rename = "majorVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub major_versions: Vec<StackMajorVersion>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub frameworks: Vec<ApplicationStack>,
}
impl ApplicationStack {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationStackCollection {
    pub value: Vec<ApplicationStack>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationStackCollection {
    pub fn new(value: Vec<ApplicationStack>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealActions {
    #[serde(rename = "actionType", default, skip_serializing_if = "Option::is_none")]
    pub action_type: Option<auto_heal_actions::ActionType>,
    #[serde(rename = "customAction", default, skip_serializing_if = "Option::is_none")]
    pub custom_action: Option<AutoHealCustomAction>,
    #[serde(rename = "minProcessExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub min_process_execution_time: Option<String>,
}
impl AutoHealActions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod auto_heal_actions {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActionType {
        Recycle,
        LogEvent,
        CustomAction,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealCustomAction {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exe: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<String>,
}
impl AutoHealCustomAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealRules {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub triggers: Option<AutoHealTriggers>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub actions: Option<AutoHealActions>,
}
impl AutoHealRules {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealTriggers {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub requests: Option<RequestsBasedTrigger>,
    #[serde(rename = "privateBytesInKB", default, skip_serializing_if = "Option::is_none")]
    pub private_bytes_in_kb: Option<i32>,
    #[serde(rename = "statusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub status_codes: Vec<StatusCodesBasedTrigger>,
    #[serde(rename = "slowRequests", default, skip_serializing_if = "Option::is_none")]
    pub slow_requests: Option<SlowRequestsBasedTrigger>,
}
impl AutoHealTriggers {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BillingMeter {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<billing_meter::Properties>,
}
impl BillingMeter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod billing_meter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "meterId", default, skip_serializing_if = "Option::is_none")]
        pub meter_id: Option<String>,
        #[serde(rename = "billingLocation", default, skip_serializing_if = "Option::is_none")]
        pub billing_location: Option<String>,
        #[serde(rename = "shortName", default, skip_serializing_if = "Option::is_none")]
        pub short_name: Option<String>,
        #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
        pub friendly_name: Option<String>,
        #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
        pub resource_type: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BillingMeterCollection {
    pub value: Vec<BillingMeter>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BillingMeterCollection {
    pub fn new(value: Vec<BillingMeter>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Capability {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
}
impl Capability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Certificate {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate::Properties>,
}
impl Certificate {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod certificate {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
        pub friendly_name: Option<String>,
        #[serde(rename = "subjectName", default, skip_serializing_if = "Option::is_none")]
        pub subject_name: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "pfxBlob", default, skip_serializing_if = "Option::is_none")]
        pub pfx_blob: Option<String>,
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[serde(rename = "selfLink", default, skip_serializing_if = "Option::is_none")]
        pub self_link: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub issuer: Option<String>,
        #[serde(rename = "issueDate", default, skip_serializing_if = "Option::is_none")]
        pub issue_date: Option<String>,
        #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
        pub expiration_date: Option<String>,
        pub password: String,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub valid: Option<bool>,
        #[serde(rename = "cerBlob", default, skip_serializing_if = "Option::is_none")]
        pub cer_blob: Option<String>,
        #[serde(rename = "publicKeyHash", default, skip_serializing_if = "Option::is_none")]
        pub public_key_hash: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_id: Option<String>,
        #[serde(rename = "keyVaultSecretName", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_secret_name: Option<String>,
        #[serde(rename = "keyVaultSecretStatus", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_secret_status: Option<properties::KeyVaultSecretStatus>,
        #[serde(rename = "geoRegion", default, skip_serializing_if = "Option::is_none")]
        pub geo_region: Option<String>,
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
    }
    impl Properties {
        pub fn new(password: String) -> Self {
            Self {
                friendly_name: None,
                subject_name: None,
                host_names: Vec::new(),
                pfx_blob: None,
                site_name: None,
                self_link: None,
                issuer: None,
                issue_date: None,
                expiration_date: None,
                password,
                thumbprint: None,
                valid: None,
                cer_blob: None,
                public_key_hash: None,
                hosting_environment_profile: None,
                key_vault_id: None,
                key_vault_secret_name: None,
                key_vault_secret_status: None,
                geo_region: None,
                server_farm_id: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum KeyVaultSecretStatus {
            Initialized,
            WaitingOnCertificateOrder,
            Succeeded,
            CertificateOrderFailed,
            OperationNotPermittedOnKeyVault,
            AzureServiceUnauthorizedToAccessKeyVault,
            KeyVaultDoesNotExist,
            KeyVaultSecretDoesNotExist,
            UnknownError,
            ExternalPrivateKey,
            Unknown,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateCollection {
    pub value: Vec<Certificate>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CertificateCollection {
    pub fn new(value: Vec<Certificate>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificatePatchResource {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate_patch_resource::Properties>,
}
impl CertificatePatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod certificate_patch_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
        pub friendly_name: Option<String>,
        #[serde(rename = "subjectName", default, skip_serializing_if = "Option::is_none")]
        pub subject_name: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "pfxBlob", default, skip_serializing_if = "Option::is_none")]
        pub pfx_blob: Option<String>,
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[serde(rename = "selfLink", default, skip_serializing_if = "Option::is_none")]
        pub self_link: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub issuer: Option<String>,
        #[serde(rename = "issueDate", default, skip_serializing_if = "Option::is_none")]
        pub issue_date: Option<String>,
        #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
        pub expiration_date: Option<String>,
        pub password: String,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub valid: Option<bool>,
        #[serde(rename = "cerBlob", default, skip_serializing_if = "Option::is_none")]
        pub cer_blob: Option<String>,
        #[serde(rename = "publicKeyHash", default, skip_serializing_if = "Option::is_none")]
        pub public_key_hash: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_id: Option<String>,
        #[serde(rename = "keyVaultSecretName", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_secret_name: Option<String>,
        #[serde(rename = "keyVaultSecretStatus", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_secret_status: Option<properties::KeyVaultSecretStatus>,
        #[serde(rename = "geoRegion", default, skip_serializing_if = "Option::is_none")]
        pub geo_region: Option<String>,
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
    }
    impl Properties {
        pub fn new(password: String) -> Self {
            Self {
                friendly_name: None,
                subject_name: None,
                host_names: Vec::new(),
                pfx_blob: None,
                site_name: None,
                self_link: None,
                issuer: None,
                issue_date: None,
                expiration_date: None,
                password,
                thumbprint: None,
                valid: None,
                cer_blob: None,
                public_key_hash: None,
                hosting_environment_profile: None,
                key_vault_id: None,
                key_vault_secret_name: None,
                key_vault_secret_status: None,
                geo_region: None,
                server_farm_id: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum KeyVaultSecretStatus {
            Initialized,
            WaitingOnCertificateOrder,
            Succeeded,
            CertificateOrderFailed,
            OperationNotPermittedOnKeyVault,
            AzureServiceUnauthorizedToAccessKeyVault,
            KeyVaultDoesNotExist,
            KeyVaultSecretDoesNotExist,
            UnknownError,
            ExternalPrivateKey,
            Unknown,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloningInfo {
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub overwrite: Option<bool>,
    #[serde(rename = "cloneCustomHostNames", default, skip_serializing_if = "Option::is_none")]
    pub clone_custom_host_names: Option<bool>,
    #[serde(rename = "cloneSourceControl", default, skip_serializing_if = "Option::is_none")]
    pub clone_source_control: Option<bool>,
    #[serde(rename = "sourceWebAppId")]
    pub source_web_app_id: String,
    #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
    pub hosting_environment: Option<String>,
    #[serde(rename = "appSettingsOverrides", default, skip_serializing_if = "Option::is_none")]
    pub app_settings_overrides: Option<serde_json::Value>,
    #[serde(rename = "configureLoadBalancing", default, skip_serializing_if = "Option::is_none")]
    pub configure_load_balancing: Option<bool>,
    #[serde(rename = "trafficManagerProfileId", default, skip_serializing_if = "Option::is_none")]
    pub traffic_manager_profile_id: Option<String>,
    #[serde(rename = "trafficManagerProfileName", default, skip_serializing_if = "Option::is_none")]
    pub traffic_manager_profile_name: Option<String>,
    #[serde(rename = "ignoreQuotas", default, skip_serializing_if = "Option::is_none")]
    pub ignore_quotas: Option<bool>,
}
impl CloningInfo {
    pub fn new(source_web_app_id: String) -> Self {
        Self {
            correlation_id: None,
            overwrite: None,
            clone_custom_host_names: None,
            clone_source_control: None,
            source_web_app_id,
            hosting_environment: None,
            app_settings_overrides: None,
            configure_load_balancing: None,
            traffic_manager_profile_id: None,
            traffic_manager_profile_name: None,
            ignore_quotas: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnStringInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<conn_string_info::Type>,
}
impl ConnStringInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod conn_string_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        MySql,
        #[serde(rename = "SQLServer")]
        SqlServer,
        #[serde(rename = "SQLAzure")]
        SqlAzure,
        Custom,
        NotificationHub,
        ServiceBus,
        EventHub,
        ApiHub,
        DocDb,
        RedisCache,
        #[serde(rename = "PostgreSQL")]
        PostgreSql,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CorsSettings {
    #[serde(rename = "allowedOrigins", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_origins: Vec<String>,
}
impl CorsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmMoveResourceEnvelope {
    #[serde(rename = "targetResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<String>,
}
impl CsmMoveResourceEnvelope {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CsmOperationCollection {
    pub value: Vec<CsmOperationDescription>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CsmOperationCollection {
    pub fn new(value: Vec<CsmOperationDescription>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmOperationDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<CsmOperationDisplay>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CsmOperationDescriptionProperties>,
}
impl CsmOperationDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmOperationDescriptionProperties {
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<ServiceSpecification>,
}
impl CsmOperationDescriptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmOperationDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl CsmOperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmUsageQuota {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
    pub next_reset_time: Option<String>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<LocalizableString>,
}
impl CsmUsageQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CsmUsageQuotaCollection {
    pub value: Vec<CsmUsageQuota>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CsmUsageQuotaCollection {
    pub fn new(value: Vec<CsmUsageQuota>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataSource {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub instructions: Vec<String>,
    #[serde(rename = "dataSourceUri", default, skip_serializing_if = "Vec::is_empty")]
    pub data_source_uri: Vec<NameValuePair>,
}
impl DataSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataTableResponseColumn {
    #[serde(rename = "columnName", default, skip_serializing_if = "Option::is_none")]
    pub column_name: Option<String>,
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<String>,
    #[serde(rename = "columnType", default, skip_serializing_if = "Option::is_none")]
    pub column_type: Option<String>,
}
impl DataTableResponseColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataTableResponseObject {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<DataTableResponseColumn>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rows: Vec<Vec<String>>,
}
impl DataTableResponseObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<default_error_response::Error>,
}
impl DefaultErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod default_error_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Error {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub code: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub target: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub details: Vec<serde_json::Value>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub innererror: Option<String>,
    }
    impl Error {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeletedSite {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<i32>,
    #[serde(rename = "deletedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub deleted_timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subscription: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub slot: Option<String>,
}
impl DeletedSite {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeletedWebAppCollection {
    pub value: Vec<DeletedSite>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DeletedWebAppCollection {
    pub fn new(value: Vec<DeletedSite>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentLocations {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<GeoRegion>,
    #[serde(rename = "hostingEnvironments", default, skip_serializing_if = "Vec::is_empty")]
    pub hosting_environments: Vec<AppServiceEnvironment>,
    #[serde(rename = "hostingEnvironmentDeploymentInfos", default, skip_serializing_if = "Vec::is_empty")]
    pub hosting_environment_deployment_infos: Vec<HostingEnvironmentDeploymentInfo>,
}
impl DeploymentLocations {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetectorAbnormalTimePeriod {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<f64>,
    #[serde(rename = "metaData", default, skip_serializing_if = "Vec::is_empty")]
    pub meta_data: Vec<Vec<NameValuePair>>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<detector_abnormal_time_period::Type>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub solutions: Vec<Solution>,
}
impl DetectorAbnormalTimePeriod {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod detector_abnormal_time_period {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        ServiceIncident,
        AppDeployment,
        AppCrash,
        RuntimeIssueDetected,
        AseDeployment,
        UserIssue,
        PlatformIssue,
        Other,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetectorDefinition {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<detector_definition::Properties>,
}
impl DetectorDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod detector_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub rank: Option<f64>,
        #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
        pub is_enabled: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetectorInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(rename = "subCategory", default, skip_serializing_if = "Option::is_none")]
    pub sub_category: Option<String>,
    #[serde(rename = "supportTopicId", default, skip_serializing_if = "Option::is_none")]
    pub support_topic_id: Option<String>,
}
impl DetectorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DetectorResponse {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<detector_response::Properties>,
}
impl DetectorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod detector_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub metadata: Option<DetectorInfo>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub dataset: Vec<DiagnosticData>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DetectorResponseCollection {
    pub value: Vec<DetectorResponse>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DetectorResponseCollection {
    pub fn new(value: Vec<DetectorResponse>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticAnalysis {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<diagnostic_analysis::Properties>,
}
impl DiagnosticAnalysis {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod diagnostic_analysis {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(rename = "abnormalTimePeriods", default, skip_serializing_if = "Vec::is_empty")]
        pub abnormal_time_periods: Vec<AbnormalTimePeriod>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub payload: Vec<AnalysisData>,
        #[serde(rename = "nonCorrelatedDetectors", default, skip_serializing_if = "Vec::is_empty")]
        pub non_correlated_detectors: Vec<DetectorDefinition>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiagnosticAnalysisCollection {
    pub value: Vec<AnalysisDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiagnosticAnalysisCollection {
    pub fn new(value: Vec<AnalysisDefinition>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticCategory {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<diagnostic_category::Properties>,
}
impl DiagnosticCategory {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod diagnostic_category {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiagnosticCategoryCollection {
    pub value: Vec<DiagnosticCategory>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiagnosticCategoryCollection {
    pub fn new(value: Vec<DiagnosticCategory>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<DataTableResponseObject>,
    #[serde(rename = "renderingProperties", default, skip_serializing_if = "Option::is_none")]
    pub rendering_properties: Option<Rendering>,
}
impl DiagnosticData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiagnosticDetectorCollection {
    pub value: Vec<DetectorDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiagnosticDetectorCollection {
    pub fn new(value: Vec<DetectorDefinition>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticDetectorResponse {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<diagnostic_detector_response::Properties>,
}
impl DiagnosticDetectorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod diagnostic_detector_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(rename = "issueDetected", default, skip_serializing_if = "Option::is_none")]
        pub issue_detected: Option<bool>,
        #[serde(rename = "detectorDefinition", default, skip_serializing_if = "Option::is_none")]
        pub detector_definition: Option<DetectorDefinition>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub metrics: Vec<DiagnosticMetricSet>,
        #[serde(rename = "abnormalTimePeriods", default, skip_serializing_if = "Vec::is_empty")]
        pub abnormal_time_periods: Vec<DetectorAbnormalTimePeriod>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub data: Vec<Vec<NameValuePair>>,
        #[serde(rename = "responseMetaData", default, skip_serializing_if = "Option::is_none")]
        pub response_meta_data: Option<ResponseMetaData>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticMetricSample {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "roleInstance", default, skip_serializing_if = "Option::is_none")]
    pub role_instance: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f64>,
    #[serde(rename = "isAggregated", default, skip_serializing_if = "Option::is_none")]
    pub is_aggregated: Option<bool>,
}
impl DiagnosticMetricSample {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiagnosticMetricSet {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<DiagnosticMetricSample>,
}
impl DiagnosticMetricSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "internalName", default, skip_serializing_if = "Option::is_none")]
    pub internal_name: Option<String>,
    #[serde(rename = "toBeExportedForShoebox", default, skip_serializing_if = "Option::is_none")]
    pub to_be_exported_for_shoebox: Option<bool>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorEntity {
    #[serde(rename = "extendedCode", default, skip_serializing_if = "Option::is_none")]
    pub extended_code: Option<String>,
    #[serde(rename = "messageTemplate", default, skip_serializing_if = "Option::is_none")]
    pub message_template: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<String>,
    #[serde(rename = "innerErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub inner_errors: Vec<ErrorEntity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Experiments {
    #[serde(rename = "rampUpRules", default, skip_serializing_if = "Vec::is_empty")]
    pub ramp_up_rules: Vec<RampUpRule>,
}
impl Experiments {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GeoRegion {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<geo_region::Properties>,
}
impl GeoRegion {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod geo_region {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GeoRegionCollection {
    pub value: Vec<GeoRegion>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GeoRegionCollection {
    pub fn new(value: Vec<GeoRegion>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GlobalCsmSkuDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<SkuCapacity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
}
impl GlobalCsmSkuDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HandlerMapping {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub extension: Option<String>,
    #[serde(rename = "scriptProcessor", default, skip_serializing_if = "Option::is_none")]
    pub script_processor: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub arguments: Option<String>,
}
impl HandlerMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostNameSslState {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "sslState", default, skip_serializing_if = "Option::is_none")]
    pub ssl_state: Option<host_name_ssl_state::SslState>,
    #[serde(rename = "virtualIP", default, skip_serializing_if = "Option::is_none")]
    pub virtual_ip: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(rename = "toUpdate", default, skip_serializing_if = "Option::is_none")]
    pub to_update: Option<bool>,
    #[serde(rename = "hostType", default, skip_serializing_if = "Option::is_none")]
    pub host_type: Option<host_name_ssl_state::HostType>,
}
impl HostNameSslState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod host_name_ssl_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SslState {
        Disabled,
        SniEnabled,
        IpBasedEnabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HostType {
        Standard,
        Repository,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentDeploymentInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl HostingEnvironmentDeploymentInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentProfile {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl HostingEnvironmentProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HybridConnection {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hybrid_connection::Properties>,
}
impl HybridConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hybrid_connection {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "serviceBusNamespace", default, skip_serializing_if = "Option::is_none")]
        pub service_bus_namespace: Option<String>,
        #[serde(rename = "relayName", default, skip_serializing_if = "Option::is_none")]
        pub relay_name: Option<String>,
        #[serde(rename = "relayArmUri", default, skip_serializing_if = "Option::is_none")]
        pub relay_arm_uri: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub hostname: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub port: Option<i32>,
        #[serde(rename = "sendKeyName", default, skip_serializing_if = "Option::is_none")]
        pub send_key_name: Option<String>,
        #[serde(rename = "sendKeyValue", default, skip_serializing_if = "Option::is_none")]
        pub send_key_value: Option<String>,
        #[serde(rename = "serviceBusSuffix", default, skip_serializing_if = "Option::is_none")]
        pub service_bus_suffix: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HybridConnectionKey {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hybrid_connection_key::Properties>,
}
impl HybridConnectionKey {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hybrid_connection_key {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "sendKeyName", default, skip_serializing_if = "Option::is_none")]
        pub send_key_name: Option<String>,
        #[serde(rename = "sendKeyValue", default, skip_serializing_if = "Option::is_none")]
        pub send_key_value: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Identifier {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<identifier::Properties>,
}
impl Identifier {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identifier {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IdentifierCollection {
    pub value: Vec<Identifier>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IdentifierCollection {
    pub fn new(value: Vec<Identifier>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpSecurityRestriction {
    #[serde(rename = "ipAddress")]
    pub ip_address: String,
    #[serde(rename = "subnetMask", default, skip_serializing_if = "Option::is_none")]
    pub subnet_mask: Option<String>,
}
impl IpSecurityRestriction {
    pub fn new(ip_address: String) -> Self {
        Self {
            ip_address,
            subnet_mask: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalizableString {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl LocalizableString {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedServiceIdentity {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<managed_service_identity::Type>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
}
impl ManagedServiceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_service_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricAvailability {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl MetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[serde(rename = "supportsInstanceLevelAggregation", default, skip_serializing_if = "Option::is_none")]
    pub supports_instance_level_aggregation: Option<bool>,
    #[serde(rename = "enableRegionalMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub enable_regional_mdm_account: Option<bool>,
    #[serde(rename = "sourceMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_account: Option<String>,
    #[serde(rename = "sourceMdmNamespace", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_namespace: Option<String>,
    #[serde(rename = "metricFilterPattern", default, skip_serializing_if = "Option::is_none")]
    pub metric_filter_pattern: Option<String>,
    #[serde(rename = "fillGapWithZero", default, skip_serializing_if = "Option::is_none")]
    pub fill_gap_with_zero: Option<bool>,
    #[serde(rename = "isInternal", default, skip_serializing_if = "Option::is_none")]
    pub is_internal: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Dimension>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub availabilities: Vec<MetricAvailability>,
}
impl MetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameIdentifier {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl NameIdentifier {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameValuePair {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl NameValuePair {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkAccessControlEntry {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<network_access_control_entry::Action>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub order: Option<i32>,
    #[serde(rename = "remoteSubnet", default, skip_serializing_if = "Option::is_none")]
    pub remote_subnet: Option<String>,
}
impl NetworkAccessControlEntry {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_access_control_entry {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Permit,
        Deny,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<operation::Status>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ErrorEntity>,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "modifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub modified_time: Option<String>,
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[serde(rename = "geoMasterOperationId", default, skip_serializing_if = "Option::is_none")]
    pub geo_master_operation_id: Option<String>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Failed,
        Succeeded,
        TimedOut,
        Created,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PremierAddOnOffer {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<premier_add_on_offer::Properties>,
}
impl PremierAddOnOffer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod premier_add_on_offer {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub sku: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub product: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub vendor: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "promoCodeRequired", default, skip_serializing_if = "Option::is_none")]
        pub promo_code_required: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub quota: Option<i32>,
        #[serde(rename = "webHostingPlanRestrictions", default, skip_serializing_if = "Option::is_none")]
        pub web_hosting_plan_restrictions: Option<properties::WebHostingPlanRestrictions>,
        #[serde(rename = "privacyPolicyUrl", default, skip_serializing_if = "Option::is_none")]
        pub privacy_policy_url: Option<String>,
        #[serde(rename = "legalTermsUrl", default, skip_serializing_if = "Option::is_none")]
        pub legal_terms_url: Option<String>,
        #[serde(rename = "marketplacePublisher", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_publisher: Option<String>,
        #[serde(rename = "marketplaceOffer", default, skip_serializing_if = "Option::is_none")]
        pub marketplace_offer: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum WebHostingPlanRestrictions {
            None,
            Free,
            Shared,
            Basic,
            Standard,
            Premium,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PremierAddOnOfferCollection {
    pub value: Vec<PremierAddOnOffer>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PremierAddOnOfferCollection {
    pub fn new(value: Vec<PremierAddOnOffer>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyOnlyResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ProxyOnlyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PushSettings {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<push_settings::Properties>,
}
impl PushSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod push_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "isPushEnabled")]
        pub is_push_enabled: bool,
        #[serde(rename = "tagWhitelistJson", default, skip_serializing_if = "Option::is_none")]
        pub tag_whitelist_json: Option<String>,
        #[serde(rename = "tagsRequiringAuth", default, skip_serializing_if = "Option::is_none")]
        pub tags_requiring_auth: Option<String>,
        #[serde(rename = "dynamicTagsJson", default, skip_serializing_if = "Option::is_none")]
        pub dynamic_tags_json: Option<String>,
    }
    impl Properties {
        pub fn new(is_push_enabled: bool) -> Self {
            Self {
                is_push_enabled,
                tag_whitelist_json: None,
                tags_requiring_auth: None,
                dynamic_tags_json: None,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RampUpRule {
    #[serde(rename = "actionHostName", default, skip_serializing_if = "Option::is_none")]
    pub action_host_name: Option<String>,
    #[serde(rename = "reroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub reroute_percentage: Option<f64>,
    #[serde(rename = "changeStep", default, skip_serializing_if = "Option::is_none")]
    pub change_step: Option<f64>,
    #[serde(rename = "changeIntervalInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub change_interval_in_minutes: Option<i32>,
    #[serde(rename = "minReroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub min_reroute_percentage: Option<f64>,
    #[serde(rename = "maxReroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub max_reroute_percentage: Option<f64>,
    #[serde(rename = "changeDecisionCallbackUrl", default, skip_serializing_if = "Option::is_none")]
    pub change_decision_callback_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl RampUpRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Recommendation {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<recommendation::Properties>,
}
impl Recommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recommendation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
        pub creation_time: Option<String>,
        #[serde(rename = "recommendationId", default, skip_serializing_if = "Option::is_none")]
        pub recommendation_id: Option<String>,
        #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
        pub resource_id: Option<String>,
        #[serde(rename = "resourceScope", default, skip_serializing_if = "Option::is_none")]
        pub resource_scope: Option<properties::ResourceScope>,
        #[serde(rename = "ruleName", default, skip_serializing_if = "Option::is_none")]
        pub rule_name: Option<String>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub level: Option<properties::Level>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub channels: Option<properties::Channels>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tags: Vec<String>,
        #[serde(rename = "actionName", default, skip_serializing_if = "Option::is_none")]
        pub action_name: Option<String>,
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(rename = "nextNotificationTime", default, skip_serializing_if = "Option::is_none")]
        pub next_notification_time: Option<String>,
        #[serde(rename = "notificationExpirationTime", default, skip_serializing_if = "Option::is_none")]
        pub notification_expiration_time: Option<String>,
        #[serde(rename = "notifiedTime", default, skip_serializing_if = "Option::is_none")]
        pub notified_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub score: Option<f64>,
        #[serde(rename = "isDynamic", default, skip_serializing_if = "Option::is_none")]
        pub is_dynamic: Option<bool>,
        #[serde(rename = "extensionName", default, skip_serializing_if = "Option::is_none")]
        pub extension_name: Option<String>,
        #[serde(rename = "bladeName", default, skip_serializing_if = "Option::is_none")]
        pub blade_name: Option<String>,
        #[serde(rename = "forwardLink", default, skip_serializing_if = "Option::is_none")]
        pub forward_link: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ResourceScope {
            ServerFarm,
            Subscription,
            WebSite,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Level {
            Critical,
            Warning,
            Information,
            NonUrgentSuggestion,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Channels {
            Notification,
            Api,
            Email,
            Webhook,
            All,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecommendationCollection {
    pub value: Vec<Recommendation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecommendationCollection {
    pub fn new(value: Vec<Recommendation>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendationRule {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<recommendation_rule::Properties>,
}
impl RecommendationRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recommendation_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(rename = "recommendationId", default, skip_serializing_if = "Option::is_none")]
        pub recommendation_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(rename = "actionName", default, skip_serializing_if = "Option::is_none")]
        pub action_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub level: Option<properties::Level>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub channels: Option<properties::Channels>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tags: Vec<String>,
        #[serde(rename = "isDynamic", default, skip_serializing_if = "Option::is_none")]
        pub is_dynamic: Option<bool>,
        #[serde(rename = "extensionName", default, skip_serializing_if = "Option::is_none")]
        pub extension_name: Option<String>,
        #[serde(rename = "bladeName", default, skip_serializing_if = "Option::is_none")]
        pub blade_name: Option<String>,
        #[serde(rename = "forwardLink", default, skip_serializing_if = "Option::is_none")]
        pub forward_link: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Level {
            Critical,
            Warning,
            Information,
            NonUrgentSuggestion,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Channels {
            Notification,
            Api,
            Email,
            Webhook,
            All,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Rendering {
    #[serde(rename = "renderingType", default, skip_serializing_if = "Option::is_none")]
    pub rendering_type: Option<rendering::RenderingType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl Rendering {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod rendering {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RenderingType {
        NoGraph,
        Table,
        TimeSeries,
        TimeSeriesPerInstance,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestsBasedTrigger {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl RequestsBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    pub location: String,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            kind: None,
            location,
            type_: None,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceHealthMetadata {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<resource_health_metadata::Properties>,
}
impl ResourceHealthMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_health_metadata {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub category: Option<String>,
        #[serde(rename = "signalAvailability", default, skip_serializing_if = "Option::is_none")]
        pub signal_availability: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceHealthMetadataCollection {
    pub value: Vec<ResourceHealthMetadata>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceHealthMetadataCollection {
    pub fn new(value: Vec<ResourceHealthMetadata>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetric {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<ResourceMetricName>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "metricValues", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_values: Vec<ResourceMetricValue>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<ResourceMetricProperty>,
}
impl ResourceMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricAvailability {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
}
impl ResourceMetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceMetricCollection {
    pub value: Vec<ResourceMetric>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceMetricCollection {
    pub fn new(value: Vec<ResourceMetric>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricDefinition {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<resource_metric_definition::Properties>,
}
impl ResourceMetricDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_metric_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<ResourceMetricName>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub unit: Option<String>,
        #[serde(rename = "primaryAggregationType", default, skip_serializing_if = "Option::is_none")]
        pub primary_aggregation_type: Option<String>,
        #[serde(rename = "metricAvailabilities", default, skip_serializing_if = "Vec::is_empty")]
        pub metric_availabilities: Vec<ResourceMetricAvailability>,
        #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
        pub resource_uri: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub properties: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceMetricDefinitionCollection {
    pub value: Vec<ResourceMetricDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceMetricDefinitionCollection {
    pub fn new(value: Vec<ResourceMetricDefinition>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl ResourceMetricName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricProperty {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ResourceMetricProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricValue {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub average: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<f32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<ResourceMetricProperty>,
}
impl ResourceMetricValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNameAvailability {
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<resource_name_availability::Reason>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ResourceNameAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_name_availability {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceNameAvailabilityRequest {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: resource_name_availability_request::Type,
    #[serde(rename = "isFqdn", default, skip_serializing_if = "Option::is_none")]
    pub is_fqdn: Option<bool>,
}
impl ResourceNameAvailabilityRequest {
    pub fn new(name: String, type_: resource_name_availability_request::Type) -> Self {
        Self {
            name,
            type_,
            is_fqdn: None,
        }
    }
}
pub mod resource_name_availability_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Site,
        Slot,
        HostingEnvironment,
        PublishingUser,
        #[serde(rename = "Microsoft.Web/sites")]
        MicrosoftWebSites,
        #[serde(rename = "Microsoft.Web/sites/slots")]
        MicrosoftWebSitesSlots,
        #[serde(rename = "Microsoft.Web/hostingEnvironments")]
        MicrosoftWebHostingEnvironments,
        #[serde(rename = "Microsoft.Web/publishingUsers")]
        MicrosoftWebPublishingUsers,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseMetaData {
    #[serde(rename = "dataSource", default, skip_serializing_if = "Option::is_none")]
    pub data_source: Option<DataSource>,
}
impl ResponseMetaData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceSpecification {
    #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_specifications: Vec<MetricSpecification>,
}
impl ServiceSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Site {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site::Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
}
impl Site {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            identity: None,
        }
    }
}
pub mod site {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "repositorySiteName", default, skip_serializing_if = "Option::is_none")]
        pub repository_site_name: Option<String>,
        #[serde(rename = "usageState", default, skip_serializing_if = "Option::is_none")]
        pub usage_state: Option<properties::UsageState>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "enabledHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub enabled_host_names: Vec<String>,
        #[serde(rename = "availabilityState", default, skip_serializing_if = "Option::is_none")]
        pub availability_state: Option<properties::AvailabilityState>,
        #[serde(rename = "hostNameSslStates", default, skip_serializing_if = "Vec::is_empty")]
        pub host_name_ssl_states: Vec<HostNameSslState>,
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reserved: Option<bool>,
        #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
        pub last_modified_time_utc: Option<String>,
        #[serde(rename = "siteConfig", default, skip_serializing_if = "Option::is_none")]
        pub site_config: Option<SiteConfig>,
        #[serde(rename = "trafficManagerHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub traffic_manager_host_names: Vec<String>,
        #[serde(rename = "scmSiteAlsoStopped", default, skip_serializing_if = "Option::is_none")]
        pub scm_site_also_stopped: Option<bool>,
        #[serde(rename = "targetSwapSlot", default, skip_serializing_if = "Option::is_none")]
        pub target_swap_slot: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "clientAffinityEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_affinity_enabled: Option<bool>,
        #[serde(rename = "clientCertEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_cert_enabled: Option<bool>,
        #[serde(rename = "hostNamesDisabled", default, skip_serializing_if = "Option::is_none")]
        pub host_names_disabled: Option<bool>,
        #[serde(rename = "outboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub outbound_ip_addresses: Option<String>,
        #[serde(rename = "possibleOutboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub possible_outbound_ip_addresses: Option<String>,
        #[serde(rename = "containerSize", default, skip_serializing_if = "Option::is_none")]
        pub container_size: Option<i32>,
        #[serde(rename = "dailyMemoryTimeQuota", default, skip_serializing_if = "Option::is_none")]
        pub daily_memory_time_quota: Option<i32>,
        #[serde(rename = "suspendedTill", default, skip_serializing_if = "Option::is_none")]
        pub suspended_till: Option<String>,
        #[serde(rename = "maxNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub max_number_of_workers: Option<i32>,
        #[serde(rename = "cloningInfo", default, skip_serializing_if = "Option::is_none")]
        pub cloning_info: Option<CloningInfo>,
        #[serde(rename = "snapshotInfo", default, skip_serializing_if = "Option::is_none")]
        pub snapshot_info: Option<SnapshotRecoveryRequest>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(rename = "isDefaultContainer", default, skip_serializing_if = "Option::is_none")]
        pub is_default_container: Option<bool>,
        #[serde(rename = "defaultHostName", default, skip_serializing_if = "Option::is_none")]
        pub default_host_name: Option<String>,
        #[serde(rename = "slotSwapStatus", default, skip_serializing_if = "Option::is_none")]
        pub slot_swap_status: Option<SlotSwapStatus>,
        #[serde(rename = "httpsOnly", default, skip_serializing_if = "Option::is_none")]
        pub https_only: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum UsageState {
            Normal,
            Exceeded,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AvailabilityState {
            Normal,
            Limited,
            DisasterRecoveryMode,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteConfig {
    #[serde(rename = "numberOfWorkers", default, skip_serializing_if = "Option::is_none")]
    pub number_of_workers: Option<i32>,
    #[serde(rename = "defaultDocuments", default, skip_serializing_if = "Vec::is_empty")]
    pub default_documents: Vec<String>,
    #[serde(rename = "netFrameworkVersion", default, skip_serializing_if = "Option::is_none")]
    pub net_framework_version: Option<String>,
    #[serde(rename = "phpVersion", default, skip_serializing_if = "Option::is_none")]
    pub php_version: Option<String>,
    #[serde(rename = "pythonVersion", default, skip_serializing_if = "Option::is_none")]
    pub python_version: Option<String>,
    #[serde(rename = "nodeVersion", default, skip_serializing_if = "Option::is_none")]
    pub node_version: Option<String>,
    #[serde(rename = "linuxFxVersion", default, skip_serializing_if = "Option::is_none")]
    pub linux_fx_version: Option<String>,
    #[serde(rename = "requestTracingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub request_tracing_enabled: Option<bool>,
    #[serde(rename = "requestTracingExpirationTime", default, skip_serializing_if = "Option::is_none")]
    pub request_tracing_expiration_time: Option<String>,
    #[serde(rename = "remoteDebuggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub remote_debugging_enabled: Option<bool>,
    #[serde(rename = "remoteDebuggingVersion", default, skip_serializing_if = "Option::is_none")]
    pub remote_debugging_version: Option<String>,
    #[serde(rename = "httpLoggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub http_logging_enabled: Option<bool>,
    #[serde(rename = "logsDirectorySizeLimit", default, skip_serializing_if = "Option::is_none")]
    pub logs_directory_size_limit: Option<i32>,
    #[serde(rename = "detailedErrorLoggingEnabled", default, skip_serializing_if = "Option::is_none")]
    pub detailed_error_logging_enabled: Option<bool>,
    #[serde(rename = "publishingUsername", default, skip_serializing_if = "Option::is_none")]
    pub publishing_username: Option<String>,
    #[serde(rename = "appSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub app_settings: Vec<NameValuePair>,
    #[serde(rename = "connectionStrings", default, skip_serializing_if = "Vec::is_empty")]
    pub connection_strings: Vec<ConnStringInfo>,
    #[serde(rename = "machineKey", default, skip_serializing_if = "Option::is_none")]
    pub machine_key: Option<SiteMachineKey>,
    #[serde(rename = "handlerMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub handler_mappings: Vec<HandlerMapping>,
    #[serde(rename = "documentRoot", default, skip_serializing_if = "Option::is_none")]
    pub document_root: Option<String>,
    #[serde(rename = "scmType", default, skip_serializing_if = "Option::is_none")]
    pub scm_type: Option<site_config::ScmType>,
    #[serde(rename = "use32BitWorkerProcess", default, skip_serializing_if = "Option::is_none")]
    pub use32_bit_worker_process: Option<bool>,
    #[serde(rename = "webSocketsEnabled", default, skip_serializing_if = "Option::is_none")]
    pub web_sockets_enabled: Option<bool>,
    #[serde(rename = "alwaysOn", default, skip_serializing_if = "Option::is_none")]
    pub always_on: Option<bool>,
    #[serde(rename = "javaVersion", default, skip_serializing_if = "Option::is_none")]
    pub java_version: Option<String>,
    #[serde(rename = "javaContainer", default, skip_serializing_if = "Option::is_none")]
    pub java_container: Option<String>,
    #[serde(rename = "javaContainerVersion", default, skip_serializing_if = "Option::is_none")]
    pub java_container_version: Option<String>,
    #[serde(rename = "appCommandLine", default, skip_serializing_if = "Option::is_none")]
    pub app_command_line: Option<String>,
    #[serde(rename = "managedPipelineMode", default, skip_serializing_if = "Option::is_none")]
    pub managed_pipeline_mode: Option<site_config::ManagedPipelineMode>,
    #[serde(rename = "virtualApplications", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_applications: Vec<VirtualApplication>,
    #[serde(rename = "loadBalancing", default, skip_serializing_if = "Option::is_none")]
    pub load_balancing: Option<site_config::LoadBalancing>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub experiments: Option<Experiments>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limits: Option<SiteLimits>,
    #[serde(rename = "autoHealEnabled", default, skip_serializing_if = "Option::is_none")]
    pub auto_heal_enabled: Option<bool>,
    #[serde(rename = "autoHealRules", default, skip_serializing_if = "Option::is_none")]
    pub auto_heal_rules: Option<AutoHealRules>,
    #[serde(rename = "tracingOptions", default, skip_serializing_if = "Option::is_none")]
    pub tracing_options: Option<String>,
    #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
    pub vnet_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cors: Option<CorsSettings>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub push: Option<PushSettings>,
    #[serde(rename = "apiDefinition", default, skip_serializing_if = "Option::is_none")]
    pub api_definition: Option<ApiDefinitionInfo>,
    #[serde(rename = "autoSwapSlotName", default, skip_serializing_if = "Option::is_none")]
    pub auto_swap_slot_name: Option<String>,
    #[serde(rename = "localMySqlEnabled", default, skip_serializing_if = "Option::is_none")]
    pub local_my_sql_enabled: Option<bool>,
    #[serde(rename = "ipSecurityRestrictions", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_security_restrictions: Vec<IpSecurityRestriction>,
    #[serde(rename = "http20Enabled", default, skip_serializing_if = "Option::is_none")]
    pub http20_enabled: Option<bool>,
    #[serde(rename = "minTlsVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_tls_version: Option<site_config::MinTlsVersion>,
}
impl SiteConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScmType {
        None,
        Dropbox,
        Tfs,
        LocalGit,
        GitHub,
        CodePlexGit,
        CodePlexHg,
        BitbucketGit,
        BitbucketHg,
        ExternalGit,
        ExternalHg,
        OneDrive,
        #[serde(rename = "VSO")]
        Vso,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ManagedPipelineMode {
        Integrated,
        Classic,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadBalancing {
        WeightedRoundRobin,
        LeastRequests,
        LeastResponseTime,
        WeightedTotalTraffic,
        RequestHash,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MinTlsVersion {
        #[serde(rename = "1.0")]
        N1_0,
        #[serde(rename = "1.1")]
        N1_1,
        #[serde(rename = "1.2")]
        N1_2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteLimits {
    #[serde(rename = "maxPercentageCpu", default, skip_serializing_if = "Option::is_none")]
    pub max_percentage_cpu: Option<f64>,
    #[serde(rename = "maxMemoryInMb", default, skip_serializing_if = "Option::is_none")]
    pub max_memory_in_mb: Option<i64>,
    #[serde(rename = "maxDiskSizeInMb", default, skip_serializing_if = "Option::is_none")]
    pub max_disk_size_in_mb: Option<i64>,
}
impl SiteLimits {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteMachineKey {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub validation: Option<String>,
    #[serde(rename = "validationKey", default, skip_serializing_if = "Option::is_none")]
    pub validation_key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub decryption: Option<String>,
    #[serde(rename = "decryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub decryption_key: Option<String>,
}
impl SiteMachineKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<i32>,
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<String>,
}
impl SkuCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
    #[serde(rename = "skuCapacity", default, skip_serializing_if = "Option::is_none")]
    pub sku_capacity: Option<SkuCapacity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<Capability>,
}
impl SkuDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuInfos {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub skus: Vec<GlobalCsmSkuDescription>,
}
impl SkuInfos {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotSwapStatus {
    #[serde(rename = "timestampUtc", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_utc: Option<String>,
    #[serde(rename = "sourceSlotName", default, skip_serializing_if = "Option::is_none")]
    pub source_slot_name: Option<String>,
    #[serde(rename = "destinationSlotName", default, skip_serializing_if = "Option::is_none")]
    pub destination_slot_name: Option<String>,
}
impl SlotSwapStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlowRequestsBasedTrigger {
    #[serde(rename = "timeTaken", default, skip_serializing_if = "Option::is_none")]
    pub time_taken: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl SlowRequestsBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotRecoveryRequest {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<snapshot_recovery_request::Properties>,
}
impl SnapshotRecoveryRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod snapshot_recovery_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "snapshotTime", default, skip_serializing_if = "Option::is_none")]
        pub snapshot_time: Option<String>,
        #[serde(rename = "recoveryTarget", default, skip_serializing_if = "Option::is_none")]
        pub recovery_target: Option<SnapshotRecoveryTarget>,
        pub overwrite: bool,
        #[serde(rename = "recoverConfiguration", default, skip_serializing_if = "Option::is_none")]
        pub recover_configuration: Option<bool>,
        #[serde(rename = "ignoreConflictingHostNames", default, skip_serializing_if = "Option::is_none")]
        pub ignore_conflicting_host_names: Option<bool>,
    }
    impl Properties {
        pub fn new(overwrite: bool) -> Self {
            Self {
                snapshot_time: None,
                recovery_target: None,
                overwrite,
                recover_configuration: None,
                ignore_conflicting_host_names: None,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotRecoveryTarget {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SnapshotRecoveryTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Solution {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<f64>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub order: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<solution::Type>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub data: Vec<Vec<NameValuePair>>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<Vec<NameValuePair>>,
}
impl Solution {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod solution {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        QuickSolution,
        DeepInvestigation,
        BestPractices,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceControl {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<source_control::Properties>,
}
impl SourceControl {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod source_control {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub token: Option<String>,
        #[serde(rename = "tokenSecret", default, skip_serializing_if = "Option::is_none")]
        pub token_secret: Option<String>,
        #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
        pub refresh_token: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceControlCollection {
    pub value: Vec<SourceControl>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SourceControlCollection {
    pub fn new(value: Vec<SourceControl>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StackMajorVersion {
    #[serde(rename = "displayVersion", default, skip_serializing_if = "Option::is_none")]
    pub display_version: Option<String>,
    #[serde(rename = "runtimeVersion", default, skip_serializing_if = "Option::is_none")]
    pub runtime_version: Option<String>,
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[serde(rename = "minorVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub minor_versions: Vec<StackMinorVersion>,
}
impl StackMajorVersion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StackMinorVersion {
    #[serde(rename = "displayVersion", default, skip_serializing_if = "Option::is_none")]
    pub display_version: Option<String>,
    #[serde(rename = "runtimeVersion", default, skip_serializing_if = "Option::is_none")]
    pub runtime_version: Option<String>,
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
}
impl StackMinorVersion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StampCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "availableCapacity", default, skip_serializing_if = "Option::is_none")]
    pub available_capacity: Option<i64>,
    #[serde(rename = "totalCapacity", default, skip_serializing_if = "Option::is_none")]
    pub total_capacity: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "computeMode", default, skip_serializing_if = "Option::is_none")]
    pub compute_mode: Option<stamp_capacity::ComputeMode>,
    #[serde(rename = "workerSize", default, skip_serializing_if = "Option::is_none")]
    pub worker_size: Option<stamp_capacity::WorkerSize>,
    #[serde(rename = "workerSizeId", default, skip_serializing_if = "Option::is_none")]
    pub worker_size_id: Option<i32>,
    #[serde(rename = "excludeFromCapacityAllocation", default, skip_serializing_if = "Option::is_none")]
    pub exclude_from_capacity_allocation: Option<bool>,
    #[serde(rename = "isApplicableForAllComputeModes", default, skip_serializing_if = "Option::is_none")]
    pub is_applicable_for_all_compute_modes: Option<bool>,
    #[serde(rename = "siteMode", default, skip_serializing_if = "Option::is_none")]
    pub site_mode: Option<String>,
}
impl StampCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod stamp_capacity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComputeMode {
        Shared,
        Dedicated,
        Dynamic,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkerSize {
        Default,
        Small,
        Medium,
        Large,
        D1,
        D2,
        D3,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StatusCodesBasedTrigger {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<i32>,
    #[serde(rename = "subStatus", default, skip_serializing_if = "Option::is_none")]
    pub sub_status: Option<i32>,
    #[serde(rename = "win32Status", default, skip_serializing_if = "Option::is_none")]
    pub win32_status: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl StatusCodesBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct User {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<user::Properties>,
}
impl User {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod user {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "publishingUserName")]
        pub publishing_user_name: String,
        #[serde(rename = "publishingPassword", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password: Option<String>,
        #[serde(rename = "publishingPasswordHash", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password_hash: Option<String>,
        #[serde(rename = "publishingPasswordHashSalt", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password_hash_salt: Option<String>,
    }
    impl Properties {
        pub fn new(publishing_user_name: String) -> Self {
            Self {
                name: None,
                publishing_user_name,
                publishing_password: None,
                publishing_password_hash: None,
                publishing_password_hash_salt: None,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateProperties {
    #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
    pub server_farm_id: Option<String>,
    #[serde(rename = "skuName", default, skip_serializing_if = "Option::is_none")]
    pub sku_name: Option<String>,
    #[serde(rename = "needLinuxWorkers", default, skip_serializing_if = "Option::is_none")]
    pub need_linux_workers: Option<bool>,
    #[serde(rename = "isSpot", default, skip_serializing_if = "Option::is_none")]
    pub is_spot: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
    #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
    pub hosting_environment: Option<String>,
}
impl ValidateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidateRequest {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: validate_request::Type,
    pub location: String,
    pub properties: ValidateProperties,
}
impl ValidateRequest {
    pub fn new(name: String, type_: validate_request::Type, location: String, properties: ValidateProperties) -> Self {
        Self {
            name,
            type_,
            location,
            properties,
        }
    }
}
pub mod validate_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        ServerFarm,
        Site,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ValidateResponseError>,
}
impl ValidateResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateResponseError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ValidateResponseError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplication {
    #[serde(rename = "virtualPath", default, skip_serializing_if = "Option::is_none")]
    pub virtual_path: Option<String>,
    #[serde(rename = "physicalPath", default, skip_serializing_if = "Option::is_none")]
    pub physical_path: Option<String>,
    #[serde(rename = "preloadEnabled", default, skip_serializing_if = "Option::is_none")]
    pub preload_enabled: Option<bool>,
    #[serde(rename = "virtualDirectories", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_directories: Vec<VirtualDirectory>,
}
impl VirtualApplication {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualDirectory {
    #[serde(rename = "virtualPath", default, skip_serializing_if = "Option::is_none")]
    pub virtual_path: Option<String>,
    #[serde(rename = "physicalPath", default, skip_serializing_if = "Option::is_none")]
    pub physical_path: Option<String>,
}
impl VirtualDirectory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualIpMapping {
    #[serde(rename = "virtualIP", default, skip_serializing_if = "Option::is_none")]
    pub virtual_ip: Option<String>,
    #[serde(rename = "internalHttpPort", default, skip_serializing_if = "Option::is_none")]
    pub internal_http_port: Option<i32>,
    #[serde(rename = "internalHttpsPort", default, skip_serializing_if = "Option::is_none")]
    pub internal_https_port: Option<i32>,
    #[serde(rename = "inUse", default, skip_serializing_if = "Option::is_none")]
    pub in_use: Option<bool>,
}
impl VirtualIpMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkProfile {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<String>,
}
impl VirtualNetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetGateway {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_gateway::Properties>,
}
impl VnetGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_gateway {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_name: Option<String>,
        #[serde(rename = "vpnPackageUri")]
        pub vpn_package_uri: String,
    }
    impl Properties {
        pub fn new(vpn_package_uri: String) -> Self {
            Self {
                vnet_name: None,
                vpn_package_uri,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetInfo {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_info::Properties>,
}
impl VnetInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "vnetResourceId", default, skip_serializing_if = "Option::is_none")]
        pub vnet_resource_id: Option<String>,
        #[serde(rename = "certThumbprint", default, skip_serializing_if = "Option::is_none")]
        pub cert_thumbprint: Option<String>,
        #[serde(rename = "certBlob", default, skip_serializing_if = "Option::is_none")]
        pub cert_blob: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub routes: Vec<VnetRoute>,
        #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
        pub resync_required: Option<bool>,
        #[serde(rename = "dnsServers", default, skip_serializing_if = "Option::is_none")]
        pub dns_servers: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetParameters {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_parameters::Properties>,
}
impl VnetParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "vnetResourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub vnet_resource_group: Option<String>,
        #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_name: Option<String>,
        #[serde(rename = "vnetSubnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_subnet_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetRoute {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_route::Properties>,
}
impl VnetRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_route {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "startAddress", default, skip_serializing_if = "Option::is_none")]
        pub start_address: Option<String>,
        #[serde(rename = "endAddress", default, skip_serializing_if = "Option::is_none")]
        pub end_address: Option<String>,
        #[serde(rename = "routeType", default, skip_serializing_if = "Option::is_none")]
        pub route_type: Option<properties::RouteType>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RouteType {
            #[serde(rename = "DEFAULT")]
            Default,
            #[serde(rename = "INHERITED")]
            Inherited,
            #[serde(rename = "STATIC")]
            Static,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetValidationFailureDetails {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_validation_failure_details::Properties>,
}
impl VnetValidationFailureDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_validation_failure_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub failed: Option<bool>,
        #[serde(rename = "failedTests", default, skip_serializing_if = "Vec::is_empty")]
        pub failed_tests: Vec<VnetValidationTestFailure>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetValidationTestFailure {
    #[serde(flatten)]
    pub proxy_only_resource: ProxyOnlyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_validation_test_failure::Properties>,
}
impl VnetValidationTestFailure {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vnet_validation_test_failure {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "testName", default, skip_serializing_if = "Option::is_none")]
        pub test_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub details: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebAppCollection {
    pub value: Vec<Site>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebAppCollection {
    pub fn new(value: Vec<Site>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkerPool {
    #[serde(rename = "workerSizeId", default, skip_serializing_if = "Option::is_none")]
    pub worker_size_id: Option<i32>,
    #[serde(rename = "computeMode", default, skip_serializing_if = "Option::is_none")]
    pub compute_mode: Option<worker_pool::ComputeMode>,
    #[serde(rename = "workerSize", default, skip_serializing_if = "Option::is_none")]
    pub worker_size: Option<String>,
    #[serde(rename = "workerCount", default, skip_serializing_if = "Option::is_none")]
    pub worker_count: Option<i32>,
    #[serde(rename = "instanceNames", default, skip_serializing_if = "Vec::is_empty")]
    pub instance_names: Vec<String>,
}
impl WorkerPool {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod worker_pool {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComputeMode {
        Shared,
        Dedicated,
        Dynamic,
    }
}
