#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Address {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address1: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address2: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[serde(rename = "postalCode", default, skip_serializing_if = "Option::is_none")]
    pub postal_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}
impl Address {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressResponse {
    #[serde(rename = "serviceIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub service_ip_address: Option<String>,
    #[serde(rename = "internalIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub internal_ip_address: Option<String>,
    #[serde(rename = "outboundIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_ip_addresses: Vec<String>,
    #[serde(rename = "vipMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub vip_mappings: Vec<VirtualIpMapping>,
}
impl AddressResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiDefinitionInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl ApiDefinitionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiEntity {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<api_entity::Properties>,
}
impl ApiEntity {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod api_entity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "generalInformation", default, skip_serializing_if = "Option::is_none")]
        pub general_information: Option<GeneralApiInformation>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub path: Option<String>,
        #[serde(rename = "runtimeUrls", default, skip_serializing_if = "Vec::is_empty")]
        pub runtime_urls: Vec<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub protocols: Vec<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub policies: Option<ApiPolicies>,
        #[serde(rename = "backendService", default, skip_serializing_if = "Option::is_none")]
        pub backend_service: Option<BackendServiceDefinition>,
        #[serde(rename = "apiDefinitionUrl", default, skip_serializing_if = "Option::is_none")]
        pub api_definition_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub metadata: Option<Object>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub capabilities: Vec<String>,
        #[serde(rename = "connectionParameters", default, skip_serializing_if = "Option::is_none")]
        pub connection_parameters: Option<serde_json::Value>,
        #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
        pub created_time: Option<String>,
        #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
        pub changed_time: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiOAuthSettings {
    #[serde(rename = "identityProvider", default, skip_serializing_if = "Option::is_none")]
    pub identity_provider: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub scopes: Vec<String>,
    #[serde(rename = "redirectUrl", default, skip_serializing_if = "Option::is_none")]
    pub redirect_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Object>,
    #[serde(rename = "customParameters", default, skip_serializing_if = "Option::is_none")]
    pub custom_parameters: Option<serde_json::Value>,
}
impl ApiOAuthSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiOAuthSettingsParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<Object>,
    #[serde(rename = "uiDefinition", default, skip_serializing_if = "Option::is_none")]
    pub ui_definition: Option<Object>,
}
impl ApiOAuthSettingsParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApiPolicies {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<api_policies::Properties>,
}
impl ApiPolicies {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod api_policies {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub content: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApisCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApiEntity>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApisCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationLogsConfig {
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<FileSystemApplicationLogsConfig>,
    #[serde(rename = "azureTableStorage", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_storage: Option<AzureTableStorageApplicationLogsConfig>,
    #[serde(rename = "azureBlobStorage", default, skip_serializing_if = "Option::is_none")]
    pub azure_blob_storage: Option<AzureBlobStorageApplicationLogsConfig>,
}
impl ApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArmPlan {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub product: Option<String>,
    #[serde(rename = "promotionCode", default, skip_serializing_if = "Option::is_none")]
    pub promotion_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl ArmPlan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoHealActions {
    #[serde(rename = "actionType")]
    pub action_type: auto_heal_actions::ActionType,
    #[serde(rename = "customAction", default, skip_serializing_if = "Option::is_none")]
    pub custom_action: Option<AutoHealCustomAction>,
    #[serde(rename = "minProcessExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub min_process_execution_time: Option<String>,
}
impl AutoHealActions {
    pub fn new(action_type: auto_heal_actions::ActionType) -> Self {
        Self {
            action_type,
            custom_action: None,
            min_process_execution_time: None,
        }
    }
}
pub mod auto_heal_actions {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActionType {
        Recycle,
        LogEvent,
        CustomAction,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealCustomAction {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exe: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<String>,
}
impl AutoHealCustomAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealRules {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub triggers: Option<AutoHealTriggers>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub actions: Option<AutoHealActions>,
}
impl AutoHealRules {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoHealTriggers {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub requests: Option<RequestsBasedTrigger>,
    #[serde(rename = "privateBytesInKB", default, skip_serializing_if = "Option::is_none")]
    pub private_bytes_in_kb: Option<i32>,
    #[serde(rename = "statusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub status_codes: Vec<StatusCodesBasedTrigger>,
    #[serde(rename = "slowRequests", default, skip_serializing_if = "Option::is_none")]
    pub slow_requests: Option<SlowRequestsBasedTrigger>,
}
impl AutoHealTriggers {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobStorageApplicationLogsConfig {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<azure_blob_storage_application_logs_config::Level>,
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
    #[serde(rename = "retentionInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_days: Option<i32>,
}
impl AzureBlobStorageApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_blob_storage_application_logs_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Off,
        Verbose,
        Information,
        Warning,
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobStorageHttpLogsConfig {
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
    #[serde(rename = "retentionInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_days: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl AzureBlobStorageHttpLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureTableStorageApplicationLogsConfig {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<azure_table_storage_application_logs_config::Level>,
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
}
impl AzureTableStorageApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_table_storage_application_logs_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Off,
        Verbose,
        Information,
        Warning,
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackendServiceDefinition {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<backend_service_definition::Properties>,
}
impl BackendServiceDefinition {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod backend_service_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
        pub service_url: Option<String>,
        #[serde(rename = "hostingEnvironmentServiceUrls", default, skip_serializing_if = "Vec::is_empty")]
        pub hosting_environment_service_urls: Vec<HostingEnvironmentServiceDescriptions>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<backup_item::Properties>,
}
impl BackupItem {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod backup_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<i32>,
        #[serde(rename = "storageAccountUrl", default, skip_serializing_if = "Option::is_none")]
        pub storage_account_url: Option<String>,
        #[serde(rename = "blobName", default, skip_serializing_if = "Option::is_none")]
        pub blob_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        pub status: properties::Status,
        #[serde(rename = "sizeInBytes", default, skip_serializing_if = "Option::is_none")]
        pub size_in_bytes: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub created: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub log: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub databases: Vec<DatabaseBackupSetting>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub scheduled: Option<bool>,
        #[serde(rename = "lastRestoreTimeStamp", default, skip_serializing_if = "Option::is_none")]
        pub last_restore_time_stamp: Option<String>,
        #[serde(rename = "finishedTimeStamp", default, skip_serializing_if = "Option::is_none")]
        pub finished_time_stamp: Option<String>,
        #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
        pub correlation_id: Option<String>,
        #[serde(rename = "websiteSizeInBytes", default, skip_serializing_if = "Option::is_none")]
        pub website_size_in_bytes: Option<i64>,
    }
    impl Properties {
        pub fn new(status: properties::Status) -> Self {
            Self {
                id: None,
                storage_account_url: None,
                blob_name: None,
                name: None,
                status,
                size_in_bytes: None,
                created: None,
                log: None,
                databases: Vec::new(),
                scheduled: None,
                last_restore_time_stamp: None,
                finished_time_stamp: None,
                correlation_id: None,
                website_size_in_bytes: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            InProgress,
            Failed,
            Succeeded,
            TimedOut,
            Created,
            Skipped,
            PartiallySucceeded,
            DeleteInProgress,
            DeleteFailed,
            Deleted,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupItemCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackupItem>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BackupItemCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupRequest {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<backup_request::Properties>,
}
impl BackupRequest {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod backup_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "storageAccountUrl", default, skip_serializing_if = "Option::is_none")]
        pub storage_account_url: Option<String>,
        #[serde(rename = "backupSchedule", default, skip_serializing_if = "Option::is_none")]
        pub backup_schedule: Option<BackupSchedule>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub databases: Vec<DatabaseBackupSetting>,
        #[serde(rename = "type")]
        pub type_: properties::Type,
    }
    impl Properties {
        pub fn new(type_: properties::Type) -> Self {
            Self {
                name: None,
                enabled: None,
                storage_account_url: None,
                backup_schedule: None,
                databases: Vec::new(),
                type_,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Type {
            Default,
            Clone,
            Relocation,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupSchedule {
    #[serde(rename = "frequencyInterval", default, skip_serializing_if = "Option::is_none")]
    pub frequency_interval: Option<i32>,
    #[serde(rename = "frequencyUnit")]
    pub frequency_unit: backup_schedule::FrequencyUnit,
    #[serde(rename = "keepAtLeastOneBackup", default, skip_serializing_if = "Option::is_none")]
    pub keep_at_least_one_backup: Option<bool>,
    #[serde(rename = "retentionPeriodInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_period_in_days: Option<i32>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "lastExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub last_execution_time: Option<String>,
}
impl BackupSchedule {
    pub fn new(frequency_unit: backup_schedule::FrequencyUnit) -> Self {
        Self {
            frequency_interval: None,
            frequency_unit,
            keep_at_least_one_backup: None,
            retention_period_in_days: None,
            start_time: None,
            last_execution_time: None,
        }
    }
}
pub mod backup_schedule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FrequencyUnit {
        Day,
        Hour,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Certificate {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate::Properties>,
}
impl Certificate {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod certificate {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
        pub friendly_name: Option<String>,
        #[serde(rename = "subjectName", default, skip_serializing_if = "Option::is_none")]
        pub subject_name: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "pfxBlob", default, skip_serializing_if = "Option::is_none")]
        pub pfx_blob: Option<String>,
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[serde(rename = "selfLink", default, skip_serializing_if = "Option::is_none")]
        pub self_link: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub issuer: Option<String>,
        #[serde(rename = "issueDate", default, skip_serializing_if = "Option::is_none")]
        pub issue_date: Option<String>,
        #[serde(rename = "expirationDate", default, skip_serializing_if = "Option::is_none")]
        pub expiration_date: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub password: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub valid: Option<bool>,
        #[serde(rename = "cerBlob", default, skip_serializing_if = "Option::is_none")]
        pub cer_blob: Option<String>,
        #[serde(rename = "publicKeyHash", default, skip_serializing_if = "Option::is_none")]
        pub public_key_hash: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Certificate>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CertificateCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateDetails {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate_details::Properties>,
}
impl CertificateDetails {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod certificate_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub version: Option<i32>,
        #[serde(rename = "serialNumber", default, skip_serializing_if = "Option::is_none")]
        pub serial_number: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub thumbprint: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subject: Option<String>,
        #[serde(rename = "notBefore", default, skip_serializing_if = "Option::is_none")]
        pub not_before: Option<String>,
        #[serde(rename = "notAfter", default, skip_serializing_if = "Option::is_none")]
        pub not_after: Option<String>,
        #[serde(rename = "signatureAlgorithm", default, skip_serializing_if = "Option::is_none")]
        pub signature_algorithm: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub issuer: Option<String>,
        #[serde(rename = "rawData", default, skip_serializing_if = "Option::is_none")]
        pub raw_data: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateEmail {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate_email::Properties>,
}
impl CertificateEmail {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod certificate_email {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "emailId", default, skip_serializing_if = "Option::is_none")]
        pub email_id: Option<String>,
        #[serde(rename = "timeStamp", default, skip_serializing_if = "Option::is_none")]
        pub time_stamp: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateOrder {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate_order::Properties>,
}
impl CertificateOrder {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod certificate_order {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub certificates: Option<serde_json::Value>,
        #[serde(rename = "distinguishedName", default, skip_serializing_if = "Option::is_none")]
        pub distinguished_name: Option<String>,
        #[serde(rename = "domainVerificationToken", default, skip_serializing_if = "Option::is_none")]
        pub domain_verification_token: Option<String>,
        #[serde(rename = "validityInYears", default, skip_serializing_if = "Option::is_none")]
        pub validity_in_years: Option<i32>,
        #[serde(rename = "keySize", default, skip_serializing_if = "Option::is_none")]
        pub key_size: Option<i32>,
        #[serde(rename = "productType", default, skip_serializing_if = "Option::is_none")]
        pub product_type: Option<properties::ProductType>,
        #[serde(rename = "autoRenew", default, skip_serializing_if = "Option::is_none")]
        pub auto_renew: Option<bool>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<properties::Status>,
        #[serde(rename = "signedCertificate", default, skip_serializing_if = "Option::is_none")]
        pub signed_certificate: Option<CertificateDetails>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub csr: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub intermediate: Option<CertificateDetails>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub root: Option<CertificateDetails>,
        #[serde(rename = "serialNumber", default, skip_serializing_if = "Option::is_none")]
        pub serial_number: Option<String>,
        #[serde(rename = "lastCertificateIssuanceTime", default, skip_serializing_if = "Option::is_none")]
        pub last_certificate_issuance_time: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProductType {
            StandardDomainValidatedSsl,
            StandardDomainValidatedWildCardSsl,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Pendingissuance,
            Issued,
            Revoked,
            Canceled,
            Denied,
            Pendingrevocation,
            PendingRekey,
            Unused,
            Expired,
            NotSubmitted,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateOrderAction {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate_order_action::Properties>,
}
impl CertificateOrderAction {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod certificate_order_action {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "type")]
        pub type_: properties::Type,
        #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
        pub created_at: Option<String>,
    }
    impl Properties {
        pub fn new(type_: properties::Type) -> Self {
            Self { type_, created_at: None }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Type {
            CertificateIssued,
            CertificateOrderCanceled,
            CertificateOrderCreated,
            CertificateRevoked,
            DomainValidationComplete,
            FraudDetected,
            OrgNameChange,
            OrgValidationComplete,
            SanDrop,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateOrderCertificate {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<certificate_order_certificate::Properties>,
}
impl CertificateOrderCertificate {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod certificate_order_certificate {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_id: Option<String>,
        #[serde(rename = "keyVaultSecretName", default, skip_serializing_if = "Option::is_none")]
        pub key_vault_secret_name: Option<String>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Initialized,
            WaitingOnCertificateOrder,
            Succeeded,
            CertificateOrderFailed,
            OperationNotPermittedOnKeyVault,
            AzureServiceUnauthorizedToAccessKeyVault,
            KeyVaultDoesNotExist,
            KeyVaultSecretDoesNotExist,
            UnknownError,
            Unknown,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateOrderCertificateCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CertificateOrderCertificate>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CertificateOrderCertificateCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateOrderCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CertificateOrder>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CertificateOrderCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ClassicMobileService {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<classic_mobile_service::Properties>,
}
impl ClassicMobileService {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod classic_mobile_service {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClassicMobileServiceCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ClassicMobileService>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ClassicMobileServiceCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloningInfo {
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub overwrite: Option<bool>,
    #[serde(rename = "cloneCustomHostNames", default, skip_serializing_if = "Option::is_none")]
    pub clone_custom_host_names: Option<bool>,
    #[serde(rename = "cloneSourceControl", default, skip_serializing_if = "Option::is_none")]
    pub clone_source_control: Option<bool>,
    #[serde(rename = "sourceWebAppId", default, skip_serializing_if = "Option::is_none")]
    pub source_web_app_id: Option<String>,
    #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
    pub hosting_environment: Option<String>,
    #[serde(rename = "appSettingsOverrides", default, skip_serializing_if = "Option::is_none")]
    pub app_settings_overrides: Option<serde_json::Value>,
    #[serde(rename = "configureLoadBalancing", default, skip_serializing_if = "Option::is_none")]
    pub configure_load_balancing: Option<bool>,
    #[serde(rename = "trafficManagerProfileId", default, skip_serializing_if = "Option::is_none")]
    pub traffic_manager_profile_id: Option<String>,
    #[serde(rename = "trafficManagerProfileName", default, skip_serializing_if = "Option::is_none")]
    pub traffic_manager_profile_name: Option<String>,
}
impl CloningInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConfirmConsentCodeInput {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<confirm_consent_code_input::Properties>,
}
impl ConfirmConsentCodeInput {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod confirm_consent_code_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "principalType", default, skip_serializing_if = "Option::is_none")]
        pub principal_type: Option<properties::PrincipalType>,
        #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
        pub tenant_id: Option<String>,
        #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
        pub object_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub code: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum PrincipalType {
            ActiveDirectory,
            Connection,
            MicrosoftAccount,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnStringInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
    #[serde(rename = "type")]
    pub type_: conn_string_info::Type,
}
impl ConnStringInfo {
    pub fn new(type_: conn_string_info::Type) -> Self {
        Self {
            name: None,
            connection_string: None,
            type_,
        }
    }
}
pub mod conn_string_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        MySql,
        #[serde(rename = "SQLServer")]
        SqlServer,
        #[serde(rename = "SQLAzure")]
        SqlAzure,
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnStringValueTypePair {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "type")]
    pub type_: conn_string_value_type_pair::Type,
}
impl ConnStringValueTypePair {
    pub fn new(type_: conn_string_value_type_pair::Type) -> Self {
        Self { value: None, type_ }
    }
}
pub mod conn_string_value_type_pair {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        MySql,
        #[serde(rename = "SQLServer")]
        SqlServer,
        #[serde(rename = "SQLAzure")]
        SqlAzure,
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Connection {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<connection::Properties>,
}
impl Connection {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod connection {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub statuses: Vec<ConnectionStatus>,
        #[serde(rename = "customParameterValues", default, skip_serializing_if = "Option::is_none")]
        pub custom_parameter_values: Option<serde_json::Value>,
        #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
        pub tenant_id: Option<String>,
        #[serde(rename = "parameterValues", default, skip_serializing_if = "Option::is_none")]
        pub parameter_values: Option<serde_json::Value>,
        #[serde(rename = "nonSecretParameterValues", default, skip_serializing_if = "Option::is_none")]
        pub non_secret_parameter_values: Option<serde_json::Value>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub metadata: Option<Object>,
        #[serde(rename = "firstExpirationTime", default, skip_serializing_if = "Option::is_none")]
        pub first_expiration_time: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub keywords: Vec<String>,
        #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
        pub created_time: Option<String>,
        #[serde(rename = "changedTime", default, skip_serializing_if = "Option::is_none")]
        pub changed_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub api: Option<ExpandedParentApiEntity>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Connection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ConnectionCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionError {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<connection_error::Properties>,
}
impl ConnectionError {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod connection_error {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub code: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionParameter {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connection_parameter::Type>,
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<Object>,
    #[serde(rename = "oAuthSettings", default, skip_serializing_if = "Option::is_none")]
    pub o_auth_settings: Option<ApiOAuthSettings>,
    #[serde(rename = "uiDefinition", default, skip_serializing_if = "Option::is_none")]
    pub ui_definition: Option<Object>,
}
impl ConnectionParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "string")]
        String,
        #[serde(rename = "securestring")]
        Securestring,
        #[serde(rename = "secureobject")]
        Secureobject,
        #[serde(rename = "int")]
        Int,
        #[serde(rename = "bool")]
        Bool,
        #[serde(rename = "object")]
        Object,
        #[serde(rename = "array")]
        Array,
        #[serde(rename = "oauthSetting")]
        OauthSetting,
        #[serde(rename = "connection")]
        Connection,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionSecrets {
    #[serde(rename = "parameterValues", default, skip_serializing_if = "Option::is_none")]
    pub parameter_values: Option<serde_json::Value>,
    #[serde(rename = "connectionKey", default, skip_serializing_if = "Option::is_none")]
    pub connection_key: Option<String>,
}
impl ConnectionSecrets {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionStatus {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<connection_status::Properties>,
}
impl ConnectionStatus {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod connection_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub target: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub error: Option<ConnectionError>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionStringDictionary {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl ConnectionStringDictionary {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConsentLink {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[serde(rename = "firstPartyLoginUri", default, skip_serializing_if = "Option::is_none")]
    pub first_party_login_uri: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<consent_link::Status>,
}
impl ConsentLink {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod consent_link {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Unauthenticated,
        Authenticated,
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsentLinkInput {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<consent_link_input::Properties>,
}
impl ConsentLinkInput {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod consent_link_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub parameters: Vec<ConsentLinkInputParameter>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConsentLinkInputParameter {
    #[serde(rename = "principalType", default, skip_serializing_if = "Option::is_none")]
    pub principal_type: Option<consent_link_input_parameter::PrincipalType>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[serde(rename = "parameterName", default, skip_serializing_if = "Option::is_none")]
    pub parameter_name: Option<String>,
    #[serde(rename = "redirectUrl", default, skip_serializing_if = "Option::is_none")]
    pub redirect_url: Option<String>,
}
impl ConsentLinkInputParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod consent_link_input_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrincipalType {
        ActiveDirectory,
        Connection,
        MicrosoftAccount,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConsentLinkPayload {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConsentLink>,
}
impl ConsentLinkPayload {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Contact {
    #[serde(rename = "addressMailing", default, skip_serializing_if = "Option::is_none")]
    pub address_mailing: Option<Address>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fax: Option<String>,
    #[serde(rename = "jobTitle", default, skip_serializing_if = "Option::is_none")]
    pub job_title: Option<String>,
    #[serde(rename = "nameFirst", default, skip_serializing_if = "Option::is_none")]
    pub name_first: Option<String>,
    #[serde(rename = "nameLast", default, skip_serializing_if = "Option::is_none")]
    pub name_last: Option<String>,
    #[serde(rename = "nameMiddle", default, skip_serializing_if = "Option::is_none")]
    pub name_middle: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub organization: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,
}
impl Contact {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CorsSettings {
    #[serde(rename = "allowedOrigins", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_origins: Vec<String>,
}
impl CorsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmMoveResourceEnvelope {
    #[serde(rename = "targetResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<String>,
}
impl CsmMoveResourceEnvelope {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmPublishingProfileOptions {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<String>,
}
impl CsmPublishingProfileOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmSiteRecoveryEntity {
    #[serde(rename = "snapshotTime", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_time: Option<String>,
    #[serde(rename = "recoverConfig", default, skip_serializing_if = "Option::is_none")]
    pub recover_config: Option<bool>,
    #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
    pub site_name: Option<String>,
    #[serde(rename = "slotName", default, skip_serializing_if = "Option::is_none")]
    pub slot_name: Option<String>,
}
impl CsmSiteRecoveryEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmSlotEntity {
    #[serde(rename = "targetSlot", default, skip_serializing_if = "Option::is_none")]
    pub target_slot: Option<String>,
    #[serde(rename = "preserveVnet", default, skip_serializing_if = "Option::is_none")]
    pub preserve_vnet: Option<bool>,
}
impl CsmSlotEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmUsageQuota {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
    pub next_reset_time: Option<String>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<LocalizableString>,
}
impl CsmUsageQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CsmUsageQuotaCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CsmUsageQuota>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CsmUsageQuotaCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Csr {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<csr::Properties>,
}
impl Csr {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod csr {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "distinguishedName", default, skip_serializing_if = "Option::is_none")]
        pub distinguished_name: Option<String>,
        #[serde(rename = "csrString", default, skip_serializing_if = "Option::is_none")]
        pub csr_string: Option<String>,
        #[serde(rename = "pfxBlob", default, skip_serializing_if = "Option::is_none")]
        pub pfx_blob: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub password: Option<String>,
        #[serde(rename = "publicKeyHash", default, skip_serializing_if = "Option::is_none")]
        pub public_key_hash: Option<String>,
        #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomLoginSettingValue {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<custom_login_setting_value::Properties>,
}
impl CustomLoginSettingValue {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod custom_login_setting_value {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub option: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseBackupSetting {
    #[serde(rename = "databaseType", default, skip_serializing_if = "Option::is_none")]
    pub database_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "connectionStringName", default, skip_serializing_if = "Option::is_none")]
    pub connection_string_name: Option<String>,
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
}
impl DatabaseBackupSetting {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeletedSite {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<deleted_site::Properties>,
}
impl DeletedSite {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod deleted_site {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "deletedTimestamp", default, skip_serializing_if = "Option::is_none")]
        pub deleted_timestamp: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "repositorySiteName", default, skip_serializing_if = "Option::is_none")]
        pub repository_site_name: Option<String>,
        #[serde(rename = "usageState")]
        pub usage_state: properties::UsageState,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "enabledHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub enabled_host_names: Vec<String>,
        #[serde(rename = "availabilityState")]
        pub availability_state: properties::AvailabilityState,
        #[serde(rename = "hostNameSslStates", default, skip_serializing_if = "Vec::is_empty")]
        pub host_name_ssl_states: Vec<HostNameSslState>,
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
        #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
        pub last_modified_time_utc: Option<String>,
        #[serde(rename = "siteConfig", default, skip_serializing_if = "Option::is_none")]
        pub site_config: Option<SiteConfig>,
        #[serde(rename = "trafficManagerHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub traffic_manager_host_names: Vec<String>,
        #[serde(rename = "premiumAppDeployed", default, skip_serializing_if = "Option::is_none")]
        pub premium_app_deployed: Option<bool>,
        #[serde(rename = "scmSiteAlsoStopped", default, skip_serializing_if = "Option::is_none")]
        pub scm_site_also_stopped: Option<bool>,
        #[serde(rename = "targetSwapSlot", default, skip_serializing_if = "Option::is_none")]
        pub target_swap_slot: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "microService", default, skip_serializing_if = "Option::is_none")]
        pub micro_service: Option<String>,
        #[serde(rename = "gatewaySiteName", default, skip_serializing_if = "Option::is_none")]
        pub gateway_site_name: Option<String>,
        #[serde(rename = "clientAffinityEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_affinity_enabled: Option<bool>,
        #[serde(rename = "clientCertEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_cert_enabled: Option<bool>,
        #[serde(rename = "hostNamesDisabled", default, skip_serializing_if = "Option::is_none")]
        pub host_names_disabled: Option<bool>,
        #[serde(rename = "outboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub outbound_ip_addresses: Option<String>,
        #[serde(rename = "containerSize", default, skip_serializing_if = "Option::is_none")]
        pub container_size: Option<i32>,
        #[serde(rename = "maxNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub max_number_of_workers: Option<i32>,
        #[serde(rename = "cloningInfo", default, skip_serializing_if = "Option::is_none")]
        pub cloning_info: Option<CloningInfo>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(rename = "isDefaultContainer", default, skip_serializing_if = "Option::is_none")]
        pub is_default_container: Option<bool>,
        #[serde(rename = "defaultHostName", default, skip_serializing_if = "Option::is_none")]
        pub default_host_name: Option<String>,
    }
    impl Properties {
        pub fn new(usage_state: properties::UsageState, availability_state: properties::AvailabilityState) -> Self {
            Self {
                deleted_timestamp: None,
                name: None,
                state: None,
                host_names: Vec::new(),
                repository_site_name: None,
                usage_state,
                enabled: None,
                enabled_host_names: Vec::new(),
                availability_state,
                host_name_ssl_states: Vec::new(),
                server_farm_id: None,
                last_modified_time_utc: None,
                site_config: None,
                traffic_manager_host_names: Vec::new(),
                premium_app_deployed: None,
                scm_site_also_stopped: None,
                target_swap_slot: None,
                hosting_environment_profile: None,
                micro_service: None,
                gateway_site_name: None,
                client_affinity_enabled: None,
                client_cert_enabled: None,
                host_names_disabled: None,
                outbound_ip_addresses: None,
                container_size: None,
                max_number_of_workers: None,
                cloning_info: None,
                resource_group: None,
                is_default_container: None,
                default_host_name: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum UsageState {
            Normal,
            Exceeded,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AvailabilityState {
            Normal,
            Limited,
            DisasterRecoveryMode,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeletedSiteCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DeletedSite>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DeletedSiteCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Deployment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<deployment::Properties>,
}
impl Deployment {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod deployment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<i32>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub author: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub deployer: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub author_email: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub active: Option<bool>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub details: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Deployment>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DeploymentCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Domain {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<domain::Properties>,
}
impl Domain {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod domain {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "contactAdmin", default, skip_serializing_if = "Option::is_none")]
        pub contact_admin: Option<Contact>,
        #[serde(rename = "contactBilling", default, skip_serializing_if = "Option::is_none")]
        pub contact_billing: Option<Contact>,
        #[serde(rename = "contactRegistrant", default, skip_serializing_if = "Option::is_none")]
        pub contact_registrant: Option<Contact>,
        #[serde(rename = "contactTech", default, skip_serializing_if = "Option::is_none")]
        pub contact_tech: Option<Contact>,
        #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
        pub registration_status: Option<properties::RegistrationStatus>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[serde(rename = "nameServers", default, skip_serializing_if = "Vec::is_empty")]
        pub name_servers: Vec<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub privacy: Option<bool>,
        #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
        pub created_time: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
        #[serde(rename = "lastRenewedTime", default, skip_serializing_if = "Option::is_none")]
        pub last_renewed_time: Option<String>,
        #[serde(rename = "autoRenew", default, skip_serializing_if = "Option::is_none")]
        pub auto_renew: Option<bool>,
        #[serde(rename = "readyForDnsRecordManagement", default, skip_serializing_if = "Option::is_none")]
        pub ready_for_dns_record_management: Option<bool>,
        #[serde(rename = "managedHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub managed_host_names: Vec<HostName>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub consent: Option<DomainPurchaseConsent>,
        #[serde(rename = "domainNotRenewableReasons", default, skip_serializing_if = "Vec::is_empty")]
        pub domain_not_renewable_reasons: Vec<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RegistrationStatus {
            Active,
            Awaiting,
            Cancelled,
            Confiscated,
            Disabled,
            Excluded,
            Expired,
            Failed,
            Held,
            Locked,
            Parked,
            Pending,
            Reserved,
            Reverted,
            Suspended,
            Transferred,
            Unknown,
            Unlocked,
            Unparked,
            Updated,
            JsonConverterFailed,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainAvailablilityCheckResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
    #[serde(rename = "domainType", default, skip_serializing_if = "Option::is_none")]
    pub domain_type: Option<domain_availablility_check_result::DomainType>,
}
impl DomainAvailablilityCheckResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod domain_availablility_check_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DomainType {
        Regular,
        SoftDeleted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Domain>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DomainCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainControlCenterSsoRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "postParameterKey", default, skip_serializing_if = "Option::is_none")]
    pub post_parameter_key: Option<String>,
    #[serde(rename = "postParameterValue", default, skip_serializing_if = "Option::is_none")]
    pub post_parameter_value: Option<String>,
}
impl DomainControlCenterSsoRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainPurchaseConsent {
    #[serde(rename = "agreementKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub agreement_keys: Vec<String>,
    #[serde(rename = "agreedBy", default, skip_serializing_if = "Option::is_none")]
    pub agreed_by: Option<String>,
    #[serde(rename = "agreedAt", default, skip_serializing_if = "Option::is_none")]
    pub agreed_at: Option<String>,
}
impl DomainPurchaseConsent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DomainRecommendationSearchParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keywords: Option<String>,
    #[serde(rename = "maxDomainRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub max_domain_recommendations: Option<i32>,
}
impl DomainRecommendationSearchParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DomainRegistrationInput {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<domain_registration_input::Properties>,
}
impl DomainRegistrationInput {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod domain_registration_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "contactAdmin", default, skip_serializing_if = "Option::is_none")]
        pub contact_admin: Option<Contact>,
        #[serde(rename = "contactBilling", default, skip_serializing_if = "Option::is_none")]
        pub contact_billing: Option<Contact>,
        #[serde(rename = "contactRegistrant", default, skip_serializing_if = "Option::is_none")]
        pub contact_registrant: Option<Contact>,
        #[serde(rename = "contactTech", default, skip_serializing_if = "Option::is_none")]
        pub contact_tech: Option<Contact>,
        #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
        pub registration_status: Option<properties::RegistrationStatus>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[serde(rename = "nameServers", default, skip_serializing_if = "Vec::is_empty")]
        pub name_servers: Vec<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub privacy: Option<bool>,
        #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
        pub created_time: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
        #[serde(rename = "lastRenewedTime", default, skip_serializing_if = "Option::is_none")]
        pub last_renewed_time: Option<String>,
        #[serde(rename = "autoRenew", default, skip_serializing_if = "Option::is_none")]
        pub auto_renew: Option<bool>,
        #[serde(rename = "readyForDnsRecordManagement", default, skip_serializing_if = "Option::is_none")]
        pub ready_for_dns_record_management: Option<bool>,
        #[serde(rename = "managedHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub managed_host_names: Vec<HostName>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub consent: Option<DomainPurchaseConsent>,
        #[serde(rename = "domainNotRenewableReasons", default, skip_serializing_if = "Vec::is_empty")]
        pub domain_not_renewable_reasons: Vec<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum RegistrationStatus {
            Active,
            Awaiting,
            Cancelled,
            Confiscated,
            Disabled,
            Excluded,
            Expired,
            Failed,
            Held,
            Locked,
            Parked,
            Pending,
            Reserved,
            Reverted,
            Suspended,
            Transferred,
            Unknown,
            Unlocked,
            Unparked,
            Updated,
            JsonConverterFailed,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnabledConfig {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl EnabledConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpandedParentApiEntity {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<expanded_parent_api_entity::Properties>,
}
impl ExpandedParentApiEntity {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod expanded_parent_api_entity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub entity: Option<ResponseMessageEnvelopeApiEntity>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Experiments {
    #[serde(rename = "rampUpRules", default, skip_serializing_if = "Vec::is_empty")]
    pub ramp_up_rules: Vec<RampUpRule>,
}
impl Experiments {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileSystemApplicationLogsConfig {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<file_system_application_logs_config::Level>,
}
impl FileSystemApplicationLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod file_system_application_logs_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Off,
        Verbose,
        Information,
        Warning,
        Error,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileSystemHttpLogsConfig {
    #[serde(rename = "retentionInMb", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_mb: Option<i32>,
    #[serde(rename = "retentionInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_in_days: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl FileSystemHttpLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GeneralApiInformation {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<general_api_information::Properties>,
}
impl GeneralApiInformation {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod general_api_information {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "iconUrl", default, skip_serializing_if = "Option::is_none")]
        pub icon_url: Option<String>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(rename = "termsOfUseUrl", default, skip_serializing_if = "Option::is_none")]
        pub terms_of_use_url: Option<String>,
        #[serde(rename = "connectionDisplayName", default, skip_serializing_if = "Option::is_none")]
        pub connection_display_name: Option<String>,
        #[serde(rename = "connectionPortalUrl", default, skip_serializing_if = "Option::is_none")]
        pub connection_portal_url: Option<Object>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GeoRegion {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<geo_region::Properties>,
}
impl GeoRegion {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod geo_region {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GeoRegionCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GeoRegion>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GeoRegionCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HandlerMapping {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub extension: Option<String>,
    #[serde(rename = "scriptProcessor", default, skip_serializing_if = "Option::is_none")]
    pub script_processor: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub arguments: Option<String>,
}
impl HandlerMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "siteNames", default, skip_serializing_if = "Vec::is_empty")]
    pub site_names: Vec<String>,
    #[serde(rename = "azureResourceName", default, skip_serializing_if = "Option::is_none")]
    pub azure_resource_name: Option<String>,
    #[serde(rename = "azureResourceType", default, skip_serializing_if = "Option::is_none")]
    pub azure_resource_type: Option<host_name::AzureResourceType>,
    #[serde(rename = "customHostNameDnsRecordType", default, skip_serializing_if = "Option::is_none")]
    pub custom_host_name_dns_record_type: Option<host_name::CustomHostNameDnsRecordType>,
    #[serde(rename = "hostNameType", default, skip_serializing_if = "Option::is_none")]
    pub host_name_type: Option<host_name::HostNameType>,
}
impl HostName {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod host_name {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureResourceType {
        Website,
        TrafficManager,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CustomHostNameDnsRecordType {
        CName,
        A,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HostNameType {
        Verified,
        Managed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HostNameBinding {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<host_name_binding::Properties>,
}
impl HostNameBinding {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod host_name_binding {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[serde(rename = "domainId", default, skip_serializing_if = "Option::is_none")]
        pub domain_id: Option<String>,
        #[serde(rename = "azureResourceName", default, skip_serializing_if = "Option::is_none")]
        pub azure_resource_name: Option<String>,
        #[serde(rename = "azureResourceType", default, skip_serializing_if = "Option::is_none")]
        pub azure_resource_type: Option<properties::AzureResourceType>,
        #[serde(rename = "customHostNameDnsRecordType", default, skip_serializing_if = "Option::is_none")]
        pub custom_host_name_dns_record_type: Option<properties::CustomHostNameDnsRecordType>,
        #[serde(rename = "hostNameType", default, skip_serializing_if = "Option::is_none")]
        pub host_name_type: Option<properties::HostNameType>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AzureResourceType {
            Website,
            TrafficManager,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum CustomHostNameDnsRecordType {
            CName,
            A,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum HostNameType {
            Verified,
            Managed,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostNameBindingCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HostNameBinding>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl HostNameBindingCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HostNameSslState {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "sslState")]
    pub ssl_state: host_name_ssl_state::SslState,
    #[serde(rename = "virtualIP", default, skip_serializing_if = "Option::is_none")]
    pub virtual_ip: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(rename = "toUpdate", default, skip_serializing_if = "Option::is_none")]
    pub to_update: Option<bool>,
}
impl HostNameSslState {
    pub fn new(ssl_state: host_name_ssl_state::SslState) -> Self {
        Self {
            name: None,
            ssl_state,
            virtual_ip: None,
            thumbprint: None,
            to_update: None,
        }
    }
}
pub mod host_name_ssl_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SslState {
        Disabled,
        SniEnabled,
        IpBasedEnabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HostingEnvironment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<hosting_environment::Properties>,
}
impl HostingEnvironment {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod hosting_environment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub location: Option<String>,
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        pub status: properties::Status,
        #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_name: Option<String>,
        #[serde(rename = "vnetResourceGroupName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_resource_group_name: Option<String>,
        #[serde(rename = "vnetSubnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_subnet_name: Option<String>,
        #[serde(rename = "virtualNetwork", default, skip_serializing_if = "Option::is_none")]
        pub virtual_network: Option<VirtualNetworkProfile>,
        #[serde(rename = "internalLoadBalancingMode", default, skip_serializing_if = "Option::is_none")]
        pub internal_load_balancing_mode: Option<properties::InternalLoadBalancingMode>,
        #[serde(rename = "multiSize", default, skip_serializing_if = "Option::is_none")]
        pub multi_size: Option<String>,
        #[serde(rename = "multiRoleCount", default, skip_serializing_if = "Option::is_none")]
        pub multi_role_count: Option<i32>,
        #[serde(rename = "workerPools", default, skip_serializing_if = "Vec::is_empty")]
        pub worker_pools: Vec<WorkerPool>,
        #[serde(rename = "ipsslAddressCount", default, skip_serializing_if = "Option::is_none")]
        pub ipssl_address_count: Option<i32>,
        #[serde(rename = "databaseEdition", default, skip_serializing_if = "Option::is_none")]
        pub database_edition: Option<String>,
        #[serde(rename = "databaseServiceObjective", default, skip_serializing_if = "Option::is_none")]
        pub database_service_objective: Option<String>,
        #[serde(rename = "upgradeDomains", default, skip_serializing_if = "Option::is_none")]
        pub upgrade_domains: Option<i32>,
        #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
        pub subscription_id: Option<String>,
        #[serde(rename = "dnsSuffix", default, skip_serializing_if = "Option::is_none")]
        pub dns_suffix: Option<String>,
        #[serde(rename = "lastAction", default, skip_serializing_if = "Option::is_none")]
        pub last_action: Option<String>,
        #[serde(rename = "lastActionResult", default, skip_serializing_if = "Option::is_none")]
        pub last_action_result: Option<String>,
        #[serde(rename = "allowedMultiSizes", default, skip_serializing_if = "Option::is_none")]
        pub allowed_multi_sizes: Option<String>,
        #[serde(rename = "allowedWorkerSizes", default, skip_serializing_if = "Option::is_none")]
        pub allowed_worker_sizes: Option<String>,
        #[serde(rename = "maximumNumberOfMachines", default, skip_serializing_if = "Option::is_none")]
        pub maximum_number_of_machines: Option<i32>,
        #[serde(rename = "vipMappings", default, skip_serializing_if = "Vec::is_empty")]
        pub vip_mappings: Vec<VirtualIpMapping>,
        #[serde(rename = "environmentCapacities", default, skip_serializing_if = "Vec::is_empty")]
        pub environment_capacities: Vec<StampCapacity>,
        #[serde(rename = "networkAccessControlList", default, skip_serializing_if = "Vec::is_empty")]
        pub network_access_control_list: Vec<NetworkAccessControlEntry>,
        #[serde(rename = "environmentIsHealthy", default, skip_serializing_if = "Option::is_none")]
        pub environment_is_healthy: Option<bool>,
        #[serde(rename = "environmentStatus", default, skip_serializing_if = "Option::is_none")]
        pub environment_status: Option<String>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(rename = "apiManagementAccountId", default, skip_serializing_if = "Option::is_none")]
        pub api_management_account_id: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub suspended: Option<bool>,
        #[serde(rename = "clusterSettings", default, skip_serializing_if = "Vec::is_empty")]
        pub cluster_settings: Vec<NameValuePair>,
    }
    impl Properties {
        pub fn new(status: properties::Status) -> Self {
            Self {
                name: None,
                location: None,
                provisioning_state: None,
                status,
                vnet_name: None,
                vnet_resource_group_name: None,
                vnet_subnet_name: None,
                virtual_network: None,
                internal_load_balancing_mode: None,
                multi_size: None,
                multi_role_count: None,
                worker_pools: Vec::new(),
                ipssl_address_count: None,
                database_edition: None,
                database_service_objective: None,
                upgrade_domains: None,
                subscription_id: None,
                dns_suffix: None,
                last_action: None,
                last_action_result: None,
                allowed_multi_sizes: None,
                allowed_worker_sizes: None,
                maximum_number_of_machines: None,
                vip_mappings: Vec::new(),
                environment_capacities: Vec::new(),
                network_access_control_list: Vec::new(),
                environment_is_healthy: None,
                environment_status: None,
                resource_group: None,
                api_management_account_id: None,
                suspended: None,
                cluster_settings: Vec::new(),
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Canceled,
            InProgress,
            Deleting,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Preparing,
            Ready,
            Scaling,
            Deleting,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum InternalLoadBalancingMode {
            None,
            Web,
            Publishing,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HostingEnvironment>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl HostingEnvironmentCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentDiagnostics {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "diagnosicsOutput", default, skip_serializing_if = "Option::is_none")]
    pub diagnosics_output: Option<String>,
}
impl HostingEnvironmentDiagnostics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentProfile {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl HostingEnvironmentProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostingEnvironmentServiceDescriptions {
    #[serde(rename = "hostingEnvironmentId", default, skip_serializing_if = "Option::is_none")]
    pub hosting_environment_id: Option<String>,
    #[serde(rename = "hostId", default, skip_serializing_if = "Option::is_none")]
    pub host_id: Option<String>,
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<String>,
    #[serde(rename = "useInternalRouting", default, skip_serializing_if = "Option::is_none")]
    pub use_internal_routing: Option<bool>,
}
impl HostingEnvironmentServiceDescriptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpLogsConfig {
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<FileSystemHttpLogsConfig>,
    #[serde(rename = "azureBlobStorage", default, skip_serializing_if = "Option::is_none")]
    pub azure_blob_storage: Option<AzureBlobStorageHttpLogsConfig>,
}
impl HttpLogsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpSecurityRestriction {
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "subnetMask", default, skip_serializing_if = "Option::is_none")]
    pub subnet_mask: Option<String>,
}
impl IpSecurityRestriction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyValuePairStringString {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl KeyValuePairStringString {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListConnectionKeysInput {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<list_connection_keys_input::Properties>,
}
impl ListConnectionKeysInput {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod list_connection_keys_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "validityTimeSpan", default, skip_serializing_if = "Option::is_none")]
        pub validity_time_span: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalizableString {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl LocalizableString {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedHostingEnvironment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<managed_hosting_environment::Properties>,
}
impl ManagedHostingEnvironment {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod managed_hosting_environment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub location: Option<String>,
        pub status: properties::Status,
        #[serde(rename = "virtualNetwork", default, skip_serializing_if = "Option::is_none")]
        pub virtual_network: Option<VirtualNetworkProfile>,
        #[serde(rename = "ipsslAddressCount", default, skip_serializing_if = "Option::is_none")]
        pub ipssl_address_count: Option<i32>,
        #[serde(rename = "dnsSuffix", default, skip_serializing_if = "Option::is_none")]
        pub dns_suffix: Option<String>,
        #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
        pub subscription_id: Option<String>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(rename = "environmentIsHealthy", default, skip_serializing_if = "Option::is_none")]
        pub environment_is_healthy: Option<bool>,
        #[serde(rename = "environmentStatus", default, skip_serializing_if = "Option::is_none")]
        pub environment_status: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub suspended: Option<bool>,
        #[serde(rename = "apiManagementAccount", default, skip_serializing_if = "Option::is_none")]
        pub api_management_account: Option<String>,
    }
    impl Properties {
        pub fn new(status: properties::Status) -> Self {
            Self {
                name: None,
                location: None,
                status,
                virtual_network: None,
                ipssl_address_count: None,
                dns_suffix: None,
                subscription_id: None,
                resource_group: None,
                environment_is_healthy: None,
                environment_status: None,
                suspended: None,
                api_management_account: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Preparing,
            Ready,
            Deleting,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedHostingEnvironmentCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ManagedHostingEnvironment>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagedHostingEnvironmentCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricAvailabilily {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
}
impl MetricAvailabilily {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricDefinition {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<metric_definition::Properties>,
}
impl MetricDefinition {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod metric_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub unit: Option<String>,
        #[serde(rename = "primaryAggregationType", default, skip_serializing_if = "Option::is_none")]
        pub primary_aggregation_type: Option<String>,
        #[serde(rename = "metricAvailabilities", default, skip_serializing_if = "Vec::is_empty")]
        pub metric_availabilities: Vec<MetricAvailabilily>,
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricDefinitionCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MetricDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MetricDefinitionCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameIdentifier {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl NameIdentifier {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameIdentifierCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NameIdentifier>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NameIdentifierCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameValuePair {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl NameValuePair {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkAccessControlEntry {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<network_access_control_entry::Action>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub order: Option<i32>,
    #[serde(rename = "remoteSubnet", default, skip_serializing_if = "Option::is_none")]
    pub remote_subnet: Option<String>,
}
impl NetworkAccessControlEntry {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_access_control_entry {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Permit,
        Deny,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkFeatures {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<network_features::Properties>,
}
impl NetworkFeatures {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod network_features {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "virtualNetworkName", default, skip_serializing_if = "Option::is_none")]
        pub virtual_network_name: Option<String>,
        #[serde(rename = "virtualNetworkConnection", default, skip_serializing_if = "Option::is_none")]
        pub virtual_network_connection: Option<VnetInfo>,
        #[serde(rename = "hybridConnections", default, skip_serializing_if = "Vec::is_empty")]
        pub hybrid_connections: Vec<RelayServiceConnectionEntity>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Object {}
impl Object {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParameterCustomLoginSettingValues {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<parameter_custom_login_setting_values::Properties>,
}
impl ParameterCustomLoginSettingValues {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod parameter_custom_login_setting_values {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "customParameters", default, skip_serializing_if = "Option::is_none")]
        pub custom_parameters: Option<serde_json::Value>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PremierAddOnRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<ArmPlan>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Object>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<SkuDescription>,
}
impl PremierAddOnRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RampUpRule {
    #[serde(rename = "actionHostName", default, skip_serializing_if = "Option::is_none")]
    pub action_host_name: Option<String>,
    #[serde(rename = "reroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub reroute_percentage: Option<f64>,
    #[serde(rename = "changeStep", default, skip_serializing_if = "Option::is_none")]
    pub change_step: Option<f64>,
    #[serde(rename = "changeIntervalInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub change_interval_in_minutes: Option<i32>,
    #[serde(rename = "minReroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub min_reroute_percentage: Option<f64>,
    #[serde(rename = "maxReroutePercentage", default, skip_serializing_if = "Option::is_none")]
    pub max_reroute_percentage: Option<f64>,
    #[serde(rename = "changeDecisionCallbackUrl", default, skip_serializing_if = "Option::is_none")]
    pub change_decision_callback_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl RampUpRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Recommendation {
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "recommendationId", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_id: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "resourceScope", default, skip_serializing_if = "Option::is_none")]
    pub resource_scope: Option<String>,
    #[serde(rename = "ruleName", default, skip_serializing_if = "Option::is_none")]
    pub rule_name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    pub level: recommendation::Level,
    pub channels: recommendation::Channels,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tags: Vec<String>,
    #[serde(rename = "actionName", default, skip_serializing_if = "Option::is_none")]
    pub action_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<i32>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "nextNotificationTime", default, skip_serializing_if = "Option::is_none")]
    pub next_notification_time: Option<String>,
    #[serde(rename = "notificationExpirationTime", default, skip_serializing_if = "Option::is_none")]
    pub notification_expiration_time: Option<String>,
    #[serde(rename = "notifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub notified_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub score: Option<f64>,
}
impl Recommendation {
    pub fn new(level: recommendation::Level, channels: recommendation::Channels) -> Self {
        Self {
            creation_time: None,
            recommendation_id: None,
            resource_id: None,
            resource_scope: None,
            rule_name: None,
            display_name: None,
            message: None,
            level,
            channels,
            tags: Vec::new(),
            action_name: None,
            enabled: None,
            start_time: None,
            end_time: None,
            next_notification_time: None,
            notification_expiration_time: None,
            notified_time: None,
            score: None,
        }
    }
}
pub mod recommendation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Critical,
        Warning,
        Information,
        NonUrgentSuggestion,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Channels {
        Notification,
        Api,
        Email,
        All,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecommendationRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "recommendationId", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "actionName", default, skip_serializing_if = "Option::is_none")]
    pub action_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<i32>,
    pub level: recommendation_rule::Level,
    pub channels: recommendation_rule::Channels,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tags: Vec<String>,
}
impl RecommendationRule {
    pub fn new(level: recommendation_rule::Level, channels: recommendation_rule::Channels) -> Self {
        Self {
            name: None,
            display_name: None,
            message: None,
            recommendation_id: None,
            description: None,
            action_name: None,
            enabled: None,
            level,
            channels,
            tags: Vec::new(),
        }
    }
}
pub mod recommendation_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        Critical,
        Warning,
        Information,
        NonUrgentSuggestion,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Channels {
        Notification,
        Api,
        Email,
        All,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReissueCertificateOrderRequest {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<reissue_certificate_order_request::Properties>,
}
impl ReissueCertificateOrderRequest {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod reissue_certificate_order_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "keySize", default, skip_serializing_if = "Option::is_none")]
        pub key_size: Option<i32>,
        #[serde(rename = "delayExistingRevokeInHours", default, skip_serializing_if = "Option::is_none")]
        pub delay_existing_revoke_in_hours: Option<i32>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RelayServiceConnectionEntity {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<relay_service_connection_entity::Properties>,
}
impl RelayServiceConnectionEntity {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod relay_service_connection_entity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "entityName", default, skip_serializing_if = "Option::is_none")]
        pub entity_name: Option<String>,
        #[serde(rename = "entityConnectionString", default, skip_serializing_if = "Option::is_none")]
        pub entity_connection_string: Option<String>,
        #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
        pub resource_type: Option<String>,
        #[serde(rename = "resourceConnectionString", default, skip_serializing_if = "Option::is_none")]
        pub resource_connection_string: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub hostname: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub port: Option<i32>,
        #[serde(rename = "biztalkUri", default, skip_serializing_if = "Option::is_none")]
        pub biztalk_uri: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RenewCertificateOrderRequest {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<renew_certificate_order_request::Properties>,
}
impl RenewCertificateOrderRequest {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod renew_certificate_order_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "keySize", default, skip_serializing_if = "Option::is_none")]
        pub key_size: Option<i32>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestsBasedTrigger {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl RequestsBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    pub location: String,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            kind: None,
            location,
            type_: None,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetric {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<ResourceMetricName>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "metricValues", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_values: Vec<ResourceMetricValue>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<KeyValuePairStringString>,
}
impl ResourceMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceMetric>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceMetricCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl ResourceMetricName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMetricValue {
    #[serde(rename = "timeStamp", default, skip_serializing_if = "Option::is_none")]
    pub time_stamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub average: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<f32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<f32>,
}
impl ResourceMetricValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNameAvailability {
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ResourceNameAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNameAvailabilityRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "isFqdn", default, skip_serializing_if = "Option::is_none")]
    pub is_fqdn: Option<bool>,
}
impl ResourceNameAvailabilityRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResponseMessageEnvelopeApiEntity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub plan: Option<ArmPlan>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApiEntity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<SkuDescription>,
}
impl ResponseMessageEnvelopeApiEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestoreRequest {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<restore_request::Properties>,
}
impl RestoreRequest {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(rename = "storageAccountUrl", default, skip_serializing_if = "Option::is_none")]
        pub storage_account_url: Option<String>,
        #[serde(rename = "blobName", default, skip_serializing_if = "Option::is_none")]
        pub blob_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub overwrite: Option<bool>,
        #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
        pub site_name: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub databases: Vec<DatabaseBackupSetting>,
        #[serde(rename = "ignoreConflictingHostNames", default, skip_serializing_if = "Option::is_none")]
        pub ignore_conflicting_host_names: Option<bool>,
        #[serde(rename = "operationType")]
        pub operation_type: properties::OperationType,
        #[serde(rename = "adjustConnectionStrings", default, skip_serializing_if = "Option::is_none")]
        pub adjust_connection_strings: Option<bool>,
        #[serde(rename = "hostingEnvironment", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment: Option<String>,
    }
    impl Properties {
        pub fn new(operation_type: properties::OperationType) -> Self {
            Self {
                storage_account_url: None,
                blob_name: None,
                overwrite: None,
                site_name: None,
                databases: Vec::new(),
                ignore_conflicting_host_names: None,
                operation_type,
                adjust_connection_strings: None,
                hosting_environment: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum OperationType {
            Default,
            Clone,
            Relocation,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestoreResponse {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<restore_response::Properties>,
}
impl RestoreResponse {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod restore_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
        pub operation_id: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl RoutingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerFarmCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServerFarmWithRichSku>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServerFarmCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServerFarmWithRichSku {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<server_farm_with_rich_sku::Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<SkuDescription>,
}
impl ServerFarmWithRichSku {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            sku: None,
        }
    }
}
pub mod server_farm_with_rich_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "workerTierName", default, skip_serializing_if = "Option::is_none")]
        pub worker_tier_name: Option<String>,
        pub status: properties::Status,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subscription: Option<String>,
        #[serde(rename = "adminSiteName", default, skip_serializing_if = "Option::is_none")]
        pub admin_site_name: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "maximumNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub maximum_number_of_workers: Option<i32>,
        #[serde(rename = "geoRegion", default, skip_serializing_if = "Option::is_none")]
        pub geo_region: Option<String>,
        #[serde(rename = "perSiteScaling", default, skip_serializing_if = "Option::is_none")]
        pub per_site_scaling: Option<bool>,
        #[serde(rename = "numberOfSites", default, skip_serializing_if = "Option::is_none")]
        pub number_of_sites: Option<i32>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reserved: Option<bool>,
    }
    impl Properties {
        pub fn new(status: properties::Status) -> Self {
            Self {
                name: None,
                worker_tier_name: None,
                status,
                subscription: None,
                admin_site_name: None,
                hosting_environment_profile: None,
                maximum_number_of_workers: None,
                geo_region: None,
                per_site_scaling: None,
                number_of_sites: None,
                resource_group: None,
                reserved: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Status {
            Ready,
            Pending,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Site {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site::Properties>,
}
impl Site {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod site {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub state: Option<String>,
        #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub host_names: Vec<String>,
        #[serde(rename = "repositorySiteName", default, skip_serializing_if = "Option::is_none")]
        pub repository_site_name: Option<String>,
        #[serde(rename = "usageState")]
        pub usage_state: properties::UsageState,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "enabledHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub enabled_host_names: Vec<String>,
        #[serde(rename = "availabilityState")]
        pub availability_state: properties::AvailabilityState,
        #[serde(rename = "hostNameSslStates", default, skip_serializing_if = "Vec::is_empty")]
        pub host_name_ssl_states: Vec<HostNameSslState>,
        #[serde(rename = "serverFarmId", default, skip_serializing_if = "Option::is_none")]
        pub server_farm_id: Option<String>,
        #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
        pub last_modified_time_utc: Option<String>,
        #[serde(rename = "siteConfig", default, skip_serializing_if = "Option::is_none")]
        pub site_config: Option<SiteConfig>,
        #[serde(rename = "trafficManagerHostNames", default, skip_serializing_if = "Vec::is_empty")]
        pub traffic_manager_host_names: Vec<String>,
        #[serde(rename = "premiumAppDeployed", default, skip_serializing_if = "Option::is_none")]
        pub premium_app_deployed: Option<bool>,
        #[serde(rename = "scmSiteAlsoStopped", default, skip_serializing_if = "Option::is_none")]
        pub scm_site_also_stopped: Option<bool>,
        #[serde(rename = "targetSwapSlot", default, skip_serializing_if = "Option::is_none")]
        pub target_swap_slot: Option<String>,
        #[serde(rename = "hostingEnvironmentProfile", default, skip_serializing_if = "Option::is_none")]
        pub hosting_environment_profile: Option<HostingEnvironmentProfile>,
        #[serde(rename = "microService", default, skip_serializing_if = "Option::is_none")]
        pub micro_service: Option<String>,
        #[serde(rename = "gatewaySiteName", default, skip_serializing_if = "Option::is_none")]
        pub gateway_site_name: Option<String>,
        #[serde(rename = "clientAffinityEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_affinity_enabled: Option<bool>,
        #[serde(rename = "clientCertEnabled", default, skip_serializing_if = "Option::is_none")]
        pub client_cert_enabled: Option<bool>,
        #[serde(rename = "hostNamesDisabled", default, skip_serializing_if = "Option::is_none")]
        pub host_names_disabled: Option<bool>,
        #[serde(rename = "outboundIpAddresses", default, skip_serializing_if = "Option::is_none")]
        pub outbound_ip_addresses: Option<String>,
        #[serde(rename = "containerSize", default, skip_serializing_if = "Option::is_none")]
        pub container_size: Option<i32>,
        #[serde(rename = "maxNumberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub max_number_of_workers: Option<i32>,
        #[serde(rename = "cloningInfo", default, skip_serializing_if = "Option::is_none")]
        pub cloning_info: Option<CloningInfo>,
        #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub resource_group: Option<String>,
        #[serde(rename = "isDefaultContainer", default, skip_serializing_if = "Option::is_none")]
        pub is_default_container: Option<bool>,
        #[serde(rename = "defaultHostName", default, skip_serializing_if = "Option::is_none")]
        pub default_host_name: Option<String>,
    }
    impl Properties {
        pub fn new(usage_state: properties::UsageState, availability_state: properties::AvailabilityState) -> Self {
            Self {
                name: None,
                state: None,
                host_names: Vec::new(),
                repository_site_name: None,
                usage_state,
                enabled: None,
                enabled_host_names: Vec::new(),
                availability_state,
                host_name_ssl_states: Vec::new(),
                server_farm_id: None,
                last_modified_time_utc: None,
                site_config: None,
                traffic_manager_host_names: Vec::new(),
                premium_app_deployed: None,
                scm_site_also_stopped: None,
                target_swap_slot: None,
                hosting_environment_profile: None,
                micro_service: None,
                gateway_site_name: None,
                client_affinity_enabled: None,
                client_cert_enabled: None,
                host_names_disabled: None,
                outbound_ip_addresses: None,
                container_size: None,
                max_number_of_workers: None,
                cloning_info: None,
                resource_group: None,
                is_default_container: None,
                default_host_name: None,
            }
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum UsageState {
            Normal,
            Exceeded,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum AvailabilityState {
            Normal,
            Limited,
            DisasterRecoveryMode,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteAuthSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "httpApiPrefixPath", default, skip_serializing_if = "Option::is_none")]
    pub http_api_prefix_path: Option<String>,
    #[serde(rename = "unauthenticatedClientAction", default, skip_serializing_if = "Option::is_none")]
    pub unauthenticated_client_action: Option<site_auth_settings::UnauthenticatedClientAction>,
    #[serde(rename = "tokenStoreEnabled", default, skip_serializing_if = "Option::is_none")]
    pub token_store_enabled: Option<bool>,
    #[serde(rename = "allowedExternalRedirectUrls", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_external_redirect_urls: Vec<String>,
    #[serde(rename = "defaultProvider", default, skip_serializing_if = "Option::is_none")]
    pub default_provider: Option<site_auth_settings::DefaultProvider>,
    #[serde(rename = "tokenRefreshExtensionHours", default, skip_serializing_if = "Option::is_none")]
    pub token_refresh_extension_hours: Option<f64>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub issuer: Option<String>,
    #[serde(rename = "allowedAudiences", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_audiences: Vec<String>,
    #[serde(rename = "additionalLoginParams", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_login_params: Vec<String>,
    #[serde(rename = "aadClientId", default, skip_serializing_if = "Option::is_none")]
    pub aad_client_id: Option<String>,
    #[serde(rename = "openIdIssuer", default, skip_serializing_if = "Option::is_none")]
    pub open_id_issuer: Option<String>,
    #[serde(rename = "googleClientId", default, skip_serializing_if = "Option::is_none")]
    pub google_client_id: Option<String>,
    #[serde(rename = "googleClientSecret", default, skip_serializing_if = "Option::is_none")]
    pub google_client_secret: Option<String>,
    #[serde(rename = "googleOAuthScopes", default, skip_serializing_if = "Vec::is_empty")]
    pub google_o_auth_scopes: Vec<String>,
    #[serde(rename = "facebookAppId", default, skip_serializing_if = "Option::is_none")]
    pub facebook_app_id: Option<String>,
    #[serde(rename = "facebookAppSecret", default, skip_serializing_if = "Option::is_none")]
    pub facebook_app_secret: Option<String>,
    #[serde(rename = "facebookOAuthScopes", default, skip_serializing_if = "Vec::is_empty")]
    pub facebook_o_auth_scopes: Vec<String>,
    #[serde(rename = "twitterConsumerKey", default, skip_serializing_if = "Option::is_none")]
    pub twitter_consumer_key: Option<String>,
    #[serde(rename = "twitterConsumerSecret", default, skip_serializing_if = "Option::is_none")]
    pub twitter_consumer_secret: Option<String>,
    #[serde(rename = "microsoftAccountClientId", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_account_client_id: Option<String>,
    #[serde(rename = "microsoftAccountClientSecret", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_account_client_secret: Option<String>,
    #[serde(rename = "microsoftAccountOAuthScopes", default, skip_serializing_if = "Vec::is_empty")]
    pub microsoft_account_o_auth_scopes: Vec<String>,
}
impl SiteAuthSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod site_auth_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UnauthenticatedClientAction {
        RedirectToLoginPage,
        AllowAnonymous,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DefaultProvider {
        AzureActiveDirectory,
        Facebook,
        Google,
        MicrosoftAccount,
        Twitter,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteCloneability {
    pub result: site_cloneability::Result,
    #[serde(rename = "blockingFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub blocking_features: Vec<SiteCloneabilityCriterion>,
    #[serde(rename = "unsupportedFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub unsupported_features: Vec<SiteCloneabilityCriterion>,
    #[serde(rename = "blockingCharacteristics", default, skip_serializing_if = "Vec::is_empty")]
    pub blocking_characteristics: Vec<SiteCloneabilityCriterion>,
}
impl SiteCloneability {
    pub fn new(result: site_cloneability::Result) -> Self {
        Self {
            result,
            blocking_features: Vec::new(),
            unsupported_features: Vec::new(),
            blocking_characteristics: Vec::new(),
        }
    }
}
pub mod site_cloneability {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Result {
        Cloneable,
        PartiallyCloneable,
        NotCloneable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteCloneabilityCriterion {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl SiteCloneabilityCriterion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Site>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SiteCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteConfig {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_config::Properties>,
}
impl SiteConfig {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod site_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "numberOfWorkers", default, skip_serializing_if = "Option::is_none")]
        pub number_of_workers: Option<i32>,
        #[serde(rename = "defaultDocuments", default, skip_serializing_if = "Vec::is_empty")]
        pub default_documents: Vec<String>,
        #[serde(rename = "netFrameworkVersion", default, skip_serializing_if = "Option::is_none")]
        pub net_framework_version: Option<String>,
        #[serde(rename = "phpVersion", default, skip_serializing_if = "Option::is_none")]
        pub php_version: Option<String>,
        #[serde(rename = "pythonVersion", default, skip_serializing_if = "Option::is_none")]
        pub python_version: Option<String>,
        #[serde(rename = "nodeVersion", default, skip_serializing_if = "Option::is_none")]
        pub node_version: Option<String>,
        #[serde(rename = "requestTracingEnabled", default, skip_serializing_if = "Option::is_none")]
        pub request_tracing_enabled: Option<bool>,
        #[serde(rename = "requestTracingExpirationTime", default, skip_serializing_if = "Option::is_none")]
        pub request_tracing_expiration_time: Option<String>,
        #[serde(rename = "remoteDebuggingEnabled", default, skip_serializing_if = "Option::is_none")]
        pub remote_debugging_enabled: Option<bool>,
        #[serde(rename = "remoteDebuggingVersion", default, skip_serializing_if = "Option::is_none")]
        pub remote_debugging_version: Option<String>,
        #[serde(rename = "httpLoggingEnabled", default, skip_serializing_if = "Option::is_none")]
        pub http_logging_enabled: Option<bool>,
        #[serde(rename = "logsDirectorySizeLimit", default, skip_serializing_if = "Option::is_none")]
        pub logs_directory_size_limit: Option<i32>,
        #[serde(rename = "detailedErrorLoggingEnabled", default, skip_serializing_if = "Option::is_none")]
        pub detailed_error_logging_enabled: Option<bool>,
        #[serde(rename = "publishingUsername", default, skip_serializing_if = "Option::is_none")]
        pub publishing_username: Option<String>,
        #[serde(rename = "publishingPassword", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password: Option<String>,
        #[serde(rename = "appSettings", default, skip_serializing_if = "Vec::is_empty")]
        pub app_settings: Vec<NameValuePair>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub metadata: Vec<NameValuePair>,
        #[serde(rename = "connectionStrings", default, skip_serializing_if = "Vec::is_empty")]
        pub connection_strings: Vec<ConnStringInfo>,
        #[serde(rename = "handlerMappings", default, skip_serializing_if = "Vec::is_empty")]
        pub handler_mappings: Vec<HandlerMapping>,
        #[serde(rename = "documentRoot", default, skip_serializing_if = "Option::is_none")]
        pub document_root: Option<String>,
        #[serde(rename = "scmType", default, skip_serializing_if = "Option::is_none")]
        pub scm_type: Option<String>,
        #[serde(rename = "use32BitWorkerProcess", default, skip_serializing_if = "Option::is_none")]
        pub use32_bit_worker_process: Option<bool>,
        #[serde(rename = "webSocketsEnabled", default, skip_serializing_if = "Option::is_none")]
        pub web_sockets_enabled: Option<bool>,
        #[serde(rename = "alwaysOn", default, skip_serializing_if = "Option::is_none")]
        pub always_on: Option<bool>,
        #[serde(rename = "javaVersion", default, skip_serializing_if = "Option::is_none")]
        pub java_version: Option<String>,
        #[serde(rename = "javaContainer", default, skip_serializing_if = "Option::is_none")]
        pub java_container: Option<String>,
        #[serde(rename = "javaContainerVersion", default, skip_serializing_if = "Option::is_none")]
        pub java_container_version: Option<String>,
        #[serde(rename = "appCommandLine", default, skip_serializing_if = "Option::is_none")]
        pub app_command_line: Option<String>,
        #[serde(rename = "managedPipelineMode", default, skip_serializing_if = "Option::is_none")]
        pub managed_pipeline_mode: Option<properties::ManagedPipelineMode>,
        #[serde(rename = "virtualApplications", default, skip_serializing_if = "Vec::is_empty")]
        pub virtual_applications: Vec<VirtualApplication>,
        #[serde(rename = "loadBalancing", default, skip_serializing_if = "Option::is_none")]
        pub load_balancing: Option<properties::LoadBalancing>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub experiments: Option<Experiments>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub limits: Option<SiteLimits>,
        #[serde(rename = "autoHealEnabled", default, skip_serializing_if = "Option::is_none")]
        pub auto_heal_enabled: Option<bool>,
        #[serde(rename = "autoHealRules", default, skip_serializing_if = "Option::is_none")]
        pub auto_heal_rules: Option<AutoHealRules>,
        #[serde(rename = "tracingOptions", default, skip_serializing_if = "Option::is_none")]
        pub tracing_options: Option<String>,
        #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub cors: Option<CorsSettings>,
        #[serde(rename = "apiDefinition", default, skip_serializing_if = "Option::is_none")]
        pub api_definition: Option<ApiDefinitionInfo>,
        #[serde(rename = "autoSwapSlotName", default, skip_serializing_if = "Option::is_none")]
        pub auto_swap_slot_name: Option<String>,
        #[serde(rename = "localMySqlEnabled", default, skip_serializing_if = "Option::is_none")]
        pub local_my_sql_enabled: Option<bool>,
        #[serde(rename = "ipSecurityRestrictions", default, skip_serializing_if = "Vec::is_empty")]
        pub ip_security_restrictions: Vec<IpSecurityRestriction>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ManagedPipelineMode {
            Integrated,
            Classic,
        }
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum LoadBalancing {
            WeightedRoundRobin,
            LeastRequests,
            LeastResponseTime,
            WeightedTotalTraffic,
            RequestHash,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteInstance {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_instance::Properties>,
}
impl SiteInstance {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod site_instance {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteInstanceCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SiteInstance>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SiteInstanceCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteLimits {
    #[serde(rename = "maxPercentageCpu", default, skip_serializing_if = "Option::is_none")]
    pub max_percentage_cpu: Option<f64>,
    #[serde(rename = "maxMemoryInMb", default, skip_serializing_if = "Option::is_none")]
    pub max_memory_in_mb: Option<i64>,
    #[serde(rename = "maxDiskSizeInMb", default, skip_serializing_if = "Option::is_none")]
    pub max_disk_size_in_mb: Option<i64>,
}
impl SiteLimits {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteLogsConfig {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_logs_config::Properties>,
}
impl SiteLogsConfig {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod site_logs_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "applicationLogs", default, skip_serializing_if = "Option::is_none")]
        pub application_logs: Option<ApplicationLogsConfig>,
        #[serde(rename = "httpLogs", default, skip_serializing_if = "Option::is_none")]
        pub http_logs: Option<HttpLogsConfig>,
        #[serde(rename = "failedRequestsTracing", default, skip_serializing_if = "Option::is_none")]
        pub failed_requests_tracing: Option<EnabledConfig>,
        #[serde(rename = "detailedErrorMessages", default, skip_serializing_if = "Option::is_none")]
        pub detailed_error_messages: Option<EnabledConfig>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SiteProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<NameValuePair>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<NameValuePair>,
    #[serde(rename = "appSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub app_settings: Vec<NameValuePair>,
}
impl SiteProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SiteSourceControl {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<site_source_control::Properties>,
}
impl SiteSourceControl {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod site_source_control {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "repoUrl", default, skip_serializing_if = "Option::is_none")]
        pub repo_url: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub branch: Option<String>,
        #[serde(rename = "isManualIntegration", default, skip_serializing_if = "Option::is_none")]
        pub is_manual_integration: Option<bool>,
        #[serde(rename = "deploymentRollbackEnabled", default, skip_serializing_if = "Option::is_none")]
        pub deployment_rollback_enabled: Option<bool>,
        #[serde(rename = "isMercurial", default, skip_serializing_if = "Option::is_none")]
        pub is_mercurial: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<i32>,
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<String>,
}
impl SkuCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuDescription {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl SkuDescription {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuInfo {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<SkuDescription>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<SkuCapacity>,
}
impl SkuInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuInfoCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SkuInfo>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SkuInfoCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotConfigNames {
    #[serde(rename = "connectionStringNames", default, skip_serializing_if = "Vec::is_empty")]
    pub connection_string_names: Vec<String>,
    #[serde(rename = "appSettingNames", default, skip_serializing_if = "Vec::is_empty")]
    pub app_setting_names: Vec<String>,
}
impl SlotConfigNames {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SlotConfigNamesResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<slot_config_names_resource::Properties>,
}
impl SlotConfigNamesResource {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod slot_config_names_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "connectionStringNames", default, skip_serializing_if = "Vec::is_empty")]
        pub connection_string_names: Vec<String>,
        #[serde(rename = "appSettingNames", default, skip_serializing_if = "Vec::is_empty")]
        pub app_setting_names: Vec<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SlotDifference {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<slot_difference::Properties>,
}
impl SlotDifference {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod slot_difference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
        pub type_: Option<String>,
        #[serde(rename = "settingType", default, skip_serializing_if = "Option::is_none")]
        pub setting_type: Option<String>,
        #[serde(rename = "diffRule", default, skip_serializing_if = "Option::is_none")]
        pub diff_rule: Option<String>,
        #[serde(rename = "settingName", default, skip_serializing_if = "Option::is_none")]
        pub setting_name: Option<String>,
        #[serde(rename = "valueInCurrentSlot", default, skip_serializing_if = "Option::is_none")]
        pub value_in_current_slot: Option<String>,
        #[serde(rename = "valueInTargetSlot", default, skip_serializing_if = "Option::is_none")]
        pub value_in_target_slot: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlotDifferenceCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SlotDifference>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SlotDifferenceCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SlowRequestsBasedTrigger {
    #[serde(rename = "timeTaken", default, skip_serializing_if = "Option::is_none")]
    pub time_taken: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl SlowRequestsBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceControl {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<source_control::Properties>,
}
impl SourceControl {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod source_control {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub token: Option<String>,
        #[serde(rename = "tokenSecret", default, skip_serializing_if = "Option::is_none")]
        pub token_secret: Option<String>,
        #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
        pub refresh_token: Option<String>,
        #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
        pub expiration_time: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceControlCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SourceControl>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SourceControlCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StampCapacity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "availableCapacity", default, skip_serializing_if = "Option::is_none")]
    pub available_capacity: Option<i64>,
    #[serde(rename = "totalCapacity", default, skip_serializing_if = "Option::is_none")]
    pub total_capacity: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "computeMode", default, skip_serializing_if = "Option::is_none")]
    pub compute_mode: Option<stamp_capacity::ComputeMode>,
    #[serde(rename = "workerSize", default, skip_serializing_if = "Option::is_none")]
    pub worker_size: Option<stamp_capacity::WorkerSize>,
    #[serde(rename = "workerSizeId", default, skip_serializing_if = "Option::is_none")]
    pub worker_size_id: Option<i32>,
    #[serde(rename = "excludeFromCapacityAllocation", default, skip_serializing_if = "Option::is_none")]
    pub exclude_from_capacity_allocation: Option<bool>,
    #[serde(rename = "isApplicableForAllComputeModes", default, skip_serializing_if = "Option::is_none")]
    pub is_applicable_for_all_compute_modes: Option<bool>,
    #[serde(rename = "siteMode", default, skip_serializing_if = "Option::is_none")]
    pub site_mode: Option<String>,
}
impl StampCapacity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod stamp_capacity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ComputeMode {
        Shared,
        Dedicated,
        Dynamic,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkerSize {
        Default,
        Small,
        Medium,
        Large,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StampCapacityCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<StampCapacity>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl StampCapacityCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StatusCodesBasedTrigger {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<i32>,
    #[serde(rename = "subStatus", default, skip_serializing_if = "Option::is_none")]
    pub sub_status: Option<i32>,
    #[serde(rename = "win32Status", default, skip_serializing_if = "Option::is_none")]
    pub win32_status: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "timeInterval", default, skip_serializing_if = "Option::is_none")]
    pub time_interval: Option<String>,
}
impl StatusCodesBasedTrigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StringDictionary {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl StringDictionary {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TldLegalAgreement {
    #[serde(rename = "agreementKey", default, skip_serializing_if = "Option::is_none")]
    pub agreement_key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl TldLegalAgreement {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TldLegalAgreementCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TldLegalAgreement>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TldLegalAgreementCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TopLevelDomain {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<top_level_domain::Properties>,
}
impl TopLevelDomain {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod top_level_domain {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub privacy: Option<bool>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopLevelDomainAgreementOption {
    #[serde(rename = "includePrivacy", default, skip_serializing_if = "Option::is_none")]
    pub include_privacy: Option<bool>,
}
impl TopLevelDomainAgreementOption {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopLevelDomainCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TopLevelDomain>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TopLevelDomainCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<usage::Properties>,
}
impl Usage {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
        pub display_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
        pub resource_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub unit: Option<String>,
        #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
        pub current_value: Option<i64>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub limit: Option<i64>,
        #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
        pub next_reset_time: Option<String>,
        #[serde(rename = "computeMode", default, skip_serializing_if = "Option::is_none")]
        pub compute_mode: Option<properties::ComputeMode>,
        #[serde(rename = "siteMode", default, skip_serializing_if = "Option::is_none")]
        pub site_mode: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ComputeMode {
            Shared,
            Dedicated,
            Dynamic,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UsageCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct User {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<user::Properties>,
}
impl User {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod user {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "publishingUserName", default, skip_serializing_if = "Option::is_none")]
        pub publishing_user_name: Option<String>,
        #[serde(rename = "publishingPassword", default, skip_serializing_if = "Option::is_none")]
        pub publishing_password: Option<String>,
        #[serde(rename = "scmUri", default, skip_serializing_if = "Option::is_none")]
        pub scm_uri: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplication {
    #[serde(rename = "virtualPath", default, skip_serializing_if = "Option::is_none")]
    pub virtual_path: Option<String>,
    #[serde(rename = "physicalPath", default, skip_serializing_if = "Option::is_none")]
    pub physical_path: Option<String>,
    #[serde(rename = "preloadEnabled", default, skip_serializing_if = "Option::is_none")]
    pub preload_enabled: Option<bool>,
    #[serde(rename = "virtualDirectories", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_directories: Vec<VirtualDirectory>,
}
impl VirtualApplication {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualDirectory {
    #[serde(rename = "virtualPath", default, skip_serializing_if = "Option::is_none")]
    pub virtual_path: Option<String>,
    #[serde(rename = "physicalPath", default, skip_serializing_if = "Option::is_none")]
    pub physical_path: Option<String>,
}
impl VirtualDirectory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualIpMapping {
    #[serde(rename = "virtualIP", default, skip_serializing_if = "Option::is_none")]
    pub virtual_ip: Option<String>,
    #[serde(rename = "internalHttpPort", default, skip_serializing_if = "Option::is_none")]
    pub internal_http_port: Option<i32>,
    #[serde(rename = "internalHttpsPort", default, skip_serializing_if = "Option::is_none")]
    pub internal_https_port: Option<i32>,
    #[serde(rename = "inUse", default, skip_serializing_if = "Option::is_none")]
    pub in_use: Option<bool>,
}
impl VirtualIpMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkProfile {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<String>,
}
impl VirtualNetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VnetGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_gateway::Properties>,
}
impl VnetGateway {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod vnet_gateway {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "vnetName", default, skip_serializing_if = "Option::is_none")]
        pub vnet_name: Option<String>,
        #[serde(rename = "vpnPackageUri", default, skip_serializing_if = "Option::is_none")]
        pub vpn_package_uri: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VnetInfo {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_info::Properties>,
}
impl VnetInfo {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod vnet_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "vnetResourceId", default, skip_serializing_if = "Option::is_none")]
        pub vnet_resource_id: Option<String>,
        #[serde(rename = "certThumbprint", default, skip_serializing_if = "Option::is_none")]
        pub cert_thumbprint: Option<String>,
        #[serde(rename = "certBlob", default, skip_serializing_if = "Option::is_none")]
        pub cert_blob: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub routes: Vec<VnetRoute>,
        #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
        pub resync_required: Option<bool>,
        #[serde(rename = "dnsServers", default, skip_serializing_if = "Option::is_none")]
        pub dns_servers: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VnetRoute {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<vnet_route::Properties>,
}
impl VnetRoute {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
pub mod vnet_route {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "startAddress", default, skip_serializing_if = "Option::is_none")]
        pub start_address: Option<String>,
        #[serde(rename = "endAddress", default, skip_serializing_if = "Option::is_none")]
        pub end_address: Option<String>,
        #[serde(rename = "routeType", default, skip_serializing_if = "Option::is_none")]
        pub route_type: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkerPool {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<worker_pool::Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<SkuDescription>,
}
impl WorkerPool {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            sku: None,
        }
    }
}
pub mod worker_pool {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(rename = "workerSizeId", default, skip_serializing_if = "Option::is_none")]
        pub worker_size_id: Option<i32>,
        #[serde(rename = "computeMode", default, skip_serializing_if = "Option::is_none")]
        pub compute_mode: Option<properties::ComputeMode>,
        #[serde(rename = "workerSize", default, skip_serializing_if = "Option::is_none")]
        pub worker_size: Option<String>,
        #[serde(rename = "workerCount", default, skip_serializing_if = "Option::is_none")]
        pub worker_count: Option<i32>,
        #[serde(rename = "instanceNames", default, skip_serializing_if = "Vec::is_empty")]
        pub instance_names: Vec<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ComputeMode {
            Shared,
            Dedicated,
            Dynamic,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkerPoolCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkerPool>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WorkerPoolCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
