#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckTrafficManagerRelativeDnsNameAvailabilityParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl CheckTrafficManagerRelativeDnsNameAvailabilityParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeleteOperationResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub boolean: Option<bool>,
}
impl DeleteOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DnsConfig {
    #[serde(rename = "relativeName", default, skip_serializing_if = "Option::is_none")]
    pub relative_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub ttl: Option<i64>,
}
impl DnsConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Endpoint {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EndpointProperties>,
}
impl Endpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointProperties {
    #[serde(rename = "targetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(rename = "endpointStatus", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_status: Option<endpoint_properties::EndpointStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i64>,
    #[serde(rename = "endpointLocation", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_location: Option<String>,
    #[serde(rename = "endpointMonitorStatus", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_monitor_status: Option<endpoint_properties::EndpointMonitorStatus>,
    #[serde(rename = "minChildEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub min_child_endpoints: Option<i64>,
    #[serde(rename = "geoMapping", default, skip_serializing_if = "Vec::is_empty")]
    pub geo_mapping: Vec<String>,
    #[serde(rename = "customHeaders", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_headers: Vec<serde_json::Value>,
}
impl EndpointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod endpoint_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EndpointStatus {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EndpointMonitorStatus {
        CheckingEndpoint,
        Online,
        Degraded,
        Disabled,
        Inactive,
        Stopped,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GeographicHierarchyProperties {
    #[serde(rename = "geographicHierarchy", default, skip_serializing_if = "Option::is_none")]
    pub geographic_hierarchy: Option<Region>,
}
impl GeographicHierarchyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HeatMapEndpoint {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "endpointId", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_id: Option<i64>,
}
impl HeatMapEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HeatMapModel {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HeatMapProperties>,
}
impl HeatMapModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HeatMapProperties {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<HeatMapEndpoint>,
    #[serde(rename = "trafficFlows", default, skip_serializing_if = "Vec::is_empty")]
    pub traffic_flows: Vec<TrafficFlow>,
}
impl HeatMapProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MonitorConfig {
    #[serde(rename = "profileMonitorStatus", default, skip_serializing_if = "Option::is_none")]
    pub profile_monitor_status: Option<monitor_config::ProfileMonitorStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<monitor_config::Protocol>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "intervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub interval_in_seconds: Option<i64>,
    #[serde(rename = "timeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_in_seconds: Option<i64>,
    #[serde(rename = "toleratedNumberOfFailures", default, skip_serializing_if = "Option::is_none")]
    pub tolerated_number_of_failures: Option<i64>,
    #[serde(rename = "customHeaders", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_headers: Vec<serde_json::Value>,
    #[serde(rename = "expectedStatusCodeRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub expected_status_code_ranges: Vec<serde_json::Value>,
}
impl MonitorConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod monitor_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProfileMonitorStatus {
        CheckingEndpoints,
        Online,
        Degraded,
        Disabled,
        Inactive,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "HTTP")]
        Http,
        #[serde(rename = "HTTPS")]
        Https,
        #[serde(rename = "TCP")]
        Tcp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Profile {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProfileProperties>,
}
impl Profile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProfileListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Profile>,
}
impl ProfileListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProfileProperties {
    #[serde(rename = "profileStatus", default, skip_serializing_if = "Option::is_none")]
    pub profile_status: Option<profile_properties::ProfileStatus>,
    #[serde(rename = "trafficRoutingMethod", default, skip_serializing_if = "Option::is_none")]
    pub traffic_routing_method: Option<profile_properties::TrafficRoutingMethod>,
    #[serde(rename = "dnsConfig", default, skip_serializing_if = "Option::is_none")]
    pub dns_config: Option<DnsConfig>,
    #[serde(rename = "monitorConfig", default, skip_serializing_if = "Option::is_none")]
    pub monitor_config: Option<MonitorConfig>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<Endpoint>,
    #[serde(rename = "trafficViewEnrollmentStatus", default, skip_serializing_if = "Option::is_none")]
    pub traffic_view_enrollment_status: Option<profile_properties::TrafficViewEnrollmentStatus>,
}
impl ProfileProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod profile_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProfileStatus {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TrafficRoutingMethod {
        Performance,
        Priority,
        Weighted,
        Geographic,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TrafficViewEnrollmentStatus {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryExperience {
    #[serde(rename = "endpointId")]
    pub endpoint_id: i64,
    #[serde(rename = "queryCount")]
    pub query_count: i64,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub latency: Option<f64>,
}
impl QueryExperience {
    pub fn new(endpoint_id: i64, query_count: i64) -> Self {
        Self {
            endpoint_id,
            query_count,
            latency: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Region {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub regions: Vec<Region>,
}
impl Region {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl TrackedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrafficFlow {
    #[serde(rename = "sourceIp", default, skip_serializing_if = "Option::is_none")]
    pub source_ip: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub latitude: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub longitude: Option<f64>,
    #[serde(rename = "queryExperiences", default, skip_serializing_if = "Vec::is_empty")]
    pub query_experiences: Vec<QueryExperience>,
}
impl TrafficFlow {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrafficManagerGeographicHierarchy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GeographicHierarchyProperties>,
}
impl TrafficManagerGeographicHierarchy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrafficManagerNameAvailability {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl TrafficManagerNameAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
