#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccessPolicyCreateOrUpdateParameters {
    pub properties: AccessPolicyResourceProperties,
}
impl AccessPolicyCreateOrUpdateParameters {
    pub fn new(properties: AccessPolicyResourceProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessPolicyListResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AccessPolicyResource>,
}
impl AccessPolicyListResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessPolicyMutableProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub roles: Vec<String>,
}
impl AccessPolicyMutableProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessPolicyResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AccessPolicyResourceProperties>,
}
impl AccessPolicyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessPolicyResourceProperties {
    #[serde(rename = "principalObjectId", default, skip_serializing_if = "Option::is_none")]
    pub principal_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub roles: Vec<String>,
}
impl AccessPolicyResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessPolicyUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AccessPolicyMutableProperties>,
}
impl AccessPolicyUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureEventSourceProperties {
    #[serde(flatten)]
    pub event_source_common_properties: EventSourceCommonProperties,
    #[serde(rename = "eventSourceResourceId")]
    pub event_source_resource_id: String,
}
impl AzureEventSourceProperties {
    pub fn new(event_source_resource_id: String) -> Self {
        Self {
            event_source_common_properties: EventSourceCommonProperties::default(),
            event_source_resource_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateOrUpdateTrackedResourceProperties {
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl CreateOrUpdateTrackedResourceProperties {
    pub fn new(location: String) -> Self {
        Self { location, tags: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentCreateOrUpdateParameters {
    #[serde(flatten)]
    pub create_or_update_tracked_resource_properties: CreateOrUpdateTrackedResourceProperties,
    pub kind: environment_create_or_update_parameters::Kind,
    pub sku: Sku,
}
impl EnvironmentCreateOrUpdateParameters {
    pub fn new(
        create_or_update_tracked_resource_properties: CreateOrUpdateTrackedResourceProperties,
        kind: environment_create_or_update_parameters::Kind,
        sku: Sku,
    ) -> Self {
        Self {
            create_or_update_tracked_resource_properties,
            kind,
            sku,
        }
    }
}
pub mod environment_create_or_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Gen1,
        Gen2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentListResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EnvironmentResource>,
}
impl EnvironmentListResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    pub sku: Sku,
    pub kind: environment_resource::Kind,
}
impl EnvironmentResource {
    pub fn new(tracked_resource: TrackedResource, sku: Sku, kind: environment_resource::Kind) -> Self {
        Self {
            tracked_resource,
            sku,
            kind,
        }
    }
}
pub mod environment_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Gen1,
        Gen2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentResourceProperties {
    #[serde(flatten)]
    pub resource_properties: ResourceProperties,
    #[serde(rename = "dataAccessId", default, skip_serializing_if = "Option::is_none")]
    pub data_access_id: Option<String>,
    #[serde(rename = "dataAccessFqdn", default, skip_serializing_if = "Option::is_none")]
    pub data_access_fqdn: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<EnvironmentStatus>,
}
impl EnvironmentResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentStateDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl EnvironmentStateDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnvironmentStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub ingress: Option<IngressEnvironmentStatus>,
    #[serde(rename = "warmStorage", default, skip_serializing_if = "Option::is_none")]
    pub warm_storage: Option<WarmStorageEnvironmentStatus>,
}
impl EnvironmentStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentUpdateParameters {
    pub kind: environment_update_parameters::Kind,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl EnvironmentUpdateParameters {
    pub fn new(kind: environment_update_parameters::Kind) -> Self {
        Self { kind, tags: None }
    }
}
pub mod environment_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Gen1,
        Gen2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventHubEventSourceCommonProperties {
    #[serde(flatten)]
    pub azure_event_source_properties: AzureEventSourceProperties,
    #[serde(rename = "serviceBusNamespace")]
    pub service_bus_namespace: String,
    #[serde(rename = "eventHubName")]
    pub event_hub_name: String,
    #[serde(rename = "consumerGroupName")]
    pub consumer_group_name: String,
    #[serde(rename = "keyName")]
    pub key_name: String,
}
impl EventHubEventSourceCommonProperties {
    pub fn new(
        azure_event_source_properties: AzureEventSourceProperties,
        service_bus_namespace: String,
        event_hub_name: String,
        consumer_group_name: String,
        key_name: String,
    ) -> Self {
        Self {
            azure_event_source_properties,
            service_bus_namespace,
            event_hub_name,
            consumer_group_name,
            key_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventHubEventSourceCreateOrUpdateParameters {
    #[serde(flatten)]
    pub event_source_create_or_update_parameters: EventSourceCreateOrUpdateParameters,
    pub properties: EventHubEventSourceCreationProperties,
}
impl EventHubEventSourceCreateOrUpdateParameters {
    pub fn new(
        event_source_create_or_update_parameters: EventSourceCreateOrUpdateParameters,
        properties: EventHubEventSourceCreationProperties,
    ) -> Self {
        Self {
            event_source_create_or_update_parameters,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventHubEventSourceCreationProperties {
    #[serde(flatten)]
    pub event_hub_event_source_common_properties: EventHubEventSourceCommonProperties,
    #[serde(rename = "sharedAccessKey")]
    pub shared_access_key: String,
}
impl EventHubEventSourceCreationProperties {
    pub fn new(event_hub_event_source_common_properties: EventHubEventSourceCommonProperties, shared_access_key: String) -> Self {
        Self {
            event_hub_event_source_common_properties,
            shared_access_key,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubEventSourceMutableProperties {
    #[serde(flatten)]
    pub event_source_mutable_properties: EventSourceMutableProperties,
    #[serde(rename = "sharedAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_access_key: Option<String>,
}
impl EventHubEventSourceMutableProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventHubEventSourceResource {
    #[serde(flatten)]
    pub event_source_resource: EventSourceResource,
    pub properties: EventHubEventSourceResourceProperties,
}
impl EventHubEventSourceResource {
    pub fn new(event_source_resource: EventSourceResource, properties: EventHubEventSourceResourceProperties) -> Self {
        Self {
            event_source_resource,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventHubEventSourceResourceProperties {
    #[serde(flatten)]
    pub event_hub_event_source_common_properties: EventHubEventSourceCommonProperties,
}
impl EventHubEventSourceResourceProperties {
    pub fn new(event_hub_event_source_common_properties: EventHubEventSourceCommonProperties) -> Self {
        Self {
            event_hub_event_source_common_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventHubEventSourceUpdateParameters {
    #[serde(flatten)]
    pub event_source_update_parameters: EventSourceUpdateParameters,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EventHubEventSourceMutableProperties>,
}
impl EventHubEventSourceUpdateParameters {
    pub fn new(event_source_update_parameters: EventSourceUpdateParameters) -> Self {
        Self {
            event_source_update_parameters,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSourceCommonProperties {
    #[serde(flatten)]
    pub resource_properties: ResourceProperties,
    #[serde(rename = "timestampPropertyName", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_property_name: Option<String>,
    #[serde(rename = "localTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub local_timestamp: Option<LocalTimestamp>,
    #[serde(rename = "ingressStartAt", default, skip_serializing_if = "Option::is_none")]
    pub ingress_start_at: Option<IngressStartAtProperties>,
}
impl EventSourceCommonProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventSourceCreateOrUpdateParameters {
    #[serde(flatten)]
    pub create_or_update_tracked_resource_properties: CreateOrUpdateTrackedResourceProperties,
    pub kind: event_source_create_or_update_parameters::Kind,
    #[serde(rename = "localTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub local_timestamp: Option<LocalTimestamp>,
}
impl EventSourceCreateOrUpdateParameters {
    pub fn new(
        create_or_update_tracked_resource_properties: CreateOrUpdateTrackedResourceProperties,
        kind: event_source_create_or_update_parameters::Kind,
    ) -> Self {
        Self {
            create_or_update_tracked_resource_properties,
            kind,
            local_timestamp: None,
        }
    }
}
pub mod event_source_create_or_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "Microsoft.EventHub")]
        MicrosoftEventHub,
        #[serde(rename = "Microsoft.IoTHub")]
        MicrosoftIoTHub,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSourceListResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EventSourceResource>,
}
impl EventSourceListResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSourceMutableProperties {
    #[serde(rename = "timestampPropertyName", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_property_name: Option<String>,
}
impl EventSourceMutableProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventSourceResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    pub kind: event_source_resource::Kind,
}
impl EventSourceResource {
    pub fn new(tracked_resource: TrackedResource, kind: event_source_resource::Kind) -> Self {
        Self { tracked_resource, kind }
    }
}
pub mod event_source_resource {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "Microsoft.EventHub")]
        MicrosoftEventHub,
        #[serde(rename = "Microsoft.IoTHub")]
        MicrosoftIoTHub,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventSourceUpdateParameters {
    pub kind: event_source_update_parameters::Kind,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl EventSourceUpdateParameters {
    pub fn new(kind: event_source_update_parameters::Kind) -> Self {
        Self { kind, tags: None }
    }
}
pub mod event_source_update_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "Microsoft.EventHub")]
        MicrosoftEventHub,
        #[serde(rename = "Microsoft.IoTHub")]
        MicrosoftIoTHub,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen1EnvironmentCreateOrUpdateParameters {
    #[serde(flatten)]
    pub environment_create_or_update_parameters: EnvironmentCreateOrUpdateParameters,
    pub properties: Gen1EnvironmentCreationProperties,
}
impl Gen1EnvironmentCreateOrUpdateParameters {
    pub fn new(
        environment_create_or_update_parameters: EnvironmentCreateOrUpdateParameters,
        properties: Gen1EnvironmentCreationProperties,
    ) -> Self {
        Self {
            environment_create_or_update_parameters,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen1EnvironmentCreationProperties {
    #[serde(rename = "dataRetentionTime")]
    pub data_retention_time: String,
    #[serde(rename = "storageLimitExceededBehavior", default, skip_serializing_if = "Option::is_none")]
    pub storage_limit_exceeded_behavior: Option<gen1_environment_creation_properties::StorageLimitExceededBehavior>,
    #[serde(rename = "partitionKeyProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_key_properties: Vec<TimeSeriesIdProperty>,
}
impl Gen1EnvironmentCreationProperties {
    pub fn new(data_retention_time: String) -> Self {
        Self {
            data_retention_time,
            storage_limit_exceeded_behavior: None,
            partition_key_properties: Vec::new(),
        }
    }
}
pub mod gen1_environment_creation_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageLimitExceededBehavior {
        PurgeOldData,
        PauseIngress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Gen1EnvironmentMutableProperties {
    #[serde(rename = "dataRetentionTime", default, skip_serializing_if = "Option::is_none")]
    pub data_retention_time: Option<String>,
    #[serde(rename = "storageLimitExceededBehavior", default, skip_serializing_if = "Option::is_none")]
    pub storage_limit_exceeded_behavior: Option<gen1_environment_mutable_properties::StorageLimitExceededBehavior>,
}
impl Gen1EnvironmentMutableProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod gen1_environment_mutable_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageLimitExceededBehavior {
        PurgeOldData,
        PauseIngress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen1EnvironmentResource {
    #[serde(flatten)]
    pub environment_resource: EnvironmentResource,
    pub properties: Gen1EnvironmentResourceProperties,
}
impl Gen1EnvironmentResource {
    pub fn new(environment_resource: EnvironmentResource, properties: Gen1EnvironmentResourceProperties) -> Self {
        Self {
            environment_resource,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen1EnvironmentResourceProperties {
    #[serde(flatten)]
    pub gen1_environment_creation_properties: Gen1EnvironmentCreationProperties,
    #[serde(flatten)]
    pub environment_resource_properties: EnvironmentResourceProperties,
}
impl Gen1EnvironmentResourceProperties {
    pub fn new(gen1_environment_creation_properties: Gen1EnvironmentCreationProperties) -> Self {
        Self {
            gen1_environment_creation_properties,
            environment_resource_properties: EnvironmentResourceProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen1EnvironmentUpdateParameters {
    #[serde(flatten)]
    pub environment_update_parameters: EnvironmentUpdateParameters,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Gen1EnvironmentMutableProperties>,
}
impl Gen1EnvironmentUpdateParameters {
    pub fn new(environment_update_parameters: EnvironmentUpdateParameters) -> Self {
        Self {
            environment_update_parameters,
            sku: None,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen2EnvironmentCreateOrUpdateParameters {
    #[serde(flatten)]
    pub environment_create_or_update_parameters: EnvironmentCreateOrUpdateParameters,
    pub properties: Gen2EnvironmentCreationProperties,
}
impl Gen2EnvironmentCreateOrUpdateParameters {
    pub fn new(
        environment_create_or_update_parameters: EnvironmentCreateOrUpdateParameters,
        properties: Gen2EnvironmentCreationProperties,
    ) -> Self {
        Self {
            environment_create_or_update_parameters,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen2EnvironmentCreationProperties {
    #[serde(rename = "timeSeriesIdProperties")]
    pub time_series_id_properties: Vec<TimeSeriesIdProperty>,
    #[serde(rename = "storageConfiguration")]
    pub storage_configuration: Gen2StorageConfigurationInput,
    #[serde(rename = "warmStoreConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub warm_store_configuration: Option<WarmStoreConfigurationProperties>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<gen2_environment_creation_properties::PublicNetworkAccess>,
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
}
impl Gen2EnvironmentCreationProperties {
    pub fn new(time_series_id_properties: Vec<TimeSeriesIdProperty>, storage_configuration: Gen2StorageConfigurationInput) -> Self {
        Self {
            time_series_id_properties,
            storage_configuration,
            warm_store_configuration: None,
            public_network_access: None,
            private_endpoint_connections: Vec::new(),
        }
    }
}
pub mod gen2_environment_creation_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicNetworkAccess {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
    impl Default for PublicNetworkAccess {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Gen2EnvironmentMutableProperties {
    #[serde(rename = "storageConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub storage_configuration: Option<Gen2StorageConfigurationMutableProperties>,
    #[serde(rename = "warmStoreConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub warm_store_configuration: Option<WarmStoreConfigurationProperties>,
}
impl Gen2EnvironmentMutableProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen2EnvironmentResource {
    #[serde(flatten)]
    pub environment_resource: EnvironmentResource,
    pub properties: Gen2EnvironmentResourceProperties,
}
impl Gen2EnvironmentResource {
    pub fn new(environment_resource: EnvironmentResource, properties: Gen2EnvironmentResourceProperties) -> Self {
        Self {
            environment_resource,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen2EnvironmentResourceProperties {
    #[serde(flatten)]
    pub environment_resource_properties: EnvironmentResourceProperties,
    #[serde(rename = "timeSeriesIdProperties")]
    pub time_series_id_properties: Vec<TimeSeriesIdProperty>,
    #[serde(rename = "storageConfiguration")]
    pub storage_configuration: Gen2StorageConfigurationOutput,
    #[serde(rename = "warmStoreConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub warm_store_configuration: Option<WarmStoreConfigurationProperties>,
    #[serde(rename = "publicNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub public_network_access: Option<gen2_environment_resource_properties::PublicNetworkAccess>,
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
}
impl Gen2EnvironmentResourceProperties {
    pub fn new(time_series_id_properties: Vec<TimeSeriesIdProperty>, storage_configuration: Gen2StorageConfigurationOutput) -> Self {
        Self {
            environment_resource_properties: EnvironmentResourceProperties::default(),
            time_series_id_properties,
            storage_configuration,
            warm_store_configuration: None,
            public_network_access: None,
            private_endpoint_connections: Vec::new(),
        }
    }
}
pub mod gen2_environment_resource_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicNetworkAccess {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
    impl Default for PublicNetworkAccess {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen2EnvironmentUpdateParameters {
    #[serde(flatten)]
    pub environment_update_parameters: EnvironmentUpdateParameters,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Gen2EnvironmentMutableProperties>,
}
impl Gen2EnvironmentUpdateParameters {
    pub fn new(environment_update_parameters: EnvironmentUpdateParameters) -> Self {
        Self {
            environment_update_parameters,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen2StorageConfigurationInput {
    #[serde(rename = "accountName")]
    pub account_name: String,
    #[serde(rename = "managementKey")]
    pub management_key: String,
}
impl Gen2StorageConfigurationInput {
    pub fn new(account_name: String, management_key: String) -> Self {
        Self {
            account_name,
            management_key,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen2StorageConfigurationMutableProperties {
    #[serde(rename = "managementKey")]
    pub management_key: String,
}
impl Gen2StorageConfigurationMutableProperties {
    pub fn new(management_key: String) -> Self {
        Self { management_key }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Gen2StorageConfigurationOutput {
    #[serde(rename = "accountName")]
    pub account_name: String,
}
impl Gen2StorageConfigurationOutput {
    pub fn new(account_name: String) -> Self {
        Self { account_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IngressEnvironmentStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ingress_environment_status::State>,
    #[serde(rename = "stateDetails", default, skip_serializing_if = "Option::is_none")]
    pub state_details: Option<EnvironmentStateDetails>,
}
impl IngressEnvironmentStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ingress_environment_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
        Ready,
        Running,
        Paused,
        Unknown,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IngressStartAtProperties {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<ingress_start_at_properties::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
}
impl IngressStartAtProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ingress_start_at_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        EarliestAvailable,
        EventSourceCreationTime,
        CustomEnqueuedTime,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IoTHubEventSourceCommonProperties {
    #[serde(flatten)]
    pub azure_event_source_properties: AzureEventSourceProperties,
    #[serde(rename = "iotHubName")]
    pub iot_hub_name: String,
    #[serde(rename = "consumerGroupName")]
    pub consumer_group_name: String,
    #[serde(rename = "keyName")]
    pub key_name: String,
}
impl IoTHubEventSourceCommonProperties {
    pub fn new(
        azure_event_source_properties: AzureEventSourceProperties,
        iot_hub_name: String,
        consumer_group_name: String,
        key_name: String,
    ) -> Self {
        Self {
            azure_event_source_properties,
            iot_hub_name,
            consumer_group_name,
            key_name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IoTHubEventSourceCreateOrUpdateParameters {
    #[serde(flatten)]
    pub event_source_create_or_update_parameters: EventSourceCreateOrUpdateParameters,
    pub properties: IoTHubEventSourceCreationProperties,
}
impl IoTHubEventSourceCreateOrUpdateParameters {
    pub fn new(
        event_source_create_or_update_parameters: EventSourceCreateOrUpdateParameters,
        properties: IoTHubEventSourceCreationProperties,
    ) -> Self {
        Self {
            event_source_create_or_update_parameters,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IoTHubEventSourceCreationProperties {
    #[serde(flatten)]
    pub io_t_hub_event_source_common_properties: IoTHubEventSourceCommonProperties,
    #[serde(rename = "sharedAccessKey")]
    pub shared_access_key: String,
}
impl IoTHubEventSourceCreationProperties {
    pub fn new(io_t_hub_event_source_common_properties: IoTHubEventSourceCommonProperties, shared_access_key: String) -> Self {
        Self {
            io_t_hub_event_source_common_properties,
            shared_access_key,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IoTHubEventSourceMutableProperties {
    #[serde(flatten)]
    pub event_source_mutable_properties: EventSourceMutableProperties,
    #[serde(rename = "sharedAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_access_key: Option<String>,
}
impl IoTHubEventSourceMutableProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IoTHubEventSourceResource {
    #[serde(flatten)]
    pub event_source_resource: EventSourceResource,
    pub properties: IoTHubEventSourceResourceProperties,
}
impl IoTHubEventSourceResource {
    pub fn new(event_source_resource: EventSourceResource, properties: IoTHubEventSourceResourceProperties) -> Self {
        Self {
            event_source_resource,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IoTHubEventSourceResourceProperties {
    #[serde(flatten)]
    pub io_t_hub_event_source_common_properties: IoTHubEventSourceCommonProperties,
}
impl IoTHubEventSourceResourceProperties {
    pub fn new(io_t_hub_event_source_common_properties: IoTHubEventSourceCommonProperties) -> Self {
        Self {
            io_t_hub_event_source_common_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IoTHubEventSourceUpdateParameters {
    #[serde(flatten)]
    pub event_source_update_parameters: EventSourceUpdateParameters,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IoTHubEventSourceMutableProperties>,
}
impl IoTHubEventSourceUpdateParameters {
    pub fn new(event_source_update_parameters: EventSourceUpdateParameters) -> Self {
        Self {
            event_source_update_parameters,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalTimestamp {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<local_timestamp::Format>,
    #[serde(rename = "timeZoneOffset", default, skip_serializing_if = "Option::is_none")]
    pub time_zone_offset: Option<local_timestamp::TimeZoneOffset>,
}
impl LocalTimestamp {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod local_timestamp {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Format {
        Embedded,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct TimeZoneOffset {
        #[serde(rename = "propertyName", default, skip_serializing_if = "Option::is_none")]
        pub property_name: Option<String>,
    }
    impl TimeZoneOffset {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl LogSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricAvailability {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl MetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Dimension>,
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub availabilities: Vec<MetricAvailability>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(rename = "resourceIdDimensionNameOverride", default, skip_serializing_if = "Option::is_none")]
    pub resource_id_dimension_name_override: Option<String>,
}
impl MetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationProperties>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationProperties {
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<ServiceSpecification>,
}
impl OperationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpointConnection>,
}
impl PrivateEndpointConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrivateEndpointConnectionProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<PrivateEndpointConnectionProvisioningState>,
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[serde(rename = "groupIds", default, skip_serializing_if = "Option::is_none")]
    pub group_ids: Option<PrivateEndpointGroupIds>,
    #[serde(rename = "privateLinkServiceConnectionState")]
    pub private_link_service_connection_state: PrivateLinkServiceConnectionState,
}
impl PrivateEndpointConnectionProperties {
    pub fn new(private_link_service_connection_state: PrivateLinkServiceConnectionState) -> Self {
        Self {
            provisioning_state: None,
            private_endpoint: None,
            group_ids: None,
            private_link_service_connection_state,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PrivateEndpointConnectionProvisioningState {
    Succeeded,
    Creating,
    Deleting,
    Failed,
}
pub type PrivateEndpointGroupIds = Vec<String>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PrivateEndpointServiceConnectionStatus {
    Pending,
    Approved,
    Rejected,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkResourceProperties>,
}
impl PrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateLinkResource>,
}
impl PrivateLinkResourceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkResourceProperties {
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl PrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionState {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<PrivateEndpointServiceConnectionStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProvisioningState {
    Accepted,
    Creating,
    Updating,
    Succeeded,
    Failed,
    Deleting,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReferenceDataSetCreateOrUpdateParameters {
    #[serde(flatten)]
    pub create_or_update_tracked_resource_properties: CreateOrUpdateTrackedResourceProperties,
    pub properties: ReferenceDataSetCreationProperties,
}
impl ReferenceDataSetCreateOrUpdateParameters {
    pub fn new(
        create_or_update_tracked_resource_properties: CreateOrUpdateTrackedResourceProperties,
        properties: ReferenceDataSetCreationProperties,
    ) -> Self {
        Self {
            create_or_update_tracked_resource_properties,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReferenceDataSetCreationProperties {
    #[serde(rename = "keyProperties")]
    pub key_properties: Vec<ReferenceDataSetKeyProperty>,
    #[serde(rename = "dataStringComparisonBehavior", default, skip_serializing_if = "Option::is_none")]
    pub data_string_comparison_behavior: Option<reference_data_set_creation_properties::DataStringComparisonBehavior>,
}
impl ReferenceDataSetCreationProperties {
    pub fn new(key_properties: Vec<ReferenceDataSetKeyProperty>) -> Self {
        Self {
            key_properties,
            data_string_comparison_behavior: None,
        }
    }
}
pub mod reference_data_set_creation_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataStringComparisonBehavior {
        Ordinal,
        OrdinalIgnoreCase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReferenceDataSetKeyProperty {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<reference_data_set_key_property::Type>,
}
impl ReferenceDataSetKeyProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod reference_data_set_key_property {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        String,
        Double,
        Bool,
        DateTime,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReferenceDataSetListResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReferenceDataSetResource>,
}
impl ReferenceDataSetListResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReferenceDataSetResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReferenceDataSetResourceProperties>,
}
impl ReferenceDataSetResource {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReferenceDataSetResourceProperties {
    #[serde(flatten)]
    pub reference_data_set_creation_properties: ReferenceDataSetCreationProperties,
    #[serde(flatten)]
    pub resource_properties: ResourceProperties,
}
impl ReferenceDataSetResourceProperties {
    pub fn new(reference_data_set_creation_properties: ReferenceDataSetCreationProperties) -> Self {
        Self {
            reference_data_set_creation_properties,
            resource_properties: ResourceProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReferenceDataSetUpdateParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ReferenceDataSetUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
}
impl ResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceSpecification {
    #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_specifications: Vec<MetricSpecification>,
    #[serde(rename = "logSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub log_specifications: Vec<LogSpecification>,
}
impl ServiceSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Sku {
    pub name: sku::Name,
    pub capacity: i32,
}
impl Sku {
    pub fn new(name: sku::Name, capacity: i32) -> Self {
        Self { name, capacity }
    }
}
pub mod sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        S1,
        S2,
        P1,
        L1,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TimeSeriesIdProperty {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<time_series_id_property::Type>,
}
impl TimeSeriesIdProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod time_series_id_property {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        String,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WarmStorageEnvironmentStatus {
    #[serde(rename = "propertiesUsage", default, skip_serializing_if = "Option::is_none")]
    pub properties_usage: Option<WarmStoragePropertiesUsage>,
}
impl WarmStorageEnvironmentStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WarmStoragePropertiesUsage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<warm_storage_properties_usage::State>,
    #[serde(rename = "stateDetails", default, skip_serializing_if = "Option::is_none")]
    pub state_details: Option<WarmStoragePropertiesUsageStateDetails>,
}
impl WarmStoragePropertiesUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod warm_storage_properties_usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Ok,
        Error,
        Unknown,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WarmStoragePropertiesUsageStateDetails {
    #[serde(rename = "currentCount", default, skip_serializing_if = "Option::is_none")]
    pub current_count: Option<i32>,
    #[serde(rename = "maxCount", default, skip_serializing_if = "Option::is_none")]
    pub max_count: Option<i32>,
}
impl WarmStoragePropertiesUsageStateDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WarmStoreConfigurationProperties {
    #[serde(rename = "dataRetention")]
    pub data_retention: String,
}
impl WarmStoreConfigurationProperties {
    pub fn new(data_retention: String) -> Self {
        Self { data_retention }
    }
}
