#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckNameAvailabilityInput {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: check_name_availability_input::Type,
}
impl CheckNameAvailabilityInput {
    pub fn new(name: String, type_: check_name_availability_input::Type) -> Self {
        Self { name, type_ }
    }
}
pub mod check_name_availability_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.Support/supportTickets")]
        MicrosoftSupportSupportTickets,
        #[serde(rename = "Microsoft.Support/communications")]
        MicrosoftSupportCommunications,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckNameAvailabilityOutput {
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl CheckNameAvailabilityOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CommunicationDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CommunicationDetailsProperties>,
}
impl CommunicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommunicationDetailsProperties {
    #[serde(rename = "communicationType", default, skip_serializing_if = "Option::is_none")]
    pub communication_type: Option<communication_details_properties::CommunicationType>,
    #[serde(rename = "communicationDirection", default, skip_serializing_if = "Option::is_none")]
    pub communication_direction: Option<communication_details_properties::CommunicationDirection>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sender: Option<String>,
    pub subject: String,
    pub body: String,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
}
impl CommunicationDetailsProperties {
    pub fn new(subject: String, body: String) -> Self {
        Self {
            communication_type: None,
            communication_direction: None,
            sender: None,
            subject,
            body,
            created_date: None,
        }
    }
}
pub mod communication_details_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CommunicationType {
        #[serde(rename = "web")]
        Web,
        #[serde(rename = "phone")]
        Phone,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CommunicationDirection {
        #[serde(rename = "inbound")]
        Inbound,
        #[serde(rename = "outbound")]
        Outbound,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CommunicationsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CommunicationDetails>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CommunicationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContactProfile {
    #[serde(rename = "firstName")]
    pub first_name: String,
    #[serde(rename = "lastName")]
    pub last_name: String,
    #[serde(rename = "preferredContactMethod")]
    pub preferred_contact_method: contact_profile::PreferredContactMethod,
    #[serde(rename = "primaryEmailAddress")]
    pub primary_email_address: String,
    #[serde(rename = "additionalEmailAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_email_addresses: Vec<String>,
    #[serde(rename = "phoneNumber", default, skip_serializing_if = "Option::is_none")]
    pub phone_number: Option<String>,
    #[serde(rename = "preferredTimeZone")]
    pub preferred_time_zone: String,
    pub country: String,
    #[serde(rename = "preferredSupportLanguage")]
    pub preferred_support_language: String,
}
impl ContactProfile {
    pub fn new(
        first_name: String,
        last_name: String,
        preferred_contact_method: contact_profile::PreferredContactMethod,
        primary_email_address: String,
        preferred_time_zone: String,
        country: String,
        preferred_support_language: String,
    ) -> Self {
        Self {
            first_name,
            last_name,
            preferred_contact_method,
            primary_email_address,
            additional_email_addresses: Vec::new(),
            phone_number: None,
            preferred_time_zone,
            country,
            preferred_support_language,
        }
    }
}
pub mod contact_profile {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreferredContactMethod {
        #[serde(rename = "email")]
        Email,
        #[serde(rename = "phone")]
        Phone,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExceptionResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ServiceError>,
}
impl ExceptionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
}
impl OperationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProblemClassification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProblemClassificationProperties>,
}
impl ProblemClassification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProblemClassificationProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl ProblemClassificationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProblemClassificationsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProblemClassification>,
}
impl ProblemClassificationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaChangeRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub payload: Option<String>,
}
impl QuotaChangeRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaTicketDetails {
    #[serde(rename = "quotaChangeRequestSubType", default, skip_serializing_if = "Option::is_none")]
    pub quota_change_request_sub_type: Option<String>,
    #[serde(rename = "quotaChangeRequestVersion", default, skip_serializing_if = "Option::is_none")]
    pub quota_change_request_version: Option<String>,
    #[serde(rename = "quotaChangeRequests", default, skip_serializing_if = "Vec::is_empty")]
    pub quota_change_requests: Vec<QuotaChangeRequest>,
}
impl QuotaTicketDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Service {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceProperties>,
}
impl Service {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ServiceErrorDetail>,
}
impl ServiceError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceErrorDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl ServiceErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceLevelAgreement {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[serde(rename = "slaMinutes", default, skip_serializing_if = "Option::is_none")]
    pub sla_minutes: Option<i32>,
}
impl ServiceLevelAgreement {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "resourceTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_types: Vec<String>,
}
impl ServiceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServicesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Service>,
}
impl ServicesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SupportEngineer {
    #[serde(rename = "emailAddress", default, skip_serializing_if = "Option::is_none")]
    pub email_address: Option<String>,
}
impl SupportEngineer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SupportTicketDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SupportTicketDetailsProperties>,
}
impl SupportTicketDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SupportTicketDetailsProperties {
    #[serde(rename = "supportTicketId", default, skip_serializing_if = "Option::is_none")]
    pub support_ticket_id: Option<String>,
    pub description: String,
    #[serde(rename = "problemClassificationId")]
    pub problem_classification_id: String,
    #[serde(rename = "problemClassificationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub problem_classification_display_name: Option<String>,
    pub severity: support_ticket_details_properties::Severity,
    #[serde(rename = "enrollmentId", default, skip_serializing_if = "Option::is_none")]
    pub enrollment_id: Option<String>,
    #[serde(rename = "require24X7Response", default, skip_serializing_if = "Option::is_none")]
    pub require24_x7_response: Option<bool>,
    #[serde(rename = "contactDetails")]
    pub contact_details: ContactProfile,
    #[serde(rename = "serviceLevelAgreement", default, skip_serializing_if = "Option::is_none")]
    pub service_level_agreement: Option<ServiceLevelAgreement>,
    #[serde(rename = "supportEngineer", default, skip_serializing_if = "Option::is_none")]
    pub support_engineer: Option<SupportEngineer>,
    #[serde(rename = "supportPlanType", default, skip_serializing_if = "Option::is_none")]
    pub support_plan_type: Option<String>,
    pub title: String,
    #[serde(rename = "problemStartTime", default, skip_serializing_if = "Option::is_none")]
    pub problem_start_time: Option<String>,
    #[serde(rename = "serviceId")]
    pub service_id: String,
    #[serde(rename = "serviceDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub service_display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "createdDate", default, skip_serializing_if = "Option::is_none")]
    pub created_date: Option<String>,
    #[serde(rename = "modifiedDate", default, skip_serializing_if = "Option::is_none")]
    pub modified_date: Option<String>,
    #[serde(rename = "technicalTicketDetails", default, skip_serializing_if = "Option::is_none")]
    pub technical_ticket_details: Option<TechnicalTicketDetails>,
    #[serde(rename = "quotaTicketDetails", default, skip_serializing_if = "Option::is_none")]
    pub quota_ticket_details: Option<QuotaTicketDetails>,
}
impl SupportTicketDetailsProperties {
    pub fn new(
        description: String,
        problem_classification_id: String,
        severity: support_ticket_details_properties::Severity,
        contact_details: ContactProfile,
        title: String,
        service_id: String,
    ) -> Self {
        Self {
            support_ticket_id: None,
            description,
            problem_classification_id,
            problem_classification_display_name: None,
            severity,
            enrollment_id: None,
            require24_x7_response: None,
            contact_details,
            service_level_agreement: None,
            support_engineer: None,
            support_plan_type: None,
            title,
            problem_start_time: None,
            service_id,
            service_display_name: None,
            status: None,
            created_date: None,
            modified_date: None,
            technical_ticket_details: None,
            quota_ticket_details: None,
        }
    }
}
pub mod support_ticket_details_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        #[serde(rename = "minimal")]
        Minimal,
        #[serde(rename = "moderate")]
        Moderate,
        #[serde(rename = "critical")]
        Critical,
        #[serde(rename = "highestcriticalimpact")]
        Highestcriticalimpact,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SupportTicketsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SupportTicketDetails>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SupportTicketsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TechnicalTicketDetails {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl TechnicalTicketDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateContactProfile {
    #[serde(rename = "firstName", default, skip_serializing_if = "Option::is_none")]
    pub first_name: Option<String>,
    #[serde(rename = "lastName", default, skip_serializing_if = "Option::is_none")]
    pub last_name: Option<String>,
    #[serde(rename = "preferredContactMethod", default, skip_serializing_if = "Option::is_none")]
    pub preferred_contact_method: Option<update_contact_profile::PreferredContactMethod>,
    #[serde(rename = "primaryEmailAddress", default, skip_serializing_if = "Option::is_none")]
    pub primary_email_address: Option<String>,
    #[serde(rename = "additionalEmailAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_email_addresses: Vec<String>,
    #[serde(rename = "phoneNumber", default, skip_serializing_if = "Option::is_none")]
    pub phone_number: Option<String>,
    #[serde(rename = "preferredTimeZone", default, skip_serializing_if = "Option::is_none")]
    pub preferred_time_zone: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[serde(rename = "preferredSupportLanguage", default, skip_serializing_if = "Option::is_none")]
    pub preferred_support_language: Option<String>,
}
impl UpdateContactProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod update_contact_profile {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreferredContactMethod {
        #[serde(rename = "email")]
        Email,
        #[serde(rename = "phone")]
        Phone,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateSupportTicket {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<update_support_ticket::Severity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<update_support_ticket::Status>,
    #[serde(rename = "contactDetails", default, skip_serializing_if = "Option::is_none")]
    pub contact_details: Option<UpdateContactProfile>,
}
impl UpdateSupportTicket {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod update_support_ticket {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        #[serde(rename = "minimal")]
        Minimal,
        #[serde(rename = "moderate")]
        Moderate,
        #[serde(rename = "critical")]
        Critical,
        #[serde(rename = "highestcriticalimpact")]
        Highestcriticalimpact,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "open")]
        Open,
        #[serde(rename = "closed")]
        Closed,
    }
}
