#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccessControlRecord {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: AccessControlRecordProperties,
}
impl AccessControlRecord {
    pub fn new(properties: AccessControlRecordProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccessControlRecordList {
    pub value: Vec<AccessControlRecord>,
}
impl AccessControlRecordList {
    pub fn new(value: Vec<AccessControlRecord>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccessControlRecordProperties {
    #[serde(rename = "initiatorName")]
    pub initiator_name: String,
}
impl AccessControlRecordProperties {
    pub fn new(initiator_name: String) -> Self {
        Self { initiator_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Alert {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: AlertProperties,
}
impl Alert {
    pub fn new(properties: AlertProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertErrorDetails {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub occurences: Option<i32>,
}
impl AlertErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<alert_filter::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<alert_filter::Severity>,
    #[serde(rename = "sourceType", default, skip_serializing_if = "Option::is_none")]
    pub source_type: Option<alert_filter::SourceType>,
    #[serde(rename = "sourceName", default, skip_serializing_if = "Option::is_none")]
    pub source_name: Option<String>,
    #[serde(rename = "appearedOnTime", default, skip_serializing_if = "Option::is_none")]
    pub appeared_on_time: Option<String>,
}
impl AlertFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Active,
        Cleared,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Informational,
        Warning,
        Critical,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceType {
        Resource,
        Device,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertList {
    pub value: Vec<Alert>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertList {
    pub fn new(value: Vec<Alert>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertProperties {
    pub title: String,
    pub scope: alert_properties::Scope,
    #[serde(rename = "alertType")]
    pub alert_type: String,
    #[serde(rename = "appearedAtTime")]
    pub appeared_at_time: String,
    #[serde(rename = "appearedAtSourceTime")]
    pub appeared_at_source_time: String,
    #[serde(rename = "clearedAtTime", default, skip_serializing_if = "Option::is_none")]
    pub cleared_at_time: Option<String>,
    #[serde(rename = "clearedAtSourceTime", default, skip_serializing_if = "Option::is_none")]
    pub cleared_at_source_time: Option<String>,
    pub source: AlertSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recommendation: Option<String>,
    #[serde(rename = "resolutionReason", default, skip_serializing_if = "Option::is_none")]
    pub resolution_reason: Option<String>,
    pub severity: alert_properties::Severity,
    pub status: alert_properties::Status,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Option::is_none")]
    pub error_details: Option<AlertErrorDetails>,
    #[serde(rename = "detailedInformation", default, skip_serializing_if = "Option::is_none")]
    pub detailed_information: Option<serde_json::Value>,
}
impl AlertProperties {
    pub fn new(
        title: String,
        scope: alert_properties::Scope,
        alert_type: String,
        appeared_at_time: String,
        appeared_at_source_time: String,
        source: AlertSource,
        severity: alert_properties::Severity,
        status: alert_properties::Status,
    ) -> Self {
        Self {
            title,
            scope,
            alert_type,
            appeared_at_time,
            appeared_at_source_time,
            cleared_at_time: None,
            cleared_at_source_time: None,
            source,
            recommendation: None,
            resolution_reason: None,
            severity,
            status,
            error_details: None,
            detailed_information: None,
        }
    }
}
pub mod alert_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Scope {
        Resource,
        Device,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Informational,
        Warning,
        Critical,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Active,
        Cleared,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertSettings {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: AlertSettingsProperties,
}
impl AlertSettings {
    pub fn new(properties: AlertSettingsProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertSettingsProperties {
    #[serde(rename = "emailNotification")]
    pub email_notification: alert_settings_properties::EmailNotification,
    #[serde(rename = "notificationToServiceOwners")]
    pub notification_to_service_owners: alert_settings_properties::NotificationToServiceOwners,
    #[serde(rename = "alertNotificationCulture")]
    pub alert_notification_culture: String,
    #[serde(rename = "additionalRecipientEmailList", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_recipient_email_list: Vec<String>,
}
impl AlertSettingsProperties {
    pub fn new(
        email_notification: alert_settings_properties::EmailNotification,
        notification_to_service_owners: alert_settings_properties::NotificationToServiceOwners,
        alert_notification_culture: String,
    ) -> Self {
        Self {
            email_notification,
            notification_to_service_owners,
            alert_notification_culture,
            additional_recipient_email_list: Vec::new(),
        }
    }
}
pub mod alert_settings_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EmailNotification {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NotificationToServiceOwners {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertSource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[serde(rename = "alertSourceType", default, skip_serializing_if = "Option::is_none")]
    pub alert_source_type: Option<alert_source::AlertSourceType>,
}
impl AlertSource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_source {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AlertSourceType {
        Resource,
        Device,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AsymmetricEncryptedSecret {
    pub value: String,
    #[serde(rename = "encryptionCertificateThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub encryption_certificate_thumbprint: Option<String>,
    #[serde(rename = "encryptionAlgorithm")]
    pub encryption_algorithm: asymmetric_encrypted_secret::EncryptionAlgorithm,
}
impl AsymmetricEncryptedSecret {
    pub fn new(value: String, encryption_algorithm: asymmetric_encrypted_secret::EncryptionAlgorithm) -> Self {
        Self {
            value,
            encryption_certificate_thumbprint: None,
            encryption_algorithm,
        }
    }
}
pub mod asymmetric_encrypted_secret {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EncryptionAlgorithm {
        None,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "RSAES_PKCS1_v_1_5")]
        RsaesPkcs1V15,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProviderOperation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<AvailableProviderOperationDisplay>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AvailableProviderOperationProperties>,
}
impl AvailableProviderOperation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProviderOperationDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl AvailableProviderOperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProviderOperationProperties {}
impl AvailableProviderOperationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailableProviderOperations {
    pub value: Vec<AvailableProviderOperation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailableProviderOperations {
    pub fn new(value: Vec<AvailableProviderOperation>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Backup {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: BackupProperties,
}
impl Backup {
    pub fn new(properties: BackupProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupElement {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: BackupElementProperties,
}
impl BackupElement {
    pub fn new(properties: BackupElementProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupElementProperties {
    #[serde(rename = "sizeInBytes")]
    pub size_in_bytes: i64,
    #[serde(rename = "endpointName")]
    pub endpoint_name: String,
    #[serde(rename = "dataPolicy")]
    pub data_policy: backup_element_properties::DataPolicy,
}
impl BackupElementProperties {
    pub fn new(size_in_bytes: i64, endpoint_name: String, data_policy: backup_element_properties::DataPolicy) -> Self {
        Self {
            size_in_bytes,
            endpoint_name,
            data_policy,
        }
    }
}
pub mod backup_element_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataPolicy {
        Invalid,
        Local,
        Tiered,
        Cloud,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupFilter {
    #[serde(rename = "initiatedBy", default, skip_serializing_if = "Option::is_none")]
    pub initiated_by: Option<backup_filter::InitiatedBy>,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
}
impl BackupFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InitiatedBy {
        Manual,
        Scheduled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupList {
    pub value: Vec<Backup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BackupList {
    pub fn new(value: Vec<Backup>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupProperties {
    #[serde(rename = "targetId", default, skip_serializing_if = "Option::is_none")]
    pub target_id: Option<String>,
    #[serde(rename = "targetType", default, skip_serializing_if = "Option::is_none")]
    pub target_type: Option<String>,
    #[serde(rename = "sizeInBytes")]
    pub size_in_bytes: i64,
    #[serde(rename = "createdTime", default, skip_serializing_if = "Option::is_none")]
    pub created_time: Option<String>,
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[serde(rename = "initiatedBy")]
    pub initiated_by: backup_properties::InitiatedBy,
    #[serde(rename = "deviceId")]
    pub device_id: String,
    pub elements: Vec<BackupElement>,
}
impl BackupProperties {
    pub fn new(size_in_bytes: i64, initiated_by: backup_properties::InitiatedBy, device_id: String, elements: Vec<BackupElement>) -> Self {
        Self {
            target_id: None,
            target_type: None,
            size_in_bytes,
            created_time: None,
            expiration_time: None,
            initiated_by,
            device_id,
            elements,
        }
    }
}
pub mod backup_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InitiatedBy {
        Manual,
        Scheduled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupScheduleGroup {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: BackupScheduleGroupProperties,
}
impl BackupScheduleGroup {
    pub fn new(properties: BackupScheduleGroupProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupScheduleGroupList {
    pub value: Vec<BackupScheduleGroup>,
}
impl BackupScheduleGroupList {
    pub fn new(value: Vec<BackupScheduleGroup>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupScheduleGroupProperties {
    #[serde(rename = "startTime")]
    pub start_time: Time,
}
impl BackupScheduleGroupProperties {
    pub fn new(start_time: Time) -> Self {
        Self { start_time }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BaseModel {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl BaseModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ChapProperties {
    pub password: AsymmetricEncryptedSecret,
}
impl ChapProperties {
    pub fn new(password: AsymmetricEncryptedSecret) -> Self {
        Self { password }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ChapSettings {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: ChapProperties,
}
impl ChapSettings {
    pub fn new(properties: ChapProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ChapSettingsList {
    pub value: Vec<ChapSettings>,
}
impl ChapSettingsList {
    pub fn new(value: Vec<ChapSettings>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ClearAlertRequest {
    #[serde(rename = "resolutionMessage", default, skip_serializing_if = "Option::is_none")]
    pub resolution_message: Option<String>,
    pub alerts: Vec<String>,
}
impl ClearAlertRequest {
    pub fn new(alerts: Vec<String>) -> Self {
        Self {
            resolution_message: None,
            alerts,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloneRequest {
    pub properties: CloneRequestProperties,
}
impl CloneRequest {
    pub fn new(properties: CloneRequestProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloneRequestProperties {
    #[serde(rename = "targetDeviceId")]
    pub target_device_id: String,
    #[serde(rename = "targetAccessPointId")]
    pub target_access_point_id: String,
    #[serde(rename = "newEndpointName")]
    pub new_endpoint_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub share: Option<FileShare>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disk: Option<IscsiDisk>,
}
impl CloneRequestProperties {
    pub fn new(target_device_id: String, target_access_point_id: String, new_endpoint_name: String) -> Self {
        Self {
            target_device_id,
            target_access_point_id,
            new_endpoint_name,
            share: None,
            disk: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Device {
    #[serde(flatten)]
    pub base_model: BaseModel,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DeviceProperties>,
}
impl Device {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceDetails {
    #[serde(rename = "endpointCount", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_count: Option<i32>,
    #[serde(rename = "totalStorageInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_storage_in_bytes: Option<i64>,
    #[serde(rename = "totalLocalStorageInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_local_storage_in_bytes: Option<i64>,
    #[serde(rename = "provisionedStorageInBytes", default, skip_serializing_if = "Option::is_none")]
    pub provisioned_storage_in_bytes: Option<i64>,
    #[serde(rename = "provisionedLocalStorageInBytes", default, skip_serializing_if = "Option::is_none")]
    pub provisioned_local_storage_in_bytes: Option<i64>,
    #[serde(rename = "usingStorageInBytes", default, skip_serializing_if = "Option::is_none")]
    pub using_storage_in_bytes: Option<i64>,
    #[serde(rename = "usingLocalStorageInBytes", default, skip_serializing_if = "Option::is_none")]
    pub using_local_storage_in_bytes: Option<i64>,
    #[serde(rename = "totalBackupSizeInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_backup_size_in_bytes: Option<i64>,
    #[serde(rename = "availableStorageInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_storage_in_bytes: Option<i64>,
    #[serde(rename = "availableLocalStorageInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_local_storage_in_bytes: Option<i64>,
}
impl DeviceDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeviceList {
    pub value: Vec<Device>,
}
impl DeviceList {
    pub fn new(value: Vec<Device>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DevicePatch {
    #[serde(rename = "deviceDescription", default, skip_serializing_if = "Option::is_none")]
    pub device_description: Option<String>,
}
impl DevicePatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceProperties {
    #[serde(rename = "activationTime", default, skip_serializing_if = "Option::is_none")]
    pub activation_time: Option<String>,
    #[serde(rename = "allowedDeviceOperations", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_device_operations: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub culture: Option<String>,
    #[serde(rename = "deviceCapabilities", default, skip_serializing_if = "Vec::is_empty")]
    pub device_capabilities: Vec<String>,
    #[serde(rename = "deviceDescription", default, skip_serializing_if = "Option::is_none")]
    pub device_description: Option<String>,
    #[serde(rename = "domainName", default, skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    #[serde(rename = "deviceSoftwareVersion", default, skip_serializing_if = "Option::is_none")]
    pub device_software_version: Option<String>,
    #[serde(rename = "friendlySoftwareName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_software_name: Option<String>,
    #[serde(rename = "deviceConfigurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub device_configuration_status: Option<device_properties::DeviceConfigurationStatus>,
    #[serde(rename = "modelDescription", default, skip_serializing_if = "Option::is_none")]
    pub model_description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<device_properties::Status>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<device_properties::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<DeviceDetails>,
}
impl DeviceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod device_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeviceConfigurationStatus {
        Complete,
        Pending,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Unknown,
        Online,
        Offline,
        RequiresAttention,
        MaintenanceMode,
        Creating,
        Provisioning,
        Deleted,
        ReadyToSetup,
        Deactivated,
        Deactivating,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        Appliance,
        VirtualAppliance,
        Series9000OnPremVirtualAppliance,
        Series9000VirtualAppliance,
        Series9000PhysicalAppliance,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptionSettings {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: EncryptionSettingsProperties,
}
impl EncryptionSettings {
    pub fn new(properties: EncryptionSettingsProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptionSettingsProperties {
    #[serde(rename = "encryptionStatus")]
    pub encryption_status: encryption_settings_properties::EncryptionStatus,
    #[serde(rename = "keyRolloverStatus")]
    pub key_rollover_status: encryption_settings_properties::KeyRolloverStatus,
}
impl EncryptionSettingsProperties {
    pub fn new(
        encryption_status: encryption_settings_properties::EncryptionStatus,
        key_rollover_status: encryption_settings_properties::KeyRolloverStatus,
    ) -> Self {
        Self {
            encryption_status,
            key_rollover_status,
        }
    }
}
pub mod encryption_settings_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EncryptionStatus {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyRolloverStatus {
        Required,
        NotRequired,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Error {
    #[serde(rename = "errorCode")]
    pub error_code: String,
    pub message: Message,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<Item>,
}
impl Error {
    pub fn new(error_code: String, message: Message) -> Self {
        Self {
            error_code,
            message,
            values: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverRequest {
    #[serde(rename = "accesspointIds", default, skip_serializing_if = "Vec::is_empty")]
    pub accesspoint_ids: Vec<String>,
    #[serde(rename = "targetDeviceId", default, skip_serializing_if = "Option::is_none")]
    pub target_device_id: Option<String>,
    #[serde(rename = "skipValidation", default, skip_serializing_if = "Option::is_none")]
    pub skip_validation: Option<bool>,
    #[serde(rename = "keepSourceDevice", default, skip_serializing_if = "Option::is_none")]
    pub keep_source_device: Option<bool>,
}
impl FailoverRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServer {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: FileServerProperties,
}
impl FileServer {
    pub fn new(properties: FileServerProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerList {
    pub value: Vec<FileServer>,
}
impl FileServerList {
    pub fn new(value: Vec<FileServer>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerProperties {
    #[serde(rename = "domainName")]
    pub domain_name: String,
    #[serde(rename = "storageDomainId")]
    pub storage_domain_id: String,
    #[serde(rename = "backupScheduleGroupId")]
    pub backup_schedule_group_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl FileServerProperties {
    pub fn new(domain_name: String, storage_domain_id: String, backup_schedule_group_id: String) -> Self {
        Self {
            domain_name,
            storage_domain_id,
            backup_schedule_group_id,
            description: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileShare {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: FileShareProperties,
}
impl FileShare {
    pub fn new(properties: FileShareProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileShareList {
    pub value: Vec<FileShare>,
}
impl FileShareList {
    pub fn new(value: Vec<FileShare>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileShareProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "shareStatus")]
    pub share_status: file_share_properties::ShareStatus,
    #[serde(rename = "dataPolicy")]
    pub data_policy: file_share_properties::DataPolicy,
    #[serde(rename = "adminUser")]
    pub admin_user: String,
    #[serde(rename = "provisionedCapacityInBytes")]
    pub provisioned_capacity_in_bytes: i64,
    #[serde(rename = "usedCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub used_capacity_in_bytes: Option<i64>,
    #[serde(rename = "localUsedCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub local_used_capacity_in_bytes: Option<i64>,
    #[serde(rename = "monitoringStatus")]
    pub monitoring_status: file_share_properties::MonitoringStatus,
}
impl FileShareProperties {
    pub fn new(
        share_status: file_share_properties::ShareStatus,
        data_policy: file_share_properties::DataPolicy,
        admin_user: String,
        provisioned_capacity_in_bytes: i64,
        monitoring_status: file_share_properties::MonitoringStatus,
    ) -> Self {
        Self {
            description: None,
            share_status,
            data_policy,
            admin_user,
            provisioned_capacity_in_bytes,
            used_capacity_in_bytes: None,
            local_used_capacity_in_bytes: None,
            monitoring_status,
        }
    }
}
pub mod file_share_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ShareStatus {
        Online,
        Offline,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataPolicy {
        Invalid,
        Local,
        Tiered,
        Cloud,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MonitoringStatus {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpConfig {
    #[serde(rename = "ipAddress")]
    pub ip_address: String,
    #[serde(rename = "prefixLength", default, skip_serializing_if = "Option::is_none")]
    pub prefix_length: Option<i32>,
    pub gateway: String,
}
impl IpConfig {
    pub fn new(ip_address: String, gateway: String) -> Self {
        Self {
            ip_address,
            prefix_length: None,
            gateway,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiDisk {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: IscsiDiskProperties,
}
impl IscsiDisk {
    pub fn new(properties: IscsiDiskProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiDiskList {
    pub value: Vec<IscsiDisk>,
}
impl IscsiDiskList {
    pub fn new(value: Vec<IscsiDisk>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiDiskProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "diskStatus")]
    pub disk_status: iscsi_disk_properties::DiskStatus,
    #[serde(rename = "accessControlRecords")]
    pub access_control_records: Vec<String>,
    #[serde(rename = "dataPolicy")]
    pub data_policy: iscsi_disk_properties::DataPolicy,
    #[serde(rename = "provisionedCapacityInBytes")]
    pub provisioned_capacity_in_bytes: i64,
    #[serde(rename = "usedCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub used_capacity_in_bytes: Option<i64>,
    #[serde(rename = "localUsedCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub local_used_capacity_in_bytes: Option<i64>,
    #[serde(rename = "monitoringStatus")]
    pub monitoring_status: iscsi_disk_properties::MonitoringStatus,
}
impl IscsiDiskProperties {
    pub fn new(
        disk_status: iscsi_disk_properties::DiskStatus,
        access_control_records: Vec<String>,
        data_policy: iscsi_disk_properties::DataPolicy,
        provisioned_capacity_in_bytes: i64,
        monitoring_status: iscsi_disk_properties::MonitoringStatus,
    ) -> Self {
        Self {
            description: None,
            disk_status,
            access_control_records,
            data_policy,
            provisioned_capacity_in_bytes,
            used_capacity_in_bytes: None,
            local_used_capacity_in_bytes: None,
            monitoring_status,
        }
    }
}
pub mod iscsi_disk_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskStatus {
        Online,
        Offline,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataPolicy {
        Invalid,
        Local,
        Tiered,
        Cloud,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MonitoringStatus {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiServer {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: IscsiServerProperties,
}
impl IscsiServer {
    pub fn new(properties: IscsiServerProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiServerList {
    pub value: Vec<IscsiServer>,
}
impl IscsiServerList {
    pub fn new(value: Vec<IscsiServer>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiServerProperties {
    #[serde(rename = "storageDomainId")]
    pub storage_domain_id: String,
    #[serde(rename = "backupScheduleGroupId")]
    pub backup_schedule_group_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "chapId", default, skip_serializing_if = "Option::is_none")]
    pub chap_id: Option<String>,
    #[serde(rename = "reverseChapId", default, skip_serializing_if = "Option::is_none")]
    pub reverse_chap_id: Option<String>,
}
impl IscsiServerProperties {
    pub fn new(storage_domain_id: String, backup_schedule_group_id: String) -> Self {
        Self {
            storage_domain_id,
            backup_schedule_group_id,
            description: None,
            chap_id: None,
            reverse_chap_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Item {
    pub key: String,
    pub value: String,
}
impl Item {
    pub fn new(key: String, value: String) -> Self {
        Self { key, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Job {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub status: job::Status,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "percentComplete")]
    pub percent_complete: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<JobErrorDetails>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobProperties>,
}
impl Job {
    pub fn new(status: job::Status, percent_complete: i32) -> Self {
        Self {
            base_model: BaseModel::default(),
            status,
            start_time: None,
            end_time: None,
            percent_complete,
            error: None,
            properties: None,
        }
    }
}
pub mod job {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        Running,
        Succeeded,
        Failed,
        Canceled,
        Paused,
        Scheduled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobErrorDetails {
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<JobErrorItem>,
    pub code: String,
    pub message: String,
}
impl JobErrorDetails {
    pub fn new(code: String, message: String) -> Self {
        Self {
            error_details: Vec::new(),
            code,
            message,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobErrorItem {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
    pub code: String,
    pub message: String,
}
impl JobErrorItem {
    pub fn new(code: String, message: String) -> Self {
        Self {
            recommendations: Vec::new(),
            code,
            message,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobFilter {
    #[serde(rename = "jobType")]
    pub job_type: job_filter::JobType,
    pub status: job_filter::Status,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
}
impl JobFilter {
    pub fn new(job_type: job_filter::JobType, status: job_filter::Status) -> Self {
        Self {
            job_type,
            status,
            start_time: None,
        }
    }
}
pub mod job_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum JobType {
        Backup,
        Clone,
        Failover,
        DownloadUpdates,
        InstallUpdates,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        Running,
        Succeeded,
        Failed,
        Canceled,
        Paused,
        Scheduled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobList {
    pub value: Vec<Job>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobList {
    pub fn new(value: Vec<Job>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobProperties {
    #[serde(rename = "jobType")]
    pub job_type: job_properties::JobType,
    #[serde(rename = "targetId", default, skip_serializing_if = "Option::is_none")]
    pub target_id: Option<String>,
    #[serde(rename = "entityId", default, skip_serializing_if = "Option::is_none")]
    pub entity_id: Option<String>,
    #[serde(rename = "entityType", default, skip_serializing_if = "Option::is_none")]
    pub entity_type: Option<String>,
    #[serde(rename = "jobStages", default, skip_serializing_if = "Vec::is_empty")]
    pub job_stages: Vec<JobStage>,
    #[serde(rename = "deviceId", default, skip_serializing_if = "Option::is_none")]
    pub device_id: Option<String>,
    #[serde(rename = "isCancellable", default, skip_serializing_if = "Option::is_none")]
    pub is_cancellable: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stats: Option<JobStats>,
    #[serde(rename = "targetType", default, skip_serializing_if = "Option::is_none")]
    pub target_type: Option<job_properties::TargetType>,
    #[serde(rename = "sourceDeviceId", default, skip_serializing_if = "Option::is_none")]
    pub source_device_id: Option<String>,
    #[serde(rename = "backupPointInTime", default, skip_serializing_if = "Option::is_none")]
    pub backup_point_in_time: Option<String>,
    #[serde(rename = "downloadProgress", default, skip_serializing_if = "Option::is_none")]
    pub download_progress: Option<UpdateDownloadProgress>,
    #[serde(rename = "installProgress", default, skip_serializing_if = "Option::is_none")]
    pub install_progress: Option<UpdateInstallProgress>,
}
impl JobProperties {
    pub fn new(job_type: job_properties::JobType) -> Self {
        Self {
            job_type,
            target_id: None,
            entity_id: None,
            entity_type: None,
            job_stages: Vec::new(),
            device_id: None,
            is_cancellable: None,
            stats: None,
            target_type: None,
            source_device_id: None,
            backup_point_in_time: None,
            download_progress: None,
            install_progress: None,
        }
    }
}
pub mod job_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum JobType {
        Backup,
        Clone,
        Failover,
        DownloadUpdates,
        InstallUpdates,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TargetType {
        FileServer,
        DiskServer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobStage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "stageStatus")]
    pub stage_status: job_stage::StageStatus,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub detail: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
}
impl JobStage {
    pub fn new(stage_status: job_stage::StageStatus) -> Self {
        Self {
            message: None,
            stage_status,
            detail: None,
            error_code: None,
        }
    }
}
pub mod job_stage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StageStatus {
        Invalid,
        Running,
        Succeeded,
        Failed,
        Canceled,
        Paused,
        Scheduled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobStats {
    #[serde(rename = "completedWorkItemCount", default, skip_serializing_if = "Option::is_none")]
    pub completed_work_item_count: Option<i32>,
    #[serde(rename = "totalWorkItemCount", default, skip_serializing_if = "Option::is_none")]
    pub total_work_item_count: Option<i32>,
    #[serde(rename = "estimatedTimeRemaining", default, skip_serializing_if = "Option::is_none")]
    pub estimated_time_remaining: Option<i32>,
}
impl JobStats {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Manager {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagerProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Manager {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagerExtendedInfo {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: ManagerExtendedInfoProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ManagerExtendedInfo {
    pub fn new(properties: ManagerExtendedInfoProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagerExtendedInfoProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "integrityKey")]
    pub integrity_key: String,
    #[serde(rename = "encryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub encryption_key: Option<String>,
    #[serde(rename = "encryptionKeyThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub encryption_key_thumbprint: Option<String>,
    #[serde(rename = "portalCertificateThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub portal_certificate_thumbprint: Option<String>,
    pub algorithm: String,
}
impl ManagerExtendedInfoProperties {
    pub fn new(integrity_key: String, algorithm: String) -> Self {
        Self {
            version: None,
            integrity_key,
            encryption_key: None,
            encryption_key_thumbprint: None,
            portal_certificate_thumbprint: None,
            algorithm,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagerIntrinsicSettings {
    #[serde(rename = "type")]
    pub type_: manager_intrinsic_settings::Type,
}
impl ManagerIntrinsicSettings {
    pub fn new(type_: manager_intrinsic_settings::Type) -> Self {
        Self { type_ }
    }
}
pub mod manager_intrinsic_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        GardaV1,
        HelsinkiV1,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagerList {
    pub value: Vec<Manager>,
}
impl ManagerList {
    pub fn new(value: Vec<Manager>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagerPatch {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ManagerPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagerProperties {
    #[serde(rename = "cisIntrinsicSettings", default, skip_serializing_if = "Option::is_none")]
    pub cis_intrinsic_settings: Option<ManagerIntrinsicSettings>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ManagerSku>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ManagerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagerSku {
    pub name: manager_sku::Name,
}
impl ManagerSku {
    pub fn new(name: manager_sku::Name) -> Self {
        Self { name }
    }
}
pub mod manager_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Message {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl Message {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricAvailablity {
    #[serde(rename = "timeGrain")]
    pub time_grain: String,
    pub retention: String,
}
impl MetricAvailablity {
    pub fn new(time_grain: String, retention: String) -> Self {
        Self { time_grain, retention }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricData {
    #[serde(rename = "timeStamp")]
    pub time_stamp: String,
    pub sum: f64,
    pub count: i32,
    pub average: f64,
    pub minimum: f64,
    pub maximum: f64,
}
impl MetricData {
    pub fn new(time_stamp: String, sum: f64, count: i32, average: f64, minimum: f64, maximum: f64) -> Self {
        Self {
            time_stamp,
            sum,
            count,
            average,
            minimum,
            maximum,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricDefinition {
    pub name: MetricName,
    pub unit: metric_definition::Unit,
    #[serde(rename = "primaryAggregationType")]
    pub primary_aggregation_type: metric_definition::PrimaryAggregationType,
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[serde(rename = "metricAvailabilities")]
    pub metric_availabilities: Vec<MetricAvailablity>,
    pub dimensions: Vec<MetricDimension>,
    #[serde(rename = "type")]
    pub type_: String,
}
impl MetricDefinition {
    pub fn new(
        name: MetricName,
        unit: metric_definition::Unit,
        primary_aggregation_type: metric_definition::PrimaryAggregationType,
        resource_id: String,
        metric_availabilities: Vec<MetricAvailablity>,
        dimensions: Vec<MetricDimension>,
        type_: String,
    ) -> Self {
        Self {
            name,
            unit,
            primary_aggregation_type,
            resource_id,
            metric_availabilities,
            dimensions,
            type_,
        }
    }
}
pub mod metric_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Bytes,
        BytesPerSecond,
        Count,
        CountPerSecond,
        Percent,
        Seconds,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrimaryAggregationType {
        Average,
        Last,
        Maximum,
        Minimum,
        None,
        Total,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricDefinitionList {
    pub value: Vec<MetricDefinition>,
}
impl MetricDefinitionList {
    pub fn new(value: Vec<MetricDefinition>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricDimension {
    pub name: String,
    pub value: String,
}
impl MetricDimension {
    pub fn new(name: String, value: String) -> Self {
        Self { name, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricNameFilter>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
}
impl MetricFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricList {
    pub value: Vec<Metrics>,
}
impl MetricList {
    pub fn new(value: Vec<Metrics>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricName {
    pub value: String,
    #[serde(rename = "localizedValue")]
    pub localized_value: String,
}
impl MetricName {
    pub fn new(value: String, localized_value: String) -> Self {
        Self { value, localized_value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricNameFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl MetricNameFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Metrics {
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime")]
    pub end_time: String,
    #[serde(rename = "timeGrain")]
    pub time_grain: String,
    #[serde(rename = "primaryAggregation")]
    pub primary_aggregation: metrics::PrimaryAggregation,
    pub name: MetricName,
    pub dimensions: Vec<MetricDimension>,
    pub unit: metrics::Unit,
    #[serde(rename = "type")]
    pub type_: String,
    pub values: Vec<MetricData>,
}
impl Metrics {
    pub fn new(
        resource_id: String,
        start_time: String,
        end_time: String,
        time_grain: String,
        primary_aggregation: metrics::PrimaryAggregation,
        name: MetricName,
        dimensions: Vec<MetricDimension>,
        unit: metrics::Unit,
        type_: String,
        values: Vec<MetricData>,
    ) -> Self {
        Self {
            resource_id,
            start_time,
            end_time,
            time_grain,
            primary_aggregation,
            name,
            dimensions,
            unit,
            type_,
            values,
        }
    }
}
pub mod metrics {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrimaryAggregation {
        Average,
        Last,
        Maximum,
        Minimum,
        None,
        Total,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Bytes,
        BytesPerSecond,
        Count,
        CountPerSecond,
        Percent,
        Seconds,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkAdapter {
    #[serde(rename = "networkAdapterName")]
    pub network_adapter_name: String,
    #[serde(rename = "iPv4Info", default, skip_serializing_if = "Option::is_none")]
    pub i_pv4_info: Option<IpConfig>,
    #[serde(rename = "iPv6Info", default, skip_serializing_if = "Option::is_none")]
    pub i_pv6_info: Option<IpConfig>,
    #[serde(rename = "dhcpStatus")]
    pub dhcp_status: network_adapter::DhcpStatus,
    #[serde(rename = "linkSpeed", default, skip_serializing_if = "Option::is_none")]
    pub link_speed: Option<i64>,
}
impl NetworkAdapter {
    pub fn new(network_adapter_name: String, dhcp_status: network_adapter::DhcpStatus) -> Self {
        Self {
            network_adapter_name,
            i_pv4_info: None,
            i_pv6_info: None,
            dhcp_status,
            link_speed: None,
        }
    }
}
pub mod network_adapter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DhcpStatus {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkSettings {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: NetworkSettingsProperties,
}
impl NetworkSettings {
    pub fn new(properties: NetworkSettingsProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkSettingsProperties {
    #[serde(rename = "primaryDnsServer")]
    pub primary_dns_server: String,
    #[serde(rename = "secondaryDnsServer", default, skip_serializing_if = "Option::is_none")]
    pub secondary_dns_server: Option<String>,
    #[serde(rename = "nodeNetworks")]
    pub node_networks: Vec<NodeNetwork>,
}
impl NetworkSettingsProperties {
    pub fn new(primary_dns_server: String, node_networks: Vec<NodeNetwork>) -> Self {
        Self {
            primary_dns_server,
            secondary_dns_server: None,
            node_networks,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NodeNetwork {
    #[serde(rename = "networkAdapters")]
    pub network_adapters: Vec<NetworkAdapter>,
}
impl NodeNetwork {
    pub fn new(network_adapters: Vec<NetworkAdapter>) -> Self {
        Self { network_adapters }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RawCertificateData {
    #[serde(rename = "authType", default, skip_serializing_if = "Option::is_none")]
    pub auth_type: Option<raw_certificate_data::AuthType>,
    pub certificate: String,
}
impl RawCertificateData {
    pub fn new(certificate: String) -> Self {
        Self {
            auth_type: None,
            certificate,
        }
    }
}
pub mod raw_certificate_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthType {
        Invalid,
        AccessControlService,
        AzureActiveDirectory,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceCertificateAndAadDetails {
    #[serde(rename = "authType", default, skip_serializing_if = "Option::is_none")]
    pub auth_type: Option<resource_certificate_and_aad_details::AuthType>,
    pub certificate: String,
    #[serde(rename = "resourceId")]
    pub resource_id: i64,
    #[serde(rename = "aadAuthority")]
    pub aad_authority: String,
    #[serde(rename = "aadTenantId")]
    pub aad_tenant_id: String,
    #[serde(rename = "servicePrincipalClientId")]
    pub service_principal_client_id: String,
    #[serde(rename = "servicePrincipalObjectId")]
    pub service_principal_object_id: String,
    #[serde(rename = "azureManagementEndpointAudience")]
    pub azure_management_endpoint_audience: String,
    pub subject: String,
    #[serde(rename = "validFrom")]
    pub valid_from: String,
    #[serde(rename = "validTo")]
    pub valid_to: String,
    pub thumbprint: String,
    #[serde(rename = "friendlyName")]
    pub friendly_name: String,
    pub issuer: String,
}
impl ResourceCertificateAndAadDetails {
    pub fn new(
        certificate: String,
        resource_id: i64,
        aad_authority: String,
        aad_tenant_id: String,
        service_principal_client_id: String,
        service_principal_object_id: String,
        azure_management_endpoint_audience: String,
        subject: String,
        valid_from: String,
        valid_to: String,
        thumbprint: String,
        friendly_name: String,
        issuer: String,
    ) -> Self {
        Self {
            auth_type: None,
            certificate,
            resource_id,
            aad_authority,
            aad_tenant_id,
            service_principal_client_id,
            service_principal_object_id,
            azure_management_endpoint_audience,
            subject,
            valid_from,
            valid_to,
            thumbprint,
            friendly_name,
            issuer,
        }
    }
}
pub mod resource_certificate_and_aad_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthType {
        Invalid,
        AccessControlService,
        AzureActiveDirectory,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecuritySettings {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: SecuritySettingsProperties,
}
impl SecuritySettings {
    pub fn new(properties: SecuritySettingsProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecuritySettingsProperties {
    #[serde(rename = "deviceAdminPassword")]
    pub device_admin_password: AsymmetricEncryptedSecret,
}
impl SecuritySettingsProperties {
    pub fn new(device_admin_password: AsymmetricEncryptedSecret) -> Self {
        Self { device_admin_password }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SendTestAlertEmailRequest {
    #[serde(rename = "emailList")]
    pub email_list: Vec<String>,
}
impl SendTestAlertEmailRequest {
    pub fn new(email_list: Vec<String>) -> Self {
        Self { email_list }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageAccountCredential {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: StorageAccountCredentialProperties,
}
impl StorageAccountCredential {
    pub fn new(properties: StorageAccountCredentialProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageAccountCredentialList {
    pub value: Vec<StorageAccountCredential>,
}
impl StorageAccountCredentialList {
    pub fn new(value: Vec<StorageAccountCredential>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageAccountCredentialProperties {
    #[serde(rename = "cloudType")]
    pub cloud_type: storage_account_credential_properties::CloudType,
    #[serde(rename = "endPoint")]
    pub end_point: String,
    pub login: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "enableSSL")]
    pub enable_ssl: storage_account_credential_properties::EnableSsl,
    #[serde(rename = "accessKey", default, skip_serializing_if = "Option::is_none")]
    pub access_key: Option<AsymmetricEncryptedSecret>,
}
impl StorageAccountCredentialProperties {
    pub fn new(
        cloud_type: storage_account_credential_properties::CloudType,
        end_point: String,
        login: String,
        enable_ssl: storage_account_credential_properties::EnableSsl,
    ) -> Self {
        Self {
            cloud_type,
            end_point,
            login,
            location: None,
            enable_ssl,
            access_key: None,
        }
    }
}
pub mod storage_account_credential_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CloudType {
        Azure,
        S3,
        #[serde(rename = "S3_RRS")]
        S3Rrs,
        OpenStack,
        #[serde(rename = "HP")]
        Hp,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EnableSsl {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageDomain {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: StorageDomainProperties,
}
impl StorageDomain {
    pub fn new(properties: StorageDomainProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageDomainList {
    pub value: Vec<StorageDomain>,
}
impl StorageDomainList {
    pub fn new(value: Vec<StorageDomain>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageDomainProperties {
    #[serde(rename = "storageAccountCredentialIds")]
    pub storage_account_credential_ids: Vec<String>,
    #[serde(rename = "encryptionKey", default, skip_serializing_if = "Option::is_none")]
    pub encryption_key: Option<AsymmetricEncryptedSecret>,
    #[serde(rename = "encryptionStatus")]
    pub encryption_status: storage_domain_properties::EncryptionStatus,
}
impl StorageDomainProperties {
    pub fn new(storage_account_credential_ids: Vec<String>, encryption_status: storage_domain_properties::EncryptionStatus) -> Self {
        Self {
            storage_account_credential_ids,
            encryption_key: None,
            encryption_status,
        }
    }
}
pub mod storage_domain_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EncryptionStatus {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SymmetricEncryptedSecret {
    pub value: String,
    #[serde(rename = "valueCertificateThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub value_certificate_thumbprint: Option<String>,
    #[serde(rename = "encryptionAlgorithm")]
    pub encryption_algorithm: symmetric_encrypted_secret::EncryptionAlgorithm,
}
impl SymmetricEncryptedSecret {
    pub fn new(value: String, encryption_algorithm: symmetric_encrypted_secret::EncryptionAlgorithm) -> Self {
        Self {
            value,
            value_certificate_thumbprint: None,
            encryption_algorithm,
        }
    }
}
pub mod symmetric_encrypted_secret {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EncryptionAlgorithm {
        None,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "RSAES_PKCS1_v_1_5")]
        RsaesPkcs1V15,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Time {
    pub hour: i32,
    pub minute: i32,
}
impl Time {
    pub fn new(hour: i32, minute: i32) -> Self {
        Self { hour, minute }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimeSettings {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: TimeSettingsProperties,
}
impl TimeSettings {
    pub fn new(properties: TimeSettingsProperties) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimeSettingsProperties {
    #[serde(rename = "timeZone")]
    pub time_zone: String,
    #[serde(rename = "primaryTimeServer")]
    pub primary_time_server: String,
    #[serde(rename = "secondaryTimeServer", default, skip_serializing_if = "Option::is_none")]
    pub secondary_time_server: Option<String>,
}
impl TimeSettingsProperties {
    pub fn new(time_zone: String, primary_time_server: String) -> Self {
        Self {
            time_zone,
            primary_time_server,
            secondary_time_server: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateDownloadProgress {
    #[serde(rename = "downloadPhase", default, skip_serializing_if = "Option::is_none")]
    pub download_phase: Option<update_download_progress::DownloadPhase>,
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<i32>,
    #[serde(rename = "totalBytesToDownload", default, skip_serializing_if = "Option::is_none")]
    pub total_bytes_to_download: Option<f64>,
    #[serde(rename = "totalBytesDownloaded", default, skip_serializing_if = "Option::is_none")]
    pub total_bytes_downloaded: Option<f64>,
    #[serde(rename = "numberOfUpdatesToDownload", default, skip_serializing_if = "Option::is_none")]
    pub number_of_updates_to_download: Option<i32>,
    #[serde(rename = "numberOfUpdatesDownloaded", default, skip_serializing_if = "Option::is_none")]
    pub number_of_updates_downloaded: Option<i32>,
}
impl UpdateDownloadProgress {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod update_download_progress {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DownloadPhase {
        Unknown,
        Initializing,
        Downloading,
        Verifying,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateInstallProgress {
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<i32>,
    #[serde(rename = "numberOfUpdatesToInstall", default, skip_serializing_if = "Option::is_none")]
    pub number_of_updates_to_install: Option<i32>,
    #[serde(rename = "numberOfUpdatesInstalled", default, skip_serializing_if = "Option::is_none")]
    pub number_of_updates_installed: Option<i32>,
}
impl UpdateInstallProgress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Updates {
    #[serde(flatten)]
    pub base_model: BaseModel,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdatesProperties>,
}
impl Updates {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdatesProperties {
    #[serde(rename = "deviceVersion", default, skip_serializing_if = "Option::is_none")]
    pub device_version: Option<String>,
    #[serde(rename = "deviceLastScannedTime", default, skip_serializing_if = "Option::is_none")]
    pub device_last_scanned_time: Option<String>,
    #[serde(rename = "regularUpdatesAvailable", default, skip_serializing_if = "Option::is_none")]
    pub regular_updates_available: Option<bool>,
    #[serde(rename = "rebootRequiredForInstall", default, skip_serializing_if = "Option::is_none")]
    pub reboot_required_for_install: Option<bool>,
    #[serde(rename = "totalItemsPendingForDownload", default, skip_serializing_if = "Option::is_none")]
    pub total_items_pending_for_download: Option<i32>,
    #[serde(rename = "totalItemsPendingForInstall", default, skip_serializing_if = "Option::is_none")]
    pub total_items_pending_for_install: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<updates_properties::Status>,
    #[serde(rename = "lastCompletedScanTime", default, skip_serializing_if = "Option::is_none")]
    pub last_completed_scan_time: Option<String>,
    #[serde(rename = "lastCompletedDownloadJobTime", default, skip_serializing_if = "Option::is_none")]
    pub last_completed_download_job_time: Option<String>,
    #[serde(rename = "lastCompletedInstallJobTime", default, skip_serializing_if = "Option::is_none")]
    pub last_completed_install_job_time: Option<String>,
    #[serde(rename = "inProgressDownloadJobId", default, skip_serializing_if = "Option::is_none")]
    pub in_progress_download_job_id: Option<String>,
    #[serde(rename = "inProgressInstallJobId", default, skip_serializing_if = "Option::is_none")]
    pub in_progress_install_job_id: Option<String>,
    #[serde(rename = "inProgressScanStartedTime", default, skip_serializing_if = "Option::is_none")]
    pub in_progress_scan_started_time: Option<String>,
    #[serde(rename = "inProgressDownloadJobStartedTime", default, skip_serializing_if = "Option::is_none")]
    pub in_progress_download_job_started_time: Option<String>,
    #[serde(rename = "inProgressInstallJobStartedTime", default, skip_serializing_if = "Option::is_none")]
    pub in_progress_install_job_started_time: Option<String>,
}
impl UpdatesProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod updates_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Idle,
        Scanning,
        Downloading,
        Installing,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UploadCertificateRequest {
    pub properties: RawCertificateData,
    #[serde(rename = "contractVersion", default, skip_serializing_if = "Option::is_none")]
    pub contract_version: Option<upload_certificate_request::ContractVersion>,
}
impl UploadCertificateRequest {
    pub fn new(properties: RawCertificateData) -> Self {
        Self {
            properties,
            contract_version: None,
        }
    }
}
pub mod upload_certificate_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ContractVersion {
        InvalidVersion,
        #[serde(rename = "V2011_09")]
        V201109,
        #[serde(rename = "V2012_02")]
        V201202,
        #[serde(rename = "V2012_05")]
        V201205,
        #[serde(rename = "V2012_12")]
        V201212,
        #[serde(rename = "V2013_04")]
        V201304,
        #[serde(rename = "V2013_10")]
        V201310,
        #[serde(rename = "V2013_11")]
        V201311,
        #[serde(rename = "V2014_04")]
        V201404,
        #[serde(rename = "V2014_06")]
        V201406,
        #[serde(rename = "V2014_07")]
        V201407,
        #[serde(rename = "V2014_09")]
        V201409,
        #[serde(rename = "V2014_10")]
        V201410,
        #[serde(rename = "V2014_12")]
        V201412,
        #[serde(rename = "V2015_01")]
        V201501,
        #[serde(rename = "V2015_02")]
        V201502,
        #[serde(rename = "V2015_04")]
        V201504,
        #[serde(rename = "V2015_05")]
        V201505,
        #[serde(rename = "V2015_06")]
        V201506,
        #[serde(rename = "V2015_07")]
        V201507,
        #[serde(rename = "V2015_08")]
        V201508,
        #[serde(rename = "V2015_10")]
        V201510,
        #[serde(rename = "V2015_12")]
        V201512,
        #[serde(rename = "V2016_01")]
        V201601,
        #[serde(rename = "V2016_02")]
        V201602,
        #[serde(rename = "V2016_04")]
        V201604,
        #[serde(rename = "V2016_05")]
        V201605,
        #[serde(rename = "V2016_07")]
        V201607,
        #[serde(rename = "V2016_08")]
        V201608,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UploadCertificateResponse {
    #[serde(flatten)]
    pub base_model: BaseModel,
    pub properties: ResourceCertificateAndAadDetails,
}
impl UploadCertificateResponse {
    pub fn new(properties: ResourceCertificateAndAadDetails) -> Self {
        Self {
            base_model: BaseModel::default(),
            properties,
        }
    }
}
