#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Acl {
    #[serde(rename = "initiatorIqn")]
    pub initiator_iqn: String,
    #[serde(rename = "mappedLuns")]
    pub mapped_luns: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credentials: Option<IscsiTargetCredentials>,
}
impl Acl {
    pub fn new(initiator_iqn: String, mapped_luns: Vec<String>) -> Self {
        Self {
            initiator_iqn,
            mapped_luns,
            credentials: None,
        }
    }
}
pub type AdditionalCapability = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Attributes {
    pub authentication: bool,
    #[serde(rename = "prodModeWriteProtect")]
    pub prod_mode_write_protect: bool,
}
impl Attributes {
    pub fn new(authentication: bool, prod_mode_write_protect: bool) -> Self {
        Self {
            authentication,
            prod_mode_write_protect,
        }
    }
}
pub type AvailabilityZone = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Disk {
    pub id: String,
}
impl Disk {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiskPool {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    pub properties: DiskPoolProperties,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemMetadata>,
}
impl DiskPool {
    pub fn new(tracked_resource: TrackedResource, properties: DiskPoolProperties) -> Self {
        Self {
            tracked_resource,
            properties,
            system_data: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiskPoolCreate {
    pub properties: DiskPoolCreateProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl DiskPoolCreate {
    pub fn new(properties: DiskPoolCreateProperties, location: String) -> Self {
        Self {
            properties,
            tags: None,
            location,
            id: None,
            name: None,
            type_: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiskPoolCreateProperties {
    #[serde(rename = "availabilityZones")]
    pub availability_zones: Vec<AvailabilityZone>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<Disk>,
    #[serde(rename = "subnetId")]
    pub subnet_id: String,
    #[serde(rename = "additionalCapabilities", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_capabilities: Vec<AdditionalCapability>,
    pub tier: DiskPoolTier,
}
impl DiskPoolCreateProperties {
    pub fn new(availability_zones: Vec<AvailabilityZone>, subnet_id: String, tier: DiskPoolTier) -> Self {
        Self {
            availability_zones,
            disks: Vec::new(),
            subnet_id,
            additional_capabilities: Vec::new(),
            tier,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiskPoolListResult {
    pub value: Vec<DiskPool>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiskPoolListResult {
    pub fn new(value: Vec<DiskPool>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiskPoolProperties {
    #[serde(rename = "provisioningState")]
    pub provisioning_state: ProvisioningState,
    #[serde(rename = "availabilityZones")]
    pub availability_zones: Vec<AvailabilityZone>,
    pub status: OperationalStatus,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<Disk>,
    #[serde(rename = "subnetId")]
    pub subnet_id: String,
    #[serde(rename = "additionalCapabilities", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_capabilities: Vec<AdditionalCapability>,
    pub tier: DiskPoolTier,
}
impl DiskPoolProperties {
    pub fn new(
        provisioning_state: ProvisioningState,
        availability_zones: Vec<AvailabilityZone>,
        status: OperationalStatus,
        subnet_id: String,
        tier: DiskPoolTier,
    ) -> Self {
        Self {
            provisioning_state,
            availability_zones,
            status,
            disks: Vec::new(),
            subnet_id,
            additional_capabilities: Vec::new(),
            tier,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DiskPoolTier {
    Basic,
    Standard,
    Premium,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiskPoolUpdate {
    pub properties: DiskPoolUpdateProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl DiskPoolUpdate {
    pub fn new(properties: DiskPoolUpdateProperties) -> Self {
        Self { properties, tags: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskPoolUpdateProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<Disk>,
}
impl DiskPoolUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Error {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl Error {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorResponse>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiLun {
    pub name: String,
    #[serde(rename = "managedDiskAzureResourceId")]
    pub managed_disk_azure_resource_id: String,
}
impl IscsiLun {
    pub fn new(name: String, managed_disk_azure_resource_id: String) -> Self {
        Self {
            name,
            managed_disk_azure_resource_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiTarget {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub properties: IscsiTargetProperties,
}
impl IscsiTarget {
    pub fn new(properties: IscsiTargetProperties) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiTargetCreate {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub properties: IscsiTargetCreateProperties,
}
impl IscsiTargetCreate {
    pub fn new(properties: IscsiTargetCreateProperties) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiTargetCreateProperties {
    pub tpgs: Vec<TargetPortalGroupCreate>,
    #[serde(rename = "targetIqn", default, skip_serializing_if = "Option::is_none")]
    pub target_iqn: Option<String>,
}
impl IscsiTargetCreateProperties {
    pub fn new(tpgs: Vec<TargetPortalGroupCreate>) -> Self {
        Self { tpgs, target_iqn: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiTargetCredentials {
    pub username: String,
    pub password: String,
}
impl IscsiTargetCredentials {
    pub fn new(username: String, password: String) -> Self {
        Self { username, password }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiTargetList {
    pub value: Vec<IscsiTarget>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IscsiTargetList {
    pub fn new(value: Vec<IscsiTarget>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiTargetProperties {
    #[serde(rename = "provisioningState")]
    pub provisioning_state: ProvisioningState,
    pub status: OperationalStatus,
    pub tpgs: Vec<TargetPortalGroup>,
    #[serde(rename = "targetIqn")]
    pub target_iqn: String,
}
impl IscsiTargetProperties {
    pub fn new(provisioning_state: ProvisioningState, status: OperationalStatus, tpgs: Vec<TargetPortalGroup>, target_iqn: String) -> Self {
        Self {
            provisioning_state,
            status,
            tpgs,
            target_iqn,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiTargetUpdate {
    pub properties: IscsiTargetUpdateProperties,
}
impl IscsiTargetUpdate {
    pub fn new(properties: IscsiTargetUpdateProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IscsiTargetUpdateProperties {
    pub tpgs: Vec<TargetPortalGroupUpdate>,
}
impl IscsiTargetUpdateProperties {
    pub fn new(tpgs: Vec<TargetPortalGroupUpdate>) -> Self {
        Self { tpgs }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OperationalStatus {
    Invalid,
    Unknown,
    Healthy,
    Unhealthy,
    Updating,
    Running,
    Stopped,
    #[serde(rename = "Stopped (deallocated)")]
    StoppedDeallocated,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProvisioningState {
    Invalid,
    Succeeded,
    Failed,
    Canceled,
    Pending,
    Creating,
    Updating,
    Deleting,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StoragePoolOperationDisplay {
    pub provider: String,
    pub resource: String,
    pub operation: String,
    pub description: String,
}
impl StoragePoolOperationDisplay {
    pub fn new(provider: String, resource: String, operation: String, description: String) -> Self {
        Self {
            provider,
            resource,
            operation,
            description,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StoragePoolOperationListResult {
    pub value: Vec<StoragePoolRpOperation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl StoragePoolOperationListResult {
    pub fn new(value: Vec<StoragePoolRpOperation>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StoragePoolRpOperation {
    pub name: String,
    #[serde(rename = "isDataAction")]
    pub is_data_action: bool,
    #[serde(rename = "actionType", default, skip_serializing_if = "Option::is_none")]
    pub action_type: Option<String>,
    pub display: StoragePoolOperationDisplay,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
}
impl StoragePoolRpOperation {
    pub fn new(name: String, is_data_action: bool, display: StoragePoolOperationDisplay) -> Self {
        Self {
            name,
            is_data_action,
            action_type: None,
            display,
            origin: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemMetadata {
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<String>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<String>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TargetPortalGroup {
    pub luns: Vec<IscsiLun>,
    pub acls: Vec<Acl>,
    pub attributes: Attributes,
    pub endpoints: Vec<String>,
    pub tag: i32,
    pub port: i32,
}
impl TargetPortalGroup {
    pub fn new(luns: Vec<IscsiLun>, acls: Vec<Acl>, attributes: Attributes, endpoints: Vec<String>, tag: i32, port: i32) -> Self {
        Self {
            luns,
            acls,
            attributes,
            endpoints,
            tag,
            port,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TargetPortalGroupCreate {
    pub luns: Vec<IscsiLun>,
    pub acls: Vec<Acl>,
    pub attributes: Attributes,
}
impl TargetPortalGroupCreate {
    pub fn new(luns: Vec<IscsiLun>, acls: Vec<Acl>, attributes: Attributes) -> Self {
        Self { luns, acls, attributes }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetPortalGroupUpdate {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub luns: Vec<IscsiLun>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub acls: Vec<Acl>,
}
impl TargetPortalGroupUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    pub location: String,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            tags: None,
            location,
        }
    }
}
