#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "REST API operation description: see https://github.com/Azure/azure-rest-api-specs/blob/master/documentation/openapi-authoring-automated-guidelines.md#r3023-operationsapiimplementation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiOperation {
    #[doc = "The object that represents the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<api_operation::Display>,
    #[doc = "Operation name: {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl ApiOperation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod api_operation {
    use super::*;
    #[doc = "The object that represents the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Operation type: Read, write, delete, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "Service provider: Microsoft.StorageCache"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource on which the operation is performed: Cache, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result of the request to list Resource Provider operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiOperationListResult {
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "List of Resource Provider operations supported by the Microsoft.StorageCache resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApiOperation>,
}
impl ApiOperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Cache instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Cache {
    #[doc = "ARM tags as name/value pairs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "A fully qualified URL."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<UrlString>,
    #[doc = "Region name string."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Schema for the name of resources served by this provider. Note that objects will contain an odata @id annotation as appropriate. This will contain the complete URL of the object. These names are case-preserving, but not case sensitive."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<ResourceName>,
    #[doc = "Type of the Cache; Microsoft.StorageCache/Cache"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Properties of the Cache."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<cache::Properties>,
    #[doc = "SKU for the Cache."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<cache::Sku>,
}
impl Cache {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod cache {
    use super::*;
    #[doc = "Properties of the Cache."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The size of this Cache, in GB."]
        #[serde(rename = "cacheSizeGB", default, skip_serializing_if = "Option::is_none")]
        pub cache_size_gb: Option<i64>,
        #[doc = "An indication of Cache health. Gives more information about health than just that related to provisioning."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub health: Option<CacheHealth>,
        #[doc = "Array of IP addresses that can be used by clients mounting this Cache."]
        #[serde(rename = "mountAddresses", default, skip_serializing_if = "Vec::is_empty")]
        pub mount_addresses: Vec<String>,
        #[doc = "ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property"]
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[doc = "A fully qualified URL."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub subnet: Option<UrlString>,
        #[doc = "Properties describing the software upgrade state of the Cache."]
        #[serde(rename = "upgradeStatus", default, skip_serializing_if = "Option::is_none")]
        pub upgrade_status: Option<CacheUpgradeStatus>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Cancelled,
            Creating,
            Deleting,
            Updating,
        }
    }
    #[doc = "SKU for the Cache."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Sku {
        #[doc = "SKU name for this Cache."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Sku {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "An indication of Cache health. Gives more information about health than just that related to provisioning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CacheHealth {
    #[doc = "List of Cache health states."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<cache_health::State>,
    #[doc = "Describes explanation of state."]
    #[serde(rename = "statusDescription", default, skip_serializing_if = "Option::is_none")]
    pub status_description: Option<String>,
}
impl CacheHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod cache_health {
    use super::*;
    #[doc = "List of Cache health states."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Unknown,
        Healthy,
        Degraded,
        Down,
        Transitioning,
        Stopping,
        Stopped,
        Upgrading,
        Flushing,
    }
}
#[doc = "Properties describing the software upgrade state of the Cache."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CacheUpgradeStatus {
    #[doc = "Version string of the firmware currently installed on this Cache."]
    #[serde(rename = "currentFirmwareVersion", default, skip_serializing_if = "Option::is_none")]
    pub current_firmware_version: Option<String>,
    #[doc = "True if there is a firmware update ready to install on this Cache. The firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation."]
    #[serde(rename = "firmwareUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub firmware_update_status: Option<cache_upgrade_status::FirmwareUpdateStatus>,
    #[doc = "Time at which the pending firmware update will automatically be installed on the Cache."]
    #[serde(rename = "firmwareUpdateDeadline", default, skip_serializing_if = "Option::is_none")]
    pub firmware_update_deadline: Option<String>,
    #[doc = "Time of the last successful firmware update."]
    #[serde(rename = "lastFirmwareUpdate", default, skip_serializing_if = "Option::is_none")]
    pub last_firmware_update: Option<String>,
    #[doc = "When firmwareUpdateAvailable is true, this field holds the version string for the update."]
    #[serde(rename = "pendingFirmwareVersion", default, skip_serializing_if = "Option::is_none")]
    pub pending_firmware_version: Option<String>,
}
impl CacheUpgradeStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod cache_upgrade_status {
    use super::*;
    #[doc = "True if there is a firmware update ready to install on this Cache. The firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirmwareUpdateStatus {
        #[serde(rename = "available")]
        Available,
        #[serde(rename = "unavailable")]
        Unavailable,
    }
}
#[doc = "Result of the request to list Caches. It contains a list of Caches and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CachesListResult {
    #[doc = "URL to get the next set of Cache list results, if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "List of Caches."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Cache>,
}
impl CachesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Storage container for use as a CLFS Storage Target."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClfsTarget {
    #[doc = "A fully qualified URL."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<UrlString>,
}
impl ClfsTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "An error response."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "An identifier for the error. Codes are invariant and are intended to be consumed programmatically."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "A list of additional details about the error."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[doc = "A message describing the error, intended to be suitable for display in a user interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The target of the particular error. For example, the name of the property in error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A namespace junction."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NamespaceJunction {
    #[doc = "Namespace path on a Cache for a Storage Target."]
    #[serde(rename = "namespacePath", default, skip_serializing_if = "Option::is_none")]
    pub namespace_path: Option<String>,
    #[doc = "Path in Storage Target to which namespacePath points."]
    #[serde(rename = "targetPath", default, skip_serializing_if = "Option::is_none")]
    pub target_path: Option<String>,
    #[doc = "NFS export where targetPath exists."]
    #[serde(rename = "nfsExport", default, skip_serializing_if = "Option::is_none")]
    pub nfs_export: Option<String>,
}
impl NamespaceJunction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An NFSv3 mount point for use as a Storage Target."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Nfs3Target {
    #[doc = "IP address or host name of an NFSv3 host (e.g., 10.0.44.44)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "Identifies the primary usage model to be used for this Storage Target. Get choices from .../usageModels"]
    #[serde(rename = "usageModel", default, skip_serializing_if = "Option::is_none")]
    pub usage_model: Option<String>,
}
impl Nfs3Target {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type ResourceName = String;
#[doc = "A resource SKU."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSku {
    #[doc = "The type of resource the SKU applies to."]
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[doc = "A list of capabilities of this SKU, such as throughput or ops/sec."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<ResourceSkuCapabilities>,
    #[doc = "The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g., West US, East US, Southeast Asia, etc.)."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[doc = "The set of locations that the SKU is available."]
    #[serde(rename = "locationInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub location_info: Vec<ResourceSkuLocationInfo>,
    #[doc = "The name of this SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The restrictions preventing this SKU from being used. This is empty if there are no restrictions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub restrictions: Vec<Restriction>,
}
impl ResourceSku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A resource SKU capability."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSkuCapabilities {
    #[doc = "Name of a capability, such as ops/sec."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Quantity, if the capability is measured by quantity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ResourceSkuCapabilities {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Resource SKU location information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSkuLocationInfo {
    #[doc = "Location where this SKU is available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Zones if any."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl ResourceSkuLocationInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response from the List Cache SKUs operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSkusResult {
    #[doc = "The URI to fetch the next page of Cache SKUs."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "The list of SKUs available for the subscription."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceSku>,
}
impl ResourceSkusResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The restrictions preventing this SKU from being used."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Restriction {
    #[doc = "The type of restrictions. In this version, the only possible value for this is location."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The value of restrictions. If the restriction type is set to location, then this would be the different locations where the SKU is restricted."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
    #[doc = "The reason for the restriction. As of now this can be \"QuotaId\" or \"NotAvailableForSubscription\". \"QuotaId\" is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. \"NotAvailableForSubscription\" is related to capacity at the datacenter."]
    #[serde(rename = "reasonCode", default, skip_serializing_if = "Option::is_none")]
    pub reason_code: Option<restriction::ReasonCode>,
}
impl Restriction {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod restriction {
    use super::*;
    #[doc = "The reason for the restriction. As of now this can be \"QuotaId\" or \"NotAvailableForSubscription\". \"QuotaId\" is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. \"NotAvailableForSubscription\" is related to capacity at the datacenter."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReasonCode {
        QuotaId,
        NotAvailableForSubscription,
    }
}
#[doc = "A storage system being cached by a Cache."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageTarget {
    #[doc = "Schema for the name of resources served by this provider. Note that objects will contain an odata @id annotation as appropriate. This will contain the complete URL of the object. These names are case-preserving, but not case sensitive."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<ResourceName>,
    #[doc = "Resource ID of the Storage Target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Type of the Storage Target; Microsoft.StorageCache/Cache/StorageTarget"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Properties of the Storage Target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<storage_target::Properties>,
}
impl StorageTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod storage_target {
    use super::*;
    #[doc = "Properties of the Storage Target."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "List of Cache namespace junctions to target for namespace associations."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub junctions: Vec<NamespaceJunction>,
        #[doc = "Type of the Storage Target."]
        #[serde(rename = "targetType", default, skip_serializing_if = "Option::is_none")]
        pub target_type: Option<properties::TargetType>,
        #[doc = "ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property"]
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<properties::ProvisioningState>,
        #[doc = "An NFSv3 mount point for use as a Storage Target."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub nfs3: Option<Nfs3Target>,
        #[doc = "Storage container for use as a CLFS Storage Target."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub clfs: Option<ClfsTarget>,
        #[doc = "Storage container for use as an Unknown Storage Target."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub unknown: Option<UnknownTarget>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Type of the Storage Target."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum TargetType {
            #[serde(rename = "nfs3")]
            Nfs3,
            #[serde(rename = "clfs")]
            Clfs,
            #[serde(rename = "unknown")]
            Unknown,
        }
        #[doc = "ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property"]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ProvisioningState {
            Succeeded,
            Failed,
            Cancelled,
            Creating,
            Deleting,
            Updating,
        }
    }
}
#[doc = "A list of Storage Targets."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageTargetsResult {
    #[doc = "The URI to fetch the next page of Storage Targets."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "The list of Storage Targets defined for the Cache."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<StorageTarget>,
}
impl StorageTargetsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type UrlString = String;
#[doc = "Properties of an unknown type of Storage Target."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UnknownProperties {}
impl UnknownProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Storage container for use as an Unknown Storage Target."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UnknownTarget {
    #[doc = "Properties of an unknown type of Storage Target."]
    #[serde(rename = "unknownMap", default, skip_serializing_if = "Option::is_none")]
    pub unknown_map: Option<UnknownProperties>,
}
impl UnknownTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A usage model."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageModel {
    #[doc = "Localized information describing this usage model."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<usage_model::Display>,
    #[doc = "Non-localized keyword name for this usage model."]
    #[serde(rename = "modelName", default, skip_serializing_if = "Option::is_none")]
    pub model_name: Option<String>,
    #[doc = "The type of Storage Target to which this model is applicable (only nfs3 as of this version)."]
    #[serde(rename = "targetType", default, skip_serializing_if = "Option::is_none")]
    pub target_type: Option<String>,
}
impl UsageModel {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod usage_model {
    use super::*;
    #[doc = "Localized information describing this usage model."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "String to display for this usage model."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "A list of Cache usage models."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageModelsResult {
    #[doc = "The URI to fetch the next page of Cache usage models."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "The list of usage models available for the subscription."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<UsageModel>,
}
impl UsageModelsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
