#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Automatic tuning properties for individual advisors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutomaticTuningOptions {
    #[doc = "Automatic tuning option desired state."]
    #[serde(rename = "desiredState", default, skip_serializing_if = "Option::is_none")]
    pub desired_state: Option<automatic_tuning_options::DesiredState>,
    #[doc = "Automatic tuning option actual state."]
    #[serde(rename = "actualState", default, skip_serializing_if = "Option::is_none")]
    pub actual_state: Option<automatic_tuning_options::ActualState>,
    #[doc = "Reason code if desired and actual state are different."]
    #[serde(rename = "reasonCode", default, skip_serializing_if = "Option::is_none")]
    pub reason_code: Option<i32>,
    #[doc = "Reason description if desired and actual state are different."]
    #[serde(rename = "reasonDesc", default, skip_serializing_if = "Option::is_none")]
    pub reason_desc: Option<automatic_tuning_options::ReasonDesc>,
}
impl AutomaticTuningOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod automatic_tuning_options {
    use super::*;
    #[doc = "Automatic tuning option desired state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DesiredState {
        Off,
        On,
        Default,
    }
    #[doc = "Automatic tuning option actual state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActualState {
        Off,
        On,
    }
    #[doc = "Reason description if desired and actual state are different."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReasonDesc {
        Default,
        Disabled,
        AutoConfigured,
        InheritedFromServer,
        QueryStoreOff,
        QueryStoreReadOnly,
        NotSupported,
    }
}
#[doc = "Automatic tuning properties for individual advisors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutomaticTuningServerOptions {
    #[doc = "Automatic tuning option desired state."]
    #[serde(rename = "desiredState", default, skip_serializing_if = "Option::is_none")]
    pub desired_state: Option<automatic_tuning_server_options::DesiredState>,
    #[doc = "Automatic tuning option actual state."]
    #[serde(rename = "actualState", default, skip_serializing_if = "Option::is_none")]
    pub actual_state: Option<automatic_tuning_server_options::ActualState>,
    #[doc = "Reason code if desired and actual state are different."]
    #[serde(rename = "reasonCode", default, skip_serializing_if = "Option::is_none")]
    pub reason_code: Option<i32>,
    #[doc = "Reason description if desired and actual state are different."]
    #[serde(rename = "reasonDesc", default, skip_serializing_if = "Option::is_none")]
    pub reason_desc: Option<automatic_tuning_server_options::ReasonDesc>,
}
impl AutomaticTuningServerOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod automatic_tuning_server_options {
    use super::*;
    #[doc = "Automatic tuning option desired state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DesiredState {
        Off,
        On,
        Default,
    }
    #[doc = "Automatic tuning option actual state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActualState {
        Off,
        On,
    }
    #[doc = "Reason description if desired and actual state are different."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReasonDesc {
        Default,
        Disabled,
        AutoConfigured,
    }
}
#[doc = "Server-level Automatic Tuning properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutomaticTuningServerProperties {
    #[doc = "Automatic tuning desired state."]
    #[serde(rename = "desiredState", default, skip_serializing_if = "Option::is_none")]
    pub desired_state: Option<automatic_tuning_server_properties::DesiredState>,
    #[doc = "Automatic tuning actual state."]
    #[serde(rename = "actualState", default, skip_serializing_if = "Option::is_none")]
    pub actual_state: Option<automatic_tuning_server_properties::ActualState>,
    #[doc = "Automatic tuning options definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl AutomaticTuningServerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod automatic_tuning_server_properties {
    use super::*;
    #[doc = "Automatic tuning desired state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DesiredState {
        Custom,
        Auto,
        Unspecified,
    }
    #[doc = "Automatic tuning actual state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActualState {
        Custom,
        Auto,
        Unspecified,
    }
}
#[doc = "The availability status of the capability"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CapabilityStatus {
    Visible,
    Available,
    Default,
    Disabled,
}
#[doc = "A request to check whether the specified name for a resource is available."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckNameAvailabilityRequest {
    #[doc = "The name whose availability is to be checked."]
    pub name: String,
    #[doc = "The type of resource that is used as the scope of the availability check."]
    #[serde(rename = "type")]
    pub type_: check_name_availability_request::Type,
}
impl CheckNameAvailabilityRequest {
    pub fn new(name: String, type_: check_name_availability_request::Type) -> Self {
        Self { name, type_ }
    }
}
pub mod check_name_availability_request {
    use super::*;
    #[doc = "The type of resource that is used as the scope of the availability check."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.Sql/servers")]
        MicrosoftSqlServers,
    }
}
#[doc = "A response indicating whether the specified name for a resource is available."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckNameAvailabilityResponse {
    #[doc = "True if the name is available, otherwise false."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
    #[doc = "A message explaining why the name is unavailable. Will be null if the name is available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The name whose availability was checked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The reason code explaining why the name is unavailable. Will be null if the name is available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<check_name_availability_response::Reason>,
}
impl CheckNameAvailabilityResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod check_name_availability_response {
    use super::*;
    #[doc = "The reason code explaining why the name is unavailable. Will be null if the name is available."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[doc = "Contains the information necessary to perform a complete database restore operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CompleteDatabaseRestoreDefinition {
    #[doc = "The last backup name to apply"]
    #[serde(rename = "lastBackupName")]
    pub last_backup_name: String,
}
impl CompleteDatabaseRestoreDefinition {
    pub fn new(last_backup_name: String) -> Self {
        Self { last_backup_name }
    }
}
#[doc = "Contains the information necessary to perform a create database restore point operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateDatabaseRestorePointDefinition {
    #[doc = "The restore point label to apply"]
    #[serde(rename = "restorePointLabel")]
    pub restore_point_label: String,
}
impl CreateDatabaseRestorePointDefinition {
    pub fn new(restore_point_label: String) -> Self {
        Self { restore_point_label }
    }
}
#[doc = "Represents a database data masking policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataMaskingPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of a database data masking policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DataMaskingPolicyProperties>,
    #[doc = "The location of the data masking policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "The kind of data masking policy. Metadata, used for Azure portal."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl DataMaskingPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a database data masking policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataMaskingPolicyProperties {
    #[doc = "The state of the data masking policy."]
    #[serde(rename = "dataMaskingState")]
    pub data_masking_state: data_masking_policy_properties::DataMaskingState,
    #[doc = "The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries."]
    #[serde(rename = "exemptPrincipals", default, skip_serializing_if = "Option::is_none")]
    pub exempt_principals: Option<String>,
    #[doc = "The list of the application principals. This is a legacy parameter and is no longer used."]
    #[serde(rename = "applicationPrincipals", default, skip_serializing_if = "Option::is_none")]
    pub application_principals: Option<String>,
    #[doc = "The masking level. This is a legacy parameter and is no longer used."]
    #[serde(rename = "maskingLevel", default, skip_serializing_if = "Option::is_none")]
    pub masking_level: Option<String>,
}
impl DataMaskingPolicyProperties {
    pub fn new(data_masking_state: data_masking_policy_properties::DataMaskingState) -> Self {
        Self {
            data_masking_state,
            exempt_principals: None,
            application_principals: None,
            masking_level: None,
        }
    }
}
pub mod data_masking_policy_properties {
    use super::*;
    #[doc = "The state of the data masking policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataMaskingState {
        Disabled,
        Enabled,
    }
}
#[doc = "Represents a database data masking rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataMaskingRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of a database data masking rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DataMaskingRuleProperties>,
    #[doc = "The location of the data masking rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "The kind of Data Masking Rule. Metadata, used for Azure portal."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl DataMaskingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list data masking rules request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataMaskingRuleListResult {
    #[doc = "The list of database data masking rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DataMaskingRule>,
}
impl DataMaskingRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a database data masking rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataMaskingRuleProperties {
    #[doc = "The rule Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The alias name. This is a legacy parameter and is no longer used."]
    #[serde(rename = "aliasName", default, skip_serializing_if = "Option::is_none")]
    pub alias_name: Option<String>,
    #[doc = "The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState."]
    #[serde(rename = "ruleState", default, skip_serializing_if = "Option::is_none")]
    pub rule_state: Option<data_masking_rule_properties::RuleState>,
    #[doc = "The schema name on which the data masking rule is applied."]
    #[serde(rename = "schemaName")]
    pub schema_name: String,
    #[doc = "The table name on which the data masking rule is applied."]
    #[serde(rename = "tableName")]
    pub table_name: String,
    #[doc = "The column name on which the data masking rule is applied."]
    #[serde(rename = "columnName")]
    pub column_name: String,
    #[doc = "The masking function that is used for the data masking rule."]
    #[serde(rename = "maskingFunction")]
    pub masking_function: data_masking_rule_properties::MaskingFunction,
    #[doc = "The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored."]
    #[serde(rename = "numberFrom", default, skip_serializing_if = "Option::is_none")]
    pub number_from: Option<String>,
    #[doc = "The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored."]
    #[serde(rename = "numberTo", default, skip_serializing_if = "Option::is_none")]
    pub number_to: Option<String>,
    #[doc = "If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored."]
    #[serde(rename = "prefixSize", default, skip_serializing_if = "Option::is_none")]
    pub prefix_size: Option<String>,
    #[doc = "If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored."]
    #[serde(rename = "suffixSize", default, skip_serializing_if = "Option::is_none")]
    pub suffix_size: Option<String>,
    #[doc = "If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored."]
    #[serde(rename = "replacementString", default, skip_serializing_if = "Option::is_none")]
    pub replacement_string: Option<String>,
}
impl DataMaskingRuleProperties {
    pub fn new(
        schema_name: String,
        table_name: String,
        column_name: String,
        masking_function: data_masking_rule_properties::MaskingFunction,
    ) -> Self {
        Self {
            id: None,
            alias_name: None,
            rule_state: None,
            schema_name,
            table_name,
            column_name,
            masking_function,
            number_from: None,
            number_to: None,
            prefix_size: None,
            suffix_size: None,
            replacement_string: None,
        }
    }
}
pub mod data_masking_rule_properties {
    use super::*;
    #[doc = "The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleState {
        Disabled,
        Enabled,
    }
    #[doc = "The masking function that is used for the data masking rule."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MaskingFunction {
        Default,
        #[serde(rename = "CCN")]
        Ccn,
        Email,
        Number,
        #[serde(rename = "SSN")]
        Ssn,
        Text,
    }
}
#[doc = "User activities of a data warehouse"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataWarehouseUserActivities {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "User activities of a data warehouse. This currently includes the count of running or suspended queries. For more information, please view the sys.dm_pdw_exec_requests dynamic management view (DMV)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DataWarehouseUserActivitiesProperties>,
}
impl DataWarehouseUserActivities {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "User activities of a data warehouse. This currently includes the count of running or suspended queries. For more information, please view the sys.dm_pdw_exec_requests dynamic management view (DMV)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataWarehouseUserActivitiesProperties {
    #[doc = "Count of running and suspended queries."]
    #[serde(rename = "activeQueriesCount", default, skip_serializing_if = "Option::is_none")]
    pub active_queries_count: Option<i32>,
}
impl DataWarehouseUserActivitiesProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Database {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Kind of database.  This is metadata used for the Azure portal experience."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Represents the properties of a database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseProperties>,
}
impl Database {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            kind: None,
            properties: None,
        }
    }
}
#[doc = "Database-level Automatic Tuning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAutomaticTuning {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Database-level Automatic Tuning properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseAutomaticTuningProperties>,
}
impl DatabaseAutomaticTuning {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Database-level Automatic Tuning properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseAutomaticTuningProperties {
    #[doc = "Automatic tuning desired state."]
    #[serde(rename = "desiredState", default, skip_serializing_if = "Option::is_none")]
    pub desired_state: Option<database_automatic_tuning_properties::DesiredState>,
    #[doc = "Automatic tuning actual state."]
    #[serde(rename = "actualState", default, skip_serializing_if = "Option::is_none")]
    pub actual_state: Option<database_automatic_tuning_properties::ActualState>,
    #[doc = "Automatic tuning options definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub options: Option<serde_json::Value>,
}
impl DatabaseAutomaticTuningProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod database_automatic_tuning_properties {
    use super::*;
    #[doc = "Automatic tuning desired state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DesiredState {
        Inherit,
        Custom,
        Auto,
        Unspecified,
    }
    #[doc = "Automatic tuning actual state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActualState {
        Inherit,
        Custom,
        Auto,
        Unspecified,
    }
}
#[doc = "A database blob auditing policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseBlobAuditingPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Resource kind."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Properties of a database blob auditing policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseBlobAuditingPolicyProperties>,
}
impl DatabaseBlobAuditingPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of database auditing settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseBlobAuditingPolicyListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DatabaseBlobAuditingPolicy>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DatabaseBlobAuditingPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a database blob auditing policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseBlobAuditingPolicyProperties {
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required."]
    pub state: database_blob_auditing_policy_properties::State,
    #[doc = "Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required."]
    #[serde(rename = "storageEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub storage_endpoint: Option<String>,
    #[doc = "Specifies the identifier key of the auditing storage account. \r\nIf state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.\r\nPrerequisites for using managed identity authentication:\r\n1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).\r\n2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.\r\nFor more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)"]
    #[serde(rename = "storageAccountAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_access_key: Option<String>,
    #[doc = "Specifies the number of days to keep in the audit logs in the storage account."]
    #[serde(rename = "retentionDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i32>,
    #[doc = "Specifies the Actions-Groups and Actions to audit.\r\n\r\nThe recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:\r\n\r\nBATCH_COMPLETED_GROUP,\r\nSUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,\r\nFAILED_DATABASE_AUTHENTICATION_GROUP.\r\n\r\nThis above combination is also the set that is configured by default when enabling auditing from the Azure portal.\r\n\r\nThe supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):\r\n\r\nAPPLICATION_ROLE_CHANGE_PASSWORD_GROUP\r\nBACKUP_RESTORE_GROUP\r\nDATABASE_LOGOUT_GROUP\r\nDATABASE_OBJECT_CHANGE_GROUP\r\nDATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP\r\nDATABASE_OBJECT_PERMISSION_CHANGE_GROUP\r\nDATABASE_OPERATION_GROUP\r\nDATABASE_PERMISSION_CHANGE_GROUP\r\nDATABASE_PRINCIPAL_CHANGE_GROUP\r\nDATABASE_PRINCIPAL_IMPERSONATION_GROUP\r\nDATABASE_ROLE_MEMBER_CHANGE_GROUP\r\nFAILED_DATABASE_AUTHENTICATION_GROUP\r\nSCHEMA_OBJECT_ACCESS_GROUP\r\nSCHEMA_OBJECT_CHANGE_GROUP\r\nSCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP\r\nSCHEMA_OBJECT_PERMISSION_CHANGE_GROUP\r\nSUCCESSFUL_DATABASE_AUTHENTICATION_GROUP\r\nUSER_CHANGE_PASSWORD_GROUP\r\nBATCH_STARTED_GROUP\r\nBATCH_COMPLETED_GROUP\r\nDBCC_GROUP\r\nDATABASE_OWNERSHIP_CHANGE_GROUP\r\nDATABASE_CHANGE_GROUP\r\n\r\nThese are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.\r\n\r\nFor more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).\r\n\r\nFor Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:\r\nSELECT\r\nUPDATE\r\nINSERT\r\nDELETE\r\nEXECUTE\r\nRECEIVE\r\nREFERENCES\r\n\r\nThe general form for defining an action to be audited is:\r\n{action} ON {object} BY {principal}\r\n\r\nNote that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.\r\n\r\nFor example:\r\nSELECT on dbo.myTable by public\r\nSELECT on DATABASE::myDatabase by public\r\nSELECT on SCHEMA::mySchema by public\r\n\r\nFor more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)"]
    #[serde(rename = "auditActionsAndGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub audit_actions_and_groups: Vec<String>,
    #[doc = "Specifies the blob storage subscription Id."]
    #[serde(rename = "storageAccountSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_subscription_id: Option<String>,
    #[doc = "Specifies whether storageAccountAccessKey value is the storage's secondary key."]
    #[serde(rename = "isStorageSecondaryKeyInUse", default, skip_serializing_if = "Option::is_none")]
    pub is_storage_secondary_key_in_use: Option<bool>,
    #[doc = "Specifies whether audit events are sent to Azure Monitor. \r\nIn order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.\r\n\r\nWhen using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.\r\nNote that for server level audit you should use the 'master' database as {databaseName}.\r\n\r\nDiagnostic Settings URI format:\r\nPUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview\r\n\r\nFor more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)\r\nor [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)\r\n"]
    #[serde(rename = "isAzureMonitorTargetEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_azure_monitor_target_enabled: Option<bool>,
    #[doc = "Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.\r\nThe default minimum value is 1000 (1 second). The maximum is 2,147,483,647."]
    #[serde(rename = "queueDelayMs", default, skip_serializing_if = "Option::is_none")]
    pub queue_delay_ms: Option<i32>,
}
impl DatabaseBlobAuditingPolicyProperties {
    pub fn new(state: database_blob_auditing_policy_properties::State) -> Self {
        Self {
            state,
            storage_endpoint: None,
            storage_account_access_key: None,
            retention_days: None,
            audit_actions_and_groups: Vec::new(),
            storage_account_subscription_id: None,
            is_storage_secondary_key_in_use: None,
            is_azure_monitor_target_enabled: None,
            queue_delay_ms: None,
        }
    }
}
pub mod database_blob_auditing_policy_properties {
    use super::*;
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
}
#[doc = "Represents the response to a list database request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseListResult {
    #[doc = "The list of databases housed in the server."]
    pub value: Vec<Database>,
}
impl DatabaseListResult {
    pub fn new(value: Vec<Database>) -> Self {
        Self { value }
    }
}
#[doc = "A database operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseOperation {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of a database operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseOperationProperties>,
}
impl DatabaseOperation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list database operations request"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseOperationListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DatabaseOperation>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DatabaseOperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a database operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseOperationProperties {
    #[doc = "The name of the database the operation is being performed on."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "The name of operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "The friendly name of operation."]
    #[serde(rename = "operationFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub operation_friendly_name: Option<String>,
    #[doc = "The percentage of the operation completed."]
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<i32>,
    #[doc = "The name of the server."]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "The operation start time."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The operation state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<database_operation_properties::State>,
    #[doc = "The operation error code."]
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[doc = "The operation error description."]
    #[serde(rename = "errorDescription", default, skip_serializing_if = "Option::is_none")]
    pub error_description: Option<String>,
    #[doc = "The operation error severity."]
    #[serde(rename = "errorSeverity", default, skip_serializing_if = "Option::is_none")]
    pub error_severity: Option<i32>,
    #[doc = "Whether or not the error is a user error."]
    #[serde(rename = "isUserError", default, skip_serializing_if = "Option::is_none")]
    pub is_user_error: Option<bool>,
    #[doc = "The estimated completion time of the operation."]
    #[serde(rename = "estimatedCompletionTime", default, skip_serializing_if = "Option::is_none")]
    pub estimated_completion_time: Option<String>,
    #[doc = "The operation description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Whether the operation can be cancelled."]
    #[serde(rename = "isCancellable", default, skip_serializing_if = "Option::is_none")]
    pub is_cancellable: Option<bool>,
}
impl DatabaseOperationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod database_operation_properties {
    use super::*;
    #[doc = "The operation state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Pending,
        InProgress,
        Succeeded,
        Failed,
        CancelInProgress,
        Cancelled,
    }
}
#[doc = "Represents the properties of a database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseProperties {
    #[doc = "The collation of the database. If createMode is not Default, this value is ignored."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub collation: Option<String>,
    #[doc = "The creation date of the database (ISO8601 format)."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "The containment state of the database."]
    #[serde(rename = "containmentState", default, skip_serializing_if = "Option::is_none")]
    pub containment_state: Option<i64>,
    #[doc = "The current service level objective ID of the database. This is the ID of the service level objective that is currently active."]
    #[serde(rename = "currentServiceObjectiveId", default, skip_serializing_if = "Option::is_none")]
    pub current_service_objective_id: Option<String>,
    #[doc = "The ID of the database."]
    #[serde(rename = "databaseId", default, skip_serializing_if = "Option::is_none")]
    pub database_id: Option<String>,
    #[doc = "This records the earliest start date and time that restore is available for this database (ISO8601 format)."]
    #[serde(rename = "earliestRestoreDate", default, skip_serializing_if = "Option::is_none")]
    pub earliest_restore_date: Option<String>,
    #[doc = "Specifies the mode of database creation.\n\nDefault: regular database creation.\n\nCopy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.\n\nOnlineSecondary/NonReadableSecondary: creates a database as a (readable or nonreadable) secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.\n\nPointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.\n\nRecovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.\n\nRestore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.\n\nRestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.\n\nCopy, NonReadableSecondary, OnlineSecondary and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition."]
    #[serde(rename = "createMode", default, skip_serializing_if = "Option::is_none")]
    pub create_mode: Option<database_properties::CreateMode>,
    #[doc = "Conditional. If createMode is Copy, NonReadableSecondary, OnlineSecondary, PointInTimeRestore, Recovery, or Restore, then this value is required. Specifies the resource ID of the source database. If createMode is NonReadableSecondary or OnlineSecondary, the name of the source database must be the same as the new database being created."]
    #[serde(rename = "sourceDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub source_database_id: Option<String>,
    #[doc = "Conditional. If createMode is Restore and sourceDatabaseId is the deleted database's original resource id when it existed (as opposed to its current restorable dropped database id), then this value is required. Specifies the time that the database was deleted."]
    #[serde(rename = "sourceDatabaseDeletionDate", default, skip_serializing_if = "Option::is_none")]
    pub source_database_deletion_date: Option<String>,
    #[doc = "Conditional. If createMode is PointInTimeRestore, this value is required. If createMode is Restore, this value is optional. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. Must be greater than or equal to the source database's earliestRestoreDate value."]
    #[serde(rename = "restorePointInTime", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_in_time: Option<String>,
    #[doc = "Conditional. If createMode is RestoreLongTermRetentionBackup, then this value is required. Specifies the resource ID of the recovery point to restore from."]
    #[serde(
        rename = "recoveryServicesRecoveryPointResourceId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub recovery_services_recovery_point_resource_id: Option<String>,
    #[doc = "The edition of the database. The DatabaseEditions enumeration contains all the valid editions. If createMode is NonReadableSecondary or OnlineSecondary, this value is ignored.\r\n\r\nThe list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:\r\n\r\n```azurecli\r\naz sql db list-editions -l <location> -o table\r\n````\r\n\r\n```powershell\r\nGet-AzSqlServerServiceObjective -Location <location>\r\n````\r\n"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub edition: Option<database_properties::Edition>,
    #[doc = "The max size of the database expressed in bytes. If createMode is not Default, this value is ignored. To see possible values, query the capabilities API (/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationID}/capabilities) referred to by operationId: \"Capabilities_ListByLocation.\""]
    #[serde(rename = "maxSizeBytes", default, skip_serializing_if = "Option::is_none")]
    pub max_size_bytes: Option<String>,
    #[doc = "The configured service level objective ID of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of currentServiceObjectiveId property. If requestedServiceObjectiveId and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveId overrides the value of requestedServiceObjectiveName.\r\n\r\nThe list of SKUs may vary by region and support offer. To determine the service objective ids that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API."]
    #[serde(rename = "requestedServiceObjectiveId", default, skip_serializing_if = "Option::is_none")]
    pub requested_service_objective_id: Option<String>,
    #[doc = "The name of the configured service level objective of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of serviceLevelObjective property. \r\n\r\nThe list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:\r\n\r\n```azurecli\r\naz sql db list-editions -l <location> -o table\r\n````\r\n\r\n```powershell\r\nGet-AzSqlServerServiceObjective -Location <location>\r\n````\r\n"]
    #[serde(rename = "requestedServiceObjectiveName", default, skip_serializing_if = "Option::is_none")]
    pub requested_service_objective_name: Option<database_properties::RequestedServiceObjectiveName>,
    #[doc = "The current service level objective of the database."]
    #[serde(rename = "serviceLevelObjective", default, skip_serializing_if = "Option::is_none")]
    pub service_level_objective: Option<database_properties::ServiceLevelObjective>,
    #[doc = "The status of the database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The name of the elastic pool the database is in. If elasticPoolName and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveName is ignored. Not supported for DataWarehouse edition."]
    #[serde(rename = "elasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub elastic_pool_name: Option<String>,
    #[doc = "The default secondary region for this database."]
    #[serde(rename = "defaultSecondaryLocation", default, skip_serializing_if = "Option::is_none")]
    pub default_secondary_location: Option<String>,
    #[doc = "The list of service tier advisors for this database. Expanded property"]
    #[serde(rename = "serviceTierAdvisors", default, skip_serializing_if = "Vec::is_empty")]
    pub service_tier_advisors: Vec<ServiceTierAdvisor>,
    #[doc = "The transparent data encryption info for this database."]
    #[serde(rename = "transparentDataEncryption", default, skip_serializing_if = "Vec::is_empty")]
    pub transparent_data_encryption: Vec<TransparentDataEncryption>,
    #[doc = "The recommended indices for this database."]
    #[serde(rename = "recommendedIndex", default, skip_serializing_if = "Vec::is_empty")]
    pub recommended_index: Vec<RecommendedIndex>,
    #[doc = "The resource identifier of the failover group containing this database."]
    #[serde(rename = "failoverGroupId", default, skip_serializing_if = "Option::is_none")]
    pub failover_group_id: Option<String>,
    #[doc = "Conditional. If the database is a geo-secondary, readScale indicates whether read-only connections are allowed to this database or not. Not supported for DataWarehouse edition."]
    #[serde(rename = "readScale", default, skip_serializing_if = "Option::is_none")]
    pub read_scale: Option<database_properties::ReadScale>,
    #[doc = "Indicates the name of the sample schema to apply when creating this database. If createMode is not Default, this value is ignored. Not supported for DataWarehouse edition."]
    #[serde(rename = "sampleName", default, skip_serializing_if = "Option::is_none")]
    pub sample_name: Option<database_properties::SampleName>,
    #[doc = "Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones."]
    #[serde(rename = "zoneRedundant", default, skip_serializing_if = "Option::is_none")]
    pub zone_redundant: Option<bool>,
}
impl DatabaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod database_properties {
    use super::*;
    #[doc = "Specifies the mode of database creation.\n\nDefault: regular database creation.\n\nCopy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.\n\nOnlineSecondary/NonReadableSecondary: creates a database as a (readable or nonreadable) secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.\n\nPointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.\n\nRecovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.\n\nRestore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.\n\nRestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.\n\nCopy, NonReadableSecondary, OnlineSecondary and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreateMode {
        Copy,
        Default,
        NonReadableSecondary,
        OnlineSecondary,
        PointInTimeRestore,
        Recovery,
        Restore,
        RestoreLongTermRetentionBackup,
    }
    #[doc = "The edition of the database. The DatabaseEditions enumeration contains all the valid editions. If createMode is NonReadableSecondary or OnlineSecondary, this value is ignored.\r\n\r\nThe list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:\r\n\r\n```azurecli\r\naz sql db list-editions -l <location> -o table\r\n````\r\n\r\n```powershell\r\nGet-AzSqlServerServiceObjective -Location <location>\r\n````\r\n"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Edition {
        Web,
        Business,
        Basic,
        Standard,
        Premium,
        #[serde(rename = "PremiumRS")]
        PremiumRs,
        Free,
        Stretch,
        DataWarehouse,
        System,
        System2,
        GeneralPurpose,
        BusinessCritical,
        Hyperscale,
    }
    #[doc = "The name of the configured service level objective of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of serviceLevelObjective property. \r\n\r\nThe list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:\r\n\r\n```azurecli\r\naz sql db list-editions -l <location> -o table\r\n````\r\n\r\n```powershell\r\nGet-AzSqlServerServiceObjective -Location <location>\r\n````\r\n"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RequestedServiceObjectiveName {
        System,
        System0,
        System1,
        System2,
        System3,
        System4,
        System2L,
        System3L,
        System4L,
        Free,
        Basic,
        S0,
        S1,
        S2,
        S3,
        S4,
        S6,
        S7,
        S9,
        S12,
        P1,
        P2,
        P3,
        P4,
        P6,
        P11,
        P15,
        #[serde(rename = "PRS1")]
        Prs1,
        #[serde(rename = "PRS2")]
        Prs2,
        #[serde(rename = "PRS4")]
        Prs4,
        #[serde(rename = "PRS6")]
        Prs6,
        #[serde(rename = "DW100")]
        Dw100,
        #[serde(rename = "DW200")]
        Dw200,
        #[serde(rename = "DW300")]
        Dw300,
        #[serde(rename = "DW400")]
        Dw400,
        #[serde(rename = "DW500")]
        Dw500,
        #[serde(rename = "DW600")]
        Dw600,
        #[serde(rename = "DW1000")]
        Dw1000,
        #[serde(rename = "DW1200")]
        Dw1200,
        #[serde(rename = "DW1000c")]
        Dw1000c,
        #[serde(rename = "DW1500")]
        Dw1500,
        #[serde(rename = "DW1500c")]
        Dw1500c,
        #[serde(rename = "DW2000")]
        Dw2000,
        #[serde(rename = "DW2000c")]
        Dw2000c,
        #[serde(rename = "DW3000")]
        Dw3000,
        #[serde(rename = "DW2500c")]
        Dw2500c,
        #[serde(rename = "DW3000c")]
        Dw3000c,
        #[serde(rename = "DW6000")]
        Dw6000,
        #[serde(rename = "DW5000c")]
        Dw5000c,
        #[serde(rename = "DW6000c")]
        Dw6000c,
        #[serde(rename = "DW7500c")]
        Dw7500c,
        #[serde(rename = "DW10000c")]
        Dw10000c,
        #[serde(rename = "DW15000c")]
        Dw15000c,
        #[serde(rename = "DW30000c")]
        Dw30000c,
        #[serde(rename = "DS100")]
        Ds100,
        #[serde(rename = "DS200")]
        Ds200,
        #[serde(rename = "DS300")]
        Ds300,
        #[serde(rename = "DS400")]
        Ds400,
        #[serde(rename = "DS500")]
        Ds500,
        #[serde(rename = "DS600")]
        Ds600,
        #[serde(rename = "DS1000")]
        Ds1000,
        #[serde(rename = "DS1200")]
        Ds1200,
        #[serde(rename = "DS1500")]
        Ds1500,
        #[serde(rename = "DS2000")]
        Ds2000,
        ElasticPool,
    }
    #[doc = "The current service level objective of the database."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceLevelObjective {
        System,
        System0,
        System1,
        System2,
        System3,
        System4,
        System2L,
        System3L,
        System4L,
        Free,
        Basic,
        S0,
        S1,
        S2,
        S3,
        S4,
        S6,
        S7,
        S9,
        S12,
        P1,
        P2,
        P3,
        P4,
        P6,
        P11,
        P15,
        #[serde(rename = "PRS1")]
        Prs1,
        #[serde(rename = "PRS2")]
        Prs2,
        #[serde(rename = "PRS4")]
        Prs4,
        #[serde(rename = "PRS6")]
        Prs6,
        #[serde(rename = "DW100")]
        Dw100,
        #[serde(rename = "DW200")]
        Dw200,
        #[serde(rename = "DW300")]
        Dw300,
        #[serde(rename = "DW400")]
        Dw400,
        #[serde(rename = "DW500")]
        Dw500,
        #[serde(rename = "DW600")]
        Dw600,
        #[serde(rename = "DW1000")]
        Dw1000,
        #[serde(rename = "DW1200")]
        Dw1200,
        #[serde(rename = "DW1000c")]
        Dw1000c,
        #[serde(rename = "DW1500")]
        Dw1500,
        #[serde(rename = "DW1500c")]
        Dw1500c,
        #[serde(rename = "DW2000")]
        Dw2000,
        #[serde(rename = "DW2000c")]
        Dw2000c,
        #[serde(rename = "DW3000")]
        Dw3000,
        #[serde(rename = "DW2500c")]
        Dw2500c,
        #[serde(rename = "DW3000c")]
        Dw3000c,
        #[serde(rename = "DW6000")]
        Dw6000,
        #[serde(rename = "DW5000c")]
        Dw5000c,
        #[serde(rename = "DW6000c")]
        Dw6000c,
        #[serde(rename = "DW7500c")]
        Dw7500c,
        #[serde(rename = "DW10000c")]
        Dw10000c,
        #[serde(rename = "DW15000c")]
        Dw15000c,
        #[serde(rename = "DW30000c")]
        Dw30000c,
        #[serde(rename = "DS100")]
        Ds100,
        #[serde(rename = "DS200")]
        Ds200,
        #[serde(rename = "DS300")]
        Ds300,
        #[serde(rename = "DS400")]
        Ds400,
        #[serde(rename = "DS500")]
        Ds500,
        #[serde(rename = "DS600")]
        Ds600,
        #[serde(rename = "DS1000")]
        Ds1000,
        #[serde(rename = "DS1200")]
        Ds1200,
        #[serde(rename = "DS1500")]
        Ds1500,
        #[serde(rename = "DS2000")]
        Ds2000,
        ElasticPool,
    }
    #[doc = "Conditional. If the database is a geo-secondary, readScale indicates whether read-only connections are allowed to this database or not. Not supported for DataWarehouse edition."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReadScale {
        Enabled,
        Disabled,
    }
    #[doc = "Indicates the name of the sample schema to apply when creating this database. If createMode is not Default, this value is ignored. Not supported for DataWarehouse edition."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SampleName {
        #[serde(rename = "AdventureWorksLT")]
        AdventureWorksLt,
    }
}
#[doc = "Contains information about a database Threat Detection policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseSecurityAlertPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The geo-location where the resource lives"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource kind."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Properties for a database Threat Detection policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseSecurityAlertPolicyProperties>,
}
impl DatabaseSecurityAlertPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties for a database Threat Detection policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseSecurityAlertPolicyProperties {
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required."]
    pub state: database_security_alert_policy_properties::State,
    #[doc = "Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action."]
    #[serde(rename = "disabledAlerts", default, skip_serializing_if = "Option::is_none")]
    pub disabled_alerts: Option<String>,
    #[doc = "Specifies the semicolon-separated list of e-mail addresses to which the alert is sent."]
    #[serde(rename = "emailAddresses", default, skip_serializing_if = "Option::is_none")]
    pub email_addresses: Option<String>,
    #[doc = "Specifies that the alert is sent to the account administrators."]
    #[serde(rename = "emailAccountAdmins", default, skip_serializing_if = "Option::is_none")]
    pub email_account_admins: Option<database_security_alert_policy_properties::EmailAccountAdmins>,
    #[doc = "Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required."]
    #[serde(rename = "storageEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub storage_endpoint: Option<String>,
    #[doc = "Specifies the identifier key of the Threat Detection audit storage account. If state is Enabled, storageAccountAccessKey is required."]
    #[serde(rename = "storageAccountAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_access_key: Option<String>,
    #[doc = "Specifies the number of days to keep in the Threat Detection audit logs."]
    #[serde(rename = "retentionDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i32>,
    #[doc = "Specifies whether to use the default server policy."]
    #[serde(rename = "useServerDefault", default, skip_serializing_if = "Option::is_none")]
    pub use_server_default: Option<database_security_alert_policy_properties::UseServerDefault>,
}
impl DatabaseSecurityAlertPolicyProperties {
    pub fn new(state: database_security_alert_policy_properties::State) -> Self {
        Self {
            state,
            disabled_alerts: None,
            email_addresses: None,
            email_account_admins: None,
            storage_endpoint: None,
            storage_account_access_key: None,
            retention_days: None,
            use_server_default: None,
        }
    }
}
pub mod database_security_alert_policy_properties {
    use super::*;
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        New,
        Enabled,
        Disabled,
    }
    #[doc = "Specifies that the alert is sent to the account administrators."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EmailAccountAdmins {
        Enabled,
        Disabled,
    }
    #[doc = "Specifies whether to use the default server policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UseServerDefault {
        Enabled,
        Disabled,
    }
}
#[doc = "Represents a database update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseUpdate {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Represents the properties of a database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseProperties>,
}
impl DatabaseUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The database usages."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseUsage {
    #[doc = "The name of the usage metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
    pub resource_name: Option<String>,
    #[doc = "The usage metric display name."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The current value of the usage metric."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<f64>,
    #[doc = "The current limit of the usage metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<f64>,
    #[doc = "The units of the usage metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[doc = "The next reset time for the usage metric (ISO8601 format)."]
    #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
    pub next_reset_time: Option<String>,
}
impl DatabaseUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list database metrics request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseUsageListResult {
    #[doc = "The list of database usages for the database."]
    pub value: Vec<DatabaseUsage>,
}
impl DatabaseUsageListResult {
    pub fn new(value: Vec<DatabaseUsage>) -> Self {
        Self { value }
    }
}
#[doc = "A database vulnerability assessment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseVulnerabilityAssessment {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a database Vulnerability Assessment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseVulnerabilityAssessmentProperties>,
}
impl DatabaseVulnerabilityAssessment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of the database's vulnerability assessments."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseVulnerabilityAssessmentListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DatabaseVulnerabilityAssessment>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DatabaseVulnerabilityAssessmentListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a database Vulnerability Assessment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseVulnerabilityAssessmentProperties {
    #[doc = "A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set"]
    #[serde(rename = "storageContainerPath", default, skip_serializing_if = "Option::is_none")]
    pub storage_container_path: Option<String>,
    #[doc = "A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required."]
    #[serde(rename = "storageContainerSasKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_container_sas_key: Option<String>,
    #[doc = "Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required."]
    #[serde(rename = "storageAccountAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_access_key: Option<String>,
    #[doc = "Properties of a Vulnerability Assessment recurring scans."]
    #[serde(rename = "recurringScans", default, skip_serializing_if = "Option::is_none")]
    pub recurring_scans: Option<VulnerabilityAssessmentRecurringScansProperties>,
}
impl DatabaseVulnerabilityAssessmentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A database vulnerability assessment rule baseline."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseVulnerabilityAssessmentRuleBaseline {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a database Vulnerability Assessment rule baseline."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseVulnerabilityAssessmentRuleBaselineProperties>,
}
impl DatabaseVulnerabilityAssessmentRuleBaseline {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseVulnerabilityAssessmentRuleBaselineItem {
    #[doc = "The rule baseline result"]
    pub result: Vec<String>,
}
impl DatabaseVulnerabilityAssessmentRuleBaselineItem {
    pub fn new(result: Vec<String>) -> Self {
        Self { result }
    }
}
#[doc = "Properties of a database Vulnerability Assessment rule baseline."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseVulnerabilityAssessmentRuleBaselineProperties {
    #[doc = "The rule baseline result"]
    #[serde(rename = "baselineResults")]
    pub baseline_results: Vec<DatabaseVulnerabilityAssessmentRuleBaselineItem>,
}
impl DatabaseVulnerabilityAssessmentRuleBaselineProperties {
    pub fn new(baseline_results: Vec<DatabaseVulnerabilityAssessmentRuleBaselineItem>) -> Self {
        Self { baseline_results }
    }
}
#[doc = "The database edition capabilities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EditionCapability {
    #[doc = "The edition name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The availability status of the capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<CapabilityStatus>,
    #[doc = "The list of supported service objectives for the edition."]
    #[serde(rename = "supportedServiceLevelObjectives", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_service_level_objectives: Vec<ServiceObjectiveCapability>,
    #[doc = "Whether or not zone redundancy is supported for the edition."]
    #[serde(rename = "zoneRedundant", default, skip_serializing_if = "Option::is_none")]
    pub zone_redundant: Option<bool>,
}
impl EditionCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a database elastic pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ElasticPool {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Represents the properties of an elastic pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ElasticPoolProperties>,
    #[doc = "Kind of elastic pool.  This is metadata used for the Azure portal experience."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl ElasticPool {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
            kind: None,
        }
    }
}
#[doc = "Represents the activity on an elastic pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolActivity {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The geo-location where the resource lives"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Represents the properties of an elastic pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ElasticPoolActivityProperties>,
}
impl ElasticPoolActivity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the response to a list elastic pool activity request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ElasticPoolActivityListResult {
    #[doc = "The list of elastic pool activities."]
    pub value: Vec<ElasticPoolActivity>,
}
impl ElasticPoolActivityListResult {
    pub fn new(value: Vec<ElasticPoolActivity>) -> Self {
        Self { value }
    }
}
#[doc = "Represents the properties of an elastic pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolActivityProperties {
    #[doc = "The time the operation finished (ISO8601 format)."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The error code if available."]
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[doc = "The error message if available."]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[doc = "The error severity if available."]
    #[serde(rename = "errorSeverity", default, skip_serializing_if = "Option::is_none")]
    pub error_severity: Option<i32>,
    #[doc = "The operation name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "The unique operation ID."]
    #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
    pub operation_id: Option<String>,
    #[doc = "The percentage complete if available."]
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<i32>,
    #[doc = "The requested max DTU per database if available."]
    #[serde(rename = "requestedDatabaseDtuMax", default, skip_serializing_if = "Option::is_none")]
    pub requested_database_dtu_max: Option<i32>,
    #[doc = "The requested min DTU per database if available."]
    #[serde(rename = "requestedDatabaseDtuMin", default, skip_serializing_if = "Option::is_none")]
    pub requested_database_dtu_min: Option<i32>,
    #[doc = "The requested DTU for the pool if available."]
    #[serde(rename = "requestedDtu", default, skip_serializing_if = "Option::is_none")]
    pub requested_dtu: Option<i32>,
    #[doc = "The requested name for the elastic pool if available."]
    #[serde(rename = "requestedElasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub requested_elastic_pool_name: Option<String>,
    #[doc = "The requested storage limit for the pool in GB if available."]
    #[serde(rename = "requestedStorageLimitInGB", default, skip_serializing_if = "Option::is_none")]
    pub requested_storage_limit_in_gb: Option<i64>,
    #[doc = "The name of the elastic pool."]
    #[serde(rename = "elasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub elastic_pool_name: Option<String>,
    #[doc = "The name of the server the elastic pool is in."]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "The time the operation started (ISO8601 format)."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The current state of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The requested storage limit in MB."]
    #[serde(rename = "requestedStorageLimitInMB", default, skip_serializing_if = "Option::is_none")]
    pub requested_storage_limit_in_mb: Option<i32>,
    #[doc = "The requested per database DTU guarantee."]
    #[serde(rename = "requestedDatabaseDtuGuarantee", default, skip_serializing_if = "Option::is_none")]
    pub requested_database_dtu_guarantee: Option<i32>,
    #[doc = "The requested per database DTU cap."]
    #[serde(rename = "requestedDatabaseDtuCap", default, skip_serializing_if = "Option::is_none")]
    pub requested_database_dtu_cap: Option<i32>,
    #[doc = "The requested DTU guarantee."]
    #[serde(rename = "requestedDtuGuarantee", default, skip_serializing_if = "Option::is_none")]
    pub requested_dtu_guarantee: Option<i32>,
}
impl ElasticPoolActivityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the activity on an elastic pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolDatabaseActivity {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The geo-location where the resource lives"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Represents the properties of an elastic pool database activity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ElasticPoolDatabaseActivityProperties>,
}
impl ElasticPoolDatabaseActivity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the response to a list elastic pool database activity request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ElasticPoolDatabaseActivityListResult {
    #[doc = "The list of elastic pool database activities."]
    pub value: Vec<ElasticPoolDatabaseActivity>,
}
impl ElasticPoolDatabaseActivityListResult {
    pub fn new(value: Vec<ElasticPoolDatabaseActivity>) -> Self {
        Self { value }
    }
}
#[doc = "Represents the properties of an elastic pool database activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolDatabaseActivityProperties {
    #[doc = "The database name."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "The time the operation finished (ISO8601 format)."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The error code if available."]
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[doc = "The error message if available."]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[doc = "The error severity if available."]
    #[serde(rename = "errorSeverity", default, skip_serializing_if = "Option::is_none")]
    pub error_severity: Option<i32>,
    #[doc = "The operation name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "The unique operation ID."]
    #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
    pub operation_id: Option<String>,
    #[doc = "The percentage complete if available."]
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<i32>,
    #[doc = "The name for the elastic pool the database is moving into if available."]
    #[serde(rename = "requestedElasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub requested_elastic_pool_name: Option<String>,
    #[doc = "The name of the current elastic pool the database is in if available."]
    #[serde(rename = "currentElasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub current_elastic_pool_name: Option<String>,
    #[doc = "The name of the current service objective if available."]
    #[serde(rename = "currentServiceObjective", default, skip_serializing_if = "Option::is_none")]
    pub current_service_objective: Option<String>,
    #[doc = "The name of the requested service objective if available."]
    #[serde(rename = "requestedServiceObjective", default, skip_serializing_if = "Option::is_none")]
    pub requested_service_objective: Option<String>,
    #[doc = "The name of the server the elastic pool is in."]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "The time the operation started (ISO8601 format)."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The current state of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}
impl ElasticPoolDatabaseActivityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Elastic Pool DTU capability."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolDtuCapability {
    #[doc = "The maximum size of the database (see 'unit' for the units)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "The maximum number of databases supported."]
    #[serde(rename = "maxDatabaseCount", default, skip_serializing_if = "Option::is_none")]
    pub max_database_count: Option<i64>,
    #[doc = "The availability status of the capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<CapabilityStatus>,
    #[doc = "The list of supported max sizes."]
    #[serde(rename = "supportedMaxSizes", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_max_sizes: Vec<MaxSizeCapability>,
    #[doc = "The maximum size limits for a database."]
    #[serde(rename = "includedMaxSize", default, skip_serializing_if = "Option::is_none")]
    pub included_max_size: Option<MaxSizeCapability>,
    #[doc = "The list of supported max database sizes."]
    #[serde(rename = "supportedPerDatabaseMaxSizes", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_per_database_max_sizes: Vec<MaxSizeCapability>,
    #[doc = "The list of supported max database DTUs."]
    #[serde(rename = "supportedPerDatabaseMaxDtus", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_per_database_max_dtus: Vec<ElasticPoolPerDatabaseMaxDtuCapability>,
}
impl ElasticPoolDtuCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The elastic pool edition capabilities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolEditionCapability {
    #[doc = "The elastic pool edition name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The availability status of the capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<CapabilityStatus>,
    #[doc = "The list of supported elastic pool DTU levels for the edition."]
    #[serde(rename = "supportedElasticPoolDtus", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_elastic_pool_dtus: Vec<ElasticPoolDtuCapability>,
    #[doc = "Whether or not zone redundancy is supported for the edition."]
    #[serde(rename = "zoneRedundant", default, skip_serializing_if = "Option::is_none")]
    pub zone_redundant: Option<bool>,
}
impl ElasticPoolEditionCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the response to a list elastic pool request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ElasticPoolListResult {
    #[doc = "The list of elastic pools hosted in the server."]
    pub value: Vec<ElasticPool>,
}
impl ElasticPoolListResult {
    pub fn new(value: Vec<ElasticPool>) -> Self {
        Self { value }
    }
}
#[doc = "The max per-database DTU capability."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolPerDatabaseMaxDtuCapability {
    #[doc = "The maximum DTUs per database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "The availability status of the capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<CapabilityStatus>,
    #[doc = "The list of supported min database DTUs."]
    #[serde(rename = "supportedPerDatabaseMinDtus", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_per_database_min_dtus: Vec<ElasticPoolPerDatabaseMinDtuCapability>,
}
impl ElasticPoolPerDatabaseMaxDtuCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The minimum per-database DTU capability."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolPerDatabaseMinDtuCapability {
    #[doc = "The maximum DTUs per database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "The availability status of the capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<CapabilityStatus>,
}
impl ElasticPoolPerDatabaseMinDtuCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the properties of an elastic pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolProperties {
    #[doc = "The creation date of the elastic pool (ISO8601 format)."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "The state of the elastic pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<elastic_pool_properties::State>,
    #[doc = "The edition of the elastic pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub edition: Option<elastic_pool_properties::Edition>,
    #[doc = "The total shared DTU for the database elastic pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dtu: Option<i32>,
    #[doc = "The maximum DTU any one database can consume."]
    #[serde(rename = "databaseDtuMax", default, skip_serializing_if = "Option::is_none")]
    pub database_dtu_max: Option<i32>,
    #[doc = "The minimum DTU all databases are guaranteed."]
    #[serde(rename = "databaseDtuMin", default, skip_serializing_if = "Option::is_none")]
    pub database_dtu_min: Option<i32>,
    #[doc = "Gets storage limit for the database elastic pool in MB."]
    #[serde(rename = "storageMB", default, skip_serializing_if = "Option::is_none")]
    pub storage_mb: Option<i32>,
    #[doc = "Whether or not this database elastic pool is zone redundant, which means the replicas of this database will be spread across multiple availability zones."]
    #[serde(rename = "zoneRedundant", default, skip_serializing_if = "Option::is_none")]
    pub zone_redundant: Option<bool>,
}
impl ElasticPoolProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod elastic_pool_properties {
    use super::*;
    #[doc = "The state of the elastic pool."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Creating,
        Ready,
        Disabled,
    }
    #[doc = "The edition of the elastic pool."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Edition {
        Basic,
        Standard,
        Premium,
        GeneralPurpose,
        BusinessCritical,
    }
}
#[doc = "Represents an elastic pool update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolUpdate {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Represents the properties of an elastic pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ElasticPoolProperties>,
}
impl ElasticPoolUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The server encryption protector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionProtector {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Kind of encryption protector. This is metadata used for the Azure portal experience."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Properties for an encryption protector execution."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EncryptionProtectorProperties>,
}
impl EncryptionProtector {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of server encryption protectors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionProtectorListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EncryptionProtector>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EncryptionProtectorListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties for an encryption protector execution."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptionProtectorProperties {
    #[doc = "Subregion of the encryption protector."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subregion: Option<String>,
    #[doc = "The name of the server key."]
    #[serde(rename = "serverKeyName", default, skip_serializing_if = "Option::is_none")]
    pub server_key_name: Option<String>,
    #[doc = "The encryption protector type like 'ServiceManaged', 'AzureKeyVault'."]
    #[serde(rename = "serverKeyType")]
    pub server_key_type: encryption_protector_properties::ServerKeyType,
    #[doc = "The URI of the server key."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
    #[doc = "Thumbprint of the server key."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
}
impl EncryptionProtectorProperties {
    pub fn new(server_key_type: encryption_protector_properties::ServerKeyType) -> Self {
        Self {
            subregion: None,
            server_key_name: None,
            server_key_type,
            uri: None,
            thumbprint: None,
        }
    }
}
pub mod encryption_protector_properties {
    use super::*;
    #[doc = "The encryption protector type like 'ServiceManaged', 'AzureKeyVault'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServerKeyType {
        ServiceManaged,
        AzureKeyVault,
    }
}
#[doc = "Export database parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportRequest {
    #[doc = "The type of the storage key to use."]
    #[serde(rename = "storageKeyType")]
    pub storage_key_type: export_request::StorageKeyType,
    #[doc = "The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a \"?.\""]
    #[serde(rename = "storageKey")]
    pub storage_key: String,
    #[doc = "The storage uri to use."]
    #[serde(rename = "storageUri")]
    pub storage_uri: String,
    #[doc = "The name of the SQL administrator."]
    #[serde(rename = "administratorLogin")]
    pub administrator_login: String,
    #[doc = "The password of the SQL administrator."]
    #[serde(rename = "administratorLoginPassword")]
    pub administrator_login_password: String,
    #[doc = "The authentication type."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<export_request::AuthenticationType>,
}
impl ExportRequest {
    pub fn new(
        storage_key_type: export_request::StorageKeyType,
        storage_key: String,
        storage_uri: String,
        administrator_login: String,
        administrator_login_password: String,
    ) -> Self {
        Self {
            storage_key_type,
            storage_key,
            storage_uri,
            administrator_login,
            administrator_login_password,
            authentication_type: None,
        }
    }
}
pub mod export_request {
    use super::*;
    #[doc = "The type of the storage key to use."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageKeyType {
        StorageAccessKey,
        SharedAccessKey,
    }
    #[doc = "The authentication type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        #[serde(rename = "SQL")]
        Sql,
        #[serde(rename = "ADPassword")]
        AdPassword,
    }
    impl Default for AuthenticationType {
        fn default() -> Self {
            Self::Sql
        }
    }
}
#[doc = "An extended database blob auditing policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedDatabaseBlobAuditingPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of an extended database blob auditing policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExtendedDatabaseBlobAuditingPolicyProperties>,
}
impl ExtendedDatabaseBlobAuditingPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of database extended auditing settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedDatabaseBlobAuditingPolicyListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExtendedDatabaseBlobAuditingPolicy>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExtendedDatabaseBlobAuditingPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an extended database blob auditing policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExtendedDatabaseBlobAuditingPolicyProperties {
    #[doc = "Specifies condition of where clause when creating an audit."]
    #[serde(rename = "predicateExpression", default, skip_serializing_if = "Option::is_none")]
    pub predicate_expression: Option<String>,
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required."]
    pub state: extended_database_blob_auditing_policy_properties::State,
    #[doc = "Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required."]
    #[serde(rename = "storageEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub storage_endpoint: Option<String>,
    #[doc = "Specifies the identifier key of the auditing storage account. \r\nIf state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.\r\nPrerequisites for using managed identity authentication:\r\n1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).\r\n2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.\r\nFor more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)"]
    #[serde(rename = "storageAccountAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_access_key: Option<String>,
    #[doc = "Specifies the number of days to keep in the audit logs in the storage account."]
    #[serde(rename = "retentionDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i32>,
    #[doc = "Specifies the Actions-Groups and Actions to audit.\r\n\r\nThe recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:\r\n\r\nBATCH_COMPLETED_GROUP,\r\nSUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,\r\nFAILED_DATABASE_AUTHENTICATION_GROUP.\r\n\r\nThis above combination is also the set that is configured by default when enabling auditing from the Azure portal.\r\n\r\nThe supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):\r\n\r\nAPPLICATION_ROLE_CHANGE_PASSWORD_GROUP\r\nBACKUP_RESTORE_GROUP\r\nDATABASE_LOGOUT_GROUP\r\nDATABASE_OBJECT_CHANGE_GROUP\r\nDATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP\r\nDATABASE_OBJECT_PERMISSION_CHANGE_GROUP\r\nDATABASE_OPERATION_GROUP\r\nDATABASE_PERMISSION_CHANGE_GROUP\r\nDATABASE_PRINCIPAL_CHANGE_GROUP\r\nDATABASE_PRINCIPAL_IMPERSONATION_GROUP\r\nDATABASE_ROLE_MEMBER_CHANGE_GROUP\r\nFAILED_DATABASE_AUTHENTICATION_GROUP\r\nSCHEMA_OBJECT_ACCESS_GROUP\r\nSCHEMA_OBJECT_CHANGE_GROUP\r\nSCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP\r\nSCHEMA_OBJECT_PERMISSION_CHANGE_GROUP\r\nSUCCESSFUL_DATABASE_AUTHENTICATION_GROUP\r\nUSER_CHANGE_PASSWORD_GROUP\r\nBATCH_STARTED_GROUP\r\nBATCH_COMPLETED_GROUP\r\nDBCC_GROUP\r\nDATABASE_OWNERSHIP_CHANGE_GROUP\r\nDATABASE_CHANGE_GROUP\r\n\r\nThese are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.\r\n\r\nFor more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).\r\n\r\nFor Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:\r\nSELECT\r\nUPDATE\r\nINSERT\r\nDELETE\r\nEXECUTE\r\nRECEIVE\r\nREFERENCES\r\n\r\nThe general form for defining an action to be audited is:\r\n{action} ON {object} BY {principal}\r\n\r\nNote that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.\r\n\r\nFor example:\r\nSELECT on dbo.myTable by public\r\nSELECT on DATABASE::myDatabase by public\r\nSELECT on SCHEMA::mySchema by public\r\n\r\nFor more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)"]
    #[serde(rename = "auditActionsAndGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub audit_actions_and_groups: Vec<String>,
    #[doc = "Specifies the blob storage subscription Id."]
    #[serde(rename = "storageAccountSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_subscription_id: Option<String>,
    #[doc = "Specifies whether storageAccountAccessKey value is the storage's secondary key."]
    #[serde(rename = "isStorageSecondaryKeyInUse", default, skip_serializing_if = "Option::is_none")]
    pub is_storage_secondary_key_in_use: Option<bool>,
    #[doc = "Specifies whether audit events are sent to Azure Monitor. \r\nIn order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.\r\n\r\nWhen using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.\r\nNote that for server level audit you should use the 'master' database as {databaseName}.\r\n\r\nDiagnostic Settings URI format:\r\nPUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview\r\n\r\nFor more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)\r\nor [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)\r\n"]
    #[serde(rename = "isAzureMonitorTargetEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_azure_monitor_target_enabled: Option<bool>,
    #[doc = "Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.\r\nThe default minimum value is 1000 (1 second). The maximum is 2,147,483,647."]
    #[serde(rename = "queueDelayMs", default, skip_serializing_if = "Option::is_none")]
    pub queue_delay_ms: Option<i32>,
}
impl ExtendedDatabaseBlobAuditingPolicyProperties {
    pub fn new(state: extended_database_blob_auditing_policy_properties::State) -> Self {
        Self {
            predicate_expression: None,
            state,
            storage_endpoint: None,
            storage_account_access_key: None,
            retention_days: None,
            audit_actions_and_groups: Vec::new(),
            storage_account_subscription_id: None,
            is_storage_secondary_key_in_use: None,
            is_azure_monitor_target_enabled: None,
            queue_delay_ms: None,
        }
    }
}
pub mod extended_database_blob_auditing_policy_properties {
    use super::*;
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
}
#[doc = "An extended server blob auditing policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedServerBlobAuditingPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of an extended server blob auditing policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExtendedServerBlobAuditingPolicyProperties>,
}
impl ExtendedServerBlobAuditingPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of server extended auditing settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedServerBlobAuditingPolicyListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExtendedServerBlobAuditingPolicy>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExtendedServerBlobAuditingPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an extended server blob auditing policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExtendedServerBlobAuditingPolicyProperties {
    #[doc = "Specifies condition of where clause when creating an audit."]
    #[serde(rename = "predicateExpression", default, skip_serializing_if = "Option::is_none")]
    pub predicate_expression: Option<String>,
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required."]
    pub state: extended_server_blob_auditing_policy_properties::State,
    #[doc = "Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required."]
    #[serde(rename = "storageEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub storage_endpoint: Option<String>,
    #[doc = "Specifies the identifier key of the auditing storage account. \r\nIf state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.\r\nPrerequisites for using managed identity authentication:\r\n1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).\r\n2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.\r\nFor more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)"]
    #[serde(rename = "storageAccountAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_access_key: Option<String>,
    #[doc = "Specifies the number of days to keep in the audit logs in the storage account."]
    #[serde(rename = "retentionDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i32>,
    #[doc = "Specifies the Actions-Groups and Actions to audit.\r\n\r\nThe recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:\r\n\r\nBATCH_COMPLETED_GROUP,\r\nSUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,\r\nFAILED_DATABASE_AUTHENTICATION_GROUP.\r\n\r\nThis above combination is also the set that is configured by default when enabling auditing from the Azure portal.\r\n\r\nThe supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):\r\n\r\nAPPLICATION_ROLE_CHANGE_PASSWORD_GROUP\r\nBACKUP_RESTORE_GROUP\r\nDATABASE_LOGOUT_GROUP\r\nDATABASE_OBJECT_CHANGE_GROUP\r\nDATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP\r\nDATABASE_OBJECT_PERMISSION_CHANGE_GROUP\r\nDATABASE_OPERATION_GROUP\r\nDATABASE_PERMISSION_CHANGE_GROUP\r\nDATABASE_PRINCIPAL_CHANGE_GROUP\r\nDATABASE_PRINCIPAL_IMPERSONATION_GROUP\r\nDATABASE_ROLE_MEMBER_CHANGE_GROUP\r\nFAILED_DATABASE_AUTHENTICATION_GROUP\r\nSCHEMA_OBJECT_ACCESS_GROUP\r\nSCHEMA_OBJECT_CHANGE_GROUP\r\nSCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP\r\nSCHEMA_OBJECT_PERMISSION_CHANGE_GROUP\r\nSUCCESSFUL_DATABASE_AUTHENTICATION_GROUP\r\nUSER_CHANGE_PASSWORD_GROUP\r\nBATCH_STARTED_GROUP\r\nBATCH_COMPLETED_GROUP\r\nDBCC_GROUP\r\nDATABASE_OWNERSHIP_CHANGE_GROUP\r\nDATABASE_CHANGE_GROUP\r\n\r\nThese are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.\r\n\r\nFor more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).\r\n\r\nFor Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:\r\nSELECT\r\nUPDATE\r\nINSERT\r\nDELETE\r\nEXECUTE\r\nRECEIVE\r\nREFERENCES\r\n\r\nThe general form for defining an action to be audited is:\r\n{action} ON {object} BY {principal}\r\n\r\nNote that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.\r\n\r\nFor example:\r\nSELECT on dbo.myTable by public\r\nSELECT on DATABASE::myDatabase by public\r\nSELECT on SCHEMA::mySchema by public\r\n\r\nFor more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)"]
    #[serde(rename = "auditActionsAndGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub audit_actions_and_groups: Vec<String>,
    #[doc = "Specifies the blob storage subscription Id."]
    #[serde(rename = "storageAccountSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_subscription_id: Option<String>,
    #[doc = "Specifies whether storageAccountAccessKey value is the storage's secondary key."]
    #[serde(rename = "isStorageSecondaryKeyInUse", default, skip_serializing_if = "Option::is_none")]
    pub is_storage_secondary_key_in_use: Option<bool>,
    #[doc = "Specifies whether audit events are sent to Azure Monitor. \r\nIn order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.\r\n\r\nWhen using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.\r\nNote that for server level audit you should use the 'master' database as {databaseName}.\r\n\r\nDiagnostic Settings URI format:\r\nPUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview\r\n\r\nFor more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)\r\nor [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)\r\n"]
    #[serde(rename = "isAzureMonitorTargetEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_azure_monitor_target_enabled: Option<bool>,
    #[doc = "Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.\r\nThe default minimum value is 1000 (1 second). The maximum is 2,147,483,647."]
    #[serde(rename = "queueDelayMs", default, skip_serializing_if = "Option::is_none")]
    pub queue_delay_ms: Option<i32>,
}
impl ExtendedServerBlobAuditingPolicyProperties {
    pub fn new(state: extended_server_blob_auditing_policy_properties::State) -> Self {
        Self {
            predicate_expression: None,
            state,
            storage_endpoint: None,
            storage_account_access_key: None,
            retention_days: None,
            audit_actions_and_groups: Vec::new(),
            storage_account_subscription_id: None,
            is_storage_secondary_key_in_use: None,
            is_azure_monitor_target_enabled: None,
            queue_delay_ms: None,
        }
    }
}
pub mod extended_server_blob_auditing_policy_properties {
    use super::*;
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
}
#[doc = "A failover group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverGroup {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Properties of a failover group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FailoverGroupProperties>,
}
impl FailoverGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of failover groups."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverGroupListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FailoverGroup>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FailoverGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a failover group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FailoverGroupProperties {
    #[doc = "Read-write endpoint of the failover group instance."]
    #[serde(rename = "readWriteEndpoint")]
    pub read_write_endpoint: FailoverGroupReadWriteEndpoint,
    #[doc = "Read-only endpoint of the failover group instance."]
    #[serde(rename = "readOnlyEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub read_only_endpoint: Option<FailoverGroupReadOnlyEndpoint>,
    #[doc = "Local replication role of the failover group instance."]
    #[serde(rename = "replicationRole", default, skip_serializing_if = "Option::is_none")]
    pub replication_role: Option<failover_group_properties::ReplicationRole>,
    #[doc = "Replication state of the failover group instance."]
    #[serde(rename = "replicationState", default, skip_serializing_if = "Option::is_none")]
    pub replication_state: Option<String>,
    #[doc = "List of partner server information for the failover group."]
    #[serde(rename = "partnerServers")]
    pub partner_servers: Vec<PartnerInfo>,
    #[doc = "List of databases in the failover group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub databases: Vec<String>,
}
impl FailoverGroupProperties {
    pub fn new(read_write_endpoint: FailoverGroupReadWriteEndpoint, partner_servers: Vec<PartnerInfo>) -> Self {
        Self {
            read_write_endpoint,
            read_only_endpoint: None,
            replication_role: None,
            replication_state: None,
            partner_servers,
            databases: Vec::new(),
        }
    }
}
pub mod failover_group_properties {
    use super::*;
    #[doc = "Local replication role of the failover group instance."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReplicationRole {
        Primary,
        Secondary,
    }
}
#[doc = "Read-only endpoint of the failover group instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverGroupReadOnlyEndpoint {
    #[doc = "Failover policy of the read-only endpoint for the failover group."]
    #[serde(rename = "failoverPolicy", default, skip_serializing_if = "Option::is_none")]
    pub failover_policy: Option<failover_group_read_only_endpoint::FailoverPolicy>,
}
impl FailoverGroupReadOnlyEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod failover_group_read_only_endpoint {
    use super::*;
    #[doc = "Failover policy of the read-only endpoint for the failover group."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverPolicy {
        Disabled,
        Enabled,
    }
}
#[doc = "Read-write endpoint of the failover group instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FailoverGroupReadWriteEndpoint {
    #[doc = "Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required."]
    #[serde(rename = "failoverPolicy")]
    pub failover_policy: failover_group_read_write_endpoint::FailoverPolicy,
    #[doc = "Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required."]
    #[serde(
        rename = "failoverWithDataLossGracePeriodMinutes",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub failover_with_data_loss_grace_period_minutes: Option<i32>,
}
impl FailoverGroupReadWriteEndpoint {
    pub fn new(failover_policy: failover_group_read_write_endpoint::FailoverPolicy) -> Self {
        Self {
            failover_policy,
            failover_with_data_loss_grace_period_minutes: None,
        }
    }
}
pub mod failover_group_read_write_endpoint {
    use super::*;
    #[doc = "Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverPolicy {
        Manual,
        Automatic,
    }
}
#[doc = "A failover group update request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverGroupUpdate {
    #[doc = "Properties of a failover group update."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FailoverGroupUpdateProperties>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl FailoverGroupUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a failover group update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverGroupUpdateProperties {
    #[doc = "Read-write endpoint of the failover group instance."]
    #[serde(rename = "readWriteEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub read_write_endpoint: Option<FailoverGroupReadWriteEndpoint>,
    #[doc = "Read-only endpoint of the failover group instance."]
    #[serde(rename = "readOnlyEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub read_only_endpoint: Option<FailoverGroupReadOnlyEndpoint>,
    #[doc = "List of databases in the failover group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub databases: Vec<String>,
}
impl FailoverGroupUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a server firewall rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Kind of server that contains this firewall rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Location of the server that contains this firewall rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Type of resource this is."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Represents the properties of a server firewall rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FirewallRuleProperties>,
}
impl FirewallRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the response to a List Firewall Rules request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallRuleListResult {
    #[doc = "The list of server firewall rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FirewallRule>,
}
impl FirewallRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the properties of a server firewall rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallRuleProperties {
    #[doc = "The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' to represent all Azure-internal IP addresses."]
    #[serde(rename = "startIpAddress")]
    pub start_ip_address: String,
    #[doc = "The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' to represent all Azure-internal IP addresses."]
    #[serde(rename = "endIpAddress")]
    pub end_ip_address: String,
}
impl FirewallRuleProperties {
    pub fn new(start_ip_address: String, end_ip_address: String) -> Self {
        Self {
            start_ip_address,
            end_ip_address,
        }
    }
}
#[doc = "A database geo backup policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GeoBackupPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of the geo backup policy."]
    pub properties: GeoBackupPolicyProperties,
    #[doc = "Kind of geo backup policy.  This is metadata used for the Azure portal experience."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Backup policy location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl GeoBackupPolicy {
    pub fn new(properties: GeoBackupPolicyProperties) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            properties,
            kind: None,
            location: None,
        }
    }
}
#[doc = "The response to a list geo backup policies request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GeoBackupPolicyListResult {
    #[doc = "The list of geo backup policies."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GeoBackupPolicy>,
}
impl GeoBackupPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of the geo backup policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GeoBackupPolicyProperties {
    #[doc = "The state of the geo backup policy."]
    pub state: geo_backup_policy_properties::State,
    #[doc = "The storage type of the geo backup policy."]
    #[serde(rename = "storageType", default, skip_serializing_if = "Option::is_none")]
    pub storage_type: Option<String>,
}
impl GeoBackupPolicyProperties {
    pub fn new(state: geo_backup_policy_properties::State) -> Self {
        Self { state, storage_type: None }
    }
}
pub mod geo_backup_policy_properties {
    use super::*;
    #[doc = "The state of the geo backup policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
        Enabled,
    }
}
#[doc = "Response for Import/Export Get operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportExportResponse {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Response for Import/Export Status operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ImportExportResponseProperties>,
}
impl ImportExportResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for Import/Export Status operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportExportResponseProperties {
    #[doc = "The request type of the operation."]
    #[serde(rename = "requestType", default, skip_serializing_if = "Option::is_none")]
    pub request_type: Option<String>,
    #[doc = "The request type of the operation."]
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[doc = "The name of the server."]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "The name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "The status message returned from the server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The operation status last modified time."]
    #[serde(rename = "lastModifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<String>,
    #[doc = "The operation queued time."]
    #[serde(rename = "queuedTime", default, skip_serializing_if = "Option::is_none")]
    pub queued_time: Option<String>,
    #[doc = "The blob uri."]
    #[serde(rename = "blobUri", default, skip_serializing_if = "Option::is_none")]
    pub blob_uri: Option<String>,
    #[doc = "The error message returned from the server."]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}
impl ImportExportResponseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the properties for an import operation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportExtensionProperties {
    #[serde(flatten)]
    pub export_request: ExportRequest,
    #[doc = "The type of import operation being performed. This is always Import."]
    #[serde(rename = "operationMode")]
    pub operation_mode: import_extension_properties::OperationMode,
}
impl ImportExtensionProperties {
    pub fn new(export_request: ExportRequest, operation_mode: import_extension_properties::OperationMode) -> Self {
        Self {
            export_request,
            operation_mode,
        }
    }
}
pub mod import_extension_properties {
    use super::*;
    #[doc = "The type of import operation being performed. This is always Import."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationMode {
        Import,
    }
}
#[doc = "Import database parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportExtensionRequest {
    #[doc = "The name of the extension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the extension."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Represents the properties for an import operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ImportExtensionProperties>,
}
impl ImportExtensionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Import database parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportRequest {
    #[serde(flatten)]
    pub export_request: ExportRequest,
    #[doc = "The name of the database to import."]
    #[serde(rename = "databaseName")]
    pub database_name: String,
    #[doc = "The edition for the database being created.\r\n\r\nThe list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:\r\n\r\n```azurecli\r\naz sql db list-editions -l <location> -o table\r\n````\r\n\r\n```powershell\r\nGet-AzSqlServerServiceObjective -Location <location>\r\n````\r\n"]
    pub edition: import_request::Edition,
    #[doc = "The name of the service objective to assign to the database."]
    #[serde(rename = "serviceObjectiveName")]
    pub service_objective_name: import_request::ServiceObjectiveName,
    #[doc = "The maximum size for the newly imported database."]
    #[serde(rename = "maxSizeBytes")]
    pub max_size_bytes: String,
}
impl ImportRequest {
    pub fn new(
        export_request: ExportRequest,
        database_name: String,
        edition: import_request::Edition,
        service_objective_name: import_request::ServiceObjectiveName,
        max_size_bytes: String,
    ) -> Self {
        Self {
            export_request,
            database_name,
            edition,
            service_objective_name,
            max_size_bytes,
        }
    }
}
pub mod import_request {
    use super::*;
    #[doc = "The edition for the database being created.\r\n\r\nThe list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:\r\n\r\n```azurecli\r\naz sql db list-editions -l <location> -o table\r\n````\r\n\r\n```powershell\r\nGet-AzSqlServerServiceObjective -Location <location>\r\n````\r\n"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Edition {
        Web,
        Business,
        Basic,
        Standard,
        Premium,
        #[serde(rename = "PremiumRS")]
        PremiumRs,
        Free,
        Stretch,
        DataWarehouse,
        System,
        System2,
        GeneralPurpose,
        BusinessCritical,
        Hyperscale,
    }
    #[doc = "The name of the service objective to assign to the database."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceObjectiveName {
        System,
        System0,
        System1,
        System2,
        System3,
        System4,
        System2L,
        System3L,
        System4L,
        Free,
        Basic,
        S0,
        S1,
        S2,
        S3,
        S4,
        S6,
        S7,
        S9,
        S12,
        P1,
        P2,
        P3,
        P4,
        P6,
        P11,
        P15,
        #[serde(rename = "PRS1")]
        Prs1,
        #[serde(rename = "PRS2")]
        Prs2,
        #[serde(rename = "PRS4")]
        Prs4,
        #[serde(rename = "PRS6")]
        Prs6,
        #[serde(rename = "DW100")]
        Dw100,
        #[serde(rename = "DW200")]
        Dw200,
        #[serde(rename = "DW300")]
        Dw300,
        #[serde(rename = "DW400")]
        Dw400,
        #[serde(rename = "DW500")]
        Dw500,
        #[serde(rename = "DW600")]
        Dw600,
        #[serde(rename = "DW1000")]
        Dw1000,
        #[serde(rename = "DW1200")]
        Dw1200,
        #[serde(rename = "DW1000c")]
        Dw1000c,
        #[serde(rename = "DW1500")]
        Dw1500,
        #[serde(rename = "DW1500c")]
        Dw1500c,
        #[serde(rename = "DW2000")]
        Dw2000,
        #[serde(rename = "DW2000c")]
        Dw2000c,
        #[serde(rename = "DW3000")]
        Dw3000,
        #[serde(rename = "DW2500c")]
        Dw2500c,
        #[serde(rename = "DW3000c")]
        Dw3000c,
        #[serde(rename = "DW6000")]
        Dw6000,
        #[serde(rename = "DW5000c")]
        Dw5000c,
        #[serde(rename = "DW6000c")]
        Dw6000c,
        #[serde(rename = "DW7500c")]
        Dw7500c,
        #[serde(rename = "DW10000c")]
        Dw10000c,
        #[serde(rename = "DW15000c")]
        Dw15000c,
        #[serde(rename = "DW30000c")]
        Dw30000c,
        #[serde(rename = "DS100")]
        Ds100,
        #[serde(rename = "DS200")]
        Ds200,
        #[serde(rename = "DS300")]
        Ds300,
        #[serde(rename = "DS400")]
        Ds400,
        #[serde(rename = "DS500")]
        Ds500,
        #[serde(rename = "DS600")]
        Ds600,
        #[serde(rename = "DS1000")]
        Ds1000,
        #[serde(rename = "DS1200")]
        Ds1200,
        #[serde(rename = "DS1500")]
        Ds1500,
        #[serde(rename = "DS2000")]
        Ds2000,
        ElasticPool,
    }
}
#[doc = "A job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Job {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a job."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobProperties>,
}
impl Job {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure SQL job agent."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobAgent {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "An ARM Resource SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Properties of a job agent."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobAgentProperties>,
}
impl JobAgent {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            sku: None,
            properties: None,
        }
    }
}
#[doc = "A list of Azure SQL job agents."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobAgentListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobAgent>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobAgentListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a job agent."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobAgentProperties {
    #[doc = "Resource ID of the database to store job metadata in."]
    #[serde(rename = "databaseId")]
    pub database_id: String,
    #[doc = "The state of the job agent."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<job_agent_properties::State>,
}
impl JobAgentProperties {
    pub fn new(database_id: String) -> Self {
        Self { database_id, state: None }
    }
}
pub mod job_agent_properties {
    use super::*;
    #[doc = "The state of the job agent."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Creating,
        Ready,
        Updating,
        Deleting,
        Disabled,
    }
}
#[doc = "An update to an Azure SQL job agent."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobAgentUpdate {
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl JobAgentUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A stored credential that can be used by a job to connect to target databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobCredential {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a job credential."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobCredentialProperties>,
}
impl JobCredential {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of job credentials."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobCredentialListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobCredential>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobCredentialListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a job credential."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobCredentialProperties {
    #[doc = "The credential user name."]
    pub username: String,
    #[doc = "The credential password."]
    pub password: String,
}
impl JobCredentialProperties {
    pub fn new(username: String, password: String) -> Self {
        Self { username, password }
    }
}
#[doc = "An execution of a job"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobExecution {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties for an Azure SQL Database Elastic job execution."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobExecutionProperties>,
}
impl JobExecution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of job executions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobExecutionListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobExecution>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobExecutionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties for an Azure SQL Database Elastic job execution."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobExecutionProperties {
    #[doc = "The job version number."]
    #[serde(rename = "jobVersion", default, skip_serializing_if = "Option::is_none")]
    pub job_version: Option<i32>,
    #[doc = "The job step name."]
    #[serde(rename = "stepName", default, skip_serializing_if = "Option::is_none")]
    pub step_name: Option<String>,
    #[doc = "The job step id."]
    #[serde(rename = "stepId", default, skip_serializing_if = "Option::is_none")]
    pub step_id: Option<i32>,
    #[doc = "The unique identifier of the job execution."]
    #[serde(rename = "jobExecutionId", default, skip_serializing_if = "Option::is_none")]
    pub job_execution_id: Option<String>,
    #[doc = "The detailed state of the job execution."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub lifecycle: Option<job_execution_properties::Lifecycle>,
    #[doc = "The ARM provisioning state of the job execution."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<job_execution_properties::ProvisioningState>,
    #[doc = "The time that the job execution was created."]
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[doc = "The time that the job execution started."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The time that the job execution completed."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "Number of times the job execution has been attempted."]
    #[serde(rename = "currentAttempts", default, skip_serializing_if = "Option::is_none")]
    pub current_attempts: Option<i32>,
    #[doc = "Start time of the current attempt."]
    #[serde(rename = "currentAttemptStartTime", default, skip_serializing_if = "Option::is_none")]
    pub current_attempt_start_time: Option<String>,
    #[doc = "The last status or error message."]
    #[serde(rename = "lastMessage", default, skip_serializing_if = "Option::is_none")]
    pub last_message: Option<String>,
    #[doc = "The target that a job execution is executed on."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<JobExecutionTarget>,
}
impl JobExecutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_execution_properties {
    use super::*;
    #[doc = "The detailed state of the job execution."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Lifecycle {
        Created,
        InProgress,
        WaitingForChildJobExecutions,
        WaitingForRetry,
        Succeeded,
        SucceededWithSkipped,
        Failed,
        TimedOut,
        Canceled,
        Skipped,
    }
    #[doc = "The ARM provisioning state of the job execution."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Created,
        InProgress,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "The target that a job execution is executed on."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobExecutionTarget {
    #[doc = "The type of the target."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<job_execution_target::Type>,
    #[doc = "The server name."]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "The database name."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
}
impl JobExecutionTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_execution_target {
    use super::*;
    #[doc = "The type of the target."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        TargetGroup,
        SqlDatabase,
        SqlElasticPool,
        SqlShardMap,
        SqlServer,
    }
}
#[doc = "A list of jobs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Job>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobProperties {
    #[doc = "User-defined description of the job."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The job version number."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i32>,
    #[doc = "Scheduling properties of a job."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<JobSchedule>,
}
impl JobProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Scheduling properties of a job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobSchedule {
    #[doc = "Schedule start time."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "Schedule end time."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "Schedule interval type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<job_schedule::Type>,
    #[doc = "Whether or not the schedule is enabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[doc = "Value of the schedule's recurring interval, if the schedule type is recurring. ISO8601 duration format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<String>,
}
impl JobSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_schedule {
    use super::*;
    #[doc = "Schedule interval type"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Once,
        Recurring,
    }
    impl Default for Type {
        fn default() -> Self {
            Self::Once
        }
    }
}
#[doc = "A job step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobStep {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a job step."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobStepProperties>,
}
impl JobStep {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The action to be executed by a job step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobStepAction {
    #[doc = "Type of action being executed by the job step."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<job_step_action::Type>,
    #[doc = "The source of the action to execute."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<job_step_action::Source>,
    #[doc = "The action value, for example the text of the T-SQL script to execute."]
    pub value: String,
}
impl JobStepAction {
    pub fn new(value: String) -> Self {
        Self {
            type_: None,
            source: None,
            value,
        }
    }
}
pub mod job_step_action {
    use super::*;
    #[doc = "Type of action being executed by the job step."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        TSql,
    }
    impl Default for Type {
        fn default() -> Self {
            Self::TSql
        }
    }
    #[doc = "The source of the action to execute."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        Inline,
    }
    impl Default for Source {
        fn default() -> Self {
            Self::Inline
        }
    }
}
#[doc = "The execution options of a job step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobStepExecutionOptions {
    #[doc = "Execution timeout for the job step."]
    #[serde(rename = "timeoutSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_seconds: Option<i32>,
    #[doc = "Maximum number of times the job step will be reattempted if the first attempt fails."]
    #[serde(rename = "retryAttempts", default, skip_serializing_if = "Option::is_none")]
    pub retry_attempts: Option<i32>,
    #[doc = "Initial delay between retries for job step execution."]
    #[serde(rename = "initialRetryIntervalSeconds", default, skip_serializing_if = "Option::is_none")]
    pub initial_retry_interval_seconds: Option<i32>,
    #[doc = "The maximum amount of time to wait between retries for job step execution."]
    #[serde(rename = "maximumRetryIntervalSeconds", default, skip_serializing_if = "Option::is_none")]
    pub maximum_retry_interval_seconds: Option<i32>,
    #[doc = "The backoff multiplier for the time between retries."]
    #[serde(rename = "retryIntervalBackoffMultiplier", default, skip_serializing_if = "Option::is_none")]
    pub retry_interval_backoff_multiplier: Option<f32>,
}
impl JobStepExecutionOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of job steps."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobStepListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobStep>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobStepListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The output configuration of a job step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobStepOutput {
    #[doc = "The output destination type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<job_step_output::Type>,
    #[doc = "The output destination subscription id."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "The output destination resource group."]
    #[serde(rename = "resourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub resource_group_name: Option<String>,
    #[doc = "The output destination server name."]
    #[serde(rename = "serverName")]
    pub server_name: String,
    #[doc = "The output destination database."]
    #[serde(rename = "databaseName")]
    pub database_name: String,
    #[doc = "The output destination schema."]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[doc = "The output destination table."]
    #[serde(rename = "tableName")]
    pub table_name: String,
    #[doc = "The resource ID of the credential to use to connect to the output destination."]
    pub credential: String,
}
impl JobStepOutput {
    pub fn new(server_name: String, database_name: String, table_name: String, credential: String) -> Self {
        Self {
            type_: None,
            subscription_id: None,
            resource_group_name: None,
            server_name,
            database_name,
            schema_name: None,
            table_name,
            credential,
        }
    }
}
pub mod job_step_output {
    use super::*;
    #[doc = "The output destination type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SqlDatabase,
    }
    impl Default for Type {
        fn default() -> Self {
            Self::SqlDatabase
        }
    }
}
#[doc = "Properties of a job step."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobStepProperties {
    #[doc = "The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified."]
    #[serde(rename = "stepId", default, skip_serializing_if = "Option::is_none")]
    pub step_id: Option<i32>,
    #[doc = "The resource ID of the target group that the job step will be executed on."]
    #[serde(rename = "targetGroup")]
    pub target_group: String,
    #[doc = "The resource ID of the job credential that will be used to connect to the targets."]
    pub credential: String,
    #[doc = "The action to be executed by a job step."]
    pub action: JobStepAction,
    #[doc = "The output configuration of a job step."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<JobStepOutput>,
    #[doc = "The execution options of a job step."]
    #[serde(rename = "executionOptions", default, skip_serializing_if = "Option::is_none")]
    pub execution_options: Option<JobStepExecutionOptions>,
}
impl JobStepProperties {
    pub fn new(target_group: String, credential: String, action: JobStepAction) -> Self {
        Self {
            step_id: None,
            target_group,
            credential,
            action,
            output: None,
            execution_options: None,
        }
    }
}
#[doc = "A job target, for example a specific database or a container of databases that is evaluated during job execution."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobTarget {
    #[doc = "Whether the target is included or excluded from the group."]
    #[serde(rename = "membershipType", default, skip_serializing_if = "Option::is_none")]
    pub membership_type: Option<job_target::MembershipType>,
    #[doc = "The target type."]
    #[serde(rename = "type")]
    pub type_: job_target::Type,
    #[doc = "The target server name."]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "The target database name."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "The target elastic pool name."]
    #[serde(rename = "elasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub elastic_pool_name: Option<String>,
    #[doc = "The target shard map."]
    #[serde(rename = "shardMapName", default, skip_serializing_if = "Option::is_none")]
    pub shard_map_name: Option<String>,
    #[doc = "The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target."]
    #[serde(rename = "refreshCredential", default, skip_serializing_if = "Option::is_none")]
    pub refresh_credential: Option<String>,
}
impl JobTarget {
    pub fn new(type_: job_target::Type) -> Self {
        Self {
            membership_type: None,
            type_,
            server_name: None,
            database_name: None,
            elastic_pool_name: None,
            shard_map_name: None,
            refresh_credential: None,
        }
    }
}
pub mod job_target {
    use super::*;
    #[doc = "Whether the target is included or excluded from the group."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MembershipType {
        Include,
        Exclude,
    }
    impl Default for MembershipType {
        fn default() -> Self {
            Self::Include
        }
    }
    #[doc = "The target type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        TargetGroup,
        SqlDatabase,
        SqlElasticPool,
        SqlShardMap,
        SqlServer,
    }
}
#[doc = "A group of job targets."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobTargetGroup {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of job target group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobTargetGroupProperties>,
}
impl JobTargetGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of target groups."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobTargetGroupListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobTargetGroup>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobTargetGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of job target group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobTargetGroupProperties {
    #[doc = "Members of the target group."]
    pub members: Vec<JobTarget>,
}
impl JobTargetGroupProperties {
    pub fn new(members: Vec<JobTarget>) -> Self {
        Self { members }
    }
}
#[doc = "A job version."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobVersion {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
}
impl JobVersion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of job versions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobVersionListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobVersion>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobVersionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The capabilities for a location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocationCapabilities {
    #[doc = "The location name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The availability status of the capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<CapabilityStatus>,
    #[doc = "The list of supported server versions."]
    #[serde(rename = "supportedServerVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_server_versions: Vec<ServerVersionCapability>,
}
impl LocationCapabilities {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of the server's security alert policies."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogicalServerSecurityAlertPolicyListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServerSecurityAlertPolicy>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LogicalServerSecurityAlertPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A short term retention policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedBackupShortTermRetentionPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a short term retention policy"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagedBackupShortTermRetentionPolicyProperties>,
}
impl ManagedBackupShortTermRetentionPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of short term retention policies."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedBackupShortTermRetentionPolicyListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ManagedBackupShortTermRetentionPolicy>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagedBackupShortTermRetentionPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a short term retention policy"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedBackupShortTermRetentionPolicyProperties {
    #[doc = "The backup retention period in days. This is how many days Point-in-Time Restore will be supported."]
    #[serde(rename = "retentionDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i32>,
}
impl ManagedBackupShortTermRetentionPolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A managed database resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedDatabase {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "The managed database's properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagedDatabaseProperties>,
}
impl ManagedDatabase {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
        }
    }
}
#[doc = "A list of managed databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedDatabaseListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ManagedDatabase>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagedDatabaseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The managed database's properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedDatabaseProperties {
    #[doc = "Collation of the managed database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub collation: Option<String>,
    #[doc = "Status of the database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<managed_database_properties::Status>,
    #[doc = "Creation date of the database."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "Earliest restore point in time for point in time restore."]
    #[serde(rename = "earliestRestorePoint", default, skip_serializing_if = "Option::is_none")]
    pub earliest_restore_point: Option<String>,
    #[doc = "Conditional. If createMode is PointInTimeRestore, this value is required. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database."]
    #[serde(rename = "restorePointInTime", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_in_time: Option<String>,
    #[doc = "Geo paired region."]
    #[serde(rename = "defaultSecondaryLocation", default, skip_serializing_if = "Option::is_none")]
    pub default_secondary_location: Option<String>,
    #[doc = "Collation of the metadata catalog."]
    #[serde(rename = "catalogCollation", default, skip_serializing_if = "Option::is_none")]
    pub catalog_collation: Option<managed_database_properties::CatalogCollation>,
    #[doc = "Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore."]
    #[serde(rename = "createMode", default, skip_serializing_if = "Option::is_none")]
    pub create_mode: Option<managed_database_properties::CreateMode>,
    #[doc = "Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the uri of the storage container where backups for this restore are stored."]
    #[serde(rename = "storageContainerUri", default, skip_serializing_if = "Option::is_none")]
    pub storage_container_uri: Option<String>,
    #[doc = "The resource identifier of the source database associated with create operation of this database."]
    #[serde(rename = "sourceDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub source_database_id: Option<String>,
    #[doc = "The restorable dropped database resource id to restore when creating this database."]
    #[serde(rename = "restorableDroppedDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub restorable_dropped_database_id: Option<String>,
    #[doc = "Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the storage container sas token."]
    #[serde(rename = "storageContainerSasToken", default, skip_serializing_if = "Option::is_none")]
    pub storage_container_sas_token: Option<String>,
    #[doc = "Instance Failover Group resource identifier that this managed database belongs to."]
    #[serde(rename = "failoverGroupId", default, skip_serializing_if = "Option::is_none")]
    pub failover_group_id: Option<String>,
    #[doc = "The resource identifier of the recoverable database associated with create operation of this database."]
    #[serde(rename = "recoverableDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub recoverable_database_id: Option<String>,
    #[doc = "The name of the Long Term Retention backup to be used for restore of this managed database."]
    #[serde(rename = "longTermRetentionBackupResourceId", default, skip_serializing_if = "Option::is_none")]
    pub long_term_retention_backup_resource_id: Option<String>,
}
impl ManagedDatabaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_database_properties {
    use super::*;
    #[doc = "Status of the database."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Online,
        Offline,
        Shutdown,
        Creating,
        Inaccessible,
        Restoring,
        Updating,
    }
    #[doc = "Collation of the metadata catalog."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CatalogCollation {
        #[serde(rename = "DATABASE_DEFAULT")]
        DatabaseDefault,
        #[serde(rename = "SQL_Latin1_General_CP1_CI_AS")]
        SqlLatin1GeneralCp1CiAs,
    }
    #[doc = "Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreateMode {
        Default,
        RestoreExternalBackup,
        PointInTimeRestore,
        Recovery,
        RestoreLongTermRetentionBackup,
    }
}
#[doc = "An managed database update."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedDatabaseUpdate {
    #[doc = "The managed database's properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagedDatabaseProperties>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ManagedDatabaseUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure SQL managed instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedInstance {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Azure Active Directory identity configuration for a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "An ARM Resource SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "The properties of a managed instance."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagedInstanceProperties>,
}
impl ManagedInstance {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            identity: None,
            sku: None,
            properties: None,
        }
    }
}
#[doc = "An Azure SQL managed instance administrator."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedInstanceAdministrator {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of a managed instance administrator."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagedInstanceAdministratorProperties>,
}
impl ManagedInstanceAdministrator {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of managed instance administrators."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedInstanceAdministratorListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ManagedInstanceAdministrator>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagedInstanceAdministratorListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a managed instance administrator."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedInstanceAdministratorProperties {
    #[doc = "Type of the managed instance administrator."]
    #[serde(rename = "administratorType")]
    pub administrator_type: managed_instance_administrator_properties::AdministratorType,
    #[doc = "Login name of the managed instance administrator."]
    pub login: String,
    #[doc = "SID (object ID) of the managed instance administrator."]
    pub sid: String,
    #[doc = "Tenant ID of the managed instance administrator."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl ManagedInstanceAdministratorProperties {
    pub fn new(administrator_type: managed_instance_administrator_properties::AdministratorType, login: String, sid: String) -> Self {
        Self {
            administrator_type,
            login,
            sid,
            tenant_id: None,
        }
    }
}
pub mod managed_instance_administrator_properties {
    use super::*;
    #[doc = "Type of the managed instance administrator."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AdministratorType {
        ActiveDirectory,
    }
}
#[doc = "A list of managed instances."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedInstanceListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ManagedInstance>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagedInstanceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a managed instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedInstanceProperties {
    #[doc = "Specifies the mode of database creation.\r\n\r\nDefault: Regular instance creation.\r\n\r\nRestore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified."]
    #[serde(rename = "managedInstanceCreateMode", default, skip_serializing_if = "Option::is_none")]
    pub managed_instance_create_mode: Option<managed_instance_properties::ManagedInstanceCreateMode>,
    #[doc = "The fully qualified domain name of the managed instance."]
    #[serde(rename = "fullyQualifiedDomainName", default, skip_serializing_if = "Option::is_none")]
    pub fully_qualified_domain_name: Option<String>,
    #[doc = "Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation)."]
    #[serde(rename = "administratorLogin", default, skip_serializing_if = "Option::is_none")]
    pub administrator_login: Option<String>,
    #[doc = "The administrator login password (required for managed instance creation)."]
    #[serde(rename = "administratorLoginPassword", default, skip_serializing_if = "Option::is_none")]
    pub administrator_login_password: Option<String>,
    #[doc = "Subnet resource ID for the managed instance."]
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[doc = "The state of the managed instance."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses)."]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<managed_instance_properties::LicenseType>,
    #[doc = "The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80."]
    #[serde(rename = "vCores", default, skip_serializing_if = "Option::is_none")]
    pub v_cores: Option<i32>,
    #[doc = "Storage size in GB. Minimum value: 32. Maximum value: 8192. Increments of 32 GB allowed only."]
    #[serde(rename = "storageSizeInGB", default, skip_serializing_if = "Option::is_none")]
    pub storage_size_in_gb: Option<i32>,
    #[doc = "Collation of the managed instance."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub collation: Option<String>,
    #[doc = "The Dns Zone that the managed instance is in."]
    #[serde(rename = "dnsZone", default, skip_serializing_if = "Option::is_none")]
    pub dns_zone: Option<String>,
    #[doc = "The resource id of another managed instance whose DNS zone this managed instance will share after creation."]
    #[serde(rename = "dnsZonePartner", default, skip_serializing_if = "Option::is_none")]
    pub dns_zone_partner: Option<String>,
    #[doc = "Whether or not the public data endpoint is enabled."]
    #[serde(rename = "publicDataEndpointEnabled", default, skip_serializing_if = "Option::is_none")]
    pub public_data_endpoint_enabled: Option<bool>,
    #[doc = "The resource identifier of the source managed instance associated with create operation of this instance."]
    #[serde(rename = "sourceManagedInstanceId", default, skip_serializing_if = "Option::is_none")]
    pub source_managed_instance_id: Option<String>,
    #[doc = "Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database."]
    #[serde(rename = "restorePointInTime", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_in_time: Option<String>,
    #[doc = "Connection type used for connecting to the instance."]
    #[serde(rename = "proxyOverride", default, skip_serializing_if = "Option::is_none")]
    pub proxy_override: Option<managed_instance_properties::ProxyOverride>,
    #[doc = "Id of the timezone. Allowed values are timezones supported by Windows.\r\nWindows keeps details on supported timezones, including the id, in registry under\r\nKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones.\r\nYou can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.\r\nList of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.\r\nAn example of valid timezone id is \"Pacific Standard Time\" or \"W. Europe Standard Time\"."]
    #[serde(rename = "timezoneId", default, skip_serializing_if = "Option::is_none")]
    pub timezone_id: Option<String>,
    #[doc = "The Id of the instance pool this managed server belongs to."]
    #[serde(rename = "instancePoolId", default, skip_serializing_if = "Option::is_none")]
    pub instance_pool_id: Option<String>,
    #[doc = "Specifies maintenance configuration id to apply to this managed instance."]
    #[serde(rename = "maintenanceConfigurationId", default, skip_serializing_if = "Option::is_none")]
    pub maintenance_configuration_id: Option<String>,
    #[doc = "Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'"]
    #[serde(rename = "minimalTlsVersion", default, skip_serializing_if = "Option::is_none")]
    pub minimal_tls_version: Option<String>,
}
impl ManagedInstanceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_instance_properties {
    use super::*;
    #[doc = "Specifies the mode of database creation.\r\n\r\nDefault: Regular instance creation.\r\n\r\nRestore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ManagedInstanceCreateMode {
        Default,
        PointInTimeRestore,
    }
    #[doc = "The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        LicenseIncluded,
        BasePrice,
    }
    #[doc = "Connection type used for connecting to the instance."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProxyOverride {
        Proxy,
        Redirect,
        Default,
    }
}
#[doc = "An update request for an Azure SQL Database managed instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedInstanceUpdate {
    #[doc = "An ARM Resource SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "The properties of a managed instance."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagedInstanceProperties>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ManagedInstanceUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The maximum size limits for a database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MaxSizeCapability {
    #[doc = "The maximum size of the database (see 'unit' for the units)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[doc = "The units that the limit is expressed in."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<max_size_capability::Unit>,
    #[doc = "The availability status of the capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<CapabilityStatus>,
}
impl MaxSizeCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod max_size_capability {
    use super::*;
    #[doc = "The units that the limit is expressed in."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Megabytes,
        Gigabytes,
        Terabytes,
        Petabytes,
    }
}
#[doc = "Database metrics."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Metric {
    #[doc = "The start time for the metric (ISO-8601 format)."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time for the metric (ISO-8601 format)."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The time step to be used to summarize the metric values."]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[doc = "The unit of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<metric::Unit>,
    #[doc = "A database metric name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
    #[doc = "The metric values for the specified time window and timestep."]
    #[serde(rename = "metricValues", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_values: Vec<MetricValue>,
}
impl Metric {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod metric {
    use super::*;
    #[doc = "The unit of the metric."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        #[serde(rename = "count")]
        Count,
        #[serde(rename = "bytes")]
        Bytes,
        #[serde(rename = "seconds")]
        Seconds,
        #[serde(rename = "percent")]
        Percent,
        #[serde(rename = "countPerSecond")]
        CountPerSecond,
        #[serde(rename = "bytesPerSecond")]
        BytesPerSecond,
    }
}
#[doc = "A metric availability value."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricAvailability {
    #[doc = "The length of retention for the database metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
    #[doc = "The granularity of the database metric."]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
}
impl MetricAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A database metric definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricDefinition {
    #[doc = "A database metric name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<MetricName>,
    #[doc = "The primary aggregation type defining how metric values are displayed."]
    #[serde(rename = "primaryAggregationType", default, skip_serializing_if = "Option::is_none")]
    pub primary_aggregation_type: Option<metric_definition::PrimaryAggregationType>,
    #[doc = "The resource uri of the database."]
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[doc = "The unit of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<metric_definition::Unit>,
    #[doc = "The list of database metric availabilities for the metric."]
    #[serde(rename = "metricAvailabilities", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_availabilities: Vec<MetricAvailability>,
}
impl MetricDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod metric_definition {
    use super::*;
    #[doc = "The primary aggregation type defining how metric values are displayed."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrimaryAggregationType {
        None,
        Average,
        Count,
        Minimum,
        Maximum,
        Total,
    }
    #[doc = "The unit of the metric."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
        Bytes,
        Seconds,
        Percent,
        CountPerSecond,
        BytesPerSecond,
    }
}
#[doc = "The response to a list database metric definitions request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricDefinitionListResult {
    #[doc = "The list of metric definitions for the database."]
    pub value: Vec<MetricDefinition>,
}
impl MetricDefinitionListResult {
    pub fn new(value: Vec<MetricDefinition>) -> Self {
        Self { value }
    }
}
#[doc = "The response to a list database metrics request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetricListResult {
    #[doc = "The list of metrics for the database."]
    pub value: Vec<Metric>,
}
impl MetricListResult {
    pub fn new(value: Vec<Metric>) -> Self {
        Self { value }
    }
}
#[doc = "A database metric name."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricName {
    #[doc = "The name of the database metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "The friendly name of the database metric."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl MetricName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents database metrics."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricValue {
    #[doc = "The number of values for the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<f64>,
    #[doc = "The average value of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub average: Option<f64>,
    #[doc = "The max value of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<f64>,
    #[doc = "The min value of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub minimum: Option<f64>,
    #[doc = "The metric timestamp (ISO-8601 format)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[doc = "The total value of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub total: Option<f64>,
}
impl MetricValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SQL REST API operation definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "The name of the operation being performed on this particular object."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Display metadata associated with the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationDisplay>,
    #[doc = "The intended executor of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<operation::Origin>,
    #[doc = "Additional descriptions for the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "The intended executor of the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Origin {
        #[serde(rename = "user")]
        User,
        #[serde(rename = "system")]
        System,
    }
}
#[doc = "Display metadata associated with the operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDisplay {
    #[doc = "The localized friendly form of the resource provider name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "The localized friendly form of the resource type related to this action/operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[doc = "The localized friendly name for the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "The localized friendly description for the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The impact of an operation, both in absolute and relative terms."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationImpact {
    #[doc = "The name of the impact dimension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The unit in which estimated impact to dimension is measured."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[doc = "The absolute impact to dimension."]
    #[serde(rename = "changeValueAbsolute", default, skip_serializing_if = "Option::is_none")]
    pub change_value_absolute: Option<f64>,
    #[doc = "The relative impact to dimension (null if not applicable)"]
    #[serde(rename = "changeValueRelative", default, skip_serializing_if = "Option::is_none")]
    pub change_value_relative: Option<f64>,
}
impl OperationImpact {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list SQL operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Partner server information for the failover group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PartnerInfo {
    #[doc = "Resource identifier of the partner server."]
    pub id: String,
    #[doc = "Geo location of the partner server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Replication role of the partner server."]
    #[serde(rename = "replicationRole", default, skip_serializing_if = "Option::is_none")]
    pub replication_role: Option<partner_info::ReplicationRole>,
}
impl PartnerInfo {
    pub fn new(id: String) -> Self {
        Self {
            id,
            location: None,
            replication_role: None,
        }
    }
}
pub mod partner_info {
    use super::*;
    #[doc = "Replication role of the partner server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReplicationRole {
        Primary,
        Secondary,
    }
}
#[doc = "A possible performance level of a service objective capability."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerformanceLevel {
    #[doc = "Unit type used to measure service objective performance level."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<performance_level::Unit>,
    #[doc = "Performance level value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<i64>,
}
impl PerformanceLevel {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod performance_level {
    use super::*;
    #[doc = "Unit type used to measure service objective performance level."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        #[serde(rename = "DTU")]
        Dtu,
    }
}
#[doc = "ARM proxy resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a database recommended index."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendedIndex {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Represents the properties of a database recommended index."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecommendedIndexProperties>,
}
impl RecommendedIndex {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the properties of a database recommended index."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendedIndexProperties {
    #[doc = "The proposed index action. You can create a missing index, drop an unused index, or rebuild an existing index to improve its performance."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<recommended_index_properties::Action>,
    #[doc = "The current recommendation state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<recommended_index_properties::State>,
    #[doc = "The UTC datetime showing when this resource was created (ISO8601 format)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[doc = "The UTC datetime of when was this resource last changed (ISO8601 format)."]
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[doc = "The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE, CLUSTERED COLUMNSTORE)"]
    #[serde(rename = "indexType", default, skip_serializing_if = "Option::is_none")]
    pub index_type: Option<recommended_index_properties::IndexType>,
    #[doc = "The schema where table to build index over resides"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    #[doc = "The table on which to build index."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<String>,
    #[doc = "Columns over which to build index"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<String>,
    #[doc = "The list of column names to be included in the index"]
    #[serde(rename = "includedColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub included_columns: Vec<String>,
    #[doc = "The full build index script"]
    #[serde(rename = "indexScript", default, skip_serializing_if = "Option::is_none")]
    pub index_script: Option<String>,
    #[doc = "The estimated impact of doing recommended index action."]
    #[serde(rename = "estimatedImpact", default, skip_serializing_if = "Vec::is_empty")]
    pub estimated_impact: Vec<OperationImpact>,
    #[doc = "The values reported after index action is complete."]
    #[serde(rename = "reportedImpact", default, skip_serializing_if = "Vec::is_empty")]
    pub reported_impact: Vec<OperationImpact>,
}
impl RecommendedIndexProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recommended_index_properties {
    use super::*;
    #[doc = "The proposed index action. You can create a missing index, drop an unused index, or rebuild an existing index to improve its performance."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Create,
        Drop,
        Rebuild,
    }
    #[doc = "The current recommendation state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Active,
        Pending,
        Executing,
        Verifying,
        #[serde(rename = "Pending Revert")]
        PendingRevert,
        Reverting,
        Reverted,
        Ignored,
        Expired,
        Blocked,
        Success,
    }
    #[doc = "The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE, CLUSTERED COLUMNSTORE)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IndexType {
        #[serde(rename = "CLUSTERED")]
        Clustered,
        #[serde(rename = "NONCLUSTERED")]
        Nonclustered,
        #[serde(rename = "COLUMNSTORE")]
        Columnstore,
        #[serde(rename = "CLUSTERED COLUMNSTORE")]
        ClusteredColumnstore,
    }
}
#[doc = "A recoverable database"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoverableDatabase {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of a recoverable database"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecoverableDatabaseProperties>,
}
impl RecoverableDatabase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list recoverable databases request"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoverableDatabaseListResult {
    #[doc = "A list of recoverable databases"]
    pub value: Vec<RecoverableDatabase>,
}
impl RecoverableDatabaseListResult {
    pub fn new(value: Vec<RecoverableDatabase>) -> Self {
        Self { value }
    }
}
#[doc = "The properties of a recoverable database"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoverableDatabaseProperties {
    #[doc = "The edition of the database"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub edition: Option<String>,
    #[doc = "The service level objective name of the database"]
    #[serde(rename = "serviceLevelObjective", default, skip_serializing_if = "Option::is_none")]
    pub service_level_objective: Option<String>,
    #[doc = "The elastic pool name of the database"]
    #[serde(rename = "elasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub elastic_pool_name: Option<String>,
    #[doc = "The last available backup date of the database (ISO8601 format)"]
    #[serde(rename = "lastAvailableBackupDate", default, skip_serializing_if = "Option::is_none")]
    pub last_available_backup_date: Option<String>,
}
impl RecoverableDatabaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a database replication link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationLink {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Location of the server that contains this firewall rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Type of resource this is."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Represents the properties of a database replication link."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReplicationLinkProperties>,
}
impl ReplicationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the response to a List database replication link request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationLinkListResult {
    #[doc = "The list of database replication links housed in the database."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReplicationLink>,
}
impl ReplicationLinkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the properties of a database replication link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationLinkProperties {
    #[doc = "Legacy value indicating whether termination is allowed.  Currently always returns true."]
    #[serde(rename = "isTerminationAllowed", default, skip_serializing_if = "Option::is_none")]
    pub is_termination_allowed: Option<bool>,
    #[doc = "Replication mode of this replication link."]
    #[serde(rename = "replicationMode", default, skip_serializing_if = "Option::is_none")]
    pub replication_mode: Option<String>,
    #[doc = "The name of the server hosting the partner database."]
    #[serde(rename = "partnerServer", default, skip_serializing_if = "Option::is_none")]
    pub partner_server: Option<String>,
    #[doc = "The name of the partner database."]
    #[serde(rename = "partnerDatabase", default, skip_serializing_if = "Option::is_none")]
    pub partner_database: Option<String>,
    #[doc = "The Azure Region of the partner database."]
    #[serde(rename = "partnerLocation", default, skip_serializing_if = "Option::is_none")]
    pub partner_location: Option<String>,
    #[doc = "The role of the database in the replication link."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub role: Option<replication_link_properties::Role>,
    #[doc = "The role of the partner database in the replication link."]
    #[serde(rename = "partnerRole", default, skip_serializing_if = "Option::is_none")]
    pub partner_role: Option<replication_link_properties::PartnerRole>,
    #[doc = "The start time for the replication link."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The percentage of seeding complete for the replication link."]
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<i32>,
    #[doc = "The replication state for the replication link."]
    #[serde(rename = "replicationState", default, skip_serializing_if = "Option::is_none")]
    pub replication_state: Option<replication_link_properties::ReplicationState>,
}
impl ReplicationLinkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod replication_link_properties {
    use super::*;
    #[doc = "The role of the database in the replication link."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Role {
        Primary,
        Secondary,
        NonReadableSecondary,
        Source,
        Copy,
    }
    #[doc = "The role of the partner database in the replication link."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PartnerRole {
        Primary,
        Secondary,
        NonReadableSecondary,
        Source,
        Copy,
    }
    #[doc = "The replication state for the replication link."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReplicationState {
        #[serde(rename = "PENDING")]
        Pending,
        #[serde(rename = "SEEDING")]
        Seeding,
        #[serde(rename = "CATCH_UP")]
        CatchUp,
        #[serde(rename = "SUSPENDED")]
        Suspended,
    }
}
#[doc = "ARM resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Active Directory identity configuration for a resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceIdentity {
    #[doc = "The Azure Active Directory principal id."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<resource_identity::Type>,
    #[doc = "The Azure Active Directory tenant id."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl ResourceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_identity {
    use super::*;
    #[doc = "The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        None,
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned,UserAssigned")]
        SystemAssignedUserAssigned,
    }
}
#[doc = "Contains the information necessary to perform a resource move (rename)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceMoveDefinition {
    #[doc = "The target ID for the resource"]
    pub id: String,
}
impl ResourceMoveDefinition {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "A restorable dropped database"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestorableDroppedDatabase {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The geo-location where the resource lives"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "The properties of a restorable dropped database"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RestorableDroppedDatabaseProperties>,
}
impl RestorableDroppedDatabase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response to a list restorable dropped databases request"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestorableDroppedDatabaseListResult {
    #[doc = "A list of restorable dropped databases"]
    pub value: Vec<RestorableDroppedDatabase>,
}
impl RestorableDroppedDatabaseListResult {
    pub fn new(value: Vec<RestorableDroppedDatabase>) -> Self {
        Self { value }
    }
}
#[doc = "The properties of a restorable dropped database"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestorableDroppedDatabaseProperties {
    #[doc = "The name of the database"]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "The edition of the database"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub edition: Option<String>,
    #[doc = "The max size in bytes of the database"]
    #[serde(rename = "maxSizeBytes", default, skip_serializing_if = "Option::is_none")]
    pub max_size_bytes: Option<String>,
    #[doc = "The service level objective name of the database"]
    #[serde(rename = "serviceLevelObjective", default, skip_serializing_if = "Option::is_none")]
    pub service_level_objective: Option<String>,
    #[doc = "The elastic pool name of the database"]
    #[serde(rename = "elasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub elastic_pool_name: Option<String>,
    #[doc = "The creation date of the database (ISO8601 format)"]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "The deletion date of the database (ISO8601 format)"]
    #[serde(rename = "deletionDate", default, skip_serializing_if = "Option::is_none")]
    pub deletion_date: Option<String>,
    #[doc = "The earliest restore date of the database (ISO8601 format)"]
    #[serde(rename = "earliestRestoreDate", default, skip_serializing_if = "Option::is_none")]
    pub earliest_restore_date: Option<String>,
}
impl RestorableDroppedDatabaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A restorable dropped managed database resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestorableDroppedManagedDatabase {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "The restorable dropped managed database's properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RestorableDroppedManagedDatabaseProperties>,
}
impl RestorableDroppedManagedDatabase {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
        }
    }
}
#[doc = "A list of restorable dropped managed databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestorableDroppedManagedDatabaseListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RestorableDroppedManagedDatabase>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RestorableDroppedManagedDatabaseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The restorable dropped managed database's properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestorableDroppedManagedDatabaseProperties {
    #[doc = "The name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "The creation date of the database (ISO8601 format)."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "The deletion date of the database (ISO8601 format)."]
    #[serde(rename = "deletionDate", default, skip_serializing_if = "Option::is_none")]
    pub deletion_date: Option<String>,
    #[doc = "The earliest restore date of the database (ISO8601 format)."]
    #[serde(rename = "earliestRestoreDate", default, skip_serializing_if = "Option::is_none")]
    pub earliest_restore_date: Option<String>,
}
impl RestorableDroppedManagedDatabaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Database restore points."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestorePoint {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Properties of a database restore point"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RestorePointProperties>,
}
impl RestorePoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of long term retention backups."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestorePointListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RestorePoint>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RestorePointListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a database restore point"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestorePointProperties {
    #[doc = "The type of restore point"]
    #[serde(rename = "restorePointType", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_type: Option<restore_point_properties::RestorePointType>,
    #[doc = "The earliest time to which this database can be restored"]
    #[serde(rename = "earliestRestoreDate", default, skip_serializing_if = "Option::is_none")]
    pub earliest_restore_date: Option<String>,
    #[doc = "The time the backup was taken"]
    #[serde(rename = "restorePointCreationDate", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_creation_date: Option<String>,
    #[doc = "The label of restore point for backup request by user"]
    #[serde(rename = "restorePointLabel", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_label: Option<String>,
}
impl RestorePointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod restore_point_properties {
    use super::*;
    #[doc = "The type of restore point"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RestorePointType {
        #[serde(rename = "CONTINUOUS")]
        Continuous,
        #[serde(rename = "DISCRETE")]
        Discrete,
    }
}
#[doc = "Properties of a security alert policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAlertPolicyProperties {
    #[doc = "Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database."]
    pub state: security_alert_policy_properties::State,
    #[doc = "Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action"]
    #[serde(rename = "disabledAlerts", default, skip_serializing_if = "Vec::is_empty")]
    pub disabled_alerts: Vec<String>,
    #[doc = "Specifies an array of e-mail addresses to which the alert is sent."]
    #[serde(rename = "emailAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub email_addresses: Vec<String>,
    #[doc = "Specifies that the alert is sent to the account administrators."]
    #[serde(rename = "emailAccountAdmins", default, skip_serializing_if = "Option::is_none")]
    pub email_account_admins: Option<bool>,
    #[doc = "Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs."]
    #[serde(rename = "storageEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub storage_endpoint: Option<String>,
    #[doc = "Specifies the identifier key of the Threat Detection audit storage account."]
    #[serde(rename = "storageAccountAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_access_key: Option<String>,
    #[doc = "Specifies the number of days to keep in the Threat Detection audit logs."]
    #[serde(rename = "retentionDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i32>,
    #[doc = "Specifies the UTC creation time of the policy."]
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
}
impl SecurityAlertPolicyProperties {
    pub fn new(state: security_alert_policy_properties::State) -> Self {
        Self {
            state,
            disabled_alerts: Vec::new(),
            email_addresses: Vec::new(),
            email_account_admins: None,
            storage_endpoint: None,
            storage_account_access_key: None,
            retention_days: None,
            creation_time: None,
        }
    }
}
pub mod security_alert_policy_properties {
    use super::*;
    #[doc = "Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        New,
        Enabled,
        Disabled,
    }
}
#[doc = "A sensitivity label."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SensitivityLabel {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a sensitivity label."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SensitivityLabelProperties>,
}
impl SensitivityLabel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of sensitivity labels."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SensitivityLabelListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SensitivityLabel>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SensitivityLabelListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a sensitivity label."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SensitivityLabelProperties {
    #[doc = "The label name."]
    #[serde(rename = "labelName", default, skip_serializing_if = "Option::is_none")]
    pub label_name: Option<String>,
    #[doc = "The label ID."]
    #[serde(rename = "labelId", default, skip_serializing_if = "Option::is_none")]
    pub label_id: Option<String>,
    #[doc = "The information type."]
    #[serde(rename = "informationType", default, skip_serializing_if = "Option::is_none")]
    pub information_type: Option<String>,
    #[doc = "The information type ID."]
    #[serde(rename = "informationTypeId", default, skip_serializing_if = "Option::is_none")]
    pub information_type_id: Option<String>,
    #[doc = "Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not."]
    #[serde(rename = "isDisabled", default, skip_serializing_if = "Option::is_none")]
    pub is_disabled: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub rank: Option<sensitivity_label_properties::Rank>,
}
impl SensitivityLabelProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sensitivity_label_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Rank {
        None,
        Low,
        Medium,
        High,
        Critical,
    }
}
#[doc = "An Azure SQL Database server."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Server {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Azure Active Directory identity configuration for a resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ResourceIdentity>,
    #[doc = "Kind of sql server. This is metadata used for the Azure portal experience."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "The properties of a server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServerProperties>,
}
impl Server {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            identity: None,
            kind: None,
            properties: None,
        }
    }
}
#[doc = "The response to a list Active Directory Administrators request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerAdministratorListResult {
    #[doc = "The list of server Active Directory Administrators for the server."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServerAzureAdAdministrator>,
}
impl ServerAdministratorListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of an server Administrator."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServerAdministratorProperties {
    #[doc = "The type of administrator."]
    #[serde(rename = "administratorType")]
    pub administrator_type: server_administrator_properties::AdministratorType,
    #[doc = "The server administrator login value."]
    pub login: String,
    #[doc = "The server administrator Sid (Secure ID)."]
    pub sid: String,
    #[doc = "The server Active Directory Administrator tenant id."]
    #[serde(rename = "tenantId")]
    pub tenant_id: String,
}
impl ServerAdministratorProperties {
    pub fn new(
        administrator_type: server_administrator_properties::AdministratorType,
        login: String,
        sid: String,
        tenant_id: String,
    ) -> Self {
        Self {
            administrator_type,
            login,
            sid,
            tenant_id,
        }
    }
}
pub mod server_administrator_properties {
    use super::*;
    #[doc = "The type of administrator."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AdministratorType {
        ActiveDirectory,
    }
}
#[doc = "Server-level Automatic Tuning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerAutomaticTuning {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Server-level Automatic Tuning properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AutomaticTuningServerProperties>,
}
impl ServerAutomaticTuning {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An server Active Directory Administrator."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerAzureAdAdministrator {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of an server Administrator."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServerAdministratorProperties>,
}
impl ServerAzureAdAdministrator {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A server blob auditing policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerBlobAuditingPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a server blob auditing policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServerBlobAuditingPolicyProperties>,
}
impl ServerBlobAuditingPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of server auditing settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerBlobAuditingPolicyListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServerBlobAuditingPolicy>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServerBlobAuditingPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a server blob auditing policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServerBlobAuditingPolicyProperties {
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required."]
    pub state: server_blob_auditing_policy_properties::State,
    #[doc = "Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required."]
    #[serde(rename = "storageEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub storage_endpoint: Option<String>,
    #[doc = "Specifies the identifier key of the auditing storage account. \r\nIf state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.\r\nPrerequisites for using managed identity authentication:\r\n1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).\r\n2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.\r\nFor more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)"]
    #[serde(rename = "storageAccountAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_access_key: Option<String>,
    #[doc = "Specifies the number of days to keep in the audit logs in the storage account."]
    #[serde(rename = "retentionDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i32>,
    #[doc = "Specifies the Actions-Groups and Actions to audit.\r\n\r\nThe recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:\r\n\r\nBATCH_COMPLETED_GROUP,\r\nSUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,\r\nFAILED_DATABASE_AUTHENTICATION_GROUP.\r\n\r\nThis above combination is also the set that is configured by default when enabling auditing from the Azure portal.\r\n\r\nThe supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):\r\n\r\nAPPLICATION_ROLE_CHANGE_PASSWORD_GROUP\r\nBACKUP_RESTORE_GROUP\r\nDATABASE_LOGOUT_GROUP\r\nDATABASE_OBJECT_CHANGE_GROUP\r\nDATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP\r\nDATABASE_OBJECT_PERMISSION_CHANGE_GROUP\r\nDATABASE_OPERATION_GROUP\r\nDATABASE_PERMISSION_CHANGE_GROUP\r\nDATABASE_PRINCIPAL_CHANGE_GROUP\r\nDATABASE_PRINCIPAL_IMPERSONATION_GROUP\r\nDATABASE_ROLE_MEMBER_CHANGE_GROUP\r\nFAILED_DATABASE_AUTHENTICATION_GROUP\r\nSCHEMA_OBJECT_ACCESS_GROUP\r\nSCHEMA_OBJECT_CHANGE_GROUP\r\nSCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP\r\nSCHEMA_OBJECT_PERMISSION_CHANGE_GROUP\r\nSUCCESSFUL_DATABASE_AUTHENTICATION_GROUP\r\nUSER_CHANGE_PASSWORD_GROUP\r\nBATCH_STARTED_GROUP\r\nBATCH_COMPLETED_GROUP\r\nDBCC_GROUP\r\nDATABASE_OWNERSHIP_CHANGE_GROUP\r\nDATABASE_CHANGE_GROUP\r\n\r\nThese are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.\r\n\r\nFor more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).\r\n\r\nFor Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:\r\nSELECT\r\nUPDATE\r\nINSERT\r\nDELETE\r\nEXECUTE\r\nRECEIVE\r\nREFERENCES\r\n\r\nThe general form for defining an action to be audited is:\r\n{action} ON {object} BY {principal}\r\n\r\nNote that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.\r\n\r\nFor example:\r\nSELECT on dbo.myTable by public\r\nSELECT on DATABASE::myDatabase by public\r\nSELECT on SCHEMA::mySchema by public\r\n\r\nFor more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)"]
    #[serde(rename = "auditActionsAndGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub audit_actions_and_groups: Vec<String>,
    #[doc = "Specifies the blob storage subscription Id."]
    #[serde(rename = "storageAccountSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_subscription_id: Option<String>,
    #[doc = "Specifies whether storageAccountAccessKey value is the storage's secondary key."]
    #[serde(rename = "isStorageSecondaryKeyInUse", default, skip_serializing_if = "Option::is_none")]
    pub is_storage_secondary_key_in_use: Option<bool>,
    #[doc = "Specifies whether audit events are sent to Azure Monitor. \r\nIn order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.\r\n\r\nWhen using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.\r\nNote that for server level audit you should use the 'master' database as {databaseName}.\r\n\r\nDiagnostic Settings URI format:\r\nPUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview\r\n\r\nFor more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)\r\nor [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)\r\n"]
    #[serde(rename = "isAzureMonitorTargetEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_azure_monitor_target_enabled: Option<bool>,
    #[doc = "Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.\r\nThe default minimum value is 1000 (1 second). The maximum is 2,147,483,647."]
    #[serde(rename = "queueDelayMs", default, skip_serializing_if = "Option::is_none")]
    pub queue_delay_ms: Option<i32>,
}
impl ServerBlobAuditingPolicyProperties {
    pub fn new(state: server_blob_auditing_policy_properties::State) -> Self {
        Self {
            state,
            storage_endpoint: None,
            storage_account_access_key: None,
            retention_days: None,
            audit_actions_and_groups: Vec::new(),
            storage_account_subscription_id: None,
            is_storage_secondary_key_in_use: None,
            is_azure_monitor_target_enabled: None,
            queue_delay_ms: None,
        }
    }
}
pub mod server_blob_auditing_policy_properties {
    use super::*;
    #[doc = "Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
}
#[doc = "Server communication link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerCommunicationLink {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "The properties of a server communication link."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServerCommunicationLinkProperties>,
    #[doc = "Communication link location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Communication link kind.  This property is used for Azure Portal metadata."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl ServerCommunicationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of server communication links."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerCommunicationLinkListResult {
    #[doc = "The list of server communication links."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServerCommunicationLink>,
}
impl ServerCommunicationLinkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a server communication link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServerCommunicationLinkProperties {
    #[doc = "The state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The name of the partner server."]
    #[serde(rename = "partnerServer")]
    pub partner_server: String,
}
impl ServerCommunicationLinkProperties {
    pub fn new(partner_server: String) -> Self {
        Self {
            state: None,
            partner_server,
        }
    }
}
#[doc = "A server secure connection policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerConnectionPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Metadata used for the Azure portal experience."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "The properties of a server secure connection policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServerConnectionPolicyProperties>,
}
impl ServerConnectionPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a server secure connection policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServerConnectionPolicyProperties {
    #[doc = "The server connection type."]
    #[serde(rename = "connectionType")]
    pub connection_type: server_connection_policy_properties::ConnectionType,
}
impl ServerConnectionPolicyProperties {
    pub fn new(connection_type: server_connection_policy_properties::ConnectionType) -> Self {
        Self { connection_type }
    }
}
pub mod server_connection_policy_properties {
    use super::*;
    #[doc = "The server connection type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionType {
        Default,
        Proxy,
        Redirect,
    }
}
#[doc = "A server DNS alias."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerDnsAlias {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a server DNS alias."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServerDnsAliasProperties>,
}
impl ServerDnsAlias {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A server DNS alias acquisition request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerDnsAliasAcquisition {
    #[doc = "The id of the server alias that will be acquired to point to this server instead."]
    #[serde(rename = "oldServerDnsAliasId", default, skip_serializing_if = "Option::is_none")]
    pub old_server_dns_alias_id: Option<String>,
}
impl ServerDnsAliasAcquisition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of server DNS aliases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerDnsAliasListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServerDnsAlias>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServerDnsAliasListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a server DNS alias."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerDnsAliasProperties {
    #[doc = "The fully qualified DNS record for alias"]
    #[serde(rename = "azureDnsRecord", default, skip_serializing_if = "Option::is_none")]
    pub azure_dns_record: Option<String>,
}
impl ServerDnsAliasProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A server key."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerKey {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Kind of encryption protector. This is metadata used for the Azure portal experience."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Properties for a server key execution."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServerKeyProperties>,
}
impl ServerKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of server keys."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerKeyListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServerKey>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServerKeyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties for a server key execution."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServerKeyProperties {
    #[doc = "Subregion of the server key."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subregion: Option<String>,
    #[doc = "The server key type like 'ServiceManaged', 'AzureKeyVault'."]
    #[serde(rename = "serverKeyType")]
    pub server_key_type: server_key_properties::ServerKeyType,
    #[doc = "The URI of the server key."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
    #[doc = "Thumbprint of the server key."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "The server key creation date."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
}
impl ServerKeyProperties {
    pub fn new(server_key_type: server_key_properties::ServerKeyType) -> Self {
        Self {
            subregion: None,
            server_key_type,
            uri: None,
            thumbprint: None,
            creation_date: None,
        }
    }
}
pub mod server_key_properties {
    use super::*;
    #[doc = "The server key type like 'ServiceManaged', 'AzureKeyVault'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServerKeyType {
        ServiceManaged,
        AzureKeyVault,
    }
}
#[doc = "A list of servers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Server>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a server."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerProperties {
    #[doc = "Administrator username for the server. Once created it cannot be changed."]
    #[serde(rename = "administratorLogin", default, skip_serializing_if = "Option::is_none")]
    pub administrator_login: Option<String>,
    #[doc = "The administrator login password (required for server creation)."]
    #[serde(rename = "administratorLoginPassword", default, skip_serializing_if = "Option::is_none")]
    pub administrator_login_password: Option<String>,
    #[doc = "The version of the server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[doc = "The state of the server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The fully qualified domain name of the server."]
    #[serde(rename = "fullyQualifiedDomainName", default, skip_serializing_if = "Option::is_none")]
    pub fully_qualified_domain_name: Option<String>,
}
impl ServerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A server security alert policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerSecurityAlertPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a security alert policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityAlertPolicyProperties>,
}
impl ServerSecurityAlertPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An update request for an Azure SQL Database server."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerUpdate {
    #[doc = "The properties of a server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServerProperties>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl ServerUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents server metrics."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerUsage {
    #[doc = "Name of the server usage metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The name of the resource."]
    #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
    pub resource_name: Option<String>,
    #[doc = "The metric display name."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The current value of the metric."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<f64>,
    #[doc = "The current limit of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<f64>,
    #[doc = "The units of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[doc = "The next reset time for the metric (ISO8601 format)."]
    #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
    pub next_reset_time: Option<String>,
}
impl ServerUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the response to a list server metrics request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServerUsageListResult {
    #[doc = "The list of server metrics for the server."]
    pub value: Vec<ServerUsage>,
}
impl ServerUsageListResult {
    pub fn new(value: Vec<ServerUsage>) -> Self {
        Self { value }
    }
}
#[doc = "The server capabilities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerVersionCapability {
    #[doc = "The server version name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The availability status of the capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<CapabilityStatus>,
    #[doc = "The list of supported database editions."]
    #[serde(rename = "supportedEditions", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_editions: Vec<EditionCapability>,
    #[doc = "The list of supported elastic pool editions."]
    #[serde(rename = "supportedElasticPoolEditions", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_elastic_pool_editions: Vec<ElasticPoolEditionCapability>,
}
impl ServerVersionCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a database service objective."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceObjective {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Represents the properties of a database service objective."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceObjectiveProperties>,
}
impl ServiceObjective {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The service objectives capability."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceObjectiveCapability {
    #[doc = "The service objective name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The availability status of the capability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<CapabilityStatus>,
    #[doc = "A possible performance level of a service objective capability."]
    #[serde(rename = "performanceLevel", default, skip_serializing_if = "Option::is_none")]
    pub performance_level: Option<PerformanceLevel>,
    #[doc = "The unique ID of the service objective."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The list of supported maximum database sizes for this service objective."]
    #[serde(rename = "supportedMaxSizes", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_max_sizes: Vec<MaxSizeCapability>,
    #[doc = "The maximum size limits for a database."]
    #[serde(rename = "includedMaxSize", default, skip_serializing_if = "Option::is_none")]
    pub included_max_size: Option<MaxSizeCapability>,
}
impl ServiceObjectiveCapability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the response to a get database service objectives request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceObjectiveListResult {
    #[doc = "The list of database service objectives."]
    pub value: Vec<ServiceObjective>,
}
impl ServiceObjectiveListResult {
    pub fn new(value: Vec<ServiceObjective>) -> Self {
        Self { value }
    }
}
#[doc = "Represents the properties of a database service objective."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceObjectiveProperties {
    #[doc = "The name for the service objective."]
    #[serde(rename = "serviceObjectiveName", default, skip_serializing_if = "Option::is_none")]
    pub service_objective_name: Option<String>,
    #[doc = "Gets whether the service level objective is the default service objective."]
    #[serde(rename = "isDefault", default, skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    #[doc = "Gets whether the service level objective is a system service objective."]
    #[serde(rename = "isSystem", default, skip_serializing_if = "Option::is_none")]
    pub is_system: Option<bool>,
    #[doc = "The description for the service level objective."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Gets whether the service level objective is enabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl ServiceObjectiveProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a Service Tier Advisor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTierAdvisor {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Represents the properties of a Service Tier Advisor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceTierAdvisorProperties>,
}
impl ServiceTierAdvisor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the response to a list service tier advisor request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceTierAdvisorListResult {
    #[doc = "The list of service tier advisors for specified database."]
    pub value: Vec<ServiceTierAdvisor>,
}
impl ServiceTierAdvisorListResult {
    pub fn new(value: Vec<ServiceTierAdvisor>) -> Self {
        Self { value }
    }
}
#[doc = "Represents the properties of a Service Tier Advisor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTierAdvisorProperties {
    #[doc = "The observation period start (ISO8601 format)."]
    #[serde(rename = "observationPeriodStart", default, skip_serializing_if = "Option::is_none")]
    pub observation_period_start: Option<String>,
    #[doc = "The observation period start (ISO8601 format)."]
    #[serde(rename = "observationPeriodEnd", default, skip_serializing_if = "Option::is_none")]
    pub observation_period_end: Option<String>,
    #[doc = "The activeTimeRatio for service tier advisor."]
    #[serde(rename = "activeTimeRatio", default, skip_serializing_if = "Option::is_none")]
    pub active_time_ratio: Option<f64>,
    #[doc = "Gets or sets minDtu for service tier advisor."]
    #[serde(rename = "minDtu", default, skip_serializing_if = "Option::is_none")]
    pub min_dtu: Option<f64>,
    #[doc = "Gets or sets avgDtu for service tier advisor."]
    #[serde(rename = "avgDtu", default, skip_serializing_if = "Option::is_none")]
    pub avg_dtu: Option<f64>,
    #[doc = "Gets or sets maxDtu for service tier advisor."]
    #[serde(rename = "maxDtu", default, skip_serializing_if = "Option::is_none")]
    pub max_dtu: Option<f64>,
    #[doc = "Gets or sets maxSizeInGB for service tier advisor."]
    #[serde(rename = "maxSizeInGB", default, skip_serializing_if = "Option::is_none")]
    pub max_size_in_gb: Option<f64>,
    #[doc = "Gets or sets serviceLevelObjectiveUsageMetrics for the service tier advisor."]
    #[serde(rename = "serviceLevelObjectiveUsageMetrics", default, skip_serializing_if = "Vec::is_empty")]
    pub service_level_objective_usage_metrics: Vec<SloUsageMetric>,
    #[doc = "Gets or sets currentServiceLevelObjective for service tier advisor."]
    #[serde(rename = "currentServiceLevelObjective", default, skip_serializing_if = "Option::is_none")]
    pub current_service_level_objective: Option<String>,
    #[doc = "Gets or sets currentServiceLevelObjectiveId for service tier advisor."]
    #[serde(rename = "currentServiceLevelObjectiveId", default, skip_serializing_if = "Option::is_none")]
    pub current_service_level_objective_id: Option<String>,
    #[doc = "Gets or sets usageBasedRecommendationServiceLevelObjective for service tier advisor."]
    #[serde(
        rename = "usageBasedRecommendationServiceLevelObjective",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub usage_based_recommendation_service_level_objective: Option<String>,
    #[doc = "Gets or sets usageBasedRecommendationServiceLevelObjectiveId for service tier advisor."]
    #[serde(
        rename = "usageBasedRecommendationServiceLevelObjectiveId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub usage_based_recommendation_service_level_objective_id: Option<String>,
    #[doc = "Gets or sets databaseSizeBasedRecommendationServiceLevelObjective for service tier advisor."]
    #[serde(
        rename = "databaseSizeBasedRecommendationServiceLevelObjective",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub database_size_based_recommendation_service_level_objective: Option<String>,
    #[doc = "Gets or sets databaseSizeBasedRecommendationServiceLevelObjectiveId for service tier advisor."]
    #[serde(
        rename = "databaseSizeBasedRecommendationServiceLevelObjectiveId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub database_size_based_recommendation_service_level_objective_id: Option<String>,
    #[doc = "Gets or sets disasterPlanBasedRecommendationServiceLevelObjective for service tier advisor."]
    #[serde(
        rename = "disasterPlanBasedRecommendationServiceLevelObjective",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub disaster_plan_based_recommendation_service_level_objective: Option<String>,
    #[doc = "Gets or sets disasterPlanBasedRecommendationServiceLevelObjectiveId for service tier advisor."]
    #[serde(
        rename = "disasterPlanBasedRecommendationServiceLevelObjectiveId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub disaster_plan_based_recommendation_service_level_objective_id: Option<String>,
    #[doc = "Gets or sets overallRecommendationServiceLevelObjective for service tier advisor."]
    #[serde(
        rename = "overallRecommendationServiceLevelObjective",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub overall_recommendation_service_level_objective: Option<String>,
    #[doc = "Gets or sets overallRecommendationServiceLevelObjectiveId for service tier advisor."]
    #[serde(
        rename = "overallRecommendationServiceLevelObjectiveId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub overall_recommendation_service_level_objective_id: Option<String>,
    #[doc = "Gets or sets confidence for service tier advisor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub confidence: Option<f64>,
}
impl ServiceTierAdvisorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An ARM Resource SKU."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Sku {
    #[doc = "The name of the SKU, typically, a letter + Number code, e.g. P3."]
    pub name: String,
    #[doc = "The tier or edition of the particular SKU, e.g. Basic, Premium."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[doc = "Size of the particular SKU"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
    #[doc = "If the service has different generations of hardware, for the same SKU, then that can be captured here."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[doc = "Capacity of the particular SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl Sku {
    pub fn new(name: String) -> Self {
        Self {
            name,
            tier: None,
            size: None,
            family: None,
            capacity: None,
        }
    }
}
#[doc = "A Slo Usage Metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SloUsageMetric {
    #[doc = "The serviceLevelObjective for SLO usage metric."]
    #[serde(rename = "serviceLevelObjective", default, skip_serializing_if = "Option::is_none")]
    pub service_level_objective: Option<slo_usage_metric::ServiceLevelObjective>,
    #[doc = "The serviceLevelObjectiveId for SLO usage metric."]
    #[serde(rename = "serviceLevelObjectiveId", default, skip_serializing_if = "Option::is_none")]
    pub service_level_objective_id: Option<String>,
    #[doc = "Gets or sets inRangeTimeRatio for SLO usage metric."]
    #[serde(rename = "inRangeTimeRatio", default, skip_serializing_if = "Option::is_none")]
    pub in_range_time_ratio: Option<f64>,
}
impl SloUsageMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod slo_usage_metric {
    use super::*;
    #[doc = "The serviceLevelObjective for SLO usage metric."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceLevelObjective {
        System,
        System0,
        System1,
        System2,
        System3,
        System4,
        System2L,
        System3L,
        System4L,
        Free,
        Basic,
        S0,
        S1,
        S2,
        S3,
        S4,
        S6,
        S7,
        S9,
        S12,
        P1,
        P2,
        P3,
        P4,
        P6,
        P11,
        P15,
        #[serde(rename = "PRS1")]
        Prs1,
        #[serde(rename = "PRS2")]
        Prs2,
        #[serde(rename = "PRS4")]
        Prs4,
        #[serde(rename = "PRS6")]
        Prs6,
        #[serde(rename = "DW100")]
        Dw100,
        #[serde(rename = "DW200")]
        Dw200,
        #[serde(rename = "DW300")]
        Dw300,
        #[serde(rename = "DW400")]
        Dw400,
        #[serde(rename = "DW500")]
        Dw500,
        #[serde(rename = "DW600")]
        Dw600,
        #[serde(rename = "DW1000")]
        Dw1000,
        #[serde(rename = "DW1200")]
        Dw1200,
        #[serde(rename = "DW1000c")]
        Dw1000c,
        #[serde(rename = "DW1500")]
        Dw1500,
        #[serde(rename = "DW1500c")]
        Dw1500c,
        #[serde(rename = "DW2000")]
        Dw2000,
        #[serde(rename = "DW2000c")]
        Dw2000c,
        #[serde(rename = "DW3000")]
        Dw3000,
        #[serde(rename = "DW2500c")]
        Dw2500c,
        #[serde(rename = "DW3000c")]
        Dw3000c,
        #[serde(rename = "DW6000")]
        Dw6000,
        #[serde(rename = "DW5000c")]
        Dw5000c,
        #[serde(rename = "DW6000c")]
        Dw6000c,
        #[serde(rename = "DW7500c")]
        Dw7500c,
        #[serde(rename = "DW10000c")]
        Dw10000c,
        #[serde(rename = "DW15000c")]
        Dw15000c,
        #[serde(rename = "DW30000c")]
        Dw30000c,
        #[serde(rename = "DS100")]
        Ds100,
        #[serde(rename = "DS200")]
        Ds200,
        #[serde(rename = "DS300")]
        Ds300,
        #[serde(rename = "DS400")]
        Ds400,
        #[serde(rename = "DS500")]
        Ds500,
        #[serde(rename = "DS600")]
        Ds600,
        #[serde(rename = "DS1000")]
        Ds1000,
        #[serde(rename = "DS1200")]
        Ds1200,
        #[serde(rename = "DS1500")]
        Ds1500,
        #[serde(rename = "DS2000")]
        Ds2000,
        ElasticPool,
    }
}
#[doc = "Usage Metric of a Subscription in a Location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionUsage {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a subscription usage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubscriptionUsageProperties>,
}
impl SubscriptionUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of subscription usage metrics in a location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionUsageListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SubscriptionUsage>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SubscriptionUsageListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a subscription usage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionUsageProperties {
    #[doc = "User-readable name of the metric."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Current value of the metric."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<f64>,
    #[doc = "Boundary value of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<f64>,
    #[doc = "Unit of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
}
impl SubscriptionUsageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure SQL Database sync agent."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncAgent {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of an Azure SQL Database sync agent."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SyncAgentProperties>,
}
impl SyncAgent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an Azure SQL Database sync agent key."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncAgentKeyProperties {
    #[doc = "Key of sync agent."]
    #[serde(rename = "syncAgentKey", default, skip_serializing_if = "Option::is_none")]
    pub sync_agent_key: Option<String>,
}
impl SyncAgentKeyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure SQL Database sync agent linked database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncAgentLinkedDatabase {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of an Azure SQL Database sync agent linked database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SyncAgentLinkedDatabaseProperties>,
}
impl SyncAgentLinkedDatabase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of sync agent linked databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncAgentLinkedDatabaseListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SyncAgentLinkedDatabase>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SyncAgentLinkedDatabaseListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an Azure SQL Database sync agent linked database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncAgentLinkedDatabaseProperties {
    #[doc = "Type of the sync agent linked database."]
    #[serde(rename = "databaseType", default, skip_serializing_if = "Option::is_none")]
    pub database_type: Option<sync_agent_linked_database_properties::DatabaseType>,
    #[doc = "Id of the sync agent linked database."]
    #[serde(rename = "databaseId", default, skip_serializing_if = "Option::is_none")]
    pub database_id: Option<String>,
    #[doc = "Description of the sync agent linked database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Server name of the sync agent linked database."]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "Database name of the sync agent linked database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "User name of the sync agent linked database."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl SyncAgentLinkedDatabaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sync_agent_linked_database_properties {
    use super::*;
    #[doc = "Type of the sync agent linked database."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DatabaseType {
        AzureSqlDatabase,
        SqlServerDatabase,
    }
}
#[doc = "A list of sync agents."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncAgentListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SyncAgent>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SyncAgentListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an Azure SQL Database sync agent."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncAgentProperties {
    #[doc = "Name of the sync agent."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "ARM resource id of the sync database in the sync agent."]
    #[serde(rename = "syncDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub sync_database_id: Option<String>,
    #[doc = "Last alive time of the sync agent."]
    #[serde(rename = "lastAliveTime", default, skip_serializing_if = "Option::is_none")]
    pub last_alive_time: Option<String>,
    #[doc = "State of the sync agent."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<sync_agent_properties::State>,
    #[doc = "If the sync agent version is up to date."]
    #[serde(rename = "isUpToDate", default, skip_serializing_if = "Option::is_none")]
    pub is_up_to_date: Option<bool>,
    #[doc = "Expiration time of the sync agent version."]
    #[serde(rename = "expiryTime", default, skip_serializing_if = "Option::is_none")]
    pub expiry_time: Option<String>,
    #[doc = "Version of the sync agent."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl SyncAgentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sync_agent_properties {
    use super::*;
    #[doc = "State of the sync agent."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Online,
        Offline,
        NeverConnected,
    }
}
#[doc = "A list of sync database ID properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncDatabaseIdListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SyncDatabaseIdProperties>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SyncDatabaseIdListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the sync database id."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncDatabaseIdProperties {
    #[doc = "ARM resource id of sync database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SyncDatabaseIdProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the database full schema."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncFullSchemaProperties {
    #[doc = "List of tables in the database full schema."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tables: Vec<SyncFullSchemaTable>,
    #[doc = "Last update time of the database schema."]
    #[serde(rename = "lastUpdateTime", default, skip_serializing_if = "Option::is_none")]
    pub last_update_time: Option<String>,
}
impl SyncFullSchemaProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of sync schema properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncFullSchemaPropertiesListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SyncFullSchemaProperties>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SyncFullSchemaPropertiesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the table in the database full schema."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncFullSchemaTable {
    #[doc = "List of columns in the table of database full schema."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<SyncFullSchemaTableColumn>,
    #[doc = "Error id of the table."]
    #[serde(rename = "errorId", default, skip_serializing_if = "Option::is_none")]
    pub error_id: Option<String>,
    #[doc = "If there is error in the table."]
    #[serde(rename = "hasError", default, skip_serializing_if = "Option::is_none")]
    pub has_error: Option<bool>,
    #[doc = "Name of the table."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Quoted name of the table."]
    #[serde(rename = "quotedName", default, skip_serializing_if = "Option::is_none")]
    pub quoted_name: Option<String>,
}
impl SyncFullSchemaTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the column in the table of database full schema."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncFullSchemaTableColumn {
    #[doc = "Data size of the column."]
    #[serde(rename = "dataSize", default, skip_serializing_if = "Option::is_none")]
    pub data_size: Option<String>,
    #[doc = "Data type of the column."]
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<String>,
    #[doc = "Error id of the column."]
    #[serde(rename = "errorId", default, skip_serializing_if = "Option::is_none")]
    pub error_id: Option<String>,
    #[doc = "If there is error in the table."]
    #[serde(rename = "hasError", default, skip_serializing_if = "Option::is_none")]
    pub has_error: Option<bool>,
    #[doc = "If it is the primary key of the table."]
    #[serde(rename = "isPrimaryKey", default, skip_serializing_if = "Option::is_none")]
    pub is_primary_key: Option<bool>,
    #[doc = "Name of the column."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Quoted name of the column."]
    #[serde(rename = "quotedName", default, skip_serializing_if = "Option::is_none")]
    pub quoted_name: Option<String>,
}
impl SyncFullSchemaTableColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure SQL Database sync group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncGroup {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a sync group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SyncGroupProperties>,
}
impl SyncGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of sync groups."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncGroupListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SyncGroup>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SyncGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of sync group log properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncGroupLogListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SyncGroupLogProperties>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SyncGroupLogListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an Azure SQL Database sync group log."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncGroupLogProperties {
    #[doc = "Timestamp of the sync group log."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[doc = "Type of the sync group log."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<sync_group_log_properties::Type>,
    #[doc = "Source of the sync group log."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[doc = "Details of the sync group log."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
    #[doc = "TracingId of the sync group log."]
    #[serde(rename = "tracingId", default, skip_serializing_if = "Option::is_none")]
    pub tracing_id: Option<String>,
    #[doc = "OperationStatus of the sync group log."]
    #[serde(rename = "operationStatus", default, skip_serializing_if = "Option::is_none")]
    pub operation_status: Option<String>,
}
impl SyncGroupLogProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sync_group_log_properties {
    use super::*;
    #[doc = "Type of the sync group log."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        All,
        Error,
        Warning,
        Success,
    }
}
#[doc = "Properties of a sync group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncGroupProperties {
    #[doc = "Sync interval of the sync group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[doc = "Last sync time of the sync group."]
    #[serde(rename = "lastSyncTime", default, skip_serializing_if = "Option::is_none")]
    pub last_sync_time: Option<String>,
    #[doc = "Conflict resolution policy of the sync group."]
    #[serde(rename = "conflictResolutionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub conflict_resolution_policy: Option<sync_group_properties::ConflictResolutionPolicy>,
    #[doc = "ARM resource id of the sync database in the sync group."]
    #[serde(rename = "syncDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub sync_database_id: Option<String>,
    #[doc = "User name for the sync group hub database credential."]
    #[serde(rename = "hubDatabaseUserName", default, skip_serializing_if = "Option::is_none")]
    pub hub_database_user_name: Option<String>,
    #[doc = "Password for the sync group hub database credential."]
    #[serde(rename = "hubDatabasePassword", default, skip_serializing_if = "Option::is_none")]
    pub hub_database_password: Option<String>,
    #[doc = "Sync state of the sync group."]
    #[serde(rename = "syncState", default, skip_serializing_if = "Option::is_none")]
    pub sync_state: Option<sync_group_properties::SyncState>,
    #[doc = "Properties of sync group schema."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<SyncGroupSchema>,
}
impl SyncGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sync_group_properties {
    use super::*;
    #[doc = "Conflict resolution policy of the sync group."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConflictResolutionPolicy {
        HubWin,
        MemberWin,
    }
    #[doc = "Sync state of the sync group."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SyncState {
        NotReady,
        Error,
        Warning,
        Progressing,
        Good,
    }
}
#[doc = "Properties of sync group schema."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncGroupSchema {
    #[doc = "List of tables in sync group schema."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tables: Vec<SyncGroupSchemaTable>,
    #[doc = "Name of master sync member where the schema is from."]
    #[serde(rename = "masterSyncMemberName", default, skip_serializing_if = "Option::is_none")]
    pub master_sync_member_name: Option<String>,
}
impl SyncGroupSchema {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of table in sync group schema."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncGroupSchemaTable {
    #[doc = "List of columns in sync group schema."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<SyncGroupSchemaTableColumn>,
    #[doc = "Quoted name of sync group schema table."]
    #[serde(rename = "quotedName", default, skip_serializing_if = "Option::is_none")]
    pub quoted_name: Option<String>,
}
impl SyncGroupSchemaTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of column in sync group table."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncGroupSchemaTableColumn {
    #[doc = "Quoted name of sync group table column."]
    #[serde(rename = "quotedName", default, skip_serializing_if = "Option::is_none")]
    pub quoted_name: Option<String>,
    #[doc = "Data size of the column."]
    #[serde(rename = "dataSize", default, skip_serializing_if = "Option::is_none")]
    pub data_size: Option<String>,
    #[doc = "Data type of the column."]
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<String>,
}
impl SyncGroupSchemaTableColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure SQL Database sync member."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncMember {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a sync member."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SyncMemberProperties>,
}
impl SyncMember {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of Azure SQL Database sync members."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncMemberListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SyncMember>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SyncMemberListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a sync member."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SyncMemberProperties {
    #[doc = "Database type of the sync member."]
    #[serde(rename = "databaseType", default, skip_serializing_if = "Option::is_none")]
    pub database_type: Option<sync_member_properties::DatabaseType>,
    #[doc = "ARM resource id of the sync agent in the sync member."]
    #[serde(rename = "syncAgentId", default, skip_serializing_if = "Option::is_none")]
    pub sync_agent_id: Option<String>,
    #[doc = "SQL Server database id of the sync member."]
    #[serde(rename = "sqlServerDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_database_id: Option<String>,
    #[doc = "Server name of the member database in the sync member"]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "Database name of the member database in the sync member."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "User name of the member database in the sync member."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[doc = "Password of the member database in the sync member."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[doc = "Sync direction of the sync member."]
    #[serde(rename = "syncDirection", default, skip_serializing_if = "Option::is_none")]
    pub sync_direction: Option<sync_member_properties::SyncDirection>,
    #[doc = "Sync state of the sync member."]
    #[serde(rename = "syncState", default, skip_serializing_if = "Option::is_none")]
    pub sync_state: Option<sync_member_properties::SyncState>,
}
impl SyncMemberProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sync_member_properties {
    use super::*;
    #[doc = "Database type of the sync member."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DatabaseType {
        AzureSqlDatabase,
        SqlServerDatabase,
    }
    #[doc = "Sync direction of the sync member."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SyncDirection {
        Bidirectional,
        OneWayMemberToHub,
        OneWayHubToMember,
    }
    #[doc = "Sync state of the sync member."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SyncState {
        SyncInProgress,
        SyncSucceeded,
        SyncFailed,
        DisabledTombstoneCleanup,
        DisabledBackupRestore,
        SyncSucceededWithWarnings,
        SyncCancelling,
        SyncCancelled,
        UnProvisioned,
        Provisioning,
        Provisioned,
        ProvisionFailed,
        DeProvisioning,
        DeProvisioned,
        DeProvisionFailed,
        Reprovisioning,
        ReprovisionFailed,
        UnReprovisioned,
    }
}
#[doc = "ARM tracked top level resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Resource location."]
    pub location: String,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            location,
            tags: None,
        }
    }
}
#[doc = "Represents a database transparent data encryption configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransparentDataEncryption {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Represents the properties of a database transparent data encryption."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TransparentDataEncryptionProperties>,
}
impl TransparentDataEncryption {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a database transparent data encryption Scan."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransparentDataEncryptionActivity {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Represents the properties of a database transparent data encryption Scan."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TransparentDataEncryptionActivityProperties>,
}
impl TransparentDataEncryptionActivity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the response to a list database transparent data encryption activity request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TransparentDataEncryptionActivityListResult {
    #[doc = "The list of database transparent data encryption activities."]
    pub value: Vec<TransparentDataEncryptionActivity>,
}
impl TransparentDataEncryptionActivityListResult {
    pub fn new(value: Vec<TransparentDataEncryptionActivity>) -> Self {
        Self { value }
    }
}
#[doc = "Represents the properties of a database transparent data encryption Scan."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransparentDataEncryptionActivityProperties {
    #[doc = "The status of the database."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<transparent_data_encryption_activity_properties::Status>,
    #[doc = "The percent complete of the transparent data encryption scan for a database."]
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<f32>,
}
impl TransparentDataEncryptionActivityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod transparent_data_encryption_activity_properties {
    use super::*;
    #[doc = "The status of the database."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Encrypting,
        Decrypting,
    }
}
#[doc = "Represents the properties of a database transparent data encryption."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransparentDataEncryptionProperties {
    #[doc = "The status of the database transparent data encryption."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<transparent_data_encryption_properties::Status>,
}
impl TransparentDataEncryptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod transparent_data_encryption_properties {
    use super::*;
    #[doc = "The status of the database transparent data encryption."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
}
#[doc = "Represents the parameters for Unlink Replication Link request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UnlinkParameters {
    #[doc = "Determines whether link will be terminated in a forced or a friendly way."]
    #[serde(rename = "forcedTermination", default, skip_serializing_if = "Option::is_none")]
    pub forced_termination: Option<bool>,
}
impl UnlinkParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An Azure SQL virtual cluster."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualCluster {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "The properties of a virtual cluster."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualClusterProperties>,
}
impl VirtualCluster {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
        }
    }
}
#[doc = "A list of virtual clusters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualClusterListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualCluster>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualClusterListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a virtual cluster."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualClusterProperties {
    #[doc = "Subnet resource ID for the virtual cluster."]
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[doc = "If the service has different generations of hardware, for the same SKU, then that can be captured here."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[doc = "List of resources in this virtual cluster."]
    #[serde(rename = "childResources", default, skip_serializing_if = "Vec::is_empty")]
    pub child_resources: Vec<String>,
}
impl VirtualClusterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An update request for an Azure SQL Database virtual cluster."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualClusterUpdate {
    #[doc = "The properties of a virtual cluster."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualClusterProperties>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl VirtualClusterUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A virtual network rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a virtual network rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkRuleProperties>,
}
impl VirtualNetworkRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of virtual network rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkRuleListResult {
    #[doc = "Array of results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkRule>,
    #[doc = "Link to retrieve next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a virtual network rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkRuleProperties {
    #[doc = "The ARM resource id of the virtual network subnet."]
    #[serde(rename = "virtualNetworkSubnetId")]
    pub virtual_network_subnet_id: String,
    #[doc = "Create firewall rule before the virtual network has vnet service endpoint enabled."]
    #[serde(rename = "ignoreMissingVnetServiceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub ignore_missing_vnet_service_endpoint: Option<bool>,
    #[doc = "Virtual Network Rule State"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<virtual_network_rule_properties::State>,
}
impl VirtualNetworkRuleProperties {
    pub fn new(virtual_network_subnet_id: String) -> Self {
        Self {
            virtual_network_subnet_id,
            ignore_missing_vnet_service_endpoint: None,
            state: None,
        }
    }
}
pub mod virtual_network_rule_properties {
    use super::*;
    #[doc = "Virtual Network Rule State"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Initializing,
        InProgress,
        Ready,
        Deleting,
        Unknown,
    }
}
#[doc = "Properties of a Vulnerability Assessment recurring scans."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VulnerabilityAssessmentRecurringScansProperties {
    #[doc = "Recurring scans state."]
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
    #[doc = "Specifies that the schedule scan notification will be is sent to the subscription administrators."]
    #[serde(rename = "emailSubscriptionAdmins", default, skip_serializing_if = "Option::is_none")]
    pub email_subscription_admins: Option<bool>,
    #[doc = "Specifies an array of e-mail addresses to which the scan notification is sent."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub emails: Vec<String>,
}
impl VulnerabilityAssessmentRecurringScansProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
