#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckNameAvailabilityRequest {
    pub name: String,
    #[serde(rename = "type")]
    pub type_: check_name_availability_request::Type,
}
impl CheckNameAvailabilityRequest {
    pub fn new(name: String, type_: check_name_availability_request::Type) -> Self {
        Self { name, type_ }
    }
}
pub mod check_name_availability_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.Sql/servers")]
        MicrosoftSqlServers,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckNameAvailabilityResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<check_name_availability_response::Reason>,
}
impl CheckNameAvailabilityResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod check_name_availability_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Database {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseProperties>,
}
impl Database {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            kind: None,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseListResult {
    pub value: Vec<Database>,
}
impl DatabaseListResult {
    pub fn new(value: Vec<Database>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub collation: Option<String>,
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[serde(rename = "containmentState", default, skip_serializing_if = "Option::is_none")]
    pub containment_state: Option<i64>,
    #[serde(rename = "currentServiceObjectiveId", default, skip_serializing_if = "Option::is_none")]
    pub current_service_objective_id: Option<String>,
    #[serde(rename = "databaseId", default, skip_serializing_if = "Option::is_none")]
    pub database_id: Option<String>,
    #[serde(rename = "earliestRestoreDate", default, skip_serializing_if = "Option::is_none")]
    pub earliest_restore_date: Option<String>,
    #[serde(rename = "createMode", default, skip_serializing_if = "Option::is_none")]
    pub create_mode: Option<database_properties::CreateMode>,
    #[serde(rename = "sourceDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub source_database_id: Option<String>,
    #[serde(rename = "sourceDatabaseDeletionDate", default, skip_serializing_if = "Option::is_none")]
    pub source_database_deletion_date: Option<String>,
    #[serde(rename = "restorePointInTime", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_in_time: Option<String>,
    #[serde(
        rename = "recoveryServicesRecoveryPointResourceId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub recovery_services_recovery_point_resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub edition: Option<database_properties::Edition>,
    #[serde(rename = "maxSizeBytes", default, skip_serializing_if = "Option::is_none")]
    pub max_size_bytes: Option<String>,
    #[serde(rename = "requestedServiceObjectiveId", default, skip_serializing_if = "Option::is_none")]
    pub requested_service_objective_id: Option<String>,
    #[serde(rename = "requestedServiceObjectiveName", default, skip_serializing_if = "Option::is_none")]
    pub requested_service_objective_name: Option<database_properties::RequestedServiceObjectiveName>,
    #[serde(rename = "serviceLevelObjective", default, skip_serializing_if = "Option::is_none")]
    pub service_level_objective: Option<database_properties::ServiceLevelObjective>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "elasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub elastic_pool_name: Option<String>,
    #[serde(rename = "defaultSecondaryLocation", default, skip_serializing_if = "Option::is_none")]
    pub default_secondary_location: Option<String>,
    #[serde(rename = "serviceTierAdvisors", default, skip_serializing_if = "Vec::is_empty")]
    pub service_tier_advisors: Vec<ServiceTierAdvisor>,
    #[serde(rename = "transparentDataEncryption", default, skip_serializing_if = "Vec::is_empty")]
    pub transparent_data_encryption: Vec<TransparentDataEncryption>,
    #[serde(rename = "recommendedIndex", default, skip_serializing_if = "Vec::is_empty")]
    pub recommended_index: Vec<RecommendedIndex>,
    #[serde(rename = "failoverGroupId", default, skip_serializing_if = "Option::is_none")]
    pub failover_group_id: Option<String>,
    #[serde(rename = "readScale", default, skip_serializing_if = "Option::is_none")]
    pub read_scale: Option<database_properties::ReadScale>,
    #[serde(rename = "sampleName", default, skip_serializing_if = "Option::is_none")]
    pub sample_name: Option<database_properties::SampleName>,
    #[serde(rename = "zoneRedundant", default, skip_serializing_if = "Option::is_none")]
    pub zone_redundant: Option<bool>,
}
impl DatabaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod database_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreateMode {
        Copy,
        Default,
        NonReadableSecondary,
        OnlineSecondary,
        PointInTimeRestore,
        Recovery,
        Restore,
        RestoreLongTermRetentionBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Edition {
        Web,
        Business,
        Basic,
        Standard,
        Premium,
        #[serde(rename = "PremiumRS")]
        PremiumRs,
        Free,
        Stretch,
        DataWarehouse,
        System,
        System2,
        GeneralPurpose,
        BusinessCritical,
        Hyperscale,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RequestedServiceObjectiveName {
        System,
        System0,
        System1,
        System2,
        System3,
        System4,
        System2L,
        System3L,
        System4L,
        Free,
        Basic,
        S0,
        S1,
        S2,
        S3,
        S4,
        S6,
        S7,
        S9,
        S12,
        P1,
        P2,
        P3,
        P4,
        P6,
        P11,
        P15,
        #[serde(rename = "PRS1")]
        Prs1,
        #[serde(rename = "PRS2")]
        Prs2,
        #[serde(rename = "PRS4")]
        Prs4,
        #[serde(rename = "PRS6")]
        Prs6,
        #[serde(rename = "DW100")]
        Dw100,
        #[serde(rename = "DW200")]
        Dw200,
        #[serde(rename = "DW300")]
        Dw300,
        #[serde(rename = "DW400")]
        Dw400,
        #[serde(rename = "DW500")]
        Dw500,
        #[serde(rename = "DW600")]
        Dw600,
        #[serde(rename = "DW1000")]
        Dw1000,
        #[serde(rename = "DW1200")]
        Dw1200,
        #[serde(rename = "DW1000c")]
        Dw1000c,
        #[serde(rename = "DW1500")]
        Dw1500,
        #[serde(rename = "DW1500c")]
        Dw1500c,
        #[serde(rename = "DW2000")]
        Dw2000,
        #[serde(rename = "DW2000c")]
        Dw2000c,
        #[serde(rename = "DW3000")]
        Dw3000,
        #[serde(rename = "DW2500c")]
        Dw2500c,
        #[serde(rename = "DW3000c")]
        Dw3000c,
        #[serde(rename = "DW6000")]
        Dw6000,
        #[serde(rename = "DW5000c")]
        Dw5000c,
        #[serde(rename = "DW6000c")]
        Dw6000c,
        #[serde(rename = "DW7500c")]
        Dw7500c,
        #[serde(rename = "DW10000c")]
        Dw10000c,
        #[serde(rename = "DW15000c")]
        Dw15000c,
        #[serde(rename = "DW30000c")]
        Dw30000c,
        #[serde(rename = "DS100")]
        Ds100,
        #[serde(rename = "DS200")]
        Ds200,
        #[serde(rename = "DS300")]
        Ds300,
        #[serde(rename = "DS400")]
        Ds400,
        #[serde(rename = "DS500")]
        Ds500,
        #[serde(rename = "DS600")]
        Ds600,
        #[serde(rename = "DS1000")]
        Ds1000,
        #[serde(rename = "DS1200")]
        Ds1200,
        #[serde(rename = "DS1500")]
        Ds1500,
        #[serde(rename = "DS2000")]
        Ds2000,
        ElasticPool,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceLevelObjective {
        System,
        System0,
        System1,
        System2,
        System3,
        System4,
        System2L,
        System3L,
        System4L,
        Free,
        Basic,
        S0,
        S1,
        S2,
        S3,
        S4,
        S6,
        S7,
        S9,
        S12,
        P1,
        P2,
        P3,
        P4,
        P6,
        P11,
        P15,
        #[serde(rename = "PRS1")]
        Prs1,
        #[serde(rename = "PRS2")]
        Prs2,
        #[serde(rename = "PRS4")]
        Prs4,
        #[serde(rename = "PRS6")]
        Prs6,
        #[serde(rename = "DW100")]
        Dw100,
        #[serde(rename = "DW200")]
        Dw200,
        #[serde(rename = "DW300")]
        Dw300,
        #[serde(rename = "DW400")]
        Dw400,
        #[serde(rename = "DW500")]
        Dw500,
        #[serde(rename = "DW600")]
        Dw600,
        #[serde(rename = "DW1000")]
        Dw1000,
        #[serde(rename = "DW1200")]
        Dw1200,
        #[serde(rename = "DW1000c")]
        Dw1000c,
        #[serde(rename = "DW1500")]
        Dw1500,
        #[serde(rename = "DW1500c")]
        Dw1500c,
        #[serde(rename = "DW2000")]
        Dw2000,
        #[serde(rename = "DW2000c")]
        Dw2000c,
        #[serde(rename = "DW3000")]
        Dw3000,
        #[serde(rename = "DW2500c")]
        Dw2500c,
        #[serde(rename = "DW3000c")]
        Dw3000c,
        #[serde(rename = "DW6000")]
        Dw6000,
        #[serde(rename = "DW5000c")]
        Dw5000c,
        #[serde(rename = "DW6000c")]
        Dw6000c,
        #[serde(rename = "DW7500c")]
        Dw7500c,
        #[serde(rename = "DW10000c")]
        Dw10000c,
        #[serde(rename = "DW15000c")]
        Dw15000c,
        #[serde(rename = "DW30000c")]
        Dw30000c,
        #[serde(rename = "DS100")]
        Ds100,
        #[serde(rename = "DS200")]
        Ds200,
        #[serde(rename = "DS300")]
        Ds300,
        #[serde(rename = "DS400")]
        Ds400,
        #[serde(rename = "DS500")]
        Ds500,
        #[serde(rename = "DS600")]
        Ds600,
        #[serde(rename = "DS1000")]
        Ds1000,
        #[serde(rename = "DS1200")]
        Ds1200,
        #[serde(rename = "DS1500")]
        Ds1500,
        #[serde(rename = "DS2000")]
        Ds2000,
        ElasticPool,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReadScale {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SampleName {
        #[serde(rename = "AdventureWorksLT")]
        AdventureWorksLt,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseSecurityAlertPolicy {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseSecurityAlertPolicyProperties>,
}
impl DatabaseSecurityAlertPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabaseSecurityAlertPolicyProperties {
    pub state: database_security_alert_policy_properties::State,
    #[serde(rename = "disabledAlerts", default, skip_serializing_if = "Option::is_none")]
    pub disabled_alerts: Option<String>,
    #[serde(rename = "emailAddresses", default, skip_serializing_if = "Option::is_none")]
    pub email_addresses: Option<String>,
    #[serde(rename = "emailAccountAdmins", default, skip_serializing_if = "Option::is_none")]
    pub email_account_admins: Option<database_security_alert_policy_properties::EmailAccountAdmins>,
    #[serde(rename = "storageEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub storage_endpoint: Option<String>,
    #[serde(rename = "storageAccountAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_access_key: Option<String>,
    #[serde(rename = "retentionDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i32>,
    #[serde(rename = "useServerDefault", default, skip_serializing_if = "Option::is_none")]
    pub use_server_default: Option<database_security_alert_policy_properties::UseServerDefault>,
}
impl DatabaseSecurityAlertPolicyProperties {
    pub fn new(state: database_security_alert_policy_properties::State) -> Self {
        Self {
            state,
            disabled_alerts: None,
            email_addresses: None,
            email_account_admins: None,
            storage_endpoint: None,
            storage_account_access_key: None,
            retention_days: None,
            use_server_default: None,
        }
    }
}
pub mod database_security_alert_policy_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        New,
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EmailAccountAdmins {
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UseServerDefault {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatabaseUpdate {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DatabaseProperties>,
}
impl DatabaseUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ElasticPool {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ElasticPoolProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl ElasticPool {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
            kind: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolActivity {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ElasticPoolActivityProperties>,
}
impl ElasticPoolActivity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ElasticPoolActivityListResult {
    pub value: Vec<ElasticPoolActivity>,
}
impl ElasticPoolActivityListResult {
    pub fn new(value: Vec<ElasticPoolActivity>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolActivityProperties {
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "errorSeverity", default, skip_serializing_if = "Option::is_none")]
    pub error_severity: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
    pub operation_id: Option<String>,
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<i32>,
    #[serde(rename = "requestedDatabaseDtuMax", default, skip_serializing_if = "Option::is_none")]
    pub requested_database_dtu_max: Option<i32>,
    #[serde(rename = "requestedDatabaseDtuMin", default, skip_serializing_if = "Option::is_none")]
    pub requested_database_dtu_min: Option<i32>,
    #[serde(rename = "requestedDtu", default, skip_serializing_if = "Option::is_none")]
    pub requested_dtu: Option<i32>,
    #[serde(rename = "requestedElasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub requested_elastic_pool_name: Option<String>,
    #[serde(rename = "requestedStorageLimitInGB", default, skip_serializing_if = "Option::is_none")]
    pub requested_storage_limit_in_gb: Option<i64>,
    #[serde(rename = "elasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub elastic_pool_name: Option<String>,
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "requestedStorageLimitInMB", default, skip_serializing_if = "Option::is_none")]
    pub requested_storage_limit_in_mb: Option<i32>,
    #[serde(rename = "requestedDatabaseDtuGuarantee", default, skip_serializing_if = "Option::is_none")]
    pub requested_database_dtu_guarantee: Option<i32>,
    #[serde(rename = "requestedDatabaseDtuCap", default, skip_serializing_if = "Option::is_none")]
    pub requested_database_dtu_cap: Option<i32>,
    #[serde(rename = "requestedDtuGuarantee", default, skip_serializing_if = "Option::is_none")]
    pub requested_dtu_guarantee: Option<i32>,
}
impl ElasticPoolActivityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolDatabaseActivity {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ElasticPoolDatabaseActivityProperties>,
}
impl ElasticPoolDatabaseActivity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ElasticPoolDatabaseActivityListResult {
    pub value: Vec<ElasticPoolDatabaseActivity>,
}
impl ElasticPoolDatabaseActivityListResult {
    pub fn new(value: Vec<ElasticPoolDatabaseActivity>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolDatabaseActivityProperties {
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "errorSeverity", default, skip_serializing_if = "Option::is_none")]
    pub error_severity: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
    pub operation_id: Option<String>,
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<i32>,
    #[serde(rename = "requestedElasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub requested_elastic_pool_name: Option<String>,
    #[serde(rename = "currentElasticPoolName", default, skip_serializing_if = "Option::is_none")]
    pub current_elastic_pool_name: Option<String>,
    #[serde(rename = "currentServiceObjective", default, skip_serializing_if = "Option::is_none")]
    pub current_service_objective: Option<String>,
    #[serde(rename = "requestedServiceObjective", default, skip_serializing_if = "Option::is_none")]
    pub requested_service_objective: Option<String>,
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}
impl ElasticPoolDatabaseActivityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ElasticPoolListResult {
    pub value: Vec<ElasticPool>,
}
impl ElasticPoolListResult {
    pub fn new(value: Vec<ElasticPool>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolProperties {
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<elastic_pool_properties::State>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub edition: Option<elastic_pool_properties::Edition>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dtu: Option<i32>,
    #[serde(rename = "databaseDtuMax", default, skip_serializing_if = "Option::is_none")]
    pub database_dtu_max: Option<i32>,
    #[serde(rename = "databaseDtuMin", default, skip_serializing_if = "Option::is_none")]
    pub database_dtu_min: Option<i32>,
    #[serde(rename = "storageMB", default, skip_serializing_if = "Option::is_none")]
    pub storage_mb: Option<i32>,
    #[serde(rename = "zoneRedundant", default, skip_serializing_if = "Option::is_none")]
    pub zone_redundant: Option<bool>,
}
impl ElasticPoolProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod elastic_pool_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Creating,
        Ready,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Edition {
        Basic,
        Standard,
        Premium,
        GeneralPurpose,
        BusinessCritical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ElasticPoolUpdate {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ElasticPoolProperties>,
}
impl ElasticPoolUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportRequest {
    #[serde(rename = "storageKeyType")]
    pub storage_key_type: export_request::StorageKeyType,
    #[serde(rename = "storageKey")]
    pub storage_key: String,
    #[serde(rename = "storageUri")]
    pub storage_uri: String,
    #[serde(rename = "administratorLogin")]
    pub administrator_login: String,
    #[serde(rename = "administratorLoginPassword")]
    pub administrator_login_password: String,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<export_request::AuthenticationType>,
}
impl ExportRequest {
    pub fn new(
        storage_key_type: export_request::StorageKeyType,
        storage_key: String,
        storage_uri: String,
        administrator_login: String,
        administrator_login_password: String,
    ) -> Self {
        Self {
            storage_key_type,
            storage_key,
            storage_uri,
            administrator_login,
            administrator_login_password,
            authentication_type: None,
        }
    }
}
pub mod export_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageKeyType {
        StorageAccessKey,
        SharedAccessKey,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        #[serde(rename = "SQL")]
        Sql,
        #[serde(rename = "ADPassword")]
        AdPassword,
    }
    impl Default for AuthenticationType {
        fn default() -> Self {
            Self::Sql
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FirewallRuleProperties>,
}
impl FirewallRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FirewallRule>,
}
impl FirewallRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallRuleProperties {
    #[serde(rename = "startIpAddress")]
    pub start_ip_address: String,
    #[serde(rename = "endIpAddress")]
    pub end_ip_address: String,
}
impl FirewallRuleProperties {
    pub fn new(start_ip_address: String, end_ip_address: String) -> Self {
        Self {
            start_ip_address,
            end_ip_address,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportExportResponse {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ImportExportResponseProperties>,
}
impl ImportExportResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportExportResponseProperties {
    #[serde(rename = "requestType", default, skip_serializing_if = "Option::is_none")]
    pub request_type: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "lastModifiedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<String>,
    #[serde(rename = "queuedTime", default, skip_serializing_if = "Option::is_none")]
    pub queued_time: Option<String>,
    #[serde(rename = "blobUri", default, skip_serializing_if = "Option::is_none")]
    pub blob_uri: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}
impl ImportExportResponseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportExtensionProperties {
    #[serde(flatten)]
    pub export_request: ExportRequest,
    #[serde(rename = "operationMode")]
    pub operation_mode: import_extension_properties::OperationMode,
}
impl ImportExtensionProperties {
    pub fn new(export_request: ExportRequest, operation_mode: import_extension_properties::OperationMode) -> Self {
        Self {
            export_request,
            operation_mode,
        }
    }
}
pub mod import_extension_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationMode {
        Import,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImportExtensionRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ImportExtensionProperties>,
}
impl ImportExtensionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportRequest {
    #[serde(flatten)]
    pub export_request: ExportRequest,
    #[serde(rename = "databaseName")]
    pub database_name: String,
    pub edition: import_request::Edition,
    #[serde(rename = "serviceObjectiveName")]
    pub service_objective_name: import_request::ServiceObjectiveName,
    #[serde(rename = "maxSizeBytes")]
    pub max_size_bytes: String,
}
impl ImportRequest {
    pub fn new(
        export_request: ExportRequest,
        database_name: String,
        edition: import_request::Edition,
        service_objective_name: import_request::ServiceObjectiveName,
        max_size_bytes: String,
    ) -> Self {
        Self {
            export_request,
            database_name,
            edition,
            service_objective_name,
            max_size_bytes,
        }
    }
}
pub mod import_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Edition {
        Web,
        Business,
        Basic,
        Standard,
        Premium,
        #[serde(rename = "PremiumRS")]
        PremiumRs,
        Free,
        Stretch,
        DataWarehouse,
        System,
        System2,
        GeneralPurpose,
        BusinessCritical,
        Hyperscale,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceObjectiveName {
        System,
        System0,
        System1,
        System2,
        System3,
        System4,
        System2L,
        System3L,
        System4L,
        Free,
        Basic,
        S0,
        S1,
        S2,
        S3,
        S4,
        S6,
        S7,
        S9,
        S12,
        P1,
        P2,
        P3,
        P4,
        P6,
        P11,
        P15,
        #[serde(rename = "PRS1")]
        Prs1,
        #[serde(rename = "PRS2")]
        Prs2,
        #[serde(rename = "PRS4")]
        Prs4,
        #[serde(rename = "PRS6")]
        Prs6,
        #[serde(rename = "DW100")]
        Dw100,
        #[serde(rename = "DW200")]
        Dw200,
        #[serde(rename = "DW300")]
        Dw300,
        #[serde(rename = "DW400")]
        Dw400,
        #[serde(rename = "DW500")]
        Dw500,
        #[serde(rename = "DW600")]
        Dw600,
        #[serde(rename = "DW1000")]
        Dw1000,
        #[serde(rename = "DW1200")]
        Dw1200,
        #[serde(rename = "DW1000c")]
        Dw1000c,
        #[serde(rename = "DW1500")]
        Dw1500,
        #[serde(rename = "DW1500c")]
        Dw1500c,
        #[serde(rename = "DW2000")]
        Dw2000,
        #[serde(rename = "DW2000c")]
        Dw2000c,
        #[serde(rename = "DW3000")]
        Dw3000,
        #[serde(rename = "DW2500c")]
        Dw2500c,
        #[serde(rename = "DW3000c")]
        Dw3000c,
        #[serde(rename = "DW6000")]
        Dw6000,
        #[serde(rename = "DW5000c")]
        Dw5000c,
        #[serde(rename = "DW6000c")]
        Dw6000c,
        #[serde(rename = "DW7500c")]
        Dw7500c,
        #[serde(rename = "DW10000c")]
        Dw10000c,
        #[serde(rename = "DW15000c")]
        Dw15000c,
        #[serde(rename = "DW30000c")]
        Dw30000c,
        #[serde(rename = "DS100")]
        Ds100,
        #[serde(rename = "DS200")]
        Ds200,
        #[serde(rename = "DS300")]
        Ds300,
        #[serde(rename = "DS400")]
        Ds400,
        #[serde(rename = "DS500")]
        Ds500,
        #[serde(rename = "DS600")]
        Ds600,
        #[serde(rename = "DS1000")]
        Ds1000,
        #[serde(rename = "DS1200")]
        Ds1200,
        #[serde(rename = "DS1500")]
        Ds1500,
        #[serde(rename = "DS2000")]
        Ds2000,
        ElasticPool,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationImpact {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "changeValueAbsolute", default, skip_serializing_if = "Option::is_none")]
    pub change_value_absolute: Option<f64>,
    #[serde(rename = "changeValueRelative", default, skip_serializing_if = "Option::is_none")]
    pub change_value_relative: Option<f64>,
}
impl OperationImpact {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendedElasticPool {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecommendedElasticPoolProperties>,
}
impl RecommendedElasticPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecommendedElasticPoolListMetricsResult {
    pub value: Vec<RecommendedElasticPoolMetric>,
}
impl RecommendedElasticPoolListMetricsResult {
    pub fn new(value: Vec<RecommendedElasticPoolMetric>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecommendedElasticPoolListResult {
    pub value: Vec<RecommendedElasticPool>,
}
impl RecommendedElasticPoolListResult {
    pub fn new(value: Vec<RecommendedElasticPool>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendedElasticPoolMetric {
    #[serde(rename = "dateTime", default, skip_serializing_if = "Option::is_none")]
    pub date_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dtu: Option<f64>,
    #[serde(rename = "sizeGB", default, skip_serializing_if = "Option::is_none")]
    pub size_gb: Option<f64>,
}
impl RecommendedElasticPoolMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendedElasticPoolProperties {
    #[serde(rename = "databaseEdition", default, skip_serializing_if = "Option::is_none")]
    pub database_edition: Option<recommended_elastic_pool_properties::DatabaseEdition>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dtu: Option<f64>,
    #[serde(rename = "databaseDtuMin", default, skip_serializing_if = "Option::is_none")]
    pub database_dtu_min: Option<f64>,
    #[serde(rename = "databaseDtuMax", default, skip_serializing_if = "Option::is_none")]
    pub database_dtu_max: Option<f64>,
    #[serde(rename = "storageMB", default, skip_serializing_if = "Option::is_none")]
    pub storage_mb: Option<f64>,
    #[serde(rename = "observationPeriodStart", default, skip_serializing_if = "Option::is_none")]
    pub observation_period_start: Option<String>,
    #[serde(rename = "observationPeriodEnd", default, skip_serializing_if = "Option::is_none")]
    pub observation_period_end: Option<String>,
    #[serde(rename = "maxObservedDtu", default, skip_serializing_if = "Option::is_none")]
    pub max_observed_dtu: Option<f64>,
    #[serde(rename = "maxObservedStorageMB", default, skip_serializing_if = "Option::is_none")]
    pub max_observed_storage_mb: Option<f64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub databases: Vec<Database>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metrics: Vec<RecommendedElasticPoolMetric>,
}
impl RecommendedElasticPoolProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recommended_elastic_pool_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DatabaseEdition {
        Basic,
        Standard,
        Premium,
        GeneralPurpose,
        BusinessCritical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendedIndex {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecommendedIndexProperties>,
}
impl RecommendedIndex {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecommendedIndexProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<recommended_index_properties::Action>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<recommended_index_properties::State>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(rename = "indexType", default, skip_serializing_if = "Option::is_none")]
    pub index_type: Option<recommended_index_properties::IndexType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<String>,
    #[serde(rename = "includedColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub included_columns: Vec<String>,
    #[serde(rename = "indexScript", default, skip_serializing_if = "Option::is_none")]
    pub index_script: Option<String>,
    #[serde(rename = "estimatedImpact", default, skip_serializing_if = "Vec::is_empty")]
    pub estimated_impact: Vec<OperationImpact>,
    #[serde(rename = "reportedImpact", default, skip_serializing_if = "Vec::is_empty")]
    pub reported_impact: Vec<OperationImpact>,
}
impl RecommendedIndexProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recommended_index_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Create,
        Drop,
        Rebuild,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Active,
        Pending,
        Executing,
        Verifying,
        #[serde(rename = "Pending Revert")]
        PendingRevert,
        Reverting,
        Reverted,
        Ignored,
        Expired,
        Blocked,
        Success,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IndexType {
        #[serde(rename = "CLUSTERED")]
        Clustered,
        #[serde(rename = "NONCLUSTERED")]
        Nonclustered,
        #[serde(rename = "COLUMNSTORE")]
        Columnstore,
        #[serde(rename = "CLUSTERED COLUMNSTORE")]
        ClusteredColumnstore,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationLink {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReplicationLinkProperties>,
}
impl ReplicationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationLinkListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReplicationLink>,
}
impl ReplicationLinkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationLinkProperties {
    #[serde(rename = "isTerminationAllowed", default, skip_serializing_if = "Option::is_none")]
    pub is_termination_allowed: Option<bool>,
    #[serde(rename = "replicationMode", default, skip_serializing_if = "Option::is_none")]
    pub replication_mode: Option<String>,
    #[serde(rename = "partnerServer", default, skip_serializing_if = "Option::is_none")]
    pub partner_server: Option<String>,
    #[serde(rename = "partnerDatabase", default, skip_serializing_if = "Option::is_none")]
    pub partner_database: Option<String>,
    #[serde(rename = "partnerLocation", default, skip_serializing_if = "Option::is_none")]
    pub partner_location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub role: Option<replication_link_properties::Role>,
    #[serde(rename = "partnerRole", default, skip_serializing_if = "Option::is_none")]
    pub partner_role: Option<replication_link_properties::PartnerRole>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<i32>,
    #[serde(rename = "replicationState", default, skip_serializing_if = "Option::is_none")]
    pub replication_state: Option<replication_link_properties::ReplicationState>,
}
impl ReplicationLinkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod replication_link_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Role {
        Primary,
        Secondary,
        NonReadableSecondary,
        Source,
        Copy,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PartnerRole {
        Primary,
        Secondary,
        NonReadableSecondary,
        Source,
        Copy,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReplicationState {
        #[serde(rename = "PENDING")]
        Pending,
        #[serde(rename = "SEEDING")]
        Seeding,
        #[serde(rename = "CATCH_UP")]
        CatchUp,
        #[serde(rename = "SUSPENDED")]
        Suspended,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTierAdvisor {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceTierAdvisorProperties>,
}
impl ServiceTierAdvisor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceTierAdvisorListResult {
    pub value: Vec<ServiceTierAdvisor>,
}
impl ServiceTierAdvisorListResult {
    pub fn new(value: Vec<ServiceTierAdvisor>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTierAdvisorProperties {
    #[serde(rename = "observationPeriodStart", default, skip_serializing_if = "Option::is_none")]
    pub observation_period_start: Option<String>,
    #[serde(rename = "observationPeriodEnd", default, skip_serializing_if = "Option::is_none")]
    pub observation_period_end: Option<String>,
    #[serde(rename = "activeTimeRatio", default, skip_serializing_if = "Option::is_none")]
    pub active_time_ratio: Option<f64>,
    #[serde(rename = "minDtu", default, skip_serializing_if = "Option::is_none")]
    pub min_dtu: Option<f64>,
    #[serde(rename = "avgDtu", default, skip_serializing_if = "Option::is_none")]
    pub avg_dtu: Option<f64>,
    #[serde(rename = "maxDtu", default, skip_serializing_if = "Option::is_none")]
    pub max_dtu: Option<f64>,
    #[serde(rename = "maxSizeInGB", default, skip_serializing_if = "Option::is_none")]
    pub max_size_in_gb: Option<f64>,
    #[serde(rename = "serviceLevelObjectiveUsageMetrics", default, skip_serializing_if = "Vec::is_empty")]
    pub service_level_objective_usage_metrics: Vec<SloUsageMetric>,
    #[serde(rename = "currentServiceLevelObjective", default, skip_serializing_if = "Option::is_none")]
    pub current_service_level_objective: Option<String>,
    #[serde(rename = "currentServiceLevelObjectiveId", default, skip_serializing_if = "Option::is_none")]
    pub current_service_level_objective_id: Option<String>,
    #[serde(
        rename = "usageBasedRecommendationServiceLevelObjective",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub usage_based_recommendation_service_level_objective: Option<String>,
    #[serde(
        rename = "usageBasedRecommendationServiceLevelObjectiveId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub usage_based_recommendation_service_level_objective_id: Option<String>,
    #[serde(
        rename = "databaseSizeBasedRecommendationServiceLevelObjective",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub database_size_based_recommendation_service_level_objective: Option<String>,
    #[serde(
        rename = "databaseSizeBasedRecommendationServiceLevelObjectiveId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub database_size_based_recommendation_service_level_objective_id: Option<String>,
    #[serde(
        rename = "disasterPlanBasedRecommendationServiceLevelObjective",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub disaster_plan_based_recommendation_service_level_objective: Option<String>,
    #[serde(
        rename = "disasterPlanBasedRecommendationServiceLevelObjectiveId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub disaster_plan_based_recommendation_service_level_objective_id: Option<String>,
    #[serde(
        rename = "overallRecommendationServiceLevelObjective",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub overall_recommendation_service_level_objective: Option<String>,
    #[serde(
        rename = "overallRecommendationServiceLevelObjectiveId",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub overall_recommendation_service_level_objective_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub confidence: Option<f64>,
}
impl ServiceTierAdvisorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SloUsageMetric {
    #[serde(rename = "serviceLevelObjective", default, skip_serializing_if = "Option::is_none")]
    pub service_level_objective: Option<slo_usage_metric::ServiceLevelObjective>,
    #[serde(rename = "serviceLevelObjectiveId", default, skip_serializing_if = "Option::is_none")]
    pub service_level_objective_id: Option<String>,
    #[serde(rename = "inRangeTimeRatio", default, skip_serializing_if = "Option::is_none")]
    pub in_range_time_ratio: Option<f64>,
}
impl SloUsageMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod slo_usage_metric {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceLevelObjective {
        System,
        System0,
        System1,
        System2,
        System3,
        System4,
        System2L,
        System3L,
        System4L,
        Free,
        Basic,
        S0,
        S1,
        S2,
        S3,
        S4,
        S6,
        S7,
        S9,
        S12,
        P1,
        P2,
        P3,
        P4,
        P6,
        P11,
        P15,
        #[serde(rename = "PRS1")]
        Prs1,
        #[serde(rename = "PRS2")]
        Prs2,
        #[serde(rename = "PRS4")]
        Prs4,
        #[serde(rename = "PRS6")]
        Prs6,
        #[serde(rename = "DW100")]
        Dw100,
        #[serde(rename = "DW200")]
        Dw200,
        #[serde(rename = "DW300")]
        Dw300,
        #[serde(rename = "DW400")]
        Dw400,
        #[serde(rename = "DW500")]
        Dw500,
        #[serde(rename = "DW600")]
        Dw600,
        #[serde(rename = "DW1000")]
        Dw1000,
        #[serde(rename = "DW1200")]
        Dw1200,
        #[serde(rename = "DW1000c")]
        Dw1000c,
        #[serde(rename = "DW1500")]
        Dw1500,
        #[serde(rename = "DW1500c")]
        Dw1500c,
        #[serde(rename = "DW2000")]
        Dw2000,
        #[serde(rename = "DW2000c")]
        Dw2000c,
        #[serde(rename = "DW3000")]
        Dw3000,
        #[serde(rename = "DW2500c")]
        Dw2500c,
        #[serde(rename = "DW3000c")]
        Dw3000c,
        #[serde(rename = "DW6000")]
        Dw6000,
        #[serde(rename = "DW5000c")]
        Dw5000c,
        #[serde(rename = "DW6000c")]
        Dw6000c,
        #[serde(rename = "DW7500c")]
        Dw7500c,
        #[serde(rename = "DW10000c")]
        Dw10000c,
        #[serde(rename = "DW15000c")]
        Dw15000c,
        #[serde(rename = "DW30000c")]
        Dw30000c,
        #[serde(rename = "DS100")]
        Ds100,
        #[serde(rename = "DS200")]
        Ds200,
        #[serde(rename = "DS300")]
        Ds300,
        #[serde(rename = "DS400")]
        Ds400,
        #[serde(rename = "DS500")]
        Ds500,
        #[serde(rename = "DS600")]
        Ds600,
        #[serde(rename = "DS1000")]
        Ds1000,
        #[serde(rename = "DS1200")]
        Ds1200,
        #[serde(rename = "DS1500")]
        Ds1500,
        #[serde(rename = "DS2000")]
        Ds2000,
        ElasticPool,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransparentDataEncryption {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TransparentDataEncryptionProperties>,
}
impl TransparentDataEncryption {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransparentDataEncryptionActivity {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TransparentDataEncryptionActivityProperties>,
}
impl TransparentDataEncryptionActivity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TransparentDataEncryptionActivityListResult {
    pub value: Vec<TransparentDataEncryptionActivity>,
}
impl TransparentDataEncryptionActivityListResult {
    pub fn new(value: Vec<TransparentDataEncryptionActivity>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransparentDataEncryptionActivityProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<transparent_data_encryption_activity_properties::Status>,
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<f32>,
}
impl TransparentDataEncryptionActivityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod transparent_data_encryption_activity_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Encrypting,
        Decrypting,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TransparentDataEncryptionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<transparent_data_encryption_properties::Status>,
}
impl TransparentDataEncryptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod transparent_data_encryption_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UnlinkParameters {
    #[serde(rename = "forcedTermination", default, skip_serializing_if = "Option::is_none")]
    pub forced_termination: Option<bool>,
}
impl UnlinkParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
