#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Represents AAD (Azure Active Directory) data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AadDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[doc = "AAD (Azure Active Directory) data connector properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AadDataConnectorProperties>,
}
impl AadDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[doc = "AAD (Azure Active Directory) data connector properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadDataConnectorProperties {
    #[doc = "The tenant id to connect to, and get the data from."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "Alerts data type for data connectors."]
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl AadDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents AATP (Azure Advanced Threat Protection) data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AatpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[doc = "AATP (Azure Advanced Threat Protection) data connector properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AatpDataConnectorProperties>,
}
impl AatpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[doc = "AATP (Azure Advanced Threat Protection) data connector properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AatpDataConnectorProperties {
    #[doc = "The tenant id to connect to, and get the data from."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "Alerts data type for data connectors."]
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl AatpDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents ASC (Azure Security Center) data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AscDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[doc = "ASC (Azure Security Center) data connector properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AscDataConnectorProperties>,
}
impl AscDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[doc = "ASC (Azure Security Center) data connector properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
    #[doc = "The subscription id to connect to, and get the data from."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
}
impl AscDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Action property bag base."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionPropertiesBase {
    #[doc = "Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}."]
    #[serde(rename = "logicAppResourceId")]
    pub logic_app_resource_id: String,
}
impl ActionPropertiesBase {
    pub fn new(logic_app_resource_id: String) -> Self {
        Self { logic_app_resource_id }
    }
}
#[doc = "Action for alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActionRequest {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[doc = "Action property bag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActionRequestProperties>,
}
impl ActionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Action property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionRequestProperties {
    #[serde(flatten)]
    pub action_properties_base: ActionPropertiesBase,
    #[doc = "Logic App Callback URL for this specific workflow."]
    #[serde(rename = "triggerUri")]
    pub trigger_uri: String,
}
impl ActionRequestProperties {
    pub fn new(action_properties_base: ActionPropertiesBase, trigger_uri: String) -> Self {
        Self {
            action_properties_base,
            trigger_uri,
        }
    }
}
#[doc = "Action for alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActionResponse {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Etag of the action."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Action property bag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActionResponseProperties>,
}
impl ActionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Action property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionResponseProperties {
    #[serde(flatten)]
    pub action_properties_base: ActionPropertiesBase,
    #[doc = "The name of the logic app's workflow."]
    #[serde(rename = "workflowId", default, skip_serializing_if = "Option::is_none")]
    pub workflow_id: Option<String>,
}
impl ActionResponseProperties {
    pub fn new(action_properties_base: ActionPropertiesBase) -> Self {
        Self {
            action_properties_base,
            workflow_id: None,
        }
    }
}
#[doc = "List all the actions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionsList {
    #[doc = "URL to fetch the next set of actions."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of actions."]
    pub value: Vec<ActionResponse>,
}
impl ActionsList {
    pub fn new(value: Vec<ActionResponse>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "Alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRule {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[doc = "The kind of the alert rule"]
    pub kind: AlertRuleKind,
}
impl AlertRule {
    pub fn new(kind: AlertRuleKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[doc = "The kind of the alert rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleKind {
    Scheduled,
    MicrosoftSecurityIncidentCreation,
    Fusion,
}
#[doc = "Alert rule template."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleTemplate {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The kind of the alert rule"]
    pub kind: AlertRuleKind,
}
impl AlertRuleTemplate {
    pub fn new(kind: AlertRuleKind) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
#[doc = "alert rule template data sources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRuleTemplateDataSource {
    #[doc = "The connector id that provides the following data types"]
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[doc = "The data types used by the alert rule template"]
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub data_types: Vec<String>,
}
impl AlertRuleTemplateDataSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The alert rule template status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleTemplateStatus {
    Installed,
    Available,
    NotAvailable,
}
#[doc = "List all the alert rule templates."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleTemplatesList {
    #[doc = "URL to fetch the next set of alert rule templates."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of alert rule templates."]
    pub value: Vec<AlertRuleTemplate>,
}
impl AlertRuleTemplatesList {
    pub fn new(value: Vec<AlertRuleTemplate>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "The operation against the threshold that triggers alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleTriggerOperator {
    GreaterThan,
    LessThan,
    Equal,
    NotEqual,
}
#[doc = "List all the alert rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRulesList {
    #[doc = "URL to fetch the next set of alert rules."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of alert rules."]
    pub value: Vec<AlertRule>,
}
impl AlertRulesList {
    pub fn new(value: Vec<AlertRule>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "The severity of the alert"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertSeverity {
    High,
    Medium,
    Low,
    Informational,
}
#[doc = "Alerts data type for data connectors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertsDataTypeOfDataConnector {
    #[doc = "Common field for data type in data connectors."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub alerts: Option<DataConnectorDataTypeCommon>,
}
impl AlertsDataTypeOfDataConnector {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The severity for alerts created by this alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AttackTactic {
    InitialAccess,
    Execution,
    Persistence,
    PrivilegeEscalation,
    DefenseEvasion,
    CredentialAccess,
    Discovery,
    LateralMovement,
    Collection,
    Exfiltration,
    CommandAndControl,
    Impact,
}
#[doc = "Represents Amazon Web Services CloudTrail data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsCloudTrailDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[doc = "Amazon Web Services CloudTrail data connector properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AwsCloudTrailDataConnectorProperties>,
}
impl AwsCloudTrailDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[doc = "The available data types for Amazon Web Services CloudTrail data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AwsCloudTrailDataConnectorDataTypes {
    #[doc = "Logs data type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub logs: Option<serde_json::Value>,
}
impl AwsCloudTrailDataConnectorDataTypes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Amazon Web Services CloudTrail data connector properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AwsCloudTrailDataConnectorProperties {
    #[doc = "The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account."]
    #[serde(rename = "awsRoleArn", default, skip_serializing_if = "Option::is_none")]
    pub aws_role_arn: Option<String>,
    #[doc = "The available data types for Amazon Web Services CloudTrail data connector."]
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AwsCloudTrailDataConnectorDataTypes>,
}
impl AwsCloudTrailDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a bookmark in Azure Security Insights."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Bookmark {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[doc = "Describes bookmark properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BookmarkProperties>,
}
impl Bookmark {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List all the bookmarks."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BookmarkList {
    #[doc = "URL to fetch the next set of cases."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of bookmarks."]
    pub value: Vec<Bookmark>,
}
impl BookmarkList {
    pub fn new(value: Vec<Bookmark>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "Describes bookmark properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BookmarkProperties {
    #[doc = "The time the bookmark was created"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[doc = "User information that made some action"]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[doc = "The display name of the bookmark"]
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[doc = "List of labels relevant to this bookmark"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<Label>,
    #[doc = "The notes of the bookmark"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    #[doc = "The query of the bookmark."]
    pub query: String,
    #[doc = "The query result of the bookmark."]
    #[serde(rename = "queryResult", default, skip_serializing_if = "Option::is_none")]
    pub query_result: Option<String>,
    #[doc = "The last time the bookmark was updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[doc = "User information that made some action"]
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<UserInfo>,
    #[doc = "The bookmark event time"]
    #[serde(rename = "eventTime", default, skip_serializing_if = "Option::is_none")]
    pub event_time: Option<String>,
    #[doc = "The start time for the query"]
    #[serde(rename = "queryStartTime", default, skip_serializing_if = "Option::is_none")]
    pub query_start_time: Option<String>,
    #[doc = "The end time for the query"]
    #[serde(rename = "queryEndTime", default, skip_serializing_if = "Option::is_none")]
    pub query_end_time: Option<String>,
    #[doc = "Describes related incident information for the bookmark"]
    #[serde(rename = "incidentInfo", default, skip_serializing_if = "Option::is_none")]
    pub incident_info: Option<IncidentInfo>,
}
impl BookmarkProperties {
    pub fn new(display_name: String, query: String) -> Self {
        Self {
            created: None,
            created_by: None,
            display_name,
            labels: Vec::new(),
            notes: None,
            query,
            query_result: None,
            updated: None,
            updated_by: None,
            event_time: None,
            query_start_time: None,
            query_end_time: None,
            incident_info: None,
        }
    }
}
#[doc = "Information on the client (user or application) that made some action"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientInfo {
    #[doc = "The email of the client."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[doc = "The name of the client."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The object id of the client."]
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[doc = "The user principal name of the client."]
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
}
impl ClientInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response for a resource management request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnector {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[doc = "The kind of the data connector"]
    pub kind: DataConnectorKind,
}
impl DataConnector {
    pub fn new(kind: DataConnectorKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[doc = "Common field for data type in data connectors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorDataTypeCommon {
    #[doc = "Describe whether this data type connection is enabled or not."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<data_connector_data_type_common::State>,
}
impl DataConnectorDataTypeCommon {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_connector_data_type_common {
    use super::*;
    #[doc = "Describe whether this data type connection is enabled or not."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
}
#[doc = "The kind of the data connector"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DataConnectorKind {
    AzureActiveDirectory,
    AzureSecurityCenter,
    MicrosoftCloudAppSecurity,
    ThreatIntelligence,
    Office365,
    AmazonWebServicesCloudTrail,
    AzureAdvancedThreatProtection,
    MicrosoftDefenderAdvancedThreatProtection,
}
#[doc = "List all the data connectors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnectorList {
    #[doc = "URL to fetch the next set of data connectors."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of data connectors."]
    pub value: Vec<DataConnector>,
}
impl DataConnectorList {
    pub fn new(value: Vec<DataConnector>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "Properties data connector on tenant level."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorTenantId {
    #[doc = "The tenant id to connect to, and get the data from."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl DataConnectorTenantId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Data connector properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorWithAlertsProperties {
    #[doc = "Alerts data type for data connectors."]
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl DataConnectorWithAlertsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorResponse>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents Fusion alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[doc = "Fusion alert rule base property bag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FusionAlertRuleProperties>,
}
impl FusionAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[doc = "Fusion alert rule base property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRuleProperties {
    #[doc = "The Name of the alert rule template used to create this rule."]
    #[serde(rename = "alertRuleTemplateName")]
    pub alert_rule_template_name: String,
    #[doc = "The description of the alert rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The display name for alerts created by this alert rule."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Determines whether this alert rule is enabled or disabled."]
    pub enabled: bool,
    #[doc = "The last time that this alert has been modified."]
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[doc = "The severity of the alert"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[doc = "The tactics of the alert rule"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl FusionAlertRuleProperties {
    pub fn new(alert_rule_template_name: String, enabled: bool) -> Self {
        Self {
            alert_rule_template_name,
            description: None,
            display_name: None,
            enabled,
            last_modified_utc: None,
            severity: None,
            tactics: Vec::new(),
        }
    }
}
#[doc = "Represents Fusion alert rule template."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[doc = "Represents Fusion alert rule template properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FusionAlertRuleTemplateProperties>,
}
impl FusionAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
#[doc = "Represents Fusion alert rule template properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FusionAlertRuleTemplateProperties {
    #[doc = "the number of alert rules that were created by this template"]
    #[serde(rename = "alertRulesCreatedByTemplateCount", default, skip_serializing_if = "Option::is_none")]
    pub alert_rules_created_by_template_count: Option<i32>,
    #[doc = "The time that this alert rule template has been added."]
    #[serde(rename = "createdDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub created_date_utc: Option<String>,
    #[doc = "The description of the alert rule template."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The display name for alert rule template."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The time that this alert rule template was last updated."]
    #[serde(rename = "lastUpdatedDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_date_utc: Option<String>,
    #[doc = "The required data connectors for this template"]
    #[serde(rename = "requiredDataConnectors", default, skip_serializing_if = "Vec::is_empty")]
    pub required_data_connectors: Vec<AlertRuleTemplateDataSource>,
    #[doc = "The alert rule template status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<AlertRuleTemplateStatus>,
    #[doc = "The severity of the alert"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[doc = "The tactics of the alert rule template"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl FusionAlertRuleTemplateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents an incident in Azure Security Insights."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Incident {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[doc = "Describes incident properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IncidentProperties>,
}
impl Incident {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Incident additional data property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentAdditionalData {
    #[doc = "The number of alerts in the incident"]
    #[serde(rename = "alertsCount", default, skip_serializing_if = "Option::is_none")]
    pub alerts_count: Option<i32>,
    #[doc = "The number of bookmarks in the incident"]
    #[serde(rename = "bookmarksCount", default, skip_serializing_if = "Option::is_none")]
    pub bookmarks_count: Option<i32>,
    #[doc = "The number of comments in the incident"]
    #[serde(rename = "commentsCount", default, skip_serializing_if = "Option::is_none")]
    pub comments_count: Option<i32>,
    #[doc = "List of product names of alerts in the incident"]
    #[serde(rename = "alertProductNames", default, skip_serializing_if = "Vec::is_empty")]
    pub alert_product_names: Vec<String>,
    #[doc = "The tactics associated with incident"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl IncidentAdditionalData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents an incident comment"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentComment {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Incident comment property bag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IncidentCommentProperties>,
}
impl IncidentComment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of incident comments."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentCommentList {
    #[doc = "URL to fetch the next set of comments."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of comments."]
    pub value: Vec<IncidentComment>,
}
impl IncidentCommentList {
    pub fn new(value: Vec<IncidentComment>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "Incident comment property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentCommentProperties {
    #[doc = "The time the comment was created"]
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[doc = "The comment message"]
    pub message: String,
    #[doc = "Information on the client (user or application) that made some action"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<ClientInfo>,
}
impl IncidentCommentProperties {
    pub fn new(message: String) -> Self {
        Self {
            created_time_utc: None,
            message,
            author: None,
        }
    }
}
#[doc = "Describes related incident information for the bookmark"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentInfo {
    #[doc = "Incident Id"]
    #[serde(rename = "incidentId", default, skip_serializing_if = "Option::is_none")]
    pub incident_id: Option<String>,
    #[doc = "The severity of the incident"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<IncidentSeverityEnum>,
    #[doc = "The title of the incident"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[doc = "Relation Name"]
    #[serde(rename = "relationName", default, skip_serializing_if = "Option::is_none")]
    pub relation_name: Option<String>,
}
impl IncidentInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents an incident label"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentLabel {
    #[doc = "The name of the label"]
    #[serde(rename = "labelName")]
    pub label_name: String,
    #[doc = "The type of the label"]
    #[serde(rename = "labelType", default, skip_serializing_if = "Option::is_none")]
    pub label_type: Option<incident_label::LabelType>,
}
impl IncidentLabel {
    pub fn new(label_name: String) -> Self {
        Self {
            label_name,
            label_type: None,
        }
    }
}
pub mod incident_label {
    use super::*;
    #[doc = "The type of the label"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LabelType {
        User,
        System,
    }
}
#[doc = "List all the incidents."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentList {
    #[doc = "URL to fetch the next set of incidents."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of incidents."]
    pub value: Vec<Incident>,
}
impl IncidentList {
    pub fn new(value: Vec<Incident>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "Information on the user an incident is assigned to"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentOwnerInfo {
    #[doc = "The email of the user the incident is assigned to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[doc = "The name of the user the incident is assigned to."]
    #[serde(rename = "assignedTo", default, skip_serializing_if = "Option::is_none")]
    pub assigned_to: Option<String>,
    #[doc = "The object id of the user the incident is assigned to."]
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[doc = "The user principal name of the user the incident is assigned to."]
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
}
impl IncidentOwnerInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes incident properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentProperties {
    #[doc = "Incident additional data property bag."]
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<IncidentAdditionalData>,
    #[doc = "The reason the incident was closed"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub classification: Option<incident_properties::Classification>,
    #[doc = "Describes the reason the incident was closed"]
    #[serde(rename = "classificationComment", default, skip_serializing_if = "Option::is_none")]
    pub classification_comment: Option<String>,
    #[doc = "The classification reason the incident was closed with"]
    #[serde(rename = "classificationReason", default, skip_serializing_if = "Option::is_none")]
    pub classification_reason: Option<incident_properties::ClassificationReason>,
    #[doc = "The time the incident was created"]
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[doc = "The description of the incident"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The time of the first activity in the incident"]
    #[serde(rename = "firstActivityTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub first_activity_time_utc: Option<String>,
    #[doc = "The deep-link url to the incident in Azure portal"]
    #[serde(rename = "incidentUrl", default, skip_serializing_if = "Option::is_none")]
    pub incident_url: Option<String>,
    #[doc = "A sequential number"]
    #[serde(rename = "incidentNumber", default, skip_serializing_if = "Option::is_none")]
    pub incident_number: Option<i32>,
    #[doc = "List of labels relevant to this incident"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<IncidentLabel>,
    #[doc = "The time of the last activity in the incident"]
    #[serde(rename = "lastActivityTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_activity_time_utc: Option<String>,
    #[doc = "The last time the incident was updated"]
    #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time_utc: Option<String>,
    #[doc = "Information on the user an incident is assigned to"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub owner: Option<IncidentOwnerInfo>,
    #[doc = "List of resource ids of Analytic rules related to the incident"]
    #[serde(rename = "relatedAnalyticRuleIds", default, skip_serializing_if = "Vec::is_empty")]
    pub related_analytic_rule_ids: Vec<String>,
    #[doc = "The severity of the incident"]
    pub severity: IncidentSeverityEnum,
    #[doc = "The status of the incident"]
    pub status: incident_properties::Status,
    #[doc = "The title of the incident"]
    pub title: String,
}
impl IncidentProperties {
    pub fn new(severity: IncidentSeverityEnum, status: incident_properties::Status, title: String) -> Self {
        Self {
            additional_data: None,
            classification: None,
            classification_comment: None,
            classification_reason: None,
            created_time_utc: None,
            description: None,
            first_activity_time_utc: None,
            incident_url: None,
            incident_number: None,
            labels: Vec::new(),
            last_activity_time_utc: None,
            last_modified_time_utc: None,
            owner: None,
            related_analytic_rule_ids: Vec::new(),
            severity,
            status,
            title,
        }
    }
}
pub mod incident_properties {
    use super::*;
    #[doc = "The reason the incident was closed"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Classification {
        Undetermined,
        TruePositive,
        BenignPositive,
        FalsePositive,
    }
    #[doc = "The classification reason the incident was closed with"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ClassificationReason {
        SuspiciousActivity,
        SuspiciousButExpected,
        IncorrectAlertLogic,
        InaccurateData,
    }
    #[doc = "The status of the incident"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        New,
        Active,
        Closed,
    }
}
#[doc = "The severity of the incident"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IncidentSeverityEnum {
    High,
    Medium,
    Low,
    Informational,
}
pub type Label = String;
#[doc = "Represents MCAS (Microsoft Cloud App Security) data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[doc = "MCAS (Microsoft Cloud App Security) data connector properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<McasDataConnectorProperties>,
}
impl McasDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[doc = "The available data types for MCAS (Microsoft Cloud App Security) data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct McasDataConnectorDataTypes {
    #[serde(flatten)]
    pub alerts_data_type_of_data_connector: AlertsDataTypeOfDataConnector,
    #[doc = "Common field for data type in data connectors."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub alerts: Option<DataConnectorDataTypeCommon>,
    #[doc = "Common field for data type in data connectors."]
    #[serde(rename = "discoveryLogs", default, skip_serializing_if = "Option::is_none")]
    pub discovery_logs: Option<DataConnectorDataTypeCommon>,
}
impl McasDataConnectorDataTypes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "MCAS (Microsoft Cloud App Security) data connector properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct McasDataConnectorProperties {
    #[doc = "The tenant id to connect to, and get the data from."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The available data types for MCAS (Microsoft Cloud App Security) data connector."]
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<McasDataConnectorDataTypes>,
}
impl McasDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents MDATP (Microsoft Defender Advanced Threat Protection) data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MdatpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[doc = "MDATP (Microsoft Defender Advanced Threat Protection) data connector properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MdatpDataConnectorProperties>,
}
impl MdatpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[doc = "MDATP (Microsoft Defender Advanced Threat Protection) data connector properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MdatpDataConnectorProperties {
    #[doc = "The tenant id to connect to, and get the data from."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "Alerts data type for data connectors."]
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl MdatpDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents MicrosoftSecurityIncidentCreation rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[doc = "MicrosoftSecurityIncidentCreation rule property bag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MicrosoftSecurityIncidentCreationAlertRuleProperties>,
}
impl MicrosoftSecurityIncidentCreationAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[doc = "MicrosoftSecurityIncidentCreation rule common property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleCommonProperties {
    #[doc = "the alerts' displayNames on which the cases will be generated"]
    #[serde(rename = "displayNamesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_filter: Vec<String>,
    #[doc = "the alerts' displayNames on which the cases will not be generated"]
    #[serde(rename = "displayNamesExcludeFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_exclude_filter: Vec<String>,
    #[doc = "The alerts' productName on which the cases will be generated"]
    #[serde(rename = "productFilter")]
    pub product_filter: MicrosoftSecurityProductName,
    #[doc = "the alerts' severities on which the cases will be generated"]
    #[serde(rename = "severitiesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub severities_filter: Vec<AlertSeverity>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleCommonProperties {
    pub fn new(product_filter: MicrosoftSecurityProductName) -> Self {
        Self {
            display_names_filter: Vec::new(),
            display_names_exclude_filter: Vec::new(),
            product_filter,
            severities_filter: Vec::new(),
        }
    }
}
#[doc = "MicrosoftSecurityIncidentCreation rule property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleProperties {
    #[serde(flatten)]
    pub microsoft_security_incident_creation_alert_rule_common_properties: MicrosoftSecurityIncidentCreationAlertRuleCommonProperties,
    #[doc = "The Name of the alert rule template used to create this rule."]
    #[serde(rename = "alertRuleTemplateName", default, skip_serializing_if = "Option::is_none")]
    pub alert_rule_template_name: Option<String>,
    #[doc = "The description of the alert rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The display name for alerts created by this alert rule."]
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[doc = "Determines whether this alert rule is enabled or disabled."]
    pub enabled: bool,
    #[doc = "The last time that this alert has been modified."]
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleProperties {
    pub fn new(
        microsoft_security_incident_creation_alert_rule_common_properties: MicrosoftSecurityIncidentCreationAlertRuleCommonProperties,
        display_name: String,
        enabled: bool,
    ) -> Self {
        Self {
            microsoft_security_incident_creation_alert_rule_common_properties,
            alert_rule_template_name: None,
            description: None,
            display_name,
            enabled,
            last_modified_utc: None,
        }
    }
}
#[doc = "Represents MicrosoftSecurityIncidentCreation rule template."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[doc = "MicrosoftSecurityIncidentCreation rule template properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
#[doc = "MicrosoftSecurityIncidentCreation rule template properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties {
    #[doc = "the number of alert rules that were created by this template"]
    #[serde(rename = "alertRulesCreatedByTemplateCount", default, skip_serializing_if = "Option::is_none")]
    pub alert_rules_created_by_template_count: Option<i32>,
    #[doc = "The time that this alert rule template has been added."]
    #[serde(rename = "createdDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub created_date_utc: Option<String>,
    #[doc = "The description of the alert rule template."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The display name for alert rule template."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The time that this alert rule template was last updated."]
    #[serde(rename = "lastUpdatedDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_date_utc: Option<String>,
    #[doc = "The required data connectors for this template"]
    #[serde(rename = "requiredDataConnectors", default, skip_serializing_if = "Vec::is_empty")]
    pub required_data_connectors: Vec<AlertRuleTemplateDataSource>,
    #[doc = "The alert rule template status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<AlertRuleTemplateStatus>,
    #[doc = "the alerts' displayNames on which the cases will be generated"]
    #[serde(rename = "displayNamesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_filter: Vec<String>,
    #[doc = "the alerts' displayNames on which the cases will not be generated"]
    #[serde(rename = "displayNamesExcludeFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_exclude_filter: Vec<String>,
    #[doc = "The alerts' productName on which the cases will be generated"]
    #[serde(rename = "productFilter")]
    pub product_filter: MicrosoftSecurityProductName,
    #[doc = "the alerts' severities on which the cases will be generated"]
    #[serde(rename = "severitiesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub severities_filter: Vec<AlertSeverity>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties {
    pub fn new(product_filter: MicrosoftSecurityProductName) -> Self {
        Self {
            alert_rules_created_by_template_count: None,
            created_date_utc: None,
            description: None,
            display_name: None,
            last_updated_date_utc: None,
            required_data_connectors: Vec::new(),
            status: None,
            display_names_filter: Vec::new(),
            display_names_exclude_filter: Vec::new(),
            product_filter,
            severities_filter: Vec::new(),
        }
    }
}
#[doc = "The alerts' productName on which the cases will be generated"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum MicrosoftSecurityProductName {
    #[serde(rename = "Microsoft Cloud App Security")]
    MicrosoftCloudAppSecurity,
    #[serde(rename = "Azure Security Center")]
    AzureSecurityCenter,
    #[serde(rename = "Azure Advanced Threat Protection")]
    AzureAdvancedThreatProtection,
    #[serde(rename = "Azure Active Directory Identity Protection")]
    AzureActiveDirectoryIdentityProtection,
    #[serde(rename = "Azure Security Center for IoT")]
    AzureSecurityCenterForIoT,
}
#[doc = "Consent for Office365 tenant that already made."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeConsent {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Consent property bag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeConsentProperties>,
}
impl OfficeConsent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of all the office365 consents."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeConsentList {
    #[doc = "URL to fetch the next set of office consents."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of the consents."]
    pub value: Vec<OfficeConsent>,
}
impl OfficeConsentList {
    pub fn new(value: Vec<OfficeConsent>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "Consent property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeConsentProperties {
    #[doc = "The tenantId of the Office365 with the consent."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The tenant name of the Office365 with the consent."]
    #[serde(rename = "tenantName", default, skip_serializing_if = "Option::is_none")]
    pub tenant_name: Option<String>,
}
impl OfficeConsentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents office data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[doc = "Office data connector properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeDataConnectorProperties>,
}
impl OfficeDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[doc = "The available data types for office data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeDataConnectorDataTypes {
    #[doc = "Exchange data type connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exchange: Option<serde_json::Value>,
    #[doc = "SharePoint data type connection."]
    #[serde(rename = "sharePoint", default, skip_serializing_if = "Option::is_none")]
    pub share_point: Option<serde_json::Value>,
    #[doc = "Teams data type connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub teams: Option<serde_json::Value>,
}
impl OfficeDataConnectorDataTypes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Office data connector properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeDataConnectorProperties {
    #[doc = "The tenant id to connect to, and get the data from."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The available data types for office data connector."]
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<OfficeDataConnectorDataTypes>,
}
impl OfficeDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Operation provided by provider"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Properties of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[doc = "Name of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The origin of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "Properties of the operation"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Description of the operation"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[doc = "Operation name"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "Provider name"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource name"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Lists the operations available in the SecurityInsights RP."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationsList {
    #[doc = "URL to fetch the next set of operations."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "Array of operations"]
    pub value: Vec<Operation>,
}
impl OperationsList {
    pub fn new(value: Vec<Operation>) -> Self {
        Self { next_link: None, value }
    }
}
#[doc = "An azure resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Azure resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Azure resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Azure resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An azure resource object with an Etag property"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceWithEtag {
    #[doc = "Azure resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Azure resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Azure resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Etag of the azure resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ResourceWithEtag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents scheduled alert rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[doc = "Scheduled alert rule base property bag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScheduledAlertRuleProperties>,
}
impl ScheduledAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[doc = "Schedule alert rule template property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduledAlertRuleCommonProperties {
    #[doc = "The query that creates alerts for this rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[doc = "The frequency (in ISO 8601 duration format) for this alert rule to run."]
    #[serde(rename = "queryFrequency", default, skip_serializing_if = "Option::is_none")]
    pub query_frequency: Option<String>,
    #[doc = "The period (in ISO 8601 duration format) that this alert rule looks at."]
    #[serde(rename = "queryPeriod", default, skip_serializing_if = "Option::is_none")]
    pub query_period: Option<String>,
    #[doc = "The severity of the alert"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[doc = "The operation against the threshold that triggers alert rule."]
    #[serde(rename = "triggerOperator", default, skip_serializing_if = "Option::is_none")]
    pub trigger_operator: Option<AlertRuleTriggerOperator>,
    #[doc = "The threshold triggers this alert rule."]
    #[serde(rename = "triggerThreshold", default, skip_serializing_if = "Option::is_none")]
    pub trigger_threshold: Option<i32>,
}
impl ScheduledAlertRuleCommonProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Scheduled alert rule base property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRuleProperties {
    #[serde(flatten)]
    pub scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties,
    #[doc = "The Name of the alert rule template used to create this rule."]
    #[serde(rename = "alertRuleTemplateName", default, skip_serializing_if = "Option::is_none")]
    pub alert_rule_template_name: Option<String>,
    #[doc = "The description of the alert rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The display name for alerts created by this alert rule."]
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[doc = "Determines whether this alert rule is enabled or disabled."]
    pub enabled: bool,
    #[doc = "The last time that this alert rule has been modified."]
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[doc = "The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered."]
    #[serde(rename = "suppressionDuration")]
    pub suppression_duration: String,
    #[doc = "Determines whether the suppression for this alert rule is enabled or disabled."]
    #[serde(rename = "suppressionEnabled")]
    pub suppression_enabled: bool,
    #[doc = "The tactics of the alert rule"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl ScheduledAlertRuleProperties {
    pub fn new(display_name: String, enabled: bool, suppression_duration: String, suppression_enabled: bool) -> Self {
        Self {
            scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties::default(),
            alert_rule_template_name: None,
            description: None,
            display_name,
            enabled,
            last_modified_utc: None,
            suppression_duration,
            suppression_enabled,
            tactics: Vec::new(),
        }
    }
}
#[doc = "Represents scheduled alert rule template."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[doc = "Scheduled alert rule template properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScheduledAlertRuleTemplateProperties>,
}
impl ScheduledAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
#[doc = "Scheduled alert rule template properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduledAlertRuleTemplateProperties {
    #[doc = "the number of alert rules that were created by this template"]
    #[serde(rename = "alertRulesCreatedByTemplateCount", default, skip_serializing_if = "Option::is_none")]
    pub alert_rules_created_by_template_count: Option<i32>,
    #[doc = "The time that this alert rule template has been added."]
    #[serde(rename = "createdDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub created_date_utc: Option<String>,
    #[doc = "The description of the alert rule template."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The display name for alert rule template."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The time that this alert rule template was last updated."]
    #[serde(rename = "lastUpdatedDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_date_utc: Option<String>,
    #[doc = "The required data connectors for this template"]
    #[serde(rename = "requiredDataConnectors", default, skip_serializing_if = "Vec::is_empty")]
    pub required_data_connectors: Vec<AlertRuleTemplateDataSource>,
    #[doc = "The alert rule template status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<AlertRuleTemplateStatus>,
    #[doc = "The query that creates alerts for this rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[doc = "The frequency (in ISO 8601 duration format) for this alert rule to run."]
    #[serde(rename = "queryFrequency", default, skip_serializing_if = "Option::is_none")]
    pub query_frequency: Option<String>,
    #[doc = "The period (in ISO 8601 duration format) that this alert rule looks at."]
    #[serde(rename = "queryPeriod", default, skip_serializing_if = "Option::is_none")]
    pub query_period: Option<String>,
    #[doc = "The severity of the alert"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[doc = "The operation against the threshold that triggers alert rule."]
    #[serde(rename = "triggerOperator", default, skip_serializing_if = "Option::is_none")]
    pub trigger_operator: Option<AlertRuleTriggerOperator>,
    #[doc = "The threshold triggers this alert rule."]
    #[serde(rename = "triggerThreshold", default, skip_serializing_if = "Option::is_none")]
    pub trigger_threshold: Option<i32>,
    #[doc = "The tactics of the alert rule template"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl ScheduledAlertRuleTemplateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents threat intelligence data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[doc = "TI (Threat Intelligence) data connector properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TiDataConnectorProperties>,
}
impl TiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[doc = "The available data types for TI (Threat Intelligence) data connector."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TiDataConnectorDataTypes {
    #[doc = "Data type for indicators connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub indicators: Option<serde_json::Value>,
}
impl TiDataConnectorDataTypes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "TI (Threat Intelligence) data connector properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TiDataConnectorProperties {
    #[doc = "The tenant id to connect to, and get the data from."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The lookback period for the feed to be imported."]
    #[serde(rename = "tipLookbackPeriod", default, skip_serializing_if = "Option::is_none")]
    pub tip_lookback_period: Option<String>,
    #[doc = "The available data types for TI (Threat Intelligence) data connector."]
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<TiDataConnectorDataTypes>,
}
impl TiDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ThreatIntelligence property bag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligence {
    #[doc = "Confidence (must be between 0 and 1)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub confidence: Option<f64>,
    #[doc = "Name of the provider from whom this Threat Intelligence information was received"]
    #[serde(rename = "providerName", default, skip_serializing_if = "Option::is_none")]
    pub provider_name: Option<String>,
    #[doc = "Report link"]
    #[serde(rename = "reportLink", default, skip_serializing_if = "Option::is_none")]
    pub report_link: Option<String>,
    #[doc = "Threat description (free text)"]
    #[serde(rename = "threatDescription", default, skip_serializing_if = "Option::is_none")]
    pub threat_description: Option<String>,
    #[doc = "Threat name (e.g. \"Jedobot malware\")"]
    #[serde(rename = "threatName", default, skip_serializing_if = "Option::is_none")]
    pub threat_name: Option<String>,
    #[doc = "Threat type (e.g. \"Botnet\")"]
    #[serde(rename = "threatType", default, skip_serializing_if = "Option::is_none")]
    pub threat_type: Option<String>,
}
impl ThreatIntelligence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "User information that made some action"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserInfo {
    #[doc = "The email of the user."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[doc = "The name of the user."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The object id of the user."]
    #[serde(rename = "objectId")]
    pub object_id: String,
}
impl UserInfo {
    pub fn new(object_id: String) -> Self {
        Self {
            email: None,
            name: None,
            object_id,
        }
    }
}
