#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AadCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AadCheckRequirementsProperties>,
}
impl AadCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AadCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl AadCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AadDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AadDataConnectorProperties>,
}
impl AadDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AadDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
}
impl AadDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self {
            data_connector_tenant_id,
            data_connector_with_alerts_properties: DataConnectorWithAlertsProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AatpCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AatpCheckRequirementsProperties>,
}
impl AatpCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AatpCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl AatpCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AatpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AatpDataConnectorProperties>,
}
impl AatpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AatpDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
}
impl AatpDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self {
            data_connector_tenant_id,
            data_connector_with_alerts_properties: DataConnectorWithAlertsProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AscCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AscCheckRequirementsProperties>,
}
impl AscCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscCheckRequirementsProperties {
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
}
impl AscCheckRequirementsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AscDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AscDataConnectorProperties>,
}
impl AscDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
}
impl AscDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionPropertiesBase {
    #[serde(rename = "logicAppResourceId")]
    pub logic_app_resource_id: String,
}
impl ActionPropertiesBase {
    pub fn new(logic_app_resource_id: String) -> Self {
        Self { logic_app_resource_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActionRequest {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActionRequestProperties>,
}
impl ActionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionRequestProperties {
    #[serde(flatten)]
    pub action_properties_base: ActionPropertiesBase,
    #[serde(rename = "triggerUri")]
    pub trigger_uri: String,
}
impl ActionRequestProperties {
    pub fn new(action_properties_base: ActionPropertiesBase, trigger_uri: String) -> Self {
        Self {
            action_properties_base,
            trigger_uri,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActionResponse {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActionResponseProperties>,
}
impl ActionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionResponseProperties {
    #[serde(flatten)]
    pub action_properties_base: ActionPropertiesBase,
    #[serde(rename = "workflowId", default, skip_serializing_if = "Option::is_none")]
    pub workflow_id: Option<String>,
}
impl ActionResponseProperties {
    pub fn new(action_properties_base: ActionPropertiesBase) -> Self {
        Self {
            action_properties_base,
            workflow_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionsList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ActionResponse>,
}
impl ActionsList {
    pub fn new(value: Vec<ActionResponse>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityCustomEntityQuery {
    #[serde(flatten)]
    pub custom_entity_query: CustomEntityQuery,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActivityEntityQueriesProperties>,
}
impl ActivityCustomEntityQuery {
    pub fn new(custom_entity_query: CustomEntityQuery) -> Self {
        Self {
            custom_entity_query,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActivityEntityQueriesProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "queryDefinitions", default, skip_serializing_if = "Option::is_none")]
    pub query_definitions: Option<activity_entity_queries_properties::QueryDefinitions>,
    #[serde(rename = "inputEntityType", default, skip_serializing_if = "Option::is_none")]
    pub input_entity_type: Option<EntityInnerType>,
    #[serde(rename = "requiredInputFieldsSets", default, skip_serializing_if = "Vec::is_empty")]
    pub required_input_fields_sets: Vec<Vec<String>>,
    #[serde(rename = "entitiesFilter", default, skip_serializing_if = "Option::is_none")]
    pub entities_filter: Option<serde_json::Value>,
    #[serde(rename = "templateName", default, skip_serializing_if = "Option::is_none")]
    pub template_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time_utc: Option<String>,
}
impl ActivityEntityQueriesProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod activity_entity_queries_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct QueryDefinitions {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub query: Option<String>,
    }
    impl QueryDefinitions {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityEntityQuery {
    #[serde(flatten)]
    pub entity_query: EntityQuery,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActivityEntityQueriesProperties>,
}
impl ActivityEntityQuery {
    pub fn new(entity_query: EntityQuery) -> Self {
        Self {
            entity_query,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityEntityQueryTemplate {
    #[serde(flatten)]
    pub entity_query_template: EntityQueryTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActivityEntityQueryTemplateProperties>,
}
impl ActivityEntityQueryTemplate {
    pub fn new(entity_query_template: EntityQueryTemplate) -> Self {
        Self {
            entity_query_template,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActivityEntityQueryTemplateProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "queryDefinitions", default, skip_serializing_if = "Option::is_none")]
    pub query_definitions: Option<activity_entity_query_template_properties::QueryDefinitions>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub data_types: Vec<DataTypeDefinitions>,
    #[serde(rename = "inputEntityType", default, skip_serializing_if = "Option::is_none")]
    pub input_entity_type: Option<EntityInnerType>,
    #[serde(rename = "requiredInputFieldsSets", default, skip_serializing_if = "Vec::is_empty")]
    pub required_input_fields_sets: Vec<Vec<String>>,
    #[serde(rename = "entitiesFilter", default, skip_serializing_if = "Option::is_none")]
    pub entities_filter: Option<serde_json::Value>,
}
impl ActivityEntityQueryTemplateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod activity_entity_query_template_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct QueryDefinitions {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub query: Option<String>,
        #[serde(rename = "summarizeBy", default, skip_serializing_if = "Option::is_none")]
        pub summarize_by: Option<String>,
    }
    impl QueryDefinitions {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityTimelineItem {
    #[serde(flatten)]
    pub entity_timeline_item: EntityTimelineItem,
    #[serde(rename = "queryId")]
    pub query_id: String,
    #[serde(rename = "bucketStartTimeUTC")]
    pub bucket_start_time_utc: String,
    #[serde(rename = "bucketEndTimeUTC")]
    pub bucket_end_time_utc: String,
    #[serde(rename = "firstActivityTimeUTC")]
    pub first_activity_time_utc: String,
    #[serde(rename = "lastActivityTimeUTC")]
    pub last_activity_time_utc: String,
    pub content: String,
    pub title: String,
}
impl ActivityTimelineItem {
    pub fn new(
        entity_timeline_item: EntityTimelineItem,
        query_id: String,
        bucket_start_time_utc: String,
        bucket_end_time_utc: String,
        first_activity_time_utc: String,
        last_activity_time_utc: String,
        content: String,
        title: String,
    ) -> Self {
        Self {
            entity_timeline_item,
            query_id,
            bucket_start_time_utc,
            bucket_end_time_utc,
            first_activity_time_utc,
            last_activity_time_utc,
            content,
            title,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertDetailsOverride {
    #[serde(rename = "alertDisplayNameFormat", default, skip_serializing_if = "Option::is_none")]
    pub alert_display_name_format: Option<String>,
    #[serde(rename = "alertDescriptionFormat", default, skip_serializing_if = "Option::is_none")]
    pub alert_description_format: Option<String>,
    #[serde(rename = "alertTacticsColumnName", default, skip_serializing_if = "Option::is_none")]
    pub alert_tactics_column_name: Option<String>,
    #[serde(rename = "alertSeverityColumnName", default, skip_serializing_if = "Option::is_none")]
    pub alert_severity_column_name: Option<String>,
}
impl AlertDetailsOverride {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRule {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: AlertRuleKindEnum,
}
impl AlertRule {
    pub fn new(kind: AlertRuleKindEnum) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleKindEnum {
    Scheduled,
    MicrosoftSecurityIncidentCreation,
    Fusion,
    #[serde(rename = "MLBehaviorAnalytics")]
    MlBehaviorAnalytics,
    ThreatIntelligence,
    #[serde(rename = "NRT")]
    Nrt,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleTemplate {
    #[serde(flatten)]
    pub resource: Resource,
    pub kind: AlertRuleKindEnum,
}
impl AlertRuleTemplate {
    pub fn new(kind: AlertRuleKindEnum) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRuleTemplateDataSource {
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub data_types: Vec<String>,
}
impl AlertRuleTemplateDataSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRuleTemplatePropertiesBase {
    #[serde(rename = "alertRulesCreatedByTemplateCount", default, skip_serializing_if = "Option::is_none")]
    pub alert_rules_created_by_template_count: Option<i32>,
    #[serde(rename = "lastUpdatedDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_date_utc: Option<String>,
    #[serde(rename = "createdDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub created_date_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "requiredDataConnectors", default, skip_serializing_if = "Vec::is_empty")]
    pub required_data_connectors: Vec<AlertRuleTemplateDataSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<alert_rule_template_properties_base::Status>,
}
impl AlertRuleTemplatePropertiesBase {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_rule_template_properties_base {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Installed,
        Available,
        NotAvailable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleTemplatesList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<AlertRuleTemplate>,
}
impl AlertRuleTemplatesList {
    pub fn new(value: Vec<AlertRuleTemplate>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleTriggerOperator {
    GreaterThan,
    LessThan,
    Equal,
    NotEqual,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRulesList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<AlertRule>,
}
impl AlertRulesList {
    pub fn new(value: Vec<AlertRule>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertSeverityEnum {
    High,
    Medium,
    Low,
    Informational,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertsDataTypeOfDataConnector {
    pub alerts: DataConnectorDataTypeCommon,
}
impl AlertsDataTypeOfDataConnector {
    pub fn new(alerts: DataConnectorDataTypeCommon) -> Self {
        Self { alerts }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Anomalies {
    #[serde(flatten)]
    pub settings: Settings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AnomaliesSettingsProperties>,
}
impl Anomalies {
    pub fn new(settings: Settings) -> Self {
        Self {
            settings,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AnomaliesSettingsProperties {
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
}
impl AnomaliesSettingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiPollingParameters {
    #[serde(rename = "connectorUiConfig", default, skip_serializing_if = "Option::is_none")]
    pub connector_ui_config: Option<CodelessUiConnectorConfigProperties>,
    #[serde(rename = "pollingConfig", default, skip_serializing_if = "Option::is_none")]
    pub polling_config: Option<CodelessConnectorPollingConfigProperties>,
}
impl ApiPollingParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AttackTactic {
    InitialAccess,
    Execution,
    Persistence,
    PrivilegeEscalation,
    DefenseEvasion,
    CredentialAccess,
    Discovery,
    LateralMovement,
    Collection,
    Exfiltration,
    CommandAndControl,
    Impact,
    PreAttack,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutomationRule {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AutomationRuleProperties>,
}
impl AutomationRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomationRuleAction {
    pub order: i32,
    #[serde(rename = "actionType")]
    pub action_type: automation_rule_action::ActionType,
}
impl AutomationRuleAction {
    pub fn new(order: i32, action_type: automation_rule_action::ActionType) -> Self {
        Self { order, action_type }
    }
}
pub mod automation_rule_action {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActionType {
        ModifyProperties,
        RunPlaybook,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomationRuleCondition {
    #[serde(rename = "conditionType")]
    pub condition_type: automation_rule_condition::ConditionType,
}
impl AutomationRuleCondition {
    pub fn new(condition_type: automation_rule_condition::ConditionType) -> Self {
        Self { condition_type }
    }
}
pub mod automation_rule_condition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConditionType {
        Property,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomationRuleModifyPropertiesAction {
    #[serde(flatten)]
    pub automation_rule_action: AutomationRuleAction,
    #[serde(rename = "actionConfiguration")]
    pub action_configuration: automation_rule_modify_properties_action::ActionConfiguration,
}
impl AutomationRuleModifyPropertiesAction {
    pub fn new(
        automation_rule_action: AutomationRuleAction,
        action_configuration: automation_rule_modify_properties_action::ActionConfiguration,
    ) -> Self {
        Self {
            automation_rule_action,
            action_configuration,
        }
    }
}
pub mod automation_rule_modify_properties_action {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ActionConfiguration {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub classification: Option<IncidentClassificationEnum>,
        #[serde(rename = "classificationComment", default, skip_serializing_if = "Option::is_none")]
        pub classification_comment: Option<String>,
        #[serde(rename = "classificationReason", default, skip_serializing_if = "Option::is_none")]
        pub classification_reason: Option<IncidentClassificationReasonEnum>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub labels: Vec<IncidentLabel>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub owner: Option<IncidentOwnerInfo>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub severity: Option<IncidentSeverityEnum>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub status: Option<IncidentStatusEnum>,
    }
    impl ActionConfiguration {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomationRuleProperties {
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub order: i32,
    #[serde(rename = "triggeringLogic")]
    pub triggering_logic: AutomationRuleTriggeringLogic,
    pub actions: Vec<AutomationRuleAction>,
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time_utc: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<ClientInfo>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<ClientInfo>,
}
impl AutomationRuleProperties {
    pub fn new(
        display_name: String,
        order: i32,
        triggering_logic: AutomationRuleTriggeringLogic,
        actions: Vec<AutomationRuleAction>,
    ) -> Self {
        Self {
            display_name,
            order,
            triggering_logic,
            actions,
            created_time_utc: None,
            last_modified_time_utc: None,
            created_by: None,
            last_modified_by: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AutomationRulePropertyConditionSupportedProperty {
    IncidentTitle,
    IncidentDescription,
    IncidentSeverity,
    IncidentStatus,
    IncidentTactics,
    IncidentRelatedAnalyticRuleIds,
    IncidentProviderName,
    AccountAadTenantId,
    AccountAadUserId,
    AccountName,
    #[serde(rename = "AccountNTDomain")]
    AccountNtDomain,
    #[serde(rename = "AccountPUID")]
    AccountPuid,
    AccountSid,
    AccountObjectGuid,
    #[serde(rename = "AccountUPNSuffix")]
    AccountUpnSuffix,
    AzureResourceResourceId,
    AzureResourceSubscriptionId,
    CloudApplicationAppId,
    CloudApplicationAppName,
    #[serde(rename = "DNSDomainName")]
    DnsDomainName,
    FileDirectory,
    FileName,
    FileHashValue,
    #[serde(rename = "HostAzureID")]
    HostAzureId,
    HostName,
    HostNetBiosName,
    #[serde(rename = "HostNTDomain")]
    HostNtDomain,
    #[serde(rename = "HostOSVersion")]
    HostOsVersion,
    IoTDeviceId,
    IoTDeviceName,
    IoTDeviceType,
    IoTDeviceVendor,
    IoTDeviceModel,
    IoTDeviceOperatingSystem,
    #[serde(rename = "IPAddress")]
    IpAddress,
    MailboxDisplayName,
    MailboxPrimaryAddress,
    #[serde(rename = "MailboxUPN")]
    MailboxUpn,
    MailMessageDeliveryAction,
    MailMessageDeliveryLocation,
    MailMessageRecipient,
    #[serde(rename = "MailMessageSenderIP")]
    MailMessageSenderIp,
    MailMessageSubject,
    MailMessageP1Sender,
    MailMessageP2Sender,
    MalwareCategory,
    MalwareName,
    ProcessCommandLine,
    ProcessId,
    RegistryKey,
    RegistryValueData,
    Url,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomationRulePropertyValuesCondition {
    #[serde(flatten)]
    pub automation_rule_condition: AutomationRuleCondition,
    #[serde(rename = "conditionProperties")]
    pub condition_properties: automation_rule_property_values_condition::ConditionProperties,
}
impl AutomationRulePropertyValuesCondition {
    pub fn new(
        automation_rule_condition: AutomationRuleCondition,
        condition_properties: automation_rule_property_values_condition::ConditionProperties,
    ) -> Self {
        Self {
            automation_rule_condition,
            condition_properties,
        }
    }
}
pub mod automation_rule_property_values_condition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ConditionProperties {
        #[serde(rename = "propertyName", default, skip_serializing_if = "Option::is_none")]
        pub property_name: Option<AutomationRulePropertyConditionSupportedProperty>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operator: Option<condition_properties::Operator>,
        #[serde(rename = "propertyValues", default, skip_serializing_if = "Vec::is_empty")]
        pub property_values: Vec<String>,
    }
    impl ConditionProperties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod condition_properties {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Operator {
            Equals,
            NotEquals,
            Contains,
            NotContains,
            StartsWith,
            NotStartsWith,
            EndsWith,
            NotEndsWith,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomationRuleRunPlaybookAction {
    #[serde(flatten)]
    pub automation_rule_action: AutomationRuleAction,
    #[serde(rename = "actionConfiguration")]
    pub action_configuration: automation_rule_run_playbook_action::ActionConfiguration,
}
impl AutomationRuleRunPlaybookAction {
    pub fn new(
        automation_rule_action: AutomationRuleAction,
        action_configuration: automation_rule_run_playbook_action::ActionConfiguration,
    ) -> Self {
        Self {
            automation_rule_action,
            action_configuration,
        }
    }
}
pub mod automation_rule_run_playbook_action {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ActionConfiguration {
        #[serde(rename = "logicAppResourceId", default, skip_serializing_if = "Option::is_none")]
        pub logic_app_resource_id: Option<String>,
        #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
        pub tenant_id: Option<String>,
    }
    impl ActionConfiguration {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomationRuleTriggeringLogic {
    #[serde(rename = "isEnabled")]
    pub is_enabled: bool,
    #[serde(rename = "expirationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time_utc: Option<String>,
    #[serde(rename = "triggersOn")]
    pub triggers_on: automation_rule_triggering_logic::TriggersOn,
    #[serde(rename = "triggersWhen")]
    pub triggers_when: automation_rule_triggering_logic::TriggersWhen,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub conditions: Vec<AutomationRuleCondition>,
}
impl AutomationRuleTriggeringLogic {
    pub fn new(
        is_enabled: bool,
        triggers_on: automation_rule_triggering_logic::TriggersOn,
        triggers_when: automation_rule_triggering_logic::TriggersWhen,
    ) -> Self {
        Self {
            is_enabled,
            expiration_time_utc: None,
            triggers_on,
            triggers_when,
            conditions: Vec::new(),
        }
    }
}
pub mod automation_rule_triggering_logic {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TriggersOn {
        Incidents,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TriggersWhen {
        Created,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomationRulesList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<AutomationRule>,
}
impl AutomationRulesList {
    pub fn new(value: Vec<AutomationRule>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Availability {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<availability::Status>,
    #[serde(rename = "isPreview", default, skip_serializing_if = "Option::is_none")]
    pub is_preview: Option<bool>,
}
impl Availability {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod availability {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {}
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsCloudTrailCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
}
impl AwsCloudTrailCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsCloudTrailDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AwsCloudTrailDataConnectorProperties>,
}
impl AwsCloudTrailDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsCloudTrailDataConnectorDataTypes {
    pub logs: serde_json::Value,
}
impl AwsCloudTrailDataConnectorDataTypes {
    pub fn new(logs: serde_json::Value) -> Self {
        Self { logs }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsCloudTrailDataConnectorProperties {
    #[serde(rename = "awsRoleArn", default, skip_serializing_if = "Option::is_none")]
    pub aws_role_arn: Option<String>,
    #[serde(rename = "dataTypes")]
    pub data_types: AwsCloudTrailDataConnectorDataTypes,
}
impl AwsCloudTrailDataConnectorProperties {
    pub fn new(data_types: AwsCloudTrailDataConnectorDataTypes) -> Self {
        Self {
            aws_role_arn: None,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsS3CheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
}
impl AwsS3CheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsS3DataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AwsS3DataConnectorProperties>,
}
impl AwsS3DataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsS3DataConnectorDataTypes {
    pub logs: serde_json::Value,
}
impl AwsS3DataConnectorDataTypes {
    pub fn new(logs: serde_json::Value) -> Self {
        Self { logs }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsS3DataConnectorProperties {
    #[serde(rename = "destinationTable")]
    pub destination_table: String,
    #[serde(rename = "sqsUrls")]
    pub sqs_urls: Vec<String>,
    #[serde(rename = "roleArn")]
    pub role_arn: String,
    #[serde(rename = "dataTypes")]
    pub data_types: AwsS3DataConnectorDataTypes,
}
impl AwsS3DataConnectorProperties {
    pub fn new(destination_table: String, sqs_urls: Vec<String>, role_arn: String, data_types: AwsS3DataConnectorDataTypes) -> Self {
        Self {
            destination_table,
            sqs_urls,
            role_arn,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Bookmark {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BookmarkProperties>,
}
impl Bookmark {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BookmarkExpandParameters {
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "expansionId", default, skip_serializing_if = "Option::is_none")]
    pub expansion_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
}
impl BookmarkExpandParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BookmarkExpandResponse {
    #[serde(rename = "metaData", default, skip_serializing_if = "Option::is_none")]
    pub meta_data: Option<ExpansionResultsMetadata>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<bookmark_expand_response::Value>,
}
impl BookmarkExpandResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bookmark_expand_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Value {
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub entities: Vec<Entity>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub edges: Vec<ConnectedEntity>,
    }
    impl Value {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BookmarkList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Bookmark>,
}
impl BookmarkList {
    pub fn new(value: Vec<Bookmark>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BookmarkProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<Label>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    pub query: String,
    #[serde(rename = "queryResult", default, skip_serializing_if = "Option::is_none")]
    pub query_result: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<UserInfo>,
    #[serde(rename = "eventTime", default, skip_serializing_if = "Option::is_none")]
    pub event_time: Option<String>,
    #[serde(rename = "queryStartTime", default, skip_serializing_if = "Option::is_none")]
    pub query_start_time: Option<String>,
    #[serde(rename = "queryEndTime", default, skip_serializing_if = "Option::is_none")]
    pub query_end_time: Option<String>,
    #[serde(rename = "incidentInfo", default, skip_serializing_if = "Option::is_none")]
    pub incident_info: Option<IncidentInfo>,
}
impl BookmarkProperties {
    pub fn new(display_name: String, query: String) -> Self {
        Self {
            created: None,
            created_by: None,
            display_name,
            labels: Vec::new(),
            notes: None,
            query,
            query_result: None,
            updated: None,
            updated_by: None,
            event_time: None,
            query_start_time: None,
            query_end_time: None,
            incident_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BookmarkTimelineItem {
    #[serde(flatten)]
    pub entity_timeline_item: EntityTimelineItem,
    #[serde(rename = "azureResourceId")]
    pub azure_resource_id: String,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    #[serde(rename = "endTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub end_time_utc: Option<String>,
    #[serde(rename = "startTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub start_time_utc: Option<String>,
    #[serde(rename = "eventTime", default, skip_serializing_if = "Option::is_none")]
    pub event_time: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<Label>,
}
impl BookmarkTimelineItem {
    pub fn new(entity_timeline_item: EntityTimelineItem, azure_resource_id: String) -> Self {
        Self {
            entity_timeline_item,
            azure_resource_id,
            display_name: None,
            notes: None,
            end_time_utc: None,
            start_time_utc: None,
            event_time: None,
            created_by: None,
            labels: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
}
impl ClientInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessApiPollingDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApiPollingParameters>,
}
impl CodelessApiPollingDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessConnectorPollingAuthProperties {
    #[serde(rename = "authType")]
    pub auth_type: String,
    #[serde(rename = "apiKeyName", default, skip_serializing_if = "Option::is_none")]
    pub api_key_name: Option<String>,
    #[serde(rename = "apiKeyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub api_key_identifier: Option<String>,
    #[serde(rename = "isApiKeyInPostPayload", default, skip_serializing_if = "Option::is_none")]
    pub is_api_key_in_post_payload: Option<String>,
    #[serde(rename = "flowName", default, skip_serializing_if = "Option::is_none")]
    pub flow_name: Option<String>,
    #[serde(rename = "tokenEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub token_endpoint: Option<String>,
    #[serde(rename = "authorizationEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub authorization_endpoint: Option<String>,
    #[serde(rename = "authorizationEndpointQueryParameters", default, skip_serializing_if = "Option::is_none")]
    pub authorization_endpoint_query_parameters: Option<serde_json::Value>,
    #[serde(rename = "redirectionEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub redirection_endpoint: Option<String>,
    #[serde(rename = "tokenEndpointHeaders", default, skip_serializing_if = "Option::is_none")]
    pub token_endpoint_headers: Option<serde_json::Value>,
    #[serde(rename = "tokenEndpointQueryParameters", default, skip_serializing_if = "Option::is_none")]
    pub token_endpoint_query_parameters: Option<serde_json::Value>,
    #[serde(rename = "isClientSecretInHeader", default, skip_serializing_if = "Option::is_none")]
    pub is_client_secret_in_header: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
}
impl CodelessConnectorPollingAuthProperties {
    pub fn new(auth_type: String) -> Self {
        Self {
            auth_type,
            api_key_name: None,
            api_key_identifier: None,
            is_api_key_in_post_payload: None,
            flow_name: None,
            token_endpoint: None,
            authorization_endpoint: None,
            authorization_endpoint_query_parameters: None,
            redirection_endpoint: None,
            token_endpoint_headers: None,
            token_endpoint_query_parameters: None,
            is_client_secret_in_header: None,
            scope: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessConnectorPollingConfigProperties {
    #[serde(rename = "isActive", default, skip_serializing_if = "Option::is_none")]
    pub is_active: Option<bool>,
    pub auth: CodelessConnectorPollingAuthProperties,
    pub request: CodelessConnectorPollingRequestProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub paging: Option<CodelessConnectorPollingPagingProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub response: Option<CodelessConnectorPollingResponseProperties>,
}
impl CodelessConnectorPollingConfigProperties {
    pub fn new(auth: CodelessConnectorPollingAuthProperties, request: CodelessConnectorPollingRequestProperties) -> Self {
        Self {
            is_active: None,
            auth,
            request,
            paging: None,
            response: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessConnectorPollingPagingProperties {
    #[serde(rename = "pagingType")]
    pub paging_type: String,
    #[serde(rename = "nextPageParaName", default, skip_serializing_if = "Option::is_none")]
    pub next_page_para_name: Option<String>,
    #[serde(rename = "nextPageTokenJsonPath", default, skip_serializing_if = "Option::is_none")]
    pub next_page_token_json_path: Option<String>,
    #[serde(rename = "pageCountAttributePath", default, skip_serializing_if = "Option::is_none")]
    pub page_count_attribute_path: Option<String>,
    #[serde(rename = "pageTotalCountAttributePath", default, skip_serializing_if = "Option::is_none")]
    pub page_total_count_attribute_path: Option<String>,
    #[serde(rename = "pageTimeStampAttributePath", default, skip_serializing_if = "Option::is_none")]
    pub page_time_stamp_attribute_path: Option<String>,
    #[serde(
        rename = "searchTheLatestTimeStampFromEventsList",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub search_the_latest_time_stamp_from_events_list: Option<String>,
    #[serde(rename = "pageSizeParaName", default, skip_serializing_if = "Option::is_none")]
    pub page_size_para_name: Option<String>,
    #[serde(rename = "pageSize", default, skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i32>,
}
impl CodelessConnectorPollingPagingProperties {
    pub fn new(paging_type: String) -> Self {
        Self {
            paging_type,
            next_page_para_name: None,
            next_page_token_json_path: None,
            page_count_attribute_path: None,
            page_total_count_attribute_path: None,
            page_time_stamp_attribute_path: None,
            search_the_latest_time_stamp_from_events_list: None,
            page_size_para_name: None,
            page_size: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessConnectorPollingRequestProperties {
    #[serde(rename = "apiEndpoint")]
    pub api_endpoint: String,
    #[serde(rename = "rateLimitQps", default, skip_serializing_if = "Option::is_none")]
    pub rate_limit_qps: Option<i32>,
    #[serde(rename = "queryWindowInMin")]
    pub query_window_in_min: i32,
    #[serde(rename = "httpMethod")]
    pub http_method: String,
    #[serde(rename = "queryTimeFormat")]
    pub query_time_format: String,
    #[serde(rename = "retryCount", default, skip_serializing_if = "Option::is_none")]
    pub retry_count: Option<i32>,
    #[serde(rename = "timeoutInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub timeout_in_seconds: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
    #[serde(rename = "queryParameters", default, skip_serializing_if = "Option::is_none")]
    pub query_parameters: Option<serde_json::Value>,
    #[serde(rename = "queryParametersTemplate", default, skip_serializing_if = "Option::is_none")]
    pub query_parameters_template: Option<String>,
    #[serde(rename = "startTimeAttributeName", default, skip_serializing_if = "Option::is_none")]
    pub start_time_attribute_name: Option<String>,
    #[serde(rename = "endTimeAttributeName", default, skip_serializing_if = "Option::is_none")]
    pub end_time_attribute_name: Option<String>,
}
impl CodelessConnectorPollingRequestProperties {
    pub fn new(api_endpoint: String, query_window_in_min: i32, http_method: String, query_time_format: String) -> Self {
        Self {
            api_endpoint,
            rate_limit_qps: None,
            query_window_in_min,
            http_method,
            query_time_format,
            retry_count: None,
            timeout_in_seconds: None,
            headers: None,
            query_parameters: None,
            query_parameters_template: None,
            start_time_attribute_name: None,
            end_time_attribute_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessConnectorPollingResponseProperties {
    #[serde(rename = "eventsJsonPaths")]
    pub events_json_paths: Vec<String>,
    #[serde(rename = "successStatusJsonPath", default, skip_serializing_if = "Option::is_none")]
    pub success_status_json_path: Option<String>,
    #[serde(rename = "successStatusValue", default, skip_serializing_if = "Option::is_none")]
    pub success_status_value: Option<String>,
    #[serde(rename = "isGzipCompressed", default, skip_serializing_if = "Option::is_none")]
    pub is_gzip_compressed: Option<bool>,
}
impl CodelessConnectorPollingResponseProperties {
    pub fn new(events_json_paths: Vec<String>) -> Self {
        Self {
            events_json_paths,
            success_status_json_path: None,
            success_status_value: None,
            is_gzip_compressed: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CodelessParameters {
    #[serde(rename = "connectorUiConfig", default, skip_serializing_if = "Option::is_none")]
    pub connector_ui_config: Option<CodelessUiConnectorConfigProperties>,
}
impl CodelessParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessUiConnectorConfigProperties {
    pub title: String,
    pub publisher: String,
    #[serde(rename = "descriptionMarkdown")]
    pub description_markdown: String,
    #[serde(rename = "customImage", default, skip_serializing_if = "Option::is_none")]
    pub custom_image: Option<String>,
    #[serde(rename = "graphQueriesTableName")]
    pub graph_queries_table_name: String,
    #[serde(rename = "graphQueries")]
    pub graph_queries: Vec<serde_json::Value>,
    #[serde(rename = "sampleQueries")]
    pub sample_queries: Vec<serde_json::Value>,
    #[serde(rename = "dataTypes")]
    pub data_types: Vec<serde_json::Value>,
    #[serde(rename = "connectivityCriteria")]
    pub connectivity_criteria: Vec<serde_json::Value>,
    pub availability: Availability,
    pub permissions: Permissions,
    #[serde(rename = "instructionSteps")]
    pub instruction_steps: Vec<serde_json::Value>,
}
impl CodelessUiConnectorConfigProperties {
    pub fn new(
        title: String,
        publisher: String,
        description_markdown: String,
        graph_queries_table_name: String,
        graph_queries: Vec<serde_json::Value>,
        sample_queries: Vec<serde_json::Value>,
        data_types: Vec<serde_json::Value>,
        connectivity_criteria: Vec<serde_json::Value>,
        availability: Availability,
        permissions: Permissions,
        instruction_steps: Vec<serde_json::Value>,
    ) -> Self {
        Self {
            title,
            publisher,
            description_markdown,
            custom_image: None,
            graph_queries_table_name,
            graph_queries,
            sample_queries,
            data_types,
            connectivity_criteria,
            availability,
            permissions,
            instruction_steps,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessUiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CodelessParameters>,
}
impl CodelessUiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectedEntity {
    #[serde(rename = "targetEntityId", default, skip_serializing_if = "Option::is_none")]
    pub target_entity_id: Option<String>,
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<serde_json::Value>,
}
impl ConnectedEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityCriteria {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connectivity_criteria::Type>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<String>,
}
impl ConnectivityCriteria {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_criteria {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        IsConnectedQuery,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectorInstructionModelBase {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[serde(rename = "type")]
    pub type_: connector_instruction_model_base::Type,
}
impl ConnectorInstructionModelBase {
    pub fn new(type_: connector_instruction_model_base::Type) -> Self {
        Self { parameters: None, type_ }
    }
}
pub mod connector_instruction_model_base {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        CopyableLabel,
        InstructionStepsGroup,
        InfoMessage,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentPathMap {
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<ContentType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl ContentPathMap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ContentType {
    AnalyticRule,
    Workbook,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomEntityQuery {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: CustomEntityQueryKind,
}
impl CustomEntityQuery {
    pub fn new(kind: CustomEntityQueryKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CustomEntityQueryKind {
    Activity,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Customs {
    #[serde(flatten)]
    pub customs_permission: CustomsPermission,
}
impl Customs {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomsPermission {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl CustomsPermission {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnector {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: DataConnectorKind,
}
impl DataConnector {
    pub fn new(kind: DataConnectorKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DataConnectorAuthorizationState {
    Valid,
    Invalid,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorConnectBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<data_connector_connect_body::Kind>,
    #[serde(rename = "apiKey", default, skip_serializing_if = "Option::is_none")]
    pub api_key: Option<String>,
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(rename = "authorizationCode", default, skip_serializing_if = "Option::is_none")]
    pub authorization_code: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "requestConfigUserInputValues", default, skip_serializing_if = "Vec::is_empty")]
    pub request_config_user_input_values: Vec<serde_json::Value>,
}
impl DataConnectorConnectBody {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_connector_connect_body {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Basic,
        OAuth2,
        #[serde(rename = "APIKey")]
        ApiKey,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnectorDataTypeCommon {
    pub state: data_connector_data_type_common::State,
}
impl DataConnectorDataTypeCommon {
    pub fn new(state: data_connector_data_type_common::State) -> Self {
        Self { state }
    }
}
pub mod data_connector_data_type_common {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DataConnectorKind {
    AzureActiveDirectory,
    AzureSecurityCenter,
    MicrosoftCloudAppSecurity,
    ThreatIntelligence,
    ThreatIntelligenceTaxii,
    Office365,
    #[serde(rename = "OfficeATP")]
    OfficeAtp,
    #[serde(rename = "OfficeIRM")]
    OfficeIrm,
    AmazonWebServicesCloudTrail,
    AmazonWebServicesS3,
    AzureAdvancedThreatProtection,
    MicrosoftDefenderAdvancedThreatProtection,
    Dynamics365,
    MicrosoftThreatProtection,
    MicrosoftThreatIntelligence,
    #[serde(rename = "GenericUI")]
    GenericUi,
    #[serde(rename = "APIPolling")]
    ApiPolling,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DataConnectorLicenseState {
    Valid,
    Invalid,
    Unknown,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnectorList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<DataConnector>,
}
impl DataConnectorList {
    pub fn new(value: Vec<DataConnector>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorRequirementsState {
    #[serde(rename = "authorizationState", default, skip_serializing_if = "Option::is_none")]
    pub authorization_state: Option<DataConnectorAuthorizationState>,
    #[serde(rename = "licenseState", default, skip_serializing_if = "Option::is_none")]
    pub license_state: Option<DataConnectorLicenseState>,
}
impl DataConnectorRequirementsState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnectorTenantId {
    #[serde(rename = "tenantId")]
    pub tenant_id: String,
}
impl DataConnectorTenantId {
    pub fn new(tenant_id: String) -> Self {
        Self { tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorWithAlertsProperties {
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl DataConnectorWithAlertsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnectorsCheckRequirements {
    pub kind: DataConnectorKind,
}
impl DataConnectorsCheckRequirements {
    pub fn new(kind: DataConnectorKind) -> Self {
        Self { kind }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataTypeDefinitions {
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<String>,
}
impl DataTypeDefinitions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dynamics365CheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Dynamics365CheckRequirementsProperties>,
}
impl Dynamics365CheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dynamics365CheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl Dynamics365CheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dynamics365DataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Dynamics365DataConnectorProperties>,
}
impl Dynamics365DataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dynamics365DataConnectorDataTypes {
    #[serde(rename = "dynamics365CdsActivities")]
    pub dynamics365_cds_activities: serde_json::Value,
}
impl Dynamics365DataConnectorDataTypes {
    pub fn new(dynamics365_cds_activities: serde_json::Value) -> Self {
        Self {
            dynamics365_cds_activities,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dynamics365DataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: Dynamics365DataConnectorDataTypes,
}
impl Dynamics365DataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: Dynamics365DataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrichmentDomainWhois {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub domain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expires: Option<String>,
    #[serde(rename = "parsedWhois", default, skip_serializing_if = "Option::is_none")]
    pub parsed_whois: Option<EnrichmentDomainWhoisDetails>,
}
impl EnrichmentDomainWhois {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrichmentDomainWhoisContact {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub org: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub street: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub postal: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fax: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
}
impl EnrichmentDomainWhoisContact {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrichmentDomainWhoisContacts {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub admin: Option<EnrichmentDomainWhoisContact>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub billing: Option<EnrichmentDomainWhoisContact>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registrant: Option<EnrichmentDomainWhoisContact>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tech: Option<EnrichmentDomainWhoisContact>,
}
impl EnrichmentDomainWhoisContacts {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrichmentDomainWhoisDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registrar: Option<EnrichmentDomainWhoisRegistrarDetails>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub contacts: Option<EnrichmentDomainWhoisContacts>,
    #[serde(rename = "nameServers", default, skip_serializing_if = "Vec::is_empty")]
    pub name_servers: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<String>,
}
impl EnrichmentDomainWhoisDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrichmentDomainWhoisRegistrarDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "abuseContactEmail", default, skip_serializing_if = "Option::is_none")]
    pub abuse_contact_email: Option<String>,
    #[serde(rename = "abuseContactPhone", default, skip_serializing_if = "Option::is_none")]
    pub abuse_contact_phone: Option<String>,
    #[serde(rename = "ianaId", default, skip_serializing_if = "Option::is_none")]
    pub iana_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "whoisServer", default, skip_serializing_if = "Option::is_none")]
    pub whois_server: Option<String>,
}
impl EnrichmentDomainWhoisRegistrarDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnrichmentIpGeodata {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub carrier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    #[serde(rename = "cityCf", default, skip_serializing_if = "Option::is_none")]
    pub city_cf: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub continent: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[serde(rename = "countryCf", default, skip_serializing_if = "Option::is_none")]
    pub country_cf: Option<i32>,
    #[serde(rename = "ipAddr", default, skip_serializing_if = "Option::is_none")]
    pub ip_addr: Option<String>,
    #[serde(rename = "ipRoutingType", default, skip_serializing_if = "Option::is_none")]
    pub ip_routing_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub latitude: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub longitude: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub organization: Option<String>,
    #[serde(rename = "organizationType", default, skip_serializing_if = "Option::is_none")]
    pub organization_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "stateCf", default, skip_serializing_if = "Option::is_none")]
    pub state_cf: Option<i32>,
    #[serde(rename = "stateCode", default, skip_serializing_if = "Option::is_none")]
    pub state_code: Option<String>,
}
impl EnrichmentIpGeodata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Entity {
    #[serde(flatten)]
    pub resource: Resource,
    pub kind: EntityInnerKind,
}
impl Entity {
    pub fn new(kind: EntityInnerKind) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityAnalytics {
    #[serde(flatten)]
    pub settings: Settings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EntityAnalyticsProperties>,
}
impl EntityAnalytics {
    pub fn new(settings: Settings) -> Self {
        Self {
            settings,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityAnalyticsProperties {
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
}
impl EntityAnalyticsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityCommonProperties {
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<serde_json::Value>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl EntityCommonProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityEdges {
    #[serde(rename = "targetEntityId", default, skip_serializing_if = "Option::is_none")]
    pub target_entity_id: Option<String>,
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<serde_json::Value>,
}
impl EntityEdges {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityExpandParameters {
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "expansionId", default, skip_serializing_if = "Option::is_none")]
    pub expansion_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
}
impl EntityExpandParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityExpandResponse {
    #[serde(rename = "metaData", default, skip_serializing_if = "Option::is_none")]
    pub meta_data: Option<ExpansionResultsMetadata>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<entity_expand_response::Value>,
}
impl EntityExpandResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod entity_expand_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Value {
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub entities: Vec<Entity>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub edges: Vec<EntityEdges>,
    }
    impl Value {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityGetInsightsParameters {
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime")]
    pub end_time: String,
    #[serde(rename = "addDefaultExtendedTimeRange", default, skip_serializing_if = "Option::is_none")]
    pub add_default_extended_time_range: Option<bool>,
    #[serde(rename = "insightQueryIds", default, skip_serializing_if = "Vec::is_empty")]
    pub insight_query_ids: Vec<String>,
}
impl EntityGetInsightsParameters {
    pub fn new(start_time: String, end_time: String) -> Self {
        Self {
            start_time,
            end_time,
            add_default_extended_time_range: None,
            insight_query_ids: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityGetInsightsResponse {
    #[serde(rename = "metaData", default, skip_serializing_if = "Option::is_none")]
    pub meta_data: Option<GetInsightsResultsMetadata>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EntityInsightItem>,
}
impl EntityGetInsightsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityInnerKind {
    Account,
    Host,
    File,
    AzureResource,
    CloudApplication,
    DnsResolution,
    FileHash,
    Ip,
    Malware,
    Process,
    RegistryKey,
    RegistryValue,
    SecurityGroup,
    Url,
    IoTDevice,
    SecurityAlert,
    Bookmark,
    Mailbox,
    MailCluster,
    MailMessage,
    SubmissionMail,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityInnerType {
    Account,
    Host,
    File,
    AzureResource,
    CloudApplication,
    #[serde(rename = "DNS")]
    Dns,
    FileHash,
    #[serde(rename = "IP")]
    Ip,
    Malware,
    Process,
    RegistryKey,
    RegistryValue,
    SecurityGroup,
    #[serde(rename = "URL")]
    Url,
    IoTDevice,
    SecurityAlert,
    HuntingBookmark,
    MailCluster,
    MailMessage,
    Mailbox,
    SubmissionMail,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityInsightItem {
    #[serde(rename = "queryId", default, skip_serializing_if = "Option::is_none")]
    pub query_id: Option<String>,
    #[serde(rename = "queryTimeInterval", default, skip_serializing_if = "Option::is_none")]
    pub query_time_interval: Option<entity_insight_item::QueryTimeInterval>,
    #[serde(rename = "tableQueryResults", default, skip_serializing_if = "Option::is_none")]
    pub table_query_results: Option<InsightsTableResult>,
    #[serde(rename = "chartQueryResults", default, skip_serializing_if = "Vec::is_empty")]
    pub chart_query_results: Vec<InsightsTableResult>,
}
impl EntityInsightItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod entity_insight_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct QueryTimeInterval {
        #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
        pub start_time: Option<String>,
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
    }
    impl QueryTimeInterval {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Entity>,
}
impl EntityList {
    pub fn new(value: Vec<Entity>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityMapping {
    #[serde(rename = "entityType", default, skip_serializing_if = "Option::is_none")]
    pub entity_type: Option<EntityMappingType>,
    #[serde(rename = "fieldMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub field_mappings: Vec<FieldMapping>,
}
impl EntityMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityMappingType {
    Account,
    Host,
    #[serde(rename = "IP")]
    Ip,
    Malware,
    File,
    Process,
    CloudApplication,
    #[serde(rename = "DNS")]
    Dns,
    AzureResource,
    FileHash,
    RegistryKey,
    RegistryValue,
    SecurityGroup,
    #[serde(rename = "URL")]
    Url,
    Mailbox,
    MailCluster,
    MailMessage,
    SubmissionMail,
}
pub type EntityMappings = Vec<EntityMapping>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityQuery {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: EntityQueryKind,
}
impl EntityQuery {
    pub fn new(kind: EntityQueryKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityQueryItem {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub kind: EntityQueryKind,
}
impl EntityQueryItem {
    pub fn new(kind: EntityQueryKind) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityQueryItemProperties {
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub data_types: Vec<serde_json::Value>,
    #[serde(rename = "inputEntityType", default, skip_serializing_if = "Option::is_none")]
    pub input_entity_type: Option<EntityInnerType>,
    #[serde(rename = "requiredInputFieldsSets", default, skip_serializing_if = "Vec::is_empty")]
    pub required_input_fields_sets: Vec<Vec<String>>,
    #[serde(rename = "entitiesFilter", default, skip_serializing_if = "Option::is_none")]
    pub entities_filter: Option<serde_json::Value>,
}
impl EntityQueryItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityQueryKind {
    Expansion,
    Insight,
    Activity,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityQueryList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<EntityQuery>,
}
impl EntityQueryList {
    pub fn new(value: Vec<EntityQuery>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityQueryTemplate {
    #[serde(flatten)]
    pub resource: Resource,
    pub kind: EntityQueryTemplateKind,
}
impl EntityQueryTemplate {
    pub fn new(kind: EntityQueryTemplateKind) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityQueryTemplateKind {
    Activity,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityQueryTemplateList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<EntityQueryTemplate>,
}
impl EntityQueryTemplateList {
    pub fn new(value: Vec<EntityQueryTemplate>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityTimelineItem {
    pub kind: EntityTimelineKind,
}
impl EntityTimelineItem {
    pub fn new(kind: EntityTimelineKind) -> Self {
        Self { kind }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityTimelineKind {
    Activity,
    Bookmark,
    SecurityAlert,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityTimelineParameters {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub kinds: Vec<EntityTimelineKind>,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime")]
    pub end_time: String,
    #[serde(rename = "numberOfBucket", default, skip_serializing_if = "Option::is_none")]
    pub number_of_bucket: Option<i32>,
}
impl EntityTimelineParameters {
    pub fn new(start_time: String, end_time: String) -> Self {
        Self {
            kinds: Vec::new(),
            start_time,
            end_time,
            number_of_bucket: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityTimelineResponse {
    #[serde(rename = "metaData", default, skip_serializing_if = "Option::is_none")]
    pub meta_data: Option<TimelineResultsMetadata>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EntityTimelineItem>,
}
impl EntityTimelineResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetail>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetail>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EventGroupingAggregationKind {
    SingleAlert,
    AlertPerResult,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventGroupingSettings {
    #[serde(rename = "aggregationKind", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_kind: Option<EventGroupingAggregationKind>,
}
impl EventGroupingSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpansionEntityQueriesProperties {
    #[serde(rename = "dataSources", default, skip_serializing_if = "Vec::is_empty")]
    pub data_sources: Vec<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "inputEntityType", default, skip_serializing_if = "Option::is_none")]
    pub input_entity_type: Option<EntityInnerType>,
    #[serde(rename = "inputFields", default, skip_serializing_if = "Vec::is_empty")]
    pub input_fields: Vec<String>,
    #[serde(rename = "outputEntityTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub output_entity_types: Vec<EntityInnerType>,
    #[serde(rename = "queryTemplate", default, skip_serializing_if = "Option::is_none")]
    pub query_template: Option<String>,
}
impl ExpansionEntityQueriesProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpansionEntityQuery {
    #[serde(flatten)]
    pub entity_query: EntityQuery,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpansionEntityQueriesProperties>,
}
impl ExpansionEntityQuery {
    pub fn new(entity_query: EntityQuery) -> Self {
        Self {
            entity_query,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpansionResultAggregation {
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    pub count: i32,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "entityKind")]
    pub entity_kind: EntityInnerKind,
}
impl ExpansionResultAggregation {
    pub fn new(count: i32, entity_kind: EntityInnerKind) -> Self {
        Self {
            aggregation_type: None,
            count,
            display_name: None,
            entity_kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpansionResultsMetadata {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub aggregations: Vec<ExpansionResultAggregation>,
}
impl ExpansionResultsMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EyesOn {
    #[serde(flatten)]
    pub settings: Settings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EyesOnSettingsProperties>,
}
impl EyesOn {
    pub fn new(settings: Settings) -> Self {
        Self {
            settings,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EyesOnSettingsProperties {
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
}
impl EyesOnSettingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FieldMapping {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identifier: Option<String>,
    #[serde(rename = "columnName", default, skip_serializing_if = "Option::is_none")]
    pub column_name: Option<String>,
}
impl FieldMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FusionAlertRuleProperties>,
}
impl FusionAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRuleProperties {
    #[serde(rename = "alertRuleTemplateName")]
    pub alert_rule_template_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverityEnum>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl FusionAlertRuleProperties {
    pub fn new(alert_rule_template_name: String, enabled: bool) -> Self {
        Self {
            alert_rule_template_name,
            description: None,
            display_name: None,
            enabled,
            last_modified_utc: None,
            severity: None,
            tactics: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<fusion_alert_rule_template::Properties>,
}
impl FusionAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
pub mod fusion_alert_rule_template {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(flatten)]
        pub alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase,
        pub severity: AlertSeverityEnum,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tactics: Vec<AttackTactic>,
    }
    impl Properties {
        pub fn new(severity: AlertSeverityEnum) -> Self {
            Self {
                alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase::default(),
                severity,
                tactics: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetInsightsError {
    pub kind: get_insights_error::Kind,
    #[serde(rename = "queryId", default, skip_serializing_if = "Option::is_none")]
    pub query_id: Option<String>,
    #[serde(rename = "errorMessage")]
    pub error_message: String,
}
impl GetInsightsError {
    pub fn new(kind: get_insights_error::Kind, error_message: String) -> Self {
        Self {
            kind,
            query_id: None,
            error_message,
        }
    }
}
pub mod get_insights_error {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Insight,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetInsightsResultsMetadata {
    #[serde(rename = "totalCount")]
    pub total_count: i32,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<GetInsightsError>,
}
impl GetInsightsResultsMetadata {
    pub fn new(total_count: i32) -> Self {
        Self {
            total_count,
            errors: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetQueriesResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EntityQueryItem>,
}
impl GetQueriesResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GraphQueries {
    #[serde(rename = "metricName", default, skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub legend: Option<String>,
    #[serde(rename = "baseQuery", default, skip_serializing_if = "Option::is_none")]
    pub base_query: Option<String>,
}
impl GraphQueries {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GroupingConfiguration {
    pub enabled: bool,
    #[serde(rename = "reopenClosedIncident")]
    pub reopen_closed_incident: bool,
    #[serde(rename = "lookbackDuration")]
    pub lookback_duration: String,
    #[serde(rename = "matchingMethod")]
    pub matching_method: grouping_configuration::MatchingMethod,
    #[serde(rename = "groupByEntities", default, skip_serializing_if = "Vec::is_empty")]
    pub group_by_entities: Vec<EntityMappingType>,
    #[serde(rename = "groupByAlertDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub group_by_alert_details: Vec<String>,
    #[serde(rename = "groupByCustomDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub group_by_custom_details: Vec<String>,
}
impl GroupingConfiguration {
    pub fn new(
        enabled: bool,
        reopen_closed_incident: bool,
        lookback_duration: String,
        matching_method: grouping_configuration::MatchingMethod,
    ) -> Self {
        Self {
            enabled,
            reopen_closed_incident,
            lookback_duration,
            matching_method,
            group_by_entities: Vec::new(),
            group_by_alert_details: Vec::new(),
            group_by_custom_details: Vec::new(),
        }
    }
}
pub mod grouping_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MatchingMethod {
        AllEntities,
        AnyAlert,
        Selected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HuntingBookmark {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HuntingBookmarkProperties>,
}
impl HuntingBookmark {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HuntingBookmarkProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(rename = "eventTime", default, skip_serializing_if = "Option::is_none")]
    pub event_time: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<Label>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    pub query: String,
    #[serde(rename = "queryResult", default, skip_serializing_if = "Option::is_none")]
    pub query_result: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<UserInfo>,
    #[serde(rename = "incidentInfo", default, skip_serializing_if = "Option::is_none")]
    pub incident_info: Option<IncidentInfo>,
}
impl HuntingBookmarkProperties {
    pub fn new(display_name: String, query: String) -> Self {
        Self {
            entity_common_properties: EntityCommonProperties::default(),
            created: None,
            created_by: None,
            display_name,
            event_time: None,
            labels: Vec::new(),
            notes: None,
            query,
            query_result: None,
            updated: None,
            updated_by: None,
            incident_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Incident {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IncidentProperties>,
}
impl Incident {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentAdditionalData {
    #[serde(rename = "alertsCount", default, skip_serializing_if = "Option::is_none")]
    pub alerts_count: Option<i32>,
    #[serde(rename = "bookmarksCount", default, skip_serializing_if = "Option::is_none")]
    pub bookmarks_count: Option<i32>,
    #[serde(rename = "commentsCount", default, skip_serializing_if = "Option::is_none")]
    pub comments_count: Option<i32>,
    #[serde(rename = "alertProductNames", default, skip_serializing_if = "Vec::is_empty")]
    pub alert_product_names: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl IncidentAdditionalData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentAlertList {
    pub value: Vec<SecurityAlert>,
}
impl IncidentAlertList {
    pub fn new(value: Vec<SecurityAlert>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentBookmarkList {
    pub value: Vec<HuntingBookmark>,
}
impl IncidentBookmarkList {
    pub fn new(value: Vec<HuntingBookmark>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IncidentClassificationEnum {
    Undetermined,
    TruePositive,
    BenignPositive,
    FalsePositive,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IncidentClassificationReasonEnum {
    SuspiciousActivity,
    SuspiciousButExpected,
    IncorrectAlertLogic,
    InaccurateData,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentComment {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IncidentCommentProperties>,
}
impl IncidentComment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentCommentList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<IncidentComment>,
}
impl IncidentCommentList {
    pub fn new(value: Vec<IncidentComment>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentCommentProperties {
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time_utc: Option<String>,
    pub message: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<ClientInfo>,
}
impl IncidentCommentProperties {
    pub fn new(message: String) -> Self {
        Self {
            created_time_utc: None,
            last_modified_time_utc: None,
            message,
            author: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentConfiguration {
    #[serde(rename = "createIncident")]
    pub create_incident: bool,
    #[serde(rename = "groupingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub grouping_configuration: Option<GroupingConfiguration>,
}
impl IncidentConfiguration {
    pub fn new(create_incident: bool) -> Self {
        Self {
            create_incident,
            grouping_configuration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentEntitiesResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub entities: Vec<Entity>,
    #[serde(rename = "metaData", default, skip_serializing_if = "Vec::is_empty")]
    pub meta_data: Vec<IncidentEntitiesResultsMetadata>,
}
impl IncidentEntitiesResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentEntitiesResultsMetadata {
    pub count: i32,
    #[serde(rename = "entityKind")]
    pub entity_kind: EntityInnerKind,
}
impl IncidentEntitiesResultsMetadata {
    pub fn new(count: i32, entity_kind: EntityInnerKind) -> Self {
        Self { count, entity_kind }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentInfo {
    #[serde(rename = "incidentId", default, skip_serializing_if = "Option::is_none")]
    pub incident_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<IncidentSeverityEnum>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(rename = "relationName", default, skip_serializing_if = "Option::is_none")]
    pub relation_name: Option<String>,
}
impl IncidentInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentLabel {
    #[serde(rename = "labelName")]
    pub label_name: String,
    #[serde(rename = "labelType", default, skip_serializing_if = "Option::is_none")]
    pub label_type: Option<incident_label::LabelType>,
}
impl IncidentLabel {
    pub fn new(label_name: String) -> Self {
        Self {
            label_name,
            label_type: None,
        }
    }
}
pub mod incident_label {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LabelType {
        User,
        System,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Incident>,
}
impl IncidentList {
    pub fn new(value: Vec<Incident>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentOwnerInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(rename = "assignedTo", default, skip_serializing_if = "Option::is_none")]
    pub assigned_to: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
    #[serde(rename = "ownerType", default, skip_serializing_if = "Option::is_none")]
    pub owner_type: Option<incident_owner_info::OwnerType>,
}
impl IncidentOwnerInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod incident_owner_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OwnerType {
        Unknown,
        User,
        Group,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentProperties {
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<IncidentAdditionalData>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub classification: Option<IncidentClassificationEnum>,
    #[serde(rename = "classificationComment", default, skip_serializing_if = "Option::is_none")]
    pub classification_comment: Option<String>,
    #[serde(rename = "classificationReason", default, skip_serializing_if = "Option::is_none")]
    pub classification_reason: Option<IncidentClassificationReasonEnum>,
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "firstActivityTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub first_activity_time_utc: Option<String>,
    #[serde(rename = "incidentUrl", default, skip_serializing_if = "Option::is_none")]
    pub incident_url: Option<String>,
    #[serde(rename = "incidentNumber", default, skip_serializing_if = "Option::is_none")]
    pub incident_number: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<IncidentLabel>,
    #[serde(rename = "providerName", default, skip_serializing_if = "Option::is_none")]
    pub provider_name: Option<String>,
    #[serde(rename = "providerIncidentId", default, skip_serializing_if = "Option::is_none")]
    pub provider_incident_id: Option<String>,
    #[serde(rename = "lastActivityTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_activity_time_utc: Option<String>,
    #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub owner: Option<IncidentOwnerInfo>,
    #[serde(rename = "relatedAnalyticRuleIds", default, skip_serializing_if = "Vec::is_empty")]
    pub related_analytic_rule_ids: Vec<String>,
    pub severity: IncidentSeverityEnum,
    pub status: IncidentStatusEnum,
    #[serde(rename = "teamInformation", default, skip_serializing_if = "Option::is_none")]
    pub team_information: Option<TeamInformation>,
    pub title: String,
}
impl IncidentProperties {
    pub fn new(severity: IncidentSeverityEnum, status: IncidentStatusEnum, title: String) -> Self {
        Self {
            additional_data: None,
            classification: None,
            classification_comment: None,
            classification_reason: None,
            created_time_utc: None,
            description: None,
            first_activity_time_utc: None,
            incident_url: None,
            incident_number: None,
            labels: Vec::new(),
            provider_name: None,
            provider_incident_id: None,
            last_activity_time_utc: None,
            last_modified_time_utc: None,
            owner: None,
            related_analytic_rule_ids: Vec::new(),
            severity,
            status,
            team_information: None,
            title,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IncidentSeverityEnum {
    High,
    Medium,
    Low,
    Informational,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IncidentStatusEnum {
    New,
    Active,
    Closed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InsightQueryItem {
    #[serde(flatten)]
    pub entity_query_item: EntityQueryItem,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InsightQueryItemProperties>,
}
impl InsightQueryItem {
    pub fn new(entity_query_item: EntityQueryItem) -> Self {
        Self {
            entity_query_item,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InsightQueryItemProperties {
    #[serde(flatten)]
    pub entity_query_item_properties: EntityQueryItemProperties,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "baseQuery", default, skip_serializing_if = "Option::is_none")]
    pub base_query: Option<String>,
    #[serde(rename = "tableQuery", default, skip_serializing_if = "Option::is_none")]
    pub table_query: Option<insight_query_item_properties::TableQuery>,
    #[serde(rename = "chartQuery", default, skip_serializing_if = "Option::is_none")]
    pub chart_query: Option<serde_json::Value>,
    #[serde(rename = "additionalQuery", default, skip_serializing_if = "Option::is_none")]
    pub additional_query: Option<insight_query_item_properties::AdditionalQuery>,
    #[serde(rename = "defaultTimeRange", default, skip_serializing_if = "Option::is_none")]
    pub default_time_range: Option<insight_query_item_properties::DefaultTimeRange>,
    #[serde(rename = "referenceTimeRange", default, skip_serializing_if = "Option::is_none")]
    pub reference_time_range: Option<insight_query_item_properties::ReferenceTimeRange>,
}
impl InsightQueryItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod insight_query_item_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct TableQuery {
        #[serde(rename = "columnsDefinitions", default, skip_serializing_if = "Vec::is_empty")]
        pub columns_definitions: Vec<serde_json::Value>,
        #[serde(rename = "queriesDefinitions", default, skip_serializing_if = "Vec::is_empty")]
        pub queries_definitions: Vec<serde_json::Value>,
    }
    impl TableQuery {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct AdditionalQuery {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub query: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub text: Option<String>,
    }
    impl AdditionalQuery {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct DefaultTimeRange {
        #[serde(rename = "beforeRange", default, skip_serializing_if = "Option::is_none")]
        pub before_range: Option<String>,
        #[serde(rename = "afterRange", default, skip_serializing_if = "Option::is_none")]
        pub after_range: Option<String>,
    }
    impl DefaultTimeRange {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ReferenceTimeRange {
        #[serde(rename = "beforeRange", default, skip_serializing_if = "Option::is_none")]
        pub before_range: Option<String>,
    }
    impl ReferenceTimeRange {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InsightsTableResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rows: Vec<Vec<String>>,
}
impl InsightsTableResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstructionSteps {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub instructions: Vec<serde_json::Value>,
}
impl InstructionSteps {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type Label = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LastDataReceivedDataType {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "lastDataReceivedQuery", default, skip_serializing_if = "Option::is_none")]
    pub last_data_received_query: Option<String>,
}
impl LastDataReceivedDataType {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<McasCheckRequirementsProperties>,
}
impl McasCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl McasCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<McasDataConnectorProperties>,
}
impl McasDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasDataConnectorDataTypes {
    #[serde(flatten)]
    pub alerts_data_type_of_data_connector: AlertsDataTypeOfDataConnector,
    #[serde(rename = "discoveryLogs", default, skip_serializing_if = "Option::is_none")]
    pub discovery_logs: Option<DataConnectorDataTypeCommon>,
}
impl McasDataConnectorDataTypes {
    pub fn new(alerts_data_type_of_data_connector: AlertsDataTypeOfDataConnector) -> Self {
        Self {
            alerts_data_type_of_data_connector,
            discovery_logs: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: McasDataConnectorDataTypes,
}
impl McasDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: McasDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MdatpCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MdatpCheckRequirementsProperties>,
}
impl MdatpCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MdatpCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl MdatpCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MdatpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MdatpDataConnectorProperties>,
}
impl MdatpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MdatpDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
}
impl MdatpDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self {
            data_connector_tenant_id,
            data_connector_with_alerts_properties: DataConnectorWithAlertsProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MlBehaviorAnalyticsAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MlBehaviorAnalyticsAlertRuleProperties>,
}
impl MlBehaviorAnalyticsAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MlBehaviorAnalyticsAlertRuleProperties {
    #[serde(rename = "alertRuleTemplateName")]
    pub alert_rule_template_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverityEnum>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl MlBehaviorAnalyticsAlertRuleProperties {
    pub fn new(alert_rule_template_name: String, enabled: bool) -> Self {
        Self {
            alert_rule_template_name,
            description: None,
            display_name: None,
            enabled,
            last_modified_utc: None,
            severity: None,
            tactics: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MlBehaviorAnalyticsAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ml_behavior_analytics_alert_rule_template::Properties>,
}
impl MlBehaviorAnalyticsAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
pub mod ml_behavior_analytics_alert_rule_template {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(flatten)]
        pub alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase,
        pub severity: AlertSeverityEnum,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tactics: Vec<AttackTactic>,
    }
    impl Properties {
        pub fn new(severity: AlertSeverityEnum) -> Self {
            Self {
                alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase::default(),
                severity,
                tactics: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MstiCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MstiCheckRequirementsProperties>,
}
impl MstiCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MstiCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl MstiCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MstiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MstiDataConnectorProperties>,
}
impl MstiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MstiDataConnectorDataTypes {
    #[serde(rename = "bingSafetyPhishingURL")]
    pub bing_safety_phishing_url: msti_data_connector_data_types::BingSafetyPhishingUrl,
    #[serde(rename = "microsoftEmergingThreatFeed")]
    pub microsoft_emerging_threat_feed: msti_data_connector_data_types::MicrosoftEmergingThreatFeed,
}
impl MstiDataConnectorDataTypes {
    pub fn new(
        bing_safety_phishing_url: msti_data_connector_data_types::BingSafetyPhishingUrl,
        microsoft_emerging_threat_feed: msti_data_connector_data_types::MicrosoftEmergingThreatFeed,
    ) -> Self {
        Self {
            bing_safety_phishing_url,
            microsoft_emerging_threat_feed,
        }
    }
}
pub mod msti_data_connector_data_types {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct BingSafetyPhishingUrl {
        #[serde(flatten)]
        pub data_connector_data_type_common: DataConnectorDataTypeCommon,
        #[serde(rename = "lookbackPeriod")]
        pub lookback_period: String,
    }
    impl BingSafetyPhishingUrl {
        pub fn new(data_connector_data_type_common: DataConnectorDataTypeCommon, lookback_period: String) -> Self {
            Self {
                data_connector_data_type_common,
                lookback_period,
            }
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct MicrosoftEmergingThreatFeed {
        #[serde(flatten)]
        pub data_connector_data_type_common: DataConnectorDataTypeCommon,
        #[serde(rename = "lookbackPeriod")]
        pub lookback_period: String,
    }
    impl MicrosoftEmergingThreatFeed {
        pub fn new(data_connector_data_type_common: DataConnectorDataTypeCommon, lookback_period: String) -> Self {
            Self {
                data_connector_data_type_common,
                lookback_period,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MstiDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: MstiDataConnectorDataTypes,
}
impl MstiDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: MstiDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MtpCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl MtpCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MtpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MtpDataConnectorProperties>,
}
impl MtpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MtpDataConnectorDataTypes {
    pub incidents: serde_json::Value,
}
impl MtpDataConnectorDataTypes {
    pub fn new(incidents: serde_json::Value) -> Self {
        Self { incidents }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MtpDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: MtpDataConnectorDataTypes,
}
impl MtpDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: MtpDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataList {
    pub value: Vec<MetadataModel>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MetadataList {
    pub fn new(value: Vec<MetadataModel>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataModel {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MetadataProperties>,
}
impl MetadataModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MicrosoftSecurityIncidentCreationAlertRuleProperties>,
}
impl MicrosoftSecurityIncidentCreationAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleCommonProperties {
    #[serde(rename = "displayNamesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_filter: Vec<String>,
    #[serde(rename = "displayNamesExcludeFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_exclude_filter: Vec<String>,
    #[serde(rename = "productFilter")]
    pub product_filter: microsoft_security_incident_creation_alert_rule_common_properties::ProductFilter,
    #[serde(rename = "severitiesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub severities_filter: Vec<AlertSeverityEnum>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleCommonProperties {
    pub fn new(product_filter: microsoft_security_incident_creation_alert_rule_common_properties::ProductFilter) -> Self {
        Self {
            display_names_filter: Vec::new(),
            display_names_exclude_filter: Vec::new(),
            product_filter,
            severities_filter: Vec::new(),
        }
    }
}
pub mod microsoft_security_incident_creation_alert_rule_common_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProductFilter {
        #[serde(rename = "Microsoft Cloud App Security")]
        MicrosoftCloudAppSecurity,
        #[serde(rename = "Azure Security Center")]
        AzureSecurityCenter,
        #[serde(rename = "Azure Advanced Threat Protection")]
        AzureAdvancedThreatProtection,
        #[serde(rename = "Azure Active Directory Identity Protection")]
        AzureActiveDirectoryIdentityProtection,
        #[serde(rename = "Azure Security Center for IoT")]
        AzureSecurityCenterForIoT,
        #[serde(rename = "Office 365 Advanced Threat Protection")]
        Office365AdvancedThreatProtection,
        #[serde(rename = "Microsoft Defender Advanced Threat Protection")]
        MicrosoftDefenderAdvancedThreatProtection,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleProperties {
    #[serde(flatten)]
    pub microsoft_security_incident_creation_alert_rule_common_properties: MicrosoftSecurityIncidentCreationAlertRuleCommonProperties,
    #[serde(rename = "alertRuleTemplateName", default, skip_serializing_if = "Option::is_none")]
    pub alert_rule_template_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleProperties {
    pub fn new(
        microsoft_security_incident_creation_alert_rule_common_properties: MicrosoftSecurityIncidentCreationAlertRuleCommonProperties,
        display_name: String,
        enabled: bool,
    ) -> Self {
        Self {
            microsoft_security_incident_creation_alert_rule_common_properties,
            alert_rule_template_name: None,
            description: None,
            display_name,
            enabled,
            last_modified_utc: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MtpCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MtpCheckRequirementsProperties>,
}
impl MtpCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NrtAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NrtAlertRuleProperties>,
}
impl NrtAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NrtAlertRuleProperties {
    #[serde(flatten)]
    pub query_based_alert_rule_properties: QueryBasedAlertRuleProperties,
}
impl NrtAlertRuleProperties {
    pub fn new(query_based_alert_rule_properties: QueryBasedAlertRuleProperties) -> Self {
        Self {
            query_based_alert_rule_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NrtAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl NrtAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeAtpCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeAtpCheckRequirementsProperties>,
}
impl OfficeAtpCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeAtpCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl OfficeAtpCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeAtpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeAtpDataConnectorProperties>,
}
impl OfficeAtpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeAtpDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
}
impl OfficeAtpDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self {
            data_connector_tenant_id,
            data_connector_with_alerts_properties: DataConnectorWithAlertsProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeConsent {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeConsentProperties>,
}
impl OfficeConsent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeConsentList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<OfficeConsent>,
}
impl OfficeConsentList {
    pub fn new(value: Vec<OfficeConsent>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeConsentProperties {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "consentId", default, skip_serializing_if = "Option::is_none")]
    pub consent_id: Option<String>,
}
impl OfficeConsentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeDataConnectorProperties>,
}
impl OfficeDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeDataConnectorDataTypes {
    pub exchange: serde_json::Value,
    #[serde(rename = "sharePoint")]
    pub share_point: serde_json::Value,
    pub teams: serde_json::Value,
}
impl OfficeDataConnectorDataTypes {
    pub fn new(exchange: serde_json::Value, share_point: serde_json::Value, teams: serde_json::Value) -> Self {
        Self {
            exchange,
            share_point,
            teams,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: OfficeDataConnectorDataTypes,
}
impl OfficeDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: OfficeDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeIrmCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeIrmCheckRequirementsProperties>,
}
impl OfficeIrmCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeIrmCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl OfficeIrmCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeIrmDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeIrmDataConnectorProperties>,
}
impl OfficeIrmDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeIrmDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
}
impl OfficeIrmDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self {
            data_connector_tenant_id,
            data_connector_with_alerts_properties: DataConnectorWithAlertsProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(rename = "isDataAction", default, skip_serializing_if = "Option::is_none")]
    pub is_data_action: Option<bool>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationsList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Operation>,
}
impl OperationsList {
    pub fn new(value: Vec<Operation>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Permissions {
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_provider: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub customs: Vec<serde_json::Value>,
}
impl Permissions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryBasedAlertRuleProperties {
    #[serde(rename = "alertRuleTemplateName", default, skip_serializing_if = "Option::is_none")]
    pub alert_rule_template_name: Option<String>,
    #[serde(rename = "templateVersion", default, skip_serializing_if = "Option::is_none")]
    pub template_version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(rename = "suppressionDuration")]
    pub suppression_duration: String,
    #[serde(rename = "suppressionEnabled")]
    pub suppression_enabled: bool,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverityEnum>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
    #[serde(rename = "incidentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub incident_configuration: Option<IncidentConfiguration>,
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<serde_json::Value>,
    #[serde(rename = "entityMappings", default, skip_serializing_if = "Option::is_none")]
    pub entity_mappings: Option<EntityMappings>,
    #[serde(rename = "alertDetailsOverride", default, skip_serializing_if = "Option::is_none")]
    pub alert_details_override: Option<AlertDetailsOverride>,
}
impl QueryBasedAlertRuleProperties {
    pub fn new(display_name: String, enabled: bool, suppression_duration: String, suppression_enabled: bool) -> Self {
        Self {
            alert_rule_template_name: None,
            template_version: None,
            description: None,
            query: None,
            display_name,
            enabled,
            last_modified_utc: None,
            suppression_duration,
            suppression_enabled,
            severity: None,
            tactics: Vec::new(),
            incident_configuration: None,
            custom_details: None,
            entity_mappings: None,
            alert_details_override: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryBasedAlertRuleTemplateProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverityEnum>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<serde_json::Value>,
    #[serde(rename = "entityMappings", default, skip_serializing_if = "Option::is_none")]
    pub entity_mappings: Option<EntityMappings>,
    #[serde(rename = "alertDetailsOverride", default, skip_serializing_if = "Option::is_none")]
    pub alert_details_override: Option<AlertDetailsOverride>,
}
impl QueryBasedAlertRuleTemplateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Relation {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RelationProperties>,
}
impl Relation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RelationList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Relation>,
}
impl RelationList {
    pub fn new(value: Vec<Relation>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RelationProperties {
    #[serde(rename = "relatedResourceId")]
    pub related_resource_id: String,
    #[serde(rename = "relatedResourceName", default, skip_serializing_if = "Option::is_none")]
    pub related_resource_name: Option<String>,
    #[serde(rename = "relatedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub related_resource_type: Option<String>,
    #[serde(rename = "relatedResourceKind", default, skip_serializing_if = "Option::is_none")]
    pub related_resource_kind: Option<String>,
}
impl RelationProperties {
    pub fn new(related_resource_id: String) -> Self {
        Self {
            related_resource_id,
            related_resource_name: None,
            related_resource_type: None,
            related_resource_kind: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Repo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "fullName", default, skip_serializing_if = "Option::is_none")]
    pub full_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub branches: Vec<String>,
}
impl Repo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RepoList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Repo>,
}
impl RepoList {
    pub fn new(value: Vec<Repo>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RepoType {
    Github,
    DevOps,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Repository {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[serde(rename = "displayUrl", default, skip_serializing_if = "Option::is_none")]
    pub display_url: Option<String>,
    #[serde(rename = "deploymentLogsUrl", default, skip_serializing_if = "Option::is_none")]
    pub deployment_logs_url: Option<String>,
    #[serde(rename = "pathMapping", default, skip_serializing_if = "Vec::is_empty")]
    pub path_mapping: Vec<ContentPathMap>,
}
impl Repository {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequiredPermissions {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub write: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub read: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub delete: Option<bool>,
}
impl RequiredPermissions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProvider {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<resource_provider::Provider>,
    #[serde(rename = "permissionsDisplayText", default, skip_serializing_if = "Option::is_none")]
    pub permissions_display_text: Option<String>,
    #[serde(rename = "providerDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub provider_display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<resource_provider::Scope>,
    #[serde(rename = "requiredPermissions", default, skip_serializing_if = "Option::is_none")]
    pub required_permissions: Option<RequiredPermissions>,
}
impl ResourceProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_provider {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Provider {
        #[serde(rename = "Microsoft.OperationalInsights/solutions")]
        MicrosoftOperationalInsightsSolutions,
        #[serde(rename = "Microsoft.OperationalInsights/workspaces")]
        MicrosoftOperationalInsightsWorkspaces,
        #[serde(rename = "Microsoft.OperationalInsights/workspaces/datasources")]
        MicrosoftOperationalInsightsWorkspacesDatasources,
        #[serde(rename = "microsoft.aadiam/diagnosticSettings")]
        MicrosoftAadiamDiagnosticSettings,
        #[serde(rename = "Microsoft.OperationalInsights/workspaces/sharedKeys")]
        MicrosoftOperationalInsightsWorkspacesSharedKeys,
        #[serde(rename = "Microsoft.Authorization/policyAssignments")]
        MicrosoftAuthorizationPolicyAssignments,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Scope {
        ResourceGroup,
        Subscription,
        Workspace,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceWithEtag {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ResourceWithEtag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SampleQueries {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
}
impl SampleQueries {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScheduledAlertRuleProperties>,
}
impl ScheduledAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduledAlertRuleCommonProperties {
    #[serde(rename = "queryFrequency", default, skip_serializing_if = "Option::is_none")]
    pub query_frequency: Option<String>,
    #[serde(rename = "queryPeriod", default, skip_serializing_if = "Option::is_none")]
    pub query_period: Option<String>,
    #[serde(rename = "triggerOperator", default, skip_serializing_if = "Option::is_none")]
    pub trigger_operator: Option<AlertRuleTriggerOperator>,
    #[serde(rename = "triggerThreshold", default, skip_serializing_if = "Option::is_none")]
    pub trigger_threshold: Option<i32>,
    #[serde(rename = "eventGroupingSettings", default, skip_serializing_if = "Option::is_none")]
    pub event_grouping_settings: Option<EventGroupingSettings>,
}
impl ScheduledAlertRuleCommonProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRuleProperties {
    #[serde(flatten)]
    pub scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties,
    #[serde(flatten)]
    pub query_based_alert_rule_properties: QueryBasedAlertRuleProperties,
}
impl ScheduledAlertRuleProperties {
    pub fn new(query_based_alert_rule_properties: QueryBasedAlertRuleProperties) -> Self {
        Self {
            scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties::default(),
            query_based_alert_rule_properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<scheduled_alert_rule_template::Properties>,
}
impl ScheduledAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
pub mod scheduled_alert_rule_template {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(flatten)]
        pub alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase,
        #[serde(flatten)]
        pub query_based_alert_rule_template_properties: QueryBasedAlertRuleTemplateProperties,
        #[serde(flatten)]
        pub scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tactics: Vec<AttackTactic>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self {
                alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase::default(),
                query_based_alert_rule_template_properties: QueryBasedAlertRuleTemplateProperties::default(),
                scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties::default(),
                tactics: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAlert {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityAlertProperties>,
}
impl SecurityAlert {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAlertProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "alertDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub alert_display_name: Option<String>,
    #[serde(rename = "alertType", default, skip_serializing_if = "Option::is_none")]
    pub alert_type: Option<String>,
    #[serde(rename = "compromisedEntity", default, skip_serializing_if = "Option::is_none")]
    pub compromised_entity: Option<String>,
    #[serde(rename = "confidenceLevel", default, skip_serializing_if = "Option::is_none")]
    pub confidence_level: Option<security_alert_properties::ConfidenceLevel>,
    #[serde(rename = "confidenceReasons", default, skip_serializing_if = "Vec::is_empty")]
    pub confidence_reasons: Vec<serde_json::Value>,
    #[serde(rename = "confidenceScore", default, skip_serializing_if = "Option::is_none")]
    pub confidence_score: Option<f64>,
    #[serde(rename = "confidenceScoreStatus", default, skip_serializing_if = "Option::is_none")]
    pub confidence_score_status: Option<security_alert_properties::ConfidenceScoreStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "endTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub end_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub intent: Option<security_alert_properties::Intent>,
    #[serde(rename = "providerAlertId", default, skip_serializing_if = "Option::is_none")]
    pub provider_alert_id: Option<String>,
    #[serde(rename = "processingEndTime", default, skip_serializing_if = "Option::is_none")]
    pub processing_end_time: Option<String>,
    #[serde(rename = "productComponentName", default, skip_serializing_if = "Option::is_none")]
    pub product_component_name: Option<String>,
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[serde(rename = "productVersion", default, skip_serializing_if = "Option::is_none")]
    pub product_version: Option<String>,
    #[serde(rename = "remediationSteps", default, skip_serializing_if = "Vec::is_empty")]
    pub remediation_steps: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverityEnum>,
    #[serde(rename = "startTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub start_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<security_alert_properties::Status>,
    #[serde(rename = "systemAlertId", default, skip_serializing_if = "Option::is_none")]
    pub system_alert_id: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
    #[serde(rename = "timeGenerated", default, skip_serializing_if = "Option::is_none")]
    pub time_generated: Option<String>,
    #[serde(rename = "vendorName", default, skip_serializing_if = "Option::is_none")]
    pub vendor_name: Option<String>,
    #[serde(rename = "alertLink", default, skip_serializing_if = "Option::is_none")]
    pub alert_link: Option<String>,
    #[serde(rename = "resourceIdentifiers", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_identifiers: Vec<serde_json::Value>,
}
impl SecurityAlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod security_alert_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConfidenceLevel {
        Unknown,
        Low,
        High,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConfidenceScoreStatus {
        NotApplicable,
        InProcess,
        NotFinal,
        Final,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Intent {
        Unknown,
        Probing,
        Exploitation,
        Persistence,
        PrivilegeEscalation,
        DefenseEvasion,
        CredentialAccess,
        Discovery,
        LateralMovement,
        Execution,
        Collection,
        Exfiltration,
        CommandAndControl,
        Impact,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Unknown,
        New,
        Resolved,
        Dismissed,
        InProgress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAlertTimelineItem {
    #[serde(flatten)]
    pub entity_timeline_item: EntityTimelineItem,
    #[serde(rename = "azureResourceId")]
    pub azure_resource_id: String,
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub severity: AlertSeverityEnum,
    #[serde(rename = "endTimeUtc")]
    pub end_time_utc: String,
    #[serde(rename = "startTimeUtc")]
    pub start_time_utc: String,
    #[serde(rename = "timeGenerated")]
    pub time_generated: String,
    #[serde(rename = "alertType")]
    pub alert_type: String,
}
impl SecurityAlertTimelineItem {
    pub fn new(
        entity_timeline_item: EntityTimelineItem,
        azure_resource_id: String,
        display_name: String,
        severity: AlertSeverityEnum,
        end_time_utc: String,
        start_time_utc: String,
        time_generated: String,
        alert_type: String,
    ) -> Self {
        Self {
            entity_timeline_item,
            azure_resource_id,
            product_name: None,
            description: None,
            display_name,
            severity,
            end_time_utc,
            start_time_utc,
            time_generated,
            alert_type,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SentinelOnboardingState {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SentinelOnboardingStateProperties>,
}
impl SentinelOnboardingState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SentinelOnboardingStateProperties {
    #[serde(rename = "customerManagedKey", default, skip_serializing_if = "Option::is_none")]
    pub customer_managed_key: Option<bool>,
}
impl SentinelOnboardingStateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SentinelOnboardingStatesList {
    pub value: Vec<SentinelOnboardingState>,
}
impl SentinelOnboardingStatesList {
    pub fn new(value: Vec<SentinelOnboardingState>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SettingList {
    pub value: Vec<Settings>,
}
impl SettingList {
    pub fn new(value: Vec<Settings>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Settings {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: settings::Kind,
}
impl Settings {
    pub fn new(kind: settings::Kind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
pub mod settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Anomalies,
        EyesOn,
        EntityAnalytics,
        Ueba,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<sku::Name>,
    #[serde(rename = "capacityReservationLevel", default, skip_serializing_if = "Option::is_none")]
    pub capacity_reservation_level: Option<i32>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "PerGB")]
        PerGb,
        CapacityReservation,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceControl {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SourceControlProperties>,
}
impl SourceControl {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceControlList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<SourceControl>,
}
impl SourceControlList {
    pub fn new(value: Vec<SourceControl>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceControlProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "repoType")]
    pub repo_type: RepoType,
    #[serde(rename = "contentTypes")]
    pub content_types: Vec<ContentType>,
    pub repository: Repository,
}
impl SourceControlProperties {
    pub fn new(display_name: String, repo_type: RepoType, content_types: Vec<ContentType>, repository: Repository) -> Self {
        Self {
            id: None,
            display_name,
            description: None,
            repo_type,
            content_types,
            repository,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TiCheckRequirementsProperties>,
}
impl TiCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl TiCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TiDataConnectorProperties>,
}
impl TiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiDataConnectorDataTypes {
    pub indicators: serde_json::Value,
}
impl TiDataConnectorDataTypes {
    pub fn new(indicators: serde_json::Value) -> Self {
        Self { indicators }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "tipLookbackPeriod", default, skip_serializing_if = "Option::is_none")]
    pub tip_lookback_period: Option<String>,
    #[serde(rename = "dataTypes")]
    pub data_types: TiDataConnectorDataTypes,
}
impl TiDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: TiDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            tip_lookback_period: None,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeamInformation {
    #[serde(rename = "teamId", default, skip_serializing_if = "Option::is_none")]
    pub team_id: Option<String>,
    #[serde(rename = "primaryChannelUrl", default, skip_serializing_if = "Option::is_none")]
    pub primary_channel_url: Option<String>,
    #[serde(rename = "teamCreationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub team_creation_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl TeamInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeamProperties {
    #[serde(rename = "teamName")]
    pub team_name: String,
    #[serde(rename = "teamDescription", default, skip_serializing_if = "Option::is_none")]
    pub team_description: Option<String>,
    #[serde(rename = "memberIds", default, skip_serializing_if = "Vec::is_empty")]
    pub member_ids: Vec<String>,
    #[serde(rename = "groupIds", default, skip_serializing_if = "Vec::is_empty")]
    pub group_ids: Vec<String>,
}
impl TeamProperties {
    pub fn new(team_name: String) -> Self {
        Self {
            team_name,
            team_description: None,
            member_ids: Vec::new(),
            group_ids: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ThreatIntelligenceAlertRuleProperties>,
}
impl ThreatIntelligenceAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceAlertRuleProperties {
    #[serde(rename = "alertRuleTemplateName")]
    pub alert_rule_template_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverityEnum>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl ThreatIntelligenceAlertRuleProperties {
    pub fn new(alert_rule_template_name: String, enabled: bool) -> Self {
        Self {
            alert_rule_template_name,
            description: None,
            display_name: None,
            enabled,
            last_modified_utc: None,
            severity: None,
            tactics: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<threat_intelligence_alert_rule_template::Properties>,
}
impl ThreatIntelligenceAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
pub mod threat_intelligence_alert_rule_template {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(flatten)]
        pub alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase,
        pub severity: AlertSeverityEnum,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tactics: Vec<AttackTactic>,
    }
    impl Properties {
        pub fn new(severity: AlertSeverityEnum) -> Self {
            Self {
                alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase::default(),
                severity,
                tactics: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceAppendTags {
    #[serde(rename = "threatIntelligenceTags", default, skip_serializing_if = "Vec::is_empty")]
    pub threat_intelligence_tags: Vec<String>,
}
impl ThreatIntelligenceAppendTags {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceExternalReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "externalId", default, skip_serializing_if = "Option::is_none")]
    pub external_id: Option<String>,
    #[serde(rename = "sourceName", default, skip_serializing_if = "Option::is_none")]
    pub source_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub hashes: Option<serde_json::Value>,
}
impl ThreatIntelligenceExternalReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceFilteringCriteria {
    #[serde(rename = "pageSize", default, skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i32>,
    #[serde(rename = "minConfidence", default, skip_serializing_if = "Option::is_none")]
    pub min_confidence: Option<i32>,
    #[serde(rename = "maxConfidence", default, skip_serializing_if = "Option::is_none")]
    pub max_confidence: Option<i32>,
    #[serde(rename = "minValidUntil", default, skip_serializing_if = "Option::is_none")]
    pub min_valid_until: Option<String>,
    #[serde(rename = "maxValidUntil", default, skip_serializing_if = "Option::is_none")]
    pub max_valid_until: Option<String>,
    #[serde(rename = "includeDisabled", default, skip_serializing_if = "Option::is_none")]
    pub include_disabled: Option<bool>,
    #[serde(rename = "sortBy", default, skip_serializing_if = "Vec::is_empty")]
    pub sort_by: Vec<ThreatIntelligenceSortingCriteria>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<String>,
    #[serde(rename = "patternTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub pattern_types: Vec<String>,
    #[serde(rename = "threatTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub threat_types: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub ids: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub keywords: Vec<String>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ThreatIntelligenceFilteringCriteria {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceGranularMarkingModel {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<String>,
    #[serde(rename = "markingRef", default, skip_serializing_if = "Option::is_none")]
    pub marking_ref: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub selectors: Vec<String>,
}
impl ThreatIntelligenceGranularMarkingModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceIndicatorModel {
    #[serde(flatten)]
    pub threat_intelligence_information: ThreatIntelligenceInformation,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ThreatIntelligenceIndicatorProperties>,
}
impl ThreatIntelligenceIndicatorModel {
    pub fn new(threat_intelligence_information: ThreatIntelligenceInformation) -> Self {
        Self {
            threat_intelligence_information,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceIndicatorModelForRequestBody {
    #[serde(flatten)]
    pub threat_intelligence_resource_kind: ThreatIntelligenceResourceKind,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ThreatIntelligenceIndicatorProperties>,
}
impl ThreatIntelligenceIndicatorModelForRequestBody {
    pub fn new(threat_intelligence_resource_kind: ThreatIntelligenceResourceKind) -> Self {
        Self {
            threat_intelligence_resource_kind,
            etag: None,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceIndicatorProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "threatIntelligenceTags", default, skip_serializing_if = "Vec::is_empty")]
    pub threat_intelligence_tags: Vec<String>,
    #[serde(rename = "lastUpdatedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "indicatorTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub indicator_types: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pattern: Option<String>,
    #[serde(rename = "patternType", default, skip_serializing_if = "Option::is_none")]
    pub pattern_type: Option<String>,
    #[serde(rename = "patternVersion", default, skip_serializing_if = "Option::is_none")]
    pub pattern_version: Option<String>,
    #[serde(rename = "killChainPhases", default, skip_serializing_if = "Vec::is_empty")]
    pub kill_chain_phases: Vec<ThreatIntelligenceKillChainPhase>,
    #[serde(rename = "parsedPattern", default, skip_serializing_if = "Vec::is_empty")]
    pub parsed_pattern: Vec<ThreatIntelligenceParsedPattern>,
    #[serde(rename = "externalId", default, skip_serializing_if = "Option::is_none")]
    pub external_id: Option<String>,
    #[serde(rename = "createdByRef", default, skip_serializing_if = "Option::is_none")]
    pub created_by_ref: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub defanged: Option<bool>,
    #[serde(rename = "externalLastUpdatedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub external_last_updated_time_utc: Option<String>,
    #[serde(rename = "externalReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub external_references: Vec<ThreatIntelligenceExternalReference>,
    #[serde(rename = "granularMarkings", default, skip_serializing_if = "Vec::is_empty")]
    pub granular_markings: Vec<ThreatIntelligenceGranularMarkingModel>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub revoked: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub confidence: Option<i32>,
    #[serde(rename = "objectMarkingRefs", default, skip_serializing_if = "Vec::is_empty")]
    pub object_marking_refs: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<String>,
    #[serde(rename = "threatTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub threat_types: Vec<String>,
    #[serde(rename = "validFrom", default, skip_serializing_if = "Option::is_none")]
    pub valid_from: Option<String>,
    #[serde(rename = "validUntil", default, skip_serializing_if = "Option::is_none")]
    pub valid_until: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub modified: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub extensions: Option<serde_json::Value>,
}
impl ThreatIntelligenceIndicatorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceInformation {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(flatten)]
    pub threat_intelligence_resource_kind: ThreatIntelligenceResourceKind,
}
impl ThreatIntelligenceInformation {
    pub fn new(threat_intelligence_resource_kind: ThreatIntelligenceResourceKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            threat_intelligence_resource_kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceInformationList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ThreatIntelligenceInformation>,
}
impl ThreatIntelligenceInformationList {
    pub fn new(value: Vec<ThreatIntelligenceInformation>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceKillChainPhase {
    #[serde(rename = "killChainName", default, skip_serializing_if = "Option::is_none")]
    pub kill_chain_name: Option<String>,
    #[serde(rename = "phaseName", default, skip_serializing_if = "Option::is_none")]
    pub phase_name: Option<String>,
}
impl ThreatIntelligenceKillChainPhase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceMetric {
    #[serde(rename = "lastUpdatedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_time_utc: Option<String>,
    #[serde(rename = "threatTypeMetrics", default, skip_serializing_if = "Vec::is_empty")]
    pub threat_type_metrics: Vec<ThreatIntelligenceMetricEntity>,
    #[serde(rename = "patternTypeMetrics", default, skip_serializing_if = "Vec::is_empty")]
    pub pattern_type_metrics: Vec<ThreatIntelligenceMetricEntity>,
    #[serde(rename = "sourceMetrics", default, skip_serializing_if = "Vec::is_empty")]
    pub source_metrics: Vec<ThreatIntelligenceMetricEntity>,
}
impl ThreatIntelligenceMetric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceMetricEntity {
    #[serde(rename = "metricName", default, skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
    #[serde(rename = "metricValue", default, skip_serializing_if = "Option::is_none")]
    pub metric_value: Option<i32>,
}
impl ThreatIntelligenceMetricEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceMetrics {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ThreatIntelligenceMetric>,
}
impl ThreatIntelligenceMetrics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceMetricsList {
    pub value: Vec<ThreatIntelligenceMetrics>,
}
impl ThreatIntelligenceMetricsList {
    pub fn new(value: Vec<ThreatIntelligenceMetrics>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceParsedPattern {
    #[serde(rename = "patternTypeKey", default, skip_serializing_if = "Option::is_none")]
    pub pattern_type_key: Option<String>,
    #[serde(rename = "patternTypeValues", default, skip_serializing_if = "Vec::is_empty")]
    pub pattern_type_values: Vec<ThreatIntelligenceParsedPatternTypeValue>,
}
impl ThreatIntelligenceParsedPattern {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceParsedPatternTypeValue {
    #[serde(rename = "valueType", default, skip_serializing_if = "Option::is_none")]
    pub value_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ThreatIntelligenceParsedPatternTypeValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ThreatIntelligenceResourceInnerKind {
    #[serde(rename = "indicator")]
    Indicator,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceResourceKind {
    pub kind: ThreatIntelligenceResourceInnerKind,
}
impl ThreatIntelligenceResourceKind {
    pub fn new(kind: ThreatIntelligenceResourceInnerKind) -> Self {
        Self { kind }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligenceSortingCriteria {
    #[serde(rename = "itemKey", default, skip_serializing_if = "Option::is_none")]
    pub item_key: Option<String>,
    #[serde(rename = "sortOrder", default, skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<ThreatIntelligenceSortingOrder>,
}
impl ThreatIntelligenceSortingCriteria {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ThreatIntelligenceSortingOrder {
    #[serde(rename = "unsorted")]
    Unsorted,
    #[serde(rename = "ascending")]
    Ascending,
    #[serde(rename = "descending")]
    Descending,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiTaxiiCheckRequirements {
    #[serde(flatten)]
    pub data_connectors_check_requirements: DataConnectorsCheckRequirements,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TiTaxiiCheckRequirementsProperties>,
}
impl TiTaxiiCheckRequirements {
    pub fn new(data_connectors_check_requirements: DataConnectorsCheckRequirements) -> Self {
        Self {
            data_connectors_check_requirements,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiTaxiiCheckRequirementsProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
}
impl TiTaxiiCheckRequirementsProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self { data_connector_tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiTaxiiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TiTaxiiDataConnectorProperties>,
}
impl TiTaxiiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiTaxiiDataConnectorDataTypes {
    #[serde(rename = "taxiiClient")]
    pub taxii_client: serde_json::Value,
}
impl TiTaxiiDataConnectorDataTypes {
    pub fn new(taxii_client: serde_json::Value) -> Self {
        Self { taxii_client }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiTaxiiDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "taxiiServer", default, skip_serializing_if = "Option::is_none")]
    pub taxii_server: Option<String>,
    #[serde(rename = "collectionId", default, skip_serializing_if = "Option::is_none")]
    pub collection_id: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "taxiiLookbackPeriod", default, skip_serializing_if = "Option::is_none")]
    pub taxii_lookback_period: Option<String>,
    #[serde(rename = "pollingFrequency")]
    pub polling_frequency: ti_taxii_data_connector_properties::PollingFrequency,
    #[serde(rename = "dataTypes")]
    pub data_types: TiTaxiiDataConnectorDataTypes,
}
impl TiTaxiiDataConnectorProperties {
    pub fn new(
        data_connector_tenant_id: DataConnectorTenantId,
        polling_frequency: ti_taxii_data_connector_properties::PollingFrequency,
        data_types: TiTaxiiDataConnectorDataTypes,
    ) -> Self {
        Self {
            data_connector_tenant_id,
            workspace_id: None,
            friendly_name: None,
            taxii_server: None,
            collection_id: None,
            user_name: None,
            password: None,
            taxii_lookback_period: None,
            polling_frequency,
            data_types,
        }
    }
}
pub mod ti_taxii_data_connector_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PollingFrequency {
        OnceAMinute,
        OnceAnHour,
        OnceADay,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimelineAggregation {
    pub count: i32,
    pub kind: EntityTimelineKind,
}
impl TimelineAggregation {
    pub fn new(count: i32, kind: EntityTimelineKind) -> Self {
        Self { count, kind }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimelineError {
    pub kind: EntityTimelineKind,
    #[serde(rename = "queryId", default, skip_serializing_if = "Option::is_none")]
    pub query_id: Option<String>,
    #[serde(rename = "errorMessage")]
    pub error_message: String,
}
impl TimelineError {
    pub fn new(kind: EntityTimelineKind, error_message: String) -> Self {
        Self {
            kind,
            query_id: None,
            error_message,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimelineResultsMetadata {
    #[serde(rename = "totalCount")]
    pub total_count: i32,
    pub aggregations: Vec<TimelineAggregation>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<TimelineError>,
}
impl TimelineResultsMetadata {
    pub fn new(total_count: i32, aggregations: Vec<TimelineAggregation>) -> Self {
        Self {
            total_count,
            aggregations,
            errors: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Ueba {
    #[serde(flatten)]
    pub settings: Settings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UebaProperties>,
}
impl Ueba {
    pub fn new(settings: Settings) -> Self {
        Self {
            settings,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum UebaDataSources {
    AuditLogs,
    AzureActivity,
    SecurityEvent,
    SigninLogs,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UebaProperties {
    #[serde(rename = "dataSources", default, skip_serializing_if = "Vec::is_empty")]
    pub data_sources: Vec<UebaDataSources>,
}
impl UebaProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
}
impl UserInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Watchlist {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WatchlistProperties>,
}
impl Watchlist {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WatchlistItem {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WatchlistItemProperties>,
}
impl WatchlistItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WatchlistItemList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<WatchlistItem>,
}
impl WatchlistItemList {
    pub fn new(value: Vec<WatchlistItem>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WatchlistItemProperties {
    #[serde(rename = "watchlistItemType", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_item_type: Option<String>,
    #[serde(rename = "watchlistItemId", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_item_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "isDeleted", default, skip_serializing_if = "Option::is_none")]
    pub is_deleted: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<UserInfo>,
    #[serde(rename = "itemsKeyValue")]
    pub items_key_value: serde_json::Value,
    #[serde(rename = "entityMapping", default, skip_serializing_if = "Option::is_none")]
    pub entity_mapping: Option<serde_json::Value>,
}
impl WatchlistItemProperties {
    pub fn new(items_key_value: serde_json::Value) -> Self {
        Self {
            watchlist_item_type: None,
            watchlist_item_id: None,
            tenant_id: None,
            is_deleted: None,
            created: None,
            updated: None,
            created_by: None,
            updated_by: None,
            items_key_value,
            entity_mapping: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WatchlistList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Watchlist>,
}
impl WatchlistList {
    pub fn new(value: Vec<Watchlist>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WatchlistProperties {
    #[serde(rename = "watchlistId", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_id: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub provider: String,
    pub source: watchlist_properties::Source,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<UserInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "watchlistType", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_type: Option<String>,
    #[serde(rename = "watchlistAlias", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_alias: Option<String>,
    #[serde(rename = "isDeleted", default, skip_serializing_if = "Option::is_none")]
    pub is_deleted: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<Label>,
    #[serde(rename = "defaultDuration", default, skip_serializing_if = "Option::is_none")]
    pub default_duration: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "numberOfLinesToSkip", default, skip_serializing_if = "Option::is_none")]
    pub number_of_lines_to_skip: Option<i32>,
    #[serde(rename = "rawContent", default, skip_serializing_if = "Option::is_none")]
    pub raw_content: Option<String>,
    #[serde(rename = "itemsSearchKey")]
    pub items_search_key: String,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "uploadStatus", default, skip_serializing_if = "Option::is_none")]
    pub upload_status: Option<String>,
    #[serde(rename = "watchlistItemsCount", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_items_count: Option<i32>,
}
impl WatchlistProperties {
    pub fn new(display_name: String, provider: String, source: watchlist_properties::Source, items_search_key: String) -> Self {
        Self {
            watchlist_id: None,
            display_name,
            provider,
            source,
            created: None,
            updated: None,
            created_by: None,
            updated_by: None,
            description: None,
            watchlist_type: None,
            watchlist_alias: None,
            is_deleted: None,
            labels: Vec::new(),
            default_duration: None,
            tenant_id: None,
            number_of_lines_to_skip: None,
            raw_content: None,
            items_search_key,
            content_type: None,
            upload_status: None,
            watchlist_items_count: None,
        }
    }
}
pub mod watchlist_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        #[serde(rename = "Local file")]
        LocalFile,
        #[serde(rename = "Remote storage")]
        RemoteStorage,
    }
}
pub type FirstPublishDate = String;
pub type LastPublishDate = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataAuthor {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
}
impl MetadataAuthor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataCategories {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub domains: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub verticals: Vec<String>,
}
impl MetadataCategories {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type MetadataContentId = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataDependencies {
    #[serde(rename = "contentId", default, skip_serializing_if = "Option::is_none")]
    pub content_id: Option<MetadataContentId>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<MetadataKind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<MetadataVersion>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operator: Option<metadata_dependencies::Operator>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub criteria: Vec<MetadataDependencies>,
}
impl MetadataDependencies {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod metadata_dependencies {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        #[serde(rename = "AND")]
        And,
        #[serde(rename = "OR")]
        Or,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum MetadataKind {
    DataConnector,
    DataType,
    Workbook,
    WorkbookTemplate,
    Playbook,
    PlaybookTemplate,
    AnalyticsRuleTemplate,
    AnalyticsRule,
    HuntingQuery,
    InvestigationQuery,
    Parser,
    Watchlist,
    WatchlistTemplate,
    Solution,
}
pub type MetadataParentId = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataPatch {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MetadataPropertiesPatch>,
}
impl MetadataPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataProperties {
    #[serde(rename = "contentId", default, skip_serializing_if = "Option::is_none")]
    pub content_id: Option<MetadataContentId>,
    #[serde(rename = "parentId")]
    pub parent_id: MetadataParentId,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<MetadataVersion>,
    pub kind: MetadataKind,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<MetadataSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<MetadataAuthor>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub support: Option<MetadataSupport>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dependencies: Option<MetadataDependencies>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub categories: Option<MetadataCategories>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub providers: Option<MetadataProviders>,
    #[serde(rename = "firstPublishDate", default, skip_serializing_if = "Option::is_none")]
    pub first_publish_date: Option<FirstPublishDate>,
    #[serde(rename = "lastPublishDate", default, skip_serializing_if = "Option::is_none")]
    pub last_publish_date: Option<LastPublishDate>,
}
impl MetadataProperties {
    pub fn new(parent_id: MetadataParentId, kind: MetadataKind) -> Self {
        Self {
            content_id: None,
            parent_id,
            version: None,
            kind,
            source: None,
            author: None,
            support: None,
            dependencies: None,
            categories: None,
            providers: None,
            first_publish_date: None,
            last_publish_date: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataPropertiesPatch {
    #[serde(rename = "contentId", default, skip_serializing_if = "Option::is_none")]
    pub content_id: Option<MetadataContentId>,
    #[serde(rename = "parentId", default, skip_serializing_if = "Option::is_none")]
    pub parent_id: Option<MetadataParentId>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<MetadataVersion>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<MetadataKind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<MetadataSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<MetadataAuthor>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub support: Option<MetadataSupport>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dependencies: Option<MetadataDependencies>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub categories: Option<MetadataCategories>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub providers: Option<MetadataProviders>,
    #[serde(rename = "firstPublishDate", default, skip_serializing_if = "Option::is_none")]
    pub first_publish_date: Option<FirstPublishDate>,
    #[serde(rename = "lastPublishDate", default, skip_serializing_if = "Option::is_none")]
    pub last_publish_date: Option<LastPublishDate>,
}
impl MetadataPropertiesPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type MetadataProviders = Vec<String>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataSource {
    pub kind: metadata_source::Kind,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "sourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_id: Option<String>,
}
impl MetadataSource {
    pub fn new(kind: metadata_source::Kind) -> Self {
        Self {
            kind,
            name: None,
            source_id: None,
        }
    }
}
pub mod metadata_source {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        LocalWorkspace,
        Community,
        Solution,
        SourceRepository,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataSupport {
    pub tier: metadata_support::Tier,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
}
impl MetadataSupport {
    pub fn new(tier: metadata_support::Tier) -> Self {
        Self {
            tier,
            name: None,
            email: None,
            link: None,
        }
    }
}
pub mod metadata_support {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Microsoft,
        Partner,
        Community,
    }
}
pub type MetadataVersion = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
