#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AadDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AadDataConnectorProperties>,
}
impl AadDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AadDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
}
impl AadDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self {
            data_connector_tenant_id,
            data_connector_with_alerts_properties: DataConnectorWithAlertsProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AatpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AatpDataConnectorProperties>,
}
impl AatpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AatpDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
}
impl AatpDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self {
            data_connector_tenant_id,
            data_connector_with_alerts_properties: DataConnectorWithAlertsProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AscDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AscDataConnectorProperties>,
}
impl AscDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
}
impl AscDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccountEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AccountEntityProperties>,
}
impl AccountEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccountEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "aadTenantId", default, skip_serializing_if = "Option::is_none")]
    pub aad_tenant_id: Option<String>,
    #[serde(rename = "aadUserId", default, skip_serializing_if = "Option::is_none")]
    pub aad_user_id: Option<String>,
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "hostEntityId", default, skip_serializing_if = "Option::is_none")]
    pub host_entity_id: Option<String>,
    #[serde(rename = "isDomainJoined", default, skip_serializing_if = "Option::is_none")]
    pub is_domain_joined: Option<bool>,
    #[serde(rename = "ntDomain", default, skip_serializing_if = "Option::is_none")]
    pub nt_domain: Option<String>,
    #[serde(rename = "objectGuid", default, skip_serializing_if = "Option::is_none")]
    pub object_guid: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub puid: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sid: Option<String>,
    #[serde(rename = "upnSuffix", default, skip_serializing_if = "Option::is_none")]
    pub upn_suffix: Option<String>,
    #[serde(rename = "dnsDomain", default, skip_serializing_if = "Option::is_none")]
    pub dns_domain: Option<String>,
}
impl AccountEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionPropertiesBase {
    #[serde(rename = "logicAppResourceId")]
    pub logic_app_resource_id: String,
}
impl ActionPropertiesBase {
    pub fn new(logic_app_resource_id: String) -> Self {
        Self { logic_app_resource_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActionRequest {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActionRequestProperties>,
}
impl ActionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionRequestProperties {
    #[serde(flatten)]
    pub action_properties_base: ActionPropertiesBase,
    #[serde(rename = "triggerUri")]
    pub trigger_uri: String,
}
impl ActionRequestProperties {
    pub fn new(action_properties_base: ActionPropertiesBase, trigger_uri: String) -> Self {
        Self {
            action_properties_base,
            trigger_uri,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActionResponse {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActionResponseProperties>,
}
impl ActionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionResponseProperties {
    #[serde(flatten)]
    pub action_properties_base: ActionPropertiesBase,
    #[serde(rename = "workflowId", default, skip_serializing_if = "Option::is_none")]
    pub workflow_id: Option<String>,
}
impl ActionResponseProperties {
    pub fn new(action_properties_base: ActionPropertiesBase) -> Self {
        Self {
            action_properties_base,
            workflow_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionsList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ActionResponse>,
}
impl ActionsList {
    pub fn new(value: Vec<ActionResponse>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityCustomEntityQuery {
    #[serde(flatten)]
    pub custom_entity_query: CustomEntityQuery,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActivityEntityQueriesProperties>,
}
impl ActivityCustomEntityQuery {
    pub fn new(custom_entity_query: CustomEntityQuery) -> Self {
        Self {
            custom_entity_query,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActivityEntityQueriesProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "queryDefinitions", default, skip_serializing_if = "Option::is_none")]
    pub query_definitions: Option<activity_entity_queries_properties::QueryDefinitions>,
    #[serde(rename = "inputEntityType", default, skip_serializing_if = "Option::is_none")]
    pub input_entity_type: Option<EntityInnerType>,
    #[serde(rename = "requiredInputFieldsSets", default, skip_serializing_if = "Vec::is_empty")]
    pub required_input_fields_sets: Vec<Vec<String>>,
    #[serde(rename = "entitiesFilter", default, skip_serializing_if = "Option::is_none")]
    pub entities_filter: Option<serde_json::Value>,
    #[serde(rename = "templateName", default, skip_serializing_if = "Option::is_none")]
    pub template_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time_utc: Option<String>,
}
impl ActivityEntityQueriesProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod activity_entity_queries_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct QueryDefinitions {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub query: Option<String>,
    }
    impl QueryDefinitions {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityEntityQuery {
    #[serde(flatten)]
    pub entity_query: EntityQuery,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActivityEntityQueriesProperties>,
}
impl ActivityEntityQuery {
    pub fn new(entity_query: EntityQuery) -> Self {
        Self {
            entity_query,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityEntityQueryTemplate {
    #[serde(flatten)]
    pub entity_query_template: EntityQueryTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActivityEntityQueryTemplateProperties>,
}
impl ActivityEntityQueryTemplate {
    pub fn new(entity_query_template: EntityQueryTemplate) -> Self {
        Self {
            entity_query_template,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActivityEntityQueryTemplateProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "queryDefinitions", default, skip_serializing_if = "Option::is_none")]
    pub query_definitions: Option<activity_entity_query_template_properties::QueryDefinitions>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub data_types: Vec<DataTypeDefinitions>,
    #[serde(rename = "inputEntityType", default, skip_serializing_if = "Option::is_none")]
    pub input_entity_type: Option<EntityInnerType>,
    #[serde(rename = "requiredInputFieldsSets", default, skip_serializing_if = "Vec::is_empty")]
    pub required_input_fields_sets: Vec<Vec<String>>,
    #[serde(rename = "entitiesFilter", default, skip_serializing_if = "Option::is_none")]
    pub entities_filter: Option<serde_json::Value>,
}
impl ActivityEntityQueryTemplateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod activity_entity_query_template_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct QueryDefinitions {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub query: Option<String>,
        #[serde(rename = "summarizeBy", default, skip_serializing_if = "Option::is_none")]
        pub summarize_by: Option<String>,
    }
    impl QueryDefinitions {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityTimelineItem {
    #[serde(flatten)]
    pub entity_timeline_item: EntityTimelineItem,
    #[serde(rename = "queryId")]
    pub query_id: String,
    #[serde(rename = "bucketStartTimeUTC")]
    pub bucket_start_time_utc: String,
    #[serde(rename = "bucketEndTimeUTC")]
    pub bucket_end_time_utc: String,
    #[serde(rename = "firstActivityTimeUTC")]
    pub first_activity_time_utc: String,
    #[serde(rename = "lastActivityTimeUTC")]
    pub last_activity_time_utc: String,
    pub content: String,
    pub title: String,
}
impl ActivityTimelineItem {
    pub fn new(
        entity_timeline_item: EntityTimelineItem,
        query_id: String,
        bucket_start_time_utc: String,
        bucket_end_time_utc: String,
        first_activity_time_utc: String,
        last_activity_time_utc: String,
        content: String,
        title: String,
    ) -> Self {
        Self {
            entity_timeline_item,
            query_id,
            bucket_start_time_utc,
            bucket_end_time_utc,
            first_activity_time_utc,
            last_activity_time_utc,
            content,
            title,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertDetailsOverride {
    #[serde(rename = "alertDisplayNameFormat", default, skip_serializing_if = "Option::is_none")]
    pub alert_display_name_format: Option<String>,
    #[serde(rename = "alertDescriptionFormat", default, skip_serializing_if = "Option::is_none")]
    pub alert_description_format: Option<String>,
    #[serde(rename = "alertTacticsColumnName", default, skip_serializing_if = "Option::is_none")]
    pub alert_tactics_column_name: Option<String>,
    #[serde(rename = "alertSeverityColumnName", default, skip_serializing_if = "Option::is_none")]
    pub alert_severity_column_name: Option<String>,
}
impl AlertDetailsOverride {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRule {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: AlertRuleKindEnum,
}
impl AlertRule {
    pub fn new(kind: AlertRuleKindEnum) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleKindEnum {
    Scheduled,
    MicrosoftSecurityIncidentCreation,
    Fusion,
    #[serde(rename = "MLBehaviorAnalytics")]
    MlBehaviorAnalytics,
    ThreatIntelligence,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleTemplate {
    #[serde(flatten)]
    pub resource: Resource,
    pub kind: AlertRuleKindEnum,
}
impl AlertRuleTemplate {
    pub fn new(kind: AlertRuleKindEnum) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRuleTemplateDataSource {
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub data_types: Vec<String>,
}
impl AlertRuleTemplateDataSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRuleTemplatePropertiesBase {
    #[serde(rename = "alertRulesCreatedByTemplateCount", default, skip_serializing_if = "Option::is_none")]
    pub alert_rules_created_by_template_count: Option<i32>,
    #[serde(rename = "lastUpdatedDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_date_utc: Option<String>,
    #[serde(rename = "createdDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub created_date_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "requiredDataConnectors", default, skip_serializing_if = "Vec::is_empty")]
    pub required_data_connectors: Vec<AlertRuleTemplateDataSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<alert_rule_template_properties_base::Status>,
}
impl AlertRuleTemplatePropertiesBase {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_rule_template_properties_base {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Installed,
        Available,
        NotAvailable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleTemplatesList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<AlertRuleTemplate>,
}
impl AlertRuleTemplatesList {
    pub fn new(value: Vec<AlertRuleTemplate>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleTriggerOperator {
    GreaterThan,
    LessThan,
    Equal,
    NotEqual,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRulesList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<AlertRule>,
}
impl AlertRulesList {
    pub fn new(value: Vec<AlertRule>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertSeverity {
    High,
    Medium,
    Low,
    Informational,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertsDataTypeOfDataConnector {
    pub alerts: DataConnectorDataTypeCommon,
}
impl AlertsDataTypeOfDataConnector {
    pub fn new(alerts: DataConnectorDataTypeCommon) -> Self {
        Self { alerts }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Anomalies {
    #[serde(flatten)]
    pub settings: Settings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AnomaliesSettingsProperties>,
}
impl Anomalies {
    pub fn new(settings: Settings) -> Self {
        Self {
            settings,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AnomaliesSettingsProperties {
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
}
impl AnomaliesSettingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AttackTactic {
    InitialAccess,
    Execution,
    Persistence,
    PrivilegeEscalation,
    DefenseEvasion,
    CredentialAccess,
    Discovery,
    LateralMovement,
    Collection,
    Exfiltration,
    CommandAndControl,
    Impact,
    PreAttack,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Availability {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<availability::Status>,
    #[serde(rename = "isPreview", default, skip_serializing_if = "Option::is_none")]
    pub is_preview: Option<bool>,
}
impl Availability {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod availability {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {}
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsCloudTrailDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AwsCloudTrailDataConnectorProperties>,
}
impl AwsCloudTrailDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsCloudTrailDataConnectorDataTypes {
    pub logs: serde_json::Value,
}
impl AwsCloudTrailDataConnectorDataTypes {
    pub fn new(logs: serde_json::Value) -> Self {
        Self { logs }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsCloudTrailDataConnectorProperties {
    #[serde(rename = "awsRoleArn", default, skip_serializing_if = "Option::is_none")]
    pub aws_role_arn: Option<String>,
    #[serde(rename = "dataTypes")]
    pub data_types: AwsCloudTrailDataConnectorDataTypes,
}
impl AwsCloudTrailDataConnectorProperties {
    pub fn new(data_types: AwsCloudTrailDataConnectorDataTypes) -> Self {
        Self {
            aws_role_arn: None,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureResourceEntityProperties>,
}
impl AzureResourceEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResourceEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
}
impl AzureResourceEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BookmarkTimelineItem {
    #[serde(flatten)]
    pub entity_timeline_item: EntityTimelineItem,
    #[serde(rename = "azureResourceId")]
    pub azure_resource_id: String,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    #[serde(rename = "endTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub end_time_utc: Option<String>,
    #[serde(rename = "startTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub start_time_utc: Option<String>,
    #[serde(rename = "eventTime", default, skip_serializing_if = "Option::is_none")]
    pub event_time: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<Label>,
}
impl BookmarkTimelineItem {
    pub fn new(entity_timeline_item: EntityTimelineItem, azure_resource_id: String) -> Self {
        Self {
            entity_timeline_item,
            azure_resource_id,
            display_name: None,
            notes: None,
            end_time_utc: None,
            start_time_utc: None,
            event_time: None,
            created_by: None,
            labels: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
}
impl ClientInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudApplicationEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CloudApplicationEntityProperties>,
}
impl CloudApplicationEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudApplicationEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "appId", default, skip_serializing_if = "Option::is_none")]
    pub app_id: Option<i32>,
    #[serde(rename = "appName", default, skip_serializing_if = "Option::is_none")]
    pub app_name: Option<String>,
    #[serde(rename = "instanceName", default, skip_serializing_if = "Option::is_none")]
    pub instance_name: Option<String>,
}
impl CloudApplicationEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CodelessParameters {
    #[serde(rename = "connectorUiConfig", default, skip_serializing_if = "Option::is_none")]
    pub connector_ui_config: Option<CodelessUiConnectorConfigProperties>,
}
impl CodelessParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessUiConnectorConfigProperties {
    pub title: String,
    pub publisher: String,
    #[serde(rename = "descriptionMarkdown")]
    pub description_markdown: String,
    #[serde(rename = "customImage", default, skip_serializing_if = "Option::is_none")]
    pub custom_image: Option<String>,
    #[serde(rename = "graphQueriesTableName")]
    pub graph_queries_table_name: String,
    #[serde(rename = "graphQueries")]
    pub graph_queries: Vec<serde_json::Value>,
    #[serde(rename = "sampleQueries")]
    pub sample_queries: Vec<serde_json::Value>,
    #[serde(rename = "dataTypes")]
    pub data_types: Vec<serde_json::Value>,
    #[serde(rename = "connectivityCriteria")]
    pub connectivity_criteria: Vec<serde_json::Value>,
    pub availability: Availability,
    pub permissions: Permissions,
    #[serde(rename = "instructionSteps")]
    pub instruction_steps: Vec<serde_json::Value>,
}
impl CodelessUiConnectorConfigProperties {
    pub fn new(
        title: String,
        publisher: String,
        description_markdown: String,
        graph_queries_table_name: String,
        graph_queries: Vec<serde_json::Value>,
        sample_queries: Vec<serde_json::Value>,
        data_types: Vec<serde_json::Value>,
        connectivity_criteria: Vec<serde_json::Value>,
        availability: Availability,
        permissions: Permissions,
        instruction_steps: Vec<serde_json::Value>,
    ) -> Self {
        Self {
            title,
            publisher,
            description_markdown,
            custom_image: None,
            graph_queries_table_name,
            graph_queries,
            sample_queries,
            data_types,
            connectivity_criteria,
            availability,
            permissions,
            instruction_steps,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CodelessUiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CodelessParameters>,
}
impl CodelessUiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityCriteria {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connectivity_criteria::Type>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<String>,
}
impl ConnectivityCriteria {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_criteria {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        IsConnectedQuery,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectorInstructionModelBase {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[serde(rename = "type")]
    pub type_: connector_instruction_model_base::Type,
}
impl ConnectorInstructionModelBase {
    pub fn new(type_: connector_instruction_model_base::Type) -> Self {
        Self { parameters: None, type_ }
    }
}
pub mod connector_instruction_model_base {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        CopyableLabel,
        InstructionStepsGroup,
        InfoMessage,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContentPathMap {
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<ContentType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl ContentPathMap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ContentType {
    AnalyticRule,
    Workbook,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomEntityQuery {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: CustomEntityQueryKind,
}
impl CustomEntityQuery {
    pub fn new(kind: CustomEntityQueryKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CustomEntityQueryKind {
    Activity,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Customs {
    #[serde(flatten)]
    pub customs_permission: CustomsPermission,
}
impl Customs {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomsPermission {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl CustomsPermission {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnector {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: DataConnectorKind,
}
impl DataConnector {
    pub fn new(kind: DataConnectorKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnectorDataTypeCommon {
    pub state: data_connector_data_type_common::State,
}
impl DataConnectorDataTypeCommon {
    pub fn new(state: data_connector_data_type_common::State) -> Self {
        Self { state }
    }
}
pub mod data_connector_data_type_common {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DataConnectorKind {
    AzureActiveDirectory,
    AzureSecurityCenter,
    MicrosoftCloudAppSecurity,
    ThreatIntelligence,
    ThreatIntelligenceTaxii,
    Office365,
    #[serde(rename = "OfficeATP")]
    OfficeAtp,
    AmazonWebServicesCloudTrail,
    AzureAdvancedThreatProtection,
    MicrosoftDefenderAdvancedThreatProtection,
    Dynamics365,
    MicrosoftThreatProtection,
    MicrosoftThreatIntelligence,
    #[serde(rename = "GenericUI")]
    GenericUi,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnectorList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<DataConnector>,
}
impl DataConnectorList {
    pub fn new(value: Vec<DataConnector>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnectorTenantId {
    #[serde(rename = "tenantId")]
    pub tenant_id: String,
}
impl DataConnectorTenantId {
    pub fn new(tenant_id: String) -> Self {
        Self { tenant_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorWithAlertsProperties {
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl DataConnectorWithAlertsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataTypeDefinitions {
    #[serde(rename = "dataType", default, skip_serializing_if = "Option::is_none")]
    pub data_type: Option<String>,
}
impl DataTypeDefinitions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DnsEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DnsEntityProperties>,
}
impl DnsEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DnsEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "dnsServerIpEntityId", default, skip_serializing_if = "Option::is_none")]
    pub dns_server_ip_entity_id: Option<String>,
    #[serde(rename = "domainName", default, skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    #[serde(rename = "hostIpAddressEntityId", default, skip_serializing_if = "Option::is_none")]
    pub host_ip_address_entity_id: Option<String>,
    #[serde(rename = "ipAddressEntityIds", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_address_entity_ids: Vec<String>,
}
impl DnsEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dynamics365DataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Dynamics365DataConnectorProperties>,
}
impl Dynamics365DataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dynamics365DataConnectorDataTypes {
    #[serde(rename = "dynamics365CdsActivities")]
    pub dynamics365_cds_activities: serde_json::Value,
}
impl Dynamics365DataConnectorDataTypes {
    pub fn new(dynamics365_cds_activities: serde_json::Value) -> Self {
        Self {
            dynamics365_cds_activities,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dynamics365DataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: Dynamics365DataConnectorDataTypes,
}
impl Dynamics365DataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: Dynamics365DataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Entity {
    #[serde(flatten)]
    pub resource: Resource,
    pub kind: EntityInnerKind,
}
impl Entity {
    pub fn new(kind: EntityInnerKind) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityAnalytics {
    #[serde(flatten)]
    pub settings: Settings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EntityAnalyticsProperties>,
}
impl EntityAnalytics {
    pub fn new(settings: Settings) -> Self {
        Self {
            settings,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityAnalyticsProperties {
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
}
impl EntityAnalyticsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityCommonProperties {
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<serde_json::Value>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl EntityCommonProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityInnerKind {
    Account,
    Host,
    File,
    AzureResource,
    CloudApplication,
    DnsResolution,
    FileHash,
    Ip,
    Malware,
    Process,
    RegistryKey,
    RegistryValue,
    SecurityGroup,
    Url,
    IoTDevice,
    SecurityAlert,
    Bookmark,
    Mailbox,
    MailCluster,
    MailMessage,
    SubmissionMail,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityInnerType {
    Account,
    Host,
    File,
    AzureResource,
    CloudApplication,
    #[serde(rename = "DNS")]
    Dns,
    FileHash,
    #[serde(rename = "IP")]
    Ip,
    Malware,
    Process,
    RegistryKey,
    RegistryValue,
    SecurityGroup,
    #[serde(rename = "URL")]
    Url,
    IoTDevice,
    SecurityAlert,
    HuntingBookmark,
    MailCluster,
    MailMessage,
    Mailbox,
    SubmissionMail,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityMapping {
    #[serde(rename = "entityType", default, skip_serializing_if = "Option::is_none")]
    pub entity_type: Option<EntityMappingType>,
    #[serde(rename = "fieldMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub field_mappings: Vec<FieldMapping>,
}
impl EntityMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityMappingType {
    Account,
    Host,
    #[serde(rename = "IP")]
    Ip,
    Malware,
    File,
    Process,
    CloudApplication,
    #[serde(rename = "DNS")]
    Dns,
    AzureResource,
    FileHash,
    RegistryKey,
    RegistryValue,
    SecurityGroup,
    #[serde(rename = "URL")]
    Url,
    Mailbox,
    MailCluster,
    MailMessage,
    SubmissionMail,
}
pub type EntityMappings = Vec<EntityMapping>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityQuery {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: EntityQueryKind,
}
impl EntityQuery {
    pub fn new(kind: EntityQueryKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityQueryKind {
    Expansion,
    Insight,
    Activity,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityQueryList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<EntityQuery>,
}
impl EntityQueryList {
    pub fn new(value: Vec<EntityQuery>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityQueryTemplate {
    #[serde(flatten)]
    pub resource: Resource,
    pub kind: EntityQueryTemplateKind,
}
impl EntityQueryTemplate {
    pub fn new(kind: EntityQueryTemplateKind) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityQueryTemplateKind {
    Activity,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityQueryTemplateList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<EntityQueryTemplate>,
}
impl EntityQueryTemplateList {
    pub fn new(value: Vec<EntityQueryTemplate>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EntityTimelineItem {
    pub kind: EntityTimelineKind,
}
impl EntityTimelineItem {
    pub fn new(kind: EntityTimelineKind) -> Self {
        Self { kind }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EntityTimelineKind {
    Activity,
    Bookmark,
    SecurityAlert,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EventGroupingAggregationKind {
    SingleAlert,
    AlertPerResult,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventGroupingSettings {
    #[serde(rename = "aggregationKind", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_kind: Option<EventGroupingAggregationKind>,
}
impl EventGroupingSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpansionEntityQueriesProperties {
    #[serde(rename = "dataSources", default, skip_serializing_if = "Vec::is_empty")]
    pub data_sources: Vec<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "inputEntityType", default, skip_serializing_if = "Option::is_none")]
    pub input_entity_type: Option<EntityInnerType>,
    #[serde(rename = "inputFields", default, skip_serializing_if = "Vec::is_empty")]
    pub input_fields: Vec<String>,
    #[serde(rename = "outputEntityTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub output_entity_types: Vec<EntityInnerType>,
    #[serde(rename = "queryTemplate", default, skip_serializing_if = "Option::is_none")]
    pub query_template: Option<String>,
}
impl ExpansionEntityQueriesProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpansionEntityQuery {
    #[serde(flatten)]
    pub entity_query: EntityQuery,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpansionEntityQueriesProperties>,
}
impl ExpansionEntityQuery {
    pub fn new(entity_query: EntityQuery) -> Self {
        Self {
            entity_query,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EyesOn {
    #[serde(flatten)]
    pub settings: Settings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EyesOnSettingsProperties>,
}
impl EyesOn {
    pub fn new(settings: Settings) -> Self {
        Self {
            settings,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EyesOnSettingsProperties {
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
}
impl EyesOnSettingsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FieldMapping {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identifier: Option<String>,
    #[serde(rename = "columnName", default, skip_serializing_if = "Option::is_none")]
    pub column_name: Option<String>,
}
impl FieldMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FileEntityProperties>,
}
impl FileEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub directory: Option<String>,
    #[serde(rename = "fileHashEntityIds", default, skip_serializing_if = "Vec::is_empty")]
    pub file_hash_entity_ids: Vec<String>,
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<String>,
    #[serde(rename = "hostEntityId", default, skip_serializing_if = "Option::is_none")]
    pub host_entity_id: Option<String>,
}
impl FileEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileHashEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FileHashEntityProperties>,
}
impl FileHashEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileHashEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub algorithm: Option<file_hash_entity_properties::Algorithm>,
    #[serde(rename = "hashValue", default, skip_serializing_if = "Option::is_none")]
    pub hash_value: Option<String>,
}
impl FileHashEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod file_hash_entity_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Algorithm {
        Unknown,
        #[serde(rename = "MD5")]
        Md5,
        #[serde(rename = "SHA1")]
        Sha1,
        #[serde(rename = "SHA256")]
        Sha256,
        #[serde(rename = "SHA256AC")]
        Sha256ac,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FusionAlertRuleProperties>,
}
impl FusionAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRuleProperties {
    #[serde(rename = "alertRuleTemplateName")]
    pub alert_rule_template_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl FusionAlertRuleProperties {
    pub fn new(alert_rule_template_name: String, enabled: bool) -> Self {
        Self {
            alert_rule_template_name,
            description: None,
            display_name: None,
            enabled,
            last_modified_utc: None,
            severity: None,
            tactics: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<fusion_alert_rule_template::Properties>,
}
impl FusionAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
pub mod fusion_alert_rule_template {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(flatten)]
        pub alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase,
        pub severity: AlertSeverity,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tactics: Vec<AttackTactic>,
    }
    impl Properties {
        pub fn new(severity: AlertSeverity) -> Self {
            Self {
                alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase::default(),
                severity,
                tactics: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GeoLocation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    #[serde(rename = "countryCode", default, skip_serializing_if = "Option::is_none")]
    pub country_code: Option<String>,
    #[serde(rename = "countryName", default, skip_serializing_if = "Option::is_none")]
    pub country_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub latitude: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub longitude: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}
impl GeoLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GraphQueries {
    #[serde(rename = "metricName", default, skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub legend: Option<String>,
    #[serde(rename = "baseQuery", default, skip_serializing_if = "Option::is_none")]
    pub base_query: Option<String>,
}
impl GraphQueries {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GroupingConfiguration {
    pub enabled: bool,
    #[serde(rename = "reopenClosedIncident")]
    pub reopen_closed_incident: bool,
    #[serde(rename = "lookbackDuration")]
    pub lookback_duration: String,
    #[serde(rename = "matchingMethod")]
    pub matching_method: grouping_configuration::MatchingMethod,
    #[serde(rename = "groupByEntities", default, skip_serializing_if = "Vec::is_empty")]
    pub group_by_entities: Vec<EntityMappingType>,
    #[serde(rename = "groupByAlertDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub group_by_alert_details: Vec<String>,
    #[serde(rename = "groupByCustomDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub group_by_custom_details: Vec<String>,
}
impl GroupingConfiguration {
    pub fn new(
        enabled: bool,
        reopen_closed_incident: bool,
        lookback_duration: String,
        matching_method: grouping_configuration::MatchingMethod,
    ) -> Self {
        Self {
            enabled,
            reopen_closed_incident,
            lookback_duration,
            matching_method,
            group_by_entities: Vec::new(),
            group_by_alert_details: Vec::new(),
            group_by_custom_details: Vec::new(),
        }
    }
}
pub mod grouping_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MatchingMethod {
        AllEntities,
        AnyAlert,
        Selected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HostEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HostEntityProperties>,
}
impl HostEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HostEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "azureID", default, skip_serializing_if = "Option::is_none")]
    pub azure_id: Option<String>,
    #[serde(rename = "dnsDomain", default, skip_serializing_if = "Option::is_none")]
    pub dns_domain: Option<String>,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "isDomainJoined", default, skip_serializing_if = "Option::is_none")]
    pub is_domain_joined: Option<bool>,
    #[serde(rename = "netBiosName", default, skip_serializing_if = "Option::is_none")]
    pub net_bios_name: Option<String>,
    #[serde(rename = "ntDomain", default, skip_serializing_if = "Option::is_none")]
    pub nt_domain: Option<String>,
    #[serde(rename = "omsAgentID", default, skip_serializing_if = "Option::is_none")]
    pub oms_agent_id: Option<String>,
    #[serde(rename = "osFamily", default, skip_serializing_if = "Option::is_none")]
    pub os_family: Option<host_entity_properties::OsFamily>,
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
}
impl HostEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod host_entity_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsFamily {
        Linux,
        Windows,
        Android,
        #[serde(rename = "IOS")]
        Ios,
        Unknown,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HuntingBookmark {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HuntingBookmarkProperties>,
}
impl HuntingBookmark {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HuntingBookmarkProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(rename = "eventTime", default, skip_serializing_if = "Option::is_none")]
    pub event_time: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<Label>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    pub query: String,
    #[serde(rename = "queryResult", default, skip_serializing_if = "Option::is_none")]
    pub query_result: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<UserInfo>,
    #[serde(rename = "incidentInfo", default, skip_serializing_if = "Option::is_none")]
    pub incident_info: Option<IncidentInfo>,
}
impl HuntingBookmarkProperties {
    pub fn new(display_name: String, query: String) -> Self {
        Self {
            entity_common_properties: EntityCommonProperties::default(),
            created: None,
            created_by: None,
            display_name,
            event_time: None,
            labels: Vec::new(),
            notes: None,
            query,
            query_result: None,
            updated: None,
            updated_by: None,
            incident_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Incident {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IncidentProperties>,
}
impl Incident {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentAdditionalData {
    #[serde(rename = "alertsCount", default, skip_serializing_if = "Option::is_none")]
    pub alerts_count: Option<i32>,
    #[serde(rename = "bookmarksCount", default, skip_serializing_if = "Option::is_none")]
    pub bookmarks_count: Option<i32>,
    #[serde(rename = "commentsCount", default, skip_serializing_if = "Option::is_none")]
    pub comments_count: Option<i32>,
    #[serde(rename = "alertProductNames", default, skip_serializing_if = "Vec::is_empty")]
    pub alert_product_names: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl IncidentAdditionalData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentAlertList {
    pub value: Vec<SecurityAlert>,
}
impl IncidentAlertList {
    pub fn new(value: Vec<SecurityAlert>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentBookmarkList {
    pub value: Vec<HuntingBookmark>,
}
impl IncidentBookmarkList {
    pub fn new(value: Vec<HuntingBookmark>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentComment {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IncidentCommentProperties>,
}
impl IncidentComment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentCommentList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<IncidentComment>,
}
impl IncidentCommentList {
    pub fn new(value: Vec<IncidentComment>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentCommentProperties {
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time_utc: Option<String>,
    pub message: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<ClientInfo>,
}
impl IncidentCommentProperties {
    pub fn new(message: String) -> Self {
        Self {
            created_time_utc: None,
            last_modified_time_utc: None,
            message,
            author: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentConfiguration {
    #[serde(rename = "createIncident")]
    pub create_incident: bool,
    #[serde(rename = "groupingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub grouping_configuration: Option<GroupingConfiguration>,
}
impl IncidentConfiguration {
    pub fn new(create_incident: bool) -> Self {
        Self {
            create_incident,
            grouping_configuration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentEntitiesResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub entities: Vec<Entity>,
    #[serde(rename = "metaData", default, skip_serializing_if = "Vec::is_empty")]
    pub meta_data: Vec<IncidentEntitiesResultsMetadata>,
}
impl IncidentEntitiesResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentEntitiesResultsMetadata {
    pub count: i32,
    #[serde(rename = "entityKind")]
    pub entity_kind: EntityInnerKind,
}
impl IncidentEntitiesResultsMetadata {
    pub fn new(count: i32, entity_kind: EntityInnerKind) -> Self {
        Self { count, entity_kind }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentInfo {
    #[serde(rename = "incidentId", default, skip_serializing_if = "Option::is_none")]
    pub incident_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<incident_info::Severity>,
    #[serde(rename = "teamInformation", default, skip_serializing_if = "Option::is_none")]
    pub team_information: Option<TeamInformation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(rename = "relationName", default, skip_serializing_if = "Option::is_none")]
    pub relation_name: Option<String>,
}
impl IncidentInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod incident_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Critical,
        High,
        Medium,
        Low,
        Informational,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentLabel {
    #[serde(rename = "labelName")]
    pub label_name: String,
    #[serde(rename = "labelType", default, skip_serializing_if = "Option::is_none")]
    pub label_type: Option<incident_label::LabelType>,
}
impl IncidentLabel {
    pub fn new(label_name: String) -> Self {
        Self {
            label_name,
            label_type: None,
        }
    }
}
pub mod incident_label {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LabelType {
        User,
        System,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Incident>,
}
impl IncidentList {
    pub fn new(value: Vec<Incident>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentOwnerInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(rename = "assignedTo", default, skip_serializing_if = "Option::is_none")]
    pub assigned_to: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
    #[serde(rename = "ownerType", default, skip_serializing_if = "Option::is_none")]
    pub owner_type: Option<incident_owner_info::OwnerType>,
}
impl IncidentOwnerInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod incident_owner_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OwnerType {
        Unknown,
        User,
        Group,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentProperties {
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<IncidentAdditionalData>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub classification: Option<incident_properties::Classification>,
    #[serde(rename = "classificationComment", default, skip_serializing_if = "Option::is_none")]
    pub classification_comment: Option<String>,
    #[serde(rename = "classificationReason", default, skip_serializing_if = "Option::is_none")]
    pub classification_reason: Option<incident_properties::ClassificationReason>,
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "firstActivityTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub first_activity_time_utc: Option<String>,
    #[serde(rename = "incidentUrl", default, skip_serializing_if = "Option::is_none")]
    pub incident_url: Option<String>,
    #[serde(rename = "incidentNumber", default, skip_serializing_if = "Option::is_none")]
    pub incident_number: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<IncidentLabel>,
    #[serde(rename = "providerName", default, skip_serializing_if = "Option::is_none")]
    pub provider_name: Option<String>,
    #[serde(rename = "providerIncidentId", default, skip_serializing_if = "Option::is_none")]
    pub provider_incident_id: Option<String>,
    #[serde(rename = "lastActivityTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_activity_time_utc: Option<String>,
    #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub owner: Option<IncidentOwnerInfo>,
    #[serde(rename = "relatedAnalyticRuleIds", default, skip_serializing_if = "Vec::is_empty")]
    pub related_analytic_rule_ids: Vec<String>,
    pub severity: incident_properties::Severity,
    pub status: incident_properties::Status,
    #[serde(rename = "teamInformation", default, skip_serializing_if = "Option::is_none")]
    pub team_information: Option<TeamInformation>,
    pub title: String,
}
impl IncidentProperties {
    pub fn new(severity: incident_properties::Severity, status: incident_properties::Status, title: String) -> Self {
        Self {
            additional_data: None,
            classification: None,
            classification_comment: None,
            classification_reason: None,
            created_time_utc: None,
            description: None,
            first_activity_time_utc: None,
            incident_url: None,
            incident_number: None,
            labels: Vec::new(),
            provider_name: None,
            provider_incident_id: None,
            last_activity_time_utc: None,
            last_modified_time_utc: None,
            owner: None,
            related_analytic_rule_ids: Vec::new(),
            severity,
            status,
            team_information: None,
            title,
        }
    }
}
pub mod incident_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Classification {
        Undetermined,
        TruePositive,
        BenignPositive,
        FalsePositive,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ClassificationReason {
        SuspiciousActivity,
        SuspiciousButExpected,
        IncorrectAlertLogic,
        InaccurateData,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        High,
        Medium,
        Low,
        Informational,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        New,
        Active,
        Closed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstructionSteps {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub instructions: Vec<serde_json::Value>,
}
impl InstructionSteps {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IoTDeviceEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IoTDeviceEntityProperties>,
}
impl IoTDeviceEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IoTDeviceEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "deviceId", default, skip_serializing_if = "Option::is_none")]
    pub device_id: Option<String>,
    #[serde(rename = "deviceName", default, skip_serializing_if = "Option::is_none")]
    pub device_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[serde(rename = "iotSecurityAgentId", default, skip_serializing_if = "Option::is_none")]
    pub iot_security_agent_id: Option<String>,
    #[serde(rename = "deviceType", default, skip_serializing_if = "Option::is_none")]
    pub device_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
    #[serde(rename = "edgeId", default, skip_serializing_if = "Option::is_none")]
    pub edge_id: Option<String>,
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub model: Option<String>,
    #[serde(rename = "serialNumber", default, skip_serializing_if = "Option::is_none")]
    pub serial_number: Option<String>,
    #[serde(rename = "firmwareVersion", default, skip_serializing_if = "Option::is_none")]
    pub firmware_version: Option<String>,
    #[serde(rename = "operatingSystem", default, skip_serializing_if = "Option::is_none")]
    pub operating_system: Option<String>,
    #[serde(rename = "iotHubEntityId", default, skip_serializing_if = "Option::is_none")]
    pub iot_hub_entity_id: Option<String>,
    #[serde(rename = "hostEntityId", default, skip_serializing_if = "Option::is_none")]
    pub host_entity_id: Option<String>,
    #[serde(rename = "ipAddressEntityId", default, skip_serializing_if = "Option::is_none")]
    pub ip_address_entity_id: Option<String>,
    #[serde(rename = "threatIntelligence", default, skip_serializing_if = "Vec::is_empty")]
    pub threat_intelligence: Vec<ThreatIntelligence>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<String>,
}
impl IoTDeviceEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpEntityProperties>,
}
impl IpEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<GeoLocation>,
    #[serde(rename = "threatIntelligence", default, skip_serializing_if = "Vec::is_empty")]
    pub threat_intelligence: Vec<ThreatIntelligence>,
}
impl IpEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type Label = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LastDataReceivedDataType {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "lastDataReceivedQuery", default, skip_serializing_if = "Option::is_none")]
    pub last_data_received_query: Option<String>,
}
impl LastDataReceivedDataType {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<McasDataConnectorProperties>,
}
impl McasDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasDataConnectorDataTypes {
    #[serde(flatten)]
    pub alerts_data_type_of_data_connector: AlertsDataTypeOfDataConnector,
    #[serde(rename = "discoveryLogs", default, skip_serializing_if = "Option::is_none")]
    pub discovery_logs: Option<DataConnectorDataTypeCommon>,
}
impl McasDataConnectorDataTypes {
    pub fn new(alerts_data_type_of_data_connector: AlertsDataTypeOfDataConnector) -> Self {
        Self {
            alerts_data_type_of_data_connector,
            discovery_logs: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: McasDataConnectorDataTypes,
}
impl McasDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: McasDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MdatpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MdatpDataConnectorProperties>,
}
impl MdatpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MdatpDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
}
impl MdatpDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self {
            data_connector_tenant_id,
            data_connector_with_alerts_properties: DataConnectorWithAlertsProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MlBehaviorAnalyticsAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MlBehaviorAnalyticsAlertRuleProperties>,
}
impl MlBehaviorAnalyticsAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MlBehaviorAnalyticsAlertRuleProperties {
    #[serde(rename = "alertRuleTemplateName")]
    pub alert_rule_template_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl MlBehaviorAnalyticsAlertRuleProperties {
    pub fn new(alert_rule_template_name: String, enabled: bool) -> Self {
        Self {
            alert_rule_template_name,
            description: None,
            display_name: None,
            enabled,
            last_modified_utc: None,
            severity: None,
            tactics: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MlBehaviorAnalyticsAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ml_behavior_analytics_alert_rule_template::Properties>,
}
impl MlBehaviorAnalyticsAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
pub mod ml_behavior_analytics_alert_rule_template {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(flatten)]
        pub alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase,
        pub severity: AlertSeverity,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tactics: Vec<AttackTactic>,
    }
    impl Properties {
        pub fn new(severity: AlertSeverity) -> Self {
            Self {
                alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase::default(),
                severity,
                tactics: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MstiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MstiDataConnectorProperties>,
}
impl MstiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MstiDataConnectorDataTypes {
    #[serde(rename = "bingSafetyPhishingURL")]
    pub bing_safety_phishing_url: msti_data_connector_data_types::BingSafetyPhishingUrl,
    #[serde(rename = "microsoftEmergingThreatFeed")]
    pub microsoft_emerging_threat_feed: msti_data_connector_data_types::MicrosoftEmergingThreatFeed,
}
impl MstiDataConnectorDataTypes {
    pub fn new(
        bing_safety_phishing_url: msti_data_connector_data_types::BingSafetyPhishingUrl,
        microsoft_emerging_threat_feed: msti_data_connector_data_types::MicrosoftEmergingThreatFeed,
    ) -> Self {
        Self {
            bing_safety_phishing_url,
            microsoft_emerging_threat_feed,
        }
    }
}
pub mod msti_data_connector_data_types {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct BingSafetyPhishingUrl {
        #[serde(flatten)]
        pub data_connector_data_type_common: DataConnectorDataTypeCommon,
        #[serde(rename = "lookbackPeriod")]
        pub lookback_period: String,
    }
    impl BingSafetyPhishingUrl {
        pub fn new(data_connector_data_type_common: DataConnectorDataTypeCommon, lookback_period: String) -> Self {
            Self {
                data_connector_data_type_common,
                lookback_period,
            }
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct MicrosoftEmergingThreatFeed {
        #[serde(flatten)]
        pub data_connector_data_type_common: DataConnectorDataTypeCommon,
        #[serde(rename = "lookbackPeriod")]
        pub lookback_period: String,
    }
    impl MicrosoftEmergingThreatFeed {
        pub fn new(data_connector_data_type_common: DataConnectorDataTypeCommon, lookback_period: String) -> Self {
            Self {
                data_connector_data_type_common,
                lookback_period,
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MstiDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: MstiDataConnectorDataTypes,
}
impl MstiDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: MstiDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MtpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MtpDataConnectorProperties>,
}
impl MtpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MtpDataConnectorDataTypes {
    pub incidents: serde_json::Value,
}
impl MtpDataConnectorDataTypes {
    pub fn new(incidents: serde_json::Value) -> Self {
        Self { incidents }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MtpDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: MtpDataConnectorDataTypes,
}
impl MtpDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: MtpDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MailClusterEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MailClusterEntityProperties>,
}
impl MailClusterEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MailClusterEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "networkMessageIds", default, skip_serializing_if = "Vec::is_empty")]
    pub network_message_ids: Vec<String>,
    #[serde(rename = "countByDeliveryStatus", default, skip_serializing_if = "Option::is_none")]
    pub count_by_delivery_status: Option<serde_json::Value>,
    #[serde(rename = "countByThreatType", default, skip_serializing_if = "Option::is_none")]
    pub count_by_threat_type: Option<serde_json::Value>,
    #[serde(rename = "countByProtectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub count_by_protection_status: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub threats: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[serde(rename = "queryTime", default, skip_serializing_if = "Option::is_none")]
    pub query_time: Option<String>,
    #[serde(rename = "mailCount", default, skip_serializing_if = "Option::is_none")]
    pub mail_count: Option<i32>,
    #[serde(rename = "isVolumeAnomaly", default, skip_serializing_if = "Option::is_none")]
    pub is_volume_anomaly: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[serde(rename = "clusterSourceIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub cluster_source_identifier: Option<String>,
    #[serde(rename = "clusterSourceType", default, skip_serializing_if = "Option::is_none")]
    pub cluster_source_type: Option<String>,
    #[serde(rename = "clusterQueryStartTime", default, skip_serializing_if = "Option::is_none")]
    pub cluster_query_start_time: Option<String>,
    #[serde(rename = "clusterQueryEndTime", default, skip_serializing_if = "Option::is_none")]
    pub cluster_query_end_time: Option<String>,
    #[serde(rename = "clusterGroup", default, skip_serializing_if = "Option::is_none")]
    pub cluster_group: Option<String>,
}
impl MailClusterEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MailMessageEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MailMessageEntityProperties>,
}
impl MailMessageEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MailMessageEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "fileEntityIds", default, skip_serializing_if = "Vec::is_empty")]
    pub file_entity_ids: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recipient: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub urls: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub threats: Vec<String>,
    #[serde(rename = "p1Sender", default, skip_serializing_if = "Option::is_none")]
    pub p1_sender: Option<String>,
    #[serde(rename = "p1SenderDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub p1_sender_display_name: Option<String>,
    #[serde(rename = "p1SenderDomain", default, skip_serializing_if = "Option::is_none")]
    pub p1_sender_domain: Option<String>,
    #[serde(rename = "senderIP", default, skip_serializing_if = "Option::is_none")]
    pub sender_ip: Option<String>,
    #[serde(rename = "p2Sender", default, skip_serializing_if = "Option::is_none")]
    pub p2_sender: Option<String>,
    #[serde(rename = "p2SenderDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub p2_sender_display_name: Option<String>,
    #[serde(rename = "p2SenderDomain", default, skip_serializing_if = "Option::is_none")]
    pub p2_sender_domain: Option<String>,
    #[serde(rename = "receiveDate", default, skip_serializing_if = "Option::is_none")]
    pub receive_date: Option<String>,
    #[serde(rename = "networkMessageId", default, skip_serializing_if = "Option::is_none")]
    pub network_message_id: Option<String>,
    #[serde(rename = "internetMessageId", default, skip_serializing_if = "Option::is_none")]
    pub internet_message_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<String>,
    #[serde(rename = "threatDetectionMethods", default, skip_serializing_if = "Vec::is_empty")]
    pub threat_detection_methods: Vec<String>,
    #[serde(rename = "bodyFingerprintBin1", default, skip_serializing_if = "Option::is_none")]
    pub body_fingerprint_bin1: Option<i32>,
    #[serde(rename = "bodyFingerprintBin2", default, skip_serializing_if = "Option::is_none")]
    pub body_fingerprint_bin2: Option<i32>,
    #[serde(rename = "bodyFingerprintBin3", default, skip_serializing_if = "Option::is_none")]
    pub body_fingerprint_bin3: Option<i32>,
    #[serde(rename = "bodyFingerprintBin4", default, skip_serializing_if = "Option::is_none")]
    pub body_fingerprint_bin4: Option<i32>,
    #[serde(rename = "bodyFingerprintBin5", default, skip_serializing_if = "Option::is_none")]
    pub body_fingerprint_bin5: Option<i32>,
    #[serde(rename = "antispamDirection", default, skip_serializing_if = "Option::is_none")]
    pub antispam_direction: Option<mail_message_entity_properties::AntispamDirection>,
    #[serde(rename = "deliveryAction", default, skip_serializing_if = "Option::is_none")]
    pub delivery_action: Option<mail_message_entity_properties::DeliveryAction>,
    #[serde(rename = "deliveryLocation", default, skip_serializing_if = "Option::is_none")]
    pub delivery_location: Option<mail_message_entity_properties::DeliveryLocation>,
}
impl MailMessageEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod mail_message_entity_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AntispamDirection {
        Unknown,
        Inbound,
        Outbound,
        Intraorg,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeliveryAction {
        Unknown,
        DeliveredAsSpam,
        Delivered,
        Blocked,
        Replaced,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeliveryLocation {
        Unknown,
        Inbox,
        JunkFolder,
        DeletedFolder,
        Quarantine,
        External,
        Failed,
        Dropped,
        Forwarded,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MailboxEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MailboxEntityProperties>,
}
impl MailboxEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MailboxEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "mailboxPrimaryAddress", default, skip_serializing_if = "Option::is_none")]
    pub mailbox_primary_address: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub upn: Option<String>,
    #[serde(rename = "externalDirectoryObjectId", default, skip_serializing_if = "Option::is_none")]
    pub external_directory_object_id: Option<String>,
}
impl MailboxEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MalwareEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MalwareEntityProperties>,
}
impl MalwareEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MalwareEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(rename = "fileEntityIds", default, skip_serializing_if = "Vec::is_empty")]
    pub file_entity_ids: Vec<String>,
    #[serde(rename = "malwareName", default, skip_serializing_if = "Option::is_none")]
    pub malware_name: Option<String>,
    #[serde(rename = "processEntityIds", default, skip_serializing_if = "Vec::is_empty")]
    pub process_entity_ids: Vec<String>,
}
impl MalwareEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataList {
    pub value: Vec<MetadataModel>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MetadataList {
    pub fn new(value: Vec<MetadataModel>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataModel {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MetadataProperties>,
}
impl MetadataModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MicrosoftSecurityIncidentCreationAlertRuleProperties>,
}
impl MicrosoftSecurityIncidentCreationAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleCommonProperties {
    #[serde(rename = "displayNamesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_filter: Vec<String>,
    #[serde(rename = "displayNamesExcludeFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_exclude_filter: Vec<String>,
    #[serde(rename = "productFilter")]
    pub product_filter: microsoft_security_incident_creation_alert_rule_common_properties::ProductFilter,
    #[serde(rename = "severitiesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub severities_filter: Vec<AlertSeverity>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleCommonProperties {
    pub fn new(product_filter: microsoft_security_incident_creation_alert_rule_common_properties::ProductFilter) -> Self {
        Self {
            display_names_filter: Vec::new(),
            display_names_exclude_filter: Vec::new(),
            product_filter,
            severities_filter: Vec::new(),
        }
    }
}
pub mod microsoft_security_incident_creation_alert_rule_common_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProductFilter {
        #[serde(rename = "Microsoft Cloud App Security")]
        MicrosoftCloudAppSecurity,
        #[serde(rename = "Azure Security Center")]
        AzureSecurityCenter,
        #[serde(rename = "Azure Advanced Threat Protection")]
        AzureAdvancedThreatProtection,
        #[serde(rename = "Azure Active Directory Identity Protection")]
        AzureActiveDirectoryIdentityProtection,
        #[serde(rename = "Azure Security Center for IoT")]
        AzureSecurityCenterForIoT,
        #[serde(rename = "Office 365 Advanced Threat Protection")]
        Office365AdvancedThreatProtection,
        #[serde(rename = "Microsoft Defender Advanced Threat Protection")]
        MicrosoftDefenderAdvancedThreatProtection,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleProperties {
    #[serde(flatten)]
    pub microsoft_security_incident_creation_alert_rule_common_properties: MicrosoftSecurityIncidentCreationAlertRuleCommonProperties,
    #[serde(rename = "alertRuleTemplateName", default, skip_serializing_if = "Option::is_none")]
    pub alert_rule_template_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleProperties {
    pub fn new(
        microsoft_security_incident_creation_alert_rule_common_properties: MicrosoftSecurityIncidentCreationAlertRuleCommonProperties,
        display_name: String,
        enabled: bool,
    ) -> Self {
        Self {
            microsoft_security_incident_creation_alert_rule_common_properties,
            alert_rule_template_name: None,
            description: None,
            display_name,
            enabled,
            last_modified_utc: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeAtpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeAtpDataConnectorProperties>,
}
impl OfficeAtpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeAtpDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
}
impl OfficeAtpDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId) -> Self {
        Self {
            data_connector_tenant_id,
            data_connector_with_alerts_properties: DataConnectorWithAlertsProperties::default(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeDataConnectorProperties>,
}
impl OfficeDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeDataConnectorDataTypes {
    pub exchange: serde_json::Value,
    #[serde(rename = "sharePoint")]
    pub share_point: serde_json::Value,
    pub teams: serde_json::Value,
}
impl OfficeDataConnectorDataTypes {
    pub fn new(exchange: serde_json::Value, share_point: serde_json::Value, teams: serde_json::Value) -> Self {
        Self {
            exchange,
            share_point,
            teams,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "dataTypes")]
    pub data_types: OfficeDataConnectorDataTypes,
}
impl OfficeDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: OfficeDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationsList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Operation>,
}
impl OperationsList {
    pub fn new(value: Vec<Operation>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Permissions {
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_provider: Vec<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub customs: Vec<serde_json::Value>,
}
impl Permissions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProcessEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProcessEntityProperties>,
}
impl ProcessEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "accountEntityId", default, skip_serializing_if = "Option::is_none")]
    pub account_entity_id: Option<String>,
    #[serde(rename = "commandLine", default, skip_serializing_if = "Option::is_none")]
    pub command_line: Option<String>,
    #[serde(rename = "creationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub creation_time_utc: Option<String>,
    #[serde(rename = "elevationToken", default, skip_serializing_if = "Option::is_none")]
    pub elevation_token: Option<process_entity_properties::ElevationToken>,
    #[serde(rename = "hostEntityId", default, skip_serializing_if = "Option::is_none")]
    pub host_entity_id: Option<String>,
    #[serde(rename = "hostLogonSessionEntityId", default, skip_serializing_if = "Option::is_none")]
    pub host_logon_session_entity_id: Option<String>,
    #[serde(rename = "imageFileEntityId", default, skip_serializing_if = "Option::is_none")]
    pub image_file_entity_id: Option<String>,
    #[serde(rename = "parentProcessEntityId", default, skip_serializing_if = "Option::is_none")]
    pub parent_process_entity_id: Option<String>,
    #[serde(rename = "processId", default, skip_serializing_if = "Option::is_none")]
    pub process_id: Option<String>,
}
impl ProcessEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod process_entity_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ElevationToken {
        Default,
        Full,
        Limited,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegistryKeyEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RegistryKeyEntityProperties>,
}
impl RegistryKeyEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryKeyEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub hive: Option<registry_key_entity_properties::Hive>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
}
impl RegistryKeyEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod registry_key_entity_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Hive {
        #[serde(rename = "HKEY_LOCAL_MACHINE")]
        HkeyLocalMachine,
        #[serde(rename = "HKEY_CLASSES_ROOT")]
        HkeyClassesRoot,
        #[serde(rename = "HKEY_CURRENT_CONFIG")]
        HkeyCurrentConfig,
        #[serde(rename = "HKEY_USERS")]
        HkeyUsers,
        #[serde(rename = "HKEY_CURRENT_USER_LOCAL_SETTINGS")]
        HkeyCurrentUserLocalSettings,
        #[serde(rename = "HKEY_PERFORMANCE_DATA")]
        HkeyPerformanceData,
        #[serde(rename = "HKEY_PERFORMANCE_NLSTEXT")]
        HkeyPerformanceNlstext,
        #[serde(rename = "HKEY_PERFORMANCE_TEXT")]
        HkeyPerformanceText,
        #[serde(rename = "HKEY_A")]
        HkeyA,
        #[serde(rename = "HKEY_CURRENT_USER")]
        HkeyCurrentUser,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegistryValueEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RegistryValueEntityProperties>,
}
impl RegistryValueEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegistryValueEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "keyEntityId", default, skip_serializing_if = "Option::is_none")]
    pub key_entity_id: Option<String>,
    #[serde(rename = "valueData", default, skip_serializing_if = "Option::is_none")]
    pub value_data: Option<String>,
    #[serde(rename = "valueName", default, skip_serializing_if = "Option::is_none")]
    pub value_name: Option<String>,
    #[serde(rename = "valueType", default, skip_serializing_if = "Option::is_none")]
    pub value_type: Option<registry_value_entity_properties::ValueType>,
}
impl RegistryValueEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod registry_value_entity_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ValueType {
        None,
        Unknown,
        String,
        ExpandString,
        Binary,
        DWord,
        MultiString,
        QWord,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Relation {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RelationProperties>,
}
impl Relation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RelationList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Relation>,
}
impl RelationList {
    pub fn new(value: Vec<Relation>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RelationProperties {
    #[serde(rename = "relatedResourceId")]
    pub related_resource_id: String,
    #[serde(rename = "relatedResourceName", default, skip_serializing_if = "Option::is_none")]
    pub related_resource_name: Option<String>,
    #[serde(rename = "relatedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub related_resource_type: Option<String>,
    #[serde(rename = "relatedResourceKind", default, skip_serializing_if = "Option::is_none")]
    pub related_resource_kind: Option<String>,
}
impl RelationProperties {
    pub fn new(related_resource_id: String) -> Self {
        Self {
            related_resource_id,
            related_resource_name: None,
            related_resource_type: None,
            related_resource_kind: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Repo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "fullName", default, skip_serializing_if = "Option::is_none")]
    pub full_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub branches: Vec<String>,
}
impl Repo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RepoList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Repo>,
}
impl RepoList {
    pub fn new(value: Vec<Repo>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RepoType {
    Github,
    DevOps,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Repository {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[serde(rename = "displayUrl", default, skip_serializing_if = "Option::is_none")]
    pub display_url: Option<String>,
    #[serde(rename = "deploymentLogsUrl", default, skip_serializing_if = "Option::is_none")]
    pub deployment_logs_url: Option<String>,
    #[serde(rename = "pathMapping", default, skip_serializing_if = "Vec::is_empty")]
    pub path_mapping: Vec<ContentPathMap>,
}
impl Repository {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequiredPermissions {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub write: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub read: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub delete: Option<bool>,
}
impl RequiredPermissions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProvider {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<resource_provider::Provider>,
    #[serde(rename = "permissionsDisplayText", default, skip_serializing_if = "Option::is_none")]
    pub permissions_display_text: Option<String>,
    #[serde(rename = "providerDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub provider_display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<resource_provider::Scope>,
    #[serde(rename = "requiredPermissions", default, skip_serializing_if = "Option::is_none")]
    pub required_permissions: Option<RequiredPermissions>,
}
impl ResourceProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_provider {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Provider {
        #[serde(rename = "Microsoft.OperationalInsights/solutions")]
        MicrosoftOperationalInsightsSolutions,
        #[serde(rename = "Microsoft.OperationalInsights/workspaces")]
        MicrosoftOperationalInsightsWorkspaces,
        #[serde(rename = "Microsoft.OperationalInsights/workspaces/datasources")]
        MicrosoftOperationalInsightsWorkspacesDatasources,
        #[serde(rename = "microsoft.aadiam/diagnosticSettings")]
        MicrosoftAadiamDiagnosticSettings,
        #[serde(rename = "Microsoft.OperationalInsights/workspaces/sharedKeys")]
        MicrosoftOperationalInsightsWorkspacesSharedKeys,
        #[serde(rename = "Microsoft.Authorization/policyAssignments")]
        MicrosoftAuthorizationPolicyAssignments,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Scope {
        ResourceGroup,
        Subscription,
        Workspace,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceWithEtag {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ResourceWithEtag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SampleQueries {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
}
impl SampleQueries {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScheduledAlertRuleProperties>,
}
impl ScheduledAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduledAlertRuleCommonProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[serde(rename = "queryFrequency", default, skip_serializing_if = "Option::is_none")]
    pub query_frequency: Option<String>,
    #[serde(rename = "queryPeriod", default, skip_serializing_if = "Option::is_none")]
    pub query_period: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[serde(rename = "triggerOperator", default, skip_serializing_if = "Option::is_none")]
    pub trigger_operator: Option<AlertRuleTriggerOperator>,
    #[serde(rename = "triggerThreshold", default, skip_serializing_if = "Option::is_none")]
    pub trigger_threshold: Option<i32>,
    #[serde(rename = "eventGroupingSettings", default, skip_serializing_if = "Option::is_none")]
    pub event_grouping_settings: Option<EventGroupingSettings>,
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<serde_json::Value>,
    #[serde(rename = "entityMappings", default, skip_serializing_if = "Option::is_none")]
    pub entity_mappings: Option<EntityMappings>,
    #[serde(rename = "alertDetailsOverride", default, skip_serializing_if = "Option::is_none")]
    pub alert_details_override: Option<AlertDetailsOverride>,
}
impl ScheduledAlertRuleCommonProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRuleProperties {
    #[serde(flatten)]
    pub scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties,
    #[serde(rename = "alertRuleTemplateName", default, skip_serializing_if = "Option::is_none")]
    pub alert_rule_template_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(rename = "suppressionDuration")]
    pub suppression_duration: String,
    #[serde(rename = "suppressionEnabled")]
    pub suppression_enabled: bool,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
    #[serde(rename = "incidentConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub incident_configuration: Option<IncidentConfiguration>,
}
impl ScheduledAlertRuleProperties {
    pub fn new(display_name: String, enabled: bool, suppression_duration: String, suppression_enabled: bool) -> Self {
        Self {
            scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties::default(),
            alert_rule_template_name: None,
            description: None,
            display_name,
            enabled,
            last_modified_utc: None,
            suppression_duration,
            suppression_enabled,
            tactics: Vec::new(),
            incident_configuration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<scheduled_alert_rule_template::Properties>,
}
impl ScheduledAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
pub mod scheduled_alert_rule_template {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(flatten)]
        pub alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase,
        #[serde(flatten)]
        pub scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tactics: Vec<AttackTactic>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self {
                alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase::default(),
                scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties::default(),
                tactics: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAlert {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityAlertProperties>,
}
impl SecurityAlert {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAlertProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "alertDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub alert_display_name: Option<String>,
    #[serde(rename = "alertType", default, skip_serializing_if = "Option::is_none")]
    pub alert_type: Option<String>,
    #[serde(rename = "compromisedEntity", default, skip_serializing_if = "Option::is_none")]
    pub compromised_entity: Option<String>,
    #[serde(rename = "confidenceLevel", default, skip_serializing_if = "Option::is_none")]
    pub confidence_level: Option<security_alert_properties::ConfidenceLevel>,
    #[serde(rename = "confidenceReasons", default, skip_serializing_if = "Vec::is_empty")]
    pub confidence_reasons: Vec<serde_json::Value>,
    #[serde(rename = "confidenceScore", default, skip_serializing_if = "Option::is_none")]
    pub confidence_score: Option<f64>,
    #[serde(rename = "confidenceScoreStatus", default, skip_serializing_if = "Option::is_none")]
    pub confidence_score_status: Option<security_alert_properties::ConfidenceScoreStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "endTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub end_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub intent: Option<security_alert_properties::Intent>,
    #[serde(rename = "providerAlertId", default, skip_serializing_if = "Option::is_none")]
    pub provider_alert_id: Option<String>,
    #[serde(rename = "processingEndTime", default, skip_serializing_if = "Option::is_none")]
    pub processing_end_time: Option<String>,
    #[serde(rename = "productComponentName", default, skip_serializing_if = "Option::is_none")]
    pub product_component_name: Option<String>,
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[serde(rename = "productVersion", default, skip_serializing_if = "Option::is_none")]
    pub product_version: Option<String>,
    #[serde(rename = "remediationSteps", default, skip_serializing_if = "Vec::is_empty")]
    pub remediation_steps: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[serde(rename = "startTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub start_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<security_alert_properties::Status>,
    #[serde(rename = "systemAlertId", default, skip_serializing_if = "Option::is_none")]
    pub system_alert_id: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
    #[serde(rename = "timeGenerated", default, skip_serializing_if = "Option::is_none")]
    pub time_generated: Option<String>,
    #[serde(rename = "vendorName", default, skip_serializing_if = "Option::is_none")]
    pub vendor_name: Option<String>,
    #[serde(rename = "alertLink", default, skip_serializing_if = "Option::is_none")]
    pub alert_link: Option<String>,
    #[serde(rename = "resourceIdentifiers", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_identifiers: Vec<serde_json::Value>,
}
impl SecurityAlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod security_alert_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConfidenceLevel {
        Unknown,
        Low,
        High,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConfidenceScoreStatus {
        NotApplicable,
        InProcess,
        NotFinal,
        Final,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Intent {
        Unknown,
        Probing,
        Exploitation,
        Persistence,
        PrivilegeEscalation,
        DefenseEvasion,
        CredentialAccess,
        Discovery,
        LateralMovement,
        Execution,
        Collection,
        Exfiltration,
        CommandAndControl,
        Impact,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Unknown,
        New,
        Resolved,
        Dismissed,
        InProgress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAlertTimelineItem {
    #[serde(flatten)]
    pub entity_timeline_item: EntityTimelineItem,
    #[serde(rename = "azureResourceId")]
    pub azure_resource_id: String,
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub severity: AlertSeverity,
    #[serde(rename = "endTimeUtc")]
    pub end_time_utc: String,
    #[serde(rename = "startTimeUtc")]
    pub start_time_utc: String,
    #[serde(rename = "timeGenerated")]
    pub time_generated: String,
    #[serde(rename = "alertType")]
    pub alert_type: String,
}
impl SecurityAlertTimelineItem {
    pub fn new(
        entity_timeline_item: EntityTimelineItem,
        azure_resource_id: String,
        display_name: String,
        severity: AlertSeverity,
        end_time_utc: String,
        start_time_utc: String,
        time_generated: String,
        alert_type: String,
    ) -> Self {
        Self {
            entity_timeline_item,
            azure_resource_id,
            product_name: None,
            description: None,
            display_name,
            severity,
            end_time_utc,
            start_time_utc,
            time_generated,
            alert_type,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityGroupEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityGroupEntityProperties>,
}
impl SecurityGroupEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityGroupEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "distinguishedName", default, skip_serializing_if = "Option::is_none")]
    pub distinguished_name: Option<String>,
    #[serde(rename = "objectGuid", default, skip_serializing_if = "Option::is_none")]
    pub object_guid: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sid: Option<String>,
}
impl SecurityGroupEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SentinelOnboardingState {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SentinelOnboardingStateProperties>,
}
impl SentinelOnboardingState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SentinelOnboardingStateProperties {
    #[serde(rename = "customerManagedKey", default, skip_serializing_if = "Option::is_none")]
    pub customer_managed_key: Option<bool>,
}
impl SentinelOnboardingStateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SentinelOnboardingStatesList {
    pub value: Vec<SentinelOnboardingState>,
}
impl SentinelOnboardingStatesList {
    pub fn new(value: Vec<SentinelOnboardingState>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SettingList {
    pub value: Vec<Settings>,
}
impl SettingList {
    pub fn new(value: Vec<Settings>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Settings {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: settings::Kind,
}
impl Settings {
    pub fn new(kind: settings::Kind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
pub mod settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Anomalies,
        EyesOn,
        EntityAnalytics,
        Ueba,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<sku::Name>,
    #[serde(rename = "capacityReservationLevel", default, skip_serializing_if = "Option::is_none")]
    pub capacity_reservation_level: Option<i32>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "PerGB")]
        PerGb,
        CapacityReservation,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SourceControl {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SourceControlProperties>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl SourceControl {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceControlList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<SourceControl>,
}
impl SourceControlList {
    pub fn new(value: Vec<SourceControl>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SourceControlProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "repoType")]
    pub repo_type: RepoType,
    #[serde(rename = "contentTypes")]
    pub content_types: Vec<ContentType>,
    pub repository: Repository,
}
impl SourceControlProperties {
    pub fn new(display_name: String, repo_type: RepoType, content_types: Vec<ContentType>, repository: Repository) -> Self {
        Self {
            id: None,
            display_name,
            description: None,
            repo_type,
            content_types,
            repository,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SubmissionMailEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubmissionMailEntityProperties>,
}
impl SubmissionMailEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubmissionMailEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(rename = "networkMessageId", default, skip_serializing_if = "Option::is_none")]
    pub network_message_id: Option<String>,
    #[serde(rename = "submissionId", default, skip_serializing_if = "Option::is_none")]
    pub submission_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub submitter: Option<String>,
    #[serde(rename = "submissionDate", default, skip_serializing_if = "Option::is_none")]
    pub submission_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recipient: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sender: Option<String>,
    #[serde(rename = "senderIp", default, skip_serializing_if = "Option::is_none")]
    pub sender_ip: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(rename = "reportType", default, skip_serializing_if = "Option::is_none")]
    pub report_type: Option<String>,
}
impl SubmissionMailEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TiDataConnectorProperties>,
}
impl TiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiDataConnectorDataTypes {
    pub indicators: serde_json::Value,
}
impl TiDataConnectorDataTypes {
    pub fn new(indicators: serde_json::Value) -> Self {
        Self { indicators }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "tipLookbackPeriod", default, skip_serializing_if = "Option::is_none")]
    pub tip_lookback_period: Option<String>,
    #[serde(rename = "dataTypes")]
    pub data_types: TiDataConnectorDataTypes,
}
impl TiDataConnectorProperties {
    pub fn new(data_connector_tenant_id: DataConnectorTenantId, data_types: TiDataConnectorDataTypes) -> Self {
        Self {
            data_connector_tenant_id,
            tip_lookback_period: None,
            data_types,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeamInformation {
    #[serde(rename = "teamId", default, skip_serializing_if = "Option::is_none")]
    pub team_id: Option<String>,
    #[serde(rename = "primaryChannelUrl", default, skip_serializing_if = "Option::is_none")]
    pub primary_channel_url: Option<String>,
    #[serde(rename = "teamCreationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub team_creation_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl TeamInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeamProperties {
    #[serde(rename = "teamName")]
    pub team_name: String,
    #[serde(rename = "teamDescription", default, skip_serializing_if = "Option::is_none")]
    pub team_description: Option<String>,
    #[serde(rename = "memberIds", default, skip_serializing_if = "Vec::is_empty")]
    pub member_ids: Vec<String>,
    #[serde(rename = "groupIds", default, skip_serializing_if = "Vec::is_empty")]
    pub group_ids: Vec<String>,
}
impl TeamProperties {
    pub fn new(team_name: String) -> Self {
        Self {
            team_name,
            team_description: None,
            member_ids: Vec::new(),
            group_ids: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub confidence: Option<f64>,
    #[serde(rename = "providerName", default, skip_serializing_if = "Option::is_none")]
    pub provider_name: Option<String>,
    #[serde(rename = "reportLink", default, skip_serializing_if = "Option::is_none")]
    pub report_link: Option<String>,
    #[serde(rename = "threatDescription", default, skip_serializing_if = "Option::is_none")]
    pub threat_description: Option<String>,
    #[serde(rename = "threatName", default, skip_serializing_if = "Option::is_none")]
    pub threat_name: Option<String>,
    #[serde(rename = "threatType", default, skip_serializing_if = "Option::is_none")]
    pub threat_type: Option<String>,
}
impl ThreatIntelligence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ThreatIntelligenceAlertRuleProperties>,
}
impl ThreatIntelligenceAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceAlertRuleProperties {
    #[serde(rename = "alertRuleTemplateName")]
    pub alert_rule_template_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl ThreatIntelligenceAlertRuleProperties {
    pub fn new(alert_rule_template_name: String, enabled: bool) -> Self {
        Self {
            alert_rule_template_name,
            description: None,
            display_name: None,
            enabled,
            last_modified_utc: None,
            severity: None,
            tactics: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreatIntelligenceAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<threat_intelligence_alert_rule_template::Properties>,
}
impl ThreatIntelligenceAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
pub mod threat_intelligence_alert_rule_template {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct Properties {
        #[serde(flatten)]
        pub alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase,
        pub severity: AlertSeverity,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub tactics: Vec<AttackTactic>,
    }
    impl Properties {
        pub fn new(severity: AlertSeverity) -> Self {
            Self {
                alert_rule_template_properties_base: AlertRuleTemplatePropertiesBase::default(),
                severity,
                tactics: Vec::new(),
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiTaxiiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TiTaxiiDataConnectorProperties>,
}
impl TiTaxiiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiTaxiiDataConnectorDataTypes {
    #[serde(rename = "taxiiClient")]
    pub taxii_client: serde_json::Value,
}
impl TiTaxiiDataConnectorDataTypes {
    pub fn new(taxii_client: serde_json::Value) -> Self {
        Self { taxii_client }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiTaxiiDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_tenant_id: DataConnectorTenantId,
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "taxiiServer", default, skip_serializing_if = "Option::is_none")]
    pub taxii_server: Option<String>,
    #[serde(rename = "collectionId", default, skip_serializing_if = "Option::is_none")]
    pub collection_id: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "taxiiLookbackPeriod", default, skip_serializing_if = "Option::is_none")]
    pub taxii_lookback_period: Option<String>,
    #[serde(rename = "pollingFrequency")]
    pub polling_frequency: ti_taxii_data_connector_properties::PollingFrequency,
    #[serde(rename = "dataTypes")]
    pub data_types: TiTaxiiDataConnectorDataTypes,
}
impl TiTaxiiDataConnectorProperties {
    pub fn new(
        data_connector_tenant_id: DataConnectorTenantId,
        polling_frequency: ti_taxii_data_connector_properties::PollingFrequency,
        data_types: TiTaxiiDataConnectorDataTypes,
    ) -> Self {
        Self {
            data_connector_tenant_id,
            workspace_id: None,
            friendly_name: None,
            taxii_server: None,
            collection_id: None,
            user_name: None,
            password: None,
            taxii_lookback_period: None,
            polling_frequency,
            data_types,
        }
    }
}
pub mod ti_taxii_data_connector_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PollingFrequency {
        OnceAMinute,
        OnceAnHour,
        OnceADay,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Ueba {
    #[serde(flatten)]
    pub settings: Settings,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UebaProperties>,
}
impl Ueba {
    pub fn new(settings: Settings) -> Self {
        Self {
            settings,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum UebaDataSources {
    AuditLogs,
    AzureActivity,
    SecurityEvent,
    SigninLogs,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UebaProperties {
    #[serde(rename = "dataSources", default, skip_serializing_if = "Vec::is_empty")]
    pub data_sources: Vec<UebaDataSources>,
}
impl UebaProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UrlEntity {
    #[serde(flatten)]
    pub entity: Entity,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UrlEntityProperties>,
}
impl UrlEntity {
    pub fn new(entity: Entity) -> Self {
        Self { entity, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UrlEntityProperties {
    #[serde(flatten)]
    pub entity_common_properties: EntityCommonProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl UrlEntityProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
}
impl UserInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Watchlist {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WatchlistProperties>,
}
impl Watchlist {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WatchlistItem {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WatchlistItemProperties>,
}
impl WatchlistItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WatchlistItemList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<WatchlistItem>,
}
impl WatchlistItemList {
    pub fn new(value: Vec<WatchlistItem>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WatchlistItemProperties {
    #[serde(rename = "watchlistItemType", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_item_type: Option<String>,
    #[serde(rename = "watchlistItemId", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_item_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "isDeleted", default, skip_serializing_if = "Option::is_none")]
    pub is_deleted: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<UserInfo>,
    #[serde(rename = "itemsKeyValue")]
    pub items_key_value: serde_json::Value,
    #[serde(rename = "entityMapping", default, skip_serializing_if = "Option::is_none")]
    pub entity_mapping: Option<serde_json::Value>,
}
impl WatchlistItemProperties {
    pub fn new(items_key_value: serde_json::Value) -> Self {
        Self {
            watchlist_item_type: None,
            watchlist_item_id: None,
            tenant_id: None,
            is_deleted: None,
            created: None,
            updated: None,
            created_by: None,
            updated_by: None,
            items_key_value,
            entity_mapping: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WatchlistList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Watchlist>,
}
impl WatchlistList {
    pub fn new(value: Vec<Watchlist>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WatchlistProperties {
    #[serde(rename = "watchlistId", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_id: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub provider: String,
    pub source: watchlist_properties::Source,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<UserInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "watchlistType", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_type: Option<String>,
    #[serde(rename = "watchlistAlias", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_alias: Option<String>,
    #[serde(rename = "isDeleted", default, skip_serializing_if = "Option::is_none")]
    pub is_deleted: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<Label>,
    #[serde(rename = "defaultDuration", default, skip_serializing_if = "Option::is_none")]
    pub default_duration: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "numberOfLinesToSkip", default, skip_serializing_if = "Option::is_none")]
    pub number_of_lines_to_skip: Option<i32>,
    #[serde(rename = "rawContent", default, skip_serializing_if = "Option::is_none")]
    pub raw_content: Option<String>,
    #[serde(rename = "itemsSearchKey")]
    pub items_search_key: String,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "uploadStatus", default, skip_serializing_if = "Option::is_none")]
    pub upload_status: Option<String>,
    #[serde(rename = "watchlistItemsCount", default, skip_serializing_if = "Option::is_none")]
    pub watchlist_items_count: Option<i32>,
}
impl WatchlistProperties {
    pub fn new(display_name: String, provider: String, source: watchlist_properties::Source, items_search_key: String) -> Self {
        Self {
            watchlist_id: None,
            display_name,
            provider,
            source,
            created: None,
            updated: None,
            created_by: None,
            updated_by: None,
            description: None,
            watchlist_type: None,
            watchlist_alias: None,
            is_deleted: None,
            labels: Vec::new(),
            default_duration: None,
            tenant_id: None,
            number_of_lines_to_skip: None,
            raw_content: None,
            items_search_key,
            content_type: None,
            upload_status: None,
            watchlist_items_count: None,
        }
    }
}
pub mod watchlist_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        #[serde(rename = "Local file")]
        LocalFile,
        #[serde(rename = "Remote storage")]
        RemoteStorage,
    }
}
pub type FirstPublishDate = String;
pub type LastPublishDate = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataAuthor {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
}
impl MetadataAuthor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataCategories {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub domains: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub verticals: Vec<String>,
}
impl MetadataCategories {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type MetadataContentId = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataDependencies {
    #[serde(rename = "contentId", default, skip_serializing_if = "Option::is_none")]
    pub content_id: Option<MetadataContentId>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<MetadataKind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<MetadataVersion>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operator: Option<metadata_dependencies::Operator>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub criteria: Vec<MetadataDependencies>,
}
impl MetadataDependencies {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod metadata_dependencies {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        #[serde(rename = "AND")]
        And,
        #[serde(rename = "OR")]
        Or,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum MetadataKind {
    DataConnector,
    DataType,
    Workbook,
    WorkbookTemplate,
    Playbook,
    PlaybookTemplate,
    AnalyticsRuleTemplate,
    AnalyticsRule,
    HuntingQuery,
    InvestigationQuery,
    Parser,
    Watchlist,
    WatchlistTemplate,
    Solution,
}
pub type MetadataParentId = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataPatch {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MetadataPropertiesPatch>,
}
impl MetadataPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataProperties {
    #[serde(rename = "contentId", default, skip_serializing_if = "Option::is_none")]
    pub content_id: Option<MetadataContentId>,
    #[serde(rename = "parentId")]
    pub parent_id: MetadataParentId,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<MetadataVersion>,
    pub kind: MetadataKind,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<MetadataSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<MetadataAuthor>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub support: Option<MetadataSupport>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dependencies: Option<MetadataDependencies>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub categories: Option<MetadataCategories>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub providers: Option<MetadataProviders>,
    #[serde(rename = "firstPublishDate", default, skip_serializing_if = "Option::is_none")]
    pub first_publish_date: Option<FirstPublishDate>,
    #[serde(rename = "lastPublishDate", default, skip_serializing_if = "Option::is_none")]
    pub last_publish_date: Option<LastPublishDate>,
}
impl MetadataProperties {
    pub fn new(parent_id: MetadataParentId, kind: MetadataKind) -> Self {
        Self {
            content_id: None,
            parent_id,
            version: None,
            kind,
            source: None,
            author: None,
            support: None,
            dependencies: None,
            categories: None,
            providers: None,
            first_publish_date: None,
            last_publish_date: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataPropertiesPatch {
    #[serde(rename = "contentId", default, skip_serializing_if = "Option::is_none")]
    pub content_id: Option<MetadataContentId>,
    #[serde(rename = "parentId", default, skip_serializing_if = "Option::is_none")]
    pub parent_id: Option<MetadataParentId>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<MetadataVersion>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<MetadataKind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<MetadataSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<MetadataAuthor>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub support: Option<MetadataSupport>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dependencies: Option<MetadataDependencies>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub categories: Option<MetadataCategories>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub providers: Option<MetadataProviders>,
    #[serde(rename = "firstPublishDate", default, skip_serializing_if = "Option::is_none")]
    pub first_publish_date: Option<FirstPublishDate>,
    #[serde(rename = "lastPublishDate", default, skip_serializing_if = "Option::is_none")]
    pub last_publish_date: Option<LastPublishDate>,
}
impl MetadataPropertiesPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type MetadataProviders = Vec<String>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataSource {
    pub kind: metadata_source::Kind,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "sourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_id: Option<String>,
}
impl MetadataSource {
    pub fn new(kind: metadata_source::Kind) -> Self {
        Self {
            kind,
            name: None,
            source_id: None,
        }
    }
}
pub mod metadata_source {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        LocalWorkspace,
        Community,
        Solution,
        SourceRepository,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataSupport {
    pub tier: metadata_support::Tier,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
}
impl MetadataSupport {
    pub fn new(tier: metadata_support::Tier) -> Self {
        Self {
            tier,
            name: None,
            email: None,
            link: None,
        }
    }
}
pub mod metadata_support {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Microsoft,
        Partner,
        Community,
    }
}
pub type MetadataVersion = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
