#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AadDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AadDataConnectorProperties>,
}
impl AadDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadDataConnectorProperties {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl AadDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AatpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AatpDataConnectorProperties>,
}
impl AatpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AatpDataConnectorProperties {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl AatpDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AscDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AscDataConnectorProperties>,
}
impl AscDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscDataConnectorProperties {
    #[serde(flatten)]
    pub data_connector_with_alerts_properties: DataConnectorWithAlertsProperties,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
}
impl AscDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionPropertiesBase {
    #[serde(rename = "logicAppResourceId")]
    pub logic_app_resource_id: String,
}
impl ActionPropertiesBase {
    pub fn new(logic_app_resource_id: String) -> Self {
        Self { logic_app_resource_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActionRequest {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActionRequestProperties>,
}
impl ActionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionRequestProperties {
    #[serde(flatten)]
    pub action_properties_base: ActionPropertiesBase,
    #[serde(rename = "triggerUri")]
    pub trigger_uri: String,
}
impl ActionRequestProperties {
    pub fn new(action_properties_base: ActionPropertiesBase, trigger_uri: String) -> Self {
        Self {
            action_properties_base,
            trigger_uri,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActionResponse {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ActionResponseProperties>,
}
impl ActionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionResponseProperties {
    #[serde(flatten)]
    pub action_properties_base: ActionPropertiesBase,
    #[serde(rename = "workflowId", default, skip_serializing_if = "Option::is_none")]
    pub workflow_id: Option<String>,
}
impl ActionResponseProperties {
    pub fn new(action_properties_base: ActionPropertiesBase) -> Self {
        Self {
            action_properties_base,
            workflow_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActionsList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<ActionResponse>,
}
impl ActionsList {
    pub fn new(value: Vec<ActionResponse>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRule {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: AlertRuleKind,
}
impl AlertRule {
    pub fn new(kind: AlertRuleKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleKind {
    Scheduled,
    MicrosoftSecurityIncidentCreation,
    Fusion,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleTemplate {
    #[serde(flatten)]
    pub resource: Resource,
    pub kind: AlertRuleKind,
}
impl AlertRuleTemplate {
    pub fn new(kind: AlertRuleKind) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertRuleTemplateDataSource {
    #[serde(rename = "connectorId", default, skip_serializing_if = "Option::is_none")]
    pub connector_id: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub data_types: Vec<String>,
}
impl AlertRuleTemplateDataSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleTemplateStatus {
    Installed,
    Available,
    NotAvailable,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRuleTemplatesList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<AlertRuleTemplate>,
}
impl AlertRuleTemplatesList {
    pub fn new(value: Vec<AlertRuleTemplate>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertRuleTriggerOperator {
    GreaterThan,
    LessThan,
    Equal,
    NotEqual,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRulesList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<AlertRule>,
}
impl AlertRulesList {
    pub fn new(value: Vec<AlertRule>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AlertSeverity {
    High,
    Medium,
    Low,
    Informational,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertsDataTypeOfDataConnector {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub alerts: Option<DataConnectorDataTypeCommon>,
}
impl AlertsDataTypeOfDataConnector {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AttackTactic {
    InitialAccess,
    Execution,
    Persistence,
    PrivilegeEscalation,
    DefenseEvasion,
    CredentialAccess,
    Discovery,
    LateralMovement,
    Collection,
    Exfiltration,
    CommandAndControl,
    Impact,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AwsCloudTrailDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AwsCloudTrailDataConnectorProperties>,
}
impl AwsCloudTrailDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AwsCloudTrailDataConnectorDataTypes {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub logs: Option<serde_json::Value>,
}
impl AwsCloudTrailDataConnectorDataTypes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AwsCloudTrailDataConnectorProperties {
    #[serde(rename = "awsRoleArn", default, skip_serializing_if = "Option::is_none")]
    pub aws_role_arn: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AwsCloudTrailDataConnectorDataTypes>,
}
impl AwsCloudTrailDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Bookmark {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BookmarkProperties>,
}
impl Bookmark {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BookmarkList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Bookmark>,
}
impl BookmarkList {
    pub fn new(value: Vec<Bookmark>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BookmarkProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserInfo>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<Label>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    pub query: String,
    #[serde(rename = "queryResult", default, skip_serializing_if = "Option::is_none")]
    pub query_result: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    #[serde(rename = "updatedBy", default, skip_serializing_if = "Option::is_none")]
    pub updated_by: Option<UserInfo>,
    #[serde(rename = "eventTime", default, skip_serializing_if = "Option::is_none")]
    pub event_time: Option<String>,
    #[serde(rename = "queryStartTime", default, skip_serializing_if = "Option::is_none")]
    pub query_start_time: Option<String>,
    #[serde(rename = "queryEndTime", default, skip_serializing_if = "Option::is_none")]
    pub query_end_time: Option<String>,
    #[serde(rename = "incidentInfo", default, skip_serializing_if = "Option::is_none")]
    pub incident_info: Option<IncidentInfo>,
}
impl BookmarkProperties {
    pub fn new(display_name: String, query: String) -> Self {
        Self {
            created: None,
            created_by: None,
            display_name,
            labels: Vec::new(),
            notes: None,
            query,
            query_result: None,
            updated: None,
            updated_by: None,
            event_time: None,
            query_start_time: None,
            query_end_time: None,
            incident_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
}
impl ClientInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnector {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    pub kind: DataConnectorKind,
}
impl DataConnector {
    pub fn new(kind: DataConnectorKind) -> Self {
        Self {
            resource_with_etag: ResourceWithEtag::default(),
            kind,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorDataTypeCommon {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<data_connector_data_type_common::State>,
}
impl DataConnectorDataTypeCommon {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_connector_data_type_common {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DataConnectorKind {
    AzureActiveDirectory,
    AzureSecurityCenter,
    MicrosoftCloudAppSecurity,
    ThreatIntelligence,
    Office365,
    AmazonWebServicesCloudTrail,
    AzureAdvancedThreatProtection,
    MicrosoftDefenderAdvancedThreatProtection,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataConnectorList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<DataConnector>,
}
impl DataConnectorList {
    pub fn new(value: Vec<DataConnector>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorTenantId {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl DataConnectorTenantId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataConnectorWithAlertsProperties {
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl DataConnectorWithAlertsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorResponse>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FusionAlertRuleProperties>,
}
impl FusionAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRuleProperties {
    #[serde(rename = "alertRuleTemplateName")]
    pub alert_rule_template_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl FusionAlertRuleProperties {
    pub fn new(alert_rule_template_name: String, enabled: bool) -> Self {
        Self {
            alert_rule_template_name,
            description: None,
            display_name: None,
            enabled,
            last_modified_utc: None,
            severity: None,
            tactics: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FusionAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FusionAlertRuleTemplateProperties>,
}
impl FusionAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FusionAlertRuleTemplateProperties {
    #[serde(rename = "alertRulesCreatedByTemplateCount", default, skip_serializing_if = "Option::is_none")]
    pub alert_rules_created_by_template_count: Option<i32>,
    #[serde(rename = "createdDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub created_date_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "requiredDataConnectors", default, skip_serializing_if = "Vec::is_empty")]
    pub required_data_connectors: Vec<AlertRuleTemplateDataSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<AlertRuleTemplateStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl FusionAlertRuleTemplateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Incident {
    #[serde(flatten)]
    pub resource_with_etag: ResourceWithEtag,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IncidentProperties>,
}
impl Incident {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentAdditionalData {
    #[serde(rename = "alertsCount", default, skip_serializing_if = "Option::is_none")]
    pub alerts_count: Option<i32>,
    #[serde(rename = "bookmarksCount", default, skip_serializing_if = "Option::is_none")]
    pub bookmarks_count: Option<i32>,
    #[serde(rename = "commentsCount", default, skip_serializing_if = "Option::is_none")]
    pub comments_count: Option<i32>,
    #[serde(rename = "alertProductNames", default, skip_serializing_if = "Vec::is_empty")]
    pub alert_product_names: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl IncidentAdditionalData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentComment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IncidentCommentProperties>,
}
impl IncidentComment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentCommentList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<IncidentComment>,
}
impl IncidentCommentList {
    pub fn new(value: Vec<IncidentComment>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentCommentProperties {
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    pub message: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<ClientInfo>,
}
impl IncidentCommentProperties {
    pub fn new(message: String) -> Self {
        Self {
            created_time_utc: None,
            message,
            author: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentInfo {
    #[serde(rename = "incidentId", default, skip_serializing_if = "Option::is_none")]
    pub incident_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<IncidentSeverityEnum>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(rename = "relationName", default, skip_serializing_if = "Option::is_none")]
    pub relation_name: Option<String>,
}
impl IncidentInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentLabel {
    #[serde(rename = "labelName")]
    pub label_name: String,
    #[serde(rename = "labelType", default, skip_serializing_if = "Option::is_none")]
    pub label_type: Option<incident_label::LabelType>,
}
impl IncidentLabel {
    pub fn new(label_name: String) -> Self {
        Self {
            label_name,
            label_type: None,
        }
    }
}
pub mod incident_label {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LabelType {
        User,
        System,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Incident>,
}
impl IncidentList {
    pub fn new(value: Vec<Incident>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IncidentOwnerInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(rename = "assignedTo", default, skip_serializing_if = "Option::is_none")]
    pub assigned_to: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[serde(rename = "userPrincipalName", default, skip_serializing_if = "Option::is_none")]
    pub user_principal_name: Option<String>,
}
impl IncidentOwnerInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IncidentProperties {
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<IncidentAdditionalData>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub classification: Option<incident_properties::Classification>,
    #[serde(rename = "classificationComment", default, skip_serializing_if = "Option::is_none")]
    pub classification_comment: Option<String>,
    #[serde(rename = "classificationReason", default, skip_serializing_if = "Option::is_none")]
    pub classification_reason: Option<incident_properties::ClassificationReason>,
    #[serde(rename = "createdTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "firstActivityTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub first_activity_time_utc: Option<String>,
    #[serde(rename = "incidentUrl", default, skip_serializing_if = "Option::is_none")]
    pub incident_url: Option<String>,
    #[serde(rename = "incidentNumber", default, skip_serializing_if = "Option::is_none")]
    pub incident_number: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<IncidentLabel>,
    #[serde(rename = "lastActivityTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_activity_time_utc: Option<String>,
    #[serde(rename = "lastModifiedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub owner: Option<IncidentOwnerInfo>,
    #[serde(rename = "relatedAnalyticRuleIds", default, skip_serializing_if = "Vec::is_empty")]
    pub related_analytic_rule_ids: Vec<String>,
    pub severity: IncidentSeverityEnum,
    pub status: incident_properties::Status,
    pub title: String,
}
impl IncidentProperties {
    pub fn new(severity: IncidentSeverityEnum, status: incident_properties::Status, title: String) -> Self {
        Self {
            additional_data: None,
            classification: None,
            classification_comment: None,
            classification_reason: None,
            created_time_utc: None,
            description: None,
            first_activity_time_utc: None,
            incident_url: None,
            incident_number: None,
            labels: Vec::new(),
            last_activity_time_utc: None,
            last_modified_time_utc: None,
            owner: None,
            related_analytic_rule_ids: Vec::new(),
            severity,
            status,
            title,
        }
    }
}
pub mod incident_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Classification {
        Undetermined,
        TruePositive,
        BenignPositive,
        FalsePositive,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ClassificationReason {
        SuspiciousActivity,
        SuspiciousButExpected,
        IncorrectAlertLogic,
        InaccurateData,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        New,
        Active,
        Closed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IncidentSeverityEnum {
    High,
    Medium,
    Low,
    Informational,
}
pub type Label = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct McasDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<McasDataConnectorProperties>,
}
impl McasDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct McasDataConnectorDataTypes {
    #[serde(flatten)]
    pub alerts_data_type_of_data_connector: AlertsDataTypeOfDataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub alerts: Option<DataConnectorDataTypeCommon>,
    #[serde(rename = "discoveryLogs", default, skip_serializing_if = "Option::is_none")]
    pub discovery_logs: Option<DataConnectorDataTypeCommon>,
}
impl McasDataConnectorDataTypes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct McasDataConnectorProperties {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<McasDataConnectorDataTypes>,
}
impl McasDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MdatpDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MdatpDataConnectorProperties>,
}
impl MdatpDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MdatpDataConnectorProperties {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<AlertsDataTypeOfDataConnector>,
}
impl MdatpDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MicrosoftSecurityIncidentCreationAlertRuleProperties>,
}
impl MicrosoftSecurityIncidentCreationAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleCommonProperties {
    #[serde(rename = "displayNamesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_filter: Vec<String>,
    #[serde(rename = "displayNamesExcludeFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_exclude_filter: Vec<String>,
    #[serde(rename = "productFilter")]
    pub product_filter: MicrosoftSecurityProductName,
    #[serde(rename = "severitiesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub severities_filter: Vec<AlertSeverity>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleCommonProperties {
    pub fn new(product_filter: MicrosoftSecurityProductName) -> Self {
        Self {
            display_names_filter: Vec::new(),
            display_names_exclude_filter: Vec::new(),
            product_filter,
            severities_filter: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleProperties {
    #[serde(flatten)]
    pub microsoft_security_incident_creation_alert_rule_common_properties: MicrosoftSecurityIncidentCreationAlertRuleCommonProperties,
    #[serde(rename = "alertRuleTemplateName", default, skip_serializing_if = "Option::is_none")]
    pub alert_rule_template_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleProperties {
    pub fn new(
        microsoft_security_incident_creation_alert_rule_common_properties: MicrosoftSecurityIncidentCreationAlertRuleCommonProperties,
        display_name: String,
        enabled: bool,
    ) -> Self {
        Self {
            microsoft_security_incident_creation_alert_rule_common_properties,
            alert_rule_template_name: None,
            description: None,
            display_name,
            enabled,
            last_modified_utc: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties {
    #[serde(rename = "alertRulesCreatedByTemplateCount", default, skip_serializing_if = "Option::is_none")]
    pub alert_rules_created_by_template_count: Option<i32>,
    #[serde(rename = "createdDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub created_date_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "requiredDataConnectors", default, skip_serializing_if = "Vec::is_empty")]
    pub required_data_connectors: Vec<AlertRuleTemplateDataSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<AlertRuleTemplateStatus>,
    #[serde(rename = "displayNamesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_filter: Vec<String>,
    #[serde(rename = "displayNamesExcludeFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub display_names_exclude_filter: Vec<String>,
    #[serde(rename = "productFilter")]
    pub product_filter: MicrosoftSecurityProductName,
    #[serde(rename = "severitiesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub severities_filter: Vec<AlertSeverity>,
}
impl MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties {
    pub fn new(product_filter: MicrosoftSecurityProductName) -> Self {
        Self {
            alert_rules_created_by_template_count: None,
            created_date_utc: None,
            description: None,
            display_name: None,
            required_data_connectors: Vec::new(),
            status: None,
            display_names_filter: Vec::new(),
            display_names_exclude_filter: Vec::new(),
            product_filter,
            severities_filter: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum MicrosoftSecurityProductName {
    #[serde(rename = "Microsoft Cloud App Security")]
    MicrosoftCloudAppSecurity,
    #[serde(rename = "Azure Security Center")]
    AzureSecurityCenter,
    #[serde(rename = "Azure Advanced Threat Protection")]
    AzureAdvancedThreatProtection,
    #[serde(rename = "Azure Active Directory Identity Protection")]
    AzureActiveDirectoryIdentityProtection,
    #[serde(rename = "Azure Security Center for IoT")]
    AzureSecurityCenterForIoT,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeConsent {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeConsentProperties>,
}
impl OfficeConsent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeConsentList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<OfficeConsent>,
}
impl OfficeConsentList {
    pub fn new(value: Vec<OfficeConsent>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeConsentProperties {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "tenantName", default, skip_serializing_if = "Option::is_none")]
    pub tenant_name: Option<String>,
}
impl OfficeConsentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OfficeDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OfficeDataConnectorProperties>,
}
impl OfficeDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeDataConnectorDataTypes {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exchange: Option<serde_json::Value>,
    #[serde(rename = "sharePoint", default, skip_serializing_if = "Option::is_none")]
    pub share_point: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub teams: Option<serde_json::Value>,
}
impl OfficeDataConnectorDataTypes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OfficeDataConnectorProperties {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<OfficeDataConnectorDataTypes>,
}
impl OfficeDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationsList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    pub value: Vec<Operation>,
}
impl OperationsList {
    pub fn new(value: Vec<Operation>) -> Self {
        Self { next_link: None, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceWithEtag {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ResourceWithEtag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRule {
    #[serde(flatten)]
    pub alert_rule: AlertRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScheduledAlertRuleProperties>,
}
impl ScheduledAlertRule {
    pub fn new(alert_rule: AlertRule) -> Self {
        Self {
            alert_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduledAlertRuleCommonProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[serde(rename = "queryFrequency", default, skip_serializing_if = "Option::is_none")]
    pub query_frequency: Option<String>,
    #[serde(rename = "queryPeriod", default, skip_serializing_if = "Option::is_none")]
    pub query_period: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[serde(rename = "triggerOperator", default, skip_serializing_if = "Option::is_none")]
    pub trigger_operator: Option<AlertRuleTriggerOperator>,
    #[serde(rename = "triggerThreshold", default, skip_serializing_if = "Option::is_none")]
    pub trigger_threshold: Option<i32>,
}
impl ScheduledAlertRuleCommonProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRuleProperties {
    #[serde(flatten)]
    pub scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties,
    #[serde(rename = "alertRuleTemplateName", default, skip_serializing_if = "Option::is_none")]
    pub alert_rule_template_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub enabled: bool,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(rename = "suppressionDuration")]
    pub suppression_duration: String,
    #[serde(rename = "suppressionEnabled")]
    pub suppression_enabled: bool,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl ScheduledAlertRuleProperties {
    pub fn new(display_name: String, enabled: bool, suppression_duration: String, suppression_enabled: bool) -> Self {
        Self {
            scheduled_alert_rule_common_properties: ScheduledAlertRuleCommonProperties::default(),
            alert_rule_template_name: None,
            description: None,
            display_name,
            enabled,
            last_modified_utc: None,
            suppression_duration,
            suppression_enabled,
            tactics: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduledAlertRuleTemplate {
    #[serde(flatten)]
    pub alert_rule_template: AlertRuleTemplate,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScheduledAlertRuleTemplateProperties>,
}
impl ScheduledAlertRuleTemplate {
    pub fn new(alert_rule_template: AlertRuleTemplate) -> Self {
        Self {
            alert_rule_template,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduledAlertRuleTemplateProperties {
    #[serde(rename = "alertRulesCreatedByTemplateCount", default, skip_serializing_if = "Option::is_none")]
    pub alert_rules_created_by_template_count: Option<i32>,
    #[serde(rename = "createdDateUTC", default, skip_serializing_if = "Option::is_none")]
    pub created_date_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "requiredDataConnectors", default, skip_serializing_if = "Vec::is_empty")]
    pub required_data_connectors: Vec<AlertRuleTemplateDataSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<AlertRuleTemplateStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[serde(rename = "queryFrequency", default, skip_serializing_if = "Option::is_none")]
    pub query_frequency: Option<String>,
    #[serde(rename = "queryPeriod", default, skip_serializing_if = "Option::is_none")]
    pub query_period: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<AlertSeverity>,
    #[serde(rename = "triggerOperator", default, skip_serializing_if = "Option::is_none")]
    pub trigger_operator: Option<AlertRuleTriggerOperator>,
    #[serde(rename = "triggerThreshold", default, skip_serializing_if = "Option::is_none")]
    pub trigger_threshold: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tactics: Vec<AttackTactic>,
}
impl ScheduledAlertRuleTemplateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TiDataConnector {
    #[serde(flatten)]
    pub data_connector: DataConnector,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TiDataConnectorProperties>,
}
impl TiDataConnector {
    pub fn new(data_connector: DataConnector) -> Self {
        Self {
            data_connector,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TiDataConnectorDataTypes {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub indicators: Option<serde_json::Value>,
}
impl TiDataConnectorDataTypes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TiDataConnectorProperties {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "tipLookbackPeriod", default, skip_serializing_if = "Option::is_none")]
    pub tip_lookback_period: Option<String>,
    #[serde(rename = "dataTypes", default, skip_serializing_if = "Option::is_none")]
    pub data_types: Option<TiDataConnectorDataTypes>,
}
impl TiDataConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThreatIntelligence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub confidence: Option<f64>,
    #[serde(rename = "providerName", default, skip_serializing_if = "Option::is_none")]
    pub provider_name: Option<String>,
    #[serde(rename = "reportLink", default, skip_serializing_if = "Option::is_none")]
    pub report_link: Option<String>,
    #[serde(rename = "threatDescription", default, skip_serializing_if = "Option::is_none")]
    pub threat_description: Option<String>,
    #[serde(rename = "threatName", default, skip_serializing_if = "Option::is_none")]
    pub threat_name: Option<String>,
    #[serde(rename = "threatType", default, skip_serializing_if = "Option::is_none")]
    pub threat_type: Option<String>,
}
impl ThreatIntelligence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "objectId")]
    pub object_id: String,
}
impl UserInfo {
    pub fn new(object_id: String) -> Self {
        Self {
            email: None,
            name: None,
            object_id,
        }
    }
}
