#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Security alert"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alert {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "describes security alert properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertProperties>,
}
impl Alert {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Changing set of properties depending on the entity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertEntity {
    #[doc = "Type of entity"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl AlertEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Links related to the alert"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertExtendedLinks {}
impl AlertExtendedLinks {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Custom properties for the alert."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertExtendedProperties {}
impl AlertExtendedProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of security alerts"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertList {
    #[doc = "describes security alert properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Alert>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes security alert properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertProperties {
    #[doc = "Unique identifier for the detection logic (all alert instances from the same detection logic will have the same alertType)."]
    #[serde(rename = "alertType", default, skip_serializing_if = "Option::is_none")]
    pub alert_type: Option<String>,
    #[doc = "Unique identifier for the alert."]
    #[serde(rename = "systemAlertId", default, skip_serializing_if = "Option::is_none")]
    pub system_alert_id: Option<String>,
    #[doc = "The name of Azure Security Center pricing tier which powering this alert. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-pricing"]
    #[serde(rename = "productComponentName", default, skip_serializing_if = "Option::is_none")]
    pub product_component_name: Option<String>,
    #[doc = "The display name of the alert."]
    #[serde(rename = "alertDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub alert_display_name: Option<String>,
    #[doc = "Description of the suspicious activity that was detected."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The risk level of the threat that was detected. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<alert_properties::Severity>,
    #[doc = "The kill chain related intent behind the alert. For list of supported values, and explanations of Azure Security Center's supported kill chain intents."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub intent: Option<alert_properties::Intent>,
    #[doc = "The UTC time of the first event or activity included in the alert in ISO8601 format."]
    #[serde(rename = "startTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub start_time_utc: Option<String>,
    #[doc = "The UTC time of the last event or activity included in the alert in ISO8601 format."]
    #[serde(rename = "endTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub end_time_utc: Option<String>,
    #[doc = "The resource identifiers that can be used to direct the alert to the right product exposure group (tenant, workspace, subscription etc.). There can be multiple identifiers of different type per alert."]
    #[serde(rename = "resourceIdentifiers", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_identifiers: Vec<ResourceIdentifier>,
    #[doc = "Manual action items to take to remediate the alert."]
    #[serde(rename = "remediationSteps", default, skip_serializing_if = "Vec::is_empty")]
    pub remediation_steps: Vec<String>,
    #[doc = "The name of the vendor that raises the alert."]
    #[serde(rename = "vendorName", default, skip_serializing_if = "Option::is_none")]
    pub vendor_name: Option<String>,
    #[doc = "The life cycle status of the alert."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<alert_properties::Status>,
    #[doc = "Links related to the alert"]
    #[serde(rename = "extendedLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub extended_links: Vec<AlertExtendedLinks>,
    #[doc = "A direct link to the alert page in Azure Portal."]
    #[serde(rename = "alertUri", default, skip_serializing_if = "Option::is_none")]
    pub alert_uri: Option<String>,
    #[doc = "The UTC time the alert was generated in ISO8601 format."]
    #[serde(rename = "timeGeneratedUtc", default, skip_serializing_if = "Option::is_none")]
    pub time_generated_utc: Option<String>,
    #[doc = "The name of the product which published this alert (Azure Security Center, Azure ATP, Microsoft Defender ATP, O365 ATP, MCAS, and so on)."]
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[doc = "The UTC processing end time of the alert in ISO8601 format."]
    #[serde(rename = "processingEndTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub processing_end_time_utc: Option<String>,
    #[doc = "A list of entities related to the alert."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub entities: Vec<AlertEntity>,
    #[doc = "This field determines whether the alert is an incident (a compound grouping of several alerts) or a single alert."]
    #[serde(rename = "isIncident", default, skip_serializing_if = "Option::is_none")]
    pub is_incident: Option<bool>,
    #[doc = "Key for corelating related alerts. Alerts with the same correlation key considered to be related."]
    #[serde(rename = "correlationKey", default, skip_serializing_if = "Option::is_none")]
    pub correlation_key: Option<String>,
    #[doc = "Custom properties for the alert."]
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<AlertExtendedProperties>,
    #[doc = "The display name of the resource most related to this alert."]
    #[serde(rename = "compromisedEntity", default, skip_serializing_if = "Option::is_none")]
    pub compromised_entity: Option<String>,
}
impl AlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_properties {
    use super::*;
    #[doc = "The risk level of the threat that was detected. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Informational,
        Low,
        Medium,
        High,
    }
    #[doc = "The kill chain related intent behind the alert. For list of supported values, and explanations of Azure Security Center's supported kill chain intents."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Intent {
        Unknown,
        PreAttack,
        InitialAccess,
        Persistence,
        PrivilegeEscalation,
        DefenseEvasion,
        CredentialAccess,
        Discovery,
        LateralMovement,
        Execution,
        Collection,
        Exfiltration,
        CommandAndControl,
        Impact,
        Probing,
        Exploitation,
    }
    #[doc = "The life cycle status of the alert."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Active,
        Resolved,
        Dismissed,
    }
}
#[doc = "Simulate alerts according to this bundles."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertSimulatorBundlesRequestProperties {
    #[serde(flatten)]
    pub alert_simulator_request_properties: AlertSimulatorRequestProperties,
    #[doc = "Bundles list."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub bundles: Vec<BundleType>,
}
impl AlertSimulatorBundlesRequestProperties {
    pub fn new(alert_simulator_request_properties: AlertSimulatorRequestProperties) -> Self {
        Self {
            alert_simulator_request_properties,
            bundles: Vec::new(),
        }
    }
}
#[doc = "Alert Simulator request body."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertSimulatorRequestBody {
    #[doc = "Describes properties of an alert simulation request"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertSimulatorRequestProperties>,
}
impl AlertSimulatorRequestBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes properties of an alert simulation request"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertSimulatorRequestProperties {
    #[doc = "The kind of alert simulation."]
    pub kind: alert_simulator_request_properties::Kind,
}
impl AlertSimulatorRequestProperties {
    pub fn new(kind: alert_simulator_request_properties::Kind) -> Self {
        Self { kind }
    }
}
pub mod alert_simulator_request_properties {
    use super::*;
    #[doc = "The kind of alert simulation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Bundles,
    }
}
#[doc = "Azure resource identifier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceIdentifier {
    #[serde(flatten)]
    pub resource_identifier: ResourceIdentifier,
    #[doc = "ARM resource identifier for the cloud resource being alerted on"]
    #[serde(rename = "azureResourceId", default, skip_serializing_if = "Option::is_none")]
    pub azure_resource_id: Option<String>,
}
impl AzureResourceIdentifier {
    pub fn new(resource_identifier: ResourceIdentifier) -> Self {
        Self {
            resource_identifier,
            azure_resource_id: None,
        }
    }
}
#[doc = "Alert Simulator supported bundles."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum BundleType {
    AppServices,
    #[serde(rename = "DNS")]
    Dns,
    KeyVaults,
    KubernetesService,
    ResourceManager,
    SqlServers,
    StorageAccounts,
    VirtualMachines,
}
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "The error detail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The error detail."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a Log Analytics workspace scope identifier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogAnalyticsIdentifier {
    #[serde(flatten)]
    pub resource_identifier: ResourceIdentifier,
    #[doc = "The LogAnalytics workspace id that stores this alert."]
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[doc = "The azure subscription id for the LogAnalytics workspace storing this alert."]
    #[serde(rename = "workspaceSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_subscription_id: Option<String>,
    #[doc = "The azure resource group for the LogAnalytics workspace storing this alert"]
    #[serde(rename = "workspaceResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub workspace_resource_group: Option<String>,
    #[doc = "(optional) The LogAnalytics agent id reporting the event that this alert is based on."]
    #[serde(rename = "agentId", default, skip_serializing_if = "Option::is_none")]
    pub agent_id: Option<String>,
}
impl LogAnalyticsIdentifier {
    pub fn new(resource_identifier: ResourceIdentifier) -> Self {
        Self {
            resource_identifier,
            workspace_id: None,
            workspace_subscription_id: None,
            workspace_resource_group: None,
            agent_id: None,
        }
    }
}
#[doc = "Describes an Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A resource identifier for an alert which can be used to direct the alert to the right product exposure group (tenant, workspace, subscription etc.)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceIdentifier {
    #[doc = "There can be multiple identifiers of different type per alert, this field specify the identifier type."]
    #[serde(rename = "type")]
    pub type_: resource_identifier::Type,
}
impl ResourceIdentifier {
    pub fn new(type_: resource_identifier::Type) -> Self {
        Self { type_ }
    }
}
pub mod resource_identifier {
    use super::*;
    #[doc = "There can be multiple identifiers of different type per alert, this field specify the identifier type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        AzureResource,
        LogAnalytics,
    }
}
