#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Describes an Azure resource with kind"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadConnectivityState {
    #[serde(rename = "connectivityState", default, skip_serializing_if = "Option::is_none")]
    pub connectivity_state: Option<aad_connectivity_state::ConnectivityState>,
}
impl AadConnectivityState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod aad_connectivity_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectivityState {
        Discovered,
        NotLicensed,
        Connected,
    }
}
#[doc = "Represents an AAD identity protection solution which sends logs to an OMS workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadExternalSecuritySolution {
    #[serde(flatten)]
    pub external_security_solution: ExternalSecuritySolution,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AadSolutionProperties>,
}
impl AadExternalSecuritySolution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadSolutionProperties {
    #[serde(flatten)]
    pub external_security_solution_properties: ExternalSecuritySolutionProperties,
    #[serde(flatten)]
    pub aad_connectivity_state: AadConnectivityState,
}
impl AadSolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource whose properties describes the Adaptive Network Hardening settings for some Azure resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveNetworkHardening {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Adaptive Network Hardening resource properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdaptiveNetworkHardeningProperties>,
}
impl AdaptiveNetworkHardening {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdaptiveNetworkHardeningEnforceRequest {
    #[doc = "The rules to enforce"]
    pub rules: Vec<Rule>,
    #[doc = "The Azure resource IDs of the effective network security groups that will be updated with the created security rules from the Adaptive Network Hardening rules"]
    #[serde(rename = "networkSecurityGroups")]
    pub network_security_groups: Vec<String>,
}
impl AdaptiveNetworkHardeningEnforceRequest {
    pub fn new(rules: Vec<Rule>, network_security_groups: Vec<String>) -> Self {
        Self {
            rules,
            network_security_groups,
        }
    }
}
#[doc = "Adaptive Network Hardening resource properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveNetworkHardeningProperties {
    #[doc = "The security rules which are recommended to be effective on the VM"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<Rule>,
    #[doc = "The UTC time on which the rules were calculated"]
    #[serde(rename = "rulesCalculationTime", default, skip_serializing_if = "Option::is_none")]
    pub rules_calculation_time: Option<String>,
    #[doc = "The Network Security Groups effective on the network interfaces of the protected resource"]
    #[serde(rename = "effectiveNetworkSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_network_security_groups: Vec<EffectiveNetworkSecurityGroups>,
}
impl AdaptiveNetworkHardeningProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListAdaptiveNetworkHardenings API service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveNetworkHardeningsList {
    #[doc = "A list of Adaptive Network Hardenings resources"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AdaptiveNetworkHardening>,
    #[doc = "The URL to get the next set of results"]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AdaptiveNetworkHardeningsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security alert"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alert {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "describes security alert properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertProperties>,
}
impl Alert {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Factors that increase our confidence that the alert is a true positive"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertConfidenceReason {
    #[doc = "Type of confidence factor"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "description of the confidence reason"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
}
impl AlertConfidenceReason {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Changing set of properties depending on the entity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertEntity {
    #[doc = "Type of entity"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl AlertEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Changing set of properties depending on the alert type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertExtendedProperties {}
impl AlertExtendedProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of security alerts"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Alert>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes security alert properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertProperties {
    #[doc = "State of the alert (Active, Dismissed etc.)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The time the incident was reported to Microsoft.Security in UTC"]
    #[serde(rename = "reportedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub reported_time_utc: Option<String>,
    #[doc = "Name of the vendor that discovered the incident"]
    #[serde(rename = "vendorName", default, skip_serializing_if = "Option::is_none")]
    pub vendor_name: Option<String>,
    #[doc = "Name of the alert type"]
    #[serde(rename = "alertName", default, skip_serializing_if = "Option::is_none")]
    pub alert_name: Option<String>,
    #[doc = "Display name of the alert type"]
    #[serde(rename = "alertDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub alert_display_name: Option<String>,
    #[doc = "The time the incident was detected by the vendor"]
    #[serde(rename = "detectedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub detected_time_utc: Option<String>,
    #[doc = "Description of the incident and what it means"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Recommended steps to reradiate the incident"]
    #[serde(rename = "remediationSteps", default, skip_serializing_if = "Option::is_none")]
    pub remediation_steps: Option<String>,
    #[doc = "The action that was taken as a response to the alert (Active, Blocked etc.)"]
    #[serde(rename = "actionTaken", default, skip_serializing_if = "Option::is_none")]
    pub action_taken: Option<String>,
    #[doc = "Estimated severity of this alert"]
    #[serde(rename = "reportedSeverity", default, skip_serializing_if = "Option::is_none")]
    pub reported_severity: Option<alert_properties::ReportedSeverity>,
    #[doc = "The entity that the incident happened on"]
    #[serde(rename = "compromisedEntity", default, skip_serializing_if = "Option::is_none")]
    pub compromised_entity: Option<String>,
    #[doc = "Azure resource ID of the associated resource"]
    #[serde(rename = "associatedResource", default, skip_serializing_if = "Option::is_none")]
    pub associated_resource: Option<String>,
    #[doc = "Changing set of properties depending on the alert type."]
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<AlertExtendedProperties>,
    #[doc = "The type of the alerted resource (Azure, Non-Azure)"]
    #[serde(rename = "systemSource", default, skip_serializing_if = "Option::is_none")]
    pub system_source: Option<String>,
    #[doc = "Whether this alert can be investigated with Azure Security Center"]
    #[serde(rename = "canBeInvestigated", default, skip_serializing_if = "Option::is_none")]
    pub can_be_investigated: Option<bool>,
    #[doc = "Whether this alert is for incident type or not (otherwise - single alert)"]
    #[serde(rename = "isIncident", default, skip_serializing_if = "Option::is_none")]
    pub is_incident: Option<bool>,
    #[doc = "objects that are related to this alerts"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub entities: Vec<AlertEntity>,
    #[doc = "level of confidence we have on the alert"]
    #[serde(rename = "confidenceScore", default, skip_serializing_if = "Option::is_none")]
    pub confidence_score: Option<f32>,
    #[doc = "reasons the alert got the confidenceScore value"]
    #[serde(rename = "confidenceReasons", default, skip_serializing_if = "Vec::is_empty")]
    pub confidence_reasons: Vec<AlertConfidenceReason>,
    #[doc = "Azure subscription ID of the resource that had the security alert or the subscription ID of the workspace that this resource reports to"]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "Instance ID of the alert."]
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[doc = "Azure resource ID of the workspace that the alert was reported to."]
    #[serde(rename = "workspaceArmId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_arm_id: Option<String>,
    #[doc = "Alerts with the same CorrelationKey will be grouped together in Ibiza."]
    #[serde(rename = "correlationKey", default, skip_serializing_if = "Option::is_none")]
    pub correlation_key: Option<String>,
}
impl AlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_properties {
    use super::*;
    #[doc = "Estimated severity of this alert"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReportedSeverity {
        Silent,
        Information,
        Low,
        High,
    }
}
#[doc = "List of all possible traffic between Azure resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AllowedConnectionsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AllowedConnectionsResource>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AllowedConnectionsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource whose properties describes the allowed traffic between Azure resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AllowedConnectionsResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    #[doc = "Describes the allowed traffic between Azure resources"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AllowedConnectionsResourceProperties>,
}
impl AllowedConnectionsResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the allowed traffic between Azure resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AllowedConnectionsResourceProperties {
    #[doc = "The UTC time on which the allowed connections resource was calculated"]
    #[serde(rename = "calculatedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub calculated_date_time: Option<String>,
    #[doc = "List of connectable resources"]
    #[serde(rename = "connectableResources", default, skip_serializing_if = "Vec::is_empty")]
    pub connectable_resources: Vec<ConnectableResource>,
}
impl AllowedConnectionsResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppWhitelistingGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    #[doc = "Represents a VM/server group and set of rules that are Recommended by Azure Security Center to be allowed"]
    pub properties: AppWhitelistingGroupData,
}
impl AppWhitelistingGroup {
    pub fn new(properties: AppWhitelistingGroupData) -> Self {
        Self {
            resource: Resource::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[doc = "Represents a VM/server group and set of rules that are Recommended by Azure Security Center to be allowed"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppWhitelistingGroupData {
    #[doc = "The application control policy enforcement/protection mode of the VM/server group"]
    #[serde(rename = "enforcementMode", default, skip_serializing_if = "Option::is_none")]
    pub enforcement_mode: Option<EnforcementMode>,
    #[doc = "The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux."]
    #[serde(rename = "protectionMode", default, skip_serializing_if = "Option::is_none")]
    pub protection_mode: Option<ProtectionMode>,
    #[doc = "The configuration status of the VM/server group or machine or rule on the machine"]
    #[serde(rename = "configurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub configuration_status: Option<ConfigurationStatus>,
    #[doc = "The recommendation status of the VM/server group or VM/server"]
    #[serde(rename = "recommendationStatus", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_status: Option<RecommendationStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub issues: Option<AppWhitelistingIssuesSummaries>,
    #[doc = "The source type of the VM/server group"]
    #[serde(rename = "sourceSystem", default, skip_serializing_if = "Option::is_none")]
    pub source_system: Option<SourceSystem>,
    #[serde(rename = "vmRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub vm_recommendations: Option<VmRecommendations>,
    #[serde(rename = "pathRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub path_recommendations: Option<PathRecommendations>,
}
impl AppWhitelistingGroupData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a list of VM/server groups and set of rules that are Recommended by Azure Security Center to be allowed"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppWhitelistingGroups {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AppWhitelistingGroup>,
}
impl AppWhitelistingGroups {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An alert that VMs/servers within a group can have"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AppWhitelistingIssue {
    ViolationsAudited,
    ViolationsBlocked,
    MsiAndScriptViolationsAudited,
    MsiAndScriptViolationsBlocked,
    ExecutableViolationsAudited,
    RulesViolatedManually,
}
#[doc = "Represents a summary of the alerts of the VM/server group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppWhitelistingIssueSummary {
    #[doc = "An alert that VMs/servers within a group can have"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub issue: Option<AppWhitelistingIssue>,
    #[doc = "The number of machines in the VM/server group that have this alert"]
    #[serde(rename = "numberOfVms", default, skip_serializing_if = "Option::is_none")]
    pub number_of_vms: Option<f64>,
}
impl AppWhitelistingIssueSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type AppWhitelistingIssuesSummaries = Vec<AppWhitelistingIssueSummary>;
#[doc = "The altered data of the recommended VM/server group policy"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppWhitelistingPutGroupData {
    #[doc = "The application control policy enforcement/protection mode of the VM/server group"]
    #[serde(rename = "enforcementMode", default, skip_serializing_if = "Option::is_none")]
    pub enforcement_mode: Option<EnforcementMode>,
    #[doc = "The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux."]
    #[serde(rename = "protectionMode", default, skip_serializing_if = "Option::is_none")]
    pub protection_mode: Option<ProtectionMode>,
    #[serde(rename = "vmRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub vm_recommendations: Option<VmRecommendations>,
    #[serde(rename = "pathRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub path_recommendations: Option<PathRecommendations>,
}
impl AppWhitelistingPutGroupData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type AppWhitelistingResourceType = String;
#[doc = "The ASC location of the subscription is in the \"name\" field"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscLocation {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "An empty set of properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AscLocationProperties>,
}
impl AscLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of locations where ASC saves your data"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscLocationList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AscLocation>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AscLocationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An empty set of properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscLocationProperties {}
impl AscLocationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents an ATA security solution which sends logs to an OMS workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AtaExternalSecuritySolution {
    #[serde(flatten)]
    pub external_security_solution: ExternalSecuritySolution,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AtaSolutionProperties>,
}
impl AtaExternalSecuritySolution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AtaSolutionProperties {
    #[serde(flatten)]
    pub external_security_solution_properties: ExternalSecuritySolutionProperties,
    #[serde(rename = "lastEventReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_event_received: Option<String>,
}
impl AtaSolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a security solution which sends CEF logs to an OMS workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CefExternalSecuritySolution {
    #[serde(flatten)]
    pub external_security_solution: ExternalSecuritySolution,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CefSolutionProperties>,
}
impl CefExternalSecuritySolution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CefSolutionProperties {
    #[serde(flatten)]
    pub external_security_solution_properties: ExternalSecuritySolutionProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub agent: Option<String>,
    #[serde(rename = "lastEventReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_event_received: Option<String>,
}
impl CefSolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "The error detail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The error detail."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The configuration status of the VM/server group or machine or rule on the machine"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConfigurationStatus {
    Configured,
    NotConfigured,
    InProgress,
    Failed,
    NoStatus,
}
#[doc = "Describes the allowed inbound and outbound traffic of an Azure resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectableResource {
    #[doc = "The Azure resource id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The list of Azure resources that the resource has inbound allowed connection from"]
    #[serde(rename = "inboundConnectedResources", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_connected_resources: Vec<ConnectedResource>,
    #[doc = "The list of Azure resources that the resource has outbound allowed connection to"]
    #[serde(rename = "outboundConnectedResources", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_connected_resources: Vec<ConnectedResource>,
}
impl ConnectableResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes properties of a connected resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectedResource {
    #[doc = "The Azure resource id of the connected resource"]
    #[serde(rename = "connectedResourceId", default, skip_serializing_if = "Option::is_none")]
    pub connected_resource_id: Option<String>,
    #[doc = "The allowed tcp ports"]
    #[serde(rename = "tcpPorts", default, skip_serializing_if = "Option::is_none")]
    pub tcp_ports: Option<String>,
    #[doc = "The allowed udp ports"]
    #[serde(rename = "udpPorts", default, skip_serializing_if = "Option::is_none")]
    pub udp_ports: Option<String>,
}
impl ConnectedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectedWorkspace {
    #[doc = "Azure resource ID of the connected OMS workspace"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ConnectedWorkspace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiscoveredSecuritySolution {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    pub properties: DiscoveredSecuritySolutionProperties,
}
impl DiscoveredSecuritySolution {
    pub fn new(properties: DiscoveredSecuritySolutionProperties) -> Self {
        Self {
            resource: Resource::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiscoveredSecuritySolutionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DiscoveredSecuritySolution>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiscoveredSecuritySolutionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiscoveredSecuritySolutionProperties {
    #[doc = "The security family of the discovered solution"]
    #[serde(rename = "securityFamily")]
    pub security_family: discovered_security_solution_properties::SecurityFamily,
    #[doc = "The security solutions' image offer"]
    pub offer: String,
    #[doc = "The security solutions' image publisher"]
    pub publisher: String,
    #[doc = "The security solutions' image sku"]
    pub sku: String,
}
impl DiscoveredSecuritySolutionProperties {
    pub fn new(
        security_family: discovered_security_solution_properties::SecurityFamily,
        offer: String,
        publisher: String,
        sku: String,
    ) -> Self {
        Self {
            security_family,
            offer,
            publisher,
            sku,
        }
    }
}
pub mod discovered_security_solution_properties {
    use super::*;
    #[doc = "The security family of the discovered solution"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SecurityFamily {
        Waf,
        Ngfw,
        SaasWaf,
        Va,
    }
}
#[doc = "Describes the Network Security Groups effective on a network interface"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroups {
    #[doc = "The Azure resource ID of the network interface"]
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<String>,
    #[doc = "The Network Security Groups effective on the network interface"]
    #[serde(rename = "networkSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub network_security_groups: Vec<String>,
}
impl EffectiveNetworkSecurityGroups {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The application control policy enforcement/protection mode of the VM/server group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EnforcementMode {
    Audit,
    Enforce,
    None,
}
#[doc = "The VM/server supportability of Enforce feature"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EnforcementSupport {
    Supported,
    NotSupported,
    Unknown,
}
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a security solution external to Azure Security Center which sends information to an OMS workspace and whose data is displayed by Azure Security Center."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolution {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub external_security_solution_kind: ExternalSecuritySolutionKind,
    #[serde(flatten)]
    pub location: Location,
}
impl ExternalSecuritySolution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes an Azure resource with kind"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolutionKind {
    #[doc = "The kind of the external solution"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<external_security_solution_kind::Kind>,
}
impl ExternalSecuritySolutionKind {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod external_security_solution_kind {
    use super::*;
    #[doc = "The kind of the external solution"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "CEF")]
        Cef,
        #[serde(rename = "ATA")]
        Ata,
        #[serde(rename = "AAD")]
        Aad,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolutionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExternalSecuritySolution>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExternalSecuritySolutionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The solution properties (correspond to the solution kind)"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolutionProperties {
    #[serde(rename = "deviceVendor", default, skip_serializing_if = "Option::is_none")]
    pub device_vendor: Option<String>,
    #[serde(rename = "deviceType", default, skip_serializing_if = "Option::is_none")]
    pub device_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub workspace: Option<ConnectedWorkspace>,
}
impl ExternalSecuritySolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The type of the file (for Linux files - Executable is used)"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FileType {
    Exe,
    Dll,
    Msi,
    Script,
    Executable,
    Unknown,
}
pub type GroupResourceId = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JitNetworkAccessPoliciesList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JitNetworkAccessPolicy>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JitNetworkAccessPoliciesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub kind: Kind,
    #[serde(flatten)]
    pub location: Location,
    pub properties: JitNetworkAccessPolicyProperties,
}
impl JitNetworkAccessPolicy {
    pub fn new(properties: JitNetworkAccessPolicyProperties) -> Self {
        Self {
            resource: Resource::default(),
            kind: Kind::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyInitiatePort {
    pub number: PortNumber,
    #[doc = "Source of the allowed traffic. If omitted, the request will be for the source IP address of the initiate request."]
    #[serde(rename = "allowedSourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub allowed_source_address_prefix: Option<String>,
    #[doc = "The time to close the request in UTC"]
    #[serde(rename = "endTimeUtc")]
    pub end_time_utc: String,
}
impl JitNetworkAccessPolicyInitiatePort {
    pub fn new(number: PortNumber, end_time_utc: String) -> Self {
        Self {
            number,
            allowed_source_address_prefix: None,
            end_time_utc,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyInitiateRequest {
    #[doc = "A list of virtual machines & ports to open access for"]
    #[serde(rename = "virtualMachines")]
    pub virtual_machines: Vec<JitNetworkAccessPolicyInitiateVirtualMachine>,
    #[doc = "The justification for making the initiate request"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub justification: Option<String>,
}
impl JitNetworkAccessPolicyInitiateRequest {
    pub fn new(virtual_machines: Vec<JitNetworkAccessPolicyInitiateVirtualMachine>) -> Self {
        Self {
            virtual_machines,
            justification: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyInitiateVirtualMachine {
    #[doc = "Resource ID of the virtual machine that is linked to this policy"]
    pub id: String,
    #[doc = "The ports to open for the resource with the `id`"]
    pub ports: Vec<JitNetworkAccessPolicyInitiatePort>,
}
impl JitNetworkAccessPolicyInitiateVirtualMachine {
    pub fn new(id: String, ports: Vec<JitNetworkAccessPolicyInitiatePort>) -> Self {
        Self { id, ports }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyProperties {
    #[doc = "Configurations for Microsoft.Compute/virtualMachines resource type."]
    #[serde(rename = "virtualMachines")]
    pub virtual_machines: Vec<JitNetworkAccessPolicyVirtualMachine>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub requests: Vec<JitNetworkAccessRequest>,
    #[doc = "Gets the provisioning state of the Just-in-Time policy."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl JitNetworkAccessPolicyProperties {
    pub fn new(virtual_machines: Vec<JitNetworkAccessPolicyVirtualMachine>) -> Self {
        Self {
            virtual_machines,
            requests: Vec::new(),
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyVirtualMachine {
    #[doc = "Resource ID of the virtual machine that is linked to this policy"]
    pub id: String,
    #[doc = "Port configurations for the virtual machine"]
    pub ports: Vec<JitNetworkAccessPortRule>,
    #[doc = "Public IP address of the Azure Firewall that is linked to this policy, if applicable"]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
}
impl JitNetworkAccessPolicyVirtualMachine {
    pub fn new(id: String, ports: Vec<JitNetworkAccessPortRule>) -> Self {
        Self {
            id,
            ports,
            public_ip_address: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPortRule {
    pub number: PortNumber,
    pub protocol: jit_network_access_port_rule::Protocol,
    #[doc = "Mutually exclusive with the \"allowedSourceAddressPrefixes\" parameter. Should be an IP address or CIDR, for example \"192.168.0.3\" or \"192.168.0.0/16\"."]
    #[serde(rename = "allowedSourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub allowed_source_address_prefix: Option<String>,
    #[doc = "Mutually exclusive with the \"allowedSourceAddressPrefix\" parameter."]
    #[serde(rename = "allowedSourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_source_address_prefixes: Vec<String>,
    #[doc = "Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day"]
    #[serde(rename = "maxRequestAccessDuration")]
    pub max_request_access_duration: String,
}
impl JitNetworkAccessPortRule {
    pub fn new(number: PortNumber, protocol: jit_network_access_port_rule::Protocol, max_request_access_duration: String) -> Self {
        Self {
            number,
            protocol,
            allowed_source_address_prefix: None,
            allowed_source_address_prefixes: Vec::new(),
            max_request_access_duration,
        }
    }
}
pub mod jit_network_access_port_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
        #[serde(rename = "*")]
        U2a,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessRequest {
    #[serde(rename = "virtualMachines")]
    pub virtual_machines: Vec<JitNetworkAccessRequestVirtualMachine>,
    #[doc = "The start time of the request in UTC"]
    #[serde(rename = "startTimeUtc")]
    pub start_time_utc: String,
    #[doc = "The identity of the person who made the request"]
    pub requestor: String,
    #[doc = "The justification for making the initiate request"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub justification: Option<String>,
}
impl JitNetworkAccessRequest {
    pub fn new(virtual_machines: Vec<JitNetworkAccessRequestVirtualMachine>, start_time_utc: String, requestor: String) -> Self {
        Self {
            virtual_machines,
            start_time_utc,
            requestor,
            justification: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessRequestPort {
    pub number: PortNumber,
    #[doc = "Mutually exclusive with the \"allowedSourceAddressPrefixes\" parameter. Should be an IP address or CIDR, for example \"192.168.0.3\" or \"192.168.0.0/16\"."]
    #[serde(rename = "allowedSourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub allowed_source_address_prefix: Option<String>,
    #[doc = "Mutually exclusive with the \"allowedSourceAddressPrefix\" parameter."]
    #[serde(rename = "allowedSourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_source_address_prefixes: Vec<String>,
    #[doc = "The date & time at which the request ends in UTC"]
    #[serde(rename = "endTimeUtc")]
    pub end_time_utc: String,
    #[doc = "The status of the port"]
    pub status: jit_network_access_request_port::Status,
    #[doc = "A description of why the `status` has its value"]
    #[serde(rename = "statusReason")]
    pub status_reason: jit_network_access_request_port::StatusReason,
    #[doc = "The port which is mapped to this port's `number` in the Azure Firewall, if applicable"]
    #[serde(rename = "mappedPort", default, skip_serializing_if = "Option::is_none")]
    pub mapped_port: Option<i64>,
}
impl JitNetworkAccessRequestPort {
    pub fn new(
        number: PortNumber,
        end_time_utc: String,
        status: jit_network_access_request_port::Status,
        status_reason: jit_network_access_request_port::StatusReason,
    ) -> Self {
        Self {
            number,
            allowed_source_address_prefix: None,
            allowed_source_address_prefixes: Vec::new(),
            end_time_utc,
            status,
            status_reason,
            mapped_port: None,
        }
    }
}
pub mod jit_network_access_request_port {
    use super::*;
    #[doc = "The status of the port"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Revoked,
        Initiated,
    }
    #[doc = "A description of why the `status` has its value"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StatusReason {
        Expired,
        UserRequested,
        NewerRequestInitiated,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessRequestVirtualMachine {
    #[doc = "Resource ID of the virtual machine that is linked to this policy"]
    pub id: String,
    #[doc = "The ports that were opened for the virtual machine"]
    pub ports: Vec<JitNetworkAccessRequestPort>,
}
impl JitNetworkAccessRequestVirtualMachine {
    pub fn new(id: String, ports: Vec<JitNetworkAccessRequestPort>) -> Self {
        Self { id, ports }
    }
}
#[doc = "Describes an Azure resource with kind"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Kind {
    #[doc = "Kind of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl Kind {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes an Azure resource with location"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Location {
    #[doc = "Location where the resource is stored"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl Location {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Possible operation in the REST API of Microsoft.Security"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Name of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Where the operation is originated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[doc = "Security operation display"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationDisplay>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security operation display"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDisplay {
    #[doc = "The resource provider for the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "The display name of the resource the operation applies to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[doc = "The display name of the security operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "The description of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of possible operations for Microsoft.Security resource provider"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationList {
    #[doc = "List of Security operations"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a path that is recommended to be allowed and its properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PathRecommendation {
    #[doc = "The full path to whitelist"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "The recommendation action of the VM/server or rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<RecommendationAction>,
    #[doc = "The type of the rule to be allowed"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<RecommendationType>,
    #[doc = "Represents the publisher information of a process/rule"]
    #[serde(rename = "publisherInfo", default, skip_serializing_if = "Option::is_none")]
    pub publisher_info: Option<PublisherInfo>,
    #[doc = "Whether the path is commonly run on the machine"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub common: Option<bool>,
    #[serde(rename = "userSids", default, skip_serializing_if = "Vec::is_empty")]
    pub user_sids: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub usernames: Vec<UserRecommendation>,
    #[doc = "The type of the file (for Linux files - Executable is used)"]
    #[serde(rename = "fileType", default, skip_serializing_if = "Option::is_none")]
    pub file_type: Option<FileType>,
    #[doc = "The configuration status of the VM/server group or machine or rule on the machine"]
    #[serde(rename = "configurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub configuration_status: Option<ConfigurationStatus>,
}
impl PathRecommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type PathRecommendations = Vec<PathRecommendation>;
pub type PortNumber = i64;
#[doc = "The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionMode {
    #[doc = "The application control policy enforcement/protection mode of the VM/server group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exe: Option<EnforcementMode>,
    #[doc = "The application control policy enforcement/protection mode of the VM/server group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub msi: Option<EnforcementMode>,
    #[doc = "The application control policy enforcement/protection mode of the VM/server group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<EnforcementMode>,
    #[doc = "The application control policy enforcement/protection mode of the VM/server group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub executable: Option<EnforcementMode>,
}
impl ProtectionMode {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the publisher information of a process/rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublisherInfo {
    #[doc = "The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country"]
    #[serde(rename = "publisherName", default, skip_serializing_if = "Option::is_none")]
    pub publisher_name: Option<String>,
    #[doc = "The product name taken from the file's version resource"]
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[doc = "The \"OriginalName\" field taken from the file's version resource"]
    #[serde(rename = "binaryName", default, skip_serializing_if = "Option::is_none")]
    pub binary_name: Option<String>,
    #[doc = "The binary file version taken from the file's version resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl PublisherInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The recommendation action of the VM/server or rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecommendationAction {
    Recommended,
    Add,
    Remove,
}
#[doc = "The recommendation status of the VM/server group or VM/server"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecommendationStatus {
    Recommended,
    NotRecommended,
    NotAvailable,
    NoStatus,
}
#[doc = "The type of the rule to be allowed"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecommendationType {
    File,
    FileHash,
    PublisherSignature,
    ProductSignature,
    BinarySignature,
    VersionAndAboveSignature,
}
#[doc = "Describes an Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes remote addresses that is recommended to communicate with the Azure resource on some (Protocol, Port, Direction). All other remote addresses are recommended to be blocked"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Rule {
    #[doc = "The name of the rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The rule's direction"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<rule::Direction>,
    #[serde(rename = "destinationPort", default, skip_serializing_if = "Option::is_none")]
    pub destination_port: Option<PortNumber>,
    #[doc = "The rule's transport protocols"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<String>,
    #[doc = "The remote IP addresses that should be able to communicate with the Azure resource on the rule's destination port and protocol"]
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
}
impl Rule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod rule {
    use super::*;
    #[doc = "The rule's direction"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[doc = "Security task that we recommend to do in order to strengthen security"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityTask {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes properties of a task."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityTaskProperties>,
}
impl SecurityTask {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of security task recommendations"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityTaskList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityTask>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityTaskList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Changing set of properties, depending on the task type that is derived from the name field"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityTaskParameters {
    #[doc = "Name of the task type"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl SecurityTaskParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes properties of a task."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityTaskProperties {
    #[doc = "State of the task (Active, Resolved etc.)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The time this task was discovered in UTC"]
    #[serde(rename = "creationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub creation_time_utc: Option<String>,
    #[doc = "Changing set of properties, depending on the task type that is derived from the name field"]
    #[serde(rename = "securityTaskParameters", default, skip_serializing_if = "Option::is_none")]
    pub security_task_parameters: Option<SecurityTaskParameters>,
    #[doc = "The time this task's details were last changed in UTC"]
    #[serde(rename = "lastStateChangeTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_state_change_time_utc: Option<String>,
    #[doc = "Additional data on the state of the task"]
    #[serde(rename = "subState", default, skip_serializing_if = "Option::is_none")]
    pub sub_state: Option<String>,
}
impl SecurityTaskProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The source type of the VM/server group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SourceSystem {
    #[serde(rename = "Azure_AppLocker")]
    AzureAppLocker,
    #[serde(rename = "Azure_AuditD")]
    AzureAuditD,
    #[serde(rename = "NonAzure_AppLocker")]
    NonAzureAppLocker,
    #[serde(rename = "NonAzure_AuditD")]
    NonAzureAuditD,
    None,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TopologyResource>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TopologyList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TopologyResourceProperties>,
}
impl TopologyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyResourceProperties {
    #[doc = "The UTC time on which the topology was calculated"]
    #[serde(rename = "calculatedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub calculated_date_time: Option<String>,
    #[doc = "Azure resources which are part of this topology resource"]
    #[serde(rename = "topologyResources", default, skip_serializing_if = "Vec::is_empty")]
    pub topology_resources: Vec<TopologySingleResource>,
}
impl TopologyResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologySingleResource {
    #[doc = "Azure resource id"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "The security severity of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
    #[doc = "Indicates if the resource has security recommendations"]
    #[serde(rename = "recommendationsExist", default, skip_serializing_if = "Option::is_none")]
    pub recommendations_exist: Option<bool>,
    #[doc = "Indicates the resource connectivity level to the Internet (InternetFacing, Internal ,etc.)"]
    #[serde(rename = "networkZones", default, skip_serializing_if = "Option::is_none")]
    pub network_zones: Option<String>,
    #[doc = "Score of the resource based on its security severity"]
    #[serde(rename = "topologyScore", default, skip_serializing_if = "Option::is_none")]
    pub topology_score: Option<i64>,
    #[doc = "The location of this resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Azure resources connected to this resource which are in higher level in the topology view"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parents: Vec<TopologySingleResourceParent>,
    #[doc = "Azure resources connected to this resource which are in lower level in the topology view"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub children: Vec<TopologySingleResourceChild>,
}
impl TopologySingleResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologySingleResourceChild {
    #[doc = "Azure resource id which serves as child resource in topology view"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl TopologySingleResourceChild {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologySingleResourceParent {
    #[doc = "Azure resource id which serves as parent resource in topology view"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl TopologySingleResourceParent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a user that is recommended to be allowed for a certain rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserRecommendation {
    #[doc = "Represents a user that is recommended to be allowed for a certain rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "The recommendation action of the VM/server or rule"]
    #[serde(rename = "recommendationAction", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_action: Option<RecommendationAction>,
}
impl UserRecommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a machine that is part of a VM/server group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmRecommendation {
    #[doc = "The configuration status of the VM/server group or machine or rule on the machine"]
    #[serde(rename = "configurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub configuration_status: Option<ConfigurationStatus>,
    #[doc = "The recommendation action of the VM/server or rule"]
    #[serde(rename = "recommendationAction", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_action: Option<RecommendationAction>,
    #[doc = "The full azure resource id of the machine"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<VmResourceId>,
    #[doc = "The VM/server supportability of Enforce feature"]
    #[serde(rename = "enforcementSupport", default, skip_serializing_if = "Option::is_none")]
    pub enforcement_support: Option<EnforcementSupport>,
}
impl VmRecommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type VmRecommendations = Vec<VmRecommendation>;
pub type VmResourceId = String;
