#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "The error detail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The error detail."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Custom entity store assignment"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomEntityStoreAssignment {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
    #[doc = "describes the custom entity store assignment properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CustomEntityStoreAssignmentProperties>,
}
impl CustomEntityStoreAssignment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes the custom entity store assignment properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomEntityStoreAssignmentProperties {
    #[doc = "The principal assigned with entity store. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub principal: Option<String>,
    #[doc = "The link to entity store database."]
    #[serde(rename = "entityStoreDatabaseLink", default, skip_serializing_if = "Option::is_none")]
    pub entity_store_database_link: Option<String>,
}
impl CustomEntityStoreAssignmentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes the custom entity store assignment request"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomEntityStoreAssignmentRequest {
    #[doc = "describes properties of custom entity store assignment request"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CustomEntityStoreAssignmentRequestProperties>,
}
impl CustomEntityStoreAssignmentRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes properties of custom entity store assignment request"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomEntityStoreAssignmentRequestProperties {
    #[doc = "The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub principal: Option<String>,
}
impl CustomEntityStoreAssignmentRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of custom entity store assignments"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomEntityStoreAssignmentsListResult {
    #[doc = "Collection of custom entity store assignments"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CustomEntityStoreAssignment>,
    #[doc = "The link used to get the next page of operations."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CustomEntityStoreAssignmentsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes an Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Custom Assessment Automation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomAssessmentAutomation {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
    #[doc = "describes the Custom Assessment Automation properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CustomAssessmentAutomationProperties>,
}
impl CustomAssessmentAutomation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes the Custom Assessment Automation properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomAssessmentAutomationProperties {
    #[doc = "GZip encoded KQL query representing the assessment automation results required."]
    #[serde(rename = "compressedQuery", default, skip_serializing_if = "Option::is_none")]
    pub compressed_query: Option<String>,
    #[doc = "Relevant cloud for the custom assessment automation."]
    #[serde(rename = "supportedCloud", default, skip_serializing_if = "Option::is_none")]
    pub supported_cloud: Option<custom_assessment_automation_properties::SupportedCloud>,
    #[doc = "The severity to relate to the assessments generated by this assessment automation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<custom_assessment_automation_properties::Severity>,
    #[doc = "The display name of the assessments generated by this assessment automation."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The description to relate to the assessments generated by this assessment automation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The remediation description to relate to the assessments generated by this assessment automation."]
    #[serde(rename = "remediationDescription", default, skip_serializing_if = "Option::is_none")]
    pub remediation_description: Option<String>,
    #[doc = "The assessment metadata key used when an assessment is generated for this assessment automation."]
    #[serde(rename = "assessmentKey", default, skip_serializing_if = "Option::is_none")]
    pub assessment_key: Option<String>,
}
impl CustomAssessmentAutomationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod custom_assessment_automation_properties {
    use super::*;
    #[doc = "Relevant cloud for the custom assessment automation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SupportedCloud {
        #[serde(rename = "AWS")]
        Aws,
        #[serde(rename = "GCP")]
        Gcp,
    }
    #[doc = "The severity to relate to the assessments generated by this assessment automation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        High,
        Medium,
        Low,
    }
}
#[doc = "Custom Assessment Automation request"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomAssessmentAutomationRequest {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "describes the Custom Assessment Automation properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CustomAssessmentAutomationRequestProperties>,
}
impl CustomAssessmentAutomationRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes the Custom Assessment Automation properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomAssessmentAutomationRequestProperties {
    #[doc = "Base 64 encoded KQL query representing the assessment automation results required."]
    #[serde(rename = "compressedQuery", default, skip_serializing_if = "Option::is_none")]
    pub compressed_query: Option<String>,
    #[doc = "Relevant cloud for the custom assessment automation."]
    #[serde(rename = "supportedCloud", default, skip_serializing_if = "Option::is_none")]
    pub supported_cloud: Option<custom_assessment_automation_request_properties::SupportedCloud>,
    #[doc = "The severity to relate to the assessments generated by this assessment automation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<custom_assessment_automation_request_properties::Severity>,
    #[doc = "The display name of the assessments generated by this assessment automation."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The description to relate to the assessments generated by this assessment automation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The remediation description to relate to the assessments generated by this assessment automation."]
    #[serde(rename = "remediationDescription", default, skip_serializing_if = "Option::is_none")]
    pub remediation_description: Option<String>,
}
impl CustomAssessmentAutomationRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod custom_assessment_automation_request_properties {
    use super::*;
    #[doc = "Relevant cloud for the custom assessment automation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SupportedCloud {
        #[serde(rename = "AWS")]
        Aws,
        #[serde(rename = "GCP")]
        Gcp,
    }
    #[doc = "The severity to relate to the assessments generated by this assessment automation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        High,
        Medium,
        Low,
    }
}
#[doc = "A list of Custom Assessment Automations"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomAssessmentAutomationsListResult {
    #[doc = "Collection of Custom Assessment Automations"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CustomAssessmentAutomation>,
    #[doc = "The link used to get the next page of operations."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CustomAssessmentAutomationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metadata pertaining to creation and last modification of the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[doc = "The identity that created the resource."]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[doc = "The type of identity that created the resource."]
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[doc = "The timestamp of resource creation (UTC)."]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "The identity that last modified the resource."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[doc = "The timestamp of resource last modification (UTC)"]
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[doc = "The type of identity that created the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[doc = "The type of identity that last modified the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
