#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Describes an Azure resource with kind"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadConnectivityState {
    #[serde(rename = "connectivityState", default, skip_serializing_if = "Option::is_none")]
    pub connectivity_state: Option<aad_connectivity_state::ConnectivityState>,
}
impl AadConnectivityState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod aad_connectivity_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectivityState {
        Discovered,
        NotLicensed,
        Connected,
    }
}
#[doc = "Represents an AAD identity protection solution which sends logs to an OMS workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AadExternalSecuritySolution {
    #[serde(flatten)]
    pub external_security_solution: ExternalSecuritySolution,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AadSolutionProperties>,
}
impl AadExternalSecuritySolution {
    pub fn new(external_security_solution: ExternalSecuritySolution) -> Self {
        Self {
            external_security_solution,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadSolutionProperties {
    #[serde(flatten)]
    pub external_security_solution_properties: ExternalSecuritySolutionProperties,
    #[serde(flatten)]
    pub aad_connectivity_state: AadConnectivityState,
}
impl AadSolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdaptiveApplicationControlGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    #[doc = "Represents a machines group and set of rules to be allowed running on a machine"]
    pub properties: AdaptiveApplicationControlGroupData,
}
impl AdaptiveApplicationControlGroup {
    pub fn new(properties: AdaptiveApplicationControlGroupData) -> Self {
        Self {
            resource: Resource::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[doc = "Represents a machines group and set of rules to be allowed running on a machine"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveApplicationControlGroupData {
    #[doc = "The application control policy enforcement/protection mode of the machine group"]
    #[serde(rename = "enforcementMode", default, skip_serializing_if = "Option::is_none")]
    pub enforcement_mode: Option<EnforcementMode>,
    #[doc = "The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux."]
    #[serde(rename = "protectionMode", default, skip_serializing_if = "Option::is_none")]
    pub protection_mode: Option<ProtectionMode>,
    #[doc = "The configuration status of the machines group or machine or rule"]
    #[serde(rename = "configurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub configuration_status: Option<ConfigurationStatus>,
    #[doc = "The initial recommendation status of the machine group or machine"]
    #[serde(rename = "recommendationStatus", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_status: Option<RecommendationStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub issues: Option<AdaptiveApplicationControlIssuesSummaries>,
    #[doc = "The source type of the machine group"]
    #[serde(rename = "sourceSystem", default, skip_serializing_if = "Option::is_none")]
    pub source_system: Option<SourceSystem>,
    #[serde(rename = "vmRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub vm_recommendations: Option<VmRecommendations>,
    #[serde(rename = "pathRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub path_recommendations: Option<PathRecommendations>,
}
impl AdaptiveApplicationControlGroupData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a list of machine groups and set of rules that are recommended by Azure Security Center to be allowed"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveApplicationControlGroups {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AdaptiveApplicationControlGroup>,
}
impl AdaptiveApplicationControlGroups {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An alert that machines within a group can have"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AdaptiveApplicationControlIssue {
    ViolationsAudited,
    ViolationsBlocked,
    MsiAndScriptViolationsAudited,
    MsiAndScriptViolationsBlocked,
    ExecutableViolationsAudited,
    RulesViolatedManually,
}
#[doc = "Represents a summary of the alerts of the machine group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveApplicationControlIssueSummary {
    #[doc = "An alert that machines within a group can have"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub issue: Option<AdaptiveApplicationControlIssue>,
    #[doc = "The number of machines in the group that have this alert"]
    #[serde(rename = "numberOfVms", default, skip_serializing_if = "Option::is_none")]
    pub number_of_vms: Option<f64>,
}
impl AdaptiveApplicationControlIssueSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type AdaptiveApplicationControlIssuesSummaries = Vec<AdaptiveApplicationControlIssueSummary>;
#[doc = "The resource whose properties describes the Adaptive Network Hardening settings for some Azure resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveNetworkHardening {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Adaptive Network Hardening resource properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdaptiveNetworkHardeningProperties>,
}
impl AdaptiveNetworkHardening {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdaptiveNetworkHardeningEnforceRequest {
    #[doc = "The rules to enforce"]
    pub rules: Vec<Rule>,
    #[doc = "The Azure resource IDs of the effective network security groups that will be updated with the created security rules from the Adaptive Network Hardening rules"]
    #[serde(rename = "networkSecurityGroups")]
    pub network_security_groups: Vec<String>,
}
impl AdaptiveNetworkHardeningEnforceRequest {
    pub fn new(rules: Vec<Rule>, network_security_groups: Vec<String>) -> Self {
        Self {
            rules,
            network_security_groups,
        }
    }
}
#[doc = "Adaptive Network Hardening resource properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveNetworkHardeningProperties {
    #[doc = "The security rules which are recommended to be effective on the VM"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<Rule>,
    #[doc = "The UTC time on which the rules were calculated"]
    #[serde(rename = "rulesCalculationTime", default, skip_serializing_if = "Option::is_none")]
    pub rules_calculation_time: Option<String>,
    #[doc = "The Network Security Groups effective on the network interfaces of the protected resource"]
    #[serde(rename = "effectiveNetworkSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_network_security_groups: Vec<EffectiveNetworkSecurityGroups>,
}
impl AdaptiveNetworkHardeningProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListAdaptiveNetworkHardenings API service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveNetworkHardeningsList {
    #[doc = "A list of Adaptive Network Hardenings resources"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AdaptiveNetworkHardening>,
    #[doc = "The URL to get the next set of results"]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AdaptiveNetworkHardeningsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security alert"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alert {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "describes security alert properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertProperties>,
}
impl Alert {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Changing set of properties depending on the entity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertEntity {
    #[doc = "Type of entity"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl AlertEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Links related to the alert"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertExtendedLinks {}
impl AlertExtendedLinks {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Custom properties for the alert."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertExtendedProperties {}
impl AlertExtendedProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of security alerts"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertList {
    #[doc = "describes security alert properties."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Alert>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes security alert properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertProperties {
    #[doc = "Unique identifier for the detection logic (all alert instances from the same detection logic will have the same alertType)."]
    #[serde(rename = "alertType", default, skip_serializing_if = "Option::is_none")]
    pub alert_type: Option<String>,
    #[doc = "Unique identifier for the alert."]
    #[serde(rename = "systemAlertId", default, skip_serializing_if = "Option::is_none")]
    pub system_alert_id: Option<String>,
    #[doc = "The name of Azure Security Center pricing tier which powering this alert. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-pricing"]
    #[serde(rename = "productComponentName", default, skip_serializing_if = "Option::is_none")]
    pub product_component_name: Option<String>,
    #[doc = "The display name of the alert."]
    #[serde(rename = "alertDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub alert_display_name: Option<String>,
    #[doc = "Description of the suspicious activity that was detected."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The risk level of the threat that was detected. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<alert_properties::Severity>,
    #[doc = "The kill chain related intent behind the alert. For list of supported values, and explanations of Azure Security Center's supported kill chain intents."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub intent: Option<alert_properties::Intent>,
    #[doc = "The UTC time of the first event or activity included in the alert in ISO8601 format."]
    #[serde(rename = "startTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub start_time_utc: Option<String>,
    #[doc = "The UTC time of the last event or activity included in the alert in ISO8601 format."]
    #[serde(rename = "endTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub end_time_utc: Option<String>,
    #[doc = "The resource identifiers that can be used to direct the alert to the right product exposure group (tenant, workspace, subscription etc.). There can be multiple identifiers of different type per alert."]
    #[serde(rename = "resourceIdentifiers", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_identifiers: Vec<ResourceIdentifier>,
    #[doc = "Manual action items to take to remediate the alert."]
    #[serde(rename = "remediationSteps", default, skip_serializing_if = "Vec::is_empty")]
    pub remediation_steps: Vec<String>,
    #[doc = "The name of the vendor that raises the alert."]
    #[serde(rename = "vendorName", default, skip_serializing_if = "Option::is_none")]
    pub vendor_name: Option<String>,
    #[doc = "The life cycle status of the alert."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<alert_properties::Status>,
    #[doc = "Links related to the alert"]
    #[serde(rename = "extendedLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub extended_links: Vec<AlertExtendedLinks>,
    #[doc = "A direct link to the alert page in Azure Portal."]
    #[serde(rename = "alertUri", default, skip_serializing_if = "Option::is_none")]
    pub alert_uri: Option<String>,
    #[doc = "The UTC time the alert was generated in ISO8601 format."]
    #[serde(rename = "timeGeneratedUtc", default, skip_serializing_if = "Option::is_none")]
    pub time_generated_utc: Option<String>,
    #[doc = "The name of the product which published this alert (Azure Security Center, Azure ATP, Microsoft Defender ATP, O365 ATP, MCAS, and so on)."]
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[doc = "The UTC processing end time of the alert in ISO8601 format."]
    #[serde(rename = "processingEndTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub processing_end_time_utc: Option<String>,
    #[doc = "A list of entities related to the alert."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub entities: Vec<AlertEntity>,
    #[doc = "This field determines whether the alert is an incident (a compound grouping of several alerts) or a single alert."]
    #[serde(rename = "isIncident", default, skip_serializing_if = "Option::is_none")]
    pub is_incident: Option<bool>,
    #[doc = "Key for corelating related alerts. Alerts with the same correlation key considered to be related."]
    #[serde(rename = "correlationKey", default, skip_serializing_if = "Option::is_none")]
    pub correlation_key: Option<String>,
    #[doc = "Custom properties for the alert."]
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<AlertExtendedProperties>,
    #[doc = "The display name of the resource most related to this alert."]
    #[serde(rename = "compromisedEntity", default, skip_serializing_if = "Option::is_none")]
    pub compromised_entity: Option<String>,
}
impl AlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_properties {
    use super::*;
    #[doc = "The risk level of the threat that was detected. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Informational,
        Low,
        Medium,
        High,
    }
    #[doc = "The kill chain related intent behind the alert. For list of supported values, and explanations of Azure Security Center's supported kill chain intents."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Intent {
        Unknown,
        PreAttack,
        InitialAccess,
        Persistence,
        PrivilegeEscalation,
        DefenseEvasion,
        CredentialAccess,
        Discovery,
        LateralMovement,
        Execution,
        Collection,
        Exfiltration,
        CommandAndControl,
        Impact,
        Probing,
        Exploitation,
    }
    #[doc = "The life cycle status of the alert."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Active,
        Resolved,
        Dismissed,
    }
}
#[doc = "List of all possible traffic between Azure resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AllowedConnectionsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AllowedConnectionsResource>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AllowedConnectionsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource whose properties describes the allowed traffic between Azure resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AllowedConnectionsResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    #[doc = "Describes the allowed traffic between Azure resources"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AllowedConnectionsResourceProperties>,
}
impl AllowedConnectionsResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the allowed traffic between Azure resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AllowedConnectionsResourceProperties {
    #[doc = "The UTC time on which the allowed connections resource was calculated"]
    #[serde(rename = "calculatedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub calculated_date_time: Option<String>,
    #[doc = "List of connectable resources"]
    #[serde(rename = "connectableResources", default, skip_serializing_if = "Vec::is_empty")]
    pub connectable_resources: Vec<ConnectableResource>,
}
impl AllowedConnectionsResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Links relevant to the assessment"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessmentLinks {
    #[doc = "Link to assessment in Azure Portal"]
    #[serde(rename = "azurePortalUri", default, skip_serializing_if = "Option::is_none")]
    pub azure_portal_uri: Option<String>,
}
impl AssessmentLinks {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The result of the assessment"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssessmentStatus {
    #[doc = "Programmatic code for the status of the assessment"]
    pub code: assessment_status::Code,
    #[doc = "Programmatic code for the cause of the assessment status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cause: Option<String>,
    #[doc = "Human readable description of the assessment status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl AssessmentStatus {
    pub fn new(code: assessment_status::Code) -> Self {
        Self {
            code,
            cause: None,
            description: None,
        }
    }
}
pub mod assessment_status {
    use super::*;
    #[doc = "Programmatic code for the status of the assessment"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Code {
        Healthy,
        Unhealthy,
        NotApplicable,
    }
}
#[doc = "Represents an ATA security solution which sends logs to an OMS workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AtaExternalSecuritySolution {
    #[serde(flatten)]
    pub external_security_solution: ExternalSecuritySolution,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AtaSolutionProperties>,
}
impl AtaExternalSecuritySolution {
    pub fn new(external_security_solution: ExternalSecuritySolution) -> Self {
        Self {
            external_security_solution,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AtaSolutionProperties {
    #[serde(flatten)]
    pub external_security_solution_properties: ExternalSecuritySolutionProperties,
    #[serde(rename = "lastEventReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_event_received: Option<String>,
}
impl AtaSolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure resource identifier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceIdentifier {
    #[serde(flatten)]
    pub resource_identifier: ResourceIdentifier,
    #[doc = "ARM resource identifier for the cloud resource being alerted on"]
    #[serde(rename = "azureResourceId", default, skip_serializing_if = "Option::is_none")]
    pub azure_resource_id: Option<String>,
}
impl AzureResourceIdentifier {
    pub fn new(resource_identifier: ResourceIdentifier) -> Self {
        Self {
            resource_identifier,
            azure_resource_id: None,
        }
    }
}
#[doc = "Describes an Azure resource with kind"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResourceLink {
    #[doc = "Azure resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl AzureResourceLink {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type AzureResourceLinks = Vec<AzureResourceLink>;
#[doc = "Represents a security solution which sends CEF logs to an OMS workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CefExternalSecuritySolution {
    #[serde(flatten)]
    pub external_security_solution: ExternalSecuritySolution,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CefSolutionProperties>,
}
impl CefExternalSecuritySolution {
    pub fn new(external_security_solution: ExternalSecuritySolution) -> Self {
        Self {
            external_security_solution,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CefSolutionProperties {
    #[serde(flatten)]
    pub external_security_solution_properties: ExternalSecuritySolutionProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub agent: Option<String>,
    #[serde(rename = "lastEventReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_event_received: Option<String>,
}
impl CefSolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "The error detail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The error detail."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The configuration status of the machines group or machine or rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConfigurationStatus {
    Configured,
    NotConfigured,
    InProgress,
    Failed,
    NoStatus,
}
#[doc = "Describes the allowed inbound and outbound traffic of an Azure resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectableResource {
    #[doc = "The Azure resource id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The list of Azure resources that the resource has inbound allowed connection from"]
    #[serde(rename = "inboundConnectedResources", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_connected_resources: Vec<ConnectedResource>,
    #[doc = "The list of Azure resources that the resource has outbound allowed connection to"]
    #[serde(rename = "outboundConnectedResources", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_connected_resources: Vec<ConnectedResource>,
}
impl ConnectableResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes properties of a connected resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectedResource {
    #[doc = "The Azure resource id of the connected resource"]
    #[serde(rename = "connectedResourceId", default, skip_serializing_if = "Option::is_none")]
    pub connected_resource_id: Option<String>,
    #[doc = "The allowed tcp ports"]
    #[serde(rename = "tcpPorts", default, skip_serializing_if = "Option::is_none")]
    pub tcp_ports: Option<String>,
    #[doc = "The allowed udp ports"]
    #[serde(rename = "udpPorts", default, skip_serializing_if = "Option::is_none")]
    pub udp_ports: Option<String>,
}
impl ConnectedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectedWorkspace {
    #[doc = "Azure resource ID of the connected OMS workspace"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ConnectedWorkspace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiscoveredSecuritySolution {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    pub properties: DiscoveredSecuritySolutionProperties,
}
impl DiscoveredSecuritySolution {
    pub fn new(properties: DiscoveredSecuritySolutionProperties) -> Self {
        Self {
            resource: Resource::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiscoveredSecuritySolutionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DiscoveredSecuritySolution>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiscoveredSecuritySolutionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiscoveredSecuritySolutionProperties {
    #[doc = "The security family of the discovered solution"]
    #[serde(rename = "securityFamily")]
    pub security_family: discovered_security_solution_properties::SecurityFamily,
    #[doc = "The security solutions' image offer"]
    pub offer: String,
    #[doc = "The security solutions' image publisher"]
    pub publisher: String,
    #[doc = "The security solutions' image sku"]
    pub sku: String,
}
impl DiscoveredSecuritySolutionProperties {
    pub fn new(
        security_family: discovered_security_solution_properties::SecurityFamily,
        offer: String,
        publisher: String,
        sku: String,
    ) -> Self {
        Self {
            security_family,
            offer,
            publisher,
            sku,
        }
    }
}
pub mod discovered_security_solution_properties {
    use super::*;
    #[doc = "The security family of the discovered solution"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SecurityFamily {
        Waf,
        Ngfw,
        SaasWaf,
        Va,
    }
}
#[doc = "Describes the Network Security Groups effective on a network interface"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroups {
    #[doc = "The Azure resource ID of the network interface"]
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<String>,
    #[doc = "The Network Security Groups effective on the network interface"]
    #[serde(rename = "networkSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub network_security_groups: Vec<String>,
}
impl EffectiveNetworkSecurityGroups {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The application control policy enforcement/protection mode of the machine group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EnforcementMode {
    Audit,
    Enforce,
    None,
}
#[doc = "The machine supportability of Enforce feature"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EnforcementSupport {
    Supported,
    NotSupported,
    Unknown,
}
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a security solution external to Azure Security Center which sends information to an OMS workspace and whose data is displayed by Azure Security Center."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExternalSecuritySolution {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub external_security_solution_kind: ExternalSecuritySolutionKind,
    #[serde(flatten)]
    pub location: Location,
}
impl ExternalSecuritySolution {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            external_security_solution_kind: ExternalSecuritySolutionKind::default(),
            location: Location::default(),
        }
    }
}
#[doc = "Describes an Azure resource with kind"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolutionKind {
    #[doc = "The kind of the external solution"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<external_security_solution_kind::Kind>,
}
impl ExternalSecuritySolutionKind {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod external_security_solution_kind {
    use super::*;
    #[doc = "The kind of the external solution"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "CEF")]
        Cef,
        #[serde(rename = "ATA")]
        Ata,
        #[serde(rename = "AAD")]
        Aad,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolutionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExternalSecuritySolution>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExternalSecuritySolutionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The solution properties (correspond to the solution kind)"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolutionProperties {
    #[serde(rename = "deviceVendor", default, skip_serializing_if = "Option::is_none")]
    pub device_vendor: Option<String>,
    #[serde(rename = "deviceType", default, skip_serializing_if = "Option::is_none")]
    pub device_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub workspace: Option<ConnectedWorkspace>,
}
impl ExternalSecuritySolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The type of the file (for Linux files - Executable is used)"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FileType {
    Exe,
    Dll,
    Msi,
    Script,
    Executable,
    Unknown,
}
pub type GroupResourceId = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JitNetworkAccessPoliciesList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JitNetworkAccessPolicy>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JitNetworkAccessPoliciesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub kind: Kind,
    #[serde(flatten)]
    pub location: Location,
    pub properties: JitNetworkAccessPolicyProperties,
}
impl JitNetworkAccessPolicy {
    pub fn new(properties: JitNetworkAccessPolicyProperties) -> Self {
        Self {
            resource: Resource::default(),
            kind: Kind::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyInitiatePort {
    pub number: PortNumber,
    #[doc = "Source of the allowed traffic. If omitted, the request will be for the source IP address of the initiate request."]
    #[serde(rename = "allowedSourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub allowed_source_address_prefix: Option<String>,
    #[doc = "The time to close the request in UTC"]
    #[serde(rename = "endTimeUtc")]
    pub end_time_utc: String,
}
impl JitNetworkAccessPolicyInitiatePort {
    pub fn new(number: PortNumber, end_time_utc: String) -> Self {
        Self {
            number,
            allowed_source_address_prefix: None,
            end_time_utc,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyInitiateRequest {
    #[doc = "A list of virtual machines & ports to open access for"]
    #[serde(rename = "virtualMachines")]
    pub virtual_machines: Vec<JitNetworkAccessPolicyInitiateVirtualMachine>,
    #[doc = "The justification for making the initiate request"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub justification: Option<String>,
}
impl JitNetworkAccessPolicyInitiateRequest {
    pub fn new(virtual_machines: Vec<JitNetworkAccessPolicyInitiateVirtualMachine>) -> Self {
        Self {
            virtual_machines,
            justification: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyInitiateVirtualMachine {
    #[doc = "Resource ID of the virtual machine that is linked to this policy"]
    pub id: String,
    #[doc = "The ports to open for the resource with the `id`"]
    pub ports: Vec<JitNetworkAccessPolicyInitiatePort>,
}
impl JitNetworkAccessPolicyInitiateVirtualMachine {
    pub fn new(id: String, ports: Vec<JitNetworkAccessPolicyInitiatePort>) -> Self {
        Self { id, ports }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyProperties {
    #[doc = "Configurations for Microsoft.Compute/virtualMachines resource type."]
    #[serde(rename = "virtualMachines")]
    pub virtual_machines: Vec<JitNetworkAccessPolicyVirtualMachine>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub requests: Vec<JitNetworkAccessRequest>,
    #[doc = "Gets the provisioning state of the Just-in-Time policy."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl JitNetworkAccessPolicyProperties {
    pub fn new(virtual_machines: Vec<JitNetworkAccessPolicyVirtualMachine>) -> Self {
        Self {
            virtual_machines,
            requests: Vec::new(),
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyVirtualMachine {
    #[doc = "Resource ID of the virtual machine that is linked to this policy"]
    pub id: String,
    #[doc = "Port configurations for the virtual machine"]
    pub ports: Vec<JitNetworkAccessPortRule>,
    #[doc = "Public IP address of the Azure Firewall that is linked to this policy, if applicable"]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
}
impl JitNetworkAccessPolicyVirtualMachine {
    pub fn new(id: String, ports: Vec<JitNetworkAccessPortRule>) -> Self {
        Self {
            id,
            ports,
            public_ip_address: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPortRule {
    pub number: PortNumber,
    pub protocol: jit_network_access_port_rule::Protocol,
    #[doc = "Mutually exclusive with the \"allowedSourceAddressPrefixes\" parameter. Should be an IP address or CIDR, for example \"192.168.0.3\" or \"192.168.0.0/16\"."]
    #[serde(rename = "allowedSourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub allowed_source_address_prefix: Option<String>,
    #[doc = "Mutually exclusive with the \"allowedSourceAddressPrefix\" parameter."]
    #[serde(rename = "allowedSourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_source_address_prefixes: Vec<String>,
    #[doc = "Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day"]
    #[serde(rename = "maxRequestAccessDuration")]
    pub max_request_access_duration: String,
}
impl JitNetworkAccessPortRule {
    pub fn new(number: PortNumber, protocol: jit_network_access_port_rule::Protocol, max_request_access_duration: String) -> Self {
        Self {
            number,
            protocol,
            allowed_source_address_prefix: None,
            allowed_source_address_prefixes: Vec::new(),
            max_request_access_duration,
        }
    }
}
pub mod jit_network_access_port_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
        #[serde(rename = "*")]
        U2a,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessRequest {
    #[serde(rename = "virtualMachines")]
    pub virtual_machines: Vec<JitNetworkAccessRequestVirtualMachine>,
    #[doc = "The start time of the request in UTC"]
    #[serde(rename = "startTimeUtc")]
    pub start_time_utc: String,
    #[doc = "The identity of the person who made the request"]
    pub requestor: String,
    #[doc = "The justification for making the initiate request"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub justification: Option<String>,
}
impl JitNetworkAccessRequest {
    pub fn new(virtual_machines: Vec<JitNetworkAccessRequestVirtualMachine>, start_time_utc: String, requestor: String) -> Self {
        Self {
            virtual_machines,
            start_time_utc,
            requestor,
            justification: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessRequestPort {
    pub number: PortNumber,
    #[doc = "Mutually exclusive with the \"allowedSourceAddressPrefixes\" parameter. Should be an IP address or CIDR, for example \"192.168.0.3\" or \"192.168.0.0/16\"."]
    #[serde(rename = "allowedSourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub allowed_source_address_prefix: Option<String>,
    #[doc = "Mutually exclusive with the \"allowedSourceAddressPrefix\" parameter."]
    #[serde(rename = "allowedSourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_source_address_prefixes: Vec<String>,
    #[doc = "The date & time at which the request ends in UTC"]
    #[serde(rename = "endTimeUtc")]
    pub end_time_utc: String,
    #[doc = "The status of the port"]
    pub status: jit_network_access_request_port::Status,
    #[doc = "A description of why the `status` has its value"]
    #[serde(rename = "statusReason")]
    pub status_reason: jit_network_access_request_port::StatusReason,
    #[doc = "The port which is mapped to this port's `number` in the Azure Firewall, if applicable"]
    #[serde(rename = "mappedPort", default, skip_serializing_if = "Option::is_none")]
    pub mapped_port: Option<i64>,
}
impl JitNetworkAccessRequestPort {
    pub fn new(
        number: PortNumber,
        end_time_utc: String,
        status: jit_network_access_request_port::Status,
        status_reason: jit_network_access_request_port::StatusReason,
    ) -> Self {
        Self {
            number,
            allowed_source_address_prefix: None,
            allowed_source_address_prefixes: Vec::new(),
            end_time_utc,
            status,
            status_reason,
            mapped_port: None,
        }
    }
}
pub mod jit_network_access_request_port {
    use super::*;
    #[doc = "The status of the port"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Revoked,
        Initiated,
    }
    #[doc = "A description of why the `status` has its value"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StatusReason {
        Expired,
        UserRequested,
        NewerRequestInitiated,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessRequestVirtualMachine {
    #[doc = "Resource ID of the virtual machine that is linked to this policy"]
    pub id: String,
    #[doc = "The ports that were opened for the virtual machine"]
    pub ports: Vec<JitNetworkAccessRequestPort>,
}
impl JitNetworkAccessRequestVirtualMachine {
    pub fn new(id: String, ports: Vec<JitNetworkAccessRequestPort>) -> Self {
        Self { id, ports }
    }
}
#[doc = "Describes an Azure resource with kind"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Kind {
    #[doc = "Kind of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl Kind {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes an Azure resource with location"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Location {
    #[doc = "Location where the resource is stored"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl Location {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a Log Analytics workspace scope identifier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogAnalyticsIdentifier {
    #[serde(flatten)]
    pub resource_identifier: ResourceIdentifier,
    #[doc = "The LogAnalytics workspace id that stores this alert."]
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[doc = "The azure subscription id for the LogAnalytics workspace storing this alert."]
    #[serde(rename = "workspaceSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_subscription_id: Option<String>,
    #[doc = "The azure resource group for the LogAnalytics workspace storing this alert"]
    #[serde(rename = "workspaceResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub workspace_resource_group: Option<String>,
    #[doc = "(optional) The LogAnalytics agent id reporting the event that this alert is based on."]
    #[serde(rename = "agentId", default, skip_serializing_if = "Option::is_none")]
    pub agent_id: Option<String>,
}
impl LogAnalyticsIdentifier {
    pub fn new(resource_identifier: ResourceIdentifier) -> Self {
        Self {
            resource_identifier,
            workspace_id: None,
            workspace_subscription_id: None,
            workspace_resource_group: None,
            agent_id: None,
        }
    }
}
#[doc = "Represents a path that is recommended to be allowed and its properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PathRecommendation {
    #[doc = "The full path of the file, or an identifier of the application"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "The recommendation action of the machine or rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<RecommendationAction>,
    #[doc = "The type of the rule to be allowed"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<RecommendationType>,
    #[doc = "Represents the publisher information of a process/rule"]
    #[serde(rename = "publisherInfo", default, skip_serializing_if = "Option::is_none")]
    pub publisher_info: Option<PublisherInfo>,
    #[doc = "Whether the application is commonly run on the machine"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub common: Option<bool>,
    #[serde(rename = "userSids", default, skip_serializing_if = "Vec::is_empty")]
    pub user_sids: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub usernames: Vec<UserRecommendation>,
    #[doc = "The type of the file (for Linux files - Executable is used)"]
    #[serde(rename = "fileType", default, skip_serializing_if = "Option::is_none")]
    pub file_type: Option<FileType>,
    #[doc = "The configuration status of the machines group or machine or rule"]
    #[serde(rename = "configurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub configuration_status: Option<ConfigurationStatus>,
}
impl PathRecommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type PathRecommendations = Vec<PathRecommendation>;
pub type PortNumber = i64;
#[doc = "The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionMode {
    #[doc = "The application control policy enforcement/protection mode of the machine group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exe: Option<EnforcementMode>,
    #[doc = "The application control policy enforcement/protection mode of the machine group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub msi: Option<EnforcementMode>,
    #[doc = "The application control policy enforcement/protection mode of the machine group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<EnforcementMode>,
    #[doc = "The application control policy enforcement/protection mode of the machine group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub executable: Option<EnforcementMode>,
}
impl ProtectionMode {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the publisher information of a process/rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublisherInfo {
    #[doc = "The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country"]
    #[serde(rename = "publisherName", default, skip_serializing_if = "Option::is_none")]
    pub publisher_name: Option<String>,
    #[doc = "The product name taken from the file's version resource"]
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[doc = "The \"OriginalName\" field taken from the file's version resource"]
    #[serde(rename = "binaryName", default, skip_serializing_if = "Option::is_none")]
    pub binary_name: Option<String>,
    #[doc = "The binary file version taken from the file's version resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl PublisherInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The recommendation action of the machine or rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecommendationAction {
    Recommended,
    Add,
    Remove,
}
#[doc = "The initial recommendation status of the machine group or machine"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecommendationStatus {
    Recommended,
    NotRecommended,
    NotAvailable,
    NoStatus,
}
#[doc = "The type of the rule to be allowed"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecommendationType {
    File,
    FileHash,
    PublisherSignature,
    ProductSignature,
    BinarySignature,
    VersionAndAboveSignature,
}
#[doc = "Describes an Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details of the resource that was assessed"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceDetails {
    #[doc = "The platform where the assessed resource resides"]
    pub source: resource_details::Source,
}
impl ResourceDetails {
    pub fn new(source: resource_details::Source) -> Self {
        Self { source }
    }
}
pub mod resource_details {
    use super::*;
    #[doc = "The platform where the assessed resource resides"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        Azure,
        OnPremise,
        OnPremiseSql,
    }
}
#[doc = "A resource identifier for an alert which can be used to direct the alert to the right product exposure group (tenant, workspace, subscription etc.)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceIdentifier {
    #[doc = "There can be multiple identifiers of different type per alert, this field specify the identifier type."]
    #[serde(rename = "type")]
    pub type_: resource_identifier::Type,
}
impl ResourceIdentifier {
    pub fn new(type_: resource_identifier::Type) -> Self {
        Self { type_ }
    }
}
pub mod resource_identifier {
    use super::*;
    #[doc = "There can be multiple identifiers of different type per alert, this field specify the identifier type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        AzureResource,
        LogAnalytics,
    }
}
#[doc = "Describes remote addresses that is recommended to communicate with the Azure resource on some (Protocol, Port, Direction). All other remote addresses are recommended to be blocked"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Rule {
    #[doc = "The name of the rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The rule's direction"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<rule::Direction>,
    #[serde(rename = "destinationPort", default, skip_serializing_if = "Option::is_none")]
    pub destination_port: Option<PortNumber>,
    #[doc = "The rule's transport protocols"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<String>,
    #[doc = "The remote IP addresses that should be able to communicate with the Azure resource on the rule's destination port and protocol"]
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
}
impl Rule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod rule {
    use super::*;
    #[doc = "The rule's direction"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[doc = "Calculation result data"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScoreDetails {
    #[doc = "Maximum score available"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub max: Option<i32>,
    #[doc = "Current score"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub current: Option<f64>,
    #[doc = "Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub percentage: Option<f64>,
}
impl ScoreDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information about the security control."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreControlDefinitionItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Security Control Definition Properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecureScoreControlDefinitionItemProperties>,
}
impl SecureScoreControlDefinitionItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security Control Definition Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreControlDefinitionItemProperties {
    #[doc = "User friendly display name of the control"]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "User friendly description of the control"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Maximum control score (0..10)"]
    #[serde(rename = "maxScore", default, skip_serializing_if = "Option::is_none")]
    pub max_score: Option<i32>,
    #[doc = "The type of the security control (For example, BuiltIn)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<SecureScoreControlDefinitionSource>,
    #[doc = "array of azure resource IDs"]
    #[serde(rename = "assessmentDefinitions", default, skip_serializing_if = "Option::is_none")]
    pub assessment_definitions: Option<AzureResourceLinks>,
}
impl SecureScoreControlDefinitionItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The type of the security control (For example, BuiltIn)"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreControlDefinitionSource {
    #[doc = "The type of security control (for example, BuiltIn)"]
    #[serde(rename = "sourceType", default, skip_serializing_if = "Option::is_none")]
    pub source_type: Option<secure_score_control_definition_source::SourceType>,
}
impl SecureScoreControlDefinitionSource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod secure_score_control_definition_source {
    use super::*;
    #[doc = "The type of security control (for example, BuiltIn)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceType {
        BuiltIn,
        Custom,
    }
}
#[doc = "Details of the security control, its score, and the health status of the relevant resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreControlDetails {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Calculation result data in control level"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecureScoreControlScoreDetails>,
}
impl SecureScoreControlDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of security controls"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreControlList {
    #[doc = "Collection of security controls in this page"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecureScoreControlDetails>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecureScoreControlList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Calculation result data"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreControlScore {
    #[doc = "Maximum control score (0..10)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub max: Option<i32>,
    #[doc = "Actual score for the control = (achieved points / total points) * max score. if total points is zeroed, the return number is 0.00"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub current: Option<f64>,
    #[doc = "Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub percentage: Option<f64>,
}
impl SecureScoreControlScore {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Calculation result data in control level"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreControlScoreDetails {
    #[doc = "User friendly display name of the control"]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Calculation result data"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub score: Option<ScoreDetails>,
    #[doc = "Number of healthy resources in the control"]
    #[serde(rename = "healthyResourceCount", default, skip_serializing_if = "Option::is_none")]
    pub healthy_resource_count: Option<i32>,
    #[doc = "Number of unhealthy resources in the control"]
    #[serde(rename = "unhealthyResourceCount", default, skip_serializing_if = "Option::is_none")]
    pub unhealthy_resource_count: Option<i32>,
    #[doc = "Number of not applicable resources in the control"]
    #[serde(rename = "notApplicableResourceCount", default, skip_serializing_if = "Option::is_none")]
    pub not_applicable_resource_count: Option<i32>,
    #[doc = "The relative weight for this specific control in each of your subscriptions. Used when calculating an aggregated score for this control across all of your subscriptions."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i64>,
    #[doc = "Information about the security control."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definition: Option<SecureScoreControlDefinitionItem>,
}
impl SecureScoreControlScoreDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Secure score item data model"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes properties of a calculated secure score."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecureScoreItemProperties>,
}
impl SecureScoreItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes properties of a calculated secure score."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreItemProperties {
    #[doc = "The initiative’s name"]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Calculation result data"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub score: Option<ScoreDetails>,
    #[doc = "The relative weight for each subscription. Used when calculating an aggregated secure score for multiple subscriptions."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i64>,
}
impl SecureScoreItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of secure scores"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoresList {
    #[doc = "Collection of secure scores in this page"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecureScoreItem>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecureScoresList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security assessment on a resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAssessment {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes properties of an assessment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityAssessmentProperties>,
}
impl SecurityAssessment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Page of a security assessments list"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAssessmentList {
    #[doc = "Collection of security assessments in this page"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityAssessment>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityAssessmentList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security assessment metadata"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAssessmentMetadata {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Describes properties of an assessment metadata."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityAssessmentMetadataProperties>,
}
impl SecurityAssessmentMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of security assessment metadata"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAssessmentMetadataList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityAssessmentMetadata>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityAssessmentMetadataList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the partner that created the assessment"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAssessmentMetadataPartnerData {
    #[doc = "Name of the company of the partner"]
    #[serde(rename = "partnerName")]
    pub partner_name: String,
    #[doc = "Name of the product of the partner that created the assessment"]
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[doc = "Secret to authenticate the partner and verify it created the assessment - write only"]
    pub secret: String,
}
impl SecurityAssessmentMetadataPartnerData {
    pub fn new(partner_name: String, secret: String) -> Self {
        Self {
            partner_name,
            product_name: None,
            secret,
        }
    }
}
#[doc = "Describes properties of an assessment metadata."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAssessmentMetadataProperties {
    #[doc = "User friendly display name of the assessment"]
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[doc = "Azure resource ID of the policy definition that turns this assessment calculation on"]
    #[serde(rename = "policyDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub policy_definition_id: Option<String>,
    #[doc = "Human readable description of the assessment"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Human readable description of what you should do to mitigate this security issue"]
    #[serde(rename = "remediationDescription", default, skip_serializing_if = "Option::is_none")]
    pub remediation_description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub categories: Vec<String>,
    #[doc = "The severity level of the assessment"]
    pub severity: security_assessment_metadata_properties::Severity,
    #[doc = "The user impact of the assessment"]
    #[serde(rename = "userImpact", default, skip_serializing_if = "Option::is_none")]
    pub user_impact: Option<security_assessment_metadata_properties::UserImpact>,
    #[doc = "The implementation effort required to remediate this assessment"]
    #[serde(rename = "implementationEffort", default, skip_serializing_if = "Option::is_none")]
    pub implementation_effort: Option<security_assessment_metadata_properties::ImplementationEffort>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub threats: Vec<String>,
    #[doc = "True if this assessment is in preview release status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub preview: Option<bool>,
    #[doc = "BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition"]
    #[serde(rename = "assessmentType")]
    pub assessment_type: security_assessment_metadata_properties::AssessmentType,
    #[doc = "Describes the partner that created the assessment"]
    #[serde(rename = "partnerData", default, skip_serializing_if = "Option::is_none")]
    pub partner_data: Option<SecurityAssessmentMetadataPartnerData>,
}
impl SecurityAssessmentMetadataProperties {
    pub fn new(
        display_name: String,
        severity: security_assessment_metadata_properties::Severity,
        assessment_type: security_assessment_metadata_properties::AssessmentType,
    ) -> Self {
        Self {
            display_name,
            policy_definition_id: None,
            description: None,
            remediation_description: None,
            categories: Vec::new(),
            severity,
            user_impact: None,
            implementation_effort: None,
            threats: Vec::new(),
            preview: None,
            assessment_type,
            partner_data: None,
        }
    }
}
pub mod security_assessment_metadata_properties {
    use super::*;
    #[doc = "The severity level of the assessment"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Low,
        Medium,
        High,
    }
    #[doc = "The user impact of the assessment"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UserImpact {
        Low,
        Moderate,
        High,
    }
    #[doc = "The implementation effort required to remediate this assessment"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ImplementationEffort {
        Low,
        Moderate,
        High,
    }
    #[doc = "BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AssessmentType {
        BuiltIn,
        CustomPolicy,
        CustomerManaged,
        VerifiedPartner,
    }
}
#[doc = "Data regarding 3rd party partner integration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAssessmentPartnerData {
    #[doc = "Name of the company of the partner"]
    #[serde(rename = "partnerName")]
    pub partner_name: String,
    #[doc = "secret to authenticate the partner - write only"]
    pub secret: String,
}
impl SecurityAssessmentPartnerData {
    pub fn new(partner_name: String, secret: String) -> Self {
        Self { partner_name, secret }
    }
}
#[doc = "Describes properties of an assessment."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAssessmentProperties {
    #[doc = "Details of the resource that was assessed"]
    #[serde(rename = "resourceDetails")]
    pub resource_details: ResourceDetails,
    #[doc = "User friendly display name of the assessment"]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The result of the assessment"]
    pub status: AssessmentStatus,
    #[doc = "Additional data regarding the assessment"]
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<serde_json::Value>,
    #[doc = "Links relevant to the assessment"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub links: Option<AssessmentLinks>,
    #[doc = "Describes properties of an assessment metadata."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<SecurityAssessmentMetadataProperties>,
    #[doc = "Data regarding 3rd party partner integration"]
    #[serde(rename = "partnersData", default, skip_serializing_if = "Option::is_none")]
    pub partners_data: Option<SecurityAssessmentPartnerData>,
}
impl SecurityAssessmentProperties {
    pub fn new(resource_details: ResourceDetails, status: AssessmentStatus) -> Self {
        Self {
            resource_details,
            display_name: None,
            status,
            additional_data: None,
            links: None,
            metadata: None,
            partners_data: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecuritySolution {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecuritySolutionProperties>,
}
impl SecuritySolution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecuritySolutionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecuritySolution>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecuritySolutionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecuritySolutionProperties {
    #[doc = "The security family of the security solution"]
    #[serde(rename = "securityFamily")]
    pub security_family: security_solution_properties::SecurityFamily,
    #[doc = "The security family provisioning State"]
    #[serde(rename = "provisioningState")]
    pub provisioning_state: security_solution_properties::ProvisioningState,
    #[doc = "The security solutions' template"]
    pub template: String,
    #[doc = "The security solutions' status"]
    #[serde(rename = "protectionStatus")]
    pub protection_status: String,
}
impl SecuritySolutionProperties {
    pub fn new(
        security_family: security_solution_properties::SecurityFamily,
        provisioning_state: security_solution_properties::ProvisioningState,
        template: String,
        protection_status: String,
    ) -> Self {
        Self {
            security_family,
            provisioning_state,
            template,
            protection_status,
        }
    }
}
pub mod security_solution_properties {
    use super::*;
    #[doc = "The security family of the security solution"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SecurityFamily {
        Waf,
        Ngfw,
        SaasWaf,
        Va,
    }
    #[doc = "The security family provisioning State"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Failed,
        Updating,
    }
}
#[doc = "Describes the server vulnerability assessment details on a resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerVulnerabilityAssessment {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "describes ServerVulnerabilityAssessment properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServerVulnerabilityAssessmentProperties>,
}
impl ServerVulnerabilityAssessment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes ServerVulnerabilityAssessment properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerVulnerabilityAssessmentProperties {
    #[doc = "The provisioningState of the vulnerability assessment capability on the VM"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<server_vulnerability_assessment_properties::ProvisioningState>,
}
impl ServerVulnerabilityAssessmentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod server_vulnerability_assessment_properties {
    use super::*;
    #[doc = "The provisioningState of the vulnerability assessment capability on the VM"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Failed,
        Canceled,
        Provisioning,
        Deprovisioning,
    }
}
#[doc = "List of server vulnerability assessments"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServerVulnerabilityAssessmentsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServerVulnerabilityAssessment>,
}
impl ServerVulnerabilityAssessmentsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The source type of the machine group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SourceSystem {
    #[serde(rename = "Azure_AppLocker")]
    AzureAppLocker,
    #[serde(rename = "Azure_AuditD")]
    AzureAuditD,
    #[serde(rename = "NonAzure_AppLocker")]
    NonAzureAppLocker,
    #[serde(rename = "NonAzure_AuditD")]
    NonAzureAuditD,
    None,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TopologyResource>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TopologyList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TopologyResourceProperties>,
}
impl TopologyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyResourceProperties {
    #[doc = "The UTC time on which the topology was calculated"]
    #[serde(rename = "calculatedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub calculated_date_time: Option<String>,
    #[doc = "Azure resources which are part of this topology resource"]
    #[serde(rename = "topologyResources", default, skip_serializing_if = "Vec::is_empty")]
    pub topology_resources: Vec<TopologySingleResource>,
}
impl TopologyResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologySingleResource {
    #[doc = "Azure resource id"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "The security severity of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
    #[doc = "Indicates if the resource has security recommendations"]
    #[serde(rename = "recommendationsExist", default, skip_serializing_if = "Option::is_none")]
    pub recommendations_exist: Option<bool>,
    #[doc = "Indicates the resource connectivity level to the Internet (InternetFacing, Internal ,etc.)"]
    #[serde(rename = "networkZones", default, skip_serializing_if = "Option::is_none")]
    pub network_zones: Option<String>,
    #[doc = "Score of the resource based on its security severity"]
    #[serde(rename = "topologyScore", default, skip_serializing_if = "Option::is_none")]
    pub topology_score: Option<i64>,
    #[doc = "The location of this resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Azure resources connected to this resource which are in higher level in the topology view"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parents: Vec<TopologySingleResourceParent>,
    #[doc = "Azure resources connected to this resource which are in lower level in the topology view"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub children: Vec<TopologySingleResourceChild>,
}
impl TopologySingleResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologySingleResourceChild {
    #[doc = "Azure resource id which serves as child resource in topology view"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl TopologySingleResourceChild {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologySingleResourceParent {
    #[doc = "Azure resource id which serves as parent resource in topology view"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl TopologySingleResourceParent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a user that is recommended to be allowed for a certain rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserRecommendation {
    #[doc = "Represents a user that is recommended to be allowed for a certain rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "The recommendation action of the machine or rule"]
    #[serde(rename = "recommendationAction", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_action: Option<RecommendationAction>,
}
impl UserRecommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents a machine that is part of a machine group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmRecommendation {
    #[doc = "The configuration status of the machines group or machine or rule"]
    #[serde(rename = "configurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub configuration_status: Option<ConfigurationStatus>,
    #[doc = "The recommendation action of the machine or rule"]
    #[serde(rename = "recommendationAction", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_action: Option<RecommendationAction>,
    #[doc = "The full resource id of the machine"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<VmResourceId>,
    #[doc = "The machine supportability of Enforce feature"]
    #[serde(rename = "enforcementSupport", default, skip_serializing_if = "Option::is_none")]
    pub enforcement_support: Option<EnforcementSupport>,
}
impl VmRecommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type VmRecommendations = Vec<VmRecommendation>;
pub type VmResourceId = String;
#[doc = "List of security controls definition"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecureScoreControlDefinitionList {
    #[doc = "Collection of security controls definition in this page"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecureScoreControlDefinitionItem>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecureScoreControlDefinitionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecuritySolutionsReferenceData {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    pub properties: SecuritySolutionsReferenceDataProperties,
}
impl SecuritySolutionsReferenceData {
    pub fn new(properties: SecuritySolutionsReferenceDataProperties) -> Self {
        Self {
            resource: Resource::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecuritySolutionsReferenceDataList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecuritySolutionsReferenceData>,
}
impl SecuritySolutionsReferenceDataList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecuritySolutionsReferenceDataProperties {
    #[doc = "The security family of the security solution"]
    #[serde(rename = "securityFamily")]
    pub security_family: security_solutions_reference_data_properties::SecurityFamily,
    #[doc = "The security solutions' vendor name"]
    #[serde(rename = "alertVendorName")]
    pub alert_vendor_name: String,
    #[doc = "The security solutions' package info url"]
    #[serde(rename = "packageInfoUrl")]
    pub package_info_url: String,
    #[doc = "The security solutions' product name"]
    #[serde(rename = "productName")]
    pub product_name: String,
    #[doc = "The security solutions' publisher"]
    pub publisher: String,
    #[doc = "The security solutions' publisher display name"]
    #[serde(rename = "publisherDisplayName")]
    pub publisher_display_name: String,
    #[doc = "The security solutions' template"]
    pub template: String,
}
impl SecuritySolutionsReferenceDataProperties {
    pub fn new(
        security_family: security_solutions_reference_data_properties::SecurityFamily,
        alert_vendor_name: String,
        package_info_url: String,
        product_name: String,
        publisher: String,
        publisher_display_name: String,
        template: String,
    ) -> Self {
        Self {
            security_family,
            alert_vendor_name,
            package_info_url,
            product_name,
            publisher,
            publisher_display_name,
            template,
        }
    }
}
pub mod security_solutions_reference_data_properties {
    use super::*;
    #[doc = "The security family of the security solution"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SecurityFamily {
        Waf,
        Ngfw,
        SaasWaf,
        Va,
    }
}
