#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Security alert"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alert {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "describes security alert properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertProperties>,
}
impl Alert {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Factors that increase our confidence that the alert is a true positive"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertConfidenceReason {
    #[doc = "Type of confidence factor"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "description of the confidence reason"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
}
impl AlertConfidenceReason {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Changing set of properties depending on the entity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertEntity {
    #[doc = "Type of entity"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl AlertEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Changing set of properties depending on the alert type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertExtendedProperties {}
impl AlertExtendedProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of security alerts"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Alert>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "describes security alert properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertProperties {
    #[doc = "State of the alert (Active, Dismissed etc.)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The time the incident was reported to Microsoft.Security in UTC"]
    #[serde(rename = "reportedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub reported_time_utc: Option<String>,
    #[doc = "Name of the vendor that discovered the incident"]
    #[serde(rename = "vendorName", default, skip_serializing_if = "Option::is_none")]
    pub vendor_name: Option<String>,
    #[doc = "Name of the alert type"]
    #[serde(rename = "alertName", default, skip_serializing_if = "Option::is_none")]
    pub alert_name: Option<String>,
    #[doc = "Display name of the alert type"]
    #[serde(rename = "alertDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub alert_display_name: Option<String>,
    #[doc = "The time the incident was detected by the vendor"]
    #[serde(rename = "detectedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub detected_time_utc: Option<String>,
    #[doc = "Description of the incident and what it means"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Recommended steps to reradiate the incident"]
    #[serde(rename = "remediationSteps", default, skip_serializing_if = "Option::is_none")]
    pub remediation_steps: Option<String>,
    #[doc = "The action that was taken as a response to the alert (Active, Blocked etc.)"]
    #[serde(rename = "actionTaken", default, skip_serializing_if = "Option::is_none")]
    pub action_taken: Option<String>,
    #[doc = "Estimated severity of this alert"]
    #[serde(rename = "reportedSeverity", default, skip_serializing_if = "Option::is_none")]
    pub reported_severity: Option<alert_properties::ReportedSeverity>,
    #[doc = "The entity that the incident happened on"]
    #[serde(rename = "compromisedEntity", default, skip_serializing_if = "Option::is_none")]
    pub compromised_entity: Option<String>,
    #[doc = "Azure resource ID of the associated resource"]
    #[serde(rename = "associatedResource", default, skip_serializing_if = "Option::is_none")]
    pub associated_resource: Option<String>,
    #[doc = "Changing set of properties depending on the alert type."]
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<AlertExtendedProperties>,
    #[doc = "The type of the alerted resource (Azure, Non-Azure)"]
    #[serde(rename = "systemSource", default, skip_serializing_if = "Option::is_none")]
    pub system_source: Option<String>,
    #[doc = "Whether this alert can be investigated with Azure Security Center"]
    #[serde(rename = "canBeInvestigated", default, skip_serializing_if = "Option::is_none")]
    pub can_be_investigated: Option<bool>,
    #[doc = "Whether this alert is for incident type or not (otherwise - single alert)"]
    #[serde(rename = "isIncident", default, skip_serializing_if = "Option::is_none")]
    pub is_incident: Option<bool>,
    #[doc = "objects that are related to this alerts"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub entities: Vec<AlertEntity>,
    #[doc = "level of confidence we have on the alert"]
    #[serde(rename = "confidenceScore", default, skip_serializing_if = "Option::is_none")]
    pub confidence_score: Option<f32>,
    #[doc = "reasons the alert got the confidenceScore value"]
    #[serde(rename = "confidenceReasons", default, skip_serializing_if = "Vec::is_empty")]
    pub confidence_reasons: Vec<AlertConfidenceReason>,
    #[doc = "Azure subscription ID of the resource that had the security alert or the subscription ID of the workspace that this resource reports to"]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "Instance ID of the alert."]
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[doc = "Azure resource ID of the workspace that the alert was reported to."]
    #[serde(rename = "workspaceArmId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_arm_id: Option<String>,
    #[doc = "Alerts with the same CorrelationKey will be grouped together in Ibiza."]
    #[serde(rename = "correlationKey", default, skip_serializing_if = "Option::is_none")]
    pub correlation_key: Option<String>,
}
impl AlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_properties {
    use super::*;
    #[doc = "Estimated severity of this alert"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReportedSeverity {
        Informational,
        Low,
        Medium,
        High,
    }
}
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "The error detail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The error detail."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The data export setting properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataExportSettingProperties {
    #[doc = "Is the data export setting is enabled"]
    pub enabled: bool,
}
impl DataExportSettingProperties {
    pub fn new(enabled: bool) -> Self {
        Self { enabled }
    }
}
#[doc = "Represents a data export setting"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataExportSettings {
    #[serde(flatten)]
    pub setting: Setting,
    #[doc = "The data export setting properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DataExportSettingProperties>,
}
impl DataExportSettings {
    pub fn new(setting: Setting) -> Self {
        Self { setting, properties: None }
    }
}
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes an Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The kind of the security setting"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Setting {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "the kind of the settings string (DataExportSettings)"]
    pub kind: setting::Kind,
}
impl Setting {
    pub fn new(kind: setting::Kind) -> Self {
        Self {
            resource: Resource::default(),
            kind,
        }
    }
}
pub mod setting {
    use super::*;
    #[doc = "the kind of the settings string (DataExportSettings)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        DataExportSettings,
        AlertSuppressionSetting,
    }
}
#[doc = "Subscription settings list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SettingsList {
    #[doc = "The settings list."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Setting>,
    #[doc = "The URI to fetch the next page."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SettingsList {
    pub fn new() -> Self {
        Self::default()
    }
}
