#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureTrackedResourceLocation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl AzureTrackedResourceLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ETag {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ETag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Kind {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl Kind {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConnector {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityConnectorProperties>,
}
impl SecurityConnector {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConnectorProperties {
    #[serde(rename = "hierarchyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub hierarchy_identifier: Option<String>,
    #[serde(rename = "cloudName", default, skip_serializing_if = "Option::is_none")]
    pub cloud_name: Option<security_connector_properties::CloudName>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub offerings: Vec<CloudOffering>,
    #[serde(rename = "organizationalData", default, skip_serializing_if = "Option::is_none")]
    pub organizational_data: Option<security_connector_properties::OrganizationalData>,
}
impl SecurityConnectorProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod security_connector_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CloudName {
        Azure,
        #[serde(rename = "AWS")]
        Aws,
        #[serde(rename = "GCP")]
        Gcp,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct OrganizationalData {
        #[serde(rename = "organizationMembershipType", default, skip_serializing_if = "Option::is_none")]
        pub organization_membership_type: Option<organizational_data::OrganizationMembershipType>,
        #[serde(rename = "parentHierarchyId", default, skip_serializing_if = "Option::is_none")]
        pub parent_hierarchy_id: Option<String>,
        #[serde(rename = "stacksetName", default, skip_serializing_if = "Option::is_none")]
        pub stackset_name: Option<String>,
        #[serde(rename = "excludedAccountIds", default, skip_serializing_if = "Vec::is_empty")]
        pub excluded_account_ids: Vec<String>,
    }
    impl OrganizationalData {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod organizational_data {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum OrganizationMembershipType {
            Member,
            Organization,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityConnectorsList {
    pub value: Vec<SecurityConnector>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityConnectorsList {
    pub fn new(value: Vec<SecurityConnector>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Tags {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Tags {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub azure_tracked_resource_location: AzureTrackedResourceLocation,
    #[serde(flatten)]
    pub kind: Kind,
    #[serde(flatten)]
    pub e_tag: ETag,
    #[serde(flatten)]
    pub tags: Tags,
}
impl TrackedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudOffering {
    #[serde(rename = "offeringType")]
    pub offering_type: cloud_offering::OfferingType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl CloudOffering {
    pub fn new(offering_type: cloud_offering::OfferingType) -> Self {
        Self {
            offering_type,
            description: None,
        }
    }
}
pub mod cloud_offering {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OfferingType {
        CspmMonitorAws,
        DefenderForContainersAws,
        DefenderForServersAws,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CspmMonitorAwsOffering {
    #[serde(flatten)]
    pub cloud_offering: CloudOffering,
    #[serde(rename = "nativeCloudConnection", default, skip_serializing_if = "Option::is_none")]
    pub native_cloud_connection: Option<cspm_monitor_aws_offering::NativeCloudConnection>,
}
impl CspmMonitorAwsOffering {
    pub fn new(cloud_offering: CloudOffering) -> Self {
        Self {
            cloud_offering,
            native_cloud_connection: None,
        }
    }
}
pub mod cspm_monitor_aws_offering {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct NativeCloudConnection {
        #[serde(rename = "cloudRoleArn", default, skip_serializing_if = "Option::is_none")]
        pub cloud_role_arn: Option<String>,
    }
    impl NativeCloudConnection {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DefenderForContainersAwsOffering {
    #[serde(flatten)]
    pub cloud_offering: CloudOffering,
    #[serde(rename = "kubernetesService", default, skip_serializing_if = "Option::is_none")]
    pub kubernetes_service: Option<defender_for_containers_aws_offering::KubernetesService>,
    #[serde(rename = "kubernetesScubaReader", default, skip_serializing_if = "Option::is_none")]
    pub kubernetes_scuba_reader: Option<defender_for_containers_aws_offering::KubernetesScubaReader>,
    #[serde(rename = "cloudWatchToKinesis", default, skip_serializing_if = "Option::is_none")]
    pub cloud_watch_to_kinesis: Option<defender_for_containers_aws_offering::CloudWatchToKinesis>,
    #[serde(rename = "kinesisToS3", default, skip_serializing_if = "Option::is_none")]
    pub kinesis_to_s3: Option<defender_for_containers_aws_offering::KinesisToS3>,
}
impl DefenderForContainersAwsOffering {
    pub fn new(cloud_offering: CloudOffering) -> Self {
        Self {
            cloud_offering,
            kubernetes_service: None,
            kubernetes_scuba_reader: None,
            cloud_watch_to_kinesis: None,
            kinesis_to_s3: None,
        }
    }
}
pub mod defender_for_containers_aws_offering {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct KubernetesService {
        #[serde(rename = "cloudRoleArn", default, skip_serializing_if = "Option::is_none")]
        pub cloud_role_arn: Option<String>,
    }
    impl KubernetesService {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct KubernetesScubaReader {
        #[serde(rename = "cloudRoleArn", default, skip_serializing_if = "Option::is_none")]
        pub cloud_role_arn: Option<String>,
    }
    impl KubernetesScubaReader {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct CloudWatchToKinesis {
        #[serde(rename = "cloudRoleArn", default, skip_serializing_if = "Option::is_none")]
        pub cloud_role_arn: Option<String>,
    }
    impl CloudWatchToKinesis {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct KinesisToS3 {
        #[serde(rename = "cloudRoleArn", default, skip_serializing_if = "Option::is_none")]
        pub cloud_role_arn: Option<String>,
    }
    impl KinesisToS3 {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DefenderForServersAwsOffering {
    #[serde(flatten)]
    pub cloud_offering: CloudOffering,
    #[serde(rename = "defenderForServers", default, skip_serializing_if = "Option::is_none")]
    pub defender_for_servers: Option<defender_for_servers_aws_offering::DefenderForServers>,
    #[serde(rename = "arcAutoProvisioning", default, skip_serializing_if = "Option::is_none")]
    pub arc_auto_provisioning: Option<defender_for_servers_aws_offering::ArcAutoProvisioning>,
}
impl DefenderForServersAwsOffering {
    pub fn new(cloud_offering: CloudOffering) -> Self {
        Self {
            cloud_offering,
            defender_for_servers: None,
            arc_auto_provisioning: None,
        }
    }
}
pub mod defender_for_servers_aws_offering {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct DefenderForServers {
        #[serde(rename = "cloudRoleArn", default, skip_serializing_if = "Option::is_none")]
        pub cloud_role_arn: Option<String>,
    }
    impl DefenderForServers {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ArcAutoProvisioning {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub enabled: Option<bool>,
        #[serde(rename = "servicePrincipalSecretMetadata", default, skip_serializing_if = "Option::is_none")]
        pub service_principal_secret_metadata: Option<arc_auto_provisioning::ServicePrincipalSecretMetadata>,
    }
    impl ArcAutoProvisioning {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod arc_auto_provisioning {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
        pub struct ServicePrincipalSecretMetadata {
            #[serde(rename = "expiryDate", default, skip_serializing_if = "Option::is_none")]
            pub expiry_date: Option<String>,
            #[serde(rename = "parameterStoreRegion", default, skip_serializing_if = "Option::is_none")]
            pub parameter_store_region: Option<String>,
            #[serde(rename = "parameterNameInStore", default, skip_serializing_if = "Option::is_none")]
            pub parameter_name_in_store: Option<String>,
        }
        impl ServicePrincipalSecretMetadata {
            pub fn new() -> Self {
                Self::default()
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
