#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertsSuppressionRule {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertsSuppressionRuleProperties>,
}
impl AlertsSuppressionRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertsSuppressionRuleProperties {
    #[serde(rename = "alertType")]
    pub alert_type: String,
    #[serde(rename = "lastModifiedUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_utc: Option<String>,
    #[serde(rename = "expirationDateUtc", default, skip_serializing_if = "Option::is_none")]
    pub expiration_date_utc: Option<String>,
    pub reason: String,
    pub state: alerts_suppression_rule_properties::State,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    #[serde(rename = "suppressionAlertsScope", default, skip_serializing_if = "Option::is_none")]
    pub suppression_alerts_scope: Option<SuppressionAlertsScope>,
}
impl AlertsSuppressionRuleProperties {
    pub fn new(alert_type: String, reason: String, state: alerts_suppression_rule_properties::State) -> Self {
        Self {
            alert_type,
            last_modified_utc: None,
            expiration_date_utc: None,
            reason,
            state,
            comment: None,
            suppression_alerts_scope: None,
        }
    }
}
pub mod alerts_suppression_rule_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
        Expired,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertsSuppressionRulesList {
    pub value: Vec<AlertsSuppressionRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertsSuppressionRulesList {
    pub fn new(value: Vec<AlertsSuppressionRule>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AssessmentLinks {
    #[serde(rename = "azurePortalUri", default, skip_serializing_if = "Option::is_none")]
    pub azure_portal_uri: Option<String>,
}
impl AssessmentLinks {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssessmentStatus {
    pub code: assessment_status::Code,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cause: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl AssessmentStatus {
    pub fn new(code: assessment_status::Code) -> Self {
        Self {
            code,
            cause: None,
            description: None,
        }
    }
}
pub mod assessment_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Code {
        Healthy,
        Unhealthy,
        NotApplicable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegulatoryComplianceAssessment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RegulatoryComplianceAssessmentProperties>,
}
impl RegulatoryComplianceAssessment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegulatoryComplianceAssessmentList {
    pub value: Vec<RegulatoryComplianceAssessment>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RegulatoryComplianceAssessmentList {
    pub fn new(value: Vec<RegulatoryComplianceAssessment>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegulatoryComplianceAssessmentProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "assessmentType", default, skip_serializing_if = "Option::is_none")]
    pub assessment_type: Option<String>,
    #[serde(rename = "assessmentDetailsLink", default, skip_serializing_if = "Option::is_none")]
    pub assessment_details_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<regulatory_compliance_assessment_properties::State>,
    #[serde(rename = "passedResources", default, skip_serializing_if = "Option::is_none")]
    pub passed_resources: Option<i64>,
    #[serde(rename = "failedResources", default, skip_serializing_if = "Option::is_none")]
    pub failed_resources: Option<i64>,
    #[serde(rename = "skippedResources", default, skip_serializing_if = "Option::is_none")]
    pub skipped_resources: Option<i64>,
    #[serde(rename = "unsupportedResources", default, skip_serializing_if = "Option::is_none")]
    pub unsupported_resources: Option<i64>,
}
impl RegulatoryComplianceAssessmentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod regulatory_compliance_assessment_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Passed,
        Failed,
        Skipped,
        Unsupported,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegulatoryComplianceControl {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RegulatoryComplianceControlProperties>,
}
impl RegulatoryComplianceControl {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegulatoryComplianceControlList {
    pub value: Vec<RegulatoryComplianceControl>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RegulatoryComplianceControlList {
    pub fn new(value: Vec<RegulatoryComplianceControl>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegulatoryComplianceControlProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<regulatory_compliance_control_properties::State>,
    #[serde(rename = "passedAssessments", default, skip_serializing_if = "Option::is_none")]
    pub passed_assessments: Option<i64>,
    #[serde(rename = "failedAssessments", default, skip_serializing_if = "Option::is_none")]
    pub failed_assessments: Option<i64>,
    #[serde(rename = "skippedAssessments", default, skip_serializing_if = "Option::is_none")]
    pub skipped_assessments: Option<i64>,
}
impl RegulatoryComplianceControlProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod regulatory_compliance_control_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Passed,
        Failed,
        Skipped,
        Unsupported,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegulatoryComplianceStandard {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RegulatoryComplianceStandardProperties>,
}
impl RegulatoryComplianceStandard {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegulatoryComplianceStandardList {
    pub value: Vec<RegulatoryComplianceStandard>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RegulatoryComplianceStandardList {
    pub fn new(value: Vec<RegulatoryComplianceStandard>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RegulatoryComplianceStandardProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<regulatory_compliance_standard_properties::State>,
    #[serde(rename = "passedControls", default, skip_serializing_if = "Option::is_none")]
    pub passed_controls: Option<i64>,
    #[serde(rename = "failedControls", default, skip_serializing_if = "Option::is_none")]
    pub failed_controls: Option<i64>,
    #[serde(rename = "skippedControls", default, skip_serializing_if = "Option::is_none")]
    pub skipped_controls: Option<i64>,
    #[serde(rename = "unsupportedControls", default, skip_serializing_if = "Option::is_none")]
    pub unsupported_controls: Option<i64>,
}
impl RegulatoryComplianceStandardProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod regulatory_compliance_standard_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Passed,
        Failed,
        Skipped,
        Unsupported,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceDetails {
    pub source: resource_details::Source,
}
impl ResourceDetails {
    pub fn new(source: resource_details::Source) -> Self {
        Self { source }
    }
}
pub mod resource_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        Azure,
        OnPremise,
        OnPremiseSql,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeElement {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub field: Option<String>,
}
impl ScopeElement {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAssessment {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityAssessmentProperties>,
}
impl SecurityAssessment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAssessmentList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityAssessment>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityAssessmentList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAssessmentMetadata {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityAssessmentMetadataProperties>,
}
impl SecurityAssessmentMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityAssessmentMetadataList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityAssessmentMetadata>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityAssessmentMetadataList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAssessmentMetadataProperties {
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[serde(rename = "policyDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub policy_definition_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "remediationDescription", default, skip_serializing_if = "Option::is_none")]
    pub remediation_description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub categories: Vec<String>,
    pub severity: security_assessment_metadata_properties::Severity,
    #[serde(rename = "userImpact", default, skip_serializing_if = "Option::is_none")]
    pub user_impact: Option<security_assessment_metadata_properties::UserImpact>,
    #[serde(rename = "implementationEffort", default, skip_serializing_if = "Option::is_none")]
    pub implementation_effort: Option<security_assessment_metadata_properties::ImplementationEffort>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub threats: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub preview: Option<bool>,
    #[serde(rename = "assessmentType")]
    pub assessment_type: security_assessment_metadata_properties::AssessmentType,
}
impl SecurityAssessmentMetadataProperties {
    pub fn new(
        display_name: String,
        severity: security_assessment_metadata_properties::Severity,
        assessment_type: security_assessment_metadata_properties::AssessmentType,
    ) -> Self {
        Self {
            display_name,
            policy_definition_id: None,
            description: None,
            remediation_description: None,
            categories: Vec::new(),
            severity,
            user_impact: None,
            implementation_effort: None,
            threats: Vec::new(),
            preview: None,
            assessment_type,
        }
    }
}
pub mod security_assessment_metadata_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Low,
        Medium,
        High,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UserImpact {
        Low,
        Moderate,
        High,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ImplementationEffort {
        Low,
        Moderate,
        High,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AssessmentType {
        BuiltIn,
        CustomPolicy,
        CustomerManaged,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityAssessmentProperties {
    #[serde(rename = "resourceDetails")]
    pub resource_details: ResourceDetails,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub status: AssessmentStatus,
    #[serde(rename = "additionalData", default, skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub links: Option<AssessmentLinks>,
}
impl SecurityAssessmentProperties {
    pub fn new(resource_details: ResourceDetails, status: AssessmentStatus) -> Self {
        Self {
            resource_details,
            display_name: None,
            status,
            additional_data: None,
            links: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SuppressionAlertsScope {
    #[serde(rename = "allOf")]
    pub all_of: Vec<ScopeElement>,
}
impl SuppressionAlertsScope {
    pub fn new(all_of: Vec<ScopeElement>) -> Self {
        Self { all_of }
    }
}
