#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadConnectivityState {
    #[serde(rename = "connectivityState", default, skip_serializing_if = "Option::is_none")]
    pub connectivity_state: Option<aad_connectivity_state::ConnectivityState>,
}
impl AadConnectivityState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod aad_connectivity_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectivityState {
        Discovered,
        NotLicensed,
        Connected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadExternalSecuritySolution {
    #[serde(flatten)]
    pub external_security_solution: ExternalSecuritySolution,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AadSolutionProperties>,
}
impl AadExternalSecuritySolution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadSolutionProperties {
    #[serde(flatten)]
    pub external_security_solution_properties: ExternalSecuritySolutionProperties,
    #[serde(flatten)]
    pub aad_connectivity_state: AadConnectivityState,
}
impl AadSolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveNetworkHardening {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdaptiveNetworkHardeningProperties>,
}
impl AdaptiveNetworkHardening {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdaptiveNetworkHardeningEnforceRequest {
    pub rules: Vec<Rule>,
    #[serde(rename = "networkSecurityGroups")]
    pub network_security_groups: Vec<String>,
}
impl AdaptiveNetworkHardeningEnforceRequest {
    pub fn new(rules: Vec<Rule>, network_security_groups: Vec<String>) -> Self {
        Self {
            rules,
            network_security_groups,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveNetworkHardeningProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<Rule>,
    #[serde(rename = "rulesCalculationTime", default, skip_serializing_if = "Option::is_none")]
    pub rules_calculation_time: Option<String>,
    #[serde(rename = "effectiveNetworkSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_network_security_groups: Vec<EffectiveNetworkSecurityGroups>,
}
impl AdaptiveNetworkHardeningProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdaptiveNetworkHardeningsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AdaptiveNetworkHardening>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AdaptiveNetworkHardeningsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alert {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertProperties>,
}
impl Alert {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertConfidenceReason {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<String>,
}
impl AlertConfidenceReason {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertEntity {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl AlertEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertExtendedProperties {}
impl AlertExtendedProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Alert>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "reportedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub reported_time_utc: Option<String>,
    #[serde(rename = "vendorName", default, skip_serializing_if = "Option::is_none")]
    pub vendor_name: Option<String>,
    #[serde(rename = "alertName", default, skip_serializing_if = "Option::is_none")]
    pub alert_name: Option<String>,
    #[serde(rename = "alertDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub alert_display_name: Option<String>,
    #[serde(rename = "detectedTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub detected_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "remediationSteps", default, skip_serializing_if = "Option::is_none")]
    pub remediation_steps: Option<String>,
    #[serde(rename = "actionTaken", default, skip_serializing_if = "Option::is_none")]
    pub action_taken: Option<String>,
    #[serde(rename = "reportedSeverity", default, skip_serializing_if = "Option::is_none")]
    pub reported_severity: Option<alert_properties::ReportedSeverity>,
    #[serde(rename = "compromisedEntity", default, skip_serializing_if = "Option::is_none")]
    pub compromised_entity: Option<String>,
    #[serde(rename = "associatedResource", default, skip_serializing_if = "Option::is_none")]
    pub associated_resource: Option<String>,
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<AlertExtendedProperties>,
    #[serde(rename = "systemSource", default, skip_serializing_if = "Option::is_none")]
    pub system_source: Option<String>,
    #[serde(rename = "canBeInvestigated", default, skip_serializing_if = "Option::is_none")]
    pub can_be_investigated: Option<bool>,
    #[serde(rename = "isIncident", default, skip_serializing_if = "Option::is_none")]
    pub is_incident: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub entities: Vec<AlertEntity>,
    #[serde(rename = "confidenceScore", default, skip_serializing_if = "Option::is_none")]
    pub confidence_score: Option<f32>,
    #[serde(rename = "confidenceReasons", default, skip_serializing_if = "Vec::is_empty")]
    pub confidence_reasons: Vec<AlertConfidenceReason>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[serde(rename = "workspaceArmId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_arm_id: Option<String>,
    #[serde(rename = "correlationKey", default, skip_serializing_if = "Option::is_none")]
    pub correlation_key: Option<String>,
}
impl AlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod alert_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReportedSeverity {
        Silent,
        Information,
        Low,
        High,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AllowedConnectionsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AllowedConnectionsResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AllowedConnectionsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AllowedConnectionsResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AllowedConnectionsResourceProperties>,
}
impl AllowedConnectionsResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AllowedConnectionsResourceProperties {
    #[serde(rename = "calculatedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub calculated_date_time: Option<String>,
    #[serde(rename = "connectableResources", default, skip_serializing_if = "Vec::is_empty")]
    pub connectable_resources: Vec<ConnectableResource>,
}
impl AllowedConnectionsResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppWhitelistingGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    pub properties: AppWhitelistingGroupData,
}
impl AppWhitelistingGroup {
    pub fn new(properties: AppWhitelistingGroupData) -> Self {
        Self {
            resource: Resource::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppWhitelistingGroupData {
    #[serde(rename = "enforcementMode", default, skip_serializing_if = "Option::is_none")]
    pub enforcement_mode: Option<EnforcementMode>,
    #[serde(rename = "protectionMode", default, skip_serializing_if = "Option::is_none")]
    pub protection_mode: Option<ProtectionMode>,
    #[serde(rename = "configurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub configuration_status: Option<ConfigurationStatus>,
    #[serde(rename = "recommendationStatus", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_status: Option<RecommendationStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub issues: Option<AppWhitelistingIssuesSummaries>,
    #[serde(rename = "sourceSystem", default, skip_serializing_if = "Option::is_none")]
    pub source_system: Option<SourceSystem>,
    #[serde(rename = "vmRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub vm_recommendations: Option<VmRecommendations>,
    #[serde(rename = "pathRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub path_recommendations: Option<PathRecommendations>,
}
impl AppWhitelistingGroupData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppWhitelistingGroups {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AppWhitelistingGroup>,
}
impl AppWhitelistingGroups {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AppWhitelistingIssue {
    ViolationsAudited,
    ViolationsBlocked,
    MsiAndScriptViolationsAudited,
    MsiAndScriptViolationsBlocked,
    ExecutableViolationsAudited,
    RulesViolatedManually,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppWhitelistingIssueSummary {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub issue: Option<AppWhitelistingIssue>,
    #[serde(rename = "numberOfVms", default, skip_serializing_if = "Option::is_none")]
    pub number_of_vms: Option<f64>,
}
impl AppWhitelistingIssueSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type AppWhitelistingIssuesSummaries = Vec<AppWhitelistingIssueSummary>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppWhitelistingPutGroupData {
    #[serde(rename = "enforcementMode", default, skip_serializing_if = "Option::is_none")]
    pub enforcement_mode: Option<EnforcementMode>,
    #[serde(rename = "protectionMode", default, skip_serializing_if = "Option::is_none")]
    pub protection_mode: Option<ProtectionMode>,
    #[serde(rename = "vmRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub vm_recommendations: Option<VmRecommendations>,
    #[serde(rename = "pathRecommendations", default, skip_serializing_if = "Option::is_none")]
    pub path_recommendations: Option<PathRecommendations>,
}
impl AppWhitelistingPutGroupData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type AppWhitelistingResourceType = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscLocation {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AscLocationProperties>,
}
impl AscLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscLocationList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AscLocation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AscLocationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AscLocationProperties {}
impl AscLocationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AtaExternalSecuritySolution {
    #[serde(flatten)]
    pub external_security_solution: ExternalSecuritySolution,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AtaSolutionProperties>,
}
impl AtaExternalSecuritySolution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AtaSolutionProperties {
    #[serde(flatten)]
    pub external_security_solution_properties: ExternalSecuritySolutionProperties,
    #[serde(rename = "lastEventReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_event_received: Option<String>,
}
impl AtaSolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CefExternalSecuritySolution {
    #[serde(flatten)]
    pub external_security_solution: ExternalSecuritySolution,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CefSolutionProperties>,
}
impl CefExternalSecuritySolution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CefSolutionProperties {
    #[serde(flatten)]
    pub external_security_solution_properties: ExternalSecuritySolutionProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub agent: Option<String>,
    #[serde(rename = "lastEventReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_event_received: Option<String>,
}
impl CefSolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConfigurationStatus {
    Configured,
    NotConfigured,
    InProgress,
    Failed,
    NoStatus,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectableResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "inboundConnectedResources", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_connected_resources: Vec<ConnectedResource>,
    #[serde(rename = "outboundConnectedResources", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_connected_resources: Vec<ConnectedResource>,
}
impl ConnectableResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectedResource {
    #[serde(rename = "connectedResourceId", default, skip_serializing_if = "Option::is_none")]
    pub connected_resource_id: Option<String>,
    #[serde(rename = "tcpPorts", default, skip_serializing_if = "Option::is_none")]
    pub tcp_ports: Option<String>,
    #[serde(rename = "udpPorts", default, skip_serializing_if = "Option::is_none")]
    pub udp_ports: Option<String>,
}
impl ConnectedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectedWorkspace {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ConnectedWorkspace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiscoveredSecuritySolution {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    pub properties: DiscoveredSecuritySolutionProperties,
}
impl DiscoveredSecuritySolution {
    pub fn new(properties: DiscoveredSecuritySolutionProperties) -> Self {
        Self {
            resource: Resource::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiscoveredSecuritySolutionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DiscoveredSecuritySolution>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DiscoveredSecuritySolutionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DiscoveredSecuritySolutionProperties {
    #[serde(rename = "securityFamily")]
    pub security_family: discovered_security_solution_properties::SecurityFamily,
    pub offer: String,
    pub publisher: String,
    pub sku: String,
}
impl DiscoveredSecuritySolutionProperties {
    pub fn new(
        security_family: discovered_security_solution_properties::SecurityFamily,
        offer: String,
        publisher: String,
        sku: String,
    ) -> Self {
        Self {
            security_family,
            offer,
            publisher,
            sku,
        }
    }
}
pub mod discovered_security_solution_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SecurityFamily {
        Waf,
        Ngfw,
        SaasWaf,
        Va,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroups {
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<String>,
    #[serde(rename = "networkSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub network_security_groups: Vec<String>,
}
impl EffectiveNetworkSecurityGroups {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EnforcementMode {
    Audit,
    Enforce,
    None,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum EnforcementSupport {
    Supported,
    NotSupported,
    Unknown,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolution {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub external_security_solution_kind: ExternalSecuritySolutionKind,
    #[serde(flatten)]
    pub location: Location,
}
impl ExternalSecuritySolution {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolutionKind {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<external_security_solution_kind::Kind>,
}
impl ExternalSecuritySolutionKind {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod external_security_solution_kind {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "CEF")]
        Cef,
        #[serde(rename = "ATA")]
        Ata,
        #[serde(rename = "AAD")]
        Aad,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolutionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExternalSecuritySolution>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExternalSecuritySolutionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalSecuritySolutionProperties {
    #[serde(rename = "deviceVendor", default, skip_serializing_if = "Option::is_none")]
    pub device_vendor: Option<String>,
    #[serde(rename = "deviceType", default, skip_serializing_if = "Option::is_none")]
    pub device_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub workspace: Option<ConnectedWorkspace>,
}
impl ExternalSecuritySolutionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FileType {
    Exe,
    Dll,
    Msi,
    Script,
    Executable,
    Unknown,
}
pub type GroupResourceId = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JitNetworkAccessPoliciesList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JitNetworkAccessPolicy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JitNetworkAccessPoliciesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub kind: Kind,
    #[serde(flatten)]
    pub location: Location,
    pub properties: JitNetworkAccessPolicyProperties,
}
impl JitNetworkAccessPolicy {
    pub fn new(properties: JitNetworkAccessPolicyProperties) -> Self {
        Self {
            resource: Resource::default(),
            kind: Kind::default(),
            location: Location::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyInitiatePort {
    pub number: PortNumber,
    #[serde(rename = "allowedSourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub allowed_source_address_prefix: Option<String>,
    #[serde(rename = "endTimeUtc")]
    pub end_time_utc: String,
}
impl JitNetworkAccessPolicyInitiatePort {
    pub fn new(number: PortNumber, end_time_utc: String) -> Self {
        Self {
            number,
            allowed_source_address_prefix: None,
            end_time_utc,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyInitiateRequest {
    #[serde(rename = "virtualMachines")]
    pub virtual_machines: Vec<JitNetworkAccessPolicyInitiateVirtualMachine>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub justification: Option<String>,
}
impl JitNetworkAccessPolicyInitiateRequest {
    pub fn new(virtual_machines: Vec<JitNetworkAccessPolicyInitiateVirtualMachine>) -> Self {
        Self {
            virtual_machines,
            justification: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyInitiateVirtualMachine {
    pub id: String,
    pub ports: Vec<JitNetworkAccessPolicyInitiatePort>,
}
impl JitNetworkAccessPolicyInitiateVirtualMachine {
    pub fn new(id: String, ports: Vec<JitNetworkAccessPolicyInitiatePort>) -> Self {
        Self { id, ports }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyProperties {
    #[serde(rename = "virtualMachines")]
    pub virtual_machines: Vec<JitNetworkAccessPolicyVirtualMachine>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub requests: Vec<JitNetworkAccessRequest>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl JitNetworkAccessPolicyProperties {
    pub fn new(virtual_machines: Vec<JitNetworkAccessPolicyVirtualMachine>) -> Self {
        Self {
            virtual_machines,
            requests: Vec::new(),
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPolicyVirtualMachine {
    pub id: String,
    pub ports: Vec<JitNetworkAccessPortRule>,
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
}
impl JitNetworkAccessPolicyVirtualMachine {
    pub fn new(id: String, ports: Vec<JitNetworkAccessPortRule>) -> Self {
        Self {
            id,
            ports,
            public_ip_address: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessPortRule {
    pub number: PortNumber,
    pub protocol: jit_network_access_port_rule::Protocol,
    #[serde(rename = "allowedSourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub allowed_source_address_prefix: Option<String>,
    #[serde(rename = "allowedSourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_source_address_prefixes: Vec<String>,
    #[serde(rename = "maxRequestAccessDuration")]
    pub max_request_access_duration: String,
}
impl JitNetworkAccessPortRule {
    pub fn new(number: PortNumber, protocol: jit_network_access_port_rule::Protocol, max_request_access_duration: String) -> Self {
        Self {
            number,
            protocol,
            allowed_source_address_prefix: None,
            allowed_source_address_prefixes: Vec::new(),
            max_request_access_duration,
        }
    }
}
pub mod jit_network_access_port_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
        #[serde(rename = "*")]
        U2a,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessRequest {
    #[serde(rename = "virtualMachines")]
    pub virtual_machines: Vec<JitNetworkAccessRequestVirtualMachine>,
    #[serde(rename = "startTimeUtc")]
    pub start_time_utc: String,
    pub requestor: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub justification: Option<String>,
}
impl JitNetworkAccessRequest {
    pub fn new(virtual_machines: Vec<JitNetworkAccessRequestVirtualMachine>, start_time_utc: String, requestor: String) -> Self {
        Self {
            virtual_machines,
            start_time_utc,
            requestor,
            justification: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessRequestPort {
    pub number: PortNumber,
    #[serde(rename = "allowedSourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub allowed_source_address_prefix: Option<String>,
    #[serde(rename = "allowedSourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_source_address_prefixes: Vec<String>,
    #[serde(rename = "endTimeUtc")]
    pub end_time_utc: String,
    pub status: jit_network_access_request_port::Status,
    #[serde(rename = "statusReason")]
    pub status_reason: jit_network_access_request_port::StatusReason,
    #[serde(rename = "mappedPort", default, skip_serializing_if = "Option::is_none")]
    pub mapped_port: Option<i64>,
}
impl JitNetworkAccessRequestPort {
    pub fn new(
        number: PortNumber,
        end_time_utc: String,
        status: jit_network_access_request_port::Status,
        status_reason: jit_network_access_request_port::StatusReason,
    ) -> Self {
        Self {
            number,
            allowed_source_address_prefix: None,
            allowed_source_address_prefixes: Vec::new(),
            end_time_utc,
            status,
            status_reason,
            mapped_port: None,
        }
    }
}
pub mod jit_network_access_request_port {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Revoked,
        Initiated,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StatusReason {
        Expired,
        UserRequested,
        NewerRequestInitiated,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JitNetworkAccessRequestVirtualMachine {
    pub id: String,
    pub ports: Vec<JitNetworkAccessRequestPort>,
}
impl JitNetworkAccessRequestVirtualMachine {
    pub fn new(id: String, ports: Vec<JitNetworkAccessRequestPort>) -> Self {
        Self { id, ports }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Kind {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl Kind {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Location {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl Location {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationDisplay>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PathRecommendation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<RecommendationAction>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<RecommendationType>,
    #[serde(rename = "publisherInfo", default, skip_serializing_if = "Option::is_none")]
    pub publisher_info: Option<PublisherInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub common: Option<bool>,
    #[serde(rename = "userSids", default, skip_serializing_if = "Vec::is_empty")]
    pub user_sids: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub usernames: Vec<UserRecommendation>,
    #[serde(rename = "fileType", default, skip_serializing_if = "Option::is_none")]
    pub file_type: Option<FileType>,
    #[serde(rename = "configurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub configuration_status: Option<ConfigurationStatus>,
}
impl PathRecommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type PathRecommendations = Vec<PathRecommendation>;
pub type PortNumber = i64;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionMode {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub exe: Option<EnforcementMode>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub msi: Option<EnforcementMode>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<EnforcementMode>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub executable: Option<EnforcementMode>,
}
impl ProtectionMode {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublisherInfo {
    #[serde(rename = "publisherName", default, skip_serializing_if = "Option::is_none")]
    pub publisher_name: Option<String>,
    #[serde(rename = "productName", default, skip_serializing_if = "Option::is_none")]
    pub product_name: Option<String>,
    #[serde(rename = "binaryName", default, skip_serializing_if = "Option::is_none")]
    pub binary_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl PublisherInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecommendationAction {
    Recommended,
    Add,
    Remove,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecommendationStatus {
    Recommended,
    NotRecommended,
    NotAvailable,
    NoStatus,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecommendationType {
    File,
    FileHash,
    PublisherSignature,
    ProductSignature,
    BinarySignature,
    VersionAndAboveSignature,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Rule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<rule::Direction>,
    #[serde(rename = "destinationPort", default, skip_serializing_if = "Option::is_none")]
    pub destination_port: Option<PortNumber>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<String>,
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
}
impl Rule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityTask {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityTaskProperties>,
}
impl SecurityTask {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityTaskList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityTask>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityTaskList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityTaskParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl SecurityTaskParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityTaskProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "creationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub creation_time_utc: Option<String>,
    #[serde(rename = "securityTaskParameters", default, skip_serializing_if = "Option::is_none")]
    pub security_task_parameters: Option<SecurityTaskParameters>,
    #[serde(rename = "lastStateChangeTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_state_change_time_utc: Option<String>,
    #[serde(rename = "subState", default, skip_serializing_if = "Option::is_none")]
    pub sub_state: Option<String>,
}
impl SecurityTaskProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SourceSystem {
    #[serde(rename = "Azure_AppLocker")]
    AzureAppLocker,
    #[serde(rename = "Azure_AuditD")]
    AzureAuditD,
    #[serde(rename = "NonAzure_AppLocker")]
    NonAzureAppLocker,
    #[serde(rename = "NonAzure_AuditD")]
    NonAzureAuditD,
    None,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TopologyResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TopologyList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(flatten)]
    pub location: Location,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TopologyResourceProperties>,
}
impl TopologyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyResourceProperties {
    #[serde(rename = "calculatedDateTime", default, skip_serializing_if = "Option::is_none")]
    pub calculated_date_time: Option<String>,
    #[serde(rename = "topologyResources", default, skip_serializing_if = "Vec::is_empty")]
    pub topology_resources: Vec<TopologySingleResource>,
}
impl TopologyResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologySingleResource {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
    #[serde(rename = "recommendationsExist", default, skip_serializing_if = "Option::is_none")]
    pub recommendations_exist: Option<bool>,
    #[serde(rename = "networkZones", default, skip_serializing_if = "Option::is_none")]
    pub network_zones: Option<String>,
    #[serde(rename = "topologyScore", default, skip_serializing_if = "Option::is_none")]
    pub topology_score: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parents: Vec<TopologySingleResourceParent>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub children: Vec<TopologySingleResourceChild>,
}
impl TopologySingleResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologySingleResourceChild {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl TopologySingleResourceChild {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologySingleResourceParent {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl TopologySingleResourceParent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserRecommendation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(rename = "recommendationAction", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_action: Option<RecommendationAction>,
}
impl UserRecommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmRecommendation {
    #[serde(rename = "configurationStatus", default, skip_serializing_if = "Option::is_none")]
    pub configuration_status: Option<ConfigurationStatus>,
    #[serde(rename = "recommendationAction", default, skip_serializing_if = "Option::is_none")]
    pub recommendation_action: Option<RecommendationAction>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<VmResourceId>,
    #[serde(rename = "enforcementSupport", default, skip_serializing_if = "Option::is_none")]
    pub enforcement_support: Option<EnforcementSupport>,
}
impl VmRecommendation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type VmRecommendations = Vec<VmRecommendation>;
pub type VmResourceId = String;
