#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BasicAuthentication {
    #[serde(flatten)]
    pub http_authentication: HttpAuthentication,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl BasicAuthentication {
    pub fn new(http_authentication: HttpAuthentication) -> Self {
        Self {
            http_authentication,
            username: None,
            password: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ClientCertAuthentication {
    #[serde(flatten)]
    pub http_authentication: HttpAuthentication,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pfx: Option<String>,
    #[serde(rename = "certificateThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub certificate_thumbprint: Option<String>,
    #[serde(rename = "certificateExpirationDate", default, skip_serializing_if = "Option::is_none")]
    pub certificate_expiration_date: Option<String>,
    #[serde(rename = "certificateSubjectName", default, skip_serializing_if = "Option::is_none")]
    pub certificate_subject_name: Option<String>,
}
impl ClientCertAuthentication {
    pub fn new(http_authentication: HttpAuthentication) -> Self {
        Self {
            http_authentication,
            password: None,
            pfx: None,
            certificate_thumbprint: None,
            certificate_expiration_date: None,
            certificate_subject_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpAuthentication {
    #[serde(rename = "type")]
    pub type_: http_authentication::Type,
}
impl HttpAuthentication {
    pub fn new(type_: http_authentication::Type) -> Self {
        Self { type_ }
    }
}
pub mod http_authentication {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        NotSpecified,
        ClientCertificate,
        ActiveDirectoryOAuth,
        Basic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<HttpAuthentication>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
}
impl HttpRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobAction {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<job_action::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub request: Option<HttpRequest>,
    #[serde(rename = "queueMessage", default, skip_serializing_if = "Option::is_none")]
    pub queue_message: Option<StorageQueueMessage>,
    #[serde(rename = "serviceBusQueueMessage", default, skip_serializing_if = "Option::is_none")]
    pub service_bus_queue_message: Option<ServiceBusQueueMessage>,
    #[serde(rename = "serviceBusTopicMessage", default, skip_serializing_if = "Option::is_none")]
    pub service_bus_topic_message: Option<ServiceBusTopicMessage>,
    #[serde(rename = "retryPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retry_policy: Option<RetryPolicy>,
    #[serde(rename = "errorAction", default, skip_serializing_if = "Option::is_none")]
    pub error_action: Option<JobErrorAction>,
}
impl JobAction {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_action {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Http,
        Https,
        StorageQueue,
        ServiceBusQueue,
        ServiceBusTopic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobCollectionDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobCollectionProperties>,
}
impl JobCollectionDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobCollectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobCollectionDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobCollectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobCollectionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<job_collection_properties::State>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quota: Option<JobCollectionQuota>,
}
impl JobCollectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_collection_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Enabled,
        Disabled,
        Suspended,
        Deleted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobCollectionQuota {
    #[serde(rename = "maxJobCount", default, skip_serializing_if = "Option::is_none")]
    pub max_job_count: Option<i64>,
    #[serde(rename = "maxJobOccurrence", default, skip_serializing_if = "Option::is_none")]
    pub max_job_occurrence: Option<i64>,
    #[serde(rename = "maxRecurrence", default, skip_serializing_if = "Option::is_none")]
    pub max_recurrence: Option<JobMaxRecurrence>,
}
impl JobCollectionQuota {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobProperties>,
}
impl JobDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobErrorAction {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<job_error_action::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub request: Option<HttpRequest>,
    #[serde(rename = "queueMessage", default, skip_serializing_if = "Option::is_none")]
    pub queue_message: Option<StorageQueueMessage>,
    #[serde(rename = "serviceBusQueueMessage", default, skip_serializing_if = "Option::is_none")]
    pub service_bus_queue_message: Option<ServiceBusQueueMessage>,
    #[serde(rename = "serviceBusTopicMessage", default, skip_serializing_if = "Option::is_none")]
    pub service_bus_topic_message: Option<ServiceBusTopicMessage>,
    #[serde(rename = "retryPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retry_policy: Option<RetryPolicy>,
}
impl JobErrorAction {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_error_action {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Http,
        Https,
        StorageQueue,
        ServiceBusQueue,
        ServiceBusTopic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JobExecutionStatus {
    Completed,
    Failed,
    Postponed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobHistoryDefinition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobHistoryDefinitionProperties>,
}
impl JobHistoryDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobHistoryDefinitionProperties {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "expectedExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub expected_execution_time: Option<String>,
    #[serde(rename = "actionName", default, skip_serializing_if = "Option::is_none")]
    pub action_name: Option<job_history_definition_properties::ActionName>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<JobExecutionStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "retryCount", default, skip_serializing_if = "Option::is_none")]
    pub retry_count: Option<i64>,
    #[serde(rename = "repeatCount", default, skip_serializing_if = "Option::is_none")]
    pub repeat_count: Option<i64>,
}
impl JobHistoryDefinitionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_history_definition_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActionName {
        MainAction,
        ErrorAction,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobHistoryFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<JobExecutionStatus>,
}
impl JobHistoryFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobHistoryListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobHistoryDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobHistoryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobMaxRecurrence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<job_max_recurrence::Frequency>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i64>,
}
impl JobMaxRecurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_max_recurrence {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Frequency {
        Minute,
        Hour,
        Day,
        Week,
        Month,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobProperties {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<JobAction>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recurrence: Option<JobRecurrence>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<JobState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<JobStatus>,
}
impl JobProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobRecurrence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<job_recurrence::Frequency>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<JobRecurrenceSchedule>,
}
impl JobRecurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_recurrence {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Frequency {
        Minute,
        Hour,
        Day,
        Week,
        Month,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobRecurrenceSchedule {
    #[serde(rename = "weekDays", default, skip_serializing_if = "Vec::is_empty")]
    pub week_days: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hours: Vec<i64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub minutes: Vec<i64>,
    #[serde(rename = "monthDays", default, skip_serializing_if = "Vec::is_empty")]
    pub month_days: Vec<i64>,
    #[serde(rename = "monthlyOccurrences", default, skip_serializing_if = "Vec::is_empty")]
    pub monthly_occurrences: Vec<JobRecurrenceScheduleMonthlyOccurrence>,
}
impl JobRecurrenceSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobRecurrenceScheduleMonthlyOccurrence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub day: Option<job_recurrence_schedule_monthly_occurrence::Day>,
    #[serde(rename = "Occurrence", default, skip_serializing_if = "Option::is_none")]
    pub occurrence: Option<i64>,
}
impl JobRecurrenceScheduleMonthlyOccurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_recurrence_schedule_monthly_occurrence {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Day {
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday,
        Sunday,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JobState {
    Enabled,
    Disabled,
    Faulted,
    Completed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobStateFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<JobState>,
}
impl JobStateFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobStatus {
    #[serde(rename = "executionCount", default, skip_serializing_if = "Option::is_none")]
    pub execution_count: Option<i64>,
    #[serde(rename = "failureCount", default, skip_serializing_if = "Option::is_none")]
    pub failure_count: Option<i64>,
    #[serde(rename = "faultedCount", default, skip_serializing_if = "Option::is_none")]
    pub faulted_count: Option<i64>,
    #[serde(rename = "lastExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub last_execution_time: Option<String>,
    #[serde(rename = "nextExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub next_execution_time: Option<String>,
}
impl JobStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OAuthAuthentication {
    #[serde(flatten)]
    pub http_authentication: HttpAuthentication,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secret: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub audience: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
}
impl OAuthAuthentication {
    pub fn new(http_authentication: HttpAuthentication) -> Self {
        Self {
            http_authentication,
            secret: None,
            tenant: None,
            audience: None,
            client_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecurrenceFrequency {
    Minute,
    Hour,
    Day,
    Week,
    Month,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetryPolicy {
    #[serde(rename = "retryType", default, skip_serializing_if = "Option::is_none")]
    pub retry_type: Option<retry_policy::RetryType>,
    #[serde(rename = "retryInterval", default, skip_serializing_if = "Option::is_none")]
    pub retry_interval: Option<String>,
    #[serde(rename = "retryCount", default, skip_serializing_if = "Option::is_none")]
    pub retry_count: Option<i64>,
}
impl RetryPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod retry_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RetryType {
        None,
        Fixed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusAuthentication {
    #[serde(rename = "sasKey", default, skip_serializing_if = "Option::is_none")]
    pub sas_key: Option<String>,
    #[serde(rename = "sasKeyName", default, skip_serializing_if = "Option::is_none")]
    pub sas_key_name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<service_bus_authentication::Type>,
}
impl ServiceBusAuthentication {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod service_bus_authentication {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        NotSpecified,
        SharedAccessKey,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusBrokeredMessageProperties {
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "forcePersistence", default, skip_serializing_if = "Option::is_none")]
    pub force_persistence: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub label: Option<String>,
    #[serde(rename = "messageId", default, skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    #[serde(rename = "partitionKey", default, skip_serializing_if = "Option::is_none")]
    pub partition_key: Option<String>,
    #[serde(rename = "replyTo", default, skip_serializing_if = "Option::is_none")]
    pub reply_to: Option<String>,
    #[serde(rename = "replyToSessionId", default, skip_serializing_if = "Option::is_none")]
    pub reply_to_session_id: Option<String>,
    #[serde(rename = "scheduledEnqueueTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub scheduled_enqueue_time_utc: Option<String>,
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[serde(rename = "timeToLive", default, skip_serializing_if = "Option::is_none")]
    pub time_to_live: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub to: Option<String>,
    #[serde(rename = "viaPartitionKey", default, skip_serializing_if = "Option::is_none")]
    pub via_partition_key: Option<String>,
}
impl ServiceBusBrokeredMessageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusMessage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<ServiceBusAuthentication>,
    #[serde(rename = "brokeredMessageProperties", default, skip_serializing_if = "Option::is_none")]
    pub brokered_message_properties: Option<ServiceBusBrokeredMessageProperties>,
    #[serde(rename = "customMessageProperties", default, skip_serializing_if = "Option::is_none")]
    pub custom_message_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespace: Option<String>,
    #[serde(rename = "transportType", default, skip_serializing_if = "Option::is_none")]
    pub transport_type: Option<service_bus_message::TransportType>,
}
impl ServiceBusMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod service_bus_message {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TransportType {
        NotSpecified,
        NetMessaging,
        #[serde(rename = "AMQP")]
        Amqp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusQueueMessage {
    #[serde(flatten)]
    pub service_bus_message: ServiceBusMessage,
    #[serde(rename = "queueName", default, skip_serializing_if = "Option::is_none")]
    pub queue_name: Option<String>,
}
impl ServiceBusQueueMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusTopicMessage {
    #[serde(flatten)]
    pub service_bus_message: ServiceBusMessage,
    #[serde(rename = "topicPath", default, skip_serializing_if = "Option::is_none")]
    pub topic_path: Option<String>,
}
impl ServiceBusTopicMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<sku::Name>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Standard,
        Free,
        P10Premium,
        P20Premium,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageQueueMessage {
    #[serde(rename = "storageAccount", default, skip_serializing_if = "Option::is_none")]
    pub storage_account: Option<String>,
    #[serde(rename = "queueName", default, skip_serializing_if = "Option::is_none")]
    pub queue_name: Option<String>,
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl StorageQueueMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
