#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "List of management locks."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementLockListResult {
    #[doc = "The list of locks."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ManagementLockObject>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ManagementLockListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Management lock information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementLockObject {
    #[doc = "The management lock properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ManagementLockProperties>,
    #[doc = "The Id of the lock."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The type of the lock."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The name of the lock."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl ManagementLockObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The management lock properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagementLockProperties {
    #[doc = "The lock level of the management lock."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<management_lock_properties::Level>,
    #[doc = "The notes of the management lock."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
}
impl ManagementLockProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod management_lock_properties {
    use super::*;
    #[doc = "The lock level of the management lock."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Level {
        NotSpecified,
        CanNotDelete,
        ReadOnly,
    }
}
