#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureCliScript {
    #[serde(flatten)]
    pub deployment_script: DeploymentScript,
    pub properties: AzureCliScriptProperties,
}
impl AzureCliScript {
    pub fn new(deployment_script: DeploymentScript, properties: AzureCliScriptProperties) -> Self {
        Self {
            deployment_script,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureCliScriptProperties {
    #[serde(flatten)]
    pub deployment_script_properties_base: DeploymentScriptPropertiesBase,
    #[serde(flatten)]
    pub script_configuration_base: ScriptConfigurationBase,
    #[serde(rename = "azCliVersion")]
    pub az_cli_version: String,
}
impl AzureCliScriptProperties {
    pub fn new(script_configuration_base: ScriptConfigurationBase, az_cli_version: String) -> Self {
        Self {
            deployment_script_properties_base: DeploymentScriptPropertiesBase::default(),
            script_configuration_base,
            az_cli_version,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePowerShellScript {
    #[serde(flatten)]
    pub deployment_script: DeploymentScript,
    pub properties: AzurePowerShellScriptProperties,
}
impl AzurePowerShellScript {
    pub fn new(deployment_script: DeploymentScript, properties: AzurePowerShellScriptProperties) -> Self {
        Self {
            deployment_script,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePowerShellScriptProperties {
    #[serde(flatten)]
    pub deployment_script_properties_base: DeploymentScriptPropertiesBase,
    #[serde(flatten)]
    pub script_configuration_base: ScriptConfigurationBase,
    #[serde(rename = "azPowerShellVersion")]
    pub az_power_shell_version: String,
}
impl AzurePowerShellScriptProperties {
    pub fn new(script_configuration_base: ScriptConfigurationBase, az_power_shell_version: String) -> Self {
        Self {
            deployment_script_properties_base: DeploymentScriptPropertiesBase::default(),
            script_configuration_base,
            az_power_shell_version,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResourceBase {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl AzureResourceBase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerConfiguration {
    #[serde(rename = "containerGroupName", default, skip_serializing_if = "Option::is_none")]
    pub container_group_name: Option<String>,
}
impl ContainerConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeploymentScript {
    #[serde(flatten)]
    pub azure_resource_base: AzureResourceBase,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
    pub location: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    pub kind: deployment_script::Kind,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl DeploymentScript {
    pub fn new(location: String, kind: deployment_script::Kind) -> Self {
        Self {
            azure_resource_base: AzureResourceBase::default(),
            identity: None,
            location,
            tags: None,
            kind,
            system_data: None,
        }
    }
}
pub mod deployment_script {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        AzurePowerShell,
        #[serde(rename = "AzureCLI")]
        AzureCli,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentScriptListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DeploymentScript>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DeploymentScriptListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentScriptPropertiesBase {
    #[serde(rename = "containerSettings", default, skip_serializing_if = "Option::is_none")]
    pub container_settings: Option<ContainerConfiguration>,
    #[serde(rename = "storageAccountSettings", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_settings: Option<StorageAccountConfiguration>,
    #[serde(rename = "cleanupPreference", default, skip_serializing_if = "Option::is_none")]
    pub cleanup_preference: Option<deployment_script_properties_base::CleanupPreference>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<deployment_script_properties_base::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<ScriptStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub outputs: Option<serde_json::Value>,
}
impl DeploymentScriptPropertiesBase {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod deployment_script_properties_base {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CleanupPreference {
        Always,
        OnSuccess,
        OnExpiration,
    }
    impl Default for CleanupPreference {
        fn default() -> Self {
            Self::Always
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Creating,
        ProvisioningResources,
        Running,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentScriptUpdateParameter {
    #[serde(flatten)]
    pub azure_resource_base: AzureResourceBase,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl DeploymentScriptUpdateParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeploymentScriptsError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl DeploymentScriptsError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentVariable {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "secureValue", default, skip_serializing_if = "Option::is_none")]
    pub secure_value: Option<String>,
}
impl EnvironmentVariable {
    pub fn new(name: String) -> Self {
        Self {
            name,
            value: None,
            secure_value: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorResponse>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub log: Option<String>,
}
impl LogProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedServiceIdentity {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<managed_service_identity::Type>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl ManagedServiceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_service_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        UserAssigned,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScriptConfigurationBase {
    #[serde(rename = "primaryScriptUri", default, skip_serializing_if = "Option::is_none")]
    pub primary_script_uri: Option<String>,
    #[serde(rename = "supportingScriptUris", default, skip_serializing_if = "Vec::is_empty")]
    pub supporting_script_uris: Vec<String>,
    #[serde(rename = "scriptContent", default, skip_serializing_if = "Option::is_none")]
    pub script_content: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub arguments: Option<String>,
    #[serde(rename = "environmentVariables", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_variables: Vec<EnvironmentVariable>,
    #[serde(rename = "forceUpdateTag", default, skip_serializing_if = "Option::is_none")]
    pub force_update_tag: Option<String>,
    #[serde(rename = "retentionInterval")]
    pub retention_interval: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
}
impl ScriptConfigurationBase {
    pub fn new(retention_interval: String) -> Self {
        Self {
            primary_script_uri: None,
            supporting_script_uris: Vec::new(),
            script_content: None,
            arguments: None,
            environment_variables: Vec::new(),
            force_update_tag: None,
            retention_interval,
            timeout: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScriptLog {
    #[serde(flatten)]
    pub azure_resource_base: AzureResourceBase,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LogProperties>,
}
impl ScriptLog {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScriptLogsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ScriptLog>,
}
impl ScriptLogsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScriptStatus {
    #[serde(rename = "containerInstanceId", default, skip_serializing_if = "Option::is_none")]
    pub container_instance_id: Option<String>,
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "expirationTime", default, skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl ScriptStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageAccountConfiguration {
    #[serde(rename = "storageAccountName", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_name: Option<String>,
    #[serde(rename = "storageAccountKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_key: Option<String>,
}
impl StorageAccountConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserAssignedIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
}
impl UserAssignedIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
