#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Parameters for Redis export operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportRdbParameters {
    #[doc = "File format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<String>,
    #[doc = "Prefix to use for exported files."]
    pub prefix: String,
    #[doc = "Container name to export to."]
    pub container: String,
}
impl ExportRdbParameters {
    pub fn new(prefix: String, container: String) -> Self {
        Self {
            format: None,
            prefix,
            container,
        }
    }
}
#[doc = "Parameters for Redis import operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportRdbParameters {
    #[doc = "File format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<String>,
    #[doc = "files to import."]
    pub files: Vec<String>,
}
impl ImportRdbParameters {
    pub fn new(files: Vec<String>) -> Self {
        Self { format: None, files }
    }
}
#[doc = "REST API operation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The object that describes the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "The object that describes the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Friendly name of the resource provider"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Operation type: read, write, delete, listKeys/action, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "Resource type on which the operation is performed."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Friendly name of the operation"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of operations supported by the resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Redis cache access keys."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisAccessKeys {
    #[doc = "The current primary key that clients can use to authenticate with Redis cache."]
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[doc = "The current secondary key that clients can use to authenticate with Redis cache."]
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
}
impl RedisAccessKeys {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters supplied to the Create Redis operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedisCreateParameters {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties supplied to Create Redis operation."]
    pub properties: RedisCreateProperties,
}
impl RedisCreateParameters {
    pub fn new(resource: Resource, properties: RedisCreateProperties) -> Self {
        Self { resource, properties }
    }
}
#[doc = "Properties supplied to Create Redis operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedisCreateProperties {
    #[serde(flatten)]
    pub redis_properties: RedisProperties,
    #[doc = "SKU parameters supplied to the create Redis operation."]
    pub sku: Sku,
}
impl RedisCreateProperties {
    pub fn new(sku: Sku) -> Self {
        Self {
            redis_properties: RedisProperties::default(),
            sku,
        }
    }
}
#[doc = "A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedisFirewallRule {
    #[doc = "resource ID (of the firewall rule)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "name of the firewall rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "type (of the firewall rule resource = 'Microsoft.Cache/redis/firewallRule')"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Specifies a range of IP addresses permitted to connect to the cache"]
    pub properties: RedisFirewallRuleProperties,
}
impl RedisFirewallRule {
    pub fn new(properties: RedisFirewallRuleProperties) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            properties,
        }
    }
}
#[doc = "The response of list firewall rules Redis operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedisFirewallRuleListResult {
    #[doc = "Results of the list firewall rules operation."]
    pub value: Vec<RedisFirewallRule>,
    #[doc = "Link for next set of locations."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RedisFirewallRuleListResult {
    pub fn new(value: Vec<RedisFirewallRule>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Specifies a range of IP addresses permitted to connect to the cache"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedisFirewallRuleProperties {
    #[doc = "lowest IP address included in the range"]
    #[serde(rename = "startIP")]
    pub start_ip: String,
    #[doc = "highest IP address included in the range"]
    #[serde(rename = "endIP")]
    pub end_ip: String,
}
impl RedisFirewallRuleProperties {
    pub fn new(start_ip: String, end_ip: String) -> Self {
        Self { start_ip, end_ip }
    }
}
#[doc = "Response to force reboot for Redis cache."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisForceRebootResponse {
    #[doc = "Status message"]
    #[serde(rename = "Message", default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl RedisForceRebootResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response of list Redis operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisListResult {
    #[doc = "List of Redis cache instances."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RedisResource>,
    #[doc = "Link for next set of locations."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RedisListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response to put/get patch schedules for Redis cache."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedisPatchSchedule {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "List of patch schedules for a Redis cache."]
    pub properties: ScheduleEntries,
}
impl RedisPatchSchedule {
    pub fn new(properties: ScheduleEntries) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location: None,
            properties,
        }
    }
}
#[doc = "Properties supplied to Create or Update Redis operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisProperties {
    #[doc = "All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc."]
    #[serde(rename = "redisConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub redis_configuration: Option<serde_json::Value>,
    #[doc = "Specifies whether the non-ssl Redis server port (6379) is enabled."]
    #[serde(rename = "enableNonSslPort", default, skip_serializing_if = "Option::is_none")]
    pub enable_non_ssl_port: Option<bool>,
    #[doc = "tenantSettings"]
    #[serde(rename = "tenantSettings", default, skip_serializing_if = "Option::is_none")]
    pub tenant_settings: Option<serde_json::Value>,
    #[doc = "The number of shards to be created on a Premium Cluster Cache."]
    #[serde(rename = "shardCount", default, skip_serializing_if = "Option::is_none")]
    pub shard_count: Option<i32>,
    #[doc = "The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1"]
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[doc = "Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network."]
    #[serde(rename = "staticIP", default, skip_serializing_if = "Option::is_none")]
    pub static_ip: Option<String>,
}
impl RedisProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies which Redis node(s) to reboot."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedisRebootParameters {
    #[doc = "Which Redis node(s) to reboot. Depending on this value data loss is possible."]
    #[serde(rename = "rebootType")]
    pub reboot_type: redis_reboot_parameters::RebootType,
    #[doc = "If clustering is enabled, the ID of the shard to be rebooted."]
    #[serde(rename = "shardId", default, skip_serializing_if = "Option::is_none")]
    pub shard_id: Option<i32>,
}
impl RedisRebootParameters {
    pub fn new(reboot_type: redis_reboot_parameters::RebootType) -> Self {
        Self {
            reboot_type,
            shard_id: None,
        }
    }
}
pub mod redis_reboot_parameters {
    use super::*;
    #[doc = "Which Redis node(s) to reboot. Depending on this value data loss is possible."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RebootType {
        PrimaryNode,
        SecondaryNode,
        AllNodes,
    }
}
#[doc = "Specifies which Redis access keys to reset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedisRegenerateKeyParameters {
    #[doc = "The Redis access key to regenerate."]
    #[serde(rename = "keyType")]
    pub key_type: redis_regenerate_key_parameters::KeyType,
}
impl RedisRegenerateKeyParameters {
    pub fn new(key_type: redis_regenerate_key_parameters::KeyType) -> Self {
        Self { key_type }
    }
}
pub mod redis_regenerate_key_parameters {
    use super::*;
    #[doc = "The Redis access key to regenerate."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum KeyType {
        Primary,
        Secondary,
    }
}
#[doc = "A single Redis item in List or Get Operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedisResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Parameters describing a Redis instance."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RedisResourceProperties>,
}
impl RedisResource {
    pub fn new(resource: Resource) -> Self {
        Self {
            resource,
            properties: None,
        }
    }
}
#[doc = "Parameters describing a Redis instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisResourceProperties {
    #[serde(flatten)]
    pub redis_properties: RedisProperties,
    #[doc = "SKU parameters supplied to the create Redis operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Redis version."]
    #[serde(rename = "redisVersion", default, skip_serializing_if = "Option::is_none")]
    pub redis_version: Option<String>,
    #[doc = "Redis instance provisioning status."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Redis host name."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[doc = "Redis non-SSL port."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "Redis SSL port."]
    #[serde(rename = "sslPort", default, skip_serializing_if = "Option::is_none")]
    pub ssl_port: Option<i32>,
    #[doc = "Redis cache access keys."]
    #[serde(rename = "accessKeys", default, skip_serializing_if = "Option::is_none")]
    pub access_keys: Option<RedisAccessKeys>,
}
impl RedisResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters supplied to the Update Redis operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisUpdateParameters {
    #[doc = "Properties supplied to Update Redis operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RedisUpdateProperties>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl RedisUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties supplied to Update Redis operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisUpdateProperties {
    #[serde(flatten)]
    pub redis_properties: RedisProperties,
    #[doc = "SKU parameters supplied to the create Redis operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
}
impl RedisUpdateProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Resource definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location."]
    pub location: String,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[doc = "List of patch schedules for a Redis cache."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduleEntries {
    #[doc = "List of patch schedules for a Redis cache."]
    #[serde(rename = "scheduleEntries")]
    pub schedule_entries: Vec<ScheduleEntry>,
}
impl ScheduleEntries {
    pub fn new(schedule_entries: Vec<ScheduleEntry>) -> Self {
        Self { schedule_entries }
    }
}
#[doc = "Patch schedule entry for a Premium Redis Cache."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduleEntry {
    #[doc = "Day of the week when a cache can be patched."]
    #[serde(rename = "dayOfWeek")]
    pub day_of_week: schedule_entry::DayOfWeek,
    #[doc = "Start hour after which cache patching can start."]
    #[serde(rename = "startHourUtc")]
    pub start_hour_utc: i32,
    #[doc = "ISO8601 timespan specifying how much time cache patching can take. "]
    #[serde(rename = "maintenanceWindow", default, skip_serializing_if = "Option::is_none")]
    pub maintenance_window: Option<String>,
}
impl ScheduleEntry {
    pub fn new(day_of_week: schedule_entry::DayOfWeek, start_hour_utc: i32) -> Self {
        Self {
            day_of_week,
            start_hour_utc,
            maintenance_window: None,
        }
    }
}
pub mod schedule_entry {
    use super::*;
    #[doc = "Day of the week when a cache can be patched."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DayOfWeek {
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday,
        Sunday,
        Everyday,
        Weekend,
    }
}
#[doc = "SKU parameters supplied to the create Redis operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Sku {
    #[doc = "The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)"]
    pub name: sku::Name,
    #[doc = "The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium)."]
    pub family: sku::Family,
    #[doc = "The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4)."]
    pub capacity: i32,
}
impl Sku {
    pub fn new(name: sku::Name, family: sku::Family, capacity: i32) -> Self {
        Self { name, family, capacity }
    }
}
pub mod sku {
    use super::*;
    #[doc = "The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
        Premium,
    }
    #[doc = "The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Family {
        C,
        P,
    }
}
