#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "ApplyRecoveryPoint input specific to A2A provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aApplyRecoveryPointInput {
    #[serde(flatten)]
    pub apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput,
}
impl A2aApplyRecoveryPointInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A cloud creation input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aContainerCreationInput {
    #[serde(flatten)]
    pub replication_provider_specific_container_creation_input: ReplicationProviderSpecificContainerCreationInput,
}
impl A2aContainerCreationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A container mapping input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aContainerMappingInput {
    #[serde(flatten)]
    pub replication_provider_specific_container_mapping_input: ReplicationProviderSpecificContainerMappingInput,
    #[doc = "A value indicating whether the auto update is enabled."]
    #[serde(rename = "agentAutoUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_auto_update_status: Option<a2a_container_mapping_input::AgentAutoUpdateStatus>,
    #[doc = "The automation account arm id."]
    #[serde(rename = "automationAccountArmId", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_arm_id: Option<String>,
}
impl A2aContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod a2a_container_mapping_input {
    use super::*;
    #[doc = "A value indicating whether the auto update is enabled."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AgentAutoUpdateStatus {
        Disabled,
        Enabled,
    }
}
#[doc = "A2A enable protection input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aEnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[doc = "The fabric specific object Id of the virtual machine."]
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[doc = "The recovery container Id."]
    #[serde(rename = "recoveryContainerId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_container_id: Option<String>,
    #[doc = "The recovery resource group Id. Valid for V2 scenarios."]
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[doc = "The recovery cloud service Id. Valid for V1 scenarios."]
    #[serde(rename = "recoveryCloudServiceId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service_id: Option<String>,
    #[doc = "The recovery availability set Id."]
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[doc = "The list of vm disk details."]
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<A2aVmDiskInputDetails>,
    #[doc = "The list of vm managed disk details."]
    #[serde(rename = "vmManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_managed_disks: Vec<A2aVmManagedDiskInputDetails>,
    #[doc = "The multi vm group name."]
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[doc = "The boot diagnostic storage account."]
    #[serde(rename = "recoveryBootDiagStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account_id: Option<String>,
    #[doc = "Recovery disk encryption info (BEK and KEK)."]
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
}
impl A2aEnableProtectionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Model class for event details of a A2A event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[doc = "The protected item arm name."]
    #[serde(rename = "protectedItemName", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_name: Option<String>,
    #[doc = "The azure vm arm id."]
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[doc = "Fabric arm name."]
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[doc = "The fabric location."]
    #[serde(rename = "fabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub fabric_location: Option<String>,
    #[doc = "Remote fabric arm name."]
    #[serde(rename = "remoteFabricName", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_name: Option<String>,
    #[doc = "Remote fabric location."]
    #[serde(rename = "remoteFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_location: Option<String>,
}
impl A2aEventDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A provider specific input for failover."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aFailoverProviderInput {
    #[serde(flatten)]
    pub provider_specific_failover_input: ProviderSpecificFailoverInput,
    #[doc = "The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed."]
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[doc = "A value indicating whether to use recovery cloud service for TFO or not."]
    #[serde(rename = "cloudServiceCreationOption", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_creation_option: Option<String>,
}
impl A2aFailoverProviderInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A Policy creation input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aPolicyCreationInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[doc = "The crash consistent snapshot frequency (in minutes)."]
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "The app consistent snapshot frequency (in minutes)."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'."]
    #[serde(rename = "multiVmSyncStatus")]
    pub multi_vm_sync_status: a2a_policy_creation_input::MultiVmSyncStatus,
}
impl A2aPolicyCreationInput {
    pub fn new(multi_vm_sync_status: a2a_policy_creation_input::MultiVmSyncStatus) -> Self {
        Self {
            policy_provider_specific_input: PolicyProviderSpecificInput::default(),
            recovery_point_history: None,
            crash_consistent_frequency_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status,
        }
    }
}
pub mod a2a_policy_creation_input {
    use super::*;
    #[doc = "A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncStatus {
        Enable,
        Disable,
    }
}
#[doc = "A2A specific policy details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aPolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "The recovery point threshold in minutes."]
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[doc = "The app consistent snapshot frequency in minutes."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "A value indicating whether multi-VM sync has to be enabled."]
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
    #[doc = "The crash consistent snapshot frequency in minutes."]
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
}
impl A2aPolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A protected disk details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aProtectedDiskDetails {
    #[doc = "The disk uri."]
    #[serde(rename = "diskUri", default, skip_serializing_if = "Option::is_none")]
    pub disk_uri: Option<String>,
    #[doc = "The recovery disk storage account."]
    #[serde(rename = "recoveryAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_storage_account_id: Option<String>,
    #[doc = "The primary disk storage account."]
    #[serde(rename = "primaryDiskAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub primary_disk_azure_storage_account_id: Option<String>,
    #[doc = "Recovery disk uri."]
    #[serde(rename = "recoveryDiskUri", default, skip_serializing_if = "Option::is_none")]
    pub recovery_disk_uri: Option<String>,
    #[doc = "The disk name."]
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[doc = "The disk capacity in bytes."]
    #[serde(rename = "diskCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_capacity_in_bytes: Option<i64>,
    #[doc = "The primary staging storage account."]
    #[serde(rename = "primaryStagingAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub primary_staging_azure_storage_account_id: Option<String>,
    #[doc = "The type of disk."]
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<String>,
    #[doc = "A value indicating whether resync is required for this disk."]
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<bool>,
    #[doc = "The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property."]
    #[serde(rename = "monitoringPercentageCompletion", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_percentage_completion: Option<i32>,
    #[doc = "The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property."]
    #[serde(rename = "monitoringJobType", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_job_type: Option<String>,
    #[doc = "The data pending for replication in MB at staging account."]
    #[serde(
        rename = "dataPendingInStagingStorageAccountInMB",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub data_pending_in_staging_storage_account_in_mb: Option<f64>,
    #[doc = "The data pending at source virtual machine in MB."]
    #[serde(rename = "dataPendingAtSourceAgentInMB", default, skip_serializing_if = "Option::is_none")]
    pub data_pending_at_source_agent_in_mb: Option<f64>,
    #[doc = "A value indicating whether vm has encrypted os disk or not."]
    #[serde(rename = "isDiskEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_disk_encrypted: Option<bool>,
    #[doc = "The secret URL / identifier (BEK)."]
    #[serde(rename = "secretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub secret_identifier: Option<String>,
    #[doc = "The KeyVault resource id for secret (BEK)."]
    #[serde(rename = "dekKeyVaultArmId", default, skip_serializing_if = "Option::is_none")]
    pub dek_key_vault_arm_id: Option<String>,
    #[doc = "A value indicating whether disk key got encrypted or not."]
    #[serde(rename = "isDiskKeyEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_disk_key_encrypted: Option<bool>,
    #[doc = "The key URL / identifier (KEK)."]
    #[serde(rename = "keyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub key_identifier: Option<String>,
    #[doc = "The KeyVault resource id for key (KEK)."]
    #[serde(rename = "kekKeyVaultArmId", default, skip_serializing_if = "Option::is_none")]
    pub kek_key_vault_arm_id: Option<String>,
}
impl A2aProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A protected managed disk details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aProtectedManagedDiskDetails {
    #[doc = "The managed disk Arm id."]
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[doc = "The recovery disk resource group Arm Id."]
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[doc = "Recovery target disk Arm Id."]
    #[serde(rename = "recoveryTargetDiskId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target_disk_id: Option<String>,
    #[doc = "Recovery replica disk Arm Id."]
    #[serde(rename = "recoveryReplicaDiskId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_replica_disk_id: Option<String>,
    #[doc = "The replica disk type. Its an optional value and will be same as source disk type if not user provided."]
    #[serde(rename = "recoveryReplicaDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_replica_disk_account_type: Option<String>,
    #[doc = "The target disk type after failover. Its an optional value and will be same as source disk type if not user provided."]
    #[serde(rename = "recoveryTargetDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target_disk_account_type: Option<String>,
    #[doc = "The disk name."]
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[doc = "The disk capacity in bytes."]
    #[serde(rename = "diskCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_capacity_in_bytes: Option<i64>,
    #[doc = "The primary staging storage account."]
    #[serde(rename = "primaryStagingAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub primary_staging_azure_storage_account_id: Option<String>,
    #[doc = "The type of disk."]
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<String>,
    #[doc = "A value indicating whether resync is required for this disk."]
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<bool>,
    #[doc = "The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property."]
    #[serde(rename = "monitoringPercentageCompletion", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_percentage_completion: Option<i32>,
    #[doc = "The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property."]
    #[serde(rename = "monitoringJobType", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_job_type: Option<String>,
    #[doc = "The data pending for replication in MB at staging account."]
    #[serde(
        rename = "dataPendingInStagingStorageAccountInMB",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub data_pending_in_staging_storage_account_in_mb: Option<f64>,
    #[doc = "The data pending at source virtual machine in MB."]
    #[serde(rename = "dataPendingAtSourceAgentInMB", default, skip_serializing_if = "Option::is_none")]
    pub data_pending_at_source_agent_in_mb: Option<f64>,
    #[doc = "A value indicating whether vm has encrypted os disk or not."]
    #[serde(rename = "isDiskEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_disk_encrypted: Option<bool>,
    #[doc = "The secret URL / identifier (BEK)."]
    #[serde(rename = "secretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub secret_identifier: Option<String>,
    #[doc = "The KeyVault resource id for secret (BEK)."]
    #[serde(rename = "dekKeyVaultArmId", default, skip_serializing_if = "Option::is_none")]
    pub dek_key_vault_arm_id: Option<String>,
    #[doc = "A value indicating whether disk key got encrypted or not."]
    #[serde(rename = "isDiskKeyEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_disk_key_encrypted: Option<bool>,
    #[doc = "The key URL / identifier (KEK)."]
    #[serde(rename = "keyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub key_identifier: Option<String>,
    #[doc = "The KeyVault resource id for key (KEK)."]
    #[serde(rename = "kekKeyVaultArmId", default, skip_serializing_if = "Option::is_none")]
    pub kek_key_vault_arm_id: Option<String>,
}
impl A2aProtectedManagedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aProtectionContainerMappingDetails {
    #[serde(flatten)]
    pub protection_container_mapping_provider_specific_details: ProtectionContainerMappingProviderSpecificDetails,
    #[doc = "A value indicating whether the auto update is enabled."]
    #[serde(rename = "agentAutoUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_auto_update_status: Option<a2a_protection_container_mapping_details::AgentAutoUpdateStatus>,
    #[doc = "The automation account arm id."]
    #[serde(rename = "automationAccountArmId", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_arm_id: Option<String>,
    #[doc = "The schedule arm name."]
    #[serde(rename = "scheduleName", default, skip_serializing_if = "Option::is_none")]
    pub schedule_name: Option<String>,
    #[doc = "The job schedule arm name."]
    #[serde(rename = "jobScheduleName", default, skip_serializing_if = "Option::is_none")]
    pub job_schedule_name: Option<String>,
}
impl A2aProtectionContainerMappingDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod a2a_protection_container_mapping_details {
    use super::*;
    #[doc = "A value indicating whether the auto update is enabled."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AgentAutoUpdateStatus {
        Disabled,
        Enabled,
    }
}
#[doc = "A2A provider specific recovery point details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aRecoveryPointDetails {
    #[serde(flatten)]
    pub provider_specific_recovery_point_details: ProviderSpecificRecoveryPointDetails,
    #[doc = "A value indicating whether the recovery point is multi VM consistent."]
    #[serde(rename = "recoveryPointSyncType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_sync_type: Option<a2a_recovery_point_details::RecoveryPointSyncType>,
}
impl A2aRecoveryPointDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod a2a_recovery_point_details {
    use super::*;
    #[doc = "A value indicating whether the recovery point is multi VM consistent."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointSyncType {
        MultiVmSyncRecoveryPoint,
        PerVmRecoveryPoint,
    }
}
#[doc = "A2A provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[doc = "The fabric specific object Id of the virtual machine."]
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[doc = "The multi vm group Id."]
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[doc = "The multi vm group name."]
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[doc = "Whether Multi VM group is auto created or specified by user."]
    #[serde(rename = "multiVmGroupCreateOption", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_create_option: Option<a2a_replication_details::MultiVmGroupCreateOption>,
    #[doc = "The management Id."]
    #[serde(rename = "managementId", default, skip_serializing_if = "Option::is_none")]
    pub management_id: Option<String>,
    #[doc = "The list of protected disks."]
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<A2aProtectedDiskDetails>,
    #[doc = "The list of protected managed disks."]
    #[serde(rename = "protectedManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_managed_disks: Vec<A2aProtectedManagedDiskDetails>,
    #[doc = "The recovery boot diagnostic storage account Arm Id."]
    #[serde(rename = "recoveryBootDiagStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account_id: Option<String>,
    #[doc = "Primary fabric location."]
    #[serde(rename = "primaryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_location: Option<String>,
    #[doc = "The recovery fabric location."]
    #[serde(rename = "recoveryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_location: Option<String>,
    #[doc = "The type of operating system."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "The size of recovery virtual machine."]
    #[serde(rename = "recoveryAzureVMSize", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_size: Option<String>,
    #[doc = "The name of recovery virtual machine."]
    #[serde(rename = "recoveryAzureVMName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_name: Option<String>,
    #[doc = "The recovery resource group."]
    #[serde(rename = "recoveryAzureResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_resource_group_id: Option<String>,
    #[doc = "The recovery cloud service."]
    #[serde(rename = "recoveryCloudService", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service: Option<String>,
    #[doc = "The recovery availability set."]
    #[serde(rename = "recoveryAvailabilitySet", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set: Option<String>,
    #[doc = "The recovery virtual network."]
    #[serde(rename = "selectedRecoveryAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_recovery_azure_network_id: Option<String>,
    #[doc = "The virtual machine nic details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[doc = "Azure to Azure VM synced configuration details."]
    #[serde(rename = "vmSyncedConfigDetails", default, skip_serializing_if = "Option::is_none")]
    pub vm_synced_config_details: Option<AzureToAzureVmSyncedConfigDetails>,
    #[doc = "The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property."]
    #[serde(rename = "monitoringPercentageCompletion", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_percentage_completion: Option<i32>,
    #[doc = "The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property."]
    #[serde(rename = "monitoringJobType", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_job_type: Option<String>,
    #[doc = "The last heartbeat received from the source server."]
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[doc = "The agent version."]
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[doc = "A value indicating whether replication agent update is required."]
    #[serde(rename = "isReplicationAgentUpdateRequired", default, skip_serializing_if = "Option::is_none")]
    pub is_replication_agent_update_required: Option<bool>,
    #[doc = "The recovery fabric object Id."]
    #[serde(rename = "recoveryFabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_object_id: Option<String>,
    #[doc = "The protection state for the vm."]
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[doc = "The protection state description for the vm."]
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[doc = "An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the \"same\" protected item even though other internal Ids/ARM Id might be changing."]
    #[serde(rename = "lifecycleId", default, skip_serializing_if = "Option::is_none")]
    pub lifecycle_id: Option<String>,
    #[doc = "The test failover fabric object Id."]
    #[serde(rename = "testFailoverRecoveryFabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub test_failover_recovery_fabric_object_id: Option<String>,
    #[doc = "The last RPO value in seconds."]
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[doc = "The time (in UTC) when the last RPO value was calculated by Protection Service."]
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
}
impl A2aReplicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod a2a_replication_details {
    use super::*;
    #[doc = "Whether Multi VM group is auto created or specified by user."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmGroupCreateOption {
        AutoCreated,
        UserSpecified,
    }
}
#[doc = "Azure specific reprotect input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[doc = "The recovery container Id."]
    #[serde(rename = "recoveryContainerId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_container_id: Option<String>,
    #[doc = "The list of vm disk details."]
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<A2aVmDiskInputDetails>,
    #[doc = "The recovery resource group Id. Valid for V2 scenarios."]
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[doc = "The recovery cloud service Id. Valid for V1 scenarios."]
    #[serde(rename = "recoveryCloudServiceId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service_id: Option<String>,
    #[doc = "The recovery availability set."]
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[doc = "The Policy Id."]
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
}
impl A2aReprotectInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A specific switch protection input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aSwitchProtectionInput {
    #[serde(flatten)]
    pub switch_protection_provider_specific_input: SwitchProtectionProviderSpecificInput,
    #[doc = "The recovery container Id."]
    #[serde(rename = "recoveryContainerId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_container_id: Option<String>,
    #[doc = "The list of vm disk details."]
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<A2aVmDiskInputDetails>,
    #[doc = "The list of vm managed disk details."]
    #[serde(rename = "vmManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_managed_disks: Vec<A2aVmManagedDiskInputDetails>,
    #[doc = "The recovery resource group Id. Valid for V2 scenarios."]
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[doc = "The recovery cloud service Id. Valid for V1 scenarios."]
    #[serde(rename = "recoveryCloudServiceId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service_id: Option<String>,
    #[doc = "The recovery availability set."]
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[doc = "The Policy Id."]
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[doc = "The boot diagnostic storage account."]
    #[serde(rename = "recoveryBootDiagStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account_id: Option<String>,
    #[doc = "Recovery disk encryption info (BEK and KEK)."]
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
}
impl A2aSwitchProtectionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A update protection container mapping."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aUpdateContainerMappingInput {
    #[serde(flatten)]
    pub replication_provider_specific_update_container_mapping_input: ReplicationProviderSpecificUpdateContainerMappingInput,
    #[doc = "A value indicating whether the auto update is enabled."]
    #[serde(rename = "agentAutoUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_auto_update_status: Option<a2a_update_container_mapping_input::AgentAutoUpdateStatus>,
    #[doc = "The automation account arm id."]
    #[serde(rename = "automationAccountArmId", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_arm_id: Option<String>,
}
impl A2aUpdateContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod a2a_update_container_mapping_input {
    use super::*;
    #[doc = "A value indicating whether the auto update is enabled."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AgentAutoUpdateStatus {
        Disabled,
        Enabled,
    }
}
#[doc = "InMage Azure V2 input to update replication protected item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aUpdateReplicationProtectedItemInput {
    #[serde(flatten)]
    pub update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput,
    #[doc = "The target cloud service ARM Id (for V1)."]
    #[serde(rename = "recoveryCloudServiceId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service_id: Option<String>,
    #[doc = "The target resource group ARM Id (for V2)."]
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[doc = "Managed disk update details."]
    #[serde(rename = "managedDiskUpdateDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub managed_disk_update_details: Vec<A2aVmManagedDiskUpdateDetails>,
    #[doc = "The boot diagnostic storage account."]
    #[serde(rename = "recoveryBootDiagStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account_id: Option<String>,
    #[doc = "Recovery disk encryption info (BEK and KEK)."]
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
}
impl A2aUpdateReplicationProtectedItemInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM disk input details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aVmDiskInputDetails {
    #[doc = "The disk Uri."]
    #[serde(rename = "diskUri", default, skip_serializing_if = "Option::is_none")]
    pub disk_uri: Option<String>,
    #[doc = "The recovery VHD storage account Id."]
    #[serde(rename = "recoveryAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_storage_account_id: Option<String>,
    #[doc = "The primary staging storage account Id."]
    #[serde(rename = "primaryStagingAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub primary_staging_azure_storage_account_id: Option<String>,
}
impl A2aVmDiskInputDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM managed disk input details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aVmManagedDiskInputDetails {
    #[doc = "The disk Id."]
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[doc = "The primary staging storage account Arm Id."]
    #[serde(rename = "primaryStagingAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub primary_staging_azure_storage_account_id: Option<String>,
    #[doc = "The target resource group Arm Id."]
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[doc = "The replica disk type. Its an optional value and will be same as source disk type if not user provided."]
    #[serde(rename = "recoveryReplicaDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_replica_disk_account_type: Option<String>,
    #[doc = "The target disk type after failover. Its an optional value and will be same as source disk type if not user provided."]
    #[serde(rename = "recoveryTargetDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target_disk_account_type: Option<String>,
}
impl A2aVmManagedDiskInputDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM managed disk update input details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aVmManagedDiskUpdateDetails {
    #[doc = "The disk Id."]
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[doc = "The target disk type before failover."]
    #[serde(rename = "recoveryTargetDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target_disk_account_type: Option<String>,
    #[doc = "The replica disk type before failover."]
    #[serde(rename = "recoveryReplicaDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_replica_disk_account_type: Option<String>,
}
impl A2aVmManagedDiskUpdateDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Task of the Job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AsrTask {
    #[doc = "The Id."]
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[doc = "The unique Task name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The start time."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The state/actions applicable on this task."]
    #[serde(rename = "allowedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_actions: Vec<String>,
    #[doc = "The name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The description of the task state. For example - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped."]
    #[serde(rename = "stateDescription", default, skip_serializing_if = "Option::is_none")]
    pub state_description: Option<String>,
    #[doc = "The type of task. Details in CustomDetails property depend on this type."]
    #[serde(rename = "taskType", default, skip_serializing_if = "Option::is_none")]
    pub task_type: Option<String>,
    #[doc = "Task details based on specific task type."]
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<TaskTypeDetails>,
    #[doc = "This class represents the group task details when parent child relationship exists in the drill down."]
    #[serde(rename = "groupTaskCustomDetails", default, skip_serializing_if = "Option::is_none")]
    pub group_task_custom_details: Option<GroupTaskDetails>,
    #[doc = "The task error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<JobErrorDetails>,
}
impl AsrTask {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input required to add a provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AddRecoveryServicesProviderInput {
    #[doc = "The properties of an add provider request."]
    pub properties: AddRecoveryServicesProviderInputProperties,
}
impl AddRecoveryServicesProviderInput {
    pub fn new(properties: AddRecoveryServicesProviderInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "The properties of an add provider request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AddRecoveryServicesProviderInputProperties {
    #[doc = "The name of the machine where the provider is getting added."]
    #[serde(rename = "machineName")]
    pub machine_name: String,
    #[doc = "Identity provider input."]
    #[serde(rename = "authenticationIdentityInput")]
    pub authentication_identity_input: IdentityProviderInput,
    #[doc = "Identity provider input."]
    #[serde(rename = "resourceAccessIdentityInput")]
    pub resource_access_identity_input: IdentityProviderInput,
}
impl AddRecoveryServicesProviderInputProperties {
    pub fn new(
        machine_name: String,
        authentication_identity_input: IdentityProviderInput,
        resource_access_identity_input: IdentityProviderInput,
    ) -> Self {
        Self {
            machine_name,
            authentication_identity_input,
            resource_access_identity_input,
        }
    }
}
#[doc = "Input required to add vCenter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddVCenterRequest {
    #[doc = "The properties of an add vCenter request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AddVCenterRequestProperties>,
}
impl AddVCenterRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of an add vCenter request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddVCenterRequestProperties {
    #[doc = "The friendly name of the vCenter."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The IP address of the vCenter to be discovered."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The process server Id from where the discovery is orchestrated."]
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[doc = "The port number for discovery."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<String>,
    #[doc = "The account Id which has privileges to discover the vCenter."]
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
}
impl AddVCenterRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Implements the Alert class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alert {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of an alert."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertProperties>,
}
impl Alert {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of alerts."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertCollection {
    #[doc = "The list of alerts."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Alert>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of an alert."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertProperties {
    #[doc = "A value indicating whether to send email to subscription administrator."]
    #[serde(rename = "sendToOwners", default, skip_serializing_if = "Option::is_none")]
    pub send_to_owners: Option<String>,
    #[doc = "The custom email address for sending emails."]
    #[serde(rename = "customEmailAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_email_addresses: Vec<String>,
    #[doc = "The locale for the email notification."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub locale: Option<String>,
}
impl AlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input to apply recovery point."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplyRecoveryPointInput {
    #[doc = "Input properties to apply recovery point."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplyRecoveryPointInputProperties>,
}
impl ApplyRecoveryPointInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input properties to apply recovery point."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplyRecoveryPointInputProperties {
    #[doc = "The recovery point Id."]
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[doc = "Provider specific input for apply recovery point."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ApplyRecoveryPointProviderSpecificInput>,
}
impl ApplyRecoveryPointInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provider specific input for apply recovery point."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplyRecoveryPointProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ApplyRecoveryPointProviderSpecificInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents job details based on specific job type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AsrJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
}
impl AsrJobDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents the task details for an automation runbook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutomationRunbookTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[doc = "The recovery plan task name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The cloud service of the automation runbook account."]
    #[serde(rename = "cloudServiceName", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_name: Option<String>,
    #[doc = "The subscription Id of the automation runbook account."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[doc = "The automation account name of the runbook."]
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[doc = "The runbook Id."]
    #[serde(rename = "runbookId", default, skip_serializing_if = "Option::is_none")]
    pub runbook_id: Option<String>,
    #[doc = "The runbook name."]
    #[serde(rename = "runbookName", default, skip_serializing_if = "Option::is_none")]
    pub runbook_name: Option<String>,
    #[doc = "The job Id of the runbook execution."]
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[doc = "The execution output of the runbook."]
    #[serde(rename = "jobOutput", default, skip_serializing_if = "Option::is_none")]
    pub job_output: Option<String>,
    #[doc = "A value indicating whether it is a primary side script or not."]
    #[serde(rename = "isPrimarySideScript", default, skip_serializing_if = "Option::is_none")]
    pub is_primary_side_script: Option<bool>,
}
impl AutomationRunbookTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Fabric provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFabricCreationInput {
    #[serde(flatten)]
    pub fabric_specific_creation_input: FabricSpecificCreationInput,
    #[doc = "The Location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl AzureFabricCreationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Fabric Specific Details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFabricSpecificDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
    #[doc = "The Location for the Azure fabric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "The container Ids for the Azure fabric."]
    #[serde(rename = "containerIds", default, skip_serializing_if = "Vec::is_empty")]
    pub container_ids: Vec<String>,
}
impl AzureFabricSpecificDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Create network mappings input properties/behavior specific to Azure to Azure Network mapping."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureToAzureCreateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_create_network_mapping_input: FabricSpecificCreateNetworkMappingInput,
    #[doc = "The primary azure vnet Id."]
    #[serde(rename = "primaryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub primary_network_id: Option<String>,
}
impl AzureToAzureCreateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A2A Network Mapping fabric specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureToAzureNetworkMappingSettings {
    #[serde(flatten)]
    pub network_mapping_fabric_specific_settings: NetworkMappingFabricSpecificSettings,
    #[doc = "The primary fabric location."]
    #[serde(rename = "primaryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_location: Option<String>,
    #[doc = "The recovery fabric location."]
    #[serde(rename = "recoveryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_location: Option<String>,
}
impl AzureToAzureNetworkMappingSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Updates network mappings input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureToAzureUpdateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_update_network_mapping_input: FabricSpecificUpdateNetworkMappingInput,
    #[doc = "The primary azure vnet Id."]
    #[serde(rename = "primaryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub primary_network_id: Option<String>,
}
impl AzureToAzureUpdateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure to Azure VM synced configuration details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureToAzureVmSyncedConfigDetails {
    #[doc = "The Azure VM tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The Azure role assignments."]
    #[serde(rename = "roleAssignments", default, skip_serializing_if = "Vec::is_empty")]
    pub role_assignments: Vec<RoleAssignment>,
    #[doc = "The Azure VM input endpoints."]
    #[serde(rename = "inputEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub input_endpoints: Vec<InputEndpoint>,
}
impl AzureToAzureVmSyncedConfigDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Disk details for E2A provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmDiskDetails {
    #[doc = "VHD type."]
    #[serde(rename = "vhdType", default, skip_serializing_if = "Option::is_none")]
    pub vhd_type: Option<String>,
    #[doc = "The VHD id."]
    #[serde(rename = "vhdId", default, skip_serializing_if = "Option::is_none")]
    pub vhd_id: Option<String>,
    #[doc = "VHD name."]
    #[serde(rename = "vhdName", default, skip_serializing_if = "Option::is_none")]
    pub vhd_name: Option<String>,
    #[doc = "Max side in MB."]
    #[serde(rename = "maxSizeMB", default, skip_serializing_if = "Option::is_none")]
    pub max_size_mb: Option<String>,
    #[doc = "Blob uri of the Azure disk."]
    #[serde(rename = "targetDiskLocation", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_location: Option<String>,
    #[doc = "The target Azure disk name."]
    #[serde(rename = "targetDiskName", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_name: Option<String>,
    #[doc = "Ordinal\\LunId of the disk for the Azure VM."]
    #[serde(rename = "lunId", default, skip_serializing_if = "Option::is_none")]
    pub lun_id: Option<String>,
}
impl AzureVmDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents the error used to indicate why the target compute size is not applicable."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeSizeErrorDetails {
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The severity of the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
}
impl ComputeSizeErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Replication provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConfigurationSettings {
    #[doc = "Gets the class type. Overridden in derived classes."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ConfigurationSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request to configure alerts for the system."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConfigureAlertRequest {
    #[doc = "Properties of a configure alert request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConfigureAlertRequestProperties>,
}
impl ConfigureAlertRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a configure alert request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConfigureAlertRequestProperties {
    #[doc = "A value indicating whether to send email to subscription administrator."]
    #[serde(rename = "sendToOwners", default, skip_serializing_if = "Option::is_none")]
    pub send_to_owners: Option<String>,
    #[doc = "The custom email address for sending emails."]
    #[serde(rename = "customEmailAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_email_addresses: Vec<String>,
    #[doc = "The locale for the email notification."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub locale: Option<String>,
}
impl ConfigureAlertRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class contains monitoring details of all the inconsistent Protected Entities in Vmm."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConsistencyCheckTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[doc = "The list of inconsistent Vm details."]
    #[serde(rename = "vmDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_details: Vec<InconsistentVmDetails>,
}
impl ConsistencyCheckTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Create network mappings input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateNetworkMappingInput {
    #[doc = "Common input details for network mapping operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreateNetworkMappingInputProperties>,
}
impl CreateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common input details for network mapping operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateNetworkMappingInputProperties {
    #[doc = "Recovery fabric Name."]
    #[serde(rename = "recoveryFabricName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_name: Option<String>,
    #[doc = "Recovery network Id."]
    #[serde(rename = "recoveryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_network_id: Option<String>,
    #[doc = "Input details specific to fabrics during Network Mapping."]
    #[serde(rename = "fabricSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub fabric_specific_details: Option<FabricSpecificCreateNetworkMappingInput>,
}
impl CreateNetworkMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protection Policy input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreatePolicyInput {
    #[doc = "Policy creation properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreatePolicyInputProperties>,
}
impl CreatePolicyInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Policy creation properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreatePolicyInputProperties {
    #[doc = "Base class for provider specific input"]
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_input: Option<PolicyProviderSpecificInput>,
}
impl CreatePolicyInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Create protection container input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionContainerInput {
    #[doc = "Create protection container input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreateProtectionContainerInputProperties>,
}
impl CreateProtectionContainerInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Create protection container input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionContainerInputProperties {
    #[doc = "Provider specific inputs for container creation."]
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_input: Vec<ReplicationProviderSpecificContainerCreationInput>,
}
impl CreateProtectionContainerInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configure pairing input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionContainerMappingInput {
    #[doc = "Configure pairing input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreateProtectionContainerMappingInputProperties>,
}
impl CreateProtectionContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configure pairing input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionContainerMappingInputProperties {
    #[doc = "The target unique protection container name."]
    #[serde(rename = "targetProtectionContainerId", default, skip_serializing_if = "Option::is_none")]
    pub target_protection_container_id: Option<String>,
    #[doc = "Applicable policy."]
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[doc = "Provider specific input for pairing operations."]
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_input: Option<ReplicationProviderSpecificContainerMappingInput>,
}
impl CreateProtectionContainerMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Create recovery plan input class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateRecoveryPlanInput {
    #[doc = "Recovery plan creation properties."]
    pub properties: CreateRecoveryPlanInputProperties,
}
impl CreateRecoveryPlanInput {
    pub fn new(properties: CreateRecoveryPlanInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Recovery plan creation properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateRecoveryPlanInputProperties {
    #[doc = "The primary fabric Id."]
    #[serde(rename = "primaryFabricId")]
    pub primary_fabric_id: String,
    #[doc = "The recovery fabric Id."]
    #[serde(rename = "recoveryFabricId")]
    pub recovery_fabric_id: String,
    #[doc = "The failover deployment model."]
    #[serde(rename = "failoverDeploymentModel", default, skip_serializing_if = "Option::is_none")]
    pub failover_deployment_model: Option<create_recovery_plan_input_properties::FailoverDeploymentModel>,
    #[doc = "The recovery plan groups."]
    pub groups: Vec<RecoveryPlanGroup>,
}
impl CreateRecoveryPlanInputProperties {
    pub fn new(primary_fabric_id: String, recovery_fabric_id: String, groups: Vec<RecoveryPlanGroup>) -> Self {
        Self {
            primary_fabric_id,
            recovery_fabric_id,
            failover_deployment_model: None,
            groups,
        }
    }
}
pub mod create_recovery_plan_input_properties {
    use super::*;
    #[doc = "The failover deployment model."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverDeploymentModel {
        NotApplicable,
        Classic,
        ResourceManager,
    }
}
#[doc = "Current job details of the migration item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CurrentJobDetails {
    #[doc = "The job name."]
    #[serde(rename = "jobName", default, skip_serializing_if = "Option::is_none")]
    pub job_name: Option<String>,
    #[doc = "The ARM Id of the job being executed."]
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[doc = "The start time of the job."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
}
impl CurrentJobDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Current scenario details of the protected entity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CurrentScenarioDetails {
    #[doc = "Scenario name."]
    #[serde(rename = "scenarioName", default, skip_serializing_if = "Option::is_none")]
    pub scenario_name: Option<String>,
    #[doc = "ARM Id of the job being executed."]
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[doc = "Start time of the workflow."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
}
impl CurrentScenarioDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The data store details of the MT."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataStore {
    #[doc = "The symbolic name of data store."]
    #[serde(rename = "symbolicName", default, skip_serializing_if = "Option::is_none")]
    pub symbolic_name: Option<String>,
    #[doc = "The uuid of data store."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uuid: Option<String>,
    #[doc = "The capacity of data store in GBs."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<String>,
    #[doc = "The free space of data store in GBs."]
    #[serde(rename = "freeSpace", default, skip_serializing_if = "Option::is_none")]
    pub free_space: Option<String>,
    #[doc = "The type of data store."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl DataStore {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Disable protection input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DisableProtectionInput {
    #[doc = "Disable protection input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DisableProtectionInputProperties>,
}
impl DisableProtectionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Disable protection input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DisableProtectionInputProperties {
    #[doc = "Disable protection reason. It can have values NotSpecified/MigrationComplete."]
    #[serde(rename = "disableProtectionReason", default, skip_serializing_if = "Option::is_none")]
    pub disable_protection_reason: Option<disable_protection_input_properties::DisableProtectionReason>,
    #[doc = "Disable protection provider specific input."]
    #[serde(rename = "replicationProviderInput", default, skip_serializing_if = "Option::is_none")]
    pub replication_provider_input: Option<DisableProtectionProviderSpecificInput>,
}
impl DisableProtectionInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod disable_protection_input_properties {
    use super::*;
    #[doc = "Disable protection reason. It can have values NotSpecified/MigrationComplete."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DisableProtectionReason {
        NotSpecified,
        MigrationComplete,
    }
}
#[doc = "Disable protection provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DisableProtectionProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl DisableProtectionProviderSpecificInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request to add a physical machine as a protectable item in a container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiscoverProtectableItemRequest {
    #[doc = "Discover protectable item properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DiscoverProtectableItemRequestProperties>,
}
impl DiscoverProtectableItemRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Discover protectable item properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiscoverProtectableItemRequestProperties {
    #[doc = "The friendly name of the physical machine."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The IP address of the physical machine to be discovered."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The OS type on the physical machine."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
}
impl DiscoverProtectableItemRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "On-prem disk details data."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskDetails {
    #[doc = "The hard disk max size in MB."]
    #[serde(rename = "maxSizeMB", default, skip_serializing_if = "Option::is_none")]
    pub max_size_mb: Option<i64>,
    #[doc = "The type of the volume."]
    #[serde(rename = "vhdType", default, skip_serializing_if = "Option::is_none")]
    pub vhd_type: Option<String>,
    #[doc = "The VHD Id."]
    #[serde(rename = "vhdId", default, skip_serializing_if = "Option::is_none")]
    pub vhd_id: Option<String>,
    #[doc = "The VHD name."]
    #[serde(rename = "vhdName", default, skip_serializing_if = "Option::is_none")]
    pub vhd_name: Option<String>,
}
impl DiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery disk encryption info (BEK and KEK)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskEncryptionInfo {
    #[doc = "Disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows)."]
    #[serde(rename = "diskEncryptionKeyInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_key_info: Option<DiskEncryptionKeyInfo>,
    #[doc = "Key Encryption Key (KEK) information."]
    #[serde(rename = "keyEncryptionKeyInfo", default, skip_serializing_if = "Option::is_none")]
    pub key_encryption_key_info: Option<KeyEncryptionKeyInfo>,
}
impl DiskEncryptionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskEncryptionKeyInfo {
    #[doc = "The\u{a0}secret url / identifier."]
    #[serde(rename = "secretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub secret_identifier: Option<String>,
    #[doc = "The\u{a0}KeyVault resource ARM id for secret."]
    #[serde(rename = "keyVaultResourceArmId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_resource_arm_id: Option<String>,
}
impl DiskEncryptionKeyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Volume details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskVolumeDetails {
    #[doc = "The volume label."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub label: Option<String>,
    #[doc = "The volume name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl DiskVolumeDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains the localized display information for this particular operation / action. These value will be used by several clients for (1) custom role definitions for RBAC; (2) complex query filters for the event service; and (3) audit history / records for management operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Display {
    #[doc = "The provider. The localized friendly form of the resource provider name – it is expected to also include the publisher/company responsible. It should use Title Casing and begin with \"Microsoft\" for 1st party services. e.g. \"Microsoft Monitoring Insights\" or \"Microsoft Compute.\""]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "The resource. The localized friendly form of the resource related to this action/operation – it should match the public documentation for the resource provider. It should use Title Casing. This value should be unique for a particular URL type (e.g. nested types should *not* reuse their parent’s display.resource field). e.g. \"Virtual Machines\" or \"Scheduler Job Collections\", or \"Virtual Machine VM Sizes\" or \"Scheduler Jobs\""]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[doc = "The operation. The localized friendly name for the operation, as it should be shown to the user. It should be concise (to fit in drop downs) but clear (i.e. self-documenting). It should use Title Casing. Prescriptive guidance: Read Create or Update Delete 'ActionName'"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "The description. The localized friendly description for the operation, as it should be shown to the user. It should be thorough, yet concise – it will be used in tool tips and detailed views. Prescriptive guidance for namespaces: Read any 'display.provider' resource Create or Update any 'display.provider' resource Delete any 'display.provider' resource Perform any other action on any 'display.provider' resource Prescriptive guidance for namespaces: Read any 'display.resource' Create or Update any 'display.resource' Delete any 'display.resource' 'ActionName' any 'display.resources'"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl Display {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Enable migration input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnableMigrationInput {
    #[doc = "Enable migration input properties."]
    pub properties: EnableMigrationInputProperties,
}
impl EnableMigrationInput {
    pub fn new(properties: EnableMigrationInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Enable migration input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnableMigrationInputProperties {
    #[doc = "The policy Id."]
    #[serde(rename = "policyId")]
    pub policy_id: String,
    #[doc = "Enable migration provider specific input."]
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: EnableMigrationProviderSpecificInput,
}
impl EnableMigrationInputProperties {
    pub fn new(policy_id: String, provider_specific_details: EnableMigrationProviderSpecificInput) -> Self {
        Self {
            policy_id,
            provider_specific_details,
        }
    }
}
#[doc = "Enable migration provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnableMigrationProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl EnableMigrationProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[doc = "Enable protection input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnableProtectionInput {
    #[doc = "Enable protection input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EnableProtectionInputProperties>,
}
impl EnableProtectionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Enable protection input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnableProtectionInputProperties {
    #[doc = "The Policy Id."]
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[doc = "The protectable item Id."]
    #[serde(rename = "protectableItemId", default, skip_serializing_if = "Option::is_none")]
    pub protectable_item_id: Option<String>,
    #[doc = "Enable protection provider specific input."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<EnableProtectionProviderSpecificInput>,
}
impl EnableProtectionInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Enable protection provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnableProtectionProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl EnableProtectionProviderSpecificInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Encryption details for the fabric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionDetails {
    #[doc = "The key encryption key state for the Vmm."]
    #[serde(rename = "kekState", default, skip_serializing_if = "Option::is_none")]
    pub kek_state: Option<String>,
    #[doc = "The key encryption key certificate thumbprint."]
    #[serde(rename = "kekCertThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub kek_cert_thumbprint: Option<String>,
    #[doc = "The key encryption key certificate expiry date."]
    #[serde(rename = "kekCertExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub kek_cert_expiry_date: Option<String>,
}
impl EncryptionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Implements the Event class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Event {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The properties of a monitoring event."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EventProperties>,
}
impl Event {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of fabric details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventCollection {
    #[doc = "The list of events."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Event>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EventCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a monitoring event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventProperties {
    #[doc = "The Id of the monitoring event."]
    #[serde(rename = "eventCode", default, skip_serializing_if = "Option::is_none")]
    pub event_code: Option<String>,
    #[doc = "The event name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The type of the event. for example: VM Health, Server Health, Job Failure etc."]
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[doc = "The friendly name of the source of the event on which it is raised (for example, VM, VMM etc)."]
    #[serde(rename = "affectedObjectFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_friendly_name: Option<String>,
    #[doc = "The affected object correlationId for the event."]
    #[serde(rename = "affectedObjectCorrelationId", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_correlation_id: Option<String>,
    #[doc = "The severity of the event."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
    #[doc = "The time of occurrence of the event."]
    #[serde(rename = "timeOfOccurrence", default, skip_serializing_if = "Option::is_none")]
    pub time_of_occurrence: Option<String>,
    #[doc = "The ARM ID of the fabric."]
    #[serde(rename = "fabricId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_id: Option<String>,
    #[doc = "Model class for provider specific details for an event."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<EventProviderSpecificDetails>,
    #[doc = "Model class for event specific details for an event."]
    #[serde(rename = "eventSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub event_specific_details: Option<EventSpecificDetails>,
    #[doc = "The list of errors / warnings capturing details associated with the issue(s)."]
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
}
impl EventProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Model class for provider specific details for an event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventProviderSpecificDetails {
    #[doc = "Gets the class type. Overridden in derived classes."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl EventProviderSpecificDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Implements the event query parameter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventQueryParameter {
    #[doc = "The source id of the events to be queried."]
    #[serde(rename = "eventCode", default, skip_serializing_if = "Option::is_none")]
    pub event_code: Option<String>,
    #[doc = "The severity of the events to be queried."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
    #[doc = "The type of the events to be queried."]
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[doc = "The affected object server id of the events to be queried."]
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[doc = "The affected object name of the events to be queried."]
    #[serde(rename = "affectedObjectFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_friendly_name: Option<String>,
    #[doc = "The affected object correlationId for the events to be queried."]
    #[serde(rename = "affectedObjectCorrelationId", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_correlation_id: Option<String>,
    #[doc = "The start time of the time range within which the events are to be queried."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time of the time range within which the events are to be queried."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl EventQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Model class for event specific details for an event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSpecificDetails {
    #[doc = "Gets the class type. Overridden in derived classes."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl EventSpecificDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents details for export jobs workflow."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
    #[doc = "BlobUri of the exported jobs."]
    #[serde(rename = "blobUri", default, skip_serializing_if = "Option::is_none")]
    pub blob_uri: Option<String>,
    #[doc = "The sas token to access blob."]
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<String>,
}
impl ExportJobDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Fabric definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Fabric {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Fabric properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FabricProperties>,
}
impl Fabric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of fabric details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricCollection {
    #[doc = "The fabric details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Fabric>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FabricCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Site details provided during the time of site creation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricCreationInput {
    #[doc = "Properties of site details provided during the time of site creation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FabricCreationInputProperties>,
}
impl FabricCreationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of site details provided during the time of site creation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricCreationInputProperties {
    #[doc = "Fabric provider specific settings."]
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<FabricSpecificCreationInput>,
}
impl FabricCreationInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Fabric properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricProperties {
    #[doc = "Friendly name of the fabric."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Encryption details for the fabric."]
    #[serde(rename = "encryptionDetails", default, skip_serializing_if = "Option::is_none")]
    pub encryption_details: Option<EncryptionDetails>,
    #[doc = "Encryption details for the fabric."]
    #[serde(rename = "rolloverEncryptionDetails", default, skip_serializing_if = "Option::is_none")]
    pub rollover_encryption_details: Option<EncryptionDetails>,
    #[doc = "Dra Registration Id."]
    #[serde(rename = "internalIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub internal_identifier: Option<String>,
    #[doc = "BCDR state of the fabric."]
    #[serde(rename = "bcdrState", default, skip_serializing_if = "Option::is_none")]
    pub bcdr_state: Option<String>,
    #[doc = "Fabric specific details."]
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<FabricSpecificDetails>,
    #[doc = "Fabric health error details."]
    #[serde(rename = "healthErrorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub health_error_details: Vec<HealthError>,
    #[doc = "Health of fabric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<String>,
}
impl FabricProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents the fabric replication group task details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricReplicationGroupTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[doc = "The skipped reason."]
    #[serde(rename = "skippedReason", default, skip_serializing_if = "Option::is_none")]
    pub skipped_reason: Option<String>,
    #[doc = "The skipped reason string."]
    #[serde(rename = "skippedReasonString", default, skip_serializing_if = "Option::is_none")]
    pub skipped_reason_string: Option<String>,
    #[doc = "This class contains the minimal job details required to navigate to the desired drill down."]
    #[serde(rename = "jobTask", default, skip_serializing_if = "Option::is_none")]
    pub job_task: Option<JobEntity>,
}
impl FabricReplicationGroupTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input details specific to fabrics during Network Mapping."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricSpecificCreateNetworkMappingInput {
    #[doc = "The instance type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl FabricSpecificCreateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Fabric provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricSpecificCreationInput {
    #[doc = "Gets the class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl FabricSpecificCreationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Fabric specific details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricSpecificDetails {
    #[doc = "Gets the class type. Overridden in derived classes."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl FabricSpecificDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input details specific to fabrics during Network Mapping."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricSpecificUpdateNetworkMappingInput {
    #[doc = "The instance type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl FabricSpecificUpdateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents the details for a failover job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
    #[doc = "The test VM details."]
    #[serde(rename = "protectedItemDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_item_details: Vec<FailoverReplicationProtectedItemDetails>,
}
impl FailoverJobDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request to failover a process server."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverProcessServerRequest {
    #[doc = "The properties of the Failover Process Server request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FailoverProcessServerRequestProperties>,
}
impl FailoverProcessServerRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of the Failover Process Server request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverProcessServerRequestProperties {
    #[doc = "The container identifier."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The source process server."]
    #[serde(rename = "sourceProcessServerId", default, skip_serializing_if = "Option::is_none")]
    pub source_process_server_id: Option<String>,
    #[doc = "The new process server."]
    #[serde(rename = "targetProcessServerId", default, skip_serializing_if = "Option::is_none")]
    pub target_process_server_id: Option<String>,
    #[doc = "The VMS to migrate."]
    #[serde(rename = "vmsToMigrate", default, skip_serializing_if = "Vec::is_empty")]
    pub vms_to_migrate: Vec<String>,
    #[doc = "A value for failover type. It can be systemlevel/serverlevel"]
    #[serde(rename = "updateType", default, skip_serializing_if = "Option::is_none")]
    pub update_type: Option<String>,
}
impl FailoverProcessServerRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Failover details for a replication protected item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverReplicationProtectedItemDetails {
    #[doc = "The name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The friendly name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The test Vm name."]
    #[serde(rename = "testVmName", default, skip_serializing_if = "Option::is_none")]
    pub test_vm_name: Option<String>,
    #[doc = "The test Vm friendly name."]
    #[serde(rename = "testVmFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub test_vm_friendly_name: Option<String>,
    #[doc = "The network connection status."]
    #[serde(rename = "networkConnectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub network_connection_status: Option<String>,
    #[doc = "The network friendly name."]
    #[serde(rename = "networkFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub network_friendly_name: Option<String>,
    #[doc = "The network subnet."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<String>,
    #[doc = "The recovery point Id."]
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[doc = "The recovery point time."]
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
}
impl FailoverReplicationProtectedItemDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents the group task details when parent child relationship exists in the drill down."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupTaskDetails {
    #[doc = "The type of task details."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    #[doc = "The child tasks."]
    #[serde(rename = "childTasks", default, skip_serializing_if = "Vec::is_empty")]
    pub child_tasks: Vec<AsrTask>,
}
impl GroupTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Health Error"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HealthError {
    #[doc = "The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException."]
    #[serde(rename = "innerHealthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub inner_health_errors: Vec<InnerHealthError>,
    #[doc = "Source of error."]
    #[serde(rename = "errorSource", default, skip_serializing_if = "Option::is_none")]
    pub error_source: Option<String>,
    #[doc = "Type of error."]
    #[serde(rename = "errorType", default, skip_serializing_if = "Option::is_none")]
    pub error_type: Option<String>,
    #[doc = "Level of error."]
    #[serde(rename = "errorLevel", default, skip_serializing_if = "Option::is_none")]
    pub error_level: Option<String>,
    #[doc = "Category of error."]
    #[serde(rename = "errorCategory", default, skip_serializing_if = "Option::is_none")]
    pub error_category: Option<String>,
    #[doc = "Error code."]
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[doc = "Summary message of the entity."]
    #[serde(rename = "summaryMessage", default, skip_serializing_if = "Option::is_none")]
    pub summary_message: Option<String>,
    #[doc = "Error message."]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[doc = "Possible causes of error."]
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[doc = "Recommended action to resolve error."]
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
    #[doc = "Error creation time (UTC)"]
    #[serde(rename = "creationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub creation_time_utc: Option<String>,
    #[doc = "DRA error message."]
    #[serde(rename = "recoveryProviderErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub recovery_provider_error_message: Option<String>,
    #[doc = "ID of the entity."]
    #[serde(rename = "entityId", default, skip_serializing_if = "Option::is_none")]
    pub entity_id: Option<String>,
}
impl HealthError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "class to define the summary of the health error details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HealthErrorSummary {
    #[doc = "The code of the health error."]
    #[serde(rename = "summaryCode", default, skip_serializing_if = "Option::is_none")]
    pub summary_code: Option<String>,
    #[doc = "The category of the health error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<health_error_summary::Category>,
    #[doc = "Severity of error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<health_error_summary::Severity>,
    #[doc = "The summary message of the health error."]
    #[serde(rename = "summaryMessage", default, skip_serializing_if = "Option::is_none")]
    pub summary_message: Option<String>,
    #[doc = "The type of affected ARM resource."]
    #[serde(rename = "affectedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub affected_resource_type: Option<String>,
    #[doc = "The sub type of any subcomponent within the ARM resource that this might be applicable. Value remains null if not applicable."]
    #[serde(rename = "affectedResourceSubtype", default, skip_serializing_if = "Option::is_none")]
    pub affected_resource_subtype: Option<String>,
    #[doc = "The list of affected resource correlation Ids. This can be used to uniquely identify the count of items affected by a specific category and severity as well as count of item affected by an specific issue."]
    #[serde(rename = "affectedResourceCorrelationIds", default, skip_serializing_if = "Vec::is_empty")]
    pub affected_resource_correlation_ids: Vec<String>,
}
impl HealthErrorSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod health_error_summary {
    use super::*;
    #[doc = "The category of the health error."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Category {
        None,
        Replication,
        TestFailover,
        Configuration,
        FabricInfrastructure,
        VersionExpiry,
        AgentAutoUpdate,
    }
    #[doc = "Severity of error."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        #[serde(rename = "NONE")]
        None,
        Warning,
        Error,
        Info,
    }
}
#[doc = "Model class for event details of a HyperVReplica E2E event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplica2012EventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[doc = "The container friendly name."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The fabric friendly name."]
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[doc = "The remote container name."]
    #[serde(rename = "remoteContainerName", default, skip_serializing_if = "Option::is_none")]
    pub remote_container_name: Option<String>,
    #[doc = "The remote fabric name."]
    #[serde(rename = "remoteFabricName", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_name: Option<String>,
}
impl HyperVReplica2012EventDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Model class for event details of a HyperVReplica blue E2E event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplica2012R2EventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[doc = "The container friendly name."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The fabric friendly name."]
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[doc = "The remote container name."]
    #[serde(rename = "remoteContainerName", default, skip_serializing_if = "Option::is_none")]
    pub remote_container_name: Option<String>,
    #[doc = "The remote fabric name."]
    #[serde(rename = "remoteFabricName", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_name: Option<String>,
}
impl HyperVReplica2012R2EventDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ApplyRecoveryPoint input specific to HyperVReplicaAzure provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureApplyRecoveryPointInput {
    #[serde(flatten)]
    pub apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput,
    #[doc = "The vault location where the recovery Vm resides."]
    #[serde(rename = "vaultLocation", default, skip_serializing_if = "Option::is_none")]
    pub vault_location: Option<String>,
    #[doc = "The primary kek certificate pfx."]
    #[serde(rename = "primaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub primary_kek_certificate_pfx: Option<String>,
    #[doc = "The secondary kek certificate pfx."]
    #[serde(rename = "secondaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub secondary_kek_certificate_pfx: Option<String>,
}
impl HyperVReplicaAzureApplyRecoveryPointInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure specific enable protection input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureEnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[doc = "The Hyper-V host Vm Id."]
    #[serde(rename = "hvHostVmId", default, skip_serializing_if = "Option::is_none")]
    pub hv_host_vm_id: Option<String>,
    #[doc = "The Vm Name."]
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[doc = "The OS type associated with vm."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "The OS disk VHD id associated with vm."]
    #[serde(rename = "vhdId", default, skip_serializing_if = "Option::is_none")]
    pub vhd_id: Option<String>,
    #[doc = "The storage account name."]
    #[serde(rename = "targetStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_storage_account_id: Option<String>,
    #[doc = "The selected target Azure network Id."]
    #[serde(rename = "targetAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_network_id: Option<String>,
    #[doc = "The selected target Azure subnet Id."]
    #[serde(rename = "targetAzureSubnetId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_subnet_id: Option<String>,
    #[doc = "The selected option to enable RDP\\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum."]
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[doc = "The target azure Vm Name."]
    #[serde(rename = "targetAzureVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_vm_name: Option<String>,
    #[doc = "The storage account to be used for logging during replication."]
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[doc = "The list of VHD IDs of disks to be protected."]
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<String>,
    #[doc = "The Id of the target resource group (for classic deployment) in which the failover VM is to be created."]
    #[serde(rename = "targetAzureV1ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_v1_resource_group_id: Option<String>,
    #[doc = "The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created."]
    #[serde(rename = "targetAzureV2ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_v2_resource_group_id: Option<String>,
    #[doc = "A value indicating whether managed disks should be used during failover."]
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
}
impl HyperVReplicaAzureEnableProtectionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Model class for event details of a HyperVReplica E2A event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[doc = "The container friendly name."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The fabric friendly name."]
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[doc = "The remote container name."]
    #[serde(rename = "remoteContainerName", default, skip_serializing_if = "Option::is_none")]
    pub remote_container_name: Option<String>,
}
impl HyperVReplicaAzureEventDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HvrA provider specific input for failback."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureFailbackProviderInput {
    #[serde(flatten)]
    pub provider_specific_failover_input: ProviderSpecificFailoverInput,
    #[doc = "Data sync option."]
    #[serde(rename = "dataSyncOption", default, skip_serializing_if = "Option::is_none")]
    pub data_sync_option: Option<String>,
    #[doc = "ALR options to create alternate recovery."]
    #[serde(rename = "recoveryVmCreationOption", default, skip_serializing_if = "Option::is_none")]
    pub recovery_vm_creation_option: Option<String>,
    #[doc = "Provider ID for alternate location"]
    #[serde(rename = "providerIdForAlternateRecovery", default, skip_serializing_if = "Option::is_none")]
    pub provider_id_for_alternate_recovery: Option<String>,
}
impl HyperVReplicaAzureFailbackProviderInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HvrA provider specific input for failover."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureFailoverProviderInput {
    #[serde(flatten)]
    pub provider_specific_failover_input: ProviderSpecificFailoverInput,
    #[doc = "Location of the vault."]
    #[serde(rename = "vaultLocation", default, skip_serializing_if = "Option::is_none")]
    pub vault_location: Option<String>,
    #[doc = "Primary kek certificate pfx."]
    #[serde(rename = "primaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub primary_kek_certificate_pfx: Option<String>,
    #[doc = "Secondary kek certificate pfx."]
    #[serde(rename = "secondaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub secondary_kek_certificate_pfx: Option<String>,
    #[doc = "The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed."]
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl HyperVReplicaAzureFailoverProviderInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hyper-V Replica Azure specific protection profile details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzurePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "The duration (in hours) to which point the recovery history needs to be maintained."]
    #[serde(rename = "recoveryPointHistoryDurationInHours", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_duration_in_hours: Option<i32>,
    #[doc = "The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM."]
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[doc = "The replication interval."]
    #[serde(rename = "replicationInterval", default, skip_serializing_if = "Option::is_none")]
    pub replication_interval: Option<i32>,
    #[doc = "The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately."]
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[doc = "A value indicating whether encryption is enabled for virtual machines in this cloud."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<String>,
    #[doc = "The active storage account Id."]
    #[serde(rename = "activeStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub active_storage_account_id: Option<String>,
}
impl HyperVReplicaAzurePolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hyper-V Replica Azure specific input for creating a protection profile."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzurePolicyInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[doc = "The duration (in hours) to which point the recovery history needs to be maintained."]
    #[serde(rename = "recoveryPointHistoryDuration", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_duration: Option<i32>,
    #[doc = "The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM."]
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[doc = "The replication interval."]
    #[serde(rename = "replicationInterval", default, skip_serializing_if = "Option::is_none")]
    pub replication_interval: Option<i32>,
    #[doc = "The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately."]
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[doc = "The list of storage accounts to which the VMs in the primary cloud can replicate to."]
    #[serde(rename = "storageAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_accounts: Vec<String>,
}
impl HyperVReplicaAzurePolicyInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hyper V Replica Azure provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[doc = "Azure VM Disk details."]
    #[serde(rename = "azureVmDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_vm_disk_details: Vec<AzureVmDiskDetails>,
    #[doc = "Recovery Azure given name."]
    #[serde(rename = "recoveryAzureVmName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_name: Option<String>,
    #[doc = "The Recovery Azure VM size."]
    #[serde(rename = "recoveryAzureVMSize", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_size: Option<String>,
    #[doc = "The recovery Azure storage account."]
    #[serde(rename = "recoveryAzureStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_storage_account: Option<String>,
    #[doc = "The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection."]
    #[serde(rename = "recoveryAzureLogStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_log_storage_account_id: Option<String>,
    #[doc = "The Last replication time."]
    #[serde(rename = "lastReplicatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_replicated_time: Option<String>,
    #[doc = "Last RPO value."]
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[doc = "The last RPO calculated time."]
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[doc = "The virtual machine Id."]
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[doc = "The protection state for the vm."]
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[doc = "The protection state description for the vm."]
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[doc = "Initial replication details."]
    #[serde(rename = "initialReplicationDetails", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_details: Option<InitialReplicationDetails>,
    #[doc = "The PE Network details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[doc = "The selected recovery azure network Id."]
    #[serde(rename = "selectedRecoveryAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_recovery_azure_network_id: Option<String>,
    #[doc = "The selected source nic Id which will be used as the primary nic during failover."]
    #[serde(rename = "selectedSourceNicId", default, skip_serializing_if = "Option::is_none")]
    pub selected_source_nic_id: Option<String>,
    #[doc = "The encryption info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<String>,
    #[doc = "Disk Details."]
    #[serde(rename = "oSDetails", default, skip_serializing_if = "Option::is_none")]
    pub o_s_details: Option<OsDetails>,
    #[doc = "The RAM size of the VM on the primary side."]
    #[serde(rename = "sourceVmRamSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_ram_size_in_mb: Option<i32>,
    #[doc = "The CPU count of the VM on the primary side."]
    #[serde(rename = "sourceVmCpuCount", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_cpu_count: Option<i32>,
    #[doc = "The selected option to enable RDP\\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum."]
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[doc = "The target resource group Id."]
    #[serde(rename = "recoveryAzureResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_resource_group_id: Option<String>,
    #[doc = "The recovery availability set Id."]
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[doc = "A value indicating whether managed disks should be used during failover."]
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
    #[doc = "License Type of the VM to be used."]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
}
impl HyperVReplicaAzureReplicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure specific reprotect input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[doc = "The Hyper-V host Vm Id."]
    #[serde(rename = "hvHostVmId", default, skip_serializing_if = "Option::is_none")]
    pub hv_host_vm_id: Option<String>,
    #[doc = "The Vm Name."]
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[doc = "The OS type associated with vm."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "The OS disk VHD id associated with vm."]
    #[serde(rename = "vHDId", default, skip_serializing_if = "Option::is_none")]
    pub v_hd_id: Option<String>,
    #[doc = "The storage account name."]
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[doc = "The storage account to be used for logging during replication."]
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
}
impl HyperVReplicaAzureReprotectInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HyperV replica Azure input to update replication protected item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureUpdateReplicationProtectedItemInput {
    #[serde(flatten)]
    pub update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput,
    #[doc = "The recovery Azure resource group Id for classic deployment."]
    #[serde(rename = "recoveryAzureV1ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_v1_resource_group_id: Option<String>,
    #[doc = "The recovery Azure resource group Id for resource manager deployment."]
    #[serde(rename = "recoveryAzureV2ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_v2_resource_group_id: Option<String>,
    #[doc = "A value indicating whether managed disks should be used during failover."]
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
}
impl HyperVReplicaAzureUpdateReplicationProtectedItemInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Abstract model class for event details of a HyperVReplica E2E event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaBaseEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[doc = "The container friendly name."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The fabric friendly name."]
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[doc = "The remote container name."]
    #[serde(rename = "remoteContainerName", default, skip_serializing_if = "Option::is_none")]
    pub remote_container_name: Option<String>,
    #[doc = "The remote fabric name."]
    #[serde(rename = "remoteFabricName", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_name: Option<String>,
}
impl HyperVReplicaBaseEventDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for HyperVReplica policy details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaBasePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "A value indicating the number of recovery points."]
    #[serde(rename = "recoveryPoints", default, skip_serializing_if = "Option::is_none")]
    pub recovery_points: Option<i32>,
    #[doc = "A value indicating the application consistent frequency."]
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[doc = "A value indicating whether compression has to be enabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<String>,
    #[doc = "A value indicating whether IR is online."]
    #[serde(rename = "initialReplicationMethod", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_method: Option<String>,
    #[doc = "A value indicating the online IR start time."]
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[doc = "A value indicating the offline IR import path."]
    #[serde(rename = "offlineReplicationImportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_import_path: Option<String>,
    #[doc = "A value indicating the offline IR export path."]
    #[serde(rename = "offlineReplicationExportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_export_path: Option<String>,
    #[doc = "A value indicating the recovery HTTPS port."]
    #[serde(rename = "replicationPort", default, skip_serializing_if = "Option::is_none")]
    pub replication_port: Option<i32>,
    #[doc = "A value indicating the authentication type."]
    #[serde(rename = "allowedAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub allowed_authentication_type: Option<i32>,
    #[doc = "A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud"]
    #[serde(rename = "replicaDeletionOption", default, skip_serializing_if = "Option::is_none")]
    pub replica_deletion_option: Option<String>,
}
impl HyperVReplicaBasePolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hyper V replica provider specific settings base class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaBaseReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[doc = "The Last replication time."]
    #[serde(rename = "lastReplicatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_replicated_time: Option<String>,
    #[doc = "The PE Network details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[doc = "The virtual machine Id."]
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[doc = "The protection state for the vm."]
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[doc = "The protection state description for the vm."]
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[doc = "Initial replication details."]
    #[serde(rename = "initialReplicationDetails", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_details: Option<InitialReplicationDetails>,
    #[doc = "VM disk details."]
    #[serde(rename = "vMDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub v_m_disk_details: Vec<DiskDetails>,
}
impl HyperVReplicaBaseReplicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hyper-V Replica Blue specific protection profile details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaBluePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "A value indicating the replication interval."]
    #[serde(rename = "replicationFrequencyInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub replication_frequency_in_seconds: Option<i32>,
    #[doc = "A value indicating the number of recovery points."]
    #[serde(rename = "recoveryPoints", default, skip_serializing_if = "Option::is_none")]
    pub recovery_points: Option<i32>,
    #[doc = "A value indicating the application consistent frequency."]
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[doc = "A value indicating whether compression has to be enabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<String>,
    #[doc = "A value indicating whether IR is online."]
    #[serde(rename = "initialReplicationMethod", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_method: Option<String>,
    #[doc = "A value indicating the online IR start time."]
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[doc = "A value indicating the offline IR import path."]
    #[serde(rename = "offlineReplicationImportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_import_path: Option<String>,
    #[doc = "A value indicating the offline IR export path."]
    #[serde(rename = "offlineReplicationExportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_export_path: Option<String>,
    #[doc = "A value indicating the recovery HTTPS port."]
    #[serde(rename = "replicationPort", default, skip_serializing_if = "Option::is_none")]
    pub replication_port: Option<i32>,
    #[doc = "A value indicating the authentication type."]
    #[serde(rename = "allowedAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub allowed_authentication_type: Option<i32>,
    #[doc = "A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud"]
    #[serde(rename = "replicaDeletionOption", default, skip_serializing_if = "Option::is_none")]
    pub replica_deletion_option: Option<String>,
}
impl HyperVReplicaBluePolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HyperV Replica Blue policy input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaBluePolicyInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[doc = "A value indicating the replication interval."]
    #[serde(rename = "replicationFrequencyInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub replication_frequency_in_seconds: Option<i32>,
    #[doc = "A value indicating the number of recovery points."]
    #[serde(rename = "recoveryPoints", default, skip_serializing_if = "Option::is_none")]
    pub recovery_points: Option<i32>,
    #[doc = "A value indicating the application consistent frequency."]
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[doc = "A value indicating whether compression has to be enabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<String>,
    #[doc = "A value indicating whether IR is online."]
    #[serde(rename = "initialReplicationMethod", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_method: Option<String>,
    #[doc = "A value indicating the online IR start time."]
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[doc = "A value indicating the offline IR import path."]
    #[serde(rename = "offlineReplicationImportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_import_path: Option<String>,
    #[doc = "A value indicating the offline IR export path."]
    #[serde(rename = "offlineReplicationExportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_export_path: Option<String>,
    #[doc = "A value indicating the recovery HTTPS port."]
    #[serde(rename = "replicationPort", default, skip_serializing_if = "Option::is_none")]
    pub replication_port: Option<i32>,
    #[doc = "A value indicating the authentication type."]
    #[serde(rename = "allowedAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub allowed_authentication_type: Option<i32>,
    #[doc = "A value indicating whether the VM has to be auto deleted."]
    #[serde(rename = "replicaDeletion", default, skip_serializing_if = "Option::is_none")]
    pub replica_deletion: Option<String>,
}
impl HyperVReplicaBluePolicyInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HyperV replica 2012 R2 (Blue) replication details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaBlueReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[doc = "The Last replication time."]
    #[serde(rename = "lastReplicatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_replicated_time: Option<String>,
    #[doc = "The PE Network details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[doc = "The virtual machine Id."]
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[doc = "The protection state for the vm."]
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[doc = "The protection state description for the vm."]
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[doc = "Initial replication details."]
    #[serde(rename = "initialReplicationDetails", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_details: Option<InitialReplicationDetails>,
    #[doc = "VM disk details."]
    #[serde(rename = "vMDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub v_m_disk_details: Vec<DiskDetails>,
}
impl HyperVReplicaBlueReplicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hyper-V Replica Blue specific protection profile details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaPolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "A value indicating the number of recovery points."]
    #[serde(rename = "recoveryPoints", default, skip_serializing_if = "Option::is_none")]
    pub recovery_points: Option<i32>,
    #[doc = "A value indicating the application consistent frequency."]
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[doc = "A value indicating whether compression has to be enabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<String>,
    #[doc = "A value indicating whether IR is online."]
    #[serde(rename = "initialReplicationMethod", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_method: Option<String>,
    #[doc = "A value indicating the online IR start time."]
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[doc = "A value indicating the offline IR import path."]
    #[serde(rename = "offlineReplicationImportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_import_path: Option<String>,
    #[doc = "A value indicating the offline IR export path."]
    #[serde(rename = "offlineReplicationExportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_export_path: Option<String>,
    #[doc = "A value indicating the recovery HTTPS port."]
    #[serde(rename = "replicationPort", default, skip_serializing_if = "Option::is_none")]
    pub replication_port: Option<i32>,
    #[doc = "A value indicating the authentication type."]
    #[serde(rename = "allowedAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub allowed_authentication_type: Option<i32>,
    #[doc = "A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud"]
    #[serde(rename = "replicaDeletionOption", default, skip_serializing_if = "Option::is_none")]
    pub replica_deletion_option: Option<String>,
}
impl HyperVReplicaPolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hyper-V Replica specific policy Input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaPolicyInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[doc = "A value indicating the number of recovery points."]
    #[serde(rename = "recoveryPoints", default, skip_serializing_if = "Option::is_none")]
    pub recovery_points: Option<i32>,
    #[doc = "A value indicating the application consistent frequency."]
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[doc = "A value indicating whether compression has to be enabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<String>,
    #[doc = "A value indicating whether IR is online."]
    #[serde(rename = "initialReplicationMethod", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_method: Option<String>,
    #[doc = "A value indicating the online IR start time."]
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[doc = "A value indicating the offline IR import path."]
    #[serde(rename = "offlineReplicationImportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_import_path: Option<String>,
    #[doc = "A value indicating the offline IR export path."]
    #[serde(rename = "offlineReplicationExportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_export_path: Option<String>,
    #[doc = "A value indicating the recovery HTTPS port."]
    #[serde(rename = "replicationPort", default, skip_serializing_if = "Option::is_none")]
    pub replication_port: Option<i32>,
    #[doc = "A value indicating the authentication type."]
    #[serde(rename = "allowedAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub allowed_authentication_type: Option<i32>,
    #[doc = "A value indicating whether the VM has to be auto deleted."]
    #[serde(rename = "replicaDeletion", default, skip_serializing_if = "Option::is_none")]
    pub replica_deletion: Option<String>,
}
impl HyperVReplicaPolicyInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HyperV replica 2012 replication details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[doc = "The Last replication time."]
    #[serde(rename = "lastReplicatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_replicated_time: Option<String>,
    #[doc = "The PE Network details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[doc = "The virtual machine Id."]
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[doc = "The protection state for the vm."]
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[doc = "The protection state description for the vm."]
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[doc = "Initial replication details."]
    #[serde(rename = "initialReplicationDetails", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_details: Option<InitialReplicationDetails>,
    #[doc = "VM disk details."]
    #[serde(rename = "vMDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub v_m_disk_details: Vec<DiskDetails>,
}
impl HyperVReplicaReplicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HyperVSite fabric specific details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVSiteDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
}
impl HyperVSiteDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Single Host fabric provider specific VM settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVVirtualMachineDetails {
    #[serde(flatten)]
    pub configuration_settings: ConfigurationSettings,
    #[doc = "The source id of the object."]
    #[serde(rename = "sourceItemId", default, skip_serializing_if = "Option::is_none")]
    pub source_item_id: Option<String>,
    #[doc = "The id of the object in fabric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub generation: Option<String>,
    #[doc = "Disk Details."]
    #[serde(rename = "osDetails", default, skip_serializing_if = "Option::is_none")]
    pub os_details: Option<OsDetails>,
    #[doc = "The Last successful failover time."]
    #[serde(rename = "diskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_details: Vec<DiskDetails>,
    #[doc = "A value indicating whether the VM has a physical disk attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[serde(rename = "hasPhysicalDisk", default, skip_serializing_if = "Option::is_none")]
    pub has_physical_disk: Option<hyper_v_virtual_machine_details::HasPhysicalDisk>,
    #[doc = "A value indicating whether the VM has a fibre channel adapter attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[serde(rename = "hasFibreChannelAdapter", default, skip_serializing_if = "Option::is_none")]
    pub has_fibre_channel_adapter: Option<hyper_v_virtual_machine_details::HasFibreChannelAdapter>,
    #[doc = "A value indicating whether the VM has a shared VHD attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[serde(rename = "hasSharedVhd", default, skip_serializing_if = "Option::is_none")]
    pub has_shared_vhd: Option<hyper_v_virtual_machine_details::HasSharedVhd>,
}
impl HyperVVirtualMachineDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hyper_v_virtual_machine_details {
    use super::*;
    #[doc = "A value indicating whether the VM has a physical disk attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HasPhysicalDisk {
        Unknown,
        Present,
        NotPresent,
    }
    #[doc = "A value indicating whether the VM has a fibre channel adapter attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HasFibreChannelAdapter {
        Unknown,
        Present,
        NotPresent,
    }
    #[doc = "A value indicating whether the VM has a shared VHD attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HasSharedVhd {
        Unknown,
        Present,
        NotPresent,
    }
}
#[doc = "Identity provider details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProviderDetails {
    #[doc = "The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(rename = "applicationId", default, skip_serializing_if = "Option::is_none")]
    pub application_id: Option<String>,
    #[doc = "The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[doc = "The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub audience: Option<String>,
    #[doc = "The base authority for Azure Active Directory authentication."]
    #[serde(rename = "aadAuthority", default, skip_serializing_if = "Option::is_none")]
    pub aad_authority: Option<String>,
}
impl IdentityProviderDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Identity provider input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IdentityProviderInput {
    #[doc = "The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(rename = "tenantId")]
    pub tenant_id: String,
    #[doc = "The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(rename = "applicationId")]
    pub application_id: String,
    #[doc = "The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    #[serde(rename = "objectId")]
    pub object_id: String,
    #[doc = "The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services."]
    pub audience: String,
    #[doc = "The base authority for Azure Active Directory authentication."]
    #[serde(rename = "aadAuthority")]
    pub aad_authority: String,
}
impl IdentityProviderInput {
    pub fn new(tenant_id: String, application_id: String, object_id: String, audience: String, aad_authority: String) -> Self {
        Self {
            tenant_id,
            application_id,
            object_id,
            audience,
            aad_authority,
        }
    }
}
#[doc = "The details of the InMage agent."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAgentDetails {
    #[doc = "The agent version."]
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[doc = "A value indicating whether installed agent needs to be updated."]
    #[serde(rename = "agentUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_update_status: Option<String>,
    #[doc = "A value indicating whether reboot is required after update is applied."]
    #[serde(rename = "postUpdateRebootStatus", default, skip_serializing_if = "Option::is_none")]
    pub post_update_reboot_status: Option<String>,
    #[doc = "Agent expiry date."]
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
}
impl InMageAgentDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMage agent version details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAgentVersionDetails {
    #[doc = "A value indicating whether reboot is required after update is applied."]
    #[serde(rename = "postUpdateRebootStatus", default, skip_serializing_if = "Option::is_none")]
    pub post_update_reboot_status: Option<String>,
    #[doc = "The agent version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[doc = "Version expiry date."]
    #[serde(rename = "expiryDate", default, skip_serializing_if = "Option::is_none")]
    pub expiry_date: Option<String>,
    #[doc = "A value indicating whether security update required."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<in_mage_agent_version_details::Status>,
}
impl InMageAgentVersionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod in_mage_agent_version_details {
    use super::*;
    #[doc = "A value indicating whether security update required."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Supported,
        NotSupported,
        Deprecated,
        UpdateRequired,
        SecurityUpdateRequired,
    }
}
#[doc = "ApplyRecoveryPoint input specific to InMageAzureV2 provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2ApplyRecoveryPointInput {
    #[serde(flatten)]
    pub apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput,
    #[doc = "The vault location where the recovery Vm resides."]
    #[serde(rename = "vaultLocation", default, skip_serializing_if = "Option::is_none")]
    pub vault_location: Option<String>,
}
impl InMageAzureV2ApplyRecoveryPointInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMware Azure specific enable protection input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2EnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[doc = "The Master target Id."]
    #[serde(rename = "masterTargetId", default, skip_serializing_if = "Option::is_none")]
    pub master_target_id: Option<String>,
    #[doc = "The Process Server Id."]
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[doc = "The storage account name."]
    #[serde(rename = "storageAccountId")]
    pub storage_account_id: String,
    #[doc = "The CS account Id."]
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[doc = "The multi vm group Id."]
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[doc = "The multi vm group name."]
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[doc = "The disks to include list."]
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<String>,
    #[doc = "The selected target Azure network Id."]
    #[serde(rename = "targetAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_network_id: Option<String>,
    #[doc = "The selected target Azure subnet Id."]
    #[serde(rename = "targetAzureSubnetId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_subnet_id: Option<String>,
    #[doc = "The selected option to enable RDP\\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum."]
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[doc = "The target azure Vm Name."]
    #[serde(rename = "targetAzureVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_vm_name: Option<String>,
    #[doc = "The storage account to be used for logging during replication."]
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[doc = "The Id of the target resource group (for classic deployment) in which the failover VM is to be created."]
    #[serde(rename = "targetAzureV1ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_v1_resource_group_id: Option<String>,
    #[doc = "The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created."]
    #[serde(rename = "targetAzureV2ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_v2_resource_group_id: Option<String>,
    #[doc = "A value indicating whether managed disks should be used during failover."]
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
}
impl InMageAzureV2EnableProtectionInput {
    pub fn new(storage_account_id: String) -> Self {
        Self {
            enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput::default(),
            master_target_id: None,
            process_server_id: None,
            storage_account_id,
            run_as_account_id: None,
            multi_vm_group_id: None,
            multi_vm_group_name: None,
            disks_to_include: Vec::new(),
            target_azure_network_id: None,
            target_azure_subnet_id: None,
            enable_rdp_on_target_option: None,
            target_azure_vm_name: None,
            log_storage_account_id: None,
            target_azure_v1_resource_group_id: None,
            target_azure_v2_resource_group_id: None,
            use_managed_disks: None,
        }
    }
}
#[doc = "Model class for event details of a VMwareAzureV2 event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2EventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[doc = "InMage Event type. Takes one of the values of {InMageDataContract.InMageMonitoringEventType}."]
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[doc = "InMage Event Category."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[doc = "InMage Event Component."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub component: Option<String>,
    #[doc = "Corrective Action string for the event."]
    #[serde(rename = "correctiveAction", default, skip_serializing_if = "Option::is_none")]
    pub corrective_action: Option<String>,
    #[doc = "InMage Event Details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
    #[doc = "InMage Event Summary."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub summary: Option<String>,
    #[doc = "VMware Site name."]
    #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
    pub site_name: Option<String>,
}
impl InMageAzureV2EventDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMageAzureV2 provider specific input for failover."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2FailoverProviderInput {
    #[serde(flatten)]
    pub provider_specific_failover_input: ProviderSpecificFailoverInput,
    #[doc = "Location of the vault."]
    #[serde(rename = "vaultLocation", default, skip_serializing_if = "Option::is_none")]
    pub vault_location: Option<String>,
    #[doc = "The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed."]
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl InMageAzureV2FailoverProviderInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMage Azure v2 specific protection profile details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2PolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "The crash consistent snapshot frequency in minutes."]
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "The recovery point threshold in minutes."]
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[doc = "The app consistent snapshot frequency in minutes."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "A value indicating whether multi-VM sync has to be enabled."]
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
}
impl InMageAzureV2PolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMWare Azure specific policy Input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2PolicyInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[doc = "The recovery point threshold in minutes."]
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[doc = "The crash consistent snapshot frequency (in minutes)."]
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "The app consistent snapshot frequency (in minutes)."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'."]
    #[serde(rename = "multiVmSyncStatus")]
    pub multi_vm_sync_status: in_mage_azure_v2_policy_input::MultiVmSyncStatus,
}
impl InMageAzureV2PolicyInput {
    pub fn new(multi_vm_sync_status: in_mage_azure_v2_policy_input::MultiVmSyncStatus) -> Self {
        Self {
            policy_provider_specific_input: PolicyProviderSpecificInput::default(),
            recovery_point_threshold_in_minutes: None,
            recovery_point_history: None,
            crash_consistent_frequency_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status,
        }
    }
}
pub mod in_mage_azure_v2_policy_input {
    use super::*;
    #[doc = "A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncStatus {
        Enable,
        Disable,
    }
}
#[doc = "InMageAzureV2 protected disk details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2ProtectedDiskDetails {
    #[doc = "The disk id."]
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[doc = "The disk name."]
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[doc = "The protection stage."]
    #[serde(rename = "protectionStage", default, skip_serializing_if = "Option::is_none")]
    pub protection_stage: Option<String>,
    #[doc = "The health error code for the disk."]
    #[serde(rename = "healthErrorCode", default, skip_serializing_if = "Option::is_none")]
    pub health_error_code: Option<String>,
    #[doc = "The RPO in seconds."]
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[doc = "A value indicating whether resync is required for this disk."]
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<String>,
    #[doc = "The resync progress percentage."]
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[doc = "The resync duration in seconds."]
    #[serde(rename = "resyncDurationInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub resync_duration_in_seconds: Option<i64>,
    #[doc = "The disk capacity in bytes."]
    #[serde(rename = "diskCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_capacity_in_bytes: Option<i64>,
    #[doc = "The disk file system capacity in bytes."]
    #[serde(rename = "fileSystemCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub file_system_capacity_in_bytes: Option<i64>,
    #[doc = "The source data transit in MB."]
    #[serde(rename = "sourceDataInMegaBytes", default, skip_serializing_if = "Option::is_none")]
    pub source_data_in_mega_bytes: Option<f64>,
    #[doc = "The PS data transit in MB."]
    #[serde(rename = "psDataInMegaBytes", default, skip_serializing_if = "Option::is_none")]
    pub ps_data_in_mega_bytes: Option<f64>,
    #[doc = "The target data transit in MB."]
    #[serde(rename = "targetDataInMegaBytes", default, skip_serializing_if = "Option::is_none")]
    pub target_data_in_mega_bytes: Option<f64>,
    #[doc = "A value indicating whether disk is resized."]
    #[serde(rename = "diskResized", default, skip_serializing_if = "Option::is_none")]
    pub disk_resized: Option<String>,
    #[doc = "The last RPO calculated time."]
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
}
impl InMageAzureV2ProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMage Azure V2 provider specific recovery point details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2RecoveryPointDetails {
    #[serde(flatten)]
    pub provider_specific_recovery_point_details: ProviderSpecificRecoveryPointDetails,
    #[doc = "A value indicating whether the recovery point is multi VM consistent."]
    #[serde(rename = "isMultiVmSyncPoint", default, skip_serializing_if = "Option::is_none")]
    pub is_multi_vm_sync_point: Option<String>,
}
impl InMageAzureV2RecoveryPointDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMageAzureV2 provider specific settings"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2ReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[doc = "The infrastructure VM Id."]
    #[serde(rename = "infrastructureVmId", default, skip_serializing_if = "Option::is_none")]
    pub infrastructure_vm_id: Option<String>,
    #[doc = "The vCenter infrastructure Id."]
    #[serde(rename = "vCenterInfrastructureId", default, skip_serializing_if = "Option::is_none")]
    pub v_center_infrastructure_id: Option<String>,
    #[doc = "The protection stage."]
    #[serde(rename = "protectionStage", default, skip_serializing_if = "Option::is_none")]
    pub protection_stage: Option<String>,
    #[doc = "The virtual machine Id."]
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[doc = "The protection state for the vm."]
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[doc = "The protection state description for the vm."]
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[doc = "The resync progress percentage."]
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[doc = "The RPO in seconds."]
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[doc = "The compressed data change rate in MB."]
    #[serde(rename = "compressedDataRateInMB", default, skip_serializing_if = "Option::is_none")]
    pub compressed_data_rate_in_mb: Option<f64>,
    #[doc = "The uncompressed data change rate in MB."]
    #[serde(rename = "uncompressedDataRateInMB", default, skip_serializing_if = "Option::is_none")]
    pub uncompressed_data_rate_in_mb: Option<f64>,
    #[doc = "The source IP address."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The agent version."]
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[doc = "Agent expiry date."]
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
    #[doc = "A value indicating whether installed agent needs to be updated."]
    #[serde(rename = "isAgentUpdateRequired", default, skip_serializing_if = "Option::is_none")]
    pub is_agent_update_required: Option<String>,
    #[doc = "A value indicating whether the source server requires a restart after update."]
    #[serde(rename = "isRebootAfterUpdateRequired", default, skip_serializing_if = "Option::is_none")]
    pub is_reboot_after_update_required: Option<String>,
    #[doc = "The last heartbeat received from the source server."]
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[doc = "The process server Id."]
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[doc = "The multi vm group Id."]
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[doc = "The multi vm group name."]
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[doc = "A value indicating whether multi vm sync is enabled or disabled."]
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
    #[doc = "The list of protected disks."]
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<InMageAzureV2ProtectedDiskDetails>,
    #[doc = "A value indicating whether any disk is resized for this VM."]
    #[serde(rename = "diskResized", default, skip_serializing_if = "Option::is_none")]
    pub disk_resized: Option<String>,
    #[doc = "The master target Id."]
    #[serde(rename = "masterTargetId", default, skip_serializing_if = "Option::is_none")]
    pub master_target_id: Option<String>,
    #[doc = "The CPU count of the VM on the primary side."]
    #[serde(rename = "sourceVmCpuCount", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_cpu_count: Option<i32>,
    #[doc = "The RAM size of the VM on the primary side."]
    #[serde(rename = "sourceVmRamSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_ram_size_in_mb: Option<i32>,
    #[doc = "The type of the OS on the VM."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "The OS disk VHD name."]
    #[serde(rename = "vhdName", default, skip_serializing_if = "Option::is_none")]
    pub vhd_name: Option<String>,
    #[doc = "The id of the disk containing the OS."]
    #[serde(rename = "osDiskId", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_id: Option<String>,
    #[doc = "Azure VM Disk details."]
    #[serde(rename = "azureVMDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_vm_disk_details: Vec<AzureVmDiskDetails>,
    #[doc = "Recovery Azure given name."]
    #[serde(rename = "recoveryAzureVMName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_name: Option<String>,
    #[doc = "The Recovery Azure VM size."]
    #[serde(rename = "recoveryAzureVMSize", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_size: Option<String>,
    #[doc = "The recovery Azure storage account."]
    #[serde(rename = "recoveryAzureStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_storage_account: Option<String>,
    #[doc = "The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection."]
    #[serde(rename = "recoveryAzureLogStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_log_storage_account_id: Option<String>,
    #[doc = "The PE Network details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[doc = "The selected recovery azure network Id."]
    #[serde(rename = "selectedRecoveryAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_recovery_azure_network_id: Option<String>,
    #[doc = "The selected source nic Id which will be used as the primary nic during failover."]
    #[serde(rename = "selectedSourceNicId", default, skip_serializing_if = "Option::is_none")]
    pub selected_source_nic_id: Option<String>,
    #[doc = "A value indicating the discovery type of the machine. Value can be vCenter or physical."]
    #[serde(rename = "discoveryType", default, skip_serializing_if = "Option::is_none")]
    pub discovery_type: Option<String>,
    #[doc = "The selected option to enable RDP\\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum."]
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[doc = "The data stores of the on-premise machine. Value can be list of strings that contain data store names."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datastores: Vec<String>,
    #[doc = "The ARM Id of the target Azure VM. This value will be null until the VM is failed over. Only after failure it will be populated with the ARM Id of the Azure VM."]
    #[serde(rename = "targetVmId", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_id: Option<String>,
    #[doc = "The target resource group Id."]
    #[serde(rename = "recoveryAzureResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_resource_group_id: Option<String>,
    #[doc = "The recovery availability set Id."]
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[doc = "A value indicating whether managed disks should be used during failover."]
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
    #[doc = "License Type of the VM to be used."]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[doc = "The validation errors of the on-premise machine Value can be list of validation errors."]
    #[serde(rename = "validationErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_errors: Vec<HealthError>,
    #[doc = "The last RPO calculated time."]
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[doc = "The last update time received from on-prem components."]
    #[serde(rename = "lastUpdateReceivedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_update_received_time: Option<String>,
    #[doc = "The replica id of the protected item."]
    #[serde(rename = "replicaId", default, skip_serializing_if = "Option::is_none")]
    pub replica_id: Option<String>,
    #[doc = "The OS Version of the protected item."]
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
}
impl InMageAzureV2ReplicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMageAzureV2 specific provider input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2ReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[doc = "The Master target Id."]
    #[serde(rename = "masterTargetId", default, skip_serializing_if = "Option::is_none")]
    pub master_target_id: Option<String>,
    #[doc = "The Process Server Id."]
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[doc = "The storage account id."]
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[doc = "The CS account Id."]
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[doc = "The Policy Id."]
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[doc = "The storage account to be used for logging during replication."]
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[doc = "The disks to include list."]
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<String>,
}
impl InMageAzureV2ReprotectInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMage Azure V2 input to update replication protected item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2UpdateReplicationProtectedItemInput {
    #[serde(flatten)]
    pub update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput,
    #[doc = "The recovery Azure resource group Id for classic deployment."]
    #[serde(rename = "recoveryAzureV1ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_v1_resource_group_id: Option<String>,
    #[doc = "The recovery Azure resource group Id for resource manager deployment."]
    #[serde(rename = "recoveryAzureV2ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_v2_resource_group_id: Option<String>,
    #[doc = "A value indicating whether managed disks should be used during failover."]
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
}
impl InMageAzureV2UpdateReplicationProtectedItemInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for the policies of providers using InMage replication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageBasePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "The recovery point threshold in minutes."]
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[doc = "The app consistent snapshot frequency in minutes."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "A value indicating whether multi-VM sync has to be enabled."]
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
}
impl InMageBasePolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMage disable protection provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageDisableProtectionProviderSpecificInput {
    #[serde(flatten)]
    pub disable_protection_provider_specific_input: DisableProtectionProviderSpecificInput,
    #[doc = "A value indicating whether the replica VM should be destroyed or retained. Values from Delete and Retain."]
    #[serde(rename = "replicaVmDeletionStatus", default, skip_serializing_if = "Option::is_none")]
    pub replica_vm_deletion_status: Option<String>,
}
impl InMageDisableProtectionProviderSpecificInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMware/Physical specific Disk Details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageDiskDetails {
    #[doc = "The disk Id."]
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[doc = "The disk name."]
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[doc = "The disk size in MB."]
    #[serde(rename = "diskSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_in_mb: Option<String>,
    #[doc = "Whether disk is system disk or data disk."]
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<String>,
    #[doc = "Whether disk is dynamic disk or basic disk."]
    #[serde(rename = "diskConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub disk_configuration: Option<String>,
    #[doc = "Volumes of the disk."]
    #[serde(rename = "volumeList", default, skip_serializing_if = "Vec::is_empty")]
    pub volume_list: Vec<DiskVolumeDetails>,
}
impl InMageDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DiskExclusionInput when doing enable protection of virtual machine in InMage provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageDiskExclusionInput {
    #[doc = "The volume label based option for disk exclusion."]
    #[serde(rename = "volumeOptions", default, skip_serializing_if = "Vec::is_empty")]
    pub volume_options: Vec<InMageVolumeExclusionOptions>,
    #[doc = "The guest disk signature based option for disk exclusion."]
    #[serde(rename = "diskSignatureOptions", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_signature_options: Vec<InMageDiskSignatureExclusionOptions>,
}
impl InMageDiskExclusionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageDiskSignatureExclusionOptions {
    #[doc = "The guest signature of disk to be excluded from replication."]
    #[serde(rename = "diskSignature", default, skip_serializing_if = "Option::is_none")]
    pub disk_signature: Option<String>,
}
impl InMageDiskSignatureExclusionOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMware Azure specific enable protection input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageEnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[doc = "The Vm Name."]
    #[serde(rename = "vmFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub vm_friendly_name: Option<String>,
    #[doc = "The Master Target Id."]
    #[serde(rename = "masterTargetId")]
    pub master_target_id: String,
    #[doc = "The Process Server Id."]
    #[serde(rename = "processServerId")]
    pub process_server_id: String,
    #[doc = "The retention drive to use on the MT."]
    #[serde(rename = "retentionDrive")]
    pub retention_drive: String,
    #[doc = "The CS account Id."]
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[doc = "The multi vm group Id."]
    #[serde(rename = "multiVmGroupId")]
    pub multi_vm_group_id: String,
    #[doc = "The multi vm group name."]
    #[serde(rename = "multiVmGroupName")]
    pub multi_vm_group_name: String,
    #[doc = "The target data store name."]
    #[serde(rename = "datastoreName", default, skip_serializing_if = "Option::is_none")]
    pub datastore_name: Option<String>,
    #[doc = "DiskExclusionInput when doing enable protection of virtual machine in InMage provider."]
    #[serde(rename = "diskExclusionInput", default, skip_serializing_if = "Option::is_none")]
    pub disk_exclusion_input: Option<InMageDiskExclusionInput>,
    #[doc = "The disks to include list."]
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<String>,
}
impl InMageEnableProtectionInput {
    pub fn new(
        master_target_id: String,
        process_server_id: String,
        retention_drive: String,
        multi_vm_group_id: String,
        multi_vm_group_name: String,
    ) -> Self {
        Self {
            enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput::default(),
            vm_friendly_name: None,
            master_target_id,
            process_server_id,
            retention_drive,
            run_as_account_id: None,
            multi_vm_group_id,
            multi_vm_group_name,
            datastore_name: None,
            disk_exclusion_input: None,
            disks_to_include: Vec::new(),
        }
    }
}
#[doc = "Provider specific input for InMage failover."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageFailoverProviderInput {
    #[serde(flatten)]
    pub provider_specific_failover_input: ProviderSpecificFailoverInput,
    #[doc = "The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In the other two cases, recovery point id will be ignored."]
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<in_mage_failover_provider_input::RecoveryPointType>,
    #[doc = "The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed."]
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl InMageFailoverProviderInput {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod in_mage_failover_provider_input {
    use super::*;
    #[doc = "The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In the other two cases, recovery point id will be ignored."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        LatestTime,
        LatestTag,
        Custom,
    }
}
#[doc = "InMage specific protection profile details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMagePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "The recovery point threshold in minutes."]
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[doc = "The app consistent snapshot frequency in minutes."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "A value indicating whether multi-VM sync has to be enabled."]
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
}
impl InMagePolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMWare Azure specific protection profile Input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMagePolicyInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[doc = "The recovery point threshold in minutes."]
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[doc = "The app consistent snapshot frequency (in minutes)."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'."]
    #[serde(rename = "multiVmSyncStatus")]
    pub multi_vm_sync_status: in_mage_policy_input::MultiVmSyncStatus,
}
impl InMagePolicyInput {
    pub fn new(multi_vm_sync_status: in_mage_policy_input::MultiVmSyncStatus) -> Self {
        Self {
            policy_provider_specific_input: PolicyProviderSpecificInput::default(),
            recovery_point_threshold_in_minutes: None,
            recovery_point_history: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status,
        }
    }
}
pub mod in_mage_policy_input {
    use super::*;
    #[doc = "A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncStatus {
        Enable,
        Disable,
    }
}
#[doc = "InMage protected disk details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageProtectedDiskDetails {
    #[doc = "The disk id."]
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[doc = "The disk name."]
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[doc = "The protection stage."]
    #[serde(rename = "protectionStage", default, skip_serializing_if = "Option::is_none")]
    pub protection_stage: Option<String>,
    #[doc = "The health error code for the disk."]
    #[serde(rename = "healthErrorCode", default, skip_serializing_if = "Option::is_none")]
    pub health_error_code: Option<String>,
    #[doc = "The RPO in seconds."]
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[doc = "A value indicating whether resync is required for this disk."]
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<String>,
    #[doc = "The resync progress percentage."]
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[doc = "The resync duration in seconds."]
    #[serde(rename = "resyncDurationInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub resync_duration_in_seconds: Option<i64>,
    #[doc = "The disk capacity in bytes."]
    #[serde(rename = "diskCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_capacity_in_bytes: Option<i64>,
    #[doc = "The file system capacity in bytes."]
    #[serde(rename = "fileSystemCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub file_system_capacity_in_bytes: Option<i64>,
    #[doc = "The source data transit in MB."]
    #[serde(rename = "sourceDataInMB", default, skip_serializing_if = "Option::is_none")]
    pub source_data_in_mb: Option<f64>,
    #[doc = "The PS data transit in MB."]
    #[serde(rename = "psDataInMB", default, skip_serializing_if = "Option::is_none")]
    pub ps_data_in_mb: Option<f64>,
    #[doc = "The target data transit in MB."]
    #[serde(rename = "targetDataInMB", default, skip_serializing_if = "Option::is_none")]
    pub target_data_in_mb: Option<f64>,
    #[doc = "A value indicating whether disk is resized."]
    #[serde(rename = "diskResized", default, skip_serializing_if = "Option::is_none")]
    pub disk_resized: Option<String>,
    #[doc = "The last RPO calculated time."]
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
}
impl InMageProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMage provider specific settings"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[doc = "The active location of the VM. If the VM is being protected from Azure, this field will take values from { Azure, OnPrem }. If the VM is being protected between two data-centers, this field will be OnPrem always."]
    #[serde(rename = "activeSiteType", default, skip_serializing_if = "Option::is_none")]
    pub active_site_type: Option<String>,
    #[doc = "The CPU count of the VM on the primary side."]
    #[serde(rename = "sourceVmCpuCount", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_cpu_count: Option<i32>,
    #[doc = "The RAM size of the VM on the primary side."]
    #[serde(rename = "sourceVmRamSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_ram_size_in_mb: Option<i32>,
    #[doc = "Details of the OS Disk."]
    #[serde(rename = "osDetails", default, skip_serializing_if = "Option::is_none")]
    pub os_details: Option<OsDiskDetails>,
    #[doc = "The protection stage."]
    #[serde(rename = "protectionStage", default, skip_serializing_if = "Option::is_none")]
    pub protection_stage: Option<String>,
    #[doc = "The virtual machine Id."]
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[doc = "The protection state for the vm."]
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[doc = "The protection state description for the vm."]
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[doc = "Initial replication details."]
    #[serde(rename = "resyncDetails", default, skip_serializing_if = "Option::is_none")]
    pub resync_details: Option<InitialReplicationDetails>,
    #[doc = "The retention window start time."]
    #[serde(rename = "retentionWindowStart", default, skip_serializing_if = "Option::is_none")]
    pub retention_window_start: Option<String>,
    #[doc = "The retention window end time."]
    #[serde(rename = "retentionWindowEnd", default, skip_serializing_if = "Option::is_none")]
    pub retention_window_end: Option<String>,
    #[doc = "The compressed data change rate in MB."]
    #[serde(rename = "compressedDataRateInMB", default, skip_serializing_if = "Option::is_none")]
    pub compressed_data_rate_in_mb: Option<f64>,
    #[doc = "The uncompressed data change rate in MB."]
    #[serde(rename = "uncompressedDataRateInMB", default, skip_serializing_if = "Option::is_none")]
    pub uncompressed_data_rate_in_mb: Option<f64>,
    #[doc = "The RPO in seconds."]
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[doc = "The list of protected disks."]
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<InMageProtectedDiskDetails>,
    #[doc = "The source IP address."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The last heartbeat received from the source server."]
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[doc = "The process server Id."]
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[doc = "The master target Id."]
    #[serde(rename = "masterTargetId", default, skip_serializing_if = "Option::is_none")]
    pub master_target_id: Option<String>,
    #[doc = "The collection of Consistency points."]
    #[serde(rename = "consistencyPoints", default, skip_serializing_if = "Option::is_none")]
    pub consistency_points: Option<serde_json::Value>,
    #[doc = "A value indicating whether any disk is resized for this VM."]
    #[serde(rename = "diskResized", default, skip_serializing_if = "Option::is_none")]
    pub disk_resized: Option<String>,
    #[doc = "A value indicating whether the source server requires a restart after update."]
    #[serde(rename = "rebootAfterUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub reboot_after_update_status: Option<String>,
    #[doc = "The multi vm group Id, if any."]
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[doc = "The multi vm group name, if any."]
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[doc = "A value indicating whether the multi vm sync is enabled or disabled."]
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
    #[doc = "The details of the InMage agent."]
    #[serde(rename = "agentDetails", default, skip_serializing_if = "Option::is_none")]
    pub agent_details: Option<InMageAgentDetails>,
    #[doc = "The vCenter infrastructure Id."]
    #[serde(rename = "vCenterInfrastructureId", default, skip_serializing_if = "Option::is_none")]
    pub v_center_infrastructure_id: Option<String>,
    #[doc = "The infrastructure VM Id."]
    #[serde(rename = "infrastructureVmId", default, skip_serializing_if = "Option::is_none")]
    pub infrastructure_vm_id: Option<String>,
    #[doc = "The PE Network details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[doc = "A value indicating the discovery type of the machine."]
    #[serde(rename = "discoveryType", default, skip_serializing_if = "Option::is_none")]
    pub discovery_type: Option<String>,
    #[doc = "A value indicating the underlying Azure storage account. If the VM is not running in Azure, this value shall be set to null."]
    #[serde(rename = "azureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub azure_storage_account_id: Option<String>,
    #[doc = "The data stores of the on-premise machine Value can be list of strings that contain data store names"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datastores: Vec<String>,
    #[doc = "The validation errors of the on-premise machine Value can be list of validation errors"]
    #[serde(rename = "validationErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_errors: Vec<HealthError>,
    #[doc = "The last RPO calculated time."]
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[doc = "The last update time received from on-prem components."]
    #[serde(rename = "lastUpdateReceivedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_update_received_time: Option<String>,
    #[doc = "The replica id of the protected item."]
    #[serde(rename = "replicaId", default, skip_serializing_if = "Option::is_none")]
    pub replica_id: Option<String>,
    #[doc = "The OS Version of the protected item."]
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
}
impl InMageReplicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "InMageAzureV2 specific provider input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[doc = "The Master Target Id."]
    #[serde(rename = "masterTargetId")]
    pub master_target_id: String,
    #[doc = "The Process Server Id."]
    #[serde(rename = "processServerId")]
    pub process_server_id: String,
    #[doc = "The retention drive to use on the MT."]
    #[serde(rename = "retentionDrive")]
    pub retention_drive: String,
    #[doc = "The CS account Id."]
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[doc = "The target data store name."]
    #[serde(rename = "datastoreName", default, skip_serializing_if = "Option::is_none")]
    pub datastore_name: Option<String>,
    #[doc = "DiskExclusionInput when doing enable protection of virtual machine in InMage provider."]
    #[serde(rename = "diskExclusionInput", default, skip_serializing_if = "Option::is_none")]
    pub disk_exclusion_input: Option<InMageDiskExclusionInput>,
    #[doc = "The Policy Id."]
    #[serde(rename = "profileId")]
    pub profile_id: String,
    #[doc = "The disks to include list."]
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<String>,
}
impl InMageReprotectInput {
    pub fn new(master_target_id: String, process_server_id: String, retention_drive: String, profile_id: String) -> Self {
        Self {
            reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput::default(),
            master_target_id,
            process_server_id,
            retention_drive,
            run_as_account_id: None,
            datastore_name: None,
            disk_exclusion_input: None,
            profile_id,
            disks_to_include: Vec::new(),
        }
    }
}
#[doc = "Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageVolumeExclusionOptions {
    #[doc = "The volume label. The disk having any volume with this label will be excluded from replication."]
    #[serde(rename = "volumeLabel", default, skip_serializing_if = "Option::is_none")]
    pub volume_label: Option<String>,
    #[doc = "The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume has label matching with VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false."]
    #[serde(rename = "onlyExcludeIfSingleVolume", default, skip_serializing_if = "Option::is_none")]
    pub only_exclude_if_single_volume: Option<String>,
}
impl InMageVolumeExclusionOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class stores the monitoring details for consistency check of inconsistent Protected Entity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InconsistentVmDetails {
    #[doc = "The Vm name."]
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[doc = "The Cloud name."]
    #[serde(rename = "cloudName", default, skip_serializing_if = "Option::is_none")]
    pub cloud_name: Option<String>,
    #[doc = "The list of details regarding state of the Protected Entity in SRS and On prem."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<String>,
    #[doc = "The list of error ids."]
    #[serde(rename = "errorIds", default, skip_serializing_if = "Vec::is_empty")]
    pub error_ids: Vec<String>,
}
impl InconsistentVmDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Initial replication details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InitialReplicationDetails {
    #[doc = "Initial replication type."]
    #[serde(rename = "initialReplicationType", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_type: Option<String>,
    #[doc = "The initial replication progress percentage."]
    #[serde(rename = "initialReplicationProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_progress_percentage: Option<String>,
}
impl InitialReplicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents the inline workflow task details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InlineWorkflowTaskDetails {
    #[serde(flatten)]
    pub group_task_details: GroupTaskDetails,
    #[doc = "The list of child workflow ids."]
    #[serde(rename = "workflowIds", default, skip_serializing_if = "Vec::is_empty")]
    pub workflow_ids: Vec<String>,
}
impl InlineWorkflowTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Implements InnerHealthError class. HealthError object has a list of InnerHealthErrors as child errors. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InnerHealthError {
    #[doc = "Source of error."]
    #[serde(rename = "errorSource", default, skip_serializing_if = "Option::is_none")]
    pub error_source: Option<String>,
    #[doc = "Type of error."]
    #[serde(rename = "errorType", default, skip_serializing_if = "Option::is_none")]
    pub error_type: Option<String>,
    #[doc = "Level of error."]
    #[serde(rename = "errorLevel", default, skip_serializing_if = "Option::is_none")]
    pub error_level: Option<String>,
    #[doc = "Category of error."]
    #[serde(rename = "errorCategory", default, skip_serializing_if = "Option::is_none")]
    pub error_category: Option<String>,
    #[doc = "Error code."]
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[doc = "Summary message of the entity."]
    #[serde(rename = "summaryMessage", default, skip_serializing_if = "Option::is_none")]
    pub summary_message: Option<String>,
    #[doc = "Error message."]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[doc = "Possible causes of error."]
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[doc = "Recommended action to resolve error."]
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
    #[doc = "Error creation time (UTC)"]
    #[serde(rename = "creationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub creation_time_utc: Option<String>,
    #[doc = "DRA error message."]
    #[serde(rename = "recoveryProviderErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub recovery_provider_error_message: Option<String>,
    #[doc = "ID of the entity."]
    #[serde(rename = "entityId", default, skip_serializing_if = "Option::is_none")]
    pub entity_id: Option<String>,
}
impl InnerHealthError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM input endpoint details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InputEndpoint {
    #[doc = "The input endpoint name."]
    #[serde(rename = "endpointName", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    #[doc = "The input endpoint private port."]
    #[serde(rename = "privatePort", default, skip_serializing_if = "Option::is_none")]
    pub private_port: Option<i32>,
    #[doc = "The input endpoint public port."]
    #[serde(rename = "publicPort", default, skip_serializing_if = "Option::is_none")]
    pub public_port: Option<i32>,
    #[doc = "The input endpoint protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<String>,
}
impl InputEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Job details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Job {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Job custom data details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobProperties>,
}
impl Job {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of jobs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobCollection {
    #[doc = "The list of jobs."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Job>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Job details based on specific job type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobDetails {
    #[doc = "Gets the type of job details (see JobDetailsTypes enum for possible values)."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    #[doc = "The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details."]
    #[serde(rename = "affectedObjectDetails", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_details: Option<serde_json::Value>,
}
impl JobDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class contains the minimal job details required to navigate to the desired drill down."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobEntity {
    #[doc = "The job id."]
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[doc = "The job display name."]
    #[serde(rename = "jobFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub job_friendly_name: Option<String>,
    #[doc = "The object id."]
    #[serde(rename = "targetObjectId", default, skip_serializing_if = "Option::is_none")]
    pub target_object_id: Option<String>,
    #[doc = "The object name."]
    #[serde(rename = "targetObjectName", default, skip_serializing_if = "Option::is_none")]
    pub target_object_name: Option<String>,
    #[doc = "The workflow affected object type."]
    #[serde(rename = "targetInstanceType", default, skip_serializing_if = "Option::is_none")]
    pub target_instance_type: Option<String>,
    #[doc = "The job name. Enum type ScenarioName."]
    #[serde(rename = "jobScenarioName", default, skip_serializing_if = "Option::is_none")]
    pub job_scenario_name: Option<String>,
}
impl JobEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class contains the error details per object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobErrorDetails {
    #[doc = "ASR error model"]
    #[serde(rename = "serviceErrorDetails", default, skip_serializing_if = "Option::is_none")]
    pub service_error_details: Option<ServiceError>,
    #[doc = "This class contains the error details per object."]
    #[serde(rename = "providerErrorDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_error_details: Option<ProviderError>,
    #[doc = "Error level of error."]
    #[serde(rename = "errorLevel", default, skip_serializing_if = "Option::is_none")]
    pub error_level: Option<String>,
    #[doc = "The creation time of job error."]
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[doc = "The Id of the task."]
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
}
impl JobErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Job custom data details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobProperties {
    #[doc = "The activity id."]
    #[serde(rename = "activityId", default, skip_serializing_if = "Option::is_none")]
    pub activity_id: Option<String>,
    #[doc = "The ScenarioName."]
    #[serde(rename = "scenarioName", default, skip_serializing_if = "Option::is_none")]
    pub scenario_name: Option<String>,
    #[doc = "The DisplayName."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The status of the Job. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The description of the state of the Job. For e.g. - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped."]
    #[serde(rename = "stateDescription", default, skip_serializing_if = "Option::is_none")]
    pub state_description: Option<String>,
    #[doc = "The tasks."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tasks: Vec<AsrTask>,
    #[doc = "The errors."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<JobErrorDetails>,
    #[doc = "The start time."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The Allowed action the job."]
    #[serde(rename = "allowedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_actions: Vec<String>,
    #[doc = "The affected Object Id."]
    #[serde(rename = "targetObjectId", default, skip_serializing_if = "Option::is_none")]
    pub target_object_id: Option<String>,
    #[doc = "The name of the affected object."]
    #[serde(rename = "targetObjectName", default, skip_serializing_if = "Option::is_none")]
    pub target_object_name: Option<String>,
    #[doc = "The type of the affected object which is of {Microsoft.Azure.SiteRecovery.V2015_11_10.AffectedObjectType} class."]
    #[serde(rename = "targetInstanceType", default, skip_serializing_if = "Option::is_none")]
    pub target_instance_type: Option<String>,
    #[doc = "Job details based on specific job type."]
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<JobDetails>,
}
impl JobProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Query parameter to enumerate jobs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobQueryParameter {
    #[doc = "Date time to get jobs from."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "Date time to get jobs up to."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The Id of the fabric to search jobs under."]
    #[serde(rename = "fabricId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_id: Option<String>,
    #[doc = "The type of objects."]
    #[serde(rename = "affectedObjectTypes", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_types: Option<String>,
    #[doc = "The states of the job to be filtered can be in."]
    #[serde(rename = "jobStatus", default, skip_serializing_if = "Option::is_none")]
    pub job_status: Option<String>,
}
impl JobQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Model class for event details of a job status event."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobStatusEventDetails {
    #[serde(flatten)]
    pub event_specific_details: EventSpecificDetails,
    #[doc = "Job arm id for the event."]
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[doc = "JobName for the Event."]
    #[serde(rename = "jobFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub job_friendly_name: Option<String>,
    #[doc = "JobStatus for the Event."]
    #[serde(rename = "jobStatus", default, skip_serializing_if = "Option::is_none")]
    pub job_status: Option<String>,
    #[doc = "AffectedObjectType for the event."]
    #[serde(rename = "affectedObjectType", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_type: Option<String>,
}
impl JobStatusEventDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents a task which is actually a workflow so that one can navigate to its individual drill down."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[doc = "This class contains the minimal job details required to navigate to the desired drill down."]
    #[serde(rename = "jobTask", default, skip_serializing_if = "Option::is_none")]
    pub job_task: Option<JobEntity>,
}
impl JobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Key Encryption Key (KEK) information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyEncryptionKeyInfo {
    #[doc = "The\u{a0}key url / identifier."]
    #[serde(rename = "keyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub key_identifier: Option<String>,
    #[doc = "The\u{a0}KeyVault resource ARM id for key."]
    #[serde(rename = "keyVaultResourceArmId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_resource_arm_id: Option<String>,
}
impl KeyEncryptionKeyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Logical network data model."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogicalNetwork {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Logical Network Properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LogicalNetworkProperties>,
}
impl LogicalNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of logical networks."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogicalNetworkCollection {
    #[doc = "The Logical Networks list details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LogicalNetwork>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LogicalNetworkCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Logical Network Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogicalNetworkProperties {
    #[doc = "The Friendly Name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "A value indicating whether Network Virtualization is enabled for the logical network."]
    #[serde(rename = "networkVirtualizationStatus", default, skip_serializing_if = "Option::is_none")]
    pub network_virtualization_status: Option<String>,
    #[doc = "A value indicating whether logical network is used as private test network by test failover."]
    #[serde(rename = "logicalNetworkUsage", default, skip_serializing_if = "Option::is_none")]
    pub logical_network_usage: Option<String>,
    #[doc = "A value indicating whether logical network definitions are isolated."]
    #[serde(rename = "logicalNetworkDefinitionsStatus", default, skip_serializing_if = "Option::is_none")]
    pub logical_network_definitions_status: Option<String>,
}
impl LogicalNetworkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents the manual action task details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManualActionTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[doc = "The name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The instructions."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub instructions: Option<String>,
    #[doc = "The observation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub observation: Option<String>,
}
impl ManualActionTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details of a Master Target Server."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MasterTargetServer {
    #[doc = "The server Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The IP address of the server."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The server name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The OS type of the server."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "The version of the scout component on the server."]
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[doc = "The last heartbeat received from the server."]
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[doc = "Version status"]
    #[serde(rename = "versionStatus", default, skip_serializing_if = "Option::is_none")]
    pub version_status: Option<String>,
    #[doc = "The retention volumes of Master target Server."]
    #[serde(rename = "retentionVolumes", default, skip_serializing_if = "Vec::is_empty")]
    pub retention_volumes: Vec<RetentionVolume>,
    #[doc = "The list of data stores in the fabric."]
    #[serde(rename = "dataStores", default, skip_serializing_if = "Vec::is_empty")]
    pub data_stores: Vec<DataStore>,
    #[doc = "Validation errors."]
    #[serde(rename = "validationErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_errors: Vec<HealthError>,
    #[doc = "Health errors."]
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[doc = "Disk count of the master target."]
    #[serde(rename = "diskCount", default, skip_serializing_if = "Option::is_none")]
    pub disk_count: Option<i32>,
    #[doc = "OS Version of the master target."]
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[doc = "Agent expiry date."]
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
    #[doc = "MARS agent version."]
    #[serde(rename = "marsAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub mars_agent_version: Option<String>,
    #[doc = "MARS agent expiry date."]
    #[serde(rename = "marsAgentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub mars_agent_expiry_date: Option<String>,
    #[doc = "Version related details."]
    #[serde(rename = "agentVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub agent_version_details: Option<VersionDetails>,
    #[doc = "Version related details."]
    #[serde(rename = "marsAgentVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub mars_agent_version_details: Option<VersionDetails>,
}
impl MasterTargetServer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input for migrate."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MigrateInput {
    #[doc = "Migrate input properties."]
    pub properties: MigrateInputProperties,
}
impl MigrateInput {
    pub fn new(properties: MigrateInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Migrate input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MigrateInputProperties {
    #[doc = "Migrate provider specific input."]
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: MigrateProviderSpecificInput,
}
impl MigrateInputProperties {
    pub fn new(provider_specific_details: MigrateProviderSpecificInput) -> Self {
        Self { provider_specific_details }
    }
}
#[doc = "Migrate provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MigrateProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl MigrateProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[doc = "Migration item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Migration item properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MigrationItemProperties>,
}
impl MigrationItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Migration item collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationItemCollection {
    #[doc = "The list of migration items."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MigrationItem>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MigrationItemCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Migration item properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationItemProperties {
    #[doc = "The on-premise virtual machine name."]
    #[serde(rename = "machineName", default, skip_serializing_if = "Option::is_none")]
    pub machine_name: Option<String>,
    #[doc = "The ARM Id of policy governing this item."]
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[doc = "The name of policy governing this item."]
    #[serde(rename = "policyFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_friendly_name: Option<String>,
    #[doc = "The migration status."]
    #[serde(rename = "migrationState", default, skip_serializing_if = "Option::is_none")]
    pub migration_state: Option<migration_item_properties::MigrationState>,
    #[doc = "The migration state description."]
    #[serde(rename = "migrationStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub migration_state_description: Option<String>,
    #[doc = "The last test migration time."]
    #[serde(rename = "lastTestMigrationTime", default, skip_serializing_if = "Option::is_none")]
    pub last_test_migration_time: Option<String>,
    #[doc = "The status of the last test migration."]
    #[serde(rename = "lastTestMigrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_test_migration_status: Option<String>,
    #[doc = "The test migrate state."]
    #[serde(rename = "testMigrateState", default, skip_serializing_if = "Option::is_none")]
    pub test_migrate_state: Option<migration_item_properties::TestMigrateState>,
    #[doc = "The test migrate state description."]
    #[serde(rename = "testMigrateStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub test_migrate_state_description: Option<String>,
    #[doc = "The consolidated health."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<migration_item_properties::Health>,
    #[doc = "The list of health errors."]
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[doc = "The allowed operations on the migration item, based on the current migration state of the item."]
    #[serde(rename = "allowedOperations", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_operations: Vec<String>,
    #[doc = "Current job details of the migration item."]
    #[serde(rename = "currentJob", default, skip_serializing_if = "Option::is_none")]
    pub current_job: Option<CurrentJobDetails>,
    #[doc = "The correlation Id for events associated with this migration item."]
    #[serde(rename = "eventCorrelationId", default, skip_serializing_if = "Option::is_none")]
    pub event_correlation_id: Option<String>,
    #[doc = "Migration provider specific settings."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<MigrationProviderSpecificSettings>,
}
impl MigrationItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod migration_item_properties {
    use super::*;
    #[doc = "The migration status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MigrationState {
        None,
        EnableMigrationInProgress,
        EnableMigrationFailed,
        DisableMigrationInProgress,
        DisableMigrationFailed,
        InitialSeedingInProgress,
        InitialSeedingFailed,
        Replicating,
        MigrationInProgress,
        MigrationSucceeded,
        MigrationFailed,
    }
    #[doc = "The test migrate state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TestMigrateState {
        None,
        TestMigrationInProgress,
        TestMigrationSucceeded,
        TestMigrationFailed,
        TestMigrationCleanupInProgress,
    }
    #[doc = "The consolidated health."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[doc = "Query parameter to enumerate migration items."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationItemsQueryParameter {
    #[doc = "The source fabric name filter."]
    #[serde(rename = "sourceFabricName", default, skip_serializing_if = "Option::is_none")]
    pub source_fabric_name: Option<String>,
    #[doc = "The replication provider type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl MigrationItemsQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Migration provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationProviderSpecificSettings {
    #[doc = "Gets the instance type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl MigrationProviderSpecificSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery point for a migration item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationRecoveryPoint {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Migration item recovery point properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MigrationRecoveryPointProperties>,
}
impl MigrationRecoveryPoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of migration recovery points."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationRecoveryPointCollection {
    #[doc = "The migration recovery point details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MigrationRecoveryPoint>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MigrationRecoveryPointCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Migration item recovery point properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationRecoveryPointProperties {
    #[doc = "The recovery point time."]
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[doc = "The recovery point type."]
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<migration_recovery_point_properties::RecoveryPointType>,
}
impl MigrationRecoveryPointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod migration_recovery_point_properties {
    use super::*;
    #[doc = "The recovery point type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        NotSpecified,
        ApplicationConsistent,
        CrashConsistent,
    }
}
#[doc = "The Mobility Service update details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MobilityServiceUpdate {
    #[doc = "The version of the latest update."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[doc = "The reboot status of the update - whether it is required or not."]
    #[serde(rename = "rebootStatus", default, skip_serializing_if = "Option::is_none")]
    pub reboot_status: Option<String>,
    #[doc = "The OS type."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
}
impl MobilityServiceUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network model."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Network {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Network Properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkProperties>,
}
impl Network {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of networks."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkCollection {
    #[doc = "The Networks list details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Network>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Mapping model. Ideally it should have been possible to inherit this class from prev version in InheritedModels as long as there is no difference in structure or method signature. Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the class has been introduced in its entirety with references to base models to facilitate extensions in subsequent versions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkMapping {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Network Mapping Properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkMappingProperties>,
}
impl NetworkMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of network mappings. As with NetworkMapping, it should be possible to reuse a prev version of this class. It doesn't seem likely this class could be anything more than a slightly bespoke collection of NetworkMapping. Hence it makes sense to override Load with Base.NetworkMapping instead of existing CurrentVersion.NetworkMapping."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkMappingCollection {
    #[doc = "The Network Mappings list."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkMapping>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkMappingCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Mapping fabric specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkMappingFabricSpecificSettings {
    #[doc = "Gets the Instance type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl NetworkMappingFabricSpecificSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Mapping Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkMappingProperties {
    #[doc = "The pairing state for network mapping."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The primary network friendly name."]
    #[serde(rename = "primaryNetworkFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub primary_network_friendly_name: Option<String>,
    #[doc = "The primary network id for network mapping."]
    #[serde(rename = "primaryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub primary_network_id: Option<String>,
    #[doc = "The primary fabric friendly name."]
    #[serde(rename = "primaryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_friendly_name: Option<String>,
    #[doc = "The recovery network friendly name."]
    #[serde(rename = "recoveryNetworkFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_network_friendly_name: Option<String>,
    #[doc = "The recovery network id for network mapping."]
    #[serde(rename = "recoveryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_network_id: Option<String>,
    #[doc = "The recovery fabric ARM id."]
    #[serde(rename = "recoveryFabricArmId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_arm_id: Option<String>,
    #[doc = "The recovery fabric friendly name."]
    #[serde(rename = "recoveryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_friendly_name: Option<String>,
    #[doc = "Network Mapping fabric specific settings."]
    #[serde(rename = "fabricSpecificSettings", default, skip_serializing_if = "Option::is_none")]
    pub fabric_specific_settings: Option<NetworkMappingFabricSpecificSettings>,
}
impl NetworkMappingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProperties {
    #[doc = "The Fabric Type."]
    #[serde(rename = "fabricType", default, skip_serializing_if = "Option::is_none")]
    pub fabric_type: Option<String>,
    #[doc = "The List of subnets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "The Friendly Name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The Network Type."]
    #[serde(rename = "networkType", default, skip_serializing_if = "Option::is_none")]
    pub network_type: Option<String>,
}
impl NetworkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Disk Details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsDetails {
    #[doc = "VM Disk details."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "Product type."]
    #[serde(rename = "productType", default, skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
    #[doc = "The OSEdition."]
    #[serde(rename = "osEdition", default, skip_serializing_if = "Option::is_none")]
    pub os_edition: Option<String>,
    #[doc = "The OS Version."]
    #[serde(rename = "oSVersion", default, skip_serializing_if = "Option::is_none")]
    pub o_s_version: Option<String>,
    #[doc = "The OS Major Version."]
    #[serde(rename = "oSMajorVersion", default, skip_serializing_if = "Option::is_none")]
    pub o_s_major_version: Option<String>,
    #[doc = "The OS Minor Version."]
    #[serde(rename = "oSMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub o_s_minor_version: Option<String>,
}
impl OsDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details of the OS Disk."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsDiskDetails {
    #[doc = "The id of the disk containing the OS."]
    #[serde(rename = "osVhdId", default, skip_serializing_if = "Option::is_none")]
    pub os_vhd_id: Option<String>,
    #[doc = "The type of the OS on the VM."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "The OS disk VHD name."]
    #[serde(rename = "vhdName", default, skip_serializing_if = "Option::is_none")]
    pub vhd_name: Option<String>,
}
impl OsDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base of all objects."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Object {}
impl Object {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Operations discovery class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsDiscovery {
    #[doc = "Name of the API. The name of the operation being performed on this particular object. It should match the action name that appears in RBAC / the event service. Examples of operations include: * Microsoft.Compute/virtualMachine/capture/action * Microsoft.Compute/virtualMachine/restart/action * Microsoft.Compute/virtualMachine/write * Microsoft.Compute/virtualMachine/read * Microsoft.Compute/virtualMachine/delete Each action should include, in order: (1) Resource Provider Namespace (2) Type hierarchy for which the action applies (e.g. server/databases for a SQL Azure database) (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH on a collection or named value, Write should be used. If it is a GET, Read should be used. If it is a DELETE, Delete should be used. If it is a POST, Action should be used. As a note: all resource providers would need to include the \"{Resource Provider Namespace}/register/action\" operation in their response. This API is used to register for their service, and should include details about the operation (e.g. a localized name for the resource provider + any special considerations like PII release)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Contains the localized display information for this particular operation / action. These value will be used by several clients for (1) custom role definitions for RBAC; (2) complex query filters for the event service; and (3) audit history / records for management operations."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<Display>,
    #[doc = "Origin. The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX. Default value is \"user,system\""]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[doc = "ClientDiscovery properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationsDiscoveryProperties>,
}
impl OperationsDiscovery {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of ClientDiscovery details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsDiscoveryCollection {
    #[doc = "The ClientDiscovery details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OperationsDiscovery>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationsDiscoveryCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ClientDiscovery properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsDiscoveryProperties {}
impl OperationsDiscoveryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input definition for planned failover."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PlannedFailoverInput {
    #[doc = "Input definition for planned failover input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PlannedFailoverInputProperties>,
}
impl PlannedFailoverInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input definition for planned failover input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PlannedFailoverInputProperties {
    #[doc = "Failover direction."]
    #[serde(rename = "failoverDirection", default, skip_serializing_if = "Option::is_none")]
    pub failover_direction: Option<String>,
    #[doc = "Provider specific failover input."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ProviderSpecificFailoverInput>,
}
impl PlannedFailoverInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protection profile details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Policy {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Protection profile custom data details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PolicyProperties>,
}
impl Policy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protection Profile Collection details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyCollection {
    #[doc = "The policy details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Policy>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PolicyCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protection profile custom data details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyProperties {
    #[doc = "The FriendlyName."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Base class for Provider specific details for policies."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<PolicyProviderSpecificDetails>,
}
impl PolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for Provider specific details for policies."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyProviderSpecificDetails {
    #[doc = "Gets the class type. Overridden in derived classes."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl PolicyProviderSpecificDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for provider specific input"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl PolicyProviderSpecificInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details of the Process Server."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessServer {
    #[doc = "The Process Server's friendly name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The Process Server Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The IP address of the server."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The OS type of the server."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "The version of the scout component on the server."]
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[doc = "The last heartbeat received from the server."]
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[doc = "Version status"]
    #[serde(rename = "versionStatus", default, skip_serializing_if = "Option::is_none")]
    pub version_status: Option<String>,
    #[doc = "The list of the mobility service updates available on the Process Server."]
    #[serde(rename = "mobilityServiceUpdates", default, skip_serializing_if = "Vec::is_empty")]
    pub mobility_service_updates: Vec<MobilityServiceUpdate>,
    #[doc = "The agent generated Id."]
    #[serde(rename = "hostId", default, skip_serializing_if = "Option::is_none")]
    pub host_id: Option<String>,
    #[doc = "The servers configured with this PS."]
    #[serde(rename = "machineCount", default, skip_serializing_if = "Option::is_none")]
    pub machine_count: Option<String>,
    #[doc = "The number of replication pairs configured in this PS."]
    #[serde(rename = "replicationPairCount", default, skip_serializing_if = "Option::is_none")]
    pub replication_pair_count: Option<String>,
    #[doc = "The percentage of the system load."]
    #[serde(rename = "systemLoad", default, skip_serializing_if = "Option::is_none")]
    pub system_load: Option<String>,
    #[doc = "The system load status."]
    #[serde(rename = "systemLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub system_load_status: Option<String>,
    #[doc = "The percentage of the CPU load."]
    #[serde(rename = "cpuLoad", default, skip_serializing_if = "Option::is_none")]
    pub cpu_load: Option<String>,
    #[doc = "The CPU load status."]
    #[serde(rename = "cpuLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub cpu_load_status: Option<String>,
    #[doc = "The total memory."]
    #[serde(rename = "totalMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_memory_in_bytes: Option<i64>,
    #[doc = "The available memory."]
    #[serde(rename = "availableMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_memory_in_bytes: Option<i64>,
    #[doc = "The memory usage status."]
    #[serde(rename = "memoryUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub memory_usage_status: Option<String>,
    #[doc = "The total space."]
    #[serde(rename = "totalSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_space_in_bytes: Option<i64>,
    #[doc = "The available space."]
    #[serde(rename = "availableSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_space_in_bytes: Option<i64>,
    #[doc = "The space usage status."]
    #[serde(rename = "spaceUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub space_usage_status: Option<String>,
    #[doc = "The PS service status."]
    #[serde(rename = "psServiceStatus", default, skip_serializing_if = "Option::is_none")]
    pub ps_service_status: Option<String>,
    #[doc = "The PS SSL cert expiry date."]
    #[serde(rename = "sslCertExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_expiry_date: Option<String>,
    #[doc = "CS SSL cert expiry date."]
    #[serde(rename = "sslCertExpiryRemainingDays", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_expiry_remaining_days: Option<i32>,
    #[doc = "OS Version of the process server. Note: This will get populated if user has CS version greater than 9.12.0.0."]
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[doc = "Health errors."]
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[doc = "Agent expiry date."]
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
    #[doc = "Version related details."]
    #[serde(rename = "agentVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub agent_version_details: Option<VersionDetails>,
}
impl ProcessServer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Replication protected item"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Replication protected item custom data details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectableItemProperties>,
}
impl ProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protectable item collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableItemCollection {
    #[doc = "The Protectable item details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectableItem>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProtectableItemCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Replication protected item custom data details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableItemProperties {
    #[doc = "The name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The protection status."]
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[doc = "The ARM resource of protected items."]
    #[serde(rename = "replicationProtectedItemId", default, skip_serializing_if = "Option::is_none")]
    pub replication_protected_item_id: Option<String>,
    #[doc = "The recovery provider ARM Id."]
    #[serde(rename = "recoveryServicesProviderId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_services_provider_id: Option<String>,
    #[doc = "The Current protection readiness errors."]
    #[serde(rename = "protectionReadinessErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub protection_readiness_errors: Vec<String>,
    #[doc = "The list of replication providers supported for the protectable item."]
    #[serde(rename = "supportedReplicationProviders", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_replication_providers: Vec<String>,
    #[doc = "Replication provider specific settings."]
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<ConfigurationSettings>,
}
impl ProtectableItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Query parameter to enumerate Protectable items."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableItemQueryParameter {
    #[doc = "State of the Protectable item query filter."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}
impl ProtectableItemQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Query parameter to enumerate protected items."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectedItemsQueryParameter {
    #[doc = "The source fabric name filter."]
    #[serde(rename = "sourceFabricName", default, skip_serializing_if = "Option::is_none")]
    pub source_fabric_name: Option<String>,
    #[doc = "The recovery plan filter."]
    #[serde(rename = "recoveryPlanName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_plan_name: Option<String>,
    #[doc = "The vCenter name filter."]
    #[serde(rename = "vCenterName", default, skip_serializing_if = "Option::is_none")]
    pub v_center_name: Option<String>,
    #[doc = "The replication provider type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    #[doc = "Whether Multi VM group is auto created or specified by user."]
    #[serde(rename = "multiVmGroupCreateOption", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_create_option: Option<protected_items_query_parameter::MultiVmGroupCreateOption>,
}
impl ProtectedItemsQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protected_items_query_parameter {
    use super::*;
    #[doc = "Whether Multi VM group is auto created or specified by user."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmGroupCreateOption {
        AutoCreated,
        UserSpecified,
    }
}
#[doc = "Protection container details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainer {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Protection profile custom data details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectionContainerProperties>,
}
impl ProtectionContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protection Container collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerCollection {
    #[doc = "The Protection Container details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectionContainer>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProtectionContainerCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for fabric specific details of container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerFabricSpecificDetails {
    #[doc = "Gets the class type. Overridden in derived classes."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ProtectionContainerFabricSpecificDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protection container mapping object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerMapping {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Protection container mapping properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectionContainerMappingProperties>,
}
impl ProtectionContainerMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protection container mapping collection class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerMappingCollection {
    #[doc = "List of container mappings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectionContainerMapping>,
    #[doc = "Link to fetch rest of the data."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProtectionContainerMappingCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protection container mapping properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerMappingProperties {
    #[doc = "Paired protection container ARM ID."]
    #[serde(rename = "targetProtectionContainerId", default, skip_serializing_if = "Option::is_none")]
    pub target_protection_container_id: Option<String>,
    #[doc = "Friendly name of paired container."]
    #[serde(rename = "targetProtectionContainerFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub target_protection_container_friendly_name: Option<String>,
    #[doc = "Container mapping provider specific details."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ProtectionContainerMappingProviderSpecificDetails>,
    #[doc = "Health of pairing."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<String>,
    #[doc = "Health error."]
    #[serde(rename = "healthErrorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub health_error_details: Vec<HealthError>,
    #[doc = "Policy ARM Id."]
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[doc = "Association Status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "Friendly name of source protection container."]
    #[serde(rename = "sourceProtectionContainerFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub source_protection_container_friendly_name: Option<String>,
    #[doc = "Friendly name of source fabric."]
    #[serde(rename = "sourceFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub source_fabric_friendly_name: Option<String>,
    #[doc = "Friendly name of target fabric."]
    #[serde(rename = "targetFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub target_fabric_friendly_name: Option<String>,
    #[doc = "Friendly name of replication policy."]
    #[serde(rename = "policyFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_friendly_name: Option<String>,
}
impl ProtectionContainerMappingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container mapping provider specific details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerMappingProviderSpecificDetails {
    #[doc = "Gets the class type. Overridden in derived classes."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ProtectionContainerMappingProviderSpecificDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Protection profile custom data details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerProperties {
    #[doc = "Fabric friendly name."]
    #[serde(rename = "fabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_friendly_name: Option<String>,
    #[doc = "The name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The fabric type."]
    #[serde(rename = "fabricType", default, skip_serializing_if = "Option::is_none")]
    pub fabric_type: Option<String>,
    #[doc = "Number of protected PEs"]
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i32>,
    #[doc = "The pairing status of this cloud."]
    #[serde(rename = "pairingStatus", default, skip_serializing_if = "Option::is_none")]
    pub pairing_status: Option<String>,
    #[doc = "The role of this cloud."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub role: Option<String>,
    #[doc = "Base class for fabric specific details of container."]
    #[serde(rename = "fabricSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub fabric_specific_details: Option<ProtectionContainerFabricSpecificDetails>,
}
impl ProtectionContainerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class contains the error details per object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderError {
    #[doc = "The Error code."]
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[doc = "The Error message."]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[doc = "The Provider error Id."]
    #[serde(rename = "errorId", default, skip_serializing_if = "Option::is_none")]
    pub error_id: Option<String>,
    #[doc = "The possible causes for the error."]
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[doc = "The recommended action to resolve the error."]
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
}
impl ProviderError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provider specific failover input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderSpecificFailoverInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ProviderSpecificFailoverInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Replication provider specific recovery point details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderSpecificRecoveryPointDetails {
    #[doc = "Gets the provider type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ProviderSpecificRecoveryPointDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "RCM based Azure migration specific policy details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RcmAzureMigrationPolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "The recovery point threshold in minutes."]
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[doc = "The app consistent snapshot frequency in minutes."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "A value indicating whether multi-VM sync has to be enabled."]
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<rcm_azure_migration_policy_details::MultiVmSyncStatus>,
    #[doc = "The crash consistent snapshot frequency in minutes."]
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
}
impl RcmAzureMigrationPolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod rcm_azure_migration_policy_details {
    use super::*;
    #[doc = "A value indicating whether multi-VM sync has to be enabled."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncStatus {
        Enabled,
        Disabled,
    }
}
#[doc = "Recovery plan details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlan {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Recovery plan custom details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecoveryPlanProperties>,
}
impl RecoveryPlan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan A2A failover input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanA2aFailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[doc = "The recovery point type."]
    #[serde(rename = "recoveryPointType")]
    pub recovery_point_type: recovery_plan_a2a_failover_input::RecoveryPointType,
    #[doc = "A value indicating whether to use recovery cloud service for TFO or not."]
    #[serde(rename = "cloudServiceCreationOption", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_creation_option: Option<String>,
    #[doc = "A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover."]
    #[serde(rename = "multiVmSyncPointOption", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_point_option: Option<recovery_plan_a2a_failover_input::MultiVmSyncPointOption>,
}
impl RecoveryPlanA2aFailoverInput {
    pub fn new(recovery_point_type: recovery_plan_a2a_failover_input::RecoveryPointType) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput::default(),
            recovery_point_type,
            cloud_service_creation_option: None,
            multi_vm_sync_point_option: None,
        }
    }
}
pub mod recovery_plan_a2a_failover_input {
    use super::*;
    #[doc = "The recovery point type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        Latest,
        LatestApplicationConsistent,
        LatestCrashConsistent,
        LatestProcessed,
    }
    #[doc = "A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncPointOption {
        UseMultiVmSyncRecoveryPoint,
        UsePerVmRecoveryPoint,
    }
}
#[doc = "Recovery plan action details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanAction {
    #[doc = "The action name."]
    #[serde(rename = "actionName")]
    pub action_name: String,
    #[doc = "The list of failover types."]
    #[serde(rename = "failoverTypes")]
    pub failover_types: Vec<String>,
    #[doc = "The list of failover directions."]
    #[serde(rename = "failoverDirections")]
    pub failover_directions: Vec<String>,
    #[doc = "Recovery plan action custom details."]
    #[serde(rename = "customDetails")]
    pub custom_details: RecoveryPlanActionDetails,
}
impl RecoveryPlanAction {
    pub fn new(
        action_name: String,
        failover_types: Vec<String>,
        failover_directions: Vec<String>,
        custom_details: RecoveryPlanActionDetails,
    ) -> Self {
        Self {
            action_name,
            failover_types,
            failover_directions,
            custom_details,
        }
    }
}
#[doc = "Recovery plan action custom details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanActionDetails {
    #[doc = "Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values)."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl RecoveryPlanActionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan Automation runbook action details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanAutomationRunbookActionDetails {
    #[serde(flatten)]
    pub recovery_plan_action_details: RecoveryPlanActionDetails,
    #[doc = "The runbook ARM Id."]
    #[serde(rename = "runbookId", default, skip_serializing_if = "Option::is_none")]
    pub runbook_id: Option<String>,
    #[doc = "The runbook timeout."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
    #[doc = "The fabric location."]
    #[serde(rename = "fabricLocation")]
    pub fabric_location: recovery_plan_automation_runbook_action_details::FabricLocation,
}
impl RecoveryPlanAutomationRunbookActionDetails {
    pub fn new(fabric_location: recovery_plan_automation_runbook_action_details::FabricLocation) -> Self {
        Self {
            recovery_plan_action_details: RecoveryPlanActionDetails::default(),
            runbook_id: None,
            timeout: None,
            fabric_location,
        }
    }
}
pub mod recovery_plan_automation_runbook_action_details {
    use super::*;
    #[doc = "The fabric location."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FabricLocation {
        Primary,
        Recovery,
    }
}
#[doc = "Recovery plan collection details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanCollection {
    #[doc = "The list of recovery plans."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecoveryPlan>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecoveryPlanCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan group details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanGroup {
    #[doc = "The group type."]
    #[serde(rename = "groupType")]
    pub group_type: recovery_plan_group::GroupType,
    #[doc = "The list of protected items."]
    #[serde(rename = "replicationProtectedItems", default, skip_serializing_if = "Vec::is_empty")]
    pub replication_protected_items: Vec<RecoveryPlanProtectedItem>,
    #[doc = "The start group actions."]
    #[serde(rename = "startGroupActions", default, skip_serializing_if = "Vec::is_empty")]
    pub start_group_actions: Vec<RecoveryPlanAction>,
    #[doc = "The end group actions."]
    #[serde(rename = "endGroupActions", default, skip_serializing_if = "Vec::is_empty")]
    pub end_group_actions: Vec<RecoveryPlanAction>,
}
impl RecoveryPlanGroup {
    pub fn new(group_type: recovery_plan_group::GroupType) -> Self {
        Self {
            group_type,
            replication_protected_items: Vec::new(),
            start_group_actions: Vec::new(),
            end_group_actions: Vec::new(),
        }
    }
}
pub mod recovery_plan_group {
    use super::*;
    #[doc = "The group type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GroupType {
        Shutdown,
        Boot,
        Failover,
    }
}
#[doc = "This class represents the recovery plan group task."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanGroupTaskDetails {
    #[serde(flatten)]
    pub group_task_details: GroupTaskDetails,
    #[doc = "The name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The group identifier."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[doc = "The group type."]
    #[serde(rename = "rpGroupType", default, skip_serializing_if = "Option::is_none")]
    pub rp_group_type: Option<String>,
}
impl RecoveryPlanGroupTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan HVR Azure failback input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanHyperVReplicaAzureFailbackInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[doc = "The data sync option."]
    #[serde(rename = "dataSyncOption")]
    pub data_sync_option: recovery_plan_hyper_v_replica_azure_failback_input::DataSyncOption,
    #[doc = "The ALR option."]
    #[serde(rename = "recoveryVmCreationOption")]
    pub recovery_vm_creation_option: recovery_plan_hyper_v_replica_azure_failback_input::RecoveryVmCreationOption,
}
impl RecoveryPlanHyperVReplicaAzureFailbackInput {
    pub fn new(
        data_sync_option: recovery_plan_hyper_v_replica_azure_failback_input::DataSyncOption,
        recovery_vm_creation_option: recovery_plan_hyper_v_replica_azure_failback_input::RecoveryVmCreationOption,
    ) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput::default(),
            data_sync_option,
            recovery_vm_creation_option,
        }
    }
}
pub mod recovery_plan_hyper_v_replica_azure_failback_input {
    use super::*;
    #[doc = "The data sync option."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSyncOption {
        ForDownTime,
        ForSynchronization,
    }
    #[doc = "The ALR option."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryVmCreationOption {
        CreateVmIfNotFound,
        NoAction,
    }
}
#[doc = "Recovery plan HVR Azure failover input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanHyperVReplicaAzureFailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[doc = "The vault location."]
    #[serde(rename = "vaultLocation", default, skip_serializing_if = "Option::is_none")]
    pub vault_location: Option<String>,
    #[doc = "The primary KEK certificate PFX."]
    #[serde(rename = "primaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub primary_kek_certificate_pfx: Option<String>,
    #[doc = "The secondary KEK certificate PFX."]
    #[serde(rename = "secondaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub secondary_kek_certificate_pfx: Option<String>,
    #[doc = "The recovery point type."]
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<recovery_plan_hyper_v_replica_azure_failover_input::RecoveryPointType>,
}
impl RecoveryPlanHyperVReplicaAzureFailoverInput {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recovery_plan_hyper_v_replica_azure_failover_input {
    use super::*;
    #[doc = "The recovery point type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        Latest,
        LatestApplicationConsistent,
        LatestProcessed,
    }
}
#[doc = "Recovery plan InMageAzureV2 failover input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanInMageAzureV2FailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[doc = "The vault location."]
    #[serde(rename = "vaultLocation")]
    pub vault_location: String,
    #[doc = "The recovery point type."]
    #[serde(rename = "recoveryPointType")]
    pub recovery_point_type: recovery_plan_in_mage_azure_v2_failover_input::RecoveryPointType,
    #[doc = "A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover."]
    #[serde(rename = "useMultiVmSyncPoint", default, skip_serializing_if = "Option::is_none")]
    pub use_multi_vm_sync_point: Option<String>,
}
impl RecoveryPlanInMageAzureV2FailoverInput {
    pub fn new(vault_location: String, recovery_point_type: recovery_plan_in_mage_azure_v2_failover_input::RecoveryPointType) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput::default(),
            vault_location,
            recovery_point_type,
            use_multi_vm_sync_point: None,
        }
    }
}
pub mod recovery_plan_in_mage_azure_v2_failover_input {
    use super::*;
    #[doc = "The recovery point type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        Latest,
        LatestApplicationConsistent,
        LatestCrashConsistent,
        LatestProcessed,
    }
}
#[doc = "Recovery plan InMage failover input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanInMageFailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[doc = "The recovery point type."]
    #[serde(rename = "recoveryPointType")]
    pub recovery_point_type: recovery_plan_in_mage_failover_input::RecoveryPointType,
}
impl RecoveryPlanInMageFailoverInput {
    pub fn new(recovery_point_type: recovery_plan_in_mage_failover_input::RecoveryPointType) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput::default(),
            recovery_point_type,
        }
    }
}
pub mod recovery_plan_in_mage_failover_input {
    use super::*;
    #[doc = "The recovery point type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        LatestTime,
        LatestTag,
        Custom,
    }
}
#[doc = "Recovery plan manual action details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanManualActionDetails {
    #[serde(flatten)]
    pub recovery_plan_action_details: RecoveryPlanActionDetails,
    #[doc = "The manual action description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl RecoveryPlanManualActionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan planned failover input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanPlannedFailoverInput {
    #[doc = "Recovery plan planned failover input properties."]
    pub properties: RecoveryPlanPlannedFailoverInputProperties,
}
impl RecoveryPlanPlannedFailoverInput {
    pub fn new(properties: RecoveryPlanPlannedFailoverInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Recovery plan planned failover input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanPlannedFailoverInputProperties {
    #[doc = "The failover direction."]
    #[serde(rename = "failoverDirection")]
    pub failover_direction: recovery_plan_planned_failover_input_properties::FailoverDirection,
    #[doc = "The provider specific properties."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_details: Vec<RecoveryPlanProviderSpecificFailoverInput>,
}
impl RecoveryPlanPlannedFailoverInputProperties {
    pub fn new(failover_direction: recovery_plan_planned_failover_input_properties::FailoverDirection) -> Self {
        Self {
            failover_direction,
            provider_specific_details: Vec::new(),
        }
    }
}
pub mod recovery_plan_planned_failover_input_properties {
    use super::*;
    #[doc = "The failover direction."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverDirection {
        PrimaryToRecovery,
        RecoveryToPrimary,
    }
}
#[doc = "Recovery plan custom details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanProperties {
    #[doc = "The friendly name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The primary fabric Id."]
    #[serde(rename = "primaryFabricId", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_id: Option<String>,
    #[doc = "The primary fabric friendly name."]
    #[serde(rename = "primaryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_friendly_name: Option<String>,
    #[doc = "The recovery fabric Id."]
    #[serde(rename = "recoveryFabricId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_id: Option<String>,
    #[doc = "The recovery fabric friendly name."]
    #[serde(rename = "recoveryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_friendly_name: Option<String>,
    #[doc = "The failover deployment model."]
    #[serde(rename = "failoverDeploymentModel", default, skip_serializing_if = "Option::is_none")]
    pub failover_deployment_model: Option<String>,
    #[doc = "The list of replication providers."]
    #[serde(rename = "replicationProviders", default, skip_serializing_if = "Vec::is_empty")]
    pub replication_providers: Vec<String>,
    #[doc = "The list of allowed operations."]
    #[serde(rename = "allowedOperations", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_operations: Vec<String>,
    #[doc = "The start time of the last planned failover."]
    #[serde(rename = "lastPlannedFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_planned_failover_time: Option<String>,
    #[doc = "The start time of the last unplanned failover."]
    #[serde(rename = "lastUnplannedFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_unplanned_failover_time: Option<String>,
    #[doc = "The start time of the last test failover."]
    #[serde(rename = "lastTestFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_test_failover_time: Option<String>,
    #[doc = "Current scenario details of the protected entity."]
    #[serde(rename = "currentScenario", default, skip_serializing_if = "Option::is_none")]
    pub current_scenario: Option<CurrentScenarioDetails>,
    #[doc = "The recovery plan status."]
    #[serde(rename = "currentScenarioStatus", default, skip_serializing_if = "Option::is_none")]
    pub current_scenario_status: Option<String>,
    #[doc = "The recovery plan status description."]
    #[serde(rename = "currentScenarioStatusDescription", default, skip_serializing_if = "Option::is_none")]
    pub current_scenario_status_description: Option<String>,
    #[doc = "The recovery plan groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groups: Vec<RecoveryPlanGroup>,
}
impl RecoveryPlanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan protected item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanProtectedItem {
    #[doc = "The ARM Id of the recovery plan protected item."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The virtual machine Id."]
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
}
impl RecoveryPlanProtectedItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan provider specific failover input base class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanProviderSpecificFailoverInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl RecoveryPlanProviderSpecificFailoverInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan script action details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanScriptActionDetails {
    #[serde(flatten)]
    pub recovery_plan_action_details: RecoveryPlanActionDetails,
    #[doc = "The script path."]
    pub path: String,
    #[doc = "The script timeout."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
    #[doc = "The fabric location."]
    #[serde(rename = "fabricLocation")]
    pub fabric_location: recovery_plan_script_action_details::FabricLocation,
}
impl RecoveryPlanScriptActionDetails {
    pub fn new(path: String, fabric_location: recovery_plan_script_action_details::FabricLocation) -> Self {
        Self {
            recovery_plan_action_details: RecoveryPlanActionDetails::default(),
            path,
            timeout: None,
            fabric_location,
        }
    }
}
pub mod recovery_plan_script_action_details {
    use super::*;
    #[doc = "The fabric location."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FabricLocation {
        Primary,
        Recovery,
    }
}
#[doc = "This class represents the recovery plan shutdown group task details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanShutdownGroupTaskDetails {
    #[serde(flatten)]
    pub group_task_details: GroupTaskDetails,
    #[doc = "The name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The group identifier."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[doc = "The group type."]
    #[serde(rename = "rpGroupType", default, skip_serializing_if = "Option::is_none")]
    pub rp_group_type: Option<String>,
}
impl RecoveryPlanShutdownGroupTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan test failover cleanup input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanTestFailoverCleanupInput {
    #[doc = "Recovery plan test failover cleanup input properties."]
    pub properties: RecoveryPlanTestFailoverCleanupInputProperties,
}
impl RecoveryPlanTestFailoverCleanupInput {
    pub fn new(properties: RecoveryPlanTestFailoverCleanupInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Recovery plan test failover cleanup input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanTestFailoverCleanupInputProperties {
    #[doc = "The test failover cleanup comments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
}
impl RecoveryPlanTestFailoverCleanupInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan test failover input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanTestFailoverInput {
    #[doc = "Recovery plan test failover input properties."]
    pub properties: RecoveryPlanTestFailoverInputProperties,
}
impl RecoveryPlanTestFailoverInput {
    pub fn new(properties: RecoveryPlanTestFailoverInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Recovery plan test failover input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanTestFailoverInputProperties {
    #[doc = "The failover direction."]
    #[serde(rename = "failoverDirection")]
    pub failover_direction: recovery_plan_test_failover_input_properties::FailoverDirection,
    #[doc = "The network type to be used for test failover."]
    #[serde(rename = "networkType")]
    pub network_type: String,
    #[doc = "The Id of the network to be used for test failover."]
    #[serde(rename = "networkId", default, skip_serializing_if = "Option::is_none")]
    pub network_id: Option<String>,
    #[doc = "A value indicating whether the test failover cleanup is to be skipped."]
    #[serde(rename = "skipTestFailoverCleanup", default, skip_serializing_if = "Option::is_none")]
    pub skip_test_failover_cleanup: Option<String>,
    #[doc = "The provider specific properties."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_details: Vec<RecoveryPlanProviderSpecificFailoverInput>,
}
impl RecoveryPlanTestFailoverInputProperties {
    pub fn new(failover_direction: recovery_plan_test_failover_input_properties::FailoverDirection, network_type: String) -> Self {
        Self {
            failover_direction,
            network_type,
            network_id: None,
            skip_test_failover_cleanup: None,
            provider_specific_details: Vec::new(),
        }
    }
}
pub mod recovery_plan_test_failover_input_properties {
    use super::*;
    #[doc = "The failover direction."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverDirection {
        PrimaryToRecovery,
        RecoveryToPrimary,
    }
}
#[doc = "Recovery plan unplanned failover input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanUnplannedFailoverInput {
    #[doc = "Recovery plan unplanned failover input properties."]
    pub properties: RecoveryPlanUnplannedFailoverInputProperties,
}
impl RecoveryPlanUnplannedFailoverInput {
    pub fn new(properties: RecoveryPlanUnplannedFailoverInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Recovery plan unplanned failover input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanUnplannedFailoverInputProperties {
    #[doc = "The failover direction."]
    #[serde(rename = "failoverDirection")]
    pub failover_direction: recovery_plan_unplanned_failover_input_properties::FailoverDirection,
    #[doc = "A value indicating whether source site operations are required."]
    #[serde(rename = "sourceSiteOperations")]
    pub source_site_operations: recovery_plan_unplanned_failover_input_properties::SourceSiteOperations,
    #[doc = "The provider specific properties."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_details: Vec<RecoveryPlanProviderSpecificFailoverInput>,
}
impl RecoveryPlanUnplannedFailoverInputProperties {
    pub fn new(
        failover_direction: recovery_plan_unplanned_failover_input_properties::FailoverDirection,
        source_site_operations: recovery_plan_unplanned_failover_input_properties::SourceSiteOperations,
    ) -> Self {
        Self {
            failover_direction,
            source_site_operations,
            provider_specific_details: Vec::new(),
        }
    }
}
pub mod recovery_plan_unplanned_failover_input_properties {
    use super::*;
    #[doc = "The failover direction."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverDirection {
        PrimaryToRecovery,
        RecoveryToPrimary,
    }
    #[doc = "A value indicating whether source site operations are required."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceSiteOperations {
        Required,
        NotRequired,
    }
}
#[doc = "Base class representing a recovery point."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPoint {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Recovery point properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecoveryPointProperties>,
}
impl RecoveryPoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of recovery point details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointCollection {
    #[doc = "The recovery point details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecoveryPoint>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecoveryPointCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery point properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointProperties {
    #[doc = "The recovery point time."]
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[doc = "The recovery point type: ApplicationConsistent, CrashConsistent."]
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<String>,
    #[doc = "Replication provider specific recovery point details."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ProviderSpecificRecoveryPointDetails>,
}
impl RecoveryPointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provider details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryServicesProvider {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Recovery services provider properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecoveryServicesProviderProperties>,
}
impl RecoveryServicesProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of providers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryServicesProviderCollection {
    #[doc = "The Servers details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecoveryServicesProvider>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecoveryServicesProviderCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery services provider properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryServicesProviderProperties {
    #[doc = "Type of the site."]
    #[serde(rename = "fabricType", default, skip_serializing_if = "Option::is_none")]
    pub fabric_type: Option<String>,
    #[doc = "Friendly name of the DRA."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The provider version."]
    #[serde(rename = "providerVersion", default, skip_serializing_if = "Option::is_none")]
    pub provider_version: Option<String>,
    #[doc = "The fabric provider."]
    #[serde(rename = "serverVersion", default, skip_serializing_if = "Option::is_none")]
    pub server_version: Option<String>,
    #[doc = "DRA version status."]
    #[serde(rename = "providerVersionState", default, skip_serializing_if = "Option::is_none")]
    pub provider_version_state: Option<String>,
    #[doc = "Expiry date of the version."]
    #[serde(rename = "providerVersionExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub provider_version_expiry_date: Option<String>,
    #[doc = "The fabric friendly name."]
    #[serde(rename = "fabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_friendly_name: Option<String>,
    #[doc = "Time when last heartbeat was sent by the DRA."]
    #[serde(rename = "lastHeartBeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heart_beat: Option<String>,
    #[doc = "A value indicating whether DRA is responsive."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<String>,
    #[doc = "Number of protected VMs currently managed by the DRA."]
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i32>,
    #[doc = "The scenarios allowed on this provider."]
    #[serde(rename = "allowedScenarios", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_scenarios: Vec<String>,
    #[doc = "The recovery services provider health error details."]
    #[serde(rename = "healthErrorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub health_error_details: Vec<HealthError>,
    #[doc = "The DRA Id."]
    #[serde(rename = "draIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub dra_identifier: Option<String>,
    #[doc = "Identity provider details."]
    #[serde(rename = "authenticationIdentityDetails", default, skip_serializing_if = "Option::is_none")]
    pub authentication_identity_details: Option<IdentityProviderDetails>,
    #[doc = "Identity provider details."]
    #[serde(rename = "resourceAccessIdentityDetails", default, skip_serializing_if = "Option::is_none")]
    pub resource_access_identity_details: Option<IdentityProviderDetails>,
    #[doc = "Version related details."]
    #[serde(rename = "providerVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_version_details: Option<VersionDetails>,
}
impl RecoveryServicesProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container unpairing input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RemoveProtectionContainerMappingInput {
    #[doc = "Unpairing input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RemoveProtectionContainerMappingInputProperties>,
}
impl RemoveProtectionContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Unpairing input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RemoveProtectionContainerMappingInputProperties {
    #[doc = "Provider specific input for unpairing operations."]
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_input: Option<ReplicationProviderContainerUnmappingInput>,
}
impl RemoveProtectionContainerMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Certificate renewal input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RenewCertificateInput {
    #[doc = "Renew Certificate input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RenewCertificateInputProperties>,
}
impl RenewCertificateInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Renew Certificate input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RenewCertificateInputProperties {
    #[doc = "Renew certificate type."]
    #[serde(rename = "renewCertificateType", default, skip_serializing_if = "Option::is_none")]
    pub renew_certificate_type: Option<String>,
}
impl RenewCertificateInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Replication group details. This will be used in case of San and Wvr."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationGroupDetails {
    #[serde(flatten)]
    pub configuration_settings: ConfigurationSettings,
}
impl ReplicationGroupDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Replication protected item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProtectedItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Replication protected item custom data details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReplicationProtectedItemProperties>,
}
impl ReplicationProtectedItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Replication protected item collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProtectedItemCollection {
    #[doc = "The Replication protected item details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReplicationProtectedItem>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ReplicationProtectedItemCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Replication protected item custom data details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProtectedItemProperties {
    #[doc = "The name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The type of protected item type."]
    #[serde(rename = "protectedItemType", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_type: Option<String>,
    #[doc = "The protected item ARM Id."]
    #[serde(rename = "protectableItemId", default, skip_serializing_if = "Option::is_none")]
    pub protectable_item_id: Option<String>,
    #[doc = "The recovery provider ARM Id."]
    #[serde(rename = "recoveryServicesProviderId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_services_provider_id: Option<String>,
    #[doc = "The friendly name of the primary fabric."]
    #[serde(rename = "primaryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_friendly_name: Option<String>,
    #[doc = "The fabric provider of the primary fabric."]
    #[serde(rename = "primaryFabricProvider", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_provider: Option<String>,
    #[doc = "The friendly name of recovery fabric."]
    #[serde(rename = "recoveryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_friendly_name: Option<String>,
    #[doc = "The Arm Id of recovery fabric."]
    #[serde(rename = "recoveryFabricId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_id: Option<String>,
    #[doc = "The name of primary protection container friendly name."]
    #[serde(
        rename = "primaryProtectionContainerFriendlyName",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub primary_protection_container_friendly_name: Option<String>,
    #[doc = "The name of recovery container friendly name."]
    #[serde(
        rename = "recoveryProtectionContainerFriendlyName",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub recovery_protection_container_friendly_name: Option<String>,
    #[doc = "The protection status."]
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<String>,
    #[doc = "The protection state description."]
    #[serde(rename = "protectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub protection_state_description: Option<String>,
    #[doc = "The Current active location of the PE."]
    #[serde(rename = "activeLocation", default, skip_serializing_if = "Option::is_none")]
    pub active_location: Option<String>,
    #[doc = "The Test failover state."]
    #[serde(rename = "testFailoverState", default, skip_serializing_if = "Option::is_none")]
    pub test_failover_state: Option<String>,
    #[doc = "The Test failover state description."]
    #[serde(rename = "testFailoverStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub test_failover_state_description: Option<String>,
    #[doc = "The allowed operations on the Replication protected item."]
    #[serde(rename = "allowedOperations", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_operations: Vec<String>,
    #[doc = "The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration."]
    #[serde(rename = "replicationHealth", default, skip_serializing_if = "Option::is_none")]
    pub replication_health: Option<String>,
    #[doc = "The consolidated failover health for the VM."]
    #[serde(rename = "failoverHealth", default, skip_serializing_if = "Option::is_none")]
    pub failover_health: Option<String>,
    #[doc = "List of health errors."]
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[doc = "The ID of Policy governing this PE."]
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[doc = "The name of Policy governing this PE."]
    #[serde(rename = "policyFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_friendly_name: Option<String>,
    #[doc = "The Last successful failover time."]
    #[serde(rename = "lastSuccessfulFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_successful_failover_time: Option<String>,
    #[doc = "The Last successful test failover time."]
    #[serde(rename = "lastSuccessfulTestFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_successful_test_failover_time: Option<String>,
    #[doc = "Current scenario details of the protected entity."]
    #[serde(rename = "currentScenario", default, skip_serializing_if = "Option::is_none")]
    pub current_scenario: Option<CurrentScenarioDetails>,
    #[doc = "The recovery point ARM Id to which the Vm was failed over."]
    #[serde(rename = "failoverRecoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub failover_recovery_point_id: Option<String>,
    #[doc = "Replication provider specific settings."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ReplicationProviderSpecificSettings>,
    #[doc = "The recovery container Id."]
    #[serde(rename = "recoveryContainerId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_container_id: Option<String>,
}
impl ReplicationProtectedItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provider specific input for unpairing operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProviderContainerUnmappingInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ReplicationProviderContainerUnmappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provider specific input for container creation operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProviderSpecificContainerCreationInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ReplicationProviderSpecificContainerCreationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provider specific input for pairing operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProviderSpecificContainerMappingInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ReplicationProviderSpecificContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Replication provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProviderSpecificSettings {
    #[doc = "Gets the Instance type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ReplicationProviderSpecificSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provider specific input for update pairing operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProviderSpecificUpdateContainerMappingInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ReplicationProviderSpecificUpdateContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource Name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource Type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource Location"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class to define the health summary of the resources contained under an Arm resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceHealthSummary {
    #[doc = "The count of total resources under the container."]
    #[serde(rename = "resourceCount", default, skip_serializing_if = "Option::is_none")]
    pub resource_count: Option<i32>,
    #[doc = "The list of summary of health errors across the resources under the container."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub issues: Vec<HealthErrorSummary>,
    #[doc = "The categorized resource counts."]
    #[serde(rename = "categorizedResourceCounts", default, skip_serializing_if = "Option::is_none")]
    pub categorized_resource_counts: Option<serde_json::Value>,
}
impl ResourceHealthSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Resume job params."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResumeJobParams {
    #[doc = "Resume job properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ResumeJobParamsProperties>,
}
impl ResumeJobParams {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Resume job properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResumeJobParamsProperties {
    #[doc = "Resume job comments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
}
impl ResumeJobParamsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Resync input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResyncInput {
    #[doc = "Resync input properties."]
    pub properties: ResyncInputProperties,
}
impl ResyncInput {
    pub fn new(properties: ResyncInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Resync input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResyncInputProperties {
    #[doc = "Resync provider specific input."]
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: ResyncProviderSpecificInput,
}
impl ResyncInputProperties {
    pub fn new(provider_specific_details: ResyncProviderSpecificInput) -> Self {
        Self { provider_specific_details }
    }
}
#[doc = "Resync provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResyncProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ResyncProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[doc = "The retention details of the MT."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetentionVolume {
    #[doc = "The volume name."]
    #[serde(rename = "volumeName", default, skip_serializing_if = "Option::is_none")]
    pub volume_name: Option<String>,
    #[doc = "The volume capacity."]
    #[serde(rename = "capacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub capacity_in_bytes: Option<i64>,
    #[doc = "The free space available in this volume."]
    #[serde(rename = "freeSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub free_space_in_bytes: Option<i64>,
    #[doc = "The threshold percentage."]
    #[serde(rename = "thresholdPercentage", default, skip_serializing_if = "Option::is_none")]
    pub threshold_percentage: Option<i32>,
}
impl RetentionVolume {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Reverse replication input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReverseReplicationInput {
    #[doc = "Reverse replication input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReverseReplicationInputProperties>,
}
impl ReverseReplicationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Reverse replication input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReverseReplicationInputProperties {
    #[doc = "Failover direction."]
    #[serde(rename = "failoverDirection", default, skip_serializing_if = "Option::is_none")]
    pub failover_direction: Option<String>,
    #[doc = "Provider specific reverse replication input."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ReverseReplicationProviderSpecificInput>,
}
impl ReverseReplicationInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provider specific reverse replication input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReverseReplicationProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ReverseReplicationProviderSpecificInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure role assignment details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoleAssignment {
    #[doc = "The ARM Id of the role assignment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the role assignment."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Role assignment scope."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[doc = "Principal Id."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "Role definition id."]
    #[serde(rename = "roleDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub role_definition_id: Option<String>,
}
impl RoleAssignment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "CS Accounts Details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunAsAccount {
    #[doc = "The CS RunAs account Id."]
    #[serde(rename = "accountId", default, skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    #[doc = "The CS RunAs account name."]
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
}
impl RunAsAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "San enable protection provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SanEnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
}
impl SanEnableProtectionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents the script action task details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScriptActionTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[doc = "The name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The path."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "The output."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<String>,
    #[doc = "A value indicating whether it is a primary side script or not."]
    #[serde(rename = "isPrimarySideScript", default, skip_serializing_if = "Option::is_none")]
    pub is_primary_side_script: Option<bool>,
}
impl ScriptActionTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ASR error model"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceError {
    #[doc = "Error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "Possible causes of error."]
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[doc = "Recommended action to resolve error."]
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
    #[doc = "Activity Id."]
    #[serde(rename = "activityId", default, skip_serializing_if = "Option::is_none")]
    pub activity_id: Option<String>,
}
impl ServiceError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Storage object definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassification {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Storage object properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StorageClassificationProperties>,
}
impl StorageClassification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of storage details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationCollection {
    #[doc = "The storage details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<StorageClassification>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl StorageClassificationCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Storage mapping object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationMapping {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Storage mapping properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StorageClassificationMappingProperties>,
}
impl StorageClassificationMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of storage mapping details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationMappingCollection {
    #[doc = "The storage details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<StorageClassificationMapping>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl StorageClassificationMappingCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Storage mapping input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationMappingInput {
    #[doc = "Storage mapping input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StorageMappingInputProperties>,
}
impl StorageClassificationMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Storage mapping properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationMappingProperties {
    #[doc = "Target storage object Id."]
    #[serde(rename = "targetStorageClassificationId", default, skip_serializing_if = "Option::is_none")]
    pub target_storage_classification_id: Option<String>,
}
impl StorageClassificationMappingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Storage object properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationProperties {
    #[doc = "Friendly name of the Storage classification."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl StorageClassificationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Storage mapping input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageMappingInputProperties {
    #[doc = "The ID of the storage object."]
    #[serde(rename = "targetStorageClassificationId", default, skip_serializing_if = "Option::is_none")]
    pub target_storage_classification_id: Option<String>,
}
impl StorageMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Subnets of the network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Subnet {
    #[doc = "The subnet name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The subnet friendly name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The list of addresses for the subnet."]
    #[serde(rename = "addressList", default, skip_serializing_if = "Vec::is_empty")]
    pub address_list: Vec<String>,
}
impl Subnet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Switch protection input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwitchProtectionInput {
    #[doc = "Switch protection input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SwitchProtectionInputProperties>,
}
impl SwitchProtectionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Switch protection input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwitchProtectionInputProperties {
    #[doc = "The unique replication protected item name."]
    #[serde(rename = "replicationProtectedItemName", default, skip_serializing_if = "Option::is_none")]
    pub replication_protected_item_name: Option<String>,
    #[doc = "Provider specific switch protection input."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<SwitchProtectionProviderSpecificInput>,
}
impl SwitchProtectionInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents details for switch protection job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwitchProtectionJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
    #[doc = "ARM Id of the new replication protected item."]
    #[serde(rename = "newReplicationProtectedItemId", default, skip_serializing_if = "Option::is_none")]
    pub new_replication_protected_item_id: Option<String>,
}
impl SwitchProtectionJobDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provider specific switch protection input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwitchProtectionProviderSpecificInput {
    #[doc = "Gets the Instance type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl SwitchProtectionProviderSpecificInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents applicable recovery vm sizes."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetComputeSize {
    #[doc = "The Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The Type of the object."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Represents applicable recovery vm sizes properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TargetComputeSizeProperties>,
}
impl TargetComputeSize {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Target compute size collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetComputeSizeCollection {
    #[doc = "The list of target compute sizes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TargetComputeSize>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TargetComputeSizeCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents applicable recovery vm sizes properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetComputeSizeProperties {
    #[doc = "Target compute size name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Target compute size display name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The maximum cpu cores count supported by target compute size."]
    #[serde(rename = "cpuCoresCount", default, skip_serializing_if = "Option::is_none")]
    pub cpu_cores_count: Option<i32>,
    #[doc = "The maximum memory in GB supported by target compute size."]
    #[serde(rename = "memoryInGB", default, skip_serializing_if = "Option::is_none")]
    pub memory_in_gb: Option<f64>,
    #[doc = "The maximum data disks count supported by target compute size."]
    #[serde(rename = "maxDataDiskCount", default, skip_serializing_if = "Option::is_none")]
    pub max_data_disk_count: Option<i32>,
    #[doc = "The maximum Nics count supported by target compute size."]
    #[serde(rename = "maxNicsCount", default, skip_serializing_if = "Option::is_none")]
    pub max_nics_count: Option<i32>,
    #[doc = "The reasons why the target compute size is not applicable for the protected item."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ComputeSizeErrorDetails>,
    #[doc = "The value indicating whether the target compute size supports high Iops."]
    #[serde(rename = "highIopsSupported", default, skip_serializing_if = "Option::is_none")]
    pub high_iops_supported: Option<String>,
}
impl TargetComputeSizeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Task details based on specific task type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskTypeDetails {
    #[doc = "The type of task details."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl TaskTypeDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input definition for test failover cleanup."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestFailoverCleanupInput {
    #[doc = "Input definition for test failover cleanup input properties."]
    pub properties: TestFailoverCleanupInputProperties,
}
impl TestFailoverCleanupInput {
    pub fn new(properties: TestFailoverCleanupInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Input definition for test failover cleanup input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestFailoverCleanupInputProperties {
    #[doc = "Test failover cleanup comments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
}
impl TestFailoverCleanupInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input definition for planned failover."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestFailoverInput {
    #[doc = "Input definition for planned failover input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TestFailoverInputProperties>,
}
impl TestFailoverInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input definition for planned failover input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestFailoverInputProperties {
    #[doc = "Failover direction."]
    #[serde(rename = "failoverDirection", default, skip_serializing_if = "Option::is_none")]
    pub failover_direction: Option<String>,
    #[doc = "Network type to be used for test failover."]
    #[serde(rename = "networkType", default, skip_serializing_if = "Option::is_none")]
    pub network_type: Option<String>,
    #[doc = "The id of the network to be used for test failover"]
    #[serde(rename = "networkId", default, skip_serializing_if = "Option::is_none")]
    pub network_id: Option<String>,
    #[doc = "A value indicating whether the test failover cleanup is to be skipped."]
    #[serde(rename = "skipTestFailoverCleanup", default, skip_serializing_if = "Option::is_none")]
    pub skip_test_failover_cleanup: Option<String>,
    #[doc = "Provider specific failover input."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ProviderSpecificFailoverInput>,
}
impl TestFailoverInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents the details for a test failover job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestFailoverJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
    #[doc = "The test failover status."]
    #[serde(rename = "testFailoverStatus", default, skip_serializing_if = "Option::is_none")]
    pub test_failover_status: Option<String>,
    #[doc = "The test failover comments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
    #[doc = "The test network name."]
    #[serde(rename = "networkName", default, skip_serializing_if = "Option::is_none")]
    pub network_name: Option<String>,
    #[doc = "The test network friendly name."]
    #[serde(rename = "networkFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub network_friendly_name: Option<String>,
    #[doc = "The test network type (see TestFailoverInput enum for possible values)."]
    #[serde(rename = "networkType", default, skip_serializing_if = "Option::is_none")]
    pub network_type: Option<String>,
    #[doc = "The test VM details."]
    #[serde(rename = "protectedItemDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_item_details: Vec<FailoverReplicationProtectedItemDetails>,
}
impl TestFailoverJobDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input for test migrate cleanup."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestMigrateCleanupInput {
    #[doc = "Test migrate cleanup input properties."]
    pub properties: TestMigrateCleanupInputProperties,
}
impl TestMigrateCleanupInput {
    pub fn new(properties: TestMigrateCleanupInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Test migrate cleanup input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestMigrateCleanupInputProperties {
    #[doc = "Test migrate cleanup comments."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
}
impl TestMigrateCleanupInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input for test migrate."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestMigrateInput {
    #[doc = "Test migrate input properties."]
    pub properties: TestMigrateInputProperties,
}
impl TestMigrateInput {
    pub fn new(properties: TestMigrateInputProperties) -> Self {
        Self { properties }
    }
}
#[doc = "Test migrate input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestMigrateInputProperties {
    #[doc = "Test migrate provider specific input."]
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: TestMigrateProviderSpecificInput,
}
impl TestMigrateInputProperties {
    pub fn new(provider_specific_details: TestMigrateProviderSpecificInput) -> Self {
        Self { provider_specific_details }
    }
}
#[doc = "Test migrate provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestMigrateProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl TestMigrateProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[doc = "Input definition for planned failover."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UnplannedFailoverInput {
    #[doc = "Input definition for planned failover input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UnplannedFailoverInputProperties>,
}
impl UnplannedFailoverInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input definition for planned failover input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UnplannedFailoverInputProperties {
    #[doc = "Failover direction."]
    #[serde(rename = "failoverDirection", default, skip_serializing_if = "Option::is_none")]
    pub failover_direction: Option<String>,
    #[doc = "Source site operations status"]
    #[serde(rename = "sourceSiteOperations", default, skip_serializing_if = "Option::is_none")]
    pub source_site_operations: Option<String>,
    #[doc = "Provider specific failover input."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ProviderSpecificFailoverInput>,
}
impl UnplannedFailoverInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Update migration item input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateMigrationItemInput {
    #[doc = "Update migration item input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateMigrationItemInputProperties>,
}
impl UpdateMigrationItemInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Update migration item input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateMigrationItemInputProperties {
    #[doc = "Update migration item provider specific input."]
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: UpdateMigrationItemProviderSpecificInput,
}
impl UpdateMigrationItemInputProperties {
    pub fn new(provider_specific_details: UpdateMigrationItemProviderSpecificInput) -> Self {
        Self { provider_specific_details }
    }
}
#[doc = "Update migration item provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateMigrationItemProviderSpecificInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl UpdateMigrationItemProviderSpecificInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request to update the mobility service on a protected item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateMobilityServiceRequest {
    #[doc = "The properties of an update mobility service request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateMobilityServiceRequestProperties>,
}
impl UpdateMobilityServiceRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of an update mobility service request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateMobilityServiceRequestProperties {
    #[doc = "The CS run as account Id."]
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
}
impl UpdateMobilityServiceRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Update network mapping input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateNetworkMappingInput {
    #[doc = "Common input details for network mapping operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateNetworkMappingInputProperties>,
}
impl UpdateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common input details for network mapping operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateNetworkMappingInputProperties {
    #[doc = "Recovery fabric name."]
    #[serde(rename = "recoveryFabricName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_name: Option<String>,
    #[doc = "Recovery network Id."]
    #[serde(rename = "recoveryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_network_id: Option<String>,
    #[doc = "Input details specific to fabrics during Network Mapping."]
    #[serde(rename = "fabricSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub fabric_specific_details: Option<FabricSpecificUpdateNetworkMappingInput>,
}
impl UpdateNetworkMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Update policy input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdatePolicyInput {
    #[doc = "Policy update properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdatePolicyInputProperties>,
}
impl UpdatePolicyInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Policy update properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdatePolicyInputProperties {
    #[doc = "Base class for provider specific input"]
    #[serde(rename = "replicationProviderSettings", default, skip_serializing_if = "Option::is_none")]
    pub replication_provider_settings: Option<PolicyProviderSpecificInput>,
}
impl UpdatePolicyInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container pairing update input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateProtectionContainerMappingInput {
    #[doc = "Container pairing update input."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateProtectionContainerMappingInputProperties>,
}
impl UpdateProtectionContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container pairing update input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateProtectionContainerMappingInputProperties {
    #[doc = "Provider specific input for update pairing operations."]
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_input: Option<ReplicationProviderSpecificUpdateContainerMappingInput>,
}
impl UpdateProtectionContainerMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Update recovery plan input class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateRecoveryPlanInput {
    #[doc = "Recovery plan update properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateRecoveryPlanInputProperties>,
}
impl UpdateRecoveryPlanInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Recovery plan update properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateRecoveryPlanInputProperties {
    #[doc = "The recovery plan groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groups: Vec<RecoveryPlanGroup>,
}
impl UpdateRecoveryPlanInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Update replication protected item input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateReplicationProtectedItemInput {
    #[doc = "Update protected item input properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateReplicationProtectedItemInputProperties>,
}
impl UpdateReplicationProtectedItemInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Update protected item input properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateReplicationProtectedItemInputProperties {
    #[doc = "Target azure VM name given by the user."]
    #[serde(rename = "recoveryAzureVMName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_name: Option<String>,
    #[doc = "Target Azure Vm size."]
    #[serde(rename = "recoveryAzureVMSize", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_size: Option<String>,
    #[doc = "Target Azure Network Id."]
    #[serde(rename = "selectedRecoveryAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_recovery_azure_network_id: Option<String>,
    #[doc = "The selected source nic Id which will be used as the primary nic during failover."]
    #[serde(rename = "selectedSourceNicId", default, skip_serializing_if = "Option::is_none")]
    pub selected_source_nic_id: Option<String>,
    #[doc = "The selected option to enable RDP\\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum."]
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[doc = "The list of vm nic details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicInputDetails>,
    #[doc = "License type."]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<update_replication_protected_item_input_properties::LicenseType>,
    #[doc = "The target availability set id."]
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[doc = "Update replication protected item provider specific input."]
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<UpdateReplicationProtectedItemProviderInput>,
}
impl UpdateReplicationProtectedItemInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod update_replication_protected_item_input_properties {
    use super::*;
    #[doc = "License type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
}
#[doc = "Update replication protected item provider specific input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateReplicationProtectedItemProviderInput {
    #[doc = "The class type."]
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl UpdateReplicationProtectedItemProviderInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Input required to update vCenter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateVCenterRequest {
    #[doc = "The properties of an update vCenter request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateVCenterRequestProperties>,
}
impl UpdateVCenterRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of an update vCenter request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateVCenterRequestProperties {
    #[doc = "The friendly name of the vCenter."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "The IP address of the vCenter to be discovered."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The process server Id from where the update can be orchestrated."]
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[doc = "The port number for discovery."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<String>,
    #[doc = "The CS account Id which has privileges to update the vCenter."]
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
}
impl UpdateVCenterRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "vCenter definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VCenter {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "vCenter properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VCenterProperties>,
}
impl VCenter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of vCenter details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VCenterCollection {
    #[doc = "The vCenter details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VCenter>,
    #[doc = "The value of next link."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VCenterCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "vCenter properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VCenterProperties {
    #[doc = "Friendly name of the vCenter."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "VCenter internal ID."]
    #[serde(rename = "internalId", default, skip_serializing_if = "Option::is_none")]
    pub internal_id: Option<String>,
    #[doc = "The time when the last heartbeat was received by vCenter."]
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[doc = "The VCenter discovery status."]
    #[serde(rename = "discoveryStatus", default, skip_serializing_if = "Option::is_none")]
    pub discovery_status: Option<String>,
    #[doc = "The process server Id."]
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[doc = "The IP address of the vCenter."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The infrastructure Id of vCenter."]
    #[serde(rename = "infrastructureId", default, skip_serializing_if = "Option::is_none")]
    pub infrastructure_id: Option<String>,
    #[doc = "The port number for discovery."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<String>,
    #[doc = "The account Id which has privileges to discover the vCenter."]
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[doc = "The ARM resource name of the fabric containing this VCenter."]
    #[serde(rename = "fabricArmResourceName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_arm_resource_name: Option<String>,
    #[doc = "The health errors for this VCenter."]
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
}
impl VCenterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hyper V VM network details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmNicDetails {
    #[doc = "The nic Id."]
    #[serde(rename = "nicId", default, skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    #[doc = "The replica nic Id."]
    #[serde(rename = "replicaNicId", default, skip_serializing_if = "Option::is_none")]
    pub replica_nic_id: Option<String>,
    #[doc = "The source nic ARM Id."]
    #[serde(rename = "sourceNicArmId", default, skip_serializing_if = "Option::is_none")]
    pub source_nic_arm_id: Option<String>,
    #[doc = "VM subnet name."]
    #[serde(rename = "vMSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub v_m_subnet_name: Option<String>,
    #[doc = "VM network name."]
    #[serde(rename = "vMNetworkName", default, skip_serializing_if = "Option::is_none")]
    pub v_m_network_name: Option<String>,
    #[doc = "Recovery VM network Id."]
    #[serde(rename = "recoveryVMNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_vm_network_id: Option<String>,
    #[doc = "Recovery VM subnet name."]
    #[serde(rename = "recoveryVMSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_vm_subnet_name: Option<String>,
    #[doc = "Ip address type."]
    #[serde(rename = "ipAddressType", default, skip_serializing_if = "Option::is_none")]
    pub ip_address_type: Option<String>,
    #[doc = "Primary nic static IP address."]
    #[serde(rename = "primaryNicStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub primary_nic_static_ip_address: Option<String>,
    #[doc = "Replica nic static IP address."]
    #[serde(rename = "replicaNicStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub replica_nic_static_ip_address: Option<String>,
    #[doc = "Selection type for failover."]
    #[serde(rename = "selectionType", default, skip_serializing_if = "Option::is_none")]
    pub selection_type: Option<String>,
    #[doc = "IP allocation type for recovery VM."]
    #[serde(rename = "recoveryNicIpAddressType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_nic_ip_address_type: Option<String>,
    #[doc = "A value indicating whether the NIC has accelerated networking enabled."]
    #[serde(rename = "enableAcceleratedNetworkingOnRecovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking_on_recovery: Option<bool>,
}
impl VmNicDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hyper V VM network input details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmNicInputDetails {
    #[doc = "The nic Id."]
    #[serde(rename = "nicId", default, skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    #[doc = "Recovery VM subnet name."]
    #[serde(rename = "recoveryVMSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_vm_subnet_name: Option<String>,
    #[doc = "Replica nic static IP address."]
    #[serde(rename = "replicaNicStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub replica_nic_static_ip_address: Option<String>,
    #[doc = "Selection type for failover."]
    #[serde(rename = "selectionType", default, skip_serializing_if = "Option::is_none")]
    pub selection_type: Option<String>,
    #[doc = "Whether the NIC has accelerated networking enabled."]
    #[serde(rename = "enableAcceleratedNetworkingOnRecovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking_on_recovery: Option<bool>,
}
impl VmNicInputDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMwareCbt container creation input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtContainerCreationInput {
    #[serde(flatten)]
    pub replication_provider_specific_container_creation_input: ReplicationProviderSpecificContainerCreationInput,
}
impl VMwareCbtContainerCreationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMwareCbt container mapping input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtContainerMappingInput {
    #[serde(flatten)]
    pub replication_provider_specific_container_mapping_input: ReplicationProviderSpecificContainerMappingInput,
    #[doc = "The target key vault ARM Id."]
    #[serde(rename = "keyVaultId")]
    pub key_vault_id: String,
    #[doc = "The target key vault URL."]
    #[serde(rename = "keyVaultUri")]
    pub key_vault_uri: String,
    #[doc = "The storage account ARM Id."]
    #[serde(rename = "storageAccountId")]
    pub storage_account_id: String,
    #[doc = "The secret name of the storage account."]
    #[serde(rename = "storageAccountSasSecretName")]
    pub storage_account_sas_secret_name: String,
    #[doc = "The secret name of the service bus connection string."]
    #[serde(rename = "serviceBusConnectionStringSecretName")]
    pub service_bus_connection_string_secret_name: String,
    #[doc = "The target location."]
    #[serde(rename = "targetLocation")]
    pub target_location: String,
}
impl VMwareCbtContainerMappingInput {
    pub fn new(
        key_vault_id: String,
        key_vault_uri: String,
        storage_account_id: String,
        storage_account_sas_secret_name: String,
        service_bus_connection_string_secret_name: String,
        target_location: String,
    ) -> Self {
        Self {
            replication_provider_specific_container_mapping_input: ReplicationProviderSpecificContainerMappingInput::default(),
            key_vault_id,
            key_vault_uri,
            storage_account_id,
            storage_account_sas_secret_name,
            service_bus_connection_string_secret_name,
            target_location,
        }
    }
}
#[doc = "VMwareCbt disk input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtDiskInput {
    #[doc = "The disk Id."]
    #[serde(rename = "diskId")]
    pub disk_id: String,
    #[doc = "A value indicating whether the disk is the OS disk."]
    #[serde(rename = "isOSDisk")]
    pub is_os_disk: String,
    #[doc = "The log storage account ARM Id."]
    #[serde(rename = "logStorageAccountId")]
    pub log_storage_account_id: String,
    #[doc = "The key vault secret name of the log storage account."]
    #[serde(rename = "logStorageAccountSasSecretName")]
    pub log_storage_account_sas_secret_name: String,
    #[doc = "The disk type."]
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<v_mware_cbt_disk_input::DiskType>,
    #[doc = "The DiskEncryptionSet ARM Id."]
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
}
impl VMwareCbtDiskInput {
    pub fn new(disk_id: String, is_os_disk: String, log_storage_account_id: String, log_storage_account_sas_secret_name: String) -> Self {
        Self {
            disk_id,
            is_os_disk,
            log_storage_account_id,
            log_storage_account_sas_secret_name,
            disk_type: None,
            disk_encryption_set_id: None,
        }
    }
}
pub mod v_mware_cbt_disk_input {
    use super::*;
    #[doc = "The disk type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[doc = "VMwareCbt specific enable migration input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtEnableMigrationInput {
    #[serde(flatten)]
    pub enable_migration_provider_specific_input: EnableMigrationProviderSpecificInput,
    #[doc = "The ARM Id of the VM discovered in VMware."]
    #[serde(rename = "vmwareMachineId")]
    pub vmware_machine_id: String,
    #[doc = "The disks to include list."]
    #[serde(rename = "disksToInclude")]
    pub disks_to_include: Vec<VMwareCbtDiskInput>,
    #[doc = "License type."]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<v_mware_cbt_enable_migration_input::LicenseType>,
    #[doc = "The data mover RunAs account Id."]
    #[serde(rename = "dataMoverRunAsAccountId")]
    pub data_mover_run_as_account_id: String,
    #[doc = "The snapshot RunAs account Id."]
    #[serde(rename = "snapshotRunAsAccountId")]
    pub snapshot_run_as_account_id: String,
    #[doc = "The target VM name."]
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[doc = "The target VM size."]
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[doc = "The target resource group ARM Id."]
    #[serde(rename = "targetResourceGroupId")]
    pub target_resource_group_id: String,
    #[doc = "The target network ARM Id."]
    #[serde(rename = "targetNetworkId")]
    pub target_network_id: String,
    #[doc = "The target subnet name."]
    #[serde(rename = "targetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet_name: Option<String>,
    #[doc = "The target availability set ARM Id."]
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[doc = "The target availability zone."]
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[doc = "The target boot diagnostics storage account ARM Id."]
    #[serde(rename = "targetBootDiagnosticsStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_boot_diagnostics_storage_account_id: Option<String>,
    #[doc = "A value indicating whether auto resync is to be done."]
    #[serde(rename = "performAutoResync", default, skip_serializing_if = "Option::is_none")]
    pub perform_auto_resync: Option<String>,
}
impl VMwareCbtEnableMigrationInput {
    pub fn new(
        enable_migration_provider_specific_input: EnableMigrationProviderSpecificInput,
        vmware_machine_id: String,
        disks_to_include: Vec<VMwareCbtDiskInput>,
        data_mover_run_as_account_id: String,
        snapshot_run_as_account_id: String,
        target_resource_group_id: String,
        target_network_id: String,
    ) -> Self {
        Self {
            enable_migration_provider_specific_input,
            vmware_machine_id,
            disks_to_include,
            license_type: None,
            data_mover_run_as_account_id,
            snapshot_run_as_account_id,
            target_vm_name: None,
            target_vm_size: None,
            target_resource_group_id,
            target_network_id,
            target_subnet_name: None,
            target_availability_set_id: None,
            target_availability_zone: None,
            target_boot_diagnostics_storage_account_id: None,
            perform_auto_resync: None,
        }
    }
}
pub mod v_mware_cbt_enable_migration_input {
    use super::*;
    #[doc = "License type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
}
#[doc = "Event details for VMwareCbt provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[doc = "The migration item name."]
    #[serde(rename = "migrationItemName", default, skip_serializing_if = "Option::is_none")]
    pub migration_item_name: Option<String>,
}
impl VMwareCbtEventDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMwareCbt specific migrate input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtMigrateInput {
    #[serde(flatten)]
    pub migrate_provider_specific_input: MigrateProviderSpecificInput,
    #[doc = "A value indicating whether VM is to be shutdown."]
    #[serde(rename = "performShutdown")]
    pub perform_shutdown: String,
}
impl VMwareCbtMigrateInput {
    pub fn new(migrate_provider_specific_input: MigrateProviderSpecificInput, perform_shutdown: String) -> Self {
        Self {
            migrate_provider_specific_input,
            perform_shutdown,
        }
    }
}
#[doc = "VMwareCbt provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtMigrationDetails {
    #[serde(flatten)]
    pub migration_provider_specific_settings: MigrationProviderSpecificSettings,
    #[doc = "The ARM Id of the VM discovered in VMware."]
    #[serde(rename = "vmwareMachineId", default, skip_serializing_if = "Option::is_none")]
    pub vmware_machine_id: Option<String>,
    #[doc = "The type of the OS on the VM."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "The firmware type."]
    #[serde(rename = "firmwareType", default, skip_serializing_if = "Option::is_none")]
    pub firmware_type: Option<String>,
    #[doc = "The target generation."]
    #[serde(rename = "targetGeneration", default, skip_serializing_if = "Option::is_none")]
    pub target_generation: Option<String>,
    #[doc = "License Type of the VM to be used."]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[doc = "The data mover RunAs account Id."]
    #[serde(rename = "dataMoverRunAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub data_mover_run_as_account_id: Option<String>,
    #[doc = "The snapshot RunAs account Id."]
    #[serde(rename = "snapshotRunAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_run_as_account_id: Option<String>,
    #[doc = "Target VM name."]
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[doc = "The target VM size."]
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[doc = "The target location."]
    #[serde(rename = "targetLocation", default, skip_serializing_if = "Option::is_none")]
    pub target_location: Option<String>,
    #[doc = "The target resource group Id."]
    #[serde(rename = "targetResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_id: Option<String>,
    #[doc = "The target availability set Id."]
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[doc = "The target availability zone."]
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[doc = "The target boot diagnostics storage account ARM Id."]
    #[serde(rename = "targetBootDiagnosticsStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_boot_diagnostics_storage_account_id: Option<String>,
    #[doc = "The list of protected disks."]
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<VMwareCbtProtectedDiskDetails>,
    #[doc = "The target network Id."]
    #[serde(rename = "targetNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_network_id: Option<String>,
    #[doc = "The network details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VMwareCbtNicDetails>,
    #[doc = "The recovery point Id to which the VM was migrated."]
    #[serde(rename = "migrationRecoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub migration_recovery_point_id: Option<String>,
    #[doc = "The last recovery point received time."]
    #[serde(rename = "lastRecoveryPointReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point_received: Option<String>,
    #[doc = "The last recovery point Id."]
    #[serde(rename = "lastRecoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point_id: Option<String>,
    #[doc = "The initial seeding progress percentage."]
    #[serde(rename = "initialSeedingProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub initial_seeding_progress_percentage: Option<i32>,
    #[doc = "The migration progress percentage."]
    #[serde(rename = "migrationProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub migration_progress_percentage: Option<i32>,
    #[doc = "The resync progress percentage."]
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[doc = "A value indicating whether resync is required."]
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<String>,
    #[doc = "The resync state."]
    #[serde(rename = "resyncState", default, skip_serializing_if = "Option::is_none")]
    pub resync_state: Option<v_mware_cbt_migration_details::ResyncState>,
    #[doc = "A value indicating whether auto resync is to be done."]
    #[serde(rename = "performAutoResync", default, skip_serializing_if = "Option::is_none")]
    pub perform_auto_resync: Option<String>,
}
impl VMwareCbtMigrationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod v_mware_cbt_migration_details {
    use super::*;
    #[doc = "The resync state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResyncState {
        None,
        PreparedForResynchronization,
        StartedResynchronization,
    }
}
#[doc = "VMwareCbt NIC details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtNicDetails {
    #[doc = "The NIC Id."]
    #[serde(rename = "nicId", default, skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    #[doc = "A value indicating whether this is the primary NIC."]
    #[serde(rename = "isPrimaryNic", default, skip_serializing_if = "Option::is_none")]
    pub is_primary_nic: Option<String>,
    #[doc = "The source IP address."]
    #[serde(rename = "sourceIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub source_ip_address: Option<String>,
    #[doc = "The source IP address type."]
    #[serde(rename = "sourceIPAddressType", default, skip_serializing_if = "Option::is_none")]
    pub source_ip_address_type: Option<v_mware_cbt_nic_details::SourceIpAddressType>,
    #[doc = "Source network Id."]
    #[serde(rename = "sourceNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub source_network_id: Option<String>,
    #[doc = "The target IP address."]
    #[serde(rename = "targetIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub target_ip_address: Option<String>,
    #[doc = "The target IP address type."]
    #[serde(rename = "targetIPAddressType", default, skip_serializing_if = "Option::is_none")]
    pub target_ip_address_type: Option<v_mware_cbt_nic_details::TargetIpAddressType>,
    #[doc = "Target subnet name."]
    #[serde(rename = "targetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet_name: Option<String>,
    #[doc = "A value indicating whether this NIC is selected for migration."]
    #[serde(rename = "isSelectedForMigration", default, skip_serializing_if = "Option::is_none")]
    pub is_selected_for_migration: Option<String>,
}
impl VMwareCbtNicDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod v_mware_cbt_nic_details {
    use super::*;
    #[doc = "The source IP address type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceIpAddressType {
        Dynamic,
        Static,
    }
    #[doc = "The target IP address type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TargetIpAddressType {
        Dynamic,
        Static,
    }
}
#[doc = "VMwareCbt NIC input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtNicInput {
    #[doc = "The NIC Id."]
    #[serde(rename = "nicId")]
    pub nic_id: String,
    #[doc = "A value indicating whether this is the primary NIC."]
    #[serde(rename = "isPrimaryNic")]
    pub is_primary_nic: String,
    #[doc = "Target subnet name."]
    #[serde(rename = "targetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet_name: Option<String>,
    #[doc = "The static IP address."]
    #[serde(rename = "targetStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub target_static_ip_address: Option<String>,
    #[doc = "A value indicating whether this NIC is selected for migration."]
    #[serde(rename = "isSelectedForMigration", default, skip_serializing_if = "Option::is_none")]
    pub is_selected_for_migration: Option<String>,
}
impl VMwareCbtNicInput {
    pub fn new(nic_id: String, is_primary_nic: String) -> Self {
        Self {
            nic_id,
            is_primary_nic,
            target_subnet_name: None,
            target_static_ip_address: None,
            is_selected_for_migration: None,
        }
    }
}
#[doc = "VMware Cbt policy creation input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtPolicyCreationInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistoryInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_in_minutes: Option<i32>,
    #[doc = "The crash consistent snapshot frequency (in minutes)."]
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "The app consistent snapshot frequency (in minutes)."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
}
impl VMwareCbtPolicyCreationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMwareCbt protected disk details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtProtectedDiskDetails {
    #[doc = "The disk id."]
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[doc = "The disk name."]
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[doc = "The disk path."]
    #[serde(rename = "diskPath", default, skip_serializing_if = "Option::is_none")]
    pub disk_path: Option<String>,
    #[doc = "A value indicating whether the disk is the OS disk."]
    #[serde(rename = "isOSDisk", default, skip_serializing_if = "Option::is_none")]
    pub is_os_disk: Option<String>,
    #[doc = "The disk capacity in bytes."]
    #[serde(rename = "capacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub capacity_in_bytes: Option<i64>,
    #[doc = "The log storage account ARM Id."]
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[doc = "The key vault secret name of the log storage account."]
    #[serde(rename = "logStorageAccountSasSecretName", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_sas_secret_name: Option<String>,
    #[doc = "The DiskEncryptionSet ARM Id."]
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
    #[doc = "The ARM Id of the seed managed disk."]
    #[serde(rename = "seedManagedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub seed_managed_disk_id: Option<String>,
    #[doc = "The ARM Id of the target managed disk."]
    #[serde(rename = "targetManagedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub target_managed_disk_id: Option<String>,
    #[doc = "The disk type."]
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<v_mware_cbt_protected_disk_details::DiskType>,
}
impl VMwareCbtProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod v_mware_cbt_protected_disk_details {
    use super::*;
    #[doc = "The disk type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[doc = "VMwareCbt provider specific container mapping details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtProtectionContainerMappingDetails {
    #[serde(flatten)]
    pub protection_container_mapping_provider_specific_details: ProtectionContainerMappingProviderSpecificDetails,
    #[doc = "The target key vault ARM Id."]
    #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_id: Option<String>,
    #[doc = "The target key vault URI."]
    #[serde(rename = "keyVaultUri", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_uri: Option<String>,
    #[doc = "The storage account ARM Id."]
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[doc = "The secret name of the storage account."]
    #[serde(rename = "storageAccountSasSecretName", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_sas_secret_name: Option<String>,
    #[doc = "The secret name of the service bus connection string."]
    #[serde(rename = "serviceBusConnectionStringSecretName", default, skip_serializing_if = "Option::is_none")]
    pub service_bus_connection_string_secret_name: Option<String>,
    #[doc = "The target location."]
    #[serde(rename = "targetLocation", default, skip_serializing_if = "Option::is_none")]
    pub target_location: Option<String>,
}
impl VMwareCbtProtectionContainerMappingDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMwareCbt specific resync input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtResyncInput {
    #[serde(flatten)]
    pub resync_provider_specific_input: ResyncProviderSpecificInput,
    #[doc = "A value indicating whether CBT is to be reset."]
    #[serde(rename = "skipCbtReset")]
    pub skip_cbt_reset: String,
}
impl VMwareCbtResyncInput {
    pub fn new(resync_provider_specific_input: ResyncProviderSpecificInput, skip_cbt_reset: String) -> Self {
        Self {
            resync_provider_specific_input,
            skip_cbt_reset,
        }
    }
}
#[doc = "VMwareCbt specific test migrate input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtTestMigrateInput {
    #[serde(flatten)]
    pub test_migrate_provider_specific_input: TestMigrateProviderSpecificInput,
    #[doc = "The recovery point Id."]
    #[serde(rename = "recoveryPointId")]
    pub recovery_point_id: String,
    #[doc = "The test network Id."]
    #[serde(rename = "networkId")]
    pub network_id: String,
}
impl VMwareCbtTestMigrateInput {
    pub fn new(
        test_migrate_provider_specific_input: TestMigrateProviderSpecificInput,
        recovery_point_id: String,
        network_id: String,
    ) -> Self {
        Self {
            test_migrate_provider_specific_input,
            recovery_point_id,
            network_id,
        }
    }
}
#[doc = "VMwareCbt specific update migration item input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtUpdateMigrationItemInput {
    #[serde(flatten)]
    pub update_migration_item_provider_specific_input: UpdateMigrationItemProviderSpecificInput,
    #[doc = "The target VM name."]
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[doc = "The target VM size."]
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[doc = "The target resource group ARM Id."]
    #[serde(rename = "targetResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_id: Option<String>,
    #[doc = "The target availability set ARM Id."]
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[doc = "The target availability zone."]
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[doc = "The target boot diagnostics storage account ARM Id."]
    #[serde(rename = "targetBootDiagnosticsStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_boot_diagnostics_storage_account_id: Option<String>,
    #[doc = "The target network ARM Id."]
    #[serde(rename = "targetNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_network_id: Option<String>,
    #[doc = "The list of NIC details."]
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VMwareCbtNicInput>,
    #[doc = "The license type."]
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<v_mware_cbt_update_migration_item_input::LicenseType>,
    #[doc = "A value indicating whether auto resync is to be done."]
    #[serde(rename = "performAutoResync", default, skip_serializing_if = "Option::is_none")]
    pub perform_auto_resync: Option<String>,
}
impl VMwareCbtUpdateMigrationItemInput {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod v_mware_cbt_update_migration_item_input {
    use super::*;
    #[doc = "The license type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
}
#[doc = "Store the fabric details specific to the VMware fabric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
    #[doc = "The list of Process Servers associated with the fabric."]
    #[serde(rename = "processServers", default, skip_serializing_if = "Vec::is_empty")]
    pub process_servers: Vec<ProcessServer>,
    #[doc = "The list of Master Target servers associated with the fabric."]
    #[serde(rename = "masterTargetServers", default, skip_serializing_if = "Vec::is_empty")]
    pub master_target_servers: Vec<MasterTargetServer>,
    #[doc = "The list of run as accounts created on the server."]
    #[serde(rename = "runAsAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub run_as_accounts: Vec<RunAsAccount>,
    #[doc = "The number of replication pairs configured in this CS."]
    #[serde(rename = "replicationPairCount", default, skip_serializing_if = "Option::is_none")]
    pub replication_pair_count: Option<String>,
    #[doc = "The number of process servers."]
    #[serde(rename = "processServerCount", default, skip_serializing_if = "Option::is_none")]
    pub process_server_count: Option<String>,
    #[doc = "The number of source and target servers configured to talk to this CS."]
    #[serde(rename = "agentCount", default, skip_serializing_if = "Option::is_none")]
    pub agent_count: Option<String>,
    #[doc = "The number of protected servers."]
    #[serde(rename = "protectedServers", default, skip_serializing_if = "Option::is_none")]
    pub protected_servers: Option<String>,
    #[doc = "The percentage of the system load."]
    #[serde(rename = "systemLoad", default, skip_serializing_if = "Option::is_none")]
    pub system_load: Option<String>,
    #[doc = "The system load status."]
    #[serde(rename = "systemLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub system_load_status: Option<String>,
    #[doc = "The percentage of the CPU load."]
    #[serde(rename = "cpuLoad", default, skip_serializing_if = "Option::is_none")]
    pub cpu_load: Option<String>,
    #[doc = "The CPU load status."]
    #[serde(rename = "cpuLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub cpu_load_status: Option<String>,
    #[doc = "The total memory."]
    #[serde(rename = "totalMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_memory_in_bytes: Option<i64>,
    #[doc = "The available memory."]
    #[serde(rename = "availableMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_memory_in_bytes: Option<i64>,
    #[doc = "The memory usage status."]
    #[serde(rename = "memoryUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub memory_usage_status: Option<String>,
    #[doc = "The total space."]
    #[serde(rename = "totalSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_space_in_bytes: Option<i64>,
    #[doc = "The available space."]
    #[serde(rename = "availableSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_space_in_bytes: Option<i64>,
    #[doc = "The space usage status."]
    #[serde(rename = "spaceUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub space_usage_status: Option<String>,
    #[doc = "The web load."]
    #[serde(rename = "webLoad", default, skip_serializing_if = "Option::is_none")]
    pub web_load: Option<String>,
    #[doc = "The web load status."]
    #[serde(rename = "webLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub web_load_status: Option<String>,
    #[doc = "The database server load."]
    #[serde(rename = "databaseServerLoad", default, skip_serializing_if = "Option::is_none")]
    pub database_server_load: Option<String>,
    #[doc = "The database server load status."]
    #[serde(rename = "databaseServerLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub database_server_load_status: Option<String>,
    #[doc = "The CS service status."]
    #[serde(rename = "csServiceStatus", default, skip_serializing_if = "Option::is_none")]
    pub cs_service_status: Option<String>,
    #[doc = "The IP address."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The agent Version."]
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[doc = "The host name."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[doc = "The last heartbeat received from CS server."]
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[doc = "Version status"]
    #[serde(rename = "versionStatus", default, skip_serializing_if = "Option::is_none")]
    pub version_status: Option<String>,
    #[doc = "CS SSL cert expiry date."]
    #[serde(rename = "sslCertExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_expiry_date: Option<String>,
    #[doc = "CS SSL cert expiry date."]
    #[serde(rename = "sslCertExpiryRemainingDays", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_expiry_remaining_days: Option<i32>,
    #[doc = "PS template version."]
    #[serde(rename = "psTemplateVersion", default, skip_serializing_if = "Option::is_none")]
    pub ps_template_version: Option<String>,
    #[doc = "Agent expiry date."]
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
    #[doc = "Version related details."]
    #[serde(rename = "agentVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub agent_version_details: Option<VersionDetails>,
}
impl VMwareDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMwareV2 fabric provider specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareV2FabricCreationInput {
    #[serde(flatten)]
    pub fabric_specific_creation_input: FabricSpecificCreationInput,
    #[doc = "The ARM Id of the VMware site."]
    #[serde(rename = "vmwareSiteId", default, skip_serializing_if = "Option::is_none")]
    pub vmware_site_id: Option<String>,
    #[doc = "The ARM Id of the physical site."]
    #[serde(rename = "physicalSiteId", default, skip_serializing_if = "Option::is_none")]
    pub physical_site_id: Option<String>,
    #[doc = "The ARM Id of the migration solution."]
    #[serde(rename = "migrationSolutionId")]
    pub migration_solution_id: String,
}
impl VMwareV2FabricCreationInput {
    pub fn new(migration_solution_id: String) -> Self {
        Self {
            fabric_specific_creation_input: FabricSpecificCreationInput::default(),
            vmware_site_id: None,
            physical_site_id: None,
            migration_solution_id,
        }
    }
}
#[doc = "VMwareV2 fabric specific details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareV2FabricSpecificDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
    #[doc = "The ARM Id of the VMware site."]
    #[serde(rename = "vmwareSiteId", default, skip_serializing_if = "Option::is_none")]
    pub vmware_site_id: Option<String>,
    #[doc = "The ARM Id of the physical site."]
    #[serde(rename = "physicalSiteId", default, skip_serializing_if = "Option::is_none")]
    pub physical_site_id: Option<String>,
    #[doc = "The Migration solution ARM Id."]
    #[serde(rename = "migrationSolutionId", default, skip_serializing_if = "Option::is_none")]
    pub migration_solution_id: Option<String>,
    #[doc = "The service endpoint."]
    #[serde(rename = "serviceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub service_endpoint: Option<String>,
    #[doc = "The service resource Id."]
    #[serde(rename = "serviceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub service_resource_id: Option<String>,
}
impl VMwareV2FabricSpecificDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMware provider specific settings"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareVirtualMachineDetails {
    #[serde(flatten)]
    pub configuration_settings: ConfigurationSettings,
    #[doc = "The ID generated by the InMage agent after it gets installed on guest. This is the ID to be used during InMage CreateProtection."]
    #[serde(rename = "agentGeneratedId", default, skip_serializing_if = "Option::is_none")]
    pub agent_generated_id: Option<String>,
    #[doc = "The value indicating if InMage scout agent is installed on guest."]
    #[serde(rename = "agentInstalled", default, skip_serializing_if = "Option::is_none")]
    pub agent_installed: Option<String>,
    #[doc = "The OsType installed on VM."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "The agent version."]
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[doc = "The IP address."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The value indicating whether VM is powered on."]
    #[serde(rename = "poweredOn", default, skip_serializing_if = "Option::is_none")]
    pub powered_on: Option<String>,
    #[doc = "The VCenter infrastructure Id."]
    #[serde(rename = "vCenterInfrastructureId", default, skip_serializing_if = "Option::is_none")]
    pub v_center_infrastructure_id: Option<String>,
    #[doc = "A value indicating the discovery type of the machine. Value can be vCenter or physical."]
    #[serde(rename = "discoveryType", default, skip_serializing_if = "Option::is_none")]
    pub discovery_type: Option<String>,
    #[doc = "The disk details."]
    #[serde(rename = "diskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_details: Vec<InMageDiskDetails>,
    #[doc = "The validation errors."]
    #[serde(rename = "validationErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_errors: Vec<HealthError>,
}
impl VMwareVirtualMachineDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Vault health details definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultHealthDetails {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "class to define the health summary of the Vault."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VaultHealthProperties>,
}
impl VaultHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "class to define the health summary of the Vault."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultHealthProperties {
    #[doc = "The list of errors on the vault."]
    #[serde(rename = "vaultErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub vault_errors: Vec<HealthError>,
    #[doc = "Base class to define the health summary of the resources contained under an Arm resource."]
    #[serde(rename = "protectedItemsHealth", default, skip_serializing_if = "Option::is_none")]
    pub protected_items_health: Option<ResourceHealthSummary>,
    #[doc = "Base class to define the health summary of the resources contained under an Arm resource."]
    #[serde(rename = "fabricsHealth", default, skip_serializing_if = "Option::is_none")]
    pub fabrics_health: Option<ResourceHealthSummary>,
    #[doc = "Base class to define the health summary of the resources contained under an Arm resource."]
    #[serde(rename = "containersHealth", default, skip_serializing_if = "Option::is_none")]
    pub containers_health: Option<ResourceHealthSummary>,
}
impl VaultHealthProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Version related details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VersionDetails {
    #[doc = "The agent version."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[doc = "Version expiry date."]
    #[serde(rename = "expiryDate", default, skip_serializing_if = "Option::is_none")]
    pub expiry_date: Option<String>,
    #[doc = "A value indicating whether security update required."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<version_details::Status>,
}
impl VersionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod version_details {
    use super::*;
    #[doc = "A value indicating whether security update required."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Supported,
        NotSupported,
        Deprecated,
        UpdateRequired,
        SecurityUpdateRequired,
    }
}
#[doc = "This class represents the virtual machine task details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualMachineTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[doc = "The skipped reason."]
    #[serde(rename = "skippedReason", default, skip_serializing_if = "Option::is_none")]
    pub skipped_reason: Option<String>,
    #[doc = "The skipped reason string."]
    #[serde(rename = "skippedReasonString", default, skip_serializing_if = "Option::is_none")]
    pub skipped_reason_string: Option<String>,
    #[doc = "This class contains the minimal job details required to navigate to the desired drill down."]
    #[serde(rename = "jobTask", default, skip_serializing_if = "Option::is_none")]
    pub job_task: Option<JobEntity>,
}
impl VirtualMachineTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This class represents the vm NicUpdates task details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmNicUpdatesTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[doc = "Virtual machine Id."]
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[doc = "Nic Id."]
    #[serde(rename = "nicId", default, skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    #[doc = "Name of the Nic."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl VmNicUpdatesTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMM fabric specific details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmmDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
}
impl VmmDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Create network mappings input properties/behavior specific to Vmm to Azure Network mapping."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmmToAzureCreateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_create_network_mapping_input: FabricSpecificCreateNetworkMappingInput,
}
impl VmmToAzureCreateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "E2A Network Mapping fabric specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmmToAzureNetworkMappingSettings {
    #[serde(flatten)]
    pub network_mapping_fabric_specific_settings: NetworkMappingFabricSpecificSettings,
}
impl VmmToAzureNetworkMappingSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Update network mappings input properties/behavior specific to vmm to azure."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmmToAzureUpdateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_update_network_mapping_input: FabricSpecificUpdateNetworkMappingInput,
}
impl VmmToAzureUpdateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Create network mappings input properties/behavior specific to vmm to vmm Network mapping."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmmToVmmCreateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_create_network_mapping_input: FabricSpecificCreateNetworkMappingInput,
}
impl VmmToVmmCreateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "E2E Network Mapping fabric specific settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmmToVmmNetworkMappingSettings {
    #[serde(flatten)]
    pub network_mapping_fabric_specific_settings: NetworkMappingFabricSpecificSettings,
}
impl VmmToVmmNetworkMappingSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Update network mappings input properties/behavior specific to vmm to vmm."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmmToVmmUpdateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_update_network_mapping_input: FabricSpecificUpdateNetworkMappingInput,
}
impl VmmToVmmUpdateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VMM fabric provider specific VM settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmmVirtualMachineDetails {
    #[serde(flatten)]
    pub configuration_settings: ConfigurationSettings,
    #[doc = "The source id of the object."]
    #[serde(rename = "sourceItemId", default, skip_serializing_if = "Option::is_none")]
    pub source_item_id: Option<String>,
    #[doc = "The id of the object in fabric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub generation: Option<String>,
    #[doc = "Disk Details."]
    #[serde(rename = "osDetails", default, skip_serializing_if = "Option::is_none")]
    pub os_details: Option<OsDetails>,
    #[doc = "The Last successful failover time."]
    #[serde(rename = "diskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_details: Vec<DiskDetails>,
    #[doc = "A value indicating whether the VM has a physical disk attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[serde(rename = "hasPhysicalDisk", default, skip_serializing_if = "Option::is_none")]
    pub has_physical_disk: Option<vmm_virtual_machine_details::HasPhysicalDisk>,
    #[doc = "A value indicating whether the VM has a fibre channel adapter attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[serde(rename = "hasFibreChannelAdapter", default, skip_serializing_if = "Option::is_none")]
    pub has_fibre_channel_adapter: Option<vmm_virtual_machine_details::HasFibreChannelAdapter>,
    #[doc = "A value indicating whether the VM has a shared VHD attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[serde(rename = "hasSharedVhd", default, skip_serializing_if = "Option::is_none")]
    pub has_shared_vhd: Option<vmm_virtual_machine_details::HasSharedVhd>,
}
impl VmmVirtualMachineDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vmm_virtual_machine_details {
    use super::*;
    #[doc = "A value indicating whether the VM has a physical disk attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HasPhysicalDisk {
        Unknown,
        Present,
        NotPresent,
    }
    #[doc = "A value indicating whether the VM has a fibre channel adapter attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HasFibreChannelAdapter {
        Unknown,
        Present,
        NotPresent,
    }
    #[doc = "A value indicating whether the VM has a shared VHD attached. String value of {SrsDataContract.PresenceStatus} enum."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HasSharedVhd {
        Unknown,
        Present,
        NotPresent,
    }
}
#[doc = "VMware Cbt specific policy details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmwareCbtPolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[doc = "The duration in minutes until which the recovery points need to be stored."]
    #[serde(rename = "recoveryPointHistoryInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_in_minutes: Option<i32>,
    #[doc = "The app consistent snapshot frequency in minutes."]
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[doc = "The crash consistent snapshot frequency in minutes."]
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
}
impl VmwareCbtPolicyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
