#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aAddDisksInput {
    #[serde(flatten)]
    pub add_disks_provider_specific_input: AddDisksProviderSpecificInput,
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<A2aVmDiskInputDetails>,
    #[serde(rename = "vmManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_managed_disks: Vec<A2aVmManagedDiskInputDetails>,
}
impl A2aAddDisksInput {
    pub fn new(add_disks_provider_specific_input: AddDisksProviderSpecificInput) -> Self {
        Self {
            add_disks_provider_specific_input,
            vm_disks: Vec::new(),
            vm_managed_disks: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aApplyRecoveryPointInput {
    #[serde(flatten)]
    pub apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput,
}
impl A2aApplyRecoveryPointInput {
    pub fn new(apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput) -> Self {
        Self {
            apply_recovery_point_provider_specific_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aContainerCreationInput {
    #[serde(flatten)]
    pub replication_provider_specific_container_creation_input: ReplicationProviderSpecificContainerCreationInput,
}
impl A2aContainerCreationInput {
    pub fn new(replication_provider_specific_container_creation_input: ReplicationProviderSpecificContainerCreationInput) -> Self {
        Self {
            replication_provider_specific_container_creation_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aContainerMappingInput {
    #[serde(flatten)]
    pub replication_provider_specific_container_mapping_input: ReplicationProviderSpecificContainerMappingInput,
    #[serde(rename = "agentAutoUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_auto_update_status: Option<a2a_container_mapping_input::AgentAutoUpdateStatus>,
    #[serde(rename = "automationAccountArmId", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_arm_id: Option<String>,
    #[serde(rename = "automationAccountAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_authentication_type: Option<a2a_container_mapping_input::AutomationAccountAuthenticationType>,
}
impl A2aContainerMappingInput {
    pub fn new(replication_provider_specific_container_mapping_input: ReplicationProviderSpecificContainerMappingInput) -> Self {
        Self {
            replication_provider_specific_container_mapping_input,
            agent_auto_update_status: None,
            automation_account_arm_id: None,
            automation_account_authentication_type: None,
        }
    }
}
pub mod a2a_container_mapping_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AgentAutoUpdateStatus {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutomationAccountAuthenticationType {
        RunAsAccount,
        SystemAssignedIdentity,
    }
    impl Default for AutomationAccountAuthenticationType {
        fn default() -> Self {
            Self::RunAsAccount
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aCreateProtectionIntentInput {
    #[serde(flatten)]
    pub create_protection_intent_provider_specific_details: CreateProtectionIntentProviderSpecificDetails,
    #[serde(rename = "fabricObjectId")]
    pub fabric_object_id: String,
    #[serde(rename = "primaryLocation")]
    pub primary_location: String,
    #[serde(rename = "recoveryLocation")]
    pub recovery_location: String,
    #[serde(rename = "recoverySubscriptionId")]
    pub recovery_subscription_id: String,
    #[serde(rename = "recoveryAvailabilityType")]
    pub recovery_availability_type: a2a_create_protection_intent_input::RecoveryAvailabilityType,
    #[serde(rename = "protectionProfileCustomInput", default, skip_serializing_if = "Option::is_none")]
    pub protection_profile_custom_input: Option<ProtectionProfileCustomDetails>,
    #[serde(rename = "recoveryResourceGroupId")]
    pub recovery_resource_group_id: String,
    #[serde(
        rename = "primaryStagingStorageAccountCustomInput",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub primary_staging_storage_account_custom_input: Option<StorageAccountCustomDetails>,
    #[serde(rename = "recoveryAvailabilitySetCustomInput", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_custom_input: Option<RecoveryAvailabilitySetCustomDetails>,
    #[serde(rename = "recoveryVirtualNetworkCustomInput", default, skip_serializing_if = "Option::is_none")]
    pub recovery_virtual_network_custom_input: Option<RecoveryVirtualNetworkCustomDetails>,
    #[serde(
        rename = "recoveryProximityPlacementGroupCustomInput",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub recovery_proximity_placement_group_custom_input: Option<RecoveryProximityPlacementGroupCustomDetails>,
    #[serde(rename = "autoProtectionOfDataDisk", default, skip_serializing_if = "Option::is_none")]
    pub auto_protection_of_data_disk: Option<a2a_create_protection_intent_input::AutoProtectionOfDataDisk>,
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<A2aProtectionIntentDiskInputDetails>,
    #[serde(rename = "vmManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_managed_disks: Vec<A2aProtectionIntentManagedDiskInputDetails>,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[serde(rename = "recoveryBootDiagStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account: Option<StorageAccountCustomDetails>,
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
    #[serde(rename = "recoveryAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_zone: Option<String>,
    #[serde(rename = "agentAutoUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_auto_update_status: Option<a2a_create_protection_intent_input::AgentAutoUpdateStatus>,
    #[serde(rename = "automationAccountAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_authentication_type: Option<a2a_create_protection_intent_input::AutomationAccountAuthenticationType>,
    #[serde(rename = "automationAccountArmId", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_arm_id: Option<String>,
}
impl A2aCreateProtectionIntentInput {
    pub fn new(
        create_protection_intent_provider_specific_details: CreateProtectionIntentProviderSpecificDetails,
        fabric_object_id: String,
        primary_location: String,
        recovery_location: String,
        recovery_subscription_id: String,
        recovery_availability_type: a2a_create_protection_intent_input::RecoveryAvailabilityType,
        recovery_resource_group_id: String,
    ) -> Self {
        Self {
            create_protection_intent_provider_specific_details,
            fabric_object_id,
            primary_location,
            recovery_location,
            recovery_subscription_id,
            recovery_availability_type,
            protection_profile_custom_input: None,
            recovery_resource_group_id,
            primary_staging_storage_account_custom_input: None,
            recovery_availability_set_custom_input: None,
            recovery_virtual_network_custom_input: None,
            recovery_proximity_placement_group_custom_input: None,
            auto_protection_of_data_disk: None,
            vm_disks: Vec::new(),
            vm_managed_disks: Vec::new(),
            multi_vm_group_name: None,
            multi_vm_group_id: None,
            recovery_boot_diag_storage_account: None,
            disk_encryption_info: None,
            recovery_availability_zone: None,
            agent_auto_update_status: None,
            automation_account_authentication_type: None,
            automation_account_arm_id: None,
        }
    }
}
pub mod a2a_create_protection_intent_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryAvailabilityType {
        Single,
        AvailabilitySet,
        AvailabilityZone,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutoProtectionOfDataDisk {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AgentAutoUpdateStatus {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutomationAccountAuthenticationType {
        RunAsAccount,
        SystemAssignedIdentity,
    }
    impl Default for AutomationAccountAuthenticationType {
        fn default() -> Self {
            Self::RunAsAccount
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aCrossClusterMigrationApplyRecoveryPointInput {
    #[serde(flatten)]
    pub apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput,
}
impl A2aCrossClusterMigrationApplyRecoveryPointInput {
    pub fn new(apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput) -> Self {
        Self {
            apply_recovery_point_provider_specific_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aCrossClusterMigrationContainerCreationInput {
    #[serde(flatten)]
    pub replication_provider_specific_container_creation_input: ReplicationProviderSpecificContainerCreationInput,
}
impl A2aCrossClusterMigrationContainerCreationInput {
    pub fn new(replication_provider_specific_container_creation_input: ReplicationProviderSpecificContainerCreationInput) -> Self {
        Self {
            replication_provider_specific_container_creation_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aCrossClusterMigrationEnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(rename = "recoveryContainerId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_container_id: Option<String>,
}
impl A2aCrossClusterMigrationEnableProtectionInput {
    pub fn new(enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput) -> Self {
        Self {
            enable_protection_provider_specific_input,
            fabric_object_id: None,
            recovery_container_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aCrossClusterMigrationPolicyCreationInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
}
impl A2aCrossClusterMigrationPolicyCreationInput {
    pub fn new(policy_provider_specific_input: PolicyProviderSpecificInput) -> Self {
        Self {
            policy_provider_specific_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aCrossClusterMigrationReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(rename = "primaryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_location: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[serde(rename = "lifecycleId", default, skip_serializing_if = "Option::is_none")]
    pub lifecycle_id: Option<String>,
}
impl A2aCrossClusterMigrationReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            fabric_object_id: None,
            primary_fabric_location: None,
            os_type: None,
            vm_protection_state: None,
            vm_protection_state_description: None,
            lifecycle_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aEnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[serde(rename = "fabricObjectId")]
    pub fabric_object_id: String,
    #[serde(rename = "recoveryContainerId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_container_id: Option<String>,
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[serde(rename = "recoveryCloudServiceId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service_id: Option<String>,
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[serde(rename = "recoveryProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_proximity_placement_group_id: Option<String>,
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<A2aVmDiskInputDetails>,
    #[serde(rename = "vmManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_managed_disks: Vec<A2aVmManagedDiskInputDetails>,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[serde(rename = "recoveryBootDiagStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account_id: Option<String>,
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
    #[serde(rename = "recoveryAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_zone: Option<String>,
    #[serde(rename = "recoveryAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_network_id: Option<String>,
    #[serde(rename = "recoverySubnetName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_subnet_name: Option<String>,
    #[serde(rename = "recoveryVirtualMachineScaleSetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_virtual_machine_scale_set_id: Option<String>,
    #[serde(rename = "recoveryCapacityReservationGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_capacity_reservation_group_id: Option<String>,
}
impl A2aEnableProtectionInput {
    pub fn new(enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput, fabric_object_id: String) -> Self {
        Self {
            enable_protection_provider_specific_input,
            fabric_object_id,
            recovery_container_id: None,
            recovery_resource_group_id: None,
            recovery_cloud_service_id: None,
            recovery_availability_set_id: None,
            recovery_proximity_placement_group_id: None,
            vm_disks: Vec::new(),
            vm_managed_disks: Vec::new(),
            multi_vm_group_name: None,
            multi_vm_group_id: None,
            recovery_boot_diag_storage_account_id: None,
            disk_encryption_info: None,
            recovery_availability_zone: None,
            recovery_azure_network_id: None,
            recovery_subnet_name: None,
            recovery_virtual_machine_scale_set_id: None,
            recovery_capacity_reservation_group_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[serde(rename = "protectedItemName", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_name: Option<String>,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "fabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub fabric_location: Option<String>,
    #[serde(rename = "remoteFabricName", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_name: Option<String>,
    #[serde(rename = "remoteFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_location: Option<String>,
}
impl A2aEventDetails {
    pub fn new(event_provider_specific_details: EventProviderSpecificDetails) -> Self {
        Self {
            event_provider_specific_details,
            protected_item_name: None,
            fabric_object_id: None,
            fabric_name: None,
            fabric_location: None,
            remote_fabric_name: None,
            remote_fabric_location: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aPolicyCreationInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "multiVmSyncStatus")]
    pub multi_vm_sync_status: a2a_policy_creation_input::MultiVmSyncStatus,
}
impl A2aPolicyCreationInput {
    pub fn new(
        policy_provider_specific_input: PolicyProviderSpecificInput,
        multi_vm_sync_status: a2a_policy_creation_input::MultiVmSyncStatus,
    ) -> Self {
        Self {
            policy_provider_specific_input,
            recovery_point_history: None,
            crash_consistent_frequency_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status,
        }
    }
}
pub mod a2a_policy_creation_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncStatus {
        Enable,
        Disable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aPolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
}
impl A2aPolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            recovery_point_threshold_in_minutes: None,
            recovery_point_history: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status: None,
            crash_consistent_frequency_in_minutes: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aProtectedDiskDetails {
    #[serde(rename = "diskUri", default, skip_serializing_if = "Option::is_none")]
    pub disk_uri: Option<String>,
    #[serde(rename = "recoveryAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_storage_account_id: Option<String>,
    #[serde(rename = "primaryDiskAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub primary_disk_azure_storage_account_id: Option<String>,
    #[serde(rename = "recoveryDiskUri", default, skip_serializing_if = "Option::is_none")]
    pub recovery_disk_uri: Option<String>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "diskCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_capacity_in_bytes: Option<i64>,
    #[serde(rename = "primaryStagingAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub primary_staging_azure_storage_account_id: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<String>,
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<bool>,
    #[serde(rename = "monitoringPercentageCompletion", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_percentage_completion: Option<i32>,
    #[serde(rename = "monitoringJobType", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_job_type: Option<String>,
    #[serde(
        rename = "dataPendingInStagingStorageAccountInMB",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub data_pending_in_staging_storage_account_in_mb: Option<f64>,
    #[serde(rename = "dataPendingAtSourceAgentInMB", default, skip_serializing_if = "Option::is_none")]
    pub data_pending_at_source_agent_in_mb: Option<f64>,
    #[serde(rename = "diskState", default, skip_serializing_if = "Option::is_none")]
    pub disk_state: Option<String>,
    #[serde(rename = "allowedDiskLevelOperation", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_disk_level_operation: Vec<String>,
    #[serde(rename = "isDiskEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_disk_encrypted: Option<bool>,
    #[serde(rename = "secretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub secret_identifier: Option<String>,
    #[serde(rename = "dekKeyVaultArmId", default, skip_serializing_if = "Option::is_none")]
    pub dek_key_vault_arm_id: Option<String>,
    #[serde(rename = "isDiskKeyEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_disk_key_encrypted: Option<bool>,
    #[serde(rename = "keyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub key_identifier: Option<String>,
    #[serde(rename = "kekKeyVaultArmId", default, skip_serializing_if = "Option::is_none")]
    pub kek_key_vault_arm_id: Option<String>,
    #[serde(rename = "failoverDiskName", default, skip_serializing_if = "Option::is_none")]
    pub failover_disk_name: Option<String>,
    #[serde(rename = "tfoDiskName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_disk_name: Option<String>,
}
impl A2aProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aProtectedManagedDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[serde(rename = "recoveryTargetDiskId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target_disk_id: Option<String>,
    #[serde(rename = "recoveryReplicaDiskId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_replica_disk_id: Option<String>,
    #[serde(rename = "recoveryOrignalTargetDiskId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_orignal_target_disk_id: Option<String>,
    #[serde(rename = "recoveryReplicaDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_replica_disk_account_type: Option<String>,
    #[serde(rename = "recoveryTargetDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target_disk_account_type: Option<String>,
    #[serde(rename = "recoveryDiskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_disk_encryption_set_id: Option<String>,
    #[serde(rename = "primaryDiskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub primary_disk_encryption_set_id: Option<String>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "diskCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_capacity_in_bytes: Option<i64>,
    #[serde(rename = "primaryStagingAzureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub primary_staging_azure_storage_account_id: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<String>,
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<bool>,
    #[serde(rename = "monitoringPercentageCompletion", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_percentage_completion: Option<i32>,
    #[serde(rename = "monitoringJobType", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_job_type: Option<String>,
    #[serde(
        rename = "dataPendingInStagingStorageAccountInMB",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub data_pending_in_staging_storage_account_in_mb: Option<f64>,
    #[serde(rename = "dataPendingAtSourceAgentInMB", default, skip_serializing_if = "Option::is_none")]
    pub data_pending_at_source_agent_in_mb: Option<f64>,
    #[serde(rename = "diskState", default, skip_serializing_if = "Option::is_none")]
    pub disk_state: Option<String>,
    #[serde(rename = "allowedDiskLevelOperation", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_disk_level_operation: Vec<String>,
    #[serde(rename = "isDiskEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_disk_encrypted: Option<bool>,
    #[serde(rename = "secretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub secret_identifier: Option<String>,
    #[serde(rename = "dekKeyVaultArmId", default, skip_serializing_if = "Option::is_none")]
    pub dek_key_vault_arm_id: Option<String>,
    #[serde(rename = "isDiskKeyEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_disk_key_encrypted: Option<bool>,
    #[serde(rename = "keyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub key_identifier: Option<String>,
    #[serde(rename = "kekKeyVaultArmId", default, skip_serializing_if = "Option::is_none")]
    pub kek_key_vault_arm_id: Option<String>,
    #[serde(rename = "failoverDiskName", default, skip_serializing_if = "Option::is_none")]
    pub failover_disk_name: Option<String>,
    #[serde(rename = "tfoDiskName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_disk_name: Option<String>,
}
impl A2aProtectedManagedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aProtectionContainerMappingDetails {
    #[serde(flatten)]
    pub protection_container_mapping_provider_specific_details: ProtectionContainerMappingProviderSpecificDetails,
    #[serde(rename = "agentAutoUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_auto_update_status: Option<a2a_protection_container_mapping_details::AgentAutoUpdateStatus>,
    #[serde(rename = "automationAccountArmId", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_arm_id: Option<String>,
    #[serde(rename = "automationAccountAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_authentication_type: Option<a2a_protection_container_mapping_details::AutomationAccountAuthenticationType>,
    #[serde(rename = "scheduleName", default, skip_serializing_if = "Option::is_none")]
    pub schedule_name: Option<String>,
    #[serde(rename = "jobScheduleName", default, skip_serializing_if = "Option::is_none")]
    pub job_schedule_name: Option<String>,
}
impl A2aProtectionContainerMappingDetails {
    pub fn new(protection_container_mapping_provider_specific_details: ProtectionContainerMappingProviderSpecificDetails) -> Self {
        Self {
            protection_container_mapping_provider_specific_details,
            agent_auto_update_status: None,
            automation_account_arm_id: None,
            automation_account_authentication_type: None,
            schedule_name: None,
            job_schedule_name: None,
        }
    }
}
pub mod a2a_protection_container_mapping_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AgentAutoUpdateStatus {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutomationAccountAuthenticationType {
        RunAsAccount,
        SystemAssignedIdentity,
    }
    impl Default for AutomationAccountAuthenticationType {
        fn default() -> Self {
            Self::RunAsAccount
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aProtectionIntentDiskInputDetails {
    #[serde(rename = "diskUri")]
    pub disk_uri: String,
    #[serde(
        rename = "recoveryAzureStorageAccountCustomInput",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub recovery_azure_storage_account_custom_input: Option<StorageAccountCustomDetails>,
    #[serde(
        rename = "primaryStagingStorageAccountCustomInput",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub primary_staging_storage_account_custom_input: Option<StorageAccountCustomDetails>,
}
impl A2aProtectionIntentDiskInputDetails {
    pub fn new(disk_uri: String) -> Self {
        Self {
            disk_uri,
            recovery_azure_storage_account_custom_input: None,
            primary_staging_storage_account_custom_input: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aProtectionIntentManagedDiskInputDetails {
    #[serde(rename = "diskId")]
    pub disk_id: String,
    #[serde(
        rename = "primaryStagingStorageAccountCustomInput",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub primary_staging_storage_account_custom_input: Option<StorageAccountCustomDetails>,
    #[serde(rename = "recoveryResourceGroupCustomInput", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_custom_input: Option<RecoveryResourceGroupCustomDetails>,
    #[serde(rename = "recoveryReplicaDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_replica_disk_account_type: Option<String>,
    #[serde(rename = "recoveryTargetDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target_disk_account_type: Option<String>,
    #[serde(rename = "recoveryDiskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_disk_encryption_set_id: Option<String>,
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
}
impl A2aProtectionIntentManagedDiskInputDetails {
    pub fn new(disk_id: String) -> Self {
        Self {
            disk_id,
            primary_staging_storage_account_custom_input: None,
            recovery_resource_group_custom_input: None,
            recovery_replica_disk_account_type: None,
            recovery_target_disk_account_type: None,
            recovery_disk_encryption_set_id: None,
            disk_encryption_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aRecoveryPointDetails {
    #[serde(flatten)]
    pub provider_specific_recovery_point_details: ProviderSpecificRecoveryPointDetails,
    #[serde(rename = "recoveryPointSyncType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_sync_type: Option<a2a_recovery_point_details::RecoveryPointSyncType>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<String>,
}
impl A2aRecoveryPointDetails {
    pub fn new(provider_specific_recovery_point_details: ProviderSpecificRecoveryPointDetails) -> Self {
        Self {
            provider_specific_recovery_point_details,
            recovery_point_sync_type: None,
            disks: Vec::new(),
        }
    }
}
pub mod a2a_recovery_point_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointSyncType {
        MultiVmSyncRecoveryPoint,
        PerVmRecoveryPoint,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aRemoveDisksInput {
    #[serde(flatten)]
    pub remove_disks_provider_specific_input: RemoveDisksProviderSpecificInput,
    #[serde(rename = "vmDisksUris", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks_uris: Vec<String>,
    #[serde(rename = "vmManagedDisksIds", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_managed_disks_ids: Vec<String>,
}
impl A2aRemoveDisksInput {
    pub fn new(remove_disks_provider_specific_input: RemoveDisksProviderSpecificInput) -> Self {
        Self {
            remove_disks_provider_specific_input,
            vm_disks_uris: Vec::new(),
            vm_managed_disks_ids: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(rename = "initialPrimaryZone", default, skip_serializing_if = "Option::is_none")]
    pub initial_primary_zone: Option<String>,
    #[serde(rename = "initialPrimaryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub initial_primary_fabric_location: Option<String>,
    #[serde(rename = "initialRecoveryZone", default, skip_serializing_if = "Option::is_none")]
    pub initial_recovery_zone: Option<String>,
    #[serde(rename = "initialRecoveryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub initial_recovery_fabric_location: Option<String>,
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[serde(rename = "multiVmGroupCreateOption", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_create_option: Option<a2a_replication_details::MultiVmGroupCreateOption>,
    #[serde(rename = "managementId", default, skip_serializing_if = "Option::is_none")]
    pub management_id: Option<String>,
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<A2aProtectedDiskDetails>,
    #[serde(rename = "unprotectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub unprotected_disks: Vec<A2aUnprotectedDiskDetails>,
    #[serde(rename = "protectedManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_managed_disks: Vec<A2aProtectedManagedDiskDetails>,
    #[serde(rename = "recoveryBootDiagStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account_id: Option<String>,
    #[serde(rename = "primaryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_location: Option<String>,
    #[serde(rename = "recoveryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_location: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "recoveryAzureVMSize", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_size: Option<String>,
    #[serde(rename = "recoveryAzureVMName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_name: Option<String>,
    #[serde(rename = "recoveryAzureResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_resource_group_id: Option<String>,
    #[serde(rename = "recoveryCloudService", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service: Option<String>,
    #[serde(rename = "recoveryAvailabilitySet", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set: Option<String>,
    #[serde(rename = "selectedRecoveryAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_recovery_azure_network_id: Option<String>,
    #[serde(rename = "selectedTfoAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_tfo_azure_network_id: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[serde(rename = "vmSyncedConfigDetails", default, skip_serializing_if = "Option::is_none")]
    pub vm_synced_config_details: Option<AzureToAzureVmSyncedConfigDetails>,
    #[serde(rename = "monitoringPercentageCompletion", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_percentage_completion: Option<i32>,
    #[serde(rename = "monitoringJobType", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_job_type: Option<String>,
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
    #[serde(rename = "isReplicationAgentUpdateRequired", default, skip_serializing_if = "Option::is_none")]
    pub is_replication_agent_update_required: Option<bool>,
    #[serde(rename = "agentCertificateExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_certificate_expiry_date: Option<String>,
    #[serde(
        rename = "isReplicationAgentCertificateUpdateRequired",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub is_replication_agent_certificate_update_required: Option<bool>,
    #[serde(rename = "recoveryFabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_object_id: Option<String>,
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[serde(rename = "lifecycleId", default, skip_serializing_if = "Option::is_none")]
    pub lifecycle_id: Option<String>,
    #[serde(rename = "testFailoverRecoveryFabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub test_failover_recovery_fabric_object_id: Option<String>,
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[serde(rename = "primaryAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub primary_availability_zone: Option<String>,
    #[serde(rename = "recoveryAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_zone: Option<String>,
    #[serde(rename = "vmEncryptionType", default, skip_serializing_if = "Option::is_none")]
    pub vm_encryption_type: Option<a2a_replication_details::VmEncryptionType>,
    #[serde(rename = "tfoAzureVMName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_azure_vm_name: Option<String>,
    #[serde(rename = "recoveryAzureGeneration", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_generation: Option<String>,
    #[serde(rename = "recoveryProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_proximity_placement_group_id: Option<String>,
    #[serde(rename = "autoProtectionOfDataDisk", default, skip_serializing_if = "Option::is_none")]
    pub auto_protection_of_data_disk: Option<a2a_replication_details::AutoProtectionOfDataDisk>,
    #[serde(rename = "recoveryVirtualMachineScaleSetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_virtual_machine_scale_set_id: Option<String>,
    #[serde(rename = "recoveryCapacityReservationGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_capacity_reservation_group_id: Option<String>,
}
impl A2aReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            fabric_object_id: None,
            initial_primary_zone: None,
            initial_primary_fabric_location: None,
            initial_recovery_zone: None,
            initial_recovery_fabric_location: None,
            multi_vm_group_id: None,
            multi_vm_group_name: None,
            multi_vm_group_create_option: None,
            management_id: None,
            protected_disks: Vec::new(),
            unprotected_disks: Vec::new(),
            protected_managed_disks: Vec::new(),
            recovery_boot_diag_storage_account_id: None,
            primary_fabric_location: None,
            recovery_fabric_location: None,
            os_type: None,
            recovery_azure_vm_size: None,
            recovery_azure_vm_name: None,
            recovery_azure_resource_group_id: None,
            recovery_cloud_service: None,
            recovery_availability_set: None,
            selected_recovery_azure_network_id: None,
            selected_tfo_azure_network_id: None,
            vm_nics: Vec::new(),
            vm_synced_config_details: None,
            monitoring_percentage_completion: None,
            monitoring_job_type: None,
            last_heartbeat: None,
            agent_version: None,
            agent_expiry_date: None,
            is_replication_agent_update_required: None,
            agent_certificate_expiry_date: None,
            is_replication_agent_certificate_update_required: None,
            recovery_fabric_object_id: None,
            vm_protection_state: None,
            vm_protection_state_description: None,
            lifecycle_id: None,
            test_failover_recovery_fabric_object_id: None,
            rpo_in_seconds: None,
            last_rpo_calculated_time: None,
            primary_availability_zone: None,
            recovery_availability_zone: None,
            vm_encryption_type: None,
            tfo_azure_vm_name: None,
            recovery_azure_generation: None,
            recovery_proximity_placement_group_id: None,
            auto_protection_of_data_disk: None,
            recovery_virtual_machine_scale_set_id: None,
            recovery_capacity_reservation_group_id: None,
        }
    }
}
pub mod a2a_replication_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmGroupCreateOption {
        AutoCreated,
        UserSpecified,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VmEncryptionType {
        NotEncrypted,
        OnePassEncrypted,
        TwoPassEncrypted,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutoProtectionOfDataDisk {
        Disabled,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aReplicationIntentDetails {
    #[serde(flatten)]
    pub replication_protection_intent_provider_specific_settings: ReplicationProtectionIntentProviderSpecificSettings,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(rename = "primaryLocation", default, skip_serializing_if = "Option::is_none")]
    pub primary_location: Option<String>,
    #[serde(rename = "recoveryLocation", default, skip_serializing_if = "Option::is_none")]
    pub recovery_location: Option<String>,
    #[serde(rename = "recoverySubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_subscription_id: Option<String>,
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<A2aProtectionIntentDiskInputDetails>,
    #[serde(rename = "vmManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_managed_disks: Vec<A2aProtectionIntentManagedDiskInputDetails>,
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[serde(rename = "protectionProfile", default, skip_serializing_if = "Option::is_none")]
    pub protection_profile: Option<ProtectionProfileCustomDetails>,
    #[serde(rename = "primaryStagingStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub primary_staging_storage_account: Option<StorageAccountCustomDetails>,
    #[serde(rename = "recoveryAvailabilitySet", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set: Option<RecoveryAvailabilitySetCustomDetails>,
    #[serde(rename = "recoveryVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub recovery_virtual_network: Option<RecoveryVirtualNetworkCustomDetails>,
    #[serde(rename = "recoveryProximityPlacementGroup", default, skip_serializing_if = "Option::is_none")]
    pub recovery_proximity_placement_group: Option<RecoveryProximityPlacementGroupCustomDetails>,
    #[serde(rename = "autoProtectionOfDataDisk", default, skip_serializing_if = "Option::is_none")]
    pub auto_protection_of_data_disk: Option<a2a_replication_intent_details::AutoProtectionOfDataDisk>,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[serde(rename = "recoveryBootDiagStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account: Option<StorageAccountCustomDetails>,
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
    #[serde(rename = "recoveryAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_zone: Option<String>,
    #[serde(rename = "recoveryAvailabilityType")]
    pub recovery_availability_type: String,
    #[serde(rename = "agentAutoUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_auto_update_status: Option<a2a_replication_intent_details::AgentAutoUpdateStatus>,
    #[serde(rename = "automationAccountArmId", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_arm_id: Option<String>,
    #[serde(rename = "automationAccountAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_authentication_type: Option<a2a_replication_intent_details::AutomationAccountAuthenticationType>,
}
impl A2aReplicationIntentDetails {
    pub fn new(
        replication_protection_intent_provider_specific_settings: ReplicationProtectionIntentProviderSpecificSettings,
        recovery_availability_type: String,
    ) -> Self {
        Self {
            replication_protection_intent_provider_specific_settings,
            fabric_object_id: None,
            primary_location: None,
            recovery_location: None,
            recovery_subscription_id: None,
            vm_disks: Vec::new(),
            vm_managed_disks: Vec::new(),
            recovery_resource_group_id: None,
            protection_profile: None,
            primary_staging_storage_account: None,
            recovery_availability_set: None,
            recovery_virtual_network: None,
            recovery_proximity_placement_group: None,
            auto_protection_of_data_disk: None,
            multi_vm_group_name: None,
            multi_vm_group_id: None,
            recovery_boot_diag_storage_account: None,
            disk_encryption_info: None,
            recovery_availability_zone: None,
            recovery_availability_type,
            agent_auto_update_status: None,
            automation_account_arm_id: None,
            automation_account_authentication_type: None,
        }
    }
}
pub mod a2a_replication_intent_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutoProtectionOfDataDisk {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AgentAutoUpdateStatus {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutomationAccountAuthenticationType {
        RunAsAccount,
        SystemAssignedIdentity,
    }
    impl Default for AutomationAccountAuthenticationType {
        fn default() -> Self {
            Self::RunAsAccount
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[serde(rename = "recoveryContainerId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_container_id: Option<String>,
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<A2aVmDiskInputDetails>,
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[serde(rename = "recoveryCloudServiceId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service_id: Option<String>,
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
}
impl A2aReprotectInput {
    pub fn new(reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput) -> Self {
        Self {
            reverse_replication_provider_specific_input,
            recovery_container_id: None,
            vm_disks: Vec::new(),
            recovery_resource_group_id: None,
            recovery_cloud_service_id: None,
            recovery_availability_set_id: None,
            policy_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aSwitchProtectionInput {
    #[serde(flatten)]
    pub switch_protection_provider_specific_input: SwitchProtectionProviderSpecificInput,
    #[serde(rename = "recoveryContainerId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_container_id: Option<String>,
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<A2aVmDiskInputDetails>,
    #[serde(rename = "vmManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_managed_disks: Vec<A2aVmManagedDiskInputDetails>,
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[serde(rename = "recoveryCloudServiceId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service_id: Option<String>,
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(rename = "recoveryBootDiagStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account_id: Option<String>,
    #[serde(rename = "recoveryAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_zone: Option<String>,
    #[serde(rename = "recoveryProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_proximity_placement_group_id: Option<String>,
    #[serde(rename = "recoveryVirtualMachineScaleSetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_virtual_machine_scale_set_id: Option<String>,
    #[serde(rename = "recoveryCapacityReservationGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_capacity_reservation_group_id: Option<String>,
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
}
impl A2aSwitchProtectionInput {
    pub fn new(switch_protection_provider_specific_input: SwitchProtectionProviderSpecificInput) -> Self {
        Self {
            switch_protection_provider_specific_input,
            recovery_container_id: None,
            vm_disks: Vec::new(),
            vm_managed_disks: Vec::new(),
            recovery_resource_group_id: None,
            recovery_cloud_service_id: None,
            recovery_availability_set_id: None,
            policy_id: None,
            recovery_boot_diag_storage_account_id: None,
            recovery_availability_zone: None,
            recovery_proximity_placement_group_id: None,
            recovery_virtual_machine_scale_set_id: None,
            recovery_capacity_reservation_group_id: None,
            disk_encryption_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aTestFailoverInput {
    #[serde(flatten)]
    pub test_failover_provider_specific_input: TestFailoverProviderSpecificInput,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "cloudServiceCreationOption", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_creation_option: Option<String>,
}
impl A2aTestFailoverInput {
    pub fn new(test_failover_provider_specific_input: TestFailoverProviderSpecificInput) -> Self {
        Self {
            test_failover_provider_specific_input,
            recovery_point_id: None,
            cloud_service_creation_option: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aUnplannedFailoverInput {
    #[serde(flatten)]
    pub unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "cloudServiceCreationOption", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_creation_option: Option<String>,
}
impl A2aUnplannedFailoverInput {
    pub fn new(unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput) -> Self {
        Self {
            unplanned_failover_provider_specific_input,
            recovery_point_id: None,
            cloud_service_creation_option: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aUnprotectedDiskDetails {
    #[serde(rename = "diskLunId", default, skip_serializing_if = "Option::is_none")]
    pub disk_lun_id: Option<i32>,
    #[serde(rename = "diskAutoProtectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub disk_auto_protection_status: Option<a2a_unprotected_disk_details::DiskAutoProtectionStatus>,
}
impl A2aUnprotectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod a2a_unprotected_disk_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskAutoProtectionStatus {
        Disabled,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aUpdateContainerMappingInput {
    #[serde(flatten)]
    pub replication_provider_specific_update_container_mapping_input: ReplicationProviderSpecificUpdateContainerMappingInput,
    #[serde(rename = "agentAutoUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_auto_update_status: Option<a2a_update_container_mapping_input::AgentAutoUpdateStatus>,
    #[serde(rename = "automationAccountArmId", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_arm_id: Option<String>,
    #[serde(rename = "automationAccountAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub automation_account_authentication_type: Option<a2a_update_container_mapping_input::AutomationAccountAuthenticationType>,
}
impl A2aUpdateContainerMappingInput {
    pub fn new(
        replication_provider_specific_update_container_mapping_input: ReplicationProviderSpecificUpdateContainerMappingInput,
    ) -> Self {
        Self {
            replication_provider_specific_update_container_mapping_input,
            agent_auto_update_status: None,
            automation_account_arm_id: None,
            automation_account_authentication_type: None,
        }
    }
}
pub mod a2a_update_container_mapping_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AgentAutoUpdateStatus {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AutomationAccountAuthenticationType {
        RunAsAccount,
        SystemAssignedIdentity,
    }
    impl Default for AutomationAccountAuthenticationType {
        fn default() -> Self {
            Self::RunAsAccount
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aUpdateReplicationProtectedItemInput {
    #[serde(flatten)]
    pub update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput,
    #[serde(rename = "recoveryCloudServiceId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_cloud_service_id: Option<String>,
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
    #[serde(rename = "managedDiskUpdateDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub managed_disk_update_details: Vec<A2aVmManagedDiskUpdateDetails>,
    #[serde(rename = "recoveryBootDiagStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_boot_diag_storage_account_id: Option<String>,
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
    #[serde(rename = "tfoAzureVMName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_azure_vm_name: Option<String>,
    #[serde(rename = "recoveryProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_proximity_placement_group_id: Option<String>,
    #[serde(rename = "recoveryVirtualMachineScaleSetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_virtual_machine_scale_set_id: Option<String>,
    #[serde(rename = "recoveryCapacityReservationGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_capacity_reservation_group_id: Option<String>,
}
impl A2aUpdateReplicationProtectedItemInput {
    pub fn new(update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput) -> Self {
        Self {
            update_replication_protected_item_provider_input,
            recovery_cloud_service_id: None,
            recovery_resource_group_id: None,
            managed_disk_update_details: Vec::new(),
            recovery_boot_diag_storage_account_id: None,
            disk_encryption_info: None,
            tfo_azure_vm_name: None,
            recovery_proximity_placement_group_id: None,
            recovery_virtual_machine_scale_set_id: None,
            recovery_capacity_reservation_group_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aVmDiskInputDetails {
    #[serde(rename = "diskUri")]
    pub disk_uri: String,
    #[serde(rename = "recoveryAzureStorageAccountId")]
    pub recovery_azure_storage_account_id: String,
    #[serde(rename = "primaryStagingAzureStorageAccountId")]
    pub primary_staging_azure_storage_account_id: String,
}
impl A2aVmDiskInputDetails {
    pub fn new(disk_uri: String, recovery_azure_storage_account_id: String, primary_staging_azure_storage_account_id: String) -> Self {
        Self {
            disk_uri,
            recovery_azure_storage_account_id,
            primary_staging_azure_storage_account_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct A2aVmManagedDiskInputDetails {
    #[serde(rename = "diskId")]
    pub disk_id: String,
    #[serde(rename = "primaryStagingAzureStorageAccountId")]
    pub primary_staging_azure_storage_account_id: String,
    #[serde(rename = "recoveryResourceGroupId")]
    pub recovery_resource_group_id: String,
    #[serde(rename = "recoveryReplicaDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_replica_disk_account_type: Option<String>,
    #[serde(rename = "recoveryTargetDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target_disk_account_type: Option<String>,
    #[serde(rename = "recoveryDiskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_disk_encryption_set_id: Option<String>,
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
}
impl A2aVmManagedDiskInputDetails {
    pub fn new(disk_id: String, primary_staging_azure_storage_account_id: String, recovery_resource_group_id: String) -> Self {
        Self {
            disk_id,
            primary_staging_azure_storage_account_id,
            recovery_resource_group_id,
            recovery_replica_disk_account_type: None,
            recovery_target_disk_account_type: None,
            recovery_disk_encryption_set_id: None,
            disk_encryption_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aVmManagedDiskUpdateDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "recoveryTargetDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target_disk_account_type: Option<String>,
    #[serde(rename = "recoveryReplicaDiskAccountType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_replica_disk_account_type: Option<String>,
    #[serde(rename = "diskEncryptionInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_info: Option<DiskEncryptionInfo>,
    #[serde(rename = "failoverDiskName", default, skip_serializing_if = "Option::is_none")]
    pub failover_disk_name: Option<String>,
    #[serde(rename = "tfoDiskName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_disk_name: Option<String>,
}
impl A2aVmManagedDiskUpdateDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct A2aZoneDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
}
impl A2aZoneDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AsrTask {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "allowedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_actions: Vec<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "stateDescription", default, skip_serializing_if = "Option::is_none")]
    pub state_description: Option<String>,
    #[serde(rename = "taskType", default, skip_serializing_if = "Option::is_none")]
    pub task_type: Option<String>,
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<TaskTypeDetails>,
    #[serde(rename = "groupTaskCustomDetails", default, skip_serializing_if = "Option::is_none")]
    pub group_task_custom_details: Option<GroupTaskDetails>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<JobErrorDetails>,
}
impl AsrTask {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddDisksInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AddDisksInputProperties>,
}
impl AddDisksInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AddDisksInputProperties {
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: AddDisksProviderSpecificInput,
}
impl AddDisksInputProperties {
    pub fn new(provider_specific_details: AddDisksProviderSpecificInput) -> Self {
        Self { provider_specific_details }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AddDisksProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl AddDisksProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AddRecoveryServicesProviderInput {
    pub properties: AddRecoveryServicesProviderInputProperties,
}
impl AddRecoveryServicesProviderInput {
    pub fn new(properties: AddRecoveryServicesProviderInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AddRecoveryServicesProviderInputProperties {
    #[serde(rename = "machineName")]
    pub machine_name: String,
    #[serde(rename = "machineId", default, skip_serializing_if = "Option::is_none")]
    pub machine_id: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(rename = "authenticationIdentityInput")]
    pub authentication_identity_input: IdentityProviderInput,
    #[serde(rename = "resourceAccessIdentityInput")]
    pub resource_access_identity_input: IdentityProviderInput,
    #[serde(rename = "dataPlaneAuthenticationIdentityInput", default, skip_serializing_if = "Option::is_none")]
    pub data_plane_authentication_identity_input: Option<IdentityProviderInput>,
}
impl AddRecoveryServicesProviderInputProperties {
    pub fn new(
        machine_name: String,
        authentication_identity_input: IdentityProviderInput,
        resource_access_identity_input: IdentityProviderInput,
    ) -> Self {
        Self {
            machine_name,
            machine_id: None,
            bios_id: None,
            authentication_identity_input,
            resource_access_identity_input,
            data_plane_authentication_identity_input: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddVCenterRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AddVCenterRequestProperties>,
}
impl AddVCenterRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddVCenterRequestProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<String>,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
}
impl AddVCenterRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgentDetails {
    #[serde(rename = "agentId", default, skip_serializing_if = "Option::is_none")]
    pub agent_id: Option<String>,
    #[serde(rename = "machineId", default, skip_serializing_if = "Option::is_none")]
    pub machine_id: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub disks: Vec<AgentDiskDetails>,
}
impl AgentDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AgentDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "isOSDisk", default, skip_serializing_if = "Option::is_none")]
    pub is_os_disk: Option<String>,
    #[serde(rename = "capacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub capacity_in_bytes: Option<i64>,
    #[serde(rename = "lunId", default, skip_serializing_if = "Option::is_none")]
    pub lun_id: Option<i32>,
}
impl AgentDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Alert {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AlertProperties>,
}
impl Alert {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Alert>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AlertCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AlertProperties {
    #[serde(rename = "sendToOwners", default, skip_serializing_if = "Option::is_none")]
    pub send_to_owners: Option<String>,
    #[serde(rename = "customEmailAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_email_addresses: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub locale: Option<String>,
}
impl AlertProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplyRecoveryPointInput {
    pub properties: ApplyRecoveryPointInputProperties,
}
impl ApplyRecoveryPointInput {
    pub fn new(properties: ApplyRecoveryPointInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplyRecoveryPointInputProperties {
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: ApplyRecoveryPointProviderSpecificInput,
}
impl ApplyRecoveryPointInputProperties {
    pub fn new(provider_specific_details: ApplyRecoveryPointProviderSpecificInput) -> Self {
        Self {
            recovery_point_id: None,
            provider_specific_details,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplyRecoveryPointProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ApplyRecoveryPointProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AsrJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
}
impl AsrJobDetails {
    pub fn new(job_details: JobDetails) -> Self {
        Self { job_details }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutomationRunbookTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "cloudServiceName", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_name: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[serde(rename = "runbookId", default, skip_serializing_if = "Option::is_none")]
    pub runbook_id: Option<String>,
    #[serde(rename = "runbookName", default, skip_serializing_if = "Option::is_none")]
    pub runbook_name: Option<String>,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "jobOutput", default, skip_serializing_if = "Option::is_none")]
    pub job_output: Option<String>,
    #[serde(rename = "isPrimarySideScript", default, skip_serializing_if = "Option::is_none")]
    pub is_primary_side_script: Option<bool>,
}
impl AutomationRunbookTaskDetails {
    pub fn new(task_type_details: TaskTypeDetails) -> Self {
        Self {
            task_type_details,
            name: None,
            cloud_service_name: None,
            subscription_id: None,
            account_name: None,
            runbook_id: None,
            runbook_name: None,
            job_id: None,
            job_output: None,
            is_primary_side_script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFabricCreationInput {
    #[serde(flatten)]
    pub fabric_specific_creation_input: FabricSpecificCreationInput,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl AzureFabricCreationInput {
    pub fn new(fabric_specific_creation_input: FabricSpecificCreationInput) -> Self {
        Self {
            fabric_specific_creation_input,
            location: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFabricSpecificDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "containerIds", default, skip_serializing_if = "Vec::is_empty")]
    pub container_ids: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<A2aZoneDetails>,
}
impl AzureFabricSpecificDetails {
    pub fn new(fabric_specific_details: FabricSpecificDetails) -> Self {
        Self {
            fabric_specific_details,
            location: None,
            container_ids: Vec::new(),
            zones: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureToAzureCreateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_create_network_mapping_input: FabricSpecificCreateNetworkMappingInput,
    #[serde(rename = "primaryNetworkId")]
    pub primary_network_id: String,
}
impl AzureToAzureCreateNetworkMappingInput {
    pub fn new(fabric_specific_create_network_mapping_input: FabricSpecificCreateNetworkMappingInput, primary_network_id: String) -> Self {
        Self {
            fabric_specific_create_network_mapping_input,
            primary_network_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureToAzureNetworkMappingSettings {
    #[serde(flatten)]
    pub network_mapping_fabric_specific_settings: NetworkMappingFabricSpecificSettings,
    #[serde(rename = "primaryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_location: Option<String>,
    #[serde(rename = "recoveryFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_location: Option<String>,
}
impl AzureToAzureNetworkMappingSettings {
    pub fn new(network_mapping_fabric_specific_settings: NetworkMappingFabricSpecificSettings) -> Self {
        Self {
            network_mapping_fabric_specific_settings,
            primary_fabric_location: None,
            recovery_fabric_location: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureToAzureUpdateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_update_network_mapping_input: FabricSpecificUpdateNetworkMappingInput,
    #[serde(rename = "primaryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub primary_network_id: Option<String>,
}
impl AzureToAzureUpdateNetworkMappingInput {
    pub fn new(fabric_specific_update_network_mapping_input: FabricSpecificUpdateNetworkMappingInput) -> Self {
        Self {
            fabric_specific_update_network_mapping_input,
            primary_network_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureToAzureVmSyncedConfigDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(rename = "inputEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub input_endpoints: Vec<InputEndpoint>,
}
impl AzureToAzureVmSyncedConfigDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmDiskDetails {
    #[serde(rename = "vhdType", default, skip_serializing_if = "Option::is_none")]
    pub vhd_type: Option<String>,
    #[serde(rename = "vhdId", default, skip_serializing_if = "Option::is_none")]
    pub vhd_id: Option<String>,
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "vhdName", default, skip_serializing_if = "Option::is_none")]
    pub vhd_name: Option<String>,
    #[serde(rename = "maxSizeMB", default, skip_serializing_if = "Option::is_none")]
    pub max_size_mb: Option<String>,
    #[serde(rename = "targetDiskLocation", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_location: Option<String>,
    #[serde(rename = "targetDiskName", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_name: Option<String>,
    #[serde(rename = "lunId", default, skip_serializing_if = "Option::is_none")]
    pub lun_id: Option<String>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
    #[serde(rename = "customTargetDiskName", default, skip_serializing_if = "Option::is_none")]
    pub custom_target_disk_name: Option<String>,
}
impl AzureVmDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeSizeErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
}
impl ComputeSizeErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConfigurationSettings {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ConfigurationSettings {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConfigureAlertRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConfigureAlertRequestProperties>,
}
impl ConfigureAlertRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConfigureAlertRequestProperties {
    #[serde(rename = "sendToOwners", default, skip_serializing_if = "Option::is_none")]
    pub send_to_owners: Option<String>,
    #[serde(rename = "customEmailAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_email_addresses: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub locale: Option<String>,
}
impl ConfigureAlertRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsistencyCheckTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[serde(rename = "vmDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_details: Vec<InconsistentVmDetails>,
}
impl ConsistencyCheckTaskDetails {
    pub fn new(task_type_details: TaskTypeDetails) -> Self {
        Self {
            task_type_details,
            vm_details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateNetworkMappingInput {
    pub properties: CreateNetworkMappingInputProperties,
}
impl CreateNetworkMappingInput {
    pub fn new(properties: CreateNetworkMappingInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateNetworkMappingInputProperties {
    #[serde(rename = "recoveryFabricName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_name: Option<String>,
    #[serde(rename = "recoveryNetworkId")]
    pub recovery_network_id: String,
    #[serde(rename = "fabricSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub fabric_specific_details: Option<FabricSpecificCreateNetworkMappingInput>,
}
impl CreateNetworkMappingInputProperties {
    pub fn new(recovery_network_id: String) -> Self {
        Self {
            recovery_fabric_name: None,
            recovery_network_id,
            fabric_specific_details: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreatePolicyInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreatePolicyInputProperties>,
}
impl CreatePolicyInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreatePolicyInputProperties {
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_input: Option<PolicyProviderSpecificInput>,
}
impl CreatePolicyInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionContainerInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreateProtectionContainerInputProperties>,
}
impl CreateProtectionContainerInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionContainerInputProperties {
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_input: Vec<ReplicationProviderSpecificContainerCreationInput>,
}
impl CreateProtectionContainerInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionContainerMappingInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreateProtectionContainerMappingInputProperties>,
}
impl CreateProtectionContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionContainerMappingInputProperties {
    #[serde(rename = "targetProtectionContainerId", default, skip_serializing_if = "Option::is_none")]
    pub target_protection_container_id: Option<String>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_input: Option<ReplicationProviderSpecificContainerMappingInput>,
}
impl CreateProtectionContainerMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionIntentInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CreateProtectionIntentProperties>,
}
impl CreateProtectionIntentInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateProtectionIntentProperties {
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<CreateProtectionIntentProviderSpecificDetails>,
}
impl CreateProtectionIntentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateProtectionIntentProviderSpecificDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl CreateProtectionIntentProviderSpecificDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateRecoveryPlanInput {
    pub properties: CreateRecoveryPlanInputProperties,
}
impl CreateRecoveryPlanInput {
    pub fn new(properties: CreateRecoveryPlanInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateRecoveryPlanInputProperties {
    #[serde(rename = "primaryFabricId")]
    pub primary_fabric_id: String,
    #[serde(rename = "recoveryFabricId")]
    pub recovery_fabric_id: String,
    #[serde(rename = "failoverDeploymentModel", default, skip_serializing_if = "Option::is_none")]
    pub failover_deployment_model: Option<create_recovery_plan_input_properties::FailoverDeploymentModel>,
    pub groups: Vec<RecoveryPlanGroup>,
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_input: Vec<RecoveryPlanProviderSpecificInput>,
}
impl CreateRecoveryPlanInputProperties {
    pub fn new(primary_fabric_id: String, recovery_fabric_id: String, groups: Vec<RecoveryPlanGroup>) -> Self {
        Self {
            primary_fabric_id,
            recovery_fabric_id,
            failover_deployment_model: None,
            groups,
            provider_specific_input: Vec::new(),
        }
    }
}
pub mod create_recovery_plan_input_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverDeploymentModel {
        NotApplicable,
        Classic,
        ResourceManager,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CurrentJobDetails {
    #[serde(rename = "jobName", default, skip_serializing_if = "Option::is_none")]
    pub job_name: Option<String>,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
}
impl CurrentJobDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CurrentScenarioDetails {
    #[serde(rename = "scenarioName", default, skip_serializing_if = "Option::is_none")]
    pub scenario_name: Option<String>,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
}
impl CurrentScenarioDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataStore {
    #[serde(rename = "symbolicName", default, skip_serializing_if = "Option::is_none")]
    pub symbolic_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uuid: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<String>,
    #[serde(rename = "freeSpace", default, skip_serializing_if = "Option::is_none")]
    pub free_space: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl DataStore {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DisableProtectionInput {
    pub properties: DisableProtectionInputProperties,
}
impl DisableProtectionInput {
    pub fn new(properties: DisableProtectionInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DisableProtectionInputProperties {
    #[serde(rename = "disableProtectionReason", default, skip_serializing_if = "Option::is_none")]
    pub disable_protection_reason: Option<disable_protection_input_properties::DisableProtectionReason>,
    #[serde(rename = "replicationProviderInput", default, skip_serializing_if = "Option::is_none")]
    pub replication_provider_input: Option<DisableProtectionProviderSpecificInput>,
}
impl DisableProtectionInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod disable_protection_input_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DisableProtectionReason {
        NotSpecified,
        MigrationComplete,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DisableProtectionProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl DisableProtectionProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiscoverProtectableItemRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DiscoverProtectableItemRequestProperties>,
}
impl DiscoverProtectableItemRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiscoverProtectableItemRequestProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
}
impl DiscoverProtectableItemRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskDetails {
    #[serde(rename = "maxSizeMB", default, skip_serializing_if = "Option::is_none")]
    pub max_size_mb: Option<i64>,
    #[serde(rename = "vhdType", default, skip_serializing_if = "Option::is_none")]
    pub vhd_type: Option<String>,
    #[serde(rename = "vhdId", default, skip_serializing_if = "Option::is_none")]
    pub vhd_id: Option<String>,
    #[serde(rename = "vhdName", default, skip_serializing_if = "Option::is_none")]
    pub vhd_name: Option<String>,
}
impl DiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskEncryptionInfo {
    #[serde(rename = "diskEncryptionKeyInfo", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_key_info: Option<DiskEncryptionKeyInfo>,
    #[serde(rename = "keyEncryptionKeyInfo", default, skip_serializing_if = "Option::is_none")]
    pub key_encryption_key_info: Option<KeyEncryptionKeyInfo>,
}
impl DiskEncryptionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskEncryptionKeyInfo {
    #[serde(rename = "secretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub secret_identifier: Option<String>,
    #[serde(rename = "keyVaultResourceArmId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_resource_arm_id: Option<String>,
}
impl DiskEncryptionKeyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskVolumeDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub label: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl DiskVolumeDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Display {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl Display {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DraDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<dra_details::Health>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[serde(rename = "forwardProtectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub forward_protected_item_count: Option<i32>,
    #[serde(rename = "reverseProtectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub reverse_protected_item_count: Option<i32>,
}
impl DraDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod dra_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnableMigrationInput {
    pub properties: EnableMigrationInputProperties,
}
impl EnableMigrationInput {
    pub fn new(properties: EnableMigrationInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnableMigrationInputProperties {
    #[serde(rename = "policyId")]
    pub policy_id: String,
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: EnableMigrationProviderSpecificInput,
}
impl EnableMigrationInputProperties {
    pub fn new(policy_id: String, provider_specific_details: EnableMigrationProviderSpecificInput) -> Self {
        Self {
            policy_id,
            provider_specific_details,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnableMigrationProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl EnableMigrationProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnableProtectionInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EnableProtectionInputProperties>,
}
impl EnableProtectionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EnableProtectionInputProperties {
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(rename = "protectableItemId", default, skip_serializing_if = "Option::is_none")]
    pub protectable_item_id: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<EnableProtectionProviderSpecificInput>,
}
impl EnableProtectionInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnableProtectionProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl EnableProtectionProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionDetails {
    #[serde(rename = "kekState", default, skip_serializing_if = "Option::is_none")]
    pub kek_state: Option<String>,
    #[serde(rename = "kekCertThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub kek_cert_thumbprint: Option<String>,
    #[serde(rename = "kekCertExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub kek_cert_expiry_date: Option<String>,
}
impl EncryptionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Event {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<EventProperties>,
}
impl Event {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Event>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EventCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventProperties {
    #[serde(rename = "eventCode", default, skip_serializing_if = "Option::is_none")]
    pub event_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[serde(rename = "affectedObjectFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_friendly_name: Option<String>,
    #[serde(rename = "affectedObjectCorrelationId", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_correlation_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
    #[serde(rename = "timeOfOccurrence", default, skip_serializing_if = "Option::is_none")]
    pub time_of_occurrence: Option<String>,
    #[serde(rename = "fabricId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_id: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<EventProviderSpecificDetails>,
    #[serde(rename = "eventSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub event_specific_details: Option<EventSpecificDetails>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
}
impl EventProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventProviderSpecificDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl EventProviderSpecificDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventQueryParameter {
    #[serde(rename = "eventCode", default, skip_serializing_if = "Option::is_none")]
    pub event_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<String>,
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "affectedObjectFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_friendly_name: Option<String>,
    #[serde(rename = "affectedObjectCorrelationId", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_correlation_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl EventQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventSpecificDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl EventSpecificDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExistingProtectionProfile {
    #[serde(flatten)]
    pub protection_profile_custom_details: ProtectionProfileCustomDetails,
    #[serde(rename = "protectionProfileId")]
    pub protection_profile_id: String,
}
impl ExistingProtectionProfile {
    pub fn new(protection_profile_custom_details: ProtectionProfileCustomDetails, protection_profile_id: String) -> Self {
        Self {
            protection_profile_custom_details,
            protection_profile_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExistingRecoveryAvailabilitySet {
    #[serde(flatten)]
    pub recovery_availability_set_custom_details: RecoveryAvailabilitySetCustomDetails,
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
}
impl ExistingRecoveryAvailabilitySet {
    pub fn new(recovery_availability_set_custom_details: RecoveryAvailabilitySetCustomDetails) -> Self {
        Self {
            recovery_availability_set_custom_details,
            recovery_availability_set_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExistingRecoveryProximityPlacementGroup {
    #[serde(flatten)]
    pub recovery_proximity_placement_group_custom_details: RecoveryProximityPlacementGroupCustomDetails,
    #[serde(rename = "recoveryProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_proximity_placement_group_id: Option<String>,
}
impl ExistingRecoveryProximityPlacementGroup {
    pub fn new(recovery_proximity_placement_group_custom_details: RecoveryProximityPlacementGroupCustomDetails) -> Self {
        Self {
            recovery_proximity_placement_group_custom_details,
            recovery_proximity_placement_group_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExistingRecoveryRecoveryResourceGroup {
    #[serde(flatten)]
    pub recovery_resource_group_custom_details: RecoveryResourceGroupCustomDetails,
    #[serde(rename = "recoveryResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_resource_group_id: Option<String>,
}
impl ExistingRecoveryRecoveryResourceGroup {
    pub fn new(recovery_resource_group_custom_details: RecoveryResourceGroupCustomDetails) -> Self {
        Self {
            recovery_resource_group_custom_details,
            recovery_resource_group_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExistingRecoveryVirtualNetwork {
    #[serde(flatten)]
    pub recovery_virtual_network_custom_details: RecoveryVirtualNetworkCustomDetails,
    #[serde(rename = "recoveryVirtualNetworkId")]
    pub recovery_virtual_network_id: String,
    #[serde(rename = "recoverySubnetName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_subnet_name: Option<String>,
}
impl ExistingRecoveryVirtualNetwork {
    pub fn new(recovery_virtual_network_custom_details: RecoveryVirtualNetworkCustomDetails, recovery_virtual_network_id: String) -> Self {
        Self {
            recovery_virtual_network_custom_details,
            recovery_virtual_network_id,
            recovery_subnet_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExistingStorageAccount {
    #[serde(flatten)]
    pub storage_account_custom_details: StorageAccountCustomDetails,
    #[serde(rename = "azureStorageAccountId")]
    pub azure_storage_account_id: String,
}
impl ExistingStorageAccount {
    pub fn new(storage_account_custom_details: StorageAccountCustomDetails, azure_storage_account_id: String) -> Self {
        Self {
            storage_account_custom_details,
            azure_storage_account_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
    #[serde(rename = "blobUri", default, skip_serializing_if = "Option::is_none")]
    pub blob_uri: Option<String>,
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<String>,
}
impl ExportJobDetails {
    pub fn new(job_details: JobDetails) -> Self {
        Self {
            job_details,
            blob_uri: None,
            sas_token: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Fabric {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FabricProperties>,
}
impl Fabric {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Fabric>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FabricCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricCreationInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FabricCreationInputProperties>,
}
impl FabricCreationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricCreationInputProperties {
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<FabricSpecificCreationInput>,
}
impl FabricCreationInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "encryptionDetails", default, skip_serializing_if = "Option::is_none")]
    pub encryption_details: Option<EncryptionDetails>,
    #[serde(rename = "rolloverEncryptionDetails", default, skip_serializing_if = "Option::is_none")]
    pub rollover_encryption_details: Option<EncryptionDetails>,
    #[serde(rename = "internalIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub internal_identifier: Option<String>,
    #[serde(rename = "bcdrState", default, skip_serializing_if = "Option::is_none")]
    pub bcdr_state: Option<String>,
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<FabricSpecificDetails>,
    #[serde(rename = "healthErrorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub health_error_details: Vec<HealthError>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<String>,
}
impl FabricProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FabricQueryParameter {
    #[serde(rename = "zoneToZoneMappings", default, skip_serializing_if = "Option::is_none")]
    pub zone_to_zone_mappings: Option<String>,
    #[serde(rename = "fetchAgentDetails", default, skip_serializing_if = "Option::is_none")]
    pub fetch_agent_details: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "discoveryType", default, skip_serializing_if = "Option::is_none")]
    pub discovery_type: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
}
impl FabricQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FabricReplicationGroupTaskDetails {
    #[serde(flatten)]
    pub job_task_details: JobTaskDetails,
    #[serde(rename = "skippedReason", default, skip_serializing_if = "Option::is_none")]
    pub skipped_reason: Option<String>,
    #[serde(rename = "skippedReasonString", default, skip_serializing_if = "Option::is_none")]
    pub skipped_reason_string: Option<String>,
}
impl FabricReplicationGroupTaskDetails {
    pub fn new(job_task_details: JobTaskDetails) -> Self {
        Self {
            job_task_details,
            skipped_reason: None,
            skipped_reason_string: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FabricSpecificCreateNetworkMappingInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl FabricSpecificCreateNetworkMappingInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FabricSpecificCreationInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl FabricSpecificCreationInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FabricSpecificDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl FabricSpecificDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FabricSpecificUpdateNetworkMappingInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl FabricSpecificUpdateNetworkMappingInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FailoverJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
    #[serde(rename = "protectedItemDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_item_details: Vec<FailoverReplicationProtectedItemDetails>,
}
impl FailoverJobDetails {
    pub fn new(job_details: JobDetails) -> Self {
        Self {
            job_details,
            protected_item_details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverProcessServerRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FailoverProcessServerRequestProperties>,
}
impl FailoverProcessServerRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverProcessServerRequestProperties {
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "sourceProcessServerId", default, skip_serializing_if = "Option::is_none")]
    pub source_process_server_id: Option<String>,
    #[serde(rename = "targetProcessServerId", default, skip_serializing_if = "Option::is_none")]
    pub target_process_server_id: Option<String>,
    #[serde(rename = "vmsToMigrate", default, skip_serializing_if = "Vec::is_empty")]
    pub vms_to_migrate: Vec<String>,
    #[serde(rename = "updateType", default, skip_serializing_if = "Option::is_none")]
    pub update_type: Option<String>,
}
impl FailoverProcessServerRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FailoverReplicationProtectedItemDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "testVmName", default, skip_serializing_if = "Option::is_none")]
    pub test_vm_name: Option<String>,
    #[serde(rename = "testVmFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub test_vm_friendly_name: Option<String>,
    #[serde(rename = "networkConnectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub network_connection_status: Option<String>,
    #[serde(rename = "networkFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub network_friendly_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<String>,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
}
impl FailoverReplicationProtectedItemDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GroupTaskDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
    #[serde(rename = "childTasks", default, skip_serializing_if = "Vec::is_empty")]
    pub child_tasks: Vec<AsrTask>,
}
impl GroupTaskDetails {
    pub fn new(instance_type: String) -> Self {
        Self {
            instance_type,
            child_tasks: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HealthError {
    #[serde(rename = "innerHealthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub inner_health_errors: Vec<InnerHealthError>,
    #[serde(rename = "errorSource", default, skip_serializing_if = "Option::is_none")]
    pub error_source: Option<String>,
    #[serde(rename = "errorType", default, skip_serializing_if = "Option::is_none")]
    pub error_type: Option<String>,
    #[serde(rename = "errorLevel", default, skip_serializing_if = "Option::is_none")]
    pub error_level: Option<String>,
    #[serde(rename = "errorCategory", default, skip_serializing_if = "Option::is_none")]
    pub error_category: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(rename = "summaryMessage", default, skip_serializing_if = "Option::is_none")]
    pub summary_message: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
    #[serde(rename = "creationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub creation_time_utc: Option<String>,
    #[serde(rename = "recoveryProviderErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub recovery_provider_error_message: Option<String>,
    #[serde(rename = "entityId", default, skip_serializing_if = "Option::is_none")]
    pub entity_id: Option<String>,
    #[serde(rename = "errorId", default, skip_serializing_if = "Option::is_none")]
    pub error_id: Option<String>,
    #[serde(rename = "customerResolvability", default, skip_serializing_if = "Option::is_none")]
    pub customer_resolvability: Option<health_error::CustomerResolvability>,
}
impl HealthError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod health_error {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CustomerResolvability {
        Allowed,
        NotAllowed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HealthErrorSummary {
    #[serde(rename = "summaryCode", default, skip_serializing_if = "Option::is_none")]
    pub summary_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<health_error_summary::Category>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<health_error_summary::Severity>,
    #[serde(rename = "summaryMessage", default, skip_serializing_if = "Option::is_none")]
    pub summary_message: Option<String>,
    #[serde(rename = "affectedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub affected_resource_type: Option<String>,
    #[serde(rename = "affectedResourceSubtype", default, skip_serializing_if = "Option::is_none")]
    pub affected_resource_subtype: Option<String>,
    #[serde(rename = "affectedResourceCorrelationIds", default, skip_serializing_if = "Vec::is_empty")]
    pub affected_resource_correlation_ids: Vec<String>,
}
impl HealthErrorSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod health_error_summary {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Category {
        None,
        Replication,
        TestFailover,
        Configuration,
        FabricInfrastructure,
        VersionExpiry,
        AgentAutoUpdateInfra,
        AgentAutoUpdateArtifactDeleted,
        AgentAutoUpdateRunAsAccount,
        AgentAutoUpdateRunAsAccountExpiry,
        AgentAutoUpdateRunAsAccountExpired,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        #[serde(rename = "NONE")]
        None,
        Warning,
        Error,
        Info,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVHostDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "marsAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub mars_agent_version: Option<String>,
}
impl HyperVHostDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplica2012EventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "remoteContainerName", default, skip_serializing_if = "Option::is_none")]
    pub remote_container_name: Option<String>,
    #[serde(rename = "remoteFabricName", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_name: Option<String>,
}
impl HyperVReplica2012EventDetails {
    pub fn new(event_provider_specific_details: EventProviderSpecificDetails) -> Self {
        Self {
            event_provider_specific_details,
            container_name: None,
            fabric_name: None,
            remote_container_name: None,
            remote_fabric_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplica2012R2EventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "remoteContainerName", default, skip_serializing_if = "Option::is_none")]
    pub remote_container_name: Option<String>,
    #[serde(rename = "remoteFabricName", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_name: Option<String>,
}
impl HyperVReplica2012R2EventDetails {
    pub fn new(event_provider_specific_details: EventProviderSpecificDetails) -> Self {
        Self {
            event_provider_specific_details,
            container_name: None,
            fabric_name: None,
            remote_container_name: None,
            remote_fabric_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzureApplyRecoveryPointInput {
    #[serde(flatten)]
    pub apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput,
    #[serde(rename = "primaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub primary_kek_certificate_pfx: Option<String>,
    #[serde(rename = "secondaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub secondary_kek_certificate_pfx: Option<String>,
}
impl HyperVReplicaAzureApplyRecoveryPointInput {
    pub fn new(apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput) -> Self {
        Self {
            apply_recovery_point_provider_specific_input,
            primary_kek_certificate_pfx: None,
            secondary_kek_certificate_pfx: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureDiskInputDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<hyper_v_replica_azure_disk_input_details::DiskType>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
}
impl HyperVReplicaAzureDiskInputDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hyper_v_replica_azure_disk_input_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzureEnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[serde(rename = "hvHostVmId", default, skip_serializing_if = "Option::is_none")]
    pub hv_host_vm_id: Option<String>,
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "vhdId", default, skip_serializing_if = "Option::is_none")]
    pub vhd_id: Option<String>,
    #[serde(rename = "targetStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_storage_account_id: Option<String>,
    #[serde(rename = "targetAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_network_id: Option<String>,
    #[serde(rename = "targetAzureSubnetId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_subnet_id: Option<String>,
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[serde(rename = "targetAzureVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_vm_name: Option<String>,
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<String>,
    #[serde(rename = "targetAzureV1ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_v1_resource_group_id: Option<String>,
    #[serde(rename = "targetAzureV2ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_v2_resource_group_id: Option<String>,
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<hyper_v_replica_azure_enable_protection_input::LicenseType>,
    #[serde(rename = "sqlServerLicenseType", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_license_type: Option<hyper_v_replica_azure_enable_protection_input::SqlServerLicenseType>,
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "useManagedDisksForReplication", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks_for_replication: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<hyper_v_replica_azure_enable_protection_input::DiskType>,
    #[serde(rename = "disksToIncludeForManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include_for_managed_disks: Vec<HyperVReplicaAzureDiskInputDetails>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
    #[serde(rename = "targetVmTags", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_tags: Option<serde_json::Value>,
    #[serde(rename = "seedManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub seed_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub target_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetNicTags", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_tags: Option<serde_json::Value>,
}
impl HyperVReplicaAzureEnableProtectionInput {
    pub fn new(enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput) -> Self {
        Self {
            enable_protection_provider_specific_input,
            hv_host_vm_id: None,
            vm_name: None,
            os_type: None,
            vhd_id: None,
            target_storage_account_id: None,
            target_azure_network_id: None,
            target_azure_subnet_id: None,
            enable_rdp_on_target_option: None,
            target_azure_vm_name: None,
            log_storage_account_id: None,
            disks_to_include: Vec::new(),
            target_azure_v1_resource_group_id: None,
            target_azure_v2_resource_group_id: None,
            use_managed_disks: None,
            target_availability_set_id: None,
            target_availability_zone: None,
            license_type: None,
            sql_server_license_type: None,
            target_vm_size: None,
            target_proximity_placement_group_id: None,
            use_managed_disks_for_replication: None,
            disk_type: None,
            disks_to_include_for_managed_disks: Vec::new(),
            disk_encryption_set_id: None,
            target_vm_tags: None,
            seed_managed_disk_tags: None,
            target_managed_disk_tags: None,
            target_nic_tags: None,
        }
    }
}
pub mod hyper_v_replica_azure_enable_protection_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SqlServerLicenseType {
        NotSpecified,
        NoLicenseType,
        #[serde(rename = "PAYG")]
        Payg,
        #[serde(rename = "AHUB")]
        Ahub,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzureEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "remoteContainerName", default, skip_serializing_if = "Option::is_none")]
    pub remote_container_name: Option<String>,
}
impl HyperVReplicaAzureEventDetails {
    pub fn new(event_provider_specific_details: EventProviderSpecificDetails) -> Self {
        Self {
            event_provider_specific_details,
            container_name: None,
            fabric_name: None,
            remote_container_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzureFailbackProviderInput {
    #[serde(flatten)]
    pub planned_failover_provider_specific_failover_input: PlannedFailoverProviderSpecificFailoverInput,
    #[serde(rename = "dataSyncOption", default, skip_serializing_if = "Option::is_none")]
    pub data_sync_option: Option<String>,
    #[serde(rename = "recoveryVmCreationOption", default, skip_serializing_if = "Option::is_none")]
    pub recovery_vm_creation_option: Option<String>,
    #[serde(rename = "providerIdForAlternateRecovery", default, skip_serializing_if = "Option::is_none")]
    pub provider_id_for_alternate_recovery: Option<String>,
}
impl HyperVReplicaAzureFailbackProviderInput {
    pub fn new(planned_failover_provider_specific_failover_input: PlannedFailoverProviderSpecificFailoverInput) -> Self {
        Self {
            planned_failover_provider_specific_failover_input,
            data_sync_option: None,
            recovery_vm_creation_option: None,
            provider_id_for_alternate_recovery: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HyperVReplicaAzureManagedDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "seedManagedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub seed_managed_disk_id: Option<String>,
    #[serde(rename = "replicaDiskType", default, skip_serializing_if = "Option::is_none")]
    pub replica_disk_type: Option<String>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
}
impl HyperVReplicaAzureManagedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzurePlannedFailoverProviderInput {
    #[serde(flatten)]
    pub planned_failover_provider_specific_failover_input: PlannedFailoverProviderSpecificFailoverInput,
    #[serde(rename = "primaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub primary_kek_certificate_pfx: Option<String>,
    #[serde(rename = "secondaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub secondary_kek_certificate_pfx: Option<String>,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl HyperVReplicaAzurePlannedFailoverProviderInput {
    pub fn new(planned_failover_provider_specific_failover_input: PlannedFailoverProviderSpecificFailoverInput) -> Self {
        Self {
            planned_failover_provider_specific_failover_input,
            primary_kek_certificate_pfx: None,
            secondary_kek_certificate_pfx: None,
            recovery_point_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzurePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "recoveryPointHistoryDurationInHours", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_duration_in_hours: Option<i32>,
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[serde(rename = "replicationInterval", default, skip_serializing_if = "Option::is_none")]
    pub replication_interval: Option<i32>,
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<String>,
    #[serde(rename = "activeStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub active_storage_account_id: Option<String>,
}
impl HyperVReplicaAzurePolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            recovery_point_history_duration_in_hours: None,
            application_consistent_snapshot_frequency_in_hours: None,
            replication_interval: None,
            online_replication_start_time: None,
            encryption: None,
            active_storage_account_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzurePolicyInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[serde(rename = "recoveryPointHistoryDuration", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_duration: Option<i32>,
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[serde(rename = "replicationInterval", default, skip_serializing_if = "Option::is_none")]
    pub replication_interval: Option<i32>,
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[serde(rename = "storageAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_accounts: Vec<String>,
}
impl HyperVReplicaAzurePolicyInput {
    pub fn new(policy_provider_specific_input: PolicyProviderSpecificInput) -> Self {
        Self {
            policy_provider_specific_input,
            recovery_point_history_duration: None,
            application_consistent_snapshot_frequency_in_hours: None,
            replication_interval: None,
            online_replication_start_time: None,
            storage_accounts: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzureReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "azureVmDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_vm_disk_details: Vec<AzureVmDiskDetails>,
    #[serde(rename = "recoveryAzureVmName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_name: Option<String>,
    #[serde(rename = "recoveryAzureVMSize", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_size: Option<String>,
    #[serde(rename = "recoveryAzureStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_storage_account: Option<String>,
    #[serde(rename = "recoveryAzureLogStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_log_storage_account_id: Option<String>,
    #[serde(rename = "lastReplicatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_replicated_time: Option<String>,
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[serde(rename = "initialReplicationDetails", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_details: Option<InitialReplicationDetails>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[serde(rename = "selectedRecoveryAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_recovery_azure_network_id: Option<String>,
    #[serde(rename = "selectedSourceNicId", default, skip_serializing_if = "Option::is_none")]
    pub selected_source_nic_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<String>,
    #[serde(rename = "oSDetails", default, skip_serializing_if = "Option::is_none")]
    pub o_s_details: Option<OsDetails>,
    #[serde(rename = "sourceVmRamSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_ram_size_in_mb: Option<i32>,
    #[serde(rename = "sourceVmCpuCount", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_cpu_count: Option<i32>,
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[serde(rename = "recoveryAzureResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_resource_group_id: Option<String>,
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "sqlServerLicenseType", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_license_type: Option<String>,
    #[serde(rename = "lastRecoveryPointReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point_received: Option<String>,
    #[serde(rename = "targetVmTags", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_tags: Option<serde_json::Value>,
    #[serde(rename = "seedManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub seed_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub target_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetNicTags", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_tags: Option<serde_json::Value>,
    #[serde(rename = "protectedManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_managed_disks: Vec<HyperVReplicaAzureManagedDiskDetails>,
}
impl HyperVReplicaAzureReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            azure_vm_disk_details: Vec::new(),
            recovery_azure_vm_name: None,
            recovery_azure_vm_size: None,
            recovery_azure_storage_account: None,
            recovery_azure_log_storage_account_id: None,
            last_replicated_time: None,
            rpo_in_seconds: None,
            last_rpo_calculated_time: None,
            vm_id: None,
            vm_protection_state: None,
            vm_protection_state_description: None,
            initial_replication_details: None,
            vm_nics: Vec::new(),
            selected_recovery_azure_network_id: None,
            selected_source_nic_id: None,
            encryption: None,
            o_s_details: None,
            source_vm_ram_size_in_mb: None,
            source_vm_cpu_count: None,
            enable_rdp_on_target_option: None,
            recovery_azure_resource_group_id: None,
            recovery_availability_set_id: None,
            target_availability_zone: None,
            target_proximity_placement_group_id: None,
            use_managed_disks: None,
            license_type: None,
            sql_server_license_type: None,
            last_recovery_point_received: None,
            target_vm_tags: None,
            seed_managed_disk_tags: None,
            target_managed_disk_tags: None,
            target_nic_tags: None,
            protected_managed_disks: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzureReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[serde(rename = "hvHostVmId", default, skip_serializing_if = "Option::is_none")]
    pub hv_host_vm_id: Option<String>,
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "vHDId", default, skip_serializing_if = "Option::is_none")]
    pub v_hd_id: Option<String>,
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
}
impl HyperVReplicaAzureReprotectInput {
    pub fn new(reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput) -> Self {
        Self {
            reverse_replication_provider_specific_input,
            hv_host_vm_id: None,
            vm_name: None,
            os_type: None,
            v_hd_id: None,
            storage_account_id: None,
            log_storage_account_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzureTestFailoverInput {
    #[serde(flatten)]
    pub test_failover_provider_specific_input: TestFailoverProviderSpecificInput,
    #[serde(rename = "primaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub primary_kek_certificate_pfx: Option<String>,
    #[serde(rename = "secondaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub secondary_kek_certificate_pfx: Option<String>,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl HyperVReplicaAzureTestFailoverInput {
    pub fn new(test_failover_provider_specific_input: TestFailoverProviderSpecificInput) -> Self {
        Self {
            test_failover_provider_specific_input,
            primary_kek_certificate_pfx: None,
            secondary_kek_certificate_pfx: None,
            recovery_point_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzureUnplannedFailoverInput {
    #[serde(flatten)]
    pub unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput,
    #[serde(rename = "primaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub primary_kek_certificate_pfx: Option<String>,
    #[serde(rename = "secondaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub secondary_kek_certificate_pfx: Option<String>,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl HyperVReplicaAzureUnplannedFailoverInput {
    pub fn new(unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput) -> Self {
        Self {
            unplanned_failover_provider_specific_input,
            primary_kek_certificate_pfx: None,
            secondary_kek_certificate_pfx: None,
            recovery_point_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaAzureUpdateReplicationProtectedItemInput {
    #[serde(flatten)]
    pub update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput,
    #[serde(rename = "recoveryAzureV1ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_v1_resource_group_id: Option<String>,
    #[serde(rename = "recoveryAzureV2ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_v2_resource_group_id: Option<String>,
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
    #[serde(rename = "diskIdToDiskEncryptionMap", default, skip_serializing_if = "Option::is_none")]
    pub disk_id_to_disk_encryption_map: Option<serde_json::Value>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetVmTags", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_tags: Option<serde_json::Value>,
    #[serde(rename = "targetManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub target_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetNicTags", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_tags: Option<serde_json::Value>,
    #[serde(rename = "sqlServerLicenseType", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_license_type: Option<hyper_v_replica_azure_update_replication_protected_item_input::SqlServerLicenseType>,
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<UpdateDiskInput>,
}
impl HyperVReplicaAzureUpdateReplicationProtectedItemInput {
    pub fn new(update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput) -> Self {
        Self {
            update_replication_protected_item_provider_input,
            recovery_azure_v1_resource_group_id: None,
            recovery_azure_v2_resource_group_id: None,
            use_managed_disks: None,
            disk_id_to_disk_encryption_map: None,
            target_proximity_placement_group_id: None,
            target_availability_zone: None,
            target_vm_tags: None,
            target_managed_disk_tags: None,
            target_nic_tags: None,
            sql_server_license_type: None,
            vm_disks: Vec::new(),
        }
    }
}
pub mod hyper_v_replica_azure_update_replication_protected_item_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SqlServerLicenseType {
        NotSpecified,
        NoLicenseType,
        #[serde(rename = "PAYG")]
        Payg,
        #[serde(rename = "AHUB")]
        Ahub,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaBaseEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "remoteContainerName", default, skip_serializing_if = "Option::is_none")]
    pub remote_container_name: Option<String>,
    #[serde(rename = "remoteFabricName", default, skip_serializing_if = "Option::is_none")]
    pub remote_fabric_name: Option<String>,
}
impl HyperVReplicaBaseEventDetails {
    pub fn new(event_provider_specific_details: EventProviderSpecificDetails) -> Self {
        Self {
            event_provider_specific_details,
            container_name: None,
            fabric_name: None,
            remote_container_name: None,
            remote_fabric_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaBasePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "recoveryPoints", default, skip_serializing_if = "Option::is_none")]
    pub recovery_points: Option<i32>,
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<String>,
    #[serde(rename = "initialReplicationMethod", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_method: Option<String>,
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[serde(rename = "offlineReplicationImportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_import_path: Option<String>,
    #[serde(rename = "offlineReplicationExportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_export_path: Option<String>,
    #[serde(rename = "replicationPort", default, skip_serializing_if = "Option::is_none")]
    pub replication_port: Option<i32>,
    #[serde(rename = "allowedAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub allowed_authentication_type: Option<i32>,
    #[serde(rename = "replicaDeletionOption", default, skip_serializing_if = "Option::is_none")]
    pub replica_deletion_option: Option<String>,
}
impl HyperVReplicaBasePolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            recovery_points: None,
            application_consistent_snapshot_frequency_in_hours: None,
            compression: None,
            initial_replication_method: None,
            online_replication_start_time: None,
            offline_replication_import_path: None,
            offline_replication_export_path: None,
            replication_port: None,
            allowed_authentication_type: None,
            replica_deletion_option: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaBaseReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "lastReplicatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_replicated_time: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[serde(rename = "initialReplicationDetails", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_details: Option<InitialReplicationDetails>,
    #[serde(rename = "vMDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub v_m_disk_details: Vec<DiskDetails>,
}
impl HyperVReplicaBaseReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            last_replicated_time: None,
            vm_nics: Vec::new(),
            vm_id: None,
            vm_protection_state: None,
            vm_protection_state_description: None,
            initial_replication_details: None,
            v_m_disk_details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaBluePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "replicationFrequencyInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub replication_frequency_in_seconds: Option<i32>,
    #[serde(rename = "recoveryPoints", default, skip_serializing_if = "Option::is_none")]
    pub recovery_points: Option<i32>,
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<String>,
    #[serde(rename = "initialReplicationMethod", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_method: Option<String>,
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[serde(rename = "offlineReplicationImportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_import_path: Option<String>,
    #[serde(rename = "offlineReplicationExportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_export_path: Option<String>,
    #[serde(rename = "replicationPort", default, skip_serializing_if = "Option::is_none")]
    pub replication_port: Option<i32>,
    #[serde(rename = "allowedAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub allowed_authentication_type: Option<i32>,
    #[serde(rename = "replicaDeletionOption", default, skip_serializing_if = "Option::is_none")]
    pub replica_deletion_option: Option<String>,
}
impl HyperVReplicaBluePolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            replication_frequency_in_seconds: None,
            recovery_points: None,
            application_consistent_snapshot_frequency_in_hours: None,
            compression: None,
            initial_replication_method: None,
            online_replication_start_time: None,
            offline_replication_import_path: None,
            offline_replication_export_path: None,
            replication_port: None,
            allowed_authentication_type: None,
            replica_deletion_option: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaBluePolicyInput {
    #[serde(flatten)]
    pub hyper_v_replica_policy_input: HyperVReplicaPolicyInput,
    #[serde(rename = "replicationFrequencyInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub replication_frequency_in_seconds: Option<i32>,
}
impl HyperVReplicaBluePolicyInput {
    pub fn new(hyper_v_replica_policy_input: HyperVReplicaPolicyInput) -> Self {
        Self {
            hyper_v_replica_policy_input,
            replication_frequency_in_seconds: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaBlueReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "lastReplicatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_replicated_time: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[serde(rename = "initialReplicationDetails", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_details: Option<InitialReplicationDetails>,
    #[serde(rename = "vMDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub v_m_disk_details: Vec<DiskDetails>,
}
impl HyperVReplicaBlueReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            last_replicated_time: None,
            vm_nics: Vec::new(),
            vm_id: None,
            vm_protection_state: None,
            vm_protection_state_description: None,
            initial_replication_details: None,
            v_m_disk_details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaPolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "recoveryPoints", default, skip_serializing_if = "Option::is_none")]
    pub recovery_points: Option<i32>,
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<String>,
    #[serde(rename = "initialReplicationMethod", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_method: Option<String>,
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[serde(rename = "offlineReplicationImportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_import_path: Option<String>,
    #[serde(rename = "offlineReplicationExportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_export_path: Option<String>,
    #[serde(rename = "replicationPort", default, skip_serializing_if = "Option::is_none")]
    pub replication_port: Option<i32>,
    #[serde(rename = "allowedAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub allowed_authentication_type: Option<i32>,
    #[serde(rename = "replicaDeletionOption", default, skip_serializing_if = "Option::is_none")]
    pub replica_deletion_option: Option<String>,
}
impl HyperVReplicaPolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            recovery_points: None,
            application_consistent_snapshot_frequency_in_hours: None,
            compression: None,
            initial_replication_method: None,
            online_replication_start_time: None,
            offline_replication_import_path: None,
            offline_replication_export_path: None,
            replication_port: None,
            allowed_authentication_type: None,
            replica_deletion_option: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaPolicyInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[serde(rename = "recoveryPoints", default, skip_serializing_if = "Option::is_none")]
    pub recovery_points: Option<i32>,
    #[serde(
        rename = "applicationConsistentSnapshotFrequencyInHours",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub application_consistent_snapshot_frequency_in_hours: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<String>,
    #[serde(rename = "initialReplicationMethod", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_method: Option<String>,
    #[serde(rename = "onlineReplicationStartTime", default, skip_serializing_if = "Option::is_none")]
    pub online_replication_start_time: Option<String>,
    #[serde(rename = "offlineReplicationImportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_import_path: Option<String>,
    #[serde(rename = "offlineReplicationExportPath", default, skip_serializing_if = "Option::is_none")]
    pub offline_replication_export_path: Option<String>,
    #[serde(rename = "replicationPort", default, skip_serializing_if = "Option::is_none")]
    pub replication_port: Option<i32>,
    #[serde(rename = "allowedAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub allowed_authentication_type: Option<i32>,
    #[serde(rename = "replicaDeletion", default, skip_serializing_if = "Option::is_none")]
    pub replica_deletion: Option<String>,
}
impl HyperVReplicaPolicyInput {
    pub fn new(policy_provider_specific_input: PolicyProviderSpecificInput) -> Self {
        Self {
            policy_provider_specific_input,
            recovery_points: None,
            application_consistent_snapshot_frequency_in_hours: None,
            compression: None,
            initial_replication_method: None,
            online_replication_start_time: None,
            offline_replication_import_path: None,
            offline_replication_export_path: None,
            replication_port: None,
            allowed_authentication_type: None,
            replica_deletion: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVReplicaReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "lastReplicatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_replicated_time: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[serde(rename = "initialReplicationDetails", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_details: Option<InitialReplicationDetails>,
    #[serde(rename = "vMDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub v_m_disk_details: Vec<DiskDetails>,
}
impl HyperVReplicaReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            last_replicated_time: None,
            vm_nics: Vec::new(),
            vm_id: None,
            vm_protection_state: None,
            vm_protection_state_description: None,
            initial_replication_details: None,
            v_m_disk_details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVSiteDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
    #[serde(rename = "hyperVHosts", default, skip_serializing_if = "Vec::is_empty")]
    pub hyper_v_hosts: Vec<HyperVHostDetails>,
}
impl HyperVSiteDetails {
    pub fn new(fabric_specific_details: FabricSpecificDetails) -> Self {
        Self {
            fabric_specific_details,
            hyper_v_hosts: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HyperVVirtualMachineDetails {
    #[serde(flatten)]
    pub configuration_settings: ConfigurationSettings,
    #[serde(rename = "sourceItemId", default, skip_serializing_if = "Option::is_none")]
    pub source_item_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub generation: Option<String>,
    #[serde(rename = "osDetails", default, skip_serializing_if = "Option::is_none")]
    pub os_details: Option<OsDetails>,
    #[serde(rename = "diskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_details: Vec<DiskDetails>,
    #[serde(rename = "hasPhysicalDisk", default, skip_serializing_if = "Option::is_none")]
    pub has_physical_disk: Option<hyper_v_virtual_machine_details::HasPhysicalDisk>,
    #[serde(rename = "hasFibreChannelAdapter", default, skip_serializing_if = "Option::is_none")]
    pub has_fibre_channel_adapter: Option<hyper_v_virtual_machine_details::HasFibreChannelAdapter>,
    #[serde(rename = "hasSharedVhd", default, skip_serializing_if = "Option::is_none")]
    pub has_shared_vhd: Option<hyper_v_virtual_machine_details::HasSharedVhd>,
    #[serde(rename = "hyperVHostId", default, skip_serializing_if = "Option::is_none")]
    pub hyper_v_host_id: Option<String>,
}
impl HyperVVirtualMachineDetails {
    pub fn new(configuration_settings: ConfigurationSettings) -> Self {
        Self {
            configuration_settings,
            source_item_id: None,
            generation: None,
            os_details: None,
            disk_details: Vec::new(),
            has_physical_disk: None,
            has_fibre_channel_adapter: None,
            has_shared_vhd: None,
            hyper_v_host_id: None,
        }
    }
}
pub mod hyper_v_virtual_machine_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HasPhysicalDisk {
        Unknown,
        Present,
        NotPresent,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HasFibreChannelAdapter {
        Unknown,
        Present,
        NotPresent,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HasSharedVhd {
        Unknown,
        Present,
        NotPresent,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "isPrimary", default, skip_serializing_if = "Option::is_none")]
    pub is_primary: Option<bool>,
    #[serde(rename = "subnetName", default, skip_serializing_if = "Option::is_none")]
    pub subnet_name: Option<String>,
    #[serde(rename = "staticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub static_ip_address: Option<String>,
    #[serde(rename = "ipAddressType", default, skip_serializing_if = "Option::is_none")]
    pub ip_address_type: Option<String>,
    #[serde(rename = "isSeletedForFailover", default, skip_serializing_if = "Option::is_none")]
    pub is_seleted_for_failover: Option<bool>,
    #[serde(rename = "recoverySubnetName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_subnet_name: Option<String>,
    #[serde(rename = "recoveryStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub recovery_static_ip_address: Option<String>,
    #[serde(rename = "recoveryIPAddressType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_ip_address_type: Option<String>,
    #[serde(rename = "recoveryPublicIPAddressId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_public_ip_address_id: Option<String>,
    #[serde(rename = "recoveryLBBackendAddressPoolIds", default, skip_serializing_if = "Vec::is_empty")]
    pub recovery_lb_backend_address_pool_ids: Vec<String>,
    #[serde(rename = "tfoSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_subnet_name: Option<String>,
    #[serde(rename = "tfoStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub tfo_static_ip_address: Option<String>,
    #[serde(rename = "tfoPublicIPAddressId", default, skip_serializing_if = "Option::is_none")]
    pub tfo_public_ip_address_id: Option<String>,
    #[serde(rename = "tfoLBBackendAddressPoolIds", default, skip_serializing_if = "Vec::is_empty")]
    pub tfo_lb_backend_address_pool_ids: Vec<String>,
}
impl IpConfigDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigInputDetails {
    #[serde(rename = "ipConfigName", default, skip_serializing_if = "Option::is_none")]
    pub ip_config_name: Option<String>,
    #[serde(rename = "isPrimary", default, skip_serializing_if = "Option::is_none")]
    pub is_primary: Option<bool>,
    #[serde(rename = "isSeletedForFailover", default, skip_serializing_if = "Option::is_none")]
    pub is_seleted_for_failover: Option<bool>,
    #[serde(rename = "recoverySubnetName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_subnet_name: Option<String>,
    #[serde(rename = "recoveryStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub recovery_static_ip_address: Option<String>,
    #[serde(rename = "recoveryPublicIPAddressId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_public_ip_address_id: Option<String>,
    #[serde(rename = "recoveryLBBackendAddressPoolIds", default, skip_serializing_if = "Vec::is_empty")]
    pub recovery_lb_backend_address_pool_ids: Vec<String>,
    #[serde(rename = "tfoSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_subnet_name: Option<String>,
    #[serde(rename = "tfoStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub tfo_static_ip_address: Option<String>,
    #[serde(rename = "tfoPublicIPAddressId", default, skip_serializing_if = "Option::is_none")]
    pub tfo_public_ip_address_id: Option<String>,
    #[serde(rename = "tfoLBBackendAddressPoolIds", default, skip_serializing_if = "Vec::is_empty")]
    pub tfo_lb_backend_address_pool_ids: Vec<String>,
}
impl IpConfigInputDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityProviderDetails {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "applicationId", default, skip_serializing_if = "Option::is_none")]
    pub application_id: Option<String>,
    #[serde(rename = "objectId", default, skip_serializing_if = "Option::is_none")]
    pub object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub audience: Option<String>,
    #[serde(rename = "aadAuthority", default, skip_serializing_if = "Option::is_none")]
    pub aad_authority: Option<String>,
}
impl IdentityProviderDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IdentityProviderInput {
    #[serde(rename = "tenantId")]
    pub tenant_id: String,
    #[serde(rename = "applicationId")]
    pub application_id: String,
    #[serde(rename = "objectId")]
    pub object_id: String,
    pub audience: String,
    #[serde(rename = "aadAuthority")]
    pub aad_authority: String,
}
impl IdentityProviderInput {
    pub fn new(tenant_id: String, application_id: String, object_id: String, audience: String, aad_authority: String) -> Self {
        Self {
            tenant_id,
            application_id,
            object_id,
            audience,
            aad_authority,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAgentDetails {
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "agentUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub agent_update_status: Option<String>,
    #[serde(rename = "postUpdateRebootStatus", default, skip_serializing_if = "Option::is_none")]
    pub post_update_reboot_status: Option<String>,
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
}
impl InMageAgentDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2ApplyRecoveryPointInput {
    #[serde(flatten)]
    pub apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput,
}
impl InMageAzureV2ApplyRecoveryPointInput {
    pub fn new(apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput) -> Self {
        Self {
            apply_recovery_point_provider_specific_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2DiskInputDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<in_mage_azure_v2_disk_input_details::DiskType>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
}
impl InMageAzureV2DiskInputDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod in_mage_azure_v2_disk_input_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2EnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[serde(rename = "masterTargetId", default, skip_serializing_if = "Option::is_none")]
    pub master_target_id: Option<String>,
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<InMageAzureV2DiskInputDetails>,
    #[serde(rename = "targetAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_network_id: Option<String>,
    #[serde(rename = "targetAzureSubnetId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_subnet_id: Option<String>,
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[serde(rename = "targetAzureVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_vm_name: Option<String>,
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[serde(rename = "targetAzureV1ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_v1_resource_group_id: Option<String>,
    #[serde(rename = "targetAzureV2ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_azure_v2_resource_group_id: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<in_mage_azure_v2_enable_protection_input::DiskType>,
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<in_mage_azure_v2_enable_protection_input::LicenseType>,
    #[serde(rename = "sqlServerLicenseType", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_license_type: Option<in_mage_azure_v2_enable_protection_input::SqlServerLicenseType>,
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
    #[serde(rename = "targetVmTags", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_tags: Option<serde_json::Value>,
    #[serde(rename = "seedManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub seed_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub target_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetNicTags", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_tags: Option<serde_json::Value>,
}
impl InMageAzureV2EnableProtectionInput {
    pub fn new(enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput) -> Self {
        Self {
            enable_protection_provider_specific_input,
            master_target_id: None,
            process_server_id: None,
            storage_account_id: None,
            run_as_account_id: None,
            multi_vm_group_id: None,
            multi_vm_group_name: None,
            disks_to_include: Vec::new(),
            target_azure_network_id: None,
            target_azure_subnet_id: None,
            enable_rdp_on_target_option: None,
            target_azure_vm_name: None,
            log_storage_account_id: None,
            target_azure_v1_resource_group_id: None,
            target_azure_v2_resource_group_id: None,
            disk_type: None,
            target_availability_set_id: None,
            target_availability_zone: None,
            target_proximity_placement_group_id: None,
            license_type: None,
            sql_server_license_type: None,
            target_vm_size: None,
            disk_encryption_set_id: None,
            target_vm_tags: None,
            seed_managed_disk_tags: None,
            target_managed_disk_tags: None,
            target_nic_tags: None,
        }
    }
}
pub mod in_mage_azure_v2_enable_protection_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SqlServerLicenseType {
        NotSpecified,
        NoLicenseType,
        #[serde(rename = "PAYG")]
        Payg,
        #[serde(rename = "AHUB")]
        Ahub,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2EventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[serde(rename = "eventType", default, skip_serializing_if = "Option::is_none")]
    pub event_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub component: Option<String>,
    #[serde(rename = "correctiveAction", default, skip_serializing_if = "Option::is_none")]
    pub corrective_action: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub details: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub summary: Option<String>,
    #[serde(rename = "siteName", default, skip_serializing_if = "Option::is_none")]
    pub site_name: Option<String>,
}
impl InMageAzureV2EventDetails {
    pub fn new(event_provider_specific_details: EventProviderSpecificDetails) -> Self {
        Self {
            event_provider_specific_details,
            event_type: None,
            category: None,
            component: None,
            corrective_action: None,
            details: None,
            summary: None,
            site_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2ManagedDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "seedManagedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub seed_managed_disk_id: Option<String>,
    #[serde(rename = "replicaDiskType", default, skip_serializing_if = "Option::is_none")]
    pub replica_disk_type: Option<String>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
    #[serde(rename = "targetDiskName", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_name: Option<String>,
}
impl InMageAzureV2ManagedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2PolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
}
impl InMageAzureV2PolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            crash_consistent_frequency_in_minutes: None,
            recovery_point_threshold_in_minutes: None,
            recovery_point_history: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2PolicyInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "multiVmSyncStatus")]
    pub multi_vm_sync_status: in_mage_azure_v2_policy_input::MultiVmSyncStatus,
}
impl InMageAzureV2PolicyInput {
    pub fn new(
        policy_provider_specific_input: PolicyProviderSpecificInput,
        multi_vm_sync_status: in_mage_azure_v2_policy_input::MultiVmSyncStatus,
    ) -> Self {
        Self {
            policy_provider_specific_input,
            recovery_point_threshold_in_minutes: None,
            recovery_point_history: None,
            crash_consistent_frequency_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status,
        }
    }
}
pub mod in_mage_azure_v2_policy_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncStatus {
        Enable,
        Disable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageAzureV2ProtectedDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "protectionStage", default, skip_serializing_if = "Option::is_none")]
    pub protection_stage: Option<String>,
    #[serde(rename = "healthErrorCode", default, skip_serializing_if = "Option::is_none")]
    pub health_error_code: Option<String>,
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<String>,
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[serde(rename = "resyncDurationInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub resync_duration_in_seconds: Option<i64>,
    #[serde(rename = "diskCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_capacity_in_bytes: Option<i64>,
    #[serde(rename = "fileSystemCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub file_system_capacity_in_bytes: Option<i64>,
    #[serde(rename = "sourceDataInMegaBytes", default, skip_serializing_if = "Option::is_none")]
    pub source_data_in_mega_bytes: Option<f64>,
    #[serde(rename = "psDataInMegaBytes", default, skip_serializing_if = "Option::is_none")]
    pub ps_data_in_mega_bytes: Option<f64>,
    #[serde(rename = "targetDataInMegaBytes", default, skip_serializing_if = "Option::is_none")]
    pub target_data_in_mega_bytes: Option<f64>,
    #[serde(rename = "diskResized", default, skip_serializing_if = "Option::is_none")]
    pub disk_resized: Option<String>,
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[serde(rename = "resyncProcessedBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_processed_bytes: Option<i64>,
    #[serde(rename = "resyncTotalTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_total_transferred_bytes: Option<i64>,
    #[serde(rename = "resyncLast15MinutesTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_last15_minutes_transferred_bytes: Option<i64>,
    #[serde(rename = "resyncLastDataTransferTimeUTC", default, skip_serializing_if = "Option::is_none")]
    pub resync_last_data_transfer_time_utc: Option<String>,
    #[serde(rename = "resyncStartTime", default, skip_serializing_if = "Option::is_none")]
    pub resync_start_time: Option<String>,
    #[serde(rename = "progressHealth", default, skip_serializing_if = "Option::is_none")]
    pub progress_health: Option<String>,
    #[serde(rename = "progressStatus", default, skip_serializing_if = "Option::is_none")]
    pub progress_status: Option<String>,
}
impl InMageAzureV2ProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2RecoveryPointDetails {
    #[serde(flatten)]
    pub provider_specific_recovery_point_details: ProviderSpecificRecoveryPointDetails,
    #[serde(rename = "isMultiVmSyncPoint", default, skip_serializing_if = "Option::is_none")]
    pub is_multi_vm_sync_point: Option<String>,
}
impl InMageAzureV2RecoveryPointDetails {
    pub fn new(provider_specific_recovery_point_details: ProviderSpecificRecoveryPointDetails) -> Self {
        Self {
            provider_specific_recovery_point_details,
            is_multi_vm_sync_point: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2ReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "infrastructureVmId", default, skip_serializing_if = "Option::is_none")]
    pub infrastructure_vm_id: Option<String>,
    #[serde(rename = "vCenterInfrastructureId", default, skip_serializing_if = "Option::is_none")]
    pub v_center_infrastructure_id: Option<String>,
    #[serde(rename = "protectionStage", default, skip_serializing_if = "Option::is_none")]
    pub protection_stage: Option<String>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[serde(rename = "compressedDataRateInMB", default, skip_serializing_if = "Option::is_none")]
    pub compressed_data_rate_in_mb: Option<f64>,
    #[serde(rename = "uncompressedDataRateInMB", default, skip_serializing_if = "Option::is_none")]
    pub uncompressed_data_rate_in_mb: Option<f64>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
    #[serde(rename = "isAgentUpdateRequired", default, skip_serializing_if = "Option::is_none")]
    pub is_agent_update_required: Option<String>,
    #[serde(rename = "isRebootAfterUpdateRequired", default, skip_serializing_if = "Option::is_none")]
    pub is_reboot_after_update_required: Option<String>,
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[serde(rename = "processServerName", default, skip_serializing_if = "Option::is_none")]
    pub process_server_name: Option<String>,
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<InMageAzureV2ProtectedDiskDetails>,
    #[serde(rename = "diskResized", default, skip_serializing_if = "Option::is_none")]
    pub disk_resized: Option<String>,
    #[serde(rename = "masterTargetId", default, skip_serializing_if = "Option::is_none")]
    pub master_target_id: Option<String>,
    #[serde(rename = "sourceVmCpuCount", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_cpu_count: Option<i32>,
    #[serde(rename = "sourceVmRamSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_ram_size_in_mb: Option<i32>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "vhdName", default, skip_serializing_if = "Option::is_none")]
    pub vhd_name: Option<String>,
    #[serde(rename = "osDiskId", default, skip_serializing_if = "Option::is_none")]
    pub os_disk_id: Option<String>,
    #[serde(rename = "azureVMDiskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_vm_disk_details: Vec<AzureVmDiskDetails>,
    #[serde(rename = "recoveryAzureVMName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_name: Option<String>,
    #[serde(rename = "recoveryAzureVMSize", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_size: Option<String>,
    #[serde(rename = "recoveryAzureStorageAccount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_storage_account: Option<String>,
    #[serde(rename = "recoveryAzureLogStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_log_storage_account_id: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[serde(rename = "selectedRecoveryAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_recovery_azure_network_id: Option<String>,
    #[serde(rename = "selectedTfoAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_tfo_azure_network_id: Option<String>,
    #[serde(rename = "selectedSourceNicId", default, skip_serializing_if = "Option::is_none")]
    pub selected_source_nic_id: Option<String>,
    #[serde(rename = "discoveryType", default, skip_serializing_if = "Option::is_none")]
    pub discovery_type: Option<String>,
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datastores: Vec<String>,
    #[serde(rename = "targetVmId", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_id: Option<String>,
    #[serde(rename = "recoveryAzureResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_resource_group_id: Option<String>,
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "sqlServerLicenseType", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_license_type: Option<String>,
    #[serde(rename = "validationErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_errors: Vec<HealthError>,
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[serde(rename = "lastUpdateReceivedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_update_received_time: Option<String>,
    #[serde(rename = "replicaId", default, skip_serializing_if = "Option::is_none")]
    pub replica_id: Option<String>,
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[serde(rename = "protectedManagedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_managed_disks: Vec<InMageAzureV2ManagedDiskDetails>,
    #[serde(rename = "lastRecoveryPointReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point_received: Option<String>,
    #[serde(rename = "firmwareType", default, skip_serializing_if = "Option::is_none")]
    pub firmware_type: Option<String>,
    #[serde(rename = "azureVmGeneration", default, skip_serializing_if = "Option::is_none")]
    pub azure_vm_generation: Option<String>,
    #[serde(rename = "isAdditionalStatsAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_additional_stats_available: Option<bool>,
    #[serde(rename = "totalDataTransferred", default, skip_serializing_if = "Option::is_none")]
    pub total_data_transferred: Option<i64>,
    #[serde(rename = "totalProgressHealth", default, skip_serializing_if = "Option::is_none")]
    pub total_progress_health: Option<String>,
    #[serde(rename = "targetVmTags", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_tags: Option<serde_json::Value>,
    #[serde(rename = "seedManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub seed_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub target_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetNicTags", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_tags: Option<serde_json::Value>,
}
impl InMageAzureV2ReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            infrastructure_vm_id: None,
            v_center_infrastructure_id: None,
            protection_stage: None,
            vm_id: None,
            vm_protection_state: None,
            vm_protection_state_description: None,
            resync_progress_percentage: None,
            rpo_in_seconds: None,
            compressed_data_rate_in_mb: None,
            uncompressed_data_rate_in_mb: None,
            ip_address: None,
            agent_version: None,
            agent_expiry_date: None,
            is_agent_update_required: None,
            is_reboot_after_update_required: None,
            last_heartbeat: None,
            process_server_id: None,
            process_server_name: None,
            multi_vm_group_id: None,
            multi_vm_group_name: None,
            multi_vm_sync_status: None,
            protected_disks: Vec::new(),
            disk_resized: None,
            master_target_id: None,
            source_vm_cpu_count: None,
            source_vm_ram_size_in_mb: None,
            os_type: None,
            vhd_name: None,
            os_disk_id: None,
            azure_vm_disk_details: Vec::new(),
            recovery_azure_vm_name: None,
            recovery_azure_vm_size: None,
            recovery_azure_storage_account: None,
            recovery_azure_log_storage_account_id: None,
            vm_nics: Vec::new(),
            selected_recovery_azure_network_id: None,
            selected_tfo_azure_network_id: None,
            selected_source_nic_id: None,
            discovery_type: None,
            enable_rdp_on_target_option: None,
            datastores: Vec::new(),
            target_vm_id: None,
            recovery_azure_resource_group_id: None,
            recovery_availability_set_id: None,
            target_availability_zone: None,
            target_proximity_placement_group_id: None,
            use_managed_disks: None,
            license_type: None,
            sql_server_license_type: None,
            validation_errors: Vec::new(),
            last_rpo_calculated_time: None,
            last_update_received_time: None,
            replica_id: None,
            os_version: None,
            protected_managed_disks: Vec::new(),
            last_recovery_point_received: None,
            firmware_type: None,
            azure_vm_generation: None,
            is_additional_stats_available: None,
            total_data_transferred: None,
            total_progress_health: None,
            target_vm_tags: None,
            seed_managed_disk_tags: None,
            target_managed_disk_tags: None,
            target_nic_tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2ReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[serde(rename = "masterTargetId", default, skip_serializing_if = "Option::is_none")]
    pub master_target_id: Option<String>,
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<String>,
}
impl InMageAzureV2ReprotectInput {
    pub fn new(reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput) -> Self {
        Self {
            reverse_replication_provider_specific_input,
            master_target_id: None,
            process_server_id: None,
            storage_account_id: None,
            run_as_account_id: None,
            policy_id: None,
            log_storage_account_id: None,
            disks_to_include: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2TestFailoverInput {
    #[serde(flatten)]
    pub test_failover_provider_specific_input: TestFailoverProviderSpecificInput,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl InMageAzureV2TestFailoverInput {
    pub fn new(test_failover_provider_specific_input: TestFailoverProviderSpecificInput) -> Self {
        Self {
            test_failover_provider_specific_input,
            recovery_point_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2UnplannedFailoverInput {
    #[serde(flatten)]
    pub unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl InMageAzureV2UnplannedFailoverInput {
    pub fn new(unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput) -> Self {
        Self {
            unplanned_failover_provider_specific_input,
            recovery_point_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageAzureV2UpdateReplicationProtectedItemInput {
    #[serde(flatten)]
    pub update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput,
    #[serde(rename = "recoveryAzureV1ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_v1_resource_group_id: Option<String>,
    #[serde(rename = "recoveryAzureV2ResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_v2_resource_group_id: Option<String>,
    #[serde(rename = "useManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub use_managed_disks: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetVmTags", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_tags: Option<serde_json::Value>,
    #[serde(rename = "targetManagedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub target_managed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetNicTags", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_tags: Option<serde_json::Value>,
    #[serde(rename = "sqlServerLicenseType", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_license_type: Option<in_mage_azure_v2_update_replication_protected_item_input::SqlServerLicenseType>,
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<UpdateDiskInput>,
}
impl InMageAzureV2UpdateReplicationProtectedItemInput {
    pub fn new(update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput) -> Self {
        Self {
            update_replication_protected_item_provider_input,
            recovery_azure_v1_resource_group_id: None,
            recovery_azure_v2_resource_group_id: None,
            use_managed_disks: None,
            target_proximity_placement_group_id: None,
            target_availability_zone: None,
            target_vm_tags: None,
            target_managed_disk_tags: None,
            target_nic_tags: None,
            sql_server_license_type: None,
            vm_disks: Vec::new(),
        }
    }
}
pub mod in_mage_azure_v2_update_replication_protected_item_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SqlServerLicenseType {
        NotSpecified,
        NoLicenseType,
        #[serde(rename = "PAYG")]
        Payg,
        #[serde(rename = "AHUB")]
        Ahub,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageBasePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
}
impl InMageBasePolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            recovery_point_threshold_in_minutes: None,
            recovery_point_history: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageDisableProtectionProviderSpecificInput {
    #[serde(flatten)]
    pub disable_protection_provider_specific_input: DisableProtectionProviderSpecificInput,
    #[serde(rename = "replicaVmDeletionStatus", default, skip_serializing_if = "Option::is_none")]
    pub replica_vm_deletion_status: Option<String>,
}
impl InMageDisableProtectionProviderSpecificInput {
    pub fn new(disable_protection_provider_specific_input: DisableProtectionProviderSpecificInput) -> Self {
        Self {
            disable_protection_provider_specific_input,
            replica_vm_deletion_status: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "diskSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub disk_size_in_mb: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<String>,
    #[serde(rename = "diskConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub disk_configuration: Option<String>,
    #[serde(rename = "volumeList", default, skip_serializing_if = "Vec::is_empty")]
    pub volume_list: Vec<DiskVolumeDetails>,
}
impl InMageDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageDiskExclusionInput {
    #[serde(rename = "volumeOptions", default, skip_serializing_if = "Vec::is_empty")]
    pub volume_options: Vec<InMageVolumeExclusionOptions>,
    #[serde(rename = "diskSignatureOptions", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_signature_options: Vec<InMageDiskSignatureExclusionOptions>,
}
impl InMageDiskExclusionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageDiskSignatureExclusionOptions {
    #[serde(rename = "diskSignature", default, skip_serializing_if = "Option::is_none")]
    pub disk_signature: Option<String>,
}
impl InMageDiskSignatureExclusionOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageEnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[serde(rename = "vmFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub vm_friendly_name: Option<String>,
    #[serde(rename = "masterTargetId")]
    pub master_target_id: String,
    #[serde(rename = "processServerId")]
    pub process_server_id: String,
    #[serde(rename = "retentionDrive")]
    pub retention_drive: String,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[serde(rename = "multiVmGroupId")]
    pub multi_vm_group_id: String,
    #[serde(rename = "multiVmGroupName")]
    pub multi_vm_group_name: String,
    #[serde(rename = "datastoreName", default, skip_serializing_if = "Option::is_none")]
    pub datastore_name: Option<String>,
    #[serde(rename = "diskExclusionInput", default, skip_serializing_if = "Option::is_none")]
    pub disk_exclusion_input: Option<InMageDiskExclusionInput>,
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<String>,
}
impl InMageEnableProtectionInput {
    pub fn new(
        enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
        master_target_id: String,
        process_server_id: String,
        retention_drive: String,
        multi_vm_group_id: String,
        multi_vm_group_name: String,
    ) -> Self {
        Self {
            enable_protection_provider_specific_input,
            vm_friendly_name: None,
            master_target_id,
            process_server_id,
            retention_drive,
            run_as_account_id: None,
            multi_vm_group_id,
            multi_vm_group_name,
            datastore_name: None,
            disk_exclusion_input: None,
            disks_to_include: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMagePolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
}
impl InMagePolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            recovery_point_threshold_in_minutes: None,
            recovery_point_history: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMagePolicyInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[serde(rename = "recoveryPointThresholdInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_threshold_in_minutes: Option<i32>,
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "multiVmSyncStatus")]
    pub multi_vm_sync_status: in_mage_policy_input::MultiVmSyncStatus,
}
impl InMagePolicyInput {
    pub fn new(
        policy_provider_specific_input: PolicyProviderSpecificInput,
        multi_vm_sync_status: in_mage_policy_input::MultiVmSyncStatus,
    ) -> Self {
        Self {
            policy_provider_specific_input,
            recovery_point_threshold_in_minutes: None,
            recovery_point_history: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status,
        }
    }
}
pub mod in_mage_policy_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncStatus {
        Enable,
        Disable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageProtectedDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "protectionStage", default, skip_serializing_if = "Option::is_none")]
    pub protection_stage: Option<String>,
    #[serde(rename = "healthErrorCode", default, skip_serializing_if = "Option::is_none")]
    pub health_error_code: Option<String>,
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<String>,
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[serde(rename = "resyncDurationInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub resync_duration_in_seconds: Option<i64>,
    #[serde(rename = "diskCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_capacity_in_bytes: Option<i64>,
    #[serde(rename = "fileSystemCapacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub file_system_capacity_in_bytes: Option<i64>,
    #[serde(rename = "sourceDataInMB", default, skip_serializing_if = "Option::is_none")]
    pub source_data_in_mb: Option<f64>,
    #[serde(rename = "psDataInMB", default, skip_serializing_if = "Option::is_none")]
    pub ps_data_in_mb: Option<f64>,
    #[serde(rename = "targetDataInMB", default, skip_serializing_if = "Option::is_none")]
    pub target_data_in_mb: Option<f64>,
    #[serde(rename = "diskResized", default, skip_serializing_if = "Option::is_none")]
    pub disk_resized: Option<String>,
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[serde(rename = "resyncProcessedBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_processed_bytes: Option<i64>,
    #[serde(rename = "resyncTotalTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_total_transferred_bytes: Option<i64>,
    #[serde(rename = "resyncLast15MinutesTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_last15_minutes_transferred_bytes: Option<i64>,
    #[serde(rename = "resyncLastDataTransferTimeUTC", default, skip_serializing_if = "Option::is_none")]
    pub resync_last_data_transfer_time_utc: Option<String>,
    #[serde(rename = "resyncStartTime", default, skip_serializing_if = "Option::is_none")]
    pub resync_start_time: Option<String>,
    #[serde(rename = "progressHealth", default, skip_serializing_if = "Option::is_none")]
    pub progress_health: Option<String>,
    #[serde(rename = "progressStatus", default, skip_serializing_if = "Option::is_none")]
    pub progress_status: Option<String>,
}
impl InMageProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmAgentUpgradeBlockingErrorDetails {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
    #[serde(rename = "errorMessageParameters", default, skip_serializing_if = "Option::is_none")]
    pub error_message_parameters: Option<serde_json::Value>,
    #[serde(rename = "errorTags", default, skip_serializing_if = "Option::is_none")]
    pub error_tags: Option<serde_json::Value>,
}
impl InMageRcmAgentUpgradeBlockingErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmApplyRecoveryPointInput {
    #[serde(flatten)]
    pub apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput,
    #[serde(rename = "recoveryPointId")]
    pub recovery_point_id: String,
}
impl InMageRcmApplyRecoveryPointInput {
    pub fn new(apply_recovery_point_provider_specific_input: ApplyRecoveryPointProviderSpecificInput, recovery_point_id: String) -> Self {
        Self {
            apply_recovery_point_provider_specific_input,
            recovery_point_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmDiscoveredProtectedVmDetails {
    #[serde(rename = "vCenterId", default, skip_serializing_if = "Option::is_none")]
    pub v_center_id: Option<String>,
    #[serde(rename = "vCenterFqdn", default, skip_serializing_if = "Option::is_none")]
    pub v_center_fqdn: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datastores: Vec<String>,
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
    #[serde(rename = "vmwareToolsStatus", default, skip_serializing_if = "Option::is_none")]
    pub vmware_tools_status: Option<String>,
    #[serde(rename = "powerStatus", default, skip_serializing_if = "Option::is_none")]
    pub power_status: Option<String>,
    #[serde(rename = "vmFqdn", default, skip_serializing_if = "Option::is_none")]
    pub vm_fqdn: Option<String>,
    #[serde(rename = "osName", default, skip_serializing_if = "Option::is_none")]
    pub os_name: Option<String>,
    #[serde(rename = "createdTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<String>,
    #[serde(rename = "updatedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<String>,
    #[serde(rename = "isDeleted", default, skip_serializing_if = "Option::is_none")]
    pub is_deleted: Option<bool>,
    #[serde(rename = "lastDiscoveryTimeInUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_discovery_time_in_utc: Option<String>,
}
impl InMageRcmDiscoveredProtectedVmDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmDiskInput {
    #[serde(rename = "diskId")]
    pub disk_id: String,
    #[serde(rename = "logStorageAccountId")]
    pub log_storage_account_id: String,
    #[serde(rename = "diskType")]
    pub disk_type: in_mage_rcm_disk_input::DiskType,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
}
impl InMageRcmDiskInput {
    pub fn new(disk_id: String, log_storage_account_id: String, disk_type: in_mage_rcm_disk_input::DiskType) -> Self {
        Self {
            disk_id,
            log_storage_account_id,
            disk_type,
            disk_encryption_set_id: None,
        }
    }
}
pub mod in_mage_rcm_disk_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmDisksDefaultInput {
    #[serde(rename = "logStorageAccountId")]
    pub log_storage_account_id: String,
    #[serde(rename = "diskType")]
    pub disk_type: in_mage_rcm_disks_default_input::DiskType,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
}
impl InMageRcmDisksDefaultInput {
    pub fn new(log_storage_account_id: String, disk_type: in_mage_rcm_disks_default_input::DiskType) -> Self {
        Self {
            log_storage_account_id,
            disk_type,
            disk_encryption_set_id: None,
        }
    }
}
pub mod in_mage_rcm_disks_default_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmEnableProtectionInput {
    #[serde(flatten)]
    pub enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
    #[serde(rename = "fabricDiscoveryMachineId")]
    pub fabric_discovery_machine_id: String,
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<InMageRcmDiskInput>,
    #[serde(rename = "disksDefault", default, skip_serializing_if = "Option::is_none")]
    pub disks_default: Option<InMageRcmDisksDefaultInput>,
    #[serde(rename = "targetResourceGroupId")]
    pub target_resource_group_id: String,
    #[serde(rename = "targetNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_network_id: Option<String>,
    #[serde(rename = "testNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub test_network_id: Option<String>,
    #[serde(rename = "targetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet_name: Option<String>,
    #[serde(rename = "testSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub test_subnet_name: Option<String>,
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<in_mage_rcm_enable_protection_input::LicenseType>,
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "targetBootDiagnosticsStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_boot_diagnostics_storage_account_id: Option<String>,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[serde(rename = "processServerId")]
    pub process_server_id: String,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
}
impl InMageRcmEnableProtectionInput {
    pub fn new(
        enable_protection_provider_specific_input: EnableProtectionProviderSpecificInput,
        fabric_discovery_machine_id: String,
        target_resource_group_id: String,
        process_server_id: String,
    ) -> Self {
        Self {
            enable_protection_provider_specific_input,
            fabric_discovery_machine_id,
            disks_to_include: Vec::new(),
            disks_default: None,
            target_resource_group_id,
            target_network_id: None,
            test_network_id: None,
            target_subnet_name: None,
            test_subnet_name: None,
            target_vm_name: None,
            target_vm_size: None,
            license_type: None,
            target_availability_set_id: None,
            target_availability_zone: None,
            target_proximity_placement_group_id: None,
            target_boot_diagnostics_storage_account_id: None,
            run_as_account_id: None,
            process_server_id,
            multi_vm_group_name: None,
        }
    }
}
pub mod in_mage_rcm_enable_protection_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[serde(rename = "protectedItemName", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_name: Option<String>,
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[serde(rename = "latestAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub latest_agent_version: Option<String>,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "applianceName", default, skip_serializing_if = "Option::is_none")]
    pub appliance_name: Option<String>,
    #[serde(rename = "serverType", default, skip_serializing_if = "Option::is_none")]
    pub server_type: Option<String>,
    #[serde(rename = "componentDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub component_display_name: Option<String>,
}
impl InMageRcmEventDetails {
    pub fn new(event_provider_specific_details: EventProviderSpecificDetails) -> Self {
        Self {
            event_provider_specific_details,
            protected_item_name: None,
            vm_name: None,
            latest_agent_version: None,
            job_id: None,
            fabric_name: None,
            appliance_name: None,
            server_type: None,
            component_display_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmFabricCreationInput {
    #[serde(flatten)]
    pub fabric_specific_creation_input: FabricSpecificCreationInput,
    #[serde(rename = "vmwareSiteId")]
    pub vmware_site_id: String,
    #[serde(rename = "physicalSiteId")]
    pub physical_site_id: String,
    #[serde(rename = "sourceAgentIdentity")]
    pub source_agent_identity: IdentityProviderInput,
}
impl InMageRcmFabricCreationInput {
    pub fn new(
        fabric_specific_creation_input: FabricSpecificCreationInput,
        vmware_site_id: String,
        physical_site_id: String,
        source_agent_identity: IdentityProviderInput,
    ) -> Self {
        Self {
            fabric_specific_creation_input,
            vmware_site_id,
            physical_site_id,
            source_agent_identity,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmFabricSpecificDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
    #[serde(rename = "vmwareSiteId", default, skip_serializing_if = "Option::is_none")]
    pub vmware_site_id: Option<String>,
    #[serde(rename = "physicalSiteId", default, skip_serializing_if = "Option::is_none")]
    pub physical_site_id: Option<String>,
    #[serde(rename = "serviceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub service_endpoint: Option<String>,
    #[serde(rename = "serviceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub service_resource_id: Option<String>,
    #[serde(rename = "serviceContainerId", default, skip_serializing_if = "Option::is_none")]
    pub service_container_id: Option<String>,
    #[serde(rename = "dataPlaneUri", default, skip_serializing_if = "Option::is_none")]
    pub data_plane_uri: Option<String>,
    #[serde(rename = "controlPlaneUri", default, skip_serializing_if = "Option::is_none")]
    pub control_plane_uri: Option<String>,
    #[serde(rename = "sourceAgentIdentityDetails", default, skip_serializing_if = "Option::is_none")]
    pub source_agent_identity_details: Option<IdentityProviderDetails>,
    #[serde(rename = "processServers", default, skip_serializing_if = "Vec::is_empty")]
    pub process_servers: Vec<ProcessServerDetails>,
    #[serde(rename = "rcmProxies", default, skip_serializing_if = "Vec::is_empty")]
    pub rcm_proxies: Vec<RcmProxyDetails>,
    #[serde(rename = "pushInstallers", default, skip_serializing_if = "Vec::is_empty")]
    pub push_installers: Vec<PushInstallerDetails>,
    #[serde(rename = "replicationAgents", default, skip_serializing_if = "Vec::is_empty")]
    pub replication_agents: Vec<ReplicationAgentDetails>,
    #[serde(rename = "reprotectAgents", default, skip_serializing_if = "Vec::is_empty")]
    pub reprotect_agents: Vec<ReprotectAgentDetails>,
    #[serde(rename = "marsAgents", default, skip_serializing_if = "Vec::is_empty")]
    pub mars_agents: Vec<MarsAgentDetails>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dras: Vec<DraDetails>,
    #[serde(rename = "agentDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub agent_details: Vec<AgentDetails>,
}
impl InMageRcmFabricSpecificDetails {
    pub fn new(fabric_specific_details: FabricSpecificDetails) -> Self {
        Self {
            fabric_specific_details,
            vmware_site_id: None,
            physical_site_id: None,
            service_endpoint: None,
            service_resource_id: None,
            service_container_id: None,
            data_plane_uri: None,
            control_plane_uri: None,
            source_agent_identity_details: None,
            process_servers: Vec::new(),
            rcm_proxies: Vec::new(),
            push_installers: Vec::new(),
            replication_agents: Vec::new(),
            reprotect_agents: Vec::new(),
            mars_agents: Vec::new(),
            dras: Vec::new(),
            agent_details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmFailbackDiscoveredProtectedVmDetails {
    #[serde(rename = "vCenterId", default, skip_serializing_if = "Option::is_none")]
    pub v_center_id: Option<String>,
    #[serde(rename = "vCenterFqdn", default, skip_serializing_if = "Option::is_none")]
    pub v_center_fqdn: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datastores: Vec<String>,
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
    #[serde(rename = "vmwareToolsStatus", default, skip_serializing_if = "Option::is_none")]
    pub vmware_tools_status: Option<String>,
    #[serde(rename = "powerStatus", default, skip_serializing_if = "Option::is_none")]
    pub power_status: Option<String>,
    #[serde(rename = "vmFqdn", default, skip_serializing_if = "Option::is_none")]
    pub vm_fqdn: Option<String>,
    #[serde(rename = "osName", default, skip_serializing_if = "Option::is_none")]
    pub os_name: Option<String>,
    #[serde(rename = "createdTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub created_timestamp: Option<String>,
    #[serde(rename = "updatedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub updated_timestamp: Option<String>,
    #[serde(rename = "isDeleted", default, skip_serializing_if = "Option::is_none")]
    pub is_deleted: Option<bool>,
    #[serde(rename = "lastDiscoveryTimeInUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_discovery_time_in_utc: Option<String>,
}
impl InMageRcmFailbackDiscoveredProtectedVmDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmFailbackEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[serde(rename = "protectedItemName", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_name: Option<String>,
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[serde(rename = "applianceName", default, skip_serializing_if = "Option::is_none")]
    pub appliance_name: Option<String>,
    #[serde(rename = "serverType", default, skip_serializing_if = "Option::is_none")]
    pub server_type: Option<String>,
    #[serde(rename = "componentDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub component_display_name: Option<String>,
}
impl InMageRcmFailbackEventDetails {
    pub fn new(event_provider_specific_details: EventProviderSpecificDetails) -> Self {
        Self {
            event_provider_specific_details,
            protected_item_name: None,
            vm_name: None,
            appliance_name: None,
            server_type: None,
            component_display_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmFailbackMobilityAgentDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "latestVersion", default, skip_serializing_if = "Option::is_none")]
    pub latest_version: Option<String>,
    #[serde(rename = "driverVersion", default, skip_serializing_if = "Option::is_none")]
    pub driver_version: Option<String>,
    #[serde(rename = "latestUpgradableVersionWithoutReboot", default, skip_serializing_if = "Option::is_none")]
    pub latest_upgradable_version_without_reboot: Option<String>,
    #[serde(rename = "agentVersionExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_version_expiry_date: Option<String>,
    #[serde(rename = "driverVersionExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub driver_version_expiry_date: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(rename = "reasonsBlockingUpgrade", default, skip_serializing_if = "Vec::is_empty")]
    pub reasons_blocking_upgrade: Vec<String>,
    #[serde(rename = "isUpgradeable", default, skip_serializing_if = "Option::is_none")]
    pub is_upgradeable: Option<String>,
}
impl InMageRcmFailbackMobilityAgentDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmFailbackNicDetails {
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[serde(rename = "networkName", default, skip_serializing_if = "Option::is_none")]
    pub network_name: Option<String>,
    #[serde(rename = "adapterType", default, skip_serializing_if = "Option::is_none")]
    pub adapter_type: Option<String>,
    #[serde(rename = "sourceIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub source_ip_address: Option<String>,
}
impl InMageRcmFailbackNicDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmFailbackPlannedFailoverProviderInput {
    #[serde(flatten)]
    pub planned_failover_provider_specific_failover_input: PlannedFailoverProviderSpecificFailoverInput,
    #[serde(rename = "recoveryPointType")]
    pub recovery_point_type: in_mage_rcm_failback_planned_failover_provider_input::RecoveryPointType,
}
impl InMageRcmFailbackPlannedFailoverProviderInput {
    pub fn new(
        planned_failover_provider_specific_failover_input: PlannedFailoverProviderSpecificFailoverInput,
        recovery_point_type: in_mage_rcm_failback_planned_failover_provider_input::RecoveryPointType,
    ) -> Self {
        Self {
            planned_failover_provider_specific_failover_input,
            recovery_point_type,
        }
    }
}
pub mod in_mage_rcm_failback_planned_failover_provider_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        ApplicationConsistent,
        CrashConsistent,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmFailbackPolicyCreationInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
}
impl InMageRcmFailbackPolicyCreationInput {
    pub fn new(policy_provider_specific_input: PolicyProviderSpecificInput) -> Self {
        Self {
            policy_provider_specific_input,
            crash_consistent_frequency_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmFailbackPolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
}
impl InMageRcmFailbackPolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            app_consistent_frequency_in_minutes: None,
            crash_consistent_frequency_in_minutes: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmFailbackProtectedDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "isOSDisk", default, skip_serializing_if = "Option::is_none")]
    pub is_os_disk: Option<String>,
    #[serde(rename = "capacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub capacity_in_bytes: Option<i64>,
    #[serde(rename = "diskUuid", default, skip_serializing_if = "Option::is_none")]
    pub disk_uuid: Option<String>,
    #[serde(rename = "dataPendingInLogDataStoreInMB", default, skip_serializing_if = "Option::is_none")]
    pub data_pending_in_log_data_store_in_mb: Option<f64>,
    #[serde(rename = "dataPendingAtSourceAgentInMB", default, skip_serializing_if = "Option::is_none")]
    pub data_pending_at_source_agent_in_mb: Option<f64>,
    #[serde(rename = "isInitialReplicationComplete", default, skip_serializing_if = "Option::is_none")]
    pub is_initial_replication_complete: Option<String>,
    #[serde(rename = "irDetails", default, skip_serializing_if = "Option::is_none")]
    pub ir_details: Option<InMageRcmFailbackSyncDetails>,
    #[serde(rename = "resyncDetails", default, skip_serializing_if = "Option::is_none")]
    pub resync_details: Option<InMageRcmFailbackSyncDetails>,
    #[serde(rename = "lastSyncTime", default, skip_serializing_if = "Option::is_none")]
    pub last_sync_time: Option<String>,
}
impl InMageRcmFailbackProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmFailbackReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "internalIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub internal_identifier: Option<String>,
    #[serde(rename = "azureVirtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub azure_virtual_machine_id: Option<String>,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[serde(rename = "reprotectAgentId", default, skip_serializing_if = "Option::is_none")]
    pub reprotect_agent_id: Option<String>,
    #[serde(rename = "reprotectAgentName", default, skip_serializing_if = "Option::is_none")]
    pub reprotect_agent_name: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[serde(rename = "targetvCenterId", default, skip_serializing_if = "Option::is_none")]
    pub targetv_center_id: Option<String>,
    #[serde(rename = "targetDataStoreName", default, skip_serializing_if = "Option::is_none")]
    pub target_data_store_name: Option<String>,
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[serde(rename = "initialReplicationProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_progress_percentage: Option<i32>,
    #[serde(rename = "initialReplicationProcessedBytes", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_processed_bytes: Option<i64>,
    #[serde(rename = "initialReplicationTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_transferred_bytes: Option<i64>,
    #[serde(rename = "initialReplicationProgressHealth", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_progress_health: Option<in_mage_rcm_failback_replication_details::InitialReplicationProgressHealth>,
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[serde(rename = "resyncProcessedBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_processed_bytes: Option<i64>,
    #[serde(rename = "resyncTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_transferred_bytes: Option<i64>,
    #[serde(rename = "resyncProgressHealth", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_health: Option<in_mage_rcm_failback_replication_details::ResyncProgressHealth>,
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<String>,
    #[serde(rename = "resyncState", default, skip_serializing_if = "Option::is_none")]
    pub resync_state: Option<in_mage_rcm_failback_replication_details::ResyncState>,
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<InMageRcmFailbackProtectedDiskDetails>,
    #[serde(rename = "mobilityAgentDetails", default, skip_serializing_if = "Option::is_none")]
    pub mobility_agent_details: Option<InMageRcmFailbackMobilityAgentDetails>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<InMageRcmFailbackNicDetails>,
    #[serde(rename = "lastPlannedFailoverStartTime", default, skip_serializing_if = "Option::is_none")]
    pub last_planned_failover_start_time: Option<String>,
    #[serde(rename = "lastPlannedFailoverStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_planned_failover_status: Option<in_mage_rcm_failback_replication_details::LastPlannedFailoverStatus>,
    #[serde(rename = "discoveredVmDetails", default, skip_serializing_if = "Option::is_none")]
    pub discovered_vm_details: Option<InMageRcmFailbackDiscoveredProtectedVmDetails>,
    #[serde(rename = "lastUsedPolicyId", default, skip_serializing_if = "Option::is_none")]
    pub last_used_policy_id: Option<String>,
    #[serde(rename = "lastUsedPolicyFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub last_used_policy_friendly_name: Option<String>,
    #[serde(
        rename = "isAgentRegistrationSuccessfulAfterFailover",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub is_agent_registration_successful_after_failover: Option<bool>,
}
impl InMageRcmFailbackReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            internal_identifier: None,
            azure_virtual_machine_id: None,
            multi_vm_group_name: None,
            reprotect_agent_id: None,
            reprotect_agent_name: None,
            os_type: None,
            log_storage_account_id: None,
            targetv_center_id: None,
            target_data_store_name: None,
            target_vm_name: None,
            initial_replication_progress_percentage: None,
            initial_replication_processed_bytes: None,
            initial_replication_transferred_bytes: None,
            initial_replication_progress_health: None,
            resync_progress_percentage: None,
            resync_processed_bytes: None,
            resync_transferred_bytes: None,
            resync_progress_health: None,
            resync_required: None,
            resync_state: None,
            protected_disks: Vec::new(),
            mobility_agent_details: None,
            vm_nics: Vec::new(),
            last_planned_failover_start_time: None,
            last_planned_failover_status: None,
            discovered_vm_details: None,
            last_used_policy_id: None,
            last_used_policy_friendly_name: None,
            is_agent_registration_successful_after_failover: None,
        }
    }
}
pub mod in_mage_rcm_failback_replication_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InitialReplicationProgressHealth {
        None,
        InProgress,
        SlowProgress,
        NoProgress,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResyncProgressHealth {
        None,
        InProgress,
        SlowProgress,
        NoProgress,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResyncState {
        None,
        PreparedForResynchronization,
        StartedResynchronization,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastPlannedFailoverStatus {
        Succeeded,
        Failed,
        Cancelled,
        Unknown,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmFailbackReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[serde(rename = "processServerId")]
    pub process_server_id: String,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[serde(rename = "policyId")]
    pub policy_id: String,
}
impl InMageRcmFailbackReprotectInput {
    pub fn new(
        reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
        process_server_id: String,
        policy_id: String,
    ) -> Self {
        Self {
            reverse_replication_provider_specific_input,
            process_server_id,
            run_as_account_id: None,
            policy_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmFailbackSyncDetails {
    #[serde(rename = "progressHealth", default, skip_serializing_if = "Option::is_none")]
    pub progress_health: Option<in_mage_rcm_failback_sync_details::ProgressHealth>,
    #[serde(rename = "transferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub transferred_bytes: Option<i64>,
    #[serde(rename = "last15MinutesTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub last15_minutes_transferred_bytes: Option<i64>,
    #[serde(rename = "lastDataTransferTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_data_transfer_time_utc: Option<String>,
    #[serde(rename = "processedBytes", default, skip_serializing_if = "Option::is_none")]
    pub processed_bytes: Option<i64>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "lastRefreshTime", default, skip_serializing_if = "Option::is_none")]
    pub last_refresh_time: Option<String>,
    #[serde(rename = "progressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub progress_percentage: Option<i32>,
}
impl InMageRcmFailbackSyncDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod in_mage_rcm_failback_sync_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProgressHealth {
        None,
        InProgress,
        SlowProgress,
        NoProgress,
        Queued,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmLastAgentUpgradeErrorDetails {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
    #[serde(rename = "errorMessageParameters", default, skip_serializing_if = "Option::is_none")]
    pub error_message_parameters: Option<serde_json::Value>,
    #[serde(rename = "errorTags", default, skip_serializing_if = "Option::is_none")]
    pub error_tags: Option<serde_json::Value>,
}
impl InMageRcmLastAgentUpgradeErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmMobilityAgentDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "latestVersion", default, skip_serializing_if = "Option::is_none")]
    pub latest_version: Option<String>,
    #[serde(rename = "latestAgentReleaseDate", default, skip_serializing_if = "Option::is_none")]
    pub latest_agent_release_date: Option<String>,
    #[serde(rename = "driverVersion", default, skip_serializing_if = "Option::is_none")]
    pub driver_version: Option<String>,
    #[serde(rename = "latestUpgradableVersionWithoutReboot", default, skip_serializing_if = "Option::is_none")]
    pub latest_upgradable_version_without_reboot: Option<String>,
    #[serde(rename = "agentVersionExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_version_expiry_date: Option<String>,
    #[serde(rename = "driverVersionExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub driver_version_expiry_date: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(rename = "reasonsBlockingUpgrade", default, skip_serializing_if = "Vec::is_empty")]
    pub reasons_blocking_upgrade: Vec<String>,
    #[serde(rename = "isUpgradeable", default, skip_serializing_if = "Option::is_none")]
    pub is_upgradeable: Option<String>,
}
impl InMageRcmMobilityAgentDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmNicDetails {
    #[serde(rename = "nicId", default, skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    #[serde(rename = "isPrimaryNic", default, skip_serializing_if = "Option::is_none")]
    pub is_primary_nic: Option<String>,
    #[serde(rename = "isSelectedForFailover", default, skip_serializing_if = "Option::is_none")]
    pub is_selected_for_failover: Option<String>,
    #[serde(rename = "sourceIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub source_ip_address: Option<String>,
    #[serde(rename = "sourceIPAddressType", default, skip_serializing_if = "Option::is_none")]
    pub source_ip_address_type: Option<in_mage_rcm_nic_details::SourceIpAddressType>,
    #[serde(rename = "sourceNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub source_network_id: Option<String>,
    #[serde(rename = "sourceSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub source_subnet_name: Option<String>,
    #[serde(rename = "targetIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub target_ip_address: Option<String>,
    #[serde(rename = "targetIPAddressType", default, skip_serializing_if = "Option::is_none")]
    pub target_ip_address_type: Option<in_mage_rcm_nic_details::TargetIpAddressType>,
    #[serde(rename = "targetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet_name: Option<String>,
    #[serde(rename = "testSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub test_subnet_name: Option<String>,
    #[serde(rename = "testIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub test_ip_address: Option<String>,
    #[serde(rename = "testIPAddressType", default, skip_serializing_if = "Option::is_none")]
    pub test_ip_address_type: Option<in_mage_rcm_nic_details::TestIpAddressType>,
}
impl InMageRcmNicDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod in_mage_rcm_nic_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceIpAddressType {
        Dynamic,
        Static,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TargetIpAddressType {
        Dynamic,
        Static,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TestIpAddressType {
        Dynamic,
        Static,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmNicInput {
    #[serde(rename = "nicId")]
    pub nic_id: String,
    #[serde(rename = "isPrimaryNic")]
    pub is_primary_nic: String,
    #[serde(rename = "isSelectedForFailover", default, skip_serializing_if = "Option::is_none")]
    pub is_selected_for_failover: Option<String>,
    #[serde(rename = "targetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet_name: Option<String>,
    #[serde(rename = "targetStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub target_static_ip_address: Option<String>,
    #[serde(rename = "testSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub test_subnet_name: Option<String>,
    #[serde(rename = "testStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub test_static_ip_address: Option<String>,
}
impl InMageRcmNicInput {
    pub fn new(nic_id: String, is_primary_nic: String) -> Self {
        Self {
            nic_id,
            is_primary_nic,
            is_selected_for_failover: None,
            target_subnet_name: None,
            target_static_ip_address: None,
            test_subnet_name: None,
            test_static_ip_address: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmPolicyCreationInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[serde(rename = "recoveryPointHistoryInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_in_minutes: Option<i32>,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "enableMultiVmSync", default, skip_serializing_if = "Option::is_none")]
    pub enable_multi_vm_sync: Option<String>,
}
impl InMageRcmPolicyCreationInput {
    pub fn new(policy_provider_specific_input: PolicyProviderSpecificInput) -> Self {
        Self {
            policy_provider_specific_input,
            recovery_point_history_in_minutes: None,
            crash_consistent_frequency_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
            enable_multi_vm_sync: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmPolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "recoveryPointHistoryInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_in_minutes: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "enableMultiVmSync", default, skip_serializing_if = "Option::is_none")]
    pub enable_multi_vm_sync: Option<String>,
}
impl InMageRcmPolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            recovery_point_history_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
            crash_consistent_frequency_in_minutes: None,
            enable_multi_vm_sync: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmProtectedDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "isOSDisk", default, skip_serializing_if = "Option::is_none")]
    pub is_os_disk: Option<String>,
    #[serde(rename = "capacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub capacity_in_bytes: Option<i64>,
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
    #[serde(rename = "seedManagedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub seed_managed_disk_id: Option<String>,
    #[serde(rename = "targetManagedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub target_managed_disk_id: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<in_mage_rcm_protected_disk_details::DiskType>,
    #[serde(rename = "dataPendingInLogDataStoreInMB", default, skip_serializing_if = "Option::is_none")]
    pub data_pending_in_log_data_store_in_mb: Option<f64>,
    #[serde(rename = "dataPendingAtSourceAgentInMB", default, skip_serializing_if = "Option::is_none")]
    pub data_pending_at_source_agent_in_mb: Option<f64>,
    #[serde(rename = "isInitialReplicationComplete", default, skip_serializing_if = "Option::is_none")]
    pub is_initial_replication_complete: Option<String>,
    #[serde(rename = "irDetails", default, skip_serializing_if = "Option::is_none")]
    pub ir_details: Option<InMageRcmSyncDetails>,
    #[serde(rename = "resyncDetails", default, skip_serializing_if = "Option::is_none")]
    pub resync_details: Option<InMageRcmSyncDetails>,
}
impl InMageRcmProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod in_mage_rcm_protected_disk_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmProtectionContainerMappingDetails {
    #[serde(flatten)]
    pub protection_container_mapping_provider_specific_details: ProtectionContainerMappingProviderSpecificDetails,
    #[serde(rename = "enableAgentAutoUpgrade", default, skip_serializing_if = "Option::is_none")]
    pub enable_agent_auto_upgrade: Option<String>,
}
impl InMageRcmProtectionContainerMappingDetails {
    pub fn new(protection_container_mapping_provider_specific_details: ProtectionContainerMappingProviderSpecificDetails) -> Self {
        Self {
            protection_container_mapping_provider_specific_details,
            enable_agent_auto_upgrade: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmRecoveryPointDetails {
    #[serde(flatten)]
    pub provider_specific_recovery_point_details: ProviderSpecificRecoveryPointDetails,
    #[serde(rename = "isMultiVmSyncPoint", default, skip_serializing_if = "Option::is_none")]
    pub is_multi_vm_sync_point: Option<String>,
}
impl InMageRcmRecoveryPointDetails {
    pub fn new(provider_specific_recovery_point_details: ProviderSpecificRecoveryPointDetails) -> Self {
        Self {
            provider_specific_recovery_point_details,
            is_multi_vm_sync_point: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "internalIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub internal_identifier: Option<String>,
    #[serde(rename = "fabricDiscoveryMachineId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_discovery_machine_id: Option<String>,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[serde(rename = "discoveryType", default, skip_serializing_if = "Option::is_none")]
    pub discovery_type: Option<String>,
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[serde(rename = "processorCoreCount", default, skip_serializing_if = "Option::is_none")]
    pub processor_core_count: Option<i32>,
    #[serde(rename = "allocatedMemoryInMB", default, skip_serializing_if = "Option::is_none")]
    pub allocated_memory_in_mb: Option<f64>,
    #[serde(rename = "processServerName", default, skip_serializing_if = "Option::is_none")]
    pub process_server_name: Option<String>,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "firmwareType", default, skip_serializing_if = "Option::is_none")]
    pub firmware_type: Option<String>,
    #[serde(rename = "primaryNicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub primary_nic_ip_address: Option<String>,
    #[serde(rename = "targetGeneration", default, skip_serializing_if = "Option::is_none")]
    pub target_generation: Option<String>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[serde(rename = "targetResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_id: Option<String>,
    #[serde(rename = "targetLocation", default, skip_serializing_if = "Option::is_none")]
    pub target_location: Option<String>,
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "targetBootDiagnosticsStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_boot_diagnostics_storage_account_id: Option<String>,
    #[serde(rename = "targetNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_network_id: Option<String>,
    #[serde(rename = "testNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub test_network_id: Option<String>,
    #[serde(rename = "failoverRecoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub failover_recovery_point_id: Option<String>,
    #[serde(rename = "lastRecoveryPointReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point_received: Option<String>,
    #[serde(rename = "lastRpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_in_seconds: Option<i64>,
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[serde(rename = "lastRecoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point_id: Option<String>,
    #[serde(rename = "initialReplicationProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_progress_percentage: Option<i32>,
    #[serde(rename = "initialReplicationProcessedBytes", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_processed_bytes: Option<i64>,
    #[serde(rename = "initialReplicationTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_transferred_bytes: Option<i64>,
    #[serde(rename = "initialReplicationProgressHealth", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_progress_health: Option<in_mage_rcm_replication_details::InitialReplicationProgressHealth>,
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[serde(rename = "resyncProcessedBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_processed_bytes: Option<i64>,
    #[serde(rename = "resyncTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub resync_transferred_bytes: Option<i64>,
    #[serde(rename = "resyncProgressHealth", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_health: Option<in_mage_rcm_replication_details::ResyncProgressHealth>,
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<String>,
    #[serde(rename = "resyncState", default, skip_serializing_if = "Option::is_none")]
    pub resync_state: Option<in_mage_rcm_replication_details::ResyncState>,
    #[serde(rename = "agentUpgradeState", default, skip_serializing_if = "Option::is_none")]
    pub agent_upgrade_state: Option<in_mage_rcm_replication_details::AgentUpgradeState>,
    #[serde(rename = "lastAgentUpgradeType", default, skip_serializing_if = "Option::is_none")]
    pub last_agent_upgrade_type: Option<String>,
    #[serde(rename = "agentUpgradeJobId", default, skip_serializing_if = "Option::is_none")]
    pub agent_upgrade_job_id: Option<String>,
    #[serde(rename = "agentUpgradeAttemptToVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_upgrade_attempt_to_version: Option<String>,
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<InMageRcmProtectedDiskDetails>,
    #[serde(rename = "isLastUpgradeSuccessful", default, skip_serializing_if = "Option::is_none")]
    pub is_last_upgrade_successful: Option<String>,
    #[serde(
        rename = "isAgentRegistrationSuccessfulAfterFailover",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub is_agent_registration_successful_after_failover: Option<bool>,
    #[serde(rename = "mobilityAgentDetails", default, skip_serializing_if = "Option::is_none")]
    pub mobility_agent_details: Option<InMageRcmMobilityAgentDetails>,
    #[serde(rename = "lastAgentUpgradeErrorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub last_agent_upgrade_error_details: Vec<InMageRcmLastAgentUpgradeErrorDetails>,
    #[serde(rename = "agentUpgradeBlockingErrorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub agent_upgrade_blocking_error_details: Vec<InMageRcmAgentUpgradeBlockingErrorDetails>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<InMageRcmNicDetails>,
    #[serde(rename = "discoveredVmDetails", default, skip_serializing_if = "Option::is_none")]
    pub discovered_vm_details: Option<InMageRcmDiscoveredProtectedVmDetails>,
}
impl InMageRcmReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            internal_identifier: None,
            fabric_discovery_machine_id: None,
            multi_vm_group_name: None,
            discovery_type: None,
            process_server_id: None,
            processor_core_count: None,
            allocated_memory_in_mb: None,
            process_server_name: None,
            run_as_account_id: None,
            os_type: None,
            firmware_type: None,
            primary_nic_ip_address: None,
            target_generation: None,
            license_type: None,
            target_vm_name: None,
            target_vm_size: None,
            target_resource_group_id: None,
            target_location: None,
            target_availability_set_id: None,
            target_availability_zone: None,
            target_proximity_placement_group_id: None,
            target_boot_diagnostics_storage_account_id: None,
            target_network_id: None,
            test_network_id: None,
            failover_recovery_point_id: None,
            last_recovery_point_received: None,
            last_rpo_in_seconds: None,
            last_rpo_calculated_time: None,
            last_recovery_point_id: None,
            initial_replication_progress_percentage: None,
            initial_replication_processed_bytes: None,
            initial_replication_transferred_bytes: None,
            initial_replication_progress_health: None,
            resync_progress_percentage: None,
            resync_processed_bytes: None,
            resync_transferred_bytes: None,
            resync_progress_health: None,
            resync_required: None,
            resync_state: None,
            agent_upgrade_state: None,
            last_agent_upgrade_type: None,
            agent_upgrade_job_id: None,
            agent_upgrade_attempt_to_version: None,
            protected_disks: Vec::new(),
            is_last_upgrade_successful: None,
            is_agent_registration_successful_after_failover: None,
            mobility_agent_details: None,
            last_agent_upgrade_error_details: Vec::new(),
            agent_upgrade_blocking_error_details: Vec::new(),
            vm_nics: Vec::new(),
            discovered_vm_details: None,
        }
    }
}
pub mod in_mage_rcm_replication_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InitialReplicationProgressHealth {
        None,
        InProgress,
        SlowProgress,
        NoProgress,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResyncProgressHealth {
        None,
        InProgress,
        SlowProgress,
        NoProgress,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResyncState {
        None,
        PreparedForResynchronization,
        StartedResynchronization,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AgentUpgradeState {
        None,
        Started,
        Completed,
        Commit,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[serde(rename = "reprotectAgentId")]
    pub reprotect_agent_id: String,
    #[serde(rename = "datastoreName")]
    pub datastore_name: String,
    #[serde(rename = "logStorageAccountId")]
    pub log_storage_account_id: String,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
}
impl InMageRcmReprotectInput {
    pub fn new(
        reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
        reprotect_agent_id: String,
        datastore_name: String,
        log_storage_account_id: String,
    ) -> Self {
        Self {
            reverse_replication_provider_specific_input,
            reprotect_agent_id,
            datastore_name,
            log_storage_account_id,
            policy_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageRcmSyncDetails {
    #[serde(rename = "progressHealth", default, skip_serializing_if = "Option::is_none")]
    pub progress_health: Option<in_mage_rcm_sync_details::ProgressHealth>,
    #[serde(rename = "transferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub transferred_bytes: Option<i64>,
    #[serde(rename = "last15MinutesTransferredBytes", default, skip_serializing_if = "Option::is_none")]
    pub last15_minutes_transferred_bytes: Option<i64>,
    #[serde(rename = "lastDataTransferTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_data_transfer_time_utc: Option<String>,
    #[serde(rename = "processedBytes", default, skip_serializing_if = "Option::is_none")]
    pub processed_bytes: Option<i64>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "lastRefreshTime", default, skip_serializing_if = "Option::is_none")]
    pub last_refresh_time: Option<String>,
    #[serde(rename = "progressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub progress_percentage: Option<i32>,
}
impl InMageRcmSyncDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod in_mage_rcm_sync_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProgressHealth {
        None,
        InProgress,
        SlowProgress,
        NoProgress,
        Queued,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmTestFailoverInput {
    #[serde(flatten)]
    pub test_failover_provider_specific_input: TestFailoverProviderSpecificInput,
    #[serde(rename = "networkId", default, skip_serializing_if = "Option::is_none")]
    pub network_id: Option<String>,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl InMageRcmTestFailoverInput {
    pub fn new(test_failover_provider_specific_input: TestFailoverProviderSpecificInput) -> Self {
        Self {
            test_failover_provider_specific_input,
            network_id: None,
            recovery_point_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmUnplannedFailoverInput {
    #[serde(flatten)]
    pub unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput,
    #[serde(rename = "performShutdown")]
    pub perform_shutdown: String,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl InMageRcmUnplannedFailoverInput {
    pub fn new(unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput, perform_shutdown: String) -> Self {
        Self {
            unplanned_failover_provider_specific_input,
            perform_shutdown,
            recovery_point_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmUpdateApplianceForReplicationProtectedItemInput {
    #[serde(flatten)]
    pub update_appliance_for_replication_protected_item_provider_specific_input:
        UpdateApplianceForReplicationProtectedItemProviderSpecificInput,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
}
impl InMageRcmUpdateApplianceForReplicationProtectedItemInput {
    pub fn new(
        update_appliance_for_replication_protected_item_provider_specific_input : UpdateApplianceForReplicationProtectedItemProviderSpecificInput,
    ) -> Self {
        Self {
            update_appliance_for_replication_protected_item_provider_specific_input,
            run_as_account_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmUpdateContainerMappingInput {
    #[serde(flatten)]
    pub replication_provider_specific_update_container_mapping_input: ReplicationProviderSpecificUpdateContainerMappingInput,
    #[serde(rename = "enableAgentAutoUpgrade")]
    pub enable_agent_auto_upgrade: String,
}
impl InMageRcmUpdateContainerMappingInput {
    pub fn new(
        replication_provider_specific_update_container_mapping_input: ReplicationProviderSpecificUpdateContainerMappingInput,
        enable_agent_auto_upgrade: String,
    ) -> Self {
        Self {
            replication_provider_specific_update_container_mapping_input,
            enable_agent_auto_upgrade,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageRcmUpdateReplicationProtectedItemInput {
    #[serde(flatten)]
    pub update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput,
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[serde(rename = "targetResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_id: Option<String>,
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "targetBootDiagnosticsStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_boot_diagnostics_storage_account_id: Option<String>,
    #[serde(rename = "targetNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_network_id: Option<String>,
    #[serde(rename = "testNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub test_network_id: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<InMageRcmNicInput>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<in_mage_rcm_update_replication_protected_item_input::LicenseType>,
}
impl InMageRcmUpdateReplicationProtectedItemInput {
    pub fn new(update_replication_protected_item_provider_input: UpdateReplicationProtectedItemProviderInput) -> Self {
        Self {
            update_replication_protected_item_provider_input,
            target_vm_name: None,
            target_vm_size: None,
            target_resource_group_id: None,
            target_availability_set_id: None,
            target_availability_zone: None,
            target_proximity_placement_group_id: None,
            target_boot_diagnostics_storage_account_id: None,
            target_network_id: None,
            test_network_id: None,
            vm_nics: Vec::new(),
            license_type: None,
        }
    }
}
pub mod in_mage_rcm_update_replication_protected_item_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageReplicationDetails {
    #[serde(flatten)]
    pub replication_provider_specific_settings: ReplicationProviderSpecificSettings,
    #[serde(rename = "activeSiteType", default, skip_serializing_if = "Option::is_none")]
    pub active_site_type: Option<String>,
    #[serde(rename = "sourceVmCpuCount", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_cpu_count: Option<i32>,
    #[serde(rename = "sourceVmRamSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_ram_size_in_mb: Option<i32>,
    #[serde(rename = "osDetails", default, skip_serializing_if = "Option::is_none")]
    pub os_details: Option<OsDiskDetails>,
    #[serde(rename = "protectionStage", default, skip_serializing_if = "Option::is_none")]
    pub protection_stage: Option<String>,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "vmProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state: Option<String>,
    #[serde(rename = "vmProtectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub vm_protection_state_description: Option<String>,
    #[serde(rename = "resyncDetails", default, skip_serializing_if = "Option::is_none")]
    pub resync_details: Option<InitialReplicationDetails>,
    #[serde(rename = "retentionWindowStart", default, skip_serializing_if = "Option::is_none")]
    pub retention_window_start: Option<String>,
    #[serde(rename = "retentionWindowEnd", default, skip_serializing_if = "Option::is_none")]
    pub retention_window_end: Option<String>,
    #[serde(rename = "compressedDataRateInMB", default, skip_serializing_if = "Option::is_none")]
    pub compressed_data_rate_in_mb: Option<f64>,
    #[serde(rename = "uncompressedDataRateInMB", default, skip_serializing_if = "Option::is_none")]
    pub uncompressed_data_rate_in_mb: Option<f64>,
    #[serde(rename = "rpoInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub rpo_in_seconds: Option<i64>,
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<InMageProtectedDiskDetails>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[serde(rename = "masterTargetId", default, skip_serializing_if = "Option::is_none")]
    pub master_target_id: Option<String>,
    #[serde(rename = "consistencyPoints", default, skip_serializing_if = "Option::is_none")]
    pub consistency_points: Option<serde_json::Value>,
    #[serde(rename = "diskResized", default, skip_serializing_if = "Option::is_none")]
    pub disk_resized: Option<String>,
    #[serde(rename = "rebootAfterUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub reboot_after_update_status: Option<String>,
    #[serde(rename = "multiVmGroupId", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_id: Option<String>,
    #[serde(rename = "multiVmGroupName", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_name: Option<String>,
    #[serde(rename = "multiVmSyncStatus", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_status: Option<String>,
    #[serde(rename = "agentDetails", default, skip_serializing_if = "Option::is_none")]
    pub agent_details: Option<InMageAgentDetails>,
    #[serde(rename = "vCenterInfrastructureId", default, skip_serializing_if = "Option::is_none")]
    pub v_center_infrastructure_id: Option<String>,
    #[serde(rename = "infrastructureVmId", default, skip_serializing_if = "Option::is_none")]
    pub infrastructure_vm_id: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicDetails>,
    #[serde(rename = "discoveryType", default, skip_serializing_if = "Option::is_none")]
    pub discovery_type: Option<String>,
    #[serde(rename = "azureStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub azure_storage_account_id: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datastores: Vec<String>,
    #[serde(rename = "validationErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_errors: Vec<HealthError>,
    #[serde(rename = "lastRpoCalculatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_rpo_calculated_time: Option<String>,
    #[serde(rename = "lastUpdateReceivedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_update_received_time: Option<String>,
    #[serde(rename = "replicaId", default, skip_serializing_if = "Option::is_none")]
    pub replica_id: Option<String>,
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[serde(rename = "isAdditionalStatsAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_additional_stats_available: Option<bool>,
    #[serde(rename = "totalDataTransferred", default, skip_serializing_if = "Option::is_none")]
    pub total_data_transferred: Option<i64>,
    #[serde(rename = "totalProgressHealth", default, skip_serializing_if = "Option::is_none")]
    pub total_progress_health: Option<String>,
}
impl InMageReplicationDetails {
    pub fn new(replication_provider_specific_settings: ReplicationProviderSpecificSettings) -> Self {
        Self {
            replication_provider_specific_settings,
            active_site_type: None,
            source_vm_cpu_count: None,
            source_vm_ram_size_in_mb: None,
            os_details: None,
            protection_stage: None,
            vm_id: None,
            vm_protection_state: None,
            vm_protection_state_description: None,
            resync_details: None,
            retention_window_start: None,
            retention_window_end: None,
            compressed_data_rate_in_mb: None,
            uncompressed_data_rate_in_mb: None,
            rpo_in_seconds: None,
            protected_disks: Vec::new(),
            ip_address: None,
            last_heartbeat: None,
            process_server_id: None,
            master_target_id: None,
            consistency_points: None,
            disk_resized: None,
            reboot_after_update_status: None,
            multi_vm_group_id: None,
            multi_vm_group_name: None,
            multi_vm_sync_status: None,
            agent_details: None,
            v_center_infrastructure_id: None,
            infrastructure_vm_id: None,
            vm_nics: Vec::new(),
            discovery_type: None,
            azure_storage_account_id: None,
            datastores: Vec::new(),
            validation_errors: Vec::new(),
            last_rpo_calculated_time: None,
            last_update_received_time: None,
            replica_id: None,
            os_version: None,
            is_additional_stats_available: None,
            total_data_transferred: None,
            total_progress_health: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageReprotectInput {
    #[serde(flatten)]
    pub reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
    #[serde(rename = "masterTargetId")]
    pub master_target_id: String,
    #[serde(rename = "processServerId")]
    pub process_server_id: String,
    #[serde(rename = "retentionDrive")]
    pub retention_drive: String,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[serde(rename = "datastoreName", default, skip_serializing_if = "Option::is_none")]
    pub datastore_name: Option<String>,
    #[serde(rename = "diskExclusionInput", default, skip_serializing_if = "Option::is_none")]
    pub disk_exclusion_input: Option<InMageDiskExclusionInput>,
    #[serde(rename = "profileId")]
    pub profile_id: String,
    #[serde(rename = "disksToInclude", default, skip_serializing_if = "Vec::is_empty")]
    pub disks_to_include: Vec<String>,
}
impl InMageReprotectInput {
    pub fn new(
        reverse_replication_provider_specific_input: ReverseReplicationProviderSpecificInput,
        master_target_id: String,
        process_server_id: String,
        retention_drive: String,
        profile_id: String,
    ) -> Self {
        Self {
            reverse_replication_provider_specific_input,
            master_target_id,
            process_server_id,
            retention_drive,
            run_as_account_id: None,
            datastore_name: None,
            disk_exclusion_input: None,
            profile_id,
            disks_to_include: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageTestFailoverInput {
    #[serde(flatten)]
    pub test_failover_provider_specific_input: TestFailoverProviderSpecificInput,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<in_mage_test_failover_input::RecoveryPointType>,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl InMageTestFailoverInput {
    pub fn new(test_failover_provider_specific_input: TestFailoverProviderSpecificInput) -> Self {
        Self {
            test_failover_provider_specific_input,
            recovery_point_type: None,
            recovery_point_id: None,
        }
    }
}
pub mod in_mage_test_failover_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        LatestTime,
        LatestTag,
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InMageUnplannedFailoverInput {
    #[serde(flatten)]
    pub unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<in_mage_unplanned_failover_input::RecoveryPointType>,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
}
impl InMageUnplannedFailoverInput {
    pub fn new(unplanned_failover_provider_specific_input: UnplannedFailoverProviderSpecificInput) -> Self {
        Self {
            unplanned_failover_provider_specific_input,
            recovery_point_type: None,
            recovery_point_id: None,
        }
    }
}
pub mod in_mage_unplanned_failover_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        LatestTime,
        LatestTag,
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InMageVolumeExclusionOptions {
    #[serde(rename = "volumeLabel", default, skip_serializing_if = "Option::is_none")]
    pub volume_label: Option<String>,
    #[serde(rename = "onlyExcludeIfSingleVolume", default, skip_serializing_if = "Option::is_none")]
    pub only_exclude_if_single_volume: Option<String>,
}
impl InMageVolumeExclusionOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InconsistentVmDetails {
    #[serde(rename = "vmName", default, skip_serializing_if = "Option::is_none")]
    pub vm_name: Option<String>,
    #[serde(rename = "cloudName", default, skip_serializing_if = "Option::is_none")]
    pub cloud_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<String>,
    #[serde(rename = "errorIds", default, skip_serializing_if = "Vec::is_empty")]
    pub error_ids: Vec<String>,
}
impl InconsistentVmDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InitialReplicationDetails {
    #[serde(rename = "initialReplicationType", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_type: Option<String>,
    #[serde(rename = "initialReplicationProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub initial_replication_progress_percentage: Option<String>,
}
impl InitialReplicationDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InlineWorkflowTaskDetails {
    #[serde(flatten)]
    pub group_task_details: GroupTaskDetails,
    #[serde(rename = "workflowIds", default, skip_serializing_if = "Vec::is_empty")]
    pub workflow_ids: Vec<String>,
}
impl InlineWorkflowTaskDetails {
    pub fn new(group_task_details: GroupTaskDetails) -> Self {
        Self {
            group_task_details,
            workflow_ids: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InnerHealthError {
    #[serde(rename = "errorSource", default, skip_serializing_if = "Option::is_none")]
    pub error_source: Option<String>,
    #[serde(rename = "errorType", default, skip_serializing_if = "Option::is_none")]
    pub error_type: Option<String>,
    #[serde(rename = "errorLevel", default, skip_serializing_if = "Option::is_none")]
    pub error_level: Option<String>,
    #[serde(rename = "errorCategory", default, skip_serializing_if = "Option::is_none")]
    pub error_category: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(rename = "summaryMessage", default, skip_serializing_if = "Option::is_none")]
    pub summary_message: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
    #[serde(rename = "creationTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub creation_time_utc: Option<String>,
    #[serde(rename = "recoveryProviderErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub recovery_provider_error_message: Option<String>,
    #[serde(rename = "entityId", default, skip_serializing_if = "Option::is_none")]
    pub entity_id: Option<String>,
    #[serde(rename = "errorId", default, skip_serializing_if = "Option::is_none")]
    pub error_id: Option<String>,
    #[serde(rename = "customerResolvability", default, skip_serializing_if = "Option::is_none")]
    pub customer_resolvability: Option<inner_health_error::CustomerResolvability>,
}
impl InnerHealthError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod inner_health_error {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CustomerResolvability {
        Allowed,
        NotAllowed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InputEndpoint {
    #[serde(rename = "endpointName", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    #[serde(rename = "privatePort", default, skip_serializing_if = "Option::is_none")]
    pub private_port: Option<i32>,
    #[serde(rename = "publicPort", default, skip_serializing_if = "Option::is_none")]
    pub public_port: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<String>,
}
impl InputEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Job {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<JobProperties>,
}
impl Job {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Job>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
    #[serde(rename = "affectedObjectDetails", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_details: Option<serde_json::Value>,
}
impl JobDetails {
    pub fn new(instance_type: String) -> Self {
        Self {
            instance_type,
            affected_object_details: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobEntity {
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "jobFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub job_friendly_name: Option<String>,
    #[serde(rename = "targetObjectId", default, skip_serializing_if = "Option::is_none")]
    pub target_object_id: Option<String>,
    #[serde(rename = "targetObjectName", default, skip_serializing_if = "Option::is_none")]
    pub target_object_name: Option<String>,
    #[serde(rename = "targetInstanceType", default, skip_serializing_if = "Option::is_none")]
    pub target_instance_type: Option<String>,
    #[serde(rename = "jobScenarioName", default, skip_serializing_if = "Option::is_none")]
    pub job_scenario_name: Option<String>,
}
impl JobEntity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobErrorDetails {
    #[serde(rename = "serviceErrorDetails", default, skip_serializing_if = "Option::is_none")]
    pub service_error_details: Option<ServiceError>,
    #[serde(rename = "providerErrorDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_error_details: Option<ProviderError>,
    #[serde(rename = "errorLevel", default, skip_serializing_if = "Option::is_none")]
    pub error_level: Option<String>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
}
impl JobErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobProperties {
    #[serde(rename = "activityId", default, skip_serializing_if = "Option::is_none")]
    pub activity_id: Option<String>,
    #[serde(rename = "scenarioName", default, skip_serializing_if = "Option::is_none")]
    pub scenario_name: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "stateDescription", default, skip_serializing_if = "Option::is_none")]
    pub state_description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub tasks: Vec<AsrTask>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<JobErrorDetails>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "allowedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_actions: Vec<String>,
    #[serde(rename = "targetObjectId", default, skip_serializing_if = "Option::is_none")]
    pub target_object_id: Option<String>,
    #[serde(rename = "targetObjectName", default, skip_serializing_if = "Option::is_none")]
    pub target_object_name: Option<String>,
    #[serde(rename = "targetInstanceType", default, skip_serializing_if = "Option::is_none")]
    pub target_instance_type: Option<String>,
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<JobDetails>,
}
impl JobProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobQueryParameter {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "fabricId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_id: Option<String>,
    #[serde(rename = "affectedObjectTypes", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_types: Option<String>,
    #[serde(rename = "jobStatus", default, skip_serializing_if = "Option::is_none")]
    pub job_status: Option<String>,
    #[serde(rename = "jobOutputType", default, skip_serializing_if = "Option::is_none")]
    pub job_output_type: Option<job_query_parameter::JobOutputType>,
    #[serde(rename = "jobName", default, skip_serializing_if = "Option::is_none")]
    pub job_name: Option<String>,
    #[serde(rename = "timezoneOffset", default, skip_serializing_if = "Option::is_none")]
    pub timezone_offset: Option<f64>,
}
impl JobQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_query_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum JobOutputType {
        Json,
        Xml,
        Excel,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobStatusEventDetails {
    #[serde(flatten)]
    pub event_specific_details: EventSpecificDetails,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "jobFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub job_friendly_name: Option<String>,
    #[serde(rename = "jobStatus", default, skip_serializing_if = "Option::is_none")]
    pub job_status: Option<String>,
    #[serde(rename = "affectedObjectType", default, skip_serializing_if = "Option::is_none")]
    pub affected_object_type: Option<String>,
}
impl JobStatusEventDetails {
    pub fn new(event_specific_details: EventSpecificDetails) -> Self {
        Self {
            event_specific_details,
            job_id: None,
            job_friendly_name: None,
            job_status: None,
            affected_object_type: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[serde(rename = "jobTask", default, skip_serializing_if = "Option::is_none")]
    pub job_task: Option<JobEntity>,
}
impl JobTaskDetails {
    pub fn new(task_type_details: TaskTypeDetails) -> Self {
        Self {
            task_type_details,
            job_task: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyEncryptionKeyInfo {
    #[serde(rename = "keyIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub key_identifier: Option<String>,
    #[serde(rename = "keyVaultResourceArmId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_resource_arm_id: Option<String>,
}
impl KeyEncryptionKeyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogicalNetwork {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LogicalNetworkProperties>,
}
impl LogicalNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogicalNetworkCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LogicalNetwork>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LogicalNetworkCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogicalNetworkProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "networkVirtualizationStatus", default, skip_serializing_if = "Option::is_none")]
    pub network_virtualization_status: Option<String>,
    #[serde(rename = "logicalNetworkUsage", default, skip_serializing_if = "Option::is_none")]
    pub logical_network_usage: Option<String>,
    #[serde(rename = "logicalNetworkDefinitionsStatus", default, skip_serializing_if = "Option::is_none")]
    pub logical_network_definitions_status: Option<String>,
}
impl LogicalNetworkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManualActionTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub instructions: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub observation: Option<String>,
}
impl ManualActionTaskDetails {
    pub fn new(task_type_details: TaskTypeDetails) -> Self {
        Self {
            task_type_details,
            name: None,
            instructions: None,
            observation: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MarsAgentDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<mars_agent_details::Health>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
}
impl MarsAgentDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod mars_agent_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MasterTargetServer {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[serde(rename = "versionStatus", default, skip_serializing_if = "Option::is_none")]
    pub version_status: Option<String>,
    #[serde(rename = "retentionVolumes", default, skip_serializing_if = "Vec::is_empty")]
    pub retention_volumes: Vec<RetentionVolume>,
    #[serde(rename = "dataStores", default, skip_serializing_if = "Vec::is_empty")]
    pub data_stores: Vec<DataStore>,
    #[serde(rename = "validationErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_errors: Vec<HealthError>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[serde(rename = "diskCount", default, skip_serializing_if = "Option::is_none")]
    pub disk_count: Option<i32>,
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
    #[serde(rename = "marsAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub mars_agent_version: Option<String>,
    #[serde(rename = "marsAgentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub mars_agent_expiry_date: Option<String>,
    #[serde(rename = "agentVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub agent_version_details: Option<VersionDetails>,
    #[serde(rename = "marsAgentVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub mars_agent_version_details: Option<VersionDetails>,
}
impl MasterTargetServer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MigrateInput {
    pub properties: MigrateInputProperties,
}
impl MigrateInput {
    pub fn new(properties: MigrateInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MigrateInputProperties {
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: MigrateProviderSpecificInput,
}
impl MigrateInputProperties {
    pub fn new(provider_specific_details: MigrateProviderSpecificInput) -> Self {
        Self { provider_specific_details }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MigrateProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl MigrateProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MigrationItemProperties>,
}
impl MigrationItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationItemCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MigrationItem>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MigrationItemCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationItemProperties {
    #[serde(rename = "machineName", default, skip_serializing_if = "Option::is_none")]
    pub machine_name: Option<String>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(rename = "policyFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_friendly_name: Option<String>,
    #[serde(rename = "migrationState", default, skip_serializing_if = "Option::is_none")]
    pub migration_state: Option<migration_item_properties::MigrationState>,
    #[serde(rename = "migrationStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub migration_state_description: Option<String>,
    #[serde(rename = "lastTestMigrationTime", default, skip_serializing_if = "Option::is_none")]
    pub last_test_migration_time: Option<String>,
    #[serde(rename = "lastTestMigrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_test_migration_status: Option<String>,
    #[serde(rename = "testMigrateState", default, skip_serializing_if = "Option::is_none")]
    pub test_migrate_state: Option<migration_item_properties::TestMigrateState>,
    #[serde(rename = "testMigrateStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub test_migrate_state_description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<migration_item_properties::Health>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[serde(rename = "allowedOperations", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_operations: Vec<String>,
    #[serde(rename = "currentJob", default, skip_serializing_if = "Option::is_none")]
    pub current_job: Option<CurrentJobDetails>,
    #[serde(rename = "eventCorrelationId", default, skip_serializing_if = "Option::is_none")]
    pub event_correlation_id: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<MigrationProviderSpecificSettings>,
}
impl MigrationItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod migration_item_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MigrationState {
        None,
        EnableMigrationInProgress,
        EnableMigrationFailed,
        DisableMigrationInProgress,
        DisableMigrationFailed,
        InitialSeedingInProgress,
        InitialSeedingFailed,
        Replicating,
        MigrationInProgress,
        MigrationSucceeded,
        MigrationFailed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TestMigrateState {
        None,
        TestMigrationInProgress,
        TestMigrationSucceeded,
        TestMigrationFailed,
        TestMigrationCleanupInProgress,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationItemsQueryParameter {
    #[serde(rename = "sourceFabricName", default, skip_serializing_if = "Option::is_none")]
    pub source_fabric_name: Option<String>,
    #[serde(rename = "sourceContainerName", default, skip_serializing_if = "Option::is_none")]
    pub source_container_name: Option<String>,
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl MigrationItemsQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MigrationProviderSpecificSettings {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl MigrationProviderSpecificSettings {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationRecoveryPoint {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MigrationRecoveryPointProperties>,
}
impl MigrationRecoveryPoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationRecoveryPointCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<MigrationRecoveryPoint>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MigrationRecoveryPointCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MigrationRecoveryPointProperties {
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<migration_recovery_point_properties::RecoveryPointType>,
}
impl MigrationRecoveryPointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod migration_recovery_point_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        NotSpecified,
        ApplicationConsistent,
        CrashConsistent,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MobilityServiceUpdate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "rebootStatus", default, skip_serializing_if = "Option::is_none")]
    pub reboot_status: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
}
impl MobilityServiceUpdate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Network {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkProperties>,
}
impl Network {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Network>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkMapping {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkMappingProperties>,
}
impl NetworkMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkMappingCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkMapping>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkMappingCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkMappingFabricSpecificSettings {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl NetworkMappingFabricSpecificSettings {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkMappingProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "primaryNetworkFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub primary_network_friendly_name: Option<String>,
    #[serde(rename = "primaryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub primary_network_id: Option<String>,
    #[serde(rename = "primaryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_friendly_name: Option<String>,
    #[serde(rename = "recoveryNetworkFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_network_friendly_name: Option<String>,
    #[serde(rename = "recoveryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_network_id: Option<String>,
    #[serde(rename = "recoveryFabricArmId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_arm_id: Option<String>,
    #[serde(rename = "recoveryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_friendly_name: Option<String>,
    #[serde(rename = "fabricSpecificSettings", default, skip_serializing_if = "Option::is_none")]
    pub fabric_specific_settings: Option<NetworkMappingFabricSpecificSettings>,
}
impl NetworkMappingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProperties {
    #[serde(rename = "fabricType", default, skip_serializing_if = "Option::is_none")]
    pub fabric_type: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "networkType", default, skip_serializing_if = "Option::is_none")]
    pub network_type: Option<String>,
}
impl NetworkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NewProtectionProfile {
    #[serde(flatten)]
    pub protection_profile_custom_details: ProtectionProfileCustomDetails,
    #[serde(rename = "policyName")]
    pub policy_name: String,
    #[serde(rename = "recoveryPointHistory", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history: Option<i32>,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "multiVmSyncStatus")]
    pub multi_vm_sync_status: new_protection_profile::MultiVmSyncStatus,
}
impl NewProtectionProfile {
    pub fn new(
        protection_profile_custom_details: ProtectionProfileCustomDetails,
        policy_name: String,
        multi_vm_sync_status: new_protection_profile::MultiVmSyncStatus,
    ) -> Self {
        Self {
            protection_profile_custom_details,
            policy_name,
            recovery_point_history: None,
            crash_consistent_frequency_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
            multi_vm_sync_status,
        }
    }
}
pub mod new_protection_profile {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncStatus {
        Enable,
        Disable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NewRecoveryVirtualNetwork {
    #[serde(flatten)]
    pub recovery_virtual_network_custom_details: RecoveryVirtualNetworkCustomDetails,
    #[serde(
        rename = "recoveryVirtualNetworkResourceGroupName",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub recovery_virtual_network_resource_group_name: Option<String>,
    #[serde(rename = "recoveryVirtualNetworkName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_virtual_network_name: Option<String>,
}
impl NewRecoveryVirtualNetwork {
    pub fn new(recovery_virtual_network_custom_details: RecoveryVirtualNetworkCustomDetails) -> Self {
        Self {
            recovery_virtual_network_custom_details,
            recovery_virtual_network_resource_group_name: None,
            recovery_virtual_network_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsDetails {
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "productType", default, skip_serializing_if = "Option::is_none")]
    pub product_type: Option<String>,
    #[serde(rename = "osEdition", default, skip_serializing_if = "Option::is_none")]
    pub os_edition: Option<String>,
    #[serde(rename = "oSVersion", default, skip_serializing_if = "Option::is_none")]
    pub o_s_version: Option<String>,
    #[serde(rename = "oSMajorVersion", default, skip_serializing_if = "Option::is_none")]
    pub o_s_major_version: Option<String>,
    #[serde(rename = "oSMinorVersion", default, skip_serializing_if = "Option::is_none")]
    pub o_s_minor_version: Option<String>,
}
impl OsDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsDiskDetails {
    #[serde(rename = "osVhdId", default, skip_serializing_if = "Option::is_none")]
    pub os_vhd_id: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "vhdName", default, skip_serializing_if = "Option::is_none")]
    pub vhd_name: Option<String>,
}
impl OsDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsVersionWrapper {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "servicePack", default, skip_serializing_if = "Option::is_none")]
    pub service_pack: Option<String>,
}
impl OsVersionWrapper {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsDiscovery {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationsDiscoveryProperties>,
}
impl OperationsDiscovery {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsDiscoveryCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OperationsDiscovery>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationsDiscoveryCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsDiscoveryProperties {}
impl OperationsDiscoveryProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PlannedFailoverInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PlannedFailoverInputProperties>,
}
impl PlannedFailoverInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PlannedFailoverInputProperties {
    #[serde(rename = "failoverDirection", default, skip_serializing_if = "Option::is_none")]
    pub failover_direction: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<PlannedFailoverProviderSpecificFailoverInput>,
}
impl PlannedFailoverInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PlannedFailoverProviderSpecificFailoverInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl PlannedFailoverProviderSpecificFailoverInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Policy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PolicyProperties>,
}
impl Policy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Policy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PolicyCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<PolicyProviderSpecificDetails>,
}
impl PolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PolicyProviderSpecificDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl PolicyProviderSpecificDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PolicyProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl PolicyProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessServer {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[serde(rename = "versionStatus", default, skip_serializing_if = "Option::is_none")]
    pub version_status: Option<String>,
    #[serde(rename = "mobilityServiceUpdates", default, skip_serializing_if = "Vec::is_empty")]
    pub mobility_service_updates: Vec<MobilityServiceUpdate>,
    #[serde(rename = "hostId", default, skip_serializing_if = "Option::is_none")]
    pub host_id: Option<String>,
    #[serde(rename = "machineCount", default, skip_serializing_if = "Option::is_none")]
    pub machine_count: Option<String>,
    #[serde(rename = "replicationPairCount", default, skip_serializing_if = "Option::is_none")]
    pub replication_pair_count: Option<String>,
    #[serde(rename = "systemLoad", default, skip_serializing_if = "Option::is_none")]
    pub system_load: Option<String>,
    #[serde(rename = "systemLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub system_load_status: Option<String>,
    #[serde(rename = "cpuLoad", default, skip_serializing_if = "Option::is_none")]
    pub cpu_load: Option<String>,
    #[serde(rename = "cpuLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub cpu_load_status: Option<String>,
    #[serde(rename = "totalMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_memory_in_bytes: Option<i64>,
    #[serde(rename = "availableMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_memory_in_bytes: Option<i64>,
    #[serde(rename = "memoryUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub memory_usage_status: Option<String>,
    #[serde(rename = "totalSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_space_in_bytes: Option<i64>,
    #[serde(rename = "availableSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_space_in_bytes: Option<i64>,
    #[serde(rename = "spaceUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub space_usage_status: Option<String>,
    #[serde(rename = "psServiceStatus", default, skip_serializing_if = "Option::is_none")]
    pub ps_service_status: Option<String>,
    #[serde(rename = "sslCertExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_expiry_date: Option<String>,
    #[serde(rename = "sslCertExpiryRemainingDays", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_expiry_remaining_days: Option<i32>,
    #[serde(rename = "osVersion", default, skip_serializing_if = "Option::is_none")]
    pub os_version: Option<String>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
    #[serde(rename = "agentVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub agent_version_details: Option<VersionDetails>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<process_server::Health>,
    #[serde(rename = "psStatsRefreshTime", default, skip_serializing_if = "Option::is_none")]
    pub ps_stats_refresh_time: Option<String>,
    #[serde(rename = "throughputUploadPendingDataInBytes", default, skip_serializing_if = "Option::is_none")]
    pub throughput_upload_pending_data_in_bytes: Option<i64>,
    #[serde(rename = "throughputInMBps", default, skip_serializing_if = "Option::is_none")]
    pub throughput_in_m_bps: Option<i64>,
    #[serde(rename = "throughputInBytes", default, skip_serializing_if = "Option::is_none")]
    pub throughput_in_bytes: Option<i64>,
    #[serde(rename = "throughputStatus", default, skip_serializing_if = "Option::is_none")]
    pub throughput_status: Option<String>,
    #[serde(rename = "marsCommunicationStatus", default, skip_serializing_if = "Option::is_none")]
    pub mars_communication_status: Option<String>,
    #[serde(rename = "marsRegistrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub mars_registration_status: Option<String>,
}
impl ProcessServer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod process_server {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProcessServerDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(rename = "totalMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_memory_in_bytes: Option<i64>,
    #[serde(rename = "availableMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_memory_in_bytes: Option<i64>,
    #[serde(rename = "usedMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub used_memory_in_bytes: Option<i64>,
    #[serde(rename = "memoryUsagePercentage", default, skip_serializing_if = "Option::is_none")]
    pub memory_usage_percentage: Option<f64>,
    #[serde(rename = "totalSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_space_in_bytes: Option<i64>,
    #[serde(rename = "availableSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_space_in_bytes: Option<i64>,
    #[serde(rename = "usedSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub used_space_in_bytes: Option<i64>,
    #[serde(rename = "freeSpacePercentage", default, skip_serializing_if = "Option::is_none")]
    pub free_space_percentage: Option<f64>,
    #[serde(rename = "throughputUploadPendingDataInBytes", default, skip_serializing_if = "Option::is_none")]
    pub throughput_upload_pending_data_in_bytes: Option<i64>,
    #[serde(rename = "throughputInBytes", default, skip_serializing_if = "Option::is_none")]
    pub throughput_in_bytes: Option<i64>,
    #[serde(rename = "processorUsagePercentage", default, skip_serializing_if = "Option::is_none")]
    pub processor_usage_percentage: Option<f64>,
    #[serde(rename = "throughputStatus", default, skip_serializing_if = "Option::is_none")]
    pub throughput_status: Option<process_server_details::ThroughputStatus>,
    #[serde(rename = "systemLoad", default, skip_serializing_if = "Option::is_none")]
    pub system_load: Option<i64>,
    #[serde(rename = "systemLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub system_load_status: Option<process_server_details::SystemLoadStatus>,
    #[serde(rename = "diskUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub disk_usage_status: Option<process_server_details::DiskUsageStatus>,
    #[serde(rename = "memoryUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub memory_usage_status: Option<process_server_details::MemoryUsageStatus>,
    #[serde(rename = "processorUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub processor_usage_status: Option<process_server_details::ProcessorUsageStatus>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<process_server_details::Health>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i32>,
    #[serde(rename = "historicHealth", default, skip_serializing_if = "Option::is_none")]
    pub historic_health: Option<process_server_details::HistoricHealth>,
}
impl ProcessServerDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod process_server_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ThroughputStatus {
        Healthy,
        Warning,
        Critical,
        Unknown,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SystemLoadStatus {
        Healthy,
        Warning,
        Critical,
        Unknown,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskUsageStatus {
        Healthy,
        Warning,
        Critical,
        Unknown,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MemoryUsageStatus {
        Healthy,
        Warning,
        Critical,
        Unknown,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProcessorUsageStatus {
        Healthy,
        Warning,
        Critical,
        Unknown,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HistoricHealth {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectableItemProperties>,
}
impl ProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableItemCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectableItem>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProtectableItemCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableItemProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[serde(rename = "replicationProtectedItemId", default, skip_serializing_if = "Option::is_none")]
    pub replication_protected_item_id: Option<String>,
    #[serde(rename = "recoveryServicesProviderId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_services_provider_id: Option<String>,
    #[serde(rename = "protectionReadinessErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub protection_readiness_errors: Vec<String>,
    #[serde(rename = "supportedReplicationProviders", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_replication_providers: Vec<String>,
    #[serde(rename = "customDetails", default, skip_serializing_if = "Option::is_none")]
    pub custom_details: Option<ConfigurationSettings>,
}
impl ProtectableItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableItemQueryParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}
impl ProtectableItemQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectedItemsQueryParameter {
    #[serde(rename = "sourceFabricName", default, skip_serializing_if = "Option::is_none")]
    pub source_fabric_name: Option<String>,
    #[serde(rename = "recoveryPlanName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_plan_name: Option<String>,
    #[serde(rename = "sourceFabricLocation", default, skip_serializing_if = "Option::is_none")]
    pub source_fabric_location: Option<String>,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(rename = "vCenterName", default, skip_serializing_if = "Option::is_none")]
    pub v_center_name: Option<String>,
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    #[serde(rename = "multiVmGroupCreateOption", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_group_create_option: Option<protected_items_query_parameter::MultiVmGroupCreateOption>,
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
}
impl ProtectedItemsQueryParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protected_items_query_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmGroupCreateOption {
        AutoCreated,
        UserSpecified,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainer {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectionContainerProperties>,
}
impl ProtectionContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectionContainer>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProtectionContainerCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerFabricSpecificDetails {
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ProtectionContainerFabricSpecificDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerMapping {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectionContainerMappingProperties>,
}
impl ProtectionContainerMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerMappingCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectionContainerMapping>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProtectionContainerMappingCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerMappingProperties {
    #[serde(rename = "targetProtectionContainerId", default, skip_serializing_if = "Option::is_none")]
    pub target_protection_container_id: Option<String>,
    #[serde(rename = "targetProtectionContainerFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub target_protection_container_friendly_name: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ProtectionContainerMappingProviderSpecificDetails>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<String>,
    #[serde(rename = "healthErrorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub health_error_details: Vec<HealthError>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "sourceProtectionContainerFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub source_protection_container_friendly_name: Option<String>,
    #[serde(rename = "sourceFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub source_fabric_friendly_name: Option<String>,
    #[serde(rename = "targetFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub target_fabric_friendly_name: Option<String>,
    #[serde(rename = "policyFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_friendly_name: Option<String>,
}
impl ProtectionContainerMappingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProtectionContainerMappingProviderSpecificDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ProtectionContainerMappingProviderSpecificDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerProperties {
    #[serde(rename = "fabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_friendly_name: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "fabricType", default, skip_serializing_if = "Option::is_none")]
    pub fabric_type: Option<String>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i32>,
    #[serde(rename = "pairingStatus", default, skip_serializing_if = "Option::is_none")]
    pub pairing_status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub role: Option<String>,
    #[serde(rename = "fabricSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub fabric_specific_details: Option<ProtectionContainerFabricSpecificDetails>,
}
impl ProtectionContainerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProtectionProfileCustomDetails {
    #[serde(rename = "resourceType")]
    pub resource_type: String,
}
impl ProtectionProfileCustomDetails {
    pub fn new(resource_type: String) -> Self {
        Self { resource_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderError {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "errorId", default, skip_serializing_if = "Option::is_none")]
    pub error_id: Option<String>,
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
}
impl ProviderError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProviderSpecificRecoveryPointDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ProviderSpecificRecoveryPointDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PushInstallerDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<push_installer_details::Health>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
}
impl PushInstallerDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod push_installer_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RcmProxyDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "clientAuthenticationType", default, skip_serializing_if = "Option::is_none")]
    pub client_authentication_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<rcm_proxy_details::Health>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
}
impl RcmProxyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod rcm_proxy_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryAvailabilitySetCustomDetails {
    #[serde(rename = "resourceType")]
    pub resource_type: String,
}
impl RecoveryAvailabilitySetCustomDetails {
    pub fn new(resource_type: String) -> Self {
        Self { resource_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlan {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecoveryPlanProperties>,
}
impl RecoveryPlan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanA2aDetails {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_details: RecoveryPlanProviderSpecificDetails,
    #[serde(rename = "primaryZone", default, skip_serializing_if = "Option::is_none")]
    pub primary_zone: Option<String>,
    #[serde(rename = "recoveryZone", default, skip_serializing_if = "Option::is_none")]
    pub recovery_zone: Option<String>,
}
impl RecoveryPlanA2aDetails {
    pub fn new(recovery_plan_provider_specific_details: RecoveryPlanProviderSpecificDetails) -> Self {
        Self {
            recovery_plan_provider_specific_details,
            primary_zone: None,
            recovery_zone: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanA2aFailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[serde(rename = "recoveryPointType")]
    pub recovery_point_type: recovery_plan_a2a_failover_input::RecoveryPointType,
    #[serde(rename = "cloudServiceCreationOption", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_creation_option: Option<String>,
    #[serde(rename = "multiVmSyncPointOption", default, skip_serializing_if = "Option::is_none")]
    pub multi_vm_sync_point_option: Option<recovery_plan_a2a_failover_input::MultiVmSyncPointOption>,
}
impl RecoveryPlanA2aFailoverInput {
    pub fn new(
        recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
        recovery_point_type: recovery_plan_a2a_failover_input::RecoveryPointType,
    ) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input,
            recovery_point_type,
            cloud_service_creation_option: None,
            multi_vm_sync_point_option: None,
        }
    }
}
pub mod recovery_plan_a2a_failover_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        Latest,
        LatestApplicationConsistent,
        LatestCrashConsistent,
        LatestProcessed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MultiVmSyncPointOption {
        UseMultiVmSyncRecoveryPoint,
        UsePerVmRecoveryPoint,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanA2aInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_input: RecoveryPlanProviderSpecificInput,
    #[serde(rename = "primaryZone", default, skip_serializing_if = "Option::is_none")]
    pub primary_zone: Option<String>,
    #[serde(rename = "recoveryZone", default, skip_serializing_if = "Option::is_none")]
    pub recovery_zone: Option<String>,
}
impl RecoveryPlanA2aInput {
    pub fn new(recovery_plan_provider_specific_input: RecoveryPlanProviderSpecificInput) -> Self {
        Self {
            recovery_plan_provider_specific_input,
            primary_zone: None,
            recovery_zone: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanAction {
    #[serde(rename = "actionName")]
    pub action_name: String,
    #[serde(rename = "failoverTypes")]
    pub failover_types: Vec<String>,
    #[serde(rename = "failoverDirections")]
    pub failover_directions: Vec<String>,
    #[serde(rename = "customDetails")]
    pub custom_details: RecoveryPlanActionDetails,
}
impl RecoveryPlanAction {
    pub fn new(
        action_name: String,
        failover_types: Vec<String>,
        failover_directions: Vec<String>,
        custom_details: RecoveryPlanActionDetails,
    ) -> Self {
        Self {
            action_name,
            failover_types,
            failover_directions,
            custom_details,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanActionDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl RecoveryPlanActionDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanAutomationRunbookActionDetails {
    #[serde(flatten)]
    pub recovery_plan_action_details: RecoveryPlanActionDetails,
    #[serde(rename = "runbookId", default, skip_serializing_if = "Option::is_none")]
    pub runbook_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
    #[serde(rename = "fabricLocation")]
    pub fabric_location: recovery_plan_automation_runbook_action_details::FabricLocation,
}
impl RecoveryPlanAutomationRunbookActionDetails {
    pub fn new(
        recovery_plan_action_details: RecoveryPlanActionDetails,
        fabric_location: recovery_plan_automation_runbook_action_details::FabricLocation,
    ) -> Self {
        Self {
            recovery_plan_action_details,
            runbook_id: None,
            timeout: None,
            fabric_location,
        }
    }
}
pub mod recovery_plan_automation_runbook_action_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FabricLocation {
        Primary,
        Recovery,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecoveryPlan>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecoveryPlanCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanGroup {
    #[serde(rename = "groupType")]
    pub group_type: recovery_plan_group::GroupType,
    #[serde(rename = "replicationProtectedItems", default, skip_serializing_if = "Vec::is_empty")]
    pub replication_protected_items: Vec<RecoveryPlanProtectedItem>,
    #[serde(rename = "startGroupActions", default, skip_serializing_if = "Vec::is_empty")]
    pub start_group_actions: Vec<RecoveryPlanAction>,
    #[serde(rename = "endGroupActions", default, skip_serializing_if = "Vec::is_empty")]
    pub end_group_actions: Vec<RecoveryPlanAction>,
}
impl RecoveryPlanGroup {
    pub fn new(group_type: recovery_plan_group::GroupType) -> Self {
        Self {
            group_type,
            replication_protected_items: Vec::new(),
            start_group_actions: Vec::new(),
            end_group_actions: Vec::new(),
        }
    }
}
pub mod recovery_plan_group {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GroupType {
        Shutdown,
        Boot,
        Failover,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanGroupTaskDetails {
    #[serde(flatten)]
    pub group_task_details: GroupTaskDetails,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "rpGroupType", default, skip_serializing_if = "Option::is_none")]
    pub rp_group_type: Option<String>,
}
impl RecoveryPlanGroupTaskDetails {
    pub fn new(group_task_details: GroupTaskDetails) -> Self {
        Self {
            group_task_details,
            name: None,
            group_id: None,
            rp_group_type: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanHyperVReplicaAzureFailbackInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[serde(rename = "dataSyncOption")]
    pub data_sync_option: recovery_plan_hyper_v_replica_azure_failback_input::DataSyncOption,
    #[serde(rename = "recoveryVmCreationOption")]
    pub recovery_vm_creation_option: recovery_plan_hyper_v_replica_azure_failback_input::RecoveryVmCreationOption,
}
impl RecoveryPlanHyperVReplicaAzureFailbackInput {
    pub fn new(
        recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
        data_sync_option: recovery_plan_hyper_v_replica_azure_failback_input::DataSyncOption,
        recovery_vm_creation_option: recovery_plan_hyper_v_replica_azure_failback_input::RecoveryVmCreationOption,
    ) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input,
            data_sync_option,
            recovery_vm_creation_option,
        }
    }
}
pub mod recovery_plan_hyper_v_replica_azure_failback_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSyncOption {
        ForDownTime,
        ForSynchronization,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryVmCreationOption {
        CreateVmIfNotFound,
        NoAction,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanHyperVReplicaAzureFailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[serde(rename = "primaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub primary_kek_certificate_pfx: Option<String>,
    #[serde(rename = "secondaryKekCertificatePfx", default, skip_serializing_if = "Option::is_none")]
    pub secondary_kek_certificate_pfx: Option<String>,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<recovery_plan_hyper_v_replica_azure_failover_input::RecoveryPointType>,
}
impl RecoveryPlanHyperVReplicaAzureFailoverInput {
    pub fn new(recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input,
            primary_kek_certificate_pfx: None,
            secondary_kek_certificate_pfx: None,
            recovery_point_type: None,
        }
    }
}
pub mod recovery_plan_hyper_v_replica_azure_failover_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        Latest,
        LatestApplicationConsistent,
        LatestProcessed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanInMageAzureV2FailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[serde(rename = "recoveryPointType")]
    pub recovery_point_type: recovery_plan_in_mage_azure_v2_failover_input::RecoveryPointType,
    #[serde(rename = "useMultiVmSyncPoint", default, skip_serializing_if = "Option::is_none")]
    pub use_multi_vm_sync_point: Option<String>,
}
impl RecoveryPlanInMageAzureV2FailoverInput {
    pub fn new(
        recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
        recovery_point_type: recovery_plan_in_mage_azure_v2_failover_input::RecoveryPointType,
    ) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input,
            recovery_point_type,
            use_multi_vm_sync_point: None,
        }
    }
}
pub mod recovery_plan_in_mage_azure_v2_failover_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        Latest,
        LatestApplicationConsistent,
        LatestCrashConsistent,
        LatestProcessed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanInMageFailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[serde(rename = "recoveryPointType")]
    pub recovery_point_type: recovery_plan_in_mage_failover_input::RecoveryPointType,
}
impl RecoveryPlanInMageFailoverInput {
    pub fn new(
        recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
        recovery_point_type: recovery_plan_in_mage_failover_input::RecoveryPointType,
    ) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input,
            recovery_point_type,
        }
    }
}
pub mod recovery_plan_in_mage_failover_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        LatestTime,
        LatestTag,
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanInMageRcmFailbackFailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[serde(rename = "recoveryPointType")]
    pub recovery_point_type: recovery_plan_in_mage_rcm_failback_failover_input::RecoveryPointType,
    #[serde(rename = "useMultiVmSyncPoint", default, skip_serializing_if = "Option::is_none")]
    pub use_multi_vm_sync_point: Option<String>,
}
impl RecoveryPlanInMageRcmFailbackFailoverInput {
    pub fn new(
        recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
        recovery_point_type: recovery_plan_in_mage_rcm_failback_failover_input::RecoveryPointType,
    ) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input,
            recovery_point_type,
            use_multi_vm_sync_point: None,
        }
    }
}
pub mod recovery_plan_in_mage_rcm_failback_failover_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        ApplicationConsistent,
        CrashConsistent,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanInMageRcmFailoverInput {
    #[serde(flatten)]
    pub recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
    #[serde(rename = "recoveryPointType")]
    pub recovery_point_type: recovery_plan_in_mage_rcm_failover_input::RecoveryPointType,
    #[serde(rename = "useMultiVmSyncPoint", default, skip_serializing_if = "Option::is_none")]
    pub use_multi_vm_sync_point: Option<String>,
}
impl RecoveryPlanInMageRcmFailoverInput {
    pub fn new(
        recovery_plan_provider_specific_failover_input: RecoveryPlanProviderSpecificFailoverInput,
        recovery_point_type: recovery_plan_in_mage_rcm_failover_input::RecoveryPointType,
    ) -> Self {
        Self {
            recovery_plan_provider_specific_failover_input,
            recovery_point_type,
            use_multi_vm_sync_point: None,
        }
    }
}
pub mod recovery_plan_in_mage_rcm_failover_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryPointType {
        Latest,
        LatestApplicationConsistent,
        LatestCrashConsistent,
        LatestProcessed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanManualActionDetails {
    #[serde(flatten)]
    pub recovery_plan_action_details: RecoveryPlanActionDetails,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl RecoveryPlanManualActionDetails {
    pub fn new(recovery_plan_action_details: RecoveryPlanActionDetails) -> Self {
        Self {
            recovery_plan_action_details,
            description: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanPlannedFailoverInput {
    pub properties: RecoveryPlanPlannedFailoverInputProperties,
}
impl RecoveryPlanPlannedFailoverInput {
    pub fn new(properties: RecoveryPlanPlannedFailoverInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanPlannedFailoverInputProperties {
    #[serde(rename = "failoverDirection")]
    pub failover_direction: recovery_plan_planned_failover_input_properties::FailoverDirection,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_details: Vec<RecoveryPlanProviderSpecificFailoverInput>,
}
impl RecoveryPlanPlannedFailoverInputProperties {
    pub fn new(failover_direction: recovery_plan_planned_failover_input_properties::FailoverDirection) -> Self {
        Self {
            failover_direction,
            provider_specific_details: Vec::new(),
        }
    }
}
pub mod recovery_plan_planned_failover_input_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverDirection {
        PrimaryToRecovery,
        RecoveryToPrimary,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "primaryFabricId", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_id: Option<String>,
    #[serde(rename = "primaryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_friendly_name: Option<String>,
    #[serde(rename = "recoveryFabricId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_id: Option<String>,
    #[serde(rename = "recoveryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_friendly_name: Option<String>,
    #[serde(rename = "failoverDeploymentModel", default, skip_serializing_if = "Option::is_none")]
    pub failover_deployment_model: Option<String>,
    #[serde(rename = "replicationProviders", default, skip_serializing_if = "Vec::is_empty")]
    pub replication_providers: Vec<String>,
    #[serde(rename = "allowedOperations", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_operations: Vec<String>,
    #[serde(rename = "lastPlannedFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_planned_failover_time: Option<String>,
    #[serde(rename = "lastUnplannedFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_unplanned_failover_time: Option<String>,
    #[serde(rename = "lastTestFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_test_failover_time: Option<String>,
    #[serde(rename = "currentScenario", default, skip_serializing_if = "Option::is_none")]
    pub current_scenario: Option<CurrentScenarioDetails>,
    #[serde(rename = "currentScenarioStatus", default, skip_serializing_if = "Option::is_none")]
    pub current_scenario_status: Option<String>,
    #[serde(rename = "currentScenarioStatusDescription", default, skip_serializing_if = "Option::is_none")]
    pub current_scenario_status_description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groups: Vec<RecoveryPlanGroup>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_details: Vec<RecoveryPlanProviderSpecificDetails>,
}
impl RecoveryPlanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanProtectedItem {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
}
impl RecoveryPlanProtectedItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanProviderSpecificDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl RecoveryPlanProviderSpecificDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanProviderSpecificFailoverInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl RecoveryPlanProviderSpecificFailoverInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl RecoveryPlanProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanScriptActionDetails {
    #[serde(flatten)]
    pub recovery_plan_action_details: RecoveryPlanActionDetails,
    pub path: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
    #[serde(rename = "fabricLocation")]
    pub fabric_location: recovery_plan_script_action_details::FabricLocation,
}
impl RecoveryPlanScriptActionDetails {
    pub fn new(
        recovery_plan_action_details: RecoveryPlanActionDetails,
        path: String,
        fabric_location: recovery_plan_script_action_details::FabricLocation,
    ) -> Self {
        Self {
            recovery_plan_action_details,
            path,
            timeout: None,
            fabric_location,
        }
    }
}
pub mod recovery_plan_script_action_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FabricLocation {
        Primary,
        Recovery,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanShutdownGroupTaskDetails {
    #[serde(flatten)]
    pub recovery_plan_group_task_details: RecoveryPlanGroupTaskDetails,
}
impl RecoveryPlanShutdownGroupTaskDetails {
    pub fn new(recovery_plan_group_task_details: RecoveryPlanGroupTaskDetails) -> Self {
        Self {
            recovery_plan_group_task_details,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanTestFailoverCleanupInput {
    pub properties: RecoveryPlanTestFailoverCleanupInputProperties,
}
impl RecoveryPlanTestFailoverCleanupInput {
    pub fn new(properties: RecoveryPlanTestFailoverCleanupInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPlanTestFailoverCleanupInputProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
}
impl RecoveryPlanTestFailoverCleanupInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanTestFailoverInput {
    pub properties: RecoveryPlanTestFailoverInputProperties,
}
impl RecoveryPlanTestFailoverInput {
    pub fn new(properties: RecoveryPlanTestFailoverInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanTestFailoverInputProperties {
    #[serde(rename = "failoverDirection")]
    pub failover_direction: recovery_plan_test_failover_input_properties::FailoverDirection,
    #[serde(rename = "networkType")]
    pub network_type: String,
    #[serde(rename = "networkId", default, skip_serializing_if = "Option::is_none")]
    pub network_id: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_details: Vec<RecoveryPlanProviderSpecificFailoverInput>,
}
impl RecoveryPlanTestFailoverInputProperties {
    pub fn new(failover_direction: recovery_plan_test_failover_input_properties::FailoverDirection, network_type: String) -> Self {
        Self {
            failover_direction,
            network_type,
            network_id: None,
            provider_specific_details: Vec::new(),
        }
    }
}
pub mod recovery_plan_test_failover_input_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverDirection {
        PrimaryToRecovery,
        RecoveryToPrimary,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanUnplannedFailoverInput {
    pub properties: RecoveryPlanUnplannedFailoverInputProperties,
}
impl RecoveryPlanUnplannedFailoverInput {
    pub fn new(properties: RecoveryPlanUnplannedFailoverInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPlanUnplannedFailoverInputProperties {
    #[serde(rename = "failoverDirection")]
    pub failover_direction: recovery_plan_unplanned_failover_input_properties::FailoverDirection,
    #[serde(rename = "sourceSiteOperations")]
    pub source_site_operations: recovery_plan_unplanned_failover_input_properties::SourceSiteOperations,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_specific_details: Vec<RecoveryPlanProviderSpecificFailoverInput>,
}
impl RecoveryPlanUnplannedFailoverInputProperties {
    pub fn new(
        failover_direction: recovery_plan_unplanned_failover_input_properties::FailoverDirection,
        source_site_operations: recovery_plan_unplanned_failover_input_properties::SourceSiteOperations,
    ) -> Self {
        Self {
            failover_direction,
            source_site_operations,
            provider_specific_details: Vec::new(),
        }
    }
}
pub mod recovery_plan_unplanned_failover_input_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FailoverDirection {
        PrimaryToRecovery,
        RecoveryToPrimary,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceSiteOperations {
        Required,
        NotRequired,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPoint {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecoveryPointProperties>,
}
impl RecoveryPoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecoveryPoint>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecoveryPointCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointProperties {
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ProviderSpecificRecoveryPointDetails>,
}
impl RecoveryPointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryProximityPlacementGroupCustomDetails {
    #[serde(rename = "resourceType")]
    pub resource_type: String,
}
impl RecoveryProximityPlacementGroupCustomDetails {
    pub fn new(resource_type: String) -> Self {
        Self { resource_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryResourceGroupCustomDetails {
    #[serde(rename = "resourceType")]
    pub resource_type: String,
}
impl RecoveryResourceGroupCustomDetails {
    pub fn new(resource_type: String) -> Self {
        Self { resource_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryServicesProvider {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecoveryServicesProviderProperties>,
}
impl RecoveryServicesProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryServicesProviderCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecoveryServicesProvider>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RecoveryServicesProviderCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryServicesProviderProperties {
    #[serde(rename = "fabricType", default, skip_serializing_if = "Option::is_none")]
    pub fabric_type: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "providerVersion", default, skip_serializing_if = "Option::is_none")]
    pub provider_version: Option<String>,
    #[serde(rename = "serverVersion", default, skip_serializing_if = "Option::is_none")]
    pub server_version: Option<String>,
    #[serde(rename = "providerVersionState", default, skip_serializing_if = "Option::is_none")]
    pub provider_version_state: Option<String>,
    #[serde(rename = "providerVersionExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub provider_version_expiry_date: Option<String>,
    #[serde(rename = "fabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_friendly_name: Option<String>,
    #[serde(rename = "lastHeartBeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heart_beat: Option<String>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<String>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i32>,
    #[serde(rename = "allowedScenarios", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_scenarios: Vec<String>,
    #[serde(rename = "healthErrorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub health_error_details: Vec<HealthError>,
    #[serde(rename = "draIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub dra_identifier: Option<String>,
    #[serde(rename = "machineId", default, skip_serializing_if = "Option::is_none")]
    pub machine_id: Option<String>,
    #[serde(rename = "machineName", default, skip_serializing_if = "Option::is_none")]
    pub machine_name: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(rename = "authenticationIdentityDetails", default, skip_serializing_if = "Option::is_none")]
    pub authentication_identity_details: Option<IdentityProviderDetails>,
    #[serde(rename = "resourceAccessIdentityDetails", default, skip_serializing_if = "Option::is_none")]
    pub resource_access_identity_details: Option<IdentityProviderDetails>,
    #[serde(
        rename = "dataPlaneAuthenticationIdentityDetails",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub data_plane_authentication_identity_details: Option<IdentityProviderDetails>,
    #[serde(rename = "providerVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_version_details: Option<VersionDetails>,
}
impl RecoveryServicesProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryVirtualNetworkCustomDetails {
    #[serde(rename = "resourceType")]
    pub resource_type: String,
}
impl RecoveryVirtualNetworkCustomDetails {
    pub fn new(resource_type: String) -> Self {
        Self { resource_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RemoveDisksInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RemoveDisksInputProperties>,
}
impl RemoveDisksInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RemoveDisksInputProperties {
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<RemoveDisksProviderSpecificInput>,
}
impl RemoveDisksInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RemoveDisksProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl RemoveDisksProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RemoveProtectionContainerMappingInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RemoveProtectionContainerMappingInputProperties>,
}
impl RemoveProtectionContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RemoveProtectionContainerMappingInputProperties {
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_input: Option<ReplicationProviderContainerUnmappingInput>,
}
impl RemoveProtectionContainerMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RenewCertificateInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RenewCertificateInputProperties>,
}
impl RenewCertificateInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RenewCertificateInputProperties {
    #[serde(rename = "renewCertificateType", default, skip_serializing_if = "Option::is_none")]
    pub renew_certificate_type: Option<String>,
}
impl RenewCertificateInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationAgentDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<replication_agent_details::Health>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
}
impl ReplicationAgentDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod replication_agent_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationEligibilityResults {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReplicationEligibilityResultsProperties>,
}
impl ReplicationEligibilityResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationEligibilityResultsCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReplicationEligibilityResults>,
}
impl ReplicationEligibilityResultsCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationEligibilityResultsErrorInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl ReplicationEligibilityResultsErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationEligibilityResultsProperties {
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ReplicationEligibilityResultsErrorInfo>,
}
impl ReplicationEligibilityResultsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReplicationGroupDetails {
    #[serde(flatten)]
    pub configuration_settings: ConfigurationSettings,
}
impl ReplicationGroupDetails {
    pub fn new(configuration_settings: ConfigurationSettings) -> Self {
        Self { configuration_settings }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProtectedItem {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReplicationProtectedItemProperties>,
}
impl ReplicationProtectedItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProtectedItemCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReplicationProtectedItem>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ReplicationProtectedItemCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProtectedItemProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "protectedItemType", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_type: Option<String>,
    #[serde(rename = "protectableItemId", default, skip_serializing_if = "Option::is_none")]
    pub protectable_item_id: Option<String>,
    #[serde(rename = "recoveryServicesProviderId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_services_provider_id: Option<String>,
    #[serde(rename = "primaryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_friendly_name: Option<String>,
    #[serde(rename = "primaryFabricProvider", default, skip_serializing_if = "Option::is_none")]
    pub primary_fabric_provider: Option<String>,
    #[serde(rename = "recoveryFabricFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_friendly_name: Option<String>,
    #[serde(rename = "recoveryFabricId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_id: Option<String>,
    #[serde(
        rename = "primaryProtectionContainerFriendlyName",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub primary_protection_container_friendly_name: Option<String>,
    #[serde(
        rename = "recoveryProtectionContainerFriendlyName",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub recovery_protection_container_friendly_name: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<String>,
    #[serde(rename = "protectionStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub protection_state_description: Option<String>,
    #[serde(rename = "activeLocation", default, skip_serializing_if = "Option::is_none")]
    pub active_location: Option<String>,
    #[serde(rename = "testFailoverState", default, skip_serializing_if = "Option::is_none")]
    pub test_failover_state: Option<String>,
    #[serde(rename = "testFailoverStateDescription", default, skip_serializing_if = "Option::is_none")]
    pub test_failover_state_description: Option<String>,
    #[serde(rename = "allowedOperations", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_operations: Vec<String>,
    #[serde(rename = "replicationHealth", default, skip_serializing_if = "Option::is_none")]
    pub replication_health: Option<String>,
    #[serde(rename = "failoverHealth", default, skip_serializing_if = "Option::is_none")]
    pub failover_health: Option<String>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(rename = "policyFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_friendly_name: Option<String>,
    #[serde(rename = "lastSuccessfulFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_successful_failover_time: Option<String>,
    #[serde(rename = "lastSuccessfulTestFailoverTime", default, skip_serializing_if = "Option::is_none")]
    pub last_successful_test_failover_time: Option<String>,
    #[serde(rename = "currentScenario", default, skip_serializing_if = "Option::is_none")]
    pub current_scenario: Option<CurrentScenarioDetails>,
    #[serde(rename = "failoverRecoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub failover_recovery_point_id: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ReplicationProviderSpecificSettings>,
    #[serde(rename = "recoveryContainerId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_container_id: Option<String>,
    #[serde(rename = "eventCorrelationId", default, skip_serializing_if = "Option::is_none")]
    pub event_correlation_id: Option<String>,
}
impl ReplicationProtectedItemProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProtectionIntent {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReplicationProtectionIntentProperties>,
}
impl ReplicationProtectionIntent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProtectionIntentCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ReplicationProtectionIntent>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ReplicationProtectionIntentCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProtectionIntentProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "jobState", default, skip_serializing_if = "Option::is_none")]
    pub job_state: Option<String>,
    #[serde(rename = "isActive", default, skip_serializing_if = "Option::is_none")]
    pub is_active: Option<bool>,
    #[serde(rename = "creationTimeUTC", default, skip_serializing_if = "Option::is_none")]
    pub creation_time_utc: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ReplicationProtectionIntentProviderSpecificSettings>,
}
impl ReplicationProtectionIntentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReplicationProtectionIntentProviderSpecificSettings {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ReplicationProtectionIntentProviderSpecificSettings {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationProviderContainerUnmappingInput {
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
}
impl ReplicationProviderContainerUnmappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReplicationProviderSpecificContainerCreationInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ReplicationProviderSpecificContainerCreationInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReplicationProviderSpecificContainerMappingInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ReplicationProviderSpecificContainerMappingInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReplicationProviderSpecificSettings {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ReplicationProviderSpecificSettings {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReplicationProviderSpecificUpdateContainerMappingInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ReplicationProviderSpecificUpdateContainerMappingInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReprotectAgentDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "biosId", default, skip_serializing_if = "Option::is_none")]
    pub bios_id: Option<String>,
    #[serde(rename = "fabricObjectId", default, skip_serializing_if = "Option::is_none")]
    pub fabric_object_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "lastHeartbeatUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<reprotect_agent_details::Health>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i32>,
    #[serde(rename = "accessibleDatastores", default, skip_serializing_if = "Vec::is_empty")]
    pub accessible_datastores: Vec<String>,
    #[serde(rename = "vcenterId", default, skip_serializing_if = "Option::is_none")]
    pub vcenter_id: Option<String>,
    #[serde(rename = "lastDiscoveryInUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_discovery_in_utc: Option<String>,
}
impl ReprotectAgentDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod reprotect_agent_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        None,
        Normal,
        Warning,
        Critical,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResolveHealthError {
    #[serde(rename = "healthErrorId", default, skip_serializing_if = "Option::is_none")]
    pub health_error_id: Option<String>,
}
impl ResolveHealthError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResolveHealthInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ResolveHealthInputProperties>,
}
impl ResolveHealthInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResolveHealthInputProperties {
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<ResolveHealthError>,
}
impl ResolveHealthInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceHealthSummary {
    #[serde(rename = "resourceCount", default, skip_serializing_if = "Option::is_none")]
    pub resource_count: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub issues: Vec<HealthErrorSummary>,
    #[serde(rename = "categorizedResourceCounts", default, skip_serializing_if = "Option::is_none")]
    pub categorized_resource_counts: Option<serde_json::Value>,
}
impl ResourceHealthSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResumeJobParams {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ResumeJobParamsProperties>,
}
impl ResumeJobParams {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResumeJobParamsProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
}
impl ResumeJobParamsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResyncInput {
    pub properties: ResyncInputProperties,
}
impl ResyncInput {
    pub fn new(properties: ResyncInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResyncInputProperties {
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: ResyncProviderSpecificInput,
}
impl ResyncInputProperties {
    pub fn new(provider_specific_details: ResyncProviderSpecificInput) -> Self {
        Self { provider_specific_details }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResyncProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ResyncProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetentionVolume {
    #[serde(rename = "volumeName", default, skip_serializing_if = "Option::is_none")]
    pub volume_name: Option<String>,
    #[serde(rename = "capacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub capacity_in_bytes: Option<i64>,
    #[serde(rename = "freeSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub free_space_in_bytes: Option<i64>,
    #[serde(rename = "thresholdPercentage", default, skip_serializing_if = "Option::is_none")]
    pub threshold_percentage: Option<i32>,
}
impl RetentionVolume {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReverseReplicationInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ReverseReplicationInputProperties>,
}
impl ReverseReplicationInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReverseReplicationInputProperties {
    #[serde(rename = "failoverDirection", default, skip_serializing_if = "Option::is_none")]
    pub failover_direction: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<ReverseReplicationProviderSpecificInput>,
}
impl ReverseReplicationInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReverseReplicationProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl ReverseReplicationProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoleAssignment {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "roleDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub role_definition_id: Option<String>,
}
impl RoleAssignment {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RunAsAccount {
    #[serde(rename = "accountId", default, skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
}
impl RunAsAccount {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScriptActionTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<String>,
    #[serde(rename = "isPrimarySideScript", default, skip_serializing_if = "Option::is_none")]
    pub is_primary_side_script: Option<bool>,
}
impl ScriptActionTaskDetails {
    pub fn new(task_type_details: TaskTypeDetails) -> Self {
        Self {
            task_type_details,
            name: None,
            path: None,
            output: None,
            is_primary_side_script: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "possibleCauses", default, skip_serializing_if = "Option::is_none")]
    pub possible_causes: Option<String>,
    #[serde(rename = "recommendedAction", default, skip_serializing_if = "Option::is_none")]
    pub recommended_action: Option<String>,
    #[serde(rename = "activityId", default, skip_serializing_if = "Option::is_none")]
    pub activity_id: Option<String>,
}
impl ServiceError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StorageAccountCustomDetails {
    #[serde(rename = "resourceType")]
    pub resource_type: String,
}
impl StorageAccountCustomDetails {
    pub fn new(resource_type: String) -> Self {
        Self { resource_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassification {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StorageClassificationProperties>,
}
impl StorageClassification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<StorageClassification>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl StorageClassificationCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationMapping {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StorageClassificationMappingProperties>,
}
impl StorageClassificationMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationMappingCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<StorageClassificationMapping>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl StorageClassificationMappingCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationMappingInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StorageMappingInputProperties>,
}
impl StorageClassificationMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationMappingProperties {
    #[serde(rename = "targetStorageClassificationId", default, skip_serializing_if = "Option::is_none")]
    pub target_storage_classification_id: Option<String>,
}
impl StorageClassificationMappingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageClassificationProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl StorageClassificationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageMappingInputProperties {
    #[serde(rename = "targetStorageClassificationId", default, skip_serializing_if = "Option::is_none")]
    pub target_storage_classification_id: Option<String>,
}
impl StorageMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Subnet {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "addressList", default, skip_serializing_if = "Vec::is_empty")]
    pub address_list: Vec<String>,
}
impl Subnet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SupportedOsDetails {
    #[serde(rename = "osName", default, skip_serializing_if = "Option::is_none")]
    pub os_name: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "osVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub os_versions: Vec<OsVersionWrapper>,
}
impl SupportedOsDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SupportedOsProperties {
    #[serde(rename = "supportedOsList", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_os_list: Vec<SupportedOsProperty>,
}
impl SupportedOsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SupportedOsProperty {
    #[serde(rename = "instanceType", default, skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    #[serde(rename = "supportedOs", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_os: Vec<SupportedOsDetails>,
}
impl SupportedOsProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SupportedOperatingSystems {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SupportedOsProperties>,
}
impl SupportedOperatingSystems {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwitchProtectionInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SwitchProtectionInputProperties>,
}
impl SwitchProtectionInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwitchProtectionInputProperties {
    #[serde(rename = "replicationProtectedItemName", default, skip_serializing_if = "Option::is_none")]
    pub replication_protected_item_name: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<SwitchProtectionProviderSpecificInput>,
}
impl SwitchProtectionInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SwitchProtectionJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
    #[serde(rename = "newReplicationProtectedItemId", default, skip_serializing_if = "Option::is_none")]
    pub new_replication_protected_item_id: Option<String>,
}
impl SwitchProtectionJobDetails {
    pub fn new(job_details: JobDetails) -> Self {
        Self {
            job_details,
            new_replication_protected_item_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SwitchProtectionProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl SwitchProtectionProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetComputeSize {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<TargetComputeSizeProperties>,
}
impl TargetComputeSize {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetComputeSizeCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TargetComputeSize>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TargetComputeSizeCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetComputeSizeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "cpuCoresCount", default, skip_serializing_if = "Option::is_none")]
    pub cpu_cores_count: Option<i32>,
    #[serde(rename = "vCPUsAvailable", default, skip_serializing_if = "Option::is_none")]
    pub v_cp_us_available: Option<i32>,
    #[serde(rename = "memoryInGB", default, skip_serializing_if = "Option::is_none")]
    pub memory_in_gb: Option<f64>,
    #[serde(rename = "maxDataDiskCount", default, skip_serializing_if = "Option::is_none")]
    pub max_data_disk_count: Option<i32>,
    #[serde(rename = "maxNicsCount", default, skip_serializing_if = "Option::is_none")]
    pub max_nics_count: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ComputeSizeErrorDetails>,
    #[serde(rename = "highIopsSupported", default, skip_serializing_if = "Option::is_none")]
    pub high_iops_supported: Option<String>,
    #[serde(rename = "hyperVGenerations", default, skip_serializing_if = "Vec::is_empty")]
    pub hyper_v_generations: Vec<String>,
}
impl TargetComputeSizeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskTypeDetails {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl TaskTypeDetails {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestFailoverCleanupInput {
    pub properties: TestFailoverCleanupInputProperties,
}
impl TestFailoverCleanupInput {
    pub fn new(properties: TestFailoverCleanupInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestFailoverCleanupInputProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
}
impl TestFailoverCleanupInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestFailoverInput {
    pub properties: TestFailoverInputProperties,
}
impl TestFailoverInput {
    pub fn new(properties: TestFailoverInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestFailoverInputProperties {
    #[serde(rename = "failoverDirection", default, skip_serializing_if = "Option::is_none")]
    pub failover_direction: Option<String>,
    #[serde(rename = "networkType", default, skip_serializing_if = "Option::is_none")]
    pub network_type: Option<String>,
    #[serde(rename = "networkId", default, skip_serializing_if = "Option::is_none")]
    pub network_id: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<TestFailoverProviderSpecificInput>,
}
impl TestFailoverInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestFailoverJobDetails {
    #[serde(flatten)]
    pub job_details: JobDetails,
    #[serde(rename = "testFailoverStatus", default, skip_serializing_if = "Option::is_none")]
    pub test_failover_status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
    #[serde(rename = "networkName", default, skip_serializing_if = "Option::is_none")]
    pub network_name: Option<String>,
    #[serde(rename = "networkFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub network_friendly_name: Option<String>,
    #[serde(rename = "networkType", default, skip_serializing_if = "Option::is_none")]
    pub network_type: Option<String>,
    #[serde(rename = "protectedItemDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_item_details: Vec<FailoverReplicationProtectedItemDetails>,
}
impl TestFailoverJobDetails {
    pub fn new(job_details: JobDetails) -> Self {
        Self {
            job_details,
            test_failover_status: None,
            comments: None,
            network_name: None,
            network_friendly_name: None,
            network_type: None,
            protected_item_details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestFailoverProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl TestFailoverProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestMigrateCleanupInput {
    pub properties: TestMigrateCleanupInputProperties,
}
impl TestMigrateCleanupInput {
    pub fn new(properties: TestMigrateCleanupInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TestMigrateCleanupInputProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
}
impl TestMigrateCleanupInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestMigrateInput {
    pub properties: TestMigrateInputProperties,
}
impl TestMigrateInput {
    pub fn new(properties: TestMigrateInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestMigrateInputProperties {
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: TestMigrateProviderSpecificInput,
}
impl TestMigrateInputProperties {
    pub fn new(provider_specific_details: TestMigrateProviderSpecificInput) -> Self {
        Self { provider_specific_details }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TestMigrateProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl TestMigrateProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UnplannedFailoverInput {
    pub properties: UnplannedFailoverInputProperties,
}
impl UnplannedFailoverInput {
    pub fn new(properties: UnplannedFailoverInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UnplannedFailoverInputProperties {
    #[serde(rename = "failoverDirection", default, skip_serializing_if = "Option::is_none")]
    pub failover_direction: Option<String>,
    #[serde(rename = "sourceSiteOperations", default, skip_serializing_if = "Option::is_none")]
    pub source_site_operations: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<UnplannedFailoverProviderSpecificInput>,
}
impl UnplannedFailoverInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UnplannedFailoverProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl UnplannedFailoverProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateApplianceForReplicationProtectedItemInput {
    pub properties: UpdateApplianceForReplicationProtectedItemInputProperties,
}
impl UpdateApplianceForReplicationProtectedItemInput {
    pub fn new(properties: UpdateApplianceForReplicationProtectedItemInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateApplianceForReplicationProtectedItemInputProperties {
    #[serde(rename = "targetApplianceId")]
    pub target_appliance_id: String,
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: UpdateApplianceForReplicationProtectedItemProviderSpecificInput,
}
impl UpdateApplianceForReplicationProtectedItemInputProperties {
    pub fn new(
        target_appliance_id: String,
        provider_specific_details: UpdateApplianceForReplicationProtectedItemProviderSpecificInput,
    ) -> Self {
        Self {
            target_appliance_id,
            provider_specific_details,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateApplianceForReplicationProtectedItemProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl UpdateApplianceForReplicationProtectedItemProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateDiskInput {
    #[serde(rename = "diskId")]
    pub disk_id: String,
    #[serde(rename = "targetDiskName", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_name: Option<String>,
}
impl UpdateDiskInput {
    pub fn new(disk_id: String) -> Self {
        Self {
            disk_id,
            target_disk_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateMigrationItemInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateMigrationItemInputProperties>,
}
impl UpdateMigrationItemInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateMigrationItemInputProperties {
    #[serde(rename = "providerSpecificDetails")]
    pub provider_specific_details: UpdateMigrationItemProviderSpecificInput,
}
impl UpdateMigrationItemInputProperties {
    pub fn new(provider_specific_details: UpdateMigrationItemProviderSpecificInput) -> Self {
        Self { provider_specific_details }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateMigrationItemProviderSpecificInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl UpdateMigrationItemProviderSpecificInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateMobilityServiceRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateMobilityServiceRequestProperties>,
}
impl UpdateMobilityServiceRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateMobilityServiceRequestProperties {
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
}
impl UpdateMobilityServiceRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateNetworkMappingInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateNetworkMappingInputProperties>,
}
impl UpdateNetworkMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateNetworkMappingInputProperties {
    #[serde(rename = "recoveryFabricName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_fabric_name: Option<String>,
    #[serde(rename = "recoveryNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_network_id: Option<String>,
    #[serde(rename = "fabricSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub fabric_specific_details: Option<FabricSpecificUpdateNetworkMappingInput>,
}
impl UpdateNetworkMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdatePolicyInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdatePolicyInputProperties>,
}
impl UpdatePolicyInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdatePolicyInputProperties {
    #[serde(rename = "replicationProviderSettings", default, skip_serializing_if = "Option::is_none")]
    pub replication_provider_settings: Option<PolicyProviderSpecificInput>,
}
impl UpdatePolicyInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateProtectionContainerMappingInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateProtectionContainerMappingInputProperties>,
}
impl UpdateProtectionContainerMappingInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateProtectionContainerMappingInputProperties {
    #[serde(rename = "providerSpecificInput", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_input: Option<ReplicationProviderSpecificUpdateContainerMappingInput>,
}
impl UpdateProtectionContainerMappingInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateRecoveryPlanInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateRecoveryPlanInputProperties>,
}
impl UpdateRecoveryPlanInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateRecoveryPlanInputProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub groups: Vec<RecoveryPlanGroup>,
}
impl UpdateRecoveryPlanInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateReplicationProtectedItemInput {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateReplicationProtectedItemInputProperties>,
}
impl UpdateReplicationProtectedItemInput {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateReplicationProtectedItemInputProperties {
    #[serde(rename = "recoveryAzureVMName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_name: Option<String>,
    #[serde(rename = "recoveryAzureVMSize", default, skip_serializing_if = "Option::is_none")]
    pub recovery_azure_vm_size: Option<String>,
    #[serde(rename = "selectedRecoveryAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_recovery_azure_network_id: Option<String>,
    #[serde(rename = "selectedTfoAzureNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub selected_tfo_azure_network_id: Option<String>,
    #[serde(rename = "selectedSourceNicId", default, skip_serializing_if = "Option::is_none")]
    pub selected_source_nic_id: Option<String>,
    #[serde(rename = "enableRdpOnTargetOption", default, skip_serializing_if = "Option::is_none")]
    pub enable_rdp_on_target_option: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VmNicInputDetails>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<update_replication_protected_item_input_properties::LicenseType>,
    #[serde(rename = "recoveryAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_availability_set_id: Option<String>,
    #[serde(rename = "providerSpecificDetails", default, skip_serializing_if = "Option::is_none")]
    pub provider_specific_details: Option<UpdateReplicationProtectedItemProviderInput>,
}
impl UpdateReplicationProtectedItemInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod update_replication_protected_item_input_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateReplicationProtectedItemProviderInput {
    #[serde(rename = "instanceType")]
    pub instance_type: String,
}
impl UpdateReplicationProtectedItemProviderInput {
    pub fn new(instance_type: String) -> Self {
        Self { instance_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateVCenterRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UpdateVCenterRequestProperties>,
}
impl UpdateVCenterRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateVCenterRequestProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<String>,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
}
impl UpdateVCenterRequestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VCenter {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VCenterProperties>,
}
impl VCenter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VCenterCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VCenter>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VCenterCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VCenterProperties {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "internalId", default, skip_serializing_if = "Option::is_none")]
    pub internal_id: Option<String>,
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[serde(rename = "discoveryStatus", default, skip_serializing_if = "Option::is_none")]
    pub discovery_status: Option<String>,
    #[serde(rename = "processServerId", default, skip_serializing_if = "Option::is_none")]
    pub process_server_id: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "infrastructureId", default, skip_serializing_if = "Option::is_none")]
    pub infrastructure_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<String>,
    #[serde(rename = "runAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub run_as_account_id: Option<String>,
    #[serde(rename = "fabricArmResourceName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_arm_resource_name: Option<String>,
    #[serde(rename = "healthErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub health_errors: Vec<HealthError>,
}
impl VCenterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmNicDetails {
    #[serde(rename = "nicId", default, skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    #[serde(rename = "replicaNicId", default, skip_serializing_if = "Option::is_none")]
    pub replica_nic_id: Option<String>,
    #[serde(rename = "sourceNicArmId", default, skip_serializing_if = "Option::is_none")]
    pub source_nic_arm_id: Option<String>,
    #[serde(rename = "vMNetworkName", default, skip_serializing_if = "Option::is_none")]
    pub v_m_network_name: Option<String>,
    #[serde(rename = "recoveryVMNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_vm_network_id: Option<String>,
    #[serde(rename = "ipConfigs", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configs: Vec<IpConfigDetails>,
    #[serde(rename = "selectionType", default, skip_serializing_if = "Option::is_none")]
    pub selection_type: Option<String>,
    #[serde(rename = "recoveryNetworkSecurityGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_network_security_group_id: Option<String>,
    #[serde(rename = "enableAcceleratedNetworkingOnRecovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking_on_recovery: Option<bool>,
    #[serde(rename = "tfoVMNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub tfo_vm_network_id: Option<String>,
    #[serde(rename = "tfoNetworkSecurityGroupId", default, skip_serializing_if = "Option::is_none")]
    pub tfo_network_security_group_id: Option<String>,
    #[serde(rename = "enableAcceleratedNetworkingOnTfo", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking_on_tfo: Option<bool>,
    #[serde(rename = "recoveryNicName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_nic_name: Option<String>,
    #[serde(rename = "recoveryNicResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_nic_resource_group_name: Option<String>,
    #[serde(rename = "reuseExistingNic", default, skip_serializing_if = "Option::is_none")]
    pub reuse_existing_nic: Option<bool>,
    #[serde(rename = "tfoRecoveryNicName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_recovery_nic_name: Option<String>,
    #[serde(rename = "tfoRecoveryNicResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_recovery_nic_resource_group_name: Option<String>,
    #[serde(rename = "tfoReuseExistingNic", default, skip_serializing_if = "Option::is_none")]
    pub tfo_reuse_existing_nic: Option<bool>,
    #[serde(rename = "targetNicName", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_name: Option<String>,
}
impl VmNicDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VmNicInputDetails {
    #[serde(rename = "nicId", default, skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    #[serde(rename = "ipConfigs", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configs: Vec<IpConfigInputDetails>,
    #[serde(rename = "selectionType", default, skip_serializing_if = "Option::is_none")]
    pub selection_type: Option<String>,
    #[serde(rename = "recoveryNetworkSecurityGroupId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_network_security_group_id: Option<String>,
    #[serde(rename = "enableAcceleratedNetworkingOnRecovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking_on_recovery: Option<bool>,
    #[serde(rename = "tfoNetworkSecurityGroupId", default, skip_serializing_if = "Option::is_none")]
    pub tfo_network_security_group_id: Option<String>,
    #[serde(rename = "enableAcceleratedNetworkingOnTfo", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking_on_tfo: Option<bool>,
    #[serde(rename = "recoveryNicName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_nic_name: Option<String>,
    #[serde(rename = "recoveryNicResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub recovery_nic_resource_group_name: Option<String>,
    #[serde(rename = "reuseExistingNic", default, skip_serializing_if = "Option::is_none")]
    pub reuse_existing_nic: Option<bool>,
    #[serde(rename = "tfoNicName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_nic_name: Option<String>,
    #[serde(rename = "tfoNicResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub tfo_nic_resource_group_name: Option<String>,
    #[serde(rename = "tfoReuseExistingNic", default, skip_serializing_if = "Option::is_none")]
    pub tfo_reuse_existing_nic: Option<bool>,
    #[serde(rename = "targetNicName", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_name: Option<String>,
}
impl VmNicInputDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtContainerCreationInput {
    #[serde(flatten)]
    pub replication_provider_specific_container_creation_input: ReplicationProviderSpecificContainerCreationInput,
}
impl VMwareCbtContainerCreationInput {
    pub fn new(replication_provider_specific_container_creation_input: ReplicationProviderSpecificContainerCreationInput) -> Self {
        Self {
            replication_provider_specific_container_creation_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtContainerMappingInput {
    #[serde(flatten)]
    pub replication_provider_specific_container_mapping_input: ReplicationProviderSpecificContainerMappingInput,
    #[serde(rename = "keyVaultId")]
    pub key_vault_id: String,
    #[serde(rename = "keyVaultUri")]
    pub key_vault_uri: String,
    #[serde(rename = "storageAccountId")]
    pub storage_account_id: String,
    #[serde(rename = "storageAccountSasSecretName")]
    pub storage_account_sas_secret_name: String,
    #[serde(rename = "serviceBusConnectionStringSecretName")]
    pub service_bus_connection_string_secret_name: String,
    #[serde(rename = "targetLocation")]
    pub target_location: String,
}
impl VMwareCbtContainerMappingInput {
    pub fn new(
        replication_provider_specific_container_mapping_input: ReplicationProviderSpecificContainerMappingInput,
        key_vault_id: String,
        key_vault_uri: String,
        storage_account_id: String,
        storage_account_sas_secret_name: String,
        service_bus_connection_string_secret_name: String,
        target_location: String,
    ) -> Self {
        Self {
            replication_provider_specific_container_mapping_input,
            key_vault_id,
            key_vault_uri,
            storage_account_id,
            storage_account_sas_secret_name,
            service_bus_connection_string_secret_name,
            target_location,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtDiskInput {
    #[serde(rename = "diskId")]
    pub disk_id: String,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<v_mware_cbt_disk_input::DiskType>,
    #[serde(rename = "isOSDisk")]
    pub is_os_disk: String,
    #[serde(rename = "logStorageAccountId")]
    pub log_storage_account_id: String,
    #[serde(rename = "logStorageAccountSasSecretName")]
    pub log_storage_account_sas_secret_name: String,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
}
impl VMwareCbtDiskInput {
    pub fn new(disk_id: String, is_os_disk: String, log_storage_account_id: String, log_storage_account_sas_secret_name: String) -> Self {
        Self {
            disk_id,
            disk_type: None,
            is_os_disk,
            log_storage_account_id,
            log_storage_account_sas_secret_name,
            disk_encryption_set_id: None,
        }
    }
}
pub mod v_mware_cbt_disk_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtEnableMigrationInput {
    #[serde(flatten)]
    pub enable_migration_provider_specific_input: EnableMigrationProviderSpecificInput,
    #[serde(rename = "vmwareMachineId")]
    pub vmware_machine_id: String,
    #[serde(rename = "disksToInclude")]
    pub disks_to_include: Vec<VMwareCbtDiskInput>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<v_mware_cbt_enable_migration_input::LicenseType>,
    #[serde(rename = "sqlServerLicenseType", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_license_type: Option<v_mware_cbt_enable_migration_input::SqlServerLicenseType>,
    #[serde(rename = "dataMoverRunAsAccountId")]
    pub data_mover_run_as_account_id: String,
    #[serde(rename = "snapshotRunAsAccountId")]
    pub snapshot_run_as_account_id: String,
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[serde(rename = "targetResourceGroupId")]
    pub target_resource_group_id: String,
    #[serde(rename = "targetNetworkId")]
    pub target_network_id: String,
    #[serde(rename = "targetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet_name: Option<String>,
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "targetBootDiagnosticsStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_boot_diagnostics_storage_account_id: Option<String>,
    #[serde(rename = "performAutoResync", default, skip_serializing_if = "Option::is_none")]
    pub perform_auto_resync: Option<String>,
    #[serde(rename = "targetVmTags", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_tags: Option<serde_json::Value>,
    #[serde(rename = "seedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub seed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetNicTags", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_tags: Option<serde_json::Value>,
}
impl VMwareCbtEnableMigrationInput {
    pub fn new(
        enable_migration_provider_specific_input: EnableMigrationProviderSpecificInput,
        vmware_machine_id: String,
        disks_to_include: Vec<VMwareCbtDiskInput>,
        data_mover_run_as_account_id: String,
        snapshot_run_as_account_id: String,
        target_resource_group_id: String,
        target_network_id: String,
    ) -> Self {
        Self {
            enable_migration_provider_specific_input,
            vmware_machine_id,
            disks_to_include,
            license_type: None,
            sql_server_license_type: None,
            data_mover_run_as_account_id,
            snapshot_run_as_account_id,
            target_vm_name: None,
            target_vm_size: None,
            target_resource_group_id,
            target_network_id,
            target_subnet_name: None,
            target_availability_set_id: None,
            target_availability_zone: None,
            target_proximity_placement_group_id: None,
            target_boot_diagnostics_storage_account_id: None,
            perform_auto_resync: None,
            target_vm_tags: None,
            seed_disk_tags: None,
            target_disk_tags: None,
            target_nic_tags: None,
        }
    }
}
pub mod v_mware_cbt_enable_migration_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SqlServerLicenseType {
        NotSpecified,
        NoLicenseType,
        #[serde(rename = "PAYG")]
        Payg,
        #[serde(rename = "AHUB")]
        Ahub,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtEventDetails {
    #[serde(flatten)]
    pub event_provider_specific_details: EventProviderSpecificDetails,
    #[serde(rename = "migrationItemName", default, skip_serializing_if = "Option::is_none")]
    pub migration_item_name: Option<String>,
}
impl VMwareCbtEventDetails {
    pub fn new(event_provider_specific_details: EventProviderSpecificDetails) -> Self {
        Self {
            event_provider_specific_details,
            migration_item_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtMigrateInput {
    #[serde(flatten)]
    pub migrate_provider_specific_input: MigrateProviderSpecificInput,
    #[serde(rename = "performShutdown")]
    pub perform_shutdown: String,
}
impl VMwareCbtMigrateInput {
    pub fn new(migrate_provider_specific_input: MigrateProviderSpecificInput, perform_shutdown: String) -> Self {
        Self {
            migrate_provider_specific_input,
            perform_shutdown,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtMigrationDetails {
    #[serde(flatten)]
    pub migration_provider_specific_settings: MigrationProviderSpecificSettings,
    #[serde(rename = "vmwareMachineId", default, skip_serializing_if = "Option::is_none")]
    pub vmware_machine_id: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "firmwareType", default, skip_serializing_if = "Option::is_none")]
    pub firmware_type: Option<String>,
    #[serde(rename = "targetGeneration", default, skip_serializing_if = "Option::is_none")]
    pub target_generation: Option<String>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "sqlServerLicenseType", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_license_type: Option<String>,
    #[serde(rename = "dataMoverRunAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub data_mover_run_as_account_id: Option<String>,
    #[serde(rename = "snapshotRunAsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_run_as_account_id: Option<String>,
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[serde(rename = "targetLocation", default, skip_serializing_if = "Option::is_none")]
    pub target_location: Option<String>,
    #[serde(rename = "targetResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_id: Option<String>,
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "targetBootDiagnosticsStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_boot_diagnostics_storage_account_id: Option<String>,
    #[serde(rename = "targetVmTags", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_tags: Option<serde_json::Value>,
    #[serde(rename = "protectedDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub protected_disks: Vec<VMwareCbtProtectedDiskDetails>,
    #[serde(rename = "targetNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_network_id: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VMwareCbtNicDetails>,
    #[serde(rename = "targetNicTags", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_tags: Option<serde_json::Value>,
    #[serde(rename = "migrationRecoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub migration_recovery_point_id: Option<String>,
    #[serde(rename = "lastRecoveryPointReceived", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point_received: Option<String>,
    #[serde(rename = "lastRecoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point_id: Option<String>,
    #[serde(rename = "initialSeedingProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub initial_seeding_progress_percentage: Option<i32>,
    #[serde(rename = "migrationProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub migration_progress_percentage: Option<i32>,
    #[serde(rename = "resyncProgressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub resync_progress_percentage: Option<i32>,
    #[serde(rename = "initialSeedingRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub initial_seeding_retry_count: Option<i64>,
    #[serde(rename = "resyncRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub resync_retry_count: Option<i64>,
    #[serde(rename = "resyncRequired", default, skip_serializing_if = "Option::is_none")]
    pub resync_required: Option<String>,
    #[serde(rename = "resyncState", default, skip_serializing_if = "Option::is_none")]
    pub resync_state: Option<v_mware_cbt_migration_details::ResyncState>,
    #[serde(rename = "performAutoResync", default, skip_serializing_if = "Option::is_none")]
    pub perform_auto_resync: Option<String>,
    #[serde(rename = "seedDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub seed_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_tags: Option<serde_json::Value>,
}
impl VMwareCbtMigrationDetails {
    pub fn new(migration_provider_specific_settings: MigrationProviderSpecificSettings) -> Self {
        Self {
            migration_provider_specific_settings,
            vmware_machine_id: None,
            os_type: None,
            firmware_type: None,
            target_generation: None,
            license_type: None,
            sql_server_license_type: None,
            data_mover_run_as_account_id: None,
            snapshot_run_as_account_id: None,
            target_vm_name: None,
            target_vm_size: None,
            target_location: None,
            target_resource_group_id: None,
            target_availability_set_id: None,
            target_availability_zone: None,
            target_proximity_placement_group_id: None,
            target_boot_diagnostics_storage_account_id: None,
            target_vm_tags: None,
            protected_disks: Vec::new(),
            target_network_id: None,
            vm_nics: Vec::new(),
            target_nic_tags: None,
            migration_recovery_point_id: None,
            last_recovery_point_received: None,
            last_recovery_point_id: None,
            initial_seeding_progress_percentage: None,
            migration_progress_percentage: None,
            resync_progress_percentage: None,
            initial_seeding_retry_count: None,
            resync_retry_count: None,
            resync_required: None,
            resync_state: None,
            perform_auto_resync: None,
            seed_disk_tags: None,
            target_disk_tags: None,
        }
    }
}
pub mod v_mware_cbt_migration_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResyncState {
        None,
        PreparedForResynchronization,
        StartedResynchronization,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtNicDetails {
    #[serde(rename = "nicId", default, skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    #[serde(rename = "isPrimaryNic", default, skip_serializing_if = "Option::is_none")]
    pub is_primary_nic: Option<String>,
    #[serde(rename = "sourceIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub source_ip_address: Option<String>,
    #[serde(rename = "sourceIPAddressType", default, skip_serializing_if = "Option::is_none")]
    pub source_ip_address_type: Option<v_mware_cbt_nic_details::SourceIpAddressType>,
    #[serde(rename = "sourceNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub source_network_id: Option<String>,
    #[serde(rename = "targetIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub target_ip_address: Option<String>,
    #[serde(rename = "targetIPAddressType", default, skip_serializing_if = "Option::is_none")]
    pub target_ip_address_type: Option<v_mware_cbt_nic_details::TargetIpAddressType>,
    #[serde(rename = "targetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet_name: Option<String>,
    #[serde(rename = "targetNicName", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_name: Option<String>,
    #[serde(rename = "isSelectedForMigration", default, skip_serializing_if = "Option::is_none")]
    pub is_selected_for_migration: Option<String>,
}
impl VMwareCbtNicDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod v_mware_cbt_nic_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceIpAddressType {
        Dynamic,
        Static,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TargetIpAddressType {
        Dynamic,
        Static,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtNicInput {
    #[serde(rename = "nicId")]
    pub nic_id: String,
    #[serde(rename = "isPrimaryNic")]
    pub is_primary_nic: String,
    #[serde(rename = "targetSubnetName", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet_name: Option<String>,
    #[serde(rename = "targetStaticIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub target_static_ip_address: Option<String>,
    #[serde(rename = "isSelectedForMigration", default, skip_serializing_if = "Option::is_none")]
    pub is_selected_for_migration: Option<String>,
    #[serde(rename = "targetNicName", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_name: Option<String>,
}
impl VMwareCbtNicInput {
    pub fn new(nic_id: String, is_primary_nic: String) -> Self {
        Self {
            nic_id,
            is_primary_nic,
            target_subnet_name: None,
            target_static_ip_address: None,
            is_selected_for_migration: None,
            target_nic_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtPolicyCreationInput {
    #[serde(flatten)]
    pub policy_provider_specific_input: PolicyProviderSpecificInput,
    #[serde(rename = "recoveryPointHistoryInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_in_minutes: Option<i32>,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
}
impl VMwareCbtPolicyCreationInput {
    pub fn new(policy_provider_specific_input: PolicyProviderSpecificInput) -> Self {
        Self {
            policy_provider_specific_input,
            recovery_point_history_in_minutes: None,
            crash_consistent_frequency_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VMwareCbtProtectedDiskDetails {
    #[serde(rename = "diskId", default, skip_serializing_if = "Option::is_none")]
    pub disk_id: Option<String>,
    #[serde(rename = "diskName", default, skip_serializing_if = "Option::is_none")]
    pub disk_name: Option<String>,
    #[serde(rename = "diskType", default, skip_serializing_if = "Option::is_none")]
    pub disk_type: Option<v_mware_cbt_protected_disk_details::DiskType>,
    #[serde(rename = "diskPath", default, skip_serializing_if = "Option::is_none")]
    pub disk_path: Option<String>,
    #[serde(rename = "isOSDisk", default, skip_serializing_if = "Option::is_none")]
    pub is_os_disk: Option<String>,
    #[serde(rename = "capacityInBytes", default, skip_serializing_if = "Option::is_none")]
    pub capacity_in_bytes: Option<i64>,
    #[serde(rename = "logStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_id: Option<String>,
    #[serde(rename = "logStorageAccountSasSecretName", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_account_sas_secret_name: Option<String>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
    #[serde(rename = "seedManagedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub seed_managed_disk_id: Option<String>,
    #[serde(rename = "targetManagedDiskId", default, skip_serializing_if = "Option::is_none")]
    pub target_managed_disk_id: Option<String>,
    #[serde(rename = "targetDiskName", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_name: Option<String>,
}
impl VMwareCbtProtectedDiskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod v_mware_cbt_protected_disk_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DiskType {
        #[serde(rename = "Standard_LRS")]
        StandardLrs,
        #[serde(rename = "Premium_LRS")]
        PremiumLrs,
        #[serde(rename = "StandardSSD_LRS")]
        StandardSsdLrs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtProtectionContainerMappingDetails {
    #[serde(flatten)]
    pub protection_container_mapping_provider_specific_details: ProtectionContainerMappingProviderSpecificDetails,
    #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_id: Option<String>,
    #[serde(rename = "keyVaultUri", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_uri: Option<String>,
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[serde(rename = "storageAccountSasSecretName", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_sas_secret_name: Option<String>,
    #[serde(rename = "serviceBusConnectionStringSecretName", default, skip_serializing_if = "Option::is_none")]
    pub service_bus_connection_string_secret_name: Option<String>,
    #[serde(rename = "targetLocation", default, skip_serializing_if = "Option::is_none")]
    pub target_location: Option<String>,
}
impl VMwareCbtProtectionContainerMappingDetails {
    pub fn new(protection_container_mapping_provider_specific_details: ProtectionContainerMappingProviderSpecificDetails) -> Self {
        Self {
            protection_container_mapping_provider_specific_details,
            key_vault_id: None,
            key_vault_uri: None,
            storage_account_id: None,
            storage_account_sas_secret_name: None,
            service_bus_connection_string_secret_name: None,
            target_location: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtResyncInput {
    #[serde(flatten)]
    pub resync_provider_specific_input: ResyncProviderSpecificInput,
    #[serde(rename = "skipCbtReset")]
    pub skip_cbt_reset: String,
}
impl VMwareCbtResyncInput {
    pub fn new(resync_provider_specific_input: ResyncProviderSpecificInput, skip_cbt_reset: String) -> Self {
        Self {
            resync_provider_specific_input,
            skip_cbt_reset,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtTestMigrateInput {
    #[serde(flatten)]
    pub test_migrate_provider_specific_input: TestMigrateProviderSpecificInput,
    #[serde(rename = "recoveryPointId")]
    pub recovery_point_id: String,
    #[serde(rename = "networkId")]
    pub network_id: String,
}
impl VMwareCbtTestMigrateInput {
    pub fn new(
        test_migrate_provider_specific_input: TestMigrateProviderSpecificInput,
        recovery_point_id: String,
        network_id: String,
    ) -> Self {
        Self {
            test_migrate_provider_specific_input,
            recovery_point_id,
            network_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtUpdateDiskInput {
    #[serde(rename = "diskId")]
    pub disk_id: String,
    #[serde(rename = "targetDiskName", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_name: Option<String>,
}
impl VMwareCbtUpdateDiskInput {
    pub fn new(disk_id: String) -> Self {
        Self {
            disk_id,
            target_disk_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareCbtUpdateMigrationItemInput {
    #[serde(flatten)]
    pub update_migration_item_provider_specific_input: UpdateMigrationItemProviderSpecificInput,
    #[serde(rename = "targetVmName", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_name: Option<String>,
    #[serde(rename = "targetVmSize", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_size: Option<String>,
    #[serde(rename = "targetResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_id: Option<String>,
    #[serde(rename = "targetAvailabilitySetId", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_set_id: Option<String>,
    #[serde(rename = "targetAvailabilityZone", default, skip_serializing_if = "Option::is_none")]
    pub target_availability_zone: Option<String>,
    #[serde(rename = "targetProximityPlacementGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_proximity_placement_group_id: Option<String>,
    #[serde(rename = "targetBootDiagnosticsStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_boot_diagnostics_storage_account_id: Option<String>,
    #[serde(rename = "targetNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub target_network_id: Option<String>,
    #[serde(rename = "vmNics", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_nics: Vec<VMwareCbtNicInput>,
    #[serde(rename = "vmDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub vm_disks: Vec<VMwareCbtUpdateDiskInput>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<v_mware_cbt_update_migration_item_input::LicenseType>,
    #[serde(rename = "sqlServerLicenseType", default, skip_serializing_if = "Option::is_none")]
    pub sql_server_license_type: Option<v_mware_cbt_update_migration_item_input::SqlServerLicenseType>,
    #[serde(rename = "performAutoResync", default, skip_serializing_if = "Option::is_none")]
    pub perform_auto_resync: Option<String>,
    #[serde(rename = "targetVmTags", default, skip_serializing_if = "Option::is_none")]
    pub target_vm_tags: Option<serde_json::Value>,
    #[serde(rename = "targetDiskTags", default, skip_serializing_if = "Option::is_none")]
    pub target_disk_tags: Option<serde_json::Value>,
    #[serde(rename = "targetNicTags", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_tags: Option<serde_json::Value>,
}
impl VMwareCbtUpdateMigrationItemInput {
    pub fn new(update_migration_item_provider_specific_input: UpdateMigrationItemProviderSpecificInput) -> Self {
        Self {
            update_migration_item_provider_specific_input,
            target_vm_name: None,
            target_vm_size: None,
            target_resource_group_id: None,
            target_availability_set_id: None,
            target_availability_zone: None,
            target_proximity_placement_group_id: None,
            target_boot_diagnostics_storage_account_id: None,
            target_network_id: None,
            vm_nics: Vec::new(),
            vm_disks: Vec::new(),
            license_type: None,
            sql_server_license_type: None,
            perform_auto_resync: None,
            target_vm_tags: None,
            target_disk_tags: None,
            target_nic_tags: None,
        }
    }
}
pub mod v_mware_cbt_update_migration_item_input {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LicenseType {
        NotSpecified,
        NoLicenseType,
        WindowsServer,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SqlServerLicenseType {
        NotSpecified,
        NoLicenseType,
        #[serde(rename = "PAYG")]
        Payg,
        #[serde(rename = "AHUB")]
        Ahub,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
    #[serde(rename = "processServers", default, skip_serializing_if = "Vec::is_empty")]
    pub process_servers: Vec<ProcessServer>,
    #[serde(rename = "masterTargetServers", default, skip_serializing_if = "Vec::is_empty")]
    pub master_target_servers: Vec<MasterTargetServer>,
    #[serde(rename = "runAsAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub run_as_accounts: Vec<RunAsAccount>,
    #[serde(rename = "replicationPairCount", default, skip_serializing_if = "Option::is_none")]
    pub replication_pair_count: Option<String>,
    #[serde(rename = "processServerCount", default, skip_serializing_if = "Option::is_none")]
    pub process_server_count: Option<String>,
    #[serde(rename = "agentCount", default, skip_serializing_if = "Option::is_none")]
    pub agent_count: Option<String>,
    #[serde(rename = "protectedServers", default, skip_serializing_if = "Option::is_none")]
    pub protected_servers: Option<String>,
    #[serde(rename = "systemLoad", default, skip_serializing_if = "Option::is_none")]
    pub system_load: Option<String>,
    #[serde(rename = "systemLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub system_load_status: Option<String>,
    #[serde(rename = "cpuLoad", default, skip_serializing_if = "Option::is_none")]
    pub cpu_load: Option<String>,
    #[serde(rename = "cpuLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub cpu_load_status: Option<String>,
    #[serde(rename = "totalMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_memory_in_bytes: Option<i64>,
    #[serde(rename = "availableMemoryInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_memory_in_bytes: Option<i64>,
    #[serde(rename = "memoryUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub memory_usage_status: Option<String>,
    #[serde(rename = "totalSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_space_in_bytes: Option<i64>,
    #[serde(rename = "availableSpaceInBytes", default, skip_serializing_if = "Option::is_none")]
    pub available_space_in_bytes: Option<i64>,
    #[serde(rename = "spaceUsageStatus", default, skip_serializing_if = "Option::is_none")]
    pub space_usage_status: Option<String>,
    #[serde(rename = "webLoad", default, skip_serializing_if = "Option::is_none")]
    pub web_load: Option<String>,
    #[serde(rename = "webLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub web_load_status: Option<String>,
    #[serde(rename = "databaseServerLoad", default, skip_serializing_if = "Option::is_none")]
    pub database_server_load: Option<String>,
    #[serde(rename = "databaseServerLoadStatus", default, skip_serializing_if = "Option::is_none")]
    pub database_server_load_status: Option<String>,
    #[serde(rename = "csServiceStatus", default, skip_serializing_if = "Option::is_none")]
    pub cs_service_status: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "lastHeartbeat", default, skip_serializing_if = "Option::is_none")]
    pub last_heartbeat: Option<String>,
    #[serde(rename = "versionStatus", default, skip_serializing_if = "Option::is_none")]
    pub version_status: Option<String>,
    #[serde(rename = "sslCertExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_expiry_date: Option<String>,
    #[serde(rename = "sslCertExpiryRemainingDays", default, skip_serializing_if = "Option::is_none")]
    pub ssl_cert_expiry_remaining_days: Option<i32>,
    #[serde(rename = "psTemplateVersion", default, skip_serializing_if = "Option::is_none")]
    pub ps_template_version: Option<String>,
    #[serde(rename = "agentExpiryDate", default, skip_serializing_if = "Option::is_none")]
    pub agent_expiry_date: Option<String>,
    #[serde(rename = "agentVersionDetails", default, skip_serializing_if = "Option::is_none")]
    pub agent_version_details: Option<VersionDetails>,
}
impl VMwareDetails {
    pub fn new(fabric_specific_details: FabricSpecificDetails) -> Self {
        Self {
            fabric_specific_details,
            process_servers: Vec::new(),
            master_target_servers: Vec::new(),
            run_as_accounts: Vec::new(),
            replication_pair_count: None,
            process_server_count: None,
            agent_count: None,
            protected_servers: None,
            system_load: None,
            system_load_status: None,
            cpu_load: None,
            cpu_load_status: None,
            total_memory_in_bytes: None,
            available_memory_in_bytes: None,
            memory_usage_status: None,
            total_space_in_bytes: None,
            available_space_in_bytes: None,
            space_usage_status: None,
            web_load: None,
            web_load_status: None,
            database_server_load: None,
            database_server_load_status: None,
            cs_service_status: None,
            ip_address: None,
            agent_version: None,
            host_name: None,
            last_heartbeat: None,
            version_status: None,
            ssl_cert_expiry_date: None,
            ssl_cert_expiry_remaining_days: None,
            ps_template_version: None,
            agent_expiry_date: None,
            agent_version_details: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareV2FabricCreationInput {
    #[serde(flatten)]
    pub fabric_specific_creation_input: FabricSpecificCreationInput,
    #[serde(rename = "vmwareSiteId", default, skip_serializing_if = "Option::is_none")]
    pub vmware_site_id: Option<String>,
    #[serde(rename = "physicalSiteId", default, skip_serializing_if = "Option::is_none")]
    pub physical_site_id: Option<String>,
    #[serde(rename = "migrationSolutionId")]
    pub migration_solution_id: String,
}
impl VMwareV2FabricCreationInput {
    pub fn new(fabric_specific_creation_input: FabricSpecificCreationInput, migration_solution_id: String) -> Self {
        Self {
            fabric_specific_creation_input,
            vmware_site_id: None,
            physical_site_id: None,
            migration_solution_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareV2FabricSpecificDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
    #[serde(rename = "vmwareSiteId", default, skip_serializing_if = "Option::is_none")]
    pub vmware_site_id: Option<String>,
    #[serde(rename = "physicalSiteId", default, skip_serializing_if = "Option::is_none")]
    pub physical_site_id: Option<String>,
    #[serde(rename = "migrationSolutionId", default, skip_serializing_if = "Option::is_none")]
    pub migration_solution_id: Option<String>,
    #[serde(rename = "serviceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub service_endpoint: Option<String>,
    #[serde(rename = "serviceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub service_resource_id: Option<String>,
    #[serde(rename = "serviceContainerId", default, skip_serializing_if = "Option::is_none")]
    pub service_container_id: Option<String>,
    #[serde(rename = "processServers", default, skip_serializing_if = "Vec::is_empty")]
    pub process_servers: Vec<ProcessServerDetails>,
}
impl VMwareV2FabricSpecificDetails {
    pub fn new(fabric_specific_details: FabricSpecificDetails) -> Self {
        Self {
            fabric_specific_details,
            vmware_site_id: None,
            physical_site_id: None,
            migration_solution_id: None,
            service_endpoint: None,
            service_resource_id: None,
            service_container_id: None,
            process_servers: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VMwareVirtualMachineDetails {
    #[serde(flatten)]
    pub configuration_settings: ConfigurationSettings,
    #[serde(rename = "agentGeneratedId", default, skip_serializing_if = "Option::is_none")]
    pub agent_generated_id: Option<String>,
    #[serde(rename = "agentInstalled", default, skip_serializing_if = "Option::is_none")]
    pub agent_installed: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "poweredOn", default, skip_serializing_if = "Option::is_none")]
    pub powered_on: Option<String>,
    #[serde(rename = "vCenterInfrastructureId", default, skip_serializing_if = "Option::is_none")]
    pub v_center_infrastructure_id: Option<String>,
    #[serde(rename = "discoveryType", default, skip_serializing_if = "Option::is_none")]
    pub discovery_type: Option<String>,
    #[serde(rename = "diskDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_details: Vec<InMageDiskDetails>,
    #[serde(rename = "validationErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_errors: Vec<HealthError>,
}
impl VMwareVirtualMachineDetails {
    pub fn new(configuration_settings: ConfigurationSettings) -> Self {
        Self {
            configuration_settings,
            agent_generated_id: None,
            agent_installed: None,
            os_type: None,
            agent_version: None,
            ip_address: None,
            powered_on: None,
            v_center_infrastructure_id: None,
            discovery_type: None,
            disk_details: Vec::new(),
            validation_errors: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultHealthDetails {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VaultHealthProperties>,
}
impl VaultHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultHealthProperties {
    #[serde(rename = "vaultErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub vault_errors: Vec<HealthError>,
    #[serde(rename = "protectedItemsHealth", default, skip_serializing_if = "Option::is_none")]
    pub protected_items_health: Option<ResourceHealthSummary>,
    #[serde(rename = "fabricsHealth", default, skip_serializing_if = "Option::is_none")]
    pub fabrics_health: Option<ResourceHealthSummary>,
    #[serde(rename = "containersHealth", default, skip_serializing_if = "Option::is_none")]
    pub containers_health: Option<ResourceHealthSummary>,
}
impl VaultHealthProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultSetting {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VaultSettingProperties>,
}
impl VaultSetting {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultSettingCollection {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VaultSetting>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VaultSettingCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VaultSettingCreationInput {
    pub properties: VaultSettingCreationInputProperties,
}
impl VaultSettingCreationInput {
    pub fn new(properties: VaultSettingCreationInputProperties) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultSettingCreationInputProperties {
    #[serde(rename = "migrationSolutionId", default, skip_serializing_if = "Option::is_none")]
    pub migration_solution_id: Option<String>,
    #[serde(rename = "vmwareToAzureProviderType", default, skip_serializing_if = "Option::is_none")]
    pub vmware_to_azure_provider_type: Option<String>,
}
impl VaultSettingCreationInputProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultSettingProperties {
    #[serde(rename = "migrationSolutionId", default, skip_serializing_if = "Option::is_none")]
    pub migration_solution_id: Option<String>,
    #[serde(rename = "vmwareToAzureProviderType", default, skip_serializing_if = "Option::is_none")]
    pub vmware_to_azure_provider_type: Option<String>,
}
impl VaultSettingProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VersionDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "expiryDate", default, skip_serializing_if = "Option::is_none")]
    pub expiry_date: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<version_details::Status>,
}
impl VersionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod version_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Supported,
        NotSupported,
        Deprecated,
        UpdateRequired,
        SecurityUpdateRequired,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineTaskDetails {
    #[serde(flatten)]
    pub job_task_details: JobTaskDetails,
    #[serde(rename = "skippedReason", default, skip_serializing_if = "Option::is_none")]
    pub skipped_reason: Option<String>,
    #[serde(rename = "skippedReasonString", default, skip_serializing_if = "Option::is_none")]
    pub skipped_reason_string: Option<String>,
}
impl VirtualMachineTaskDetails {
    pub fn new(job_task_details: JobTaskDetails) -> Self {
        Self {
            job_task_details,
            skipped_reason: None,
            skipped_reason_string: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmNicUpdatesTaskDetails {
    #[serde(flatten)]
    pub task_type_details: TaskTypeDetails,
    #[serde(rename = "vmId", default, skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
    #[serde(rename = "nicId", default, skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl VmNicUpdatesTaskDetails {
    pub fn new(task_type_details: TaskTypeDetails) -> Self {
        Self {
            task_type_details,
            vm_id: None,
            nic_id: None,
            name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmmDetails {
    #[serde(flatten)]
    pub fabric_specific_details: FabricSpecificDetails,
}
impl VmmDetails {
    pub fn new(fabric_specific_details: FabricSpecificDetails) -> Self {
        Self { fabric_specific_details }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmmToAzureCreateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_create_network_mapping_input: FabricSpecificCreateNetworkMappingInput,
}
impl VmmToAzureCreateNetworkMappingInput {
    pub fn new(fabric_specific_create_network_mapping_input: FabricSpecificCreateNetworkMappingInput) -> Self {
        Self {
            fabric_specific_create_network_mapping_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmmToAzureNetworkMappingSettings {
    #[serde(flatten)]
    pub network_mapping_fabric_specific_settings: NetworkMappingFabricSpecificSettings,
}
impl VmmToAzureNetworkMappingSettings {
    pub fn new(network_mapping_fabric_specific_settings: NetworkMappingFabricSpecificSettings) -> Self {
        Self {
            network_mapping_fabric_specific_settings,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmmToAzureUpdateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_update_network_mapping_input: FabricSpecificUpdateNetworkMappingInput,
}
impl VmmToAzureUpdateNetworkMappingInput {
    pub fn new(fabric_specific_update_network_mapping_input: FabricSpecificUpdateNetworkMappingInput) -> Self {
        Self {
            fabric_specific_update_network_mapping_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmmToVmmCreateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_create_network_mapping_input: FabricSpecificCreateNetworkMappingInput,
}
impl VmmToVmmCreateNetworkMappingInput {
    pub fn new(fabric_specific_create_network_mapping_input: FabricSpecificCreateNetworkMappingInput) -> Self {
        Self {
            fabric_specific_create_network_mapping_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmmToVmmNetworkMappingSettings {
    #[serde(flatten)]
    pub network_mapping_fabric_specific_settings: NetworkMappingFabricSpecificSettings,
}
impl VmmToVmmNetworkMappingSettings {
    pub fn new(network_mapping_fabric_specific_settings: NetworkMappingFabricSpecificSettings) -> Self {
        Self {
            network_mapping_fabric_specific_settings,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmmToVmmUpdateNetworkMappingInput {
    #[serde(flatten)]
    pub fabric_specific_update_network_mapping_input: FabricSpecificUpdateNetworkMappingInput,
}
impl VmmToVmmUpdateNetworkMappingInput {
    pub fn new(fabric_specific_update_network_mapping_input: FabricSpecificUpdateNetworkMappingInput) -> Self {
        Self {
            fabric_specific_update_network_mapping_input,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmmVirtualMachineDetails {
    #[serde(flatten)]
    pub hyper_v_virtual_machine_details: HyperVVirtualMachineDetails,
}
impl VmmVirtualMachineDetails {
    pub fn new(hyper_v_virtual_machine_details: HyperVVirtualMachineDetails) -> Self {
        Self {
            hyper_v_virtual_machine_details,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VmwareCbtPolicyDetails {
    #[serde(flatten)]
    pub policy_provider_specific_details: PolicyProviderSpecificDetails,
    #[serde(rename = "recoveryPointHistoryInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_history_in_minutes: Option<i32>,
    #[serde(rename = "appConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub app_consistent_frequency_in_minutes: Option<i32>,
    #[serde(rename = "crashConsistentFrequencyInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub crash_consistent_frequency_in_minutes: Option<i32>,
}
impl VmwareCbtPolicyDetails {
    pub fn new(policy_provider_specific_details: PolicyProviderSpecificDetails) -> Self {
        Self {
            policy_provider_specific_details,
            recovery_point_history_in_minutes: None,
            app_consistent_frequency_in_minutes: None,
            crash_consistent_frequency_in_minutes: None,
        }
    }
}
