#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "AzureBackupServer (DPMVenus) workload-specific protection container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBackupServerContainer {
    #[serde(flatten)]
    pub dpm_container: DpmContainer,
}
impl AzureBackupServerContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Backup engine type when Azure Backup Server is used to manage the backups."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBackupServerEngine {
    #[serde(flatten)]
    pub backup_engine_base: BackupEngineBase,
}
impl AzureBackupServerEngine {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "AzureFileShare workload-specific backup request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareBackupRequest {
    #[serde(flatten)]
    pub backup_request: BackupRequest,
    #[doc = "Backup copy will expire after the time specified (UTC)."]
    #[serde(rename = "recoveryPointExpiryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_expiry_time_in_utc: Option<String>,
}
impl AzureFileShareBackupRequest {
    pub fn new(backup_request: BackupRequest) -> Self {
        Self {
            backup_request,
            recovery_point_expiry_time_in_utc: None,
        }
    }
}
#[doc = "Protectable item for Azure Fileshare workloads."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFileShareProtectableItem {
    #[serde(flatten)]
    pub workload_protectable_item: WorkloadProtectableItem,
    #[doc = "Full Fabric ID of container to which this protectable item belongs. For example, ARM ID."]
    #[serde(rename = "parentContainerFabricId", default, skip_serializing_if = "Option::is_none")]
    pub parent_container_fabric_id: Option<String>,
    #[doc = "Friendly name of container to which this protectable item belongs."]
    #[serde(rename = "parentContainerFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub parent_container_friendly_name: Option<String>,
    #[doc = "File Share type XSync or XSMB."]
    #[serde(rename = "azureFileShareType", default, skip_serializing_if = "Option::is_none")]
    pub azure_file_share_type: Option<azure_file_share_protectable_item::AzureFileShareType>,
}
impl AzureFileShareProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_file_share_protectable_item {
    use super::*;
    #[doc = "File Share type XSync or XSMB."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureFileShareType {
        Invalid,
        #[serde(rename = "XSMB")]
        Xsmb,
        XSync,
    }
}
#[doc = "Update snapshot Uri with the correct friendly Name of the source Azure file share."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareProvisionIlrRequest {
    #[serde(flatten)]
    pub ilr_request: IlrRequest,
    #[doc = "Recovery point ID."]
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[doc = "Source Storage account ARM Id"]
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
}
impl AzureFileShareProvisionIlrRequest {
    pub fn new(ilr_request: IlrRequest) -> Self {
        Self {
            ilr_request,
            recovery_point_id: None,
            source_resource_id: None,
        }
    }
}
#[doc = "IaaS VM workload-specific backup item representing a classic virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSClassicComputeVmContainer {
    #[serde(flatten)]
    pub iaa_svm_container: IaaSvmContainer,
}
impl AzureIaaSClassicComputeVmContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IaaS VM workload-specific backup item representing the Classic Compute VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSClassicComputeVmProtectableItem {
    #[serde(flatten)]
    pub iaa_svm_protectable_item: IaaSvmProtectableItem,
}
impl AzureIaaSClassicComputeVmProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSComputeVmContainer {
    #[serde(flatten)]
    pub iaa_svm_container: IaaSvmContainer,
}
impl AzureIaaSComputeVmContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IaaS VM workload-specific backup item representing the Azure Resource Manager VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSComputeVmProtectableItem {
    #[serde(flatten)]
    pub iaa_svm_protectable_item: IaaSvmProtectableItem,
}
impl AzureIaaSComputeVmProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container for SQL workloads under SQL Availability Group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlagWorkloadContainerProtectionContainer {
    #[serde(flatten)]
    pub azure_workload_container: AzureWorkloadContainer,
}
impl AzureSqlagWorkloadContainerProtectionContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Sql workload-specific container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
}
impl AzureSqlContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Storage Account workload-specific container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[doc = "Fully qualified ARM url."]
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[doc = "Storage account version."]
    #[serde(rename = "storageAccountVersion", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_version: Option<String>,
    #[doc = "Resource group name of Recovery Services Vault."]
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[doc = "Number of items backed up in this container."]
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i64>,
}
impl AzureStorageContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Storage-specific protectable containers"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageProtectableContainer {
    #[serde(flatten)]
    pub protectable_container: ProtectableContainer,
}
impl AzureStorageProtectableContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure workload-specific container"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmAppContainerProtectableContainer {
    #[serde(flatten)]
    pub protectable_container: ProtectableContainer,
}
impl AzureVmAppContainerProtectableContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container for SQL workloads under Azure Virtual Machines."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmAppContainerProtectionContainer {
    #[serde(flatten)]
    pub azure_workload_container: AzureWorkloadContainer,
}
impl AzureVmAppContainerProtectionContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific workload item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadItem {
    #[serde(flatten)]
    pub workload_item: WorkloadItem,
    #[doc = "Name for instance or AG"]
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    #[doc = "Host/Cluster Name for instance or AG"]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "Indicates if workload item is auto-protectable"]
    #[serde(rename = "isAutoProtectable", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_protectable: Option<bool>,
    #[doc = "For instance or AG, indicates number of DB's present"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subinquireditemcount: Option<i32>,
    #[doc = "For instance or AG, indicates number of DB's to be protected"]
    #[serde(rename = "subWorkloadItemCount", default, skip_serializing_if = "Option::is_none")]
    pub sub_workload_item_count: Option<i32>,
}
impl AzureVmWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific protectable item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadProtectableItem {
    #[serde(flatten)]
    pub workload_protectable_item: WorkloadProtectableItem,
    #[doc = "Name for instance or AG"]
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    #[doc = "Parent Unique Name is added to provide the service formatted URI Name of the Parent\r\nOnly Applicable for data bases where the parent would be either Instance or a SQL AG."]
    #[serde(rename = "parentUniqueName", default, skip_serializing_if = "Option::is_none")]
    pub parent_unique_name: Option<String>,
    #[doc = "Host/Cluster Name for instance or AG"]
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[doc = "Indicates if protectable item is auto-protectable"]
    #[serde(rename = "isAutoProtectable", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_protectable: Option<bool>,
    #[doc = "Indicates if protectable item is auto-protected"]
    #[serde(rename = "isAutoProtected", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_protected: Option<bool>,
    #[doc = "For instance or AG, indicates number of DB's present"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subinquireditemcount: Option<i32>,
    #[doc = "For instance or AG, indicates number of DB's to be protected"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subprotectableitemcount: Option<i32>,
    #[doc = "Pre-backup validation for Azure VM Workload provider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prebackupvalidation: Option<PreBackupValidation>,
}
impl AzureVmWorkloadProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific workload item representing SAP ASE Database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapAseDatabaseWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapAseDatabaseWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific protectable item representing SAP ASE System."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapAseSystemProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSapAseSystemProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific workload item representing SAP ASE System."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapAseSystemWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapAseSystemWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific protectable item representing SAP HANA Database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapHanaDatabaseProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSapHanaDatabaseProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific workload item representing SAP HANA Database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapHanaDatabaseWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapHanaDatabaseWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific protectable item representing SAP HANA System."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapHanaSystemProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSapHanaSystemProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific workload item representing SAP HANA System."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapHanaSystemWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapHanaSystemWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific protectable item representing SQL Availability Group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlAvailabilityGroupProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSqlAvailabilityGroupProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific protectable item representing SQL Database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlDatabaseProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSqlDatabaseProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific workload item representing SQL Database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlDatabaseWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSqlDatabaseWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific protectable item representing SQL Instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlInstanceProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSqlInstanceProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure VM workload-specific workload item representing SQL Instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlInstanceWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
    #[doc = "Data Directory Paths for default directories"]
    #[serde(rename = "dataDirectoryPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub data_directory_paths: Vec<SqlDataDirectory>,
}
impl AzureVmWorkloadSqlInstanceWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "AzureWorkload workload-specific backup request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadBackupRequest {
    #[serde(flatten)]
    pub backup_request: BackupRequest,
    #[doc = "Type of backup, viz. Full, Differential, Log or CopyOnlyFull"]
    #[serde(rename = "backupType", default, skip_serializing_if = "Option::is_none")]
    pub backup_type: Option<azure_workload_backup_request::BackupType>,
    #[doc = "Bool for Compression setting"]
    #[serde(rename = "enableCompression", default, skip_serializing_if = "Option::is_none")]
    pub enable_compression: Option<bool>,
    #[doc = "Backup copy will expire after the time specified (UTC)."]
    #[serde(rename = "recoveryPointExpiryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_expiry_time_in_utc: Option<String>,
}
impl AzureWorkloadBackupRequest {
    pub fn new(backup_request: BackupRequest) -> Self {
        Self {
            backup_request,
            backup_type: None,
            enable_compression: None,
            recovery_point_expiry_time_in_utc: None,
        }
    }
}
pub mod azure_workload_backup_request {
    use super::*;
    #[doc = "Type of backup, viz. Full, Differential, Log or CopyOnlyFull"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupType {
        Invalid,
        Full,
        Differential,
        Log,
        CopyOnlyFull,
    }
}
#[doc = "Container for the workloads running inside Azure Compute or Classic Compute."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[doc = "ARM ID of the virtual machine represented by this Azure Workload Container"]
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[doc = "Time stamp when this container was updated."]
    #[serde(rename = "lastUpdatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_time: Option<String>,
    #[doc = "Extended information of the container."]
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureWorkloadContainerExtendedInfo>,
    #[doc = "Workload type for which registration was sent."]
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<azure_workload_container::WorkloadType>,
    #[doc = "Re-Do Operation"]
    #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
    pub operation_type: Option<azure_workload_container::OperationType>,
}
impl AzureWorkloadContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_workload_container {
    use super::*;
    #[doc = "Workload type for which registration was sent."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[doc = "Re-Do Operation"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationType {
        Invalid,
        Register,
        Reregister,
    }
}
#[doc = "Extended information of the container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadContainerExtendedInfo {
    #[doc = "Host Os Name in case of Stand Alone and Cluster Name in case of distributed container."]
    #[serde(rename = "hostServerName", default, skip_serializing_if = "Option::is_none")]
    pub host_server_name: Option<String>,
    #[doc = "Details about inquired protectable items under a given container."]
    #[serde(rename = "inquiryInfo", default, skip_serializing_if = "Option::is_none")]
    pub inquiry_info: Option<InquiryInfo>,
    #[doc = "List of the nodes in case of distributed container."]
    #[serde(rename = "nodesList", default, skip_serializing_if = "Vec::is_empty")]
    pub nodes_list: Vec<DistributedNodesInfo>,
}
impl AzureWorkloadContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Query parameters to fetch list of backup engines."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsBackupEngineQueryObject {
    #[doc = "attribute to add extended info"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
}
impl BmsBackupEngineQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Query parameters to fetch list of backup engines."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsBackupEnginesQueryObject {
    #[doc = "Backup management type for the backup engine."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_backup_engines_query_object::BackupManagementType>,
    #[doc = "Friendly name of the backup engine."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Attribute to add extended info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
}
impl BmsBackupEnginesQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_backup_engines_query_object {
    use super::*;
    #[doc = "Backup management type for the backup engine."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
}
#[doc = "The query filters that can be used with the list containers API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BmsContainerQueryObject {
    #[doc = "Backup management type for this container."]
    #[serde(rename = "backupManagementType")]
    pub backup_management_type: bms_container_query_object::BackupManagementType,
    #[doc = "Type of container for filter"]
    #[serde(rename = "containerType", default, skip_serializing_if = "Option::is_none")]
    pub container_type: Option<bms_container_query_object::ContainerType>,
    #[doc = "Backup engine name"]
    #[serde(rename = "backupEngineName", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_name: Option<String>,
    #[doc = "Fabric name for filter"]
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[doc = "Status of registration of this container with the Recovery Services Vault."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Friendly name of this container."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl BmsContainerQueryObject {
    pub fn new(backup_management_type: bms_container_query_object::BackupManagementType) -> Self {
        Self {
            backup_management_type,
            container_type: None,
            backup_engine_name: None,
            fabric_name: None,
            status: None,
            friendly_name: None,
        }
    }
}
pub mod bms_container_query_object {
    use super::*;
    #[doc = "Backup management type for this container."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[doc = "Type of container for filter"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ContainerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
}
#[doc = "The query filters that can be used with the inquire container API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsContainersInquiryQueryObject {
    #[doc = "Backup management type for this container."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_containers_inquiry_query_object::BackupManagementType>,
    #[doc = "Workload type for this container."]
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<bms_containers_inquiry_query_object::WorkloadType>,
}
impl BmsContainersInquiryQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_containers_inquiry_query_object {
    use super::*;
    #[doc = "Backup management type for this container."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[doc = "Workload type for this container."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[doc = "Filters to list items that can be backed up."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmspoQueryObject {
    #[doc = "Backup management type."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bmspo_query_object::BackupManagementType>,
    #[doc = "Workload type"]
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<bmspo_query_object::WorkloadType>,
    #[doc = "Full name of the container whose Protectable Objects should be returned."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "Backup status query parameter."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Friendly name."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl BmspoQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bmspo_query_object {
    use super::*;
    #[doc = "Backup management type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureSql,
        AzureBackupServer,
        AzureWorkload,
        AzureStorage,
        DefaultBackup,
    }
    #[doc = "Workload type"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[doc = "The query filters that can be used with the refresh container API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsRefreshContainersQueryObject {
    #[doc = "Backup management type for this container."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_refresh_containers_query_object::BackupManagementType>,
}
impl BmsRefreshContainersQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_refresh_containers_query_object {
    use super::*;
    #[doc = "Backup management type for this container."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
}
#[doc = "Filters to list items that can be backed up."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsWorkloadItemQueryObject {
    #[doc = "Backup management type."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_workload_item_query_object::BackupManagementType>,
    #[doc = "Workload Item type"]
    #[serde(rename = "workloadItemType", default, skip_serializing_if = "Option::is_none")]
    pub workload_item_type: Option<bms_workload_item_query_object::WorkloadItemType>,
    #[doc = "Workload type"]
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<bms_workload_item_query_object::WorkloadType>,
    #[doc = "Backup status query parameter."]
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<bms_workload_item_query_object::ProtectionStatus>,
}
impl BmsWorkloadItemQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_workload_item_query_object {
    use super::*;
    #[doc = "Backup management type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureSql,
        AzureBackupServer,
        AzureWorkload,
        AzureStorage,
        DefaultBackup,
    }
    #[doc = "Workload Item type"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadItemType {
        Invalid,
        #[serde(rename = "SQLInstance")]
        SqlInstance,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        #[serde(rename = "SAPHanaSystem")]
        SapHanaSystem,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseSystem")]
        SapAseSystem,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[doc = "Workload type"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[doc = "Backup status query parameter."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionStatus {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[doc = "The base backup engine class. All workload specific backup engines derive from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineBase {
    #[doc = "Friendly name of the backup engine."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Type of backup management for the backup engine."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<backup_engine_base::BackupManagementType>,
    #[doc = "Registration status of the backup engine with the Recovery Services Vault."]
    #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub registration_status: Option<String>,
    #[doc = "Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}"]
    #[serde(rename = "backupEngineState", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_state: Option<String>,
    #[doc = "Backup status of the backup engine."]
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<String>,
    #[doc = "Type of the backup engine."]
    #[serde(rename = "backupEngineType", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_type: Option<backup_engine_base::BackupEngineType>,
    #[doc = "Flag indicating if the backup engine be registered, once already registered."]
    #[serde(rename = "canReRegister", default, skip_serializing_if = "Option::is_none")]
    pub can_re_register: Option<bool>,
    #[doc = "ID of the backup engine."]
    #[serde(rename = "backupEngineId", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_id: Option<String>,
    #[doc = "Backup engine version"]
    #[serde(rename = "dpmVersion", default, skip_serializing_if = "Option::is_none")]
    pub dpm_version: Option<String>,
    #[doc = "Backup agent version"]
    #[serde(rename = "azureBackupAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub azure_backup_agent_version: Option<String>,
    #[doc = "To check if backup agent upgrade available"]
    #[serde(rename = "isAzureBackupAgentUpgradeAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_azure_backup_agent_upgrade_available: Option<bool>,
    #[doc = "To check if backup engine upgrade available"]
    #[serde(rename = "isDpmUpgradeAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_dpm_upgrade_available: Option<bool>,
    #[doc = "Additional information on backup engine."]
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<BackupEngineExtendedInfo>,
}
impl BackupEngineBase {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_engine_base {
    use super::*;
    #[doc = "Type of backup management for the backup engine."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[doc = "Type of the backup engine."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupEngineType {
        Invalid,
        DpmBackupEngine,
        AzureBackupServerEngine,
    }
}
#[doc = "The base backup engine class. All workload specific backup engines derive from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineBaseResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The base backup engine class. All workload specific backup engines derive from this class."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupEngineBase>,
}
impl BackupEngineBaseResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of BackupEngineBase resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineBaseResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[doc = "List of resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackupEngineBaseResource>,
}
impl BackupEngineBaseResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Additional information on backup engine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineExtendedInfo {
    #[doc = "Database name of backup engine."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "Number of protected items in the backup engine."]
    #[serde(rename = "protectedItemsCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_items_count: Option<i32>,
    #[doc = "Number of protected servers in the backup engine."]
    #[serde(rename = "protectedServersCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_servers_count: Option<i32>,
    #[doc = "Number of disks in the backup engine."]
    #[serde(rename = "diskCount", default, skip_serializing_if = "Option::is_none")]
    pub disk_count: Option<i32>,
    #[doc = "Disk space used in the backup engine."]
    #[serde(rename = "usedDiskSpace", default, skip_serializing_if = "Option::is_none")]
    pub used_disk_space: Option<f64>,
    #[doc = "Disk space currently available in the backup engine."]
    #[serde(rename = "availableDiskSpace", default, skip_serializing_if = "Option::is_none")]
    pub available_disk_space: Option<f64>,
    #[doc = "Last refresh time in the backup engine."]
    #[serde(rename = "refreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub refreshed_at: Option<String>,
    #[doc = "Protected instances in the backup engine."]
    #[serde(rename = "azureProtectedInstances", default, skip_serializing_if = "Option::is_none")]
    pub azure_protected_instances: Option<i32>,
}
impl BackupEngineExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for backup request. Workload-specific backup requests are derived from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupRequest {
    #[doc = "This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types."]
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl BackupRequest {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[doc = "Base class for backup request. Workload-specific backup requests are derived from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupRequestResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Base class for backup request. Workload-specific backup requests are derived from this class."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupRequest>,
}
impl BackupRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource storage details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceConfig {
    #[doc = "Storage type"]
    #[serde(rename = "storageModelType", default, skip_serializing_if = "Option::is_none")]
    pub storage_model_type: Option<backup_resource_config::StorageModelType>,
    #[doc = "Storage type."]
    #[serde(rename = "storageType", default, skip_serializing_if = "Option::is_none")]
    pub storage_type: Option<backup_resource_config::StorageType>,
    #[doc = "Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked."]
    #[serde(rename = "storageTypeState", default, skip_serializing_if = "Option::is_none")]
    pub storage_type_state: Option<backup_resource_config::StorageTypeState>,
}
impl BackupResourceConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_resource_config {
    use super::*;
    #[doc = "Storage type"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageModelType {
        Invalid,
        GeoRedundant,
        LocallyRedundant,
    }
    #[doc = "Storage type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageType {
        Invalid,
        GeoRedundant,
        LocallyRedundant,
    }
    #[doc = "Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageTypeState {
        Invalid,
        Locked,
        Unlocked,
    }
}
#[doc = "The resource storage details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceConfigResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The resource storage details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupResourceConfig>,
}
impl BackupResourceConfigResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Client script details for file / folder restore."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientScriptForConnect {
    #[doc = "File content of the client script for file / folder restore."]
    #[serde(rename = "scriptContent", default, skip_serializing_if = "Option::is_none")]
    pub script_content: Option<String>,
    #[doc = "File extension of the client script for file / folder restore - .ps1 , .sh , etc."]
    #[serde(rename = "scriptExtension", default, skip_serializing_if = "Option::is_none")]
    pub script_extension: Option<String>,
    #[doc = "OS type - Windows, Linux etc. for which this file / folder restore client script works."]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[doc = "URL of Executable from where to source the content. If this is not null then ScriptContent should not be used"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[doc = "Mandatory suffix that should be added to the name of script that is given for download to user.\r\nIf its null or empty then , ignore it."]
    #[serde(rename = "scriptNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub script_name_suffix: Option<String>,
}
impl ClientScriptForConnect {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container identity information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerIdentityInfo {
    #[doc = "Unique name of the container"]
    #[serde(rename = "uniqueName", default, skip_serializing_if = "Option::is_none")]
    pub unique_name: Option<String>,
    #[doc = "Protection container identity - AAD Tenant"]
    #[serde(rename = "aadTenantId", default, skip_serializing_if = "Option::is_none")]
    pub aad_tenant_id: Option<String>,
    #[doc = "Protection container identity - AAD Service Principal"]
    #[serde(rename = "servicePrincipalClientId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_client_id: Option<String>,
    #[doc = "Protection container identity - Audience"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub audience: Option<String>,
}
impl ContainerIdentityInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Additional information of the DPMContainer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmContainerExtendedInfo {
    #[doc = "Last refresh time of the DPMContainer."]
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
}
impl DpmContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This is used to represent the various nodes of the distributed container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DistributedNodesInfo {
    #[doc = "Name of the node under a distributed container."]
    #[serde(rename = "nodeName", default, skip_serializing_if = "Option::is_none")]
    pub node_name: Option<String>,
    #[doc = "Status of this Node.\r\nFailed | Succeeded"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Error Detail class which encapsulates Code, Message and Recommendations."]
    #[serde(rename = "errorDetail", default, skip_serializing_if = "Option::is_none")]
    pub error_detail: Option<ErrorDetail>,
}
impl DistributedNodesInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Data Protection Manager (DPM) specific backup engine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmBackupEngine {
    #[serde(flatten)]
    pub backup_engine_base: BackupEngineBase,
}
impl DpmBackupEngine {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DPM workload-specific protection container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[doc = "Specifies whether the container is re-registrable."]
    #[serde(rename = "canReRegister", default, skip_serializing_if = "Option::is_none")]
    pub can_re_register: Option<bool>,
    #[doc = "ID of container."]
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
    #[doc = "Number of protected items in the BackupEngine"]
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i64>,
    #[doc = "Backup engine Agent version"]
    #[serde(rename = "dpmAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub dpm_agent_version: Option<String>,
    #[doc = "List of BackupEngines protecting the container"]
    #[serde(rename = "dpmServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dpm_servers: Vec<String>,
    #[doc = "To check if upgrade available"]
    #[serde(rename = "upgradeAvailable", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_available: Option<bool>,
    #[doc = "Protection status of the container."]
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[doc = "Additional information of the DPMContainer."]
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<DpmContainerExtendedInfo>,
}
impl DpmContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Error Detail class which encapsulates Code, Message and Recommendations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetail {
    #[doc = "Error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error Message related to the Code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "List of recommendation strings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl ErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for generic container of backup items"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenericContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[doc = "Name of the container's fabric"]
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[doc = "Container extended information"]
    #[serde(rename = "extendedInformation", default, skip_serializing_if = "Option::is_none")]
    pub extended_information: Option<GenericContainerExtendedInfo>,
}
impl GenericContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container extended information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenericContainerExtendedInfo {
    #[doc = "Public key of container cert"]
    #[serde(rename = "rawCertData", default, skip_serializing_if = "Option::is_none")]
    pub raw_cert_data: Option<String>,
    #[doc = "Container identity information"]
    #[serde(rename = "containerIdentityInfo", default, skip_serializing_if = "Option::is_none")]
    pub container_identity_info: Option<ContainerIdentityInfo>,
    #[doc = "Azure Backup Service Endpoints for the container"]
    #[serde(rename = "serviceEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub service_endpoints: Option<serde_json::Value>,
}
impl GenericContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters to Provision ILR API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IlrRequest {
    #[doc = "This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types."]
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl IlrRequest {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[doc = "Parameters to Provision ILR API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IlrRequestResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Parameters to Provision ILR API."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IlrRequest>,
}
impl IlrRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IaaS VM workload-specific container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IaaSvmContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[doc = "Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container."]
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
    #[doc = "Specifies whether the container represents a Classic or an Azure Resource Manager VM."]
    #[serde(rename = "virtualMachineVersion", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_version: Option<String>,
    #[doc = "Resource group name of Recovery Services Vault."]
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl IaaSvmContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IaaS VM workload-specific backup item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IaaSvmProtectableItem {
    #[serde(flatten)]
    pub workload_protectable_item: WorkloadProtectableItem,
    #[doc = "Fully qualified ARM ID of the virtual machine."]
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
}
impl IaaSvmProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IaaS VM workload-specific backup request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmBackupRequest {
    #[serde(flatten)]
    pub backup_request: BackupRequest,
    #[doc = "Backup copy will expire after the time specified (UTC)."]
    #[serde(rename = "recoveryPointExpiryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_expiry_time_in_utc: Option<String>,
}
impl IaasVmBackupRequest {
    pub fn new(backup_request: BackupRequest) -> Self {
        Self {
            backup_request,
            recovery_point_expiry_time_in_utc: None,
        }
    }
}
#[doc = "Restore files/folders from a backup copy of IaaS VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmilrRegistrationRequest {
    #[serde(flatten)]
    pub ilr_request: IlrRequest,
    #[doc = "ID of the IaaS VM backup copy from where the files/folders have to be restored."]
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[doc = "Fully qualified ARM ID of the virtual machine whose the files / folders have to be restored."]
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
    #[doc = "iSCSI initiator name."]
    #[serde(rename = "initiatorName", default, skip_serializing_if = "Option::is_none")]
    pub initiator_name: Option<String>,
    #[doc = "Whether to renew existing registration with the iSCSI server."]
    #[serde(rename = "renewExistingRegistration", default, skip_serializing_if = "Option::is_none")]
    pub renew_existing_registration: Option<bool>,
}
impl IaasVmilrRegistrationRequest {
    pub fn new(ilr_request: IlrRequest) -> Self {
        Self {
            ilr_request,
            recovery_point_id: None,
            virtual_machine_id: None,
            initiator_name: None,
            renew_existing_registration: None,
        }
    }
}
#[doc = "Details about inquired protectable items under a given container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InquiryInfo {
    #[doc = "Inquiry Status for this container such as\r\nInProgress | Failed | Succeeded"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Error Detail class which encapsulates Code, Message and Recommendations."]
    #[serde(rename = "errorDetail", default, skip_serializing_if = "Option::is_none")]
    pub error_detail: Option<ErrorDetail>,
    #[doc = "Inquiry Details which will have workload specific details.\r\nFor e.g. - For SQL and oracle this will contain different details."]
    #[serde(rename = "inquiryDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub inquiry_details: Vec<WorkloadInquiryDetails>,
}
impl InquiryInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Validation for inquired protectable items under a given container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InquiryValidation {
    #[doc = "Status for the Inquiry Validation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Error Detail class which encapsulates Code, Message and Recommendations."]
    #[serde(rename = "errorDetail", default, skip_serializing_if = "Option::is_none")]
    pub error_detail: Option<ErrorDetail>,
    #[doc = "Error Additional Detail in case the status is non-success."]
    #[serde(rename = "additionalDetail", default, skip_serializing_if = "Option::is_none")]
    pub additional_detail: Option<String>,
}
impl InquiryValidation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Target details for file / folder restore."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstantItemRecoveryTarget {
    #[doc = "List of client scripts."]
    #[serde(rename = "clientScripts", default, skip_serializing_if = "Vec::is_empty")]
    pub client_scripts: Vec<ClientScriptForConnect>,
}
impl InstantItemRecoveryTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "MAB workload-specific Health Details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabContainerHealthDetails {
    #[doc = "Health Code"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<i32>,
    #[doc = "Health Title"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[doc = "Health Message"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "Health Recommended Actions"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl MabContainerHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container with items backed up using MAB backup engine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[doc = "Can the container be registered one more time."]
    #[serde(rename = "canReRegister", default, skip_serializing_if = "Option::is_none")]
    pub can_re_register: Option<bool>,
    #[doc = "ContainerID represents the container."]
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<i64>,
    #[doc = "Number of items backed up in this container."]
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i64>,
    #[doc = "Agent version of this container."]
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[doc = "Additional information of the container."]
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<MabContainerExtendedInfo>,
    #[doc = "Health details on this mab container."]
    #[serde(rename = "mabContainerHealthDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub mab_container_health_details: Vec<MabContainerHealthDetails>,
    #[doc = "Health state of mab container."]
    #[serde(rename = "containerHealthState", default, skip_serializing_if = "Option::is_none")]
    pub container_health_state: Option<String>,
}
impl MabContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Additional information of the container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabContainerExtendedInfo {
    #[doc = "Time stamp when this container was refreshed."]
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
    #[doc = "Type of backup items associated with this container."]
    #[serde(rename = "backupItemType", default, skip_serializing_if = "Option::is_none")]
    pub backup_item_type: Option<mab_container_extended_info::BackupItemType>,
    #[doc = "List of backup items associated with this container."]
    #[serde(rename = "backupItems", default, skip_serializing_if = "Vec::is_empty")]
    pub backup_items: Vec<String>,
    #[doc = "Backup policy associated with this container."]
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    #[doc = "Latest backup status of this container."]
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
}
impl MabContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod mab_container_extended_info {
    use super::*;
    #[doc = "Type of backup items associated with this container."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupItemType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[doc = "Operation status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatus {
    #[doc = "ID of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Name of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Operation status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<operation_status::Status>,
    #[doc = "Operation start time. Format: ISO-8601."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "Operation end time. Format: ISO-8601."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "Error information associated with operation status call."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<OperationStatusError>,
    #[doc = "Base class for additional information of operation status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationStatusExtendedInfo>,
}
impl OperationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_status {
    use super::*;
    #[doc = "Operation status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        InProgress,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[doc = "Error information associated with operation status call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatusError {
    #[doc = "Error code of the operation failure."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message displayed if the operation failure."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl OperationStatusError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for additional information of operation status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusExtendedInfo {
    #[doc = "This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types."]
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl OperationStatusExtendedInfo {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[doc = "Operation status job extended info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusJobExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[doc = "ID of the job created for this protected item."]
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
}
impl OperationStatusJobExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            job_id: None,
        }
    }
}
#[doc = "Operation status extended info for list of jobs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusJobsExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[doc = "IDs of the jobs created for the protected item."]
    #[serde(rename = "jobIds", default, skip_serializing_if = "Vec::is_empty")]
    pub job_ids: Vec<String>,
    #[doc = "Stores all the failed jobs along with the corresponding error codes."]
    #[serde(rename = "failedJobsError", default, skip_serializing_if = "Option::is_none")]
    pub failed_jobs_error: Option<serde_json::Value>,
}
impl OperationStatusJobsExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            job_ids: Vec::new(),
            failed_jobs_error: None,
        }
    }
}
#[doc = "Operation status extended info for ILR provision action."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusProvisionIlrExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[doc = "Target details for file / folder restore."]
    #[serde(rename = "recoveryTarget", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target: Option<InstantItemRecoveryTarget>,
}
impl OperationStatusProvisionIlrExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            recovery_target: None,
        }
    }
}
#[doc = "Pre-backup validation for Azure VM Workload provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PreBackupValidation {
    #[doc = "Status of protectable item, i.e. InProgress,Succeeded,Failed"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<pre_backup_validation::Status>,
    #[doc = "Error code of protectable item"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Message corresponding to the error code for the protectable item"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl PreBackupValidation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pre_backup_validation {
    use super::*;
    #[doc = "Status of protectable item, i.e. InProgress,Succeeded,Failed"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        Success,
        Failed,
    }
}
#[doc = "Protectable Container Class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableContainer {
    #[doc = "Friendly name of the container."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Type of backup management for the container."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protectable_container::BackupManagementType>,
    #[doc = "Type of the container. The value of this property for\r\n1. Compute Azure VM is Microsoft.Compute/virtualMachines\r\n2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines"]
    #[serde(rename = "protectableContainerType", default, skip_serializing_if = "Option::is_none")]
    pub protectable_container_type: Option<protectable_container::ProtectableContainerType>,
    #[doc = "Status of health of the container."]
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<String>,
    #[doc = "Fabric Id of the container such as ARM Id."]
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
}
impl ProtectableContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protectable_container {
    use super::*;
    #[doc = "Type of backup management for the container."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[doc = "Type of the container. The value of this property for\r\n1. Compute Azure VM is Microsoft.Compute/virtualMachines\r\n2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectableContainerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
}
#[doc = "Protectable Container Class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Protectable Container Class."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectableContainer>,
}
impl ProtectableContainerResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of ProtectableContainer resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableContainerResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[doc = "List of resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectableContainerResource>,
}
impl ProtectableContainerResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for container with backup items. Containers with specific workloads are derived from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainer {
    #[doc = "Friendly name of the container."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "Type of backup management for the container."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protection_container::BackupManagementType>,
    #[doc = "Status of registration of the container with the Recovery Services Vault."]
    #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub registration_status: Option<String>,
    #[doc = "Status of health of the container."]
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<String>,
    #[doc = "Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.\r\nClassic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is\r\nWindows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload\r\nBackup is VMAppContainer"]
    #[serde(rename = "containerType", default, skip_serializing_if = "Option::is_none")]
    pub container_type: Option<protection_container::ContainerType>,
}
impl ProtectionContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protection_container {
    use super::*;
    #[doc = "Type of backup management for the container."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[doc = "Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.\r\nClassic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is\r\nWindows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload\r\nBackup is VMAppContainer"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ContainerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
}
#[doc = "Base class for container with backup items. Containers with specific workloads are derived from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Base class for container with backup items. Containers with specific workloads are derived from this class."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectionContainer>,
}
impl ProtectionContainerResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of ProtectionContainer resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[doc = "List of resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectionContainerResource>,
}
impl ProtectionContainerResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for backup copies. Workload-specific backup copies are derived from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPoint {
    #[doc = "This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types."]
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl RecoveryPoint {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[doc = "ARM Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id represents the complete path to the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name associated with the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/..."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Optional ETag."]
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base for all lists of resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceList {
    #[doc = "The uri to fetch the next page of resources. Call ListNext() fetches next page of resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SQLDataDirectory info"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDataDirectory {
    #[doc = "Type of data directory mapping"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<sql_data_directory::Type>,
    #[doc = "File path"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "Logical name of the file"]
    #[serde(rename = "logicalName", default, skip_serializing_if = "Option::is_none")]
    pub logical_name: Option<String>,
}
impl SqlDataDirectory {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_data_directory {
    use super::*;
    #[doc = "Type of data directory mapping"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        Data,
        Log,
    }
}
#[doc = "The token information details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenInformation {
    #[doc = "Token value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub token: Option<String>,
    #[doc = "Expiry time of token."]
    #[serde(rename = "expiryTimeInUtcTicks", default, skip_serializing_if = "Option::is_none")]
    pub expiry_time_in_utc_ticks: Option<i64>,
    #[doc = "Security PIN"]
    #[serde(rename = "securityPIN", default, skip_serializing_if = "Option::is_none")]
    pub security_pin: Option<String>,
}
impl TokenInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details of an inquired protectable item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadInquiryDetails {
    #[doc = "Type of the Workload such as SQL, Oracle etc."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Contains the protectable item Count inside this Container."]
    #[serde(rename = "itemCount", default, skip_serializing_if = "Option::is_none")]
    pub item_count: Option<i64>,
    #[doc = "Validation for inquired protectable items under a given container."]
    #[serde(rename = "inquiryValidation", default, skip_serializing_if = "Option::is_none")]
    pub inquiry_validation: Option<InquiryValidation>,
}
impl WorkloadInquiryDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for backup item. Workload-specific backup items are derived from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadItem {
    #[doc = "Type of backup management to backup an item."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<String>,
    #[doc = "Type of workload for the backup management"]
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[doc = "Type of the backup item."]
    #[serde(rename = "workloadItemType", default, skip_serializing_if = "Option::is_none")]
    pub workload_item_type: Option<String>,
    #[doc = "Friendly name of the backup item."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "State of the back up item."]
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<workload_item::ProtectionState>,
}
impl WorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod workload_item {
    use super::*;
    #[doc = "State of the back up item."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[doc = "Base class for backup item. Workload-specific backup items are derived from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadItemResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Base class for backup item. Workload-specific backup items are derived from this class."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkloadItem>,
}
impl WorkloadItemResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of WorkloadItem resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadItemResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[doc = "List of resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkloadItemResource>,
}
impl WorkloadItemResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Base class for backup item. Workload-specific backup items are derived from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadProtectableItem {
    #[doc = "Type of backup management to backup an item."]
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<String>,
    #[doc = "Type of workload for the backup management"]
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[doc = "Type of the backup item."]
    #[serde(rename = "protectableItemType", default, skip_serializing_if = "Option::is_none")]
    pub protectable_item_type: Option<String>,
    #[doc = "Friendly name of the backup item."]
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[doc = "State of the back up item."]
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<workload_protectable_item::ProtectionState>,
}
impl WorkloadProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod workload_protectable_item {
    use super::*;
    #[doc = "State of the back up item."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[doc = "Base class for backup item. Workload-specific backup items are derived from this class."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadProtectableItemResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Base class for backup item. Workload-specific backup items are derived from this class."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkloadProtectableItem>,
}
impl WorkloadProtectableItemResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of WorkloadProtectableItem resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadProtectableItemResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[doc = "List of resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkloadProtectableItemResource>,
}
impl WorkloadProtectableItemResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
