#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadProperties {
    #[serde(rename = "servicePrincipalClientId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_client_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authority: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub audience: Option<String>,
    #[serde(rename = "servicePrincipalObjectId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_object_id: Option<String>,
}
impl AadProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadPropertiesResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AadProperties>,
}
impl AadPropertiesResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareRecoveryPoint {
    #[serde(flatten)]
    pub recovery_point: RecoveryPoint,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<String>,
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[serde(rename = "fileShareSnapshotUri", default, skip_serializing_if = "Option::is_none")]
    pub file_share_snapshot_uri: Option<String>,
    #[serde(rename = "recoveryPointSizeInGB", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_size_in_gb: Option<i32>,
}
impl AzureFileShareRecoveryPoint {
    pub fn new(recovery_point: RecoveryPoint) -> Self {
        Self {
            recovery_point,
            recovery_point_type: None,
            recovery_point_time: None,
            file_share_snapshot_uri: None,
            recovery_point_size_in_gb: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareRestoreRequest {
    #[serde(flatten)]
    pub restore_request: RestoreRequest,
    #[serde(rename = "recoveryType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_type: Option<azure_file_share_restore_request::RecoveryType>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "copyOptions", default, skip_serializing_if = "Option::is_none")]
    pub copy_options: Option<azure_file_share_restore_request::CopyOptions>,
    #[serde(rename = "restoreRequestType", default, skip_serializing_if = "Option::is_none")]
    pub restore_request_type: Option<azure_file_share_restore_request::RestoreRequestType>,
    #[serde(rename = "restoreFileSpecs", default, skip_serializing_if = "Vec::is_empty")]
    pub restore_file_specs: Vec<RestoreFileSpecs>,
    #[serde(rename = "targetDetails", default, skip_serializing_if = "Option::is_none")]
    pub target_details: Option<TargetAfsRestoreInfo>,
}
impl AzureFileShareRestoreRequest {
    pub fn new(restore_request: RestoreRequest) -> Self {
        Self {
            restore_request,
            recovery_type: None,
            source_resource_id: None,
            copy_options: None,
            restore_request_type: None,
            restore_file_specs: Vec::new(),
            target_details: None,
        }
    }
}
pub mod azure_file_share_restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryType {
        Invalid,
        OriginalLocation,
        AlternateLocation,
        RestoreDisks,
        Offline,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CopyOptions {
        Invalid,
        CreateCopy,
        Skip,
        Overwrite,
        FailOnConflict,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RestoreRequestType {
        Invalid,
        FullShareRestore,
        ItemLevelRestore,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileshareProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<azure_fileshare_protected_item::ProtectionState>,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<azure_fileshare_protected_item::HealthStatus>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
    #[serde(rename = "lastBackupTime", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_time: Option<String>,
    #[serde(rename = "kpisHealths", default, skip_serializing_if = "Option::is_none")]
    pub kpis_healths: Option<serde_json::Value>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureFileshareProtectedItemExtendedInfo>,
}
impl AzureFileshareProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            protection_status: None,
            protection_state: None,
            health_status: None,
            last_backup_status: None,
            last_backup_time: None,
            kpis_healths: None,
            extended_info: None,
        }
    }
}
pub mod azure_fileshare_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthStatus {
        Passed,
        ActionRequired,
        ActionSuggested,
        Invalid,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFileshareProtectedItemExtendedInfo {
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "policyState", default, skip_serializing_if = "Option::is_none")]
    pub policy_state: Option<String>,
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<String>,
    #[serde(rename = "resourceStateSyncTime", default, skip_serializing_if = "Option::is_none")]
    pub resource_state_sync_time: Option<String>,
}
impl AzureFileshareProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSClassicComputeVmProtectedItem {
    #[serde(flatten)]
    pub azure_iaa_svm_protected_item: AzureIaaSvmProtectedItem,
}
impl AzureIaaSClassicComputeVmProtectedItem {
    pub fn new(azure_iaa_svm_protected_item: AzureIaaSvmProtectedItem) -> Self {
        Self {
            azure_iaa_svm_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSComputeVmProtectedItem {
    #[serde(flatten)]
    pub azure_iaa_svm_protected_item: AzureIaaSvmProtectedItem,
}
impl AzureIaaSComputeVmProtectedItem {
    pub fn new(azure_iaa_svm_protected_item: AzureIaaSvmProtectedItem) -> Self {
        Self {
            azure_iaa_svm_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmErrorInfo {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorTitle", default, skip_serializing_if = "Option::is_none")]
    pub error_title: Option<String>,
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl AzureIaaSvmErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmHealthDetails {
    #[serde(flatten)]
    pub resource_health_details: ResourceHealthDetails,
}
impl AzureIaaSvmHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSvmJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<AzureIaaSvmErrorInfo>,
    #[serde(rename = "virtualMachineVersion", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_version: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureIaaSvmJobExtendedInfo>,
}
impl AzureIaaSvmJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            duration: None,
            actions_info: Vec::new(),
            error_details: Vec::new(),
            virtual_machine_version: None,
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<AzureIaaSvmJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "internalPropertyBag", default, skip_serializing_if = "Option::is_none")]
    pub internal_property_bag: Option<serde_json::Value>,
    #[serde(rename = "progressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub progress_percentage: Option<f64>,
    #[serde(rename = "estimatedRemainingDuration", default, skip_serializing_if = "Option::is_none")]
    pub estimated_remaining_duration: Option<String>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl AzureIaaSvmJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "progressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub progress_percentage: Option<f64>,
    #[serde(rename = "taskExecutionDetails", default, skip_serializing_if = "Option::is_none")]
    pub task_execution_details: Option<String>,
}
impl AzureIaaSvmJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSvmProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<azure_iaa_svm_protected_item::ProtectionState>,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<azure_iaa_svm_protected_item::HealthStatus>,
    #[serde(rename = "healthDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub health_details: Vec<AzureIaaSvmHealthDetails>,
    #[serde(rename = "kpisHealths", default, skip_serializing_if = "Option::is_none")]
    pub kpis_healths: Option<serde_json::Value>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
    #[serde(rename = "lastBackupTime", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_time: Option<String>,
    #[serde(rename = "protectedItemDataId", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_data_id: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureIaaSvmProtectedItemExtendedInfo>,
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<ExtendedProperties>,
}
impl AzureIaaSvmProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            virtual_machine_id: None,
            protection_status: None,
            protection_state: None,
            health_status: None,
            health_details: Vec::new(),
            kpis_healths: None,
            last_backup_status: None,
            last_backup_time: None,
            protected_item_data_id: None,
            extended_info: None,
            extended_properties: None,
        }
    }
}
pub mod azure_iaa_svm_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthStatus {
        Passed,
        ActionRequired,
        ActionSuggested,
        Invalid,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmProtectedItemExtendedInfo {
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "policyInconsistent", default, skip_serializing_if = "Option::is_none")]
    pub policy_inconsistent: Option<bool>,
}
impl AzureIaaSvmProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "protectedItemDataId", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_data_id: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<azure_sql_protected_item::ProtectionState>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureSqlProtectedItemExtendedInfo>,
}
impl AzureSqlProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            protected_item_data_id: None,
            protection_state: None,
            extended_info: None,
        }
    }
}
pub mod azure_sql_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlProtectedItemExtendedInfo {
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "policyState", default, skip_serializing_if = "Option::is_none")]
    pub policy_state: Option<String>,
}
impl AzureSqlProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageErrorInfo {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl AzureStorageErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<AzureStorageErrorInfo>,
    #[serde(rename = "storageAccountName", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_name: Option<String>,
    #[serde(rename = "storageAccountVersion", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_version: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureStorageJobExtendedInfo>,
}
impl AzureStorageJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            duration: None,
            actions_info: Vec::new(),
            error_details: Vec::new(),
            storage_account_name: None,
            storage_account_version: None,
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<AzureStorageJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl AzureStorageJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl AzureStorageJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    #[serde(rename = "parentType", default, skip_serializing_if = "Option::is_none")]
    pub parent_type: Option<String>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<azure_vm_workload_protected_item::ProtectionState>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<azure_vm_workload_protected_item::LastBackupStatus>,
    #[serde(rename = "lastBackupTime", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_time: Option<String>,
    #[serde(rename = "lastBackupErrorDetail", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_error_detail: Option<ErrorDetail>,
    #[serde(rename = "protectedItemDataSourceId", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_data_source_id: Option<String>,
    #[serde(rename = "protectedItemHealthStatus", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_health_status: Option<azure_vm_workload_protected_item::ProtectedItemHealthStatus>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureVmWorkloadProtectedItemExtendedInfo>,
    #[serde(rename = "kpisHealths", default, skip_serializing_if = "Option::is_none")]
    pub kpis_healths: Option<serde_json::Value>,
}
impl AzureVmWorkloadProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            server_name: None,
            parent_name: None,
            parent_type: None,
            protection_status: None,
            protection_state: None,
            last_backup_status: None,
            last_backup_time: None,
            last_backup_error_detail: None,
            protected_item_data_source_id: None,
            protected_item_health_status: None,
            extended_info: None,
            kpis_healths: None,
        }
    }
}
pub mod azure_vm_workload_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastBackupStatus {
        Invalid,
        Healthy,
        Unhealthy,
        #[serde(rename = "IRPending")]
        IrPending,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectedItemHealthStatus {
        Invalid,
        Healthy,
        Unhealthy,
        NotReachable,
        #[serde(rename = "IRPending")]
        IrPending,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadProtectedItemExtendedInfo {
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "policyState", default, skip_serializing_if = "Option::is_none")]
    pub policy_state: Option<String>,
}
impl AzureVmWorkloadProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapAseDatabaseProtectedItem {
    #[serde(flatten)]
    pub azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem,
}
impl AzureVmWorkloadSapAseDatabaseProtectedItem {
    pub fn new(azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem) -> Self {
        Self {
            azure_vm_workload_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapHanaDatabaseProtectedItem {
    #[serde(flatten)]
    pub azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem,
}
impl AzureVmWorkloadSapHanaDatabaseProtectedItem {
    pub fn new(azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem) -> Self {
        Self {
            azure_vm_workload_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSqlDatabaseProtectedItem {
    #[serde(flatten)]
    pub azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem,
}
impl AzureVmWorkloadSqlDatabaseProtectedItem {
    pub fn new(azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem) -> Self {
        Self {
            azure_vm_workload_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadErrorInfo {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(rename = "errorTitle", default, skip_serializing_if = "Option::is_none")]
    pub error_title: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
    #[serde(rename = "additionalDetails", default, skip_serializing_if = "Option::is_none")]
    pub additional_details: Option<String>,
}
impl AzureWorkloadErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<AzureWorkloadErrorInfo>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureWorkloadJobExtendedInfo>,
}
impl AzureWorkloadJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            workload_type: None,
            duration: None,
            actions_info: Vec::new(),
            error_details: Vec::new(),
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<AzureWorkloadJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl AzureWorkloadJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl AzureWorkloadJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadPointInTimeRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_recovery_point: AzureWorkloadRecoveryPoint,
    #[serde(rename = "timeRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub time_ranges: Vec<PointInTimeRange>,
}
impl AzureWorkloadPointInTimeRecoveryPoint {
    pub fn new(azure_workload_recovery_point: AzureWorkloadRecoveryPoint) -> Self {
        Self {
            azure_workload_recovery_point,
            time_ranges: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadPointInTimeRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_restore_request: AzureWorkloadRestoreRequest,
    #[serde(rename = "pointInTime", default, skip_serializing_if = "Option::is_none")]
    pub point_in_time: Option<String>,
}
impl AzureWorkloadPointInTimeRestoreRequest {
    pub fn new(azure_workload_restore_request: AzureWorkloadRestoreRequest) -> Self {
        Self {
            azure_workload_restore_request,
            point_in_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadRecoveryPoint {
    #[serde(flatten)]
    pub recovery_point: RecoveryPoint,
    #[serde(rename = "recoveryPointTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time_in_utc: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<azure_workload_recovery_point::Type>,
    #[serde(rename = "recoveryPointTierDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub recovery_point_tier_details: Vec<RecoveryPointTierInformation>,
    #[serde(rename = "recoveryPointMoveReadinessInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_move_readiness_info: Option<serde_json::Value>,
}
impl AzureWorkloadRecoveryPoint {
    pub fn new(recovery_point: RecoveryPoint) -> Self {
        Self {
            recovery_point,
            recovery_point_time_in_utc: None,
            type_: None,
            recovery_point_tier_details: Vec::new(),
            recovery_point_move_readiness_info: None,
        }
    }
}
pub mod azure_workload_recovery_point {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        Full,
        Log,
        Differential,
        Incremental,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadRestoreRequest {
    #[serde(flatten)]
    pub restore_request: RestoreRequest,
    #[serde(rename = "recoveryType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_type: Option<azure_workload_restore_request::RecoveryType>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "targetInfo", default, skip_serializing_if = "Option::is_none")]
    pub target_info: Option<TargetRestoreInfo>,
    #[serde(rename = "recoveryMode", default, skip_serializing_if = "Option::is_none")]
    pub recovery_mode: Option<azure_workload_restore_request::RecoveryMode>,
    #[serde(rename = "targetVirtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub target_virtual_machine_id: Option<String>,
}
impl AzureWorkloadRestoreRequest {
    pub fn new(restore_request: RestoreRequest) -> Self {
        Self {
            restore_request,
            recovery_type: None,
            source_resource_id: None,
            property_bag: None,
            target_info: None,
            recovery_mode: None,
            target_virtual_machine_id: None,
        }
    }
}
pub mod azure_workload_restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryType {
        Invalid,
        OriginalLocation,
        AlternateLocation,
        RestoreDisks,
        Offline,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryMode {
        Invalid,
        FileRecovery,
        WorkloadRecovery,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaPointInTimeRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_point_in_time_recovery_point: AzureWorkloadPointInTimeRecoveryPoint,
}
impl AzureWorkloadSapHanaPointInTimeRecoveryPoint {
    pub fn new(azure_workload_point_in_time_recovery_point: AzureWorkloadPointInTimeRecoveryPoint) -> Self {
        Self {
            azure_workload_point_in_time_recovery_point,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaPointInTimeRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_sap_hana_restore_request: AzureWorkloadSapHanaRestoreRequest,
    #[serde(rename = "pointInTime", default, skip_serializing_if = "Option::is_none")]
    pub point_in_time: Option<String>,
}
impl AzureWorkloadSapHanaPointInTimeRestoreRequest {
    pub fn new(azure_workload_sap_hana_restore_request: AzureWorkloadSapHanaRestoreRequest) -> Self {
        Self {
            azure_workload_sap_hana_restore_request,
            point_in_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_recovery_point: AzureWorkloadRecoveryPoint,
}
impl AzureWorkloadSapHanaRecoveryPoint {
    pub fn new(azure_workload_recovery_point: AzureWorkloadRecoveryPoint) -> Self {
        Self {
            azure_workload_recovery_point,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_restore_request: AzureWorkloadRestoreRequest,
}
impl AzureWorkloadSapHanaRestoreRequest {
    pub fn new(azure_workload_restore_request: AzureWorkloadRestoreRequest) -> Self {
        Self {
            azure_workload_restore_request,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlPointInTimeRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_sql_recovery_point: AzureWorkloadSqlRecoveryPoint,
    #[serde(rename = "timeRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub time_ranges: Vec<PointInTimeRange>,
}
impl AzureWorkloadSqlPointInTimeRecoveryPoint {
    pub fn new(azure_workload_sql_recovery_point: AzureWorkloadSqlRecoveryPoint) -> Self {
        Self {
            azure_workload_sql_recovery_point,
            time_ranges: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlPointInTimeRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_sql_restore_request: AzureWorkloadSqlRestoreRequest,
    #[serde(rename = "pointInTime", default, skip_serializing_if = "Option::is_none")]
    pub point_in_time: Option<String>,
}
impl AzureWorkloadSqlPointInTimeRestoreRequest {
    pub fn new(azure_workload_sql_restore_request: AzureWorkloadSqlRestoreRequest) -> Self {
        Self {
            azure_workload_sql_restore_request,
            point_in_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_recovery_point: AzureWorkloadRecoveryPoint,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureWorkloadSqlRecoveryPointExtendedInfo>,
}
impl AzureWorkloadSqlRecoveryPoint {
    pub fn new(azure_workload_recovery_point: AzureWorkloadRecoveryPoint) -> Self {
        Self {
            azure_workload_recovery_point,
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadSqlRecoveryPointExtendedInfo {
    #[serde(rename = "dataDirectoryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub data_directory_time_in_utc: Option<String>,
    #[serde(rename = "dataDirectoryPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub data_directory_paths: Vec<SqlDataDirectory>,
}
impl AzureWorkloadSqlRecoveryPointExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_restore_request: AzureWorkloadRestoreRequest,
    #[serde(rename = "shouldUseAlternateTargetLocation", default, skip_serializing_if = "Option::is_none")]
    pub should_use_alternate_target_location: Option<bool>,
    #[serde(rename = "isNonRecoverable", default, skip_serializing_if = "Option::is_none")]
    pub is_non_recoverable: Option<bool>,
    #[serde(rename = "alternateDirectoryPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub alternate_directory_paths: Vec<SqlDataDirectoryMapping>,
}
impl AzureWorkloadSqlRestoreRequest {
    pub fn new(azure_workload_restore_request: AzureWorkloadRestoreRequest) -> Self {
        Self {
            azure_workload_restore_request,
            should_use_alternate_target_location: None,
            is_non_recoverable: None,
            alternate_directory_paths: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BekDetails {
    #[serde(rename = "secretUrl", default, skip_serializing_if = "Option::is_none")]
    pub secret_url: Option<String>,
    #[serde(rename = "secretVaultId", default, skip_serializing_if = "Option::is_none")]
    pub secret_vault_id: Option<String>,
    #[serde(rename = "secretData", default, skip_serializing_if = "Option::is_none")]
    pub secret_data: Option<String>,
}
impl BekDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsaadPropertiesQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bmsaad_properties_query_object::BackupManagementType>,
}
impl BmsaadPropertiesQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bmsaad_properties_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsBackupSummariesQueryObject {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<bms_backup_summaries_query_object::Type>,
}
impl BmsBackupSummariesQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_backup_summaries_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        BackupProtectedItemCountSummary,
        BackupProtectionContainerCountSummary,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsrpQueryObject {
    #[serde(rename = "startDate", default, skip_serializing_if = "Option::is_none")]
    pub start_date: Option<String>,
    #[serde(rename = "endDate", default, skip_serializing_if = "Option::is_none")]
    pub end_date: Option<String>,
    #[serde(rename = "restorePointQueryType", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_query_type: Option<bmsrp_query_object::RestorePointQueryType>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<bool>,
    #[serde(rename = "moveReadyRPOnly", default, skip_serializing_if = "Option::is_none")]
    pub move_ready_rp_only: Option<bool>,
}
impl BmsrpQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bmsrp_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RestorePointQueryType {
        Invalid,
        Full,
        Log,
        Differential,
        FullAndDifferential,
        All,
        Incremental,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupManagementUsage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<backup_management_usage::Unit>,
    #[serde(rename = "quotaPeriod", default, skip_serializing_if = "Option::is_none")]
    pub quota_period: Option<String>,
    #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
    pub next_reset_time: Option<String>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<NameInfo>,
}
impl BackupManagementUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_management_usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
        Bytes,
        Seconds,
        Percent,
        CountPerSecond,
        BytesPerSecond,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupManagementUsageList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackupManagementUsage>,
}
impl BackupManagementUsageList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceConfig {
    #[serde(rename = "storageModelType", default, skip_serializing_if = "Option::is_none")]
    pub storage_model_type: Option<backup_resource_config::StorageModelType>,
    #[serde(rename = "storageType", default, skip_serializing_if = "Option::is_none")]
    pub storage_type: Option<backup_resource_config::StorageType>,
    #[serde(rename = "storageTypeState", default, skip_serializing_if = "Option::is_none")]
    pub storage_type_state: Option<backup_resource_config::StorageTypeState>,
    #[serde(rename = "crossRegionRestoreFlag", default, skip_serializing_if = "Option::is_none")]
    pub cross_region_restore_flag: Option<bool>,
}
impl BackupResourceConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_resource_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageModelType {
        Invalid,
        GeoRedundant,
        LocallyRedundant,
        ZoneRedundant,
        ReadAccessGeoZoneRedundant,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageType {
        Invalid,
        GeoRedundant,
        LocallyRedundant,
        ZoneRedundant,
        ReadAccessGeoZoneRedundant,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageTypeState {
        Invalid,
        Locked,
        Unlocked,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceConfigResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupResourceConfig>,
}
impl BackupResourceConfigResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientScriptForConnect {
    #[serde(rename = "scriptContent", default, skip_serializing_if = "Option::is_none")]
    pub script_content: Option<String>,
    #[serde(rename = "scriptExtension", default, skip_serializing_if = "Option::is_none")]
    pub script_extension: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "scriptNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub script_name_suffix: Option<String>,
}
impl ClientScriptForConnect {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CrossRegionRestoreRequest {
    #[serde(rename = "crossRegionRestoreAccessDetails", default, skip_serializing_if = "Option::is_none")]
    pub cross_region_restore_access_details: Option<CrrAccessToken>,
    #[serde(rename = "restoreRequest", default, skip_serializing_if = "Option::is_none")]
    pub restore_request: Option<RestoreRequest>,
}
impl CrossRegionRestoreRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CrossRegionRestoreRequestResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CrossRegionRestoreRequest>,
}
impl CrossRegionRestoreRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CrrAccessToken {
    #[serde(rename = "objectType")]
    pub object_type: String,
    #[serde(rename = "accessTokenString", default, skip_serializing_if = "Option::is_none")]
    pub access_token_string: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub resource_group_name: Option<String>,
    #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
    pub resource_name: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "protectionContainerId", default, skip_serializing_if = "Option::is_none")]
    pub protection_container_id: Option<i64>,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "containerType", default, skip_serializing_if = "Option::is_none")]
    pub container_type: Option<String>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<String>,
    #[serde(rename = "datasourceType", default, skip_serializing_if = "Option::is_none")]
    pub datasource_type: Option<String>,
    #[serde(rename = "datasourceName", default, skip_serializing_if = "Option::is_none")]
    pub datasource_name: Option<String>,
    #[serde(rename = "datasourceId", default, skip_serializing_if = "Option::is_none")]
    pub datasource_id: Option<String>,
    #[serde(rename = "datasourceContainerName", default, skip_serializing_if = "Option::is_none")]
    pub datasource_container_name: Option<String>,
    #[serde(rename = "coordinatorServiceStampId", default, skip_serializing_if = "Option::is_none")]
    pub coordinator_service_stamp_id: Option<String>,
    #[serde(rename = "coordinatorServiceStampUri", default, skip_serializing_if = "Option::is_none")]
    pub coordinator_service_stamp_uri: Option<String>,
    #[serde(rename = "protectionServiceStampId", default, skip_serializing_if = "Option::is_none")]
    pub protection_service_stamp_id: Option<String>,
    #[serde(rename = "protectionServiceStampUri", default, skip_serializing_if = "Option::is_none")]
    pub protection_service_stamp_uri: Option<String>,
    #[serde(rename = "tokenExtendedInformation", default, skip_serializing_if = "Option::is_none")]
    pub token_extended_information: Option<String>,
    #[serde(rename = "rpTierInformation", default, skip_serializing_if = "Option::is_none")]
    pub rp_tier_information: Option<serde_json::Value>,
    #[serde(rename = "rpOriginalSAOption", default, skip_serializing_if = "Option::is_none")]
    pub rp_original_sa_option: Option<bool>,
    #[serde(rename = "rpIsManagedVirtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub rp_is_managed_virtual_machine: Option<bool>,
    #[serde(rename = "rpVMSizeDescription", default, skip_serializing_if = "Option::is_none")]
    pub rp_vm_size_description: Option<String>,
    #[serde(rename = "bMSActiveRegion", default, skip_serializing_if = "Option::is_none")]
    pub b_ms_active_region: Option<String>,
}
impl CrrAccessToken {
    pub fn new(object_type: String) -> Self {
        Self {
            object_type,
            access_token_string: None,
            subscription_id: None,
            resource_group_name: None,
            resource_name: None,
            resource_id: None,
            protection_container_id: None,
            recovery_point_id: None,
            recovery_point_time: None,
            container_name: None,
            container_type: None,
            backup_management_type: None,
            datasource_type: None,
            datasource_name: None,
            datasource_id: None,
            datasource_container_name: None,
            coordinator_service_stamp_id: None,
            coordinator_service_stamp_uri: None,
            protection_service_stamp_id: None,
            protection_service_stamp_uri: None,
            token_extended_information: None,
            rp_tier_information: None,
            rp_original_sa_option: None,
            rp_is_managed_virtual_machine: None,
            rp_vm_size_description: None,
            b_ms_active_region: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CrrAccessTokenResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CrrAccessToken>,
}
impl CrrAccessTokenResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CrrJobRequest {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "jobName", default, skip_serializing_if = "Option::is_none")]
    pub job_name: Option<String>,
}
impl CrrJobRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CrrJobRequestResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<CrrJobRequest>,
}
impl CrrJobRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DpmProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "backupEngineName", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_name: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<dpm_protected_item::ProtectionState>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<DpmProtectedItemExtendedInfo>,
}
impl DpmProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            backup_engine_name: None,
            protection_state: None,
            extended_info: None,
        }
    }
}
pub mod dpm_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmProtectedItemExtendedInfo {
    #[serde(rename = "protectableObjectLoadPath", default, skip_serializing_if = "Option::is_none")]
    pub protectable_object_load_path: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protected: Option<bool>,
    #[serde(rename = "isPresentOnCloud", default, skip_serializing_if = "Option::is_none")]
    pub is_present_on_cloud: Option<bool>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "onPremiseOldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub on_premise_oldest_recovery_point: Option<String>,
    #[serde(rename = "onPremiseLatestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub on_premise_latest_recovery_point: Option<String>,
    #[serde(rename = "onPremiseRecoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub on_premise_recovery_point_count: Option<i32>,
    #[serde(rename = "isCollocated", default, skip_serializing_if = "Option::is_none")]
    pub is_collocated: Option<bool>,
    #[serde(rename = "protectionGroupName", default, skip_serializing_if = "Option::is_none")]
    pub protection_group_name: Option<String>,
    #[serde(rename = "diskStorageUsedInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_storage_used_in_bytes: Option<String>,
    #[serde(rename = "totalDiskStorageSizeInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_disk_storage_size_in_bytes: Option<String>,
}
impl DpmProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskExclusionProperties {
    #[serde(rename = "diskLunList", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_lun_list: Vec<i32>,
    #[serde(rename = "isInclusionList", default, skip_serializing_if = "Option::is_none")]
    pub is_inclusion_list: Option<bool>,
}
impl DiskExclusionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskInformation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub lun: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl DiskInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmErrorInfo {
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl DpmErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DpmJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "dpmServerName", default, skip_serializing_if = "Option::is_none")]
    pub dpm_server_name: Option<String>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "containerType", default, skip_serializing_if = "Option::is_none")]
    pub container_type: Option<String>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<DpmErrorInfo>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<DpmJobExtendedInfo>,
}
impl DpmJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            duration: None,
            dpm_server_name: None,
            container_name: None,
            container_type: None,
            workload_type: None,
            actions_info: Vec::new(),
            error_details: Vec::new(),
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<DpmJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl DpmJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl DpmJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionDetails {
    #[serde(rename = "encryptionEnabled", default, skip_serializing_if = "Option::is_none")]
    pub encryption_enabled: Option<bool>,
    #[serde(rename = "kekUrl", default, skip_serializing_if = "Option::is_none")]
    pub kek_url: Option<String>,
    #[serde(rename = "secretKeyUrl", default, skip_serializing_if = "Option::is_none")]
    pub secret_key_url: Option<String>,
    #[serde(rename = "kekVaultId", default, skip_serializing_if = "Option::is_none")]
    pub kek_vault_id: Option<String>,
    #[serde(rename = "secretKeyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub secret_key_vault_id: Option<String>,
}
impl EncryptionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl ErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedProperties {
    #[serde(rename = "diskExclusionProperties", default, skip_serializing_if = "Option::is_none")]
    pub disk_exclusion_properties: Option<DiskExclusionProperties>,
}
impl ExtendedProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenericProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "policyState", default, skip_serializing_if = "Option::is_none")]
    pub policy_state: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<generic_protected_item::ProtectionState>,
    #[serde(rename = "protectedItemId", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_id: Option<i64>,
    #[serde(rename = "sourceAssociations", default, skip_serializing_if = "Option::is_none")]
    pub source_associations: Option<serde_json::Value>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
}
impl GenericProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            policy_state: None,
            protection_state: None,
            protected_item_id: None,
            source_associations: None,
            fabric_name: None,
        }
    }
}
pub mod generic_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenericRecoveryPoint {
    #[serde(flatten)]
    pub recovery_point: RecoveryPoint,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<String>,
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[serde(rename = "recoveryPointAdditionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_additional_info: Option<String>,
}
impl GenericRecoveryPoint {
    pub fn new(recovery_point: RecoveryPoint) -> Self {
        Self {
            recovery_point,
            friendly_name: None,
            recovery_point_type: None,
            recovery_point_time: None,
            recovery_point_additional_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmRecoveryPoint {
    #[serde(flatten)]
    pub recovery_point: RecoveryPoint,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<String>,
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[serde(rename = "recoveryPointAdditionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_additional_info: Option<String>,
    #[serde(rename = "sourceVMStorageType", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_storage_type: Option<String>,
    #[serde(rename = "isSourceVMEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_source_vm_encrypted: Option<bool>,
    #[serde(rename = "keyAndSecret", default, skip_serializing_if = "Option::is_none")]
    pub key_and_secret: Option<KeyAndSecretDetails>,
    #[serde(rename = "isInstantIlrSessionActive", default, skip_serializing_if = "Option::is_none")]
    pub is_instant_ilr_session_active: Option<bool>,
    #[serde(rename = "recoveryPointTierDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub recovery_point_tier_details: Vec<RecoveryPointTierInformation>,
    #[serde(rename = "isManagedVirtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub is_managed_virtual_machine: Option<bool>,
    #[serde(rename = "virtualMachineSize", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_size: Option<String>,
    #[serde(rename = "originalStorageAccountOption", default, skip_serializing_if = "Option::is_none")]
    pub original_storage_account_option: Option<bool>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "recoveryPointDiskConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_disk_configuration: Option<RecoveryPointDiskConfiguration>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[serde(rename = "recoveryPointMoveReadinessInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_move_readiness_info: Option<serde_json::Value>,
}
impl IaasVmRecoveryPoint {
    pub fn new(recovery_point: RecoveryPoint) -> Self {
        Self {
            recovery_point,
            recovery_point_type: None,
            recovery_point_time: None,
            recovery_point_additional_info: None,
            source_vm_storage_type: None,
            is_source_vm_encrypted: None,
            key_and_secret: None,
            is_instant_ilr_session_active: None,
            recovery_point_tier_details: Vec::new(),
            is_managed_virtual_machine: None,
            virtual_machine_size: None,
            original_storage_account_option: None,
            os_type: None,
            recovery_point_disk_configuration: None,
            zones: Vec::new(),
            recovery_point_move_readiness_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmRestoreRequest {
    #[serde(flatten)]
    pub restore_request: RestoreRequest,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "recoveryType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_type: Option<iaas_vm_restore_request::RecoveryType>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "targetVirtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub target_virtual_machine_id: Option<String>,
    #[serde(rename = "targetResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_id: Option<String>,
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[serde(rename = "virtualNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_id: Option<String>,
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[serde(rename = "targetDomainNameId", default, skip_serializing_if = "Option::is_none")]
    pub target_domain_name_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "affinityGroup", default, skip_serializing_if = "Option::is_none")]
    pub affinity_group: Option<String>,
    #[serde(rename = "createNewCloudService", default, skip_serializing_if = "Option::is_none")]
    pub create_new_cloud_service: Option<bool>,
    #[serde(rename = "originalStorageAccountOption", default, skip_serializing_if = "Option::is_none")]
    pub original_storage_account_option: Option<bool>,
    #[serde(rename = "encryptionDetails", default, skip_serializing_if = "Option::is_none")]
    pub encryption_details: Option<EncryptionDetails>,
    #[serde(rename = "restoreDiskLunList", default, skip_serializing_if = "Vec::is_empty")]
    pub restore_disk_lun_list: Vec<i32>,
    #[serde(rename = "restoreWithManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub restore_with_managed_disks: Option<bool>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[serde(rename = "identityInfo", default, skip_serializing_if = "Option::is_none")]
    pub identity_info: Option<IdentityInfo>,
    #[serde(rename = "identityBasedRestoreDetails", default, skip_serializing_if = "Option::is_none")]
    pub identity_based_restore_details: Option<IdentityBasedRestoreDetails>,
}
impl IaasVmRestoreRequest {
    pub fn new(restore_request: RestoreRequest) -> Self {
        Self {
            restore_request,
            recovery_point_id: None,
            recovery_type: None,
            source_resource_id: None,
            target_virtual_machine_id: None,
            target_resource_group_id: None,
            storage_account_id: None,
            virtual_network_id: None,
            subnet_id: None,
            target_domain_name_id: None,
            region: None,
            affinity_group: None,
            create_new_cloud_service: None,
            original_storage_account_option: None,
            encryption_details: None,
            restore_disk_lun_list: Vec::new(),
            restore_with_managed_disks: None,
            disk_encryption_set_id: None,
            zones: Vec::new(),
            identity_info: None,
            identity_based_restore_details: None,
        }
    }
}
pub mod iaas_vm_restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryType {
        Invalid,
        OriginalLocation,
        AlternateLocation,
        RestoreDisks,
        Offline,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityBasedRestoreDetails {
    #[serde(rename = "objectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "targetStorageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub target_storage_account_id: Option<String>,
}
impl IdentityBasedRestoreDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityInfo {
    #[serde(rename = "isSystemAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub is_system_assigned_identity: Option<bool>,
    #[serde(rename = "managedIdentityResourceId", default, skip_serializing_if = "Option::is_none")]
    pub managed_identity_resource_id: Option<String>,
}
impl IdentityInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstantItemRecoveryTarget {
    #[serde(rename = "clientScripts", default, skip_serializing_if = "Vec::is_empty")]
    pub client_scripts: Vec<ClientScriptForConnect>,
}
impl InstantItemRecoveryTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Job {
    #[serde(rename = "entityFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub entity_friendly_name: Option<String>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<job::BackupManagementType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "activityId", default, skip_serializing_if = "Option::is_none")]
    pub activity_id: Option<String>,
    #[serde(rename = "jobType")]
    pub job_type: String,
}
impl Job {
    pub fn new(job_type: String) -> Self {
        Self {
            entity_friendly_name: None,
            backup_management_type: None,
            operation: None,
            status: None,
            start_time: None,
            end_time: None,
            activity_id: None,
            job_type,
        }
    }
}
pub mod job {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobQueryObject {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<job_query_object::Status>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<job_query_object::BackupManagementType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<job_query_object::Operation>,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl JobQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        InProgress,
        Completed,
        Failed,
        CompletedWithWarnings,
        Cancelled,
        Cancelling,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operation {
        Invalid,
        Register,
        UnRegister,
        ConfigureBackup,
        Backup,
        Restore,
        DisableBackup,
        DeleteBackupData,
        CrossRegionRestore,
        Undelete,
        UpdateCustomerManagedKey,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Job>,
}
impl JobResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobResource>,
}
impl JobResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KekDetails {
    #[serde(rename = "keyUrl", default, skip_serializing_if = "Option::is_none")]
    pub key_url: Option<String>,
    #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_id: Option<String>,
    #[serde(rename = "keyBackupData", default, skip_serializing_if = "Option::is_none")]
    pub key_backup_data: Option<String>,
}
impl KekDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KpiResourceHealthDetails {
    #[serde(rename = "resourceHealthStatus", default, skip_serializing_if = "Option::is_none")]
    pub resource_health_status: Option<kpi_resource_health_details::ResourceHealthStatus>,
    #[serde(rename = "resourceHealthDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_health_details: Vec<ResourceHealthDetails>,
}
impl KpiResourceHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod kpi_resource_health_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceHealthStatus {
        Healthy,
        TransientDegraded,
        PersistentDegraded,
        TransientUnhealthy,
        PersistentUnhealthy,
        Invalid,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyAndSecretDetails {
    #[serde(rename = "kekDetails", default, skip_serializing_if = "Option::is_none")]
    pub kek_details: Option<KekDetails>,
    #[serde(rename = "bekDetails", default, skip_serializing_if = "Option::is_none")]
    pub bek_details: Option<BekDetails>,
    #[serde(rename = "encryptionMechanism", default, skip_serializing_if = "Option::is_none")]
    pub encryption_mechanism: Option<String>,
}
impl KeyAndSecretDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabErrorInfo {
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl MabErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MabFileFolderProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "computerName", default, skip_serializing_if = "Option::is_none")]
    pub computer_name: Option<String>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
    #[serde(rename = "lastBackupTime", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_time: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<String>,
    #[serde(rename = "deferredDeleteSyncTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub deferred_delete_sync_time_in_utc: Option<i64>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<MabFileFolderProtectedItemExtendedInfo>,
}
impl MabFileFolderProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            computer_name: None,
            last_backup_status: None,
            last_backup_time: None,
            protection_state: None,
            deferred_delete_sync_time_in_utc: None,
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabFileFolderProtectedItemExtendedInfo {
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
}
impl MabFileFolderProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MabJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "mabServerName", default, skip_serializing_if = "Option::is_none")]
    pub mab_server_name: Option<String>,
    #[serde(rename = "mabServerType", default, skip_serializing_if = "Option::is_none")]
    pub mab_server_type: Option<mab_job::MabServerType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<mab_job::WorkloadType>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<MabErrorInfo>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<MabJobExtendedInfo>,
}
impl MabJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            duration: None,
            actions_info: Vec::new(),
            mab_server_name: None,
            mab_server_type: None,
            workload_type: None,
            error_details: Vec::new(),
            extended_info: None,
        }
    }
}
pub mod mab_job {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MabServerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<MabJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl MabJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl MabJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl NameInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NewErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<new_error_response::Error>,
}
impl NewErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod new_error_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Error {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub code: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub target: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub details: Vec<NewErrorResponse>,
        #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
        pub additional_info: Vec<ErrorAdditionalInfo>,
    }
    impl Error {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<operation_status::Status>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<OperationStatusError>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationStatusExtendedInfo>,
}
impl OperationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        InProgress,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatusError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl OperationStatusError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusExtendedInfo {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl OperationStatusExtendedInfo {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusJobExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
}
impl OperationStatusJobExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            job_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusJobsExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "jobIds", default, skip_serializing_if = "Vec::is_empty")]
    pub job_ids: Vec<String>,
    #[serde(rename = "failedJobsError", default, skip_serializing_if = "Option::is_none")]
    pub failed_jobs_error: Option<serde_json::Value>,
}
impl OperationStatusJobsExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            job_ids: Vec::new(),
            failed_jobs_error: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusProvisionIlrExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "recoveryTarget", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target: Option<InstantItemRecoveryTarget>,
}
impl OperationStatusProvisionIlrExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            recovery_target: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusRecoveryPointExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "updatedRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub updated_recovery_point: Option<RecoveryPoint>,
    #[serde(rename = "deletedBackupItemVersion", default, skip_serializing_if = "Option::is_none")]
    pub deleted_backup_item_version: Option<String>,
}
impl OperationStatusRecoveryPointExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            updated_recovery_point: None,
            deleted_backup_item_version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PointInTimeRange {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl PointInTimeRange {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProtectedItem {
    #[serde(rename = "protectedItemType")]
    pub protected_item_type: String,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protected_item::BackupManagementType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<protected_item::WorkloadType>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(rename = "lastRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point: Option<String>,
    #[serde(rename = "backupSetName", default, skip_serializing_if = "Option::is_none")]
    pub backup_set_name: Option<String>,
    #[serde(rename = "createMode", default, skip_serializing_if = "Option::is_none")]
    pub create_mode: Option<protected_item::CreateMode>,
    #[serde(rename = "deferredDeleteTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub deferred_delete_time_in_utc: Option<String>,
    #[serde(rename = "isScheduledForDeferredDelete", default, skip_serializing_if = "Option::is_none")]
    pub is_scheduled_for_deferred_delete: Option<bool>,
    #[serde(rename = "deferredDeleteTimeRemaining", default, skip_serializing_if = "Option::is_none")]
    pub deferred_delete_time_remaining: Option<String>,
    #[serde(rename = "isDeferredDeleteScheduleUpcoming", default, skip_serializing_if = "Option::is_none")]
    pub is_deferred_delete_schedule_upcoming: Option<bool>,
    #[serde(rename = "isRehydrate", default, skip_serializing_if = "Option::is_none")]
    pub is_rehydrate: Option<bool>,
    #[serde(rename = "resourceGuardOperationRequests", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_guard_operation_requests: Vec<String>,
}
impl ProtectedItem {
    pub fn new(protected_item_type: String) -> Self {
        Self {
            protected_item_type,
            backup_management_type: None,
            workload_type: None,
            container_name: None,
            source_resource_id: None,
            policy_id: None,
            last_recovery_point: None,
            backup_set_name: None,
            create_mode: None,
            deferred_delete_time_in_utc: None,
            is_scheduled_for_deferred_delete: None,
            deferred_delete_time_remaining: None,
            is_deferred_delete_schedule_upcoming: None,
            is_rehydrate: None,
            resource_guard_operation_requests: Vec::new(),
        }
    }
}
pub mod protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreateMode {
        Invalid,
        Default,
        Recover,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectedItemQueryObject {
    #[serde(rename = "healthState", default, skip_serializing_if = "Option::is_none")]
    pub health_state: Option<protected_item_query_object::HealthState>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protected_item_query_object::BackupManagementType>,
    #[serde(rename = "itemType", default, skip_serializing_if = "Option::is_none")]
    pub item_type: Option<protected_item_query_object::ItemType>,
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "backupEngineName", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_name: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "backupSetName", default, skip_serializing_if = "Option::is_none")]
    pub backup_set_name: Option<String>,
}
impl ProtectedItemQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protected_item_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthState {
        Passed,
        ActionRequired,
        ActionSuggested,
        Invalid,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ItemType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectedItemResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectedItem>,
}
impl ProtectedItemResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectedItemResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectedItemResource>,
}
impl ProtectedItemResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPoint {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl RecoveryPoint {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointDiskConfiguration {
    #[serde(rename = "numberOfDisksIncludedInBackup", default, skip_serializing_if = "Option::is_none")]
    pub number_of_disks_included_in_backup: Option<i32>,
    #[serde(rename = "numberOfDisksAttachedToVm", default, skip_serializing_if = "Option::is_none")]
    pub number_of_disks_attached_to_vm: Option<i32>,
    #[serde(rename = "includedDiskList", default, skip_serializing_if = "Vec::is_empty")]
    pub included_disk_list: Vec<DiskInformation>,
    #[serde(rename = "excludedDiskList", default, skip_serializing_if = "Vec::is_empty")]
    pub excluded_disk_list: Vec<DiskInformation>,
}
impl RecoveryPointDiskConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointMoveReadinessInfo {
    #[serde(rename = "isReadyForMove", default, skip_serializing_if = "Option::is_none")]
    pub is_ready_for_move: Option<bool>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub additional_info: Option<String>,
}
impl RecoveryPointMoveReadinessInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecoveryPoint>,
}
impl RecoveryPointResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecoveryPointResource>,
}
impl RecoveryPointResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointTierInformation {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<recovery_point_tier_information::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<recovery_point_tier_information::Status>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<serde_json::Value>,
}
impl RecoveryPointTierInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recovery_point_tier_information {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        #[serde(rename = "InstantRP")]
        InstantRp,
        #[serde(rename = "HardenedRP")]
        HardenedRp,
        #[serde(rename = "ArchivedRP")]
        ArchivedRp,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        Valid,
        Disabled,
        Deleted,
        Rehydrated,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceHealthDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl ResourceHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestoreFileSpecs {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "fileSpecType", default, skip_serializing_if = "Option::is_none")]
    pub file_spec_type: Option<String>,
    #[serde(rename = "targetFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub target_folder_path: Option<String>,
}
impl RestoreFileSpecs {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestoreRequest {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl RestoreRequest {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDataDirectory {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<sql_data_directory::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "logicalName", default, skip_serializing_if = "Option::is_none")]
    pub logical_name: Option<String>,
}
impl SqlDataDirectory {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_data_directory {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        Data,
        Log,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDataDirectoryMapping {
    #[serde(rename = "mappingType", default, skip_serializing_if = "Option::is_none")]
    pub mapping_type: Option<sql_data_directory_mapping::MappingType>,
    #[serde(rename = "sourceLogicalName", default, skip_serializing_if = "Option::is_none")]
    pub source_logical_name: Option<String>,
    #[serde(rename = "sourcePath", default, skip_serializing_if = "Option::is_none")]
    pub source_path: Option<String>,
    #[serde(rename = "targetPath", default, skip_serializing_if = "Option::is_none")]
    pub target_path: Option<String>,
}
impl SqlDataDirectoryMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_data_directory_mapping {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MappingType {
        Invalid,
        Data,
        Log,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetAfsRestoreInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "targetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_id: Option<String>,
}
impl TargetAfsRestoreInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetRestoreInfo {
    #[serde(rename = "overwriteOption", default, skip_serializing_if = "Option::is_none")]
    pub overwrite_option: Option<target_restore_info::OverwriteOption>,
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "targetDirectoryForFileRestore", default, skip_serializing_if = "Option::is_none")]
    pub target_directory_for_file_restore: Option<String>,
}
impl TargetRestoreInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod target_restore_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OverwriteOption {
        Invalid,
        FailOnConflict,
        Overwrite,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkloadCrrAccessToken {
    #[serde(flatten)]
    pub crr_access_token: CrrAccessToken,
    #[serde(rename = "protectableObjectUniqueName", default, skip_serializing_if = "Option::is_none")]
    pub protectable_object_unique_name: Option<String>,
    #[serde(rename = "protectableObjectFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub protectable_object_friendly_name: Option<String>,
    #[serde(rename = "protectableObjectWorkloadType", default, skip_serializing_if = "Option::is_none")]
    pub protectable_object_workload_type: Option<String>,
    #[serde(rename = "protectableObjectProtectionState", default, skip_serializing_if = "Option::is_none")]
    pub protectable_object_protection_state: Option<String>,
    #[serde(rename = "protectableObjectContainerHostOsName", default, skip_serializing_if = "Option::is_none")]
    pub protectable_object_container_host_os_name: Option<String>,
    #[serde(
        rename = "protectableObjectParentLogicalContainerName",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub protectable_object_parent_logical_container_name: Option<String>,
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
}
impl WorkloadCrrAccessToken {
    pub fn new(crr_access_token: CrrAccessToken) -> Self {
        Self {
            crr_access_token,
            protectable_object_unique_name: None,
            protectable_object_friendly_name: None,
            protectable_object_workload_type: None,
            protectable_object_protection_state: None,
            protectable_object_container_host_os_name: None,
            protectable_object_parent_logical_container_name: None,
            container_id: None,
            policy_name: None,
            policy_id: None,
        }
    }
}
