#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBackupGoalFeatureSupportRequest {
    #[serde(flatten)]
    pub feature_support_request: FeatureSupportRequest,
}
impl AzureBackupGoalFeatureSupportRequest {
    pub fn new(feature_support_request: FeatureSupportRequest) -> Self {
        Self { feature_support_request }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBackupServerContainer {
    #[serde(flatten)]
    pub dpm_container: DpmContainer,
}
impl AzureBackupServerContainer {
    pub fn new(dpm_container: DpmContainer) -> Self {
        Self { dpm_container }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBackupServerEngine {
    #[serde(flatten)]
    pub backup_engine_base: BackupEngineBase,
}
impl AzureBackupServerEngine {
    pub fn new(backup_engine_base: BackupEngineBase) -> Self {
        Self { backup_engine_base }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareBackupRequest {
    #[serde(flatten)]
    pub backup_request: BackupRequest,
    #[serde(rename = "recoveryPointExpiryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_expiry_time_in_utc: Option<String>,
}
impl AzureFileShareBackupRequest {
    pub fn new(backup_request: BackupRequest) -> Self {
        Self {
            backup_request,
            recovery_point_expiry_time_in_utc: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareProtectableItem {
    #[serde(flatten)]
    pub workload_protectable_item: WorkloadProtectableItem,
    #[serde(rename = "parentContainerFabricId", default, skip_serializing_if = "Option::is_none")]
    pub parent_container_fabric_id: Option<String>,
    #[serde(rename = "parentContainerFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub parent_container_friendly_name: Option<String>,
    #[serde(rename = "azureFileShareType", default, skip_serializing_if = "Option::is_none")]
    pub azure_file_share_type: Option<azure_file_share_protectable_item::AzureFileShareType>,
}
impl AzureFileShareProtectableItem {
    pub fn new(workload_protectable_item: WorkloadProtectableItem) -> Self {
        Self {
            workload_protectable_item,
            parent_container_fabric_id: None,
            parent_container_friendly_name: None,
            azure_file_share_type: None,
        }
    }
}
pub mod azure_file_share_protectable_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureFileShareType {
        Invalid,
        #[serde(rename = "XSMB")]
        Xsmb,
        XSync,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareProtectionPolicy {
    #[serde(flatten)]
    pub protection_policy: ProtectionPolicy,
    #[serde(rename = "workLoadType", default, skip_serializing_if = "Option::is_none")]
    pub work_load_type: Option<azure_file_share_protection_policy::WorkLoadType>,
    #[serde(rename = "schedulePolicy", default, skip_serializing_if = "Option::is_none")]
    pub schedule_policy: Option<SchedulePolicy>,
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicy>,
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
}
impl AzureFileShareProtectionPolicy {
    pub fn new(protection_policy: ProtectionPolicy) -> Self {
        Self {
            protection_policy,
            work_load_type: None,
            schedule_policy: None,
            retention_policy: None,
            time_zone: None,
        }
    }
}
pub mod azure_file_share_protection_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkLoadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareProvisionIlrRequest {
    #[serde(flatten)]
    pub ilr_request: IlrRequest,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
}
impl AzureFileShareProvisionIlrRequest {
    pub fn new(ilr_request: IlrRequest) -> Self {
        Self {
            ilr_request,
            recovery_point_id: None,
            source_resource_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareRecoveryPoint {
    #[serde(flatten)]
    pub recovery_point: RecoveryPoint,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<String>,
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[serde(rename = "fileShareSnapshotUri", default, skip_serializing_if = "Option::is_none")]
    pub file_share_snapshot_uri: Option<String>,
    #[serde(rename = "recoveryPointSizeInGB", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_size_in_gb: Option<i32>,
}
impl AzureFileShareRecoveryPoint {
    pub fn new(recovery_point: RecoveryPoint) -> Self {
        Self {
            recovery_point,
            recovery_point_type: None,
            recovery_point_time: None,
            file_share_snapshot_uri: None,
            recovery_point_size_in_gb: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareRestoreRequest {
    #[serde(flatten)]
    pub restore_request: RestoreRequest,
    #[serde(rename = "recoveryType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_type: Option<azure_file_share_restore_request::RecoveryType>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "copyOptions", default, skip_serializing_if = "Option::is_none")]
    pub copy_options: Option<azure_file_share_restore_request::CopyOptions>,
    #[serde(rename = "restoreRequestType", default, skip_serializing_if = "Option::is_none")]
    pub restore_request_type: Option<azure_file_share_restore_request::RestoreRequestType>,
    #[serde(rename = "restoreFileSpecs", default, skip_serializing_if = "Vec::is_empty")]
    pub restore_file_specs: Vec<RestoreFileSpecs>,
    #[serde(rename = "targetDetails", default, skip_serializing_if = "Option::is_none")]
    pub target_details: Option<TargetAfsRestoreInfo>,
}
impl AzureFileShareRestoreRequest {
    pub fn new(restore_request: RestoreRequest) -> Self {
        Self {
            restore_request,
            recovery_type: None,
            source_resource_id: None,
            copy_options: None,
            restore_request_type: None,
            restore_file_specs: Vec::new(),
            target_details: None,
        }
    }
}
pub mod azure_file_share_restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryType {
        Invalid,
        OriginalLocation,
        AlternateLocation,
        RestoreDisks,
        Offline,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CopyOptions {
        Invalid,
        CreateCopy,
        Skip,
        Overwrite,
        FailOnConflict,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RestoreRequestType {
        Invalid,
        FullShareRestore,
        ItemLevelRestore,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileshareProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<azure_fileshare_protected_item::ProtectionState>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
    #[serde(rename = "lastBackupTime", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_time: Option<String>,
    #[serde(rename = "kpisHealths", default, skip_serializing_if = "Option::is_none")]
    pub kpis_healths: Option<serde_json::Value>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureFileshareProtectedItemExtendedInfo>,
}
impl AzureFileshareProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            protection_status: None,
            protection_state: None,
            last_backup_status: None,
            last_backup_time: None,
            kpis_healths: None,
            extended_info: None,
        }
    }
}
pub mod azure_fileshare_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFileshareProtectedItemExtendedInfo {
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "policyState", default, skip_serializing_if = "Option::is_none")]
    pub policy_state: Option<String>,
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<String>,
    #[serde(rename = "resourceStateSyncTime", default, skip_serializing_if = "Option::is_none")]
    pub resource_state_sync_time: Option<String>,
}
impl AzureFileshareProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSClassicComputeVmContainer {
    #[serde(flatten)]
    pub iaa_svm_container: IaaSvmContainer,
}
impl AzureIaaSClassicComputeVmContainer {
    pub fn new(iaa_svm_container: IaaSvmContainer) -> Self {
        Self { iaa_svm_container }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSClassicComputeVmProtectableItem {
    #[serde(flatten)]
    pub iaa_svm_protectable_item: IaaSvmProtectableItem,
}
impl AzureIaaSClassicComputeVmProtectableItem {
    pub fn new(iaa_svm_protectable_item: IaaSvmProtectableItem) -> Self {
        Self { iaa_svm_protectable_item }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSClassicComputeVmProtectedItem {
    #[serde(flatten)]
    pub azure_iaa_svm_protected_item: AzureIaaSvmProtectedItem,
}
impl AzureIaaSClassicComputeVmProtectedItem {
    pub fn new(azure_iaa_svm_protected_item: AzureIaaSvmProtectedItem) -> Self {
        Self {
            azure_iaa_svm_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSComputeVmContainer {
    #[serde(flatten)]
    pub iaa_svm_container: IaaSvmContainer,
}
impl AzureIaaSComputeVmContainer {
    pub fn new(iaa_svm_container: IaaSvmContainer) -> Self {
        Self { iaa_svm_container }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSComputeVmProtectableItem {
    #[serde(flatten)]
    pub iaa_svm_protectable_item: IaaSvmProtectableItem,
}
impl AzureIaaSComputeVmProtectableItem {
    pub fn new(iaa_svm_protectable_item: IaaSvmProtectableItem) -> Self {
        Self { iaa_svm_protectable_item }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSComputeVmProtectedItem {
    #[serde(flatten)]
    pub azure_iaa_svm_protected_item: AzureIaaSvmProtectedItem,
}
impl AzureIaaSComputeVmProtectedItem {
    pub fn new(azure_iaa_svm_protected_item: AzureIaaSvmProtectedItem) -> Self {
        Self {
            azure_iaa_svm_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmErrorInfo {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorTitle", default, skip_serializing_if = "Option::is_none")]
    pub error_title: Option<String>,
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl AzureIaaSvmErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmHealthDetails {
    #[serde(flatten)]
    pub resource_health_details: ResourceHealthDetails,
}
impl AzureIaaSvmHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSvmJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<AzureIaaSvmErrorInfo>,
    #[serde(rename = "virtualMachineVersion", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_version: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureIaaSvmJobExtendedInfo>,
}
impl AzureIaaSvmJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            duration: None,
            actions_info: Vec::new(),
            error_details: Vec::new(),
            virtual_machine_version: None,
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<AzureIaaSvmJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "internalPropertyBag", default, skip_serializing_if = "Option::is_none")]
    pub internal_property_bag: Option<serde_json::Value>,
    #[serde(rename = "progressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub progress_percentage: Option<f64>,
    #[serde(rename = "estimatedRemainingDuration", default, skip_serializing_if = "Option::is_none")]
    pub estimated_remaining_duration: Option<String>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl AzureIaaSvmJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "instanceId", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "progressPercentage", default, skip_serializing_if = "Option::is_none")]
    pub progress_percentage: Option<f64>,
    #[serde(rename = "taskExecutionDetails", default, skip_serializing_if = "Option::is_none")]
    pub task_execution_details: Option<String>,
}
impl AzureIaaSvmJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSvmProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<azure_iaa_svm_protected_item::ProtectionState>,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<azure_iaa_svm_protected_item::HealthStatus>,
    #[serde(rename = "healthDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub health_details: Vec<AzureIaaSvmHealthDetails>,
    #[serde(rename = "kpisHealths", default, skip_serializing_if = "Option::is_none")]
    pub kpis_healths: Option<serde_json::Value>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
    #[serde(rename = "lastBackupTime", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_time: Option<String>,
    #[serde(rename = "protectedItemDataId", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_data_id: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureIaaSvmProtectedItemExtendedInfo>,
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<ExtendedProperties>,
}
impl AzureIaaSvmProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            virtual_machine_id: None,
            protection_status: None,
            protection_state: None,
            health_status: None,
            health_details: Vec::new(),
            kpis_healths: None,
            last_backup_status: None,
            last_backup_time: None,
            protected_item_data_id: None,
            extended_info: None,
            extended_properties: None,
        }
    }
}
pub mod azure_iaa_svm_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthStatus {
        Passed,
        ActionRequired,
        ActionSuggested,
        Invalid,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSvmProtectedItemExtendedInfo {
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "policyInconsistent", default, skip_serializing_if = "Option::is_none")]
    pub policy_inconsistent: Option<bool>,
}
impl AzureIaaSvmProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureIaaSvmProtectionPolicy {
    #[serde(flatten)]
    pub protection_policy: ProtectionPolicy,
    #[serde(rename = "instantRPDetails", default, skip_serializing_if = "Option::is_none")]
    pub instant_rp_details: Option<InstantRpAdditionalDetails>,
    #[serde(rename = "schedulePolicy", default, skip_serializing_if = "Option::is_none")]
    pub schedule_policy: Option<SchedulePolicy>,
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicy>,
    #[serde(rename = "instantRpRetentionRangeInDays", default, skip_serializing_if = "Option::is_none")]
    pub instant_rp_retention_range_in_days: Option<i32>,
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
}
impl AzureIaaSvmProtectionPolicy {
    pub fn new(protection_policy: ProtectionPolicy) -> Self {
        Self {
            protection_policy,
            instant_rp_details: None,
            schedule_policy: None,
            retention_policy: None,
            instant_rp_retention_range_in_days: None,
            time_zone: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureRecoveryServiceVaultProtectionIntent {
    #[serde(flatten)]
    pub protection_intent: ProtectionIntent,
}
impl AzureRecoveryServiceVaultProtectionIntent {
    pub fn new(protection_intent: ProtectionIntent) -> Self {
        Self { protection_intent }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceProtectionIntent {
    #[serde(flatten)]
    pub protection_intent: ProtectionIntent,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl AzureResourceProtectionIntent {
    pub fn new(protection_intent: ProtectionIntent) -> Self {
        Self {
            protection_intent,
            friendly_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlagWorkloadContainerProtectionContainer {
    #[serde(flatten)]
    pub azure_workload_container: AzureWorkloadContainer,
}
impl AzureSqlagWorkloadContainerProtectionContainer {
    pub fn new(azure_workload_container: AzureWorkloadContainer) -> Self {
        Self { azure_workload_container }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
}
impl AzureSqlContainer {
    pub fn new(protection_container: ProtectionContainer) -> Self {
        Self { protection_container }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "protectedItemDataId", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_data_id: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<azure_sql_protected_item::ProtectionState>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureSqlProtectedItemExtendedInfo>,
}
impl AzureSqlProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            protected_item_data_id: None,
            protection_state: None,
            extended_info: None,
        }
    }
}
pub mod azure_sql_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlProtectedItemExtendedInfo {
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "policyState", default, skip_serializing_if = "Option::is_none")]
    pub policy_state: Option<String>,
}
impl AzureSqlProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlProtectionPolicy {
    #[serde(flatten)]
    pub protection_policy: ProtectionPolicy,
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicy>,
}
impl AzureSqlProtectionPolicy {
    pub fn new(protection_policy: ProtectionPolicy) -> Self {
        Self {
            protection_policy,
            retention_policy: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "storageAccountVersion", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_version: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i64>,
}
impl AzureStorageContainer {
    pub fn new(protection_container: ProtectionContainer) -> Self {
        Self {
            protection_container,
            source_resource_id: None,
            storage_account_version: None,
            resource_group: None,
            protected_item_count: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageErrorInfo {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl AzureStorageErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<AzureStorageErrorInfo>,
    #[serde(rename = "storageAccountName", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_name: Option<String>,
    #[serde(rename = "storageAccountVersion", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_version: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureStorageJobExtendedInfo>,
}
impl AzureStorageJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            duration: None,
            actions_info: Vec::new(),
            error_details: Vec::new(),
            storage_account_name: None,
            storage_account_version: None,
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<AzureStorageJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl AzureStorageJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl AzureStorageJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageProtectableContainer {
    #[serde(flatten)]
    pub protectable_container: ProtectableContainer,
}
impl AzureStorageProtectableContainer {
    pub fn new(protectable_container: ProtectableContainer) -> Self {
        Self { protectable_container }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmAppContainerProtectableContainer {
    #[serde(flatten)]
    pub protectable_container: ProtectableContainer,
}
impl AzureVmAppContainerProtectableContainer {
    pub fn new(protectable_container: ProtectableContainer) -> Self {
        Self { protectable_container }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmAppContainerProtectionContainer {
    #[serde(flatten)]
    pub azure_workload_container: AzureWorkloadContainer,
}
impl AzureVmAppContainerProtectionContainer {
    pub fn new(azure_workload_container: AzureWorkloadContainer) -> Self {
        Self { azure_workload_container }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmResourceFeatureSupportRequest {
    #[serde(flatten)]
    pub feature_support_request: FeatureSupportRequest,
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<String>,
    #[serde(rename = "vmSku", default, skip_serializing_if = "Option::is_none")]
    pub vm_sku: Option<String>,
}
impl AzureVmResourceFeatureSupportRequest {
    pub fn new(feature_support_request: FeatureSupportRequest) -> Self {
        Self {
            feature_support_request,
            vm_size: None,
            vm_sku: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmResourceFeatureSupportResponse {
    #[serde(rename = "supportStatus", default, skip_serializing_if = "Option::is_none")]
    pub support_status: Option<azure_vm_resource_feature_support_response::SupportStatus>,
}
impl AzureVmResourceFeatureSupportResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_vm_resource_feature_support_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SupportStatus {
        Invalid,
        Supported,
        #[serde(rename = "DefaultOFF")]
        DefaultOff,
        #[serde(rename = "DefaultON")]
        DefaultOn,
        NotSupported,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadItem {
    #[serde(flatten)]
    pub workload_item: WorkloadItem,
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[serde(rename = "isAutoProtectable", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_protectable: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subinquireditemcount: Option<i32>,
    #[serde(rename = "subWorkloadItemCount", default, skip_serializing_if = "Option::is_none")]
    pub sub_workload_item_count: Option<i32>,
}
impl AzureVmWorkloadItem {
    pub fn new(workload_item: WorkloadItem) -> Self {
        Self {
            workload_item,
            parent_name: None,
            server_name: None,
            is_auto_protectable: None,
            subinquireditemcount: None,
            sub_workload_item_count: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadProtectableItem {
    #[serde(flatten)]
    pub workload_protectable_item: WorkloadProtectableItem,
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    #[serde(rename = "parentUniqueName", default, skip_serializing_if = "Option::is_none")]
    pub parent_unique_name: Option<String>,
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[serde(rename = "isAutoProtectable", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_protectable: Option<bool>,
    #[serde(rename = "isAutoProtected", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_protected: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subinquireditemcount: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subprotectableitemcount: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prebackupvalidation: Option<PreBackupValidation>,
}
impl AzureVmWorkloadProtectableItem {
    pub fn new(workload_protectable_item: WorkloadProtectableItem) -> Self {
        Self {
            workload_protectable_item,
            parent_name: None,
            parent_unique_name: None,
            server_name: None,
            is_auto_protectable: None,
            is_auto_protected: None,
            subinquireditemcount: None,
            subprotectableitemcount: None,
            prebackupvalidation: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    #[serde(rename = "parentType", default, skip_serializing_if = "Option::is_none")]
    pub parent_type: Option<String>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<azure_vm_workload_protected_item::ProtectionState>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<azure_vm_workload_protected_item::LastBackupStatus>,
    #[serde(rename = "lastBackupTime", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_time: Option<String>,
    #[serde(rename = "lastBackupErrorDetail", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_error_detail: Option<ErrorDetail>,
    #[serde(rename = "protectedItemDataSourceId", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_data_source_id: Option<String>,
    #[serde(rename = "protectedItemHealthStatus", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_health_status: Option<azure_vm_workload_protected_item::ProtectedItemHealthStatus>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureVmWorkloadProtectedItemExtendedInfo>,
    #[serde(rename = "kpisHealths", default, skip_serializing_if = "Option::is_none")]
    pub kpis_healths: Option<serde_json::Value>,
}
impl AzureVmWorkloadProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            server_name: None,
            parent_name: None,
            parent_type: None,
            protection_status: None,
            protection_state: None,
            last_backup_status: None,
            last_backup_time: None,
            last_backup_error_detail: None,
            protected_item_data_source_id: None,
            protected_item_health_status: None,
            extended_info: None,
            kpis_healths: None,
        }
    }
}
pub mod azure_vm_workload_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastBackupStatus {
        Invalid,
        Healthy,
        Unhealthy,
        #[serde(rename = "IRPending")]
        IrPending,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectedItemHealthStatus {
        Invalid,
        Healthy,
        Unhealthy,
        NotReachable,
        #[serde(rename = "IRPending")]
        IrPending,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadProtectedItemExtendedInfo {
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "policyState", default, skip_serializing_if = "Option::is_none")]
    pub policy_state: Option<String>,
}
impl AzureVmWorkloadProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadProtectionPolicy {
    #[serde(flatten)]
    pub protection_policy: ProtectionPolicy,
    #[serde(rename = "workLoadType", default, skip_serializing_if = "Option::is_none")]
    pub work_load_type: Option<azure_vm_workload_protection_policy::WorkLoadType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub settings: Option<Settings>,
    #[serde(rename = "subProtectionPolicy", default, skip_serializing_if = "Vec::is_empty")]
    pub sub_protection_policy: Vec<SubProtectionPolicy>,
    #[serde(rename = "makePolicyConsistent", default, skip_serializing_if = "Option::is_none")]
    pub make_policy_consistent: Option<bool>,
}
impl AzureVmWorkloadProtectionPolicy {
    pub fn new(protection_policy: ProtectionPolicy) -> Self {
        Self {
            protection_policy,
            work_load_type: None,
            settings: None,
            sub_protection_policy: Vec::new(),
            make_policy_consistent: None,
        }
    }
}
pub mod azure_vm_workload_protection_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkLoadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapAseDatabaseProtectedItem {
    #[serde(flatten)]
    pub azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem,
}
impl AzureVmWorkloadSapAseDatabaseProtectedItem {
    pub fn new(azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem) -> Self {
        Self {
            azure_vm_workload_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapAseDatabaseWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapAseDatabaseWorkloadItem {
    pub fn new(azure_vm_workload_item: AzureVmWorkloadItem) -> Self {
        Self { azure_vm_workload_item }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapAseSystemProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSapAseSystemProtectableItem {
    pub fn new(azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem) -> Self {
        Self {
            azure_vm_workload_protectable_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapAseSystemWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapAseSystemWorkloadItem {
    pub fn new(azure_vm_workload_item: AzureVmWorkloadItem) -> Self {
        Self { azure_vm_workload_item }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapHanaDatabaseProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSapHanaDatabaseProtectableItem {
    pub fn new(azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem) -> Self {
        Self {
            azure_vm_workload_protectable_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapHanaDatabaseProtectedItem {
    #[serde(flatten)]
    pub azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem,
}
impl AzureVmWorkloadSapHanaDatabaseProtectedItem {
    pub fn new(azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem) -> Self {
        Self {
            azure_vm_workload_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapHanaDatabaseWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapHanaDatabaseWorkloadItem {
    pub fn new(azure_vm_workload_item: AzureVmWorkloadItem) -> Self {
        Self { azure_vm_workload_item }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapHanaSystemProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSapHanaSystemProtectableItem {
    pub fn new(azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem) -> Self {
        Self {
            azure_vm_workload_protectable_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSapHanaSystemWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapHanaSystemWorkloadItem {
    pub fn new(azure_vm_workload_item: AzureVmWorkloadItem) -> Self {
        Self { azure_vm_workload_item }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSqlAvailabilityGroupProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSqlAvailabilityGroupProtectableItem {
    pub fn new(azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem) -> Self {
        Self {
            azure_vm_workload_protectable_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSqlDatabaseProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSqlDatabaseProtectableItem {
    pub fn new(azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem) -> Self {
        Self {
            azure_vm_workload_protectable_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSqlDatabaseProtectedItem {
    #[serde(flatten)]
    pub azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem,
}
impl AzureVmWorkloadSqlDatabaseProtectedItem {
    pub fn new(azure_vm_workload_protected_item: AzureVmWorkloadProtectedItem) -> Self {
        Self {
            azure_vm_workload_protected_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSqlDatabaseWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSqlDatabaseWorkloadItem {
    pub fn new(azure_vm_workload_item: AzureVmWorkloadItem) -> Self {
        Self { azure_vm_workload_item }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSqlInstanceProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSqlInstanceProtectableItem {
    pub fn new(azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem) -> Self {
        Self {
            azure_vm_workload_protectable_item,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureVmWorkloadSqlInstanceWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
    #[serde(rename = "dataDirectoryPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub data_directory_paths: Vec<SqlDataDirectory>,
}
impl AzureVmWorkloadSqlInstanceWorkloadItem {
    pub fn new(azure_vm_workload_item: AzureVmWorkloadItem) -> Self {
        Self {
            azure_vm_workload_item,
            data_directory_paths: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadAutoProtectionIntent {
    #[serde(flatten)]
    pub azure_recovery_service_vault_protection_intent: AzureRecoveryServiceVaultProtectionIntent,
}
impl AzureWorkloadAutoProtectionIntent {
    pub fn new(azure_recovery_service_vault_protection_intent: AzureRecoveryServiceVaultProtectionIntent) -> Self {
        Self {
            azure_recovery_service_vault_protection_intent,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadBackupRequest {
    #[serde(flatten)]
    pub backup_request: BackupRequest,
    #[serde(rename = "backupType", default, skip_serializing_if = "Option::is_none")]
    pub backup_type: Option<azure_workload_backup_request::BackupType>,
    #[serde(rename = "enableCompression", default, skip_serializing_if = "Option::is_none")]
    pub enable_compression: Option<bool>,
    #[serde(rename = "recoveryPointExpiryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_expiry_time_in_utc: Option<String>,
}
impl AzureWorkloadBackupRequest {
    pub fn new(backup_request: BackupRequest) -> Self {
        Self {
            backup_request,
            backup_type: None,
            enable_compression: None,
            recovery_point_expiry_time_in_utc: None,
        }
    }
}
pub mod azure_workload_backup_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupType {
        Invalid,
        Full,
        Differential,
        Log,
        CopyOnlyFull,
        Incremental,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "lastUpdatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_time: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureWorkloadContainerExtendedInfo>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<azure_workload_container::WorkloadType>,
    #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
    pub operation_type: Option<azure_workload_container::OperationType>,
}
impl AzureWorkloadContainer {
    pub fn new(protection_container: ProtectionContainer) -> Self {
        Self {
            protection_container,
            source_resource_id: None,
            last_updated_time: None,
            extended_info: None,
            workload_type: None,
            operation_type: None,
        }
    }
}
pub mod azure_workload_container {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationType {
        Invalid,
        Register,
        Reregister,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadContainerExtendedInfo {
    #[serde(rename = "hostServerName", default, skip_serializing_if = "Option::is_none")]
    pub host_server_name: Option<String>,
    #[serde(rename = "inquiryInfo", default, skip_serializing_if = "Option::is_none")]
    pub inquiry_info: Option<InquiryInfo>,
    #[serde(rename = "nodesList", default, skip_serializing_if = "Vec::is_empty")]
    pub nodes_list: Vec<DistributedNodesInfo>,
}
impl AzureWorkloadContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadErrorInfo {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(rename = "errorTitle", default, skip_serializing_if = "Option::is_none")]
    pub error_title: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
    #[serde(rename = "additionalDetails", default, skip_serializing_if = "Option::is_none")]
    pub additional_details: Option<String>,
}
impl AzureWorkloadErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<AzureWorkloadErrorInfo>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureWorkloadJobExtendedInfo>,
}
impl AzureWorkloadJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            workload_type: None,
            duration: None,
            actions_info: Vec::new(),
            error_details: Vec::new(),
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<AzureWorkloadJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl AzureWorkloadJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl AzureWorkloadJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadPointInTimeRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_recovery_point: AzureWorkloadRecoveryPoint,
    #[serde(rename = "timeRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub time_ranges: Vec<PointInTimeRange>,
}
impl AzureWorkloadPointInTimeRecoveryPoint {
    pub fn new(azure_workload_recovery_point: AzureWorkloadRecoveryPoint) -> Self {
        Self {
            azure_workload_recovery_point,
            time_ranges: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadPointInTimeRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_restore_request: AzureWorkloadRestoreRequest,
    #[serde(rename = "pointInTime", default, skip_serializing_if = "Option::is_none")]
    pub point_in_time: Option<String>,
}
impl AzureWorkloadPointInTimeRestoreRequest {
    pub fn new(azure_workload_restore_request: AzureWorkloadRestoreRequest) -> Self {
        Self {
            azure_workload_restore_request,
            point_in_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadRecoveryPoint {
    #[serde(flatten)]
    pub recovery_point: RecoveryPoint,
    #[serde(rename = "recoveryPointTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time_in_utc: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<azure_workload_recovery_point::Type>,
    #[serde(rename = "recoveryPointTierDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub recovery_point_tier_details: Vec<RecoveryPointTierInformation>,
    #[serde(rename = "recoveryPointMoveReadinessInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_move_readiness_info: Option<serde_json::Value>,
}
impl AzureWorkloadRecoveryPoint {
    pub fn new(recovery_point: RecoveryPoint) -> Self {
        Self {
            recovery_point,
            recovery_point_time_in_utc: None,
            type_: None,
            recovery_point_tier_details: Vec::new(),
            recovery_point_move_readiness_info: None,
        }
    }
}
pub mod azure_workload_recovery_point {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        Full,
        Log,
        Differential,
        Incremental,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadRestoreRequest {
    #[serde(flatten)]
    pub restore_request: RestoreRequest,
    #[serde(rename = "recoveryType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_type: Option<azure_workload_restore_request::RecoveryType>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "targetInfo", default, skip_serializing_if = "Option::is_none")]
    pub target_info: Option<TargetRestoreInfo>,
    #[serde(rename = "recoveryMode", default, skip_serializing_if = "Option::is_none")]
    pub recovery_mode: Option<azure_workload_restore_request::RecoveryMode>,
    #[serde(rename = "targetVirtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub target_virtual_machine_id: Option<String>,
}
impl AzureWorkloadRestoreRequest {
    pub fn new(restore_request: RestoreRequest) -> Self {
        Self {
            restore_request,
            recovery_type: None,
            source_resource_id: None,
            property_bag: None,
            target_info: None,
            recovery_mode: None,
            target_virtual_machine_id: None,
        }
    }
}
pub mod azure_workload_restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryType {
        Invalid,
        OriginalLocation,
        AlternateLocation,
        RestoreDisks,
        Offline,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryMode {
        Invalid,
        FileRecovery,
        WorkloadRecovery,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaPointInTimeRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_point_in_time_recovery_point: AzureWorkloadPointInTimeRecoveryPoint,
}
impl AzureWorkloadSapHanaPointInTimeRecoveryPoint {
    pub fn new(azure_workload_point_in_time_recovery_point: AzureWorkloadPointInTimeRecoveryPoint) -> Self {
        Self {
            azure_workload_point_in_time_recovery_point,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaPointInTimeRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_sap_hana_restore_request: AzureWorkloadSapHanaRestoreRequest,
    #[serde(rename = "pointInTime", default, skip_serializing_if = "Option::is_none")]
    pub point_in_time: Option<String>,
}
impl AzureWorkloadSapHanaPointInTimeRestoreRequest {
    pub fn new(azure_workload_sap_hana_restore_request: AzureWorkloadSapHanaRestoreRequest) -> Self {
        Self {
            azure_workload_sap_hana_restore_request,
            point_in_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaPointInTimeRestoreWithRehydrateRequest {
    #[serde(flatten)]
    pub azure_workload_sap_hana_point_in_time_restore_request: AzureWorkloadSapHanaPointInTimeRestoreRequest,
    #[serde(rename = "recoveryPointRehydrationInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_rehydration_info: Option<RecoveryPointRehydrationInfo>,
}
impl AzureWorkloadSapHanaPointInTimeRestoreWithRehydrateRequest {
    pub fn new(azure_workload_sap_hana_point_in_time_restore_request: AzureWorkloadSapHanaPointInTimeRestoreRequest) -> Self {
        Self {
            azure_workload_sap_hana_point_in_time_restore_request,
            recovery_point_rehydration_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_recovery_point: AzureWorkloadRecoveryPoint,
}
impl AzureWorkloadSapHanaRecoveryPoint {
    pub fn new(azure_workload_recovery_point: AzureWorkloadRecoveryPoint) -> Self {
        Self {
            azure_workload_recovery_point,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_restore_request: AzureWorkloadRestoreRequest,
}
impl AzureWorkloadSapHanaRestoreRequest {
    pub fn new(azure_workload_restore_request: AzureWorkloadRestoreRequest) -> Self {
        Self {
            azure_workload_restore_request,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSapHanaRestoreWithRehydrateRequest {
    #[serde(flatten)]
    pub azure_workload_sap_hana_restore_request: AzureWorkloadSapHanaRestoreRequest,
    #[serde(rename = "recoveryPointRehydrationInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_rehydration_info: Option<RecoveryPointRehydrationInfo>,
}
impl AzureWorkloadSapHanaRestoreWithRehydrateRequest {
    pub fn new(azure_workload_sap_hana_restore_request: AzureWorkloadSapHanaRestoreRequest) -> Self {
        Self {
            azure_workload_sap_hana_restore_request,
            recovery_point_rehydration_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlAutoProtectionIntent {
    #[serde(flatten)]
    pub azure_workload_auto_protection_intent: AzureWorkloadAutoProtectionIntent,
    #[serde(rename = "workloadItemType", default, skip_serializing_if = "Option::is_none")]
    pub workload_item_type: Option<azure_workload_sql_auto_protection_intent::WorkloadItemType>,
}
impl AzureWorkloadSqlAutoProtectionIntent {
    pub fn new(azure_workload_auto_protection_intent: AzureWorkloadAutoProtectionIntent) -> Self {
        Self {
            azure_workload_auto_protection_intent,
            workload_item_type: None,
        }
    }
}
pub mod azure_workload_sql_auto_protection_intent {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadItemType {
        Invalid,
        #[serde(rename = "SQLInstance")]
        SqlInstance,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        #[serde(rename = "SAPHanaSystem")]
        SapHanaSystem,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseSystem")]
        SapAseSystem,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlPointInTimeRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_sql_recovery_point: AzureWorkloadSqlRecoveryPoint,
    #[serde(rename = "timeRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub time_ranges: Vec<PointInTimeRange>,
}
impl AzureWorkloadSqlPointInTimeRecoveryPoint {
    pub fn new(azure_workload_sql_recovery_point: AzureWorkloadSqlRecoveryPoint) -> Self {
        Self {
            azure_workload_sql_recovery_point,
            time_ranges: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlPointInTimeRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_sql_restore_request: AzureWorkloadSqlRestoreRequest,
    #[serde(rename = "pointInTime", default, skip_serializing_if = "Option::is_none")]
    pub point_in_time: Option<String>,
}
impl AzureWorkloadSqlPointInTimeRestoreRequest {
    pub fn new(azure_workload_sql_restore_request: AzureWorkloadSqlRestoreRequest) -> Self {
        Self {
            azure_workload_sql_restore_request,
            point_in_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlPointInTimeRestoreWithRehydrateRequest {
    #[serde(flatten)]
    pub azure_workload_sql_point_in_time_restore_request: AzureWorkloadSqlPointInTimeRestoreRequest,
    #[serde(rename = "recoveryPointRehydrationInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_rehydration_info: Option<RecoveryPointRehydrationInfo>,
}
impl AzureWorkloadSqlPointInTimeRestoreWithRehydrateRequest {
    pub fn new(azure_workload_sql_point_in_time_restore_request: AzureWorkloadSqlPointInTimeRestoreRequest) -> Self {
        Self {
            azure_workload_sql_point_in_time_restore_request,
            recovery_point_rehydration_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlRecoveryPoint {
    #[serde(flatten)]
    pub azure_workload_recovery_point: AzureWorkloadRecoveryPoint,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureWorkloadSqlRecoveryPointExtendedInfo>,
}
impl AzureWorkloadSqlRecoveryPoint {
    pub fn new(azure_workload_recovery_point: AzureWorkloadRecoveryPoint) -> Self {
        Self {
            azure_workload_recovery_point,
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadSqlRecoveryPointExtendedInfo {
    #[serde(rename = "dataDirectoryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub data_directory_time_in_utc: Option<String>,
    #[serde(rename = "dataDirectoryPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub data_directory_paths: Vec<SqlDataDirectory>,
}
impl AzureWorkloadSqlRecoveryPointExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlRestoreRequest {
    #[serde(flatten)]
    pub azure_workload_restore_request: AzureWorkloadRestoreRequest,
    #[serde(rename = "shouldUseAlternateTargetLocation", default, skip_serializing_if = "Option::is_none")]
    pub should_use_alternate_target_location: Option<bool>,
    #[serde(rename = "isNonRecoverable", default, skip_serializing_if = "Option::is_none")]
    pub is_non_recoverable: Option<bool>,
    #[serde(rename = "alternateDirectoryPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub alternate_directory_paths: Vec<SqlDataDirectoryMapping>,
}
impl AzureWorkloadSqlRestoreRequest {
    pub fn new(azure_workload_restore_request: AzureWorkloadRestoreRequest) -> Self {
        Self {
            azure_workload_restore_request,
            should_use_alternate_target_location: None,
            is_non_recoverable: None,
            alternate_directory_paths: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadSqlRestoreWithRehydrateRequest {
    #[serde(flatten)]
    pub azure_workload_sql_restore_request: AzureWorkloadSqlRestoreRequest,
    #[serde(rename = "recoveryPointRehydrationInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_rehydration_info: Option<RecoveryPointRehydrationInfo>,
}
impl AzureWorkloadSqlRestoreWithRehydrateRequest {
    pub fn new(azure_workload_sql_restore_request: AzureWorkloadSqlRestoreRequest) -> Self {
        Self {
            azure_workload_sql_restore_request,
            recovery_point_rehydration_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BekDetails {
    #[serde(rename = "secretUrl", default, skip_serializing_if = "Option::is_none")]
    pub secret_url: Option<String>,
    #[serde(rename = "secretVaultId", default, skip_serializing_if = "Option::is_none")]
    pub secret_vault_id: Option<String>,
    #[serde(rename = "secretData", default, skip_serializing_if = "Option::is_none")]
    pub secret_data: Option<String>,
}
impl BekDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsBackupEngineQueryObject {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
}
impl BmsBackupEngineQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsBackupEnginesQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_backup_engines_query_object::BackupManagementType>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
}
impl BmsBackupEnginesQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_backup_engines_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsBackupSummariesQueryObject {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<bms_backup_summaries_query_object::Type>,
}
impl BmsBackupSummariesQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_backup_summaries_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        BackupProtectedItemCountSummary,
        BackupProtectionContainerCountSummary,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BmsContainerQueryObject {
    #[serde(rename = "backupManagementType")]
    pub backup_management_type: bms_container_query_object::BackupManagementType,
    #[serde(rename = "containerType", default, skip_serializing_if = "Option::is_none")]
    pub container_type: Option<bms_container_query_object::ContainerType>,
    #[serde(rename = "backupEngineName", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_name: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl BmsContainerQueryObject {
    pub fn new(backup_management_type: bms_container_query_object::BackupManagementType) -> Self {
        Self {
            backup_management_type,
            container_type: None,
            backup_engine_name: None,
            fabric_name: None,
            status: None,
            friendly_name: None,
        }
    }
}
pub mod bms_container_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ContainerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsContainersInquiryQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_containers_inquiry_query_object::BackupManagementType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<bms_containers_inquiry_query_object::WorkloadType>,
}
impl BmsContainersInquiryQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_containers_inquiry_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmspoQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bmspo_query_object::BackupManagementType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<bmspo_query_object::WorkloadType>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl BmspoQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bmspo_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureSql,
        AzureBackupServer,
        AzureWorkload,
        AzureStorage,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsrpQueryObject {
    #[serde(rename = "startDate", default, skip_serializing_if = "Option::is_none")]
    pub start_date: Option<String>,
    #[serde(rename = "endDate", default, skip_serializing_if = "Option::is_none")]
    pub end_date: Option<String>,
    #[serde(rename = "restorePointQueryType", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_query_type: Option<bmsrp_query_object::RestorePointQueryType>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<bool>,
    #[serde(rename = "moveReadyRPOnly", default, skip_serializing_if = "Option::is_none")]
    pub move_ready_rp_only: Option<bool>,
}
impl BmsrpQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bmsrp_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RestorePointQueryType {
        Invalid,
        Full,
        Log,
        Differential,
        FullAndDifferential,
        All,
        Incremental,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsRefreshContainersQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_refresh_containers_query_object::BackupManagementType>,
}
impl BmsRefreshContainersQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_refresh_containers_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsWorkloadItemQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_workload_item_query_object::BackupManagementType>,
    #[serde(rename = "workloadItemType", default, skip_serializing_if = "Option::is_none")]
    pub workload_item_type: Option<bms_workload_item_query_object::WorkloadItemType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<bms_workload_item_query_object::WorkloadType>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<bms_workload_item_query_object::ProtectionStatus>,
}
impl BmsWorkloadItemQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_workload_item_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureSql,
        AzureBackupServer,
        AzureWorkload,
        AzureStorage,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadItemType {
        Invalid,
        #[serde(rename = "SQLInstance")]
        SqlInstance,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        #[serde(rename = "SAPHanaSystem")]
        SapHanaSystem,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseSystem")]
        SapAseSystem,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionStatus {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupEngineBase {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<backup_engine_base::BackupManagementType>,
    #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub registration_status: Option<String>,
    #[serde(rename = "backupEngineState", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_state: Option<String>,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<String>,
    #[serde(rename = "backupEngineType")]
    pub backup_engine_type: backup_engine_base::BackupEngineType,
    #[serde(rename = "canReRegister", default, skip_serializing_if = "Option::is_none")]
    pub can_re_register: Option<bool>,
    #[serde(rename = "backupEngineId", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_id: Option<String>,
    #[serde(rename = "dpmVersion", default, skip_serializing_if = "Option::is_none")]
    pub dpm_version: Option<String>,
    #[serde(rename = "azureBackupAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub azure_backup_agent_version: Option<String>,
    #[serde(rename = "isAzureBackupAgentUpgradeAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_azure_backup_agent_upgrade_available: Option<bool>,
    #[serde(rename = "isDpmUpgradeAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_dpm_upgrade_available: Option<bool>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<BackupEngineExtendedInfo>,
}
impl BackupEngineBase {
    pub fn new(backup_engine_type: backup_engine_base::BackupEngineType) -> Self {
        Self {
            friendly_name: None,
            backup_management_type: None,
            registration_status: None,
            backup_engine_state: None,
            health_status: None,
            backup_engine_type,
            can_re_register: None,
            backup_engine_id: None,
            dpm_version: None,
            azure_backup_agent_version: None,
            is_azure_backup_agent_upgrade_available: None,
            is_dpm_upgrade_available: None,
            extended_info: None,
        }
    }
}
pub mod backup_engine_base {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupEngineType {
        Invalid,
        DpmBackupEngine,
        AzureBackupServerEngine,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineBaseResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupEngineBase>,
}
impl BackupEngineBaseResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineBaseResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackupEngineBaseResource>,
}
impl BackupEngineBaseResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineExtendedInfo {
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "protectedItemsCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_items_count: Option<i32>,
    #[serde(rename = "protectedServersCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_servers_count: Option<i32>,
    #[serde(rename = "diskCount", default, skip_serializing_if = "Option::is_none")]
    pub disk_count: Option<i32>,
    #[serde(rename = "usedDiskSpace", default, skip_serializing_if = "Option::is_none")]
    pub used_disk_space: Option<f64>,
    #[serde(rename = "availableDiskSpace", default, skip_serializing_if = "Option::is_none")]
    pub available_disk_space: Option<f64>,
    #[serde(rename = "refreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub refreshed_at: Option<String>,
    #[serde(rename = "azureProtectedInstances", default, skip_serializing_if = "Option::is_none")]
    pub azure_protected_instances: Option<i32>,
}
impl BackupEngineExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupManagementUsage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<backup_management_usage::Unit>,
    #[serde(rename = "quotaPeriod", default, skip_serializing_if = "Option::is_none")]
    pub quota_period: Option<String>,
    #[serde(rename = "nextResetTime", default, skip_serializing_if = "Option::is_none")]
    pub next_reset_time: Option<String>,
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<NameInfo>,
}
impl BackupManagementUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_management_usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
        Bytes,
        Seconds,
        Percent,
        CountPerSecond,
        BytesPerSecond,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupManagementUsageList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackupManagementUsage>,
}
impl BackupManagementUsageList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupRequest {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl BackupRequest {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupRequestResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupRequest>,
}
impl BackupRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceEncryptionConfig {
    #[serde(rename = "encryptionAtRestType", default, skip_serializing_if = "Option::is_none")]
    pub encryption_at_rest_type: Option<backup_resource_encryption_config::EncryptionAtRestType>,
    #[serde(rename = "keyUri", default, skip_serializing_if = "Option::is_none")]
    pub key_uri: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "lastUpdateStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_update_status: Option<backup_resource_encryption_config::LastUpdateStatus>,
    #[serde(rename = "infrastructureEncryptionState", default, skip_serializing_if = "Option::is_none")]
    pub infrastructure_encryption_state: Option<backup_resource_encryption_config::InfrastructureEncryptionState>,
}
impl BackupResourceEncryptionConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_resource_encryption_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EncryptionAtRestType {
        Invalid,
        MicrosoftManaged,
        CustomerManaged,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastUpdateStatus {
        Invalid,
        NotEnabled,
        PartiallySucceeded,
        PartiallyFailed,
        Failed,
        Succeeded,
        Initialized,
        FirstInitialization,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum InfrastructureEncryptionState {
        Invalid,
        Disabled,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceEncryptionConfigExtended {
    #[serde(flatten)]
    pub backup_resource_encryption_config: BackupResourceEncryptionConfig,
    #[serde(rename = "userAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identity: Option<String>,
    #[serde(rename = "useSystemAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub use_system_assigned_identity: Option<bool>,
}
impl BackupResourceEncryptionConfigExtended {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceEncryptionConfigExtendedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupResourceEncryptionConfigExtended>,
}
impl BackupResourceEncryptionConfigExtendedResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceEncryptionConfigResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupResourceEncryptionConfig>,
}
impl BackupResourceEncryptionConfigResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceVaultConfig {
    #[serde(rename = "storageModelType", default, skip_serializing_if = "Option::is_none")]
    pub storage_model_type: Option<backup_resource_vault_config::StorageModelType>,
    #[serde(rename = "storageType", default, skip_serializing_if = "Option::is_none")]
    pub storage_type: Option<backup_resource_vault_config::StorageType>,
    #[serde(rename = "storageTypeState", default, skip_serializing_if = "Option::is_none")]
    pub storage_type_state: Option<backup_resource_vault_config::StorageTypeState>,
    #[serde(rename = "enhancedSecurityState", default, skip_serializing_if = "Option::is_none")]
    pub enhanced_security_state: Option<backup_resource_vault_config::EnhancedSecurityState>,
    #[serde(rename = "softDeleteFeatureState", default, skip_serializing_if = "Option::is_none")]
    pub soft_delete_feature_state: Option<backup_resource_vault_config::SoftDeleteFeatureState>,
}
impl BackupResourceVaultConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_resource_vault_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageModelType {
        Invalid,
        GeoRedundant,
        LocallyRedundant,
        ZoneRedundant,
        ReadAccessGeoZoneRedundant,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageType {
        Invalid,
        GeoRedundant,
        LocallyRedundant,
        ZoneRedundant,
        ReadAccessGeoZoneRedundant,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageTypeState {
        Invalid,
        Locked,
        Unlocked,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EnhancedSecurityState {
        Invalid,
        Enabled,
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SoftDeleteFeatureState {
        Invalid,
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceVaultConfigResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupResourceVaultConfig>,
}
impl BackupResourceVaultConfigResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupStatusRequest {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<backup_status_request::ResourceType>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "poLogicalName", default, skip_serializing_if = "Option::is_none")]
    pub po_logical_name: Option<String>,
}
impl BackupStatusRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_status_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupStatusResponse {
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<backup_status_response::ProtectionStatus>,
    #[serde(rename = "vaultId", default, skip_serializing_if = "Option::is_none")]
    pub vault_id: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<backup_status_response::FabricName>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "protectedItemName", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_name: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub registration_status: Option<String>,
}
impl BackupStatusResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_status_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionStatus {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FabricName {
        Invalid,
        Azure,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientDiscoveryDisplay {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ClientDiscoveryDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientDiscoveryForLogSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl ClientDiscoveryForLogSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientDiscoveryForProperties {
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<ClientDiscoveryForServiceSpecification>,
}
impl ClientDiscoveryForProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientDiscoveryForServiceSpecification {
    #[serde(rename = "logSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub log_specifications: Vec<ClientDiscoveryForLogSpecification>,
}
impl ClientDiscoveryForServiceSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientDiscoveryResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ClientDiscoveryValueForSingleApi>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ClientDiscoveryResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientDiscoveryValueForSingleApi {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<ClientDiscoveryDisplay>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ClientDiscoveryForProperties>,
}
impl ClientDiscoveryValueForSingleApi {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientScriptForConnect {
    #[serde(rename = "scriptContent", default, skip_serializing_if = "Option::is_none")]
    pub script_content: Option<String>,
    #[serde(rename = "scriptExtension", default, skip_serializing_if = "Option::is_none")]
    pub script_extension: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "scriptNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub script_name_suffix: Option<String>,
}
impl ClientScriptForConnect {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerIdentityInfo {
    #[serde(rename = "uniqueName", default, skip_serializing_if = "Option::is_none")]
    pub unique_name: Option<String>,
    #[serde(rename = "aadTenantId", default, skip_serializing_if = "Option::is_none")]
    pub aad_tenant_id: Option<String>,
    #[serde(rename = "servicePrincipalClientId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_client_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub audience: Option<String>,
}
impl ContainerIdentityInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmContainerExtendedInfo {
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
}
impl DpmContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DpmProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "backupEngineName", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_name: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<dpm_protected_item::ProtectionState>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<DpmProtectedItemExtendedInfo>,
}
impl DpmProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            backup_engine_name: None,
            protection_state: None,
            extended_info: None,
        }
    }
}
pub mod dpm_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmProtectedItemExtendedInfo {
    #[serde(rename = "protectableObjectLoadPath", default, skip_serializing_if = "Option::is_none")]
    pub protectable_object_load_path: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protected: Option<bool>,
    #[serde(rename = "isPresentOnCloud", default, skip_serializing_if = "Option::is_none")]
    pub is_present_on_cloud: Option<bool>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
    #[serde(rename = "onPremiseOldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub on_premise_oldest_recovery_point: Option<String>,
    #[serde(rename = "onPremiseLatestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub on_premise_latest_recovery_point: Option<String>,
    #[serde(rename = "onPremiseRecoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub on_premise_recovery_point_count: Option<i32>,
    #[serde(rename = "isCollocated", default, skip_serializing_if = "Option::is_none")]
    pub is_collocated: Option<bool>,
    #[serde(rename = "protectionGroupName", default, skip_serializing_if = "Option::is_none")]
    pub protection_group_name: Option<String>,
    #[serde(rename = "diskStorageUsedInBytes", default, skip_serializing_if = "Option::is_none")]
    pub disk_storage_used_in_bytes: Option<String>,
    #[serde(rename = "totalDiskStorageSizeInBytes", default, skip_serializing_if = "Option::is_none")]
    pub total_disk_storage_size_in_bytes: Option<String>,
}
impl DpmProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DailyRetentionFormat {
    #[serde(rename = "daysOfTheMonth", default, skip_serializing_if = "Vec::is_empty")]
    pub days_of_the_month: Vec<Day>,
}
impl DailyRetentionFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DailyRetentionSchedule {
    #[serde(rename = "retentionTimes", default, skip_serializing_if = "Vec::is_empty")]
    pub retention_times: Vec<String>,
    #[serde(rename = "retentionDuration", default, skip_serializing_if = "Option::is_none")]
    pub retention_duration: Option<RetentionDuration>,
}
impl DailyRetentionSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Day {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub date: Option<i32>,
    #[serde(rename = "isLast", default, skip_serializing_if = "Option::is_none")]
    pub is_last: Option<bool>,
}
impl Day {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskExclusionProperties {
    #[serde(rename = "diskLunList", default, skip_serializing_if = "Vec::is_empty")]
    pub disk_lun_list: Vec<i32>,
    #[serde(rename = "isInclusionList", default, skip_serializing_if = "Option::is_none")]
    pub is_inclusion_list: Option<bool>,
}
impl DiskExclusionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DiskInformation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub lun: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl DiskInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DistributedNodesInfo {
    #[serde(rename = "nodeName", default, skip_serializing_if = "Option::is_none")]
    pub node_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "errorDetail", default, skip_serializing_if = "Option::is_none")]
    pub error_detail: Option<ErrorDetail>,
}
impl DistributedNodesInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DpmBackupEngine {
    #[serde(flatten)]
    pub backup_engine_base: BackupEngineBase,
}
impl DpmBackupEngine {
    pub fn new(backup_engine_base: BackupEngineBase) -> Self {
        Self { backup_engine_base }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DpmContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "canReRegister", default, skip_serializing_if = "Option::is_none")]
    pub can_re_register: Option<bool>,
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i64>,
    #[serde(rename = "dpmAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub dpm_agent_version: Option<String>,
    #[serde(rename = "dpmServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dpm_servers: Vec<String>,
    #[serde(rename = "upgradeAvailable", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_available: Option<bool>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<DpmContainerExtendedInfo>,
}
impl DpmContainer {
    pub fn new(protection_container: ProtectionContainer) -> Self {
        Self {
            protection_container,
            can_re_register: None,
            container_id: None,
            protected_item_count: None,
            dpm_agent_version: None,
            dpm_servers: Vec::new(),
            upgrade_available: None,
            protection_status: None,
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmErrorInfo {
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl DpmErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DpmJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "dpmServerName", default, skip_serializing_if = "Option::is_none")]
    pub dpm_server_name: Option<String>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "containerType", default, skip_serializing_if = "Option::is_none")]
    pub container_type: Option<String>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<DpmErrorInfo>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<DpmJobExtendedInfo>,
}
impl DpmJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            duration: None,
            dpm_server_name: None,
            container_name: None,
            container_type: None,
            workload_type: None,
            actions_info: Vec::new(),
            error_details: Vec::new(),
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<DpmJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl DpmJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl DpmJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionDetails {
    #[serde(rename = "encryptionEnabled", default, skip_serializing_if = "Option::is_none")]
    pub encryption_enabled: Option<bool>,
    #[serde(rename = "kekUrl", default, skip_serializing_if = "Option::is_none")]
    pub kek_url: Option<String>,
    #[serde(rename = "secretKeyUrl", default, skip_serializing_if = "Option::is_none")]
    pub secret_key_url: Option<String>,
    #[serde(rename = "kekVaultId", default, skip_serializing_if = "Option::is_none")]
    pub kek_vault_id: Option<String>,
    #[serde(rename = "secretKeyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub secret_key_vault_id: Option<String>,
}
impl EncryptionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl ErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportJobsOperationResultInfo {
    #[serde(flatten)]
    pub operation_result_info_base: OperationResultInfoBase,
    #[serde(rename = "blobUrl", default, skip_serializing_if = "Option::is_none")]
    pub blob_url: Option<String>,
    #[serde(rename = "blobSasKey", default, skip_serializing_if = "Option::is_none")]
    pub blob_sas_key: Option<String>,
    #[serde(rename = "excelFileBlobUrl", default, skip_serializing_if = "Option::is_none")]
    pub excel_file_blob_url: Option<String>,
    #[serde(rename = "excelFileBlobSasKey", default, skip_serializing_if = "Option::is_none")]
    pub excel_file_blob_sas_key: Option<String>,
}
impl ExportJobsOperationResultInfo {
    pub fn new(operation_result_info_base: OperationResultInfoBase) -> Self {
        Self {
            operation_result_info_base,
            blob_url: None,
            blob_sas_key: None,
            excel_file_blob_url: None,
            excel_file_blob_sas_key: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedProperties {
    #[serde(rename = "diskExclusionProperties", default, skip_serializing_if = "Option::is_none")]
    pub disk_exclusion_properties: Option<DiskExclusionProperties>,
}
impl ExtendedProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FeatureSupportRequest {
    #[serde(rename = "featureType")]
    pub feature_type: String,
}
impl FeatureSupportRequest {
    pub fn new(feature_type: String) -> Self {
        Self { feature_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenericContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "extendedInformation", default, skip_serializing_if = "Option::is_none")]
    pub extended_information: Option<GenericContainerExtendedInfo>,
}
impl GenericContainer {
    pub fn new(protection_container: ProtectionContainer) -> Self {
        Self {
            protection_container,
            fabric_name: None,
            extended_information: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenericContainerExtendedInfo {
    #[serde(rename = "rawCertData", default, skip_serializing_if = "Option::is_none")]
    pub raw_cert_data: Option<String>,
    #[serde(rename = "containerIdentityInfo", default, skip_serializing_if = "Option::is_none")]
    pub container_identity_info: Option<ContainerIdentityInfo>,
    #[serde(rename = "serviceEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub service_endpoints: Option<serde_json::Value>,
}
impl GenericContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenericProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "policyState", default, skip_serializing_if = "Option::is_none")]
    pub policy_state: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<generic_protected_item::ProtectionState>,
    #[serde(rename = "protectedItemId", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_id: Option<i64>,
    #[serde(rename = "sourceAssociations", default, skip_serializing_if = "Option::is_none")]
    pub source_associations: Option<serde_json::Value>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
}
impl GenericProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            policy_state: None,
            protection_state: None,
            protected_item_id: None,
            source_associations: None,
            fabric_name: None,
        }
    }
}
pub mod generic_protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        #[serde(rename = "IRPending")]
        IrPending,
        Protected,
        ProtectionError,
        ProtectionStopped,
        ProtectionPaused,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenericProtectionPolicy {
    #[serde(flatten)]
    pub protection_policy: ProtectionPolicy,
    #[serde(rename = "subProtectionPolicy", default, skip_serializing_if = "Vec::is_empty")]
    pub sub_protection_policy: Vec<SubProtectionPolicy>,
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
}
impl GenericProtectionPolicy {
    pub fn new(protection_policy: ProtectionPolicy) -> Self {
        Self {
            protection_policy,
            sub_protection_policy: Vec::new(),
            time_zone: None,
            fabric_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenericRecoveryPoint {
    #[serde(flatten)]
    pub recovery_point: RecoveryPoint,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<String>,
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[serde(rename = "recoveryPointAdditionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_additional_info: Option<String>,
}
impl GenericRecoveryPoint {
    pub fn new(recovery_point: RecoveryPoint) -> Self {
        Self {
            recovery_point,
            friendly_name: None,
            recovery_point_type: None,
            recovery_point_time: None,
            recovery_point_additional_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetProtectedItemQueryObject {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
}
impl GetProtectedItemQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IlrRequest {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl IlrRequest {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IlrRequestResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IlrRequest>,
}
impl IlrRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaaSvmContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
    #[serde(rename = "virtualMachineVersion", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_version: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl IaaSvmContainer {
    pub fn new(protection_container: ProtectionContainer) -> Self {
        Self {
            protection_container,
            virtual_machine_id: None,
            virtual_machine_version: None,
            resource_group: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaaSvmProtectableItem {
    #[serde(flatten)]
    pub workload_protectable_item: WorkloadProtectableItem,
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
}
impl IaaSvmProtectableItem {
    pub fn new(workload_protectable_item: WorkloadProtectableItem) -> Self {
        Self {
            workload_protectable_item,
            virtual_machine_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmBackupRequest {
    #[serde(flatten)]
    pub backup_request: BackupRequest,
    #[serde(rename = "recoveryPointExpiryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_expiry_time_in_utc: Option<String>,
}
impl IaasVmBackupRequest {
    pub fn new(backup_request: BackupRequest) -> Self {
        Self {
            backup_request,
            recovery_point_expiry_time_in_utc: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmilrRegistrationRequest {
    #[serde(flatten)]
    pub ilr_request: IlrRequest,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
    #[serde(rename = "initiatorName", default, skip_serializing_if = "Option::is_none")]
    pub initiator_name: Option<String>,
    #[serde(rename = "renewExistingRegistration", default, skip_serializing_if = "Option::is_none")]
    pub renew_existing_registration: Option<bool>,
}
impl IaasVmilrRegistrationRequest {
    pub fn new(ilr_request: IlrRequest) -> Self {
        Self {
            ilr_request,
            recovery_point_id: None,
            virtual_machine_id: None,
            initiator_name: None,
            renew_existing_registration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmRecoveryPoint {
    #[serde(flatten)]
    pub recovery_point: RecoveryPoint,
    #[serde(rename = "recoveryPointType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_type: Option<String>,
    #[serde(rename = "recoveryPointTime", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_time: Option<String>,
    #[serde(rename = "recoveryPointAdditionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_additional_info: Option<String>,
    #[serde(rename = "sourceVMStorageType", default, skip_serializing_if = "Option::is_none")]
    pub source_vm_storage_type: Option<String>,
    #[serde(rename = "isSourceVMEncrypted", default, skip_serializing_if = "Option::is_none")]
    pub is_source_vm_encrypted: Option<bool>,
    #[serde(rename = "keyAndSecret", default, skip_serializing_if = "Option::is_none")]
    pub key_and_secret: Option<KeyAndSecretDetails>,
    #[serde(rename = "isInstantIlrSessionActive", default, skip_serializing_if = "Option::is_none")]
    pub is_instant_ilr_session_active: Option<bool>,
    #[serde(rename = "recoveryPointTierDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub recovery_point_tier_details: Vec<RecoveryPointTierInformation>,
    #[serde(rename = "isManagedVirtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub is_managed_virtual_machine: Option<bool>,
    #[serde(rename = "virtualMachineSize", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_size: Option<String>,
    #[serde(rename = "originalStorageAccountOption", default, skip_serializing_if = "Option::is_none")]
    pub original_storage_account_option: Option<bool>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(rename = "recoveryPointDiskConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_disk_configuration: Option<RecoveryPointDiskConfiguration>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[serde(rename = "recoveryPointMoveReadinessInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_move_readiness_info: Option<serde_json::Value>,
}
impl IaasVmRecoveryPoint {
    pub fn new(recovery_point: RecoveryPoint) -> Self {
        Self {
            recovery_point,
            recovery_point_type: None,
            recovery_point_time: None,
            recovery_point_additional_info: None,
            source_vm_storage_type: None,
            is_source_vm_encrypted: None,
            key_and_secret: None,
            is_instant_ilr_session_active: None,
            recovery_point_tier_details: Vec::new(),
            is_managed_virtual_machine: None,
            virtual_machine_size: None,
            original_storage_account_option: None,
            os_type: None,
            recovery_point_disk_configuration: None,
            zones: Vec::new(),
            recovery_point_move_readiness_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmRestoreRequest {
    #[serde(flatten)]
    pub restore_request: RestoreRequest,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "recoveryType", default, skip_serializing_if = "Option::is_none")]
    pub recovery_type: Option<iaas_vm_restore_request::RecoveryType>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "targetVirtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub target_virtual_machine_id: Option<String>,
    #[serde(rename = "targetResourceGroupId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_id: Option<String>,
    #[serde(rename = "storageAccountId", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_id: Option<String>,
    #[serde(rename = "virtualNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_id: Option<String>,
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[serde(rename = "targetDomainNameId", default, skip_serializing_if = "Option::is_none")]
    pub target_domain_name_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "affinityGroup", default, skip_serializing_if = "Option::is_none")]
    pub affinity_group: Option<String>,
    #[serde(rename = "createNewCloudService", default, skip_serializing_if = "Option::is_none")]
    pub create_new_cloud_service: Option<bool>,
    #[serde(rename = "originalStorageAccountOption", default, skip_serializing_if = "Option::is_none")]
    pub original_storage_account_option: Option<bool>,
    #[serde(rename = "encryptionDetails", default, skip_serializing_if = "Option::is_none")]
    pub encryption_details: Option<EncryptionDetails>,
    #[serde(rename = "restoreDiskLunList", default, skip_serializing_if = "Vec::is_empty")]
    pub restore_disk_lun_list: Vec<i32>,
    #[serde(rename = "restoreWithManagedDisks", default, skip_serializing_if = "Option::is_none")]
    pub restore_with_managed_disks: Option<bool>,
    #[serde(rename = "diskEncryptionSetId", default, skip_serializing_if = "Option::is_none")]
    pub disk_encryption_set_id: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[serde(rename = "identityInfo", default, skip_serializing_if = "Option::is_none")]
    pub identity_info: Option<IdentityInfo>,
}
impl IaasVmRestoreRequest {
    pub fn new(restore_request: RestoreRequest) -> Self {
        Self {
            restore_request,
            recovery_point_id: None,
            recovery_type: None,
            source_resource_id: None,
            target_virtual_machine_id: None,
            target_resource_group_id: None,
            storage_account_id: None,
            virtual_network_id: None,
            subnet_id: None,
            target_domain_name_id: None,
            region: None,
            affinity_group: None,
            create_new_cloud_service: None,
            original_storage_account_option: None,
            encryption_details: None,
            restore_disk_lun_list: Vec::new(),
            restore_with_managed_disks: None,
            disk_encryption_set_id: None,
            zones: Vec::new(),
            identity_info: None,
        }
    }
}
pub mod iaas_vm_restore_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecoveryType {
        Invalid,
        OriginalLocation,
        AlternateLocation,
        RestoreDisks,
        Offline,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmRestoreWithRehydrationRequest {
    #[serde(flatten)]
    pub iaas_vm_restore_request: IaasVmRestoreRequest,
    #[serde(rename = "recoveryPointRehydrationInfo", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_rehydration_info: Option<RecoveryPointRehydrationInfo>,
}
impl IaasVmRestoreWithRehydrationRequest {
    pub fn new(iaas_vm_restore_request: IaasVmRestoreRequest) -> Self {
        Self {
            iaas_vm_restore_request,
            recovery_point_rehydration_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityInfo {
    #[serde(rename = "isSystemAssignedIdentity", default, skip_serializing_if = "Option::is_none")]
    pub is_system_assigned_identity: Option<bool>,
    #[serde(rename = "managedIdentityResourceId", default, skip_serializing_if = "Option::is_none")]
    pub managed_identity_resource_id: Option<String>,
}
impl IdentityInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InquiryInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "errorDetail", default, skip_serializing_if = "Option::is_none")]
    pub error_detail: Option<ErrorDetail>,
    #[serde(rename = "inquiryDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub inquiry_details: Vec<WorkloadInquiryDetails>,
}
impl InquiryInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InquiryValidation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "errorDetail", default, skip_serializing_if = "Option::is_none")]
    pub error_detail: Option<ErrorDetail>,
    #[serde(rename = "additionalDetail", default, skip_serializing_if = "Option::is_none")]
    pub additional_detail: Option<String>,
}
impl InquiryValidation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstantItemRecoveryTarget {
    #[serde(rename = "clientScripts", default, skip_serializing_if = "Vec::is_empty")]
    pub client_scripts: Vec<ClientScriptForConnect>,
}
impl InstantItemRecoveryTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstantRpAdditionalDetails {
    #[serde(rename = "azureBackupRGNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub azure_backup_rg_name_prefix: Option<String>,
    #[serde(rename = "azureBackupRGNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub azure_backup_rg_name_suffix: Option<String>,
}
impl InstantRpAdditionalDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Job {
    #[serde(rename = "entityFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub entity_friendly_name: Option<String>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<job::BackupManagementType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "activityId", default, skip_serializing_if = "Option::is_none")]
    pub activity_id: Option<String>,
    #[serde(rename = "jobType")]
    pub job_type: String,
}
impl Job {
    pub fn new(job_type: String) -> Self {
        Self {
            entity_friendly_name: None,
            backup_management_type: None,
            operation: None,
            status: None,
            start_time: None,
            end_time: None,
            activity_id: None,
            job_type,
        }
    }
}
pub mod job {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobQueryObject {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<job_query_object::Status>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<job_query_object::BackupManagementType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<job_query_object::Operation>,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl JobQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod job_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        InProgress,
        Completed,
        Failed,
        CompletedWithWarnings,
        Cancelled,
        Cancelling,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operation {
        Invalid,
        Register,
        UnRegister,
        ConfigureBackup,
        Backup,
        Restore,
        DisableBackup,
        DeleteBackupData,
        CrossRegionRestore,
        Undelete,
        UpdateCustomerManagedKey,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<Job>,
}
impl JobResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobResource>,
}
impl JobResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KekDetails {
    #[serde(rename = "keyUrl", default, skip_serializing_if = "Option::is_none")]
    pub key_url: Option<String>,
    #[serde(rename = "keyVaultId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_id: Option<String>,
    #[serde(rename = "keyBackupData", default, skip_serializing_if = "Option::is_none")]
    pub key_backup_data: Option<String>,
}
impl KekDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KpiResourceHealthDetails {
    #[serde(rename = "resourceHealthStatus", default, skip_serializing_if = "Option::is_none")]
    pub resource_health_status: Option<kpi_resource_health_details::ResourceHealthStatus>,
    #[serde(rename = "resourceHealthDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_health_details: Vec<ResourceHealthDetails>,
}
impl KpiResourceHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod kpi_resource_health_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceHealthStatus {
        Healthy,
        TransientDegraded,
        PersistentDegraded,
        TransientUnhealthy,
        PersistentUnhealthy,
        Invalid,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyAndSecretDetails {
    #[serde(rename = "kekDetails", default, skip_serializing_if = "Option::is_none")]
    pub kek_details: Option<KekDetails>,
    #[serde(rename = "bekDetails", default, skip_serializing_if = "Option::is_none")]
    pub bek_details: Option<BekDetails>,
    #[serde(rename = "encryptionMechanism", default, skip_serializing_if = "Option::is_none")]
    pub encryption_mechanism: Option<String>,
}
impl KeyAndSecretDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListRecoveryPointsRecommendedForMoveRequest {
    #[serde(rename = "objectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "excludedRPList", default, skip_serializing_if = "Vec::is_empty")]
    pub excluded_rp_list: Vec<String>,
}
impl ListRecoveryPointsRecommendedForMoveRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogSchedulePolicy {
    #[serde(flatten)]
    pub schedule_policy: SchedulePolicy,
    #[serde(rename = "scheduleFrequencyInMins", default, skip_serializing_if = "Option::is_none")]
    pub schedule_frequency_in_mins: Option<i32>,
}
impl LogSchedulePolicy {
    pub fn new(schedule_policy: SchedulePolicy) -> Self {
        Self {
            schedule_policy,
            schedule_frequency_in_mins: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LongTermRetentionPolicy {
    #[serde(flatten)]
    pub retention_policy: RetentionPolicy,
    #[serde(rename = "dailySchedule", default, skip_serializing_if = "Option::is_none")]
    pub daily_schedule: Option<DailyRetentionSchedule>,
    #[serde(rename = "weeklySchedule", default, skip_serializing_if = "Option::is_none")]
    pub weekly_schedule: Option<WeeklyRetentionSchedule>,
    #[serde(rename = "monthlySchedule", default, skip_serializing_if = "Option::is_none")]
    pub monthly_schedule: Option<MonthlyRetentionSchedule>,
    #[serde(rename = "yearlySchedule", default, skip_serializing_if = "Option::is_none")]
    pub yearly_schedule: Option<YearlyRetentionSchedule>,
}
impl LongTermRetentionPolicy {
    pub fn new(retention_policy: RetentionPolicy) -> Self {
        Self {
            retention_policy,
            daily_schedule: None,
            weekly_schedule: None,
            monthly_schedule: None,
            yearly_schedule: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LongTermSchedulePolicy {
    #[serde(flatten)]
    pub schedule_policy: SchedulePolicy,
}
impl LongTermSchedulePolicy {
    pub fn new(schedule_policy: SchedulePolicy) -> Self {
        Self { schedule_policy }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabContainerHealthDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl MabContainerHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MabContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "canReRegister", default, skip_serializing_if = "Option::is_none")]
    pub can_re_register: Option<bool>,
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<i64>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i64>,
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<MabContainerExtendedInfo>,
    #[serde(rename = "mabContainerHealthDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub mab_container_health_details: Vec<MabContainerHealthDetails>,
    #[serde(rename = "containerHealthState", default, skip_serializing_if = "Option::is_none")]
    pub container_health_state: Option<String>,
}
impl MabContainer {
    pub fn new(protection_container: ProtectionContainer) -> Self {
        Self {
            protection_container,
            can_re_register: None,
            container_id: None,
            protected_item_count: None,
            agent_version: None,
            extended_info: None,
            mab_container_health_details: Vec::new(),
            container_health_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabContainerExtendedInfo {
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
    #[serde(rename = "backupItemType", default, skip_serializing_if = "Option::is_none")]
    pub backup_item_type: Option<mab_container_extended_info::BackupItemType>,
    #[serde(rename = "backupItems", default, skip_serializing_if = "Vec::is_empty")]
    pub backup_items: Vec<String>,
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
}
impl MabContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod mab_container_extended_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupItemType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabErrorInfo {
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl MabErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MabFileFolderProtectedItem {
    #[serde(flatten)]
    pub protected_item: ProtectedItem,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "computerName", default, skip_serializing_if = "Option::is_none")]
    pub computer_name: Option<String>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
    #[serde(rename = "lastBackupTime", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_time: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<String>,
    #[serde(rename = "deferredDeleteSyncTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub deferred_delete_sync_time_in_utc: Option<i64>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<MabFileFolderProtectedItemExtendedInfo>,
}
impl MabFileFolderProtectedItem {
    pub fn new(protected_item: ProtectedItem) -> Self {
        Self {
            protected_item,
            friendly_name: None,
            computer_name: None,
            last_backup_status: None,
            last_backup_time: None,
            protection_state: None,
            deferred_delete_sync_time_in_utc: None,
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabFileFolderProtectedItemExtendedInfo {
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
    #[serde(rename = "oldestRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub oldest_recovery_point: Option<String>,
    #[serde(rename = "recoveryPointCount", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_count: Option<i32>,
}
impl MabFileFolderProtectedItemExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MabJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "mabServerName", default, skip_serializing_if = "Option::is_none")]
    pub mab_server_name: Option<String>,
    #[serde(rename = "mabServerType", default, skip_serializing_if = "Option::is_none")]
    pub mab_server_type: Option<mab_job::MabServerType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<mab_job::WorkloadType>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<MabErrorInfo>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<MabJobExtendedInfo>,
}
impl MabJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            duration: None,
            actions_info: Vec::new(),
            mab_server_name: None,
            mab_server_type: None,
            workload_type: None,
            error_details: Vec::new(),
            extended_info: None,
        }
    }
}
pub mod mab_job {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MabServerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabJobExtendedInfo {
    #[serde(rename = "tasksList", default, skip_serializing_if = "Vec::is_empty")]
    pub tasks_list: Vec<MabJobTaskDetails>,
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
    #[serde(rename = "dynamicErrorMessage", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_error_message: Option<String>,
}
impl MabJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabJobTaskDetails {
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl MabJobTaskDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MabProtectionPolicy {
    #[serde(flatten)]
    pub protection_policy: ProtectionPolicy,
    #[serde(rename = "schedulePolicy", default, skip_serializing_if = "Option::is_none")]
    pub schedule_policy: Option<SchedulePolicy>,
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicy>,
}
impl MabProtectionPolicy {
    pub fn new(protection_policy: ProtectionPolicy) -> Self {
        Self {
            protection_policy,
            schedule_policy: None,
            retention_policy: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MonthlyRetentionSchedule {
    #[serde(rename = "retentionScheduleFormatType", default, skip_serializing_if = "Option::is_none")]
    pub retention_schedule_format_type: Option<monthly_retention_schedule::RetentionScheduleFormatType>,
    #[serde(rename = "retentionScheduleDaily", default, skip_serializing_if = "Option::is_none")]
    pub retention_schedule_daily: Option<DailyRetentionFormat>,
    #[serde(rename = "retentionScheduleWeekly", default, skip_serializing_if = "Option::is_none")]
    pub retention_schedule_weekly: Option<WeeklyRetentionFormat>,
    #[serde(rename = "retentionTimes", default, skip_serializing_if = "Vec::is_empty")]
    pub retention_times: Vec<String>,
    #[serde(rename = "retentionDuration", default, skip_serializing_if = "Option::is_none")]
    pub retention_duration: Option<RetentionDuration>,
}
impl MonthlyRetentionSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod monthly_retention_schedule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RetentionScheduleFormatType {
        Invalid,
        Daily,
        Weekly,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MoveRpAcrossTiersRequest {
    #[serde(rename = "objectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "sourceTierType", default, skip_serializing_if = "Option::is_none")]
    pub source_tier_type: Option<move_rp_across_tiers_request::SourceTierType>,
    #[serde(rename = "targetTierType", default, skip_serializing_if = "Option::is_none")]
    pub target_tier_type: Option<move_rp_across_tiers_request::TargetTierType>,
}
impl MoveRpAcrossTiersRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod move_rp_across_tiers_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceTierType {
        Invalid,
        #[serde(rename = "InstantRP")]
        InstantRp,
        #[serde(rename = "HardenedRP")]
        HardenedRp,
        #[serde(rename = "ArchivedRP")]
        ArchivedRp,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TargetTierType {
        Invalid,
        #[serde(rename = "InstantRP")]
        InstantRp,
        #[serde(rename = "HardenedRP")]
        HardenedRp,
        #[serde(rename = "ArchivedRP")]
        ArchivedRp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl NameInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NewErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<new_error_response::Error>,
}
impl NewErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod new_error_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Error {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub code: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub message: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub target: Option<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub details: Vec<NewErrorResponse>,
        #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
        pub additional_info: Vec<ErrorAdditionalInfo>,
    }
    impl Error {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationResultInfo {
    #[serde(flatten)]
    pub operation_result_info_base: OperationResultInfoBase,
    #[serde(rename = "jobList", default, skip_serializing_if = "Vec::is_empty")]
    pub job_list: Vec<String>,
}
impl OperationResultInfo {
    pub fn new(operation_result_info_base: OperationResultInfoBase) -> Self {
        Self {
            operation_result_info_base,
            job_list: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationResultInfoBase {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl OperationResultInfoBase {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResultInfoBaseResource {
    #[serde(flatten)]
    pub operation_worker_response: OperationWorkerResponse,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<OperationResultInfoBase>,
}
impl OperationResultInfoBaseResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<operation_status::Status>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<OperationStatusError>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationStatusExtendedInfo>,
}
impl OperationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        InProgress,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatusError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl OperationStatusError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusExtendedInfo {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl OperationStatusExtendedInfo {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusJobExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
}
impl OperationStatusJobExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            job_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusJobsExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "jobIds", default, skip_serializing_if = "Vec::is_empty")]
    pub job_ids: Vec<String>,
    #[serde(rename = "failedJobsError", default, skip_serializing_if = "Option::is_none")]
    pub failed_jobs_error: Option<serde_json::Value>,
}
impl OperationStatusJobsExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            job_ids: Vec::new(),
            failed_jobs_error: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusProvisionIlrExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "recoveryTarget", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target: Option<InstantItemRecoveryTarget>,
}
impl OperationStatusProvisionIlrExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            recovery_target: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationWorkerResponse {
    #[serde(rename = "statusCode", default, skip_serializing_if = "Option::is_none")]
    pub status_code: Option<operation_worker_response::StatusCode>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
}
impl OperationWorkerResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_worker_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StatusCode {
        Continue,
        SwitchingProtocols,
        #[serde(rename = "OK")]
        Ok,
        Created,
        Accepted,
        NonAuthoritativeInformation,
        NoContent,
        ResetContent,
        PartialContent,
        MultipleChoices,
        Ambiguous,
        MovedPermanently,
        Moved,
        Found,
        Redirect,
        SeeOther,
        RedirectMethod,
        NotModified,
        UseProxy,
        Unused,
        TemporaryRedirect,
        RedirectKeepVerb,
        BadRequest,
        Unauthorized,
        PaymentRequired,
        Forbidden,
        NotFound,
        MethodNotAllowed,
        NotAcceptable,
        ProxyAuthenticationRequired,
        RequestTimeout,
        Conflict,
        Gone,
        LengthRequired,
        PreconditionFailed,
        RequestEntityTooLarge,
        RequestUriTooLong,
        UnsupportedMediaType,
        RequestedRangeNotSatisfiable,
        ExpectationFailed,
        UpgradeRequired,
        InternalServerError,
        NotImplemented,
        BadGateway,
        ServiceUnavailable,
        GatewayTimeout,
        HttpVersionNotSupported,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PointInTimeRange {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl PointInTimeRange {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PreBackupValidation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<pre_backup_validation::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl PreBackupValidation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pre_backup_validation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        Success,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PreValidateEnableBackupRequest {
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<pre_validate_enable_backup_request::ResourceType>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "vaultId", default, skip_serializing_if = "Option::is_none")]
    pub vault_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<String>,
}
impl PreValidateEnableBackupRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pre_validate_enable_backup_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PreValidateEnableBackupResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<pre_validate_enable_backup_response::Status>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recommendation: Option<String>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "protectedItemName", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_name: Option<String>,
}
impl PreValidateEnableBackupResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pre_validate_enable_backup_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        Succeeded,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrepareDataMoveRequest {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[serde(rename = "targetRegion")]
    pub target_region: String,
    #[serde(rename = "dataMoveLevel")]
    pub data_move_level: prepare_data_move_request::DataMoveLevel,
    #[serde(rename = "sourceContainerArmIds", default, skip_serializing_if = "Vec::is_empty")]
    pub source_container_arm_ids: Vec<String>,
    #[serde(rename = "ignoreMoved", default, skip_serializing_if = "Option::is_none")]
    pub ignore_moved: Option<bool>,
}
impl PrepareDataMoveRequest {
    pub fn new(target_resource_id: String, target_region: String, data_move_level: prepare_data_move_request::DataMoveLevel) -> Self {
        Self {
            target_resource_id,
            target_region,
            data_move_level,
            source_container_arm_ids: Vec::new(),
            ignore_moved: None,
        }
    }
}
pub mod prepare_data_move_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataMoveLevel {
        Invalid,
        Vault,
        Container,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrepareDataMoveResponse {
    #[serde(flatten)]
    pub vault_storage_config_operation_result_response: VaultStorageConfigOperationResultResponse,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "sourceVaultProperties", default, skip_serializing_if = "Option::is_none")]
    pub source_vault_properties: Option<serde_json::Value>,
}
impl PrepareDataMoveResponse {
    pub fn new(vault_storage_config_operation_result_response: VaultStorageConfigOperationResultResponse) -> Self {
        Self {
            vault_storage_config_operation_result_response,
            correlation_id: None,
            source_vault_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<private_endpoint_connection::ProvisioningState>,
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod private_endpoint_connection {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Deleting,
        Failed,
        Pending,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnection>,
}
impl PrivateEndpointConnectionResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionState {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<private_link_service_connection_state::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "actionRequired", default, skip_serializing_if = "Option::is_none")]
    pub action_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod private_link_service_connection_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Pending,
        Approved,
        Rejected,
        Disconnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProtectableContainer {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protectable_container::BackupManagementType>,
    #[serde(rename = "protectableContainerType")]
    pub protectable_container_type: protectable_container::ProtectableContainerType,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<String>,
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
}
impl ProtectableContainer {
    pub fn new(protectable_container_type: protectable_container::ProtectableContainerType) -> Self {
        Self {
            friendly_name: None,
            backup_management_type: None,
            protectable_container_type,
            health_status: None,
            container_id: None,
        }
    }
}
pub mod protectable_container {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectableContainerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectableContainer>,
}
impl ProtectableContainerResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableContainerResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectableContainerResource>,
}
impl ProtectableContainerResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProtectedItem {
    #[serde(rename = "protectedItemType")]
    pub protected_item_type: String,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protected_item::BackupManagementType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<protected_item::WorkloadType>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(rename = "lastRecoveryPoint", default, skip_serializing_if = "Option::is_none")]
    pub last_recovery_point: Option<String>,
    #[serde(rename = "backupSetName", default, skip_serializing_if = "Option::is_none")]
    pub backup_set_name: Option<String>,
    #[serde(rename = "createMode", default, skip_serializing_if = "Option::is_none")]
    pub create_mode: Option<protected_item::CreateMode>,
    #[serde(rename = "deferredDeleteTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub deferred_delete_time_in_utc: Option<String>,
    #[serde(rename = "isScheduledForDeferredDelete", default, skip_serializing_if = "Option::is_none")]
    pub is_scheduled_for_deferred_delete: Option<bool>,
    #[serde(rename = "deferredDeleteTimeRemaining", default, skip_serializing_if = "Option::is_none")]
    pub deferred_delete_time_remaining: Option<String>,
    #[serde(rename = "isDeferredDeleteScheduleUpcoming", default, skip_serializing_if = "Option::is_none")]
    pub is_deferred_delete_schedule_upcoming: Option<bool>,
    #[serde(rename = "isRehydrate", default, skip_serializing_if = "Option::is_none")]
    pub is_rehydrate: Option<bool>,
}
impl ProtectedItem {
    pub fn new(protected_item_type: String) -> Self {
        Self {
            protected_item_type,
            backup_management_type: None,
            workload_type: None,
            container_name: None,
            source_resource_id: None,
            policy_id: None,
            last_recovery_point: None,
            backup_set_name: None,
            create_mode: None,
            deferred_delete_time_in_utc: None,
            is_scheduled_for_deferred_delete: None,
            deferred_delete_time_remaining: None,
            is_deferred_delete_schedule_upcoming: None,
            is_rehydrate: None,
        }
    }
}
pub mod protected_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreateMode {
        Invalid,
        Default,
        Recover,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectedItemQueryObject {
    #[serde(rename = "healthState", default, skip_serializing_if = "Option::is_none")]
    pub health_state: Option<protected_item_query_object::HealthState>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protected_item_query_object::BackupManagementType>,
    #[serde(rename = "itemType", default, skip_serializing_if = "Option::is_none")]
    pub item_type: Option<protected_item_query_object::ItemType>,
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(rename = "backupEngineName", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_name: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "backupSetName", default, skip_serializing_if = "Option::is_none")]
    pub backup_set_name: Option<String>,
}
impl ProtectedItemQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protected_item_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum HealthState {
        Passed,
        ActionRequired,
        ActionSuggested,
        Invalid,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ItemType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectedItemResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectedItem>,
}
impl ProtectedItemResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectedItemResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectedItemResource>,
}
impl ProtectedItemResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProtectionContainer {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protection_container::BackupManagementType>,
    #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub registration_status: Option<String>,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<String>,
    #[serde(rename = "containerType")]
    pub container_type: protection_container::ContainerType,
}
impl ProtectionContainer {
    pub fn new(container_type: protection_container::ContainerType) -> Self {
        Self {
            friendly_name: None,
            backup_management_type: None,
            registration_status: None,
            health_status: None,
            container_type,
        }
    }
}
pub mod protection_container {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ContainerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectionContainer>,
}
impl ProtectionContainerResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectionContainerResource>,
}
impl ProtectionContainerResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProtectionIntent {
    #[serde(rename = "protectionIntentItemType")]
    pub protection_intent_item_type: String,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protection_intent::BackupManagementType>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "itemId", default, skip_serializing_if = "Option::is_none")]
    pub item_id: Option<String>,
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<protection_intent::ProtectionState>,
}
impl ProtectionIntent {
    pub fn new(protection_intent_item_type: String) -> Self {
        Self {
            protection_intent_item_type,
            backup_management_type: None,
            source_resource_id: None,
            item_id: None,
            policy_id: None,
            protection_state: None,
        }
    }
}
pub mod protection_intent {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionIntentQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protection_intent_query_object::BackupManagementType>,
    #[serde(rename = "itemType", default, skip_serializing_if = "Option::is_none")]
    pub item_type: Option<protection_intent_query_object::ItemType>,
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    #[serde(rename = "itemName", default, skip_serializing_if = "Option::is_none")]
    pub item_name: Option<String>,
}
impl ProtectionIntentQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protection_intent_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ItemType {
        Invalid,
        #[serde(rename = "SQLInstance")]
        SqlInstance,
        #[serde(rename = "SQLAvailabilityGroupContainer")]
        SqlAvailabilityGroupContainer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionIntentResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectionIntent>,
}
impl ProtectionIntentResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionIntentResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectionIntentResource>,
}
impl ProtectionIntentResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProtectionPolicy {
    #[serde(rename = "protectedItemsCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_items_count: Option<i32>,
    #[serde(rename = "backupManagementType")]
    pub backup_management_type: String,
}
impl ProtectionPolicy {
    pub fn new(backup_management_type: String) -> Self {
        Self {
            protected_items_count: None,
            backup_management_type,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionPolicyQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protection_policy_query_object::BackupManagementType>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<protection_policy_query_object::WorkloadType>,
}
impl ProtectionPolicyQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protection_policy_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionPolicyResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectionPolicy>,
}
impl ProtectionPolicyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionPolicyResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectionPolicyResource>,
}
impl ProtectionPolicyResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPoint {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl RecoveryPoint {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointDiskConfiguration {
    #[serde(rename = "numberOfDisksIncludedInBackup", default, skip_serializing_if = "Option::is_none")]
    pub number_of_disks_included_in_backup: Option<i32>,
    #[serde(rename = "numberOfDisksAttachedToVm", default, skip_serializing_if = "Option::is_none")]
    pub number_of_disks_attached_to_vm: Option<i32>,
    #[serde(rename = "includedDiskList", default, skip_serializing_if = "Vec::is_empty")]
    pub included_disk_list: Vec<DiskInformation>,
    #[serde(rename = "excludedDiskList", default, skip_serializing_if = "Vec::is_empty")]
    pub excluded_disk_list: Vec<DiskInformation>,
}
impl RecoveryPointDiskConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointMoveReadinessInfo {
    #[serde(rename = "isReadyForMove", default, skip_serializing_if = "Option::is_none")]
    pub is_ready_for_move: Option<bool>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Option::is_none")]
    pub additional_info: Option<String>,
}
impl RecoveryPointMoveReadinessInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointRehydrationInfo {
    #[serde(rename = "rehydrationRetentionDuration", default, skip_serializing_if = "Option::is_none")]
    pub rehydration_retention_duration: Option<String>,
    #[serde(rename = "rehydrationPriority", default, skip_serializing_if = "Option::is_none")]
    pub rehydration_priority: Option<recovery_point_rehydration_info::RehydrationPriority>,
}
impl RecoveryPointRehydrationInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recovery_point_rehydration_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RehydrationPriority {
        Standard,
        High,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RecoveryPoint>,
}
impl RecoveryPointResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RecoveryPointResource>,
}
impl RecoveryPointResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecoveryPointTierInformation {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<recovery_point_tier_information::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<recovery_point_tier_information::Status>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<serde_json::Value>,
}
impl RecoveryPointTierInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recovery_point_tier_information {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        #[serde(rename = "InstantRP")]
        InstantRp,
        #[serde(rename = "HardenedRP")]
        HardenedRp,
        #[serde(rename = "ArchivedRP")]
        ArchivedRp,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        Valid,
        Disabled,
        Deleted,
        Rehydrated,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceHealthDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl ResourceHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestoreFileSpecs {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "fileSpecType", default, skip_serializing_if = "Option::is_none")]
    pub file_spec_type: Option<String>,
    #[serde(rename = "targetFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub target_folder_path: Option<String>,
}
impl RestoreFileSpecs {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestoreRequest {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl RestoreRequest {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestoreRequestResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RestoreRequest>,
}
impl RestoreRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetentionDuration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "durationType", default, skip_serializing_if = "Option::is_none")]
    pub duration_type: Option<retention_duration::DurationType>,
}
impl RetentionDuration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod retention_duration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DurationType {
        Invalid,
        Days,
        Weeks,
        Months,
        Years,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RetentionPolicy {
    #[serde(rename = "retentionPolicyType")]
    pub retention_policy_type: String,
}
impl RetentionPolicy {
    pub fn new(retention_policy_type: String) -> Self {
        Self { retention_policy_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDataDirectory {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<sql_data_directory::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "logicalName", default, skip_serializing_if = "Option::is_none")]
    pub logical_name: Option<String>,
}
impl SqlDataDirectory {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_data_directory {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        Data,
        Log,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDataDirectoryMapping {
    #[serde(rename = "mappingType", default, skip_serializing_if = "Option::is_none")]
    pub mapping_type: Option<sql_data_directory_mapping::MappingType>,
    #[serde(rename = "sourceLogicalName", default, skip_serializing_if = "Option::is_none")]
    pub source_logical_name: Option<String>,
    #[serde(rename = "sourcePath", default, skip_serializing_if = "Option::is_none")]
    pub source_path: Option<String>,
    #[serde(rename = "targetPath", default, skip_serializing_if = "Option::is_none")]
    pub target_path: Option<String>,
}
impl SqlDataDirectoryMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_data_directory_mapping {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MappingType {
        Invalid,
        Data,
        Log,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SchedulePolicy {
    #[serde(rename = "schedulePolicyType")]
    pub schedule_policy_type: String,
}
impl SchedulePolicy {
    pub fn new(schedule_policy_type: String) -> Self {
        Self { schedule_policy_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Settings {
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub issqlcompression: Option<bool>,
    #[serde(rename = "isCompression", default, skip_serializing_if = "Option::is_none")]
    pub is_compression: Option<bool>,
}
impl Settings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SimpleRetentionPolicy {
    #[serde(flatten)]
    pub retention_policy: RetentionPolicy,
    #[serde(rename = "retentionDuration", default, skip_serializing_if = "Option::is_none")]
    pub retention_duration: Option<RetentionDuration>,
}
impl SimpleRetentionPolicy {
    pub fn new(retention_policy: RetentionPolicy) -> Self {
        Self {
            retention_policy,
            retention_duration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SimpleSchedulePolicy {
    #[serde(flatten)]
    pub schedule_policy: SchedulePolicy,
    #[serde(rename = "scheduleRunFrequency", default, skip_serializing_if = "Option::is_none")]
    pub schedule_run_frequency: Option<simple_schedule_policy::ScheduleRunFrequency>,
    #[serde(rename = "scheduleRunDays", default, skip_serializing_if = "Vec::is_empty")]
    pub schedule_run_days: Vec<String>,
    #[serde(rename = "scheduleRunTimes", default, skip_serializing_if = "Vec::is_empty")]
    pub schedule_run_times: Vec<String>,
    #[serde(rename = "scheduleWeeklyFrequency", default, skip_serializing_if = "Option::is_none")]
    pub schedule_weekly_frequency: Option<i32>,
}
impl SimpleSchedulePolicy {
    pub fn new(schedule_policy: SchedulePolicy) -> Self {
        Self {
            schedule_policy,
            schedule_run_frequency: None,
            schedule_run_days: Vec::new(),
            schedule_run_times: Vec::new(),
            schedule_weekly_frequency: None,
        }
    }
}
pub mod simple_schedule_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScheduleRunFrequency {
        Invalid,
        Daily,
        Weekly,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubProtectionPolicy {
    #[serde(rename = "policyType", default, skip_serializing_if = "Option::is_none")]
    pub policy_type: Option<sub_protection_policy::PolicyType>,
    #[serde(rename = "schedulePolicy", default, skip_serializing_if = "Option::is_none")]
    pub schedule_policy: Option<SchedulePolicy>,
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicy>,
}
impl SubProtectionPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sub_protection_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PolicyType {
        Invalid,
        Full,
        Differential,
        Log,
        CopyOnlyFull,
        Incremental,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetAfsRestoreInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "targetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_id: Option<String>,
}
impl TargetAfsRestoreInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetRestoreInfo {
    #[serde(rename = "overwriteOption", default, skip_serializing_if = "Option::is_none")]
    pub overwrite_option: Option<target_restore_info::OverwriteOption>,
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "targetDirectoryForFileRestore", default, skip_serializing_if = "Option::is_none")]
    pub target_directory_for_file_restore: Option<String>,
}
impl TargetRestoreInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod target_restore_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OverwriteOption {
        Invalid,
        FailOnConflict,
        Overwrite,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenInformation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub token: Option<String>,
    #[serde(rename = "expiryTimeInUtcTicks", default, skip_serializing_if = "Option::is_none")]
    pub expiry_time_in_utc_ticks: Option<i64>,
    #[serde(rename = "securityPIN", default, skip_serializing_if = "Option::is_none")]
    pub security_pin: Option<String>,
}
impl TokenInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerDataMoveRequest {
    #[serde(rename = "sourceResourceId")]
    pub source_resource_id: String,
    #[serde(rename = "sourceRegion")]
    pub source_region: String,
    #[serde(rename = "dataMoveLevel")]
    pub data_move_level: trigger_data_move_request::DataMoveLevel,
    #[serde(rename = "correlationId")]
    pub correlation_id: String,
    #[serde(rename = "sourceContainerArmIds", default, skip_serializing_if = "Vec::is_empty")]
    pub source_container_arm_ids: Vec<String>,
    #[serde(rename = "pauseGC", default, skip_serializing_if = "Option::is_none")]
    pub pause_gc: Option<bool>,
}
impl TriggerDataMoveRequest {
    pub fn new(
        source_resource_id: String,
        source_region: String,
        data_move_level: trigger_data_move_request::DataMoveLevel,
        correlation_id: String,
    ) -> Self {
        Self {
            source_resource_id,
            source_region,
            data_move_level,
            correlation_id,
            source_container_arm_ids: Vec::new(),
            pause_gc: None,
        }
    }
}
pub mod trigger_data_move_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataMoveLevel {
        Invalid,
        Vault,
        Container,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidateIaasVmRestoreOperationRequest {
    #[serde(flatten)]
    pub validate_restore_operation_request: ValidateRestoreOperationRequest,
}
impl ValidateIaasVmRestoreOperationRequest {
    pub fn new(validate_restore_operation_request: ValidateRestoreOperationRequest) -> Self {
        Self {
            validate_restore_operation_request,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidateOperationRequest {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl ValidateOperationRequest {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateOperationResponse {
    #[serde(rename = "validationResults", default, skip_serializing_if = "Vec::is_empty")]
    pub validation_results: Vec<ErrorDetail>,
}
impl ValidateOperationResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ValidateOperationsResponse {
    #[serde(rename = "validateOperationResponse", default, skip_serializing_if = "Option::is_none")]
    pub validate_operation_response: Option<ValidateOperationResponse>,
}
impl ValidateOperationsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidateRestoreOperationRequest {
    #[serde(flatten)]
    pub validate_operation_request: ValidateOperationRequest,
    #[serde(rename = "restoreRequest", default, skip_serializing_if = "Option::is_none")]
    pub restore_request: Option<RestoreRequest>,
}
impl ValidateRestoreOperationRequest {
    pub fn new(validate_operation_request: ValidateOperationRequest) -> Self {
        Self {
            validate_operation_request,
            restore_request: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VaultJob {
    #[serde(flatten)]
    pub job: Job,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(rename = "actionsInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub actions_info: Vec<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<VaultJobErrorInfo>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<VaultJobExtendedInfo>,
}
impl VaultJob {
    pub fn new(job: Job) -> Self {
        Self {
            job,
            duration: None,
            actions_info: Vec::new(),
            error_details: Vec::new(),
            extended_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultJobErrorInfo {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorString", default, skip_serializing_if = "Option::is_none")]
    pub error_string: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl VaultJobErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VaultJobExtendedInfo {
    #[serde(rename = "propertyBag", default, skip_serializing_if = "Option::is_none")]
    pub property_bag: Option<serde_json::Value>,
}
impl VaultJobExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VaultStorageConfigOperationResultResponse {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl VaultStorageConfigOperationResultResponse {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WeeklyRetentionFormat {
    #[serde(rename = "daysOfTheWeek", default, skip_serializing_if = "Vec::is_empty")]
    pub days_of_the_week: Vec<String>,
    #[serde(rename = "weeksOfTheMonth", default, skip_serializing_if = "Vec::is_empty")]
    pub weeks_of_the_month: Vec<String>,
}
impl WeeklyRetentionFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WeeklyRetentionSchedule {
    #[serde(rename = "daysOfTheWeek", default, skip_serializing_if = "Vec::is_empty")]
    pub days_of_the_week: Vec<String>,
    #[serde(rename = "retentionTimes", default, skip_serializing_if = "Vec::is_empty")]
    pub retention_times: Vec<String>,
    #[serde(rename = "retentionDuration", default, skip_serializing_if = "Option::is_none")]
    pub retention_duration: Option<RetentionDuration>,
}
impl WeeklyRetentionSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadInquiryDetails {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "itemCount", default, skip_serializing_if = "Option::is_none")]
    pub item_count: Option<i64>,
    #[serde(rename = "inquiryValidation", default, skip_serializing_if = "Option::is_none")]
    pub inquiry_validation: Option<InquiryValidation>,
}
impl WorkloadInquiryDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkloadItem {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<String>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[serde(rename = "workloadItemType")]
    pub workload_item_type: String,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<workload_item::ProtectionState>,
}
impl WorkloadItem {
    pub fn new(workload_item_type: String) -> Self {
        Self {
            backup_management_type: None,
            workload_type: None,
            workload_item_type,
            friendly_name: None,
            protection_state: None,
        }
    }
}
pub mod workload_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadItemResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkloadItem>,
}
impl WorkloadItemResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadItemResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkloadItemResource>,
}
impl WorkloadItemResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkloadProtectableItem {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<String>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[serde(rename = "protectableItemType")]
    pub protectable_item_type: String,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<workload_protectable_item::ProtectionState>,
}
impl WorkloadProtectableItem {
    pub fn new(protectable_item_type: String) -> Self {
        Self {
            backup_management_type: None,
            workload_type: None,
            protectable_item_type,
            friendly_name: None,
            protection_state: None,
        }
    }
}
pub mod workload_protectable_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadProtectableItemResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkloadProtectableItem>,
}
impl WorkloadProtectableItemResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadProtectableItemResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkloadProtectableItemResource>,
}
impl WorkloadProtectableItemResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct YearlyRetentionSchedule {
    #[serde(rename = "retentionScheduleFormatType", default, skip_serializing_if = "Option::is_none")]
    pub retention_schedule_format_type: Option<yearly_retention_schedule::RetentionScheduleFormatType>,
    #[serde(rename = "monthsOfYear", default, skip_serializing_if = "Vec::is_empty")]
    pub months_of_year: Vec<String>,
    #[serde(rename = "retentionScheduleDaily", default, skip_serializing_if = "Option::is_none")]
    pub retention_schedule_daily: Option<DailyRetentionFormat>,
    #[serde(rename = "retentionScheduleWeekly", default, skip_serializing_if = "Option::is_none")]
    pub retention_schedule_weekly: Option<WeeklyRetentionFormat>,
    #[serde(rename = "retentionTimes", default, skip_serializing_if = "Vec::is_empty")]
    pub retention_times: Vec<String>,
    #[serde(rename = "retentionDuration", default, skip_serializing_if = "Option::is_none")]
    pub retention_duration: Option<RetentionDuration>,
}
impl YearlyRetentionSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod yearly_retention_schedule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RetentionScheduleFormatType {
        Invalid,
        Daily,
        Weekly,
    }
}
