#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBackupServerContainer {
    #[serde(flatten)]
    pub dpm_container: DpmContainer,
}
impl AzureBackupServerContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBackupServerEngine {
    #[serde(flatten)]
    pub backup_engine_base: BackupEngineBase,
}
impl AzureBackupServerEngine {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareBackupRequest {
    #[serde(flatten)]
    pub backup_request: BackupRequest,
    #[serde(rename = "recoveryPointExpiryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_expiry_time_in_utc: Option<String>,
}
impl AzureFileShareBackupRequest {
    pub fn new(backup_request: BackupRequest) -> Self {
        Self {
            backup_request,
            recovery_point_expiry_time_in_utc: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFileShareProtectableItem {
    #[serde(flatten)]
    pub workload_protectable_item: WorkloadProtectableItem,
    #[serde(rename = "parentContainerFabricId", default, skip_serializing_if = "Option::is_none")]
    pub parent_container_fabric_id: Option<String>,
    #[serde(rename = "parentContainerFriendlyName", default, skip_serializing_if = "Option::is_none")]
    pub parent_container_friendly_name: Option<String>,
    #[serde(rename = "azureFileShareType", default, skip_serializing_if = "Option::is_none")]
    pub azure_file_share_type: Option<azure_file_share_protectable_item::AzureFileShareType>,
}
impl AzureFileShareProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_file_share_protectable_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AzureFileShareType {
        Invalid,
        #[serde(rename = "XSMB")]
        Xsmb,
        XSync,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileShareProvisionIlrRequest {
    #[serde(flatten)]
    pub ilr_request: IlrRequest,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
}
impl AzureFileShareProvisionIlrRequest {
    pub fn new(ilr_request: IlrRequest) -> Self {
        Self {
            ilr_request,
            recovery_point_id: None,
            source_resource_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSClassicComputeVmContainer {
    #[serde(flatten)]
    pub iaa_svm_container: IaaSvmContainer,
}
impl AzureIaaSClassicComputeVmContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSClassicComputeVmProtectableItem {
    #[serde(flatten)]
    pub iaa_svm_protectable_item: IaaSvmProtectableItem,
}
impl AzureIaaSClassicComputeVmProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSComputeVmContainer {
    #[serde(flatten)]
    pub iaa_svm_container: IaaSvmContainer,
}
impl AzureIaaSComputeVmContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureIaaSComputeVmProtectableItem {
    #[serde(flatten)]
    pub iaa_svm_protectable_item: IaaSvmProtectableItem,
}
impl AzureIaaSComputeVmProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlagWorkloadContainerProtectionContainer {
    #[serde(flatten)]
    pub azure_workload_container: AzureWorkloadContainer,
}
impl AzureSqlagWorkloadContainerProtectionContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
}
impl AzureSqlContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "storageAccountVersion", default, skip_serializing_if = "Option::is_none")]
    pub storage_account_version: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i64>,
}
impl AzureStorageContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageProtectableContainer {
    #[serde(flatten)]
    pub protectable_container: ProtectableContainer,
}
impl AzureStorageProtectableContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmAppContainerProtectableContainer {
    #[serde(flatten)]
    pub protectable_container: ProtectableContainer,
}
impl AzureVmAppContainerProtectableContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmAppContainerProtectionContainer {
    #[serde(flatten)]
    pub azure_workload_container: AzureWorkloadContainer,
}
impl AzureVmAppContainerProtectionContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadItem {
    #[serde(flatten)]
    pub workload_item: WorkloadItem,
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[serde(rename = "isAutoProtectable", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_protectable: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subinquireditemcount: Option<i32>,
    #[serde(rename = "subWorkloadItemCount", default, skip_serializing_if = "Option::is_none")]
    pub sub_workload_item_count: Option<i32>,
}
impl AzureVmWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadProtectableItem {
    #[serde(flatten)]
    pub workload_protectable_item: WorkloadProtectableItem,
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    #[serde(rename = "parentUniqueName", default, skip_serializing_if = "Option::is_none")]
    pub parent_unique_name: Option<String>,
    #[serde(rename = "serverName", default, skip_serializing_if = "Option::is_none")]
    pub server_name: Option<String>,
    #[serde(rename = "isAutoProtectable", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_protectable: Option<bool>,
    #[serde(rename = "isAutoProtected", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_protected: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subinquireditemcount: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subprotectableitemcount: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prebackupvalidation: Option<PreBackupValidation>,
}
impl AzureVmWorkloadProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapAseDatabaseWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapAseDatabaseWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapAseSystemProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSapAseSystemProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapAseSystemWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapAseSystemWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapHanaDatabaseProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSapHanaDatabaseProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapHanaDatabaseWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapHanaDatabaseWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapHanaSystemProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSapHanaSystemProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSapHanaSystemWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSapHanaSystemWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlAvailabilityGroupProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSqlAvailabilityGroupProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlDatabaseProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSqlDatabaseProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlDatabaseWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
}
impl AzureVmWorkloadSqlDatabaseWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlInstanceProtectableItem {
    #[serde(flatten)]
    pub azure_vm_workload_protectable_item: AzureVmWorkloadProtectableItem,
}
impl AzureVmWorkloadSqlInstanceProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureVmWorkloadSqlInstanceWorkloadItem {
    #[serde(flatten)]
    pub azure_vm_workload_item: AzureVmWorkloadItem,
    #[serde(rename = "dataDirectoryPaths", default, skip_serializing_if = "Vec::is_empty")]
    pub data_directory_paths: Vec<SqlDataDirectory>,
}
impl AzureVmWorkloadSqlInstanceWorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureWorkloadBackupRequest {
    #[serde(flatten)]
    pub backup_request: BackupRequest,
    #[serde(rename = "backupType", default, skip_serializing_if = "Option::is_none")]
    pub backup_type: Option<azure_workload_backup_request::BackupType>,
    #[serde(rename = "enableCompression", default, skip_serializing_if = "Option::is_none")]
    pub enable_compression: Option<bool>,
    #[serde(rename = "recoveryPointExpiryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_expiry_time_in_utc: Option<String>,
}
impl AzureWorkloadBackupRequest {
    pub fn new(backup_request: BackupRequest) -> Self {
        Self {
            backup_request,
            backup_type: None,
            enable_compression: None,
            recovery_point_expiry_time_in_utc: None,
        }
    }
}
pub mod azure_workload_backup_request {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupType {
        Invalid,
        Full,
        Differential,
        Log,
        CopyOnlyFull,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "sourceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub source_resource_id: Option<String>,
    #[serde(rename = "lastUpdatedTime", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_time: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<AzureWorkloadContainerExtendedInfo>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<azure_workload_container::WorkloadType>,
    #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
    pub operation_type: Option<azure_workload_container::OperationType>,
}
impl AzureWorkloadContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_workload_container {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationType {
        Invalid,
        Register,
        Reregister,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWorkloadContainerExtendedInfo {
    #[serde(rename = "hostServerName", default, skip_serializing_if = "Option::is_none")]
    pub host_server_name: Option<String>,
    #[serde(rename = "inquiryInfo", default, skip_serializing_if = "Option::is_none")]
    pub inquiry_info: Option<InquiryInfo>,
    #[serde(rename = "nodesList", default, skip_serializing_if = "Vec::is_empty")]
    pub nodes_list: Vec<DistributedNodesInfo>,
}
impl AzureWorkloadContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsBackupEngineQueryObject {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
}
impl BmsBackupEngineQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsBackupEnginesQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_backup_engines_query_object::BackupManagementType>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
}
impl BmsBackupEnginesQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_backup_engines_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BmsContainerQueryObject {
    #[serde(rename = "backupManagementType")]
    pub backup_management_type: bms_container_query_object::BackupManagementType,
    #[serde(rename = "containerType", default, skip_serializing_if = "Option::is_none")]
    pub container_type: Option<bms_container_query_object::ContainerType>,
    #[serde(rename = "backupEngineName", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_name: Option<String>,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl BmsContainerQueryObject {
    pub fn new(backup_management_type: bms_container_query_object::BackupManagementType) -> Self {
        Self {
            backup_management_type,
            container_type: None,
            backup_engine_name: None,
            fabric_name: None,
            status: None,
            friendly_name: None,
        }
    }
}
pub mod bms_container_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ContainerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsContainersInquiryQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_containers_inquiry_query_object::BackupManagementType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<bms_containers_inquiry_query_object::WorkloadType>,
}
impl BmsContainersInquiryQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_containers_inquiry_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmspoQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bmspo_query_object::BackupManagementType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<bmspo_query_object::WorkloadType>,
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
}
impl BmspoQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bmspo_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureSql,
        AzureBackupServer,
        AzureWorkload,
        AzureStorage,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsRefreshContainersQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_refresh_containers_query_object::BackupManagementType>,
}
impl BmsRefreshContainersQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_refresh_containers_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BmsWorkloadItemQueryObject {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<bms_workload_item_query_object::BackupManagementType>,
    #[serde(rename = "workloadItemType", default, skip_serializing_if = "Option::is_none")]
    pub workload_item_type: Option<bms_workload_item_query_object::WorkloadItemType>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<bms_workload_item_query_object::WorkloadType>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<bms_workload_item_query_object::ProtectionStatus>,
}
impl BmsWorkloadItemQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bms_workload_item_query_object {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureSql,
        AzureBackupServer,
        AzureWorkload,
        AzureStorage,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadItemType {
        Invalid,
        #[serde(rename = "SQLInstance")]
        SqlInstance,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        #[serde(rename = "SAPHanaSystem")]
        SapHanaSystem,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseSystem")]
        SapAseSystem,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WorkloadType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionStatus {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineBase {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<backup_engine_base::BackupManagementType>,
    #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub registration_status: Option<String>,
    #[serde(rename = "backupEngineState", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_state: Option<String>,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<String>,
    #[serde(rename = "backupEngineType", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_type: Option<backup_engine_base::BackupEngineType>,
    #[serde(rename = "canReRegister", default, skip_serializing_if = "Option::is_none")]
    pub can_re_register: Option<bool>,
    #[serde(rename = "backupEngineId", default, skip_serializing_if = "Option::is_none")]
    pub backup_engine_id: Option<String>,
    #[serde(rename = "dpmVersion", default, skip_serializing_if = "Option::is_none")]
    pub dpm_version: Option<String>,
    #[serde(rename = "azureBackupAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub azure_backup_agent_version: Option<String>,
    #[serde(rename = "isAzureBackupAgentUpgradeAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_azure_backup_agent_upgrade_available: Option<bool>,
    #[serde(rename = "isDpmUpgradeAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_dpm_upgrade_available: Option<bool>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<BackupEngineExtendedInfo>,
}
impl BackupEngineBase {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_engine_base {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupEngineType {
        Invalid,
        DpmBackupEngine,
        AzureBackupServerEngine,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineBaseResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupEngineBase>,
}
impl BackupEngineBaseResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineBaseResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackupEngineBaseResource>,
}
impl BackupEngineBaseResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupEngineExtendedInfo {
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "protectedItemsCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_items_count: Option<i32>,
    #[serde(rename = "protectedServersCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_servers_count: Option<i32>,
    #[serde(rename = "diskCount", default, skip_serializing_if = "Option::is_none")]
    pub disk_count: Option<i32>,
    #[serde(rename = "usedDiskSpace", default, skip_serializing_if = "Option::is_none")]
    pub used_disk_space: Option<f64>,
    #[serde(rename = "availableDiskSpace", default, skip_serializing_if = "Option::is_none")]
    pub available_disk_space: Option<f64>,
    #[serde(rename = "refreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub refreshed_at: Option<String>,
    #[serde(rename = "azureProtectedInstances", default, skip_serializing_if = "Option::is_none")]
    pub azure_protected_instances: Option<i32>,
}
impl BackupEngineExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BackupRequest {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl BackupRequest {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupRequestResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupRequest>,
}
impl BackupRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceConfig {
    #[serde(rename = "storageModelType", default, skip_serializing_if = "Option::is_none")]
    pub storage_model_type: Option<backup_resource_config::StorageModelType>,
    #[serde(rename = "storageType", default, skip_serializing_if = "Option::is_none")]
    pub storage_type: Option<backup_resource_config::StorageType>,
    #[serde(rename = "storageTypeState", default, skip_serializing_if = "Option::is_none")]
    pub storage_type_state: Option<backup_resource_config::StorageTypeState>,
}
impl BackupResourceConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod backup_resource_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageModelType {
        Invalid,
        GeoRedundant,
        LocallyRedundant,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageType {
        Invalid,
        GeoRedundant,
        LocallyRedundant,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StorageTypeState {
        Invalid,
        Locked,
        Unlocked,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackupResourceConfigResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackupResourceConfig>,
}
impl BackupResourceConfigResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClientScriptForConnect {
    #[serde(rename = "scriptContent", default, skip_serializing_if = "Option::is_none")]
    pub script_content: Option<String>,
    #[serde(rename = "scriptExtension", default, skip_serializing_if = "Option::is_none")]
    pub script_extension: Option<String>,
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "scriptNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub script_name_suffix: Option<String>,
}
impl ClientScriptForConnect {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerIdentityInfo {
    #[serde(rename = "uniqueName", default, skip_serializing_if = "Option::is_none")]
    pub unique_name: Option<String>,
    #[serde(rename = "aadTenantId", default, skip_serializing_if = "Option::is_none")]
    pub aad_tenant_id: Option<String>,
    #[serde(rename = "servicePrincipalClientId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_client_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub audience: Option<String>,
}
impl ContainerIdentityInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmContainerExtendedInfo {
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
}
impl DpmContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DistributedNodesInfo {
    #[serde(rename = "nodeName", default, skip_serializing_if = "Option::is_none")]
    pub node_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "errorDetail", default, skip_serializing_if = "Option::is_none")]
    pub error_detail: Option<ErrorDetail>,
}
impl DistributedNodesInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmBackupEngine {
    #[serde(flatten)]
    pub backup_engine_base: BackupEngineBase,
}
impl DpmBackupEngine {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DpmContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "canReRegister", default, skip_serializing_if = "Option::is_none")]
    pub can_re_register: Option<bool>,
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i64>,
    #[serde(rename = "dpmAgentVersion", default, skip_serializing_if = "Option::is_none")]
    pub dpm_agent_version: Option<String>,
    #[serde(rename = "dpmServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dpm_servers: Vec<String>,
    #[serde(rename = "upgradeAvailable", default, skip_serializing_if = "Option::is_none")]
    pub upgrade_available: Option<bool>,
    #[serde(rename = "protectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub protection_status: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<DpmContainerExtendedInfo>,
}
impl DpmContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl ErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenericContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "fabricName", default, skip_serializing_if = "Option::is_none")]
    pub fabric_name: Option<String>,
    #[serde(rename = "extendedInformation", default, skip_serializing_if = "Option::is_none")]
    pub extended_information: Option<GenericContainerExtendedInfo>,
}
impl GenericContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenericContainerExtendedInfo {
    #[serde(rename = "rawCertData", default, skip_serializing_if = "Option::is_none")]
    pub raw_cert_data: Option<String>,
    #[serde(rename = "containerIdentityInfo", default, skip_serializing_if = "Option::is_none")]
    pub container_identity_info: Option<ContainerIdentityInfo>,
    #[serde(rename = "serviceEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub service_endpoints: Option<serde_json::Value>,
}
impl GenericContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IlrRequest {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl IlrRequest {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IlrRequestResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IlrRequest>,
}
impl IlrRequestResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IaaSvmContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
    #[serde(rename = "virtualMachineVersion", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_version: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl IaaSvmContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IaaSvmProtectableItem {
    #[serde(flatten)]
    pub workload_protectable_item: WorkloadProtectableItem,
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
}
impl IaaSvmProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmBackupRequest {
    #[serde(flatten)]
    pub backup_request: BackupRequest,
    #[serde(rename = "recoveryPointExpiryTimeInUTC", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_expiry_time_in_utc: Option<String>,
}
impl IaasVmBackupRequest {
    pub fn new(backup_request: BackupRequest) -> Self {
        Self {
            backup_request,
            recovery_point_expiry_time_in_utc: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IaasVmilrRegistrationRequest {
    #[serde(flatten)]
    pub ilr_request: IlrRequest,
    #[serde(rename = "recoveryPointId", default, skip_serializing_if = "Option::is_none")]
    pub recovery_point_id: Option<String>,
    #[serde(rename = "virtualMachineId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_id: Option<String>,
    #[serde(rename = "initiatorName", default, skip_serializing_if = "Option::is_none")]
    pub initiator_name: Option<String>,
    #[serde(rename = "renewExistingRegistration", default, skip_serializing_if = "Option::is_none")]
    pub renew_existing_registration: Option<bool>,
}
impl IaasVmilrRegistrationRequest {
    pub fn new(ilr_request: IlrRequest) -> Self {
        Self {
            ilr_request,
            recovery_point_id: None,
            virtual_machine_id: None,
            initiator_name: None,
            renew_existing_registration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InquiryInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "errorDetail", default, skip_serializing_if = "Option::is_none")]
    pub error_detail: Option<ErrorDetail>,
    #[serde(rename = "inquiryDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub inquiry_details: Vec<WorkloadInquiryDetails>,
}
impl InquiryInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InquiryValidation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "errorDetail", default, skip_serializing_if = "Option::is_none")]
    pub error_detail: Option<ErrorDetail>,
    #[serde(rename = "additionalDetail", default, skip_serializing_if = "Option::is_none")]
    pub additional_detail: Option<String>,
}
impl InquiryValidation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstantItemRecoveryTarget {
    #[serde(rename = "clientScripts", default, skip_serializing_if = "Vec::is_empty")]
    pub client_scripts: Vec<ClientScriptForConnect>,
}
impl InstantItemRecoveryTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabContainerHealthDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub recommendations: Vec<String>,
}
impl MabContainerHealthDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabContainer {
    #[serde(flatten)]
    pub protection_container: ProtectionContainer,
    #[serde(rename = "canReRegister", default, skip_serializing_if = "Option::is_none")]
    pub can_re_register: Option<bool>,
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<i64>,
    #[serde(rename = "protectedItemCount", default, skip_serializing_if = "Option::is_none")]
    pub protected_item_count: Option<i64>,
    #[serde(rename = "agentVersion", default, skip_serializing_if = "Option::is_none")]
    pub agent_version: Option<String>,
    #[serde(rename = "extendedInfo", default, skip_serializing_if = "Option::is_none")]
    pub extended_info: Option<MabContainerExtendedInfo>,
    #[serde(rename = "mabContainerHealthDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub mab_container_health_details: Vec<MabContainerHealthDetails>,
    #[serde(rename = "containerHealthState", default, skip_serializing_if = "Option::is_none")]
    pub container_health_state: Option<String>,
}
impl MabContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MabContainerExtendedInfo {
    #[serde(rename = "lastRefreshedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_refreshed_at: Option<String>,
    #[serde(rename = "backupItemType", default, skip_serializing_if = "Option::is_none")]
    pub backup_item_type: Option<mab_container_extended_info::BackupItemType>,
    #[serde(rename = "backupItems", default, skip_serializing_if = "Vec::is_empty")]
    pub backup_items: Vec<String>,
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<String>,
    #[serde(rename = "lastBackupStatus", default, skip_serializing_if = "Option::is_none")]
    pub last_backup_status: Option<String>,
}
impl MabContainerExtendedInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod mab_container_extended_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupItemType {
        Invalid,
        #[serde(rename = "VM")]
        Vm,
        FileFolder,
        AzureSqlDb,
        #[serde(rename = "SQLDB")]
        Sqldb,
        Exchange,
        Sharepoint,
        #[serde(rename = "VMwareVM")]
        VMwareVm,
        SystemState,
        Client,
        GenericDataSource,
        #[serde(rename = "SQLDataBase")]
        SqlDataBase,
        AzureFileShare,
        #[serde(rename = "SAPHanaDatabase")]
        SapHanaDatabase,
        #[serde(rename = "SAPAseDatabase")]
        SapAseDatabase,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<operation_status::Status>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<OperationStatusError>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationStatusExtendedInfo>,
}
impl OperationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        InProgress,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationStatusError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl OperationStatusError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusExtendedInfo {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl OperationStatusExtendedInfo {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusJobExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
}
impl OperationStatusJobExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            job_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusJobsExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "jobIds", default, skip_serializing_if = "Vec::is_empty")]
    pub job_ids: Vec<String>,
    #[serde(rename = "failedJobsError", default, skip_serializing_if = "Option::is_none")]
    pub failed_jobs_error: Option<serde_json::Value>,
}
impl OperationStatusJobsExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            job_ids: Vec::new(),
            failed_jobs_error: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusProvisionIlrExtendedInfo {
    #[serde(flatten)]
    pub operation_status_extended_info: OperationStatusExtendedInfo,
    #[serde(rename = "recoveryTarget", default, skip_serializing_if = "Option::is_none")]
    pub recovery_target: Option<InstantItemRecoveryTarget>,
}
impl OperationStatusProvisionIlrExtendedInfo {
    pub fn new(operation_status_extended_info: OperationStatusExtendedInfo) -> Self {
        Self {
            operation_status_extended_info,
            recovery_target: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PreBackupValidation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<pre_backup_validation::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl PreBackupValidation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pre_backup_validation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Invalid,
        Success,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableContainer {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protectable_container::BackupManagementType>,
    #[serde(rename = "protectableContainerType", default, skip_serializing_if = "Option::is_none")]
    pub protectable_container_type: Option<protectable_container::ProtectableContainerType>,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<String>,
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
}
impl ProtectableContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protectable_container {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectableContainerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectableContainer>,
}
impl ProtectableContainerResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectableContainerResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectableContainerResource>,
}
impl ProtectableContainerResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainer {
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<protection_container::BackupManagementType>,
    #[serde(rename = "registrationStatus", default, skip_serializing_if = "Option::is_none")]
    pub registration_status: Option<String>,
    #[serde(rename = "healthStatus", default, skip_serializing_if = "Option::is_none")]
    pub health_status: Option<String>,
    #[serde(rename = "containerType", default, skip_serializing_if = "Option::is_none")]
    pub container_type: Option<protection_container::ContainerType>,
}
impl ProtectionContainer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protection_container {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BackupManagementType {
        Invalid,
        #[serde(rename = "AzureIaasVM")]
        AzureIaasVm,
        #[serde(rename = "MAB")]
        Mab,
        #[serde(rename = "DPM")]
        Dpm,
        AzureBackupServer,
        AzureSql,
        AzureStorage,
        AzureWorkload,
        DefaultBackup,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ContainerType {
        Invalid,
        Unknown,
        #[serde(rename = "IaasVMContainer")]
        IaasVmContainer,
        #[serde(rename = "IaasVMServiceContainer")]
        IaasVmServiceContainer,
        #[serde(rename = "DPMContainer")]
        DpmContainer,
        AzureBackupServerContainer,
        #[serde(rename = "MABContainer")]
        MabContainer,
        Cluster,
        AzureSqlContainer,
        Windows,
        VCenter,
        #[serde(rename = "VMAppContainer")]
        VmAppContainer,
        #[serde(rename = "SQLAGWorkLoadContainer")]
        SqlagWorkLoadContainer,
        StorageContainer,
        GenericContainer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProtectionContainer>,
}
impl ProtectionContainerResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtectionContainerResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProtectionContainerResource>,
}
impl ProtectionContainerResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RecoveryPoint {
    #[serde(rename = "objectType")]
    pub object_type: String,
}
impl RecoveryPoint {
    pub fn new(object_type: String) -> Self {
        Self { object_type }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceList {
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlDataDirectory {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<sql_data_directory::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "logicalName", default, skip_serializing_if = "Option::is_none")]
    pub logical_name: Option<String>,
}
impl SqlDataDirectory {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_data_directory {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Invalid,
        Data,
        Log,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TokenInformation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub token: Option<String>,
    #[serde(rename = "expiryTimeInUtcTicks", default, skip_serializing_if = "Option::is_none")]
    pub expiry_time_in_utc_ticks: Option<i64>,
    #[serde(rename = "securityPIN", default, skip_serializing_if = "Option::is_none")]
    pub security_pin: Option<String>,
}
impl TokenInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadInquiryDetails {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "itemCount", default, skip_serializing_if = "Option::is_none")]
    pub item_count: Option<i64>,
    #[serde(rename = "inquiryValidation", default, skip_serializing_if = "Option::is_none")]
    pub inquiry_validation: Option<InquiryValidation>,
}
impl WorkloadInquiryDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadItem {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<String>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[serde(rename = "workloadItemType", default, skip_serializing_if = "Option::is_none")]
    pub workload_item_type: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<workload_item::ProtectionState>,
}
impl WorkloadItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod workload_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadItemResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkloadItem>,
}
impl WorkloadItemResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadItemResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkloadItemResource>,
}
impl WorkloadItemResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadProtectableItem {
    #[serde(rename = "backupManagementType", default, skip_serializing_if = "Option::is_none")]
    pub backup_management_type: Option<String>,
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[serde(rename = "protectableItemType", default, skip_serializing_if = "Option::is_none")]
    pub protectable_item_type: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(rename = "protectionState", default, skip_serializing_if = "Option::is_none")]
    pub protection_state: Option<workload_protectable_item::ProtectionState>,
}
impl WorkloadProtectableItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod workload_protectable_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionState {
        Invalid,
        NotProtected,
        Protecting,
        Protected,
        ProtectionFailed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadProtectableItemResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkloadProtectableItem>,
}
impl WorkloadProtectableItemResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkloadProtectableItemResourceList {
    #[serde(flatten)]
    pub resource_list: ResourceList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WorkloadProtectableItemResource>,
}
impl WorkloadProtectableItemResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
