#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Account resource patch details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccountPatchResource {
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<Tags>,
    #[doc = "Account resource patch properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<account_patch_resource::Properties>,
}
impl AccountPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod account_patch_resource {
    use super::*;
    #[doc = "Account resource patch properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The list of service endpoints authentication details."]
        #[serde(rename = "endpointAuthentications", default, skip_serializing_if = "Option::is_none")]
        pub endpoint_authentications: Option<EndpointAuthenticationsList>,
        #[doc = "The list of CORS details."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub cors: Option<CorsRuleList>,
        #[doc = "Connection string to write Accounts reports to."]
        #[serde(rename = "reportsConnectionString", default, skip_serializing_if = "Option::is_none")]
        pub reports_connection_string: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Account resource details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccountResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Account resource properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<account_resource::Properties>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl AccountResource {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
            system_data: None,
        }
    }
}
pub mod account_resource {
    use super::*;
    #[doc = "Account resource properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Account configuration. This can only be set at RecommendationsService Account creation."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub configuration: Option<properties::Configuration>,
        #[doc = "The list of service endpoints authentication details."]
        #[serde(rename = "endpointAuthentications", default, skip_serializing_if = "Option::is_none")]
        pub endpoint_authentications: Option<EndpointAuthenticationsList>,
        #[doc = "The list of CORS details."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub cors: Option<CorsRuleList>,
        #[doc = "Connection string to write Accounts reports to."]
        #[serde(rename = "reportsConnectionString", default, skip_serializing_if = "Option::is_none")]
        pub reports_connection_string: Option<String>,
        #[doc = "The resource provisioning state."]
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Account configuration. This can only be set at RecommendationsService Account creation."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Configuration {
            Free,
            Capacity,
        }
    }
}
#[doc = "The list of RecommendationsService Account resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccountResourceList {
    #[doc = "The link used to get the next page of RecommendationsService Account resources list."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "The list of RecommendationsService Account resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AccountResource>,
}
impl AccountResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Account status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccountStatus {
    #[doc = "The list of scopes statuses."]
    #[serde(rename = "scopesStatuses", default, skip_serializing_if = "Vec::is_empty")]
    pub scopes_statuses: Vec<ScopeStatuses>,
}
impl AccountStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The check availability request body."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckNameAvailabilityRequest {
    #[doc = "The name of the resource for which availability needs to be checked."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl CheckNameAvailabilityRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The check availability result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckNameAvailabilityResponse {
    #[doc = "Indicates if the resource name is available."]
    #[serde(rename = "nameAvailable", default, skip_serializing_if = "Option::is_none")]
    pub name_available: Option<bool>,
    #[doc = "The reason why the given name is not available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<check_name_availability_response::Reason>,
    #[doc = "Detailed reason why the given name is available."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl CheckNameAvailabilityResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod check_name_availability_response {
    use super::*;
    #[doc = "The reason why the given name is not available."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[doc = "CORS details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CorsRule {
    #[doc = "The origin domains that are permitted to make a request against the service via CORS."]
    #[serde(rename = "allowedOrigins")]
    pub allowed_origins: Vec<String>,
    #[doc = "The methods (HTTP request verbs) that the origin domain may use for a CORS request."]
    #[serde(rename = "allowedMethods", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_methods: Vec<String>,
    #[doc = "The request headers that the origin domain may specify on the CORS request."]
    #[serde(rename = "allowedHeaders", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_headers: Vec<String>,
    #[doc = "The response headers to expose to CORS clients."]
    #[serde(rename = "exposedHeaders", default, skip_serializing_if = "Vec::is_empty")]
    pub exposed_headers: Vec<String>,
    #[doc = "The number of seconds that the client/browser should cache a preflight response."]
    #[serde(rename = "maxAgeInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub max_age_in_seconds: Option<i32>,
}
impl CorsRule {
    pub fn new(allowed_origins: Vec<String>) -> Self {
        Self {
            allowed_origins,
            allowed_methods: Vec::new(),
            allowed_headers: Vec::new(),
            exposed_headers: Vec::new(),
            max_age_in_seconds: None,
        }
    }
}
pub type CorsRuleList = Vec<CorsRule>;
#[doc = "Service endpoints authentication details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointAuthentication {
    #[doc = "AAD tenant ID."]
    #[serde(rename = "aadTenantID", default, skip_serializing_if = "Option::is_none")]
    pub aad_tenant_id: Option<String>,
    #[doc = "AAD principal ID."]
    #[serde(rename = "principalID", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "AAD principal type."]
    #[serde(rename = "principalType", default, skip_serializing_if = "Option::is_none")]
    pub principal_type: Option<endpoint_authentication::PrincipalType>,
}
impl EndpointAuthentication {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod endpoint_authentication {
    use super::*;
    #[doc = "AAD principal type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrincipalType {
        Application,
        User,
    }
}
pub type EndpointAuthenticationsList = Vec<EndpointAuthentication>;
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The error detail."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetail {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetail>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "The error detail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetail>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The configuration to raw CDM data to be used as Modeling resource input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelingInputData {
    #[doc = "Connection string to raw input data."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<String>,
}
impl ModelingInputData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Modeling resource patch details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelingPatchResource {
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<Tags>,
    #[doc = "Modeling resource properties to update."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<modeling_patch_resource::Properties>,
}
impl ModelingPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod modeling_patch_resource {
    use super::*;
    #[doc = "Modeling resource properties to update."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "The configuration to raw CDM data to be used as Modeling resource input."]
        #[serde(rename = "inputData", default, skip_serializing_if = "Option::is_none")]
        pub input_data: Option<ModelingInputData>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Modeling resource details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ModelingResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Modeling resource properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<modeling_resource::Properties>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ModelingResource {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
            system_data: None,
        }
    }
}
pub mod modeling_resource {
    use super::*;
    #[doc = "Modeling resource properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "Modeling features controls the set of supported scenarios\\models being computed. This can only be set at Modeling creation."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub features: Option<properties::Features>,
        #[doc = "Modeling frequency controls the modeling compute frequency."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub frequency: Option<properties::Frequency>,
        #[doc = "Modeling size controls the maximum supported input data size."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub size: Option<properties::Size>,
        #[doc = "The configuration to raw CDM data to be used as Modeling resource input."]
        #[serde(rename = "inputData", default, skip_serializing_if = "Option::is_none")]
        pub input_data: Option<ModelingInputData>,
        #[doc = "The resource provisioning state."]
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod properties {
        use super::*;
        #[doc = "Modeling features controls the set of supported scenarios\\models being computed. This can only be set at Modeling creation."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Features {
            Basic,
            Standard,
            Premium,
        }
        #[doc = "Modeling frequency controls the modeling compute frequency."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Frequency {
            Low,
            Medium,
            High,
        }
        #[doc = "Modeling size controls the maximum supported input data size."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum Size {
            Small,
            Medium,
            Large,
        }
    }
}
#[doc = "The list of Modeling resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelingResourceList {
    #[doc = "The link used to get the next page of Modeling resources list."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "The list of Modeling resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ModelingResource>,
}
impl ModelingResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details of a REST API operation, returned from the Resource Provider Operations API"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "The name of the operation, as per Resource-Based Access Control (RBAC). Examples: \"Microsoft.Compute/virtualMachines/write\", \"Microsoft.Compute/virtualMachines/capture/action\""]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Whether the operation applies to data-plane. This is \"true\" for data-plane operations and \"false\" for ARM/control-plane operations."]
    #[serde(rename = "isDataAction", default, skip_serializing_if = "Option::is_none")]
    pub is_data_action: Option<bool>,
    #[doc = "Localized display information for this particular operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[doc = "The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is \"user,system\""]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<operation::Origin>,
    #[doc = "Enum. Indicates the action type. \"Internal\" refers to actions that are for internal only APIs."]
    #[serde(rename = "actionType", default, skip_serializing_if = "Option::is_none")]
    pub action_type: Option<operation::ActionType>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "Localized display information for this particular operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring Insights\" or \"Microsoft Compute\"."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "The localized friendly name of the resource type related to this operation. E.g. \"Virtual Machines\" or \"Job Schedule Collections\"."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create or Update Virtual Machine\", \"Restart Virtual Machine\"."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "The short, localized friendly description of the operation; suitable for tool tips and detailed views."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[doc = "The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is \"user,system\""]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Origin {
        #[serde(rename = "user")]
        User,
        #[serde(rename = "system")]
        System,
        #[serde(rename = "user,system")]
        UserSystem,
    }
    #[doc = "Enum. Indicates the action type. \"Internal\" refers to actions that are for internal only APIs."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActionType {
        Internal,
    }
}
#[doc = "A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of operations supported by the resource provider"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results (if there are any)."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The current status of an async operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationStatusResult {
    #[doc = "Fully qualified ID for the async operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Name of the async operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Operation status."]
    pub status: String,
    #[doc = "Percent of the operation that is complete."]
    #[serde(rename = "percentComplete", default, skip_serializing_if = "Option::is_none")]
    pub percent_complete: Option<f64>,
    #[doc = "The start time of the operation."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time of the operation."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The operations list."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub operations: Vec<OperationStatusResult>,
    #[doc = "The error detail."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetail>,
}
impl OperationStatusResult {
    pub fn new(status: String) -> Self {
        Self {
            id: None,
            name: None,
            status,
            percent_complete: None,
            start_time: None,
            end_time: None,
            operations: Vec::new(),
            error: None,
        }
    }
}
#[doc = "Common fields that are returned in the response for all Azure Resource Manager resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or \"Microsoft.Storage/storageAccounts\""]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Scope statuses."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeStatuses {
    #[doc = "The scope that the statuses refers to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[doc = "Scope stage statuses."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub statuses: Vec<StageStatus>,
}
impl ScopeStatuses {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ServiceEndpoint resource patch details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPatchResource {
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<Tags>,
}
impl ServiceEndpointPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ServiceEndpoint resource details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceEndpointResource {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "ServiceEndpoint resource properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<service_endpoint_resource::Properties>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ServiceEndpointResource {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
            system_data: None,
        }
    }
}
pub mod service_endpoint_resource {
    use super::*;
    #[doc = "ServiceEndpoint resource properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[doc = "ServiceEndpoint pre-allocated capacity controls the maximum requests-per-second allowed for that endpoint. Only applicable when Account configuration is Capacity."]
        #[serde(rename = "preAllocatedCapacity", default, skip_serializing_if = "Option::is_none")]
        pub pre_allocated_capacity: Option<i32>,
        #[doc = "The paired location that will be used by this ServiceEndpoint."]
        #[serde(rename = "pairedLocation", default, skip_serializing_if = "Option::is_none")]
        pub paired_location: Option<String>,
        #[doc = "The URL where the ServiceEndpoint API is accessible at."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub url: Option<String>,
        #[doc = "The resource provisioning state."]
        #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
        pub provisioning_state: Option<String>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "The list of ServiceEndpoint resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointResourceList {
    #[doc = "The link used to get the next page of ServiceEndpoint resources list."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "The list of ServiceEndpoint resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceEndpointResource>,
}
impl ServiceEndpointResourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Stage status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StageStatus {
    #[doc = "The stage name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stage: Option<String>,
    #[doc = "The status of the stage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The time of the status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
}
impl StageStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Resource tags."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Tags {}
impl Tags {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The geo-location where the resource lives"]
    pub location: String,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            tags: None,
            location,
        }
    }
}
#[doc = "Metadata pertaining to creation and last modification of the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[doc = "The identity that created the resource."]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[doc = "The type of identity that created the resource."]
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[doc = "The timestamp of resource creation (UTC)."]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "The identity that last modified the resource."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[doc = "The timestamp of resource last modification (UTC)"]
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[doc = "The type of identity that created the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[doc = "The type of identity that last modified the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
