#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationActionMapping {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub original: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub desired: Option<String>,
}
impl AuthorizationActionMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CanaryTrafficRegionRolloutConfiguration {
    #[serde(rename = "skipRegions", default, skip_serializing_if = "Vec::is_empty")]
    pub skip_regions: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub regions: Vec<String>,
}
impl CanaryTrafficRegionRolloutConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckNameAvailabilitySpecifications {
    #[serde(rename = "enableDefaultValidation", default, skip_serializing_if = "Option::is_none")]
    pub enable_default_validation: Option<bool>,
    #[serde(rename = "resourceTypesWithCustomValidation", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_types_with_custom_validation: Vec<String>,
}
impl CheckNameAvailabilitySpecifications {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckinManifestInfo {
    #[serde(rename = "isCheckedIn")]
    pub is_checked_in: bool,
    #[serde(rename = "statusMessage")]
    pub status_message: String,
    #[serde(rename = "pullRequest", default, skip_serializing_if = "Option::is_none")]
    pub pull_request: Option<String>,
    #[serde(rename = "commitId", default, skip_serializing_if = "Option::is_none")]
    pub commit_id: Option<String>,
}
impl CheckinManifestInfo {
    pub fn new(is_checked_in: bool, status_message: String) -> Self {
        Self {
            is_checked_in,
            status_message,
            pull_request: None,
            commit_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CheckinManifestParams {
    pub environment: String,
    #[serde(rename = "baselineArmManifestLocation")]
    pub baseline_arm_manifest_location: String,
}
impl CheckinManifestParams {
    pub fn new(environment: String, baseline_arm_manifest_location: String) -> Self {
        Self {
            environment,
            baseline_arm_manifest_location,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomRollout {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub properties: serde_json::Value,
}
impl CustomRollout {
    pub fn new(properties: serde_json::Value) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomRolloutArrayResponseWithContinuation {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CustomRollout>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CustomRolloutArrayResponseWithContinuation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomRolloutProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<custom_rollout_properties::ProvisioningState>,
    pub specification: serde_json::Value,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<serde_json::Value>,
}
impl CustomRolloutProperties {
    pub fn new(specification: serde_json::Value) -> Self {
        Self {
            provisioning_state: None,
            specification,
            status: None,
        }
    }
}
pub mod custom_rollout_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        NotSpecified,
        Accepted,
        Running,
        Creating,
        Created,
        Deleting,
        Deleted,
        Canceled,
        Failed,
        Succeeded,
        MovingResources,
        TransientFailure,
        RolloutInProgress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomRolloutSpecification {
    pub canary: serde_json::Value,
    #[serde(rename = "providerRegistration", default, skip_serializing_if = "Option::is_none")]
    pub provider_registration: Option<serde_json::Value>,
    #[serde(rename = "resourceTypeRegistrations", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_type_registrations: Vec<ResourceTypeRegistration>,
}
impl CustomRolloutSpecification {
    pub fn new(canary: serde_json::Value) -> Self {
        Self {
            canary,
            provider_registration: None,
            resource_type_registrations: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomRolloutStatus {
    #[serde(rename = "completedRegions", default, skip_serializing_if = "Vec::is_empty")]
    pub completed_regions: Vec<String>,
    #[serde(rename = "failedOrSkippedRegions", default, skip_serializing_if = "Option::is_none")]
    pub failed_or_skipped_regions: Option<serde_json::Value>,
}
impl CustomRolloutStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultRollout {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl DefaultRollout {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultRolloutArrayResponseWithContinuation {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DefaultRollout>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DefaultRolloutArrayResponseWithContinuation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultRolloutProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<default_rollout_properties::ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub specification: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<serde_json::Value>,
}
impl DefaultRolloutProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod default_rollout_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        NotSpecified,
        Accepted,
        Running,
        Creating,
        Created,
        Deleting,
        Deleted,
        Canceled,
        Failed,
        Succeeded,
        MovingResources,
        TransientFailure,
        RolloutInProgress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultRolloutSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub canary: Option<serde_json::Value>,
    #[serde(rename = "lowTraffic", default, skip_serializing_if = "Option::is_none")]
    pub low_traffic: Option<serde_json::Value>,
    #[serde(rename = "mediumTraffic", default, skip_serializing_if = "Option::is_none")]
    pub medium_traffic: Option<serde_json::Value>,
    #[serde(rename = "highTraffic", default, skip_serializing_if = "Option::is_none")]
    pub high_traffic: Option<serde_json::Value>,
    #[serde(rename = "restOfTheWorldGroupOne", default, skip_serializing_if = "Option::is_none")]
    pub rest_of_the_world_group_one: Option<serde_json::Value>,
    #[serde(rename = "restOfTheWorldGroupTwo", default, skip_serializing_if = "Option::is_none")]
    pub rest_of_the_world_group_two: Option<serde_json::Value>,
    #[serde(rename = "providerRegistration", default, skip_serializing_if = "Option::is_none")]
    pub provider_registration: Option<serde_json::Value>,
    #[serde(rename = "resourceTypeRegistrations", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_type_registrations: Vec<ResourceTypeRegistration>,
}
impl DefaultRolloutSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultRolloutStatus {
    #[serde(flatten)]
    pub rollout_status_base: RolloutStatusBase,
    #[serde(rename = "nextTrafficRegion", default, skip_serializing_if = "Option::is_none")]
    pub next_traffic_region: Option<default_rollout_status::NextTrafficRegion>,
    #[serde(rename = "nextTrafficRegionScheduledTime", default, skip_serializing_if = "Option::is_none")]
    pub next_traffic_region_scheduled_time: Option<String>,
    #[serde(rename = "subscriptionReregistrationResult", default, skip_serializing_if = "Option::is_none")]
    pub subscription_reregistration_result: Option<default_rollout_status::SubscriptionReregistrationResult>,
}
impl DefaultRolloutStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod default_rollout_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextTrafficRegion {
        NotSpecified,
        Canary,
        LowTraffic,
        MediumTraffic,
        HighTraffic,
        None,
        RestOfTheWorldGroupOne,
        RestOfTheWorldGroupTwo,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SubscriptionReregistrationResult {
        NotApplicable,
        ConditionalUpdate,
        ForcedUpdate,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Error {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<Error>,
    #[serde(rename = "innerError", default, skip_serializing_if = "Option::is_none")]
    pub inner_error: Option<serde_json::Value>,
}
impl Error {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedErrorInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ExtendedErrorInfo>,
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<TypedErrorInfo>,
}
impl ExtendedErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedLocationOptions {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "supportedPolicy", default, skip_serializing_if = "Option::is_none")]
    pub supported_policy: Option<String>,
}
impl ExtendedLocationOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtensionOptions {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub request: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub response: Vec<String>,
}
impl ExtensionOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FeaturesRule {
    #[serde(rename = "requiredFeaturesPolicy")]
    pub required_features_policy: features_rule::RequiredFeaturesPolicy,
}
impl FeaturesRule {
    pub fn new(required_features_policy: features_rule::RequiredFeaturesPolicy) -> Self {
        Self { required_features_policy }
    }
}
pub mod features_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RequiredFeaturesPolicy {
        Any,
        All,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityManagement {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity_management::Type>,
}
impl IdentityManagement {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity_management {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        NotSpecified,
        SystemAssigned,
        UserAssigned,
        Actor,
        DelegatedResourceIdentity,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdentityManagementProperties {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<identity_management_properties::Type>,
    #[serde(rename = "applicationId", default, skip_serializing_if = "Option::is_none")]
    pub application_id: Option<String>,
}
impl IdentityManagementProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod identity_management_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        NotSpecified,
        SystemAssigned,
        UserAssigned,
        Actor,
        DelegatedResourceIdentity,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InnerError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(rename = "innerError", default, skip_serializing_if = "Option::is_none")]
    pub inner_error: Option<serde_json::Value>,
}
impl InnerError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LightHouseAuthorization {
    #[serde(rename = "principalId")]
    pub principal_id: String,
    #[serde(rename = "roleDefinitionId")]
    pub role_definition_id: String,
}
impl LightHouseAuthorization {
    pub fn new(principal_id: String, role_definition_id: String) -> Self {
        Self {
            principal_id,
            role_definition_id,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkedAccessCheck {
    #[serde(rename = "actionName", default, skip_serializing_if = "Option::is_none")]
    pub action_name: Option<String>,
    #[serde(rename = "linkedProperty", default, skip_serializing_if = "Option::is_none")]
    pub linked_property: Option<String>,
    #[serde(rename = "linkedAction", default, skip_serializing_if = "Option::is_none")]
    pub linked_action: Option<String>,
    #[serde(rename = "linkedActionVerb", default, skip_serializing_if = "Option::is_none")]
    pub linked_action_verb: Option<String>,
    #[serde(rename = "linkedType", default, skip_serializing_if = "Option::is_none")]
    pub linked_type: Option<String>,
}
impl LinkedAccessCheck {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedOperationRule {
    #[serde(rename = "linkedOperation")]
    pub linked_operation: linked_operation_rule::LinkedOperation,
    #[serde(rename = "linkedAction")]
    pub linked_action: linked_operation_rule::LinkedAction,
}
impl LinkedOperationRule {
    pub fn new(linked_operation: linked_operation_rule::LinkedOperation, linked_action: linked_operation_rule::LinkedAction) -> Self {
        Self {
            linked_operation,
            linked_action,
        }
    }
}
pub mod linked_operation_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LinkedOperation {
        None,
        CrossResourceGroupResourceMove,
        CrossSubscriptionResourceMove,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LinkedAction {
        NotSpecified,
        Blocked,
        Validate,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoggingHiddenPropertyPath {
    #[serde(rename = "hiddenPathsOnRequest", default, skip_serializing_if = "Vec::is_empty")]
    pub hidden_paths_on_request: Vec<String>,
    #[serde(rename = "hiddenPathsOnResponse", default, skip_serializing_if = "Vec::is_empty")]
    pub hidden_paths_on_response: Vec<String>,
}
impl LoggingHiddenPropertyPath {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LoggingRule {
    pub action: String,
    pub direction: logging_rule::Direction,
    #[serde(rename = "detailLevel")]
    pub detail_level: logging_rule::DetailLevel,
    #[serde(rename = "hiddenPropertyPaths", default, skip_serializing_if = "Option::is_none")]
    pub hidden_property_paths: Option<serde_json::Value>,
}
impl LoggingRule {
    pub fn new(action: String, direction: logging_rule::Direction, detail_level: logging_rule::DetailLevel) -> Self {
        Self {
            action,
            direction,
            detail_level,
            hidden_property_paths: None,
        }
    }
}
pub mod logging_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        None,
        Request,
        Response,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DetailLevel {
        None,
        Body,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationEndpoint {
    #[serde(rename = "notificationDestination", default, skip_serializing_if = "Option::is_none")]
    pub notification_destination: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
}
impl NotificationEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationRegistration {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl NotificationRegistration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationRegistrationArrayResponseWithContinuation {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NotificationRegistration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NotificationRegistrationArrayResponseWithContinuation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotificationRegistrationProperties {
    #[serde(rename = "notificationMode", default, skip_serializing_if = "Option::is_none")]
    pub notification_mode: Option<notification_registration_properties::NotificationMode>,
    #[serde(rename = "messageScope", default, skip_serializing_if = "Option::is_none")]
    pub message_scope: Option<notification_registration_properties::MessageScope>,
    #[serde(rename = "includedEvents", default, skip_serializing_if = "Vec::is_empty")]
    pub included_events: Vec<String>,
    #[serde(rename = "notificationEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub notification_endpoints: Vec<NotificationEndpoint>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<notification_registration_properties::ProvisioningState>,
}
impl NotificationRegistrationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod notification_registration_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NotificationMode {
        NotSpecified,
        EventHub,
        WebHook,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MessageScope {
        NotSpecified,
        RegisteredSubscriptions,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        NotSpecified,
        Accepted,
        Running,
        Creating,
        Created,
        Deleting,
        Deleted,
        Canceled,
        Failed,
        Succeeded,
        MovingResources,
        TransientFailure,
        RolloutInProgress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsContent {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationsDefinition>,
}
impl OperationsContent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationsDefinition {
    pub name: String,
    #[serde(rename = "isDataAction", default, skip_serializing_if = "Option::is_none")]
    pub is_data_action: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<operations_definition::Origin>,
    pub display: serde_json::Value,
    #[serde(rename = "actionType", default, skip_serializing_if = "Option::is_none")]
    pub action_type: Option<operations_definition::ActionType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl OperationsDefinition {
    pub fn new(name: String, display: serde_json::Value) -> Self {
        Self {
            name,
            is_data_action: None,
            origin: None,
            display,
            action_type: None,
            properties: None,
        }
    }
}
pub mod operations_definition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Origin {
        NotSpecified,
        User,
        System,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ActionType {
        NotSpecified,
        Internal,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationsDefinitionArrayResponseWithContinuation {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OperationsDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationsDefinitionArrayResponseWithContinuation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationsDisplayDefinition {
    pub provider: String,
    pub resource: String,
    pub operation: String,
    pub description: String,
}
impl OperationsDisplayDefinition {
    pub fn new(provider: String, resource: String, operation: String, description: String) -> Self {
        Self {
            provider,
            resource,
            operation,
            description,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OperationsPutContent {
    pub contents: Vec<OperationsDefinition>,
}
impl OperationsPutContent {
    pub fn new(contents: Vec<OperationsDefinition>) -> Self {
        Self { contents }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderHubMetadata {
    #[serde(rename = "providerAuthorizations", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_authorizations: Vec<ResourceProviderAuthorization>,
    #[serde(rename = "providerAuthentication", default, skip_serializing_if = "Option::is_none")]
    pub provider_authentication: Option<serde_json::Value>,
    #[serde(rename = "thirdPartyProviderAuthorization", default, skip_serializing_if = "Option::is_none")]
    pub third_party_provider_authorization: Option<serde_json::Value>,
}
impl ProviderHubMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderRegistration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl ProviderRegistration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderRegistrationArrayResponseWithContinuation {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProviderRegistration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProviderRegistrationArrayResponseWithContinuation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderRegistrationProperties {
    #[serde(flatten)]
    pub resource_provider_manifest_properties: ResourceProviderManifestProperties,
    #[serde(rename = "providerHubMetadata", default, skip_serializing_if = "Option::is_none")]
    pub provider_hub_metadata: Option<serde_json::Value>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<provider_registration_properties::ProvisioningState>,
    #[serde(
        rename = "subscriptionLifecycleNotificationSpecifications",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub subscription_lifecycle_notification_specifications: Option<serde_json::Value>,
}
impl ProviderRegistrationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod provider_registration_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        NotSpecified,
        Accepted,
        Running,
        Creating,
        Created,
        Deleting,
        Deleted,
        Canceled,
        Failed,
        Succeeded,
        MovingResources,
        TransientFailure,
        RolloutInProgress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReRegisterSubscriptionMetadata {
    pub enabled: bool,
    #[serde(rename = "concurrencyLimit", default, skip_serializing_if = "Option::is_none")]
    pub concurrency_limit: Option<i32>,
}
impl ReRegisterSubscriptionMetadata {
    pub fn new(enabled: bool) -> Self {
        Self {
            enabled,
            concurrency_limit: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RequestHeaderOptions {
    #[serde(rename = "optInHeaders", default, skip_serializing_if = "Option::is_none")]
    pub opt_in_headers: Option<request_header_options::OptInHeaders>,
}
impl RequestHeaderOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod request_header_options {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OptInHeaders {
        NotSpecified,
        SignedUserToken,
        ClientGroupMembership,
        SignedAuxiliaryTokens,
        UnboundedClientGroupMembership,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceMovePolicy {
    #[serde(rename = "validationRequired", default, skip_serializing_if = "Option::is_none")]
    pub validation_required: Option<bool>,
    #[serde(rename = "crossResourceGroupMoveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub cross_resource_group_move_enabled: Option<bool>,
    #[serde(rename = "crossSubscriptionMoveEnabled", default, skip_serializing_if = "Option::is_none")]
    pub cross_subscription_move_enabled: Option<bool>,
}
impl ResourceMovePolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceProviderAuthentication {
    #[serde(rename = "allowedAudiences")]
    pub allowed_audiences: Vec<String>,
}
impl ResourceProviderAuthentication {
    pub fn new(allowed_audiences: Vec<String>) -> Self {
        Self { allowed_audiences }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderAuthorization {
    #[serde(rename = "applicationId", default, skip_serializing_if = "Option::is_none")]
    pub application_id: Option<String>,
    #[serde(rename = "roleDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub role_definition_id: Option<String>,
    #[serde(rename = "managedByRoleDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub managed_by_role_definition_id: Option<String>,
}
impl ResourceProviderAuthorization {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceProviderCapabilities {
    #[serde(rename = "quotaId")]
    pub quota_id: String,
    pub effect: resource_provider_capabilities::Effect,
    #[serde(rename = "requiredFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub required_features: Vec<String>,
}
impl ResourceProviderCapabilities {
    pub fn new(quota_id: String, effect: resource_provider_capabilities::Effect) -> Self {
        Self {
            quota_id,
            effect,
            required_features: Vec::new(),
        }
    }
}
pub mod resource_provider_capabilities {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Effect {
        NotSpecified,
        Allow,
        Disallow,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "apiVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub api_versions: Vec<String>,
    #[serde(rename = "endpointUri", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_uri: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[serde(rename = "requiredFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub required_features: Vec<String>,
    #[serde(rename = "featuresRule", default, skip_serializing_if = "Option::is_none")]
    pub features_rule: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
}
impl ResourceProviderEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderManagement {
    #[serde(rename = "schemaOwners", default, skip_serializing_if = "Vec::is_empty")]
    pub schema_owners: Vec<String>,
    #[serde(rename = "manifestOwners", default, skip_serializing_if = "Vec::is_empty")]
    pub manifest_owners: Vec<String>,
    #[serde(rename = "incidentRoutingService", default, skip_serializing_if = "Option::is_none")]
    pub incident_routing_service: Option<String>,
    #[serde(rename = "incidentRoutingTeam", default, skip_serializing_if = "Option::is_none")]
    pub incident_routing_team: Option<String>,
    #[serde(rename = "incidentContactEmail", default, skip_serializing_if = "Option::is_none")]
    pub incident_contact_email: Option<String>,
    #[serde(rename = "serviceTreeInfos", default, skip_serializing_if = "Vec::is_empty")]
    pub service_tree_infos: Vec<ServiceTreeInfo>,
    #[serde(rename = "resourceAccessPolicy", default, skip_serializing_if = "Option::is_none")]
    pub resource_access_policy: Option<resource_provider_management::ResourceAccessPolicy>,
    #[serde(rename = "resourceAccessRoles", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_access_roles: Vec<serde_json::Value>,
}
impl ResourceProviderManagement {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_provider_management {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceAccessPolicy {
        NotSpecified,
        AcisReadAllowed,
        AcisActionAllowed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderManifest {
    #[serde(rename = "providerAuthentication", default, skip_serializing_if = "Option::is_none")]
    pub provider_authentication: Option<serde_json::Value>,
    #[serde(rename = "providerAuthorizations", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_authorizations: Vec<ResourceProviderAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespace: Option<String>,
    #[serde(rename = "providerVersion", default, skip_serializing_if = "Option::is_none")]
    pub provider_version: Option<String>,
    #[serde(rename = "providerType", default, skip_serializing_if = "Option::is_none")]
    pub provider_type: Option<resource_provider_manifest::ProviderType>,
    #[serde(rename = "requiredFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub required_features: Vec<String>,
    #[serde(rename = "featuresRule", default, skip_serializing_if = "Option::is_none")]
    pub features_rule: Option<serde_json::Value>,
    #[serde(rename = "requestHeaderOptions", default, skip_serializing_if = "Option::is_none")]
    pub request_header_options: Option<serde_json::Value>,
    #[serde(rename = "resourceTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_types: Vec<ResourceType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub management: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<ResourceProviderCapabilities>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(rename = "globalNotificationEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub global_notification_endpoints: Vec<ResourceProviderEndpoint>,
    #[serde(rename = "reRegisterSubscriptionMetadata", default, skip_serializing_if = "Option::is_none")]
    pub re_register_subscription_metadata: Option<serde_json::Value>,
}
impl ResourceProviderManifest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_provider_manifest {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProviderType {
        NotSpecified,
        Internal,
        External,
        Hidden,
        RegistrationFree,
        LegacyRegistrationRequired,
        TenantOnly,
        AuthorizationFree,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceProviderManifestProperties {
    #[serde(rename = "providerAuthentication", default, skip_serializing_if = "Option::is_none")]
    pub provider_authentication: Option<serde_json::Value>,
    #[serde(rename = "providerAuthorizations", default, skip_serializing_if = "Vec::is_empty")]
    pub provider_authorizations: Vec<ResourceProviderAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespace: Option<String>,
    #[serde(rename = "providerVersion", default, skip_serializing_if = "Option::is_none")]
    pub provider_version: Option<String>,
    #[serde(rename = "providerType", default, skip_serializing_if = "Option::is_none")]
    pub provider_type: Option<resource_provider_manifest_properties::ProviderType>,
    #[serde(rename = "requiredFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub required_features: Vec<String>,
    #[serde(rename = "featuresRule", default, skip_serializing_if = "Option::is_none")]
    pub features_rule: Option<serde_json::Value>,
    #[serde(rename = "requestHeaderOptions", default, skip_serializing_if = "Option::is_none")]
    pub request_header_options: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub management: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<ResourceProviderCapabilities>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(rename = "templateDeploymentOptions", default, skip_serializing_if = "Option::is_none")]
    pub template_deployment_options: Option<serde_json::Value>,
}
impl ResourceProviderManifestProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_provider_manifest_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProviderType {
        NotSpecified,
        Internal,
        External,
        Hidden,
        RegistrationFree,
        LegacyRegistrationRequired,
        TenantOnly,
        AuthorizationFree,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceType {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "routingType", default, skip_serializing_if = "Option::is_none")]
    pub routing_type: Option<resource_type::RoutingType>,
    #[serde(rename = "resourceValidation", default, skip_serializing_if = "Option::is_none")]
    pub resource_validation: Option<resource_type::ResourceValidation>,
    #[serde(rename = "allowedUnauthorizedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_unauthorized_actions: Vec<String>,
    #[serde(rename = "authorizationActionMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub authorization_action_mappings: Vec<AuthorizationActionMapping>,
    #[serde(rename = "linkedAccessChecks", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_access_checks: Vec<LinkedAccessCheck>,
    #[serde(rename = "defaultApiVersion", default, skip_serializing_if = "Option::is_none")]
    pub default_api_version: Option<String>,
    #[serde(rename = "loggingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub logging_rules: Vec<LoggingRule>,
    #[serde(rename = "throttlingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub throttling_rules: Vec<ThrottlingRule>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<ResourceProviderEndpoint>,
    #[serde(rename = "marketplaceType", default, skip_serializing_if = "Option::is_none")]
    pub marketplace_type: Option<resource_type::MarketplaceType>,
    #[serde(rename = "identityManagement", default, skip_serializing_if = "Option::is_none")]
    pub identity_management: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(rename = "requiredFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub required_features: Vec<String>,
    #[serde(rename = "featuresRule", default, skip_serializing_if = "Option::is_none")]
    pub features_rule: Option<serde_json::Value>,
    #[serde(rename = "subscriptionStateRules", default, skip_serializing_if = "Vec::is_empty")]
    pub subscription_state_rules: Vec<SubscriptionStateRule>,
    #[serde(rename = "serviceTreeInfos", default, skip_serializing_if = "Vec::is_empty")]
    pub service_tree_infos: Vec<ServiceTreeInfo>,
    #[serde(rename = "requestHeaderOptions", default, skip_serializing_if = "Option::is_none")]
    pub request_header_options: Option<serde_json::Value>,
    #[serde(rename = "skuLink", default, skip_serializing_if = "Option::is_none")]
    pub sku_link: Option<String>,
    #[serde(rename = "disallowedActionVerbs", default, skip_serializing_if = "Vec::is_empty")]
    pub disallowed_action_verbs: Vec<String>,
    #[serde(rename = "templateDeploymentPolicy", default, skip_serializing_if = "Option::is_none")]
    pub template_deployment_policy: Option<serde_json::Value>,
    #[serde(rename = "extendedLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub extended_locations: Vec<ExtendedLocationOptions>,
    #[serde(rename = "linkedOperationRules", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_operation_rules: Vec<LinkedOperationRule>,
    #[serde(rename = "resourceDeletionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub resource_deletion_policy: Option<resource_type::ResourceDeletionPolicy>,
}
impl ResourceType {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_type {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RoutingType {
        Default,
        ProxyOnly,
        HostBased,
        Extension,
        Tenant,
        Fanout,
        LocationBased,
        Failover,
        CascadeExtension,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceValidation {
        NotSpecified,
        ReservedWords,
        ProfaneWords,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MarketplaceType {
        NotSpecified,
        AddOn,
        Bypass,
        Store,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceDeletionPolicy {
        NotSpecified,
        Cascade,
        Force,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceTypeEndpoint {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "apiVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub api_versions: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[serde(rename = "requiredFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub required_features: Vec<String>,
    #[serde(rename = "featuresRule", default, skip_serializing_if = "Option::is_none")]
    pub features_rule: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub extensions: Vec<ResourceTypeExtension>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
}
impl ResourceTypeEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceTypeExtension {
    #[serde(rename = "endpointUri", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_uri: Option<String>,
    #[serde(rename = "extensionCategories", default, skip_serializing_if = "Vec::is_empty")]
    pub extension_categories: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
}
impl ResourceTypeExtension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceTypeExtensionOptions {
    #[serde(rename = "resourceCreationBegin", default, skip_serializing_if = "Option::is_none")]
    pub resource_creation_begin: Option<serde_json::Value>,
}
impl ResourceTypeExtensionOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceTypeRegistration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl ResourceTypeRegistration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceTypeRegistrationArrayResponseWithContinuation {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceTypeRegistration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceTypeRegistrationArrayResponseWithContinuation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceTypeRegistrationProperties {
    #[serde(rename = "routingType", default, skip_serializing_if = "Option::is_none")]
    pub routing_type: Option<resource_type_registration_properties::RoutingType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub regionality: Option<resource_type_registration_properties::Regionality>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<ResourceTypeEndpoint>,
    #[serde(rename = "extensionOptions", default, skip_serializing_if = "Option::is_none")]
    pub extension_options: Option<serde_json::Value>,
    #[serde(rename = "marketplaceType", default, skip_serializing_if = "Option::is_none")]
    pub marketplace_type: Option<resource_type_registration_properties::MarketplaceType>,
    #[serde(rename = "swaggerSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub swagger_specifications: Vec<SwaggerSpecification>,
    #[serde(rename = "allowedUnauthorizedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_unauthorized_actions: Vec<String>,
    #[serde(rename = "authorizationActionMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub authorization_action_mappings: Vec<AuthorizationActionMapping>,
    #[serde(rename = "linkedAccessChecks", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_access_checks: Vec<LinkedAccessCheck>,
    #[serde(rename = "defaultApiVersion", default, skip_serializing_if = "Option::is_none")]
    pub default_api_version: Option<String>,
    #[serde(rename = "loggingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub logging_rules: Vec<LoggingRule>,
    #[serde(rename = "throttlingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub throttling_rules: Vec<ThrottlingRule>,
    #[serde(rename = "requiredFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub required_features: Vec<String>,
    #[serde(rename = "featuresRule", default, skip_serializing_if = "Option::is_none")]
    pub features_rule: Option<serde_json::Value>,
    #[serde(rename = "enableAsyncOperation", default, skip_serializing_if = "Option::is_none")]
    pub enable_async_operation: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<resource_type_registration_properties::ProvisioningState>,
    #[serde(rename = "enableThirdPartyS2S", default, skip_serializing_if = "Option::is_none")]
    pub enable_third_party_s2s: Option<bool>,
    #[serde(
        rename = "subscriptionLifecycleNotificationSpecifications",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub subscription_lifecycle_notification_specifications: Option<serde_json::Value>,
    #[serde(rename = "isPureProxy", default, skip_serializing_if = "Option::is_none")]
    pub is_pure_proxy: Option<bool>,
    #[serde(rename = "identityManagement", default, skip_serializing_if = "Option::is_none")]
    pub identity_management: Option<serde_json::Value>,
    #[serde(rename = "checkNameAvailabilitySpecifications", default, skip_serializing_if = "Option::is_none")]
    pub check_name_availability_specifications: Option<serde_json::Value>,
    #[serde(rename = "disallowedActionVerbs", default, skip_serializing_if = "Vec::is_empty")]
    pub disallowed_action_verbs: Vec<String>,
    #[serde(rename = "serviceTreeInfos", default, skip_serializing_if = "Vec::is_empty")]
    pub service_tree_infos: Vec<ServiceTreeInfo>,
    #[serde(rename = "requestHeaderOptions", default, skip_serializing_if = "Option::is_none")]
    pub request_header_options: Option<serde_json::Value>,
    #[serde(rename = "subscriptionStateRules", default, skip_serializing_if = "Vec::is_empty")]
    pub subscription_state_rules: Vec<SubscriptionStateRule>,
    #[serde(rename = "templateDeploymentOptions", default, skip_serializing_if = "Option::is_none")]
    pub template_deployment_options: Option<serde_json::Value>,
    #[serde(rename = "extendedLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub extended_locations: Vec<ExtendedLocationOptions>,
    #[serde(rename = "resourceMovePolicy", default, skip_serializing_if = "Option::is_none")]
    pub resource_move_policy: Option<serde_json::Value>,
    #[serde(rename = "resourceDeletionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub resource_deletion_policy: Option<resource_type_registration_properties::ResourceDeletionPolicy>,
}
impl ResourceTypeRegistrationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_type_registration_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RoutingType {
        Default,
        ProxyOnly,
        HostBased,
        Extension,
        Tenant,
        Fanout,
        LocationBased,
        Failover,
        CascadeExtension,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Regionality {
        NotSpecified,
        Global,
        Regional,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MarketplaceType {
        NotSpecified,
        AddOn,
        Bypass,
        Store,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        NotSpecified,
        Accepted,
        Running,
        Creating,
        Created,
        Deleting,
        Deleted,
        Canceled,
        Failed,
        Succeeded,
        MovingResources,
        TransientFailure,
        RolloutInProgress,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceDeletionPolicy {
        NotSpecified,
        CascadeDeleteAll,
        CascadeDeleteProxyOnlyChildren,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceTypeSku {
    #[serde(rename = "skuSettings")]
    pub sku_settings: Vec<SkuSetting>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<resource_type_sku::ProvisioningState>,
}
impl ResourceTypeSku {
    pub fn new(sku_settings: Vec<SkuSetting>) -> Self {
        Self {
            sku_settings,
            provisioning_state: None,
        }
    }
}
pub mod resource_type_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        NotSpecified,
        Accepted,
        Running,
        Creating,
        Created,
        Deleting,
        Deleted,
        Canceled,
        Failed,
        Succeeded,
        MovingResources,
        TransientFailure,
        RolloutInProgress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RolloutStatusBase {
    #[serde(rename = "completedRegions", default, skip_serializing_if = "Vec::is_empty")]
    pub completed_regions: Vec<String>,
    #[serde(rename = "failedOrSkippedRegions", default, skip_serializing_if = "Option::is_none")]
    pub failed_or_skipped_regions: Option<serde_json::Value>,
}
impl RolloutStatusBase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTreeInfo {
    #[serde(rename = "serviceId", default, skip_serializing_if = "Option::is_none")]
    pub service_id: Option<String>,
    #[serde(rename = "componentId", default, skip_serializing_if = "Option::is_none")]
    pub component_id: Option<String>,
}
impl ServiceTreeInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SkuCapability {
    pub name: String,
    pub value: String,
}
impl SkuCapability {
    pub fn new(name: String, value: String) -> Self {
        Self { name, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SkuCapacity {
    pub minimum: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub maximum: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<i32>,
    #[serde(rename = "scaleType", default, skip_serializing_if = "Option::is_none")]
    pub scale_type: Option<sku_capacity::ScaleType>,
}
impl SkuCapacity {
    pub fn new(minimum: i32) -> Self {
        Self {
            minimum,
            maximum: None,
            default: None,
            scale_type: None,
        }
    }
}
pub mod sku_capacity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScaleType {
        None,
        Manual,
        Automatic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SkuCost {
    #[serde(rename = "meterId")]
    pub meter_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub quantity: Option<i32>,
    #[serde(rename = "extendedUnit", default, skip_serializing_if = "Option::is_none")]
    pub extended_unit: Option<String>,
}
impl SkuCost {
    pub fn new(meter_id: String) -> Self {
        Self {
            meter_id,
            quantity: None,
            extended_unit: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SkuLocationInfo {
    pub location: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[serde(rename = "zoneDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub zone_details: Vec<SkuZoneDetail>,
    #[serde(rename = "extendedLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub extended_locations: Vec<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<sku_location_info::Type>,
}
impl SkuLocationInfo {
    pub fn new(location: String) -> Self {
        Self {
            location,
            zones: Vec::new(),
            zone_details: Vec::new(),
            extended_locations: Vec::new(),
            type_: None,
        }
    }
}
pub mod sku_location_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        NotSpecified,
        EdgeZone,
        ArcZone,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuResource {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SkuResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuResourceArrayResponseWithContinuation {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SkuResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SkuResourceArrayResponseWithContinuation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SkuSetting {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[serde(rename = "locationInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub location_info: Vec<SkuLocationInfo>,
    #[serde(rename = "requiredQuotaIds", default, skip_serializing_if = "Vec::is_empty")]
    pub required_quota_ids: Vec<String>,
    #[serde(rename = "requiredFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub required_features: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub costs: Vec<SkuCost>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<SkuCapability>,
}
impl SkuSetting {
    pub fn new(name: String) -> Self {
        Self {
            name,
            tier: None,
            size: None,
            family: None,
            kind: None,
            locations: Vec::new(),
            location_info: Vec::new(),
            required_quota_ids: Vec::new(),
            required_features: Vec::new(),
            capacity: None,
            costs: Vec::new(),
            capabilities: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkuZoneDetail {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub name: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub capabilities: Vec<SkuCapability>,
}
impl SkuZoneDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionLifecycleNotificationSpecifications {
    #[serde(rename = "subscriptionStateOverrideActions", default, skip_serializing_if = "Vec::is_empty")]
    pub subscription_state_override_actions: Vec<SubscriptionStateOverrideAction>,
    #[serde(rename = "softDeleteTTL", default, skip_serializing_if = "Option::is_none")]
    pub soft_delete_ttl: Option<String>,
}
impl SubscriptionLifecycleNotificationSpecifications {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SubscriptionStateOverrideAction {
    pub state: subscription_state_override_action::State,
    pub action: subscription_state_override_action::Action,
}
impl SubscriptionStateOverrideAction {
    pub fn new(state: subscription_state_override_action::State, action: subscription_state_override_action::Action) -> Self {
        Self { state, action }
    }
}
pub mod subscription_state_override_action {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Registered,
        Unregistered,
        Warned,
        Suspended,
        Deleted,
        WarnedToRegistered,
        WarnedToSuspended,
        WarnedToDeleted,
        WarnedToUnregistered,
        SuspendedToRegistered,
        SuspendedToWarned,
        SuspendedToDeleted,
        SuspendedToUnregistered,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        NotDefined,
        DeleteAllResources,
        SoftDeleteAllResources,
        NoOp,
        BillingCancellation,
        UndoSoftDelete,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionStateRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<subscription_state_rule::State>,
    #[serde(rename = "allowedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_actions: Vec<String>,
}
impl SubscriptionStateRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod subscription_state_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        NotDefined,
        Enabled,
        Warned,
        PastDue,
        Disabled,
        Deleted,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwaggerSpecification {
    #[serde(rename = "apiVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub api_versions: Vec<String>,
    #[serde(rename = "swaggerSpecFolderUri", default, skip_serializing_if = "Option::is_none")]
    pub swagger_spec_folder_uri: Option<String>,
}
impl SwaggerSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TemplateDeploymentOptions {
    #[serde(rename = "preflightSupported", default, skip_serializing_if = "Option::is_none")]
    pub preflight_supported: Option<bool>,
    #[serde(rename = "preflightOptions", default, skip_serializing_if = "Vec::is_empty")]
    pub preflight_options: Vec<String>,
}
impl TemplateDeploymentOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TemplateDeploymentPolicy {
    pub capabilities: template_deployment_policy::Capabilities,
    #[serde(rename = "preflightOptions")]
    pub preflight_options: template_deployment_policy::PreflightOptions,
}
impl TemplateDeploymentPolicy {
    pub fn new(
        capabilities: template_deployment_policy::Capabilities,
        preflight_options: template_deployment_policy::PreflightOptions,
    ) -> Self {
        Self {
            capabilities,
            preflight_options,
        }
    }
}
pub mod template_deployment_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Capabilities {
        Default,
        Preflight,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreflightOptions {
        None,
        ValidationRequests,
        DeploymentRequests,
        TestOnly,
        RegisteredOnly,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ThirdPartyProviderAuthorization {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub authorizations: Vec<LightHouseAuthorization>,
    #[serde(rename = "managedByTenantId", default, skip_serializing_if = "Option::is_none")]
    pub managed_by_tenant_id: Option<String>,
}
impl ThirdPartyProviderAuthorization {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThrottlingMetric {
    #[serde(rename = "type")]
    pub type_: throttling_metric::Type,
    pub limit: i64,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<String>,
}
impl ThrottlingMetric {
    pub fn new(type_: throttling_metric::Type, limit: i64) -> Self {
        Self {
            type_,
            limit,
            interval: None,
        }
    }
}
pub mod throttling_metric {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        NotSpecified,
        NumberOfRequests,
        NumberOfResources,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThrottlingRule {
    pub action: String,
    pub metrics: Vec<ThrottlingMetric>,
    #[serde(rename = "requiredFeatures", default, skip_serializing_if = "Vec::is_empty")]
    pub required_features: Vec<String>,
}
impl ThrottlingRule {
    pub fn new(action: String, metrics: Vec<ThrottlingMetric>) -> Self {
        Self {
            action,
            metrics,
            required_features: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrafficRegionRolloutConfiguration {
    #[serde(flatten)]
    pub traffic_regions: TrafficRegions,
    #[serde(rename = "waitDuration", default, skip_serializing_if = "Option::is_none")]
    pub wait_duration: Option<String>,
}
impl TrafficRegionRolloutConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrafficRegions {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub regions: Vec<String>,
}
impl TrafficRegions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TypedErrorInfo {
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl TypedErrorInfo {
    pub fn new(type_: String) -> Self {
        Self { type_, info: None }
    }
}
