#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "An Azure resource QueryPack-Query object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResourceProperties {
    #[doc = "Azure resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Azure resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Azure resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Read only system data"]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl AzureResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorDetail {
    #[doc = "The error's code."]
    pub code: String,
    #[doc = "A human readable error message."]
    pub message: String,
    #[doc = "Indicates which property in the request is responsible for the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "Indicates which value in 'target' is responsible for the error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "Indicates resources which were responsible for the error."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<String>,
    #[doc = "Additional properties that can be provided on the error details object"]
    #[serde(rename = "additionalProperties", default, skip_serializing_if = "Option::is_none")]
    pub additional_properties: Option<serde_json::Value>,
}
impl ErrorDetail {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
            value: None,
            resources: Vec::new(),
            additional_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorInfo {
    #[doc = "A machine readable error code."]
    pub code: String,
    #[doc = "A human readable error message."]
    pub message: String,
    #[doc = "error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub innererror: Box<Option<ErrorInfo>>,
    #[doc = "Additional properties that can be provided on the error info object"]
    #[serde(rename = "additionalProperties", default, skip_serializing_if = "Option::is_none")]
    pub additional_properties: Option<serde_json::Value>,
}
impl ErrorInfo {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            details: Vec::new(),
            innererror: Box::new(None),
            additional_properties: None,
        }
    }
}
#[doc = "Describe the format of an Error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorInfo>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The type of identity that creates/modifies resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IdentityType {
    #[serde(rename = "user")]
    User,
    #[serde(rename = "application")]
    Application,
    #[serde(rename = "managedIdentity")]
    ManagedIdentity,
    #[serde(rename = "key")]
    Key,
}
#[doc = "An Log Analytics QueryPack definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogAnalyticsQueryPack {
    #[serde(flatten)]
    pub query_packs_resource: QueryPacksResource,
    #[doc = "Properties that define a Log Analytics QueryPack resource."]
    pub properties: LogAnalyticsQueryPackProperties,
}
impl LogAnalyticsQueryPack {
    pub fn new(query_packs_resource: QueryPacksResource, properties: LogAnalyticsQueryPackProperties) -> Self {
        Self {
            query_packs_resource,
            properties,
        }
    }
}
#[doc = "Describes the list of Log Analytics QueryPack resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogAnalyticsQueryPackListResult {
    #[doc = "List of Log Analytics QueryPack definitions."]
    pub value: Vec<LogAnalyticsQueryPack>,
    #[doc = "The URI to get the next set of Log Analytics QueryPack definitions if too many QueryPacks where returned in the result set."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LogAnalyticsQueryPackListResult {
    pub fn new(value: Vec<LogAnalyticsQueryPack>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Properties that define a Log Analytics QueryPack resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogAnalyticsQueryPackProperties {
    #[doc = "The unique ID of your application. This field cannot be changed."]
    #[serde(rename = "queryPackId", default, skip_serializing_if = "Option::is_none")]
    pub query_pack_id: Option<String>,
    #[doc = "Creation Date for the Log Analytics QueryPack, in ISO 8601 format."]
    #[serde(rename = "timeCreated", default, skip_serializing_if = "Option::is_none")]
    pub time_created: Option<String>,
    #[doc = "Last modified date of the Log Analytics QueryPack, in ISO 8601 format."]
    #[serde(rename = "timeModified", default, skip_serializing_if = "Option::is_none")]
    pub time_modified: Option<String>,
    #[doc = "Current state of this QueryPack: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LogAnalyticsQueryPackProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Log Analytics QueryPack-Query definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogAnalyticsQueryPackQuery {
    #[serde(flatten)]
    pub azure_resource_properties: AzureResourceProperties,
    #[doc = "Properties that define an Log Analytics QueryPack-Query resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LogAnalyticsQueryPackQueryProperties>,
}
impl LogAnalyticsQueryPackQuery {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the list of Log Analytics QueryPack-Query resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogAnalyticsQueryPackQueryListResult {
    #[doc = "List of Log Analytics QueryPack Query definitions."]
    pub value: Vec<LogAnalyticsQueryPackQuery>,
    #[doc = "The URI to get the next set of Log Analytics QueryPack definitions if too many QueryPack-Queries where returned in the result set."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LogAnalyticsQueryPackQueryListResult {
    pub fn new(value: Vec<LogAnalyticsQueryPackQuery>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Properties that define an Log Analytics QueryPack-Query resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogAnalyticsQueryPackQueryProperties {
    #[doc = "The unique ID of your application. This field cannot be changed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Unique display name for your query within the Query Pack."]
    #[serde(rename = "displayName")]
    pub display_name: String,
    #[doc = "Creation Date for the Log Analytics Query, in ISO 8601 format."]
    #[serde(rename = "timeCreated", default, skip_serializing_if = "Option::is_none")]
    pub time_created: Option<String>,
    #[doc = "Last modified date of the Log Analytics Query, in ISO 8601 format."]
    #[serde(rename = "timeModified", default, skip_serializing_if = "Option::is_none")]
    pub time_modified: Option<String>,
    #[doc = "Object Id of user creating the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub author: Option<String>,
    #[doc = "Description of the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Body of the query."]
    pub body: String,
    #[doc = "The related metadata items for the function."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub related: Option<log_analytics_query_pack_query_properties::Related>,
    #[doc = "Tags associated with the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Additional properties that can be set for the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl LogAnalyticsQueryPackQueryProperties {
    pub fn new(display_name: String, body: String) -> Self {
        Self {
            id: None,
            display_name,
            time_created: None,
            time_modified: None,
            author: None,
            description: None,
            body,
            related: None,
            tags: None,
            properties: None,
        }
    }
}
pub mod log_analytics_query_pack_query_properties {
    use super::*;
    #[doc = "The related metadata items for the function."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Related {
        #[doc = "The related categories for the function."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub categories: Vec<String>,
        #[doc = "The related resource types for the function."]
        #[serde(rename = "resourceTypes", default, skip_serializing_if = "Vec::is_empty")]
        pub resource_types: Vec<String>,
        #[doc = "The related Log Analytics solutions for the function."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub solutions: Vec<String>,
    }
    impl Related {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Properties that define an Log Analytics QueryPack-Query search properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogAnalyticsQueryPackQuerySearchProperties {
    #[doc = "The related metadata items for the function."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub related: Option<log_analytics_query_pack_query_search_properties::Related>,
    #[doc = "Tags associated with the query."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl LogAnalyticsQueryPackQuerySearchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod log_analytics_query_pack_query_search_properties {
    use super::*;
    #[doc = "The related metadata items for the function."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Related {
        #[doc = "The related categories for the function."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub categories: Vec<String>,
        #[doc = "The related resource types for the function."]
        #[serde(rename = "resourceTypes", default, skip_serializing_if = "Vec::is_empty")]
        pub resource_types: Vec<String>,
        #[doc = "The related Log Analytics solutions for the function."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub solutions: Vec<String>,
    }
    impl Related {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "CDN REST API operation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Indicates whether the operation is a data action"]
    #[serde(rename = "isDataAction", default, skip_serializing_if = "Option::is_none")]
    pub is_data_action: Option<bool>,
    #[doc = "Operation display payload"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<OperationDisplay>,
    #[doc = "Origin of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Operation display payload"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationDisplay {
    #[doc = "Resource provider of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "Resource of the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
    #[doc = "Localized friendly name for the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub operation: Option<String>,
    #[doc = "Localized friendly description for the operation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl OperationDisplay {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list CDN operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of CDN operations supported by the CDN resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An azure resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryPacksResource {
    #[doc = "Azure resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Azure resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Azure resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl QueryPacksResource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[doc = "Read only system data"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[doc = "An identifier for the identity that created the resource"]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[doc = "The type of identity that creates/modifies resources"]
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<IdentityType>,
    #[doc = "The timestamp of resource creation (UTC)"]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "An identifier for the identity that last modified the resource"]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "The type of identity that creates/modifies resources"]
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<IdentityType>,
    #[doc = "The timestamp of resource last modification (UTC)"]
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A container holding only the Tags for a resource, allowing the user to update the tags on a QueryPack instance."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsResource {
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TagsResource {
    pub fn new() -> Self {
        Self::default()
    }
}
