#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "AAD Vpn authentication type related parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadAuthenticationParameters {
    #[doc = "AAD Vpn authentication parameter AAD tenant."]
    #[serde(rename = "aadTenant", default, skip_serializing_if = "Option::is_none")]
    pub aad_tenant: Option<String>,
    #[doc = "AAD Vpn authentication parameter AAD audience."]
    #[serde(rename = "aadAudience", default, skip_serializing_if = "Option::is_none")]
    pub aad_audience: Option<String>,
    #[doc = "AAD Vpn authentication parameter AAD issuer."]
    #[serde(rename = "aadIssuer", default, skip_serializing_if = "Option::is_none")]
    pub aad_issuer: Option<String>,
}
impl AadAuthenticationParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Access to be allowed or denied."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Access {
    Allow,
    Deny,
}
#[doc = "Network base admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveBaseSecurityAdminRule {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Deployment time string."]
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[doc = "Deployment region."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "A display name of the security admin configuration."]
    #[serde(rename = "configurationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub configuration_display_name: Option<String>,
    #[doc = "A description of the security admin configuration."]
    #[serde(rename = "configurationDescription", default, skip_serializing_if = "Option::is_none")]
    pub configuration_description: Option<String>,
    #[doc = "A display name of the rule collection."]
    #[serde(rename = "ruleCollectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_display_name: Option<String>,
    #[doc = "A description of the rule collection."]
    #[serde(rename = "ruleCollectionDescription", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_description: Option<String>,
    #[doc = "Groups for rule collection"]
    #[serde(rename = "ruleCollectionAppliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[doc = "Effective configuration groups."]
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ConfigurationGroup>,
    #[doc = "Whether the rule is custom or default."]
    pub kind: active_base_security_admin_rule::Kind,
}
impl ActiveBaseSecurityAdminRule {
    pub fn new(kind: active_base_security_admin_rule::Kind) -> Self {
        Self {
            id: None,
            commit_time: None,
            region: None,
            configuration_display_name: None,
            configuration_description: None,
            rule_collection_display_name: None,
            rule_collection_description: None,
            rule_collection_applies_to_groups: Vec::new(),
            rule_groups: Vec::new(),
            kind,
        }
    }
}
pub mod active_base_security_admin_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "Network base rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveBaseSecurityUserRule {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Deployment time string."]
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[doc = "Deployment region."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "A display name of the security user configuration."]
    #[serde(rename = "configurationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub configuration_display_name: Option<String>,
    #[doc = "A description of the security user configuration."]
    #[serde(rename = "configurationDescription", default, skip_serializing_if = "Option::is_none")]
    pub configuration_description: Option<String>,
    #[doc = "A display name of the rule collection."]
    #[serde(rename = "ruleCollectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_display_name: Option<String>,
    #[doc = "A description of the rule collection."]
    #[serde(rename = "ruleCollectionDescription", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_description: Option<String>,
    #[doc = "Groups for rule collection"]
    #[serde(rename = "ruleCollectionAppliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[doc = "Effective configuration groups."]
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ConfigurationGroup>,
    #[doc = "Whether the rule is custom or default."]
    pub kind: active_base_security_user_rule::Kind,
}
impl ActiveBaseSecurityUserRule {
    pub fn new(kind: active_base_security_user_rule::Kind) -> Self {
        Self {
            id: None,
            commit_time: None,
            region: None,
            configuration_display_name: None,
            configuration_description: None,
            rule_collection_display_name: None,
            rule_collection_description: None,
            rule_collection_applies_to_groups: Vec::new(),
            rule_groups: Vec::new(),
            kind,
        }
    }
}
pub mod active_base_security_user_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "Effective Virtual Networks Parameter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveConfigurationParameter {
    #[doc = "List of regions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub regions: Vec<String>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveConfigurationParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Active connectivity configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveConnectivityConfiguration {
    #[serde(flatten)]
    pub effective_connectivity_configuration: EffectiveConnectivityConfiguration,
    #[doc = "Deployment time string."]
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[doc = "Deployment region."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
}
impl ActiveConnectivityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list active connectivity configurations. It contains a list of active connectivity configurations and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveConnectivityConfigurationsListResult {
    #[doc = "Gets a page of active connectivity configurations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ActiveConnectivityConfiguration>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveConnectivityConfigurationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network default admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveDefaultSecurityAdminRule {
    #[serde(flatten)]
    pub active_base_security_admin_rule: ActiveBaseSecurityAdminRule,
    #[doc = "Security default admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultAdminPropertiesFormat>,
}
impl ActiveDefaultSecurityAdminRule {
    pub fn new(active_base_security_admin_rule: ActiveBaseSecurityAdminRule) -> Self {
        Self {
            active_base_security_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Network security default user rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveDefaultSecurityUserRule {
    #[serde(flatten)]
    pub active_base_security_user_rule: ActiveBaseSecurityUserRule,
    #[doc = "Security default user rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultUserRulePropertiesFormat>,
}
impl ActiveDefaultSecurityUserRule {
    pub fn new(active_base_security_user_rule: ActiveBaseSecurityUserRule) -> Self {
        Self {
            active_base_security_user_rule,
            properties: None,
        }
    }
}
#[doc = "Network admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveSecurityAdminRule {
    #[serde(flatten)]
    pub active_base_security_admin_rule: ActiveBaseSecurityAdminRule,
    #[doc = "Security admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdminPropertiesFormat>,
}
impl ActiveSecurityAdminRule {
    pub fn new(active_base_security_admin_rule: ActiveBaseSecurityAdminRule) -> Self {
        Self {
            active_base_security_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Result of the request to list active security admin rules. It contains a list of active security admin rules and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveSecurityAdminRulesListResult {
    #[doc = "Gets a page of active security admin rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ActiveBaseSecurityAdminRule>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveSecurityAdminRulesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network security user rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveSecurityUserRule {
    #[serde(flatten)]
    pub active_base_security_user_rule: ActiveBaseSecurityUserRule,
    #[doc = "Security rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserRulePropertiesFormat>,
}
impl ActiveSecurityUserRule {
    pub fn new(active_base_security_user_rule: ActiveBaseSecurityUserRule) -> Self {
        Self {
            active_base_security_user_rule,
            properties: None,
        }
    }
}
#[doc = "Result of the request to list active security user rules. It contains a list of active security user rules and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveSecurityUserRulesListResult {
    #[doc = "Gets a page of active security user rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ActiveBaseSecurityUserRule>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveSecurityUserRulesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Address prefix item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressPrefixItem {
    #[doc = "Address prefix."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "Address prefix type."]
    #[serde(rename = "addressPrefixType", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix_type: Option<address_prefix_item::AddressPrefixType>,
}
impl AddressPrefixItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod address_prefix_item {
    use super::*;
    #[doc = "Address prefix type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AddressPrefixType {
        #[serde(rename = "IPPrefix")]
        IpPrefix,
        ServiceTag,
    }
}
#[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressSpace {
    #[doc = "A list of address blocks reserved for this virtual network in CIDR notation."]
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
}
impl AddressSpace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security admin rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdminPropertiesFormat {
    #[doc = "A friendly name for the rule."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Network protocol this rule applies to."]
    pub protocol: RuleProtocol,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "Whether network traffic is allowed or denied."]
    pub access: SecurityConfigurationRuleAccess,
    #[doc = "The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule."]
    pub priority: i32,
    #[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
    pub direction: SecurityConfigurationRuleDirection,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AdminPropertiesFormat {
    pub fn new(
        protocol: RuleProtocol,
        access: SecurityConfigurationRuleAccess,
        priority: i32,
        direction: SecurityConfigurationRuleDirection,
    ) -> Self {
        Self {
            display_name: None,
            description: None,
            protocol,
            sources: Vec::new(),
            destinations: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            access,
            priority,
            direction,
            provisioning_state: None,
        }
    }
}
#[doc = "Network admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdminRule {
    #[serde(flatten)]
    pub base_admin_rule: BaseAdminRule,
    #[doc = "Security admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdminPropertiesFormat>,
}
impl AdminRule {
    pub fn new(base_admin_rule: BaseAdminRule) -> Self {
        Self {
            base_admin_rule,
            properties: None,
        }
    }
}
#[doc = "security configuration admin rule list result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdminRuleListResult {
    #[doc = "A list of admin rules"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BaseAdminRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AdminRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "A list of availability zones denoting where the resource needs to come from."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
}
impl ApplicationGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Authentication certificates of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAuthenticationCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Authentication certificates properties of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayAuthenticationCertificatePropertiesFormat>,
    #[doc = "Name of the authentication certificate that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayAuthenticationCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Authentication certificates properties of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAuthenticationCertificatePropertiesFormat {
    #[doc = "Certificate public data."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayAuthenticationCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application Gateway autoscale configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayAutoscaleConfiguration {
    #[doc = "Lower bound on number of Application Gateway capacity."]
    #[serde(rename = "minCapacity")]
    pub min_capacity: i32,
    #[doc = "Upper bound on number of Application Gateway capacity."]
    #[serde(rename = "maxCapacity", default, skip_serializing_if = "Option::is_none")]
    pub max_capacity: Option<i32>,
}
impl ApplicationGatewayAutoscaleConfiguration {
    pub fn new(min_capacity: i32) -> Self {
        Self {
            min_capacity,
            max_capacity: None,
        }
    }
}
pub type ApplicationGatewayAvailableRequestHeadersResult = Vec<String>;
pub type ApplicationGatewayAvailableResponseHeadersResult = Vec<String>;
pub type ApplicationGatewayAvailableServerVariablesResult = Vec<String>;
#[doc = "Response for ApplicationGatewayAvailableSslOptions API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableSslOptions {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of ApplicationGatewayAvailableSslOptions."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayAvailableSslOptionsPropertiesFormat>,
}
impl ApplicationGatewayAvailableSslOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ApplicationGatewayAvailableSslOptions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableSslOptionsPropertiesFormat {
    #[doc = "List of available Ssl predefined policy."]
    #[serde(rename = "predefinedPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub predefined_policies: Vec<SubResource>,
    #[doc = "Ssl predefined policy name enums."]
    #[serde(rename = "defaultPolicy", default, skip_serializing_if = "Option::is_none")]
    pub default_policy: Option<PolicyNameEnum>,
    #[doc = "List of available Ssl cipher suites."]
    #[serde(rename = "availableCipherSuites", default, skip_serializing_if = "Vec::is_empty")]
    pub available_cipher_suites: Vec<CipherSuitesEnum>,
    #[doc = "List of available Ssl protocols."]
    #[serde(rename = "availableProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub available_protocols: Vec<ProtocolsEnum>,
}
impl ApplicationGatewayAvailableSslOptionsPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ApplicationGatewayAvailableSslOptions API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableSslPredefinedPolicies {
    #[doc = "List of available Ssl predefined policy."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewaySslPredefinedPolicy>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayAvailableSslPredefinedPolicies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ApplicationGatewayAvailableWafRuleSets API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableWafRuleSetsResult {
    #[doc = "The list of application gateway rule sets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewayFirewallRuleSet>,
}
impl ApplicationGatewayAvailableWafRuleSetsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Backend address of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddress {
    #[doc = "Fully qualified domain name (FQDN)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "IP address."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
}
impl ApplicationGatewayBackendAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Backend Address Pool of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Backend Address Pool of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayBackendAddressPoolPropertiesFormat>,
    #[doc = "Name of the backend address pool that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayBackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Backend Address Pool of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPoolPropertiesFormat {
    #[doc = "Collection of references to IPs defined in network interfaces."]
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "Backend addresses."]
    #[serde(rename = "backendAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_addresses: Vec<ApplicationGatewayBackendAddress>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayBackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ApplicationGatewayBackendHealth API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealth {
    #[doc = "A list of ApplicationGatewayBackendHealthPool resources."]
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<ApplicationGatewayBackendHealthPool>,
}
impl ApplicationGatewayBackendHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway BackendHealthHttp settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthHttpSettings {
    #[doc = "Backend address pool settings of an application gateway."]
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<ApplicationGatewayBackendHttpSettings>,
    #[doc = "List of ApplicationGatewayBackendHealthServer resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub servers: Vec<ApplicationGatewayBackendHealthServer>,
}
impl ApplicationGatewayBackendHealthHttpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of on demand test probe."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthOnDemand {
    #[doc = "Backend Address Pool of an application gateway."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<ApplicationGatewayBackendAddressPool>,
    #[doc = "Application gateway BackendHealthHttp settings."]
    #[serde(rename = "backendHealthHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_health_http_settings: Option<ApplicationGatewayBackendHealthHttpSettings>,
}
impl ApplicationGatewayBackendHealthOnDemand {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway BackendHealth pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthPool {
    #[doc = "Backend Address Pool of an application gateway."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<ApplicationGatewayBackendAddressPool>,
    #[doc = "List of ApplicationGatewayBackendHealthHttpSettings resources."]
    #[serde(rename = "backendHttpSettingsCollection", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_http_settings_collection: Vec<ApplicationGatewayBackendHealthHttpSettings>,
}
impl ApplicationGatewayBackendHealthPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway backendhealth http settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthServer {
    #[doc = "IP address or FQDN of backend server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "IPConfiguration in a network interface."]
    #[serde(rename = "ipConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[doc = "Health of backend server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<application_gateway_backend_health_server::Health>,
    #[doc = "Health Probe Log."]
    #[serde(rename = "healthProbeLog", default, skip_serializing_if = "Option::is_none")]
    pub health_probe_log: Option<String>,
}
impl ApplicationGatewayBackendHealthServer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_backend_health_server {
    use super::*;
    #[doc = "Health of backend server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        Unknown,
        Up,
        Down,
        Partial,
        Draining,
    }
}
#[doc = "Backend address pool settings of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHttpSettings {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Backend address pool settings of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayBackendHttpSettingsPropertiesFormat>,
    #[doc = "Name of the backend http settings that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayBackendHttpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Backend address pool settings of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHttpSettingsPropertiesFormat {
    #[doc = "The destination port on the backend."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "Application Gateway protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<ApplicationGatewayProtocol>,
    #[doc = "Cookie based affinity."]
    #[serde(rename = "cookieBasedAffinity", default, skip_serializing_if = "Option::is_none")]
    pub cookie_based_affinity: Option<application_gateway_backend_http_settings_properties_format::CookieBasedAffinity>,
    #[doc = "Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds."]
    #[serde(rename = "requestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub request_timeout: Option<i32>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub probe: Option<SubResource>,
    #[doc = "Array of references to application gateway authentication certificates."]
    #[serde(rename = "authenticationCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub authentication_certificates: Vec<SubResource>,
    #[doc = "Array of references to application gateway trusted root certificates."]
    #[serde(rename = "trustedRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_root_certificates: Vec<SubResource>,
    #[doc = "Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration."]
    #[serde(rename = "connectionDraining", default, skip_serializing_if = "Option::is_none")]
    pub connection_draining: Option<ApplicationGatewayConnectionDraining>,
    #[doc = "Host header to be sent to the backend servers."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[doc = "Whether to pick host header should be picked from the host name of the backend server. Default value is false."]
    #[serde(rename = "pickHostNameFromBackendAddress", default, skip_serializing_if = "Option::is_none")]
    pub pick_host_name_from_backend_address: Option<bool>,
    #[doc = "Cookie name to use for the affinity cookie."]
    #[serde(rename = "affinityCookieName", default, skip_serializing_if = "Option::is_none")]
    pub affinity_cookie_name: Option<String>,
    #[doc = "Whether the probe is enabled. Default value is false."]
    #[serde(rename = "probeEnabled", default, skip_serializing_if = "Option::is_none")]
    pub probe_enabled: Option<bool>,
    #[doc = "Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayBackendHttpSettingsPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_backend_http_settings_properties_format {
    use super::*;
    #[doc = "Cookie based affinity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CookieBasedAffinity {
        Enabled,
        Disabled,
    }
}
#[doc = "Application gateway client authentication configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayClientAuthConfiguration {
    #[doc = "Verify client certificate issuer name on the application gateway."]
    #[serde(rename = "verifyClientCertIssuerDN", default, skip_serializing_if = "Option::is_none")]
    pub verify_client_cert_issuer_dn: Option<bool>,
}
impl ApplicationGatewayClientAuthConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayConnectionDraining {
    #[doc = "Whether connection draining is enabled or not."]
    pub enabled: bool,
    #[doc = "The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds."]
    #[serde(rename = "drainTimeoutInSec")]
    pub drain_timeout_in_sec: i32,
}
impl ApplicationGatewayConnectionDraining {
    pub fn new(enabled: bool, drain_timeout_in_sec: i32) -> Self {
        Self {
            enabled,
            drain_timeout_in_sec,
        }
    }
}
#[doc = "Customer error of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayCustomError {
    #[doc = "Status code of the application gateway customer error."]
    #[serde(rename = "statusCode", default, skip_serializing_if = "Option::is_none")]
    pub status_code: Option<application_gateway_custom_error::StatusCode>,
    #[doc = "Error page URL of the application gateway customer error."]
    #[serde(rename = "customErrorPageUrl", default, skip_serializing_if = "Option::is_none")]
    pub custom_error_page_url: Option<String>,
}
impl ApplicationGatewayCustomError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_custom_error {
    use super::*;
    #[doc = "Status code of the application gateway customer error."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StatusCode {
        HttpStatus403,
        HttpStatus502,
    }
}
#[doc = "Allows to disable rules within a rule group or an entire rule group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallDisabledRuleGroup {
    #[doc = "The name of the rule group that will be disabled."]
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[doc = "The list of rules that will be disabled. If null, all rules of the rule group will be disabled."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<i32>,
}
impl ApplicationGatewayFirewallDisabledRuleGroup {
    pub fn new(rule_group_name: String) -> Self {
        Self {
            rule_group_name,
            rules: Vec::new(),
        }
    }
}
#[doc = "Allow to exclude some variable satisfy the condition for the WAF check."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallExclusion {
    #[doc = "The variable to be excluded."]
    #[serde(rename = "matchVariable")]
    pub match_variable: String,
    #[doc = "When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to."]
    #[serde(rename = "selectorMatchOperator")]
    pub selector_match_operator: String,
    #[doc = "When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to."]
    pub selector: String,
}
impl ApplicationGatewayFirewallExclusion {
    pub fn new(match_variable: String, selector_match_operator: String, selector: String) -> Self {
        Self {
            match_variable,
            selector_match_operator,
            selector,
        }
    }
}
#[doc = "A web application firewall rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallRule {
    #[doc = "The identifier of the web application firewall rule."]
    #[serde(rename = "ruleId")]
    pub rule_id: i32,
    #[doc = "The description of the web application firewall rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ApplicationGatewayFirewallRule {
    pub fn new(rule_id: i32) -> Self {
        Self {
            rule_id,
            description: None,
        }
    }
}
#[doc = "A web application firewall rule group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallRuleGroup {
    #[doc = "The name of the web application firewall rule group."]
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[doc = "The description of the web application firewall rule group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The rules of the web application firewall rule group."]
    pub rules: Vec<ApplicationGatewayFirewallRule>,
}
impl ApplicationGatewayFirewallRuleGroup {
    pub fn new(rule_group_name: String, rules: Vec<ApplicationGatewayFirewallRule>) -> Self {
        Self {
            rule_group_name,
            description: None,
            rules,
        }
    }
}
#[doc = "A web application firewall rule set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFirewallRuleSet {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the web application firewall rule set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFirewallRuleSetPropertiesFormat>,
}
impl ApplicationGatewayFirewallRuleSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the web application firewall rule set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallRuleSetPropertiesFormat {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The type of the web application firewall rule set."]
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[doc = "The version of the web application firewall rule set type."]
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[doc = "The rule groups of the web application firewall rule set."]
    #[serde(rename = "ruleGroups")]
    pub rule_groups: Vec<ApplicationGatewayFirewallRuleGroup>,
}
impl ApplicationGatewayFirewallRuleSetPropertiesFormat {
    pub fn new(rule_set_type: String, rule_set_version: String, rule_groups: Vec<ApplicationGatewayFirewallRuleGroup>) -> Self {
        Self {
            provisioning_state: None,
            rule_set_type,
            rule_set_version,
            rule_groups,
        }
    }
}
#[doc = "Frontend IP configuration of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Frontend IP configuration of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFrontendIpConfigurationPropertiesFormat>,
    #[doc = "Name of the frontend IP configuration that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayFrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Frontend IP configuration of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendIpConfigurationPropertiesFormat {
    #[doc = "PrivateIPAddress of the network interface IP Configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "IP address allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "privateLinkConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub private_link_configuration: Option<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayFrontendIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Frontend port of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendPort {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Frontend port of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFrontendPortPropertiesFormat>,
    #[doc = "Name of the frontend port that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayFrontendPort {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Frontend port of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendPortPropertiesFormat {
    #[doc = "Frontend port."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayFrontendPortPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application Gateway global configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayGlobalConfiguration {
    #[doc = "Enable request buffering."]
    #[serde(rename = "enableRequestBuffering", default, skip_serializing_if = "Option::is_none")]
    pub enable_request_buffering: Option<bool>,
    #[doc = "Enable response buffering."]
    #[serde(rename = "enableResponseBuffering", default, skip_serializing_if = "Option::is_none")]
    pub enable_response_buffering: Option<bool>,
}
impl ApplicationGatewayGlobalConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Header configuration of the Actions set in Application Gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHeaderConfiguration {
    #[doc = "Header name of the header configuration."]
    #[serde(rename = "headerName", default, skip_serializing_if = "Option::is_none")]
    pub header_name: Option<String>,
    #[doc = "Header value of the header configuration."]
    #[serde(rename = "headerValue", default, skip_serializing_if = "Option::is_none")]
    pub header_value: Option<String>,
}
impl ApplicationGatewayHeaderConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Http listener of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHttpListener {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of HTTP listener of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayHttpListenerPropertiesFormat>,
    #[doc = "Name of the HTTP listener that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayHttpListener {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of HTTP listener of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHttpListenerPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<SubResource>,
    #[doc = "Application Gateway protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<ApplicationGatewayProtocol>,
    #[doc = "Host name of HTTP listener."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "sslCertificate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_certificate: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "sslProfile", default, skip_serializing_if = "Option::is_none")]
    pub ssl_profile: Option<SubResource>,
    #[doc = "Applicable only if protocol is https. Enables SNI for multi-hosting."]
    #[serde(rename = "requireServerNameIndication", default, skip_serializing_if = "Option::is_none")]
    pub require_server_name_indication: Option<bool>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Custom error configurations of the HTTP listener."]
    #[serde(rename = "customErrorConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_error_configurations: Vec<ApplicationGatewayCustomError>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "firewallPolicy", default, skip_serializing_if = "Option::is_none")]
    pub firewall_policy: Option<SubResource>,
    #[doc = "List of Host names for HTTP Listener that allows special wildcard characters as well."]
    #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
    pub host_names: Vec<String>,
}
impl ApplicationGatewayHttpListenerPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayIpConfigurationPropertiesFormat>,
    #[doc = "Name of the IP configuration that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayIpConfigurationPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListApplicationGateways API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayListResult {
    #[doc = "List of an application gateways in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGateway>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Load Distribution Algorithm enums."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ApplicationGatewayLoadDistributionAlgorithmEnum {
    RoundRobin,
    LeastConnections,
    IpHash,
}
#[doc = "Load Distribution Policy of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayLoadDistributionPolicy {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Load Distribution Policy of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayLoadDistributionPolicyPropertiesFormat>,
    #[doc = "Name of the load distribution policy that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayLoadDistributionPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Load Distribution Policy of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayLoadDistributionPolicyPropertiesFormat {
    #[doc = "Load Distribution Targets resource of an application gateway."]
    #[serde(rename = "loadDistributionTargets", default, skip_serializing_if = "Vec::is_empty")]
    pub load_distribution_targets: Vec<ApplicationGatewayLoadDistributionTarget>,
    #[doc = "Load Distribution Algorithm enums."]
    #[serde(rename = "loadDistributionAlgorithm", default, skip_serializing_if = "Option::is_none")]
    pub load_distribution_algorithm: Option<ApplicationGatewayLoadDistributionAlgorithmEnum>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayLoadDistributionPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Load Distribution Target of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayLoadDistributionTarget {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayLoadDistributionTargetPropertiesFormat>,
    #[doc = "Name of the load distribution policy that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayLoadDistributionTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayLoadDistributionTargetPropertiesFormat {
    #[doc = "Weight per server. Range between 1 and 100."]
    #[serde(rename = "weightPerServer", default, skip_serializing_if = "Option::is_none")]
    pub weight_per_server: Option<i32>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
}
impl ApplicationGatewayLoadDistributionTargetPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details of on demand test probe request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayOnDemandProbe {
    #[doc = "Application Gateway protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<ApplicationGatewayProtocol>,
    #[doc = "Host name to send the probe to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[doc = "Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "Whether the host header should be picked from the backend http settings. Default value is false."]
    #[serde(rename = "pickHostNameFromBackendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub pick_host_name_from_backend_http_settings: Option<bool>,
    #[doc = "Application gateway probe health response match."]
    #[serde(rename = "match", default, skip_serializing_if = "Option::is_none")]
    pub match_: Option<ApplicationGatewayProbeHealthResponseMatch>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
}
impl ApplicationGatewayOnDemandProbe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Path rule of URL path map of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPathRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of path rule of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPathRulePropertiesFormat>,
    #[doc = "Name of the path rule that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPathRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of path rule of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPathRulePropertiesFormat {
    #[doc = "Path rules of URL path map."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub paths: Vec<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "redirectConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub redirect_configuration: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "rewriteRuleSet", default, skip_serializing_if = "Option::is_none")]
    pub rewrite_rule_set: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "loadDistributionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub load_distribution_policy: Option<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "firewallPolicy", default, skip_serializing_if = "Option::is_none")]
    pub firewall_policy: Option<SubResource>,
}
impl ApplicationGatewayPathRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Private Endpoint connection on an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateEndpointConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Private Link Resource of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPrivateEndpointConnectionProperties>,
    #[doc = "Name of the private endpoint connection on an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListApplicationGatewayPrivateEndpointConnection API service call. Gets all private endpoint connections for an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateEndpointConnectionListResult {
    #[doc = "List of private endpoint connections on an application gateway."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewayPrivateEndpointConnection>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayPrivateEndpointConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Private Link Resource of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateEndpointConnectionProperties {
    #[doc = "Private endpoint resource."]
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[doc = "A collection of information about the state of the connection between service consumer and provider."]
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The consumer link id."]
    #[serde(rename = "linkIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub link_identifier: Option<String>,
}
impl ApplicationGatewayPrivateEndpointConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Private Link Configuration on an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of private link configuration on an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPrivateLinkConfigurationProperties>,
    #[doc = "Name of the private link configuration that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPrivateLinkConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of private link configuration on an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkConfigurationProperties {
    #[doc = "An array of application gateway private link ip configurations."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<ApplicationGatewayPrivateLinkIpConfiguration>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayPrivateLinkConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The application gateway private link ip configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of an application gateway private link IP configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPrivateLinkIpConfigurationProperties>,
    #[doc = "The name of application gateway private link ip configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPrivateLinkIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an application gateway private link IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkIpConfigurationProperties {
    #[doc = "The private IP address of the IP configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "IP address allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Whether the ip configuration is primary or not."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayPrivateLinkIpConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "PrivateLink Resource of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of a private link resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPrivateLinkResourceProperties>,
    #[doc = "Name of the private link resource that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListApplicationGatewayPrivateLinkResources API service call. Gets all private link resources for an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkResourceListResult {
    #[doc = "List of private link resources of an application gateway."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewayPrivateLinkResource>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayPrivateLinkResourceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a private link resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkResourceProperties {
    #[doc = "Group identifier of private link resource."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[doc = "Required member names of private link resource."]
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[doc = "Required DNS zone names of the the private link resource."]
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl ApplicationGatewayPrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Probe of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbe {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of probe of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayProbePropertiesFormat>,
    #[doc = "Name of the probe that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayProbe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway probe health response match."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbeHealthResponseMatch {
    #[doc = "Body that must be contained in the health response. Default value is empty."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    #[doc = "Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399."]
    #[serde(rename = "statusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub status_codes: Vec<String>,
}
impl ApplicationGatewayProbeHealthResponseMatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of probe of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbePropertiesFormat {
    #[doc = "Application Gateway protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<ApplicationGatewayProtocol>,
    #[doc = "Host name to send the probe to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[doc = "Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[doc = "The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20."]
    #[serde(rename = "unhealthyThreshold", default, skip_serializing_if = "Option::is_none")]
    pub unhealthy_threshold: Option<i32>,
    #[doc = "Whether the host header should be picked from the backend http settings. Default value is false."]
    #[serde(rename = "pickHostNameFromBackendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub pick_host_name_from_backend_http_settings: Option<bool>,
    #[doc = "Minimum number of servers that are always marked healthy. Default value is 0."]
    #[serde(rename = "minServers", default, skip_serializing_if = "Option::is_none")]
    pub min_servers: Option<i32>,
    #[doc = "Application gateway probe health response match."]
    #[serde(rename = "match", default, skip_serializing_if = "Option::is_none")]
    pub match_: Option<ApplicationGatewayProbeHealthResponseMatch>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl ApplicationGatewayProbePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPropertiesFormat {
    #[doc = "SKU of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ApplicationGatewaySku>,
    #[doc = "Application Gateway Ssl policy."]
    #[serde(rename = "sslPolicy", default, skip_serializing_if = "Option::is_none")]
    pub ssl_policy: Option<ApplicationGatewaySslPolicy>,
    #[doc = "Operational state of the application gateway resource."]
    #[serde(rename = "operationalState", default, skip_serializing_if = "Option::is_none")]
    pub operational_state: Option<application_gateway_properties_format::OperationalState>,
    #[doc = "Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "gatewayIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub gateway_ip_configurations: Vec<ApplicationGatewayIpConfiguration>,
    #[doc = "Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "authenticationCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub authentication_certificates: Vec<ApplicationGatewayAuthenticationCertificate>,
    #[doc = "Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "trustedRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_root_certificates: Vec<ApplicationGatewayTrustedRootCertificate>,
    #[doc = "Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "trustedClientCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_client_certificates: Vec<ApplicationGatewayTrustedClientCertificate>,
    #[doc = "SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "sslCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub ssl_certificates: Vec<ApplicationGatewaySslCertificate>,
    #[doc = "Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<ApplicationGatewayFrontendIpConfiguration>,
    #[doc = "Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "frontendPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ports: Vec<ApplicationGatewayFrontendPort>,
    #[doc = "Probes of the application gateway resource."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub probes: Vec<ApplicationGatewayProbe>,
    #[doc = "Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<ApplicationGatewayBackendAddressPool>,
    #[doc = "Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "backendHttpSettingsCollection", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_http_settings_collection: Vec<ApplicationGatewayBackendHttpSettings>,
    #[doc = "Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "httpListeners", default, skip_serializing_if = "Vec::is_empty")]
    pub http_listeners: Vec<ApplicationGatewayHttpListener>,
    #[doc = "SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "sslProfiles", default, skip_serializing_if = "Vec::is_empty")]
    pub ssl_profiles: Vec<ApplicationGatewaySslProfile>,
    #[doc = "URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "urlPathMaps", default, skip_serializing_if = "Vec::is_empty")]
    pub url_path_maps: Vec<ApplicationGatewayUrlPathMap>,
    #[doc = "Request routing rules of the application gateway resource."]
    #[serde(rename = "requestRoutingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub request_routing_rules: Vec<ApplicationGatewayRequestRoutingRule>,
    #[doc = "Rewrite rules for the application gateway resource."]
    #[serde(rename = "rewriteRuleSets", default, skip_serializing_if = "Vec::is_empty")]
    pub rewrite_rule_sets: Vec<ApplicationGatewayRewriteRuleSet>,
    #[doc = "Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits)."]
    #[serde(rename = "redirectConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub redirect_configurations: Vec<ApplicationGatewayRedirectConfiguration>,
    #[doc = "Application gateway web application firewall configuration."]
    #[serde(rename = "webApplicationFirewallConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub web_application_firewall_configuration: Option<ApplicationGatewayWebApplicationFirewallConfiguration>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "firewallPolicy", default, skip_serializing_if = "Option::is_none")]
    pub firewall_policy: Option<SubResource>,
    #[doc = "Whether HTTP2 is enabled on the application gateway resource."]
    #[serde(rename = "enableHttp2", default, skip_serializing_if = "Option::is_none")]
    pub enable_http2: Option<bool>,
    #[doc = "Whether FIPS is enabled on the application gateway resource."]
    #[serde(rename = "enableFips", default, skip_serializing_if = "Option::is_none")]
    pub enable_fips: Option<bool>,
    #[doc = "Application Gateway autoscale configuration."]
    #[serde(rename = "autoscaleConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub autoscale_configuration: Option<ApplicationGatewayAutoscaleConfiguration>,
    #[doc = "PrivateLink configurations on application gateway."]
    #[serde(rename = "privateLinkConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub private_link_configurations: Vec<ApplicationGatewayPrivateLinkConfiguration>,
    #[doc = "Private Endpoint connections on application gateway."]
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<ApplicationGatewayPrivateEndpointConnection>,
    #[doc = "The resource GUID property of the application gateway resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Custom error configurations of the application gateway resource."]
    #[serde(rename = "customErrorConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_error_configurations: Vec<ApplicationGatewayCustomError>,
    #[doc = "If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config."]
    #[serde(rename = "forceFirewallPolicyAssociation", default, skip_serializing_if = "Option::is_none")]
    pub force_firewall_policy_association: Option<bool>,
    #[doc = "Load distribution policies of the application gateway resource."]
    #[serde(rename = "loadDistributionPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub load_distribution_policies: Vec<ApplicationGatewayLoadDistributionPolicy>,
    #[doc = "Application Gateway global configuration."]
    #[serde(rename = "globalConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub global_configuration: Option<ApplicationGatewayGlobalConfiguration>,
}
impl ApplicationGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_properties_format {
    use super::*;
    #[doc = "Operational state of the application gateway resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationalState {
        Stopped,
        Starting,
        Running,
        Stopping,
    }
}
#[doc = "Application Gateway protocol."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ApplicationGatewayProtocol {
    Http,
    Https,
}
#[doc = "Redirect configuration of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRedirectConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of redirect configuration of the application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayRedirectConfigurationPropertiesFormat>,
    #[doc = "Name of the redirect configuration that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayRedirectConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of redirect configuration of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRedirectConfigurationPropertiesFormat {
    #[doc = "Redirect type enum."]
    #[serde(rename = "redirectType", default, skip_serializing_if = "Option::is_none")]
    pub redirect_type: Option<RedirectTypeEnum>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "targetListener", default, skip_serializing_if = "Option::is_none")]
    pub target_listener: Option<SubResource>,
    #[doc = "Url to redirect the request to."]
    #[serde(rename = "targetUrl", default, skip_serializing_if = "Option::is_none")]
    pub target_url: Option<String>,
    #[doc = "Include path in the redirected url."]
    #[serde(rename = "includePath", default, skip_serializing_if = "Option::is_none")]
    pub include_path: Option<bool>,
    #[doc = "Include query string in the redirected url."]
    #[serde(rename = "includeQueryString", default, skip_serializing_if = "Option::is_none")]
    pub include_query_string: Option<bool>,
    #[doc = "Request routing specifying redirect configuration."]
    #[serde(rename = "requestRoutingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub request_routing_rules: Vec<SubResource>,
    #[doc = "Url path maps specifying default redirect configuration."]
    #[serde(rename = "urlPathMaps", default, skip_serializing_if = "Vec::is_empty")]
    pub url_path_maps: Vec<SubResource>,
    #[doc = "Path rules specifying redirect configuration."]
    #[serde(rename = "pathRules", default, skip_serializing_if = "Vec::is_empty")]
    pub path_rules: Vec<SubResource>,
}
impl ApplicationGatewayRedirectConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request routing rule of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRequestRoutingRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of request routing rule of the application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayRequestRoutingRulePropertiesFormat>,
    #[doc = "Name of the request routing rule that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayRequestRoutingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of request routing rule of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRequestRoutingRulePropertiesFormat {
    #[doc = "Rule type."]
    #[serde(rename = "ruleType", default, skip_serializing_if = "Option::is_none")]
    pub rule_type: Option<application_gateway_request_routing_rule_properties_format::RuleType>,
    #[doc = "Priority of the request routing rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "httpListener", default, skip_serializing_if = "Option::is_none")]
    pub http_listener: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "urlPathMap", default, skip_serializing_if = "Option::is_none")]
    pub url_path_map: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "rewriteRuleSet", default, skip_serializing_if = "Option::is_none")]
    pub rewrite_rule_set: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "redirectConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub redirect_configuration: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "loadDistributionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub load_distribution_policy: Option<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayRequestRoutingRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_request_routing_rule_properties_format {
    use super::*;
    #[doc = "Rule type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleType {
        Basic,
        PathBasedRouting,
    }
}
#[doc = "Rewrite rule of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRule {
    #[doc = "Name of the rewrite rule that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet."]
    #[serde(rename = "ruleSequence", default, skip_serializing_if = "Option::is_none")]
    pub rule_sequence: Option<i64>,
    #[doc = "Conditions based on which the action set execution will be evaluated."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub conditions: Vec<ApplicationGatewayRewriteRuleCondition>,
    #[doc = "Set of actions in the Rewrite Rule in Application Gateway."]
    #[serde(rename = "actionSet", default, skip_serializing_if = "Option::is_none")]
    pub action_set: Option<ApplicationGatewayRewriteRuleActionSet>,
}
impl ApplicationGatewayRewriteRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Set of actions in the Rewrite Rule in Application Gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRuleActionSet {
    #[doc = "Request Header Actions in the Action Set."]
    #[serde(rename = "requestHeaderConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub request_header_configurations: Vec<ApplicationGatewayHeaderConfiguration>,
    #[doc = "Response Header Actions in the Action Set."]
    #[serde(rename = "responseHeaderConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub response_header_configurations: Vec<ApplicationGatewayHeaderConfiguration>,
    #[doc = "Url configuration of the Actions set in Application Gateway."]
    #[serde(rename = "urlConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub url_configuration: Option<ApplicationGatewayUrlConfiguration>,
}
impl ApplicationGatewayRewriteRuleActionSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Set of conditions in the Rewrite Rule in Application Gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRuleCondition {
    #[doc = "The condition parameter of the RewriteRuleCondition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub variable: Option<String>,
    #[doc = "The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pattern: Option<String>,
    #[doc = "Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison."]
    #[serde(rename = "ignoreCase", default, skip_serializing_if = "Option::is_none")]
    pub ignore_case: Option<bool>,
    #[doc = "Setting this value as truth will force to check the negation of the condition given by the user."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub negate: Option<bool>,
}
impl ApplicationGatewayRewriteRuleCondition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Rewrite rule set of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRuleSet {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of rewrite rule set of the application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayRewriteRuleSetPropertiesFormat>,
    #[doc = "Name of the rewrite rule set that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayRewriteRuleSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of rewrite rule set of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRuleSetPropertiesFormat {
    #[doc = "Rewrite rules in the rewrite rule set."]
    #[serde(rename = "rewriteRules", default, skip_serializing_if = "Vec::is_empty")]
    pub rewrite_rules: Vec<ApplicationGatewayRewriteRule>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayRewriteRuleSetPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SKU of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySku {
    #[doc = "Name of an application gateway SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<application_gateway_sku::Name>,
    #[doc = "Tier of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<application_gateway_sku::Tier>,
    #[doc = "Capacity (instance count) of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl ApplicationGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_sku {
    use super::*;
    #[doc = "Name of an application gateway SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "Standard_Small")]
        StandardSmall,
        #[serde(rename = "Standard_Medium")]
        StandardMedium,
        #[serde(rename = "Standard_Large")]
        StandardLarge,
        #[serde(rename = "WAF_Medium")]
        WafMedium,
        #[serde(rename = "WAF_Large")]
        WafLarge,
        #[serde(rename = "Standard_v2")]
        StandardV2,
        #[serde(rename = "WAF_v2")]
        WafV2,
    }
    #[doc = "Tier of an application gateway."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        #[serde(rename = "WAF")]
        Waf,
        #[serde(rename = "Standard_v2")]
        StandardV2,
        #[serde(rename = "WAF_v2")]
        WafV2,
    }
}
#[doc = "SSL certificates of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of SSL certificates of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewaySslCertificatePropertiesFormat>,
    #[doc = "Name of the SSL certificate that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewaySslCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of SSL certificates of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslCertificatePropertiesFormat {
    #[doc = "Base-64 encoded pfx certificate. Only applicable in PUT Request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[doc = "Password for the pfx file specified in data. Only applicable in PUT request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[doc = "Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request."]
    #[serde(rename = "publicCertData", default, skip_serializing_if = "Option::is_none")]
    pub public_cert_data: Option<String>,
    #[doc = "Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault."]
    #[serde(rename = "keyVaultSecretId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_secret_id: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewaySslCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application Gateway Ssl policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPolicy {
    #[doc = "Ssl protocols to be disabled on application gateway."]
    #[serde(rename = "disabledSslProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub disabled_ssl_protocols: Vec<ProtocolsEnum>,
    #[doc = "Type of Ssl Policy."]
    #[serde(rename = "policyType", default, skip_serializing_if = "Option::is_none")]
    pub policy_type: Option<application_gateway_ssl_policy::PolicyType>,
    #[doc = "Ssl predefined policy name enums."]
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<PolicyNameEnum>,
    #[doc = "Ssl cipher suites to be enabled in the specified order to application gateway."]
    #[serde(rename = "cipherSuites", default, skip_serializing_if = "Vec::is_empty")]
    pub cipher_suites: Vec<CipherSuitesEnum>,
    #[doc = "Ssl protocol enums."]
    #[serde(rename = "minProtocolVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_protocol_version: Option<ProtocolsEnum>,
}
impl ApplicationGatewaySslPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_ssl_policy {
    use super::*;
    #[doc = "Type of Ssl Policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PolicyType {
        Predefined,
        Custom,
    }
}
#[doc = "An Ssl predefined policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPredefinedPolicy {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Name of the Ssl predefined policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Properties of ApplicationGatewaySslPredefinedPolicy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewaySslPredefinedPolicyPropertiesFormat>,
}
impl ApplicationGatewaySslPredefinedPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ApplicationGatewaySslPredefinedPolicy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPredefinedPolicyPropertiesFormat {
    #[doc = "Ssl cipher suites to be enabled in the specified order for application gateway."]
    #[serde(rename = "cipherSuites", default, skip_serializing_if = "Vec::is_empty")]
    pub cipher_suites: Vec<CipherSuitesEnum>,
    #[doc = "Ssl protocol enums."]
    #[serde(rename = "minProtocolVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_protocol_version: Option<ProtocolsEnum>,
}
impl ApplicationGatewaySslPredefinedPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SSL profile of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslProfile {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of SSL profile of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewaySslProfilePropertiesFormat>,
    #[doc = "Name of the SSL profile that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewaySslProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of SSL profile of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslProfilePropertiesFormat {
    #[doc = "Array of references to application gateway trusted client certificates."]
    #[serde(rename = "trustedClientCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_client_certificates: Vec<SubResource>,
    #[doc = "Application Gateway Ssl policy."]
    #[serde(rename = "sslPolicy", default, skip_serializing_if = "Option::is_none")]
    pub ssl_policy: Option<ApplicationGatewaySslPolicy>,
    #[doc = "Application gateway client authentication configuration."]
    #[serde(rename = "clientAuthConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub client_auth_configuration: Option<ApplicationGatewayClientAuthConfiguration>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewaySslProfilePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Trusted client certificates of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayTrustedClientCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Trusted client certificates properties of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayTrustedClientCertificatePropertiesFormat>,
    #[doc = "Name of the trusted client certificate that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayTrustedClientCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Trusted client certificates properties of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayTrustedClientCertificatePropertiesFormat {
    #[doc = "Certificate public data."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[doc = "Validated certificate data."]
    #[serde(rename = "validatedCertData", default, skip_serializing_if = "Option::is_none")]
    pub validated_cert_data: Option<String>,
    #[doc = "Distinguished name of client certificate issuer."]
    #[serde(rename = "clientCertIssuerDN", default, skip_serializing_if = "Option::is_none")]
    pub client_cert_issuer_dn: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayTrustedClientCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Trusted Root certificates of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayTrustedRootCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Trusted Root certificates properties of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayTrustedRootCertificatePropertiesFormat>,
    #[doc = "Name of the trusted root certificate that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayTrustedRootCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Trusted Root certificates properties of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayTrustedRootCertificatePropertiesFormat {
    #[doc = "Certificate public data."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[doc = "Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault."]
    #[serde(rename = "keyVaultSecretId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_secret_id: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayTrustedRootCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Url configuration of the Actions set in Application Gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlConfiguration {
    #[doc = "Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null."]
    #[serde(rename = "modifiedPath", default, skip_serializing_if = "Option::is_none")]
    pub modified_path: Option<String>,
    #[doc = "Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null."]
    #[serde(rename = "modifiedQueryString", default, skip_serializing_if = "Option::is_none")]
    pub modified_query_string: Option<String>,
    #[doc = "If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reroute: Option<bool>,
}
impl ApplicationGatewayUrlConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "UrlPathMaps give a url path to the backend mapping information for PathBasedRouting."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlPathMap {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of UrlPathMap of the application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayUrlPathMapPropertiesFormat>,
    #[doc = "Name of the URL path map that is unique within an Application Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayUrlPathMap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of UrlPathMap of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlPathMapPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "defaultBackendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub default_backend_address_pool: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "defaultBackendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub default_backend_http_settings: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "defaultRewriteRuleSet", default, skip_serializing_if = "Option::is_none")]
    pub default_rewrite_rule_set: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "defaultRedirectConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub default_redirect_configuration: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "defaultLoadDistributionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub default_load_distribution_policy: Option<SubResource>,
    #[doc = "Path rule of URL path map resource."]
    #[serde(rename = "pathRules", default, skip_serializing_if = "Vec::is_empty")]
    pub path_rules: Vec<ApplicationGatewayPathRule>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayUrlPathMapPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway web application firewall configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayWebApplicationFirewallConfiguration {
    #[doc = "Whether the web application firewall is enabled or not."]
    pub enabled: bool,
    #[doc = "Web application firewall mode."]
    #[serde(rename = "firewallMode")]
    pub firewall_mode: application_gateway_web_application_firewall_configuration::FirewallMode,
    #[doc = "The type of the web application firewall rule set. Possible values are: 'OWASP'."]
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[doc = "The version of the rule set type."]
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[doc = "The disabled rule groups."]
    #[serde(rename = "disabledRuleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub disabled_rule_groups: Vec<ApplicationGatewayFirewallDisabledRuleGroup>,
    #[doc = "Whether allow WAF to check request Body."]
    #[serde(rename = "requestBodyCheck", default, skip_serializing_if = "Option::is_none")]
    pub request_body_check: Option<bool>,
    #[doc = "Maximum request body size for WAF."]
    #[serde(rename = "maxRequestBodySize", default, skip_serializing_if = "Option::is_none")]
    pub max_request_body_size: Option<i32>,
    #[doc = "Maximum request body size in Kb for WAF."]
    #[serde(rename = "maxRequestBodySizeInKb", default, skip_serializing_if = "Option::is_none")]
    pub max_request_body_size_in_kb: Option<i32>,
    #[doc = "Maximum file upload size in Mb for WAF."]
    #[serde(rename = "fileUploadLimitInMb", default, skip_serializing_if = "Option::is_none")]
    pub file_upload_limit_in_mb: Option<i32>,
    #[doc = "The exclusion list."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub exclusions: Vec<ApplicationGatewayFirewallExclusion>,
}
impl ApplicationGatewayWebApplicationFirewallConfiguration {
    pub fn new(
        enabled: bool,
        firewall_mode: application_gateway_web_application_firewall_configuration::FirewallMode,
        rule_set_type: String,
        rule_set_version: String,
    ) -> Self {
        Self {
            enabled,
            firewall_mode,
            rule_set_type,
            rule_set_version,
            disabled_rule_groups: Vec::new(),
            request_body_check: None,
            max_request_body_size: None,
            max_request_body_size_in_kb: None,
            file_upload_limit_in_mb: None,
            exclusions: Vec::new(),
        }
    }
}
pub mod application_gateway_web_application_firewall_configuration {
    use super::*;
    #[doc = "Web application firewall mode."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirewallMode {
        Detection,
        Prevention,
    }
}
#[doc = "Rule of type application."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationRule {
    #[serde(flatten)]
    pub firewall_policy_rule: FirewallPolicyRule,
    #[doc = "List of source IP addresses for this rule."]
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[doc = "List of destination IP addresses or Service Tags."]
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[doc = "Array of Application Protocols."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<FirewallPolicyRuleApplicationProtocol>,
    #[doc = "List of FQDNs for this rule."]
    #[serde(rename = "targetFqdns", default, skip_serializing_if = "Vec::is_empty")]
    pub target_fqdns: Vec<String>,
    #[doc = "List of Urls for this rule condition."]
    #[serde(rename = "targetUrls", default, skip_serializing_if = "Vec::is_empty")]
    pub target_urls: Vec<String>,
    #[doc = "List of FQDN Tags for this rule."]
    #[serde(rename = "fqdnTags", default, skip_serializing_if = "Vec::is_empty")]
    pub fqdn_tags: Vec<String>,
    #[doc = "List of source IpGroups for this rule."]
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
    #[doc = "Terminate TLS connections for this rule."]
    #[serde(rename = "terminateTLS", default, skip_serializing_if = "Option::is_none")]
    pub terminate_tls: Option<bool>,
    #[doc = "List of destination azure web categories."]
    #[serde(rename = "webCategories", default, skip_serializing_if = "Vec::is_empty")]
    pub web_categories: Vec<String>,
}
impl ApplicationRule {
    pub fn new(firewall_policy_rule: FirewallPolicyRule) -> Self {
        Self {
            firewall_policy_rule,
            source_addresses: Vec::new(),
            destination_addresses: Vec::new(),
            protocols: Vec::new(),
            target_fqdns: Vec::new(),
            target_urls: Vec::new(),
            fqdn_tags: Vec::new(),
            source_ip_groups: Vec::new(),
            terminate_tls: None,
            web_categories: Vec::new(),
        }
    }
}
#[doc = "An application security group in a resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Application security group properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationSecurityGroupPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of application security groups."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroupListResult {
    #[doc = "A list of application security groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationSecurityGroup>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application security group properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroupPropertiesFormat {
    #[doc = "The resource GUID property of the application security group resource. It uniquely identifies a resource, even if the user changes its name or migrate the resource across subscriptions or resource groups."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationSecurityGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VPN client authentication method."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AuthenticationMethod {
    #[serde(rename = "EAPTLS")]
    Eaptls,
    #[serde(rename = "EAPMSCHAPv2")]
    EapmschaPv2,
}
#[doc = "Response for ListAuthorizations API service call retrieves all authorizations that belongs to an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationListResult {
    #[doc = "The authorizations in an ExpressRoute Circuit."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitAuthorization>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AuthorizationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ExpressRouteCircuitAuthorization."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationPropertiesFormat {
    #[doc = "The authorization key."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "The authorization use status."]
    #[serde(rename = "authorizationUseStatus", default, skip_serializing_if = "Option::is_none")]
    pub authorization_use_status: Option<authorization_properties_format::AuthorizationUseStatus>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AuthorizationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod authorization_properties_format {
    use super::*;
    #[doc = "The authorization use status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthorizationUseStatus {
        Available,
        InUse,
    }
}
#[doc = "The information of an AutoApprovedPrivateLinkService."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoApprovedPrivateLinkService {
    #[doc = "The id of the private link service resource."]
    #[serde(rename = "privateLinkService", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service: Option<String>,
}
impl AutoApprovedPrivateLinkService {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An array of private link service id that can be linked to a private end point with auto approved."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoApprovedPrivateLinkServicesResult {
    #[doc = "An array of auto approved private link service."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AutoApprovedPrivateLinkService>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AutoApprovedPrivateLinkServicesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Availability of the metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Availability {
    #[doc = "The time grain of the availability."]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[doc = "The retention of the availability."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
    #[doc = "Duration of the availability blob."]
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl Availability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The serviceName of an AvailableDelegation indicates a possible delegation for a subnet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableDelegation {
    #[doc = "The name of the AvailableDelegation resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique identifier of the AvailableDelegation resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The name of the service and resource."]
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[doc = "The actions permitted to the service upon delegation."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub actions: Vec<String>,
}
impl AvailableDelegation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An array of available delegations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableDelegationsResult {
    #[doc = "An array of available delegations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AvailableDelegation>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailableDelegationsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The information of an AvailablePrivateEndpointType."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailablePrivateEndpointType {
    #[doc = "The name of the service and resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique identifier of the AvailablePrivateEndpoint Type resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The name of the service and resource."]
    #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
    pub resource_name: Option<String>,
    #[doc = "Display name of the resource."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl AvailablePrivateEndpointType {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An array of available PrivateEndpoint types."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailablePrivateEndpointTypesResult {
    #[doc = "An array of available privateEndpoint type."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AvailablePrivateEndpointType>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailablePrivateEndpointTypesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of available countries with details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailableProvidersList {
    #[doc = "List of available countries."]
    pub countries: Vec<AvailableProvidersListCountry>,
}
impl AvailableProvidersList {
    pub fn new(countries: Vec<AvailableProvidersListCountry>) -> Self {
        Self { countries }
    }
}
#[doc = "City or town details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListCity {
    #[doc = "The city or town name."]
    #[serde(rename = "cityName", default, skip_serializing_if = "Option::is_none")]
    pub city_name: Option<String>,
    #[doc = "A list of Internet service providers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
}
impl AvailableProvidersListCity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Country details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListCountry {
    #[doc = "The country name."]
    #[serde(rename = "countryName", default, skip_serializing_if = "Option::is_none")]
    pub country_name: Option<String>,
    #[doc = "A list of Internet service providers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
    #[doc = "List of available states in the country."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub states: Vec<AvailableProvidersListState>,
}
impl AvailableProvidersListCountry {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Constraints that determine the list of available Internet service providers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListParameters {
    #[doc = "A list of Azure regions."]
    #[serde(rename = "azureLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_locations: Vec<String>,
    #[doc = "The country for available providers list."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[doc = "The state for available providers list."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The city or town for available providers list."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
}
impl AvailableProvidersListParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "State details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListState {
    #[doc = "The state name."]
    #[serde(rename = "stateName", default, skip_serializing_if = "Option::is_none")]
    pub state_name: Option<String>,
    #[doc = "A list of Internet service providers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
    #[doc = "List of available cities or towns in the state."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub cities: Vec<AvailableProvidersListCity>,
}
impl AvailableProvidersListState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The available service alias."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableServiceAlias {
    #[doc = "The name of the service alias."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The ID of the service alias."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The resource name of the service alias."]
    #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
    pub resource_name: Option<String>,
}
impl AvailableServiceAlias {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An array of available service aliases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableServiceAliasesResult {
    #[doc = "An array of available service aliases."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AvailableServiceAlias>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailableServiceAliasesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureAsyncOperationResult {
    #[doc = "Status of the Azure async operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<azure_async_operation_result::Status>,
    #[doc = "Common error representation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Error>,
}
impl AzureAsyncOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_async_operation_result {
    use super::*;
    #[doc = "Status of the Azure async operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Succeeded,
        Failed,
    }
}
#[doc = "Azure Firewall resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewall {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the Azure Firewall."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallPropertiesFormat>,
    #[doc = "A list of availability zones denoting where the resource needs to come from."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewall {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The additional properties of azure firewall."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallAdditionalProperties {}
impl AzureFirewallAdditionalProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an application rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallApplicationRule {
    #[doc = "Name of the application rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Description of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "List of source IP addresses for this rule."]
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[doc = "Array of ApplicationRuleProtocols."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<AzureFirewallApplicationRuleProtocol>,
    #[doc = "List of FQDNs for this rule."]
    #[serde(rename = "targetFqdns", default, skip_serializing_if = "Vec::is_empty")]
    pub target_fqdns: Vec<String>,
    #[doc = "List of FQDN Tags for this rule."]
    #[serde(rename = "fqdnTags", default, skip_serializing_if = "Vec::is_empty")]
    pub fqdn_tags: Vec<String>,
    #[doc = "List of source IpGroups for this rule."]
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
}
impl AzureFirewallApplicationRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application rule collection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallApplicationRuleCollection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the application rule collection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallApplicationRuleCollectionPropertiesFormat>,
    #[doc = "The name of the resource that is unique within the Azure firewall. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewallApplicationRuleCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the application rule collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallApplicationRuleCollectionPropertiesFormat {
    #[doc = "Priority of the application rule collection resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "Properties of the AzureFirewallRCAction."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<AzureFirewallRcAction>,
    #[doc = "Collection of rules used by a application rule collection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<AzureFirewallApplicationRule>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AzureFirewallApplicationRuleCollectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the application rule protocol."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallApplicationRuleProtocol {
    #[doc = "The protocol type of a Application Rule resource."]
    #[serde(rename = "protocolType", default, skip_serializing_if = "Option::is_none")]
    pub protocol_type: Option<AzureFirewallApplicationRuleProtocolType>,
    #[doc = "Port number for the protocol, cannot be greater than 64000. This field is optional."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl AzureFirewallApplicationRuleProtocol {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The protocol type of a Application Rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallApplicationRuleProtocolType {
    Http,
    Https,
    Mssql,
}
#[doc = "Azure Firewall FQDN Tag Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallFqdnTag {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Azure Firewall FQDN Tag Properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallFqdnTagPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewallFqdnTag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListAzureFirewallFqdnTags API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallFqdnTagListResult {
    #[doc = "List of Azure Firewall FQDN Tags in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AzureFirewallFqdnTag>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AzureFirewallFqdnTagListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Firewall FQDN Tag Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallFqdnTagPropertiesFormat {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The name of this FQDN Tag."]
    #[serde(rename = "fqdnTagName", default, skip_serializing_if = "Option::is_none")]
    pub fqdn_tag_name: Option<String>,
}
impl AzureFirewallFqdnTagPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP configuration of an Azure Firewall."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration of an Azure Firewall."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallIpConfigurationPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl AzureFirewallIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration of an Azure Firewall."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallIpConfigurationPropertiesFormat {
    #[doc = "The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AzureFirewallIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IpGroups associated with azure firewall."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallIpGroups {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The iteration number."]
    #[serde(rename = "changeNumber", default, skip_serializing_if = "Option::is_none")]
    pub change_number: Option<String>,
}
impl AzureFirewallIpGroups {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListAzureFirewalls API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallListResult {
    #[doc = "List of Azure Firewalls in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AzureFirewall>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AzureFirewallListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "AzureFirewall NAT Rule Collection Action."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNatRcAction {
    #[doc = "The action type of a NAT rule collection."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<AzureFirewallNatRcActionType>,
}
impl AzureFirewallNatRcAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The action type of a NAT rule collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallNatRcActionType {
    Snat,
    Dnat,
}
#[doc = "Properties of a NAT rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNatRule {
    #[doc = "Name of the NAT rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Description of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "List of source IP addresses for this rule."]
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[doc = "List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags."]
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[doc = "List of destination ports."]
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<String>,
    #[doc = "Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<AzureFirewallNetworkRuleProtocol>,
    #[doc = "The translated address for this NAT rule."]
    #[serde(rename = "translatedAddress", default, skip_serializing_if = "Option::is_none")]
    pub translated_address: Option<String>,
    #[doc = "The translated port for this NAT rule."]
    #[serde(rename = "translatedPort", default, skip_serializing_if = "Option::is_none")]
    pub translated_port: Option<String>,
    #[doc = "The translated FQDN for this NAT rule."]
    #[serde(rename = "translatedFqdn", default, skip_serializing_if = "Option::is_none")]
    pub translated_fqdn: Option<String>,
    #[doc = "List of source IpGroups for this rule."]
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
}
impl AzureFirewallNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NAT rule collection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNatRuleCollection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the NAT rule collection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallNatRuleCollectionProperties>,
    #[doc = "The name of the resource that is unique within the Azure firewall. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewallNatRuleCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the NAT rule collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNatRuleCollectionProperties {
    #[doc = "Priority of the NAT rule collection resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "AzureFirewall NAT Rule Collection Action."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<AzureFirewallNatRcAction>,
    #[doc = "Collection of rules used by a NAT rule collection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<AzureFirewallNatRule>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AzureFirewallNatRuleCollectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the network rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNetworkRule {
    #[doc = "Name of the network rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Description of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Array of AzureFirewallNetworkRuleProtocols."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<AzureFirewallNetworkRuleProtocol>,
    #[doc = "List of source IP addresses for this rule."]
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[doc = "List of destination IP addresses."]
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[doc = "List of destination ports."]
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<String>,
    #[doc = "List of destination FQDNs."]
    #[serde(rename = "destinationFqdns", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_fqdns: Vec<String>,
    #[doc = "List of source IpGroups for this rule."]
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
    #[doc = "List of destination IpGroups for this rule."]
    #[serde(rename = "destinationIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ip_groups: Vec<String>,
}
impl AzureFirewallNetworkRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network rule collection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNetworkRuleCollection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the network rule collection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallNetworkRuleCollectionPropertiesFormat>,
    #[doc = "The name of the resource that is unique within the Azure firewall. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewallNetworkRuleCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the network rule collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNetworkRuleCollectionPropertiesFormat {
    #[doc = "Priority of the network rule collection resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "Properties of the AzureFirewallRCAction."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<AzureFirewallRcAction>,
    #[doc = "Collection of rules used by a network rule collection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<AzureFirewallNetworkRule>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AzureFirewallNetworkRuleCollectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The protocol of a Network Rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallNetworkRuleProtocol {
    #[serde(rename = "TCP")]
    Tcp,
    #[serde(rename = "UDP")]
    Udp,
    Any,
    #[serde(rename = "ICMP")]
    Icmp,
}
#[doc = "Properties of the Azure Firewall."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallPropertiesFormat {
    #[doc = "Collection of application rule collections used by Azure Firewall."]
    #[serde(rename = "applicationRuleCollections", default, skip_serializing_if = "Vec::is_empty")]
    pub application_rule_collections: Vec<AzureFirewallApplicationRuleCollection>,
    #[doc = "Collection of NAT rule collections used by Azure Firewall."]
    #[serde(rename = "natRuleCollections", default, skip_serializing_if = "Vec::is_empty")]
    pub nat_rule_collections: Vec<AzureFirewallNatRuleCollection>,
    #[doc = "Collection of network rule collections used by Azure Firewall."]
    #[serde(rename = "networkRuleCollections", default, skip_serializing_if = "Vec::is_empty")]
    pub network_rule_collections: Vec<AzureFirewallNetworkRuleCollection>,
    #[doc = "IP configuration of the Azure Firewall resource."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<AzureFirewallIpConfiguration>,
    #[doc = "IP configuration of an Azure Firewall."]
    #[serde(rename = "managementIpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub management_ip_configuration: Option<AzureFirewallIpConfiguration>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The operation mode for Threat Intel."]
    #[serde(rename = "threatIntelMode", default, skip_serializing_if = "Option::is_none")]
    pub threat_intel_mode: Option<AzureFirewallThreatIntelMode>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "firewallPolicy", default, skip_serializing_if = "Option::is_none")]
    pub firewall_policy: Option<SubResource>,
    #[doc = "IP addresses associated with azure firewall."]
    #[serde(rename = "hubIPAddresses", default, skip_serializing_if = "Option::is_none")]
    pub hub_ip_addresses: Option<HubIpAddresses>,
    #[doc = "List of IpGroups associated with azure firewall."]
    #[serde(rename = "ipGroups", default, skip_serializing_if = "Option::is_none")]
    pub ip_groups: Option<IpGroups>,
    #[doc = "SKU of an Azure Firewall."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<AzureFirewallSku>,
    #[doc = "The additional properties of azure firewall."]
    #[serde(rename = "additionalProperties", default, skip_serializing_if = "Option::is_none")]
    pub additional_properties: Option<AzureFirewallAdditionalProperties>,
}
impl AzureFirewallPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Public IP Address associated with azure firewall."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallPublicIpAddress {
    #[doc = "Public IP Address value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
}
impl AzureFirewallPublicIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the AzureFirewallRCAction."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallRcAction {
    #[doc = "The action type of a rule collection."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<AzureFirewallRcActionType>,
}
impl AzureFirewallRcAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The action type of a rule collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallRcActionType {
    Allow,
    Deny,
}
#[doc = "SKU of an Azure Firewall."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallSku {
    #[doc = "Name of an Azure Firewall SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<azure_firewall_sku::Name>,
    #[doc = "Tier of an Azure Firewall."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<azure_firewall_sku::Tier>,
}
impl AzureFirewallSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_firewall_sku {
    use super::*;
    #[doc = "Name of an Azure Firewall SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "AZFW_VNet")]
        AzfwVNet,
        #[serde(rename = "AZFW_Hub")]
        AzfwHub,
    }
    #[doc = "Tier of an Azure Firewall."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        Premium,
        Basic,
    }
}
#[doc = "The operation mode for Threat Intel."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallThreatIntelMode {
    Alert,
    Deny,
    Off,
}
#[doc = "Azure reachability report details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureReachabilityReport {
    #[doc = "The aggregation level of Azure reachability report. Can be Country, State or City."]
    #[serde(rename = "aggregationLevel")]
    pub aggregation_level: String,
    #[doc = "Parameters that define a geographic location."]
    #[serde(rename = "providerLocation")]
    pub provider_location: AzureReachabilityReportLocation,
    #[doc = "List of Azure reachability report items."]
    #[serde(rename = "reachabilityReport")]
    pub reachability_report: Vec<AzureReachabilityReportItem>,
}
impl AzureReachabilityReport {
    pub fn new(
        aggregation_level: String,
        provider_location: AzureReachabilityReportLocation,
        reachability_report: Vec<AzureReachabilityReportItem>,
    ) -> Self {
        Self {
            aggregation_level,
            provider_location,
            reachability_report,
        }
    }
}
#[doc = "Azure reachability report details for a given provider location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureReachabilityReportItem {
    #[doc = "The Internet service provider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "The Azure region."]
    #[serde(rename = "azureLocation", default, skip_serializing_if = "Option::is_none")]
    pub azure_location: Option<String>,
    #[doc = "List of latency details for each of the time series."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub latencies: Vec<AzureReachabilityReportLatencyInfo>,
}
impl AzureReachabilityReportItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details on latency for a time series."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureReachabilityReportLatencyInfo {
    #[doc = "The time stamp."]
    #[serde(rename = "timeStamp", default, skip_serializing_if = "Option::is_none")]
    pub time_stamp: Option<String>,
    #[doc = "The relative latency score between 1 and 100, higher values indicating a faster connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub score: Option<i32>,
}
impl AzureReachabilityReportLatencyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define a geographic location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureReachabilityReportLocation {
    #[doc = "The name of the country."]
    pub country: String,
    #[doc = "The name of the state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The name of the city or town."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
}
impl AzureReachabilityReportLocation {
    pub fn new(country: String) -> Self {
        Self {
            country,
            state: None,
            city: None,
        }
    }
}
#[doc = "Geographic and time constraints for Azure reachability report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureReachabilityReportParameters {
    #[doc = "Parameters that define a geographic location."]
    #[serde(rename = "providerLocation")]
    pub provider_location: AzureReachabilityReportLocation,
    #[doc = "List of Internet service providers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
    #[doc = "Optional Azure regions to scope the query to."]
    #[serde(rename = "azureLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_locations: Vec<String>,
    #[doc = "The start time for the Azure reachability report."]
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[doc = "The end time for the Azure reachability report."]
    #[serde(rename = "endTime")]
    pub end_time: String,
}
impl AzureReachabilityReportParameters {
    pub fn new(provider_location: AzureReachabilityReportLocation, start_time: String, end_time: String) -> Self {
        Self {
            provider_location,
            providers: Vec::new(),
            azure_locations: Vec::new(),
            start_time,
            end_time,
        }
    }
}
#[doc = "Azure Web Category Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWebCategory {
    #[doc = "Azure Web Category Properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureWebCategoryPropertiesFormat>,
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureWebCategory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListAzureWebCategories API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWebCategoryListResult {
    #[doc = "List of Azure Web Categories for a given Subscription."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AzureWebCategory>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AzureWebCategoryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Web Category Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureWebCategoryPropertiesFormat {
    #[doc = "The name of the group that the category belongs to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub group: Option<String>,
}
impl AzureWebCategoryPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains bgp community information offered in Service Community resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpCommunity {
    #[doc = "The region which the service support. e.g. For O365, region is Global."]
    #[serde(rename = "serviceSupportedRegion", default, skip_serializing_if = "Option::is_none")]
    pub service_supported_region: Option<String>,
    #[doc = "The name of the bgp community. e.g. Skype."]
    #[serde(rename = "communityName", default, skip_serializing_if = "Option::is_none")]
    pub community_name: Option<String>,
    #[doc = "The value of the bgp community. For more information: https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing."]
    #[serde(rename = "communityValue", default, skip_serializing_if = "Option::is_none")]
    pub community_value: Option<String>,
    #[doc = "The prefixes that the bgp community contains."]
    #[serde(rename = "communityPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub community_prefixes: Vec<String>,
    #[doc = "Customer is authorized to use bgp community or not."]
    #[serde(rename = "isAuthorizedToUse", default, skip_serializing_if = "Option::is_none")]
    pub is_authorized_to_use: Option<bool>,
    #[doc = "The service group of the bgp community contains."]
    #[serde(rename = "serviceGroup", default, skip_serializing_if = "Option::is_none")]
    pub service_group: Option<String>,
}
impl BgpCommunity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response for a QueryInboundNatRulePortMapping API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressInboundNatRulePortMappings {
    #[doc = "Collection of inbound NAT rule port mappings."]
    #[serde(rename = "inboundNatRulePortMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rule_port_mappings: Vec<InboundNatRulePortMapping>,
}
impl BackendAddressInboundNatRulePortMappings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Pool of backend IP addresses."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the backend address pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackendAddressPoolPropertiesFormat>,
    #[doc = "The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl BackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the backend address pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPoolPropertiesFormat {
    #[doc = "The location of the backend address pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "An array of gateway load balancer tunnel interfaces."]
    #[serde(rename = "tunnelInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_interfaces: Vec<GatewayLoadBalancerTunnelInterface>,
    #[doc = "An array of backend addresses."]
    #[serde(rename = "loadBalancerBackendAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_addresses: Vec<LoadBalancerBackendAddress>,
    #[doc = "An array of references to IP addresses defined in network interfaces."]
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "An array of references to load balancing rules that use this backend address pool."]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "outboundRule", default, skip_serializing_if = "Option::is_none")]
    pub outbound_rule: Option<SubResource>,
    #[doc = "An array of references to outbound rules that use this backend address pool."]
    #[serde(rename = "outboundRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_rules: Vec<SubResource>,
    #[doc = "An array of references to inbound NAT rules that use this backend address pool."]
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl BackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network base admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseAdminRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Whether the rule is custom or default."]
    pub kind: base_admin_rule::Kind,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl BaseAdminRule {
    pub fn new(kind: base_admin_rule::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
            system_data: None,
        }
    }
}
pub mod base_admin_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "Network base rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseUserRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Whether the rule is custom or default."]
    pub kind: base_user_rule::Kind,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl BaseUserRule {
    pub fn new(kind: base_user_rule::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
            system_data: None,
        }
    }
}
pub mod base_user_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "The session detail for a target."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionActiveSession {
    #[doc = "A unique id for the session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[doc = "The time when the session started."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<serde_json::Value>,
    #[doc = "The subscription id for the target virtual machine."]
    #[serde(rename = "targetSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub target_subscription_id: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[doc = "The host name of the target."]
    #[serde(rename = "targetHostName", default, skip_serializing_if = "Option::is_none")]
    pub target_host_name: Option<String>,
    #[doc = "The resource group of the target."]
    #[serde(rename = "targetResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group: Option<String>,
    #[doc = "The user name who is active on this session."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[doc = "The IP Address of the target."]
    #[serde(rename = "targetIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub target_ip_address: Option<String>,
    #[doc = "The protocol used to connect to the target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<bastion_active_session::Protocol>,
    #[doc = "The resource id of the target."]
    #[serde(rename = "targetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_id: Option<String>,
    #[doc = "Duration in mins the session has been active."]
    #[serde(rename = "sessionDurationInMins", default, skip_serializing_if = "Option::is_none")]
    pub session_duration_in_mins: Option<f64>,
}
impl BastionActiveSession {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bastion_active_session {
    use super::*;
    #[doc = "The protocol used to connect to the target."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "SSH")]
        Ssh,
        #[serde(rename = "RDP")]
        Rdp,
    }
}
#[doc = "Response for GetActiveSessions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionActiveSessionListResult {
    #[doc = "List of active sessions on the bastion."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BastionActiveSession>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BastionActiveSessionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Bastion Host resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionHost {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the Bastion Host."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BastionHostPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The sku of this Bastion Host."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
}
impl BastionHost {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP configuration of an Bastion Host."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionHostIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration of an Bastion Host."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BastionHostIpConfigurationPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Ip configuration type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl BastionHostIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration of an Bastion Host."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BastionHostIpConfigurationPropertiesFormat {
    #[doc = "Reference to another subresource."]
    pub subnet: SubResource,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "publicIPAddress")]
    pub public_ip_address: SubResource,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "IP address allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
}
impl BastionHostIpConfigurationPropertiesFormat {
    pub fn new(subnet: SubResource, public_ip_address: SubResource) -> Self {
        Self {
            subnet,
            public_ip_address,
            provisioning_state: None,
            private_ip_allocation_method: None,
        }
    }
}
#[doc = "Response for ListBastionHosts API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionHostListResult {
    #[doc = "List of Bastion Hosts in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BastionHost>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BastionHostListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the Bastion Host."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionHostPropertiesFormat {
    #[doc = "IP configuration of the Bastion Host resource."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<BastionHostIpConfiguration>,
    #[doc = "FQDN for the endpoint on which bastion host is accessible."]
    #[serde(rename = "dnsName", default, skip_serializing_if = "Option::is_none")]
    pub dns_name: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The scale units for the Bastion Host resource."]
    #[serde(rename = "scaleUnits", default, skip_serializing_if = "Option::is_none")]
    pub scale_units: Option<i32>,
    #[doc = "Enable/Disable Copy/Paste feature of the Bastion Host resource."]
    #[serde(rename = "disableCopyPaste", default, skip_serializing_if = "Option::is_none")]
    pub disable_copy_paste: Option<bool>,
    #[doc = "Enable/Disable File Copy feature of the Bastion Host resource."]
    #[serde(rename = "enableFileCopy", default, skip_serializing_if = "Option::is_none")]
    pub enable_file_copy: Option<bool>,
    #[doc = "Enable/Disable IP Connect feature of the Bastion Host resource."]
    #[serde(rename = "enableIpConnect", default, skip_serializing_if = "Option::is_none")]
    pub enable_ip_connect: Option<bool>,
    #[doc = "Enable/Disable Shareable Link of the Bastion Host resource."]
    #[serde(rename = "enableShareableLink", default, skip_serializing_if = "Option::is_none")]
    pub enable_shareable_link: Option<bool>,
    #[doc = "Enable/Disable Tunneling feature of the Bastion Host resource."]
    #[serde(rename = "enableTunneling", default, skip_serializing_if = "Option::is_none")]
    pub enable_tunneling: Option<bool>,
}
impl BastionHostPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for DisconnectActiveSessions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionSessionDeleteResult {
    #[doc = "List of sessions with their corresponding state."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BastionSessionState>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BastionSessionDeleteResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The session state detail for a target."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionSessionState {
    #[doc = "A unique id for the session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[doc = "Used for extra information."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The state of the session. Disconnected/Failed/NotFound."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}
impl BastionSessionState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Bastion Shareable Link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BastionShareableLink {
    #[doc = "Describes a Virtual Machine."]
    pub vm: Vm,
    #[doc = "The unique Bastion Shareable Link to the virtual machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub bsl: Option<String>,
    #[doc = "The time when the link was created."]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "Optional field indicating the warning or error message related to the vm in case of partial failure."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl BastionShareableLink {
    pub fn new(vm: Vm) -> Self {
        Self {
            vm,
            bsl: None,
            created_at: None,
            message: None,
        }
    }
}
#[doc = "Post request for all the Bastion Shareable Link endpoints."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionShareableLinkListRequest {
    #[doc = "List of VM references."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub vms: Vec<BastionShareableLink>,
}
impl BastionShareableLinkListRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for all the Bastion Shareable Link endpoints."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionShareableLinkListResult {
    #[doc = "List of Bastion Shareable Links for the request."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BastionShareableLink>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BastionShareableLinkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Appliance Site resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the bgp connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BgpConnectionProperties>,
    #[doc = "Name of the connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Connection type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl BgpConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the bgp connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpConnectionProperties {
    #[doc = "Peer ASN."]
    #[serde(rename = "peerAsn", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[doc = "Peer IP."]
    #[serde(rename = "peerIp", default, skip_serializing_if = "Option::is_none")]
    pub peer_ip: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "hubVirtualNetworkConnection", default, skip_serializing_if = "Option::is_none")]
    pub hub_virtual_network_connection: Option<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The current state of the VirtualHub to Peer."]
    #[serde(rename = "connectionState", default, skip_serializing_if = "Option::is_none")]
    pub connection_state: Option<bgp_connection_properties::ConnectionState>,
}
impl BgpConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bgp_connection_properties {
    use super::*;
    #[doc = "The current state of the VirtualHub to Peer."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionState {
        Unknown,
        Connecting,
        Connected,
        NotConnected,
    }
}
#[doc = "BGP peer status details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpPeerStatus {
    #[doc = "The virtual network gateway's local address."]
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[doc = "The remote BGP peer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[doc = "The autonomous system number of the remote BGP peer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i64>,
    #[doc = "The BGP peer state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<bgp_peer_status::State>,
    #[doc = "For how long the peering has been up."]
    #[serde(rename = "connectedDuration", default, skip_serializing_if = "Option::is_none")]
    pub connected_duration: Option<String>,
    #[doc = "The number of routes learned from this peer."]
    #[serde(rename = "routesReceived", default, skip_serializing_if = "Option::is_none")]
    pub routes_received: Option<i64>,
    #[doc = "The number of BGP messages sent."]
    #[serde(rename = "messagesSent", default, skip_serializing_if = "Option::is_none")]
    pub messages_sent: Option<i64>,
    #[doc = "The number of BGP messages received."]
    #[serde(rename = "messagesReceived", default, skip_serializing_if = "Option::is_none")]
    pub messages_received: Option<i64>,
}
impl BgpPeerStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bgp_peer_status {
    use super::*;
    #[doc = "The BGP peer state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Unknown,
        Stopped,
        Idle,
        Connecting,
        Connected,
    }
}
#[doc = "Response for list BGP peer status API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpPeerStatusListResult {
    #[doc = "List of BGP peers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BgpPeerStatus>,
}
impl BgpPeerStatusListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Service Community Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpServiceCommunity {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of Service Community."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BgpServiceCommunityPropertiesFormat>,
}
impl BgpServiceCommunity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListServiceCommunity API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpServiceCommunityListResult {
    #[doc = "A list of service community resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BgpServiceCommunity>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BgpServiceCommunityListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Service Community."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpServiceCommunityPropertiesFormat {
    #[doc = "The name of the bgp community. e.g. Skype."]
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[doc = "A list of bgp communities."]
    #[serde(rename = "bgpCommunities", default, skip_serializing_if = "Vec::is_empty")]
    pub bgp_communities: Vec<BgpCommunity>,
}
impl BgpServiceCommunityPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "BGP settings details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpSettings {
    #[doc = "The BGP speaker's ASN."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i64>,
    #[doc = "The BGP peering address and BGP identifier of this BGP speaker."]
    #[serde(rename = "bgpPeeringAddress", default, skip_serializing_if = "Option::is_none")]
    pub bgp_peering_address: Option<String>,
    #[doc = "The weight added to routes learned from this BGP speaker."]
    #[serde(rename = "peerWeight", default, skip_serializing_if = "Option::is_none")]
    pub peer_weight: Option<i32>,
    #[doc = "BGP peering address with IP configuration ID for virtual network gateway."]
    #[serde(rename = "bgpPeeringAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub bgp_peering_addresses: Vec<IpConfigurationBgpPeeringAddress>,
}
impl BgpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Virtual Appliance Sku Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BreakOutCategoryPolicies {
    #[doc = "Flag to control breakout of o365 allow category."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub allow: Option<bool>,
    #[doc = "Flag to control breakout of o365 optimize category."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub optimize: Option<bool>,
    #[doc = "Flag to control breakout of o365 default category."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<bool>,
}
impl BreakOutCategoryPolicies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request body of the CheckPrivateLinkServiceVisibility API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckPrivateLinkServiceVisibilityRequest {
    #[doc = "The alias of the private link service."]
    #[serde(rename = "privateLinkServiceAlias", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_alias: Option<String>,
}
impl CheckPrivateLinkServiceVisibilityRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Ssl cipher suites enums."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CipherSuitesEnum {
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384")]
    TlsEcdheRsaWithAes256CbcSha384,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256")]
    TlsEcdheRsaWithAes128CbcSha256,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA")]
    TlsEcdheRsaWithAes256CbcSha,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA")]
    TlsEcdheRsaWithAes128CbcSha,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384")]
    TlsDheRsaWithAes256GcmSha384,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256")]
    TlsDheRsaWithAes128GcmSha256,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_256_CBC_SHA")]
    TlsDheRsaWithAes256CbcSha,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA")]
    TlsDheRsaWithAes128CbcSha,
    #[serde(rename = "TLS_RSA_WITH_AES_256_GCM_SHA384")]
    TlsRsaWithAes256GcmSha384,
    #[serde(rename = "TLS_RSA_WITH_AES_128_GCM_SHA256")]
    TlsRsaWithAes128GcmSha256,
    #[serde(rename = "TLS_RSA_WITH_AES_256_CBC_SHA256")]
    TlsRsaWithAes256CbcSha256,
    #[serde(rename = "TLS_RSA_WITH_AES_128_CBC_SHA256")]
    TlsRsaWithAes128CbcSha256,
    #[serde(rename = "TLS_RSA_WITH_AES_256_CBC_SHA")]
    TlsRsaWithAes256CbcSha,
    #[serde(rename = "TLS_RSA_WITH_AES_128_CBC_SHA")]
    TlsRsaWithAes128CbcSha,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384")]
    TlsEcdheEcdsaWithAes256GcmSha384,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256")]
    TlsEcdheEcdsaWithAes128GcmSha256,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384")]
    TlsEcdheEcdsaWithAes256CbcSha384,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256")]
    TlsEcdheEcdsaWithAes128CbcSha256,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA")]
    TlsEcdheEcdsaWithAes256CbcSha,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA")]
    TlsEcdheEcdsaWithAes128CbcSha,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256")]
    TlsDheDssWithAes256CbcSha256,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256")]
    TlsDheDssWithAes128CbcSha256,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA")]
    TlsDheDssWithAes256CbcSha,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA")]
    TlsDheDssWithAes128CbcSha,
    #[serde(rename = "TLS_RSA_WITH_3DES_EDE_CBC_SHA")]
    TlsRsaWith3desEdeCbcSha,
    #[serde(rename = "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA")]
    TlsDheDssWith3desEdeCbcSha,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256")]
    TlsEcdheRsaWithAes128GcmSha256,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384")]
    TlsEcdheRsaWithAes256GcmSha384,
}
#[doc = "Express Route Circuit connection state."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CircuitConnectionStatus {
    Connected,
    Connecting,
    Disconnected,
}
#[doc = "An error response from the service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "An error response from the service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response from the service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "An identifier for the error. Codes are invariant and are intended to be consumed programmatically."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "A message describing the error, intended to be suitable for display in a user interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The target of the particular error. For example, the name of the property in error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "A list of additional details about the error."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The network configuration group resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConfigurationGroup {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Properties of network group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkGroupProperties>,
}
impl ConfigurationGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configuration Deployment Type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConfigurationType {
    SecurityAdmin,
    SecurityUser,
    Connectivity,
}
#[doc = "Parameters that define the operation to create a connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitor {
    #[doc = "Connection monitor location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Connection monitor tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Parameters that define the operation to create a connection monitor."]
    pub properties: ConnectionMonitorParameters,
}
impl ConnectionMonitor {
    pub fn new(properties: ConnectionMonitorParameters) -> Self {
        Self {
            location: None,
            tags: None,
            properties,
        }
    }
}
#[doc = "Describes the destination of connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorDestination {
    #[doc = "The ID of the resource used as the destination by connection monitor."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "Address of the connection monitor destination (IP or domain name)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "The destination port used by connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl ConnectionMonitorDestination {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the connection monitor endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorEndpoint {
    #[doc = "The name of the connection monitor endpoint."]
    pub name: String,
    #[doc = "The endpoint type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connection_monitor_endpoint::Type>,
    #[doc = "Resource ID of the connection monitor endpoint."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "Address of the connection monitor endpoint (IP or domain name)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "Describes the connection monitor endpoint filter."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<ConnectionMonitorEndpointFilter>,
    #[doc = "Describes the connection monitor endpoint scope."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<ConnectionMonitorEndpointScope>,
    #[doc = "Test coverage for the endpoint."]
    #[serde(rename = "coverageLevel", default, skip_serializing_if = "Option::is_none")]
    pub coverage_level: Option<connection_monitor_endpoint::CoverageLevel>,
}
impl ConnectionMonitorEndpoint {
    pub fn new(name: String) -> Self {
        Self {
            name,
            type_: None,
            resource_id: None,
            address: None,
            filter: None,
            scope: None,
            coverage_level: None,
        }
    }
}
pub mod connection_monitor_endpoint {
    use super::*;
    #[doc = "The endpoint type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "AzureVM")]
        AzureVm,
        AzureVNet,
        AzureSubnet,
        ExternalAddress,
        #[serde(rename = "MMAWorkspaceMachine")]
        MmaWorkspaceMachine,
        #[serde(rename = "MMAWorkspaceNetwork")]
        MmaWorkspaceNetwork,
    }
    #[doc = "Test coverage for the endpoint."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CoverageLevel {
        Default,
        Low,
        BelowAverage,
        Average,
        AboveAverage,
        Full,
    }
}
#[doc = "Describes the connection monitor endpoint filter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorEndpointFilter {
    #[doc = "The behavior of the endpoint filter. Currently only 'Include' is supported."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connection_monitor_endpoint_filter::Type>,
    #[doc = "List of items in the filter."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub items: Vec<ConnectionMonitorEndpointFilterItem>,
}
impl ConnectionMonitorEndpointFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_endpoint_filter {
    use super::*;
    #[doc = "The behavior of the endpoint filter. Currently only 'Include' is supported."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Include,
    }
}
#[doc = "Describes the connection monitor endpoint filter item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorEndpointFilterItem {
    #[doc = "The type of item included in the filter. Currently only 'AgentAddress' is supported."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connection_monitor_endpoint_filter_item::Type>,
    #[doc = "The address of the filter item."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
}
impl ConnectionMonitorEndpointFilterItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_endpoint_filter_item {
    use super::*;
    #[doc = "The type of item included in the filter. Currently only 'AgentAddress' is supported."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        AgentAddress,
    }
}
#[doc = "Describes the connection monitor endpoint scope."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorEndpointScope {
    #[doc = "List of items which needs to be included to the endpoint scope."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub include: Vec<ConnectionMonitorEndpointScopeItem>,
    #[doc = "List of items which needs to be excluded from the endpoint scope."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub exclude: Vec<ConnectionMonitorEndpointScopeItem>,
}
impl ConnectionMonitorEndpointScope {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the connection monitor endpoint scope item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorEndpointScopeItem {
    #[doc = "The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
}
impl ConnectionMonitorEndpointScopeItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the HTTP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorHttpConfiguration {
    #[doc = "The port to connect to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "The HTTP method to use."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<connection_monitor_http_configuration::Method>,
    #[doc = "The path component of the URI. For instance, \"/dir1/dir2\"."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "The HTTP headers to transmit with the request."]
    #[serde(rename = "requestHeaders", default, skip_serializing_if = "Vec::is_empty")]
    pub request_headers: Vec<HttpHeader>,
    #[doc = "HTTP status codes to consider successful. For instance, \"2xx,301-304,418\"."]
    #[serde(rename = "validStatusCodeRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub valid_status_code_ranges: Vec<String>,
    #[doc = "Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit."]
    #[serde(rename = "preferHTTPS", default, skip_serializing_if = "Option::is_none")]
    pub prefer_https: Option<bool>,
}
impl ConnectionMonitorHttpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_http_configuration {
    use super::*;
    #[doc = "The HTTP method to use."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Method {
        Get,
        Post,
    }
}
#[doc = "Describes the ICMP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorIcmpConfiguration {
    #[doc = "Value indicating whether path evaluation with trace route should be disabled."]
    #[serde(rename = "disableTraceRoute", default, skip_serializing_if = "Option::is_none")]
    pub disable_trace_route: Option<bool>,
}
impl ConnectionMonitorIcmpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of connection monitors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorListResult {
    #[doc = "Information about connection monitors."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConnectionMonitorResult>,
}
impl ConnectionMonitorListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes a connection monitor output destination."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorOutput {
    #[doc = "Connection monitor output destination type. Currently, only \"Workspace\" is supported."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connection_monitor_output::Type>,
    #[doc = "Describes the settings for producing output into a log analytics workspace."]
    #[serde(rename = "workspaceSettings", default, skip_serializing_if = "Option::is_none")]
    pub workspace_settings: Option<ConnectionMonitorWorkspaceSettings>,
}
impl ConnectionMonitorOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_output {
    use super::*;
    #[doc = "Connection monitor output destination type. Currently, only \"Workspace\" is supported."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Workspace,
    }
}
#[doc = "Parameters that define the operation to create a connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorParameters {
    #[doc = "Describes the source of connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<ConnectionMonitorSource>,
    #[doc = "Describes the destination of connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub destination: Option<ConnectionMonitorDestination>,
    #[doc = "Determines if the connection monitor will start automatically once created."]
    #[serde(rename = "autoStart", default, skip_serializing_if = "Option::is_none")]
    pub auto_start: Option<bool>,
    #[doc = "Monitoring interval in seconds."]
    #[serde(rename = "monitoringIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_interval_in_seconds: Option<i32>,
    #[doc = "List of connection monitor endpoints."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<ConnectionMonitorEndpoint>,
    #[doc = "List of connection monitor test configurations."]
    #[serde(rename = "testConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub test_configurations: Vec<ConnectionMonitorTestConfiguration>,
    #[doc = "List of connection monitor test groups."]
    #[serde(rename = "testGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub test_groups: Vec<ConnectionMonitorTestGroup>,
    #[doc = "List of connection monitor outputs."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub outputs: Vec<ConnectionMonitorOutput>,
    #[doc = "Optional notes to be associated with the connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
}
impl ConnectionMonitorParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of connection states snapshots."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorQueryResult {
    #[doc = "Status of connection monitor source."]
    #[serde(rename = "sourceStatus", default, skip_serializing_if = "Option::is_none")]
    pub source_status: Option<connection_monitor_query_result::SourceStatus>,
    #[doc = "Information about connection states."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub states: Vec<ConnectionStateSnapshot>,
}
impl ConnectionMonitorQueryResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_query_result {
    use super::*;
    #[doc = "Status of connection monitor source."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceStatus {
        Unknown,
        Active,
        Inactive,
    }
}
#[doc = "Information about the connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorResult {
    #[doc = "Name of the connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "ID of the connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Connection monitor type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Connection monitor location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Connection monitor tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Describes the properties of a connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectionMonitorResultProperties>,
}
impl ConnectionMonitorResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorResultProperties {
    #[serde(flatten)]
    pub connection_monitor_parameters: ConnectionMonitorParameters,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The date and time when the connection monitor was started."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The monitoring status of the connection monitor."]
    #[serde(rename = "monitoringStatus", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_status: Option<String>,
    #[doc = "Type of connection monitor."]
    #[serde(rename = "connectionMonitorType", default, skip_serializing_if = "Option::is_none")]
    pub connection_monitor_type: Option<connection_monitor_result_properties::ConnectionMonitorType>,
}
impl ConnectionMonitorResultProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_result_properties {
    use super::*;
    #[doc = "Type of connection monitor."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionMonitorType {
        MultiEndpoint,
        SingleSourceDestination,
    }
}
#[doc = "Describes the source of connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorSource {
    #[doc = "The ID of the resource used as the source by connection monitor."]
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[doc = "The source port used by connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl ConnectionMonitorSource {
    pub fn new(resource_id: String) -> Self {
        Self { resource_id, port: None }
    }
}
#[doc = "Describes the threshold for declaring a test successful."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorSuccessThreshold {
    #[doc = "The maximum percentage of failed checks permitted for a test to evaluate as successful."]
    #[serde(rename = "checksFailedPercent", default, skip_serializing_if = "Option::is_none")]
    pub checks_failed_percent: Option<i32>,
    #[doc = "The maximum round-trip time in milliseconds permitted for a test to evaluate as successful."]
    #[serde(rename = "roundTripTimeMs", default, skip_serializing_if = "Option::is_none")]
    pub round_trip_time_ms: Option<f64>,
}
impl ConnectionMonitorSuccessThreshold {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the TCP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorTcpConfiguration {
    #[doc = "The port to connect to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "Value indicating whether path evaluation with trace route should be disabled."]
    #[serde(rename = "disableTraceRoute", default, skip_serializing_if = "Option::is_none")]
    pub disable_trace_route: Option<bool>,
    #[doc = "Destination port behavior."]
    #[serde(rename = "destinationPortBehavior", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_behavior: Option<connection_monitor_tcp_configuration::DestinationPortBehavior>,
}
impl ConnectionMonitorTcpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_tcp_configuration {
    use super::*;
    #[doc = "Destination port behavior."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DestinationPortBehavior {
        None,
        ListenIfAvailable,
    }
}
#[doc = "Describes a connection monitor test configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorTestConfiguration {
    #[doc = "The name of the connection monitor test configuration."]
    pub name: String,
    #[doc = "The frequency of test evaluation, in seconds."]
    #[serde(rename = "testFrequencySec", default, skip_serializing_if = "Option::is_none")]
    pub test_frequency_sec: Option<i32>,
    #[doc = "The protocol to use in test evaluation."]
    pub protocol: connection_monitor_test_configuration::Protocol,
    #[doc = "The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters."]
    #[serde(rename = "preferredIPVersion", default, skip_serializing_if = "Option::is_none")]
    pub preferred_ip_version: Option<connection_monitor_test_configuration::PreferredIpVersion>,
    #[doc = "Describes the HTTP configuration."]
    #[serde(rename = "httpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub http_configuration: Option<ConnectionMonitorHttpConfiguration>,
    #[doc = "Describes the TCP configuration."]
    #[serde(rename = "tcpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub tcp_configuration: Option<ConnectionMonitorTcpConfiguration>,
    #[doc = "Describes the ICMP configuration."]
    #[serde(rename = "icmpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub icmp_configuration: Option<ConnectionMonitorIcmpConfiguration>,
    #[doc = "Describes the threshold for declaring a test successful."]
    #[serde(rename = "successThreshold", default, skip_serializing_if = "Option::is_none")]
    pub success_threshold: Option<ConnectionMonitorSuccessThreshold>,
}
impl ConnectionMonitorTestConfiguration {
    pub fn new(name: String, protocol: connection_monitor_test_configuration::Protocol) -> Self {
        Self {
            name,
            test_frequency_sec: None,
            protocol,
            preferred_ip_version: None,
            http_configuration: None,
            tcp_configuration: None,
            icmp_configuration: None,
            success_threshold: None,
        }
    }
}
pub mod connection_monitor_test_configuration {
    use super::*;
    #[doc = "The protocol to use in test evaluation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Http,
        Icmp,
    }
    #[doc = "The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreferredIpVersion {
        IPv4,
        IPv6,
    }
}
#[doc = "Describes the connection monitor test group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorTestGroup {
    #[doc = "The name of the connection monitor test group."]
    pub name: String,
    #[doc = "Value indicating whether test group is disabled."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disable: Option<bool>,
    #[doc = "List of test configuration names."]
    #[serde(rename = "testConfigurations")]
    pub test_configurations: Vec<String>,
    #[doc = "List of source endpoint names."]
    pub sources: Vec<String>,
    #[doc = "List of destination endpoint names."]
    pub destinations: Vec<String>,
}
impl ConnectionMonitorTestGroup {
    pub fn new(name: String, test_configurations: Vec<String>, sources: Vec<String>, destinations: Vec<String>) -> Self {
        Self {
            name,
            disable: None,
            test_configurations,
            sources,
            destinations,
        }
    }
}
#[doc = "Describes the settings for producing output into a log analytics workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorWorkspaceSettings {
    #[doc = "Log analytics workspace resource ID."]
    #[serde(rename = "workspaceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_resource_id: Option<String>,
}
impl ConnectionMonitorWorkspaceSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Gateway connection protocol."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConnectionProtocol {
    #[serde(rename = "IKEv2")]
    IkEv2,
    #[serde(rename = "IKEv1")]
    IkEv1,
}
#[doc = "The virtual network connection reset shared key."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionResetSharedKey {
    #[doc = "The virtual network connection reset shared key length, should between 1 and 128."]
    #[serde(rename = "keyLength")]
    pub key_length: i32,
}
impl ConnectionResetSharedKey {
    pub fn new(key_length: i32) -> Self {
        Self { key_length }
    }
}
#[doc = "Response for GetConnectionSharedKey API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionSharedKey {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "The virtual network connection shared key value."]
    pub value: String,
}
impl ConnectionSharedKey {
    pub fn new(value: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            value,
        }
    }
}
#[doc = "The current scope connection state."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConnectionState {
    Connected,
    Pending,
    Conflict,
    Revoked,
    Rejected,
}
#[doc = "Connection state snapshot."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionStateSnapshot {
    #[doc = "The connection state."]
    #[serde(rename = "connectionState", default, skip_serializing_if = "Option::is_none")]
    pub connection_state: Option<connection_state_snapshot::ConnectionState>,
    #[doc = "The start time of the connection snapshot."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time of the connection snapshot."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "Connectivity analysis evaluation state."]
    #[serde(rename = "evaluationState", default, skip_serializing_if = "Option::is_none")]
    pub evaluation_state: Option<connection_state_snapshot::EvaluationState>,
    #[doc = "Average latency in ms."]
    #[serde(rename = "avgLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub avg_latency_in_ms: Option<i64>,
    #[doc = "Minimum latency in ms."]
    #[serde(rename = "minLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub min_latency_in_ms: Option<i64>,
    #[doc = "Maximum latency in ms."]
    #[serde(rename = "maxLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub max_latency_in_ms: Option<i64>,
    #[doc = "The number of sent probes."]
    #[serde(rename = "probesSent", default, skip_serializing_if = "Option::is_none")]
    pub probes_sent: Option<i64>,
    #[doc = "The number of failed probes."]
    #[serde(rename = "probesFailed", default, skip_serializing_if = "Option::is_none")]
    pub probes_failed: Option<i64>,
    #[doc = "List of hops between the source and the destination."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hops: Vec<ConnectivityHop>,
}
impl ConnectionStateSnapshot {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_state_snapshot {
    use super::*;
    #[doc = "The connection state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionState {
        Reachable,
        Unreachable,
        Unknown,
    }
    #[doc = "Connectivity analysis evaluation state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EvaluationState {
        NotStarted,
        InProgress,
        Completed,
    }
}
#[doc = "The network manager connectivity configuration resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityConfiguration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of network manager connectivity configuration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectivityConfigurationProperties>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ConnectivityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list network manager connectivity configurations. It contains a list of configurations and a link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityConfigurationListResult {
    #[doc = "Gets a page of Connectivity Configurations"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConnectivityConfiguration>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ConnectivityConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of network manager connectivity configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivityConfigurationProperties {
    #[doc = "A friendly name for the resource."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the connectivity configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Connectivity topology type."]
    #[serde(rename = "connectivityTopology")]
    pub connectivity_topology: connectivity_configuration_properties::ConnectivityTopology,
    #[doc = "List of hubItems"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hubs: Vec<Hub>,
    #[doc = "Flag if global mesh is supported."]
    #[serde(rename = "isGlobal", default, skip_serializing_if = "Option::is_none")]
    pub is_global: Option<connectivity_configuration_properties::IsGlobal>,
    #[doc = "Groups for configuration"]
    #[serde(rename = "appliesToGroups")]
    pub applies_to_groups: Vec<ConnectivityGroupItem>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Flag if need to remove current existing peerings."]
    #[serde(rename = "deleteExistingPeering", default, skip_serializing_if = "Option::is_none")]
    pub delete_existing_peering: Option<connectivity_configuration_properties::DeleteExistingPeering>,
}
impl ConnectivityConfigurationProperties {
    pub fn new(
        connectivity_topology: connectivity_configuration_properties::ConnectivityTopology,
        applies_to_groups: Vec<ConnectivityGroupItem>,
    ) -> Self {
        Self {
            display_name: None,
            description: None,
            connectivity_topology,
            hubs: Vec::new(),
            is_global: None,
            applies_to_groups,
            provisioning_state: None,
            delete_existing_peering: None,
        }
    }
}
pub mod connectivity_configuration_properties {
    use super::*;
    #[doc = "Connectivity topology type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectivityTopology {
        HubAndSpoke,
        Mesh,
    }
    #[doc = "Flag if global mesh is supported."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IsGlobal {
        False,
        True,
    }
    #[doc = "Flag if need to remove current existing peerings."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeleteExistingPeering {
        False,
        True,
    }
}
#[doc = "Parameters that define destination of connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityDestination {
    #[doc = "The ID of the resource to which a connection attempt will be made."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "The IP address or URI the resource to which a connection attempt will be made."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "Port on which check connectivity will be performed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl ConnectivityDestination {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information about a hop between the source and the destination."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityHop {
    #[doc = "The type of the hop."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The ID of the hop."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The IP address of the hop."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "The ID of the resource corresponding to this hop."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "List of next hop identifiers."]
    #[serde(rename = "nextHopIds", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hop_ids: Vec<String>,
    #[doc = "List of previous hop identifiers."]
    #[serde(rename = "previousHopIds", default, skip_serializing_if = "Vec::is_empty")]
    pub previous_hop_ids: Vec<String>,
    #[doc = "List of hop links."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub links: Vec<HopLink>,
    #[doc = "List of previous hop links."]
    #[serde(rename = "previousLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub previous_links: Vec<HopLink>,
    #[doc = "List of issues."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub issues: Vec<ConnectivityIssue>,
}
impl ConnectivityHop {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information on the connectivity status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityInformation {
    #[doc = "List of hops between the source and the destination."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hops: Vec<ConnectivityHop>,
    #[doc = "The connection status."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<connectivity_information::ConnectionStatus>,
    #[doc = "Average latency in milliseconds."]
    #[serde(rename = "avgLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub avg_latency_in_ms: Option<i32>,
    #[doc = "Minimum latency in milliseconds."]
    #[serde(rename = "minLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub min_latency_in_ms: Option<i32>,
    #[doc = "Maximum latency in milliseconds."]
    #[serde(rename = "maxLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub max_latency_in_ms: Option<i32>,
    #[doc = "Total number of probes sent."]
    #[serde(rename = "probesSent", default, skip_serializing_if = "Option::is_none")]
    pub probes_sent: Option<i32>,
    #[doc = "Number of failed probes."]
    #[serde(rename = "probesFailed", default, skip_serializing_if = "Option::is_none")]
    pub probes_failed: Option<i32>,
}
impl ConnectivityInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_information {
    use super::*;
    #[doc = "The connection status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connected,
        Disconnected,
        Degraded,
    }
}
#[doc = "Information about an issue encountered in the process of checking for connectivity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityIssue {
    #[doc = "The origin of the issue."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<connectivity_issue::Origin>,
    #[doc = "The severity of the issue."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<connectivity_issue::Severity>,
    #[doc = "The type of issue."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connectivity_issue::Type>,
    #[doc = "Provides additional context on the issue."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub context: Vec<IssueContext>,
}
impl ConnectivityIssue {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_issue {
    use super::*;
    #[doc = "The origin of the issue."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Origin {
        Local,
        Inbound,
        Outbound,
    }
    #[doc = "The severity of the issue."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Error,
        Warning,
    }
    #[doc = "The type of issue."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Unknown,
        AgentStopped,
        GuestFirewall,
        DnsResolution,
        SocketBind,
        NetworkSecurityRule,
        UserDefinedRoute,
        PortThrottled,
        Platform,
    }
}
#[doc = "Parameters that determine how the connectivity check will be performed."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivityParameters {
    #[doc = "Parameters that define the source of the connection."]
    pub source: ConnectivitySource,
    #[doc = "Parameters that define destination of connection."]
    pub destination: ConnectivityDestination,
    #[doc = "Network protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<connectivity_parameters::Protocol>,
    #[doc = "Configuration of the protocol."]
    #[serde(rename = "protocolConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub protocol_configuration: Option<ProtocolConfiguration>,
    #[doc = "IP address version."]
    #[serde(rename = "preferredIPVersion", default, skip_serializing_if = "Option::is_none")]
    pub preferred_ip_version: Option<IpVersion>,
}
impl ConnectivityParameters {
    pub fn new(source: ConnectivitySource, destination: ConnectivityDestination) -> Self {
        Self {
            source,
            destination,
            protocol: None,
            protocol_configuration: None,
            preferred_ip_version: None,
        }
    }
}
pub mod connectivity_parameters {
    use super::*;
    #[doc = "Network protocol."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Http,
        Https,
        Icmp,
    }
}
#[doc = "Parameters that define the source of the connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivitySource {
    #[doc = "The ID of the resource from which a connectivity check will be initiated."]
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[doc = "The source port from which a connectivity check will be performed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl ConnectivitySource {
    pub fn new(resource_id: String) -> Self {
        Self { resource_id, port: None }
    }
}
#[doc = "Reference to container resource in remote resource provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Container {
    #[serde(flatten)]
    pub sub_resource: SubResource,
}
impl Container {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container network interface child resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterface {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of container network interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContainerNetworkInterfacePropertiesFormat>,
    #[doc = "The name of the resource. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Sub Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ContainerNetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container network interface configuration child resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfaceConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Container network interface configuration properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContainerNetworkInterfaceConfigurationPropertiesFormat>,
    #[doc = "The name of the resource. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Sub Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ContainerNetworkInterfaceConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Container network interface configuration properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfaceConfigurationPropertiesFormat {
    #[doc = "A list of ip configurations of the container network interface configuration."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<IpConfigurationProfile>,
    #[doc = "A list of container network interfaces created from this container network interface configuration."]
    #[serde(rename = "containerNetworkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub container_network_interfaces: Vec<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ContainerNetworkInterfaceConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The ip configuration for a container network interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfaceIpConfiguration {
    #[doc = "Properties of the container network interface IP configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContainerNetworkInterfaceIpConfigurationPropertiesFormat>,
    #[doc = "The name of the resource. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Sub Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ContainerNetworkInterfaceIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the container network interface IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfaceIpConfigurationPropertiesFormat {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ContainerNetworkInterfaceIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of container network interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfacePropertiesFormat {
    #[doc = "Container network interface configuration child resource."]
    #[serde(
        rename = "containerNetworkInterfaceConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub container_network_interface_configuration: Option<ContainerNetworkInterfaceConfiguration>,
    #[doc = "Reference to container resource in remote resource provider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub container: Option<Container>,
    #[doc = "Reference to the ip configuration on this container nic."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<ContainerNetworkInterfaceIpConfiguration>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ContainerNetworkInterfacePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Cross tenant scopes."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CrossTenantScopes {
    #[doc = "Tenant ID."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "List of management groups."]
    #[serde(rename = "managementGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub management_groups: Vec<String>,
    #[doc = "List of subscriptions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subscriptions: Vec<String>,
}
impl CrossTenantScopes {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains custom Dns resolution configuration from customer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomDnsConfigPropertiesFormat {
    #[doc = "Fqdn that resolves to private endpoint ip address."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "A list of private ip addresses of the private endpoint."]
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
}
impl CustomDnsConfigPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Custom IP prefix resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomIpPrefix {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "ExtendedLocation complex type."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<ExtendedLocation>,
    #[doc = "Custom IP prefix properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Box<Option<CustomIpPrefixPropertiesFormat>>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "A list of availability zones denoting the IP allocated for the resource needs to come from."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl CustomIpPrefix {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListCustomIpPrefixes API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomIpPrefixListResult {
    #[doc = "A list of Custom IP prefixes that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CustomIpPrefix>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CustomIpPrefixListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Custom IP prefix properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomIpPrefixPropertiesFormat {
    #[doc = "The prefix range in CIDR notation. Should include the start address and the prefix length."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cidr: Option<String>,
    #[doc = "Signed message for WAN validation."]
    #[serde(rename = "signedMessage", default, skip_serializing_if = "Option::is_none")]
    pub signed_message: Option<String>,
    #[doc = "Authorization message for WAN validation."]
    #[serde(rename = "authorizationMessage", default, skip_serializing_if = "Option::is_none")]
    pub authorization_message: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "customIpPrefixParent", default, skip_serializing_if = "Option::is_none")]
    pub custom_ip_prefix_parent: Option<SubResource>,
    #[doc = "The list of all Children for IPv6 /48 CustomIpPrefix."]
    #[serde(rename = "childCustomIpPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub child_custom_ip_prefixes: Vec<SubResource>,
    #[doc = "The commissioned state of the Custom IP Prefix."]
    #[serde(rename = "commissionedState", default, skip_serializing_if = "Option::is_none")]
    pub commissioned_state: Option<custom_ip_prefix_properties_format::CommissionedState>,
    #[doc = "The list of all referenced PublicIpPrefixes."]
    #[serde(rename = "publicIpPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_prefixes: Vec<SubResource>,
    #[doc = "The resource GUID property of the custom IP prefix resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The reason why resource is in failed state."]
    #[serde(rename = "failedReason", default, skip_serializing_if = "Option::is_none")]
    pub failed_reason: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl CustomIpPrefixPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod custom_ip_prefix_properties_format {
    use super::*;
    #[doc = "The commissioned state of the Custom IP Prefix."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CommissionedState {
        Provisioning,
        Provisioned,
        Commissioning,
        Commissioned,
        Decommissioning,
        Deprovisioning,
    }
}
#[doc = "A DDoS custom policy in a resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosCustomPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "DDoS custom policy properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DdosCustomPolicyPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl DdosCustomPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DDoS custom policy properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosCustomPolicyPropertiesFormat {
    #[doc = "The resource GUID property of the DDoS custom policy resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The list of public IPs associated with the DDoS custom policy resource. This list is read-only."]
    #[serde(rename = "publicIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_addresses: Vec<SubResource>,
    #[doc = "The protocol-specific DDoS policy customization parameters."]
    #[serde(rename = "protocolCustomSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub protocol_custom_settings: Vec<ProtocolCustomSettingsFormat>,
}
impl DdosCustomPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A DDoS protection plan in a resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosProtectionPlan {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "DDoS protection plan properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DdosProtectionPlanPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl DdosProtectionPlan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of DDoS protection plans."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosProtectionPlanListResult {
    #[doc = "A list of DDoS protection plans."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DdosProtectionPlan>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DdosProtectionPlanListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DDoS protection plan properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosProtectionPlanPropertiesFormat {
    #[doc = "The resource GUID property of the DDoS protection plan resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The list of virtual networks associated with the DDoS protection plan resource. This list is read-only."]
    #[serde(rename = "virtualNetworks", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_networks: Vec<SubResource>,
}
impl DdosProtectionPlanPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains the DDoS protection settings of the public IP."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosSettings {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "ddosCustomPolicy", default, skip_serializing_if = "Option::is_none")]
    pub ddos_custom_policy: Option<SubResource>,
    #[doc = "The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized."]
    #[serde(rename = "protectionCoverage", default, skip_serializing_if = "Option::is_none")]
    pub protection_coverage: Option<ddos_settings::ProtectionCoverage>,
    #[doc = "Enables DDoS protection on the public IP."]
    #[serde(rename = "protectedIP", default, skip_serializing_if = "Option::is_none")]
    pub protected_ip: Option<bool>,
}
impl DdosSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ddos_settings {
    use super::*;
    #[doc = "The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionCoverage {
        Basic,
        Standard,
    }
}
#[doc = "Security default admin rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultAdminPropertiesFormat {
    #[doc = "A friendly name for the rule."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Default rule flag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flag: Option<String>,
    #[doc = "Network protocol this rule applies to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<RuleProtocol>,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "Whether network traffic is allowed or denied."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<SecurityConfigurationRuleAccess>,
    #[doc = "The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<SecurityConfigurationRuleDirection>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl DefaultAdminPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network default admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DefaultAdminRule {
    #[serde(flatten)]
    pub base_admin_rule: BaseAdminRule,
    #[doc = "Security default admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultAdminPropertiesFormat>,
}
impl DefaultAdminRule {
    pub fn new(base_admin_rule: BaseAdminRule) -> Self {
        Self {
            base_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Network security default user rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DefaultUserRule {
    #[serde(flatten)]
    pub base_user_rule: BaseUserRule,
    #[doc = "Security default user rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultUserRulePropertiesFormat>,
}
impl DefaultUserRule {
    pub fn new(base_user_rule: BaseUserRule) -> Self {
        Self {
            base_user_rule,
            properties: None,
        }
    }
}
#[doc = "Security default user rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultUserRulePropertiesFormat {
    #[doc = "A friendly name for the rule."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Default rule flag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flag: Option<String>,
    #[doc = "Network protocol this rule applies to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<RuleProtocol>,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<SecurityConfigurationRuleDirection>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl DefaultUserRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details the service to which the subnet is delegated."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Delegation {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of a service delegation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceDelegationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a subnet. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Delegation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of properties of the device."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceProperties {
    #[doc = "Name of the device Vendor."]
    #[serde(rename = "deviceVendor", default, skip_serializing_if = "Option::is_none")]
    pub device_vendor: Option<String>,
    #[doc = "Model of the device."]
    #[serde(rename = "deviceModel", default, skip_serializing_if = "Option::is_none")]
    pub device_model: Option<String>,
    #[doc = "Link speed."]
    #[serde(rename = "linkSpeedInMbps", default, skip_serializing_if = "Option::is_none")]
    pub link_speed_in_mbps: Option<i32>,
}
impl DeviceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The DH Groups used in IKE Phase 1 for initial SA."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DhGroup {
    None,
    #[serde(rename = "DHGroup1")]
    DhGroup1,
    #[serde(rename = "DHGroup2")]
    DhGroup2,
    #[serde(rename = "DHGroup14")]
    DhGroup14,
    #[serde(rename = "DHGroup2048")]
    DhGroup2048,
    #[serde(rename = "ECP256")]
    Ecp256,
    #[serde(rename = "ECP384")]
    Ecp384,
    #[serde(rename = "DHGroup24")]
    DhGroup24,
}
#[doc = "DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DhcpOptions {
    #[doc = "The list of DNS servers IP addresses."]
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
}
impl DhcpOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Dimension of the metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[doc = "The name of the dimension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The display name of the dimension."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The internal name of the dimension."]
    #[serde(rename = "internalName", default, skip_serializing_if = "Option::is_none")]
    pub internal_name: Option<String>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The direction of the traffic."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Direction {
    Inbound,
    Outbound,
}
#[doc = "Response for the CheckDnsNameAvailability API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DnsNameAvailabilityResult {
    #[doc = "Domain availability (True/False)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
}
impl DnsNameAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DNS Proxy Settings in Firewall Policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DnsSettings {
    #[doc = "List of Custom DNS Servers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub servers: Vec<String>,
    #[doc = "Enable DNS Proxy on Firewalls attached to the Firewall Policy."]
    #[serde(rename = "enableProxy", default, skip_serializing_if = "Option::is_none")]
    pub enable_proxy: Option<bool>,
    #[doc = "FQDNs in Network Rules are supported when set to true."]
    #[serde(rename = "requireProxyForNetworkRules", default, skip_serializing_if = "Option::is_none")]
    pub require_proxy_for_network_rules: Option<bool>,
}
impl DnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Differentiated Services Code Point configuration for any given network interface"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DscpConfiguration {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Differentiated Services Code Point configuration properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DscpConfigurationPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl DscpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the DscpConfigurationList API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DscpConfigurationListResult {
    #[doc = "A list of dscp configurations in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DscpConfiguration>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DscpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Differentiated Services Code Point configuration properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DscpConfigurationPropertiesFormat {
    #[doc = "List of markings to be used in the configuration."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub markings: Vec<i32>,
    #[doc = "Source IP ranges."]
    #[serde(rename = "sourceIpRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_ranges: Vec<QosIpRange>,
    #[doc = "Destination IP ranges."]
    #[serde(rename = "destinationIpRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ip_ranges: Vec<QosIpRange>,
    #[doc = "Sources port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<QosPortRange>,
    #[doc = "Destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<QosPortRange>,
    #[doc = "RNM supported protocol types."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<dscp_configuration_properties_format::Protocol>,
    #[doc = "QoS object definitions"]
    #[serde(rename = "qosDefinitionCollection", default, skip_serializing_if = "Vec::is_empty")]
    pub qos_definition_collection: Vec<QosDefinition>,
    #[doc = "Qos Collection ID generated by RNM."]
    #[serde(rename = "qosCollectionId", default, skip_serializing_if = "Option::is_none")]
    pub qos_collection_id: Option<String>,
    #[doc = "Associated Network Interfaces to the DSCP Configuration."]
    #[serde(rename = "associatedNetworkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub associated_network_interfaces: Vec<NetworkInterface>,
    #[doc = "The resource GUID property of the DSCP Configuration resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl DscpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod dscp_configuration_properties_format {
    use super::*;
    #[doc = "RNM supported protocol types."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        DoNotUse,
        Icmp,
        Tcp,
        Udp,
        Gre,
        Esp,
        Ah,
        Vxlan,
        All,
    }
}
#[doc = "Network base admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EffectiveBaseSecurityAdminRule {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "A display name of the security admin configuration."]
    #[serde(rename = "configurationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub configuration_display_name: Option<String>,
    #[doc = "A description of the security admin configuration."]
    #[serde(rename = "configurationDescription", default, skip_serializing_if = "Option::is_none")]
    pub configuration_description: Option<String>,
    #[doc = "A display name of the rule collection."]
    #[serde(rename = "ruleCollectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_display_name: Option<String>,
    #[doc = "A description of the rule collection."]
    #[serde(rename = "ruleCollectionDescription", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_description: Option<String>,
    #[doc = "Groups for rule collection"]
    #[serde(rename = "ruleCollectionAppliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[doc = "Effective configuration groups."]
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ConfigurationGroup>,
    #[doc = "Whether the rule is custom or default."]
    pub kind: effective_base_security_admin_rule::Kind,
}
impl EffectiveBaseSecurityAdminRule {
    pub fn new(kind: effective_base_security_admin_rule::Kind) -> Self {
        Self {
            id: None,
            configuration_display_name: None,
            configuration_description: None,
            rule_collection_display_name: None,
            rule_collection_description: None,
            rule_collection_applies_to_groups: Vec::new(),
            rule_groups: Vec::new(),
            kind,
        }
    }
}
pub mod effective_base_security_admin_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "The network manager effective connectivity configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveConnectivityConfiguration {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Properties of network manager connectivity configuration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectivityConfigurationProperties>,
    #[doc = "Effective configuration groups."]
    #[serde(rename = "configurationGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub configuration_groups: Vec<ConfigurationGroup>,
}
impl EffectiveConnectivityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network default admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EffectiveDefaultSecurityAdminRule {
    #[serde(flatten)]
    pub effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule,
    #[doc = "Security default admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultAdminPropertiesFormat>,
}
impl EffectiveDefaultSecurityAdminRule {
    pub fn new(effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule) -> Self {
        Self {
            effective_base_security_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Effective network security group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroup {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<SubResource>,
    #[doc = "The effective network security group association."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub association: Option<EffectiveNetworkSecurityGroupAssociation>,
    #[doc = "A collection of effective security rules."]
    #[serde(rename = "effectiveSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_security_rules: Vec<EffectiveNetworkSecurityRule>,
    #[doc = "Mapping of tags to list of IP Addresses included within the tag."]
    #[serde(rename = "tagMap", default, skip_serializing_if = "Option::is_none")]
    pub tag_map: Option<String>,
}
impl EffectiveNetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The effective network security group association."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupAssociation {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "networkManager", default, skip_serializing_if = "Option::is_none")]
    pub network_manager: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<SubResource>,
}
impl EffectiveNetworkSecurityGroupAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for list effective network security groups API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupListResult {
    #[doc = "A list of effective network security groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveNetworkSecurityGroup>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveNetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Effective network security rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityRule {
    #[doc = "The name of the security rule specified by the user (if created by the user)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The network protocol this rule applies to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<effective_network_security_rule::Protocol>,
    #[doc = "The source port or range."]
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[doc = "The destination port or range."]
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[doc = "The source port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*)."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*)."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "The source address prefix."]
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[doc = "The destination address prefix."]
    #[serde(rename = "destinationAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub destination_address_prefix: Option<String>,
    #[doc = "The source address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*)."]
    #[serde(rename = "sourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub source_address_prefixes: Vec<String>,
    #[doc = "The destination address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*)."]
    #[serde(rename = "destinationAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_address_prefixes: Vec<String>,
    #[doc = "The expanded source address prefix."]
    #[serde(rename = "expandedSourceAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_source_address_prefix: Vec<String>,
    #[doc = "Expanded destination address prefix."]
    #[serde(rename = "expandedDestinationAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_destination_address_prefix: Vec<String>,
    #[doc = "Whether network traffic is allowed or denied."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<SecurityRuleAccess>,
    #[doc = "The priority of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<SecurityRuleDirection>,
}
impl EffectiveNetworkSecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_network_security_rule {
    use super::*;
    #[doc = "The network protocol this rule applies to."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        All,
    }
}
#[doc = "Effective Route."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRoute {
    #[doc = "The name of the user defined route. This is optional."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "If true, on-premises routes are not propagated to the network interfaces in the subnet."]
    #[serde(rename = "disableBgpRoutePropagation", default, skip_serializing_if = "Option::is_none")]
    pub disable_bgp_route_propagation: Option<bool>,
    #[doc = "Who created the route."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<effective_route::Source>,
    #[doc = "The value of effective route."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<effective_route::State>,
    #[doc = "The address prefixes of the effective routes in CIDR notation."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefix: Vec<String>,
    #[doc = "The IP address of the next hop of the effective route."]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hop_ip_address: Vec<String>,
    #[doc = "The type of Azure hop the packet should be sent to."]
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<RouteNextHopType>,
}
impl EffectiveRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_route {
    use super::*;
    #[doc = "Who created the route."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        Unknown,
        User,
        VirtualNetworkGateway,
        Default,
    }
    #[doc = "The value of effective route."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Active,
        Invalid,
    }
}
#[doc = "Response for list effective route API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRouteListResult {
    #[doc = "A list of effective routes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveRoute>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveRouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The parameters specifying the resource whose effective routes are being requested."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRoutesParameters {
    #[doc = "The resource whose effective routes are being requested."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "The type of the specified resource like RouteTable, ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection."]
    #[serde(rename = "virtualWanResourceType", default, skip_serializing_if = "Option::is_none")]
    pub virtual_wan_resource_type: Option<String>,
}
impl EffectiveRoutesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EffectiveSecurityAdminRule {
    #[serde(flatten)]
    pub effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule,
    #[doc = "Security admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdminPropertiesFormat>,
}
impl EffectiveSecurityAdminRule {
    pub fn new(effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule) -> Self {
        Self {
            effective_base_security_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Effective Virtual Network"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveVirtualNetwork {
    #[doc = "Effective vnet Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Location of vnet."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Membership Type."]
    #[serde(rename = "membershipType", default, skip_serializing_if = "Option::is_none")]
    pub membership_type: Option<effective_virtual_network::MembershipType>,
}
impl EffectiveVirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_virtual_network {
    use super::*;
    #[doc = "Membership Type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MembershipType {
        Static,
        Dynamic,
    }
}
#[doc = "Result of the request to list Effective Virtual Network. It contains a list of groups and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveVirtualNetworksListResult {
    #[doc = "Gets a page of EffectiveVirtualNetwork"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveVirtualNetwork>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl EffectiveVirtualNetworksListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Effective Virtual Networks Parameter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveVirtualNetworksParameter {
    #[doc = "Conditional Members."]
    #[serde(rename = "conditionalMembers", default, skip_serializing_if = "Option::is_none")]
    pub conditional_members: Option<String>,
    #[doc = "Continuation token for pagination, capturing the next page size and offset, as well as the context of the query."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl EffectiveVirtualNetworksParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Endpoint service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointServiceResult {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Name of the endpoint service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Type of the endpoint service."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl EndpointServiceResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListAvailableEndpointServices API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointServicesListResult {
    #[doc = "List of available endpoint services in a region."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EndpointServiceResult>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EndpointServicesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common error representation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Error {
    #[doc = "Error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "Error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "Error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetails>,
    #[doc = "Inner error message."]
    #[serde(rename = "innerError", default, skip_serializing_if = "Option::is_none")]
    pub inner_error: Option<String>,
}
impl Error {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common error details representation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[doc = "Error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "Error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The error object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "Common error details representation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetails>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Results of network security group evaluation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EvaluatedNetworkSecurityGroup {
    #[doc = "Network security group ID."]
    #[serde(rename = "networkSecurityGroupId", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group_id: Option<String>,
    #[doc = "Resource ID of nic or subnet to which network security group is applied."]
    #[serde(rename = "appliedTo", default, skip_serializing_if = "Option::is_none")]
    pub applied_to: Option<String>,
    #[doc = "Matched rule."]
    #[serde(rename = "matchedRule", default, skip_serializing_if = "Option::is_none")]
    pub matched_rule: Option<MatchedRule>,
    #[doc = "List of network security rules evaluation results."]
    #[serde(rename = "rulesEvaluationResult", default, skip_serializing_if = "Vec::is_empty")]
    pub rules_evaluation_result: Vec<NetworkSecurityRulesEvaluationResult>,
}
impl EvaluatedNetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines a managed rule to use for exclusion."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExclusionManagedRule {
    #[doc = "Identifier for the managed rule."]
    #[serde(rename = "ruleId")]
    pub rule_id: String,
}
impl ExclusionManagedRule {
    pub fn new(rule_id: String) -> Self {
        Self { rule_id }
    }
}
#[doc = "Defines a managed rule group to use for exclusion."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExclusionManagedRuleGroup {
    #[doc = "The managed rule group for exclusion."]
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[doc = "List of rules that will be excluded. If none specified, all rules in the group will be excluded."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<ExclusionManagedRule>,
}
impl ExclusionManagedRuleGroup {
    pub fn new(rule_group_name: String) -> Self {
        Self {
            rule_group_name,
            rules: Vec::new(),
        }
    }
}
#[doc = "Defines a managed rule set for Exclusions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExclusionManagedRuleSet {
    #[doc = "Defines the rule set type to use."]
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[doc = "Defines the version of the rule set to use."]
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[doc = "Defines the rule groups to apply to the rule set."]
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ExclusionManagedRuleGroup>,
}
impl ExclusionManagedRuleSet {
    pub fn new(rule_set_type: String, rule_set_version: String) -> Self {
        Self {
            rule_set_type,
            rule_set_version,
            rule_groups: Vec::new(),
        }
    }
}
#[doc = "Explicit Proxy Settings in Firewall Policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExplicitProxySettings {
    #[doc = "When set to true, explicit proxy mode is enabled."]
    #[serde(rename = "enableExplicitProxy", default, skip_serializing_if = "Option::is_none")]
    pub enable_explicit_proxy: Option<bool>,
    #[doc = "Port number for explicit proxy http protocol, cannot be greater than 64000."]
    #[serde(rename = "httpPort", default, skip_serializing_if = "Option::is_none")]
    pub http_port: Option<i32>,
    #[doc = "Port number for explicit proxy https protocol, cannot be greater than 64000."]
    #[serde(rename = "httpsPort", default, skip_serializing_if = "Option::is_none")]
    pub https_port: Option<i32>,
    #[doc = "Port number for firewall to serve PAC file."]
    #[serde(rename = "pacFilePort", default, skip_serializing_if = "Option::is_none")]
    pub pac_file_port: Option<i32>,
    #[doc = "SAS URL for PAC file."]
    #[serde(rename = "pacFile", default, skip_serializing_if = "Option::is_none")]
    pub pac_file: Option<String>,
}
impl ExplicitProxySettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRouteCircuit resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuit {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Contains SKU in an ExpressRouteCircuit."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ExpressRouteCircuitSku>,
    #[doc = "Properties of ExpressRouteCircuit."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCircuit {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The ARP table associated with the ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitArpTable {
    #[doc = "Entry age in minutes."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub age: Option<i32>,
    #[doc = "Interface address."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interface: Option<String>,
    #[doc = "The IP address."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The MAC address."]
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
}
impl ExpressRouteCircuitArpTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Authorization in an ExpressRouteCircuit resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitAuthorization {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of ExpressRouteCircuitAuthorization."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AuthorizationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ExpressRouteCircuitAuthorization {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Express Route Circuit Connection in an ExpressRouteCircuitPeering resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the express route circuit connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitConnectionPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ExpressRouteCircuitConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListConnections API service call retrieves all global reach connections that belongs to a Private Peering for an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitConnectionListResult {
    #[doc = "The global reach connection associated with Private Peering in an ExpressRoute Circuit."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitConnection>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the express route circuit connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitConnectionPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "expressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub express_route_circuit_peering: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "peerExpressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub peer_express_route_circuit_peering: Option<SubResource>,
    #[doc = "/29 IP address space to carve out Customer addresses for tunnels."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "The authorization key."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "IPv6 Circuit Connection properties for global reach."]
    #[serde(rename = "ipv6CircuitConnectionConfig", default, skip_serializing_if = "Option::is_none")]
    pub ipv6_circuit_connection_config: Option<Ipv6CircuitConnectionConfig>,
    #[doc = "Express Route Circuit connection state."]
    #[serde(rename = "circuitConnectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub circuit_connection_status: Option<CircuitConnectionStatus>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ExpressRouteCircuitConnectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListExpressRouteCircuit API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitListResult {
    #[doc = "A list of ExpressRouteCircuits in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuit>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peering in an ExpressRouteCircuit resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the express route circuit peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitPeeringPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ExpressRouteCircuitPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies the peering configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringConfig {
    #[doc = "The reference to AdvertisedPublicPrefixes."]
    #[serde(rename = "advertisedPublicPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub advertised_public_prefixes: Vec<String>,
    #[doc = "The communities of bgp peering. Specified for microsoft peering."]
    #[serde(rename = "advertisedCommunities", default, skip_serializing_if = "Vec::is_empty")]
    pub advertised_communities: Vec<String>,
    #[doc = "The advertised public prefix state of the Peering resource."]
    #[serde(rename = "advertisedPublicPrefixesState", default, skip_serializing_if = "Option::is_none")]
    pub advertised_public_prefixes_state: Option<express_route_circuit_peering_config::AdvertisedPublicPrefixesState>,
    #[doc = "The legacy mode of the peering."]
    #[serde(rename = "legacyMode", default, skip_serializing_if = "Option::is_none")]
    pub legacy_mode: Option<i32>,
    #[doc = "The CustomerASN of the peering."]
    #[serde(rename = "customerASN", default, skip_serializing_if = "Option::is_none")]
    pub customer_asn: Option<i32>,
    #[doc = "The RoutingRegistryName of the configuration."]
    #[serde(rename = "routingRegistryName", default, skip_serializing_if = "Option::is_none")]
    pub routing_registry_name: Option<String>,
}
impl ExpressRouteCircuitPeeringConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_peering_config {
    use super::*;
    #[doc = "The advertised public prefix state of the Peering resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AdvertisedPublicPrefixesState {
        NotConfigured,
        Configuring,
        Configured,
        ValidationNeeded,
    }
}
#[doc = "ExpressRoute circuit peering identifier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringId {
    #[doc = "The ID of the ExpressRoute circuit peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ExpressRouteCircuitPeeringId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringListResult {
    #[doc = "The peerings in an express route circuit."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitPeering>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the express route circuit peering."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringPropertiesFormat {
    #[doc = "The peering type."]
    #[serde(rename = "peeringType", default, skip_serializing_if = "Option::is_none")]
    pub peering_type: Option<ExpressRoutePeeringType>,
    #[doc = "The state of peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ExpressRoutePeeringState>,
    #[doc = "The Azure ASN."]
    #[serde(rename = "azureASN", default, skip_serializing_if = "Option::is_none")]
    pub azure_asn: Option<i32>,
    #[doc = "The peer ASN."]
    #[serde(rename = "peerASN", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[doc = "The primary address prefix."]
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[doc = "The secondary address prefix."]
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[doc = "The primary port."]
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[doc = "The secondary port."]
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[doc = "The shared key."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "The VLAN ID."]
    #[serde(rename = "vlanId", default, skip_serializing_if = "Option::is_none")]
    pub vlan_id: Option<i32>,
    #[doc = "Specifies the peering configuration."]
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[doc = "Contains stats associated with the peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stats: Option<ExpressRouteCircuitStats>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The GatewayManager Etag."]
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
    #[doc = "Who was the last to modify the peering."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "routeFilter", default, skip_serializing_if = "Option::is_none")]
    pub route_filter: Option<SubResource>,
    #[doc = "Contains IPv6 peering config."]
    #[serde(rename = "ipv6PeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub ipv6_peering_config: Option<Ipv6ExpressRouteCircuitPeeringConfig>,
    #[doc = "The ID of the ExpressRouteConnection."]
    #[serde(rename = "expressRouteConnection", default, skip_serializing_if = "Option::is_none")]
    pub express_route_connection: Option<ExpressRouteConnectionId>,
    #[doc = "The list of circuit connections associated with Azure Private Peering for this circuit."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub connections: Vec<ExpressRouteCircuitConnection>,
    #[doc = "The list of peered circuit connections associated with Azure Private Peering for this circuit."]
    #[serde(rename = "peeredConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub peered_connections: Vec<PeerExpressRouteCircuitConnection>,
}
impl ExpressRouteCircuitPeeringPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPropertiesFormat {
    #[doc = "Allow classic operations."]
    #[serde(rename = "allowClassicOperations", default, skip_serializing_if = "Option::is_none")]
    pub allow_classic_operations: Option<bool>,
    #[doc = "The CircuitProvisioningState state of the resource."]
    #[serde(rename = "circuitProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub circuit_provisioning_state: Option<String>,
    #[doc = "The ServiceProviderProvisioningState state of the resource."]
    #[serde(rename = "serviceProviderProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_provisioning_state: Option<ServiceProviderProvisioningState>,
    #[doc = "The list of authorizations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub authorizations: Vec<ExpressRouteCircuitAuthorization>,
    #[doc = "The list of peerings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCircuitPeering>,
    #[doc = "The ServiceKey."]
    #[serde(rename = "serviceKey", default, skip_serializing_if = "Option::is_none")]
    pub service_key: Option<String>,
    #[doc = "The ServiceProviderNotes."]
    #[serde(rename = "serviceProviderNotes", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_notes: Option<String>,
    #[doc = "Contains ServiceProviderProperties in an ExpressRouteCircuit."]
    #[serde(rename = "serviceProviderProperties", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_properties: Option<ExpressRouteCircuitServiceProviderProperties>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "expressRoutePort", default, skip_serializing_if = "Option::is_none")]
    pub express_route_port: Option<SubResource>,
    #[doc = "The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource."]
    #[serde(rename = "bandwidthInGbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_gbps: Option<f64>,
    #[doc = "The identifier of the circuit traffic. Outer tag for QinQ encapsulation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stag: Option<i32>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The GatewayManager Etag."]
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
    #[doc = "Flag denoting global reach status."]
    #[serde(rename = "globalReachEnabled", default, skip_serializing_if = "Option::is_none")]
    pub global_reach_enabled: Option<bool>,
}
impl ExpressRouteCircuitPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Reference to an express route circuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitReference {
    #[doc = "Corresponding Express Route Circuit Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ExpressRouteCircuitReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The routes table associated with the ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitRoutesTable {
    #[doc = "IP address of a network entity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[doc = "NextHop address."]
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[doc = "Local preference value as set with the set local-preference route-map configuration command."]
    #[serde(rename = "locPrf", default, skip_serializing_if = "Option::is_none")]
    pub loc_prf: Option<String>,
    #[doc = "Route Weight."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
    #[doc = "Autonomous system paths to the destination network."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl ExpressRouteCircuitRoutesTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The routes table associated with the ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitRoutesTableSummary {
    #[doc = "IP address of the neighbor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[doc = "BGP version number spoken to the neighbor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub v: Option<i32>,
    #[doc = "Autonomous system number."]
    #[serde(rename = "as", default, skip_serializing_if = "Option::is_none")]
    pub as_: Option<i32>,
    #[doc = "The length of time that the BGP session has been in the Established state, or the current status if not in the Established state."]
    #[serde(rename = "upDown", default, skip_serializing_if = "Option::is_none")]
    pub up_down: Option<String>,
    #[doc = "Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group."]
    #[serde(rename = "statePfxRcd", default, skip_serializing_if = "Option::is_none")]
    pub state_pfx_rcd: Option<String>,
}
impl ExpressRouteCircuitRoutesTableSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains ServiceProviderProperties in an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitServiceProviderProperties {
    #[doc = "The serviceProviderName."]
    #[serde(rename = "serviceProviderName", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_name: Option<String>,
    #[doc = "The peering location."]
    #[serde(rename = "peeringLocation", default, skip_serializing_if = "Option::is_none")]
    pub peering_location: Option<String>,
    #[doc = "The BandwidthInMbps."]
    #[serde(rename = "bandwidthInMbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_mbps: Option<i32>,
}
impl ExpressRouteCircuitServiceProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains SKU in an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitSku {
    #[doc = "The name of the SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The tier of the SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<express_route_circuit_sku::Tier>,
    #[doc = "The family of the SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<express_route_circuit_sku::Family>,
}
impl ExpressRouteCircuitSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_sku {
    use super::*;
    #[doc = "The tier of the SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        Premium,
        Basic,
        Local,
    }
    #[doc = "The family of the SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Family {
        UnlimitedData,
        MeteredData,
    }
}
#[doc = "Contains stats associated with the peering."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitStats {
    #[doc = "The Primary BytesIn of the peering."]
    #[serde(rename = "primarybytesIn", default, skip_serializing_if = "Option::is_none")]
    pub primarybytes_in: Option<i64>,
    #[doc = "The primary BytesOut of the peering."]
    #[serde(rename = "primarybytesOut", default, skip_serializing_if = "Option::is_none")]
    pub primarybytes_out: Option<i64>,
    #[doc = "The secondary BytesIn of the peering."]
    #[serde(rename = "secondarybytesIn", default, skip_serializing_if = "Option::is_none")]
    pub secondarybytes_in: Option<i64>,
    #[doc = "The secondary BytesOut of the peering."]
    #[serde(rename = "secondarybytesOut", default, skip_serializing_if = "Option::is_none")]
    pub secondarybytes_out: Option<i64>,
}
impl ExpressRouteCircuitStats {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListArpTable associated with the Express Route Circuits API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsArpTableListResult {
    #[doc = "A list of the ARP tables."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitArpTable>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsArpTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRoutesTable associated with the Express Route Circuits API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsRoutesTableListResult {
    #[doc = "The list of routes table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitRoutesTable>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsRoutesTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRoutesTable associated with the Express Route Circuits API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsRoutesTableSummaryListResult {
    #[doc = "A list of the routes table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitRoutesTableSummary>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsRoutesTableSummaryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRouteConnection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpressRouteConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the ExpressRouteConnection subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteConnectionProperties>,
    #[doc = "The name of the resource."]
    pub name: String,
}
impl ExpressRouteConnection {
    pub fn new(name: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties: None,
            name,
        }
    }
}
#[doc = "The ID of the ExpressRouteConnection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteConnectionId {
    #[doc = "The ID of the ExpressRouteConnection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ExpressRouteConnectionId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRouteConnection list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteConnectionList {
    #[doc = "The list of ExpressRoute connections."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteConnection>,
}
impl ExpressRouteConnectionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the ExpressRouteConnection subresource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpressRouteConnectionProperties {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "ExpressRoute circuit peering identifier."]
    #[serde(rename = "expressRouteCircuitPeering")]
    pub express_route_circuit_peering: ExpressRouteCircuitPeeringId,
    #[doc = "Authorization key to establish the connection."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "The routing weight associated to the connection."]
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i64>,
    #[doc = "Enable internet security."]
    #[serde(rename = "enableInternetSecurity", default, skip_serializing_if = "Option::is_none")]
    pub enable_internet_security: Option<bool>,
    #[doc = "Enable FastPath to vWan Firewall hub."]
    #[serde(rename = "expressRouteGatewayBypass", default, skip_serializing_if = "Option::is_none")]
    pub express_route_gateway_bypass: Option<bool>,
    #[doc = "Routing Configuration indicating the associated and propagated route tables for this connection."]
    #[serde(rename = "routingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub routing_configuration: Option<RoutingConfiguration>,
}
impl ExpressRouteConnectionProperties {
    pub fn new(express_route_circuit_peering: ExpressRouteCircuitPeeringId) -> Self {
        Self {
            provisioning_state: None,
            express_route_circuit_peering,
            authorization_key: None,
            routing_weight: None,
            enable_internet_security: None,
            express_route_gateway_bypass: None,
            routing_configuration: None,
        }
    }
}
#[doc = "ExpressRouteCrossConnection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of ExpressRouteCrossConnection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCrossConnectionProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCrossConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListExpressRouteCrossConnection API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionListResult {
    #[doc = "A list of ExpressRouteCrossConnection resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCrossConnection>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCrossConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peering in an ExpressRoute Cross Connection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of express route cross connection peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCrossConnectionPeeringProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCrossConnectionPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCrossConnection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionPeeringList {
    #[doc = "The peerings in an express route cross connection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCrossConnectionPeering>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCrossConnectionPeeringList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of express route cross connection peering."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionPeeringProperties {
    #[doc = "The peering type."]
    #[serde(rename = "peeringType", default, skip_serializing_if = "Option::is_none")]
    pub peering_type: Option<ExpressRoutePeeringType>,
    #[doc = "The state of peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ExpressRoutePeeringState>,
    #[doc = "The Azure ASN."]
    #[serde(rename = "azureASN", default, skip_serializing_if = "Option::is_none")]
    pub azure_asn: Option<i32>,
    #[doc = "The peer ASN."]
    #[serde(rename = "peerASN", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[doc = "The primary address prefix."]
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[doc = "The secondary address prefix."]
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[doc = "The primary port."]
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[doc = "The secondary port."]
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[doc = "The shared key."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "The VLAN ID."]
    #[serde(rename = "vlanId", default, skip_serializing_if = "Option::is_none")]
    pub vlan_id: Option<i32>,
    #[doc = "Specifies the peering configuration."]
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The GatewayManager Etag."]
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
    #[doc = "Who was the last to modify the peering."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "Contains IPv6 peering config."]
    #[serde(rename = "ipv6PeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub ipv6_peering_config: Option<Ipv6ExpressRouteCircuitPeeringConfig>,
}
impl ExpressRouteCrossConnectionPeeringProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ExpressRouteCrossConnection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionProperties {
    #[doc = "The name of the primary port."]
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[doc = "The name of the secondary port."]
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[doc = "The identifier of the circuit traffic."]
    #[serde(rename = "sTag", default, skip_serializing_if = "Option::is_none")]
    pub s_tag: Option<i64>,
    #[doc = "The peering location of the ExpressRoute circuit."]
    #[serde(rename = "peeringLocation", default, skip_serializing_if = "Option::is_none")]
    pub peering_location: Option<String>,
    #[doc = "The circuit bandwidth In Mbps."]
    #[serde(rename = "bandwidthInMbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_mbps: Option<i32>,
    #[doc = "Reference to an express route circuit."]
    #[serde(rename = "expressRouteCircuit", default, skip_serializing_if = "Option::is_none")]
    pub express_route_circuit: Option<ExpressRouteCircuitReference>,
    #[doc = "The ServiceProviderProvisioningState state of the resource."]
    #[serde(rename = "serviceProviderProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_provisioning_state: Option<ServiceProviderProvisioningState>,
    #[doc = "Additional read only notes set by the connectivity provider."]
    #[serde(rename = "serviceProviderNotes", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_notes: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The list of peerings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCrossConnectionPeering>,
}
impl ExpressRouteCrossConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The routes table associated with the ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionRoutesTableSummary {
    #[doc = "IP address of Neighbor router."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[doc = "Autonomous system number."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i32>,
    #[doc = "The length of time that the BGP session has been in the Established state, or the current status if not in the Established state."]
    #[serde(rename = "upDown", default, skip_serializing_if = "Option::is_none")]
    pub up_down: Option<String>,
    #[doc = "Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group."]
    #[serde(rename = "stateOrPrefixesReceived", default, skip_serializing_if = "Option::is_none")]
    pub state_or_prefixes_received: Option<String>,
}
impl ExpressRouteCrossConnectionRoutesTableSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRoutesTable associated with the Express Route Cross Connections."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionsRoutesTableSummaryListResult {
    #[doc = "A list of the routes table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCrossConnectionRoutesTableSummary>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCrossConnectionsRoutesTableSummaryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRoute gateway resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "ExpressRoute gateway resource properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteGatewayProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of ExpressRoute gateways."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteGatewayList {
    #[doc = "List of ExpressRoute gateways."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteGateway>,
}
impl ExpressRouteGatewayList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRoute gateway resource properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpressRouteGatewayProperties {
    #[doc = "Configuration for auto scaling."]
    #[serde(rename = "autoScaleConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_configuration: Option<express_route_gateway_properties::AutoScaleConfiguration>,
    #[doc = "List of ExpressRoute connections to the ExpressRoute gateway."]
    #[serde(rename = "expressRouteConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub express_route_connections: Vec<ExpressRouteConnection>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Virtual Hub identifier."]
    #[serde(rename = "virtualHub")]
    pub virtual_hub: VirtualHubId,
}
impl ExpressRouteGatewayProperties {
    pub fn new(virtual_hub: VirtualHubId) -> Self {
        Self {
            auto_scale_configuration: None,
            express_route_connections: Vec::new(),
            provisioning_state: None,
            virtual_hub,
        }
    }
}
pub mod express_route_gateway_properties {
    use super::*;
    #[doc = "Configuration for auto scaling."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct AutoScaleConfiguration {
        #[doc = "Minimum and maximum number of scale units to deploy."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub bounds: Option<auto_scale_configuration::Bounds>,
    }
    impl AutoScaleConfiguration {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod auto_scale_configuration {
        use super::*;
        #[doc = "Minimum and maximum number of scale units to deploy."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
        pub struct Bounds {
            #[doc = "Minimum number of scale units deployed for ExpressRoute gateway."]
            #[serde(default, skip_serializing_if = "Option::is_none")]
            pub min: Option<i64>,
            #[doc = "Maximum number of scale units deployed for ExpressRoute gateway."]
            #[serde(default, skip_serializing_if = "Option::is_none")]
            pub max: Option<i64>,
        }
        impl Bounds {
            pub fn new() -> Self {
                Self::default()
            }
        }
    }
}
#[doc = "ExpressRouteLink child resource definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties specific to ExpressRouteLink resources."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteLinkPropertiesFormat>,
    #[doc = "Name of child port resource that is unique among child port resources of the parent."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListExpressRouteLinks API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteLinkListResult {
    #[doc = "The list of ExpressRouteLink sub-resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteLink>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteLinkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRouteLink Mac Security Configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteLinkMacSecConfig {
    #[doc = "Keyvault Secret Identifier URL containing Mac security CKN key."]
    #[serde(rename = "cknSecretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub ckn_secret_identifier: Option<String>,
    #[doc = "Keyvault Secret Identifier URL containing Mac security CAK key."]
    #[serde(rename = "cakSecretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub cak_secret_identifier: Option<String>,
    #[doc = "Mac security cipher."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cipher: Option<express_route_link_mac_sec_config::Cipher>,
    #[doc = "Sci mode enabled/disabled."]
    #[serde(rename = "sciState", default, skip_serializing_if = "Option::is_none")]
    pub sci_state: Option<express_route_link_mac_sec_config::SciState>,
}
impl ExpressRouteLinkMacSecConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_link_mac_sec_config {
    use super::*;
    #[doc = "Mac security cipher."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Cipher {
        GcmAes256,
        GcmAes128,
        GcmAesXpn128,
        GcmAesXpn256,
    }
    #[doc = "Sci mode enabled/disabled."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SciState {
        Disabled,
        Enabled,
    }
}
#[doc = "Properties specific to ExpressRouteLink resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteLinkPropertiesFormat {
    #[doc = "Name of Azure router associated with physical port."]
    #[serde(rename = "routerName", default, skip_serializing_if = "Option::is_none")]
    pub router_name: Option<String>,
    #[doc = "Name of Azure router interface."]
    #[serde(rename = "interfaceName", default, skip_serializing_if = "Option::is_none")]
    pub interface_name: Option<String>,
    #[doc = "Mapping between physical port to patch panel port."]
    #[serde(rename = "patchPanelId", default, skip_serializing_if = "Option::is_none")]
    pub patch_panel_id: Option<String>,
    #[doc = "Mapping of physical patch panel to rack."]
    #[serde(rename = "rackId", default, skip_serializing_if = "Option::is_none")]
    pub rack_id: Option<String>,
    #[doc = "Physical fiber port type."]
    #[serde(rename = "connectorType", default, skip_serializing_if = "Option::is_none")]
    pub connector_type: Option<express_route_link_properties_format::ConnectorType>,
    #[doc = "Administrative state of the physical port."]
    #[serde(rename = "adminState", default, skip_serializing_if = "Option::is_none")]
    pub admin_state: Option<express_route_link_properties_format::AdminState>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "ExpressRouteLink Mac Security Configuration."]
    #[serde(rename = "macSecConfig", default, skip_serializing_if = "Option::is_none")]
    pub mac_sec_config: Option<ExpressRouteLinkMacSecConfig>,
}
impl ExpressRouteLinkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_link_properties_format {
    use super::*;
    #[doc = "Physical fiber port type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectorType {
        #[serde(rename = "LC")]
        Lc,
        #[serde(rename = "SC")]
        Sc,
    }
    #[doc = "Administrative state of the physical port."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AdminState {
        Enabled,
        Disabled,
    }
}
#[doc = "The state of peering."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ExpressRoutePeeringState {
    Disabled,
    Enabled,
}
#[doc = "The peering type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ExpressRoutePeeringType {
    AzurePublicPeering,
    AzurePrivatePeering,
    MicrosoftPeering,
}
#[doc = "ExpressRoutePort resource definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePort {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties specific to ExpressRoutePort resources."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRoutePortPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
}
impl ExpressRoutePort {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListExpressRoutePorts API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortListResult {
    #[doc = "A list of ExpressRoutePort resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRoutePort>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRoutePortListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties specific to ExpressRoutePort resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortPropertiesFormat {
    #[doc = "The name of the peering location that the ExpressRoutePort is mapped to physically."]
    #[serde(rename = "peeringLocation", default, skip_serializing_if = "Option::is_none")]
    pub peering_location: Option<String>,
    #[doc = "Bandwidth of procured ports in Gbps."]
    #[serde(rename = "bandwidthInGbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_gbps: Option<i64>,
    #[doc = "Aggregate Gbps of associated circuit bandwidths."]
    #[serde(rename = "provisionedBandwidthInGbps", default, skip_serializing_if = "Option::is_none")]
    pub provisioned_bandwidth_in_gbps: Option<f64>,
    #[doc = "Maximum transmission unit of the physical port pair(s)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mtu: Option<String>,
    #[doc = "Encapsulation method on physical ports."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encapsulation: Option<express_route_port_properties_format::Encapsulation>,
    #[doc = "Ether type of the physical port."]
    #[serde(rename = "etherType", default, skip_serializing_if = "Option::is_none")]
    pub ether_type: Option<String>,
    #[doc = "Date of the physical port allocation to be used in Letter of Authorization."]
    #[serde(rename = "allocationDate", default, skip_serializing_if = "Option::is_none")]
    pub allocation_date: Option<String>,
    #[doc = "The set of physical links of the ExpressRoutePort resource."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub links: Vec<ExpressRouteLink>,
    #[doc = "Reference the ExpressRoute circuit(s) that are provisioned on this ExpressRoutePort resource."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub circuits: Vec<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The resource GUID property of the express route port resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
}
impl ExpressRoutePortPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_port_properties_format {
    use super::*;
    #[doc = "Encapsulation method on physical ports."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Encapsulation {
        Dot1Q,
        QinQ,
    }
}
#[doc = "Definition of the ExpressRoutePorts peering location resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortsLocation {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties specific to ExpressRoutePorts peering location resources."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRoutePortsLocationPropertiesFormat>,
}
impl ExpressRoutePortsLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Real-time inventory of available ExpressRoute port bandwidths."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortsLocationBandwidths {
    #[doc = "Bandwidth descriptive name."]
    #[serde(rename = "offerName", default, skip_serializing_if = "Option::is_none")]
    pub offer_name: Option<String>,
    #[doc = "Bandwidth value in Gbps."]
    #[serde(rename = "valueInGbps", default, skip_serializing_if = "Option::is_none")]
    pub value_in_gbps: Option<i64>,
}
impl ExpressRoutePortsLocationBandwidths {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListExpressRoutePortsLocations API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortsLocationListResult {
    #[doc = "The list of all ExpressRoutePort peering locations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRoutePortsLocation>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRoutePortsLocationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties specific to ExpressRoutePorts peering location resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortsLocationPropertiesFormat {
    #[doc = "Address of peering location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "Contact details of peering locations."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub contact: Option<String>,
    #[doc = "The inventory of available ExpressRoutePort bandwidths."]
    #[serde(rename = "availableBandwidths", default, skip_serializing_if = "Vec::is_empty")]
    pub available_bandwidths: Vec<ExpressRoutePortsLocationBandwidths>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ExpressRoutePortsLocationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A ExpressRouteResourceProvider object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProvider {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of ExpressRouteServiceProvider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteServiceProviderPropertiesFormat>,
}
impl ExpressRouteServiceProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains bandwidths offered in ExpressRouteServiceProvider resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderBandwidthsOffered {
    #[doc = "The OfferName."]
    #[serde(rename = "offerName", default, skip_serializing_if = "Option::is_none")]
    pub offer_name: Option<String>,
    #[doc = "The ValueInMbps."]
    #[serde(rename = "valueInMbps", default, skip_serializing_if = "Option::is_none")]
    pub value_in_mbps: Option<i32>,
}
impl ExpressRouteServiceProviderBandwidthsOffered {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListExpressRouteServiceProvider API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderListResult {
    #[doc = "A list of ExpressRouteResourceProvider resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteServiceProvider>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteServiceProviderListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ExpressRouteServiceProvider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderPropertiesFormat {
    #[doc = "A list of peering locations."]
    #[serde(rename = "peeringLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub peering_locations: Vec<String>,
    #[doc = "A list of bandwidths offered."]
    #[serde(rename = "bandwidthsOffered", default, skip_serializing_if = "Vec::is_empty")]
    pub bandwidths_offered: Vec<ExpressRouteServiceProviderBandwidthsOffered>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ExpressRouteServiceProviderPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExtendedLocation complex type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExtendedLocation {
    #[doc = "The name of the extended location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The supported ExtendedLocation types. Currently only EdgeZone is supported in Microsoft.Network resources."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<ExtendedLocationType>,
}
impl ExtendedLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The supported ExtendedLocation types. Currently only EdgeZone is supported in Microsoft.Network resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ExtendedLocationType {
    EdgeZone,
}
#[doc = "Will contain the filter name and values to operate on"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FilterItems {
    #[doc = "The name of the field we would like to filter"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub field: Option<String>,
    #[doc = "List of values to filter the current field by"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<String>,
}
impl FilterItems {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type Filters = Vec<FilterItems>;
#[doc = "FirewallPolicy Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Firewall Policy definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FirewallPolicyPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
}
impl FirewallPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Trusted Root certificates properties for tls."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyCertificateAuthority {
    #[doc = "Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault."]
    #[serde(rename = "keyVaultSecretId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_secret_id: Option<String>,
    #[doc = "Name of the CA certificate."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl FirewallPolicyCertificateAuthority {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Firewall Policy Filter Rule Collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallPolicyFilterRuleCollection {
    #[serde(flatten)]
    pub firewall_policy_rule_collection: FirewallPolicyRuleCollection,
    #[doc = "Properties of the FirewallPolicyFilterRuleCollectionAction."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<FirewallPolicyFilterRuleCollectionAction>,
    #[doc = "List of rules included in a rule collection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<FirewallPolicyRule>,
}
impl FirewallPolicyFilterRuleCollection {
    pub fn new(firewall_policy_rule_collection: FirewallPolicyRuleCollection) -> Self {
        Self {
            firewall_policy_rule_collection,
            action: None,
            rules: Vec::new(),
        }
    }
}
#[doc = "Properties of the FirewallPolicyFilterRuleCollectionAction."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyFilterRuleCollectionAction {
    #[doc = "The action type of a rule."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<FirewallPolicyFilterRuleCollectionActionType>,
}
impl FirewallPolicyFilterRuleCollectionAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The action type of a rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyFilterRuleCollectionActionType {
    Allow,
    Deny,
}
#[doc = "Firewall Policy Insights."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyInsights {
    #[doc = "A flag to indicate if the insights are enabled on the policy."]
    #[serde(rename = "isEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
    #[doc = "Number of days the insights should be enabled on the policy."]
    #[serde(rename = "retentionDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_days: Option<i32>,
    #[doc = "Log Analytics Resources for Firewall Policy Insights."]
    #[serde(rename = "logAnalyticsResources", default, skip_serializing_if = "Option::is_none")]
    pub log_analytics_resources: Option<FirewallPolicyLogAnalyticsResources>,
}
impl FirewallPolicyInsights {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configuration for intrusion detection mode and rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyIntrusionDetection {
    #[doc = "Possible state values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<FirewallPolicyIntrusionDetectionStateOptions>,
    #[doc = "The operation for configuring intrusion detection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub configuration: Option<FirewallPolicyIntrusionDetectionConfiguration>,
}
impl FirewallPolicyIntrusionDetection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Possible intrusion detection bypass traffic protocols."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyIntrusionDetectionBypassTrafficProtocol {
    #[serde(rename = "TCP")]
    Tcp,
    #[serde(rename = "UDP")]
    Udp,
    #[serde(rename = "ICMP")]
    Icmp,
    #[serde(rename = "ANY")]
    Any,
}
#[doc = "Intrusion detection bypass traffic specification."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyIntrusionDetectionBypassTrafficSpecifications {
    #[doc = "Name of the bypass traffic rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Description of the bypass traffic rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Possible intrusion detection bypass traffic protocols."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<FirewallPolicyIntrusionDetectionBypassTrafficProtocol>,
    #[doc = "List of source IP addresses or ranges for this rule."]
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[doc = "List of destination IP addresses or ranges for this rule."]
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[doc = "List of destination ports or ranges."]
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<String>,
    #[doc = "List of source IpGroups for this rule."]
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
    #[doc = "List of destination IpGroups for this rule."]
    #[serde(rename = "destinationIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ip_groups: Vec<String>,
}
impl FirewallPolicyIntrusionDetectionBypassTrafficSpecifications {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The operation for configuring intrusion detection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyIntrusionDetectionConfiguration {
    #[doc = "List of specific signatures states."]
    #[serde(rename = "signatureOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub signature_overrides: Vec<FirewallPolicyIntrusionDetectionSignatureSpecification>,
    #[doc = "List of rules for traffic to bypass."]
    #[serde(rename = "bypassTrafficSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub bypass_traffic_settings: Vec<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications>,
}
impl FirewallPolicyIntrusionDetectionConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Intrusion detection signatures specification states."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyIntrusionDetectionSignatureSpecification {
    #[doc = "Signature id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Possible state values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<FirewallPolicyIntrusionDetectionStateOptions>,
}
impl FirewallPolicyIntrusionDetectionSignatureSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Possible state values."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyIntrusionDetectionStateOptions {
    Off,
    Alert,
    Deny,
}
#[doc = "Response for ListFirewallPolicies API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyListResult {
    #[doc = "List of Firewall Policies in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FirewallPolicy>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FirewallPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Log Analytics Resources for Firewall Policy Insights."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyLogAnalyticsResources {
    #[doc = "List of workspaces for Firewall Policy Insights."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub workspaces: Vec<FirewallPolicyLogAnalyticsWorkspace>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "defaultWorkspaceId", default, skip_serializing_if = "Option::is_none")]
    pub default_workspace_id: Option<SubResource>,
}
impl FirewallPolicyLogAnalyticsResources {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Log Analytics Workspace for Firewall Policy Insights."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyLogAnalyticsWorkspace {
    #[doc = "Region to configure the Workspace."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<SubResource>,
}
impl FirewallPolicyLogAnalyticsWorkspace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Firewall Policy NAT Rule Collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallPolicyNatRuleCollection {
    #[serde(flatten)]
    pub firewall_policy_rule_collection: FirewallPolicyRuleCollection,
    #[doc = "Properties of the FirewallPolicyNatRuleCollectionAction."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<FirewallPolicyNatRuleCollectionAction>,
    #[doc = "List of rules included in a rule collection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<FirewallPolicyRule>,
}
impl FirewallPolicyNatRuleCollection {
    pub fn new(firewall_policy_rule_collection: FirewallPolicyRuleCollection) -> Self {
        Self {
            firewall_policy_rule_collection,
            action: None,
            rules: Vec::new(),
        }
    }
}
#[doc = "Properties of the FirewallPolicyNatRuleCollectionAction."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyNatRuleCollectionAction {
    #[doc = "The action type of a rule."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<FirewallPolicyNatRuleCollectionActionType>,
}
impl FirewallPolicyNatRuleCollectionAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The action type of a rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyNatRuleCollectionActionType {
    #[serde(rename = "DNAT")]
    Dnat,
}
#[doc = "Firewall Policy definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyPropertiesFormat {
    #[doc = "List of references to FirewallPolicyRuleCollectionGroups."]
    #[serde(rename = "ruleCollectionGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_groups: Vec<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "basePolicy", default, skip_serializing_if = "Option::is_none")]
    pub base_policy: Option<SubResource>,
    #[doc = "List of references to Azure Firewalls that this Firewall Policy is associated with."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub firewalls: Vec<SubResource>,
    #[doc = "List of references to Child Firewall Policies."]
    #[serde(rename = "childPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub child_policies: Vec<SubResource>,
    #[doc = "The operation mode for Threat Intel."]
    #[serde(rename = "threatIntelMode", default, skip_serializing_if = "Option::is_none")]
    pub threat_intel_mode: Option<AzureFirewallThreatIntelMode>,
    #[doc = "ThreatIntel Whitelist for Firewall Policy."]
    #[serde(rename = "threatIntelWhitelist", default, skip_serializing_if = "Option::is_none")]
    pub threat_intel_whitelist: Option<FirewallPolicyThreatIntelWhitelist>,
    #[doc = "Firewall Policy Insights."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub insights: Option<FirewallPolicyInsights>,
    #[doc = "The private IP addresses/IP ranges to which traffic will not be SNAT."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub snat: Option<FirewallPolicySnat>,
    #[doc = "SQL Settings in Firewall Policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sql: Option<FirewallPolicySql>,
    #[doc = "DNS Proxy Settings in Firewall Policy."]
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<DnsSettings>,
    #[doc = "Explicit Proxy Settings in Firewall Policy."]
    #[serde(rename = "explicitProxySettings", default, skip_serializing_if = "Option::is_none")]
    pub explicit_proxy_settings: Option<ExplicitProxySettings>,
    #[doc = "Configuration for intrusion detection mode and rules."]
    #[serde(rename = "intrusionDetection", default, skip_serializing_if = "Option::is_none")]
    pub intrusion_detection: Option<FirewallPolicyIntrusionDetection>,
    #[doc = "Configuration needed to perform TLS termination & initiation."]
    #[serde(rename = "transportSecurity", default, skip_serializing_if = "Option::is_none")]
    pub transport_security: Option<FirewallPolicyTransportSecurity>,
    #[doc = "SKU of Firewall policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<FirewallPolicySku>,
}
impl FirewallPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallPolicyRule {
    #[doc = "Name of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Description of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Rule Type."]
    #[serde(rename = "ruleType")]
    pub rule_type: firewall_policy_rule::RuleType,
}
impl FirewallPolicyRule {
    pub fn new(rule_type: firewall_policy_rule::RuleType) -> Self {
        Self {
            name: None,
            description: None,
            rule_type,
        }
    }
}
pub mod firewall_policy_rule {
    use super::*;
    #[doc = "Rule Type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleType {
        ApplicationRule,
        NetworkRule,
        NatRule,
    }
}
#[doc = "Properties of the application rule protocol."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyRuleApplicationProtocol {
    #[doc = "The application protocol type of a Rule."]
    #[serde(rename = "protocolType", default, skip_serializing_if = "Option::is_none")]
    pub protocol_type: Option<FirewallPolicyRuleApplicationProtocolType>,
    #[doc = "Port number for the protocol, cannot be greater than 64000."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl FirewallPolicyRuleApplicationProtocol {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The application protocol type of a Rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyRuleApplicationProtocolType {
    Http,
    Https,
}
#[doc = "Properties of the rule collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallPolicyRuleCollection {
    #[doc = "The type of the rule collection."]
    #[serde(rename = "ruleCollectionType")]
    pub rule_collection_type: firewall_policy_rule_collection::RuleCollectionType,
    #[doc = "The name of the rule collection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Priority of the Firewall Policy Rule Collection resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
}
impl FirewallPolicyRuleCollection {
    pub fn new(rule_collection_type: firewall_policy_rule_collection::RuleCollectionType) -> Self {
        Self {
            rule_collection_type,
            name: None,
            priority: None,
        }
    }
}
pub mod firewall_policy_rule_collection {
    use super::*;
    #[doc = "The type of the rule collection."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleCollectionType {
        FirewallPolicyNatRuleCollection,
        FirewallPolicyFilterRuleCollection,
    }
}
#[doc = "Rule Collection Group resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyRuleCollectionGroup {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the rule collection group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FirewallPolicyRuleCollectionGroupProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Rule Group type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl FirewallPolicyRuleCollectionGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListFirewallPolicyRuleCollectionGroups API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyRuleCollectionGroupListResult {
    #[doc = "List of FirewallPolicyRuleCollectionGroups in a FirewallPolicy."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FirewallPolicyRuleCollectionGroup>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FirewallPolicyRuleCollectionGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the rule collection group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyRuleCollectionGroupProperties {
    #[doc = "Priority of the Firewall Policy Rule Collection Group resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "Group of Firewall Policy rule collections."]
    #[serde(rename = "ruleCollections", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collections: Vec<FirewallPolicyRuleCollection>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl FirewallPolicyRuleCollectionGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Network protocol of a Rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyRuleNetworkProtocol {
    #[serde(rename = "TCP")]
    Tcp,
    #[serde(rename = "UDP")]
    Udp,
    Any,
    #[serde(rename = "ICMP")]
    Icmp,
}
#[doc = "The private IP addresses/IP ranges to which traffic will not be SNAT."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicySnat {
    #[doc = "List of private IP addresses/IP address ranges to not be SNAT."]
    #[serde(rename = "privateRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub private_ranges: Vec<String>,
}
impl FirewallPolicySnat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SQL Settings in Firewall Policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicySql {
    #[doc = "A flag to indicate if SQL Redirect traffic filtering is enabled. Turning on the flag requires no rule using port 11000-11999."]
    #[serde(rename = "allowSqlRedirect", default, skip_serializing_if = "Option::is_none")]
    pub allow_sql_redirect: Option<bool>,
}
impl FirewallPolicySql {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SKU of Firewall policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicySku {
    #[doc = "Tier of Firewall Policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<firewall_policy_sku::Tier>,
}
impl FirewallPolicySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod firewall_policy_sku {
    use super::*;
    #[doc = "Tier of Firewall Policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        Premium,
        Basic,
    }
}
#[doc = "ThreatIntel Whitelist for Firewall Policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyThreatIntelWhitelist {
    #[doc = "List of IP addresses for the ThreatIntel Whitelist."]
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
    #[doc = "List of FQDNs for the ThreatIntel Whitelist."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub fqdns: Vec<String>,
}
impl FirewallPolicyThreatIntelWhitelist {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configuration needed to perform TLS termination & initiation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyTransportSecurity {
    #[doc = "Trusted Root certificates properties for tls."]
    #[serde(rename = "certificateAuthority", default, skip_serializing_if = "Option::is_none")]
    pub certificate_authority: Option<FirewallPolicyCertificateAuthority>,
}
impl FirewallPolicyTransportSecurity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A flow log resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FlowLog {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Parameters that define the configuration of flow log."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FlowLogPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl FlowLog {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the flow log format."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FlowLogFormatParameters {
    #[doc = "The file type of flow log."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<flow_log_format_parameters::Type>,
    #[doc = "The version (revision) of the flow log."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i32>,
}
impl FlowLogFormatParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod flow_log_format_parameters {
    use super::*;
    #[doc = "The file type of flow log."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "JSON")]
        Json,
    }
}
#[doc = "Information on the configuration of flow log and traffic analytics (optional) ."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogInformation {
    #[doc = "The ID of the resource to configure for flow log and traffic analytics (optional) ."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "Parameters that define the configuration of flow log."]
    pub properties: FlowLogProperties,
    #[doc = "Parameters that define the configuration of traffic analytics."]
    #[serde(rename = "flowAnalyticsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub flow_analytics_configuration: Option<TrafficAnalyticsProperties>,
}
impl FlowLogInformation {
    pub fn new(target_resource_id: String, properties: FlowLogProperties) -> Self {
        Self {
            target_resource_id,
            properties,
            flow_analytics_configuration: None,
        }
    }
}
#[doc = "List of flow logs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FlowLogListResult {
    #[doc = "Information about flow log resource."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FlowLog>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FlowLogListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the configuration of flow log."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogProperties {
    #[doc = "ID of the storage account which is used to store the flow log."]
    #[serde(rename = "storageId")]
    pub storage_id: String,
    #[doc = "Flag to enable/disable flow logging."]
    pub enabled: bool,
    #[doc = "Parameters that define the retention policy for flow log."]
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicyParameters>,
    #[doc = "Parameters that define the flow log format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<FlowLogFormatParameters>,
}
impl FlowLogProperties {
    pub fn new(storage_id: String, enabled: bool) -> Self {
        Self {
            storage_id,
            enabled,
            retention_policy: None,
            format: None,
        }
    }
}
#[doc = "Parameters that define the configuration of flow log."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogPropertiesFormat {
    #[doc = "ID of network security group to which flow log will be applied."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "Guid of network security group to which flow log will be applied."]
    #[serde(rename = "targetResourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_guid: Option<String>,
    #[doc = "ID of the storage account which is used to store the flow log."]
    #[serde(rename = "storageId")]
    pub storage_id: String,
    #[doc = "Flag to enable/disable flow logging."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[doc = "Parameters that define the retention policy for flow log."]
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicyParameters>,
    #[doc = "Parameters that define the flow log format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<FlowLogFormatParameters>,
    #[doc = "Parameters that define the configuration of traffic analytics."]
    #[serde(rename = "flowAnalyticsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub flow_analytics_configuration: Option<TrafficAnalyticsProperties>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl FlowLogPropertiesFormat {
    pub fn new(target_resource_id: String, storage_id: String) -> Self {
        Self {
            target_resource_id,
            target_resource_guid: None,
            storage_id,
            enabled: None,
            retention_policy: None,
            format: None,
            flow_analytics_configuration: None,
            provisioning_state: None,
        }
    }
}
#[doc = "Parameters that define a resource to query flow log and traffic analytics (optional) status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogStatusParameters {
    #[doc = "The target resource where getting the flow log and traffic analytics (optional) status."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
}
impl FlowLogStatusParameters {
    pub fn new(target_resource_id: String) -> Self {
        Self { target_resource_id }
    }
}
#[doc = "Frontend IP address of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Frontend IP Configuration of the load balancer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FrontendIpConfigurationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A list of availability zones denoting the IP allocated for the resource needs to come from."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl FrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Frontend IP Configuration of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfigurationPropertiesFormat {
    #[doc = "An array of references to inbound rules that use this frontend IP."]
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<SubResource>,
    #[doc = "An array of references to inbound pools that use this frontend IP."]
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<SubResource>,
    #[doc = "An array of references to outbound rules that use this frontend IP."]
    #[serde(rename = "outboundRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_rules: Vec<SubResource>,
    #[doc = "An array of references to load balancing rules that use this frontend IP."]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[doc = "The private IP address of the IP configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "IP address allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[doc = "IP address version."]
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<IpVersion>,
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "Public IP address resource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "publicIPPrefix", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_prefix: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "gatewayLoadBalancer", default, skip_serializing_if = "Option::is_none")]
    pub gateway_load_balancer: Option<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl FrontendIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Gateway load balancer tunnel interface of a load balancer backend address pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayLoadBalancerTunnelInterface {
    #[doc = "Port of gateway load balancer tunnel interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "Identifier of gateway load balancer tunnel interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identifier: Option<i32>,
    #[doc = "Protocol of gateway load balancer tunnel interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<gateway_load_balancer_tunnel_interface::Protocol>,
    #[doc = "Traffic type of gateway load balancer tunnel interface."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<gateway_load_balancer_tunnel_interface::Type>,
}
impl GatewayLoadBalancerTunnelInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod gateway_load_balancer_tunnel_interface {
    use super::*;
    #[doc = "Protocol of gateway load balancer tunnel interface."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        None,
        Native,
        #[serde(rename = "VXLAN")]
        Vxlan,
    }
    #[doc = "Traffic type of gateway load balancer tunnel interface."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        None,
        Internal,
        External,
    }
}
#[doc = "Gateway routing details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayRoute {
    #[doc = "The gateway's local address."]
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[doc = "The route's network prefix."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[doc = "The route's next hop."]
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[doc = "The peer this route was learned from."]
    #[serde(rename = "sourcePeer", default, skip_serializing_if = "Option::is_none")]
    pub source_peer: Option<String>,
    #[doc = "The source this route was learned from."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[doc = "The route's AS path sequence."]
    #[serde(rename = "asPath", default, skip_serializing_if = "Option::is_none")]
    pub as_path: Option<String>,
    #[doc = "The route's weight."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
}
impl GatewayRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of virtual network gateway routes."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayRouteListResult {
    #[doc = "List of gateway routes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GatewayRoute>,
}
impl GatewayRouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The customer name to be printed on a letter of authorization."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenerateExpressRoutePortsLoaRequest {
    #[doc = "The customer name."]
    #[serde(rename = "customerName")]
    pub customer_name: String,
}
impl GenerateExpressRoutePortsLoaRequest {
    pub fn new(customer_name: String) -> Self {
        Self { customer_name }
    }
}
#[doc = "Response for GenerateExpressRoutePortsLOA API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenerateExpressRoutePortsLoaResult {
    #[doc = "The content as a base64 encoded string."]
    #[serde(rename = "encodedContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_content: Option<String>,
}
impl GenerateExpressRoutePortsLoaResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of Vpn-Sites."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetVpnSitesConfigurationRequest {
    #[doc = "List of resource-ids of the vpn-sites for which config is to be downloaded."]
    #[serde(rename = "vpnSites", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_sites: Vec<String>,
    #[doc = "The sas-url to download the configurations for vpn-sites."]
    #[serde(rename = "outputBlobSasUrl")]
    pub output_blob_sas_url: String,
}
impl GetVpnSitesConfigurationRequest {
    pub fn new(output_blob_sas_url: String) -> Self {
        Self {
            vpn_sites: Vec::new(),
            output_blob_sas_url,
        }
    }
}
#[doc = "HTTP configuration of the connectivity check."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpConfiguration {
    #[doc = "HTTP method."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<http_configuration::Method>,
    #[doc = "List of HTTP headers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub headers: Vec<HttpHeader>,
    #[doc = "Valid status codes."]
    #[serde(rename = "validStatusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub valid_status_codes: Vec<i32>,
}
impl HttpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod http_configuration {
    use super::*;
    #[doc = "HTTP method."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Method {
        Get,
    }
}
#[doc = "The HTTP header."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpHeader {
    #[doc = "The name in HTTP header."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The value in HTTP header."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl HttpHeader {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hop link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HopLink {
    #[doc = "The ID of the next hop."]
    #[serde(rename = "nextHopId", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_id: Option<String>,
    #[doc = "Link type."]
    #[serde(rename = "linkType", default, skip_serializing_if = "Option::is_none")]
    pub link_type: Option<String>,
    #[doc = "Hop link properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HopLinkProperties>,
    #[doc = "List of issues."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub issues: Vec<ConnectivityIssue>,
    #[doc = "Provides additional context on links."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub context: Option<serde_json::Value>,
    #[doc = "Resource ID."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl HopLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hop link properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HopLinkProperties {
    #[doc = "Minimum roundtrip time in milliseconds."]
    #[serde(rename = "roundTripTimeMin", default, skip_serializing_if = "Option::is_none")]
    pub round_trip_time_min: Option<i64>,
    #[doc = "Average roundtrip time in milliseconds."]
    #[serde(rename = "roundTripTimeAvg", default, skip_serializing_if = "Option::is_none")]
    pub round_trip_time_avg: Option<i64>,
    #[doc = "Maximum roundtrip time in milliseconds."]
    #[serde(rename = "roundTripTimeMax", default, skip_serializing_if = "Option::is_none")]
    pub round_trip_time_max: Option<i64>,
}
impl HopLinkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hub Item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Hub {
    #[doc = "Resource Id."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "Resource Type."]
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
}
impl Hub {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP addresses associated with azure firewall."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubIpAddresses {
    #[doc = "Public IP addresses associated with azure firewall."]
    #[serde(rename = "publicIPs", default, skip_serializing_if = "Option::is_none")]
    pub public_i_ps: Option<HubPublicIpAddresses>,
    #[doc = "Private IP Address associated with azure firewall."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
}
impl HubIpAddresses {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubIpConfigurationPropertiesFormat {
    #[doc = "The private IP address of the IP configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "IP address allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "Public IP address resource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl HubIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IpConfigurations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HubIpConfigurationPropertiesFormat>,
    #[doc = "Name of the Ip Configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Ipconfiguration type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl HubIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Public IP addresses associated with azure firewall."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubPublicIpAddresses {
    #[doc = "The list of Public IP addresses associated with azure firewall or IP addresses to be retained."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub addresses: Vec<AzureFirewallPublicIpAddress>,
    #[doc = "The number of Public IP addresses associated with azure firewall."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
}
impl HubPublicIpAddresses {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "RouteTable route."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubRoute {
    #[doc = "The name of the Route that is unique within a RouteTable. This name can be used to access this route."]
    pub name: String,
    #[doc = "The type of destinations (eg: CIDR, ResourceId, Service)."]
    #[serde(rename = "destinationType")]
    pub destination_type: String,
    #[doc = "List of all destinations."]
    pub destinations: Vec<String>,
    #[doc = "The type of next hop (eg: ResourceId)."]
    #[serde(rename = "nextHopType")]
    pub next_hop_type: String,
    #[doc = "NextHop resource ID."]
    #[serde(rename = "nextHop")]
    pub next_hop: String,
}
impl HubRoute {
    pub fn new(name: String, destination_type: String, destinations: Vec<String>, next_hop_type: String, next_hop: String) -> Self {
        Self {
            name,
            destination_type,
            destinations,
            next_hop_type,
            next_hop,
        }
    }
}
#[doc = "RouteTable resource in a virtual hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubRouteTable {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Parameters for RouteTable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HubRouteTableProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl HubRouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for RouteTable."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubRouteTableProperties {
    #[doc = "List of all routes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<HubRoute>,
    #[doc = "List of labels associated with this route table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<String>,
    #[doc = "List of all connections associated with this route table."]
    #[serde(rename = "associatedConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub associated_connections: Vec<String>,
    #[doc = "List of all connections that advertise to this route table."]
    #[serde(rename = "propagatingConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub propagating_connections: Vec<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl HubRouteTableProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HubVirtualNetworkConnection Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubVirtualNetworkConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Parameters for HubVirtualNetworkConnection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HubVirtualNetworkConnectionProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl HubVirtualNetworkConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for HubVirtualNetworkConnection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubVirtualNetworkConnectionProperties {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "remoteVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub remote_virtual_network: Option<SubResource>,
    #[doc = "Deprecated: VirtualHub to RemoteVnet transit to enabled or not."]
    #[serde(rename = "allowHubToRemoteVnetTransit", default, skip_serializing_if = "Option::is_none")]
    pub allow_hub_to_remote_vnet_transit: Option<bool>,
    #[doc = "Deprecated: Allow RemoteVnet to use Virtual Hub's gateways."]
    #[serde(rename = "allowRemoteVnetToUseHubVnetGateways", default, skip_serializing_if = "Option::is_none")]
    pub allow_remote_vnet_to_use_hub_vnet_gateways: Option<bool>,
    #[doc = "Enable internet security."]
    #[serde(rename = "enableInternetSecurity", default, skip_serializing_if = "Option::is_none")]
    pub enable_internet_security: Option<bool>,
    #[doc = "Routing Configuration indicating the associated and propagated route tables for this connection."]
    #[serde(rename = "routingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub routing_configuration: Option<RoutingConfiguration>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl HubVirtualNetworkConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The current state of the VirtualHub to vnet connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum HubVirtualNetworkConnectionStatus {
    Unknown,
    Connecting,
    Connected,
    NotConnected,
}
#[doc = "Will describe the query to run against the IDPS signatures DB"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IdpsQueryObject {
    #[doc = "Describers the filters to filter response by"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filters: Option<Filters>,
    #[doc = "Search term in all columns"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub search: Option<String>,
    #[doc = "Describes a column to sort"]
    #[serde(rename = "orderBy", default, skip_serializing_if = "Option::is_none")]
    pub order_by: Option<OrderBy>,
    #[doc = "The number of the results to return in each page"]
    #[serde(rename = "resultsPerPage", default, skip_serializing_if = "Option::is_none")]
    pub results_per_page: Option<i32>,
    #[doc = "The number of records matching the filter to skip"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub skip: Option<i32>,
}
impl IdpsQueryObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for CheckIPAddressAvailability API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressAvailabilityResult {
    #[doc = "Private IP address availability."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
    #[doc = "Contains other available private IP addresses if the asked for address is taken."]
    #[serde(rename = "availableIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub available_ip_addresses: Vec<String>,
    #[doc = "Private IP address platform reserved."]
    #[serde(rename = "isPlatformReserved", default, skip_serializing_if = "Option::is_none")]
    pub is_platform_reserved: Option<bool>,
}
impl IpAddressAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP address allocation method."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpAllocationMethod {
    Static,
    Dynamic,
}
#[doc = "IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpConfigurationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IPConfigurationBgpPeeringAddress."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationBgpPeeringAddress {
    #[doc = "The ID of IP configuration which belongs to gateway."]
    #[serde(rename = "ipconfigurationId", default, skip_serializing_if = "Option::is_none")]
    pub ipconfiguration_id: Option<String>,
    #[doc = "The list of default BGP peering addresses which belong to IP configuration."]
    #[serde(rename = "defaultBgpIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub default_bgp_ip_addresses: Vec<String>,
    #[doc = "The list of custom BGP peering addresses which belong to IP configuration."]
    #[serde(rename = "customBgpIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_bgp_ip_addresses: Vec<String>,
    #[doc = "The list of tunnel public IP addresses which belong to IP configuration."]
    #[serde(rename = "tunnelIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_ip_addresses: Vec<String>,
}
impl IpConfigurationBgpPeeringAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP configuration profile child resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationProfile {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "IP configuration profile properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpConfigurationProfilePropertiesFormat>,
    #[doc = "The name of the resource. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Sub Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpConfigurationProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP configuration profile properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationProfilePropertiesFormat {
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl IpConfigurationProfilePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationPropertiesFormat {
    #[doc = "The private IP address of the IP configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "IP address allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "Public IP address resource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl IpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP address version."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpVersion {
    IPv4,
    IPv6,
}
#[doc = "The IKE encryption algorithm (IKE phase 2)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IkeEncryption {
    #[serde(rename = "DES")]
    Des,
    #[serde(rename = "DES3")]
    Des3,
    #[serde(rename = "AES128")]
    Aes128,
    #[serde(rename = "AES192")]
    Aes192,
    #[serde(rename = "AES256")]
    Aes256,
    #[serde(rename = "GCMAES256")]
    Gcmaes256,
    #[serde(rename = "GCMAES128")]
    Gcmaes128,
}
#[doc = "The IKE integrity algorithm (IKE phase 2)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IkeIntegrity {
    #[serde(rename = "MD5")]
    Md5,
    #[serde(rename = "SHA1")]
    Sha1,
    #[serde(rename = "SHA256")]
    Sha256,
    #[serde(rename = "SHA384")]
    Sha384,
    #[serde(rename = "GCMAES256")]
    Gcmaes256,
    #[serde(rename = "GCMAES128")]
    Gcmaes128,
}
#[doc = "Inbound NAT pool of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Inbound NAT pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatPoolPropertiesFormat>,
    #[doc = "The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl InboundNatPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Inbound NAT pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundNatPoolPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "The transport protocol for the endpoint."]
    pub protocol: TransportProtocol,
    #[doc = "The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534."]
    #[serde(rename = "frontendPortRangeStart")]
    pub frontend_port_range_start: i32,
    #[doc = "The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535."]
    #[serde(rename = "frontendPortRangeEnd")]
    pub frontend_port_range_end: i32,
    #[doc = "The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535."]
    #[serde(rename = "backendPort")]
    pub backend_port: i32,
    #[doc = "The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint."]
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[doc = "Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl InboundNatPoolPropertiesFormat {
    pub fn new(protocol: TransportProtocol, frontend_port_range_start: i32, frontend_port_range_end: i32, backend_port: i32) -> Self {
        Self {
            frontend_ip_configuration: None,
            protocol,
            frontend_port_range_start,
            frontend_port_range_end,
            backend_port,
            idle_timeout_in_minutes: None,
            enable_floating_ip: None,
            enable_tcp_reset: None,
            provisioning_state: None,
        }
    }
}
#[doc = "Inbound NAT rule of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the inbound NAT rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl InboundNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListInboundNatRule API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRuleListResult {
    #[doc = "A list of inbound NAT rules in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<InboundNatRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl InboundNatRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Individual port mappings for inbound NAT rule created for backend pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRulePortMapping {
    #[doc = "Name of inbound NAT rule."]
    #[serde(rename = "inboundNatRuleName", default, skip_serializing_if = "Option::is_none")]
    pub inbound_nat_rule_name: Option<String>,
    #[doc = "The transport protocol for the endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<TransportProtocol>,
    #[doc = "Frontend port."]
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<i32>,
    #[doc = "Backend port."]
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
}
impl InboundNatRulePortMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the inbound NAT rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRulePropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "IPConfiguration in a network interface."]
    #[serde(rename = "backendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub backend_ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[doc = "The transport protocol for the endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<TransportProtocol>,
    #[doc = "The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534."]
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<i32>,
    #[doc = "The port used for the internal endpoint. Acceptable values range from 1 to 65535."]
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[doc = "The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint."]
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[doc = "Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[doc = "The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534."]
    #[serde(rename = "frontendPortRangeStart", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port_range_start: Option<i32>,
    #[doc = "The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534."]
    #[serde(rename = "frontendPortRangeEnd", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port_range_end: Option<i32>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl InboundNatRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NVA Inbound Security Rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundSecurityRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the Inbound Security Rules resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundSecurityRuleProperties>,
    #[doc = "Name of security rule collection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "NVA inbound security rule type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl InboundSecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the Inbound Security Rules resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundSecurityRuleProperties {
    #[doc = "List of allowed rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<InboundSecurityRules>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl InboundSecurityRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the Inbound Security Rules resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundSecurityRules {
    #[doc = "Protocol. This should be either TCP or UDP."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<inbound_security_rules::Protocol>,
    #[doc = "The CIDR or source IP range. Only /30, /31 and /32 Ip ranges are allowed."]
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[doc = "NVA port ranges to be opened up. One needs to provide specific ports."]
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<i32>,
}
impl InboundSecurityRules {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod inbound_security_rules {
    use super::*;
    #[doc = "Protocol. This should be either TCP or UDP."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
    }
}
#[doc = "IpAllocation resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAllocation {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the IpAllocation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpAllocationPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpAllocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListIpAllocations API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAllocationListResult {
    #[doc = "A list of IpAllocation resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IpAllocation>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IpAllocationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the IpAllocation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAllocationPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network: Option<SubResource>,
    #[doc = "IpAllocation type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<IpAllocationType>,
    #[doc = "The address prefix for the IpAllocation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<String>,
    #[doc = "The address prefix length for the IpAllocation."]
    #[serde(rename = "prefixLength", default, skip_serializing_if = "Option::is_none")]
    pub prefix_length: Option<i64>,
    #[doc = "IP address version."]
    #[serde(rename = "prefixType", default, skip_serializing_if = "Option::is_none")]
    pub prefix_type: Option<IpVersion>,
    #[doc = "The IPAM allocation ID."]
    #[serde(rename = "ipamAllocationId", default, skip_serializing_if = "Option::is_none")]
    pub ipam_allocation_id: Option<String>,
    #[doc = "IpAllocation tags."]
    #[serde(rename = "allocationTags", default, skip_serializing_if = "Option::is_none")]
    pub allocation_tags: Option<serde_json::Value>,
}
impl IpAllocationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IpAllocation type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpAllocationType {
    Undefined,
    Hypernet,
}
#[doc = "The IpGroups resource information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "The IpGroups property information."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpGroupPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListIpGroups API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpGroupListResult {
    #[doc = "The list of IpGroups information resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IpGroup>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IpGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The IpGroups property information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpGroupPropertiesFormat {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "IpAddresses/IpAddressPrefixes in the IpGroups resource."]
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
    #[doc = "List of references to Firewall resources that this IpGroups is associated with."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub firewalls: Vec<SubResource>,
    #[doc = "List of references to Firewall Policies resources that this IpGroups is associated with."]
    #[serde(rename = "firewallPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub firewall_policies: Vec<SubResource>,
}
impl IpGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type IpGroups = Vec<AzureFirewallIpGroups>;
#[doc = "Contains the IpTag associated with the object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpTag {
    #[doc = "The IP tag type. Example: FirstPartyUsage."]
    #[serde(rename = "ipTagType", default, skip_serializing_if = "Option::is_none")]
    pub ip_tag_type: Option<String>,
    #[doc = "The value of the IP tag associated with the public IP. Example: SQL."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
}
impl IpTag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The IPSec encryption algorithm (IKE phase 1)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpsecEncryption {
    None,
    #[serde(rename = "DES")]
    Des,
    #[serde(rename = "DES3")]
    Des3,
    #[serde(rename = "AES128")]
    Aes128,
    #[serde(rename = "AES192")]
    Aes192,
    #[serde(rename = "AES256")]
    Aes256,
    #[serde(rename = "GCMAES128")]
    Gcmaes128,
    #[serde(rename = "GCMAES192")]
    Gcmaes192,
    #[serde(rename = "GCMAES256")]
    Gcmaes256,
}
#[doc = "The IPSec integrity algorithm (IKE phase 1)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpsecIntegrity {
    #[serde(rename = "MD5")]
    Md5,
    #[serde(rename = "SHA1")]
    Sha1,
    #[serde(rename = "SHA256")]
    Sha256,
    #[serde(rename = "GCMAES128")]
    Gcmaes128,
    #[serde(rename = "GCMAES192")]
    Gcmaes192,
    #[serde(rename = "GCMAES256")]
    Gcmaes256,
}
#[doc = "An IPSec Policy configuration for a virtual network gateway connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpsecPolicy {
    #[doc = "The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel."]
    #[serde(rename = "saLifeTimeSeconds")]
    pub sa_life_time_seconds: i32,
    #[doc = "The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel."]
    #[serde(rename = "saDataSizeKilobytes")]
    pub sa_data_size_kilobytes: i32,
    #[doc = "The IPSec encryption algorithm (IKE phase 1)."]
    #[serde(rename = "ipsecEncryption")]
    pub ipsec_encryption: IpsecEncryption,
    #[doc = "The IPSec integrity algorithm (IKE phase 1)."]
    #[serde(rename = "ipsecIntegrity")]
    pub ipsec_integrity: IpsecIntegrity,
    #[doc = "The IKE encryption algorithm (IKE phase 2)."]
    #[serde(rename = "ikeEncryption")]
    pub ike_encryption: IkeEncryption,
    #[doc = "The IKE integrity algorithm (IKE phase 2)."]
    #[serde(rename = "ikeIntegrity")]
    pub ike_integrity: IkeIntegrity,
    #[doc = "The DH Groups used in IKE Phase 1 for initial SA."]
    #[serde(rename = "dhGroup")]
    pub dh_group: DhGroup,
    #[doc = "The Pfs Groups used in IKE Phase 2 for new child SA."]
    #[serde(rename = "pfsGroup")]
    pub pfs_group: PfsGroup,
}
impl IpsecPolicy {
    pub fn new(
        sa_life_time_seconds: i32,
        sa_data_size_kilobytes: i32,
        ipsec_encryption: IpsecEncryption,
        ipsec_integrity: IpsecIntegrity,
        ike_encryption: IkeEncryption,
        ike_integrity: IkeIntegrity,
        dh_group: DhGroup,
        pfs_group: PfsGroup,
    ) -> Self {
        Self {
            sa_life_time_seconds,
            sa_data_size_kilobytes,
            ipsec_encryption,
            ipsec_integrity,
            ike_encryption,
            ike_integrity,
            dh_group,
            pfs_group,
        }
    }
}
#[doc = "IPv6 Circuit Connection properties for global reach."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Ipv6CircuitConnectionConfig {
    #[doc = "/125 IP address space to carve out customer addresses for global reach."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "Express Route Circuit connection state."]
    #[serde(rename = "circuitConnectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub circuit_connection_status: Option<CircuitConnectionStatus>,
}
impl Ipv6CircuitConnectionConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains IPv6 peering config."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Ipv6ExpressRouteCircuitPeeringConfig {
    #[doc = "The primary address prefix."]
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[doc = "The secondary address prefix."]
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[doc = "Specifies the peering configuration."]
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "routeFilter", default, skip_serializing_if = "Option::is_none")]
    pub route_filter: Option<SubResource>,
    #[doc = "The state of peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ipv6_express_route_circuit_peering_config::State>,
}
impl Ipv6ExpressRouteCircuitPeeringConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ipv6_express_route_circuit_peering_config {
    use super::*;
    #[doc = "The state of peering."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
        Enabled,
    }
}
#[doc = "A key-value pair that provides additional context on the issue."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueContext {}
impl IssueContext {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of RouteTables and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListHubRouteTablesResult {
    #[doc = "List of RouteTables."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HubRouteTable>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListHubRouteTablesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of HubVirtualNetworkConnections and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListHubVirtualNetworkConnectionsResult {
    #[doc = "List of HubVirtualNetworkConnections."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HubVirtualNetworkConnection>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListHubVirtualNetworkConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list P2SVpnGateways. It contains a list of P2SVpnGateways and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListP2sVpnGatewaysResult {
    #[doc = "List of P2SVpnGateways."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<P2sVpnGateway>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListP2sVpnGatewaysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of the routing intent result and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListRoutingIntentResult {
    #[doc = "List of RoutingIntent resource."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RoutingIntent>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListRoutingIntentResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualHubBgpConnections list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualHubBgpConnectionResults {
    #[doc = "The list of VirtualHubBgpConnections."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BgpConnection>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualHubBgpConnectionResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualHubIpConfigurations list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualHubIpConfigurationResults {
    #[doc = "The list of VirtualHubIpConfigurations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HubIpConfiguration>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualHubIpConfigurationResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of VirtualHubRouteTableV2s and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualHubRouteTableV2sResult {
    #[doc = "List of VirtualHubRouteTableV2s."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualHubRouteTableV2>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualHubRouteTableV2sResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list VirtualHubs. It contains a list of VirtualHubs and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualHubsResult {
    #[doc = "List of VirtualHubs."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualHub>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualHubsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list all nat rules to a virtual network gateway. It contains a list of Nat rules and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualNetworkGatewayNatRulesResult {
    #[doc = "List of Nat Rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayNatRule>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualNetworkGatewayNatRulesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list VirtualWANs. It contains a list of VirtualWANs and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualWaNsResult {
    #[doc = "List of VirtualWANs."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualWan>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualWaNsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains a list of Vpn Connections and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnConnectionsResult {
    #[doc = "List of Vpn Connections."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnConnection>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list all nat rules to a virtual wan vpn gateway. It contains a list of Nat rules and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnGatewayNatRulesResult {
    #[doc = "List of Nat Rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnGatewayNatRule>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnGatewayNatRulesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list VpnGateways. It contains a list of VpnGateways and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnGatewaysResult {
    #[doc = "List of VpnGateways."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnGateway>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnGatewaysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list all VpnServerConfigurations. It contains a list of VpnServerConfigurations and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnServerConfigurationsResult {
    #[doc = "List of VpnServerConfigurations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnServerConfiguration>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnServerConfigurationsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains a list of Vpn Connections and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnSiteLinkConnectionsResult {
    #[doc = "List of VpnSiteLinkConnections."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnSiteLinkConnection>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnSiteLinkConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list VpnSiteLinks. It contains a list of VpnSiteLinks and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnSiteLinksResult {
    #[doc = "List of VpnSitesLinks."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnSiteLink>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnSiteLinksResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list VpnSites. It contains a list of VpnSites and a URL nextLink to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnSitesResult {
    #[doc = "List of VpnSites."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnSite>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnSitesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "LoadBalancer resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancer {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "ExtendedLocation complex type."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<ExtendedLocation>,
    #[doc = "SKU of a load balancer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<LoadBalancerSku>,
    #[doc = "Properties of the load balancer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancerPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LoadBalancer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Load balancer backend addresses."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerBackendAddress {
    #[doc = "Properties of the load balancer backend addresses."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancerBackendAddressPropertiesFormat>,
    #[doc = "Name of the backend address."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl LoadBalancerBackendAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListBackendAddressPool API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerBackendAddressPoolListResult {
    #[doc = "A list of backend address pools in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackendAddressPool>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerBackendAddressPoolListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the load balancer backend addresses."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerBackendAddressPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "IP Address belonging to the referenced virtual network."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "networkInterfaceIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub network_interface_ip_configuration: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "loadBalancerFrontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub load_balancer_frontend_ip_configuration: Option<SubResource>,
    #[doc = "Collection of inbound NAT rule port mappings."]
    #[serde(rename = "inboundNatRulesPortMapping", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules_port_mapping: Vec<NatRulePortMapping>,
}
impl LoadBalancerBackendAddressPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListFrontendIPConfiguration API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerFrontendIpConfigurationListResult {
    #[doc = "A list of frontend IP configurations in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FrontendIpConfiguration>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerFrontendIpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListLoadBalancers API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerListResult {
    #[doc = "A list of load balancers in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancer>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListLoadBalancingRule API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerLoadBalancingRuleListResult {
    #[doc = "A list of load balancing rules in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancingRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerLoadBalancingRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListOutboundRule API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerOutboundRuleListResult {
    #[doc = "A list of outbound rules in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OutboundRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerOutboundRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListProbe API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerProbeListResult {
    #[doc = "A list of probes in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Probe>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerProbeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerPropertiesFormat {
    #[doc = "Object representing the frontend IPs to be used for the load balancer."]
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<FrontendIpConfiguration>,
    #[doc = "Collection of backend address pools used by a load balancer."]
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<BackendAddressPool>,
    #[doc = "Object collection representing the load balancing rules Gets the provisioning."]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<LoadBalancingRule>,
    #[doc = "Collection of probe objects used in the load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub probes: Vec<Probe>,
    #[doc = "Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules."]
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<InboundNatRule>,
    #[doc = "Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules."]
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<InboundNatPool>,
    #[doc = "The outbound rules."]
    #[serde(rename = "outboundRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_rules: Vec<OutboundRule>,
    #[doc = "The resource GUID property of the load balancer resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl LoadBalancerPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SKU of a load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerSku {
    #[doc = "Name of a load balancer SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<load_balancer_sku::Name>,
    #[doc = "Tier of a load balancer SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<load_balancer_sku::Tier>,
}
impl LoadBalancerSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod load_balancer_sku {
    use super::*;
    #[doc = "Name of a load balancer SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
        Gateway,
    }
    #[doc = "Tier of a load balancer SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Regional,
        Global,
    }
}
#[doc = "The request for a VIP swap."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerVipSwapRequest {
    #[doc = "A list of frontend IP configuration resources that should swap VIPs."]
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<LoadBalancerVipSwapRequestFrontendIpConfiguration>,
}
impl LoadBalancerVipSwapRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VIP swap request's frontend IP configuration object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerVipSwapRequestFrontendIpConfiguration {
    #[doc = "The ID of frontend IP configuration resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The properties of VIP swap request's frontend IP configuration object."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancerVipSwapRequestFrontendIpConfigurationProperties>,
}
impl LoadBalancerVipSwapRequestFrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of VIP swap request's frontend IP configuration object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerVipSwapRequestFrontendIpConfigurationProperties {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
}
impl LoadBalancerVipSwapRequestFrontendIpConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A load balancing rule for a load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancingRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the load balancer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancingRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl LoadBalancingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LoadBalancingRulePropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[doc = "An array of references to pool of DIPs."]
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub probe: Option<SubResource>,
    #[doc = "The transport protocol for the endpoint."]
    pub protocol: TransportProtocol,
    #[doc = "The load distribution policy for this rule."]
    #[serde(rename = "loadDistribution", default, skip_serializing_if = "Option::is_none")]
    pub load_distribution: Option<load_balancing_rule_properties_format::LoadDistribution>,
    #[doc = "The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables \"Any Port\"."]
    #[serde(rename = "frontendPort")]
    pub frontend_port: i32,
    #[doc = "The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables \"Any Port\"."]
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[doc = "The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint."]
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[doc = "Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[doc = "Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule."]
    #[serde(rename = "disableOutboundSnat", default, skip_serializing_if = "Option::is_none")]
    pub disable_outbound_snat: Option<bool>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl LoadBalancingRulePropertiesFormat {
    pub fn new(protocol: TransportProtocol, frontend_port: i32) -> Self {
        Self {
            frontend_ip_configuration: None,
            backend_address_pool: None,
            backend_address_pools: Vec::new(),
            probe: None,
            protocol,
            load_distribution: None,
            frontend_port,
            backend_port: None,
            idle_timeout_in_minutes: None,
            enable_floating_ip: None,
            enable_tcp_reset: None,
            disable_outbound_snat: None,
            provisioning_state: None,
        }
    }
}
pub mod load_balancing_rule_properties_format {
    use super::*;
    #[doc = "The load distribution policy for this rule."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadDistribution {
        Default,
        #[serde(rename = "SourceIP")]
        SourceIp,
        #[serde(rename = "SourceIPProtocol")]
        SourceIpProtocol,
    }
}
#[doc = "A common class for general resource information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LocalNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "LocalNetworkGateway properties."]
    pub properties: LocalNetworkGatewayPropertiesFormat,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LocalNetworkGateway {
    pub fn new(properties: LocalNetworkGatewayPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[doc = "Response for ListLocalNetworkGateways API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayListResult {
    #[doc = "A list of local network gateways that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LocalNetworkGateway>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LocalNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "LocalNetworkGateway properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayPropertiesFormat {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "localNetworkAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub local_network_address_space: Option<AddressSpace>,
    #[doc = "IP address of local network gateway."]
    #[serde(rename = "gatewayIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub gateway_ip_address: Option<String>,
    #[doc = "FQDN of local network gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "BGP settings details."]
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[doc = "The resource GUID property of the local network gateway resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl LocalNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Description of logging specification."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogSpecification {
    #[doc = "The name of the specification."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The display name of the specification."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Duration of the blob."]
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl LogSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines a managed rule group override setting."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRuleGroupOverride {
    #[doc = "The managed rule group to override."]
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[doc = "List of rules that will be disabled. If none specified, all rules in the group will be disabled."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<ManagedRuleOverride>,
}
impl ManagedRuleGroupOverride {
    pub fn new(rule_group_name: String) -> Self {
        Self {
            rule_group_name,
            rules: Vec::new(),
        }
    }
}
#[doc = "Defines a managed rule group override setting."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRuleOverride {
    #[doc = "Identifier for the managed rule."]
    #[serde(rename = "ruleId")]
    pub rule_id: String,
    #[doc = "The state of the managed rule. Defaults to Disabled if not specified."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<managed_rule_override::State>,
}
impl ManagedRuleOverride {
    pub fn new(rule_id: String) -> Self {
        Self { rule_id, state: None }
    }
}
pub mod managed_rule_override {
    use super::*;
    #[doc = "The state of the managed rule. Defaults to Disabled if not specified."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
    }
}
#[doc = "Defines a managed rule set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRuleSet {
    #[doc = "Defines the rule set type to use."]
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[doc = "Defines the version of the rule set to use."]
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[doc = "Defines the rule group overrides to apply to the rule set."]
    #[serde(rename = "ruleGroupOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_group_overrides: Vec<ManagedRuleGroupOverride>,
}
impl ManagedRuleSet {
    pub fn new(rule_set_type: String, rule_set_version: String) -> Self {
        Self {
            rule_set_type,
            rule_set_version,
            rule_group_overrides: Vec::new(),
        }
    }
}
#[doc = "Allow to exclude some variable satisfy the condition for the WAF check."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRulesDefinition {
    #[doc = "The Exclusions that are applied on the policy."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub exclusions: Vec<OwaspCrsExclusionEntry>,
    #[doc = "The managed rule sets that are associated with the policy."]
    #[serde(rename = "managedRuleSets")]
    pub managed_rule_sets: Vec<ManagedRuleSet>,
}
impl ManagedRulesDefinition {
    pub fn new(managed_rule_sets: Vec<ManagedRuleSet>) -> Self {
        Self {
            exclusions: Vec::new(),
            managed_rule_sets,
        }
    }
}
#[doc = "Identity for the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedServiceIdentity {
    #[doc = "The principal id of the system assigned identity. This property will only be provided for a system assigned identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The tenant id of the system assigned identity. This property will only be provided for a system assigned identity."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<managed_service_identity::Type>,
    #[doc = "The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."]
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl ManagedServiceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_service_identity {
    use super::*;
    #[doc = "The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[doc = "Define match conditions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MatchCondition {
    #[doc = "List of match variables."]
    #[serde(rename = "matchVariables")]
    pub match_variables: Vec<MatchVariable>,
    #[doc = "The operator to be matched."]
    pub operator: match_condition::Operator,
    #[doc = "Whether this is negate condition or not."]
    #[serde(rename = "negationConditon", default, skip_serializing_if = "Option::is_none")]
    pub negation_conditon: Option<bool>,
    #[doc = "Match value."]
    #[serde(rename = "matchValues")]
    pub match_values: Vec<String>,
    #[doc = "List of transforms."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl MatchCondition {
    pub fn new(match_variables: Vec<MatchVariable>, operator: match_condition::Operator, match_values: Vec<String>) -> Self {
        Self {
            match_variables,
            operator,
            negation_conditon: None,
            match_values,
            transforms: Vec::new(),
        }
    }
}
pub mod match_condition {
    use super::*;
    #[doc = "The operator to be matched."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        #[serde(rename = "IPMatch")]
        IpMatch,
        Equal,
        Contains,
        LessThan,
        GreaterThan,
        LessThanOrEqual,
        GreaterThanOrEqual,
        BeginsWith,
        EndsWith,
        Regex,
        GeoMatch,
    }
}
#[doc = "Define match variables."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MatchVariable {
    #[doc = "Match Variable."]
    #[serde(rename = "variableName")]
    pub variable_name: match_variable::VariableName,
    #[doc = "The selector of match variable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub selector: Option<String>,
}
impl MatchVariable {
    pub fn new(variable_name: match_variable::VariableName) -> Self {
        Self {
            variable_name,
            selector: None,
        }
    }
}
pub mod match_variable {
    use super::*;
    #[doc = "Match Variable."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VariableName {
        RemoteAddr,
        RequestMethod,
        QueryString,
        PostArgs,
        RequestUri,
        RequestHeaders,
        RequestBody,
        RequestCookies,
    }
}
#[doc = "Matched rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MatchedRule {
    #[doc = "Name of the matched network security rule."]
    #[serde(rename = "ruleName", default, skip_serializing_if = "Option::is_none")]
    pub rule_name: Option<String>,
    #[doc = "The network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
}
impl MatchedRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Description of metrics specification."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSpecification {
    #[doc = "The name of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The display name of the metric."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The description of the metric."]
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[doc = "Units the metric to be displayed in."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[doc = "The aggregation type."]
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[doc = "List of availability."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub availabilities: Vec<Availability>,
    #[doc = "Whether regional MDM account enabled."]
    #[serde(rename = "enableRegionalMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub enable_regional_mdm_account: Option<bool>,
    #[doc = "Whether gaps would be filled with zeros."]
    #[serde(rename = "fillGapWithZero", default, skip_serializing_if = "Option::is_none")]
    pub fill_gap_with_zero: Option<bool>,
    #[doc = "Pattern for the filter of the metric."]
    #[serde(rename = "metricFilterPattern", default, skip_serializing_if = "Option::is_none")]
    pub metric_filter_pattern: Option<String>,
    #[doc = "List of dimensions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Dimension>,
    #[doc = "Whether the metric is internal."]
    #[serde(rename = "isInternal", default, skip_serializing_if = "Option::is_none")]
    pub is_internal: Option<bool>,
    #[doc = "The source MDM account."]
    #[serde(rename = "sourceMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_account: Option<String>,
    #[doc = "The source MDM namespace."]
    #[serde(rename = "sourceMdmNamespace", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_namespace: Option<String>,
    #[doc = "The resource Id dimension name override."]
    #[serde(rename = "resourceIdDimensionNameOverride", default, skip_serializing_if = "Option::is_none")]
    pub resource_id_dimension_name_override: Option<String>,
}
impl MetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Nat Gateway resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NatGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "SKU of nat gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<NatGatewaySku>,
    #[doc = "Nat Gateway properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NatGatewayPropertiesFormat>,
    #[doc = "A list of availability zones denoting the zone in which Nat Gateway should be deployed."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NatGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListNatGateways API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NatGatewayListResult {
    #[doc = "A list of Nat Gateways that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NatGateway>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NatGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Nat Gateway properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NatGatewayPropertiesFormat {
    #[doc = "The idle timeout of the nat gateway."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "An array of public ip addresses associated with the nat gateway resource."]
    #[serde(rename = "publicIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_addresses: Vec<SubResource>,
    #[doc = "An array of public ip prefixes associated with the nat gateway resource."]
    #[serde(rename = "publicIpPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_prefixes: Vec<SubResource>,
    #[doc = "An array of references to the subnets using this nat gateway resource."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<SubResource>,
    #[doc = "The resource GUID property of the NAT gateway resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NatGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SKU of nat gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NatGatewaySku {
    #[doc = "Name of Nat Gateway SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<nat_gateway_sku::Name>,
}
impl NatGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod nat_gateway_sku {
    use super::*;
    #[doc = "Name of Nat Gateway SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Standard,
    }
}
#[doc = "Rule of type nat."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NatRule {
    #[serde(flatten)]
    pub firewall_policy_rule: FirewallPolicyRule,
    #[doc = "Array of FirewallPolicyRuleNetworkProtocols."]
    #[serde(rename = "ipProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_protocols: Vec<FirewallPolicyRuleNetworkProtocol>,
    #[doc = "List of source IP addresses for this rule."]
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[doc = "List of destination IP addresses or Service Tags."]
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[doc = "List of destination ports."]
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<String>,
    #[doc = "The translated address for this NAT rule."]
    #[serde(rename = "translatedAddress", default, skip_serializing_if = "Option::is_none")]
    pub translated_address: Option<String>,
    #[doc = "The translated port for this NAT rule."]
    #[serde(rename = "translatedPort", default, skip_serializing_if = "Option::is_none")]
    pub translated_port: Option<String>,
    #[doc = "List of source IpGroups for this rule."]
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
    #[doc = "The translated FQDN for this NAT rule."]
    #[serde(rename = "translatedFqdn", default, skip_serializing_if = "Option::is_none")]
    pub translated_fqdn: Option<String>,
}
impl NatRule {
    pub fn new(firewall_policy_rule: FirewallPolicyRule) -> Self {
        Self {
            firewall_policy_rule,
            ip_protocols: Vec::new(),
            source_addresses: Vec::new(),
            destination_addresses: Vec::new(),
            destination_ports: Vec::new(),
            translated_address: None,
            translated_port: None,
            source_ip_groups: Vec::new(),
            translated_fqdn: None,
        }
    }
}
#[doc = "Individual port mappings for inbound NAT rule created for backend pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NatRulePortMapping {
    #[doc = "Name of inbound NAT rule."]
    #[serde(rename = "inboundNatRuleName", default, skip_serializing_if = "Option::is_none")]
    pub inbound_nat_rule_name: Option<String>,
    #[doc = "Frontend port."]
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<i32>,
    #[doc = "Backend port."]
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
}
impl NatRulePortMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters to get network configuration diagnostic."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkConfigurationDiagnosticParameters {
    #[doc = "The ID of the target resource to perform network configuration diagnostic. Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application Gateway."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "Verbosity level."]
    #[serde(rename = "verbosityLevel", default, skip_serializing_if = "Option::is_none")]
    pub verbosity_level: Option<network_configuration_diagnostic_parameters::VerbosityLevel>,
    #[doc = "List of network configuration diagnostic profiles."]
    pub profiles: Vec<NetworkConfigurationDiagnosticProfile>,
}
impl NetworkConfigurationDiagnosticParameters {
    pub fn new(target_resource_id: String, profiles: Vec<NetworkConfigurationDiagnosticProfile>) -> Self {
        Self {
            target_resource_id,
            verbosity_level: None,
            profiles,
        }
    }
}
pub mod network_configuration_diagnostic_parameters {
    use super::*;
    #[doc = "Verbosity level."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VerbosityLevel {
        Normal,
        Minimum,
        Full,
    }
}
#[doc = "Parameters to compare with network configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkConfigurationDiagnosticProfile {
    #[doc = "The direction of the traffic."]
    pub direction: Direction,
    #[doc = "Protocol to be verified on. Accepted values are '*', TCP, UDP."]
    pub protocol: String,
    #[doc = "Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag."]
    pub source: String,
    #[doc = "Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag."]
    pub destination: String,
    #[doc = "Traffic destination port. Accepted values are '*' and a single port in the range (0 - 65535)."]
    #[serde(rename = "destinationPort")]
    pub destination_port: String,
}
impl NetworkConfigurationDiagnosticProfile {
    pub fn new(direction: Direction, protocol: String, source: String, destination: String, destination_port: String) -> Self {
        Self {
            direction,
            protocol,
            source,
            destination,
            destination_port,
        }
    }
}
#[doc = "Results of network configuration diagnostic on the target resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkConfigurationDiagnosticResponse {
    #[doc = "List of network configuration diagnostic results."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub results: Vec<NetworkConfigurationDiagnosticResult>,
}
impl NetworkConfigurationDiagnosticResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network configuration diagnostic result corresponded to provided traffic query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkConfigurationDiagnosticResult {
    #[doc = "Parameters to compare with network configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub profile: Option<NetworkConfigurationDiagnosticProfile>,
    #[doc = "Network configuration diagnostic result corresponded provided traffic query."]
    #[serde(rename = "networkSecurityGroupResult", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group_result: Option<NetworkSecurityGroupResult>,
}
impl NetworkConfigurationDiagnosticResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The network group resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkGroup {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of network group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkGroupProperties>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl NetworkGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list NetworkGroup. It contains a list of groups and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkGroupListResult {
    #[doc = "Gets a page of NetworkGroup"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkGroup>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of network group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkGroupProperties {
    #[doc = "A friendly name for the network group."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the network group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Group member type."]
    #[serde(rename = "memberType")]
    pub member_type: String,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkGroupProperties {
    pub fn new(member_type: String) -> Self {
        Self {
            display_name: None,
            description: None,
            member_type,
            provisioning_state: None,
        }
    }
}
#[doc = "Network Intent Policy resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkIntentPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkIntentPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network intent policy based services."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum NetworkIntentPolicyBasedService {
    None,
    All,
}
#[doc = "Details of NetworkIntentPolicyConfiguration for PrepareNetworkPoliciesRequest."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkIntentPolicyConfiguration {
    #[doc = "The name of the Network Intent Policy for storing in target subscription."]
    #[serde(rename = "networkIntentPolicyName", default, skip_serializing_if = "Option::is_none")]
    pub network_intent_policy_name: Option<String>,
    #[doc = "Network Intent Policy resource."]
    #[serde(rename = "sourceNetworkIntentPolicy", default, skip_serializing_if = "Option::is_none")]
    pub source_network_intent_policy: Option<NetworkIntentPolicy>,
}
impl NetworkIntentPolicyConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A network interface in a resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterface {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "ExtendedLocation complex type."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<ExtendedLocation>,
    #[doc = "NetworkInterface properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfacePropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network interface and its custom security rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceAssociation {
    #[doc = "Network interface ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Collection of custom security rules."]
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
}
impl NetworkInterfaceAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DNS settings of a network interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceDnsSettings {
    #[doc = "List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection."]
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
    #[doc = "If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs."]
    #[serde(rename = "appliedDnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub applied_dns_servers: Vec<String>,
    #[doc = "Relative DNS name for this NIC used for internal communications between VMs in the same virtual network."]
    #[serde(rename = "internalDnsNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub internal_dns_name_label: Option<String>,
    #[doc = "Fully qualified DNS name supporting internal communications between VMs in the same virtual network."]
    #[serde(rename = "internalFqdn", default, skip_serializing_if = "Option::is_none")]
    pub internal_fqdn: Option<String>,
    #[doc = "Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix."]
    #[serde(rename = "internalDomainNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub internal_domain_name_suffix: Option<String>,
}
impl NetworkInterfaceDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IPConfiguration in a network interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceIpConfigurationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl NetworkInterfaceIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for list ip configurations API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationListResult {
    #[doc = "A list of ip configurations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceIpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "PrivateLinkConnection properties for the network interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties {
    #[doc = "The group ID for current private link connection."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[doc = "The required member name for current private link connection."]
    #[serde(rename = "requiredMemberName", default, skip_serializing_if = "Option::is_none")]
    pub required_member_name: Option<String>,
    #[doc = "List of FQDNs for current private link connection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub fqdns: Vec<String>,
}
impl NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "gatewayLoadBalancer", default, skip_serializing_if = "Option::is_none")]
    pub gateway_load_balancer: Option<SubResource>,
    #[doc = "The reference to Virtual Network Taps."]
    #[serde(rename = "virtualNetworkTaps", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_taps: Vec<VirtualNetworkTap>,
    #[doc = "The reference to ApplicationGatewayBackendAddressPool resource."]
    #[serde(rename = "applicationGatewayBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_backend_address_pools: Vec<ApplicationGatewayBackendAddressPool>,
    #[doc = "The reference to LoadBalancerBackendAddressPool resource."]
    #[serde(rename = "loadBalancerBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_address_pools: Vec<BackendAddressPool>,
    #[doc = "A list of references of LoadBalancerInboundNatRules."]
    #[serde(rename = "loadBalancerInboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_inbound_nat_rules: Vec<InboundNatRule>,
    #[doc = "Private IP address of the IP configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "IP address allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[doc = "IP address version."]
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<IpVersion>,
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "Whether this is a primary customer address on the network interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[doc = "Public IP address resource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[doc = "Application security groups in which the IP configuration is included."]
    #[serde(rename = "applicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub application_security_groups: Vec<ApplicationSecurityGroup>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "PrivateLinkConnection properties for the network interface."]
    #[serde(rename = "privateLinkConnectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub private_link_connection_properties: Option<NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties>,
}
impl NetworkInterfaceIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListNetworkInterface API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceListResult {
    #[doc = "A list of network interfaces in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterface>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for list ip configurations API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceLoadBalancerListResult {
    #[doc = "A list of load balancers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancer>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceLoadBalancerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NetworkInterface properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfacePropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine: Option<SubResource>,
    #[doc = "NetworkSecurityGroup resource."]
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[doc = "Private endpoint resource."]
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[doc = "A list of IPConfigurations of the network interface."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "A list of TapConfigurations of the network interface."]
    #[serde(rename = "tapConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub tap_configurations: Vec<NetworkInterfaceTapConfiguration>,
    #[doc = "DNS settings of a network interface."]
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<NetworkInterfaceDnsSettings>,
    #[doc = "The MAC address of the network interface."]
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[doc = "Whether this is a primary network interface on a virtual machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[doc = "Whether the virtual machine this nic is attached to supports encryption."]
    #[serde(rename = "vnetEncryptionSupported", default, skip_serializing_if = "Option::is_none")]
    pub vnet_encryption_supported: Option<bool>,
    #[doc = "If the network interface is accelerated networking enabled."]
    #[serde(rename = "enableAcceleratedNetworking", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking: Option<bool>,
    #[doc = "Indicates whether IP forwarding is enabled on this network interface."]
    #[serde(rename = "enableIPForwarding", default, skip_serializing_if = "Option::is_none")]
    pub enable_ip_forwarding: Option<bool>,
    #[doc = "A list of references to linked BareMetal resources."]
    #[serde(rename = "hostedWorkloads", default, skip_serializing_if = "Vec::is_empty")]
    pub hosted_workloads: Vec<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "dscpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub dscp_configuration: Option<SubResource>,
    #[doc = "The resource GUID property of the network interface resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "WorkloadType of the NetworkInterface for BareMetal resources"]
    #[serde(rename = "workloadType", default, skip_serializing_if = "Option::is_none")]
    pub workload_type: Option<String>,
    #[doc = "Type of Network Interface resource."]
    #[serde(rename = "nicType", default, skip_serializing_if = "Option::is_none")]
    pub nic_type: Option<network_interface_properties_format::NicType>,
    #[doc = "Private link service resource."]
    #[serde(rename = "privateLinkService", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service: Option<PrivateLinkService>,
    #[doc = "Migration phase of Network Interface resource."]
    #[serde(rename = "migrationPhase", default, skip_serializing_if = "Option::is_none")]
    pub migration_phase: Option<network_interface_properties_format::MigrationPhase>,
}
impl NetworkInterfacePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_interface_properties_format {
    use super::*;
    #[doc = "Type of Network Interface resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NicType {
        Standard,
        Elastic,
    }
    #[doc = "Migration phase of Network Interface resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MigrationPhase {
        None,
        Prepare,
        Commit,
        Abort,
        Committed,
    }
}
#[doc = "Tap configuration in a Network Interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceTapConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Virtual Network Tap configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceTapConfigurationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Sub Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl NetworkInterfaceTapConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for list tap configurations API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceTapConfigurationListResult {
    #[doc = "A list of tap configurations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterfaceTapConfiguration>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceTapConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Virtual Network Tap configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceTapConfigurationPropertiesFormat {
    #[doc = "Virtual Network Tap resource."]
    #[serde(rename = "virtualNetworkTap", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_tap: Option<VirtualNetworkTap>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkInterfaceTapConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Managed Network resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManager {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of Managed Network"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkManagerProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl NetworkManager {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Manager Commit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkManagerCommit {
    #[doc = "Commit Id."]
    #[serde(rename = "commitId", default, skip_serializing_if = "Option::is_none")]
    pub commit_id: Option<String>,
    #[doc = "List of target locations."]
    #[serde(rename = "targetLocations")]
    pub target_locations: Vec<String>,
    #[doc = "List of configuration ids."]
    #[serde(rename = "configurationIds", default, skip_serializing_if = "Vec::is_empty")]
    pub configuration_ids: Vec<String>,
    #[doc = "Configuration Deployment Type."]
    #[serde(rename = "commitType", default, skip_serializing_if = "Option::is_none")]
    pub commit_type: Option<ConfigurationType>,
}
impl NetworkManagerCommit {
    pub fn new(target_locations: Vec<String>) -> Self {
        Self {
            commit_id: None,
            target_locations,
            configuration_ids: Vec::new(),
            commit_type: None,
        }
    }
}
#[doc = "The Network Manager Connection resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerConnection {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Information about the network manager connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkManagerConnectionProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl NetworkManagerConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of network manager connections."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerConnectionListResult {
    #[doc = "List of network manager connections."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkManagerConnection>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkManagerConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information about the network manager connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerConnectionProperties {
    #[doc = "Network Manager Id."]
    #[serde(rename = "networkManagerId", default, skip_serializing_if = "Option::is_none")]
    pub network_manager_id: Option<String>,
    #[doc = "The current scope connection state."]
    #[serde(rename = "connectionState", default, skip_serializing_if = "Option::is_none")]
    pub connection_state: Option<ConnectionState>,
    #[doc = "A description of the scope connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl NetworkManagerConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Manager Deployment Status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerDeploymentStatus {
    #[doc = "Commit Time."]
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[doc = "Region Name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "Deployment Status."]
    #[serde(rename = "deploymentStatus", default, skip_serializing_if = "Option::is_none")]
    pub deployment_status: Option<network_manager_deployment_status::DeploymentStatus>,
    #[doc = "List of configuration ids."]
    #[serde(rename = "configurationIds", default, skip_serializing_if = "Vec::is_empty")]
    pub configuration_ids: Vec<String>,
    #[doc = "Configuration Deployment Type."]
    #[serde(rename = "deploymentType", default, skip_serializing_if = "Option::is_none")]
    pub deployment_type: Option<ConfigurationType>,
    #[doc = "Error Message."]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}
impl NetworkManagerDeploymentStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_manager_deployment_status {
    use super::*;
    #[doc = "Deployment Status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeploymentStatus {
        NotStarted,
        Deploying,
        Deployed,
        Failed,
    }
}
#[doc = "A list of Network Manager Deployment Status"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerDeploymentStatusListResult {
    #[doc = "Gets a page of Network Manager Deployment Status"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkManagerDeploymentStatus>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerDeploymentStatusListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Manager Deployment Status Parameter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerDeploymentStatusParameter {
    #[doc = "List of locations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub regions: Vec<String>,
    #[doc = "List of deployment types."]
    #[serde(rename = "deploymentTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub deployment_types: Vec<ConfigurationType>,
    #[doc = "Continuation token for pagination, capturing the next page size and offset, as well as the context of the query."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerDeploymentStatusParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list networkManagerEffectiveConnectivityConfiguration. It contains a list of groups and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerEffectiveConnectivityConfigurationListResult {
    #[doc = "Gets a page of NetworkManagerEffectiveConnectivityConfiguration"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveConnectivityConfiguration>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerEffectiveConnectivityConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list networkManagerEffectiveSecurityAdminRules. It contains a list of groups and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerEffectiveSecurityAdminRulesListResult {
    #[doc = "Gets a page of NetworkManagerEffectiveSecurityAdminRules"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveBaseSecurityAdminRule>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerEffectiveSecurityAdminRulesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list NetworkManager. It contains a list of network managers and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerListResult {
    #[doc = "Gets a page of NetworkManager"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkManager>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkManagerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Managed Network"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkManagerProperties {
    #[doc = "A friendly name for the network manager."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the network manager."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Scope of Network Manager."]
    #[serde(rename = "networkManagerScopes")]
    pub network_manager_scopes: network_manager_properties::NetworkManagerScopes,
    #[doc = "Scope Access."]
    #[serde(rename = "networkManagerScopeAccesses")]
    pub network_manager_scope_accesses: Vec<ConfigurationType>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkManagerProperties {
    pub fn new(
        network_manager_scopes: network_manager_properties::NetworkManagerScopes,
        network_manager_scope_accesses: Vec<ConfigurationType>,
    ) -> Self {
        Self {
            display_name: None,
            description: None,
            network_manager_scopes,
            network_manager_scope_accesses,
            provisioning_state: None,
        }
    }
}
pub mod network_manager_properties {
    use super::*;
    #[doc = "Scope of Network Manager."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct NetworkManagerScopes {
        #[doc = "List of management groups."]
        #[serde(rename = "managementGroups", default, skip_serializing_if = "Vec::is_empty")]
        pub management_groups: Vec<String>,
        #[doc = "List of subscriptions."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub subscriptions: Vec<String>,
        #[doc = "List of cross tenant scopes."]
        #[serde(rename = "crossTenantScopes", default, skip_serializing_if = "Vec::is_empty")]
        pub cross_tenant_scopes: Vec<CrossTenantScopes>,
    }
    impl NetworkManagerScopes {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Network manager security group item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkManagerSecurityGroupItem {
    #[doc = "Network manager group Id."]
    #[serde(rename = "networkGroupId")]
    pub network_group_id: String,
}
impl NetworkManagerSecurityGroupItem {
    pub fn new(network_group_id: String) -> Self {
        Self { network_group_id }
    }
}
#[doc = "Network profile resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProfile {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Network profile properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkProfilePropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListNetworkProfiles API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProfileListResult {
    #[doc = "A list of network profiles that exist in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkProfile>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkProfileListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network profile properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProfilePropertiesFormat {
    #[doc = "List of child container network interfaces."]
    #[serde(rename = "containerNetworkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub container_network_interfaces: Vec<ContainerNetworkInterface>,
    #[doc = "List of chid container network interface configurations."]
    #[serde(rename = "containerNetworkInterfaceConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub container_network_interface_configurations: Vec<ContainerNetworkInterfaceConfiguration>,
    #[doc = "The resource GUID property of the network profile resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkProfilePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Rule of type network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkRule {
    #[serde(flatten)]
    pub firewall_policy_rule: FirewallPolicyRule,
    #[doc = "Array of FirewallPolicyRuleNetworkProtocols."]
    #[serde(rename = "ipProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_protocols: Vec<FirewallPolicyRuleNetworkProtocol>,
    #[doc = "List of source IP addresses for this rule."]
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[doc = "List of destination IP addresses or Service Tags."]
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[doc = "List of destination ports."]
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<String>,
    #[doc = "List of source IpGroups for this rule."]
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
    #[doc = "List of destination IpGroups for this rule."]
    #[serde(rename = "destinationIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ip_groups: Vec<String>,
    #[doc = "List of destination FQDNs."]
    #[serde(rename = "destinationFqdns", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_fqdns: Vec<String>,
}
impl NetworkRule {
    pub fn new(firewall_policy_rule: FirewallPolicyRule) -> Self {
        Self {
            firewall_policy_rule,
            ip_protocols: Vec::new(),
            source_addresses: Vec::new(),
            destination_addresses: Vec::new(),
            destination_ports: Vec::new(),
            source_ip_groups: Vec::new(),
            destination_ip_groups: Vec::new(),
            destination_fqdns: Vec::new(),
        }
    }
}
#[doc = "NetworkSecurityGroup resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Network Security Group resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkSecurityGroupPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListNetworkSecurityGroups API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupListResult {
    #[doc = "A list of NetworkSecurityGroup resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkSecurityGroup>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Security Group resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupPropertiesFormat {
    #[doc = "A collection of security rules of the network security group."]
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
    #[doc = "The default security rules of network security group."]
    #[serde(rename = "defaultSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub default_security_rules: Vec<SecurityRule>,
    #[doc = "A collection of references to network interfaces."]
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[doc = "A collection of references to subnets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "A collection of references to flow log resources."]
    #[serde(rename = "flowLogs", default, skip_serializing_if = "Vec::is_empty")]
    pub flow_logs: Vec<FlowLog>,
    #[doc = "The resource GUID property of the network security group resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkSecurityGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network configuration diagnostic result corresponded provided traffic query."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupResult {
    #[doc = "Whether network traffic is allowed or denied."]
    #[serde(rename = "securityRuleAccessResult", default, skip_serializing_if = "Option::is_none")]
    pub security_rule_access_result: Option<SecurityRuleAccess>,
    #[doc = "List of results network security groups diagnostic."]
    #[serde(rename = "evaluatedNetworkSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub evaluated_network_security_groups: Vec<EvaluatedNetworkSecurityGroup>,
}
impl NetworkSecurityGroupResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network security rules evaluation result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityRulesEvaluationResult {
    #[doc = "Name of the network security rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Value indicating whether protocol is matched."]
    #[serde(rename = "protocolMatched", default, skip_serializing_if = "Option::is_none")]
    pub protocol_matched: Option<bool>,
    #[doc = "Value indicating whether source is matched."]
    #[serde(rename = "sourceMatched", default, skip_serializing_if = "Option::is_none")]
    pub source_matched: Option<bool>,
    #[doc = "Value indicating whether source port is matched."]
    #[serde(rename = "sourcePortMatched", default, skip_serializing_if = "Option::is_none")]
    pub source_port_matched: Option<bool>,
    #[doc = "Value indicating whether destination is matched."]
    #[serde(rename = "destinationMatched", default, skip_serializing_if = "Option::is_none")]
    pub destination_matched: Option<bool>,
    #[doc = "Value indicating whether destination port is matched."]
    #[serde(rename = "destinationPortMatched", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_matched: Option<bool>,
}
impl NetworkSecurityRulesEvaluationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NetworkVirtualAppliance Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualAppliance {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Network Virtual Appliance definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkVirtualAppliancePropertiesFormat>,
    #[doc = "Identity for the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkVirtualAppliance {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListNetworkVirtualAppliances API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceListResult {
    #[doc = "List of Network Virtual Appliances."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkVirtualAppliance>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkVirtualApplianceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Virtual Appliance definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualAppliancePropertiesFormat {
    #[doc = "Network Virtual Appliance Sku Properties."]
    #[serde(rename = "nvaSku", default, skip_serializing_if = "Option::is_none")]
    pub nva_sku: Option<VirtualApplianceSkuProperties>,
    #[doc = "Address Prefix."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "BootStrapConfigurationBlobs storage URLs."]
    #[serde(rename = "bootStrapConfigurationBlobs", default, skip_serializing_if = "Vec::is_empty")]
    pub boot_strap_configuration_blobs: Vec<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
    #[doc = "CloudInitConfigurationBlob storage URLs."]
    #[serde(rename = "cloudInitConfigurationBlobs", default, skip_serializing_if = "Vec::is_empty")]
    pub cloud_init_configuration_blobs: Vec<String>,
    #[doc = "CloudInitConfiguration string in plain text."]
    #[serde(rename = "cloudInitConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub cloud_init_configuration: Option<String>,
    #[doc = "VirtualAppliance ASN."]
    #[serde(rename = "virtualApplianceAsn", default, skip_serializing_if = "Option::is_none")]
    pub virtual_appliance_asn: Option<i64>,
    #[doc = "Public key for SSH login."]
    #[serde(rename = "sshPublicKey", default, skip_serializing_if = "Option::is_none")]
    pub ssh_public_key: Option<String>,
    #[doc = "List of Virtual Appliance Network Interfaces."]
    #[serde(rename = "virtualApplianceNics", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_appliance_nics: Vec<VirtualApplianceNicProperties>,
    #[doc = "List of references to VirtualApplianceSite."]
    #[serde(rename = "virtualApplianceSites", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_appliance_sites: Vec<SubResource>,
    #[doc = "List of references to InboundSecurityRules."]
    #[serde(rename = "inboundSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_security_rules: Vec<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkVirtualAppliancePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListNetworkVirtualApplianceSites API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSiteListResult {
    #[doc = "List of Network Virtual Appliance sites."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualApplianceSite>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkVirtualApplianceSiteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Definition of the NetworkVirtualApplianceSkus resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSku {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties specific to NetworkVirtualApplianceSkus."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkVirtualApplianceSkuPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkVirtualApplianceSku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of available Sku and instances."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSkuInstances {
    #[doc = "Scale Unit."]
    #[serde(rename = "scaleUnit", default, skip_serializing_if = "Option::is_none")]
    pub scale_unit: Option<String>,
    #[doc = "Instance Count."]
    #[serde(rename = "instanceCount", default, skip_serializing_if = "Option::is_none")]
    pub instance_count: Option<i32>,
}
impl NetworkVirtualApplianceSkuInstances {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListNetworkVirtualApplianceSkus API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSkuListResult {
    #[doc = "List of Network Virtual Appliance Skus that are available."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkVirtualApplianceSku>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkVirtualApplianceSkuListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties specific to NetworkVirtualApplianceSkus."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSkuPropertiesFormat {
    #[doc = "Network Virtual Appliance Sku vendor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
    #[doc = "Available Network Virtual Appliance versions."]
    #[serde(rename = "availableVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub available_versions: Vec<String>,
    #[doc = "The list of scale units available."]
    #[serde(rename = "availableScaleUnits", default, skip_serializing_if = "Vec::is_empty")]
    pub available_scale_units: Vec<NetworkVirtualApplianceSkuInstances>,
}
impl NetworkVirtualApplianceSkuPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network watcher in a resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkWatcher {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The network watcher properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkWatcherPropertiesFormat>,
}
impl NetworkWatcher {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListNetworkWatchers API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkWatcherListResult {
    #[doc = "List of network watcher resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkWatcher>,
}
impl NetworkWatcherListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The network watcher properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkWatcherPropertiesFormat {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkWatcherPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the source and destination endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NextHopParameters {
    #[doc = "The resource identifier of the target resource against which the action is to be performed."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "The source IP address."]
    #[serde(rename = "sourceIPAddress")]
    pub source_ip_address: String,
    #[doc = "The destination IP address."]
    #[serde(rename = "destinationIPAddress")]
    pub destination_ip_address: String,
    #[doc = "The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of the nics, then this parameter must be specified. Otherwise optional)."]
    #[serde(rename = "targetNicResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_resource_id: Option<String>,
}
impl NextHopParameters {
    pub fn new(target_resource_id: String, source_ip_address: String, destination_ip_address: String) -> Self {
        Self {
            target_resource_id,
            source_ip_address,
            destination_ip_address,
            target_nic_resource_id: None,
        }
    }
}
#[doc = "The information about next hop from the specified VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NextHopResult {
    #[doc = "Next hop type."]
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<next_hop_result::NextHopType>,
    #[doc = "Next hop IP Address."]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
    #[doc = "The resource identifier for the route table associated with the route being returned. If the route being returned does not correspond to any user created routes then this field will be the string 'System Route'."]
    #[serde(rename = "routeTableId", default, skip_serializing_if = "Option::is_none")]
    pub route_table_id: Option<String>,
}
impl NextHopResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod next_hop_result {
    use super::*;
    #[doc = "Next hop type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextHopType {
        Internet,
        VirtualAppliance,
        VirtualNetworkGateway,
        VnetLocal,
        HyperNetGateway,
        None,
    }
}
#[doc = "Office365 breakout categories."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct O365BreakOutCategoryPolicies {
    #[doc = "Flag to control allow category."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub allow: Option<bool>,
    #[doc = "Flag to control optimize category."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub optimize: Option<bool>,
    #[doc = "Flag to control default category."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<bool>,
}
impl O365BreakOutCategoryPolicies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Office365 breakout policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct O365PolicyProperties {
    #[doc = "Office365 breakout categories."]
    #[serde(rename = "breakOutCategories", default, skip_serializing_if = "Option::is_none")]
    pub break_out_categories: Option<O365BreakOutCategoryPolicies>,
}
impl O365PolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Virtual Appliance Sku Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Office365PolicyProperties {
    #[doc = "Network Virtual Appliance Sku Properties."]
    #[serde(rename = "breakOutCategories", default, skip_serializing_if = "Option::is_none")]
    pub break_out_categories: Option<BreakOutCategoryPolicies>,
}
impl Office365PolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The office traffic category."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OfficeTrafficCategory {
    Optimize,
    OptimizeAndAllow,
    All,
    None,
}
#[doc = "Network REST API operation definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Display metadata associated with the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[doc = "Origin of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[doc = "Description of operation properties format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationPropertiesFormat>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "Display metadata associated with the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Service provider: Microsoft Network."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource on which the operation is performed."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Type of the operation: get, read, delete, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "Description of the operation."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result of the request to list Network operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of Network operations supported by the Network resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Description of operation properties format."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationPropertiesFormat {
    #[doc = "Specification of the service."]
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<operation_properties_format::ServiceSpecification>,
}
impl OperationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_properties_format {
    use super::*;
    #[doc = "Specification of the service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ServiceSpecification {
        #[doc = "Operation service specification."]
        #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
        pub metric_specifications: Vec<MetricSpecification>,
        #[doc = "Operation log specification."]
        #[serde(rename = "logSpecifications", default, skip_serializing_if = "Vec::is_empty")]
        pub log_specifications: Vec<LogSpecification>,
    }
    impl ServiceSpecification {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Describes a column to sort"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OrderBy {
    #[doc = "Describes the actual column name to sort by"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub field: Option<String>,
    #[doc = "Describes if results should be in ascending/descending order"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub order: Option<order_by::Order>,
}
impl OrderBy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod order_by {
    use super::*;
    #[doc = "Describes if results should be in ascending/descending order"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Order {
        Ascending,
        Descending,
    }
}
#[doc = "Outbound rule of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OutboundRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Outbound rule of the load balancer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OutboundRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl OutboundRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Outbound rule of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutboundRulePropertiesFormat {
    #[doc = "The number of outbound ports to be used for NAT."]
    #[serde(rename = "allocatedOutboundPorts", default, skip_serializing_if = "Option::is_none")]
    pub allocated_outbound_ports: Option<i32>,
    #[doc = "The Frontend IP addresses of the load balancer."]
    #[serde(rename = "frontendIPConfigurations")]
    pub frontend_ip_configurations: Vec<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool")]
    pub backend_address_pool: SubResource,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The protocol for the outbound rule in load balancer."]
    pub protocol: outbound_rule_properties_format::Protocol,
    #[doc = "Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[doc = "The timeout for the TCP idle connection."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i64>,
}
impl OutboundRulePropertiesFormat {
    pub fn new(
        frontend_ip_configurations: Vec<SubResource>,
        backend_address_pool: SubResource,
        protocol: outbound_rule_properties_format::Protocol,
    ) -> Self {
        Self {
            allocated_outbound_ports: None,
            frontend_ip_configurations,
            backend_address_pool,
            provisioning_state: None,
            protocol,
            enable_tcp_reset: None,
            idle_timeout_in_minutes: None,
        }
    }
}
pub mod outbound_rule_properties_format {
    use super::*;
    #[doc = "The protocol for the outbound rule in load balancer."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        All,
    }
}
#[doc = "Allow to exclude some variable satisfy the condition for the WAF check."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OwaspCrsExclusionEntry {
    #[doc = "The variable to be excluded."]
    #[serde(rename = "matchVariable")]
    pub match_variable: owasp_crs_exclusion_entry::MatchVariable,
    #[doc = "When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to."]
    #[serde(rename = "selectorMatchOperator")]
    pub selector_match_operator: owasp_crs_exclusion_entry::SelectorMatchOperator,
    #[doc = "When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to."]
    pub selector: String,
    #[doc = "The managed rule sets that are associated with the exclusion."]
    #[serde(rename = "exclusionManagedRuleSets", default, skip_serializing_if = "Vec::is_empty")]
    pub exclusion_managed_rule_sets: Vec<ExclusionManagedRuleSet>,
}
impl OwaspCrsExclusionEntry {
    pub fn new(
        match_variable: owasp_crs_exclusion_entry::MatchVariable,
        selector_match_operator: owasp_crs_exclusion_entry::SelectorMatchOperator,
        selector: String,
    ) -> Self {
        Self {
            match_variable,
            selector_match_operator,
            selector,
            exclusion_managed_rule_sets: Vec::new(),
        }
    }
}
pub mod owasp_crs_exclusion_entry {
    use super::*;
    #[doc = "The variable to be excluded."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MatchVariable {
        RequestHeaderNames,
        RequestCookieNames,
        RequestArgNames,
        RequestHeaderKeys,
        RequestHeaderValues,
        RequestCookieKeys,
        RequestCookieValues,
        RequestArgKeys,
        RequestArgValues,
    }
    #[doc = "When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SelectorMatchOperator {
        Equals,
        Contains,
        StartsWith,
        EndsWith,
        EqualsAny,
    }
}
#[doc = "P2SConnectionConfiguration Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sConnectionConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Parameters for P2SConnectionConfiguration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<P2sConnectionConfigurationProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl P2sConnectionConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for P2SConnectionConfiguration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sConnectionConfigurationProperties {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "vpnClientAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_address_pool: Option<AddressSpace>,
    #[doc = "Routing Configuration indicating the associated and propagated route tables for this connection."]
    #[serde(rename = "routingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub routing_configuration: Option<RoutingConfiguration>,
    #[doc = "Flag indicating whether the enable internet security flag is turned on for the P2S Connections or not."]
    #[serde(rename = "enableInternetSecurity", default, skip_serializing_if = "Option::is_none")]
    pub enable_internet_security: Option<bool>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl P2sConnectionConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "P2S Vpn connection detailed health written to sas url."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnConnectionHealth {
    #[doc = "Returned sas url of the blob to which the p2s vpn connection detailed health will be written."]
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
}
impl P2sVpnConnectionHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of P2S Vpn connection health request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnConnectionHealthRequest {
    #[doc = "The list of p2s vpn user names whose p2s vpn connection detailed health to retrieve for."]
    #[serde(rename = "vpnUserNamesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_user_names_filter: Vec<String>,
    #[doc = "The sas-url to download the P2S Vpn connection health detail."]
    #[serde(rename = "outputBlobSasUrl", default, skip_serializing_if = "Option::is_none")]
    pub output_blob_sas_url: Option<String>,
}
impl P2sVpnConnectionHealthRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of p2s vpn connections to be disconnected."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnConnectionRequest {
    #[doc = "List of p2s vpn connection Ids."]
    #[serde(rename = "vpnConnectionIds", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_connection_ids: Vec<String>,
}
impl P2sVpnConnectionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "P2SVpnGateway Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct P2sVpnGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Parameters for P2SVpnGateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<P2sVpnGatewayProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl P2sVpnGateway {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[doc = "Parameters for P2SVpnGateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnGatewayProperties {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
    #[doc = "List of all p2s connection configurations of the gateway."]
    #[serde(rename = "p2SConnectionConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub p2_s_connection_configurations: Vec<P2sConnectionConfiguration>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The scale unit for this p2s vpn gateway."]
    #[serde(rename = "vpnGatewayScaleUnit", default, skip_serializing_if = "Option::is_none")]
    pub vpn_gateway_scale_unit: Option<i32>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "vpnServerConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_server_configuration: Option<SubResource>,
    #[doc = "VpnClientConnectionHealth properties."]
    #[serde(rename = "vpnClientConnectionHealth", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_connection_health: Option<VpnClientConnectionHealth>,
    #[doc = "List of all customer specified DNS servers IP addresses."]
    #[serde(rename = "customDnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_dns_servers: Vec<String>,
    #[doc = "Enable Routing Preference property for the Public IP Interface of the P2SVpnGateway."]
    #[serde(rename = "isRoutingPreferenceInternet", default, skip_serializing_if = "Option::is_none")]
    pub is_routing_preference_internet: Option<bool>,
}
impl P2sVpnGatewayProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Vpn Client Parameters for package generation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnProfileParameters {
    #[doc = "VPN client authentication method."]
    #[serde(rename = "authenticationMethod", default, skip_serializing_if = "Option::is_none")]
    pub authentication_method: Option<AuthenticationMethod>,
}
impl P2sVpnProfileParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the create packet capture operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PacketCapture {
    #[doc = "Parameters that define the create packet capture operation."]
    pub properties: PacketCaptureParameters,
}
impl PacketCapture {
    pub fn new(properties: PacketCaptureParameters) -> Self {
        Self { properties }
    }
}
#[doc = "Filter that is applied to packet capture request. Multiple filters can be applied."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureFilter {
    #[doc = "Protocol to be filtered on."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<packet_capture_filter::Protocol>,
    #[doc = "Local IP Address to be filtered on. Notation: \"127.0.0.1\" for single address entry. \"127.0.0.1-127.0.0.255\" for range. \"127.0.0.1;127.0.0.5\"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null."]
    #[serde(rename = "localIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_ip_address: Option<String>,
    #[doc = "Local IP Address to be filtered on. Notation: \"127.0.0.1\" for single address entry. \"127.0.0.1-127.0.0.255\" for range. \"127.0.0.1;127.0.0.5;\" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null."]
    #[serde(rename = "remoteIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub remote_ip_address: Option<String>,
    #[doc = "Local port to be filtered on. Notation: \"80\" for single port entry.\"80-85\" for range. \"80;443;\" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null."]
    #[serde(rename = "localPort", default, skip_serializing_if = "Option::is_none")]
    pub local_port: Option<String>,
    #[doc = "Remote port to be filtered on. Notation: \"80\" for single port entry.\"80-85\" for range. \"80;443;\" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null."]
    #[serde(rename = "remotePort", default, skip_serializing_if = "Option::is_none")]
    pub remote_port: Option<String>,
}
impl PacketCaptureFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod packet_capture_filter {
    use super::*;
    #[doc = "Protocol to be filtered on."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
        Any,
    }
    impl Default for Protocol {
        fn default() -> Self {
            Self::Any
        }
    }
}
#[doc = "List of packet capture sessions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureListResult {
    #[doc = "Information about packet capture sessions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PacketCaptureResult>,
}
impl PacketCaptureListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the create packet capture operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PacketCaptureParameters {
    #[doc = "The ID of the targeted resource, only VM is currently supported."]
    pub target: String,
    #[doc = "Number of bytes captured per packet, the remaining bytes are truncated."]
    #[serde(rename = "bytesToCapturePerPacket", default, skip_serializing_if = "Option::is_none")]
    pub bytes_to_capture_per_packet: Option<i64>,
    #[doc = "Maximum size of the capture output."]
    #[serde(rename = "totalBytesPerSession", default, skip_serializing_if = "Option::is_none")]
    pub total_bytes_per_session: Option<i64>,
    #[doc = "Maximum duration of the capture session in seconds."]
    #[serde(rename = "timeLimitInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub time_limit_in_seconds: Option<i32>,
    #[doc = "The storage location for a packet capture session."]
    #[serde(rename = "storageLocation")]
    pub storage_location: PacketCaptureStorageLocation,
    #[doc = "A list of packet capture filters."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub filters: Vec<PacketCaptureFilter>,
}
impl PacketCaptureParameters {
    pub fn new(target: String, storage_location: PacketCaptureStorageLocation) -> Self {
        Self {
            target,
            bytes_to_capture_per_packet: None,
            total_bytes_per_session: None,
            time_limit_in_seconds: None,
            storage_location,
            filters: Vec::new(),
        }
    }
}
#[doc = "Status of packet capture session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureQueryStatusResult {
    #[doc = "The name of the packet capture resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The ID of the packet capture resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The start time of the packet capture session."]
    #[serde(rename = "captureStartTime", default, skip_serializing_if = "Option::is_none")]
    pub capture_start_time: Option<String>,
    #[doc = "The status of the packet capture session."]
    #[serde(rename = "packetCaptureStatus", default, skip_serializing_if = "Option::is_none")]
    pub packet_capture_status: Option<packet_capture_query_status_result::PacketCaptureStatus>,
    #[doc = "The reason the current packet capture session was stopped."]
    #[serde(rename = "stopReason", default, skip_serializing_if = "Option::is_none")]
    pub stop_reason: Option<String>,
    #[doc = "List of errors of packet capture session."]
    #[serde(rename = "packetCaptureError", default, skip_serializing_if = "Vec::is_empty")]
    pub packet_capture_error: Vec<String>,
}
impl PacketCaptureQueryStatusResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod packet_capture_query_status_result {
    use super::*;
    #[doc = "The status of the packet capture session."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PacketCaptureStatus {
        NotStarted,
        Running,
        Stopped,
        Error,
        Unknown,
    }
}
#[doc = "Information about packet capture session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureResult {
    #[doc = "Name of the packet capture session."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "ID of the packet capture operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The properties of a packet capture session."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PacketCaptureResultProperties>,
}
impl PacketCaptureResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a packet capture session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PacketCaptureResultProperties {
    #[serde(flatten)]
    pub packet_capture_parameters: PacketCaptureParameters,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl PacketCaptureResultProperties {
    pub fn new(packet_capture_parameters: PacketCaptureParameters) -> Self {
        Self {
            packet_capture_parameters,
            provisioning_state: None,
        }
    }
}
#[doc = "The storage location for a packet capture session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureStorageLocation {
    #[doc = "The ID of the storage account to save the packet capture session. Required if no local file path is provided."]
    #[serde(rename = "storageId", default, skip_serializing_if = "Option::is_none")]
    pub storage_id: Option<String>,
    #[doc = "The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture."]
    #[serde(rename = "storagePath", default, skip_serializing_if = "Option::is_none")]
    pub storage_path: Option<String>,
    #[doc = "A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional."]
    #[serde(rename = "filePath", default, skip_serializing_if = "Option::is_none")]
    pub file_path: Option<String>,
}
impl PacketCaptureStorageLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Object for patch operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PatchObject {
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl PatchObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PatchRouteFilter {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Route Filter Resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl PatchRouteFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Rule Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PatchRouteFilterRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Route Filter Rule Resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PatchRouteFilterRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peer Express Route Circuit Connection in an ExpressRouteCircuitPeering resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerExpressRouteCircuitConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the peer express route circuit connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PeerExpressRouteCircuitConnectionPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl PeerExpressRouteCircuitConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListPeeredConnections API service call retrieves all global reach peer circuit connections that belongs to a Private Peering for an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerExpressRouteCircuitConnectionListResult {
    #[doc = "The global reach peer circuit connection associated with Private Peering in an ExpressRoute Circuit."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PeerExpressRouteCircuitConnection>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PeerExpressRouteCircuitConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the peer express route circuit connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerExpressRouteCircuitConnectionPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "expressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub express_route_circuit_peering: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "peerExpressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub peer_express_route_circuit_peering: Option<SubResource>,
    #[doc = "/29 IP address space to carve out Customer addresses for tunnels."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "Express Route Circuit connection state."]
    #[serde(rename = "circuitConnectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub circuit_connection_status: Option<CircuitConnectionStatus>,
    #[doc = "The name of the express route circuit connection resource."]
    #[serde(rename = "connectionName", default, skip_serializing_if = "Option::is_none")]
    pub connection_name: Option<String>,
    #[doc = "The resource guid of the authorization used for the express route circuit connection."]
    #[serde(rename = "authResourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub auth_resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl PeerExpressRouteCircuitConnectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peer routing details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerRoute {
    #[doc = "The peer's local address."]
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[doc = "The route's network prefix."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[doc = "The route's next hop."]
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[doc = "The peer this route was learned from."]
    #[serde(rename = "sourcePeer", default, skip_serializing_if = "Option::is_none")]
    pub source_peer: Option<String>,
    #[doc = "The source this route was learned from."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[doc = "The route's AS path sequence."]
    #[serde(rename = "asPath", default, skip_serializing_if = "Option::is_none")]
    pub as_path: Option<String>,
    #[doc = "The route's weight."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
}
impl PeerRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of virtual router peer routes."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerRouteList {
    #[doc = "List of peer routes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PeerRoute>,
}
impl PeerRouteList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Pfs Groups used in IKE Phase 2 for new child SA."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PfsGroup {
    None,
    #[serde(rename = "PFS1")]
    Pfs1,
    #[serde(rename = "PFS2")]
    Pfs2,
    #[serde(rename = "PFS2048")]
    Pfs2048,
    #[serde(rename = "ECP256")]
    Ecp256,
    #[serde(rename = "ECP384")]
    Ecp384,
    #[serde(rename = "PFS24")]
    Pfs24,
    #[serde(rename = "PFS14")]
    Pfs14,
    #[serde(rename = "PFSMM")]
    Pfsmm,
}
#[doc = "Ssl predefined policy name enums."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PolicyNameEnum {
    AppGwSslPolicy20150501,
    AppGwSslPolicy20170401,
    AppGwSslPolicy20170401S,
}
#[doc = "Defines contents of a web application firewall global configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicySettings {
    #[doc = "The state of the policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<policy_settings::State>,
    #[doc = "The mode of the policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<policy_settings::Mode>,
    #[doc = "Whether to allow WAF to check request Body."]
    #[serde(rename = "requestBodyCheck", default, skip_serializing_if = "Option::is_none")]
    pub request_body_check: Option<bool>,
    #[doc = "Maximum request body size in Kb for WAF."]
    #[serde(rename = "maxRequestBodySizeInKb", default, skip_serializing_if = "Option::is_none")]
    pub max_request_body_size_in_kb: Option<i32>,
    #[doc = "Maximum file upload size in Mb for WAF."]
    #[serde(rename = "fileUploadLimitInMb", default, skip_serializing_if = "Option::is_none")]
    pub file_upload_limit_in_mb: Option<i32>,
}
impl PolicySettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod policy_settings {
    use super::*;
    #[doc = "The state of the policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
        Enabled,
    }
    #[doc = "The mode of the policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        Prevention,
        Detection,
    }
}
pub type PortsList = String;
#[doc = "The preferred routing gateway types"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PreferredRoutingGateway {
    ExpressRoute,
    VpnGateway,
    None,
}
#[doc = "Details of PrepareNetworkPolicies for Subnet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrepareNetworkPoliciesRequest {
    #[doc = "The name of the service for which subnet is being prepared for."]
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[doc = "A list of NetworkIntentPolicyConfiguration."]
    #[serde(rename = "networkIntentPolicyConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_intent_policy_configurations: Vec<NetworkIntentPolicyConfiguration>,
}
impl PrepareNetworkPoliciesRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "PrivateDnsZoneConfig resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZoneConfig {
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Properties of the private dns zone configuration resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateDnsZonePropertiesFormat>,
}
impl PrivateDnsZoneConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Private dns zone group resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZoneGroup {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Properties of the private dns zone group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateDnsZoneGroupPropertiesFormat>,
}
impl PrivateDnsZoneGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListPrivateDnsZoneGroups API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZoneGroupListResult {
    #[doc = "A list of private dns zone group resources in a private endpoint."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateDnsZoneGroup>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateDnsZoneGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the private dns zone group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZoneGroupPropertiesFormat {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "A collection of private dns zone configurations of the private dns zone group."]
    #[serde(rename = "privateDnsZoneConfigs", default, skip_serializing_if = "Vec::is_empty")]
    pub private_dns_zone_configs: Vec<PrivateDnsZoneConfig>,
}
impl PrivateDnsZoneGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the private dns zone configuration resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZonePropertiesFormat {
    #[doc = "The resource id of the private dns zone."]
    #[serde(rename = "privateDnsZoneId", default, skip_serializing_if = "Option::is_none")]
    pub private_dns_zone_id: Option<String>,
    #[doc = "A collection of information regarding a recordSet, holding information to identify private resources."]
    #[serde(rename = "recordSets", default, skip_serializing_if = "Vec::is_empty")]
    pub record_sets: Vec<RecordSet>,
}
impl PrivateDnsZonePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Private endpoint resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "ExtendedLocation complex type."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<ExtendedLocation>,
    #[doc = "Properties of the private endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "PrivateEndpointConnection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the PrivateEndpointConnectProperties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnectionProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListPrivateEndpointConnection API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionListResult {
    #[doc = "A list of PrivateEndpointConnection resources for a specific private link service."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpointConnection>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateEndpointConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the PrivateEndpointConnectProperties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionProperties {
    #[doc = "Private endpoint resource."]
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[doc = "A collection of information about the state of the connection between service consumer and provider."]
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The consumer link id."]
    #[serde(rename = "linkIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub link_identifier: Option<String>,
}
impl PrivateEndpointConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An IP Configuration of the private endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointIpConfiguration {
    #[doc = "Properties of an IP Configuration of the private endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointIpConfigurationProperties>,
    #[doc = "The name of the resource that is unique within a resource group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PrivateEndpointIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of an IP Configuration of the private endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointIpConfigurationProperties {
    #[doc = "The ID of a group obtained from the remote resource that this private endpoint should connect to."]
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[doc = "The member name of a group obtained from the remote resource that this private endpoint should connect to."]
    #[serde(rename = "memberName", default, skip_serializing_if = "Option::is_none")]
    pub member_name: Option<String>,
    #[doc = "A private ip address obtained from the private endpoint's subnet."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
}
impl PrivateEndpointIpConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListPrivateEndpoints API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointListResult {
    #[doc = "A list of private endpoint resources in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpoint>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateEndpointListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the private endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointProperties {
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "An array of references to the network interfaces created for this private endpoint."]
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "A grouping of information about the connection to the remote resource."]
    #[serde(rename = "privateLinkServiceConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_link_service_connections: Vec<PrivateLinkServiceConnection>,
    #[doc = "A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource."]
    #[serde(rename = "manualPrivateLinkServiceConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub manual_private_link_service_connections: Vec<PrivateLinkServiceConnection>,
    #[doc = "An array of custom dns configurations."]
    #[serde(rename = "customDnsConfigs", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_dns_configs: Vec<CustomDnsConfigPropertiesFormat>,
    #[doc = "Application security groups in which the private endpoint IP configuration is included."]
    #[serde(rename = "applicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub application_security_groups: Vec<ApplicationSecurityGroup>,
    #[doc = "A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<PrivateEndpointIpConfiguration>,
    #[doc = "The custom name of the network interface attached to the private endpoint."]
    #[serde(rename = "customNetworkInterfaceName", default, skip_serializing_if = "Option::is_none")]
    pub custom_network_interface_name: Option<String>,
}
impl PrivateEndpointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Private link service resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkService {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "ExtendedLocation complex type."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<ExtendedLocation>,
    #[doc = "Properties of the private link service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkServiceProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PrivateLinkService {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "PrivateLinkServiceConnection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the PrivateLinkServiceConnection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkServiceConnectionProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PrivateLinkServiceConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the PrivateLinkServiceConnection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionProperties {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The resource id of private link service."]
    #[serde(rename = "privateLinkServiceId", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_id: Option<String>,
    #[doc = "The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to."]
    #[serde(rename = "groupIds", default, skip_serializing_if = "Vec::is_empty")]
    pub group_ids: Vec<String>,
    #[doc = "A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars."]
    #[serde(rename = "requestMessage", default, skip_serializing_if = "Option::is_none")]
    pub request_message: Option<String>,
    #[doc = "A collection of information about the state of the connection between service consumer and provider."]
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
}
impl PrivateLinkServiceConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A collection of information about the state of the connection between service consumer and provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionState {
    #[doc = "Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The reason for approval/rejection of the connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "A message indicating if changes on the service provider require any updates on the consumer."]
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The private link service ip configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of private link service IP configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkServiceIpConfigurationProperties>,
    #[doc = "The name of private link service ip configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl PrivateLinkServiceIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of private link service IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceIpConfigurationProperties {
    #[doc = "The private IP address of the IP configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "IP address allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "Whether the ip configuration is primary or not."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "IP address version."]
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<IpVersion>,
}
impl PrivateLinkServiceIpConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListPrivateLinkService API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceListResult {
    #[doc = "A list of PrivateLinkService resources in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateLinkService>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateLinkServiceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the private link service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceProperties {
    #[doc = "An array of references to the load balancer IP configurations."]
    #[serde(rename = "loadBalancerFrontendIpConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_frontend_ip_configurations: Vec<FrontendIpConfiguration>,
    #[doc = "An array of private link service IP configurations."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<PrivateLinkServiceIpConfiguration>,
    #[doc = "An array of references to the network interfaces created for this private link service."]
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "An array of list about connections to the private endpoint."]
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[doc = "The visibility list of the private link service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub visibility: Option<serde_json::Value>,
    #[doc = "The auto-approval list of the private link service."]
    #[serde(rename = "autoApproval", default, skip_serializing_if = "Option::is_none")]
    pub auto_approval: Option<serde_json::Value>,
    #[doc = "The list of Fqdn."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub fqdns: Vec<String>,
    #[doc = "The alias of the private link service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub alias: Option<String>,
    #[doc = "Whether the private link service is enabled for proxy protocol or not."]
    #[serde(rename = "enableProxyProtocol", default, skip_serializing_if = "Option::is_none")]
    pub enable_proxy_protocol: Option<bool>,
}
impl PrivateLinkServiceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the CheckPrivateLinkServiceVisibility API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceVisibility {
    #[doc = "Private Link Service Visibility (True/False)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub visible: Option<bool>,
}
impl PrivateLinkServiceVisibility {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A load balancer probe."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Probe {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Load balancer probe resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProbePropertiesFormat>,
    #[doc = "The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Probe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Load balancer probe resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProbePropertiesFormat {
    #[doc = "The load balancer rules that use this probe."]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[doc = "The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful."]
    pub protocol: probe_properties_format::Protocol,
    #[doc = "The port for communicating the probe. Possible values range from 1 to 65535, inclusive."]
    pub port: i32,
    #[doc = "The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5."]
    #[serde(rename = "intervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub interval_in_seconds: Option<i32>,
    #[doc = "The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure."]
    #[serde(rename = "numberOfProbes", default, skip_serializing_if = "Option::is_none")]
    pub number_of_probes: Option<i32>,
    #[doc = "The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value."]
    #[serde(rename = "requestPath", default, skip_serializing_if = "Option::is_none")]
    pub request_path: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ProbePropertiesFormat {
    pub fn new(protocol: probe_properties_format::Protocol, port: i32) -> Self {
        Self {
            load_balancing_rules: Vec::new(),
            protocol,
            port,
            interval_in_seconds: None,
            number_of_probes: None,
            request_path: None,
            provisioning_state: None,
        }
    }
}
pub mod probe_properties_format {
    use super::*;
    #[doc = "The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Tcp,
        Https,
    }
}
#[doc = "The list of RouteTables to advertise the routes to."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PropagatedRouteTable {
    #[doc = "The list of labels."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<String>,
    #[doc = "The list of resource ids of all the RouteTables."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub ids: Vec<SubResource>,
}
impl PropagatedRouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configuration of the protocol."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtocolConfiguration {
    #[doc = "HTTP configuration of the connectivity check."]
    #[serde(rename = "HTTPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub http_configuration: Option<HttpConfiguration>,
}
impl ProtocolConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DDoS custom policy properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtocolCustomSettingsFormat {
    #[doc = "The protocol for which the DDoS protection policy is being customized."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<protocol_custom_settings_format::Protocol>,
    #[doc = "The customized DDoS protection trigger rate."]
    #[serde(rename = "triggerRateOverride", default, skip_serializing_if = "Option::is_none")]
    pub trigger_rate_override: Option<String>,
    #[doc = "The customized DDoS protection source rate."]
    #[serde(rename = "sourceRateOverride", default, skip_serializing_if = "Option::is_none")]
    pub source_rate_override: Option<String>,
    #[doc = "The customized DDoS protection trigger rate sensitivity degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t. normal traffic."]
    #[serde(rename = "triggerSensitivityOverride", default, skip_serializing_if = "Option::is_none")]
    pub trigger_sensitivity_override: Option<protocol_custom_settings_format::TriggerSensitivityOverride>,
}
impl ProtocolCustomSettingsFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protocol_custom_settings_format {
    use super::*;
    #[doc = "The protocol for which the DDoS protection policy is being customized."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        Syn,
    }
    #[doc = "The customized DDoS protection trigger rate sensitivity degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t. normal traffic."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TriggerSensitivityOverride {
        Relaxed,
        Low,
        Default,
        High,
    }
}
#[doc = "Ssl protocol enums."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProtocolsEnum {
    #[serde(rename = "TLSv1_0")]
    TlSv10,
    #[serde(rename = "TLSv1_1")]
    TlSv11,
    #[serde(rename = "TLSv1_2")]
    TlSv12,
}
#[doc = "The current provisioning state."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProvisioningState {
    Succeeded,
    Updating,
    Deleting,
    Failed,
}
#[doc = "Proxy resource representation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Public IP address resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddress {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "ExtendedLocation complex type."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<ExtendedLocation>,
    #[doc = "SKU of a public IP address."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<PublicIpAddressSku>,
    #[doc = "Public IP address properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Box<Option<PublicIpAddressPropertiesFormat>>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "A list of availability zones denoting the IP allocated for the resource needs to come from."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl PublicIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains FQDN of the DNS record associated with the public IP address."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressDnsSettings {
    #[doc = "The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system."]
    #[serde(rename = "domainNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub domain_name_label: Option<String>,
    #[doc = "The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN."]
    #[serde(rename = "reverseFqdn", default, skip_serializing_if = "Option::is_none")]
    pub reverse_fqdn: Option<String>,
}
impl PublicIpAddressDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListPublicIpAddresses API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressListResult {
    #[doc = "A list of public IP addresses that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PublicIpAddress>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PublicIpAddressListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Public IP address properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressPropertiesFormat {
    #[doc = "IP address allocation method."]
    #[serde(rename = "publicIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_allocation_method: Option<IpAllocationMethod>,
    #[doc = "IP address version."]
    #[serde(rename = "publicIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_version: Option<IpVersion>,
    #[doc = "IP configuration."]
    #[serde(rename = "ipConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration: Option<IpConfiguration>,
    #[doc = "Contains FQDN of the DNS record associated with the public IP address."]
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<PublicIpAddressDnsSettings>,
    #[doc = "Contains the DDoS protection settings of the public IP."]
    #[serde(rename = "ddosSettings", default, skip_serializing_if = "Option::is_none")]
    pub ddos_settings: Option<DdosSettings>,
    #[doc = "The list of tags associated with the public IP address."]
    #[serde(rename = "ipTags", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_tags: Vec<IpTag>,
    #[doc = "The IP address associated with the public IP address resource."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "publicIPPrefix", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_prefix: Option<SubResource>,
    #[doc = "The idle timeout of the public IP address."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "The resource GUID property of the public IP address resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Public IP address resource."]
    #[serde(rename = "servicePublicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub service_public_ip_address: Option<PublicIpAddress>,
    #[doc = "Nat Gateway resource."]
    #[serde(rename = "natGateway", default, skip_serializing_if = "Option::is_none")]
    pub nat_gateway: Option<NatGateway>,
    #[doc = "Migration phase of Public IP Address."]
    #[serde(rename = "migrationPhase", default, skip_serializing_if = "Option::is_none")]
    pub migration_phase: Option<public_ip_address_properties_format::MigrationPhase>,
    #[doc = "Public IP address resource."]
    #[serde(rename = "linkedPublicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub linked_public_ip_address: Option<PublicIpAddress>,
    #[doc = "Specify what happens to the public IP address when the VM using it is deleted"]
    #[serde(rename = "deleteOption", default, skip_serializing_if = "Option::is_none")]
    pub delete_option: Option<public_ip_address_properties_format::DeleteOption>,
}
impl PublicIpAddressPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_address_properties_format {
    use super::*;
    #[doc = "Migration phase of Public IP Address."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MigrationPhase {
        None,
        Prepare,
        Commit,
        Abort,
        Committed,
    }
    #[doc = "Specify what happens to the public IP address when the VM using it is deleted"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeleteOption {
        Delete,
        Detach,
    }
}
#[doc = "SKU of a public IP address."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressSku {
    #[doc = "Name of a public IP address SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<public_ip_address_sku::Name>,
    #[doc = "Tier of a public IP address SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<public_ip_address_sku::Tier>,
}
impl PublicIpAddressSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_address_sku {
    use super::*;
    #[doc = "Name of a public IP address SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
    }
    #[doc = "Tier of a public IP address SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Regional,
        Global,
    }
}
#[doc = "Public IP prefix resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpPrefix {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "ExtendedLocation complex type."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<ExtendedLocation>,
    #[doc = "SKU of a public IP prefix."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<PublicIpPrefixSku>,
    #[doc = "Public IP prefix properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PublicIpPrefixPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "A list of availability zones denoting the IP allocated for the resource needs to come from."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl PublicIpPrefix {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListPublicIpPrefixes API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpPrefixListResult {
    #[doc = "A list of public IP prefixes that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PublicIpPrefix>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PublicIpPrefixListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Public IP prefix properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpPrefixPropertiesFormat {
    #[doc = "IP address version."]
    #[serde(rename = "publicIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_version: Option<IpVersion>,
    #[doc = "The list of tags associated with the public IP prefix."]
    #[serde(rename = "ipTags", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_tags: Vec<IpTag>,
    #[doc = "The Length of the Public IP Prefix."]
    #[serde(rename = "prefixLength", default, skip_serializing_if = "Option::is_none")]
    pub prefix_length: Option<i32>,
    #[doc = "The allocated Prefix."]
    #[serde(rename = "ipPrefix", default, skip_serializing_if = "Option::is_none")]
    pub ip_prefix: Option<String>,
    #[doc = "The list of all referenced PublicIPAddresses."]
    #[serde(rename = "publicIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_addresses: Vec<ReferencedPublicIpAddress>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "loadBalancerFrontendIpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub load_balancer_frontend_ip_configuration: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "customIPPrefix", default, skip_serializing_if = "Option::is_none")]
    pub custom_ip_prefix: Option<SubResource>,
    #[doc = "The resource GUID property of the public IP prefix resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Nat Gateway resource."]
    #[serde(rename = "natGateway", default, skip_serializing_if = "Option::is_none")]
    pub nat_gateway: Option<NatGateway>,
}
impl PublicIpPrefixPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SKU of a public IP prefix."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpPrefixSku {
    #[doc = "Name of a public IP prefix SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<public_ip_prefix_sku::Name>,
    #[doc = "Tier of a public IP prefix SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<public_ip_prefix_sku::Tier>,
}
impl PublicIpPrefixSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_prefix_sku {
    use super::*;
    #[doc = "Name of a public IP prefix SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Standard,
    }
    #[doc = "Tier of a public IP prefix SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Regional,
        Global,
    }
}
#[doc = "Quality of Service defines the traffic configuration between endpoints. Mandatory to have one marking."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QosDefinition {
    #[doc = "List of markings to be used in the configuration."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub markings: Vec<i32>,
    #[doc = "Source IP ranges."]
    #[serde(rename = "sourceIpRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_ranges: Vec<QosIpRange>,
    #[doc = "Destination IP ranges."]
    #[serde(rename = "destinationIpRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ip_ranges: Vec<QosIpRange>,
    #[doc = "Sources port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<QosPortRange>,
    #[doc = "Destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<QosPortRange>,
    #[doc = "RNM supported protocol types."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<qos_definition::Protocol>,
}
impl QosDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod qos_definition {
    use super::*;
    #[doc = "RNM supported protocol types."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        DoNotUse,
        Icmp,
        Tcp,
        Udp,
        Gre,
        Esp,
        Ah,
        Vxlan,
        All,
    }
}
#[doc = "Qos Traffic Profiler IP Range properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QosIpRange {
    #[doc = "Start IP Address."]
    #[serde(rename = "startIP", default, skip_serializing_if = "Option::is_none")]
    pub start_ip: Option<String>,
    #[doc = "End IP Address."]
    #[serde(rename = "endIP", default, skip_serializing_if = "Option::is_none")]
    pub end_ip: Option<String>,
}
impl QosIpRange {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Qos Traffic Profiler Port range properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QosPortRange {
    #[doc = "Qos Port Range start."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub start: Option<i32>,
    #[doc = "Qos Port Range end."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub end: Option<i32>,
}
impl QosPortRange {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The request for a QueryInboundNatRulePortMapping API. Either IpConfiguration or IpAddress should be set"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryInboundNatRulePortMappingRequest {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "ipConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration: Option<SubResource>,
    #[doc = "IP address set in load balancer backend address."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
}
impl QueryInboundNatRulePortMappingRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Query Request Options"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryRequestOptions {
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl QueryRequestOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Query result"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryResults {
    #[doc = "Number of total records matching the query."]
    #[serde(rename = "matchingRecordsCount", default, skip_serializing_if = "Option::is_none")]
    pub matching_records_count: Option<i64>,
    #[doc = "Array containing the results of the query"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub signatures: Vec<SingleQueryResult>,
}
impl QueryResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the resource to query the troubleshooting result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryTroubleshootingParameters {
    #[doc = "The target resource ID to query the troubleshooting result."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
}
impl QueryTroubleshootingParameters {
    pub fn new(target_resource_id: String) -> Self {
        Self { target_resource_id }
    }
}
#[doc = "Radius Server Settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RadiusServer {
    #[doc = "The address of this radius server."]
    #[serde(rename = "radiusServerAddress")]
    pub radius_server_address: String,
    #[doc = "The initial score assigned to this radius server."]
    #[serde(rename = "radiusServerScore", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_score: Option<i64>,
    #[doc = "The secret used for this radius server."]
    #[serde(rename = "radiusServerSecret", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_secret: Option<String>,
}
impl RadiusServer {
    pub fn new(radius_server_address: String) -> Self {
        Self {
            radius_server_address,
            radius_server_score: None,
            radius_server_secret: None,
        }
    }
}
#[doc = "A collective group of information about the record set information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecordSet {
    #[doc = "Resource record type."]
    #[serde(rename = "recordType", default, skip_serializing_if = "Option::is_none")]
    pub record_type: Option<String>,
    #[doc = "Recordset name."]
    #[serde(rename = "recordSetName", default, skip_serializing_if = "Option::is_none")]
    pub record_set_name: Option<String>,
    #[doc = "Fqdn that resolves to private endpoint ip address."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Recordset time to live."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub ttl: Option<i64>,
    #[doc = "The private ip address of the private endpoint."]
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
}
impl RecordSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Redirect type enum."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RedirectTypeEnum {
    Permanent,
    Found,
    SeeOther,
    Temporary,
}
#[doc = "Reference to a public IP address."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReferencedPublicIpAddress {
    #[doc = "The PublicIPAddress Reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ReferencedPublicIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common resource representation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ResourceNavigationLink resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of ResourceNavigationLink."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ResourceNavigationLinkFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource navigation link identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ResourceNavigationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ResourceNavigationLink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLinkFormat {
    #[doc = "Resource type of the linked resource."]
    #[serde(rename = "linkedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_type: Option<String>,
    #[doc = "Link to the external resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ResourceNavigationLinkFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ResourceNavigationLinks_List operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLinksListResult {
    #[doc = "The resource navigation links in a subnet."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceNavigationLink>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceNavigationLinksListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The base resource set for visibility and auto-approval."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSet {
    #[doc = "The list of subscriptions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subscriptions: Vec<String>,
}
impl ResourceSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the retention policy for flow log."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetentionPolicyParameters {
    #[doc = "Number of days to retain flow log records."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub days: Option<i32>,
    #[doc = "Flag to enable/disable retention."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl RetentionPolicyParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Route {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Route resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RoutePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Route {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RouteFilter {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Route Filter Resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteFilter {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[doc = "Response for the ListRouteFilters API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterListResult {
    #[doc = "A list of route filters in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteFilter>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteFilterListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterPropertiesFormat {
    #[doc = "Collection of RouteFilterRules contained within a route filter."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<RouteFilterRule>,
    #[doc = "A collection of references to express route circuit peerings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCircuitPeering>,
    #[doc = "A collection of references to express route circuit ipv6 peerings."]
    #[serde(rename = "ipv6Peerings", default, skip_serializing_if = "Vec::is_empty")]
    pub ipv6_peerings: Vec<ExpressRouteCircuitPeering>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RouteFilterPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Rule Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Route Filter Rule Resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteFilterRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListRouteFilterRules API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterRuleListResult {
    #[doc = "A list of RouteFilterRules in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteFilterRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteFilterRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Rule Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RouteFilterRulePropertiesFormat {
    #[doc = "Access to be allowed or denied."]
    pub access: Access,
    #[doc = "The rule type of the rule."]
    #[serde(rename = "routeFilterRuleType")]
    pub route_filter_rule_type: route_filter_rule_properties_format::RouteFilterRuleType,
    #[doc = "The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020']."]
    pub communities: Vec<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RouteFilterRulePropertiesFormat {
    pub fn new(
        access: Access,
        route_filter_rule_type: route_filter_rule_properties_format::RouteFilterRuleType,
        communities: Vec<String>,
    ) -> Self {
        Self {
            access,
            route_filter_rule_type,
            communities,
            provisioning_state: None,
        }
    }
}
pub mod route_filter_rule_properties_format {
    use super::*;
    #[doc = "The rule type of the rule."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RouteFilterRuleType {
        Community,
    }
}
#[doc = "Response for the ListRoute API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteListResult {
    #[doc = "A list of routes in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Route>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The type of Azure hop the packet should be sent to."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RouteNextHopType {
    VirtualNetworkGateway,
    VnetLocal,
    Internet,
    VirtualAppliance,
    None,
}
#[doc = "Route resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutePropertiesFormat {
    #[doc = "The destination CIDR to which the route applies."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "The type of Azure hop the packet should be sent to."]
    #[serde(rename = "nextHopType")]
    pub next_hop_type: RouteNextHopType,
    #[doc = "The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance."]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "A value indicating whether this route overrides overlapping BGP routes regardless of LPM."]
    #[serde(rename = "hasBgpOverride", default, skip_serializing_if = "Option::is_none")]
    pub has_bgp_override: Option<bool>,
}
impl RoutePropertiesFormat {
    pub fn new(next_hop_type: RouteNextHopType) -> Self {
        Self {
            address_prefix: None,
            next_hop_type,
            next_hop_ip_address: None,
            provisioning_state: None,
            has_bgp_override: None,
        }
    }
}
#[doc = "Route table resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTable {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Route Table resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteTablePropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListRouteTable API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTableListResult {
    #[doc = "A list of route tables in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteTable>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Table resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTablePropertiesFormat {
    #[doc = "Collection of routes contained within a route table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<Route>,
    #[doc = "A collection of references to subnets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "Whether to disable the routes learned by BGP on that route table. True means disable."]
    #[serde(rename = "disableBgpRoutePropagation", default, skip_serializing_if = "Option::is_none")]
    pub disable_bgp_route_propagation: Option<bool>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The resource GUID property of the route table."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
}
impl RouteTablePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Routing Configuration indicating the associated and propagated route tables for this connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingConfiguration {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "associatedRouteTable", default, skip_serializing_if = "Option::is_none")]
    pub associated_route_table: Option<SubResource>,
    #[doc = "The list of RouteTables to advertise the routes to."]
    #[serde(rename = "propagatedRouteTables", default, skip_serializing_if = "Option::is_none")]
    pub propagated_route_tables: Option<PropagatedRouteTable>,
    #[doc = "List of routes that control routing from VirtualHub into a virtual network connection."]
    #[serde(rename = "vnetRoutes", default, skip_serializing_if = "Option::is_none")]
    pub vnet_routes: Option<VnetRoute>,
}
impl RoutingConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The routing intent child resource of a Virtual hub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingIntent {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "The properties of a RoutingIntent resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RoutingIntentProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl RoutingIntent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The properties of a RoutingIntent resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingIntentProperties {
    #[doc = "List of routing policies."]
    #[serde(rename = "routingPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub routing_policies: Vec<RoutingPolicy>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RoutingIntentProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The routing policy object used in a RoutingIntent resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutingPolicy {
    #[doc = "The unique name for the routing policy."]
    pub name: String,
    #[doc = "List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic)."]
    pub destinations: Vec<String>,
    #[doc = "The next hop resource id on which this routing policy is applicable to."]
    #[serde(rename = "nextHop")]
    pub next_hop: String,
}
impl RoutingPolicy {
    pub fn new(name: String, destinations: Vec<String>, next_hop: String) -> Self {
        Self {
            name,
            destinations,
            next_hop,
        }
    }
}
#[doc = "The current routing state of the VirtualHub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RoutingState {
    None,
    Provisioned,
    Provisioning,
    Failed,
}
#[doc = "Defines the rule collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleCollection {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Defines the rule collection properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RuleCollectionPropertiesFormat>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl RuleCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security configuration rule collection list result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleCollectionListResult {
    #[doc = "A list of network manager security configuration rule collections"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RuleCollection>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RuleCollectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines the rule collection properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RuleCollectionPropertiesFormat {
    #[doc = "A display name of the rule collection."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the rule collection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Groups for configuration"]
    #[serde(rename = "appliesToGroups")]
    pub applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RuleCollectionPropertiesFormat {
    pub fn new(applies_to_groups: Vec<NetworkManagerSecurityGroupItem>) -> Self {
        Self {
            display_name: None,
            description: None,
            applies_to_groups,
            provisioning_state: None,
        }
    }
}
#[doc = "Network protocol this rule applies to."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RuleProtocol {
    Tcp,
    Udp,
    Icmp,
    Esp,
    Any,
    Ah,
}
#[doc = "The Scope Connections resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeConnection {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Scope connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ScopeConnectionProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ScopeConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of scope connections."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeConnectionListResult {
    #[doc = "List of scope connections."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ScopeConnection>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ScopeConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Scope connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScopeConnectionProperties {
    #[doc = "Tenant ID."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "Resource ID."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "The current scope connection state."]
    #[serde(rename = "connectionState", default, skip_serializing_if = "Option::is_none")]
    pub connection_state: Option<ConnectionState>,
    #[doc = "A description of the scope connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ScopeConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines the security configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConfiguration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Defines the security Configuration properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityConfigurationPropertiesFormat>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl SecurityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of network manager security configurations"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConfigurationListResult {
    #[doc = "Gets a page of security configurations"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityConfiguration>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines the security Configuration properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConfigurationPropertiesFormat {
    #[doc = "A display name of the security configuration."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the security configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Security Type."]
    #[serde(rename = "securityType", default, skip_serializing_if = "Option::is_none")]
    pub security_type: Option<security_configuration_properties_format::SecurityType>,
    #[doc = "Enum list of network intent policy based services."]
    #[serde(rename = "applyOnNetworkIntentPolicyBasedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub apply_on_network_intent_policy_based_services: Vec<NetworkIntentPolicyBasedService>,
    #[doc = "Flag if need to delete existing network security groups."]
    #[serde(rename = "deleteExistingNSGs", default, skip_serializing_if = "Option::is_none")]
    pub delete_existing_ns_gs: Option<security_configuration_properties_format::DeleteExistingNsGs>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl SecurityConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod security_configuration_properties_format {
    use super::*;
    #[doc = "Security Type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SecurityType {
        AdminPolicy,
        UserPolicy,
    }
    #[doc = "Flag if need to delete existing network security groups."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeleteExistingNsGs {
        False,
        True,
    }
}
#[doc = "Whether network traffic is allowed or denied."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityConfigurationRuleAccess {
    Allow,
    Deny,
    AlwaysAllow,
}
#[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityConfigurationRuleDirection {
    Inbound,
    Outbound,
}
#[doc = "Network interface and all its associated security rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityGroupNetworkInterface {
    #[doc = "ID of the network interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "All security rules associated with the network interface."]
    #[serde(rename = "securityRuleAssociations", default, skip_serializing_if = "Option::is_none")]
    pub security_rule_associations: Option<SecurityRuleAssociations>,
}
impl SecurityGroupNetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the VM to check security groups for."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityGroupViewParameters {
    #[doc = "ID of the target VM."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
}
impl SecurityGroupViewParameters {
    pub fn new(target_resource_id: String) -> Self {
        Self { target_resource_id }
    }
}
#[doc = "The information about security rules applied to the specified VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityGroupViewResult {
    #[doc = "List of network interfaces on the specified VM."]
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<SecurityGroupNetworkInterface>,
}
impl SecurityGroupViewResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security Partner Provider resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPartnerProvider {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the Security Partner Provider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityPartnerProviderPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl SecurityPartnerProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The current state of the connection with Security Partner Provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityPartnerProviderConnectionStatus {
    Unknown,
    PartiallyConnected,
    Connected,
    NotConnected,
}
#[doc = "Response for ListSecurityPartnerProviders API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPartnerProviderListResult {
    #[doc = "List of Security Partner Providers in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityPartnerProvider>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityPartnerProviderListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the Security Partner Provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPartnerProviderPropertiesFormat {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The Security Providers."]
    #[serde(rename = "securityProviderName", default, skip_serializing_if = "Option::is_none")]
    pub security_provider_name: Option<SecurityPartnerProvidersecurityProviderName>,
    #[doc = "The current state of the connection with Security Partner Provider."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<SecurityPartnerProviderConnectionStatus>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
}
impl SecurityPartnerProviderPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Security Providers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityPartnerProvidersecurityProviderName {
    ZScaler,
    IBoss,
    Checkpoint,
}
#[doc = "Network security rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Security rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl SecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Whether network traffic is allowed or denied."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityRuleAccess {
    Allow,
    Deny,
}
#[doc = "All security rules associated with the network interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRuleAssociations {
    #[doc = "Network interface and its custom security rules."]
    #[serde(rename = "networkInterfaceAssociation", default, skip_serializing_if = "Option::is_none")]
    pub network_interface_association: Option<NetworkInterfaceAssociation>,
    #[doc = "Subnet and it's custom security rules."]
    #[serde(rename = "subnetAssociation", default, skip_serializing_if = "Option::is_none")]
    pub subnet_association: Option<SubnetAssociation>,
    #[doc = "Collection of default security rules of the network security group."]
    #[serde(rename = "defaultSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub default_security_rules: Vec<SecurityRule>,
    #[doc = "Collection of effective security rules."]
    #[serde(rename = "effectiveSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_security_rules: Vec<EffectiveNetworkSecurityRule>,
}
impl SecurityRuleAssociations {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityRuleDirection {
    Inbound,
    Outbound,
}
#[doc = "Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a network security group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRuleListResult {
    #[doc = "The security rules in a network security group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityRulePropertiesFormat {
    #[doc = "A description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Network protocol this rule applies to."]
    pub protocol: security_rule_properties_format::Protocol,
    #[doc = "The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports."]
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[doc = "The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports."]
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[doc = "The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from."]
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(rename = "sourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub source_address_prefixes: Vec<String>,
    #[doc = "The application security group specified as source."]
    #[serde(rename = "sourceApplicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_application_security_groups: Vec<ApplicationSecurityGroup>,
    #[doc = "The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used."]
    #[serde(rename = "destinationAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub destination_address_prefix: Option<String>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(rename = "destinationAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_address_prefixes: Vec<String>,
    #[doc = "The application security group specified as destination."]
    #[serde(rename = "destinationApplicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_application_security_groups: Vec<ApplicationSecurityGroup>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "Whether network traffic is allowed or denied."]
    pub access: SecurityRuleAccess,
    #[doc = "The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic."]
    pub direction: SecurityRuleDirection,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl SecurityRulePropertiesFormat {
    pub fn new(protocol: security_rule_properties_format::Protocol, access: SecurityRuleAccess, direction: SecurityRuleDirection) -> Self {
        Self {
            description: None,
            protocol,
            source_port_range: None,
            destination_port_range: None,
            source_address_prefix: None,
            source_address_prefixes: Vec::new(),
            source_application_security_groups: Vec::new(),
            destination_address_prefix: None,
            destination_address_prefixes: Vec::new(),
            destination_application_security_groups: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            access,
            priority: None,
            direction,
            provisioning_state: None,
        }
    }
}
pub mod security_rule_properties_format {
    use super::*;
    #[doc = "Network protocol this rule applies to."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        Icmp,
        Esp,
        #[serde(rename = "*")]
        U2a,
        Ah,
    }
}
#[doc = "ServiceAssociationLink resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceAssociationLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of ServiceAssociationLink."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceAssociationLinkPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ServiceAssociationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ServiceAssociationLink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceAssociationLinkPropertiesFormat {
    #[doc = "Resource type of the linked resource."]
    #[serde(rename = "linkedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_type: Option<String>,
    #[doc = "Link to the external resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "If true, the resource can be deleted."]
    #[serde(rename = "allowDelete", default, skip_serializing_if = "Option::is_none")]
    pub allow_delete: Option<bool>,
    #[doc = "A list of locations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
}
impl ServiceAssociationLinkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ServiceAssociationLinks_List operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceAssociationLinksListResult {
    #[doc = "The service association links in a subnet."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceAssociationLink>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceAssociationLinksListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a service delegation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceDelegationPropertiesFormat {
    #[doc = "The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers)."]
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[doc = "The actions permitted to the service upon delegation."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub actions: Vec<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ServiceDelegationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Service End point policy resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Service Endpoint Policy resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceEndpointPolicyPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Kind of service endpoint policy. This is metadata used for the Azure portal experience."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl ServiceEndpointPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Service Endpoint policy definitions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyDefinition {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Service Endpoint policy definition resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceEndpointPolicyDefinitionPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ServiceEndpointPolicyDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListServiceEndpointPolicyDefinition API service call. Retrieves all service endpoint policy definition that belongs to a service endpoint policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyDefinitionListResult {
    #[doc = "The service endpoint policy definition in a service endpoint policy."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceEndpointPolicyDefinition>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceEndpointPolicyDefinitionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Service Endpoint policy definition resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyDefinitionPropertiesFormat {
    #[doc = "A description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Service endpoint name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub service: Option<String>,
    #[doc = "A list of service resources."]
    #[serde(rename = "serviceResources", default, skip_serializing_if = "Vec::is_empty")]
    pub service_resources: Vec<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ServiceEndpointPolicyDefinitionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListServiceEndpointPolicies API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyListResult {
    #[doc = "A list of ServiceEndpointPolicy resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceEndpointPolicy>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceEndpointPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Service Endpoint Policy resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyPropertiesFormat {
    #[doc = "A collection of service endpoint policy definitions of the service endpoint policy."]
    #[serde(rename = "serviceEndpointPolicyDefinitions", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoint_policy_definitions: Vec<ServiceEndpointPolicyDefinition>,
    #[doc = "A collection of references to subnets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "The resource GUID property of the service endpoint policy resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The alias indicating if the policy belongs to a service"]
    #[serde(rename = "serviceAlias", default, skip_serializing_if = "Option::is_none")]
    pub service_alias: Option<String>,
    #[doc = "A collection of contextual service endpoint policy."]
    #[serde(rename = "contextualServiceEndpointPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub contextual_service_endpoint_policies: Vec<String>,
}
impl ServiceEndpointPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The service endpoint properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPropertiesFormat {
    #[doc = "The type of the endpoint service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub service: Option<String>,
    #[doc = "A list of locations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ServiceEndpointPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The ServiceProviderProvisioningState state of the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ServiceProviderProvisioningState {
    NotProvisioned,
    Provisioning,
    Provisioned,
    Deprovisioning,
}
#[doc = "The service tag information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTagInformation {
    #[doc = "Properties of the service tag information."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceTagInformationPropertiesFormat>,
    #[doc = "The name of service tag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The ID of service tag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The iteration number of service tag object for region."]
    #[serde(rename = "serviceTagChangeNumber", default, skip_serializing_if = "Option::is_none")]
    pub service_tag_change_number: Option<String>,
}
impl ServiceTagInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for Get ServiceTagInformation API service call. Retrieves the list of service tag information resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTagInformationListResult {
    #[doc = "The list of service tag information resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceTagInformation>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceTagInformationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the service tag information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTagInformationPropertiesFormat {
    #[doc = "The iteration number of service tag."]
    #[serde(rename = "changeNumber", default, skip_serializing_if = "Option::is_none")]
    pub change_number: Option<String>,
    #[doc = "The region of service tag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "The name of system service."]
    #[serde(rename = "systemService", default, skip_serializing_if = "Option::is_none")]
    pub system_service: Option<String>,
    #[doc = "The list of IP address prefixes."]
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[doc = "The state of the service tag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}
impl ServiceTagInformationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListServiceTags API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTagsListResult {
    #[doc = "The name of the cloud."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The ID of the cloud."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The azure resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The iteration number."]
    #[serde(rename = "changeNumber", default, skip_serializing_if = "Option::is_none")]
    pub change_number: Option<String>,
    #[doc = "The name of the cloud."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cloud: Option<String>,
    #[doc = "The list of service tag information resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<ServiceTagInformation>,
    #[doc = "The URL to get next page of service tag information resources."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceTagsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of session IDs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SessionIds {
    #[doc = "List of session IDs."]
    #[serde(rename = "sessionIds", default, skip_serializing_if = "Vec::is_empty")]
    pub session_ids: Vec<String>,
}
impl SessionIds {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the filter values possibles for a given column"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SignatureOverridesFilterValuesQuery {
    #[doc = "Describes the name of the column which values will be returned"]
    #[serde(rename = "filterName", default, skip_serializing_if = "Option::is_none")]
    pub filter_name: Option<String>,
}
impl SignatureOverridesFilterValuesQuery {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the list of all possible values for a specific filter value"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SignatureOverridesFilterValuesResponse {
    #[doc = "Describes the possible values"]
    #[serde(rename = "filterValues", default, skip_serializing_if = "Vec::is_empty")]
    pub filter_values: Vec<String>,
}
impl SignatureOverridesFilterValuesResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Signatures {}
impl Signatures {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains all specific policy signatures overrides for the IDPS"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SignaturesOverrides {
    #[doc = "Contains the name of the resource (default)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Will contain the resource id of the signature override resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Will contain the type of the resource: Microsoft.Network/firewallPolicies/intrusionDetectionSignaturesOverrides"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Will contain the properties of the resource (the actual signature overrides)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<signatures_overrides::Properties>,
}
impl SignaturesOverrides {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod signatures_overrides {
    use super::*;
    #[doc = "Will contain the properties of the resource (the actual signature overrides)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub signatures: Option<Signatures>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Describes an object containing an array with a single item"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SignaturesOverridesList {
    #[doc = "Describes a list consisting exactly one item describing the policy's signature override status"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SignaturesOverrides>,
}
impl SignaturesOverridesList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SingleQueryResult {
    #[doc = "The ID of the signature"]
    #[serde(rename = "signatureId", default, skip_serializing_if = "Option::is_none")]
    pub signature_id: Option<i32>,
    #[doc = "The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<single_query_result::Mode>,
    #[doc = "Describes the severity of signature: 1 - Low, 2 - Medium, 3 - High"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<single_query_result::Severity>,
    #[doc = "Describes in which direction signature is being enforced: 0 - Inbound, 1 - OutBound, 2 - Bidirectional"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<single_query_result::Direction>,
    #[doc = "Describes the groups the signature belongs to"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub group: Option<String>,
    #[doc = "Describes what is the signature enforces"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Describes the protocol the signatures is being enforced in"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<String>,
    #[doc = "Describes the list of source ports related to this signature"]
    #[serde(rename = "sourcePorts", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ports: Vec<PortsList>,
    #[doc = "Describes the list of destination ports related to this signature"]
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<PortsList>,
    #[doc = "Describes the last updated time of the signature (provided from 3rd party vendor)"]
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[doc = "Describes if this override is inherited from base policy or not"]
    #[serde(rename = "inheritedFromParentPolicy", default, skip_serializing_if = "Option::is_none")]
    pub inherited_from_parent_policy: Option<bool>,
}
impl SingleQueryResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod single_query_result {
    use super::*;
    #[doc = "The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {}
    #[doc = "Describes the severity of signature: 1 - Low, 2 - Medium, 3 - High"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {}
    #[doc = "Describes in which direction signature is being enforced: 0 - Inbound, 1 - OutBound, 2 - Bidirectional"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {}
}
#[doc = "The sku of this Bastion Host."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[doc = "The name of this Bastion Host."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<sku::Name>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sku {
    use super::*;
    #[doc = "The name of this Bastion Host."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
    }
    impl Default for Name {
        fn default() -> Self {
            Self::Standard
        }
    }
}
#[doc = "StaticMember Item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StaticMember {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of static member."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<StaticMemberProperties>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl StaticMember {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list StaticMember. It contains a list of groups and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StaticMemberListResult {
    #[doc = "Gets a page of StaticMember"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<StaticMember>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl StaticMemberListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of static member."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StaticMemberProperties {
    #[doc = "Resource Id."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl StaticMemberProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of all Static Routes."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StaticRoute {
    #[doc = "The name of the StaticRoute that is unique within a VnetRoute."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "List of all address prefixes."]
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[doc = "The ip address of the next hop."]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
}
impl StaticRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Reference to another subresource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Subnet in a virtual network resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Subnet {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the subnet."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubnetPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Subnet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Subnet and it's custom security rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetAssociation {
    #[doc = "Subnet ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Collection of custom security rules."]
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
}
impl SubnetAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetListResult {
    #[doc = "The subnets in a virtual network."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Subnet>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SubnetListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the subnet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetPropertiesFormat {
    #[doc = "The address prefix for the subnet."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "List of address prefixes for the subnet."]
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[doc = "NetworkSecurityGroup resource."]
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[doc = "Route table resource."]
    #[serde(rename = "routeTable", default, skip_serializing_if = "Option::is_none")]
    pub route_table: Option<RouteTable>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "natGateway", default, skip_serializing_if = "Option::is_none")]
    pub nat_gateway: Option<SubResource>,
    #[doc = "An array of service endpoints."]
    #[serde(rename = "serviceEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoints: Vec<ServiceEndpointPropertiesFormat>,
    #[doc = "An array of service endpoint policies."]
    #[serde(rename = "serviceEndpointPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoint_policies: Vec<ServiceEndpointPolicy>,
    #[doc = "An array of references to private endpoints."]
    #[serde(rename = "privateEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoints: Vec<PrivateEndpoint>,
    #[doc = "An array of references to the network interface IP configurations using subnet."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<IpConfiguration>,
    #[doc = "Array of IP configuration profiles which reference this subnet."]
    #[serde(rename = "ipConfigurationProfiles", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configuration_profiles: Vec<IpConfigurationProfile>,
    #[doc = "Array of IpAllocation which reference this subnet."]
    #[serde(rename = "ipAllocations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_allocations: Vec<SubResource>,
    #[doc = "An array of references to the external resources using subnet."]
    #[serde(rename = "resourceNavigationLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_navigation_links: Vec<ResourceNavigationLink>,
    #[doc = "An array of references to services injecting into this subnet."]
    #[serde(rename = "serviceAssociationLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub service_association_links: Vec<ServiceAssociationLink>,
    #[doc = "An array of references to the delegations on the subnet."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub delegations: Vec<Delegation>,
    #[doc = "A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub purpose: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Enable or Disable apply network policies on private end point in the subnet."]
    #[serde(rename = "privateEndpointNetworkPolicies", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint_network_policies: Option<subnet_properties_format::PrivateEndpointNetworkPolicies>,
    #[doc = "Enable or Disable apply network policies on private link service in the subnet."]
    #[serde(rename = "privateLinkServiceNetworkPolicies", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_network_policies: Option<subnet_properties_format::PrivateLinkServiceNetworkPolicies>,
    #[doc = "Application gateway IP configurations of virtual network resource."]
    #[serde(rename = "applicationGatewayIpConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_ip_configurations: Vec<ApplicationGatewayIpConfiguration>,
}
impl SubnetPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod subnet_properties_format {
    use super::*;
    #[doc = "Enable or Disable apply network policies on private end point in the subnet."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateEndpointNetworkPolicies {
        Enabled,
        Disabled,
    }
    impl Default for PrivateEndpointNetworkPolicies {
        fn default() -> Self {
            Self::Enabled
        }
    }
    #[doc = "Enable or Disable apply network policies on private link service in the subnet."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateLinkServiceNetworkPolicies {
        Enabled,
        Disabled,
    }
    impl Default for PrivateLinkServiceNetworkPolicies {
        fn default() -> Self {
            Self::Enabled
        }
    }
}
#[doc = "Metadata pertaining to creation and last modification of the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[doc = "The identity that created the resource."]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[doc = "The type of identity that created the resource."]
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[doc = "The timestamp of resource creation (UTC)."]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "The identity that last modified the resource."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[doc = "The type of identity that created the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[doc = "The type of identity that last modified the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
#[doc = "Tags object for patch operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsObject {
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TagsObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Topology of the specified resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Topology {
    #[doc = "GUID representing the operation id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The datetime when the topology was initially created for the resource group."]
    #[serde(rename = "createdDateTime", default, skip_serializing_if = "Option::is_none")]
    pub created_date_time: Option<String>,
    #[doc = "The datetime when the topology was last modified."]
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[doc = "A list of topology resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<TopologyResource>,
}
impl Topology {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Resources that have an association with the parent resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyAssociation {
    #[doc = "The name of the resource that is associated with the parent resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The ID of the resource that is associated with the parent resource."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "The association type of the child resource to the parent resource."]
    #[serde(rename = "associationType", default, skip_serializing_if = "Option::is_none")]
    pub association_type: Option<topology_association::AssociationType>,
}
impl TopologyAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod topology_association {
    use super::*;
    #[doc = "The association type of the child resource to the parent resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AssociationType {
        Associated,
        Contains,
    }
}
#[doc = "Parameters that define the representation of topology."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyParameters {
    #[doc = "The name of the target resource group to perform topology on."]
    #[serde(rename = "targetResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_name: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "targetVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub target_virtual_network: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "targetSubnet", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet: Option<SubResource>,
}
impl TopologyParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The network resource topology information for the given resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyResource {
    #[doc = "Name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "ID of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Holds the associations the resource has with other resources in the resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub associations: Vec<TopologyAssociation>,
}
impl TopologyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the configuration of traffic analytics."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrafficAnalyticsConfigurationProperties {
    #[doc = "Flag to enable/disable traffic analytics."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[doc = "The resource guid of the attached workspace."]
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[doc = "The location of the attached workspace."]
    #[serde(rename = "workspaceRegion", default, skip_serializing_if = "Option::is_none")]
    pub workspace_region: Option<String>,
    #[doc = "Resource Id of the attached workspace."]
    #[serde(rename = "workspaceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_resource_id: Option<String>,
    #[doc = "The interval in minutes which would decide how frequently TA service should do flow analytics."]
    #[serde(rename = "trafficAnalyticsInterval", default, skip_serializing_if = "Option::is_none")]
    pub traffic_analytics_interval: Option<i32>,
}
impl TrafficAnalyticsConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the configuration of traffic analytics."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrafficAnalyticsProperties {
    #[doc = "Parameters that define the configuration of traffic analytics."]
    #[serde(
        rename = "networkWatcherFlowAnalyticsConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub network_watcher_flow_analytics_configuration: Option<TrafficAnalyticsConfigurationProperties>,
}
impl TrafficAnalyticsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An traffic selector policy for a virtual network gateway connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrafficSelectorPolicy {
    #[doc = "A collection of local address spaces in CIDR format."]
    #[serde(rename = "localAddressRanges")]
    pub local_address_ranges: Vec<String>,
    #[doc = "A collection of remote address spaces in CIDR format."]
    #[serde(rename = "remoteAddressRanges")]
    pub remote_address_ranges: Vec<String>,
}
impl TrafficSelectorPolicy {
    pub fn new(local_address_ranges: Vec<String>, remote_address_ranges: Vec<String>) -> Self {
        Self {
            local_address_ranges,
            remote_address_ranges,
        }
    }
}
#[doc = "Transforms applied before matching."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Transform {
    Lowercase,
    Trim,
    UrlDecode,
    UrlEncode,
    RemoveNulls,
    HtmlEntityDecode,
}
#[doc = "The transport protocol for the endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TransportProtocol {
    Udp,
    Tcp,
    All,
}
#[doc = "Information gained from troubleshooting of specified resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TroubleshootingDetails {
    #[doc = "The id of the get troubleshoot operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Reason type of failure."]
    #[serde(rename = "reasonType", default, skip_serializing_if = "Option::is_none")]
    pub reason_type: Option<String>,
    #[doc = "A summary of troubleshooting."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub summary: Option<String>,
    #[doc = "Details on troubleshooting results."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub detail: Option<String>,
    #[doc = "List of recommended actions."]
    #[serde(rename = "recommendedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub recommended_actions: Vec<TroubleshootingRecommendedActions>,
}
impl TroubleshootingDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the resource to troubleshoot."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TroubleshootingParameters {
    #[doc = "The target resource to troubleshoot."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "Storage location provided for troubleshoot."]
    pub properties: TroubleshootingProperties,
}
impl TroubleshootingParameters {
    pub fn new(target_resource_id: String, properties: TroubleshootingProperties) -> Self {
        Self {
            target_resource_id,
            properties,
        }
    }
}
#[doc = "Storage location provided for troubleshoot."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TroubleshootingProperties {
    #[doc = "The ID for the storage account to save the troubleshoot result."]
    #[serde(rename = "storageId")]
    pub storage_id: String,
    #[doc = "The path to the blob to save the troubleshoot result in."]
    #[serde(rename = "storagePath")]
    pub storage_path: String,
}
impl TroubleshootingProperties {
    pub fn new(storage_id: String, storage_path: String) -> Self {
        Self { storage_id, storage_path }
    }
}
#[doc = "Recommended actions based on discovered issues."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TroubleshootingRecommendedActions {
    #[doc = "ID of the recommended action."]
    #[serde(rename = "actionId", default, skip_serializing_if = "Option::is_none")]
    pub action_id: Option<String>,
    #[doc = "Description of recommended actions."]
    #[serde(rename = "actionText", default, skip_serializing_if = "Option::is_none")]
    pub action_text: Option<String>,
    #[doc = "The uri linking to a documentation for the recommended troubleshooting actions."]
    #[serde(rename = "actionUri", default, skip_serializing_if = "Option::is_none")]
    pub action_uri: Option<String>,
    #[doc = "The information from the URI for the recommended troubleshooting actions."]
    #[serde(rename = "actionUriText", default, skip_serializing_if = "Option::is_none")]
    pub action_uri_text: Option<String>,
}
impl TroubleshootingRecommendedActions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Troubleshooting information gained from specified resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TroubleshootingResult {
    #[doc = "The start time of the troubleshooting."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time of the troubleshooting."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The result code of the troubleshooting."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Information from troubleshooting."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub results: Vec<TroubleshootingDetails>,
}
impl TroubleshootingResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualNetworkGatewayConnection properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TunnelConnectionHealth {
    #[doc = "Tunnel name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tunnel: Option<String>,
    #[doc = "Virtual Network Gateway connection status."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VirtualNetworkGatewayConnectionStatus>,
    #[doc = "The Ingress Bytes Transferred in this connection."]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[doc = "The Egress Bytes Transferred in this connection."]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "The time at which connection was established in Utc format."]
    #[serde(rename = "lastConnectionEstablishedUtcTime", default, skip_serializing_if = "Option::is_none")]
    pub last_connection_established_utc_time: Option<String>,
}
impl TunnelConnectionHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The current state of the tunnel."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TunnelConnectionStatus {
    Unknown,
    Connecting,
    Connected,
    NotConnected,
}
#[doc = "Details of UnprepareNetworkPolicies for Subnet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UnprepareNetworkPoliciesRequest {
    #[doc = "The name of the service for which subnet is being unprepared for."]
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
}
impl UnprepareNetworkPoliciesRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The network resource usage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    #[doc = "Resource identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "An enum describing the unit of measurement."]
    pub unit: usage::Unit,
    #[doc = "The current value of the usage."]
    #[serde(rename = "currentValue")]
    pub current_value: i64,
    #[doc = "The limit of usage."]
    pub limit: i64,
    #[doc = "The usage names."]
    pub name: UsageName,
}
impl Usage {
    pub fn new(unit: usage::Unit, current_value: i64, limit: i64, name: UsageName) -> Self {
        Self {
            id: None,
            unit,
            current_value,
            limit,
            name,
        }
    }
}
pub mod usage {
    use super::*;
    #[doc = "An enum describing the unit of measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[doc = "The usage names."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[doc = "A string describing the resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "A localized string describing the resource name."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The list usages operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsagesListResult {
    #[doc = "The list network resource usages."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UsagesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network security user rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserRule {
    #[serde(flatten)]
    pub base_user_rule: BaseUserRule,
    #[doc = "Security rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserRulePropertiesFormat>,
}
impl UserRule {
    pub fn new(base_user_rule: BaseUserRule) -> Self {
        Self {
            base_user_rule,
            properties: None,
        }
    }
}
#[doc = "security user rule list result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserRuleListResult {
    #[doc = "A list of user rules"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BaseUserRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UserRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserRulePropertiesFormat {
    #[doc = "A friendly name for the rule."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description for this rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Network protocol this rule applies to."]
    pub protocol: RuleProtocol,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
    pub direction: SecurityConfigurationRuleDirection,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl UserRulePropertiesFormat {
    pub fn new(protocol: RuleProtocol, direction: SecurityConfigurationRuleDirection) -> Self {
        Self {
            display_name: None,
            description: None,
            protocol,
            sources: Vec::new(),
            destinations: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            direction,
            provisioning_state: None,
        }
    }
}
#[doc = "Describes a Virtual Machine."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Vm {
    #[serde(flatten)]
    pub resource: Resource,
}
impl Vm {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the IP flow to be verified."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerificationIpFlowParameters {
    #[doc = "The ID of the target resource to perform next-hop on."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "The direction of the traffic."]
    pub direction: Direction,
    #[doc = "Protocol to be verified on."]
    pub protocol: verification_ip_flow_parameters::Protocol,
    #[doc = "The local port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction."]
    #[serde(rename = "localPort")]
    pub local_port: String,
    #[doc = "The remote port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction."]
    #[serde(rename = "remotePort")]
    pub remote_port: String,
    #[doc = "The local IP address. Acceptable values are valid IPv4 addresses."]
    #[serde(rename = "localIPAddress")]
    pub local_ip_address: String,
    #[doc = "The remote IP address. Acceptable values are valid IPv4 addresses."]
    #[serde(rename = "remoteIPAddress")]
    pub remote_ip_address: String,
    #[doc = "The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of them, then this parameter must be specified. Otherwise optional)."]
    #[serde(rename = "targetNicResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_resource_id: Option<String>,
}
impl VerificationIpFlowParameters {
    pub fn new(
        target_resource_id: String,
        direction: Direction,
        protocol: verification_ip_flow_parameters::Protocol,
        local_port: String,
        remote_port: String,
        local_ip_address: String,
        remote_ip_address: String,
    ) -> Self {
        Self {
            target_resource_id,
            direction,
            protocol,
            local_port,
            remote_port,
            local_ip_address,
            remote_ip_address,
            target_nic_resource_id: None,
        }
    }
}
pub mod verification_ip_flow_parameters {
    use super::*;
    #[doc = "Protocol to be verified on."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
    }
}
#[doc = "Results of IP flow verification on the target resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VerificationIpFlowResult {
    #[doc = "Access to be allowed or denied."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<Access>,
    #[doc = "Name of the rule. If input is not matched against any security rule, it is not displayed."]
    #[serde(rename = "ruleName", default, skip_serializing_if = "Option::is_none")]
    pub rule_name: Option<String>,
}
impl VerificationIpFlowResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Virtual Appliance NIC properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplianceNicProperties {
    #[doc = "NIC name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Public IP address."]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[doc = "Private IP address."]
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
}
impl VirtualApplianceNicProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Appliance Site resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplianceSite {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the rule group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualApplianceSiteProperties>,
    #[doc = "Name of the virtual appliance site."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Site type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VirtualApplianceSite {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the rule group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplianceSiteProperties {
    #[doc = "Address Prefix."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "Network Virtual Appliance Sku Properties."]
    #[serde(rename = "o365Policy", default, skip_serializing_if = "Option::is_none")]
    pub o365_policy: Option<Office365PolicyProperties>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualApplianceSiteProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Virtual Appliance Sku Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplianceSkuProperties {
    #[doc = "Virtual Appliance Vendor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
    #[doc = "Virtual Appliance Scale Unit."]
    #[serde(rename = "bundledScaleUnit", default, skip_serializing_if = "Option::is_none")]
    pub bundled_scale_unit: Option<String>,
    #[doc = "Virtual Appliance Version."]
    #[serde(rename = "marketPlaceVersion", default, skip_serializing_if = "Option::is_none")]
    pub market_place_version: Option<String>,
}
impl VirtualApplianceSkuProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualHub Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualHub {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Parameters for VirtualHub."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualHubProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Kind of service virtual hub. This is metadata used for the Azure portal experience for Route Server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<String>,
}
impl VirtualHub {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
            kind: None,
        }
    }
}
#[doc = "The effective route configured on the virtual hub or specified resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubEffectiveRoute {
    #[doc = "The list of address prefixes."]
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[doc = "The list of next hops."]
    #[serde(rename = "nextHops", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hops: Vec<String>,
    #[doc = "The type of the next hop."]
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<String>,
    #[doc = "The ASPath of this route."]
    #[serde(rename = "asPath", default, skip_serializing_if = "Option::is_none")]
    pub as_path: Option<String>,
    #[doc = "The origin of this route."]
    #[serde(rename = "routeOrigin", default, skip_serializing_if = "Option::is_none")]
    pub route_origin: Option<String>,
}
impl VirtualHubEffectiveRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "EffectiveRoutes List."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubEffectiveRouteList {
    #[doc = "The list of effective routes configured on the virtual hub or the specified resource."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualHubEffectiveRoute>,
}
impl VirtualHubEffectiveRouteList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Hub identifier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubId {
    #[doc = "The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl VirtualHubId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for VirtualHub."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubProperties {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualWan", default, skip_serializing_if = "Option::is_none")]
    pub virtual_wan: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "vpnGateway", default, skip_serializing_if = "Option::is_none")]
    pub vpn_gateway: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "p2SVpnGateway", default, skip_serializing_if = "Option::is_none")]
    pub p2_s_vpn_gateway: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "expressRouteGateway", default, skip_serializing_if = "Option::is_none")]
    pub express_route_gateway: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "azureFirewall", default, skip_serializing_if = "Option::is_none")]
    pub azure_firewall: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "securityPartnerProvider", default, skip_serializing_if = "Option::is_none")]
    pub security_partner_provider: Option<SubResource>,
    #[doc = "Address-prefix for this VirtualHub."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "VirtualHub route table."]
    #[serde(rename = "routeTable", default, skip_serializing_if = "Option::is_none")]
    pub route_table: Option<VirtualHubRouteTable>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The Security Provider name."]
    #[serde(rename = "securityProviderName", default, skip_serializing_if = "Option::is_none")]
    pub security_provider_name: Option<String>,
    #[doc = "List of all virtual hub route table v2s associated with this VirtualHub."]
    #[serde(rename = "virtualHubRouteTableV2s", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_hub_route_table_v2s: Vec<VirtualHubRouteTableV2>,
    #[doc = "The sku of this VirtualHub."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[doc = "The current routing state of the VirtualHub."]
    #[serde(rename = "routingState", default, skip_serializing_if = "Option::is_none")]
    pub routing_state: Option<RoutingState>,
    #[doc = "List of references to Bgp Connections."]
    #[serde(rename = "bgpConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub bgp_connections: Vec<SubResource>,
    #[doc = "List of references to IpConfigurations."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<SubResource>,
    #[doc = "VirtualRouter ASN."]
    #[serde(rename = "virtualRouterAsn", default, skip_serializing_if = "Option::is_none")]
    pub virtual_router_asn: Option<i64>,
    #[doc = "VirtualRouter IPs."]
    #[serde(rename = "virtualRouterIps", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_router_ips: Vec<String>,
    #[doc = "Flag to control transit for VirtualRouter hub."]
    #[serde(rename = "allowBranchToBranchTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_branch_to_branch_traffic: Option<bool>,
    #[doc = "The preferred routing gateway types"]
    #[serde(rename = "preferredRoutingGateway", default, skip_serializing_if = "Option::is_none")]
    pub preferred_routing_gateway: Option<PreferredRoutingGateway>,
}
impl VirtualHubProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualHub route."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRoute {
    #[doc = "List of all addressPrefixes."]
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[doc = "NextHop ip address."]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
}
impl VirtualHubRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualHub route table."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRouteTable {
    #[doc = "List of all routes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<VirtualHubRoute>,
}
impl VirtualHubRouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualHubRouteTableV2 Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRouteTableV2 {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Parameters for VirtualHubRouteTableV2."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualHubRouteTableV2Properties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualHubRouteTableV2 {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for VirtualHubRouteTableV2."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRouteTableV2Properties {
    #[doc = "List of all routes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<VirtualHubRouteV2>,
    #[doc = "List of all connections attached to this route table v2."]
    #[serde(rename = "attachedConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub attached_connections: Vec<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualHubRouteTableV2Properties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualHubRouteTableV2 route."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRouteV2 {
    #[doc = "The type of destinations."]
    #[serde(rename = "destinationType", default, skip_serializing_if = "Option::is_none")]
    pub destination_type: Option<String>,
    #[doc = "List of all destinations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<String>,
    #[doc = "The type of next hops."]
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<String>,
    #[doc = "NextHops ip address."]
    #[serde(rename = "nextHops", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hops: Vec<String>,
}
impl VirtualHubRouteV2 {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Network resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetwork {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "ExtendedLocation complex type."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<ExtendedLocation>,
    #[doc = "Properties of the virtual network."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkBgpCommunities {
    #[doc = "The BGP community associated with the virtual network."]
    #[serde(rename = "virtualNetworkCommunity")]
    pub virtual_network_community: String,
    #[doc = "The BGP community associated with the region of the virtual network."]
    #[serde(rename = "regionalCommunity", default, skip_serializing_if = "Option::is_none")]
    pub regional_community: Option<String>,
}
impl VirtualNetworkBgpCommunities {
    pub fn new(virtual_network_community: String) -> Self {
        Self {
            virtual_network_community,
            regional_community: None,
        }
    }
}
#[doc = "A reference to VirtualNetworkGateway or LocalNetworkGateway resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkConnectionGatewayReference {
    #[doc = "The ID of VirtualNetworkGateway or LocalNetworkGateway resource."]
    pub id: String,
}
impl VirtualNetworkConnectionGatewayReference {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[doc = "Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkEncryption {
    #[doc = "Indicates if encryption is enabled on the virtual network."]
    pub enabled: bool,
    #[doc = "If the encrypted VNet allows VM that does not support encryption"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enforcement: Option<virtual_network_encryption::Enforcement>,
}
impl VirtualNetworkEncryption {
    pub fn new(enabled: bool) -> Self {
        Self {
            enabled,
            enforcement: None,
        }
    }
}
pub mod virtual_network_encryption {
    use super::*;
    #[doc = "If the encrypted VNet allows VM that does not support encryption"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Enforcement {
        DropUnencrypted,
        AllowUnencrypted,
    }
}
#[doc = "A common class for general resource information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "VirtualNetworkGateway properties."]
    pub properties: VirtualNetworkGatewayPropertiesFormat,
    #[doc = "ExtendedLocation complex type."]
    #[serde(rename = "extendedLocation", default, skip_serializing_if = "Option::is_none")]
    pub extended_location: Option<ExtendedLocation>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGateway {
    pub fn new(properties: VirtualNetworkGatewayPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            extended_location: None,
            etag: None,
        }
    }
}
#[doc = "A common class for general resource information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "VirtualNetworkGatewayConnection properties."]
    pub properties: VirtualNetworkGatewayConnectionPropertiesFormat,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayConnection {
    pub fn new(properties: VirtualNetworkGatewayConnectionPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[doc = "A common class for general resource information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionListEntity {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "VirtualNetworkGatewayConnection properties."]
    pub properties: VirtualNetworkGatewayConnectionListEntityPropertiesFormat,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayConnectionListEntity {
    pub fn new(properties: VirtualNetworkGatewayConnectionListEntityPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[doc = "VirtualNetworkGatewayConnection properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionListEntityPropertiesFormat {
    #[doc = "The authorizationKey."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "A reference to VirtualNetworkGateway or LocalNetworkGateway resource."]
    #[serde(rename = "virtualNetworkGateway1")]
    pub virtual_network_gateway1: VirtualNetworkConnectionGatewayReference,
    #[doc = "A reference to VirtualNetworkGateway or LocalNetworkGateway resource."]
    #[serde(rename = "virtualNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway2: Option<VirtualNetworkConnectionGatewayReference>,
    #[doc = "A reference to VirtualNetworkGateway or LocalNetworkGateway resource."]
    #[serde(rename = "localNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub local_network_gateway2: Option<VirtualNetworkConnectionGatewayReference>,
    #[doc = "Gateway connection type."]
    #[serde(rename = "connectionType")]
    pub connection_type: VirtualNetworkGatewayConnectionType,
    #[doc = "Gateway connection protocol."]
    #[serde(rename = "connectionProtocol", default, skip_serializing_if = "Option::is_none")]
    pub connection_protocol: Option<ConnectionProtocol>,
    #[doc = "The routing weight."]
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[doc = "Gateway connection type."]
    #[serde(rename = "connectionMode", default, skip_serializing_if = "Option::is_none")]
    pub connection_mode: Option<VirtualNetworkGatewayConnectionMode>,
    #[doc = "The IPSec shared key."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "Virtual Network Gateway connection status."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VirtualNetworkGatewayConnectionStatus>,
    #[doc = "Collection of all tunnels' connection health status."]
    #[serde(rename = "tunnelConnectionStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_connection_status: Vec<TunnelConnectionHealth>,
    #[doc = "The egress bytes transferred in this connection."]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "The ingress bytes transferred in this connection."]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub peer: Option<SubResource>,
    #[doc = "EnableBgp flag."]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "Enable policy-based traffic selectors."]
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[doc = "The IPSec Policies to be considered by this connection."]
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[doc = "The Traffic Selector Policies to be considered by this connection."]
    #[serde(rename = "trafficSelectorPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub traffic_selector_policies: Vec<TrafficSelectorPolicy>,
    #[doc = "The resource GUID property of the virtual network gateway connection resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Bypass ExpressRoute Gateway for data forwarding."]
    #[serde(rename = "expressRouteGatewayBypass", default, skip_serializing_if = "Option::is_none")]
    pub express_route_gateway_bypass: Option<bool>,
}
impl VirtualNetworkGatewayConnectionListEntityPropertiesFormat {
    pub fn new(
        virtual_network_gateway1: VirtualNetworkConnectionGatewayReference,
        connection_type: VirtualNetworkGatewayConnectionType,
    ) -> Self {
        Self {
            authorization_key: None,
            virtual_network_gateway1,
            virtual_network_gateway2: None,
            local_network_gateway2: None,
            connection_type,
            connection_protocol: None,
            routing_weight: None,
            connection_mode: None,
            shared_key: None,
            connection_status: None,
            tunnel_connection_status: Vec::new(),
            egress_bytes_transferred: None,
            ingress_bytes_transferred: None,
            peer: None,
            enable_bgp: None,
            use_policy_based_traffic_selectors: None,
            ipsec_policies: Vec::new(),
            traffic_selector_policies: Vec::new(),
            resource_guid: None,
            provisioning_state: None,
            express_route_gateway_bypass: None,
        }
    }
}
#[doc = "Response for the ListVirtualNetworkGatewayConnections API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayConnectionListResult {
    #[doc = "A list of VirtualNetworkGatewayConnection resources that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayConnection>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Gateway connection type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum VirtualNetworkGatewayConnectionMode {
    Default,
    ResponderOnly,
    InitiatorOnly,
}
#[doc = "VirtualNetworkGatewayConnection properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionPropertiesFormat {
    #[doc = "The authorizationKey."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "A common class for general resource information."]
    #[serde(rename = "virtualNetworkGateway1")]
    pub virtual_network_gateway1: VirtualNetworkGateway,
    #[doc = "A common class for general resource information."]
    #[serde(rename = "virtualNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway2: Option<VirtualNetworkGateway>,
    #[doc = "A common class for general resource information."]
    #[serde(rename = "localNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub local_network_gateway2: Option<LocalNetworkGateway>,
    #[doc = "List of ingress NatRules."]
    #[serde(rename = "ingressNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub ingress_nat_rules: Vec<SubResource>,
    #[doc = "List of egress NatRules."]
    #[serde(rename = "egressNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub egress_nat_rules: Vec<SubResource>,
    #[doc = "Gateway connection type."]
    #[serde(rename = "connectionType")]
    pub connection_type: VirtualNetworkGatewayConnectionType,
    #[doc = "Gateway connection protocol."]
    #[serde(rename = "connectionProtocol", default, skip_serializing_if = "Option::is_none")]
    pub connection_protocol: Option<ConnectionProtocol>,
    #[doc = "The routing weight."]
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[doc = "The dead peer detection timeout of this connection in seconds."]
    #[serde(rename = "dpdTimeoutSeconds", default, skip_serializing_if = "Option::is_none")]
    pub dpd_timeout_seconds: Option<i32>,
    #[doc = "Gateway connection type."]
    #[serde(rename = "connectionMode", default, skip_serializing_if = "Option::is_none")]
    pub connection_mode: Option<VirtualNetworkGatewayConnectionMode>,
    #[doc = "The IPSec shared key."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "Virtual Network Gateway connection status."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VirtualNetworkGatewayConnectionStatus>,
    #[doc = "Collection of all tunnels' connection health status."]
    #[serde(rename = "tunnelConnectionStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_connection_status: Vec<TunnelConnectionHealth>,
    #[doc = "The egress bytes transferred in this connection."]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "The ingress bytes transferred in this connection."]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub peer: Option<SubResource>,
    #[doc = "EnableBgp flag."]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "Use private local Azure IP for the connection."]
    #[serde(rename = "useLocalAzureIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub use_local_azure_ip_address: Option<bool>,
    #[doc = "Enable policy-based traffic selectors."]
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[doc = "The IPSec Policies to be considered by this connection."]
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[doc = "The Traffic Selector Policies to be considered by this connection."]
    #[serde(rename = "trafficSelectorPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub traffic_selector_policies: Vec<TrafficSelectorPolicy>,
    #[doc = "The resource GUID property of the virtual network gateway connection resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Bypass ExpressRoute Gateway for data forwarding."]
    #[serde(rename = "expressRouteGatewayBypass", default, skip_serializing_if = "Option::is_none")]
    pub express_route_gateway_bypass: Option<bool>,
}
impl VirtualNetworkGatewayConnectionPropertiesFormat {
    pub fn new(virtual_network_gateway1: VirtualNetworkGateway, connection_type: VirtualNetworkGatewayConnectionType) -> Self {
        Self {
            authorization_key: None,
            virtual_network_gateway1,
            virtual_network_gateway2: None,
            local_network_gateway2: None,
            ingress_nat_rules: Vec::new(),
            egress_nat_rules: Vec::new(),
            connection_type,
            connection_protocol: None,
            routing_weight: None,
            dpd_timeout_seconds: None,
            connection_mode: None,
            shared_key: None,
            connection_status: None,
            tunnel_connection_status: Vec::new(),
            egress_bytes_transferred: None,
            ingress_bytes_transferred: None,
            peer: None,
            enable_bgp: None,
            use_local_azure_ip_address: None,
            use_policy_based_traffic_selectors: None,
            ipsec_policies: Vec::new(),
            traffic_selector_policies: Vec::new(),
            resource_guid: None,
            provisioning_state: None,
            express_route_gateway_bypass: None,
        }
    }
}
#[doc = "Virtual Network Gateway connection status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum VirtualNetworkGatewayConnectionStatus {
    Unknown,
    Connecting,
    Connected,
    NotConnected,
}
#[doc = "Gateway connection type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum VirtualNetworkGatewayConnectionType {
    IPsec,
    Vnet2Vnet,
    ExpressRoute,
    #[serde(rename = "VPNClient")]
    VpnClient,
}
#[doc = "IP configuration for virtual network gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of VirtualNetworkGatewayIPConfiguration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkGatewayIpConfigurationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of VirtualNetworkGatewayIPConfiguration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    #[doc = "IP address allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[doc = "Private IP Address for this gateway."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the VirtualNetworkGatewayListConnections API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayListConnectionsResult {
    #[doc = "A list of VirtualNetworkGatewayConnection resources that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayConnectionListEntity>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayListConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListVirtualNetworkGateways API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayListResult {
    #[doc = "A list of VirtualNetworkGateway resources that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGateway>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualNetworkGatewayNatRule Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayNatRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Parameters for VirtualNetworkGatewayNatRule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkGatewayNatRuleProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VirtualNetworkGatewayNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for VirtualNetworkGatewayNatRule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayNatRuleProperties {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The type of NAT rule for VPN NAT."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<virtual_network_gateway_nat_rule_properties::Type>,
    #[doc = "The Source NAT direction of a VPN NAT."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<virtual_network_gateway_nat_rule_properties::Mode>,
    #[doc = "The private IP address internal mapping for NAT."]
    #[serde(rename = "internalMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub internal_mappings: Vec<VpnNatRuleMapping>,
    #[doc = "The private IP address external mapping for NAT."]
    #[serde(rename = "externalMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub external_mappings: Vec<VpnNatRuleMapping>,
    #[doc = "The IP Configuration ID this NAT rule applies to."]
    #[serde(rename = "ipConfigurationId", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration_id: Option<String>,
}
impl VirtualNetworkGatewayNatRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_nat_rule_properties {
    use super::*;
    #[doc = "The type of NAT rule for VPN NAT."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Static,
        Dynamic,
    }
    #[doc = "The Source NAT direction of a VPN NAT."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        EgressSnat,
        IngressSnat,
    }
}
#[doc = "VirtualNetworkGateway properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayPropertiesFormat {
    #[doc = "IP configurations for virtual network gateway."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<VirtualNetworkGatewayIpConfiguration>,
    #[doc = "The type of this virtual network gateway."]
    #[serde(rename = "gatewayType", default, skip_serializing_if = "Option::is_none")]
    pub gateway_type: Option<virtual_network_gateway_properties_format::GatewayType>,
    #[doc = "The type of this virtual network gateway."]
    #[serde(rename = "vpnType", default, skip_serializing_if = "Option::is_none")]
    pub vpn_type: Option<virtual_network_gateway_properties_format::VpnType>,
    #[doc = "The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN."]
    #[serde(rename = "vpnGatewayGeneration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_gateway_generation: Option<virtual_network_gateway_properties_format::VpnGatewayGeneration>,
    #[doc = "Whether BGP is enabled for this virtual network gateway or not."]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "Whether private IP needs to be enabled on this gateway for connections or not."]
    #[serde(rename = "enablePrivateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub enable_private_ip_address: Option<bool>,
    #[doc = "ActiveActive flag."]
    #[serde(rename = "activeActive", default, skip_serializing_if = "Option::is_none")]
    pub active_active: Option<bool>,
    #[doc = "disableIPSecReplayProtection flag."]
    #[serde(rename = "disableIPSecReplayProtection", default, skip_serializing_if = "Option::is_none")]
    pub disable_ip_sec_replay_protection: Option<bool>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "gatewayDefaultSite", default, skip_serializing_if = "Option::is_none")]
    pub gateway_default_site: Option<SubResource>,
    #[doc = "VirtualNetworkGatewaySku details."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<VirtualNetworkGatewaySku>,
    #[doc = "VpnClientConfiguration for P2S client."]
    #[serde(rename = "vpnClientConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_configuration: Option<VpnClientConfiguration>,
    #[doc = "BGP settings details."]
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "customRoutes", default, skip_serializing_if = "Option::is_none")]
    pub custom_routes: Option<AddressSpace>,
    #[doc = "The resource GUID property of the virtual network gateway resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Whether dns forwarding is enabled or not."]
    #[serde(rename = "enableDnsForwarding", default, skip_serializing_if = "Option::is_none")]
    pub enable_dns_forwarding: Option<bool>,
    #[doc = "The IP address allocated by the gateway to which dns requests can be sent."]
    #[serde(rename = "inboundDnsForwardingEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub inbound_dns_forwarding_endpoint: Option<String>,
    #[doc = "Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet."]
    #[serde(rename = "vNetExtendedLocationResourceId", default, skip_serializing_if = "Option::is_none")]
    pub v_net_extended_location_resource_id: Option<String>,
    #[doc = "NatRules for virtual network gateway."]
    #[serde(rename = "natRules", default, skip_serializing_if = "Vec::is_empty")]
    pub nat_rules: Vec<VirtualNetworkGatewayNatRule>,
    #[doc = "EnableBgpRouteTranslationForNat flag."]
    #[serde(rename = "enableBgpRouteTranslationForNat", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp_route_translation_for_nat: Option<bool>,
}
impl VirtualNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_properties_format {
    use super::*;
    #[doc = "The type of this virtual network gateway."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GatewayType {
        Vpn,
        ExpressRoute,
        LocalGateway,
    }
    #[doc = "The type of this virtual network gateway."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VpnType {
        PolicyBased,
        RouteBased,
    }
    #[doc = "The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VpnGatewayGeneration {
        None,
        Generation1,
        Generation2,
    }
}
#[doc = "VirtualNetworkGatewaySku details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewaySku {
    #[doc = "Gateway SKU name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<virtual_network_gateway_sku::Name>,
    #[doc = "Gateway SKU tier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<virtual_network_gateway_sku::Tier>,
    #[doc = "The capacity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl VirtualNetworkGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_sku {
    use super::*;
    #[doc = "Gateway SKU name."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
        VpnGw4,
        VpnGw5,
        #[serde(rename = "VpnGw1AZ")]
        VpnGw1Az,
        #[serde(rename = "VpnGw2AZ")]
        VpnGw2Az,
        #[serde(rename = "VpnGw3AZ")]
        VpnGw3Az,
        #[serde(rename = "VpnGw4AZ")]
        VpnGw4Az,
        #[serde(rename = "VpnGw5AZ")]
        VpnGw5Az,
        #[serde(rename = "ErGw1AZ")]
        ErGw1Az,
        #[serde(rename = "ErGw2AZ")]
        ErGw2Az,
        #[serde(rename = "ErGw3AZ")]
        ErGw3Az,
    }
    #[doc = "Gateway SKU tier."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
        VpnGw4,
        VpnGw5,
        #[serde(rename = "VpnGw1AZ")]
        VpnGw1Az,
        #[serde(rename = "VpnGw2AZ")]
        VpnGw2Az,
        #[serde(rename = "VpnGw3AZ")]
        VpnGw3Az,
        #[serde(rename = "VpnGw4AZ")]
        VpnGw4Az,
        #[serde(rename = "VpnGw5AZ")]
        VpnGw5Az,
        #[serde(rename = "ErGw1AZ")]
        ErGw1Az,
        #[serde(rename = "ErGw2AZ")]
        ErGw2Az,
        #[serde(rename = "ErGw3AZ")]
        ErGw3Az,
    }
}
#[doc = "Response for the ListVirtualNetworks API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkListResult {
    #[doc = "A list of VirtualNetwork resources in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetwork>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the virtual networks GetUsage API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkListUsageResult {
    #[doc = "VirtualNetwork usage stats."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkUsage>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkListUsageResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peerings in a virtual network resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the virtual network peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPeeringPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VirtualNetworkPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringListResult {
    #[doc = "The peerings in a virtual network."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkPeering>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the virtual network peering."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringPropertiesFormat {
    #[doc = "Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space."]
    #[serde(rename = "allowVirtualNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub allow_virtual_network_access: Option<bool>,
    #[doc = "Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network."]
    #[serde(rename = "allowForwardedTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_forwarded_traffic: Option<bool>,
    #[doc = "If gateway links can be used in remote virtual networking to link to this virtual network."]
    #[serde(rename = "allowGatewayTransit", default, skip_serializing_if = "Option::is_none")]
    pub allow_gateway_transit: Option<bool>,
    #[doc = "If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway."]
    #[serde(rename = "useRemoteGateways", default, skip_serializing_if = "Option::is_none")]
    pub use_remote_gateways: Option<bool>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "remoteVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub remote_virtual_network: Option<SubResource>,
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "remoteAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub remote_address_space: Option<AddressSpace>,
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "remoteVirtualNetworkAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub remote_virtual_network_address_space: Option<AddressSpace>,
    #[doc = "Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET."]
    #[serde(rename = "remoteBgpCommunities", default, skip_serializing_if = "Option::is_none")]
    pub remote_bgp_communities: Option<VirtualNetworkBgpCommunities>,
    #[doc = "Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet."]
    #[serde(rename = "remoteVirtualNetworkEncryption", default, skip_serializing_if = "Option::is_none")]
    pub remote_virtual_network_encryption: Option<VirtualNetworkEncryption>,
    #[doc = "The status of the virtual network peering."]
    #[serde(rename = "peeringState", default, skip_serializing_if = "Option::is_none")]
    pub peering_state: Option<virtual_network_peering_properties_format::PeeringState>,
    #[doc = "The peering sync status of the virtual network peering."]
    #[serde(rename = "peeringSyncLevel", default, skip_serializing_if = "Option::is_none")]
    pub peering_sync_level: Option<virtual_network_peering_properties_format::PeeringSyncLevel>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "If we need to verify the provisioning state of the remote gateway."]
    #[serde(rename = "doNotVerifyRemoteGateways", default, skip_serializing_if = "Option::is_none")]
    pub do_not_verify_remote_gateways: Option<bool>,
    #[doc = "The resourceGuid property of the Virtual Network peering resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
}
impl VirtualNetworkPeeringPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_peering_properties_format {
    use super::*;
    #[doc = "The status of the virtual network peering."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PeeringState {
        Initiated,
        Connected,
        Disconnected,
    }
    #[doc = "The peering sync status of the virtual network peering."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PeeringSyncLevel {
        FullyInSync,
        RemoteNotInSync,
        LocalNotInSync,
        LocalAndRemoteNotInSync,
    }
}
#[doc = "Properties of the virtual network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPropertiesFormat {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "addressSpace", default, skip_serializing_if = "Option::is_none")]
    pub address_space: Option<AddressSpace>,
    #[doc = "DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options."]
    #[serde(rename = "dhcpOptions", default, skip_serializing_if = "Option::is_none")]
    pub dhcp_options: Option<DhcpOptions>,
    #[doc = "The FlowTimeout value (in minutes) for the Virtual Network"]
    #[serde(rename = "flowTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub flow_timeout_in_minutes: Option<i32>,
    #[doc = "A list of subnets in a Virtual Network."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "A list of peerings in a Virtual Network."]
    #[serde(rename = "virtualNetworkPeerings", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_peerings: Vec<VirtualNetworkPeering>,
    #[doc = "The resourceGuid property of the Virtual Network resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection plan associated with the resource."]
    #[serde(rename = "enableDdosProtection", default, skip_serializing_if = "Option::is_none")]
    pub enable_ddos_protection: Option<bool>,
    #[doc = "Indicates if VM protection is enabled for all the subnets in the virtual network."]
    #[serde(rename = "enableVmProtection", default, skip_serializing_if = "Option::is_none")]
    pub enable_vm_protection: Option<bool>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "ddosProtectionPlan", default, skip_serializing_if = "Option::is_none")]
    pub ddos_protection_plan: Option<SubResource>,
    #[doc = "Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET."]
    #[serde(rename = "bgpCommunities", default, skip_serializing_if = "Option::is_none")]
    pub bgp_communities: Option<VirtualNetworkBgpCommunities>,
    #[doc = "Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<VirtualNetworkEncryption>,
    #[doc = "Array of IpAllocation which reference this VNET."]
    #[serde(rename = "ipAllocations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_allocations: Vec<SubResource>,
}
impl VirtualNetworkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Network Tap resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkTap {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Virtual Network Tap properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkTapPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkTap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListVirtualNetworkTap API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkTapListResult {
    #[doc = "A list of VirtualNetworkTaps in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkTap>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkTapListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Network Tap properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkTapPropertiesFormat {
    #[doc = "Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped."]
    #[serde(rename = "networkInterfaceTapConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interface_tap_configurations: Vec<NetworkInterfaceTapConfiguration>,
    #[doc = "The resource GUID property of the virtual network tap resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "IPConfiguration in a network interface."]
    #[serde(
        rename = "destinationNetworkInterfaceIPConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub destination_network_interface_ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[doc = "Frontend IP address of the load balancer."]
    #[serde(
        rename = "destinationLoadBalancerFrontEndIPConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub destination_load_balancer_front_end_ip_configuration: Option<FrontendIpConfiguration>,
    #[doc = "The VXLAN destination port that will receive the tapped traffic."]
    #[serde(rename = "destinationPort", default, skip_serializing_if = "Option::is_none")]
    pub destination_port: Option<i64>,
}
impl VirtualNetworkTapPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Usage details for subnet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkUsage {
    #[doc = "Indicates number of IPs used from the Subnet."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<f64>,
    #[doc = "Subnet identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Indicates the size of the subnet."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<f64>,
    #[doc = "Usage strings container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<VirtualNetworkUsageName>,
    #[doc = "Usage units. Returns 'Count'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
}
impl VirtualNetworkUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Usage strings container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkUsageName {
    #[doc = "Localized subnet size and usage string."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
    #[doc = "Subnet size and usage string."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl VirtualNetworkUsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualRouter Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouter {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Virtual Router definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualRouterPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualRouter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListVirtualRouters API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterListResult {
    #[doc = "List of Virtual Routers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualRouter>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualRouterListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Router Peering resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the rule group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualRouterPeeringProperties>,
    #[doc = "Name of the virtual router peering that is unique within a virtual router."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Peering type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VirtualRouterPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListVirtualRouterPeerings API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterPeeringListResult {
    #[doc = "List of VirtualRouterPeerings in a VirtualRouter."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualRouterPeering>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualRouterPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the rule group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterPeeringProperties {
    #[doc = "Peer ASN."]
    #[serde(rename = "peerAsn", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[doc = "Peer IP."]
    #[serde(rename = "peerIp", default, skip_serializing_if = "Option::is_none")]
    pub peer_ip: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualRouterPeeringProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Router definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterPropertiesFormat {
    #[doc = "VirtualRouter ASN."]
    #[serde(rename = "virtualRouterAsn", default, skip_serializing_if = "Option::is_none")]
    pub virtual_router_asn: Option<i64>,
    #[doc = "VirtualRouter IPs."]
    #[serde(rename = "virtualRouterIps", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_router_ips: Vec<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "hostedSubnet", default, skip_serializing_if = "Option::is_none")]
    pub hosted_subnet: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "hostedGateway", default, skip_serializing_if = "Option::is_none")]
    pub hosted_gateway: Option<SubResource>,
    #[doc = "List of references to VirtualRouterPeerings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<SubResource>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualRouterPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualWAN Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualWan {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Parameters for VirtualWAN."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualWanProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualWan {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[doc = "Parameters for VirtualWAN."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualWanProperties {
    #[doc = "Vpn encryption to be disabled or not."]
    #[serde(rename = "disableVpnEncryption", default, skip_serializing_if = "Option::is_none")]
    pub disable_vpn_encryption: Option<bool>,
    #[doc = "List of VirtualHubs in the VirtualWAN."]
    #[serde(rename = "virtualHubs", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_hubs: Vec<SubResource>,
    #[doc = "List of VpnSites in the VirtualWAN."]
    #[serde(rename = "vpnSites", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_sites: Vec<SubResource>,
    #[doc = "True if branch to branch traffic is allowed."]
    #[serde(rename = "allowBranchToBranchTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_branch_to_branch_traffic: Option<bool>,
    #[doc = "True if Vnet to Vnet traffic is allowed."]
    #[serde(rename = "allowVnetToVnetTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_vnet_to_vnet_traffic: Option<bool>,
    #[doc = "The office traffic category."]
    #[serde(rename = "office365LocalBreakoutCategory", default, skip_serializing_if = "Option::is_none")]
    pub office365_local_breakout_category: Option<OfficeTrafficCategory>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The type of the VirtualWAN."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VirtualWanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Collection of SecurityProviders."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualWanSecurityProvider {
    #[doc = "Name of the security provider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Url of the security provider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[doc = "The virtual wan security provider type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<VirtualWanSecurityProviderType>,
}
impl VirtualWanSecurityProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The virtual wan security provider type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum VirtualWanSecurityProviderType {
    External,
    Native,
}
#[doc = "Collection of SecurityProviders."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualWanSecurityProviders {
    #[doc = "List of VirtualWAN security providers."]
    #[serde(rename = "supportedProviders", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_providers: Vec<VirtualWanSecurityProvider>,
}
impl VirtualWanSecurityProviders {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Wan Vpn profile parameters Vpn profile generation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualWanVpnProfileParameters {
    #[doc = "VpnServerConfiguration partial resource uri with which VirtualWan is associated to."]
    #[serde(rename = "vpnServerConfigurationResourceId", default, skip_serializing_if = "Option::is_none")]
    pub vpn_server_configuration_resource_id: Option<String>,
    #[doc = "VPN client authentication method."]
    #[serde(rename = "authenticationMethod", default, skip_serializing_if = "Option::is_none")]
    pub authentication_method: Option<AuthenticationMethod>,
}
impl VirtualWanVpnProfileParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of routes that control routing from VirtualHub into a virtual network connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetRoute {
    #[doc = "List of all Static Routes."]
    #[serde(rename = "staticRoutes", default, skip_serializing_if = "Vec::is_empty")]
    pub static_routes: Vec<StaticRoute>,
    #[doc = "The list of references to HubBgpConnection objects."]
    #[serde(rename = "bgpConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub bgp_connections: Vec<SubResource>,
}
impl VnetRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnClientConfiguration for P2S client."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConfiguration {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "vpnClientAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_address_pool: Option<AddressSpace>,
    #[doc = "VpnClientRootCertificate for virtual network gateway."]
    #[serde(rename = "vpnClientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_root_certificates: Vec<VpnClientRootCertificate>,
    #[doc = "VpnClientRevokedCertificate for Virtual network gateway."]
    #[serde(rename = "vpnClientRevokedCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_revoked_certificates: Vec<VpnClientRevokedCertificate>,
    #[doc = "VpnClientProtocols for Virtual network gateway."]
    #[serde(rename = "vpnClientProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_protocols: Vec<String>,
    #[doc = "VPN authentication types for the virtual network gateway.."]
    #[serde(rename = "vpnAuthenticationTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_authentication_types: Vec<String>,
    #[doc = "VpnClientIpsecPolicies for virtual network gateway P2S client."]
    #[serde(rename = "vpnClientIpsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_ipsec_policies: Vec<IpsecPolicy>,
    #[doc = "The radius server address property of the VirtualNetworkGateway resource for vpn client connection."]
    #[serde(rename = "radiusServerAddress", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_address: Option<String>,
    #[doc = "The radius secret property of the VirtualNetworkGateway resource for vpn client connection."]
    #[serde(rename = "radiusServerSecret", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_secret: Option<String>,
    #[doc = "The radiusServers property for multiple radius server configuration."]
    #[serde(rename = "radiusServers", default, skip_serializing_if = "Vec::is_empty")]
    pub radius_servers: Vec<RadiusServer>,
    #[doc = "The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication."]
    #[serde(rename = "aadTenant", default, skip_serializing_if = "Option::is_none")]
    pub aad_tenant: Option<String>,
    #[doc = "The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication."]
    #[serde(rename = "aadAudience", default, skip_serializing_if = "Option::is_none")]
    pub aad_audience: Option<String>,
    #[doc = "The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication."]
    #[serde(rename = "aadIssuer", default, skip_serializing_if = "Option::is_none")]
    pub aad_issuer: Option<String>,
}
impl VpnClientConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnClientConnectionHealth properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConnectionHealth {
    #[doc = "Total of the Ingress Bytes Transferred in this P2S Vpn connection."]
    #[serde(rename = "totalIngressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub total_ingress_bytes_transferred: Option<i64>,
    #[doc = "Total of the Egress Bytes Transferred in this connection."]
    #[serde(rename = "totalEgressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub total_egress_bytes_transferred: Option<i64>,
    #[doc = "The total of p2s vpn clients connected at this time to this P2SVpnGateway."]
    #[serde(rename = "vpnClientConnectionsCount", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_connections_count: Option<i32>,
    #[doc = "List of allocated ip addresses to the connected p2s vpn clients."]
    #[serde(rename = "allocatedIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub allocated_ip_addresses: Vec<String>,
}
impl VpnClientConnectionHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VPN client connection health detail."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConnectionHealthDetail {
    #[doc = "The vpn client Id."]
    #[serde(rename = "vpnConnectionId", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_id: Option<String>,
    #[doc = "The duration time of a connected vpn client."]
    #[serde(rename = "vpnConnectionDuration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_duration: Option<i64>,
    #[doc = "The start time of a connected vpn client."]
    #[serde(rename = "vpnConnectionTime", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_time: Option<String>,
    #[doc = "The public Ip of a connected vpn client."]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[doc = "The assigned private Ip of a connected vpn client."]
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "The user name of a connected vpn client."]
    #[serde(rename = "vpnUserName", default, skip_serializing_if = "Option::is_none")]
    pub vpn_user_name: Option<String>,
    #[doc = "The max band width."]
    #[serde(rename = "maxBandwidth", default, skip_serializing_if = "Option::is_none")]
    pub max_bandwidth: Option<i64>,
    #[doc = "The egress packets per second."]
    #[serde(rename = "egressPacketsTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_packets_transferred: Option<i64>,
    #[doc = "The egress bytes per second."]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "The ingress packets per second."]
    #[serde(rename = "ingressPacketsTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_packets_transferred: Option<i64>,
    #[doc = "The ingress bytes per second."]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[doc = "The max packets transferred per second."]
    #[serde(rename = "maxPacketsPerSecond", default, skip_serializing_if = "Option::is_none")]
    pub max_packets_per_second: Option<i64>,
}
impl VpnClientConnectionHealthDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of virtual network gateway vpn client connection health."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConnectionHealthDetailListResult {
    #[doc = "List of vpn client connection health."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnClientConnectionHealthDetail>,
}
impl VpnClientConnectionHealthDetailListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An IPSec parameters for a virtual network gateway P2S connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientIPsecParameters {
    #[doc = "The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client."]
    #[serde(rename = "saLifeTimeSeconds")]
    pub sa_life_time_seconds: i32,
    #[doc = "The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client.."]
    #[serde(rename = "saDataSizeKilobytes")]
    pub sa_data_size_kilobytes: i32,
    #[doc = "The IPSec encryption algorithm (IKE phase 1)."]
    #[serde(rename = "ipsecEncryption")]
    pub ipsec_encryption: IpsecEncryption,
    #[doc = "The IPSec integrity algorithm (IKE phase 1)."]
    #[serde(rename = "ipsecIntegrity")]
    pub ipsec_integrity: IpsecIntegrity,
    #[doc = "The IKE encryption algorithm (IKE phase 2)."]
    #[serde(rename = "ikeEncryption")]
    pub ike_encryption: IkeEncryption,
    #[doc = "The IKE integrity algorithm (IKE phase 2)."]
    #[serde(rename = "ikeIntegrity")]
    pub ike_integrity: IkeIntegrity,
    #[doc = "The DH Groups used in IKE Phase 1 for initial SA."]
    #[serde(rename = "dhGroup")]
    pub dh_group: DhGroup,
    #[doc = "The Pfs Groups used in IKE Phase 2 for new child SA."]
    #[serde(rename = "pfsGroup")]
    pub pfs_group: PfsGroup,
}
impl VpnClientIPsecParameters {
    pub fn new(
        sa_life_time_seconds: i32,
        sa_data_size_kilobytes: i32,
        ipsec_encryption: IpsecEncryption,
        ipsec_integrity: IpsecIntegrity,
        ike_encryption: IkeEncryption,
        ike_integrity: IkeIntegrity,
        dh_group: DhGroup,
        pfs_group: PfsGroup,
    ) -> Self {
        Self {
            sa_life_time_seconds,
            sa_data_size_kilobytes,
            ipsec_encryption,
            ipsec_integrity,
            ike_encryption,
            ike_integrity,
            dh_group,
            pfs_group,
        }
    }
}
#[doc = "Vpn Client Parameters for package generation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientParameters {
    #[doc = "VPN client Processor Architecture."]
    #[serde(rename = "processorArchitecture", default, skip_serializing_if = "Option::is_none")]
    pub processor_architecture: Option<vpn_client_parameters::ProcessorArchitecture>,
    #[doc = "VPN client authentication method."]
    #[serde(rename = "authenticationMethod", default, skip_serializing_if = "Option::is_none")]
    pub authentication_method: Option<AuthenticationMethod>,
    #[doc = "The public certificate data for the radius server authentication certificate as a Base-64 encoded string. Required only if external radius authentication has been configured with EAPTLS authentication."]
    #[serde(rename = "radiusServerAuthCertificate", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_auth_certificate: Option<String>,
    #[doc = "A list of client root certificates public certificate data encoded as Base-64 strings. Optional parameter for external radius based authentication with EAPTLS."]
    #[serde(rename = "clientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub client_root_certificates: Vec<String>,
}
impl VpnClientParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vpn_client_parameters {
    use super::*;
    #[doc = "VPN client Processor Architecture."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProcessorArchitecture {
        Amd64,
        X86,
    }
}
#[doc = "VPN client revoked certificate of virtual network gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the revoked VPN client certificate of virtual network gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnClientRevokedCertificatePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRevokedCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the revoked VPN client certificate of virtual network gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificatePropertiesFormat {
    #[doc = "The revoked VPN client certificate thumbprint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VpnClientRevokedCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VPN client root certificate of virtual network gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientRootCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of SSL certificates of application gateway."]
    pub properties: VpnClientRootCertificatePropertiesFormat,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRootCertificate {
    pub fn new(properties: VpnClientRootCertificatePropertiesFormat) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
            name: None,
            etag: None,
        }
    }
}
#[doc = "Properties of SSL certificates of application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientRootCertificatePropertiesFormat {
    #[doc = "The certificate public data."]
    #[serde(rename = "publicCertData")]
    pub public_cert_data: String,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VpnClientRootCertificatePropertiesFormat {
    pub fn new(public_cert_data: String) -> Self {
        Self {
            public_cert_data,
            provisioning_state: None,
        }
    }
}
#[doc = "VpnConnection Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Parameters for VpnConnection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnConnectionProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Vpn Connection packet capture parameters supplied to start packet capture on gateway connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnConnectionPacketCaptureStartParameters {
    #[doc = "Start Packet capture parameters on vpn connection."]
    #[serde(rename = "filterData", default, skip_serializing_if = "Option::is_none")]
    pub filter_data: Option<String>,
    #[doc = "List of site link connection names."]
    #[serde(rename = "linkConnectionNames", default, skip_serializing_if = "Vec::is_empty")]
    pub link_connection_names: Vec<String>,
}
impl VpnConnectionPacketCaptureStartParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Vpn Connection packet capture parameters supplied to stop packet capture on gateway connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnConnectionPacketCaptureStopParameters {
    #[doc = "SAS url for packet capture on vpn connection."]
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
    #[doc = "List of site link connection names."]
    #[serde(rename = "linkConnectionNames", default, skip_serializing_if = "Vec::is_empty")]
    pub link_connection_names: Vec<String>,
}
impl VpnConnectionPacketCaptureStopParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for VpnConnection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnConnectionProperties {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "remoteVpnSite", default, skip_serializing_if = "Option::is_none")]
    pub remote_vpn_site: Option<SubResource>,
    #[doc = "Routing weight for vpn connection."]
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[doc = "DPD timeout in seconds for vpn connection."]
    #[serde(rename = "dpdTimeoutSeconds", default, skip_serializing_if = "Option::is_none")]
    pub dpd_timeout_seconds: Option<i32>,
    #[doc = "The current state of the vpn connection."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VpnConnectionStatus>,
    #[doc = "Gateway connection protocol."]
    #[serde(rename = "vpnConnectionProtocolType", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_protocol_type: Option<ConnectionProtocol>,
    #[doc = "Ingress bytes transferred."]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[doc = "Egress bytes transferred."]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "Expected bandwidth in MBPS."]
    #[serde(rename = "connectionBandwidth", default, skip_serializing_if = "Option::is_none")]
    pub connection_bandwidth: Option<i32>,
    #[doc = "SharedKey for the vpn connection."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "EnableBgp flag."]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "Enable policy-based traffic selectors."]
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[doc = "The IPSec Policies to be considered by this connection."]
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[doc = "The Traffic Selector Policies to be considered by this connection."]
    #[serde(rename = "trafficSelectorPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub traffic_selector_policies: Vec<TrafficSelectorPolicy>,
    #[doc = "EnableBgp flag."]
    #[serde(rename = "enableRateLimiting", default, skip_serializing_if = "Option::is_none")]
    pub enable_rate_limiting: Option<bool>,
    #[doc = "Enable internet security."]
    #[serde(rename = "enableInternetSecurity", default, skip_serializing_if = "Option::is_none")]
    pub enable_internet_security: Option<bool>,
    #[doc = "Use local azure ip to initiate connection."]
    #[serde(rename = "useLocalAzureIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub use_local_azure_ip_address: Option<bool>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "List of all vpn site link connections to the gateway."]
    #[serde(rename = "vpnLinkConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_link_connections: Vec<VpnSiteLinkConnection>,
    #[doc = "Routing Configuration indicating the associated and propagated route tables for this connection."]
    #[serde(rename = "routingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub routing_configuration: Option<RoutingConfiguration>,
}
impl VpnConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The current state of the vpn connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum VpnConnectionStatus {
    Unknown,
    Connecting,
    Connected,
    NotConnected,
}
#[doc = "Vpn device configuration script generation parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnDeviceScriptParameters {
    #[doc = "The vendor for the vpn device."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
    #[doc = "The device family for the vpn device."]
    #[serde(rename = "deviceFamily", default, skip_serializing_if = "Option::is_none")]
    pub device_family: Option<String>,
    #[doc = "The firmware version for the vpn device."]
    #[serde(rename = "firmwareVersion", default, skip_serializing_if = "Option::is_none")]
    pub firmware_version: Option<String>,
}
impl VpnDeviceScriptParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnGateway Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Parameters for VpnGateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnGatewayProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnGateway {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[doc = "IP Configuration of a VPN Gateway Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayIpConfiguration {
    #[doc = "The identifier of the IP configuration for a VPN Gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The public IP address of this IP configuration."]
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[doc = "The private IP address of this IP configuration."]
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
}
impl VpnGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnGatewayNatRule Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayNatRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Parameters for VpnGatewayNatRule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnGatewayNatRuleProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VpnGatewayNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for VpnGatewayNatRule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayNatRuleProperties {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The type of NAT rule for VPN NAT."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<vpn_gateway_nat_rule_properties::Type>,
    #[doc = "The Source NAT direction of a VPN NAT."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<vpn_gateway_nat_rule_properties::Mode>,
    #[doc = "The private IP address internal mapping for NAT."]
    #[serde(rename = "internalMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub internal_mappings: Vec<VpnNatRuleMapping>,
    #[doc = "The private IP address external mapping for NAT."]
    #[serde(rename = "externalMappings", default, skip_serializing_if = "Vec::is_empty")]
    pub external_mappings: Vec<VpnNatRuleMapping>,
    #[doc = "The IP Configuration ID this NAT rule applies to."]
    #[serde(rename = "ipConfigurationId", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration_id: Option<String>,
    #[doc = "List of egress VpnSiteLinkConnections."]
    #[serde(rename = "egressVpnSiteLinkConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub egress_vpn_site_link_connections: Vec<SubResource>,
    #[doc = "List of ingress VpnSiteLinkConnections."]
    #[serde(rename = "ingressVpnSiteLinkConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub ingress_vpn_site_link_connections: Vec<SubResource>,
}
impl VpnGatewayNatRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vpn_gateway_nat_rule_properties {
    use super::*;
    #[doc = "The type of NAT rule for VPN NAT."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Static,
        Dynamic,
    }
    #[doc = "The Source NAT direction of a VPN NAT."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        EgressSnat,
        IngressSnat,
    }
}
#[doc = "Start packet capture parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayPacketCaptureStartParameters {
    #[doc = "Start Packet capture parameters on vpn gateway."]
    #[serde(rename = "filterData", default, skip_serializing_if = "Option::is_none")]
    pub filter_data: Option<String>,
}
impl VpnGatewayPacketCaptureStartParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Stop packet capture parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayPacketCaptureStopParameters {
    #[doc = "SAS url for packet capture on vpn gateway."]
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
}
impl VpnGatewayPacketCaptureStopParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for VpnGateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayProperties {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
    #[doc = "List of all vpn connections to the gateway."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub connections: Vec<VpnConnection>,
    #[doc = "BGP settings details."]
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "The scale unit for this vpn gateway."]
    #[serde(rename = "vpnGatewayScaleUnit", default, skip_serializing_if = "Option::is_none")]
    pub vpn_gateway_scale_unit: Option<i32>,
    #[doc = "List of all IPs configured on the gateway."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<VpnGatewayIpConfiguration>,
    #[doc = "Enable BGP routes translation for NAT on this VpnGateway."]
    #[serde(rename = "enableBgpRouteTranslationForNat", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp_route_translation_for_nat: Option<bool>,
    #[doc = "Enable Routing Preference property for the Public IP Interface of the VpnGateway."]
    #[serde(rename = "isRoutingPreferenceInternet", default, skip_serializing_if = "Option::is_none")]
    pub is_routing_preference_internet: Option<bool>,
    #[doc = "List of all the nat Rules associated with the gateway."]
    #[serde(rename = "natRules", default, skip_serializing_if = "Vec::is_empty")]
    pub nat_rules: Vec<VpnGatewayNatRule>,
}
impl VpnGatewayProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "BGP settings details for a link."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnLinkBgpSettings {
    #[doc = "The BGP speaker's ASN."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i64>,
    #[doc = "The BGP peering address and BGP identifier of this BGP speaker."]
    #[serde(rename = "bgpPeeringAddress", default, skip_serializing_if = "Option::is_none")]
    pub bgp_peering_address: Option<String>,
}
impl VpnLinkBgpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of properties of a link provider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnLinkProviderProperties {
    #[doc = "Name of the link provider."]
    #[serde(rename = "linkProviderName", default, skip_serializing_if = "Option::is_none")]
    pub link_provider_name: Option<String>,
    #[doc = "Link speed."]
    #[serde(rename = "linkSpeedInMbps", default, skip_serializing_if = "Option::is_none")]
    pub link_speed_in_mbps: Option<i32>,
}
impl VpnLinkProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Vpn NatRule mapping."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnNatRuleMapping {
    #[doc = "Address space for Vpn NatRule mapping."]
    #[serde(rename = "addressSpace", default, skip_serializing_if = "Option::is_none")]
    pub address_space: Option<String>,
    #[doc = "Port range for Vpn NatRule mapping."]
    #[serde(rename = "portRange", default, skip_serializing_if = "Option::is_none")]
    pub port_range: Option<String>,
}
impl VpnNatRuleMapping {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Start packet capture parameters on virtual network gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnPacketCaptureStartParameters {
    #[doc = "Start Packet capture parameters."]
    #[serde(rename = "filterData", default, skip_serializing_if = "Option::is_none")]
    pub filter_data: Option<String>,
}
impl VpnPacketCaptureStartParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Stop packet capture parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnPacketCaptureStopParameters {
    #[doc = "SAS url for packet capture on virtual network gateway."]
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
}
impl VpnPacketCaptureStopParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Vpn Profile Response for package generation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnProfileResponse {
    #[doc = "URL to the VPN profile."]
    #[serde(rename = "profileUrl", default, skip_serializing_if = "Option::is_none")]
    pub profile_url: Option<String>,
}
impl VpnProfileResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the Radius client root certificate of VpnServerConfiguration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigRadiusClientRootCertificate {
    #[doc = "The certificate name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The Radius client root certificate thumbprint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
}
impl VpnServerConfigRadiusClientRootCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Radius Server root certificate of VpnServerConfiguration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigRadiusServerRootCertificate {
    #[doc = "The certificate name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The certificate public data."]
    #[serde(rename = "publicCertData", default, skip_serializing_if = "Option::is_none")]
    pub public_cert_data: Option<String>,
}
impl VpnServerConfigRadiusServerRootCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the revoked VPN client certificate of VpnServerConfiguration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigVpnClientRevokedCertificate {
    #[doc = "The certificate name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The revoked VPN client certificate thumbprint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
}
impl VpnServerConfigVpnClientRevokedCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of VPN client root certificate of VpnServerConfiguration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigVpnClientRootCertificate {
    #[doc = "The certificate name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The certificate public data."]
    #[serde(rename = "publicCertData", default, skip_serializing_if = "Option::is_none")]
    pub public_cert_data: Option<String>,
}
impl VpnServerConfigVpnClientRootCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnServerConfiguration Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfiguration {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Parameters for VpnServerConfiguration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnServerConfigurationProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnServerConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for VpnServerConfiguration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigurationProperties {
    #[doc = "The name of the VpnServerConfiguration that is unique within a resource group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "VPN protocols for the VpnServerConfiguration."]
    #[serde(rename = "vpnProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_protocols: Vec<String>,
    #[doc = "VPN authentication types for the VpnServerConfiguration."]
    #[serde(rename = "vpnAuthenticationTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_authentication_types: Vec<String>,
    #[doc = "VPN client root certificate of VpnServerConfiguration."]
    #[serde(rename = "vpnClientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_root_certificates: Vec<VpnServerConfigVpnClientRootCertificate>,
    #[doc = "VPN client revoked certificate of VpnServerConfiguration."]
    #[serde(rename = "vpnClientRevokedCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_revoked_certificates: Vec<VpnServerConfigVpnClientRevokedCertificate>,
    #[doc = "Radius Server root certificate of VpnServerConfiguration."]
    #[serde(rename = "radiusServerRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub radius_server_root_certificates: Vec<VpnServerConfigRadiusServerRootCertificate>,
    #[doc = "Radius client root certificate of VpnServerConfiguration."]
    #[serde(rename = "radiusClientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub radius_client_root_certificates: Vec<VpnServerConfigRadiusClientRootCertificate>,
    #[doc = "VpnClientIpsecPolicies for VpnServerConfiguration."]
    #[serde(rename = "vpnClientIpsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_ipsec_policies: Vec<IpsecPolicy>,
    #[doc = "The radius server address property of the VpnServerConfiguration resource for point to site client connection."]
    #[serde(rename = "radiusServerAddress", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_address: Option<String>,
    #[doc = "The radius secret property of the VpnServerConfiguration resource for point to site client connection."]
    #[serde(rename = "radiusServerSecret", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_secret: Option<String>,
    #[doc = "Multiple Radius Server configuration for VpnServerConfiguration."]
    #[serde(rename = "radiusServers", default, skip_serializing_if = "Vec::is_empty")]
    pub radius_servers: Vec<RadiusServer>,
    #[doc = "AAD Vpn authentication type related parameters."]
    #[serde(rename = "aadAuthenticationParameters", default, skip_serializing_if = "Option::is_none")]
    pub aad_authentication_parameters: Option<AadAuthenticationParameters>,
    #[doc = "The provisioning state of the VpnServerConfiguration resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "List of references to P2SVpnGateways."]
    #[serde(rename = "p2SVpnGateways", default, skip_serializing_if = "Vec::is_empty")]
    pub p2_s_vpn_gateways: Vec<P2sVpnGateway>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnServerConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnServerConfigurations list associated with VirtualWan Response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigurationsResponse {
    #[doc = "List of VpnServerConfigurations associated with VirtualWan."]
    #[serde(rename = "vpnServerConfigurationResourceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_server_configuration_resource_ids: Vec<String>,
}
impl VpnServerConfigurationsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnSite Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnSite {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Parameters for VpnSite."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnSiteProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnSite {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[doc = "VpnSite Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteId {
    #[doc = "The resource-uri of the vpn-site for which config is to be fetched."]
    #[serde(rename = "vpnSite", default, skip_serializing_if = "Option::is_none")]
    pub vpn_site: Option<String>,
}
impl VpnSiteId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnSiteLink Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Parameters for VpnSite."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnSiteLinkProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VpnSiteLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnSiteLinkConnection Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteLinkConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Parameters for VpnConnection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnSiteLinkConnectionProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VpnSiteLinkConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for VpnConnection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteLinkConnectionProperties {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "vpnSiteLink", default, skip_serializing_if = "Option::is_none")]
    pub vpn_site_link: Option<SubResource>,
    #[doc = "Routing weight for vpn connection."]
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[doc = "Vpn link connection mode."]
    #[serde(rename = "vpnLinkConnectionMode", default, skip_serializing_if = "Option::is_none")]
    pub vpn_link_connection_mode: Option<vpn_site_link_connection_properties::VpnLinkConnectionMode>,
    #[doc = "The current state of the vpn connection."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VpnConnectionStatus>,
    #[doc = "Gateway connection protocol."]
    #[serde(rename = "vpnConnectionProtocolType", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_protocol_type: Option<ConnectionProtocol>,
    #[doc = "Ingress bytes transferred."]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[doc = "Egress bytes transferred."]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "Expected bandwidth in MBPS."]
    #[serde(rename = "connectionBandwidth", default, skip_serializing_if = "Option::is_none")]
    pub connection_bandwidth: Option<i32>,
    #[doc = "SharedKey for the vpn connection."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "EnableBgp flag."]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "Enable policy-based traffic selectors."]
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[doc = "The IPSec Policies to be considered by this connection."]
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[doc = "EnableBgp flag."]
    #[serde(rename = "enableRateLimiting", default, skip_serializing_if = "Option::is_none")]
    pub enable_rate_limiting: Option<bool>,
    #[doc = "Use local azure ip to initiate connection."]
    #[serde(rename = "useLocalAzureIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub use_local_azure_ip_address: Option<bool>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "List of ingress NatRules."]
    #[serde(rename = "ingressNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub ingress_nat_rules: Vec<SubResource>,
    #[doc = "List of egress NatRules."]
    #[serde(rename = "egressNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub egress_nat_rules: Vec<SubResource>,
}
impl VpnSiteLinkConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vpn_site_link_connection_properties {
    use super::*;
    #[doc = "Vpn link connection mode."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VpnLinkConnectionMode {
        Default,
        ResponderOnly,
        InitiatorOnly,
    }
}
#[doc = "Parameters for VpnSite."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteLinkProperties {
    #[doc = "List of properties of a link provider."]
    #[serde(rename = "linkProperties", default, skip_serializing_if = "Option::is_none")]
    pub link_properties: Option<VpnLinkProviderProperties>,
    #[doc = "The ip-address for the vpn-site-link."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "FQDN of vpn-site-link."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "BGP settings details for a link."]
    #[serde(rename = "bgpProperties", default, skip_serializing_if = "Option::is_none")]
    pub bgp_properties: Option<VpnLinkBgpSettings>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VpnSiteLinkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for VpnSite."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteProperties {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualWan", default, skip_serializing_if = "Option::is_none")]
    pub virtual_wan: Option<SubResource>,
    #[doc = "List of properties of the device."]
    #[serde(rename = "deviceProperties", default, skip_serializing_if = "Option::is_none")]
    pub device_properties: Option<DeviceProperties>,
    #[doc = "The ip-address for the vpn-site."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The key for vpn-site that can be used for connections."]
    #[serde(rename = "siteKey", default, skip_serializing_if = "Option::is_none")]
    pub site_key: Option<String>,
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "addressSpace", default, skip_serializing_if = "Option::is_none")]
    pub address_space: Option<AddressSpace>,
    #[doc = "BGP settings details."]
    #[serde(rename = "bgpProperties", default, skip_serializing_if = "Option::is_none")]
    pub bgp_properties: Option<BgpSettings>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "IsSecuritySite flag."]
    #[serde(rename = "isSecuritySite", default, skip_serializing_if = "Option::is_none")]
    pub is_security_site: Option<bool>,
    #[doc = "List of all vpn site links."]
    #[serde(rename = "vpnSiteLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_site_links: Vec<VpnSiteLink>,
    #[doc = "The Office365 breakout policy."]
    #[serde(rename = "o365Policy", default, skip_serializing_if = "Option::is_none")]
    pub o365_policy: Option<O365PolicyProperties>,
}
impl VpnSiteProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines contents of a web application rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebApplicationFirewallCustomRule {
    #[doc = "The name of the resource that is unique within a policy. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value."]
    pub priority: i64,
    #[doc = "The rule type."]
    #[serde(rename = "ruleType")]
    pub rule_type: web_application_firewall_custom_rule::RuleType,
    #[doc = "List of match conditions."]
    #[serde(rename = "matchConditions")]
    pub match_conditions: Vec<MatchCondition>,
    #[doc = "Type of Actions."]
    pub action: web_application_firewall_custom_rule::Action,
}
impl WebApplicationFirewallCustomRule {
    pub fn new(
        priority: i64,
        rule_type: web_application_firewall_custom_rule::RuleType,
        match_conditions: Vec<MatchCondition>,
        action: web_application_firewall_custom_rule::Action,
    ) -> Self {
        Self {
            name: None,
            etag: None,
            priority,
            rule_type,
            match_conditions,
            action,
        }
    }
}
pub mod web_application_firewall_custom_rule {
    use super::*;
    #[doc = "The rule type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleType {
        MatchRule,
        Invalid,
    }
    #[doc = "Type of Actions."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Allow,
        Block,
        Log,
    }
}
#[doc = "Defines web application firewall policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebApplicationFirewallPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Defines web application firewall policy properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WebApplicationFirewallPolicyPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl WebApplicationFirewallPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list WebApplicationFirewallPolicies. It contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebApplicationFirewallPolicyListResult {
    #[doc = "List of WebApplicationFirewallPolicies within a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WebApplicationFirewallPolicy>,
    #[doc = "URL to get the next set of WebApplicationFirewallPolicy objects if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebApplicationFirewallPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines web application firewall policy properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebApplicationFirewallPolicyPropertiesFormat {
    #[doc = "Defines contents of a web application firewall global configuration."]
    #[serde(rename = "policySettings", default, skip_serializing_if = "Option::is_none")]
    pub policy_settings: Option<PolicySettings>,
    #[doc = "The custom rules inside the policy."]
    #[serde(rename = "customRules", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_rules: Vec<WebApplicationFirewallCustomRule>,
    #[doc = "A collection of references to application gateways."]
    #[serde(rename = "applicationGateways", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateways: Vec<ApplicationGateway>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Resource status of the policy."]
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<web_application_firewall_policy_properties_format::ResourceState>,
    #[doc = "Allow to exclude some variable satisfy the condition for the WAF check."]
    #[serde(rename = "managedRules")]
    pub managed_rules: ManagedRulesDefinition,
    #[doc = "A collection of references to application gateway http listeners."]
    #[serde(rename = "httpListeners", default, skip_serializing_if = "Vec::is_empty")]
    pub http_listeners: Vec<SubResource>,
    #[doc = "A collection of references to application gateway path rules."]
    #[serde(rename = "pathBasedRules", default, skip_serializing_if = "Vec::is_empty")]
    pub path_based_rules: Vec<SubResource>,
}
impl WebApplicationFirewallPolicyPropertiesFormat {
    pub fn new(managed_rules: ManagedRulesDefinition) -> Self {
        Self {
            policy_settings: None,
            custom_rules: Vec::new(),
            application_gateways: Vec::new(),
            provisioning_state: None,
            resource_state: None,
            managed_rules,
            http_listeners: Vec::new(),
            path_based_rules: Vec::new(),
        }
    }
}
pub mod web_application_firewall_policy_properties_format {
    use super::*;
    #[doc = "Resource status of the policy."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceState {
        Creating,
        Enabling,
        Enabled,
        Disabling,
        Disabled,
        Deleting,
    }
}
#[doc = "Connectivity group item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivityGroupItem {
    #[doc = "Network group Id."]
    #[serde(rename = "networkGroupId")]
    pub network_group_id: String,
    #[doc = "Flag if need to use hub gateway."]
    #[serde(rename = "useHubGateway", default, skip_serializing_if = "Option::is_none")]
    pub use_hub_gateway: Option<connectivity_group_item::UseHubGateway>,
    #[doc = "Flag if global is supported."]
    #[serde(rename = "isGlobal", default, skip_serializing_if = "Option::is_none")]
    pub is_global: Option<connectivity_group_item::IsGlobal>,
    #[doc = "Group connectivity type."]
    #[serde(rename = "groupConnectivity")]
    pub group_connectivity: connectivity_group_item::GroupConnectivity,
}
impl ConnectivityGroupItem {
    pub fn new(network_group_id: String, group_connectivity: connectivity_group_item::GroupConnectivity) -> Self {
        Self {
            network_group_id,
            use_hub_gateway: None,
            is_global: None,
            group_connectivity,
        }
    }
}
pub mod connectivity_group_item {
    use super::*;
    #[doc = "Flag if need to use hub gateway."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UseHubGateway {
        False,
        True,
    }
    #[doc = "Flag if global is supported."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IsGlobal {
        False,
        True,
    }
    #[doc = "Group connectivity type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GroupConnectivity {
        None,
        DirectlyConnected,
    }
}
