#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Network base admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveBaseSecurityAdminRule {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Deployment time string."]
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[doc = "Deployment region."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "A display name of the security admin configuration."]
    #[serde(rename = "configurationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub configuration_display_name: Option<String>,
    #[doc = "A description of the security admin configuration."]
    #[serde(rename = "configurationDescription", default, skip_serializing_if = "Option::is_none")]
    pub configuration_description: Option<String>,
    #[doc = "A display name of the rule collection."]
    #[serde(rename = "ruleCollectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_display_name: Option<String>,
    #[doc = "A description of the rule collection."]
    #[serde(rename = "ruleCollectionDescription", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_description: Option<String>,
    #[doc = "Groups for rule collection"]
    #[serde(rename = "ruleCollectionAppliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[doc = "Effective configuration groups."]
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ConfigurationGroup>,
    #[doc = "Whether the rule is custom or default."]
    pub kind: active_base_security_admin_rule::Kind,
}
impl ActiveBaseSecurityAdminRule {
    pub fn new(kind: active_base_security_admin_rule::Kind) -> Self {
        Self {
            id: None,
            commit_time: None,
            region: None,
            configuration_display_name: None,
            configuration_description: None,
            rule_collection_display_name: None,
            rule_collection_description: None,
            rule_collection_applies_to_groups: Vec::new(),
            rule_groups: Vec::new(),
            kind,
        }
    }
}
pub mod active_base_security_admin_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "Network base rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveBaseSecurityUserRule {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Deployment time string."]
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[doc = "Deployment region."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "A display name of the security user configuration."]
    #[serde(rename = "configurationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub configuration_display_name: Option<String>,
    #[doc = "A description of the security user configuration."]
    #[serde(rename = "configurationDescription", default, skip_serializing_if = "Option::is_none")]
    pub configuration_description: Option<String>,
    #[doc = "A display name of the rule collection."]
    #[serde(rename = "ruleCollectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_display_name: Option<String>,
    #[doc = "A description of the rule collection."]
    #[serde(rename = "ruleCollectionDescription", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_description: Option<String>,
    #[doc = "Groups for rule collection"]
    #[serde(rename = "ruleCollectionAppliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[doc = "Effective configuration groups."]
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ConfigurationGroup>,
    #[doc = "Whether the rule is custom or default."]
    pub kind: active_base_security_user_rule::Kind,
}
impl ActiveBaseSecurityUserRule {
    pub fn new(kind: active_base_security_user_rule::Kind) -> Self {
        Self {
            id: None,
            commit_time: None,
            region: None,
            configuration_display_name: None,
            configuration_description: None,
            rule_collection_display_name: None,
            rule_collection_description: None,
            rule_collection_applies_to_groups: Vec::new(),
            rule_groups: Vec::new(),
            kind,
        }
    }
}
pub mod active_base_security_user_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "Effective Virtual Networks Parameter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveConfigurationParameter {
    #[doc = "List of regions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub regions: Vec<String>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveConfigurationParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Active connectivity configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveConnectivityConfiguration {
    #[serde(flatten)]
    pub effective_connectivity_configuration: EffectiveConnectivityConfiguration,
    #[doc = "Deployment time string."]
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[doc = "Deployment region."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
}
impl ActiveConnectivityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list active connectivity configurations. It contains a list of active connectivity configurations and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveConnectivityConfigurationsListResult {
    #[doc = "Gets a page of active connectivity configurations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ActiveConnectivityConfiguration>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveConnectivityConfigurationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network default admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveDefaultSecurityAdminRule {
    #[serde(flatten)]
    pub active_base_security_admin_rule: ActiveBaseSecurityAdminRule,
    #[doc = "Security default admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultAdminPropertiesFormat>,
}
impl ActiveDefaultSecurityAdminRule {
    pub fn new(active_base_security_admin_rule: ActiveBaseSecurityAdminRule) -> Self {
        Self {
            active_base_security_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Network security default user rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveDefaultSecurityUserRule {
    #[serde(flatten)]
    pub active_base_security_user_rule: ActiveBaseSecurityUserRule,
    #[doc = "Security default user rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultUserRulePropertiesFormat>,
}
impl ActiveDefaultSecurityUserRule {
    pub fn new(active_base_security_user_rule: ActiveBaseSecurityUserRule) -> Self {
        Self {
            active_base_security_user_rule,
            properties: None,
        }
    }
}
#[doc = "Network admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveSecurityAdminRule {
    #[serde(flatten)]
    pub active_base_security_admin_rule: ActiveBaseSecurityAdminRule,
    #[doc = "Security admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdminPropertiesFormat>,
}
impl ActiveSecurityAdminRule {
    pub fn new(active_base_security_admin_rule: ActiveBaseSecurityAdminRule) -> Self {
        Self {
            active_base_security_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Result of the request to list active security admin rules. It contains a list of active security admin rules and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveSecurityAdminRulesListResult {
    #[doc = "Gets a page of active security admin rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ActiveBaseSecurityAdminRule>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveSecurityAdminRulesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network security user rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveSecurityUserRule {
    #[serde(flatten)]
    pub active_base_security_user_rule: ActiveBaseSecurityUserRule,
    #[doc = "Security rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserRulePropertiesFormat>,
}
impl ActiveSecurityUserRule {
    pub fn new(active_base_security_user_rule: ActiveBaseSecurityUserRule) -> Self {
        Self {
            active_base_security_user_rule,
            properties: None,
        }
    }
}
#[doc = "Result of the request to list active security user rules. It contains a list of active security user rules and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveSecurityUserRulesListResult {
    #[doc = "Gets a page of active security user rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ActiveBaseSecurityUserRule>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveSecurityUserRulesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Address prefix item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressPrefixItem {
    #[doc = "Address prefix."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "Address prefix type."]
    #[serde(rename = "addressPrefixType", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix_type: Option<address_prefix_item::AddressPrefixType>,
}
impl AddressPrefixItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod address_prefix_item {
    use super::*;
    #[doc = "Address prefix type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AddressPrefixType {
        #[serde(rename = "IPPrefix")]
        IpPrefix,
        ServiceTag,
    }
}
#[doc = "Security admin rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdminPropertiesFormat {
    #[doc = "A friendly name for the rule."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Network protocol this rule applies to."]
    pub protocol: RuleProtocol,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "Whether network traffic is allowed or denied."]
    pub access: SecurityConfigurationRuleAccess,
    #[doc = "The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
    pub direction: SecurityConfigurationRuleDirection,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AdminPropertiesFormat {
    pub fn new(protocol: RuleProtocol, access: SecurityConfigurationRuleAccess, direction: SecurityConfigurationRuleDirection) -> Self {
        Self {
            display_name: None,
            description: None,
            protocol,
            sources: Vec::new(),
            destinations: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            access,
            priority: None,
            direction,
            provisioning_state: None,
        }
    }
}
#[doc = "Network admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdminRule {
    #[serde(flatten)]
    pub base_admin_rule: BaseAdminRule,
    #[doc = "Security admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdminPropertiesFormat>,
}
impl AdminRule {
    pub fn new(base_admin_rule: BaseAdminRule) -> Self {
        Self {
            base_admin_rule,
            properties: None,
        }
    }
}
#[doc = "security configuration admin rule list result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdminRuleListResult {
    #[doc = "A list of admin rules"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BaseAdminRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AdminRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network base admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseAdminRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Whether the rule is custom or default."]
    pub kind: base_admin_rule::Kind,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl BaseAdminRule {
    pub fn new(kind: base_admin_rule::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
            system_data: None,
        }
    }
}
pub mod base_admin_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "Network base rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseUserRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Whether the rule is custom or default."]
    pub kind: base_user_rule::Kind,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl BaseUserRule {
    pub fn new(kind: base_user_rule::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
            system_data: None,
        }
    }
}
pub mod base_user_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "An error response from the service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[doc = "An error response from the service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An error response from the service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[doc = "An identifier for the error. Codes are invariant and are intended to be consumed programmatically."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "A message describing the error, intended to be suitable for display in a user interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The target of the particular error. For example, the name of the property in error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "A list of additional details about the error."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The network configuration group resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConfigurationGroup {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Properties of network group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkGroupProperties>,
}
impl ConfigurationGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Configuration Deployment Type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConfigurationType {
    SecurityAdmin,
    SecurityUser,
    Connectivity,
}
#[doc = "The network manager connectivity configuration resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityConfiguration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of network manager connectivity configuration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectivityConfigurationProperties>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ConnectivityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list network manager connectivity configurations. It contains a list of configurations and a link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityConfigurationListResult {
    #[doc = "Gets a page of Connectivity Configurations"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConnectivityConfiguration>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ConnectivityConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of network manager connectivity configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivityConfigurationProperties {
    #[doc = "A friendly name for the resource."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the connectivity configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Connectivity topology type."]
    #[serde(rename = "connectivityTopology")]
    pub connectivity_topology: connectivity_configuration_properties::ConnectivityTopology,
    #[doc = "List of hubItems"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hubs: Vec<Hub>,
    #[doc = "Flag if global mesh is supported."]
    #[serde(rename = "isGlobal", default, skip_serializing_if = "Option::is_none")]
    pub is_global: Option<connectivity_configuration_properties::IsGlobal>,
    #[doc = "Groups for configuration"]
    #[serde(rename = "appliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub applies_to_groups: Vec<ConnectivityGroupItem>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[doc = "Flag if need to remove current existing peerings."]
    #[serde(rename = "deleteExistingPeering", default, skip_serializing_if = "Option::is_none")]
    pub delete_existing_peering: Option<connectivity_configuration_properties::DeleteExistingPeering>,
}
impl ConnectivityConfigurationProperties {
    pub fn new(connectivity_topology: connectivity_configuration_properties::ConnectivityTopology) -> Self {
        Self {
            display_name: None,
            description: None,
            connectivity_topology,
            hubs: Vec::new(),
            is_global: None,
            applies_to_groups: Vec::new(),
            provisioning_state: None,
            delete_existing_peering: None,
        }
    }
}
pub mod connectivity_configuration_properties {
    use super::*;
    #[doc = "Connectivity topology type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectivityTopology {
        HubAndSpoke,
        Mesh,
    }
    #[doc = "Flag if global mesh is supported."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IsGlobal {
        False,
        True,
    }
    #[doc = "Flag if need to remove current existing peerings."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeleteExistingPeering {
        False,
        True,
    }
}
#[doc = "Security default admin rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultAdminPropertiesFormat {
    #[doc = "A friendly name for the rule."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Default rule flag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flag: Option<String>,
    #[doc = "Network protocol this rule applies to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<RuleProtocol>,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "Whether network traffic is allowed or denied."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<SecurityConfigurationRuleAccess>,
    #[doc = "The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<SecurityConfigurationRuleDirection>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl DefaultAdminPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network default admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DefaultAdminRule {
    #[serde(flatten)]
    pub base_admin_rule: BaseAdminRule,
    #[doc = "Security default admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultAdminPropertiesFormat>,
}
impl DefaultAdminRule {
    pub fn new(base_admin_rule: BaseAdminRule) -> Self {
        Self {
            base_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Network security default user rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DefaultUserRule {
    #[serde(flatten)]
    pub base_user_rule: BaseUserRule,
    #[doc = "Security default user rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultUserRulePropertiesFormat>,
}
impl DefaultUserRule {
    pub fn new(base_user_rule: BaseUserRule) -> Self {
        Self {
            base_user_rule,
            properties: None,
        }
    }
}
#[doc = "Security default user rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultUserRulePropertiesFormat {
    #[doc = "A friendly name for the rule."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Default rule flag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flag: Option<String>,
    #[doc = "Network protocol this rule applies to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<RuleProtocol>,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<SecurityConfigurationRuleDirection>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl DefaultUserRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network base admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EffectiveBaseSecurityAdminRule {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "A display name of the security admin configuration."]
    #[serde(rename = "configurationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub configuration_display_name: Option<String>,
    #[doc = "A description of the security admin configuration."]
    #[serde(rename = "configurationDescription", default, skip_serializing_if = "Option::is_none")]
    pub configuration_description: Option<String>,
    #[doc = "A display name of the rule collection."]
    #[serde(rename = "ruleCollectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_display_name: Option<String>,
    #[doc = "A description of the rule collection."]
    #[serde(rename = "ruleCollectionDescription", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_description: Option<String>,
    #[doc = "Groups for rule collection"]
    #[serde(rename = "ruleCollectionAppliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[doc = "Effective configuration groups."]
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ConfigurationGroup>,
    #[doc = "Whether the rule is custom or default."]
    pub kind: effective_base_security_admin_rule::Kind,
}
impl EffectiveBaseSecurityAdminRule {
    pub fn new(kind: effective_base_security_admin_rule::Kind) -> Self {
        Self {
            id: None,
            configuration_display_name: None,
            configuration_description: None,
            rule_collection_display_name: None,
            rule_collection_description: None,
            rule_collection_applies_to_groups: Vec::new(),
            rule_groups: Vec::new(),
            kind,
        }
    }
}
pub mod effective_base_security_admin_rule {
    use super::*;
    #[doc = "Whether the rule is custom or default."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[doc = "The network manager effective connectivity configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveConnectivityConfiguration {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Properties of network manager connectivity configuration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectivityConfigurationProperties>,
    #[doc = "Effective configuration groups."]
    #[serde(rename = "configurationGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub configuration_groups: Vec<ConfigurationGroup>,
}
impl EffectiveConnectivityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network default admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EffectiveDefaultSecurityAdminRule {
    #[serde(flatten)]
    pub effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule,
    #[doc = "Security default admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultAdminPropertiesFormat>,
}
impl EffectiveDefaultSecurityAdminRule {
    pub fn new(effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule) -> Self {
        Self {
            effective_base_security_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Network admin rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EffectiveSecurityAdminRule {
    #[serde(flatten)]
    pub effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule,
    #[doc = "Security admin rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdminPropertiesFormat>,
}
impl EffectiveSecurityAdminRule {
    pub fn new(effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule) -> Self {
        Self {
            effective_base_security_admin_rule,
            properties: None,
        }
    }
}
#[doc = "Effective Virtual Network"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveVirtualNetwork {
    #[doc = "Effective vnet Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Location of vnet."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Membership Type."]
    #[serde(rename = "membershipType", default, skip_serializing_if = "Option::is_none")]
    pub membership_type: Option<effective_virtual_network::MembershipType>,
}
impl EffectiveVirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_virtual_network {
    use super::*;
    #[doc = "Membership Type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MembershipType {
        Static,
        Dynamic,
    }
}
#[doc = "Result of the request to list Effective Virtual Network. It contains a list of groups and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveVirtualNetworksListResult {
    #[doc = "Gets a page of EffectiveVirtualNetwork"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveVirtualNetwork>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl EffectiveVirtualNetworksListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Effective Virtual Networks Parameter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveVirtualNetworksParameter {
    #[doc = "Conditional Members."]
    #[serde(rename = "conditionalMembers", default, skip_serializing_if = "Option::is_none")]
    pub conditional_members: Option<String>,
    #[doc = "Continuation token for pagination, capturing the next page size and offset, as well as the context of the query."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl EffectiveVirtualNetworksParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hub Item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Hub {
    #[doc = "Resource Id."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "Resource Type."]
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
}
impl Hub {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Logging Category"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoggingCategory {
    #[doc = "The name of the logging category."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl LoggingCategory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The current provisioning state."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum NspProvisioningState {
    Succeeded,
    Creating,
    Updating,
    Deleting,
    Accepted,
    Failed,
}
#[doc = "The network group resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkGroup {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of network group"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkGroupProperties>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl NetworkGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list NetworkGroup. It contains a list of groups and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkGroupListResult {
    #[doc = "Gets a page of NetworkGroup"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkGroup>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of network group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkGroupProperties {
    #[doc = "A friendly name for the network group."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the network group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Group member type."]
    #[serde(rename = "memberType", default, skip_serializing_if = "Option::is_none")]
    pub member_type: Option<String>,
    #[doc = "Group members of network group."]
    #[serde(rename = "groupMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub group_members: Vec<GroupMembersItem>,
    #[doc = "Network group conditional filter."]
    #[serde(rename = "conditionalMembership", default, skip_serializing_if = "Option::is_none")]
    pub conditional_membership: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Managed Network resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManager {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of Managed Network"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkManagerProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl NetworkManager {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Manager Commit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerCommit {
    #[doc = "Commit Id."]
    #[serde(rename = "commitId", default, skip_serializing_if = "Option::is_none")]
    pub commit_id: Option<String>,
    #[doc = "List of target locations."]
    #[serde(rename = "targetLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub target_locations: Vec<String>,
    #[doc = "List of configuration ids."]
    #[serde(rename = "configurationIds", default, skip_serializing_if = "Vec::is_empty")]
    pub configuration_ids: Vec<String>,
    #[doc = "Configuration Deployment Type."]
    #[serde(rename = "commitType", default, skip_serializing_if = "Option::is_none")]
    pub commit_type: Option<ConfigurationType>,
}
impl NetworkManagerCommit {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Manager Deployment Status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerDeploymentStatus {
    #[doc = "Commit Time."]
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[doc = "Region Name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[doc = "Deployment Status."]
    #[serde(rename = "deploymentStatus", default, skip_serializing_if = "Option::is_none")]
    pub deployment_status: Option<network_manager_deployment_status::DeploymentStatus>,
    #[doc = "List of configuration ids."]
    #[serde(rename = "configurationIds", default, skip_serializing_if = "Vec::is_empty")]
    pub configuration_ids: Vec<String>,
    #[doc = "Configuration Deployment Type."]
    #[serde(rename = "deploymentType", default, skip_serializing_if = "Option::is_none")]
    pub deployment_type: Option<ConfigurationType>,
    #[doc = "Error Message."]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}
impl NetworkManagerDeploymentStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_manager_deployment_status {
    use super::*;
    #[doc = "Deployment Status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeploymentStatus {
        NotStarted,
        Deploying,
        Deployed,
        Failed,
    }
}
#[doc = "A list of Network Manager Deployment Status"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerDeploymentStatusListResult {
    #[doc = "Gets a page of Network Manager Deployment Status"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkManagerDeploymentStatus>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerDeploymentStatusListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Manager Deployment Status Parameter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerDeploymentStatusParameter {
    #[doc = "List of locations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub regions: Vec<String>,
    #[doc = "List of deployment types."]
    #[serde(rename = "deploymentTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub deployment_types: Vec<ConfigurationType>,
    #[doc = "Continuation token for pagination, capturing the next page size and offset, as well as the context of the query."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerDeploymentStatusParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list networkManagerEffectiveConnectivityConfiguration. It contains a list of groups and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerEffectiveConnectivityConfigurationListResult {
    #[doc = "Gets a page of NetworkManagerEffectiveConnectivityConfiguration"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveConnectivityConfiguration>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerEffectiveConnectivityConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list networkManagerEffectiveSecurityAdminRules. It contains a list of groups and a skiptoken to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerEffectiveSecurityAdminRulesListResult {
    #[doc = "Gets a page of NetworkManagerEffectiveSecurityAdminRules"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveBaseSecurityAdminRule>,
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerEffectiveSecurityAdminRulesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list NetworkManager. It contains a list of network managers and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerListResult {
    #[doc = "Gets a page of NetworkManager"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkManager>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkManagerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Managed Network"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerProperties {
    #[doc = "A friendly name for the network manager."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the network manager."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Scope of Network Manager."]
    #[serde(rename = "networkManagerScopes", default, skip_serializing_if = "Option::is_none")]
    pub network_manager_scopes: Option<network_manager_properties::NetworkManagerScopes>,
    #[doc = "Scope Access."]
    #[serde(rename = "networkManagerScopeAccesses", default, skip_serializing_if = "Vec::is_empty")]
    pub network_manager_scope_accesses: Vec<ConfigurationType>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkManagerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_manager_properties {
    use super::*;
    #[doc = "Scope of Network Manager."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct NetworkManagerScopes {
        #[doc = "List of management groups."]
        #[serde(rename = "managementGroups", default, skip_serializing_if = "Vec::is_empty")]
        pub management_groups: Vec<String>,
        #[doc = "List of subscriptions."]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub subscriptions: Vec<String>,
    }
    impl NetworkManagerScopes {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Network manager security group item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerSecurityGroupItem {
    #[doc = "Network manager group Id."]
    #[serde(rename = "networkGroupId", default, skip_serializing_if = "Option::is_none")]
    pub network_group_id: Option<String>,
}
impl NetworkManagerSecurityGroupItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Network Security Perimeter resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityPerimeter {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of network security perimeter."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkSecurityPerimeterProperties>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Network security perimeter identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl NetworkSecurityPerimeter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list NetworkSecurityPerimeter. It contains a list of network security perimeters and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityPerimeterListResult {
    #[doc = "Gets a page of NetworkSecurityPerimeter"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkSecurityPerimeter>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkSecurityPerimeterListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of network security perimeter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityPerimeterProperties {
    #[doc = "A friendly name for the network security perimeter."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the network security perimeter."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<NspProvisioningState>,
}
impl NetworkSecurityPerimeterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The NSP access rule resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NspAccessRule {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of NSP access rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NspAccessRuleProperties>,
    #[doc = "The name of the access rule that is unique within a profile. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "NSP access rule identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl NspAccessRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list NSP access rules. Contains a list of NSP access rules and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NspAccessRuleListResult {
    #[doc = "Gets a page of NSP access rule"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NspAccessRule>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NspAccessRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of NSP access rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NspAccessRuleProperties {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<NspProvisioningState>,
    #[doc = "Direction that specifies whether the access rules is inbound/outbound."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<nsp_access_rule_properties::Direction>,
    #[doc = "Inbound address prefixes (IPv4/IPv6)"]
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[doc = "Outbound rules fully qualified domain name format."]
    #[serde(rename = "fullyQualifiedDomainNames", default, skip_serializing_if = "Vec::is_empty")]
    pub fully_qualified_domain_names: Vec<String>,
    #[doc = "Subscription id in the ARM id format."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subscriptions: Vec<String>,
    #[doc = "Inbound rule specified by the perimeter id."]
    #[serde(rename = "networkSecurityPerimeters", default, skip_serializing_if = "Vec::is_empty")]
    pub network_security_perimeters: Vec<PerimeterBasedAccessRule>,
}
impl NspAccessRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod nsp_access_rule_properties {
    use super::*;
    #[doc = "Direction that specifies whether the access rules is inbound/outbound."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[doc = "The NSP resource association resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NspAssociation {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NspAssociationProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "NSP resource association identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl NspAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NspAssociationProperties {
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<NspProvisioningState>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "privateLinkResource", default, skip_serializing_if = "Option::is_none")]
    pub private_link_resource: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub profile: Option<SubResource>,
    #[doc = "Access mode on the association."]
    #[serde(rename = "accessMode", default, skip_serializing_if = "Option::is_none")]
    pub access_mode: Option<nsp_association_properties::AccessMode>,
    #[doc = "Specifies if there are provisioning issues"]
    #[serde(rename = "hasProvisioningIssues", default, skip_serializing_if = "Option::is_none")]
    pub has_provisioning_issues: Option<String>,
}
impl NspAssociationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod nsp_association_properties {
    use super::*;
    #[doc = "Access mode on the association."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AccessMode {
        Learning,
        Enforced,
        Audit,
    }
}
#[doc = "Result of the request to list NSP resource associations. Contains a list of NSP resource associations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NspAssociationsListResult {
    #[doc = "Gets a page of NSP resource associations"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NspAssociation>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NspAssociationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The network security perimeter profile resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NspProfile {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of NSP profile."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NspProfileProperties>,
    #[doc = "The name of the profile resource that is unique within a perimeter. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Identifier of the network security perimeter profile in ARM id format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl NspProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Result of the request to list NSP profiles. Contains a list of NSP profiles and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NspProfileListResult {
    #[doc = "Gets a page of NSP profile"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NspProfile>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NspProfileListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of NSP profile."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NspProfileProperties {
    #[doc = "Version number that increases with every update to access rules within the profile."]
    #[serde(rename = "accessRulesVersion", default, skip_serializing_if = "Option::is_none")]
    pub access_rules_version: Option<String>,
    #[doc = "Gets the enabled log categories."]
    #[serde(rename = "enabledLogCategories", default, skip_serializing_if = "Vec::is_empty")]
    pub enabled_log_categories: Vec<LoggingCategory>,
}
impl NspProfileProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Resource that is onboarded to use network security perimeter. Also referred as perimeter associable resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerimeterAssociableResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the perimeter associable resources."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PerimeterAssociableResourceProperties>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Identifier of the perimeter associable resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl PerimeterAssociableResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the perimeter associable resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerimeterAssociableResourceProperties {
    #[doc = "A friendly name for the properties of perimeter associable resources."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Resource type/provider name."]
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[doc = "Public DNS zone names of the resources."]
    #[serde(rename = "publicDnsZones", default, skip_serializing_if = "Vec::is_empty")]
    pub public_dns_zones: Vec<String>,
}
impl PerimeterAssociableResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Paged list of perimeter associable resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerimeterAssociableResourcesListResult {
    #[doc = "Gets paged list of perimeter associable resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PerimeterAssociableResource>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PerimeterAssociableResourcesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerimeterBasedAccessRule {
    #[doc = "NSP id in the ARM id format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource guid of the NSP supplied."]
    #[serde(rename = "perimeterGuid", default, skip_serializing_if = "Option::is_none")]
    pub perimeter_guid: Option<String>,
    #[doc = "Location of the NSP supplied."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
}
impl PerimeterBasedAccessRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The current provisioning state."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProvisioningState {
    Succeeded,
    Updating,
    Deleting,
    Failed,
}
#[doc = "Proxy resource representation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Query Request Options"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryRequestOptions {
    #[doc = "When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data."]
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl QueryRequestOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common resource representation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines the rule collection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleCollection {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Defines the rule collection properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RuleCollectionPropertiesFormat>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl RuleCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security configuration rule collection list result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleCollectionListResult {
    #[doc = "A list of network manager security configuration rule collections"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RuleCollection>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RuleCollectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines the rule collection properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleCollectionPropertiesFormat {
    #[doc = "A display name of the rule collection."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the rule collection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Groups for configuration"]
    #[serde(rename = "appliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RuleCollectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network protocol this rule applies to."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RuleProtocol {
    Tcp,
    Udp,
    Icmp,
    Esp,
    Any,
    Ah,
}
#[doc = "Defines the security configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConfiguration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Defines the security Configuration properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityConfigurationPropertiesFormat>,
    #[doc = "Metadata pertaining to creation and last modification of the resource."]
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl SecurityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of network manager security configurations"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConfigurationListResult {
    #[doc = "Gets a page of security configurations"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityConfiguration>,
    #[doc = "Gets the URL to get the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Defines the security Configuration properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConfigurationPropertiesFormat {
    #[doc = "A display name of the security configuration."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description of the security configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Security Type."]
    #[serde(rename = "securityType", default, skip_serializing_if = "Option::is_none")]
    pub security_type: Option<security_configuration_properties_format::SecurityType>,
    #[doc = "Flag if need to delete existing network security groups."]
    #[serde(rename = "deleteExistingNSGs", default, skip_serializing_if = "Option::is_none")]
    pub delete_existing_ns_gs: Option<security_configuration_properties_format::DeleteExistingNsGs>,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl SecurityConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod security_configuration_properties_format {
    use super::*;
    #[doc = "Security Type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SecurityType {
        AdminPolicy,
        UserPolicy,
    }
    #[doc = "Flag if need to delete existing network security groups."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeleteExistingNsGs {
        False,
        True,
    }
}
#[doc = "Whether network traffic is allowed or denied."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityConfigurationRuleAccess {
    Allow,
    Deny,
    AlwaysAllow,
}
#[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityConfigurationRuleDirection {
    Inbound,
    Outbound,
}
#[doc = "Reference to another subresource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metadata pertaining to creation and last modification of the resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[doc = "The identity that created the resource."]
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[doc = "The type of identity that created the resource."]
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[doc = "The timestamp of resource creation (UTC)."]
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[doc = "The identity that last modified the resource."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[doc = "The type of identity that last modified the resource."]
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[doc = "The type of identity that created the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[doc = "The type of identity that last modified the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
#[doc = "Tags object for patch operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsObject {
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TagsObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network security user rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserRule {
    #[serde(flatten)]
    pub base_user_rule: BaseUserRule,
    #[doc = "Security rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserRulePropertiesFormat>,
}
impl UserRule {
    pub fn new(base_user_rule: BaseUserRule) -> Self {
        Self {
            base_user_rule,
            properties: None,
        }
    }
}
#[doc = "security user rule list result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserRuleListResult {
    #[doc = "A list of user rules"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BaseUserRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UserRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserRulePropertiesFormat {
    #[doc = "A friendly name for the rule."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "A description for this rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Network protocol this rule applies to."]
    pub protocol: RuleProtocol,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic."]
    pub direction: SecurityConfigurationRuleDirection,
    #[doc = "The current provisioning state."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl UserRulePropertiesFormat {
    pub fn new(protocol: RuleProtocol, direction: SecurityConfigurationRuleDirection) -> Self {
        Self {
            display_name: None,
            description: None,
            protocol,
            sources: Vec::new(),
            destinations: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            direction,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityGroupItem {
    #[doc = "Network group Id."]
    #[serde(rename = "networkGroupId", default, skip_serializing_if = "Option::is_none")]
    pub network_group_id: Option<String>,
    #[doc = "Flag if need to use hub gateway."]
    #[serde(rename = "useHubGateway", default, skip_serializing_if = "Option::is_none")]
    pub use_hub_gateway: Option<connectivity_group_item::UseHubGateway>,
    #[doc = "Flag if global is supported."]
    #[serde(rename = "isGlobal", default, skip_serializing_if = "Option::is_none")]
    pub is_global: Option<connectivity_group_item::IsGlobal>,
    #[doc = "Group connectivity type."]
    #[serde(rename = "groupConnectivity", default, skip_serializing_if = "Option::is_none")]
    pub group_connectivity: Option<connectivity_group_item::GroupConnectivity>,
}
impl ConnectivityGroupItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_group_item {
    use super::*;
    #[doc = "Flag if need to use hub gateway."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UseHubGateway {
        False,
        True,
    }
    #[doc = "Flag if global is supported."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IsGlobal {
        False,
        True,
    }
    #[doc = "Group connectivity type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GroupConnectivity {
        None,
        DirectlyConnected,
    }
}
#[doc = "GroupMembers Item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupMembersItem {
    #[doc = "Resource Id."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl GroupMembersItem {
    pub fn new() -> Self {
        Self::default()
    }
}
