#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressSpace {
    #[doc = "A list of address blocks reserved for this virtual network in CIDR notation."]
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
}
impl AddressSpace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Authentication certificates of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAuthenticationCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Authentication certificates properties of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayAuthenticationCertificatePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayAuthenticationCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Authentication certificates properties of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAuthenticationCertificatePropertiesFormat {
    #[doc = "Certificate public data."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[doc = "Provisioning state of the authentication certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayAuthenticationCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ApplicationGatewayAvailableSslOptions API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableSslOptions {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of ApplicationGatewayAvailableSslOptions"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayAvailableSslOptionsPropertiesFormat>,
}
impl ApplicationGatewayAvailableSslOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ApplicationGatewayAvailableSslOptions"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableSslOptionsPropertiesFormat {
    #[doc = "List of available Ssl predefined policy."]
    #[serde(rename = "predefinedPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub predefined_policies: Vec<SubResource>,
    #[doc = "Ssl predefined policy name enums."]
    #[serde(rename = "defaultPolicy", default, skip_serializing_if = "Option::is_none")]
    pub default_policy: Option<PolicyNameEnum>,
    #[doc = "List of available Ssl cipher suites."]
    #[serde(rename = "availableCipherSuites", default, skip_serializing_if = "Vec::is_empty")]
    pub available_cipher_suites: Vec<CipherSuitesEnum>,
    #[doc = "List of available Ssl protocols."]
    #[serde(rename = "availableProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub available_protocols: Vec<ProtocolsEnum>,
}
impl ApplicationGatewayAvailableSslOptionsPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ApplicationGatewayAvailableSslOptions API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableSslPredefinedPolicies {
    #[doc = "List of available Ssl predefined policy."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewaySslPredefinedPolicy>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayAvailableSslPredefinedPolicies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ApplicationGatewayAvailableWafRuleSets API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableWafRuleSetsResult {
    #[doc = "The list of application gateway rule sets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewayFirewallRuleSet>,
}
impl ApplicationGatewayAvailableWafRuleSetsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Backend address of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddress {
    #[doc = "Fully qualified domain name (FQDN)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "IP address"]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
}
impl ApplicationGatewayBackendAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Backend Address Pool of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Backend Address Pool of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayBackendAddressPoolPropertiesFormat>,
    #[doc = "Resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayBackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Backend Address Pool of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPoolPropertiesFormat {
    #[doc = "Collection of references to IPs defined in network interfaces."]
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "Backend addresses"]
    #[serde(rename = "backendAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_addresses: Vec<ApplicationGatewayBackendAddress>,
    #[doc = "Provisioning state of the backend address pool resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayBackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of ApplicationGatewayBackendHealthPool resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealth {
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<ApplicationGatewayBackendHealthPool>,
}
impl ApplicationGatewayBackendHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway BackendHealthHttp settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthHttpSettings {
    #[doc = "Backend address pool settings of an application gateway."]
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<ApplicationGatewayBackendHttpSettings>,
    #[doc = "List of ApplicationGatewayBackendHealthServer resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub servers: Vec<ApplicationGatewayBackendHealthServer>,
}
impl ApplicationGatewayBackendHealthHttpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway BackendHealth pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthPool {
    #[doc = "Backend Address Pool of an application gateway."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<ApplicationGatewayBackendAddressPool>,
    #[doc = "List of ApplicationGatewayBackendHealthHttpSettings resources."]
    #[serde(rename = "backendHttpSettingsCollection", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_http_settings_collection: Vec<ApplicationGatewayBackendHealthHttpSettings>,
}
impl ApplicationGatewayBackendHealthPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway backendhealth http settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthServer {
    #[doc = "IP address or FQDN of backend server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "IPConfiguration in a network interface."]
    #[serde(rename = "ipConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[doc = "Health of backend server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<application_gateway_backend_health_server::Health>,
}
impl ApplicationGatewayBackendHealthServer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_backend_health_server {
    use super::*;
    #[doc = "Health of backend server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        Unknown,
        Up,
        Down,
        Partial,
        Draining,
    }
}
#[doc = "Backend address pool settings of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHttpSettings {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Backend address pool settings of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayBackendHttpSettingsPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayBackendHttpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Backend address pool settings of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHttpSettingsPropertiesFormat {
    #[doc = "Port"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "Protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<application_gateway_backend_http_settings_properties_format::Protocol>,
    #[doc = "Cookie based affinity."]
    #[serde(rename = "cookieBasedAffinity", default, skip_serializing_if = "Option::is_none")]
    pub cookie_based_affinity: Option<application_gateway_backend_http_settings_properties_format::CookieBasedAffinity>,
    #[doc = "Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds."]
    #[serde(rename = "requestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub request_timeout: Option<i32>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub probe: Option<SubResource>,
    #[doc = "Array of references to application gateway authentication certificates."]
    #[serde(rename = "authenticationCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub authentication_certificates: Vec<SubResource>,
    #[doc = "Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration."]
    #[serde(rename = "connectionDraining", default, skip_serializing_if = "Option::is_none")]
    pub connection_draining: Option<ApplicationGatewayConnectionDraining>,
    #[doc = "Host header to be sent to the backend servers."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[doc = "Whether to pick host header should be picked from the host name of the backend server. Default value is false."]
    #[serde(rename = "pickHostNameFromBackendAddress", default, skip_serializing_if = "Option::is_none")]
    pub pick_host_name_from_backend_address: Option<bool>,
    #[doc = "Cookie name to use for the affinity cookie."]
    #[serde(rename = "affinityCookieName", default, skip_serializing_if = "Option::is_none")]
    pub affinity_cookie_name: Option<String>,
    #[doc = "Whether the probe is enabled. Default value is false."]
    #[serde(rename = "probeEnabled", default, skip_serializing_if = "Option::is_none")]
    pub probe_enabled: Option<bool>,
    #[doc = "Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayBackendHttpSettingsPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_backend_http_settings_properties_format {
    use super::*;
    #[doc = "Protocol."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Https,
    }
    #[doc = "Cookie based affinity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CookieBasedAffinity {
        Enabled,
        Disabled,
    }
}
#[doc = "Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayConnectionDraining {
    #[doc = "Whether connection draining is enabled or not."]
    pub enabled: bool,
    #[doc = "The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds."]
    #[serde(rename = "drainTimeoutInSec")]
    pub drain_timeout_in_sec: i32,
}
impl ApplicationGatewayConnectionDraining {
    pub fn new(enabled: bool, drain_timeout_in_sec: i32) -> Self {
        Self {
            enabled,
            drain_timeout_in_sec,
        }
    }
}
#[doc = "Allows to disable rules within a rule group or an entire rule group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallDisabledRuleGroup {
    #[doc = "The name of the rule group that will be disabled."]
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[doc = "The list of rules that will be disabled. If null, all rules of the rule group will be disabled."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<i32>,
}
impl ApplicationGatewayFirewallDisabledRuleGroup {
    pub fn new(rule_group_name: String) -> Self {
        Self {
            rule_group_name,
            rules: Vec::new(),
        }
    }
}
#[doc = "A web application firewall rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallRule {
    #[doc = "The identifier of the web application firewall rule."]
    #[serde(rename = "ruleId")]
    pub rule_id: i32,
    #[doc = "The description of the web application firewall rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ApplicationGatewayFirewallRule {
    pub fn new(rule_id: i32) -> Self {
        Self {
            rule_id,
            description: None,
        }
    }
}
#[doc = "A web application firewall rule group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallRuleGroup {
    #[doc = "The name of the web application firewall rule group."]
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[doc = "The description of the web application firewall rule group."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The rules of the web application firewall rule group."]
    pub rules: Vec<ApplicationGatewayFirewallRule>,
}
impl ApplicationGatewayFirewallRuleGroup {
    pub fn new(rule_group_name: String, rules: Vec<ApplicationGatewayFirewallRule>) -> Self {
        Self {
            rule_group_name,
            description: None,
            rules,
        }
    }
}
#[doc = "A web application firewall rule set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFirewallRuleSet {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the web application firewall rule set."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFirewallRuleSetPropertiesFormat>,
}
impl ApplicationGatewayFirewallRuleSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the web application firewall rule set."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallRuleSetPropertiesFormat {
    #[doc = "The provisioning state of the web application firewall rule set."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "The type of the web application firewall rule set."]
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[doc = "The version of the web application firewall rule set type."]
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[doc = "The rule groups of the web application firewall rule set."]
    #[serde(rename = "ruleGroups")]
    pub rule_groups: Vec<ApplicationGatewayFirewallRuleGroup>,
}
impl ApplicationGatewayFirewallRuleSetPropertiesFormat {
    pub fn new(rule_set_type: String, rule_set_version: String, rule_groups: Vec<ApplicationGatewayFirewallRuleGroup>) -> Self {
        Self {
            provisioning_state: None,
            rule_set_type,
            rule_set_version,
            rule_groups,
        }
    }
}
#[doc = "Frontend IP configuration of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Frontend IP configuration of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFrontendIpConfigurationPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayFrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Frontend IP configuration of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendIpConfigurationPropertiesFormat {
    #[doc = "PrivateIPAddress of the network interface IP Configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "PrivateIP allocation method."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<application_gateway_frontend_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[doc = "Provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayFrontendIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_frontend_ip_configuration_properties_format {
    use super::*;
    #[doc = "PrivateIP allocation method."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[doc = "Frontend port of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendPort {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Frontend port of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFrontendPortPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayFrontendPort {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Frontend port of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendPortPropertiesFormat {
    #[doc = "Frontend port"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "Provisioning state of the frontend port resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayFrontendPortPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Http listener of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHttpListener {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of HTTP listener of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayHttpListenerPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayHttpListener {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of HTTP listener of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHttpListenerPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<SubResource>,
    #[doc = "Protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<application_gateway_http_listener_properties_format::Protocol>,
    #[doc = "Host name of HTTP listener."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "sslCertificate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_certificate: Option<SubResource>,
    #[doc = "Applicable only if protocol is https. Enables SNI for multi-hosting."]
    #[serde(rename = "requireServerNameIndication", default, skip_serializing_if = "Option::is_none")]
    pub require_server_name_indication: Option<bool>,
    #[doc = "Provisioning state of the HTTP listener resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayHttpListenerPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_http_listener_properties_format {
    use super::*;
    #[doc = "Protocol."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Https,
    }
}
#[doc = "IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayIpConfigurationPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayIpConfigurationPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Provisioning state of the application gateway subnet resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListApplicationGateways API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayListResult {
    #[doc = "List of an application gateways in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGateway>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Path rule of URL path map of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPathRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of path rule of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPathRulePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPathRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of path rule of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPathRulePropertiesFormat {
    #[doc = "Path rules of URL path map."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub paths: Vec<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "redirectConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub redirect_configuration: Option<SubResource>,
    #[doc = "Path rule of URL path map resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayPathRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Probe of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbe {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of probe of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayProbePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayProbe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway probe health response match"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbeHealthResponseMatch {
    #[doc = "Body that must be contained in the health response. Default value is empty."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    #[doc = "Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399."]
    #[serde(rename = "statusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub status_codes: Vec<String>,
}
impl ApplicationGatewayProbeHealthResponseMatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of probe of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbePropertiesFormat {
    #[doc = "Protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<application_gateway_probe_properties_format::Protocol>,
    #[doc = "Host name to send the probe to."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[doc = "Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[doc = "the probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20."]
    #[serde(rename = "unhealthyThreshold", default, skip_serializing_if = "Option::is_none")]
    pub unhealthy_threshold: Option<i32>,
    #[doc = "Whether the host header should be picked from the backend http settings. Default value is false."]
    #[serde(rename = "pickHostNameFromBackendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub pick_host_name_from_backend_http_settings: Option<bool>,
    #[doc = "Minimum number of servers that are always marked healthy. Default value is 0."]
    #[serde(rename = "minServers", default, skip_serializing_if = "Option::is_none")]
    pub min_servers: Option<i32>,
    #[doc = "Application gateway probe health response match"]
    #[serde(rename = "match", default, skip_serializing_if = "Option::is_none")]
    pub match_: Option<ApplicationGatewayProbeHealthResponseMatch>,
    #[doc = "Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayProbePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_probe_properties_format {
    use super::*;
    #[doc = "Protocol."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Https,
    }
}
#[doc = "Properties of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPropertiesFormat {
    #[doc = "SKU of an application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ApplicationGatewaySku>,
    #[doc = "Application Gateway Ssl policy."]
    #[serde(rename = "sslPolicy", default, skip_serializing_if = "Option::is_none")]
    pub ssl_policy: Option<ApplicationGatewaySslPolicy>,
    #[doc = "Operational state of the application gateway resource."]
    #[serde(rename = "operationalState", default, skip_serializing_if = "Option::is_none")]
    pub operational_state: Option<application_gateway_properties_format::OperationalState>,
    #[doc = "Subnets of application the gateway resource."]
    #[serde(rename = "gatewayIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub gateway_ip_configurations: Vec<ApplicationGatewayIpConfiguration>,
    #[doc = "Authentication certificates of the application gateway resource."]
    #[serde(rename = "authenticationCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub authentication_certificates: Vec<ApplicationGatewayAuthenticationCertificate>,
    #[doc = "SSL certificates of the application gateway resource."]
    #[serde(rename = "sslCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub ssl_certificates: Vec<ApplicationGatewaySslCertificate>,
    #[doc = "Frontend IP addresses of the application gateway resource."]
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<ApplicationGatewayFrontendIpConfiguration>,
    #[doc = "Frontend ports of the application gateway resource."]
    #[serde(rename = "frontendPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ports: Vec<ApplicationGatewayFrontendPort>,
    #[doc = "Probes of the application gateway resource."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub probes: Vec<ApplicationGatewayProbe>,
    #[doc = "Backend address pool of the application gateway resource."]
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<ApplicationGatewayBackendAddressPool>,
    #[doc = "Backend http settings of the application gateway resource."]
    #[serde(rename = "backendHttpSettingsCollection", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_http_settings_collection: Vec<ApplicationGatewayBackendHttpSettings>,
    #[doc = "Http listeners of the application gateway resource."]
    #[serde(rename = "httpListeners", default, skip_serializing_if = "Vec::is_empty")]
    pub http_listeners: Vec<ApplicationGatewayHttpListener>,
    #[doc = "URL path map of the application gateway resource."]
    #[serde(rename = "urlPathMaps", default, skip_serializing_if = "Vec::is_empty")]
    pub url_path_maps: Vec<ApplicationGatewayUrlPathMap>,
    #[doc = "Request routing rules of the application gateway resource."]
    #[serde(rename = "requestRoutingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub request_routing_rules: Vec<ApplicationGatewayRequestRoutingRule>,
    #[doc = "Redirect configurations of the application gateway resource."]
    #[serde(rename = "redirectConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub redirect_configurations: Vec<ApplicationGatewayRedirectConfiguration>,
    #[doc = "Application gateway web application firewall configuration."]
    #[serde(rename = "webApplicationFirewallConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub web_application_firewall_configuration: Option<ApplicationGatewayWebApplicationFirewallConfiguration>,
    #[doc = "Whether HTTP2 is enabled on the application gateway resource."]
    #[serde(rename = "enableHttp2", default, skip_serializing_if = "Option::is_none")]
    pub enable_http2: Option<bool>,
    #[doc = "Resource GUID property of the application gateway resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Provisioning state of the application gateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_properties_format {
    use super::*;
    #[doc = "Operational state of the application gateway resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationalState {
        Stopped,
        Starting,
        Running,
        Stopping,
    }
}
#[doc = "Redirect configuration of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRedirectConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of redirect configuration of the application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayRedirectConfigurationPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayRedirectConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of redirect configuration of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRedirectConfigurationPropertiesFormat {
    #[serde(rename = "redirectType", default, skip_serializing_if = "Option::is_none")]
    pub redirect_type: Option<RedirectTypeEnum>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "targetListener", default, skip_serializing_if = "Option::is_none")]
    pub target_listener: Option<SubResource>,
    #[doc = "Url to redirect the request to."]
    #[serde(rename = "targetUrl", default, skip_serializing_if = "Option::is_none")]
    pub target_url: Option<String>,
    #[doc = "Include path in the redirected url."]
    #[serde(rename = "includePath", default, skip_serializing_if = "Option::is_none")]
    pub include_path: Option<bool>,
    #[doc = "Include query string in the redirected url."]
    #[serde(rename = "includeQueryString", default, skip_serializing_if = "Option::is_none")]
    pub include_query_string: Option<bool>,
    #[doc = "Request routing specifying redirect configuration."]
    #[serde(rename = "requestRoutingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub request_routing_rules: Vec<SubResource>,
    #[doc = "Url path maps specifying default redirect configuration."]
    #[serde(rename = "urlPathMaps", default, skip_serializing_if = "Vec::is_empty")]
    pub url_path_maps: Vec<SubResource>,
    #[doc = "Path rules specifying redirect configuration."]
    #[serde(rename = "pathRules", default, skip_serializing_if = "Vec::is_empty")]
    pub path_rules: Vec<SubResource>,
}
impl ApplicationGatewayRedirectConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request routing rule of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRequestRoutingRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of request routing rule of the application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayRequestRoutingRulePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayRequestRoutingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of request routing rule of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRequestRoutingRulePropertiesFormat {
    #[doc = "Rule type."]
    #[serde(rename = "ruleType", default, skip_serializing_if = "Option::is_none")]
    pub rule_type: Option<application_gateway_request_routing_rule_properties_format::RuleType>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "httpListener", default, skip_serializing_if = "Option::is_none")]
    pub http_listener: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "urlPathMap", default, skip_serializing_if = "Option::is_none")]
    pub url_path_map: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "redirectConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub redirect_configuration: Option<SubResource>,
    #[doc = "Provisioning state of the request routing rule resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayRequestRoutingRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_request_routing_rule_properties_format {
    use super::*;
    #[doc = "Rule type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleType {
        Basic,
        PathBasedRouting,
    }
}
#[doc = "SKU of an application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySku {
    #[doc = "Name of an application gateway SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<application_gateway_sku::Name>,
    #[doc = "Tier of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<application_gateway_sku::Tier>,
    #[doc = "Capacity (instance count) of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl ApplicationGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_sku {
    use super::*;
    #[doc = "Name of an application gateway SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "Standard_Small")]
        StandardSmall,
        #[serde(rename = "Standard_Medium")]
        StandardMedium,
        #[serde(rename = "Standard_Large")]
        StandardLarge,
        #[serde(rename = "WAF_Medium")]
        WafMedium,
        #[serde(rename = "WAF_Large")]
        WafLarge,
    }
    #[doc = "Tier of an application gateway."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        #[serde(rename = "WAF")]
        Waf,
    }
}
#[doc = "SSL certificates of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of SSL certificates of an application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewaySslCertificatePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewaySslCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of SSL certificates of an application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslCertificatePropertiesFormat {
    #[doc = "Base-64 encoded pfx certificate. Only applicable in PUT Request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[doc = "Password for the pfx file specified in data. Only applicable in PUT request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[doc = "Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request."]
    #[serde(rename = "publicCertData", default, skip_serializing_if = "Option::is_none")]
    pub public_cert_data: Option<String>,
    #[doc = "Provisioning state of the SSL certificate resource Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewaySslCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application Gateway Ssl policy."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPolicy {
    #[doc = "Ssl protocols to be disabled on application gateway."]
    #[serde(rename = "disabledSslProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub disabled_ssl_protocols: Vec<ProtocolsEnum>,
    #[doc = "Type of Ssl Policy"]
    #[serde(rename = "policyType", default, skip_serializing_if = "Option::is_none")]
    pub policy_type: Option<application_gateway_ssl_policy::PolicyType>,
    #[doc = "Ssl predefined policy name enums."]
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<PolicyNameEnum>,
    #[doc = "Ssl cipher suites to be enabled in the specified order to application gateway."]
    #[serde(rename = "cipherSuites", default, skip_serializing_if = "Vec::is_empty")]
    pub cipher_suites: Vec<CipherSuitesEnum>,
    #[doc = "Ssl protocol enums."]
    #[serde(rename = "minProtocolVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_protocol_version: Option<ProtocolsEnum>,
}
impl ApplicationGatewaySslPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_ssl_policy {
    use super::*;
    #[doc = "Type of Ssl Policy"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PolicyType {
        Predefined,
        Custom,
    }
}
#[doc = "An Ssl predefined policy"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPredefinedPolicy {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Name of Ssl predefined policy."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Properties of ApplicationGatewaySslPredefinedPolicy"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewaySslPredefinedPolicyPropertiesFormat>,
}
impl ApplicationGatewaySslPredefinedPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ApplicationGatewaySslPredefinedPolicy"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPredefinedPolicyPropertiesFormat {
    #[doc = "Ssl cipher suites to be enabled in the specified order for application gateway."]
    #[serde(rename = "cipherSuites", default, skip_serializing_if = "Vec::is_empty")]
    pub cipher_suites: Vec<CipherSuitesEnum>,
    #[doc = "Ssl protocol enums."]
    #[serde(rename = "minProtocolVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_protocol_version: Option<ProtocolsEnum>,
}
impl ApplicationGatewaySslPredefinedPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "UrlPathMaps give a url path to the backend mapping information for PathBasedRouting."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlPathMap {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of UrlPathMap of the application gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayUrlPathMapPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Type of the resource."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayUrlPathMap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of UrlPathMap of the application gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlPathMapPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "defaultBackendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub default_backend_address_pool: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "defaultBackendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub default_backend_http_settings: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "defaultRedirectConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub default_redirect_configuration: Option<SubResource>,
    #[doc = "Path rule of URL path map resource."]
    #[serde(rename = "pathRules", default, skip_serializing_if = "Vec::is_empty")]
    pub path_rules: Vec<ApplicationGatewayPathRule>,
    #[doc = "Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayUrlPathMapPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway web application firewall configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayWebApplicationFirewallConfiguration {
    #[doc = "Whether the web application firewall is enabled or not."]
    pub enabled: bool,
    #[doc = "Web application firewall mode."]
    #[serde(rename = "firewallMode")]
    pub firewall_mode: application_gateway_web_application_firewall_configuration::FirewallMode,
    #[doc = "The type of the web application firewall rule set. Possible values are: 'OWASP'."]
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[doc = "The version of the rule set type."]
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[doc = "The disabled rule groups."]
    #[serde(rename = "disabledRuleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub disabled_rule_groups: Vec<ApplicationGatewayFirewallDisabledRuleGroup>,
    #[doc = "Whether allow WAF to check request Body."]
    #[serde(rename = "requestBodyCheck", default, skip_serializing_if = "Option::is_none")]
    pub request_body_check: Option<bool>,
    #[doc = "Maximum request body size for WAF."]
    #[serde(rename = "maxRequestBodySize", default, skip_serializing_if = "Option::is_none")]
    pub max_request_body_size: Option<i32>,
}
impl ApplicationGatewayWebApplicationFirewallConfiguration {
    pub fn new(
        enabled: bool,
        firewall_mode: application_gateway_web_application_firewall_configuration::FirewallMode,
        rule_set_type: String,
        rule_set_version: String,
    ) -> Self {
        Self {
            enabled,
            firewall_mode,
            rule_set_type,
            rule_set_version,
            disabled_rule_groups: Vec::new(),
            request_body_check: None,
            max_request_body_size: None,
        }
    }
}
pub mod application_gateway_web_application_firewall_configuration {
    use super::*;
    #[doc = "Web application firewall mode."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirewallMode {
        Detection,
        Prevention,
    }
}
#[doc = "An application security group in a resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Application security group properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationSecurityGroupPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of application security groups."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroupListResult {
    #[doc = "A list of application security groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationSecurityGroup>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application security group properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroupPropertiesFormat {
    #[doc = "The resource GUID property of the application security group resource. It uniquely identifies a resource, even if the user changes its name or migrate the resource across subscriptions or resource groups."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the application security group resource. Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationSecurityGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListAuthorizations API service call retrieves all authorizations that belongs to an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationListResult {
    #[doc = "The authorizations in an ExpressRoute Circuit."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitAuthorization>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AuthorizationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationPropertiesFormat {
    #[doc = "The authorization key."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "AuthorizationUseStatus. Possible values are: 'Available' and 'InUse'."]
    #[serde(rename = "authorizationUseStatus", default, skip_serializing_if = "Option::is_none")]
    pub authorization_use_status: Option<authorization_properties_format::AuthorizationUseStatus>,
    #[doc = "Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl AuthorizationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod authorization_properties_format {
    use super::*;
    #[doc = "AuthorizationUseStatus. Possible values are: 'Available' and 'InUse'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthorizationUseStatus {
        Available,
        InUse,
    }
}
#[doc = "Availability of the metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Availability {
    #[doc = "The time grain of the availability."]
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[doc = "The retention of the availability."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
    #[doc = "Duration of the availability blob."]
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl Availability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of available countries with details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailableProvidersList {
    #[doc = "List of available countries."]
    pub countries: Vec<AvailableProvidersListCountry>,
}
impl AvailableProvidersList {
    pub fn new(countries: Vec<AvailableProvidersListCountry>) -> Self {
        Self { countries }
    }
}
#[doc = "City or town details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListCity {
    #[doc = "The city or town name."]
    #[serde(rename = "cityName", default, skip_serializing_if = "Option::is_none")]
    pub city_name: Option<String>,
    #[doc = "A list of Internet service providers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
}
impl AvailableProvidersListCity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Country details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListCountry {
    #[doc = "The country name."]
    #[serde(rename = "countryName", default, skip_serializing_if = "Option::is_none")]
    pub country_name: Option<String>,
    #[doc = "A list of Internet service providers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
    #[doc = "List of available states in the country."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub states: Vec<AvailableProvidersListState>,
}
impl AvailableProvidersListCountry {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Constraints that determine the list of available Internet service providers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListParameters {
    #[doc = "A list of Azure regions."]
    #[serde(rename = "azureLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_locations: Vec<String>,
    #[doc = "The country for available providers list."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[doc = "The state for available providers list."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The city or town for available providers list."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
}
impl AvailableProvidersListParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "State details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListState {
    #[doc = "The state name."]
    #[serde(rename = "stateName", default, skip_serializing_if = "Option::is_none")]
    pub state_name: Option<String>,
    #[doc = "A list of Internet service providers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
    #[doc = "List of available cities or towns in the state."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub cities: Vec<AvailableProvidersListCity>,
}
impl AvailableProvidersListState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureAsyncOperationResult {
    #[doc = "Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and 'Failed'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<azure_async_operation_result::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Error>,
}
impl AzureAsyncOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_async_operation_result {
    use super::*;
    #[doc = "Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and 'Failed'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Succeeded,
        Failed,
    }
}
#[doc = "Azure reachability report details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureReachabilityReport {
    #[doc = "The aggregation level of Azure reachability report. Can be Country, State or City."]
    #[serde(rename = "aggregationLevel")]
    pub aggregation_level: String,
    #[doc = "Parameters that define a geographic location."]
    #[serde(rename = "providerLocation")]
    pub provider_location: AzureReachabilityReportLocation,
    #[doc = "List of Azure reachability report items."]
    #[serde(rename = "reachabilityReport")]
    pub reachability_report: Vec<AzureReachabilityReportItem>,
}
impl AzureReachabilityReport {
    pub fn new(
        aggregation_level: String,
        provider_location: AzureReachabilityReportLocation,
        reachability_report: Vec<AzureReachabilityReportItem>,
    ) -> Self {
        Self {
            aggregation_level,
            provider_location,
            reachability_report,
        }
    }
}
#[doc = "Azure reachability report details for a given provider location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureReachabilityReportItem {
    #[doc = "The Internet service provider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "The Azure region."]
    #[serde(rename = "azureLocation", default, skip_serializing_if = "Option::is_none")]
    pub azure_location: Option<String>,
    #[doc = "List of latency details for each of the time series."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub latencies: Vec<AzureReachabilityReportLatencyInfo>,
}
impl AzureReachabilityReportItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Details on latency for a time series."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureReachabilityReportLatencyInfo {
    #[doc = "The time stamp."]
    #[serde(rename = "timeStamp", default, skip_serializing_if = "Option::is_none")]
    pub time_stamp: Option<String>,
    #[doc = "The relative latency score between 1 and 100, higher values indicating a faster connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub score: Option<i64>,
}
impl AzureReachabilityReportLatencyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define a geographic location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureReachabilityReportLocation {
    #[doc = "The name of the country."]
    pub country: String,
    #[doc = "The name of the state."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The name of the city or town."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
}
impl AzureReachabilityReportLocation {
    pub fn new(country: String) -> Self {
        Self {
            country,
            state: None,
            city: None,
        }
    }
}
#[doc = "Geographic and time constraints for Azure reachability report."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureReachabilityReportParameters {
    #[doc = "Parameters that define a geographic location."]
    #[serde(rename = "providerLocation")]
    pub provider_location: AzureReachabilityReportLocation,
    #[doc = "List of Internet service providers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
    #[doc = "Optional Azure regions to scope the query to."]
    #[serde(rename = "azureLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_locations: Vec<String>,
    #[doc = "The start time for the Azure reachability report."]
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[doc = "The end time for the Azure reachability report."]
    #[serde(rename = "endTime")]
    pub end_time: String,
}
impl AzureReachabilityReportParameters {
    pub fn new(provider_location: AzureReachabilityReportLocation, start_time: String, end_time: String) -> Self {
        Self {
            provider_location,
            providers: Vec::new(),
            azure_locations: Vec::new(),
            start_time,
            end_time,
        }
    }
}
#[doc = "Contains bgp community information offered in Service Community resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpCommunity {
    #[doc = "The region which the service support. e.g. For O365, region is Global."]
    #[serde(rename = "serviceSupportedRegion", default, skip_serializing_if = "Option::is_none")]
    pub service_supported_region: Option<String>,
    #[doc = "The name of the bgp community. e.g. Skype."]
    #[serde(rename = "communityName", default, skip_serializing_if = "Option::is_none")]
    pub community_name: Option<String>,
    #[doc = "The value of the bgp community. For more information: https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing."]
    #[serde(rename = "communityValue", default, skip_serializing_if = "Option::is_none")]
    pub community_value: Option<String>,
    #[doc = "The prefixes that the bgp community contains."]
    #[serde(rename = "communityPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub community_prefixes: Vec<String>,
    #[doc = "Customer is authorized to use bgp community or not."]
    #[serde(rename = "isAuthorizedToUse", default, skip_serializing_if = "Option::is_none")]
    pub is_authorized_to_use: Option<bool>,
    #[doc = "The service group of the bgp community contains."]
    #[serde(rename = "serviceGroup", default, skip_serializing_if = "Option::is_none")]
    pub service_group: Option<String>,
}
impl BgpCommunity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Pool of backend IP addresses."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the backend address pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackendAddressPoolPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl BackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the backend address pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPoolPropertiesFormat {
    #[doc = "Gets collection of references to IP addresses defined in network interfaces."]
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "Gets load balancing rules that use this backend address pool."]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "outboundNatRule", default, skip_serializing_if = "Option::is_none")]
    pub outbound_nat_rule: Option<SubResource>,
    #[doc = "Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl BackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "BGP peer status details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpPeerStatus {
    #[doc = "The virtual network gateway's local address"]
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[doc = "The remote BGP peer"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[doc = "The autonomous system number of the remote BGP peer"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i32>,
    #[doc = "The BGP peer state"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<bgp_peer_status::State>,
    #[doc = "For how long the peering has been up"]
    #[serde(rename = "connectedDuration", default, skip_serializing_if = "Option::is_none")]
    pub connected_duration: Option<String>,
    #[doc = "The number of routes learned from this peer"]
    #[serde(rename = "routesReceived", default, skip_serializing_if = "Option::is_none")]
    pub routes_received: Option<i64>,
    #[doc = "The number of BGP messages sent"]
    #[serde(rename = "messagesSent", default, skip_serializing_if = "Option::is_none")]
    pub messages_sent: Option<i64>,
    #[doc = "The number of BGP messages received"]
    #[serde(rename = "messagesReceived", default, skip_serializing_if = "Option::is_none")]
    pub messages_received: Option<i64>,
}
impl BgpPeerStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bgp_peer_status {
    use super::*;
    #[doc = "The BGP peer state"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Unknown,
        Stopped,
        Idle,
        Connecting,
        Connected,
    }
}
#[doc = "Response for list BGP peer status API service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpPeerStatusListResult {
    #[doc = "List of BGP peers"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BgpPeerStatus>,
}
impl BgpPeerStatusListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Service Community Properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpServiceCommunity {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of Service Community."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BgpServiceCommunityPropertiesFormat>,
}
impl BgpServiceCommunity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListServiceCommunity API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpServiceCommunityListResult {
    #[doc = "A list of service community resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BgpServiceCommunity>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BgpServiceCommunityListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Service Community."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpServiceCommunityPropertiesFormat {
    #[doc = "The name of the bgp community. e.g. Skype."]
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[doc = "Get a list of bgp communities."]
    #[serde(rename = "bgpCommunities", default, skip_serializing_if = "Vec::is_empty")]
    pub bgp_communities: Vec<BgpCommunity>,
}
impl BgpServiceCommunityPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "BGP settings details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpSettings {
    #[doc = "The BGP speaker's ASN."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i64>,
    #[doc = "The BGP peering address and BGP identifier of this BGP speaker."]
    #[serde(rename = "bgpPeeringAddress", default, skip_serializing_if = "Option::is_none")]
    pub bgp_peering_address: Option<String>,
    #[doc = "The weight added to routes learned from this BGP speaker."]
    #[serde(rename = "peerWeight", default, skip_serializing_if = "Option::is_none")]
    pub peer_weight: Option<i32>,
}
impl BgpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Ssl cipher suites enums."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CipherSuitesEnum {
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384")]
    TlsEcdheRsaWithAes256CbcSha384,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256")]
    TlsEcdheRsaWithAes128CbcSha256,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA")]
    TlsEcdheRsaWithAes256CbcSha,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA")]
    TlsEcdheRsaWithAes128CbcSha,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384")]
    TlsDheRsaWithAes256GcmSha384,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256")]
    TlsDheRsaWithAes128GcmSha256,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_256_CBC_SHA")]
    TlsDheRsaWithAes256CbcSha,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA")]
    TlsDheRsaWithAes128CbcSha,
    #[serde(rename = "TLS_RSA_WITH_AES_256_GCM_SHA384")]
    TlsRsaWithAes256GcmSha384,
    #[serde(rename = "TLS_RSA_WITH_AES_128_GCM_SHA256")]
    TlsRsaWithAes128GcmSha256,
    #[serde(rename = "TLS_RSA_WITH_AES_256_CBC_SHA256")]
    TlsRsaWithAes256CbcSha256,
    #[serde(rename = "TLS_RSA_WITH_AES_128_CBC_SHA256")]
    TlsRsaWithAes128CbcSha256,
    #[serde(rename = "TLS_RSA_WITH_AES_256_CBC_SHA")]
    TlsRsaWithAes256CbcSha,
    #[serde(rename = "TLS_RSA_WITH_AES_128_CBC_SHA")]
    TlsRsaWithAes128CbcSha,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384")]
    TlsEcdheEcdsaWithAes256GcmSha384,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256")]
    TlsEcdheEcdsaWithAes128GcmSha256,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384")]
    TlsEcdheEcdsaWithAes256CbcSha384,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256")]
    TlsEcdheEcdsaWithAes128CbcSha256,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA")]
    TlsEcdheEcdsaWithAes256CbcSha,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA")]
    TlsEcdheEcdsaWithAes128CbcSha,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256")]
    TlsDheDssWithAes256CbcSha256,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256")]
    TlsDheDssWithAes128CbcSha256,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA")]
    TlsDheDssWithAes256CbcSha,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA")]
    TlsDheDssWithAes128CbcSha,
    #[serde(rename = "TLS_RSA_WITH_3DES_EDE_CBC_SHA")]
    TlsRsaWith3desEdeCbcSha,
    #[serde(rename = "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA")]
    TlsDheDssWith3desEdeCbcSha,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256")]
    TlsEcdheRsaWithAes128GcmSha256,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384")]
    TlsEcdheRsaWithAes256GcmSha384,
}
#[doc = "Parameters that define the operation to create a connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitor {
    #[doc = "Connection monitor location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Connection monitor tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Parameters that define the operation to create a connection monitor."]
    pub properties: ConnectionMonitorParameters,
}
impl ConnectionMonitor {
    pub fn new(properties: ConnectionMonitorParameters) -> Self {
        Self {
            location: None,
            tags: None,
            properties,
        }
    }
}
#[doc = "Describes the destination of connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorDestination {
    #[doc = "The ID of the resource used as the destination by connection monitor."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "Address of the connection monitor destination (IP or domain name)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "The destination port used by connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
}
impl ConnectionMonitorDestination {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of connection monitors."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorListResult {
    #[doc = "Information about connection monitors."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConnectionMonitorResult>,
}
impl ConnectionMonitorListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the operation to create a connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorParameters {
    #[doc = "Describes the source of connection monitor."]
    pub source: ConnectionMonitorSource,
    #[doc = "Describes the destination of connection monitor."]
    pub destination: ConnectionMonitorDestination,
    #[doc = "Determines if the connection monitor will start automatically once created."]
    #[serde(rename = "autoStart", default, skip_serializing_if = "Option::is_none")]
    pub auto_start: Option<bool>,
    #[doc = "Monitoring interval in seconds."]
    #[serde(rename = "monitoringIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_interval_in_seconds: Option<i64>,
}
impl ConnectionMonitorParameters {
    pub fn new(source: ConnectionMonitorSource, destination: ConnectionMonitorDestination) -> Self {
        Self {
            source,
            destination,
            auto_start: None,
            monitoring_interval_in_seconds: None,
        }
    }
}
#[doc = "List of connection states snapshots."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorQueryResult {
    #[doc = "Status of connection monitor source."]
    #[serde(rename = "sourceStatus", default, skip_serializing_if = "Option::is_none")]
    pub source_status: Option<connection_monitor_query_result::SourceStatus>,
    #[doc = "Information about connection states."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub states: Vec<ConnectionStateSnapshot>,
}
impl ConnectionMonitorQueryResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_query_result {
    use super::*;
    #[doc = "Status of connection monitor source."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceStatus {
        Uknown,
        Active,
        Inactive,
    }
}
#[doc = "Information about the connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorResult {
    #[doc = "Name of the connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "ID of the connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Connection monitor type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Connection monitor location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Connection monitor tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Describes the properties of a connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectionMonitorResultProperties>,
}
impl ConnectionMonitorResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorResultProperties {
    #[serde(flatten)]
    pub connection_monitor_parameters: ConnectionMonitorParameters,
    #[doc = "The provisioning state of the connection monitor."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<connection_monitor_result_properties::ProvisioningState>,
    #[doc = "The date and time when the connection monitor was started."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The monitoring status of the connection monitor."]
    #[serde(rename = "monitoringStatus", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_status: Option<String>,
}
impl ConnectionMonitorResultProperties {
    pub fn new(connection_monitor_parameters: ConnectionMonitorParameters) -> Self {
        Self {
            connection_monitor_parameters,
            provisioning_state: None,
            start_time: None,
            monitoring_status: None,
        }
    }
}
pub mod connection_monitor_result_properties {
    use super::*;
    #[doc = "The provisioning state of the connection monitor."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Updating,
        Deleting,
        Failed,
    }
}
#[doc = "Describes the source of connection monitor."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorSource {
    #[doc = "The ID of the resource used as the source by connection monitor."]
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[doc = "The source port used by connection monitor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
}
impl ConnectionMonitorSource {
    pub fn new(resource_id: String) -> Self {
        Self { resource_id, port: None }
    }
}
#[doc = "The virtual network connection reset shared key"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionResetSharedKey {
    #[doc = "The virtual network connection reset shared key length, should between 1 and 128."]
    #[serde(rename = "keyLength")]
    pub key_length: i32,
}
impl ConnectionResetSharedKey {
    pub fn new(key_length: i32) -> Self {
        Self { key_length }
    }
}
#[doc = "Response for GetConnectionSharedKey API service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionSharedKey {
    #[doc = "The virtual network connection shared key value."]
    pub value: String,
}
impl ConnectionSharedKey {
    pub fn new(value: String) -> Self {
        Self { value }
    }
}
#[doc = "Connection state snapshot."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionStateSnapshot {
    #[doc = "The connection state."]
    #[serde(rename = "connectionState", default, skip_serializing_if = "Option::is_none")]
    pub connection_state: Option<connection_state_snapshot::ConnectionState>,
    #[doc = "The start time of the connection snapshot."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time of the connection snapshot."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "Connectivity analysis evaluation state."]
    #[serde(rename = "evaluationState", default, skip_serializing_if = "Option::is_none")]
    pub evaluation_state: Option<connection_state_snapshot::EvaluationState>,
    #[doc = "List of hops between the source and the destination."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hops: Vec<ConnectivityHop>,
}
impl ConnectionStateSnapshot {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_state_snapshot {
    use super::*;
    #[doc = "The connection state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionState {
        Reachable,
        Unreachable,
        Unknown,
    }
    #[doc = "Connectivity analysis evaluation state."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EvaluationState {
        NotStarted,
        InProgress,
        Completed,
    }
}
#[doc = "Parameters that define destination of connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityDestination {
    #[doc = "The ID of the resource to which a connection attempt will be made."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "The IP address or URI the resource to which a connection attempt will be made."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "Port on which check connectivity will be performed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
}
impl ConnectivityDestination {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information about a hop between the source and the destination."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityHop {
    #[doc = "The type of the hop."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The ID of the hop."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The IP address of the hop."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[doc = "The ID of the resource corresponding to this hop."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "List of next hop identifiers."]
    #[serde(rename = "nextHopIds", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hop_ids: Vec<String>,
    #[doc = "List of issues."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub issues: Vec<ConnectivityIssue>,
}
impl ConnectivityHop {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information on the connectivity status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityInformation {
    #[doc = "List of hops between the source and the destination."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hops: Vec<ConnectivityHop>,
    #[doc = "The connection status."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<connectivity_information::ConnectionStatus>,
    #[doc = "Average latency in milliseconds."]
    #[serde(rename = "avgLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub avg_latency_in_ms: Option<i64>,
    #[doc = "Minimum latency in milliseconds."]
    #[serde(rename = "minLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub min_latency_in_ms: Option<i64>,
    #[doc = "Maximum latency in milliseconds."]
    #[serde(rename = "maxLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub max_latency_in_ms: Option<i64>,
    #[doc = "Total number of probes sent."]
    #[serde(rename = "probesSent", default, skip_serializing_if = "Option::is_none")]
    pub probes_sent: Option<i64>,
    #[doc = "Number of failed probes."]
    #[serde(rename = "probesFailed", default, skip_serializing_if = "Option::is_none")]
    pub probes_failed: Option<i64>,
}
impl ConnectivityInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_information {
    use super::*;
    #[doc = "The connection status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connected,
        Disconnected,
        Degraded,
    }
}
#[doc = "Information about an issue encountered in the process of checking for connectivity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityIssue {
    #[doc = "The origin of the issue."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<connectivity_issue::Origin>,
    #[doc = "The severity of the issue."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<connectivity_issue::Severity>,
    #[doc = "The type of issue."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connectivity_issue::Type>,
    #[doc = "Provides additional context on the issue."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub context: Vec<IssueContext>,
}
impl ConnectivityIssue {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_issue {
    use super::*;
    #[doc = "The origin of the issue."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Origin {
        Local,
        Inbound,
        Outbound,
    }
    #[doc = "The severity of the issue."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Error,
        Warning,
    }
    #[doc = "The type of issue."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Unknown,
        AgentStopped,
        GuestFirewall,
        DnsResolution,
        SocketBind,
        NetworkSecurityRule,
        UserDefinedRoute,
        PortThrottled,
        Platform,
    }
}
#[doc = "Parameters that determine how the connectivity check will be performed."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivityParameters {
    #[doc = "Parameters that define the source of the connection."]
    pub source: ConnectivitySource,
    #[doc = "Parameters that define destination of connection."]
    pub destination: ConnectivityDestination,
    #[doc = "Network protocol."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<connectivity_parameters::Protocol>,
    #[doc = "Configuration of the protocol."]
    #[serde(rename = "protocolConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub protocol_configuration: Option<ProtocolConfiguration>,
}
impl ConnectivityParameters {
    pub fn new(source: ConnectivitySource, destination: ConnectivityDestination) -> Self {
        Self {
            source,
            destination,
            protocol: None,
            protocol_configuration: None,
        }
    }
}
pub mod connectivity_parameters {
    use super::*;
    #[doc = "Network protocol."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Http,
        Https,
        Icmp,
    }
}
#[doc = "Parameters that define the source of the connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivitySource {
    #[doc = "The ID of the resource from which a connectivity check will be initiated."]
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[doc = "The source port from which a connectivity check will be performed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
}
impl ConnectivitySource {
    pub fn new(resource_id: String) -> Self {
        Self { resource_id, port: None }
    }
}
#[doc = "A DDoS protection plan in a resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosProtectionPlan {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "DDoS protection plan properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DdosProtectionPlanPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl DdosProtectionPlan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of DDoS protection plans."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosProtectionPlanListResult {
    #[doc = "A list of DDoS protection plans."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DdosProtectionPlan>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DdosProtectionPlanListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DDoS protection plan properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosProtectionPlanPropertiesFormat {
    #[doc = "The resource GUID property of the DDoS protection plan resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the DDoS protection plan resource. Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "The list of virtual networks associated with the DDoS protection plan resource. This list is read-only."]
    #[serde(rename = "virtualNetworks", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_networks: Vec<SubResource>,
}
impl DdosProtectionPlanPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DhcpOptions {
    #[doc = "The list of DNS servers IP addresses."]
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
}
impl DhcpOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Dimension of the metric."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[doc = "The name of the dimension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The display name of the dimension."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The internal name of the dimension."]
    #[serde(rename = "internalName", default, skip_serializing_if = "Option::is_none")]
    pub internal_name: Option<String>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the CheckDnsNameAvailability API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DnsNameAvailabilityResult {
    #[doc = "Domain availability (True/False)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
}
impl DnsNameAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Effective network security group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroup {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<SubResource>,
    #[doc = "The effective network security group association."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub association: Option<EffectiveNetworkSecurityGroupAssociation>,
    #[doc = "A collection of effective security rules."]
    #[serde(rename = "effectiveSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_security_rules: Vec<EffectiveNetworkSecurityRule>,
    #[doc = "Mapping of tags to list of IP Addresses included within the tag."]
    #[serde(rename = "tagMap", default, skip_serializing_if = "Option::is_none")]
    pub tag_map: Option<String>,
}
impl EffectiveNetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The effective network security group association."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupAssociation {
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<SubResource>,
}
impl EffectiveNetworkSecurityGroupAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for list effective network security groups API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupListResult {
    #[doc = "A list of effective network security groups."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveNetworkSecurityGroup>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveNetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Effective network security rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityRule {
    #[doc = "The name of the security rule specified by the user (if created by the user)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The network protocol this rule applies to. Possible values are: 'Tcp', 'Udp', and 'All'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<effective_network_security_rule::Protocol>,
    #[doc = "The source port or range."]
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[doc = "The destination port or range."]
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[doc = "The source port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*)"]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*)"]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "The source address prefix."]
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[doc = "The destination address prefix."]
    #[serde(rename = "destinationAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub destination_address_prefix: Option<String>,
    #[doc = "The source address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*)."]
    #[serde(rename = "sourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub source_address_prefixes: Vec<String>,
    #[doc = "The destination address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*)."]
    #[serde(rename = "destinationAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_address_prefixes: Vec<String>,
    #[doc = "The expanded source address prefix."]
    #[serde(rename = "expandedSourceAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_source_address_prefix: Vec<String>,
    #[doc = "Expanded destination address prefix."]
    #[serde(rename = "expandedDestinationAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_destination_address_prefix: Vec<String>,
    #[doc = "Whether network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<effective_network_security_rule::Access>,
    #[doc = "The priority of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "The direction of the rule. Possible values are: 'Inbound and Outbound'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<effective_network_security_rule::Direction>,
}
impl EffectiveNetworkSecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_network_security_rule {
    use super::*;
    #[doc = "The network protocol this rule applies to. Possible values are: 'Tcp', 'Udp', and 'All'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        All,
    }
    #[doc = "Whether network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
    #[doc = "The direction of the rule. Possible values are: 'Inbound and Outbound'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[doc = "Effective Route"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRoute {
    #[doc = "The name of the user defined route. This is optional."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Who created the route. Possible values are: 'Unknown', 'User', 'VirtualNetworkGateway', and 'Default'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<effective_route::Source>,
    #[doc = "The value of effective route. Possible values are: 'Active' and 'Invalid'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<effective_route::State>,
    #[doc = "The address prefixes of the effective routes in CIDR notation."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefix: Vec<String>,
    #[doc = "The IP address of the next hop of the effective route."]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hop_ip_address: Vec<String>,
    #[doc = "The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'."]
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<effective_route::NextHopType>,
}
impl EffectiveRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_route {
    use super::*;
    #[doc = "Who created the route. Possible values are: 'Unknown', 'User', 'VirtualNetworkGateway', and 'Default'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        Unknown,
        User,
        VirtualNetworkGateway,
        Default,
    }
    #[doc = "The value of effective route. Possible values are: 'Active' and 'Invalid'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Active,
        Invalid,
    }
    #[doc = "The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextHopType {
        VirtualNetworkGateway,
        VnetLocal,
        Internet,
        VirtualAppliance,
        None,
    }
}
#[doc = "Response for list effective route API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRouteListResult {
    #[doc = "A list of effective routes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveRoute>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveRouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Endpoint service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointServiceResult {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Name of the endpoint service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Type of the endpoint service."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl EndpointServiceResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListAvailableEndpointServices API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointServicesListResult {
    #[doc = "List of available endpoint services in a region."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EndpointServiceResult>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EndpointServicesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Error {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetails>,
    #[serde(rename = "innerError", default, skip_serializing_if = "Option::is_none")]
    pub inner_error: Option<String>,
}
impl Error {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRouteCircuit resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuit {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Contains SKU in an ExpressRouteCircuit."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ExpressRouteCircuitSku>,
    #[doc = "Properties of ExpressRouteCircuit."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCircuit {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The ARP table associated with the ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitArpTable {
    #[doc = "Age"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub age: Option<i32>,
    #[doc = "Interface"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interface: Option<String>,
    #[doc = "The IP address."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The MAC address."]
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
}
impl ExpressRouteCircuitArpTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Authorization in an ExpressRouteCircuit resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitAuthorization {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AuthorizationPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCircuitAuthorization {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Express Route Circuit Connection in an ExpressRouteCircuitPeering resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitConnectionPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCircuitConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitConnectionPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "expressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub express_route_circuit_peering: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "peerExpressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub peer_express_route_circuit_peering: Option<SubResource>,
    #[doc = "/29 IP address space to carve out Customer addresses for tunnels."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "The authorization key."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "Express Route Circuit Connection State. Possible values are: 'Connected' and 'Disconnected'."]
    #[serde(rename = "circuitConnectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub circuit_connection_status: Option<express_route_circuit_connection_properties_format::CircuitConnectionStatus>,
    #[doc = "Provisioning state of the circuit connection resource. Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ExpressRouteCircuitConnectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_connection_properties_format {
    use super::*;
    #[doc = "Express Route Circuit Connection State. Possible values are: 'Connected' and 'Disconnected'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CircuitConnectionStatus {
        Connected,
        Connecting,
        Disconnected,
    }
}
#[doc = "Response for ListExpressRouteCircuit API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitListResult {
    #[doc = "A list of ExpressRouteCircuits in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuit>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peering in an ExpressRouteCircuit resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitPeeringPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCircuitPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies the peering configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringConfig {
    #[doc = "The reference of AdvertisedPublicPrefixes."]
    #[serde(rename = "advertisedPublicPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub advertised_public_prefixes: Vec<String>,
    #[doc = "The communities of bgp peering. Specified for microsoft peering"]
    #[serde(rename = "advertisedCommunities", default, skip_serializing_if = "Vec::is_empty")]
    pub advertised_communities: Vec<String>,
    #[doc = "AdvertisedPublicPrefixState of the Peering resource. Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'."]
    #[serde(rename = "advertisedPublicPrefixesState", default, skip_serializing_if = "Option::is_none")]
    pub advertised_public_prefixes_state: Option<express_route_circuit_peering_config::AdvertisedPublicPrefixesState>,
    #[doc = "The legacy mode of the peering."]
    #[serde(rename = "legacyMode", default, skip_serializing_if = "Option::is_none")]
    pub legacy_mode: Option<i32>,
    #[doc = "The CustomerASN of the peering."]
    #[serde(rename = "customerASN", default, skip_serializing_if = "Option::is_none")]
    pub customer_asn: Option<i32>,
    #[doc = "The RoutingRegistryName of the configuration."]
    #[serde(rename = "routingRegistryName", default, skip_serializing_if = "Option::is_none")]
    pub routing_registry_name: Option<String>,
}
impl ExpressRouteCircuitPeeringConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_peering_config {
    use super::*;
    #[doc = "AdvertisedPublicPrefixState of the Peering resource. Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AdvertisedPublicPrefixesState {
        NotConfigured,
        Configuring,
        Configured,
        ValidationNeeded,
    }
}
#[doc = "Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringListResult {
    #[doc = "The peerings in an express route circuit."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitPeering>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringPropertiesFormat {
    #[doc = "The PeeringType. Possible values are: 'AzurePublicPeering', 'AzurePrivatePeering', and 'MicrosoftPeering'."]
    #[serde(rename = "peeringType", default, skip_serializing_if = "Option::is_none")]
    pub peering_type: Option<ExpressRoutePeeringType>,
    #[doc = "The state of peering. Possible values are: 'Disabled' and 'Enabled'"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ExpressRoutePeeringState>,
    #[doc = "The Azure ASN."]
    #[serde(rename = "azureASN", default, skip_serializing_if = "Option::is_none")]
    pub azure_asn: Option<i32>,
    #[doc = "The peer ASN."]
    #[serde(rename = "peerASN", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[doc = "The primary address prefix."]
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[doc = "The secondary address prefix."]
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[doc = "The primary port."]
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[doc = "The secondary port."]
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[doc = "The shared key."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "The VLAN ID."]
    #[serde(rename = "vlanId", default, skip_serializing_if = "Option::is_none")]
    pub vlan_id: Option<i32>,
    #[doc = "Specifies the peering configuration."]
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[doc = "Contains stats associated with the peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stats: Option<ExpressRouteCircuitStats>,
    #[doc = "Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "The GatewayManager Etag."]
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
    #[doc = "Gets whether the provider or the customer last modified the peering."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "Route Filter Resource."]
    #[serde(rename = "routeFilter", default, skip_serializing_if = "Option::is_none")]
    pub route_filter: Option<RouteFilter>,
    #[doc = "Contains IPv6 peering config."]
    #[serde(rename = "ipv6PeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub ipv6_peering_config: Option<Ipv6ExpressRouteCircuitPeeringConfig>,
    #[doc = "The list of circuit connections associated with Azure Private Peering for this circuit."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub connections: Vec<ExpressRouteCircuitConnection>,
}
impl ExpressRouteCircuitPeeringPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPropertiesFormat {
    #[doc = "Allow classic operations"]
    #[serde(rename = "allowClassicOperations", default, skip_serializing_if = "Option::is_none")]
    pub allow_classic_operations: Option<bool>,
    #[doc = "The CircuitProvisioningState state of the resource."]
    #[serde(rename = "circuitProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub circuit_provisioning_state: Option<String>,
    #[doc = "The ServiceProviderProvisioningState state of the resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and 'Deprovisioning'."]
    #[serde(rename = "serviceProviderProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_provisioning_state: Option<express_route_circuit_properties_format::ServiceProviderProvisioningState>,
    #[doc = "The list of authorizations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub authorizations: Vec<ExpressRouteCircuitAuthorization>,
    #[doc = "The list of peerings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCircuitPeering>,
    #[doc = "The ServiceKey."]
    #[serde(rename = "serviceKey", default, skip_serializing_if = "Option::is_none")]
    pub service_key: Option<String>,
    #[doc = "The ServiceProviderNotes."]
    #[serde(rename = "serviceProviderNotes", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_notes: Option<String>,
    #[doc = "Contains ServiceProviderProperties in an ExpressRouteCircuit."]
    #[serde(rename = "serviceProviderProperties", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_properties: Option<ExpressRouteCircuitServiceProviderProperties>,
    #[doc = "Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "The GatewayManager Etag."]
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
}
impl ExpressRouteCircuitPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_properties_format {
    use super::*;
    #[doc = "The ServiceProviderProvisioningState state of the resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and 'Deprovisioning'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceProviderProvisioningState {
        NotProvisioned,
        Provisioning,
        Provisioned,
        Deprovisioning,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitReference {
    #[doc = "Corresponding Express Route Circuit Id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ExpressRouteCircuitReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The routes table associated with the ExpressRouteCircuit"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitRoutesTable {
    #[doc = "network"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[doc = "nextHop"]
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[doc = "locPrf"]
    #[serde(rename = "locPrf", default, skip_serializing_if = "Option::is_none")]
    pub loc_prf: Option<String>,
    #[doc = "weight."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
    #[doc = "path"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl ExpressRouteCircuitRoutesTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The routes table associated with the ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitRoutesTableSummary {
    #[doc = "Neighbor"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[doc = "BGP version number spoken to the neighbor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub v: Option<i32>,
    #[doc = "Autonomous system number."]
    #[serde(rename = "as", default, skip_serializing_if = "Option::is_none")]
    pub as_: Option<i32>,
    #[doc = "The length of time that the BGP session has been in the Established state, or the current status if not in the Established state."]
    #[serde(rename = "upDown", default, skip_serializing_if = "Option::is_none")]
    pub up_down: Option<String>,
    #[doc = "Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group."]
    #[serde(rename = "statePfxRcd", default, skip_serializing_if = "Option::is_none")]
    pub state_pfx_rcd: Option<String>,
}
impl ExpressRouteCircuitRoutesTableSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains ServiceProviderProperties in an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitServiceProviderProperties {
    #[doc = "The serviceProviderName."]
    #[serde(rename = "serviceProviderName", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_name: Option<String>,
    #[doc = "The peering location."]
    #[serde(rename = "peeringLocation", default, skip_serializing_if = "Option::is_none")]
    pub peering_location: Option<String>,
    #[doc = "The BandwidthInMbps."]
    #[serde(rename = "bandwidthInMbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_mbps: Option<i32>,
}
impl ExpressRouteCircuitServiceProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains SKU in an ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitSku {
    #[doc = "The name of the SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The tier of the SKU. Possible values are 'Standard' and 'Premium'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<express_route_circuit_sku::Tier>,
    #[doc = "The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<express_route_circuit_sku::Family>,
}
impl ExpressRouteCircuitSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_sku {
    use super::*;
    #[doc = "The tier of the SKU. Possible values are 'Standard' and 'Premium'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        Premium,
    }
    #[doc = "The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Family {
        UnlimitedData,
        MeteredData,
    }
}
#[doc = "Contains stats associated with the peering."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitStats {
    #[doc = "Gets BytesIn of the peering."]
    #[serde(rename = "primarybytesIn", default, skip_serializing_if = "Option::is_none")]
    pub primarybytes_in: Option<i64>,
    #[doc = "Gets BytesOut of the peering."]
    #[serde(rename = "primarybytesOut", default, skip_serializing_if = "Option::is_none")]
    pub primarybytes_out: Option<i64>,
    #[doc = "Gets BytesIn of the peering."]
    #[serde(rename = "secondarybytesIn", default, skip_serializing_if = "Option::is_none")]
    pub secondarybytes_in: Option<i64>,
    #[doc = "Gets BytesOut of the peering."]
    #[serde(rename = "secondarybytesOut", default, skip_serializing_if = "Option::is_none")]
    pub secondarybytes_out: Option<i64>,
}
impl ExpressRouteCircuitStats {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListArpTable associated with the Express Route Circuits API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsArpTableListResult {
    #[doc = "Gets list of the ARP table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitArpTable>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsArpTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRoutesTable associated with the Express Route Circuits API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsRoutesTableListResult {
    #[doc = "The list of routes table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitRoutesTable>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsRoutesTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRoutesTable associated with the Express Route Circuits API."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsRoutesTableSummaryListResult {
    #[doc = "A list of the routes table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitRoutesTableSummary>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsRoutesTableSummaryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRouteCrossConnection resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of ExpressRouteCrossConnection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCrossConnectionProperties>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCrossConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListExpressRouteCrossConnection API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionListResult {
    #[doc = "A list of ExpressRouteCrossConnection resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCrossConnection>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCrossConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peering in an ExpressRoute Cross Connection resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCrossConnectionPeeringProperties>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCrossConnectionPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCrossConnection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionPeeringList {
    #[doc = "The peerings in an express route cross connection."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCrossConnectionPeering>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCrossConnectionPeeringList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionPeeringProperties {
    #[doc = "The PeeringType. Possible values are: 'AzurePublicPeering', 'AzurePrivatePeering', and 'MicrosoftPeering'."]
    #[serde(rename = "peeringType", default, skip_serializing_if = "Option::is_none")]
    pub peering_type: Option<ExpressRoutePeeringType>,
    #[doc = "The state of peering. Possible values are: 'Disabled' and 'Enabled'"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ExpressRoutePeeringState>,
    #[doc = "The Azure ASN."]
    #[serde(rename = "azureASN", default, skip_serializing_if = "Option::is_none")]
    pub azure_asn: Option<i32>,
    #[doc = "The peer ASN."]
    #[serde(rename = "peerASN", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[doc = "The primary address prefix."]
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[doc = "The secondary address prefix."]
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[doc = "The primary port."]
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[doc = "The secondary port."]
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[doc = "The shared key."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "The VLAN ID."]
    #[serde(rename = "vlanId", default, skip_serializing_if = "Option::is_none")]
    pub vlan_id: Option<i32>,
    #[doc = "Specifies the peering configuration."]
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[doc = "Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "The GatewayManager Etag."]
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
    #[doc = "Gets whether the provider or the customer last modified the peering."]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[doc = "Contains IPv6 peering config."]
    #[serde(rename = "ipv6PeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub ipv6_peering_config: Option<Ipv6ExpressRouteCircuitPeeringConfig>,
}
impl ExpressRouteCrossConnectionPeeringProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ExpressRouteCrossConnection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionProperties {
    #[doc = "The name of the primary  port."]
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[doc = "The name of the secondary  port."]
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[doc = "The identifier of the circuit traffic."]
    #[serde(rename = "sTag", default, skip_serializing_if = "Option::is_none")]
    pub s_tag: Option<i64>,
    #[doc = "The peering location of the ExpressRoute circuit."]
    #[serde(rename = "peeringLocation", default, skip_serializing_if = "Option::is_none")]
    pub peering_location: Option<String>,
    #[doc = "The circuit bandwidth In Mbps."]
    #[serde(rename = "bandwidthInMbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_mbps: Option<i32>,
    #[serde(rename = "expressRouteCircuit", default, skip_serializing_if = "Option::is_none")]
    pub express_route_circuit: Option<ExpressRouteCircuitReference>,
    #[doc = "The provisioning state of the circuit in the connectivity provider system. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned'."]
    #[serde(rename = "serviceProviderProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_provisioning_state: Option<express_route_cross_connection_properties::ServiceProviderProvisioningState>,
    #[doc = "Additional read only notes set by the connectivity provider."]
    #[serde(rename = "serviceProviderNotes", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_notes: Option<String>,
    #[doc = "Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "The list of peerings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCrossConnectionPeering>,
}
impl ExpressRouteCrossConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_cross_connection_properties {
    use super::*;
    #[doc = "The provisioning state of the circuit in the connectivity provider system. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceProviderProvisioningState {
        NotProvisioned,
        Provisioning,
        Provisioned,
        Deprovisioning,
    }
}
#[doc = "The routes table associated with the ExpressRouteCircuit."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionRoutesTableSummary {
    #[doc = "IP address of Neighbor router"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[doc = "Autonomous system number."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i32>,
    #[doc = "The length of time that the BGP session has been in the Established state, or the current status if not in the Established state."]
    #[serde(rename = "upDown", default, skip_serializing_if = "Option::is_none")]
    pub up_down: Option<String>,
    #[doc = "Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group."]
    #[serde(rename = "stateOrPrefixesReceived", default, skip_serializing_if = "Option::is_none")]
    pub state_or_prefixes_received: Option<String>,
}
impl ExpressRouteCrossConnectionRoutesTableSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRoutesTable associated with the Express Route Cross Connections."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionsRoutesTableSummaryListResult {
    #[doc = "A list of the routes table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCrossConnectionRoutesTableSummary>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCrossConnectionsRoutesTableSummaryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The state of peering. Possible values are: 'Disabled' and 'Enabled'"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ExpressRoutePeeringState {
    Disabled,
    Enabled,
}
#[doc = "The PeeringType. Possible values are: 'AzurePublicPeering', 'AzurePrivatePeering', and 'MicrosoftPeering'."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ExpressRoutePeeringType {
    AzurePublicPeering,
    AzurePrivatePeering,
    MicrosoftPeering,
}
#[doc = "A ExpressRouteResourceProvider object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProvider {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of ExpressRouteServiceProvider."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteServiceProviderPropertiesFormat>,
}
impl ExpressRouteServiceProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains bandwidths offered in ExpressRouteServiceProvider resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderBandwidthsOffered {
    #[doc = "The OfferName."]
    #[serde(rename = "offerName", default, skip_serializing_if = "Option::is_none")]
    pub offer_name: Option<String>,
    #[doc = "The ValueInMbps."]
    #[serde(rename = "valueInMbps", default, skip_serializing_if = "Option::is_none")]
    pub value_in_mbps: Option<i32>,
}
impl ExpressRouteServiceProviderBandwidthsOffered {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListExpressRouteServiceProvider API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderListResult {
    #[doc = "A list of ExpressRouteResourceProvider resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteServiceProvider>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteServiceProviderListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ExpressRouteServiceProvider."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderPropertiesFormat {
    #[doc = "Get a list of peering locations."]
    #[serde(rename = "peeringLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub peering_locations: Vec<String>,
    #[doc = "Gets bandwidths offered."]
    #[serde(rename = "bandwidthsOffered", default, skip_serializing_if = "Vec::is_empty")]
    pub bandwidths_offered: Vec<ExpressRouteServiceProviderBandwidthsOffered>,
    #[doc = "Gets the provisioning state of the resource."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ExpressRouteServiceProviderPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information on the configuration of flow log."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogInformation {
    #[doc = "The ID of the resource to configure for flow logging."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "Parameters that define the configuration of flow log."]
    pub properties: FlowLogProperties,
}
impl FlowLogInformation {
    pub fn new(target_resource_id: String, properties: FlowLogProperties) -> Self {
        Self {
            target_resource_id,
            properties,
        }
    }
}
#[doc = "Parameters that define the configuration of flow log."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogProperties {
    #[doc = "ID of the storage account which is used to store the flow log."]
    #[serde(rename = "storageId")]
    pub storage_id: String,
    #[doc = "Flag to enable/disable flow logging."]
    pub enabled: bool,
    #[doc = "Parameters that define the retention policy for flow log."]
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicyParameters>,
}
impl FlowLogProperties {
    pub fn new(storage_id: String, enabled: bool) -> Self {
        Self {
            storage_id,
            enabled,
            retention_policy: None,
        }
    }
}
#[doc = "Parameters that define a resource to query flow log status."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogStatusParameters {
    #[doc = "The target resource where getting the flow logging status."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
}
impl FlowLogStatusParameters {
    pub fn new(target_resource_id: String) -> Self {
        Self { target_resource_id }
    }
}
#[doc = "Frontend IP address of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Frontend IP Configuration of the load balancer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FrontendIpConfigurationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "A list of availability zones denoting the IP allocated for the resource needs to come from."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl FrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Frontend IP Configuration of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfigurationPropertiesFormat {
    #[doc = "Read only. Inbound rules URIs that use this frontend IP."]
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<SubResource>,
    #[doc = "Read only. Inbound pools URIs that use this frontend IP."]
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<SubResource>,
    #[doc = "Read only. Outbound rules URIs that use this frontend IP."]
    #[serde(rename = "outboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_nat_rules: Vec<SubResource>,
    #[doc = "Gets load balancing rules URIs that use this frontend IP."]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[doc = "The private IP address of the IP configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<frontend_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "Public IP address resource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[doc = "Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl FrontendIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod frontend_ip_configuration_properties_format {
    use super::*;
    #[doc = "The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[doc = "Gateway routing details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayRoute {
    #[doc = "The gateway's local address"]
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[doc = "The route's network prefix"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[doc = "The route's next hop"]
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[doc = "The peer this route was learned from"]
    #[serde(rename = "sourcePeer", default, skip_serializing_if = "Option::is_none")]
    pub source_peer: Option<String>,
    #[doc = "The source this route was learned from"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[doc = "The route's AS path sequence"]
    #[serde(rename = "asPath", default, skip_serializing_if = "Option::is_none")]
    pub as_path: Option<String>,
    #[doc = "The route's weight"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
}
impl GatewayRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of virtual network gateway routes"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayRouteListResult {
    #[doc = "List of gateway routes"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GatewayRoute>,
}
impl GatewayRouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HTTP configuration of the connectivity check."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpConfiguration {
    #[doc = "HTTP method."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<http_configuration::Method>,
    #[doc = "List of HTTP headers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub headers: Vec<HttpHeader>,
    #[doc = "Valid status codes."]
    #[serde(rename = "validStatusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub valid_status_codes: Vec<i64>,
}
impl HttpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod http_configuration {
    use super::*;
    #[doc = "HTTP method."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Method {
        Get,
    }
}
#[doc = "Describes the HTTP header."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpHeader {
    #[doc = "The name in HTTP header."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The value in HTTP header."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl HttpHeader {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for CheckIPAddressAvailability API service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressAvailabilityResult {
    #[doc = "Private IP address availability."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
    #[doc = "Contains other available private IP addresses if the asked for address is taken."]
    #[serde(rename = "availableIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub available_ip_addresses: Vec<String>,
}
impl IpAddressAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IP configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpConfigurationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationPropertiesFormat {
    #[doc = "The private IP address of the IP configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "The private IP allocation method. Possible values are 'Static' and 'Dynamic'."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "Public IP address resource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[doc = "Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl IpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ip_configuration_properties_format {
    use super::*;
    #[doc = "The private IP allocation method. Possible values are 'Static' and 'Dynamic'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[doc = "Inbound NAT pool of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Inbound NAT pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatPoolPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl InboundNatPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Inbound NAT pool."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundNatPoolPropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'."]
    pub protocol: TransportProtocol,
    #[doc = "The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534."]
    #[serde(rename = "frontendPortRangeStart")]
    pub frontend_port_range_start: i32,
    #[doc = "The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535."]
    #[serde(rename = "frontendPortRangeEnd")]
    pub frontend_port_range_end: i32,
    #[doc = "The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535."]
    #[serde(rename = "backendPort")]
    pub backend_port: i32,
    #[doc = "The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint."]
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[doc = "Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl InboundNatPoolPropertiesFormat {
    pub fn new(protocol: TransportProtocol, frontend_port_range_start: i32, frontend_port_range_end: i32, backend_port: i32) -> Self {
        Self {
            frontend_ip_configuration: None,
            protocol,
            frontend_port_range_start,
            frontend_port_range_end,
            backend_port,
            idle_timeout_in_minutes: None,
            enable_floating_ip: None,
            provisioning_state: None,
        }
    }
}
#[doc = "Inbound NAT rule of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the inbound NAT rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatRulePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl InboundNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListInboundNatRule API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRuleListResult {
    #[doc = "A list of inbound nat rules in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<InboundNatRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl InboundNatRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the inbound NAT rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRulePropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "IPConfiguration in a network interface."]
    #[serde(rename = "backendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub backend_ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[doc = "The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<TransportProtocol>,
    #[doc = "The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534."]
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<i32>,
    #[doc = "The port used for the internal endpoint. Acceptable values range from 1 to 65535."]
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[doc = "The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint."]
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[doc = "Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl InboundNatRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains the IpTag associated with the public IP address"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpTag {
    #[doc = "Gets or sets the ipTag type: Example FirstPartyUsage."]
    #[serde(rename = "ipTagType", default, skip_serializing_if = "Option::is_none")]
    pub ip_tag_type: Option<String>,
    #[doc = "Gets or sets value of the IpTag associated with the public IP. Example SQL, Storage etc"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
}
impl IpTag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An IPSec Policy configuration for a virtual network gateway connection"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpsecPolicy {
    #[doc = "The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel."]
    #[serde(rename = "saLifeTimeSeconds")]
    pub sa_life_time_seconds: i32,
    #[doc = "The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel."]
    #[serde(rename = "saDataSizeKilobytes")]
    pub sa_data_size_kilobytes: i32,
    #[doc = "The IPSec encryption algorithm (IKE phase 1)."]
    #[serde(rename = "ipsecEncryption")]
    pub ipsec_encryption: ipsec_policy::IpsecEncryption,
    #[doc = "The IPSec integrity algorithm (IKE phase 1)."]
    #[serde(rename = "ipsecIntegrity")]
    pub ipsec_integrity: ipsec_policy::IpsecIntegrity,
    #[doc = "The IKE encryption algorithm (IKE phase 2)."]
    #[serde(rename = "ikeEncryption")]
    pub ike_encryption: ipsec_policy::IkeEncryption,
    #[doc = "The IKE integrity algorithm (IKE phase 2)."]
    #[serde(rename = "ikeIntegrity")]
    pub ike_integrity: ipsec_policy::IkeIntegrity,
    #[doc = "The DH Groups used in IKE Phase 1 for initial SA."]
    #[serde(rename = "dhGroup")]
    pub dh_group: ipsec_policy::DhGroup,
    #[doc = "The Pfs Groups used in IKE Phase 2 for new child SA."]
    #[serde(rename = "pfsGroup")]
    pub pfs_group: ipsec_policy::PfsGroup,
}
impl IpsecPolicy {
    pub fn new(
        sa_life_time_seconds: i32,
        sa_data_size_kilobytes: i32,
        ipsec_encryption: ipsec_policy::IpsecEncryption,
        ipsec_integrity: ipsec_policy::IpsecIntegrity,
        ike_encryption: ipsec_policy::IkeEncryption,
        ike_integrity: ipsec_policy::IkeIntegrity,
        dh_group: ipsec_policy::DhGroup,
        pfs_group: ipsec_policy::PfsGroup,
    ) -> Self {
        Self {
            sa_life_time_seconds,
            sa_data_size_kilobytes,
            ipsec_encryption,
            ipsec_integrity,
            ike_encryption,
            ike_integrity,
            dh_group,
            pfs_group,
        }
    }
}
pub mod ipsec_policy {
    use super::*;
    #[doc = "The IPSec encryption algorithm (IKE phase 1)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IpsecEncryption {
        None,
        #[serde(rename = "DES")]
        Des,
        #[serde(rename = "DES3")]
        Des3,
        #[serde(rename = "AES128")]
        Aes128,
        #[serde(rename = "AES192")]
        Aes192,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
        #[serde(rename = "GCMAES192")]
        Gcmaes192,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
    }
    #[doc = "The IPSec integrity algorithm (IKE phase 1)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IpsecIntegrity {
        #[serde(rename = "MD5")]
        Md5,
        #[serde(rename = "SHA1")]
        Sha1,
        #[serde(rename = "SHA256")]
        Sha256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
        #[serde(rename = "GCMAES192")]
        Gcmaes192,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
    }
    #[doc = "The IKE encryption algorithm (IKE phase 2)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IkeEncryption {
        #[serde(rename = "DES")]
        Des,
        #[serde(rename = "DES3")]
        Des3,
        #[serde(rename = "AES128")]
        Aes128,
        #[serde(rename = "AES192")]
        Aes192,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
    }
    #[doc = "The IKE integrity algorithm (IKE phase 2)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IkeIntegrity {
        #[serde(rename = "MD5")]
        Md5,
        #[serde(rename = "SHA1")]
        Sha1,
        #[serde(rename = "SHA256")]
        Sha256,
        #[serde(rename = "SHA384")]
        Sha384,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
    }
    #[doc = "The DH Groups used in IKE Phase 1 for initial SA."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DhGroup {
        None,
        #[serde(rename = "DHGroup1")]
        DhGroup1,
        #[serde(rename = "DHGroup2")]
        DhGroup2,
        #[serde(rename = "DHGroup14")]
        DhGroup14,
        #[serde(rename = "DHGroup2048")]
        DhGroup2048,
        #[serde(rename = "ECP256")]
        Ecp256,
        #[serde(rename = "ECP384")]
        Ecp384,
        #[serde(rename = "DHGroup24")]
        DhGroup24,
    }
    #[doc = "The Pfs Groups used in IKE Phase 2 for new child SA."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PfsGroup {
        None,
        #[serde(rename = "PFS1")]
        Pfs1,
        #[serde(rename = "PFS2")]
        Pfs2,
        #[serde(rename = "PFS2048")]
        Pfs2048,
        #[serde(rename = "ECP256")]
        Ecp256,
        #[serde(rename = "ECP384")]
        Ecp384,
        #[serde(rename = "PFS24")]
        Pfs24,
        #[serde(rename = "PFS14")]
        Pfs14,
        #[serde(rename = "PFSMM")]
        Pfsmm,
    }
}
#[doc = "Contains IPv6 peering config."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Ipv6ExpressRouteCircuitPeeringConfig {
    #[doc = "The primary address prefix."]
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[doc = "The secondary address prefix."]
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[doc = "Specifies the peering configuration."]
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[doc = "Route Filter Resource."]
    #[serde(rename = "routeFilter", default, skip_serializing_if = "Option::is_none")]
    pub route_filter: Option<RouteFilter>,
    #[doc = "The state of peering. Possible values are: 'Disabled' and 'Enabled'"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ipv6_express_route_circuit_peering_config::State>,
}
impl Ipv6ExpressRouteCircuitPeeringConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ipv6_express_route_circuit_peering_config {
    use super::*;
    #[doc = "The state of peering. Possible values are: 'Disabled' and 'Enabled'"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
        Enabled,
    }
}
#[doc = "A key-value pair that provides additional context on the issue."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueContext {}
impl IssueContext {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "LoadBalancer resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancer {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "SKU of a load balancer"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<LoadBalancerSku>,
    #[doc = "Properties of the load balancer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancerPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LoadBalancer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListBackendAddressPool API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerBackendAddressPoolListResult {
    #[doc = "A list of backend address pools in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackendAddressPool>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerBackendAddressPoolListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListFrontendIPConfiguration API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerFrontendIpConfigurationListResult {
    #[doc = "A list of frontend IP configurations in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FrontendIpConfiguration>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerFrontendIpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListLoadBalancers API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerListResult {
    #[doc = "A list of load balancers in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancer>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListLoadBalancingRule API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerLoadBalancingRuleListResult {
    #[doc = "A list of load balancing rules in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancingRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerLoadBalancingRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListProbe API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerProbeListResult {
    #[doc = "A list of probes in a load balancer."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Probe>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerProbeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerPropertiesFormat {
    #[doc = "Object representing the frontend IPs to be used for the load balancer"]
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<FrontendIpConfiguration>,
    #[doc = "Collection of backend address pools used by a load balancer"]
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<BackendAddressPool>,
    #[doc = "Object collection representing the load balancing rules Gets the provisioning "]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<LoadBalancingRule>,
    #[doc = "Collection of probe objects used in the load balancer"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub probes: Vec<Probe>,
    #[doc = "Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules."]
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<InboundNatRule>,
    #[doc = "Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules."]
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<InboundNatPool>,
    #[doc = "The outbound NAT rules."]
    #[serde(rename = "outboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_nat_rules: Vec<OutboundNatRule>,
    #[doc = "The resource GUID property of the load balancer resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LoadBalancerPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SKU of a load balancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerSku {
    #[doc = "Name of a load balancer SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<load_balancer_sku::Name>,
}
impl LoadBalancerSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod load_balancer_sku {
    use super::*;
    #[doc = "Name of a load balancer SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
    }
}
#[doc = "A load balancing rule for a load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancingRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the load balancer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancingRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LoadBalancingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LoadBalancingRulePropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub probe: Option<SubResource>,
    #[doc = "The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'."]
    pub protocol: TransportProtocol,
    #[doc = "The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'."]
    #[serde(rename = "loadDistribution", default, skip_serializing_if = "Option::is_none")]
    pub load_distribution: Option<load_balancing_rule_properties_format::LoadDistribution>,
    #[doc = "The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables \"Any Port\""]
    #[serde(rename = "frontendPort")]
    pub frontend_port: i32,
    #[doc = "The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables \"Any Port\""]
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[doc = "The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint."]
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[doc = "Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule."]
    #[serde(rename = "disableOutboundSnat", default, skip_serializing_if = "Option::is_none")]
    pub disable_outbound_snat: Option<bool>,
    #[doc = "Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LoadBalancingRulePropertiesFormat {
    pub fn new(protocol: TransportProtocol, frontend_port: i32) -> Self {
        Self {
            frontend_ip_configuration: None,
            backend_address_pool: None,
            probe: None,
            protocol,
            load_distribution: None,
            frontend_port,
            backend_port: None,
            idle_timeout_in_minutes: None,
            enable_floating_ip: None,
            disable_outbound_snat: None,
            provisioning_state: None,
        }
    }
}
pub mod load_balancing_rule_properties_format {
    use super::*;
    #[doc = "The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadDistribution {
        Default,
        #[serde(rename = "SourceIP")]
        SourceIp,
        #[serde(rename = "SourceIPProtocol")]
        SourceIpProtocol,
    }
}
#[doc = "A common class for general resource information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LocalNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "LocalNetworkGateway properties"]
    pub properties: LocalNetworkGatewayPropertiesFormat,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LocalNetworkGateway {
    pub fn new(properties: LocalNetworkGatewayPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[doc = "Response for ListLocalNetworkGateways API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayListResult {
    #[doc = "A list of local network gateways that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LocalNetworkGateway>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LocalNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "LocalNetworkGateway properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayPropertiesFormat {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "localNetworkAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub local_network_address_space: Option<AddressSpace>,
    #[doc = "IP address of local network gateway."]
    #[serde(rename = "gatewayIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub gateway_ip_address: Option<String>,
    #[doc = "BGP settings details"]
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[doc = "The resource GUID property of the LocalNetworkGateway resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the LocalNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LocalNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Description of logging specification."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogSpecification {
    #[doc = "The name of the specification."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The display name of the specification."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Duration of the blob."]
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl LogSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Description of metrics specification."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSpecification {
    #[doc = "The name of the metric."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The display name of the metric."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "The description of the metric."]
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[doc = "Units the metric to be displayed in."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[doc = "The aggregation type."]
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[doc = "List of availability."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub availabilities: Vec<Availability>,
    #[doc = "Whether regional MDM account enabled."]
    #[serde(rename = "enableRegionalMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub enable_regional_mdm_account: Option<bool>,
    #[doc = "Whether gaps would be filled with zeros."]
    #[serde(rename = "fillGapWithZero", default, skip_serializing_if = "Option::is_none")]
    pub fill_gap_with_zero: Option<bool>,
    #[doc = "Pattern for the filter of the metric."]
    #[serde(rename = "metricFilterPattern", default, skip_serializing_if = "Option::is_none")]
    pub metric_filter_pattern: Option<String>,
    #[doc = "List of dimensions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Dimension>,
    #[doc = "Whether the metric is internal."]
    #[serde(rename = "isInternal", default, skip_serializing_if = "Option::is_none")]
    pub is_internal: Option<bool>,
    #[doc = "The source MDM account."]
    #[serde(rename = "sourceMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_account: Option<String>,
    #[doc = "The source MDM namespace."]
    #[serde(rename = "sourceMdmNamespace", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_namespace: Option<String>,
    #[doc = "The resource Id dimension name override."]
    #[serde(rename = "resourceIdDimensionNameOverride", default, skip_serializing_if = "Option::is_none")]
    pub resource_id_dimension_name_override: Option<String>,
}
impl MetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A network interface in a resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterface {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "NetworkInterface properties. "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfacePropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network interface and its custom security rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceAssociation {
    #[doc = "Network interface ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Collection of custom security rules."]
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
}
impl NetworkInterfaceAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DNS settings of a network interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceDnsSettings {
    #[doc = "List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection."]
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
    #[doc = "If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs."]
    #[serde(rename = "appliedDnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub applied_dns_servers: Vec<String>,
    #[doc = "Relative DNS name for this NIC used for internal communications between VMs in the same virtual network."]
    #[serde(rename = "internalDnsNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub internal_dns_name_label: Option<String>,
    #[doc = "Fully qualified DNS name supporting internal communications between VMs in the same virtual network."]
    #[serde(rename = "internalFqdn", default, skip_serializing_if = "Option::is_none")]
    pub internal_fqdn: Option<String>,
    #[doc = "Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix."]
    #[serde(rename = "internalDomainNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub internal_domain_name_suffix: Option<String>,
}
impl NetworkInterfaceDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IPConfiguration in a network interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceIpConfigurationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkInterfaceIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for list ip configurations API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationListResult {
    #[doc = "A list of ip configurations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceIpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationPropertiesFormat {
    #[doc = "The reference of ApplicationGatewayBackendAddressPool resource."]
    #[serde(rename = "applicationGatewayBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_backend_address_pools: Vec<ApplicationGatewayBackendAddressPool>,
    #[doc = "The reference of LoadBalancerBackendAddressPool resource."]
    #[serde(rename = "loadBalancerBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_address_pools: Vec<BackendAddressPool>,
    #[doc = "A list of references of LoadBalancerInboundNatRules."]
    #[serde(rename = "loadBalancerInboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_inbound_nat_rules: Vec<InboundNatRule>,
    #[doc = "Private IP address of the IP configuration."]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<network_interface_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[doc = "Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'."]
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<network_interface_ip_configuration_properties_format::PrivateIpAddressVersion>,
    #[doc = "Subnet in a virtual network resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "Gets whether this is a primary customer address on the network interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[doc = "Public IP address resource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[doc = "Application security groups in which the IP configuration is included."]
    #[serde(rename = "applicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub application_security_groups: Vec<ApplicationSecurityGroup>,
    #[doc = "The provisioning state of the network interface IP configuration. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkInterfaceIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_interface_ip_configuration_properties_format {
    use super::*;
    #[doc = "Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
    #[doc = "Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAddressVersion {
        IPv4,
        IPv6,
    }
}
#[doc = "Response for the ListNetworkInterface API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceListResult {
    #[doc = "A list of network interfaces in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterface>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for list ip configurations API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceLoadBalancerListResult {
    #[doc = "A list of load balancers."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancer>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceLoadBalancerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NetworkInterface properties. "]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfacePropertiesFormat {
    #[doc = "Reference to another subresource."]
    #[serde(rename = "virtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine: Option<SubResource>,
    #[doc = "NetworkSecurityGroup resource."]
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[doc = "A list of IPConfigurations of the network interface."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "DNS settings of a network interface."]
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<NetworkInterfaceDnsSettings>,
    #[doc = "The MAC address of the network interface."]
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[doc = "Gets whether this is a primary network interface on a virtual machine."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[doc = "If the network interface is accelerated networking enabled."]
    #[serde(rename = "enableAcceleratedNetworking", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking: Option<bool>,
    #[doc = "Indicates whether IP forwarding is enabled on this network interface."]
    #[serde(rename = "enableIPForwarding", default, skip_serializing_if = "Option::is_none")]
    pub enable_ip_forwarding: Option<bool>,
    #[doc = "The resource GUID property of the network interface resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkInterfacePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NetworkSecurityGroup resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Network Security Group resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkSecurityGroupPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListNetworkSecurityGroups API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupListResult {
    #[doc = "A list of NetworkSecurityGroup resources."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkSecurityGroup>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Security Group resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupPropertiesFormat {
    #[doc = "A collection of security rules of the network security group."]
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
    #[doc = "The default security rules of network security group."]
    #[serde(rename = "defaultSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub default_security_rules: Vec<SecurityRule>,
    #[doc = "A collection of references to network interfaces."]
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[doc = "A collection of references to subnets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "The resource GUID property of the network security group resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkSecurityGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network watcher in a resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkWatcher {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "The network watcher properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkWatcherPropertiesFormat>,
}
impl NetworkWatcher {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of network watcher resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkWatcherListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkWatcher>,
}
impl NetworkWatcherListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The network watcher properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkWatcherPropertiesFormat {
    #[doc = "The provisioning state of the resource."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<network_watcher_properties_format::ProvisioningState>,
}
impl NetworkWatcherPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_watcher_properties_format {
    use super::*;
    #[doc = "The provisioning state of the resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Updating,
        Deleting,
        Failed,
    }
}
#[doc = "Parameters that define the source and destination endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NextHopParameters {
    #[doc = "The resource identifier of the target resource against which the action is to be performed."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "The source IP address."]
    #[serde(rename = "sourceIPAddress")]
    pub source_ip_address: String,
    #[doc = "The destination IP address."]
    #[serde(rename = "destinationIPAddress")]
    pub destination_ip_address: String,
    #[doc = "The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of the nics, then this parameter must be specified. Otherwise optional)."]
    #[serde(rename = "targetNicResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_resource_id: Option<String>,
}
impl NextHopParameters {
    pub fn new(target_resource_id: String, source_ip_address: String, destination_ip_address: String) -> Self {
        Self {
            target_resource_id,
            source_ip_address,
            destination_ip_address,
            target_nic_resource_id: None,
        }
    }
}
#[doc = "The information about next hop from the specified VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NextHopResult {
    #[doc = "Next hop type."]
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<next_hop_result::NextHopType>,
    #[doc = "Next hop IP Address"]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
    #[doc = "The resource identifier for the route table associated with the route being returned. If the route being returned does not correspond to any user created routes then this field will be the string 'System Route'."]
    #[serde(rename = "routeTableId", default, skip_serializing_if = "Option::is_none")]
    pub route_table_id: Option<String>,
}
impl NextHopResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod next_hop_result {
    use super::*;
    #[doc = "Next hop type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextHopType {
        Internet,
        VirtualAppliance,
        VirtualNetworkGateway,
        VnetLocal,
        HyperNetGateway,
        None,
    }
}
#[doc = "Network REST API operation definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Display metadata associated with the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[doc = "Origin of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[doc = "Description of operation properties format."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationPropertiesFormat>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "Display metadata associated with the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Service provider: Microsoft Network."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource on which the operation is performed."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Type of the operation: get, read, delete, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "Description of the operation."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result of the request to list Network operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of Network operations supported by the Network resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[doc = "URL to get the next set of operation list results if there are any."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Description of operation properties format."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationPropertiesFormat {
    #[doc = "Specification of the service."]
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<operation_properties_format::ServiceSpecification>,
}
impl OperationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_properties_format {
    use super::*;
    #[doc = "Specification of the service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ServiceSpecification {
        #[doc = "Operation service specification."]
        #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
        pub metric_specifications: Vec<MetricSpecification>,
        #[doc = "Operation log specification."]
        #[serde(rename = "logSpecifications", default, skip_serializing_if = "Vec::is_empty")]
        pub log_specifications: Vec<LogSpecification>,
    }
    impl ServiceSpecification {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Outbound NAT pool of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OutboundNatRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Outbound NAT pool of the load balancer."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OutboundNatRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl OutboundNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Outbound NAT pool of the load balancer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutboundNatRulePropertiesFormat {
    #[doc = "The number of outbound ports to be used for NAT."]
    #[serde(rename = "allocatedOutboundPorts", default, skip_serializing_if = "Option::is_none")]
    pub allocated_outbound_ports: Option<i32>,
    #[doc = "The Frontend IP addresses of the load balancer."]
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "backendAddressPool")]
    pub backend_address_pool: SubResource,
    #[doc = "Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl OutboundNatRulePropertiesFormat {
    pub fn new(backend_address_pool: SubResource) -> Self {
        Self {
            allocated_outbound_ports: None,
            frontend_ip_configurations: Vec::new(),
            backend_address_pool,
            provisioning_state: None,
        }
    }
}
#[doc = "Parameters that define the create packet capture operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PacketCapture {
    #[doc = "Parameters that define the create packet capture operation."]
    pub properties: PacketCaptureParameters,
}
impl PacketCapture {
    pub fn new(properties: PacketCaptureParameters) -> Self {
        Self { properties }
    }
}
#[doc = "Filter that is applied to packet capture request. Multiple filters can be applied."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureFilter {
    #[doc = "Protocol to be filtered on."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<packet_capture_filter::Protocol>,
    #[doc = "Local IP Address to be filtered on. Notation: \"127.0.0.1\" for single address entry. \"127.0.0.1-127.0.0.255\" for range. \"127.0.0.1;127.0.0.5\"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null."]
    #[serde(rename = "localIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_ip_address: Option<String>,
    #[doc = "Local IP Address to be filtered on. Notation: \"127.0.0.1\" for single address entry. \"127.0.0.1-127.0.0.255\" for range. \"127.0.0.1;127.0.0.5;\" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null."]
    #[serde(rename = "remoteIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub remote_ip_address: Option<String>,
    #[doc = "Local port to be filtered on. Notation: \"80\" for single port entry.\"80-85\" for range. \"80;443;\" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null."]
    #[serde(rename = "localPort", default, skip_serializing_if = "Option::is_none")]
    pub local_port: Option<String>,
    #[doc = "Remote port to be filtered on. Notation: \"80\" for single port entry.\"80-85\" for range. \"80;443;\" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null."]
    #[serde(rename = "remotePort", default, skip_serializing_if = "Option::is_none")]
    pub remote_port: Option<String>,
}
impl PacketCaptureFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod packet_capture_filter {
    use super::*;
    #[doc = "Protocol to be filtered on."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
        Any,
    }
    impl Default for Protocol {
        fn default() -> Self {
            Self::Any
        }
    }
}
#[doc = "List of packet capture sessions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureListResult {
    #[doc = "Information about packet capture sessions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PacketCaptureResult>,
}
impl PacketCaptureListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the create packet capture operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PacketCaptureParameters {
    #[doc = "The ID of the targeted resource, only VM is currently supported."]
    pub target: String,
    #[doc = "Number of bytes captured per packet, the remaining bytes are truncated."]
    #[serde(rename = "bytesToCapturePerPacket", default, skip_serializing_if = "Option::is_none")]
    pub bytes_to_capture_per_packet: Option<i64>,
    #[doc = "Maximum size of the capture output."]
    #[serde(rename = "totalBytesPerSession", default, skip_serializing_if = "Option::is_none")]
    pub total_bytes_per_session: Option<i64>,
    #[doc = "Maximum duration of the capture session in seconds."]
    #[serde(rename = "timeLimitInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub time_limit_in_seconds: Option<i64>,
    #[doc = "Describes the storage location for a packet capture session."]
    #[serde(rename = "storageLocation")]
    pub storage_location: PacketCaptureStorageLocation,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub filters: Vec<PacketCaptureFilter>,
}
impl PacketCaptureParameters {
    pub fn new(target: String, storage_location: PacketCaptureStorageLocation) -> Self {
        Self {
            target,
            bytes_to_capture_per_packet: None,
            total_bytes_per_session: None,
            time_limit_in_seconds: None,
            storage_location,
            filters: Vec::new(),
        }
    }
}
#[doc = "Status of packet capture session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureQueryStatusResult {
    #[doc = "The name of the packet capture resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The ID of the packet capture resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The start time of the packet capture session."]
    #[serde(rename = "captureStartTime", default, skip_serializing_if = "Option::is_none")]
    pub capture_start_time: Option<String>,
    #[doc = "The status of the packet capture session."]
    #[serde(rename = "packetCaptureStatus", default, skip_serializing_if = "Option::is_none")]
    pub packet_capture_status: Option<packet_capture_query_status_result::PacketCaptureStatus>,
    #[doc = "The reason the current packet capture session was stopped."]
    #[serde(rename = "stopReason", default, skip_serializing_if = "Option::is_none")]
    pub stop_reason: Option<String>,
    #[doc = "List of errors of packet capture session."]
    #[serde(rename = "packetCaptureError", default, skip_serializing_if = "Vec::is_empty")]
    pub packet_capture_error: Vec<String>,
}
impl PacketCaptureQueryStatusResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod packet_capture_query_status_result {
    use super::*;
    #[doc = "The status of the packet capture session."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PacketCaptureStatus {
        NotStarted,
        Running,
        Stopped,
        Error,
        Unknown,
    }
}
#[doc = "Information about packet capture session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureResult {
    #[doc = "Name of the packet capture session."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "ID of the packet capture operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Describes the properties of a packet capture session."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PacketCaptureResultProperties>,
}
impl PacketCaptureResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the properties of a packet capture session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PacketCaptureResultProperties {
    #[serde(flatten)]
    pub packet_capture_parameters: PacketCaptureParameters,
    #[doc = "The provisioning state of the packet capture session."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<packet_capture_result_properties::ProvisioningState>,
}
impl PacketCaptureResultProperties {
    pub fn new(packet_capture_parameters: PacketCaptureParameters) -> Self {
        Self {
            packet_capture_parameters,
            provisioning_state: None,
        }
    }
}
pub mod packet_capture_result_properties {
    use super::*;
    #[doc = "The provisioning state of the packet capture session."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningState {
        Succeeded,
        Updating,
        Deleting,
        Failed,
    }
}
#[doc = "Describes the storage location for a packet capture session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureStorageLocation {
    #[doc = "The ID of the storage account to save the packet capture session. Required if no local file path is provided."]
    #[serde(rename = "storageId", default, skip_serializing_if = "Option::is_none")]
    pub storage_id: Option<String>,
    #[doc = "The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture."]
    #[serde(rename = "storagePath", default, skip_serializing_if = "Option::is_none")]
    pub storage_path: Option<String>,
    #[doc = "A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional."]
    #[serde(rename = "filePath", default, skip_serializing_if = "Option::is_none")]
    pub file_path: Option<String>,
}
impl PacketCaptureStorageLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PatchRouteFilter {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Route Filter Resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl PatchRouteFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Rule Resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PatchRouteFilterRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Route Filter Rule Resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PatchRouteFilterRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Ssl predefined policy name enums."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PolicyNameEnum {
    AppGwSslPolicy20150501,
    AppGwSslPolicy20170401,
    AppGwSslPolicy20170401S,
}
#[doc = "A load balancer probe."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Probe {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Load balancer probe resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProbePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Probe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Load balancer probe resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProbePropertiesFormat {
    #[doc = "The load balancer rules that use this probe."]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[doc = "The protocol of the end point. Possible values are: 'Http', 'Tcp' or 'Https'. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful."]
    pub protocol: probe_properties_format::Protocol,
    #[doc = "The port for communicating the probe. Possible values range from 1 to 65535, inclusive."]
    pub port: i32,
    #[doc = "The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5."]
    #[serde(rename = "intervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub interval_in_seconds: Option<i32>,
    #[doc = "The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure."]
    #[serde(rename = "numberOfProbes", default, skip_serializing_if = "Option::is_none")]
    pub number_of_probes: Option<i32>,
    #[doc = "The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value."]
    #[serde(rename = "requestPath", default, skip_serializing_if = "Option::is_none")]
    pub request_path: Option<String>,
    #[doc = "Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ProbePropertiesFormat {
    pub fn new(protocol: probe_properties_format::Protocol, port: i32) -> Self {
        Self {
            load_balancing_rules: Vec::new(),
            protocol,
            port,
            interval_in_seconds: None,
            number_of_probes: None,
            request_path: None,
            provisioning_state: None,
        }
    }
}
pub mod probe_properties_format {
    use super::*;
    #[doc = "The protocol of the end point. Possible values are: 'Http', 'Tcp' or 'Https'. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Tcp,
        Https,
    }
}
#[doc = "Configuration of the protocol."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtocolConfiguration {
    #[doc = "HTTP configuration of the connectivity check."]
    #[serde(rename = "HTTPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub http_configuration: Option<HttpConfiguration>,
}
impl ProtocolConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Ssl protocol enums."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProtocolsEnum {
    #[serde(rename = "TLSv1_0")]
    TlSv10,
    #[serde(rename = "TLSv1_1")]
    TlSv11,
    #[serde(rename = "TLSv1_2")]
    TlSv12,
}
#[doc = "Public IP address resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddress {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "SKU of a public IP address"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<PublicIpAddressSku>,
    #[doc = "Public IP address properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Box<Option<PublicIpAddressPropertiesFormat>>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "A list of availability zones denoting the IP allocated for the resource needs to come from."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl PublicIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains FQDN of the DNS record associated with the public IP address"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressDnsSettings {
    #[doc = "Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system."]
    #[serde(rename = "domainNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub domain_name_label: Option<String>,
    #[doc = "Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. "]
    #[serde(rename = "reverseFqdn", default, skip_serializing_if = "Option::is_none")]
    pub reverse_fqdn: Option<String>,
}
impl PublicIpAddressDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListPublicIpAddresses API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressListResult {
    #[doc = "A list of public IP addresses that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PublicIpAddress>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PublicIpAddressListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Public IP address properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressPropertiesFormat {
    #[doc = "The public IP allocation method. Possible values are: 'Static' and 'Dynamic'."]
    #[serde(rename = "publicIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_allocation_method: Option<public_ip_address_properties_format::PublicIpAllocationMethod>,
    #[doc = "The public IP address version. Possible values are: 'IPv4' and 'IPv6'."]
    #[serde(rename = "publicIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_version: Option<public_ip_address_properties_format::PublicIpAddressVersion>,
    #[doc = "IP configuration"]
    #[serde(rename = "ipConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration: Option<IpConfiguration>,
    #[doc = "Contains FQDN of the DNS record associated with the public IP address"]
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<PublicIpAddressDnsSettings>,
    #[doc = "The list of tags associated with the public IP address."]
    #[serde(rename = "ipTags", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_tags: Vec<IpTag>,
    #[doc = "The IP address associated with the public IP address resource."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The idle timeout of the public IP address."]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "The resource GUID property of the public IP resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl PublicIpAddressPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_address_properties_format {
    use super::*;
    #[doc = "The public IP allocation method. Possible values are: 'Static' and 'Dynamic'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicIpAllocationMethod {
        Static,
        Dynamic,
    }
    #[doc = "The public IP address version. Possible values are: 'IPv4' and 'IPv6'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicIpAddressVersion {
        IPv4,
        IPv6,
    }
}
#[doc = "SKU of a public IP address"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressSku {
    #[doc = "Name of a public IP address SKU."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<public_ip_address_sku::Name>,
}
impl PublicIpAddressSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_address_sku {
    use super::*;
    #[doc = "Name of a public IP address SKU."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
    }
}
#[doc = "Parameters that define the resource to query the troubleshooting result."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryTroubleshootingParameters {
    #[doc = "The target resource ID to query the troubleshooting result."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
}
impl QueryTroubleshootingParameters {
    pub fn new(target_resource_id: String) -> Self {
        Self { target_resource_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RedirectTypeEnum {
    Permanent,
    Found,
    SeeOther,
    Temporary,
}
#[doc = "Common resource representation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ResourceNavigationLink resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of ResourceNavigationLink."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ResourceNavigationLinkFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ResourceNavigationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ResourceNavigationLink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLinkFormat {
    #[doc = "Resource type of the linked resource."]
    #[serde(rename = "linkedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_type: Option<String>,
    #[doc = "Link to the external resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[doc = "Provisioning state of the ResourceNavigationLink resource."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ResourceNavigationLinkFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the retention policy for flow log."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetentionPolicyParameters {
    #[doc = "Number of days to retain flow log records."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub days: Option<i64>,
    #[doc = "Flag to enable/disable retention."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl RetentionPolicyParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Route {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Route resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RoutePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Route {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RouteFilter {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Route Filter Resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteFilter {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[doc = "Response for the ListRouteFilters API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterListResult {
    #[doc = "Gets a list of route filters in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteFilter>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteFilterListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterPropertiesFormat {
    #[doc = "Collection of RouteFilterRules contained within a route filter."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<RouteFilterRule>,
    #[doc = "A collection of references to express route circuit peerings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCircuitPeering>,
    #[doc = "The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl RouteFilterPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Rule Resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Route Filter Rule Resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteFilterRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListRouteFilterRules API service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterRuleListResult {
    #[doc = "Gets a list of RouteFilterRules in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteFilterRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteFilterRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Filter Rule Resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RouteFilterRulePropertiesFormat {
    #[doc = "The access type of the rule. Valid values are: 'Allow', 'Deny'"]
    pub access: route_filter_rule_properties_format::Access,
    #[doc = "The rule type of the rule. Valid value is: 'Community'"]
    #[serde(rename = "routeFilterRuleType")]
    pub route_filter_rule_type: route_filter_rule_properties_format::RouteFilterRuleType,
    #[doc = "The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020']"]
    pub communities: Vec<String>,
    #[doc = "The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl RouteFilterRulePropertiesFormat {
    pub fn new(
        access: route_filter_rule_properties_format::Access,
        route_filter_rule_type: route_filter_rule_properties_format::RouteFilterRuleType,
        communities: Vec<String>,
    ) -> Self {
        Self {
            access,
            route_filter_rule_type,
            communities,
            provisioning_state: None,
        }
    }
}
pub mod route_filter_rule_properties_format {
    use super::*;
    #[doc = "The access type of the rule. Valid values are: 'Allow', 'Deny'"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
    #[doc = "The rule type of the rule. Valid value is: 'Community'"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RouteFilterRuleType {
        Community,
    }
}
#[doc = "Response for the ListRoute API service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteListResult {
    #[doc = "Gets a list of routes in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Route>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutePropertiesFormat {
    #[doc = "The destination CIDR to which the route applies."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'"]
    #[serde(rename = "nextHopType")]
    pub next_hop_type: route_properties_format::NextHopType,
    #[doc = "The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance."]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
    #[doc = "The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl RoutePropertiesFormat {
    pub fn new(next_hop_type: route_properties_format::NextHopType) -> Self {
        Self {
            address_prefix: None,
            next_hop_type,
            next_hop_ip_address: None,
            provisioning_state: None,
        }
    }
}
pub mod route_properties_format {
    use super::*;
    #[doc = "The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextHopType {
        VirtualNetworkGateway,
        VnetLocal,
        Internet,
        VirtualAppliance,
        None,
    }
}
#[doc = "Route table resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTable {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Route Table resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteTablePropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListRouteTable API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTableListResult {
    #[doc = "Gets a list of route tables in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteTable>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Table resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTablePropertiesFormat {
    #[doc = "Collection of routes contained within a route table."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<Route>,
    #[doc = "A collection of references to subnets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "Gets or sets whether to disable the routes learned by BGP on that route table. True means disable."]
    #[serde(rename = "disableBgpRoutePropagation", default, skip_serializing_if = "Option::is_none")]
    pub disable_bgp_route_propagation: Option<bool>,
    #[doc = "The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl RouteTablePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network interface and all its associated security rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityGroupNetworkInterface {
    #[doc = "ID of the network interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "All security rules associated with the network interface."]
    #[serde(rename = "securityRuleAssociations", default, skip_serializing_if = "Option::is_none")]
    pub security_rule_associations: Option<SecurityRuleAssociations>,
}
impl SecurityGroupNetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the VM to check security groups for."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityGroupViewParameters {
    #[doc = "ID of the target VM."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
}
impl SecurityGroupViewParameters {
    pub fn new(target_resource_id: String) -> Self {
        Self { target_resource_id }
    }
}
#[doc = "The information about security rules applied to the specified VM."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityGroupViewResult {
    #[doc = "List of network interfaces on the specified VM."]
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<SecurityGroupNetworkInterface>,
}
impl SecurityGroupViewResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network security rule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Security rule resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityRulePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl SecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "All security rules associated with the network interface."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRuleAssociations {
    #[doc = "Network interface and its custom security rules."]
    #[serde(rename = "networkInterfaceAssociation", default, skip_serializing_if = "Option::is_none")]
    pub network_interface_association: Option<NetworkInterfaceAssociation>,
    #[doc = "Network interface and its custom security rules."]
    #[serde(rename = "subnetAssociation", default, skip_serializing_if = "Option::is_none")]
    pub subnet_association: Option<SubnetAssociation>,
    #[doc = "Collection of default security rules of the network security group."]
    #[serde(rename = "defaultSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub default_security_rules: Vec<SecurityRule>,
    #[doc = "Collection of effective security rules."]
    #[serde(rename = "effectiveSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_security_rules: Vec<EffectiveNetworkSecurityRule>,
}
impl SecurityRuleAssociations {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a network security group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRuleListResult {
    #[doc = "The security rules in a network security group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityRule>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Security rule resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityRulePropertiesFormat {
    #[doc = "A description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'."]
    pub protocol: security_rule_properties_format::Protocol,
    #[doc = "The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports."]
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[doc = "The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports."]
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[doc = "The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. "]
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[doc = "The CIDR or source IP ranges."]
    #[serde(rename = "sourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub source_address_prefixes: Vec<String>,
    #[doc = "The application security group specified as source."]
    #[serde(rename = "sourceApplicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_application_security_groups: Vec<ApplicationSecurityGroup>,
    #[doc = "The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used."]
    #[serde(rename = "destinationAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub destination_address_prefix: Option<String>,
    #[doc = "The destination address prefixes. CIDR or destination IP ranges."]
    #[serde(rename = "destinationAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_address_prefixes: Vec<String>,
    #[doc = "The application security group specified as destination."]
    #[serde(rename = "destinationApplicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_application_security_groups: Vec<ApplicationSecurityGroup>,
    #[doc = "The source port ranges."]
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[doc = "The destination port ranges."]
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[doc = "The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'."]
    pub access: security_rule_properties_format::Access,
    #[doc = "The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'."]
    pub direction: security_rule_properties_format::Direction,
    #[doc = "The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl SecurityRulePropertiesFormat {
    pub fn new(
        protocol: security_rule_properties_format::Protocol,
        access: security_rule_properties_format::Access,
        direction: security_rule_properties_format::Direction,
    ) -> Self {
        Self {
            description: None,
            protocol,
            source_port_range: None,
            destination_port_range: None,
            source_address_prefix: None,
            source_address_prefixes: Vec::new(),
            source_application_security_groups: Vec::new(),
            destination_address_prefix: None,
            destination_address_prefixes: Vec::new(),
            destination_application_security_groups: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            access,
            priority: None,
            direction,
            provisioning_state: None,
        }
    }
}
pub mod security_rule_properties_format {
    use super::*;
    #[doc = "Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        #[serde(rename = "*")]
        U2a,
    }
    #[doc = "The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
    #[doc = "The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[doc = "The service endpoint properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPropertiesFormat {
    #[doc = "The type of the endpoint service."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub service: Option<String>,
    #[doc = "A list of locations."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[doc = "The provisioning state of the resource."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ServiceEndpointPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Reference to another subresource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[doc = "Resource ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Subnet in a virtual network resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Subnet {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the subnet."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubnetPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Subnet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network interface and its custom security rules."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetAssociation {
    #[doc = "Subnet ID."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Collection of custom security rules."]
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
}
impl SubnetAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetListResult {
    #[doc = "The subnets in a virtual network."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Subnet>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SubnetListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the subnet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetPropertiesFormat {
    #[doc = "The address prefix for the subnet."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "NetworkSecurityGroup resource."]
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[doc = "Route table resource."]
    #[serde(rename = "routeTable", default, skip_serializing_if = "Option::is_none")]
    pub route_table: Option<RouteTable>,
    #[doc = "An array of service endpoints."]
    #[serde(rename = "serviceEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoints: Vec<ServiceEndpointPropertiesFormat>,
    #[doc = "Gets an array of references to the network interface IP configurations using subnet."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<IpConfiguration>,
    #[doc = "Gets an array of references to the external resources using subnet."]
    #[serde(rename = "resourceNavigationLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_navigation_links: Vec<ResourceNavigationLink>,
    #[doc = "The provisioning state of the resource."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl SubnetPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Tags object for patch operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsObject {
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TagsObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Topology of the specified resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Topology {
    #[doc = "GUID representing the operation id."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The datetime when the topology was initially created for the resource group."]
    #[serde(rename = "createdDateTime", default, skip_serializing_if = "Option::is_none")]
    pub created_date_time: Option<String>,
    #[doc = "The datetime when the topology was last modified."]
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<TopologyResource>,
}
impl Topology {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Resources that have an association with the parent resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyAssociation {
    #[doc = "The name of the resource that is associated with the parent resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The ID of the resource that is associated with the parent resource."]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "The association type of the child resource to the parent resource."]
    #[serde(rename = "associationType", default, skip_serializing_if = "Option::is_none")]
    pub association_type: Option<topology_association::AssociationType>,
}
impl TopologyAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod topology_association {
    use super::*;
    #[doc = "The association type of the child resource to the parent resource."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AssociationType {
        Associated,
        Contains,
    }
}
#[doc = "Parameters that define the representation of topology."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyParameters {
    #[doc = "The name of the target resource group to perform topology on."]
    #[serde(rename = "targetResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_name: Option<String>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "targetVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub target_virtual_network: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "targetSubnet", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet: Option<SubResource>,
}
impl TopologyParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The network resource topology information for the given resource group."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyResource {
    #[doc = "Name of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "ID of the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource location."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Holds the associations the resource has with other resources in the resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub associations: Vec<TopologyAssociation>,
}
impl TopologyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TransportProtocol {
    Udp,
    Tcp,
    All,
}
#[doc = "Information gained from troubleshooting of specified resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TroubleshootingDetails {
    #[doc = "The id of the get troubleshoot operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Reason type of failure."]
    #[serde(rename = "reasonType", default, skip_serializing_if = "Option::is_none")]
    pub reason_type: Option<String>,
    #[doc = "A summary of troubleshooting."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub summary: Option<String>,
    #[doc = "Details on troubleshooting results."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub detail: Option<String>,
    #[doc = "List of recommended actions."]
    #[serde(rename = "recommendedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub recommended_actions: Vec<TroubleshootingRecommendedActions>,
}
impl TroubleshootingDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the resource to troubleshoot."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TroubleshootingParameters {
    #[doc = "The target resource to troubleshoot."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "Storage location provided for troubleshoot."]
    pub properties: TroubleshootingProperties,
}
impl TroubleshootingParameters {
    pub fn new(target_resource_id: String, properties: TroubleshootingProperties) -> Self {
        Self {
            target_resource_id,
            properties,
        }
    }
}
#[doc = "Storage location provided for troubleshoot."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TroubleshootingProperties {
    #[doc = "The ID for the storage account to save the troubleshoot result."]
    #[serde(rename = "storageId")]
    pub storage_id: String,
    #[doc = "The path to the blob to save the troubleshoot result in."]
    #[serde(rename = "storagePath")]
    pub storage_path: String,
}
impl TroubleshootingProperties {
    pub fn new(storage_id: String, storage_path: String) -> Self {
        Self { storage_id, storage_path }
    }
}
#[doc = "Recommended actions based on discovered issues."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TroubleshootingRecommendedActions {
    #[doc = "ID of the recommended action."]
    #[serde(rename = "actionId", default, skip_serializing_if = "Option::is_none")]
    pub action_id: Option<String>,
    #[doc = "Description of recommended actions."]
    #[serde(rename = "actionText", default, skip_serializing_if = "Option::is_none")]
    pub action_text: Option<String>,
    #[doc = "The uri linking to a documentation for the recommended troubleshooting actions."]
    #[serde(rename = "actionUri", default, skip_serializing_if = "Option::is_none")]
    pub action_uri: Option<String>,
    #[doc = "The information from the URI for the recommended troubleshooting actions."]
    #[serde(rename = "actionUriText", default, skip_serializing_if = "Option::is_none")]
    pub action_uri_text: Option<String>,
}
impl TroubleshootingRecommendedActions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Troubleshooting information gained from specified resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TroubleshootingResult {
    #[doc = "The start time of the troubleshooting."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time of the troubleshooting."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The result code of the troubleshooting."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Information from troubleshooting."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub results: Vec<TroubleshootingDetails>,
}
impl TroubleshootingResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualNetworkGatewayConnection properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TunnelConnectionHealth {
    #[doc = "Tunnel name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tunnel: Option<String>,
    #[doc = "Virtual network Gateway connection status"]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<tunnel_connection_health::ConnectionStatus>,
    #[doc = "The Ingress Bytes Transferred in this connection"]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[doc = "The Egress Bytes Transferred in this connection"]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "The time at which connection was established in Utc format."]
    #[serde(rename = "lastConnectionEstablishedUtcTime", default, skip_serializing_if = "Option::is_none")]
    pub last_connection_established_utc_time: Option<String>,
}
impl TunnelConnectionHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod tunnel_connection_health {
    use super::*;
    #[doc = "Virtual network Gateway connection status"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connecting,
        Connected,
        NotConnected,
    }
}
#[doc = "Describes network resource usage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    #[doc = "Resource identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "An enum describing the unit of measurement."]
    pub unit: usage::Unit,
    #[doc = "The current value of the usage."]
    #[serde(rename = "currentValue")]
    pub current_value: i64,
    #[doc = "The limit of usage."]
    pub limit: i64,
    #[doc = "The usage names."]
    pub name: UsageName,
}
impl Usage {
    pub fn new(unit: usage::Unit, current_value: i64, limit: i64, name: UsageName) -> Self {
        Self {
            id: None,
            unit,
            current_value,
            limit,
            name,
        }
    }
}
pub mod usage {
    use super::*;
    #[doc = "An enum describing the unit of measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[doc = "The usage names."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[doc = "A string describing the resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "A localized string describing the resource name."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The list usages operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsagesListResult {
    #[doc = "The list network resource usages."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UsagesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters that define the IP flow to be verified."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerificationIpFlowParameters {
    #[doc = "The ID of the target resource to perform next-hop on."]
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[doc = "The direction of the packet represented as a 5-tuple."]
    pub direction: verification_ip_flow_parameters::Direction,
    #[doc = "Protocol to be verified on."]
    pub protocol: verification_ip_flow_parameters::Protocol,
    #[doc = "The local port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction."]
    #[serde(rename = "localPort")]
    pub local_port: String,
    #[doc = "The remote port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction."]
    #[serde(rename = "remotePort")]
    pub remote_port: String,
    #[doc = "The local IP address. Acceptable values are valid IPv4 addresses."]
    #[serde(rename = "localIPAddress")]
    pub local_ip_address: String,
    #[doc = "The remote IP address. Acceptable values are valid IPv4 addresses."]
    #[serde(rename = "remoteIPAddress")]
    pub remote_ip_address: String,
    #[doc = "The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of them, then this parameter must be specified. Otherwise optional)."]
    #[serde(rename = "targetNicResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_resource_id: Option<String>,
}
impl VerificationIpFlowParameters {
    pub fn new(
        target_resource_id: String,
        direction: verification_ip_flow_parameters::Direction,
        protocol: verification_ip_flow_parameters::Protocol,
        local_port: String,
        remote_port: String,
        local_ip_address: String,
        remote_ip_address: String,
    ) -> Self {
        Self {
            target_resource_id,
            direction,
            protocol,
            local_port,
            remote_port,
            local_ip_address,
            remote_ip_address,
            target_nic_resource_id: None,
        }
    }
}
pub mod verification_ip_flow_parameters {
    use super::*;
    #[doc = "The direction of the packet represented as a 5-tuple."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
    #[doc = "Protocol to be verified on."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
    }
}
#[doc = "Results of IP flow verification on the target resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VerificationIpFlowResult {
    #[doc = "Indicates whether the traffic is allowed or denied."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<verification_ip_flow_result::Access>,
    #[doc = "Name of the rule. If input is not matched against any security rule, it is not displayed."]
    #[serde(rename = "ruleName", default, skip_serializing_if = "Option::is_none")]
    pub rule_name: Option<String>,
}
impl VerificationIpFlowResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod verification_ip_flow_result {
    use super::*;
    #[doc = "Indicates whether the traffic is allowed or denied."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
}
#[doc = "Virtual Network resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetwork {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of the virtual network."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A common class for general resource information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "VirtualNetworkGateway properties"]
    pub properties: VirtualNetworkGatewayPropertiesFormat,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGateway {
    pub fn new(properties: VirtualNetworkGatewayPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[doc = "A common class for general resource information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "VirtualNetworkGatewayConnection properties"]
    pub properties: VirtualNetworkGatewayConnectionPropertiesFormat,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayConnection {
    pub fn new(properties: VirtualNetworkGatewayConnectionPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[doc = "A common class for general resource information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionListEntity {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "VirtualNetworkGatewayConnection properties"]
    pub properties: VirtualNetworkGatewayConnectionListEntityPropertiesFormat,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayConnectionListEntity {
    pub fn new(properties: VirtualNetworkGatewayConnectionListEntityPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[doc = "VirtualNetworkGatewayConnection properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionListEntityPropertiesFormat {
    #[doc = "The authorizationKey."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "A reference to VirtualNetworkGateway or LocalNetworkGateway resource."]
    #[serde(rename = "virtualNetworkGateway1")]
    pub virtual_network_gateway1: VirtualNetworkConnectionGatewayReference,
    #[doc = "A reference to VirtualNetworkGateway or LocalNetworkGateway resource."]
    #[serde(rename = "virtualNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway2: Option<VirtualNetworkConnectionGatewayReference>,
    #[doc = "A reference to VirtualNetworkGateway or LocalNetworkGateway resource."]
    #[serde(rename = "localNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub local_network_gateway2: Option<VirtualNetworkConnectionGatewayReference>,
    #[doc = "Gateway connection type. Possible values are: 'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient."]
    #[serde(rename = "connectionType")]
    pub connection_type: virtual_network_gateway_connection_list_entity_properties_format::ConnectionType,
    #[doc = "The routing weight."]
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[doc = "The IPSec shared key."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "Virtual network Gateway connection status. Possible values are 'Unknown', 'Connecting', 'Connected' and 'NotConnected'."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<virtual_network_gateway_connection_list_entity_properties_format::ConnectionStatus>,
    #[doc = "Collection of all tunnels' connection health status."]
    #[serde(rename = "tunnelConnectionStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_connection_status: Vec<TunnelConnectionHealth>,
    #[doc = "The egress bytes transferred in this connection."]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "The ingress bytes transferred in this connection."]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub peer: Option<SubResource>,
    #[doc = "EnableBgp flag"]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "Enable policy-based traffic selectors."]
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[doc = "The IPSec Policies to be considered by this connection."]
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[doc = "The resource GUID property of the VirtualNetworkGatewayConnection resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the VirtualNetworkGatewayConnection resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkGatewayConnectionListEntityPropertiesFormat {
    pub fn new(
        virtual_network_gateway1: VirtualNetworkConnectionGatewayReference,
        connection_type: virtual_network_gateway_connection_list_entity_properties_format::ConnectionType,
    ) -> Self {
        Self {
            authorization_key: None,
            virtual_network_gateway1,
            virtual_network_gateway2: None,
            local_network_gateway2: None,
            connection_type,
            routing_weight: None,
            shared_key: None,
            connection_status: None,
            tunnel_connection_status: Vec::new(),
            egress_bytes_transferred: None,
            ingress_bytes_transferred: None,
            peer: None,
            enable_bgp: None,
            use_policy_based_traffic_selectors: None,
            ipsec_policies: Vec::new(),
            resource_guid: None,
            provisioning_state: None,
        }
    }
}
pub mod virtual_network_gateway_connection_list_entity_properties_format {
    use super::*;
    #[doc = "Gateway connection type. Possible values are: 'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionType {
        IPsec,
        Vnet2Vnet,
        ExpressRoute,
        #[serde(rename = "VPNClient")]
        VpnClient,
    }
    #[doc = "Virtual network Gateway connection status. Possible values are 'Unknown', 'Connecting', 'Connected' and 'NotConnected'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connecting,
        Connected,
        NotConnected,
    }
}
#[doc = "Response for the ListVirtualNetworkGatewayConnections API service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayConnectionListResult {
    #[doc = "Gets a list of VirtualNetworkGatewayConnection resources that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayConnection>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualNetworkGatewayConnection properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionPropertiesFormat {
    #[doc = "The authorizationKey."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "A common class for general resource information"]
    #[serde(rename = "virtualNetworkGateway1")]
    pub virtual_network_gateway1: VirtualNetworkGateway,
    #[doc = "A common class for general resource information"]
    #[serde(rename = "virtualNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway2: Option<VirtualNetworkGateway>,
    #[doc = "A common class for general resource information"]
    #[serde(rename = "localNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub local_network_gateway2: Option<LocalNetworkGateway>,
    #[doc = "Gateway connection type. Possible values are: 'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient."]
    #[serde(rename = "connectionType")]
    pub connection_type: virtual_network_gateway_connection_properties_format::ConnectionType,
    #[doc = "The routing weight."]
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[doc = "The IPSec shared key."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "Virtual network Gateway connection status. Possible values are 'Unknown', 'Connecting', 'Connected' and 'NotConnected'."]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<virtual_network_gateway_connection_properties_format::ConnectionStatus>,
    #[doc = "Collection of all tunnels' connection health status."]
    #[serde(rename = "tunnelConnectionStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_connection_status: Vec<TunnelConnectionHealth>,
    #[doc = "The egress bytes transferred in this connection."]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "The ingress bytes transferred in this connection."]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub peer: Option<SubResource>,
    #[doc = "EnableBgp flag"]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "Enable policy-based traffic selectors."]
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[doc = "The IPSec Policies to be considered by this connection."]
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[doc = "The resource GUID property of the VirtualNetworkGatewayConnection resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the VirtualNetworkGatewayConnection resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkGatewayConnectionPropertiesFormat {
    pub fn new(
        virtual_network_gateway1: VirtualNetworkGateway,
        connection_type: virtual_network_gateway_connection_properties_format::ConnectionType,
    ) -> Self {
        Self {
            authorization_key: None,
            virtual_network_gateway1,
            virtual_network_gateway2: None,
            local_network_gateway2: None,
            connection_type,
            routing_weight: None,
            shared_key: None,
            connection_status: None,
            tunnel_connection_status: Vec::new(),
            egress_bytes_transferred: None,
            ingress_bytes_transferred: None,
            peer: None,
            enable_bgp: None,
            use_policy_based_traffic_selectors: None,
            ipsec_policies: Vec::new(),
            resource_guid: None,
            provisioning_state: None,
        }
    }
}
pub mod virtual_network_gateway_connection_properties_format {
    use super::*;
    #[doc = "Gateway connection type. Possible values are: 'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionType {
        IPsec,
        Vnet2Vnet,
        ExpressRoute,
        #[serde(rename = "VPNClient")]
        VpnClient,
    }
    #[doc = "Virtual network Gateway connection status. Possible values are 'Unknown', 'Connecting', 'Connected' and 'NotConnected'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connecting,
        Connected,
        NotConnected,
    }
}
#[doc = "IP configuration for virtual network gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of VirtualNetworkGatewayIPConfiguration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkGatewayIpConfigurationPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of VirtualNetworkGatewayIPConfiguration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    #[doc = "The private IP allocation method. Possible values are: 'Static' and 'Dynamic'."]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<virtual_network_gateway_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[doc = "Reference to another subresource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[doc = "The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_ip_configuration_properties_format {
    use super::*;
    #[doc = "The private IP allocation method. Possible values are: 'Static' and 'Dynamic'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[doc = "Response for the VirtualNetworkGatewayListConnections API service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayListConnectionsResult {
    #[doc = "Gets a list of VirtualNetworkGatewayConnection resources that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayConnectionListEntity>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayListConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the ListVirtualNetworkGateways API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayListResult {
    #[doc = "Gets a list of VirtualNetworkGateway resources that exists in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGateway>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualNetworkGateway properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayPropertiesFormat {
    #[doc = "IP configurations for virtual network gateway."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<VirtualNetworkGatewayIpConfiguration>,
    #[doc = "The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'."]
    #[serde(rename = "gatewayType", default, skip_serializing_if = "Option::is_none")]
    pub gateway_type: Option<virtual_network_gateway_properties_format::GatewayType>,
    #[doc = "The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'."]
    #[serde(rename = "vpnType", default, skip_serializing_if = "Option::is_none")]
    pub vpn_type: Option<virtual_network_gateway_properties_format::VpnType>,
    #[doc = "Whether BGP is enabled for this virtual network gateway or not."]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "ActiveActive flag"]
    #[serde(rename = "activeActive", default, skip_serializing_if = "Option::is_none")]
    pub active_active: Option<bool>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "gatewayDefaultSite", default, skip_serializing_if = "Option::is_none")]
    pub gateway_default_site: Option<SubResource>,
    #[doc = "VirtualNetworkGatewaySku details"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<VirtualNetworkGatewaySku>,
    #[doc = "VpnClientConfiguration for P2S client."]
    #[serde(rename = "vpnClientConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_configuration: Option<VpnClientConfiguration>,
    #[doc = "BGP settings details"]
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[doc = "The resource GUID property of the VirtualNetworkGateway resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the VirtualNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_properties_format {
    use super::*;
    #[doc = "The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GatewayType {
        Vpn,
        ExpressRoute,
    }
    #[doc = "The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VpnType {
        PolicyBased,
        RouteBased,
    }
}
#[doc = "VirtualNetworkGatewaySku details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewaySku {
    #[doc = "Gateway SKU name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<virtual_network_gateway_sku::Name>,
    #[doc = "Gateway SKU tier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<virtual_network_gateway_sku::Tier>,
    #[doc = "The capacity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl VirtualNetworkGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_sku {
    use super::*;
    #[doc = "Gateway SKU name."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
    }
    #[doc = "Gateway SKU tier."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
    }
}
#[doc = "Response for the ListVirtualNetworks API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkListResult {
    #[doc = "Gets a list of VirtualNetwork resources in a resource group."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetwork>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for the virtual networks GetUsage API service call."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkListUsageResult {
    #[doc = "VirtualNetwork usage stats."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkUsage>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkListUsageResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peerings in a virtual network resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the virtual network peering."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPeeringPropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringListResult {
    #[doc = "The peerings in a virtual network."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkPeering>,
    #[doc = "The URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the virtual network peering."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringPropertiesFormat {
    #[doc = "Whether the VMs in the linked virtual network space would be able to access all the VMs in local Virtual network space."]
    #[serde(rename = "allowVirtualNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub allow_virtual_network_access: Option<bool>,
    #[doc = "Whether the forwarded traffic from the VMs in the remote virtual network will be allowed/disallowed."]
    #[serde(rename = "allowForwardedTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_forwarded_traffic: Option<bool>,
    #[doc = "If gateway links can be used in remote virtual networking to link to this virtual network."]
    #[serde(rename = "allowGatewayTransit", default, skip_serializing_if = "Option::is_none")]
    pub allow_gateway_transit: Option<bool>,
    #[doc = "If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway."]
    #[serde(rename = "useRemoteGateways", default, skip_serializing_if = "Option::is_none")]
    pub use_remote_gateways: Option<bool>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "remoteVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub remote_virtual_network: Option<SubResource>,
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "remoteAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub remote_address_space: Option<AddressSpace>,
    #[doc = "The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and 'Disconnected'."]
    #[serde(rename = "peeringState", default, skip_serializing_if = "Option::is_none")]
    pub peering_state: Option<virtual_network_peering_properties_format::PeeringState>,
    #[doc = "The provisioning state of the resource."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkPeeringPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_peering_properties_format {
    use super::*;
    #[doc = "The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and 'Disconnected'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PeeringState {
        Initiated,
        Connected,
        Disconnected,
    }
}
#[doc = "Properties of the virtual network."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPropertiesFormat {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "addressSpace", default, skip_serializing_if = "Option::is_none")]
    pub address_space: Option<AddressSpace>,
    #[doc = "DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options."]
    #[serde(rename = "dhcpOptions", default, skip_serializing_if = "Option::is_none")]
    pub dhcp_options: Option<DhcpOptions>,
    #[doc = "A list of subnets in a Virtual Network."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "A list of peerings in a Virtual Network."]
    #[serde(rename = "virtualNetworkPeerings", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_peerings: Vec<VirtualNetworkPeering>,
    #[doc = "The resourceGuid property of the Virtual Network resource."]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection plan associated with the resource."]
    #[serde(rename = "enableDdosProtection", default, skip_serializing_if = "Option::is_none")]
    pub enable_ddos_protection: Option<bool>,
    #[doc = "Indicates if VM protection is enabled for all the subnets in the virtual network."]
    #[serde(rename = "enableVmProtection", default, skip_serializing_if = "Option::is_none")]
    pub enable_vm_protection: Option<bool>,
    #[doc = "Reference to another subresource."]
    #[serde(rename = "ddosProtectionPlan", default, skip_serializing_if = "Option::is_none")]
    pub ddos_protection_plan: Option<SubResource>,
}
impl VirtualNetworkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Usage details for subnet."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkUsage {
    #[doc = "Indicates number of IPs used from the Subnet."]
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<f64>,
    #[doc = "Subnet identifier."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Indicates the size of the subnet."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<f64>,
    #[doc = "Usage strings container."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<VirtualNetworkUsageName>,
    #[doc = "Usage units. Returns 'Count'"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
}
impl VirtualNetworkUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Usage strings container."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkUsageName {
    #[doc = "Localized subnet size and usage string."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
    #[doc = "Subnet size and usage string."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl VirtualNetworkUsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnClientConfiguration for P2S client."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConfiguration {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network."]
    #[serde(rename = "vpnClientAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_address_pool: Option<AddressSpace>,
    #[doc = "VpnClientRootCertificate for virtual network gateway."]
    #[serde(rename = "vpnClientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_root_certificates: Vec<VpnClientRootCertificate>,
    #[doc = "VpnClientRevokedCertificate for Virtual network gateway."]
    #[serde(rename = "vpnClientRevokedCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_revoked_certificates: Vec<VpnClientRevokedCertificate>,
    #[doc = "VpnClientProtocols for Virtual network gateway."]
    #[serde(rename = "vpnClientProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_protocols: Vec<String>,
    #[doc = "VpnClientIpsecPolicies for virtual network gateway P2S client."]
    #[serde(rename = "vpnClientIpsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_ipsec_policies: Vec<IpsecPolicy>,
    #[doc = "The radius server address property of the VirtualNetworkGateway resource for vpn client connection."]
    #[serde(rename = "radiusServerAddress", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_address: Option<String>,
    #[doc = "The radius secret property of the VirtualNetworkGateway resource for vpn client connection."]
    #[serde(rename = "radiusServerSecret", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_secret: Option<String>,
}
impl VpnClientConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An IPSec parameters for a virtual network gateway P2S connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientIPsecParameters {
    #[doc = "The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client."]
    #[serde(rename = "saLifeTimeSeconds")]
    pub sa_life_time_seconds: i32,
    #[doc = "The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client.."]
    #[serde(rename = "saDataSizeKilobytes")]
    pub sa_data_size_kilobytes: i32,
    #[doc = "The IPSec encryption algorithm (IKE phase 1)."]
    #[serde(rename = "ipsecEncryption")]
    pub ipsec_encryption: vpn_client_i_psec_parameters::IpsecEncryption,
    #[doc = "The IPSec integrity algorithm (IKE phase 1)."]
    #[serde(rename = "ipsecIntegrity")]
    pub ipsec_integrity: vpn_client_i_psec_parameters::IpsecIntegrity,
    #[doc = "The IKE encryption algorithm (IKE phase 2)."]
    #[serde(rename = "ikeEncryption")]
    pub ike_encryption: vpn_client_i_psec_parameters::IkeEncryption,
    #[doc = "The IKE integrity algorithm (IKE phase 2)."]
    #[serde(rename = "ikeIntegrity")]
    pub ike_integrity: vpn_client_i_psec_parameters::IkeIntegrity,
    #[doc = "The DH Groups used in IKE Phase 1 for initial SA."]
    #[serde(rename = "dhGroup")]
    pub dh_group: vpn_client_i_psec_parameters::DhGroup,
    #[doc = "The Pfs Groups used in IKE Phase 2 for new child SA."]
    #[serde(rename = "pfsGroup")]
    pub pfs_group: vpn_client_i_psec_parameters::PfsGroup,
}
impl VpnClientIPsecParameters {
    pub fn new(
        sa_life_time_seconds: i32,
        sa_data_size_kilobytes: i32,
        ipsec_encryption: vpn_client_i_psec_parameters::IpsecEncryption,
        ipsec_integrity: vpn_client_i_psec_parameters::IpsecIntegrity,
        ike_encryption: vpn_client_i_psec_parameters::IkeEncryption,
        ike_integrity: vpn_client_i_psec_parameters::IkeIntegrity,
        dh_group: vpn_client_i_psec_parameters::DhGroup,
        pfs_group: vpn_client_i_psec_parameters::PfsGroup,
    ) -> Self {
        Self {
            sa_life_time_seconds,
            sa_data_size_kilobytes,
            ipsec_encryption,
            ipsec_integrity,
            ike_encryption,
            ike_integrity,
            dh_group,
            pfs_group,
        }
    }
}
pub mod vpn_client_i_psec_parameters {
    use super::*;
    #[doc = "The IPSec encryption algorithm (IKE phase 1)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IpsecEncryption {
        None,
        #[serde(rename = "DES")]
        Des,
        #[serde(rename = "DES3")]
        Des3,
        #[serde(rename = "AES128")]
        Aes128,
        #[serde(rename = "AES192")]
        Aes192,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
        #[serde(rename = "GCMAES192")]
        Gcmaes192,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
    }
    #[doc = "The IPSec integrity algorithm (IKE phase 1)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IpsecIntegrity {
        #[serde(rename = "MD5")]
        Md5,
        #[serde(rename = "SHA1")]
        Sha1,
        #[serde(rename = "SHA256")]
        Sha256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
        #[serde(rename = "GCMAES192")]
        Gcmaes192,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
    }
    #[doc = "The IKE encryption algorithm (IKE phase 2)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IkeEncryption {
        #[serde(rename = "DES")]
        Des,
        #[serde(rename = "DES3")]
        Des3,
        #[serde(rename = "AES128")]
        Aes128,
        #[serde(rename = "AES192")]
        Aes192,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
    }
    #[doc = "The IKE integrity algorithm (IKE phase 2)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IkeIntegrity {
        #[serde(rename = "MD5")]
        Md5,
        #[serde(rename = "SHA1")]
        Sha1,
        #[serde(rename = "SHA256")]
        Sha256,
        #[serde(rename = "SHA384")]
        Sha384,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
    }
    #[doc = "The DH Groups used in IKE Phase 1 for initial SA."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DhGroup {
        None,
        #[serde(rename = "DHGroup1")]
        DhGroup1,
        #[serde(rename = "DHGroup2")]
        DhGroup2,
        #[serde(rename = "DHGroup14")]
        DhGroup14,
        #[serde(rename = "DHGroup2048")]
        DhGroup2048,
        #[serde(rename = "ECP256")]
        Ecp256,
        #[serde(rename = "ECP384")]
        Ecp384,
        #[serde(rename = "DHGroup24")]
        DhGroup24,
    }
    #[doc = "The Pfs Groups used in IKE Phase 2 for new child SA."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PfsGroup {
        None,
        #[serde(rename = "PFS1")]
        Pfs1,
        #[serde(rename = "PFS2")]
        Pfs2,
        #[serde(rename = "PFS2048")]
        Pfs2048,
        #[serde(rename = "ECP256")]
        Ecp256,
        #[serde(rename = "ECP384")]
        Ecp384,
        #[serde(rename = "PFS24")]
        Pfs24,
        #[serde(rename = "PFS14")]
        Pfs14,
        #[serde(rename = "PFSMM")]
        Pfsmm,
    }
}
#[doc = "Vpn Client Parameters for package generation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientParameters {
    #[doc = "VPN client Processor Architecture. Possible values are: 'AMD64' and 'X86'."]
    #[serde(rename = "processorArchitecture", default, skip_serializing_if = "Option::is_none")]
    pub processor_architecture: Option<vpn_client_parameters::ProcessorArchitecture>,
    #[doc = "VPN client Authentication Method. Possible values are: 'EAPTLS' and 'EAPMSCHAPv2'."]
    #[serde(rename = "authenticationMethod", default, skip_serializing_if = "Option::is_none")]
    pub authentication_method: Option<vpn_client_parameters::AuthenticationMethod>,
    #[doc = "The public certificate data for the radius server authentication certificate as a Base-64 encoded string. Required only if external radius authentication has been configured with EAPTLS authentication."]
    #[serde(rename = "radiusServerAuthCertificate", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_auth_certificate: Option<String>,
    #[doc = "A list of client root certificates public certificate data encoded as Base-64 strings. Optional parameter for external radius based authentication with EAPTLS."]
    #[serde(rename = "clientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub client_root_certificates: Vec<String>,
}
impl VpnClientParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vpn_client_parameters {
    use super::*;
    #[doc = "VPN client Processor Architecture. Possible values are: 'AMD64' and 'X86'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProcessorArchitecture {
        Amd64,
        X86,
    }
    #[doc = "VPN client Authentication Method. Possible values are: 'EAPTLS' and 'EAPMSCHAPv2'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationMethod {
        #[serde(rename = "EAPTLS")]
        Eaptls,
        #[serde(rename = "EAPMSCHAPv2")]
        EapmschaPv2,
    }
}
#[doc = "VPN client revoked certificate of virtual network gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the revoked VPN client certificate of virtual network gateway."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnClientRevokedCertificatePropertiesFormat>,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRevokedCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the revoked VPN client certificate of virtual network gateway."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificatePropertiesFormat {
    #[doc = "The revoked VPN client certificate thumbprint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VpnClientRevokedCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VPN client root certificate of virtual network gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientRootCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of SSL certificates of application gateway"]
    pub properties: VpnClientRootCertificatePropertiesFormat,
    #[doc = "The name of the resource that is unique within a resource group. This name can be used to access the resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRootCertificate {
    pub fn new(properties: VpnClientRootCertificatePropertiesFormat) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
            name: None,
            etag: None,
        }
    }
}
#[doc = "Properties of SSL certificates of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientRootCertificatePropertiesFormat {
    #[doc = "The certificate public data."]
    #[serde(rename = "publicCertData")]
    pub public_cert_data: String,
    #[doc = "The provisioning state of the VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VpnClientRootCertificatePropertiesFormat {
    pub fn new(public_cert_data: String) -> Self {
        Self {
            public_cert_data,
            provisioning_state: None,
        }
    }
}
#[doc = "Vpn device configuration script generation parameters"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnDeviceScriptParameters {
    #[doc = "The vendor for the vpn device."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
    #[doc = "The device family for the vpn device."]
    #[serde(rename = "deviceFamily", default, skip_serializing_if = "Option::is_none")]
    pub device_family: Option<String>,
    #[doc = "The firmware version for the vpn device."]
    #[serde(rename = "firmwareVersion", default, skip_serializing_if = "Option::is_none")]
    pub firmware_version: Option<String>,
}
impl VpnDeviceScriptParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A reference to VirtualNetworkGateway or LocalNetworkGateway resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkConnectionGatewayReference {
    #[doc = "The ID of VirtualNetworkGateway or LocalNetworkGateway resource."]
    pub id: String,
}
impl VirtualNetworkConnectionGatewayReference {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
