#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressSpace {
    #[doc = "Gets or sets list of address blocks reserved for this virtual network in CIDR notation"]
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
}
impl AddressSpace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ApplicationGateways resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of Application Gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPropertiesFormat>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Authentication certificates of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAuthenticationCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Authentication certificates of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayAuthenticationCertificatePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayAuthenticationCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Authentication certificates of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAuthenticationCertificatePropertiesFormat {
    #[doc = "Certificate public data "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[doc = "Provisioning state of the authentication certificate resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayAuthenticationCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Backend Address of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddress {
    #[doc = "Dns name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "Ip address"]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
}
impl ApplicationGatewayBackendAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Backend Address Pool of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Backend Address Pool of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayBackendAddressPoolPropertiesFormat>,
    #[doc = "Resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayBackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Backend Address Pool of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPoolPropertiesFormat {
    #[doc = "Collection of references to IPs defined in NICs"]
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "Backend addresses"]
    #[serde(rename = "backendAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_addresses: Vec<ApplicationGatewayBackendAddress>,
    #[doc = "Provisioning state of the backend address pool resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayBackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Backend address pool settings of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHttpSettings {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Backend address pool settings of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayBackendHttpSettingsPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayBackendHttpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Backend address pool settings of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHttpSettingsPropertiesFormat {
    #[doc = "Port"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "Protocol"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<application_gateway_backend_http_settings_properties_format::Protocol>,
    #[doc = "Cookie affinity"]
    #[serde(rename = "cookieBasedAffinity", default, skip_serializing_if = "Option::is_none")]
    pub cookie_based_affinity: Option<application_gateway_backend_http_settings_properties_format::CookieBasedAffinity>,
    #[doc = "Request timeout"]
    #[serde(rename = "requestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub request_timeout: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub probe: Option<SubResource>,
    #[doc = "Array of references to Application Gateway Authentication Certificates"]
    #[serde(rename = "authenticationCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub authentication_certificates: Vec<SubResource>,
    #[doc = "Provisioning state of the backend http settings resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayBackendHttpSettingsPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_backend_http_settings_properties_format {
    use super::*;
    #[doc = "Protocol"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Https,
    }
    #[doc = "Cookie affinity"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CookieBasedAffinity {
        Enabled,
        Disabled,
    }
}
#[doc = "Frontend IP configuration of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Frontend IP configuration of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFrontendIpConfigurationPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayFrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Frontend IP configuration of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendIpConfigurationPropertiesFormat {
    #[doc = "PrivateIPAddress of the Network Interface IP Configuration"]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "PrivateIP allocation method (Static/Dynamic)"]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<application_gateway_frontend_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[doc = "Provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayFrontendIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_frontend_ip_configuration_properties_format {
    use super::*;
    #[doc = "PrivateIP allocation method (Static/Dynamic)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[doc = "Frontend Port of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendPort {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Frontend Port of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFrontendPortPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayFrontendPort {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Frontend Port of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendPortPropertiesFormat {
    #[doc = "Frontend port"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[doc = "Provisioning state of the frontend port resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayFrontendPortPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Http listener of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHttpListener {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Http listener of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayHttpListenerPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayHttpListener {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Http listener of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHttpListenerPropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<SubResource>,
    #[doc = "Protocol"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<application_gateway_http_listener_properties_format::Protocol>,
    #[doc = "Host name of http listener "]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "sslCertificate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_certificate: Option<SubResource>,
    #[doc = "RequireServerNameIndication of http listener "]
    #[serde(rename = "requireServerNameIndication", default, skip_serializing_if = "Option::is_none")]
    pub require_server_name_indication: Option<bool>,
    #[doc = "Provisioning state of the http listener resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayHttpListenerPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_http_listener_properties_format {
    use super::*;
    #[doc = "Protocol"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Https,
    }
}
#[doc = "IP configuration of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IP configuration of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayIpConfigurationPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IP configuration of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayIpConfigurationPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[doc = "Provisioning state of the application gateway subnet resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListApplicationGateways Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayListResult {
    #[doc = "List of ApplicationGateways in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGateway>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Path rule of URL path map of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPathRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of probe of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPathRulePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayPathRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of probe of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPathRulePropertiesFormat {
    #[doc = "Path rules of URL path map"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub paths: Vec<String>,
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
    #[doc = "Path rule of URL path map resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayPathRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Probe of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbe {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of probe of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayProbePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayProbe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of probe of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbePropertiesFormat {
    #[doc = "Protocol"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<application_gateway_probe_properties_format::Protocol>,
    #[doc = "Host to send probe to "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[doc = "Relative path of probe "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "Probing interval in seconds "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[doc = "Probing timeout in seconds "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[doc = "Probing unhealthy threshold "]
    #[serde(rename = "unhealthyThreshold", default, skip_serializing_if = "Option::is_none")]
    pub unhealthy_threshold: Option<i32>,
    #[doc = "Provisioning state of the backend http settings resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayProbePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_probe_properties_format {
    use super::*;
    #[doc = "Protocol"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Https,
    }
}
#[doc = "Properties of Application Gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPropertiesFormat {
    #[doc = "SKU of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ApplicationGatewaySku>,
    #[doc = "Application gateway SSL policy"]
    #[serde(rename = "sslPolicy", default, skip_serializing_if = "Option::is_none")]
    pub ssl_policy: Option<ApplicationGatewaySslPolicy>,
    #[doc = "Operational state of application gateway resource"]
    #[serde(rename = "operationalState", default, skip_serializing_if = "Option::is_none")]
    pub operational_state: Option<application_gateway_properties_format::OperationalState>,
    #[doc = "Subnets of application gateway resource"]
    #[serde(rename = "gatewayIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub gateway_ip_configurations: Vec<ApplicationGatewayIpConfiguration>,
    #[doc = "Authentication certificates of application gateway resource"]
    #[serde(rename = "authenticationCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub authentication_certificates: Vec<ApplicationGatewayAuthenticationCertificate>,
    #[doc = "SSL certificates of application gateway resource"]
    #[serde(rename = "sslCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub ssl_certificates: Vec<ApplicationGatewaySslCertificate>,
    #[doc = "Frontend IP addresses of application gateway resource"]
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<ApplicationGatewayFrontendIpConfiguration>,
    #[doc = "Frontend ports of application gateway resource"]
    #[serde(rename = "frontendPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ports: Vec<ApplicationGatewayFrontendPort>,
    #[doc = "Probes of application gateway resource"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub probes: Vec<ApplicationGatewayProbe>,
    #[doc = "Backend address pool of application gateway resource"]
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<ApplicationGatewayBackendAddressPool>,
    #[doc = "Backend http settings of application gateway resource"]
    #[serde(rename = "backendHttpSettingsCollection", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_http_settings_collection: Vec<ApplicationGatewayBackendHttpSettings>,
    #[doc = "HTTP listeners of application gateway resource"]
    #[serde(rename = "httpListeners", default, skip_serializing_if = "Vec::is_empty")]
    pub http_listeners: Vec<ApplicationGatewayHttpListener>,
    #[doc = "URL path map of application gateway resource"]
    #[serde(rename = "urlPathMaps", default, skip_serializing_if = "Vec::is_empty")]
    pub url_path_maps: Vec<ApplicationGatewayUrlPathMap>,
    #[doc = "Request routing rules of application gateway resource"]
    #[serde(rename = "requestRoutingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub request_routing_rules: Vec<ApplicationGatewayRequestRoutingRule>,
    #[doc = "Resource guid property of the ApplicationGateway resource"]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Provisioning state of the ApplicationGateway resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_properties_format {
    use super::*;
    #[doc = "Operational state of application gateway resource"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationalState {
        Stopped,
        Starting,
        Running,
        Stopping,
    }
}
#[doc = "Request routing rule of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRequestRoutingRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Request routing rule of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayRequestRoutingRulePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayRequestRoutingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Request routing rule of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRequestRoutingRulePropertiesFormat {
    #[doc = "Rule type"]
    #[serde(rename = "ruleType", default, skip_serializing_if = "Option::is_none")]
    pub rule_type: Option<application_gateway_request_routing_rule_properties_format::RuleType>,
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
    #[serde(rename = "httpListener", default, skip_serializing_if = "Option::is_none")]
    pub http_listener: Option<SubResource>,
    #[serde(rename = "urlPathMap", default, skip_serializing_if = "Option::is_none")]
    pub url_path_map: Option<SubResource>,
    #[doc = "Provisioning state of the request routing rule resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayRequestRoutingRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_request_routing_rule_properties_format {
    use super::*;
    #[doc = "Rule type"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleType {
        Basic,
        PathBasedRouting,
    }
}
#[doc = "SKU of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySku {
    #[doc = "Name of application gateway SKU"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<application_gateway_sku::Name>,
    #[doc = "Tier of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<application_gateway_sku::Tier>,
    #[doc = "Capacity (instance count) of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl ApplicationGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_sku {
    use super::*;
    #[doc = "Name of application gateway SKU"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "Standard_Small")]
        StandardSmall,
        #[serde(rename = "Standard_Medium")]
        StandardMedium,
        #[serde(rename = "Standard_Large")]
        StandardLarge,
    }
    #[doc = "Tier of application gateway"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
    }
}
#[doc = "SSL certificates of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of SSL certificates of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewaySslCertificatePropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewaySslCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of SSL certificates of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslCertificatePropertiesFormat {
    #[doc = "SSL Certificate data "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[doc = "SSL Certificate password "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[doc = "SSL Certificate public data "]
    #[serde(rename = "publicCertData", default, skip_serializing_if = "Option::is_none")]
    pub public_cert_data: Option<String>,
    #[doc = "Provisioning state of the ssl certificate resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewaySslCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Application gateway SSL policy"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPolicy {
    #[doc = "SSL protocols to be disabled on Application Gateway"]
    #[serde(rename = "disabledSslProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub disabled_ssl_protocols: Vec<String>,
}
impl ApplicationGatewaySslPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "UrlPathMap of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlPathMap {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of UrlPathMap of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayUrlPathMapPropertiesFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayUrlPathMap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of UrlPathMap of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlPathMapPropertiesFormat {
    #[serde(rename = "defaultBackendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub default_backend_address_pool: Option<SubResource>,
    #[serde(rename = "defaultBackendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub default_backend_http_settings: Option<SubResource>,
    #[doc = "Path rule of URL path map resource"]
    #[serde(rename = "pathRules", default, skip_serializing_if = "Vec::is_empty")]
    pub path_rules: Vec<ApplicationGatewayPathRule>,
    #[doc = "Provisioning state of the backend http settings resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayUrlPathMapPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListAuthorizations Api service callRetrieves all authorizations that belongs to an ExpressRouteCircuit"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationListResult {
    #[doc = "Gets the authorizations in an ExpressRoute Circuit"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitAuthorization>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AuthorizationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationPropertiesFormat {
    #[doc = "Gets or sets the authorization key"]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "Gets or sets AuthorizationUseStatus"]
    #[serde(rename = "authorizationUseStatus", default, skip_serializing_if = "Option::is_none")]
    pub authorization_use_status: Option<authorization_properties_format::AuthorizationUseStatus>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl AuthorizationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod authorization_properties_format {
    use super::*;
    #[doc = "Gets or sets AuthorizationUseStatus"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthorizationUseStatus {
        Available,
        InUse,
    }
}
#[doc = "The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureAsyncOperationResult {
    #[doc = "Status of the AzureAsyncOperation"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<azure_async_operation_result::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Error>,
}
impl AzureAsyncOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_async_operation_result {
    use super::*;
    #[doc = "Status of the AzureAsyncOperation"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Succeeded,
        Failed,
    }
}
#[doc = "Pool of backend IP addresses"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of BackendAddressPool"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackendAddressPoolPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl BackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of BackendAddressPool"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPoolPropertiesFormat {
    #[doc = "Gets collection of references to IPs defined in NICs"]
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "Gets Load Balancing rules that use this Backend Address Pool"]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[serde(rename = "outboundNatRule", default, skip_serializing_if = "Option::is_none")]
    pub outbound_nat_rule: Option<SubResource>,
    #[doc = "Get provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl BackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpSettings {
    #[doc = "Gets or sets this BGP speaker's ASN"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i64>,
    #[doc = "Gets or sets the BGP peering address and BGP identifier of this BGP speaker"]
    #[serde(rename = "bgpPeeringAddress", default, skip_serializing_if = "Option::is_none")]
    pub bgp_peering_address: Option<String>,
    #[doc = "Gets or sets the weight added to routes learned from this BGP speaker"]
    #[serde(rename = "peerWeight", default, skip_serializing_if = "Option::is_none")]
    pub peer_weight: Option<i32>,
}
impl BgpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionResetSharedKey {
    #[doc = "The virtual network connection reset shared key length"]
    #[serde(rename = "keyLength", default, skip_serializing_if = "Option::is_none")]
    pub key_length: Option<i64>,
}
impl ConnectionResetSharedKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for GetConnectionSharedKey Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionSharedKey {
    #[doc = "The virtual network connection shared key value"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ConnectionSharedKey {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for CheckConnectionSharedKey Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionSharedKeyResult {
    #[doc = "The virtual network connection shared key value"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ConnectionSharedKeyResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DHCPOptions contains an array of DNS servers available to VMs deployed in the virtual networkStandard DHCP option for a subnet overrides VNET DHCP options."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DhcpOptions {
    #[doc = "Gets or sets list of DNS servers IP addresses"]
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
}
impl DhcpOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for CheckDnsNameAvailability Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DnsNameAvailabilityResult {
    #[doc = "Domain availability (True/False)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
}
impl DnsNameAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Effective NetworkSecurityGroup"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroup {
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<SubResource>,
    #[doc = "Effective NetworkSecurityGroup association"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub association: Option<EffectiveNetworkSecurityGroupAssociation>,
    #[doc = "Gets collection of effective security rules"]
    #[serde(rename = "effectiveSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_security_rules: Vec<EffectiveNetworkSecurityRule>,
}
impl EffectiveNetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Effective NetworkSecurityGroup association"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupAssociation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<SubResource>,
}
impl EffectiveNetworkSecurityGroupAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for list effective network security groups api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupListResult {
    #[doc = "Gets list of effective network security groups"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveNetworkSecurityGroup>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveNetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Effective NetworkSecurityRules"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityRule {
    #[doc = "Gets the name of the security rule specified by the user (if created by the user)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Gets Network protocol this rule applies to"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<effective_network_security_rule::Protocol>,
    #[doc = "Gets source port or range"]
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[doc = "Gets destination port or range"]
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[doc = "Gets source address prefix"]
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[doc = "Gets destination address prefix"]
    #[serde(rename = "destinationAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub destination_address_prefix: Option<String>,
    #[doc = "Gets expanded source address prefix"]
    #[serde(rename = "expandedSourceAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_source_address_prefix: Vec<String>,
    #[doc = "Gets expanded destination address prefix"]
    #[serde(rename = "expandedDestinationAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_destination_address_prefix: Vec<String>,
    #[doc = "Gets network traffic is allowed or denied"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<effective_network_security_rule::Access>,
    #[doc = "Gets the priority of the rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "Gets the direction of the rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<effective_network_security_rule::Direction>,
}
impl EffectiveNetworkSecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_network_security_rule {
    use super::*;
    #[doc = "Gets Network protocol this rule applies to"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        #[serde(rename = "*")]
        U2a,
    }
    #[doc = "Gets network traffic is allowed or denied"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
    #[doc = "Gets the direction of the rule"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[doc = "Effective Route"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRoute {
    #[doc = "Gets the name of the user defined route. This is optional."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Gets who created the route"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<effective_route::Source>,
    #[doc = "Gets value of effective route"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<effective_route::State>,
    #[doc = "Gets address prefixes of the effective routes in CIDR notation."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefix: Vec<String>,
    #[doc = "Gets the IP address of the next hop of the effective route"]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hop_ip_address: Vec<String>,
    #[doc = "Gets or sets the type of Azure hop the packet should be sent to."]
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<effective_route::NextHopType>,
}
impl EffectiveRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_route {
    use super::*;
    #[doc = "Gets who created the route"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        Unknown,
        User,
        VirtualNetworkGateway,
        Default,
    }
    #[doc = "Gets value of effective route"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Active,
        Invalid,
    }
    #[doc = "Gets or sets the type of Azure hop the packet should be sent to."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextHopType {
        VirtualNetworkGateway,
        VnetLocal,
        Internet,
        VirtualAppliance,
        None,
    }
}
#[doc = "Response for list effective route api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRouteListResult {
    #[doc = "Gets list of effective routes"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveRoute>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveRouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Error {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetails>,
    #[serde(rename = "innerError", default, skip_serializing_if = "Option::is_none")]
    pub inner_error: Option<String>,
}
impl Error {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRouteCircuit resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuit {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Contains sku in an ExpressRouteCircuit"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ExpressRouteCircuitSku>,
    #[doc = "Properties of ExpressRouteCircuit"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCircuit {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The arp table associated with the ExpressRouteCircuit"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitArpTable {
    #[doc = "Age."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub age: Option<i32>,
    #[doc = "Interface."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interface: Option<String>,
    #[doc = "Gets ipAddress."]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "Gets macAddress."]
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
}
impl ExpressRouteCircuitArpTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Authorization in a ExpressRouteCircuit resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitAuthorization {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AuthorizationPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCircuitAuthorization {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListExpressRouteCircuit Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitListResult {
    #[doc = "Gets a list of ExpressRouteCircuits in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuit>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peering in a ExpressRouteCircuit resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitPeeringPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCircuitPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specifies the peering config"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringConfig {
    #[doc = "Gets or sets the reference of AdvertisedPublicPrefixes"]
    #[serde(rename = "advertisedPublicPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub advertised_public_prefixes: Vec<String>,
    #[doc = "Gets or sets AdvertisedPublicPrefixState of the Peering resource "]
    #[serde(rename = "advertisedPublicPrefixesState", default, skip_serializing_if = "Option::is_none")]
    pub advertised_public_prefixes_state: Option<express_route_circuit_peering_config::AdvertisedPublicPrefixesState>,
    #[doc = "Gets or Sets CustomerAsn of the peering."]
    #[serde(rename = "customerASN", default, skip_serializing_if = "Option::is_none")]
    pub customer_asn: Option<i32>,
    #[doc = "Gets or Sets RoutingRegistryName of the config."]
    #[serde(rename = "routingRegistryName", default, skip_serializing_if = "Option::is_none")]
    pub routing_registry_name: Option<String>,
}
impl ExpressRouteCircuitPeeringConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_peering_config {
    use super::*;
    #[doc = "Gets or sets AdvertisedPublicPrefixState of the Peering resource "]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AdvertisedPublicPrefixesState {
        NotConfigured,
        Configuring,
        Configured,
        ValidationNeeded,
    }
}
#[doc = "Response for ListPeering Api service callRetrieves all Peerings that belongs to an ExpressRouteCircuit"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringListResult {
    #[doc = "Gets the peerings in an express route circuit"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitPeering>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringPropertiesFormat {
    #[doc = "Gets or sets PeeringType"]
    #[serde(rename = "peeringType", default, skip_serializing_if = "Option::is_none")]
    pub peering_type: Option<express_route_circuit_peering_properties_format::PeeringType>,
    #[doc = "Gets or sets state of Peering"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<express_route_circuit_peering_properties_format::State>,
    #[doc = "Gets or sets the azure ASN"]
    #[serde(rename = "azureASN", default, skip_serializing_if = "Option::is_none")]
    pub azure_asn: Option<i32>,
    #[doc = "Gets or sets the peer ASN"]
    #[serde(rename = "peerASN", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i32>,
    #[doc = "Gets or sets the primary address prefix"]
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[doc = "Gets or sets the secondary address prefix"]
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[doc = "Gets or sets the primary port"]
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[doc = "Gets or sets the secondary port"]
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[doc = "Gets or sets the shared key"]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "Gets or sets the vlan id"]
    #[serde(rename = "vlanId", default, skip_serializing_if = "Option::is_none")]
    pub vlan_id: Option<i32>,
    #[doc = "Specifies the peering config"]
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[doc = "Contains Stats associated with the peering"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stats: Option<ExpressRouteCircuitStats>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Gets or sets the GatewayManager Etag"]
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
    #[doc = "Gets whether the provider or the customer last modified the peering"]
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
}
impl ExpressRouteCircuitPeeringPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_peering_properties_format {
    use super::*;
    #[doc = "Gets or sets PeeringType"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PeeringType {
        AzurePublicPeering,
        AzurePrivatePeering,
        MicrosoftPeering,
    }
    #[doc = "Gets or sets state of Peering"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
        Enabled,
    }
}
#[doc = "Properties of ExpressRouteCircuit"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPropertiesFormat {
    #[doc = "allow classic operations"]
    #[serde(rename = "allowClassicOperations", default, skip_serializing_if = "Option::is_none")]
    pub allow_classic_operations: Option<bool>,
    #[doc = "Gets or sets CircuitProvisioningState state of the resource "]
    #[serde(rename = "circuitProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub circuit_provisioning_state: Option<String>,
    #[doc = "Gets or sets ServiceProviderProvisioningState state of the resource "]
    #[serde(rename = "serviceProviderProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_provisioning_state: Option<express_route_circuit_properties_format::ServiceProviderProvisioningState>,
    #[doc = "Gets or sets list of authorizations"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub authorizations: Vec<ExpressRouteCircuitAuthorization>,
    #[doc = "Gets or sets list of peerings"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCircuitPeering>,
    #[doc = "Gets or sets ServiceKey"]
    #[serde(rename = "serviceKey", default, skip_serializing_if = "Option::is_none")]
    pub service_key: Option<String>,
    #[doc = "Gets or sets ServiceProviderNotes"]
    #[serde(rename = "serviceProviderNotes", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_notes: Option<String>,
    #[doc = "Contains ServiceProviderProperties in an ExpressRouteCircuit"]
    #[serde(rename = "serviceProviderProperties", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_properties: Option<ExpressRouteCircuitServiceProviderProperties>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Gets or sets the GatewayManager Etag"]
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
}
impl ExpressRouteCircuitPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_properties_format {
    use super::*;
    #[doc = "Gets or sets ServiceProviderProvisioningState state of the resource "]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceProviderProvisioningState {
        NotProvisioned,
        Provisioning,
        Provisioned,
        Deprovisioning,
    }
}
#[doc = "The routes table associated with the ExpressRouteCircuit"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitRoutesTable {
    #[doc = "network."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[doc = "nextHop"]
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[doc = "locPrf."]
    #[serde(rename = "locPrf", default, skip_serializing_if = "Option::is_none")]
    pub loc_prf: Option<String>,
    #[doc = "weight."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
    #[doc = "path ."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl ExpressRouteCircuitRoutesTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The routes table associated with the ExpressRouteCircuit"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitRoutesTableSummary {
    #[doc = "Neighbor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[doc = "BGP version number spoken to the neighbor."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub v: Option<i32>,
    #[doc = "Autonomous system number."]
    #[serde(rename = "as", default, skip_serializing_if = "Option::is_none")]
    pub as_: Option<i32>,
    #[doc = "The length of time that the BGP session has been in the Established state, or the current status if not in the Established state."]
    #[serde(rename = "upDown", default, skip_serializing_if = "Option::is_none")]
    pub up_down: Option<String>,
    #[doc = "Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group."]
    #[serde(rename = "statePfxRcd", default, skip_serializing_if = "Option::is_none")]
    pub state_pfx_rcd: Option<String>,
}
impl ExpressRouteCircuitRoutesTableSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains ServiceProviderProperties in an ExpressRouteCircuit"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitServiceProviderProperties {
    #[doc = "Gets or sets serviceProviderName."]
    #[serde(rename = "serviceProviderName", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_name: Option<String>,
    #[doc = "Gets or sets peering location."]
    #[serde(rename = "peeringLocation", default, skip_serializing_if = "Option::is_none")]
    pub peering_location: Option<String>,
    #[doc = "Gets or sets BandwidthInMbps."]
    #[serde(rename = "bandwidthInMbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_mbps: Option<i32>,
}
impl ExpressRouteCircuitServiceProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains sku in an ExpressRouteCircuit"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitSku {
    #[doc = "Gets or sets name of the sku."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Gets or sets tier of the sku."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<express_route_circuit_sku::Tier>,
    #[doc = "Gets or sets family of the sku."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<express_route_circuit_sku::Family>,
}
impl ExpressRouteCircuitSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_sku {
    use super::*;
    #[doc = "Gets or sets tier of the sku."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        Premium,
    }
    #[doc = "Gets or sets family of the sku."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Family {
        UnlimitedData,
        MeteredData,
    }
}
#[doc = "Contains Stats associated with the peering"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitStats {
    #[doc = "Gets BytesIn of the peering."]
    #[serde(rename = "primarybytesIn", default, skip_serializing_if = "Option::is_none")]
    pub primarybytes_in: Option<i64>,
    #[doc = "Gets BytesOut of the peering."]
    #[serde(rename = "primarybytesOut", default, skip_serializing_if = "Option::is_none")]
    pub primarybytes_out: Option<i64>,
    #[doc = "Gets BytesIn of the peering."]
    #[serde(rename = "secondarybytesIn", default, skip_serializing_if = "Option::is_none")]
    pub secondarybytes_in: Option<i64>,
    #[doc = "Gets BytesOut of the peering."]
    #[serde(rename = "secondarybytesOut", default, skip_serializing_if = "Option::is_none")]
    pub secondarybytes_out: Option<i64>,
}
impl ExpressRouteCircuitStats {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListArpTable associated with the Express Route Circuits Api"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsArpTableListResult {
    #[doc = "Gets List of ArpTable"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitArpTable>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsArpTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRoutesTable associated with the Express Route Circuits Api"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsRoutesTableListResult {
    #[doc = "Gets List of RoutesTable"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitRoutesTable>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsRoutesTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRoutesTable associated with the Express Route Circuits Api"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsRoutesTableSummaryListResult {
    #[doc = "Gets List of RoutesTable"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitRoutesTableSummary>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsRoutesTableSummaryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ExpressRouteResourceProvider object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProvider {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of ExpressRouteServiceProvider"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteServiceProviderPropertiesFormat>,
}
impl ExpressRouteServiceProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains Bandwidths offered in ExpressRouteServiceProviders"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderBandwidthsOffered {
    #[doc = "Gets the OfferName"]
    #[serde(rename = "offerName", default, skip_serializing_if = "Option::is_none")]
    pub offer_name: Option<String>,
    #[doc = "Gets the ValueInMbps."]
    #[serde(rename = "valueInMbps", default, skip_serializing_if = "Option::is_none")]
    pub value_in_mbps: Option<i32>,
}
impl ExpressRouteServiceProviderBandwidthsOffered {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListExpressRouteServiceProvider Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderListResult {
    #[doc = "Gets List of ExpressRouteResourceProvider"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteServiceProvider>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteServiceProviderListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ExpressRouteServiceProvider"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderPropertiesFormat {
    #[doc = "Gets or list of peering locations"]
    #[serde(rename = "peeringLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub peering_locations: Vec<String>,
    #[doc = "Gets or bandwidths offered"]
    #[serde(rename = "bandwidthsOffered", default, skip_serializing_if = "Vec::is_empty")]
    pub bandwidths_offered: Vec<ExpressRouteServiceProviderBandwidthsOffered>,
    #[doc = "Gets provisioning state of the resource "]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ExpressRouteServiceProviderPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Frontend IP address of the load balancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Frontend IP Configuration of the load balancer"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FrontendIpConfigurationPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl FrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Frontend IP Configuration of the load balancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfigurationPropertiesFormat {
    #[doc = "Read only. Inbound rules URIs that use this frontend IP"]
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<SubResource>,
    #[doc = "Read only. Inbound pools URIs that use this frontend IP"]
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<SubResource>,
    #[doc = "Read only. Outbound rules URIs that use this frontend IP"]
    #[serde(rename = "outboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_nat_rules: Vec<SubResource>,
    #[doc = "Gets Load Balancing rules URIs that use this frontend IP"]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[doc = "Gets or sets the privateIPAddress of the IP Configuration"]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "Gets or sets PrivateIP allocation method"]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<frontend_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[doc = "Subnet in a VirtualNetwork resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "PublicIPAddress resource"]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl FrontendIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod frontend_ip_configuration_properties_format {
    use super::*;
    #[doc = "Gets or sets PrivateIP allocation method"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[doc = "Response for CheckIPAddressAvailability Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressAvailabilityResult {
    #[doc = "Private IP address availability"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
    #[doc = "Contains other available private IP addresses if the asked for address is taken"]
    #[serde(rename = "availableIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub available_ip_addresses: Vec<String>,
}
impl IpAddressAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IPConfiguration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IPConfiguration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Box<Option<IpConfigurationPropertiesFormat>>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IPConfiguration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationPropertiesFormat {
    #[doc = "Gets or sets the privateIPAddress of the IP Configuration"]
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "Gets or sets PrivateIP allocation method"]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[doc = "Subnet in a VirtualNetwork resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "PublicIPAddress resource"]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Box<Option<PublicIpAddress>>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl IpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ip_configuration_properties_format {
    use super::*;
    #[doc = "Gets or sets PrivateIP allocation method"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[doc = "Inbound NAT pool of the load balancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Inbound NAT pool"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatPoolPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl InboundNatPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Inbound NAT pool"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundNatPoolPropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "Gets or sets the transport protocol for the endpoint. Possible values are Udp or Tcp"]
    pub protocol: inbound_nat_pool_properties_format::Protocol,
    #[doc = "Gets or sets the starting port range for the NAT pool. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive"]
    #[serde(rename = "frontendPortRangeStart")]
    pub frontend_port_range_start: i32,
    #[doc = "Gets or sets the ending port range for the NAT pool. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive"]
    #[serde(rename = "frontendPortRangeEnd")]
    pub frontend_port_range_end: i32,
    #[doc = "Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API"]
    #[serde(rename = "backendPort")]
    pub backend_port: i32,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl InboundNatPoolPropertiesFormat {
    pub fn new(
        protocol: inbound_nat_pool_properties_format::Protocol,
        frontend_port_range_start: i32,
        frontend_port_range_end: i32,
        backend_port: i32,
    ) -> Self {
        Self {
            frontend_ip_configuration: None,
            protocol,
            frontend_port_range_start,
            frontend_port_range_end,
            backend_port,
            provisioning_state: None,
        }
    }
}
pub mod inbound_nat_pool_properties_format {
    use super::*;
    #[doc = "Gets or sets the transport protocol for the endpoint. Possible values are Udp or Tcp"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Udp,
        Tcp,
    }
}
#[doc = "Inbound NAT rule of the loadbalancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of Inbound NAT rule"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatRulePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl InboundNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Inbound NAT rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRulePropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[doc = "IPConfiguration in a NetworkInterface"]
    #[serde(rename = "backendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub backend_ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[doc = "Gets or sets the transport protocol for the endpoint. Possible values are Udp or Tcp"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<inbound_nat_rule_properties_format::Protocol>,
    #[doc = "Gets or sets the port for the external endpoint. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive"]
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<i32>,
    #[doc = "Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API"]
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[doc = "Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to Tcp"]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint"]
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl InboundNatRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod inbound_nat_rule_properties_format {
    use super::*;
    #[doc = "Gets or sets the transport protocol for the endpoint. Possible values are Udp or Tcp"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Udp,
        Tcp,
    }
}
#[doc = "LoadBalancer resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancer {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Properties of Load Balancer"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancerPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LoadBalancer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListLoadBalancers Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerListResult {
    #[doc = "Gets a list of LoadBalancers in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancer>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of Load Balancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerPropertiesFormat {
    #[doc = "Gets or sets frontend IP addresses of the load balancer"]
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<FrontendIpConfiguration>,
    #[doc = "Gets or sets Pools of backend IP addresses"]
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<BackendAddressPool>,
    #[doc = "Gets or sets load balancing rules"]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<LoadBalancingRule>,
    #[doc = "Gets or sets list of Load balancer probes"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub probes: Vec<Probe>,
    #[doc = "Gets or sets list of inbound rules"]
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<InboundNatRule>,
    #[doc = "Gets or sets inbound NAT pools"]
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<InboundNatPool>,
    #[doc = "Gets or sets outbound NAT rules"]
    #[serde(rename = "outboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_nat_rules: Vec<OutboundNatRule>,
    #[doc = "Gets or sets resource guid property of the Load balancer resource"]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LoadBalancerPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Rules of the load balancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancingRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the load balancer"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancingRulePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LoadBalancingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the load balancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LoadBalancingRulePropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub probe: Option<SubResource>,
    #[doc = "Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp"]
    pub protocol: load_balancing_rule_properties_format::Protocol,
    #[doc = "Gets or sets the load distribution policy for this rule"]
    #[serde(rename = "loadDistribution", default, skip_serializing_if = "Option::is_none")]
    pub load_distribution: Option<load_balancing_rule_properties_format::LoadDistribution>,
    #[doc = "Gets or sets the port for the external endpoint. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive"]
    #[serde(rename = "frontendPort")]
    pub frontend_port: i32,
    #[doc = "Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal component on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API"]
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[doc = "Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to Tcp"]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint"]
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LoadBalancingRulePropertiesFormat {
    pub fn new(protocol: load_balancing_rule_properties_format::Protocol, frontend_port: i32) -> Self {
        Self {
            frontend_ip_configuration: None,
            backend_address_pool: None,
            probe: None,
            protocol,
            load_distribution: None,
            frontend_port,
            backend_port: None,
            idle_timeout_in_minutes: None,
            enable_floating_ip: None,
            provisioning_state: None,
        }
    }
}
pub mod load_balancing_rule_properties_format {
    use super::*;
    #[doc = "Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Udp,
        Tcp,
    }
    #[doc = "Gets or sets the load distribution policy for this rule"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadDistribution {
        Default,
        #[serde(rename = "SourceIP")]
        SourceIp,
        #[serde(rename = "SourceIPProtocol")]
        SourceIpProtocol,
    }
}
#[doc = "A common class for general resource information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "LocalNetworkGateway properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LocalNetworkGatewayPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LocalNetworkGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListLocalNetworkGateways Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayListResult {
    #[doc = "Gets List of LocalNetworkGateways that exists in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LocalNetworkGateway>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LocalNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "LocalNetworkGateway properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayPropertiesFormat {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets"]
    #[serde(rename = "localNetworkAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub local_network_address_space: Option<AddressSpace>,
    #[doc = "IP address of local network gateway."]
    #[serde(rename = "gatewayIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub gateway_ip_address: Option<String>,
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[doc = "Gets or sets resource guid property of the LocalNetworkGateway resource"]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Gets provisioning state of the LocalNetworkGateway resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LocalNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A NetworkInterface in a resource group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterface {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "NetworkInterface properties. "]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfacePropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Dns settings of a network interface"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceDnsSettings {
    #[doc = "Gets or sets list of DNS servers IP addresses"]
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
    #[doc = "Gets or sets list of Applied DNS servers IP addresses"]
    #[serde(rename = "appliedDnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub applied_dns_servers: Vec<String>,
    #[doc = "Gets or sets the internal DNS name"]
    #[serde(rename = "internalDnsNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub internal_dns_name_label: Option<String>,
    #[doc = "Gets or sets the internal fqdn."]
    #[serde(rename = "internalFqdn", default, skip_serializing_if = "Option::is_none")]
    pub internal_fqdn: Option<String>,
    #[doc = "Gets or sets internal domain name suffix of the NIC."]
    #[serde(rename = "internalDomainNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub internal_domain_name_suffix: Option<String>,
}
impl NetworkInterfaceDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "IPConfiguration in a NetworkInterface"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of IPConfiguration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceIpConfigurationPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkInterfaceIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of IPConfiguration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationPropertiesFormat {
    #[doc = "Gets or sets the reference of ApplicationGatewayBackendAddressPool resource"]
    #[serde(rename = "applicationGatewayBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_backend_address_pools: Vec<ApplicationGatewayBackendAddressPool>,
    #[doc = "Gets or sets the reference of LoadBalancerBackendAddressPool resource"]
    #[serde(rename = "loadBalancerBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_address_pools: Vec<BackendAddressPool>,
    #[doc = "Gets or sets list of references of LoadBalancerInboundNatRules"]
    #[serde(rename = "loadBalancerInboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_inbound_nat_rules: Vec<InboundNatRule>,
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[doc = "Gets or sets PrivateIP allocation method"]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<network_interface_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[doc = "Gets or sets PrivateIP address version (IPv4/IPv6)"]
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<network_interface_ip_configuration_properties_format::PrivateIpAddressVersion>,
    #[doc = "Subnet in a VirtualNetwork resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[doc = "Gets whether this is a primary customer address on the NIC"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[doc = "PublicIPAddress resource"]
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkInterfaceIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_interface_ip_configuration_properties_format {
    use super::*;
    #[doc = "Gets or sets PrivateIP allocation method"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
    #[doc = "Gets or sets PrivateIP address version (IPv4/IPv6)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAddressVersion {
        IPv4,
        IPv6,
    }
}
#[doc = "Response for ListNetworkInterface Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceListResult {
    #[doc = "Gets or sets list of NetworkInterfaces in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterface>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NetworkInterface properties. "]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfacePropertiesFormat {
    #[serde(rename = "virtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine: Option<SubResource>,
    #[doc = "NetworkSecurityGroup resource"]
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[doc = "Gets or sets list of IPConfigurations of the network interface"]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[doc = "Dns settings of a network interface"]
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<NetworkInterfaceDnsSettings>,
    #[doc = "Gets the MAC address of the network interface"]
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[doc = "Gets whether this is a primary NIC on a virtual machine"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[doc = "Gets or sets whether IPForwarding is enabled on the NIC"]
    #[serde(rename = "enableIPForwarding", default, skip_serializing_if = "Option::is_none")]
    pub enable_ip_forwarding: Option<bool>,
    #[doc = "Gets or sets resource guid property of the network interface resource"]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkInterfacePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NetworkSecurityGroup resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Network Security Group resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkSecurityGroupPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListNetworkSecurityGroups Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupListResult {
    #[doc = "Gets List of NetworkSecurityGroups"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkSecurityGroup>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network Security Group resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupPropertiesFormat {
    #[doc = "Gets or sets security rules of network security group"]
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
    #[doc = "Gets or default security rules of network security group"]
    #[serde(rename = "defaultSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub default_security_rules: Vec<SecurityRule>,
    #[doc = "Gets collection of references to Network Interfaces"]
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[doc = "Gets collection of references to subnets"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "Gets or sets resource guid property of the network security group resource"]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkSecurityGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Outbound NAT pool of the load balancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OutboundNatRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Outbound NAT pool of the load balancer"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OutboundNatRulePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl OutboundNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Outbound NAT pool of the load balancer"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutboundNatRulePropertiesFormat {
    #[doc = "Gets or sets the number of outbound ports to be used for SNAT"]
    #[serde(rename = "allocatedOutboundPorts", default, skip_serializing_if = "Option::is_none")]
    pub allocated_outbound_ports: Option<i32>,
    #[doc = "Gets or sets Frontend IP addresses of the load balancer"]
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<SubResource>,
    #[serde(rename = "backendAddressPool")]
    pub backend_address_pool: SubResource,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl OutboundNatRulePropertiesFormat {
    pub fn new(backend_address_pool: SubResource) -> Self {
        Self {
            allocated_outbound_ports: None,
            frontend_ip_configurations: Vec::new(),
            backend_address_pool,
            provisioning_state: None,
        }
    }
}
#[doc = "Load balancer Probe"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Probe {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProbePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Probe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProbePropertiesFormat {
    #[doc = "Gets Load balancer rules that use this probe"]
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[doc = "Gets or sets the protocol of the end point. Possible values are http or Tcp. If Tcp is specified, a received ACK is required for the probe to be successful. If http is specified,a 200 OK response from the specifies URI is required for the probe to be successful"]
    pub protocol: probe_properties_format::Protocol,
    #[doc = "Gets or sets Port for communicating the probe. Possible values range from 1 to 65535, inclusive."]
    pub port: i32,
    #[doc = "Gets or sets the interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5"]
    #[serde(rename = "intervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub interval_in_seconds: Option<i32>,
    #[doc = "Gets or sets the number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure. "]
    #[serde(rename = "numberOfProbes", default, skip_serializing_if = "Option::is_none")]
    pub number_of_probes: Option<i32>,
    #[doc = "Gets or sets the URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value"]
    #[serde(rename = "requestPath", default, skip_serializing_if = "Option::is_none")]
    pub request_path: Option<String>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ProbePropertiesFormat {
    pub fn new(protocol: probe_properties_format::Protocol, port: i32) -> Self {
        Self {
            load_balancing_rules: Vec::new(),
            protocol,
            port,
            interval_in_seconds: None,
            number_of_probes: None,
            request_path: None,
            provisioning_state: None,
        }
    }
}
pub mod probe_properties_format {
    use super::*;
    #[doc = "Gets or sets the protocol of the end point. Possible values are http or Tcp. If Tcp is specified, a received ACK is required for the probe to be successful. If http is specified,a 200 OK response from the specifies URI is required for the probe to be successful"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Tcp,
    }
}
#[doc = "PublicIPAddress resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddress {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "PublicIpAddress properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Box<Option<PublicIpAddressPropertiesFormat>>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PublicIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains FQDN of the DNS record associated with the public IP address"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressDnsSettings {
    #[doc = "Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system."]
    #[serde(rename = "domainNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub domain_name_label: Option<String>,
    #[doc = "Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[doc = "Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. "]
    #[serde(rename = "reverseFqdn", default, skip_serializing_if = "Option::is_none")]
    pub reverse_fqdn: Option<String>,
}
impl PublicIpAddressDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListPublicIpAddresses Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressListResult {
    #[doc = "Gets List of publicIP addresses that exists in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PublicIpAddress>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PublicIpAddressListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "PublicIpAddress properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressPropertiesFormat {
    #[doc = "Gets or sets PublicIP allocation method (Static/Dynamic)"]
    #[serde(rename = "publicIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_allocation_method: Option<public_ip_address_properties_format::PublicIpAllocationMethod>,
    #[doc = "Gets or sets PublicIP address version (IPv4/IPv6)"]
    #[serde(rename = "publicIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_version: Option<public_ip_address_properties_format::PublicIpAddressVersion>,
    #[doc = "IPConfiguration"]
    #[serde(rename = "ipConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration: Box<Option<IpConfiguration>>,
    #[doc = "Contains FQDN of the DNS record associated with the public IP address"]
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<PublicIpAddressDnsSettings>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "Gets or sets the idle timeout of the public IP address"]
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[doc = "Gets or sets resource guid property of the PublicIP resource"]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl PublicIpAddressPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_address_properties_format {
    use super::*;
    #[doc = "Gets or sets PublicIP allocation method (Static/Dynamic)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicIpAllocationMethod {
        Static,
        Dynamic,
    }
    #[doc = "Gets or sets PublicIP address version (IPv4/IPv6)"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicIpAddressVersion {
        IPv4,
        IPv6,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ResourceNavigationLink resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of ResourceNavigationLink"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ResourceNavigationLinkFormat>,
    #[doc = "Name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ResourceNavigationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of ResourceNavigationLink"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLinkFormat {
    #[doc = "Resource type of the linked resource"]
    #[serde(rename = "linkedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_type: Option<String>,
    #[doc = "Link to the external resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[doc = "Provisioning state of the ResourceNavigationLink resource"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ResourceNavigationLinkFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Route {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Route resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RoutePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Route {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRoute Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteListResult {
    #[doc = "Gets List of Routes in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Route>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutePropertiesFormat {
    #[doc = "Gets or sets the destination CIDR to which the route applies."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "Gets or sets the type of Azure hop the packet should be sent to."]
    #[serde(rename = "nextHopType")]
    pub next_hop_type: route_properties_format::NextHopType,
    #[doc = "Gets or sets the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance."]
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
    #[doc = "Gets provisioning state of the resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl RoutePropertiesFormat {
    pub fn new(next_hop_type: route_properties_format::NextHopType) -> Self {
        Self {
            address_prefix: None,
            next_hop_type,
            next_hop_ip_address: None,
            provisioning_state: None,
        }
    }
}
pub mod route_properties_format {
    use super::*;
    #[doc = "Gets or sets the type of Azure hop the packet should be sent to."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextHopType {
        VirtualNetworkGateway,
        VnetLocal,
        Internet,
        VirtualAppliance,
        None,
    }
}
#[doc = "RouteTable resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTable {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Route Table resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteTablePropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListRouteTable Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTableListResult {
    #[doc = "Gets List of RouteTables in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteTable>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Route Table resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTablePropertiesFormat {
    #[doc = "Gets or sets Routes in a Route Table"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<Route>,
    #[doc = "Gets collection of references to subnets"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "Gets provisioning state of the resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl RouteTablePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Network security rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityRulePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl SecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListSecurityRule Api service callRetrieves all security rules that belongs to a network security group"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRuleListResult {
    #[doc = "Gets security rules in a network security group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityRule>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityRulePropertiesFormat {
    #[doc = "Gets or sets a description for this rule. Restricted to 140 chars."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*)."]
    pub protocol: security_rule_properties_format::Protocol,
    #[doc = "Gets or sets Source Port or Range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports."]
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[doc = "Gets or sets Destination Port or Range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports."]
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[doc = "Gets or sets source address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. "]
    #[serde(rename = "sourceAddressPrefix")]
    pub source_address_prefix: String,
    #[doc = "Gets or sets destination address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. "]
    #[serde(rename = "destinationAddressPrefix")]
    pub destination_address_prefix: String,
    #[doc = "Gets or sets network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'"]
    pub access: security_rule_properties_format::Access,
    #[doc = "Gets or sets the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[doc = "Gets or sets the direction of the rule.InBound or Outbound. The direction specifies if rule will be evaluated on incoming or outgoing traffic."]
    pub direction: security_rule_properties_format::Direction,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl SecurityRulePropertiesFormat {
    pub fn new(
        protocol: security_rule_properties_format::Protocol,
        source_address_prefix: String,
        destination_address_prefix: String,
        access: security_rule_properties_format::Access,
        direction: security_rule_properties_format::Direction,
    ) -> Self {
        Self {
            description: None,
            protocol,
            source_port_range: None,
            destination_port_range: None,
            source_address_prefix,
            destination_address_prefix,
            access,
            priority: None,
            direction,
            provisioning_state: None,
        }
    }
}
pub mod security_rule_properties_format {
    use super::*;
    #[doc = "Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        #[serde(rename = "*")]
        U2a,
    }
    #[doc = "Gets or sets network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
    #[doc = "Gets or sets the direction of the rule.InBound or Outbound. The direction specifies if rule will be evaluated on incoming or outgoing traffic."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Subnet in a VirtualNetwork resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Subnet {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubnetPropertiesFormat>,
    #[doc = "Gets or sets the name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Subnet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListSubnets Api service callRetrieves all subnet that belongs to a virtual network"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetListResult {
    #[doc = "Gets the subnets in a virtual network"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Subnet>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SubnetListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetPropertiesFormat {
    #[doc = "Gets or sets Address prefix for the subnet."]
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[doc = "NetworkSecurityGroup resource"]
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[doc = "RouteTable resource"]
    #[serde(rename = "routeTable", default, skip_serializing_if = "Option::is_none")]
    pub route_table: Option<RouteTable>,
    #[doc = "Gets array of references to the network interface IP configurations using subnet"]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<IpConfiguration>,
    #[doc = "Gets array of references to the external resources using subnet"]
    #[serde(rename = "resourceNavigationLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_navigation_links: Vec<ResourceNavigationLink>,
    #[doc = "Gets provisioning state of the resource"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl SubnetPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes Network Resource Usage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    #[doc = "Gets or sets an enum describing the unit of measurement."]
    pub unit: usage::Unit,
    #[doc = "Gets or sets the current value of the usage."]
    #[serde(rename = "currentValue")]
    pub current_value: i64,
    #[doc = "Gets or sets the limit of usage."]
    pub limit: i64,
    #[doc = "The Usage Names."]
    pub name: UsageName,
}
impl Usage {
    pub fn new(unit: usage::Unit, current_value: i64, limit: i64, name: UsageName) -> Self {
        Self {
            unit,
            current_value,
            limit,
            name,
        }
    }
}
pub mod usage {
    use super::*;
    #[doc = "Gets or sets an enum describing the unit of measurement."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[doc = "The Usage Names."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[doc = "Gets or sets a string describing the resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "Gets or sets a localized string describing the resource name."]
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The List Usages operation response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsagesListResult {
    #[doc = "Gets or sets the list Network Resource Usages."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
    #[doc = "URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UsagesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual Network resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetwork {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A common class for general resource information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "VirtualNetworkGateway properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkGatewayPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A common class for general resource information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "VirtualNetworkGatewayConnection properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkGatewayConnectionPropertiesFormat>,
    #[doc = "Gets a unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListVirtualNetworkGatewayConnections Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayConnectionListResult {
    #[doc = "Gets List of VirtualNetworkGatewayConnections that exists in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayConnection>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualNetworkGatewayConnection properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayConnectionPropertiesFormat {
    #[doc = "The authorizationKey."]
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[doc = "A common class for general resource information"]
    #[serde(rename = "virtualNetworkGateway1", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway1: Option<VirtualNetworkGateway>,
    #[doc = "A common class for general resource information"]
    #[serde(rename = "virtualNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway2: Option<VirtualNetworkGateway>,
    #[doc = "A common class for general resource information"]
    #[serde(rename = "localNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub local_network_gateway2: Option<LocalNetworkGateway>,
    #[doc = "Gateway connection type IPsec/Dedicated/VpnClient/Vnet2Vnet"]
    #[serde(rename = "connectionType", default, skip_serializing_if = "Option::is_none")]
    pub connection_type: Option<virtual_network_gateway_connection_properties_format::ConnectionType>,
    #[doc = "The Routing weight."]
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[doc = "The IPsec share key."]
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[doc = "Virtual network Gateway connection status"]
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<virtual_network_gateway_connection_properties_format::ConnectionStatus>,
    #[doc = "The Egress Bytes Transferred in this connection"]
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[doc = "The Ingress Bytes Transferred in this connection"]
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub peer: Option<SubResource>,
    #[doc = "EnableBgp Flag"]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "Gets or sets resource guid property of the VirtualNetworkGatewayConnection resource"]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Gets provisioning state of the VirtualNetworkGatewayConnection resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkGatewayConnectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_connection_properties_format {
    use super::*;
    #[doc = "Gateway connection type IPsec/Dedicated/VpnClient/Vnet2Vnet"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionType {
        IPsec,
        Vnet2Vnet,
        ExpressRoute,
        #[serde(rename = "VPNClient")]
        VpnClient,
    }
    #[doc = "Virtual network Gateway connection status"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connecting,
        Connected,
        NotConnected,
    }
}
#[doc = "IpConfiguration for Virtual network gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of VirtualNetworkGatewayIPConfiguration"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkGatewayIpConfigurationPropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of VirtualNetworkGatewayIPConfiguration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    #[doc = "Gets or sets PrivateIP allocation method"]
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<virtual_network_gateway_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_ip_configuration_properties_format {
    use super::*;
    #[doc = "Gets or sets PrivateIP allocation method"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[doc = "Response for ListVirtualNetworkGateways Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayListResult {
    #[doc = "Gets List of VirtualNetworkGateways that exists in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGateway>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VirtualNetworkGateway properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayPropertiesFormat {
    #[doc = "IpConfigurations for Virtual network gateway."]
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<VirtualNetworkGatewayIpConfiguration>,
    #[doc = "The type of this virtual network gateway."]
    #[serde(rename = "gatewayType", default, skip_serializing_if = "Option::is_none")]
    pub gateway_type: Option<virtual_network_gateway_properties_format::GatewayType>,
    #[doc = "The type of this virtual network gateway."]
    #[serde(rename = "vpnType", default, skip_serializing_if = "Option::is_none")]
    pub vpn_type: Option<virtual_network_gateway_properties_format::VpnType>,
    #[doc = "EnableBgp Flag"]
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[doc = "ActiveActive flag"]
    #[serde(rename = "activeActive", default, skip_serializing_if = "Option::is_none")]
    pub active_active: Option<bool>,
    #[serde(rename = "gatewayDefaultSite", default, skip_serializing_if = "Option::is_none")]
    pub gateway_default_site: Option<SubResource>,
    #[doc = "VirtualNetworkGatewaySku details"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<VirtualNetworkGatewaySku>,
    #[doc = "VpnClientConfiguration for P2S client"]
    #[serde(rename = "vpnClientConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_configuration: Option<VpnClientConfiguration>,
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[doc = "Gets or sets resource guid property of the VirtualNetworkGateway resource"]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Gets provisioning state of the VirtualNetworkGateway resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_properties_format {
    use super::*;
    #[doc = "The type of this virtual network gateway."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GatewayType {
        Vpn,
        ExpressRoute,
    }
    #[doc = "The type of this virtual network gateway."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VpnType {
        PolicyBased,
        RouteBased,
    }
}
#[doc = "VirtualNetworkGatewaySku details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewaySku {
    #[doc = "Gateway sku name -Basic/HighPerformance/Standard/UltraPerformance"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<virtual_network_gateway_sku::Name>,
    #[doc = "Gateway sku tier -Basic/HighPerformance/Standard/UltraPerformance"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<virtual_network_gateway_sku::Tier>,
    #[doc = "The capacity"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl VirtualNetworkGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_sku {
    use super::*;
    #[doc = "Gateway sku name -Basic/HighPerformance/Standard/UltraPerformance"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
    }
    #[doc = "Gateway sku tier -Basic/HighPerformance/Standard/UltraPerformance"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
    }
}
#[doc = "Response for ListVirtualNetworks Api service call"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkListResult {
    #[doc = "Gets list of VirtualNetworks in a resource group"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetwork>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Peerings in a VirtualNetwork resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPeeringPropertiesFormat>,
    #[doc = "Gets or sets the name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response for ListSubnets Api service callRetrieves all subnet that belongs to a virtual network"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringListResult {
    #[doc = "Gets the peerings in a virtual network"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkPeering>,
    #[doc = "Gets the URL to get the next set of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringPropertiesFormat {
    #[doc = "Gets or sets whether the VMs in the linked virtual network space would be able to access all the VMs in local Virtual network space"]
    #[serde(rename = "allowVirtualNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub allow_virtual_network_access: Option<bool>,
    #[doc = "Gets or sets whether the forwarded traffic from the VMs in the remote virtual network will be allowed/disallowed"]
    #[serde(rename = "allowForwardedTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_forwarded_traffic: Option<bool>,
    #[doc = "Gets or sets if gatewayLinks can be used in remote virtual network’s link to this virtual network"]
    #[serde(rename = "allowGatewayTransit", default, skip_serializing_if = "Option::is_none")]
    pub allow_gateway_transit: Option<bool>,
    #[doc = "Gets or sets if remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only 1 peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway."]
    #[serde(rename = "useRemoteGateways", default, skip_serializing_if = "Option::is_none")]
    pub use_remote_gateways: Option<bool>,
    #[serde(rename = "remoteVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub remote_virtual_network: Option<SubResource>,
    #[doc = "Gets the status of the virtual network peering"]
    #[serde(rename = "peeringState", default, skip_serializing_if = "Option::is_none")]
    pub peering_state: Option<virtual_network_peering_properties_format::PeeringState>,
    #[doc = "Gets provisioning state of the resource"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkPeeringPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_peering_properties_format {
    use super::*;
    #[doc = "Gets the status of the virtual network peering"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PeeringState {
        Initiated,
        Connected,
        Disconnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPropertiesFormat {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets"]
    #[serde(rename = "addressSpace", default, skip_serializing_if = "Option::is_none")]
    pub address_space: Option<AddressSpace>,
    #[doc = "DHCPOptions contains an array of DNS servers available to VMs deployed in the virtual networkStandard DHCP option for a subnet overrides VNET DHCP options."]
    #[serde(rename = "dhcpOptions", default, skip_serializing_if = "Option::is_none")]
    pub dhcp_options: Option<DhcpOptions>,
    #[doc = "Gets or sets list of subnets in a VirtualNetwork"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[doc = "Gets or sets list of peerings in a VirtualNetwork"]
    #[serde(rename = "VirtualNetworkPeerings", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_peerings: Vec<VirtualNetworkPeering>,
    #[doc = "Gets or sets resource guid property of the VirtualNetwork resource"]
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[doc = "Gets provisioning state of the PublicIP resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnClientConfiguration for P2S client"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConfiguration {
    #[doc = "AddressSpace contains an array of IP address ranges that can be used by subnets"]
    #[serde(rename = "vpnClientAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_address_pool: Option<AddressSpace>,
    #[doc = "VpnClientRootCertificate for Virtual network gateway."]
    #[serde(rename = "vpnClientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_root_certificates: Vec<VpnClientRootCertificate>,
    #[doc = "VpnClientRevokedCertificate for Virtual network gateway."]
    #[serde(rename = "vpnClientRevokedCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_revoked_certificates: Vec<VpnClientRevokedCertificate>,
}
impl VpnClientConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VpnClientParameters"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientParameters {
    #[doc = "VPN client Processor Architecture -Amd64/X86"]
    #[serde(rename = "ProcessorArchitecture", default, skip_serializing_if = "Option::is_none")]
    pub processor_architecture: Option<vpn_client_parameters::ProcessorArchitecture>,
}
impl VpnClientParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vpn_client_parameters {
    use super::*;
    #[doc = "VPN client Processor Architecture -Amd64/X86"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProcessorArchitecture {
        Amd64,
        X86,
    }
}
#[doc = "VPN client revoked certificate of virtual network gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of the revoked VPN client certificate of virtual network gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnClientRevokedCertificatePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRevokedCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of the revoked VPN client certificate of virtual network gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificatePropertiesFormat {
    #[doc = "Gets or sets the revoked Vpn client certificate thumbprint"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[doc = "Gets provisioning state of the VPN client revoked certificate resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VpnClientRevokedCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "VPN client root certificate of virtual network gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRootCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Properties of SSL certificates of application gateway"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnClientRootCertificatePropertiesFormat>,
    #[doc = "Gets name of the resource that is unique within a resource group. This name can be used to access the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "A unique read-only string that changes whenever the resource is updated"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRootCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of SSL certificates of application gateway"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRootCertificatePropertiesFormat {
    #[doc = "Gets or sets the certificate public data"]
    #[serde(rename = "publicCertData", default, skip_serializing_if = "Option::is_none")]
    pub public_cert_data: Option<String>,
    #[doc = "Gets provisioning state of the VPN client root certificate resource Updating/Deleting/Failed"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VpnClientRootCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
