#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressSpace {
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
}
impl AddressSpace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddress {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
}
impl ApplicationGatewayBackendAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayBackendAddressPoolPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayBackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPoolPropertiesFormat {
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[serde(rename = "backendAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_addresses: Vec<ApplicationGatewayBackendAddress>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationGatewayBackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationSecurityGroupPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroupPropertiesFormat {
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ApplicationSecurityGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Availability {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl Availability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureAsyncOperationResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<azure_async_operation_result::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Error>,
}
impl AzureAsyncOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_async_operation_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Succeeded,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackendAddressPoolPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl BackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPoolPropertiesFormat {
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[serde(rename = "outboundRule", default, skip_serializing_if = "Option::is_none")]
    pub outbound_rule: Option<SubResource>,
    #[serde(rename = "outboundRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_rules: Vec<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl BackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpPeerStatus {
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<bgp_peer_status::State>,
    #[serde(rename = "connectedDuration", default, skip_serializing_if = "Option::is_none")]
    pub connected_duration: Option<String>,
    #[serde(rename = "routesReceived", default, skip_serializing_if = "Option::is_none")]
    pub routes_received: Option<i64>,
    #[serde(rename = "messagesSent", default, skip_serializing_if = "Option::is_none")]
    pub messages_sent: Option<i64>,
    #[serde(rename = "messagesReceived", default, skip_serializing_if = "Option::is_none")]
    pub messages_received: Option<i64>,
}
impl BgpPeerStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bgp_peer_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Unknown,
        Stopped,
        Idle,
        Connecting,
        Connected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpPeerStatusListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BgpPeerStatus>,
}
impl BgpPeerStatusListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i64>,
    #[serde(rename = "bgpPeeringAddress", default, skip_serializing_if = "Option::is_none")]
    pub bgp_peering_address: Option<String>,
    #[serde(rename = "peerWeight", default, skip_serializing_if = "Option::is_none")]
    pub peer_weight: Option<i32>,
}
impl BgpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConnectionProtocol {
    #[serde(rename = "IKEv2")]
    IkEv2,
    #[serde(rename = "IKEv1")]
    IkEv1,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionResetSharedKey {
    #[serde(rename = "keyLength")]
    pub key_length: i32,
}
impl ConnectionResetSharedKey {
    pub fn new(key_length: i32) -> Self {
        Self { key_length }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionSharedKey {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub value: String,
}
impl ConnectionSharedKey {
    pub fn new(value: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            value,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosSettings {
    #[serde(rename = "ddosCustomPolicy", default, skip_serializing_if = "Option::is_none")]
    pub ddos_custom_policy: Option<SubResource>,
    #[serde(rename = "protectionCoverage", default, skip_serializing_if = "Option::is_none")]
    pub protection_coverage: Option<ddos_settings::ProtectionCoverage>,
}
impl DdosSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ddos_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionCoverage {
        Basic,
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Delegation {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceDelegationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Delegation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DhcpOptions {
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
}
impl DhcpOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "internalName", default, skip_serializing_if = "Option::is_none")]
    pub internal_name: Option<String>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroup {
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub association: Option<EffectiveNetworkSecurityGroupAssociation>,
    #[serde(rename = "effectiveSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_security_rules: Vec<EffectiveNetworkSecurityRule>,
    #[serde(rename = "tagMap", default, skip_serializing_if = "Option::is_none")]
    pub tag_map: Option<String>,
}
impl EffectiveNetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupAssociation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<SubResource>,
}
impl EffectiveNetworkSecurityGroupAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveNetworkSecurityGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveNetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<effective_network_security_rule::Protocol>,
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[serde(rename = "destinationAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub destination_address_prefix: Option<String>,
    #[serde(rename = "sourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub source_address_prefixes: Vec<String>,
    #[serde(rename = "destinationAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_address_prefixes: Vec<String>,
    #[serde(rename = "expandedSourceAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_source_address_prefix: Vec<String>,
    #[serde(rename = "expandedDestinationAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_destination_address_prefix: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<effective_network_security_rule::Access>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<effective_network_security_rule::Direction>,
}
impl EffectiveNetworkSecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_network_security_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        All,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRoute {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<effective_route::Source>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<effective_route::State>,
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefix: Vec<String>,
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hop_ip_address: Vec<String>,
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<effective_route::NextHopType>,
}
impl EffectiveRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_route {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        Unknown,
        User,
        VirtualNetworkGateway,
        Default,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Active,
        Invalid,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextHopType {
        VirtualNetworkGateway,
        VnetLocal,
        Internet,
        VirtualAppliance,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRouteListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveRoute>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveRouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointService {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl EndpointService {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Error {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetails>,
    #[serde(rename = "innerError", default, skip_serializing_if = "Option::is_none")]
    pub inner_error: Option<String>,
}
impl Error {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FrontendIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl FrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfigurationPropertiesFormat {
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<SubResource>,
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<SubResource>,
    #[serde(rename = "outboundRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_rules: Vec<SubResource>,
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<frontend_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[serde(rename = "publicIPPrefix", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_prefix: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl FrontendIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod frontend_ip_configuration_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayRoute {
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[serde(rename = "sourcePeer", default, skip_serializing_if = "Option::is_none")]
    pub source_peer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(rename = "asPath", default, skip_serializing_if = "Option::is_none")]
    pub as_path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
}
impl GatewayRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayRouteListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GatewayRoute>,
}
impl GatewayRouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressAvailabilityResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
    #[serde(rename = "availableIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub available_ip_addresses: Vec<String>,
}
impl IpAddressAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationProfile {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpConfigurationProfilePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpConfigurationProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationProfilePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl IpConfigurationProfilePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationPropertiesFormat {
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl IpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ip_configuration_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatPoolPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl InboundNatPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundNatPoolPropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    pub protocol: TransportProtocol,
    #[serde(rename = "frontendPortRangeStart")]
    pub frontend_port_range_start: i32,
    #[serde(rename = "frontendPortRangeEnd")]
    pub frontend_port_range_end: i32,
    #[serde(rename = "backendPort")]
    pub backend_port: i32,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl InboundNatPoolPropertiesFormat {
    pub fn new(protocol: TransportProtocol, frontend_port_range_start: i32, frontend_port_range_end: i32, backend_port: i32) -> Self {
        Self {
            frontend_ip_configuration: None,
            protocol,
            frontend_port_range_start,
            frontend_port_range_end,
            backend_port,
            idle_timeout_in_minutes: None,
            enable_floating_ip: None,
            enable_tcp_reset: None,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl InboundNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<InboundNatRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl InboundNatRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRulePropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[serde(rename = "backendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub backend_ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<TransportProtocol>,
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<i32>,
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl InboundNatRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InterfaceEndpoint {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InterfaceEndpointProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl InterfaceEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InterfaceEndpointProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "endpointService", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_service: Option<EndpointService>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub owner: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl InterfaceEndpointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpTag {
    #[serde(rename = "ipTagType", default, skip_serializing_if = "Option::is_none")]
    pub ip_tag_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
}
impl IpTag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpsecPolicy {
    #[serde(rename = "saLifeTimeSeconds")]
    pub sa_life_time_seconds: i32,
    #[serde(rename = "saDataSizeKilobytes")]
    pub sa_data_size_kilobytes: i32,
    #[serde(rename = "ipsecEncryption")]
    pub ipsec_encryption: ipsec_policy::IpsecEncryption,
    #[serde(rename = "ipsecIntegrity")]
    pub ipsec_integrity: ipsec_policy::IpsecIntegrity,
    #[serde(rename = "ikeEncryption")]
    pub ike_encryption: ipsec_policy::IkeEncryption,
    #[serde(rename = "ikeIntegrity")]
    pub ike_integrity: ipsec_policy::IkeIntegrity,
    #[serde(rename = "dhGroup")]
    pub dh_group: ipsec_policy::DhGroup,
    #[serde(rename = "pfsGroup")]
    pub pfs_group: ipsec_policy::PfsGroup,
}
impl IpsecPolicy {
    pub fn new(
        sa_life_time_seconds: i32,
        sa_data_size_kilobytes: i32,
        ipsec_encryption: ipsec_policy::IpsecEncryption,
        ipsec_integrity: ipsec_policy::IpsecIntegrity,
        ike_encryption: ipsec_policy::IkeEncryption,
        ike_integrity: ipsec_policy::IkeIntegrity,
        dh_group: ipsec_policy::DhGroup,
        pfs_group: ipsec_policy::PfsGroup,
    ) -> Self {
        Self {
            sa_life_time_seconds,
            sa_data_size_kilobytes,
            ipsec_encryption,
            ipsec_integrity,
            ike_encryption,
            ike_integrity,
            dh_group,
            pfs_group,
        }
    }
}
pub mod ipsec_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IpsecEncryption {
        None,
        #[serde(rename = "DES")]
        Des,
        #[serde(rename = "DES3")]
        Des3,
        #[serde(rename = "AES128")]
        Aes128,
        #[serde(rename = "AES192")]
        Aes192,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
        #[serde(rename = "GCMAES192")]
        Gcmaes192,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IpsecIntegrity {
        #[serde(rename = "MD5")]
        Md5,
        #[serde(rename = "SHA1")]
        Sha1,
        #[serde(rename = "SHA256")]
        Sha256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
        #[serde(rename = "GCMAES192")]
        Gcmaes192,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IkeEncryption {
        #[serde(rename = "DES")]
        Des,
        #[serde(rename = "DES3")]
        Des3,
        #[serde(rename = "AES128")]
        Aes128,
        #[serde(rename = "AES192")]
        Aes192,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IkeIntegrity {
        #[serde(rename = "MD5")]
        Md5,
        #[serde(rename = "SHA1")]
        Sha1,
        #[serde(rename = "SHA256")]
        Sha256,
        #[serde(rename = "SHA384")]
        Sha384,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DhGroup {
        None,
        #[serde(rename = "DHGroup1")]
        DhGroup1,
        #[serde(rename = "DHGroup2")]
        DhGroup2,
        #[serde(rename = "DHGroup14")]
        DhGroup14,
        #[serde(rename = "DHGroup2048")]
        DhGroup2048,
        #[serde(rename = "ECP256")]
        Ecp256,
        #[serde(rename = "ECP384")]
        Ecp384,
        #[serde(rename = "DHGroup24")]
        DhGroup24,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PfsGroup {
        None,
        #[serde(rename = "PFS1")]
        Pfs1,
        #[serde(rename = "PFS2")]
        Pfs2,
        #[serde(rename = "PFS2048")]
        Pfs2048,
        #[serde(rename = "ECP256")]
        Ecp256,
        #[serde(rename = "ECP384")]
        Ecp384,
        #[serde(rename = "PFS24")]
        Pfs24,
        #[serde(rename = "PFS14")]
        Pfs14,
        #[serde(rename = "PFSMM")]
        Pfsmm,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancer {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<LoadBalancerSku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancerPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LoadBalancer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerBackendAddressPoolListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackendAddressPool>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerBackendAddressPoolListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerFrontendIpConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FrontendIpConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerFrontendIpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancer>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerLoadBalancingRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancingRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerLoadBalancingRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerOutboundRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OutboundRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerOutboundRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerProbeListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Probe>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerProbeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerPropertiesFormat {
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<FrontendIpConfiguration>,
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<BackendAddressPool>,
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<LoadBalancingRule>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub probes: Vec<Probe>,
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<InboundNatRule>,
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<InboundNatPool>,
    #[serde(rename = "outboundRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_rules: Vec<OutboundRule>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LoadBalancerPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerSku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<load_balancer_sku::Name>,
}
impl LoadBalancerSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod load_balancer_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancingRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancingRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LoadBalancingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LoadBalancingRulePropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub probe: Option<SubResource>,
    pub protocol: TransportProtocol,
    #[serde(rename = "loadDistribution", default, skip_serializing_if = "Option::is_none")]
    pub load_distribution: Option<load_balancing_rule_properties_format::LoadDistribution>,
    #[serde(rename = "frontendPort")]
    pub frontend_port: i32,
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[serde(rename = "disableOutboundSnat", default, skip_serializing_if = "Option::is_none")]
    pub disable_outbound_snat: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LoadBalancingRulePropertiesFormat {
    pub fn new(protocol: TransportProtocol, frontend_port: i32) -> Self {
        Self {
            frontend_ip_configuration: None,
            backend_address_pool: None,
            probe: None,
            protocol,
            load_distribution: None,
            frontend_port,
            backend_port: None,
            idle_timeout_in_minutes: None,
            enable_floating_ip: None,
            enable_tcp_reset: None,
            disable_outbound_snat: None,
            provisioning_state: None,
        }
    }
}
pub mod load_balancing_rule_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadDistribution {
        Default,
        #[serde(rename = "SourceIP")]
        SourceIp,
        #[serde(rename = "SourceIPProtocol")]
        SourceIpProtocol,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LocalNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: LocalNetworkGatewayPropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LocalNetworkGateway {
    pub fn new(properties: LocalNetworkGatewayPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LocalNetworkGateway>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LocalNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayPropertiesFormat {
    #[serde(rename = "localNetworkAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub local_network_address_space: Option<AddressSpace>,
    #[serde(rename = "gatewayIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub gateway_ip_address: Option<String>,
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl LocalNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl LogSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedServiceIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<managed_service_identity::Type>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl ManagedServiceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_service_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub availabilities: Vec<Availability>,
    #[serde(rename = "enableRegionalMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub enable_regional_mdm_account: Option<bool>,
    #[serde(rename = "fillGapWithZero", default, skip_serializing_if = "Option::is_none")]
    pub fill_gap_with_zero: Option<bool>,
    #[serde(rename = "metricFilterPattern", default, skip_serializing_if = "Option::is_none")]
    pub metric_filter_pattern: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Dimension>,
    #[serde(rename = "isInternal", default, skip_serializing_if = "Option::is_none")]
    pub is_internal: Option<bool>,
    #[serde(rename = "sourceMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_account: Option<String>,
    #[serde(rename = "sourceMdmNamespace", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_namespace: Option<String>,
    #[serde(rename = "resourceIdDimensionNameOverride", default, skip_serializing_if = "Option::is_none")]
    pub resource_id_dimension_name_override: Option<String>,
}
impl MetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterface {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfacePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceDnsSettings {
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
    #[serde(rename = "appliedDnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub applied_dns_servers: Vec<String>,
    #[serde(rename = "internalDnsNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub internal_dns_name_label: Option<String>,
    #[serde(rename = "internalFqdn", default, skip_serializing_if = "Option::is_none")]
    pub internal_fqdn: Option<String>,
    #[serde(rename = "internalDomainNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub internal_domain_name_suffix: Option<String>,
}
impl NetworkInterfaceDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkInterfaceIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterfaceIpConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceIpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationPropertiesFormat {
    #[serde(rename = "virtualNetworkTaps", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_taps: Vec<VirtualNetworkTap>,
    #[serde(rename = "applicationGatewayBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_backend_address_pools: Vec<ApplicationGatewayBackendAddressPool>,
    #[serde(rename = "loadBalancerBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_address_pools: Vec<BackendAddressPool>,
    #[serde(rename = "loadBalancerInboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_inbound_nat_rules: Vec<InboundNatRule>,
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<network_interface_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<network_interface_ip_configuration_properties_format::PrivateIpAddressVersion>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[serde(rename = "applicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub application_security_groups: Vec<ApplicationSecurityGroup>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkInterfaceIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_interface_ip_configuration_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAddressVersion {
        IPv4,
        IPv6,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterface>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceLoadBalancerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancer>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceLoadBalancerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfacePropertiesFormat {
    #[serde(rename = "virtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine: Option<SubResource>,
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[serde(rename = "interfaceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub interface_endpoint: Option<InterfaceEndpoint>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[serde(rename = "tapConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub tap_configurations: Vec<NetworkInterfaceTapConfiguration>,
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<NetworkInterfaceDnsSettings>,
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "enableAcceleratedNetworking", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking: Option<bool>,
    #[serde(rename = "enableIPForwarding", default, skip_serializing_if = "Option::is_none")]
    pub enable_ip_forwarding: Option<bool>,
    #[serde(rename = "hostedWorkloads", default, skip_serializing_if = "Vec::is_empty")]
    pub hosted_workloads: Vec<String>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkInterfacePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceTapConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceTapConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl NetworkInterfaceTapConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceTapConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterfaceTapConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceTapConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceTapConfigurationPropertiesFormat {
    #[serde(rename = "virtualNetworkTap", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_tap: Option<VirtualNetworkTap>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkInterfaceTapConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkSecurityGroupPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkSecurityGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupPropertiesFormat {
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
    #[serde(rename = "defaultSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub default_security_rules: Vec<SecurityRule>,
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl NetworkSecurityGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationPropertiesFormat>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationPropertiesFormat {
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<operation_properties_format::ServiceSpecification>,
}
impl OperationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ServiceSpecification {
        #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
        pub metric_specifications: Vec<MetricSpecification>,
        #[serde(rename = "logSpecifications", default, skip_serializing_if = "Vec::is_empty")]
        pub log_specifications: Vec<LogSpecification>,
    }
    impl ServiceSpecification {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OutboundRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OutboundRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl OutboundRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutboundRulePropertiesFormat {
    #[serde(rename = "allocatedOutboundPorts", default, skip_serializing_if = "Option::is_none")]
    pub allocated_outbound_ports: Option<i32>,
    #[serde(rename = "frontendIPConfigurations")]
    pub frontend_ip_configurations: Vec<SubResource>,
    #[serde(rename = "backendAddressPool")]
    pub backend_address_pool: SubResource,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    pub protocol: outbound_rule_properties_format::Protocol,
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i64>,
}
impl OutboundRulePropertiesFormat {
    pub fn new(
        frontend_ip_configurations: Vec<SubResource>,
        backend_address_pool: SubResource,
        protocol: outbound_rule_properties_format::Protocol,
    ) -> Self {
        Self {
            allocated_outbound_ports: None,
            frontend_ip_configurations,
            backend_address_pool,
            provisioning_state: None,
            protocol,
            enable_tcp_reset: None,
            idle_timeout_in_minutes: None,
        }
    }
}
pub mod outbound_rule_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        All,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Probe {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProbePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Probe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProbePropertiesFormat {
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    pub protocol: probe_properties_format::Protocol,
    pub port: i32,
    #[serde(rename = "intervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub interval_in_seconds: Option<i32>,
    #[serde(rename = "numberOfProbes", default, skip_serializing_if = "Option::is_none")]
    pub number_of_probes: Option<i32>,
    #[serde(rename = "requestPath", default, skip_serializing_if = "Option::is_none")]
    pub request_path: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ProbePropertiesFormat {
    pub fn new(protocol: probe_properties_format::Protocol, port: i32) -> Self {
        Self {
            load_balancing_rules: Vec::new(),
            protocol,
            port,
            interval_in_seconds: None,
            number_of_probes: None,
            request_path: None,
            provisioning_state: None,
        }
    }
}
pub mod probe_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Tcp,
        Https,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddress {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<PublicIpAddressSku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Box<Option<PublicIpAddressPropertiesFormat>>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl PublicIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressDnsSettings {
    #[serde(rename = "domainNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub domain_name_label: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "reverseFqdn", default, skip_serializing_if = "Option::is_none")]
    pub reverse_fqdn: Option<String>,
}
impl PublicIpAddressDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PublicIpAddress>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PublicIpAddressListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressPropertiesFormat {
    #[serde(rename = "publicIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_allocation_method: Option<public_ip_address_properties_format::PublicIpAllocationMethod>,
    #[serde(rename = "publicIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_version: Option<public_ip_address_properties_format::PublicIpAddressVersion>,
    #[serde(rename = "ipConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration: Option<IpConfiguration>,
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<PublicIpAddressDnsSettings>,
    #[serde(rename = "ddosSettings", default, skip_serializing_if = "Option::is_none")]
    pub ddos_settings: Option<DdosSettings>,
    #[serde(rename = "ipTags", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_tags: Vec<IpTag>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "publicIPPrefix", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_prefix: Option<SubResource>,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl PublicIpAddressPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_address_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicIpAllocationMethod {
        Static,
        Dynamic,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PublicIpAddressVersion {
        IPv4,
        IPv6,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressSku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<public_ip_address_sku::Name>,
}
impl PublicIpAddressSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_address_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ResourceNavigationLinkFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ResourceNavigationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLinkFormat {
    #[serde(rename = "linkedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ResourceNavigationLinkFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Route {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RoutePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Route {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Route>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutePropertiesFormat {
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "nextHopType")]
    pub next_hop_type: route_properties_format::NextHopType,
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl RoutePropertiesFormat {
    pub fn new(next_hop_type: route_properties_format::NextHopType) -> Self {
        Self {
            address_prefix: None,
            next_hop_type,
            next_hop_ip_address: None,
            provisioning_state: None,
        }
    }
}
pub mod route_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextHopType {
        VirtualNetworkGateway,
        VnetLocal,
        Internet,
        VirtualAppliance,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTable {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteTablePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTableListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteTable>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTablePropertiesFormat {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<Route>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[serde(rename = "disableBgpRoutePropagation", default, skip_serializing_if = "Option::is_none")]
    pub disable_bgp_route_propagation: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl RouteTablePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl SecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityRulePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    pub protocol: security_rule_properties_format::Protocol,
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[serde(rename = "sourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub source_address_prefixes: Vec<String>,
    #[serde(rename = "sourceApplicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_application_security_groups: Vec<ApplicationSecurityGroup>,
    #[serde(rename = "destinationAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub destination_address_prefix: Option<String>,
    #[serde(rename = "destinationAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_address_prefixes: Vec<String>,
    #[serde(rename = "destinationApplicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_application_security_groups: Vec<ApplicationSecurityGroup>,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    pub access: security_rule_properties_format::Access,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    pub direction: security_rule_properties_format::Direction,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl SecurityRulePropertiesFormat {
    pub fn new(
        protocol: security_rule_properties_format::Protocol,
        access: security_rule_properties_format::Access,
        direction: security_rule_properties_format::Direction,
    ) -> Self {
        Self {
            description: None,
            protocol,
            source_port_range: None,
            destination_port_range: None,
            source_address_prefix: None,
            source_address_prefixes: Vec::new(),
            source_application_security_groups: Vec::new(),
            destination_address_prefix: None,
            destination_address_prefixes: Vec::new(),
            destination_application_security_groups: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            access,
            priority: None,
            direction,
            provisioning_state: None,
        }
    }
}
pub mod security_rule_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        #[serde(rename = "*")]
        U2a,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        Allow,
        Deny,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Direction {
        Inbound,
        Outbound,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceAssociationLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceAssociationLinkPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ServiceAssociationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceAssociationLinkPropertiesFormat {
    #[serde(rename = "linkedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ServiceAssociationLinkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceDelegationPropertiesFormat {
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub actions: Vec<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ServiceDelegationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceEndpointPolicyPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ServiceEndpointPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyDefinition {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceEndpointPolicyDefinitionPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ServiceEndpointPolicyDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyDefinitionPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub service: Option<String>,
    #[serde(rename = "serviceResources", default, skip_serializing_if = "Vec::is_empty")]
    pub service_resources: Vec<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ServiceEndpointPolicyDefinitionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyPropertiesFormat {
    #[serde(rename = "serviceEndpointPolicyDefinitions", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoint_policy_definitions: Vec<ServiceEndpointPolicyDefinition>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ServiceEndpointPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub service: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl ServiceEndpointPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Subnet {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubnetPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Subnet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Subnet>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SubnetListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetPropertiesFormat {
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[serde(rename = "routeTable", default, skip_serializing_if = "Option::is_none")]
    pub route_table: Option<RouteTable>,
    #[serde(rename = "serviceEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoints: Vec<ServiceEndpointPropertiesFormat>,
    #[serde(rename = "serviceEndpointPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoint_policies: Vec<ServiceEndpointPolicy>,
    #[serde(rename = "interfaceEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub interface_endpoints: Vec<InterfaceEndpoint>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<IpConfiguration>,
    #[serde(rename = "ipConfigurationProfiles", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configuration_profiles: Vec<IpConfigurationProfile>,
    #[serde(rename = "resourceNavigationLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_navigation_links: Vec<ResourceNavigationLink>,
    #[serde(rename = "serviceAssociationLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub service_association_links: Vec<ServiceAssociationLink>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub delegations: Vec<Delegation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub purpose: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl SubnetPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsObject {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TagsObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TransportProtocol {
    Udp,
    Tcp,
    All,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TunnelConnectionHealth {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tunnel: Option<String>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<tunnel_connection_health::ConnectionStatus>,
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[serde(rename = "lastConnectionEstablishedUtcTime", default, skip_serializing_if = "Option::is_none")]
    pub last_connection_established_utc_time: Option<String>,
}
impl TunnelConnectionHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod tunnel_connection_health {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connecting,
        Connected,
        NotConnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetwork {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: VirtualNetworkGatewayPropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGateway {
    pub fn new(properties: VirtualNetworkGatewayPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnection {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: VirtualNetworkGatewayConnectionPropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayConnection {
    pub fn new(properties: VirtualNetworkGatewayConnectionPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionListEntity {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: VirtualNetworkGatewayConnectionListEntityPropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayConnectionListEntity {
    pub fn new(properties: VirtualNetworkGatewayConnectionListEntityPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionListEntityPropertiesFormat {
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[serde(rename = "virtualNetworkGateway1")]
    pub virtual_network_gateway1: VirtualNetworkConnectionGatewayReference,
    #[serde(rename = "virtualNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway2: Option<VirtualNetworkConnectionGatewayReference>,
    #[serde(rename = "localNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub local_network_gateway2: Option<VirtualNetworkConnectionGatewayReference>,
    #[serde(rename = "connectionType")]
    pub connection_type: virtual_network_gateway_connection_list_entity_properties_format::ConnectionType,
    #[serde(rename = "connectionProtocol", default, skip_serializing_if = "Option::is_none")]
    pub connection_protocol: Option<ConnectionProtocol>,
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<virtual_network_gateway_connection_list_entity_properties_format::ConnectionStatus>,
    #[serde(rename = "tunnelConnectionStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_connection_status: Vec<TunnelConnectionHealth>,
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub peer: Option<SubResource>,
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "expressRouteGatewayBypass", default, skip_serializing_if = "Option::is_none")]
    pub express_route_gateway_bypass: Option<bool>,
}
impl VirtualNetworkGatewayConnectionListEntityPropertiesFormat {
    pub fn new(
        virtual_network_gateway1: VirtualNetworkConnectionGatewayReference,
        connection_type: virtual_network_gateway_connection_list_entity_properties_format::ConnectionType,
    ) -> Self {
        Self {
            authorization_key: None,
            virtual_network_gateway1,
            virtual_network_gateway2: None,
            local_network_gateway2: None,
            connection_type,
            connection_protocol: None,
            routing_weight: None,
            shared_key: None,
            connection_status: None,
            tunnel_connection_status: Vec::new(),
            egress_bytes_transferred: None,
            ingress_bytes_transferred: None,
            peer: None,
            enable_bgp: None,
            use_policy_based_traffic_selectors: None,
            ipsec_policies: Vec::new(),
            resource_guid: None,
            provisioning_state: None,
            express_route_gateway_bypass: None,
        }
    }
}
pub mod virtual_network_gateway_connection_list_entity_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionType {
        IPsec,
        Vnet2Vnet,
        ExpressRoute,
        #[serde(rename = "VPNClient")]
        VpnClient,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connecting,
        Connected,
        NotConnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionPropertiesFormat {
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[serde(rename = "virtualNetworkGateway1")]
    pub virtual_network_gateway1: VirtualNetworkGateway,
    #[serde(rename = "virtualNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway2: Option<VirtualNetworkGateway>,
    #[serde(rename = "localNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub local_network_gateway2: Option<LocalNetworkGateway>,
    #[serde(rename = "connectionType")]
    pub connection_type: virtual_network_gateway_connection_properties_format::ConnectionType,
    #[serde(rename = "connectionProtocol", default, skip_serializing_if = "Option::is_none")]
    pub connection_protocol: Option<ConnectionProtocol>,
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<virtual_network_gateway_connection_properties_format::ConnectionStatus>,
    #[serde(rename = "tunnelConnectionStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_connection_status: Vec<TunnelConnectionHealth>,
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub peer: Option<SubResource>,
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "expressRouteGatewayBypass", default, skip_serializing_if = "Option::is_none")]
    pub express_route_gateway_bypass: Option<bool>,
}
impl VirtualNetworkGatewayConnectionPropertiesFormat {
    pub fn new(
        virtual_network_gateway1: VirtualNetworkGateway,
        connection_type: virtual_network_gateway_connection_properties_format::ConnectionType,
    ) -> Self {
        Self {
            authorization_key: None,
            virtual_network_gateway1,
            virtual_network_gateway2: None,
            local_network_gateway2: None,
            connection_type,
            connection_protocol: None,
            routing_weight: None,
            shared_key: None,
            connection_status: None,
            tunnel_connection_status: Vec::new(),
            egress_bytes_transferred: None,
            ingress_bytes_transferred: None,
            peer: None,
            enable_bgp: None,
            use_policy_based_traffic_selectors: None,
            ipsec_policies: Vec::new(),
            resource_guid: None,
            provisioning_state: None,
            express_route_gateway_bypass: None,
        }
    }
}
pub mod virtual_network_gateway_connection_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionType {
        IPsec,
        Vnet2Vnet,
        ExpressRoute,
        #[serde(rename = "VPNClient")]
        VpnClient,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connecting,
        Connected,
        NotConnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkGatewayIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<virtual_network_gateway_ip_configuration_properties_format::PrivateIpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_ip_configuration_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PrivateIpAllocationMethod {
        Static,
        Dynamic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayListConnectionsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayConnectionListEntity>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayListConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGateway>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayPropertiesFormat {
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<VirtualNetworkGatewayIpConfiguration>,
    #[serde(rename = "gatewayType", default, skip_serializing_if = "Option::is_none")]
    pub gateway_type: Option<virtual_network_gateway_properties_format::GatewayType>,
    #[serde(rename = "vpnType", default, skip_serializing_if = "Option::is_none")]
    pub vpn_type: Option<virtual_network_gateway_properties_format::VpnType>,
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[serde(rename = "activeActive", default, skip_serializing_if = "Option::is_none")]
    pub active_active: Option<bool>,
    #[serde(rename = "gatewayDefaultSite", default, skip_serializing_if = "Option::is_none")]
    pub gateway_default_site: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<VirtualNetworkGatewaySku>,
    #[serde(rename = "vpnClientConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_configuration: Option<VpnClientConfiguration>,
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GatewayType {
        Vpn,
        ExpressRoute,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VpnType {
        PolicyBased,
        RouteBased,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewaySku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<virtual_network_gateway_sku::Name>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<virtual_network_gateway_sku::Tier>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl VirtualNetworkGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
        #[serde(rename = "VpnGw1AZ")]
        VpnGw1Az,
        #[serde(rename = "VpnGw2AZ")]
        VpnGw2Az,
        #[serde(rename = "VpnGw3AZ")]
        VpnGw3Az,
        #[serde(rename = "ErGw1AZ")]
        ErGw1Az,
        #[serde(rename = "ErGw2AZ")]
        ErGw2Az,
        #[serde(rename = "ErGw3AZ")]
        ErGw3Az,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
        #[serde(rename = "VpnGw1AZ")]
        VpnGw1Az,
        #[serde(rename = "VpnGw2AZ")]
        VpnGw2Az,
        #[serde(rename = "VpnGw3AZ")]
        VpnGw3Az,
        #[serde(rename = "ErGw1AZ")]
        ErGw1Az,
        #[serde(rename = "ErGw2AZ")]
        ErGw2Az,
        #[serde(rename = "ErGw3AZ")]
        ErGw3Az,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetwork>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkListUsageResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkUsage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkListUsageResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPeeringPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkPeering>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringPropertiesFormat {
    #[serde(rename = "allowVirtualNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub allow_virtual_network_access: Option<bool>,
    #[serde(rename = "allowForwardedTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_forwarded_traffic: Option<bool>,
    #[serde(rename = "allowGatewayTransit", default, skip_serializing_if = "Option::is_none")]
    pub allow_gateway_transit: Option<bool>,
    #[serde(rename = "useRemoteGateways", default, skip_serializing_if = "Option::is_none")]
    pub use_remote_gateways: Option<bool>,
    #[serde(rename = "remoteVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub remote_virtual_network: Option<SubResource>,
    #[serde(rename = "remoteAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub remote_address_space: Option<AddressSpace>,
    #[serde(rename = "peeringState", default, skip_serializing_if = "Option::is_none")]
    pub peering_state: Option<virtual_network_peering_properties_format::PeeringState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VirtualNetworkPeeringPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_peering_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PeeringState {
        Initiated,
        Connected,
        Disconnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPropertiesFormat {
    #[serde(rename = "addressSpace", default, skip_serializing_if = "Option::is_none")]
    pub address_space: Option<AddressSpace>,
    #[serde(rename = "dhcpOptions", default, skip_serializing_if = "Option::is_none")]
    pub dhcp_options: Option<DhcpOptions>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[serde(rename = "virtualNetworkPeerings", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_peerings: Vec<VirtualNetworkPeering>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "enableDdosProtection", default, skip_serializing_if = "Option::is_none")]
    pub enable_ddos_protection: Option<bool>,
    #[serde(rename = "enableVmProtection", default, skip_serializing_if = "Option::is_none")]
    pub enable_vm_protection: Option<bool>,
    #[serde(rename = "ddosProtectionPlan", default, skip_serializing_if = "Option::is_none")]
    pub ddos_protection_plan: Option<SubResource>,
}
impl VirtualNetworkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkTap {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkTapPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkTap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkTapPropertiesFormat {
    #[serde(rename = "networkInterfaceTapConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interface_tap_configurations: Vec<NetworkInterfaceTapConfiguration>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(
        rename = "destinationNetworkInterfaceIPConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub destination_network_interface_ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[serde(
        rename = "destinationLoadBalancerFrontEndIPConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub destination_load_balancer_front_end_ip_configuration: Option<FrontendIpConfiguration>,
    #[serde(rename = "destinationPort", default, skip_serializing_if = "Option::is_none")]
    pub destination_port: Option<i64>,
}
impl VirtualNetworkTapPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkUsage {
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<VirtualNetworkUsageName>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
}
impl VirtualNetworkUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkUsageName {
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl VirtualNetworkUsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConfiguration {
    #[serde(rename = "vpnClientAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_address_pool: Option<AddressSpace>,
    #[serde(rename = "vpnClientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_root_certificates: Vec<VpnClientRootCertificate>,
    #[serde(rename = "vpnClientRevokedCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_revoked_certificates: Vec<VpnClientRevokedCertificate>,
    #[serde(rename = "vpnClientProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_protocols: Vec<String>,
    #[serde(rename = "vpnClientIpsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_ipsec_policies: Vec<IpsecPolicy>,
    #[serde(rename = "radiusServerAddress", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_address: Option<String>,
    #[serde(rename = "radiusServerSecret", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_secret: Option<String>,
}
impl VpnClientConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientIPsecParameters {
    #[serde(rename = "saLifeTimeSeconds")]
    pub sa_life_time_seconds: i32,
    #[serde(rename = "saDataSizeKilobytes")]
    pub sa_data_size_kilobytes: i32,
    #[serde(rename = "ipsecEncryption")]
    pub ipsec_encryption: vpn_client_i_psec_parameters::IpsecEncryption,
    #[serde(rename = "ipsecIntegrity")]
    pub ipsec_integrity: vpn_client_i_psec_parameters::IpsecIntegrity,
    #[serde(rename = "ikeEncryption")]
    pub ike_encryption: vpn_client_i_psec_parameters::IkeEncryption,
    #[serde(rename = "ikeIntegrity")]
    pub ike_integrity: vpn_client_i_psec_parameters::IkeIntegrity,
    #[serde(rename = "dhGroup")]
    pub dh_group: vpn_client_i_psec_parameters::DhGroup,
    #[serde(rename = "pfsGroup")]
    pub pfs_group: vpn_client_i_psec_parameters::PfsGroup,
}
impl VpnClientIPsecParameters {
    pub fn new(
        sa_life_time_seconds: i32,
        sa_data_size_kilobytes: i32,
        ipsec_encryption: vpn_client_i_psec_parameters::IpsecEncryption,
        ipsec_integrity: vpn_client_i_psec_parameters::IpsecIntegrity,
        ike_encryption: vpn_client_i_psec_parameters::IkeEncryption,
        ike_integrity: vpn_client_i_psec_parameters::IkeIntegrity,
        dh_group: vpn_client_i_psec_parameters::DhGroup,
        pfs_group: vpn_client_i_psec_parameters::PfsGroup,
    ) -> Self {
        Self {
            sa_life_time_seconds,
            sa_data_size_kilobytes,
            ipsec_encryption,
            ipsec_integrity,
            ike_encryption,
            ike_integrity,
            dh_group,
            pfs_group,
        }
    }
}
pub mod vpn_client_i_psec_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IpsecEncryption {
        None,
        #[serde(rename = "DES")]
        Des,
        #[serde(rename = "DES3")]
        Des3,
        #[serde(rename = "AES128")]
        Aes128,
        #[serde(rename = "AES192")]
        Aes192,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
        #[serde(rename = "GCMAES192")]
        Gcmaes192,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IpsecIntegrity {
        #[serde(rename = "MD5")]
        Md5,
        #[serde(rename = "SHA1")]
        Sha1,
        #[serde(rename = "SHA256")]
        Sha256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
        #[serde(rename = "GCMAES192")]
        Gcmaes192,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IkeEncryption {
        #[serde(rename = "DES")]
        Des,
        #[serde(rename = "DES3")]
        Des3,
        #[serde(rename = "AES128")]
        Aes128,
        #[serde(rename = "AES192")]
        Aes192,
        #[serde(rename = "AES256")]
        Aes256,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IkeIntegrity {
        #[serde(rename = "MD5")]
        Md5,
        #[serde(rename = "SHA1")]
        Sha1,
        #[serde(rename = "SHA256")]
        Sha256,
        #[serde(rename = "SHA384")]
        Sha384,
        #[serde(rename = "GCMAES256")]
        Gcmaes256,
        #[serde(rename = "GCMAES128")]
        Gcmaes128,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DhGroup {
        None,
        #[serde(rename = "DHGroup1")]
        DhGroup1,
        #[serde(rename = "DHGroup2")]
        DhGroup2,
        #[serde(rename = "DHGroup14")]
        DhGroup14,
        #[serde(rename = "DHGroup2048")]
        DhGroup2048,
        #[serde(rename = "ECP256")]
        Ecp256,
        #[serde(rename = "ECP384")]
        Ecp384,
        #[serde(rename = "DHGroup24")]
        DhGroup24,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PfsGroup {
        None,
        #[serde(rename = "PFS1")]
        Pfs1,
        #[serde(rename = "PFS2")]
        Pfs2,
        #[serde(rename = "PFS2048")]
        Pfs2048,
        #[serde(rename = "ECP256")]
        Ecp256,
        #[serde(rename = "ECP384")]
        Ecp384,
        #[serde(rename = "PFS24")]
        Pfs24,
        #[serde(rename = "PFS14")]
        Pfs14,
        #[serde(rename = "PFSMM")]
        Pfsmm,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientParameters {
    #[serde(rename = "processorArchitecture", default, skip_serializing_if = "Option::is_none")]
    pub processor_architecture: Option<vpn_client_parameters::ProcessorArchitecture>,
    #[serde(rename = "authenticationMethod", default, skip_serializing_if = "Option::is_none")]
    pub authentication_method: Option<vpn_client_parameters::AuthenticationMethod>,
    #[serde(rename = "radiusServerAuthCertificate", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_auth_certificate: Option<String>,
    #[serde(rename = "clientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub client_root_certificates: Vec<String>,
}
impl VpnClientParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vpn_client_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProcessorArchitecture {
        Amd64,
        X86,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationMethod {
        #[serde(rename = "EAPTLS")]
        Eaptls,
        #[serde(rename = "EAPMSCHAPv2")]
        EapmschaPv2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnClientRevokedCertificatePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRevokedCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificatePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VpnClientRevokedCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientRootCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: VpnClientRootCertificatePropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRootCertificate {
    pub fn new(properties: VpnClientRootCertificatePropertiesFormat) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
            name: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientRootCertificatePropertiesFormat {
    #[serde(rename = "publicCertData")]
    pub public_cert_data: String,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl VpnClientRootCertificatePropertiesFormat {
    pub fn new(public_cert_data: String) -> Self {
        Self {
            public_cert_data,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnDeviceScriptParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
    #[serde(rename = "deviceFamily", default, skip_serializing_if = "Option::is_none")]
    pub device_family: Option<String>,
    #[serde(rename = "firmwareVersion", default, skip_serializing_if = "Option::is_none")]
    pub firmware_version: Option<String>,
}
impl VpnDeviceScriptParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkConnectionGatewayReference {
    pub id: String,
}
impl VirtualNetworkConnectionGatewayReference {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
