#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveBaseSecurityAdminRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "configurationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub configuration_display_name: Option<String>,
    #[serde(rename = "configurationDescription", default, skip_serializing_if = "Option::is_none")]
    pub configuration_description: Option<String>,
    #[serde(rename = "ruleCollectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_display_name: Option<String>,
    #[serde(rename = "ruleCollectionDescription", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_description: Option<String>,
    #[serde(rename = "ruleCollectionAppliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ConfigurationGroup>,
    pub kind: active_base_security_admin_rule::Kind,
}
impl ActiveBaseSecurityAdminRule {
    pub fn new(kind: active_base_security_admin_rule::Kind) -> Self {
        Self {
            id: None,
            commit_time: None,
            region: None,
            configuration_display_name: None,
            configuration_description: None,
            rule_collection_display_name: None,
            rule_collection_description: None,
            rule_collection_applies_to_groups: Vec::new(),
            rule_groups: Vec::new(),
            kind,
        }
    }
}
pub mod active_base_security_admin_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveBaseSecurityUserRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "configurationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub configuration_display_name: Option<String>,
    #[serde(rename = "configurationDescription", default, skip_serializing_if = "Option::is_none")]
    pub configuration_description: Option<String>,
    #[serde(rename = "ruleCollectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_display_name: Option<String>,
    #[serde(rename = "ruleCollectionDescription", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_description: Option<String>,
    #[serde(rename = "ruleCollectionAppliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ConfigurationGroup>,
    pub kind: active_base_security_user_rule::Kind,
}
impl ActiveBaseSecurityUserRule {
    pub fn new(kind: active_base_security_user_rule::Kind) -> Self {
        Self {
            id: None,
            commit_time: None,
            region: None,
            configuration_display_name: None,
            configuration_description: None,
            rule_collection_display_name: None,
            rule_collection_description: None,
            rule_collection_applies_to_groups: Vec::new(),
            rule_groups: Vec::new(),
            kind,
        }
    }
}
pub mod active_base_security_user_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveConfigurationParameter {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub regions: Vec<String>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveConfigurationParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveConnectivityConfiguration {
    #[serde(flatten)]
    pub effective_connectivity_configuration: EffectiveConnectivityConfiguration,
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
}
impl ActiveConnectivityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveConnectivityConfigurationsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ActiveConnectivityConfiguration>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveConnectivityConfigurationsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveDefaultSecurityAdminRule {
    #[serde(flatten)]
    pub active_base_security_admin_rule: ActiveBaseSecurityAdminRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultAdminPropertiesFormat>,
}
impl ActiveDefaultSecurityAdminRule {
    pub fn new(active_base_security_admin_rule: ActiveBaseSecurityAdminRule) -> Self {
        Self {
            active_base_security_admin_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveDefaultSecurityUserRule {
    #[serde(flatten)]
    pub active_base_security_user_rule: ActiveBaseSecurityUserRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultUserRulePropertiesFormat>,
}
impl ActiveDefaultSecurityUserRule {
    pub fn new(active_base_security_user_rule: ActiveBaseSecurityUserRule) -> Self {
        Self {
            active_base_security_user_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveSecurityAdminRule {
    #[serde(flatten)]
    pub active_base_security_admin_rule: ActiveBaseSecurityAdminRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdminPropertiesFormat>,
}
impl ActiveSecurityAdminRule {
    pub fn new(active_base_security_admin_rule: ActiveBaseSecurityAdminRule) -> Self {
        Self {
            active_base_security_admin_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveSecurityAdminRulesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ActiveBaseSecurityAdminRule>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveSecurityAdminRulesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActiveSecurityUserRule {
    #[serde(flatten)]
    pub active_base_security_user_rule: ActiveBaseSecurityUserRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserRulePropertiesFormat>,
}
impl ActiveSecurityUserRule {
    pub fn new(active_base_security_user_rule: ActiveBaseSecurityUserRule) -> Self {
        Self {
            active_base_security_user_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveSecurityUserRulesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ActiveBaseSecurityUserRule>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl ActiveSecurityUserRulesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressPrefixItem {
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "addressPrefixType", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix_type: Option<address_prefix_item::AddressPrefixType>,
}
impl AddressPrefixItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod address_prefix_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AddressPrefixType {
        #[serde(rename = "IPPrefix")]
        IpPrefix,
        ServiceTag,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdminPropertiesFormat {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    pub protocol: RuleProtocol,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    pub access: SecurityConfigurationRuleAccess,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    pub direction: SecurityConfigurationRuleDirection,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AdminPropertiesFormat {
    pub fn new(protocol: RuleProtocol, access: SecurityConfigurationRuleAccess, direction: SecurityConfigurationRuleDirection) -> Self {
        Self {
            display_name: None,
            description: None,
            protocol,
            sources: Vec::new(),
            destinations: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            access,
            priority: None,
            direction,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdminRule {
    #[serde(flatten)]
    pub base_admin_rule: BaseAdminRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdminPropertiesFormat>,
}
impl AdminRule {
    pub fn new(base_admin_rule: BaseAdminRule) -> Self {
        Self {
            base_admin_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdminRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BaseAdminRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AdminRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseAdminRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub kind: base_admin_rule::Kind,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl BaseAdminRule {
    pub fn new(kind: base_admin_rule::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
            system_data: None,
        }
    }
}
pub mod base_admin_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BaseUserRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub kind: base_user_rule::Kind,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl BaseUserRule {
    pub fn new(kind: base_user_rule::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
            system_data: None,
        }
    }
}
pub mod base_user_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConfigurationGroup {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkGroupProperties>,
}
impl ConfigurationGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConfigurationType {
    SecurityAdmin,
    SecurityUser,
    Connectivity,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityConfiguration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectivityConfigurationProperties>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl ConnectivityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConnectivityConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ConnectivityConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivityConfigurationProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "connectivityTopology")]
    pub connectivity_topology: connectivity_configuration_properties::ConnectivityTopology,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hubs: Vec<Hub>,
    #[serde(rename = "isGlobal", default, skip_serializing_if = "Option::is_none")]
    pub is_global: Option<connectivity_configuration_properties::IsGlobal>,
    #[serde(rename = "appliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub applies_to_groups: Vec<ConnectivityGroupItem>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "deleteExistingPeering", default, skip_serializing_if = "Option::is_none")]
    pub delete_existing_peering: Option<connectivity_configuration_properties::DeleteExistingPeering>,
}
impl ConnectivityConfigurationProperties {
    pub fn new(connectivity_topology: connectivity_configuration_properties::ConnectivityTopology) -> Self {
        Self {
            display_name: None,
            description: None,
            connectivity_topology,
            hubs: Vec::new(),
            is_global: None,
            applies_to_groups: Vec::new(),
            provisioning_state: None,
            delete_existing_peering: None,
        }
    }
}
pub mod connectivity_configuration_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectivityTopology {
        HubAndSpoke,
        Mesh,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IsGlobal {
        False,
        True,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeleteExistingPeering {
        False,
        True,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultAdminPropertiesFormat {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<RuleProtocol>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<SecurityConfigurationRuleAccess>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<SecurityConfigurationRuleDirection>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl DefaultAdminPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DefaultAdminRule {
    #[serde(flatten)]
    pub base_admin_rule: BaseAdminRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultAdminPropertiesFormat>,
}
impl DefaultAdminRule {
    pub fn new(base_admin_rule: BaseAdminRule) -> Self {
        Self {
            base_admin_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DefaultUserRule {
    #[serde(flatten)]
    pub base_user_rule: BaseUserRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultUserRulePropertiesFormat>,
}
impl DefaultUserRule {
    pub fn new(base_user_rule: BaseUserRule) -> Self {
        Self {
            base_user_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DefaultUserRulePropertiesFormat {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<RuleProtocol>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<SecurityConfigurationRuleDirection>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl DefaultUserRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EffectiveBaseSecurityAdminRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "configurationDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub configuration_display_name: Option<String>,
    #[serde(rename = "configurationDescription", default, skip_serializing_if = "Option::is_none")]
    pub configuration_description: Option<String>,
    #[serde(rename = "ruleCollectionDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_display_name: Option<String>,
    #[serde(rename = "ruleCollectionDescription", default, skip_serializing_if = "Option::is_none")]
    pub rule_collection_description: Option<String>,
    #[serde(rename = "ruleCollectionAppliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[serde(rename = "ruleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_groups: Vec<ConfigurationGroup>,
    pub kind: effective_base_security_admin_rule::Kind,
}
impl EffectiveBaseSecurityAdminRule {
    pub fn new(kind: effective_base_security_admin_rule::Kind) -> Self {
        Self {
            id: None,
            configuration_display_name: None,
            configuration_description: None,
            rule_collection_display_name: None,
            rule_collection_description: None,
            rule_collection_applies_to_groups: Vec::new(),
            rule_groups: Vec::new(),
            kind,
        }
    }
}
pub mod effective_base_security_admin_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Custom,
        Default,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveConnectivityConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectivityConfigurationProperties>,
    #[serde(rename = "configurationGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub configuration_groups: Vec<ConfigurationGroup>,
}
impl EffectiveConnectivityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EffectiveDefaultSecurityAdminRule {
    #[serde(flatten)]
    pub effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DefaultAdminPropertiesFormat>,
}
impl EffectiveDefaultSecurityAdminRule {
    pub fn new(effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule) -> Self {
        Self {
            effective_base_security_admin_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EffectiveSecurityAdminRule {
    #[serde(flatten)]
    pub effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AdminPropertiesFormat>,
}
impl EffectiveSecurityAdminRule {
    pub fn new(effective_base_security_admin_rule: EffectiveBaseSecurityAdminRule) -> Self {
        Self {
            effective_base_security_admin_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveVirtualNetwork {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "membershipType", default, skip_serializing_if = "Option::is_none")]
    pub membership_type: Option<effective_virtual_network::MembershipType>,
}
impl EffectiveVirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_virtual_network {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MembershipType {
        Static,
        Dynamic,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveVirtualNetworksListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveVirtualNetwork>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl EffectiveVirtualNetworksListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveVirtualNetworksParameter {
    #[serde(rename = "conditionalMembers", default, skip_serializing_if = "Option::is_none")]
    pub conditional_members: Option<String>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl EffectiveVirtualNetworksParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Hub {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
}
impl Hub {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkGroup {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkGroupProperties>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl NetworkGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkGroupProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "memberType", default, skip_serializing_if = "Option::is_none")]
    pub member_type: Option<String>,
    #[serde(rename = "groupMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub group_members: Vec<GroupMembersItem>,
    #[serde(rename = "conditionalMembership", default, skip_serializing_if = "Option::is_none")]
    pub conditional_membership: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManager {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkManagerProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl NetworkManager {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerCommit {
    #[serde(rename = "commitId", default, skip_serializing_if = "Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(rename = "targetLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub target_locations: Vec<String>,
    #[serde(rename = "configurationIds", default, skip_serializing_if = "Vec::is_empty")]
    pub configuration_ids: Vec<String>,
    #[serde(rename = "commitType", default, skip_serializing_if = "Option::is_none")]
    pub commit_type: Option<ConfigurationType>,
}
impl NetworkManagerCommit {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerDeploymentStatus {
    #[serde(rename = "commitTime", default, skip_serializing_if = "Option::is_none")]
    pub commit_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "deploymentStatus", default, skip_serializing_if = "Option::is_none")]
    pub deployment_status: Option<network_manager_deployment_status::DeploymentStatus>,
    #[serde(rename = "configurationIds", default, skip_serializing_if = "Vec::is_empty")]
    pub configuration_ids: Vec<String>,
    #[serde(rename = "deploymentType", default, skip_serializing_if = "Option::is_none")]
    pub deployment_type: Option<ConfigurationType>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}
impl NetworkManagerDeploymentStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_manager_deployment_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeploymentStatus {
        NotStarted,
        Deploying,
        Deployed,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerDeploymentStatusListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkManagerDeploymentStatus>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerDeploymentStatusListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerDeploymentStatusParameter {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub regions: Vec<String>,
    #[serde(rename = "deploymentTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub deployment_types: Vec<ConfigurationType>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerDeploymentStatusParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerEffectiveConnectivityConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveConnectivityConfiguration>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerEffectiveConnectivityConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerEffectiveSecurityAdminRulesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveBaseSecurityAdminRule>,
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl NetworkManagerEffectiveSecurityAdminRulesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkManager>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkManagerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "networkManagerScopes", default, skip_serializing_if = "Option::is_none")]
    pub network_manager_scopes: Option<network_manager_properties::NetworkManagerScopes>,
    #[serde(rename = "networkManagerScopeAccesses", default, skip_serializing_if = "Vec::is_empty")]
    pub network_manager_scope_accesses: Vec<ConfigurationType>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkManagerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod network_manager_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct NetworkManagerScopes {
        #[serde(rename = "managementGroups", default, skip_serializing_if = "Vec::is_empty")]
        pub management_groups: Vec<String>,
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub subscriptions: Vec<String>,
    }
    impl NetworkManagerScopes {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkManagerSecurityGroupItem {
    #[serde(rename = "networkGroupId", default, skip_serializing_if = "Option::is_none")]
    pub network_group_id: Option<String>,
}
impl NetworkManagerSecurityGroupItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityPerimeter {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkSecurityPerimeterProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl NetworkSecurityPerimeter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityPerimeterListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkSecurityPerimeter>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkSecurityPerimeterListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityPerimeterProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkSecurityPerimeterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerimeterAssociableResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PerimeterAssociableResourceProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl PerimeterAssociableResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerimeterAssociableResourceProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(rename = "publicDnsZones", default, skip_serializing_if = "Vec::is_empty")]
    pub public_dns_zones: Vec<String>,
}
impl PerimeterAssociableResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PerimeterAssociableResourcesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PerimeterAssociableResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PerimeterAssociableResourcesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProvisioningState {
    Succeeded,
    Updating,
    Deleting,
    Failed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryRequestOptions {
    #[serde(rename = "skipToken", default, skip_serializing_if = "Option::is_none")]
    pub skip_token: Option<String>,
}
impl QueryRequestOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleCollection {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RuleCollectionPropertiesFormat>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl RuleCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleCollectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RuleCollection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RuleCollectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RuleCollectionPropertiesFormat {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "appliesToGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub applies_to_groups: Vec<NetworkManagerSecurityGroupItem>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RuleCollectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RuleProtocol {
    Tcp,
    Udp,
    Icmp,
    Esp,
    Any,
    Ah,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConfiguration {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityConfigurationPropertiesFormat>,
    #[serde(rename = "systemData", default, skip_serializing_if = "Option::is_none")]
    pub system_data: Option<SystemData>,
}
impl SecurityConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityConfigurationPropertiesFormat {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "securityType", default, skip_serializing_if = "Option::is_none")]
    pub security_type: Option<security_configuration_properties_format::SecurityType>,
    #[serde(rename = "deleteExistingNSGs", default, skip_serializing_if = "Option::is_none")]
    pub delete_existing_ns_gs: Option<security_configuration_properties_format::DeleteExistingNsGs>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl SecurityConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod security_configuration_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SecurityType {
        AdminPolicy,
        UserPolicy,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeleteExistingNsGs {
        False,
        True,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityConfigurationRuleAccess {
    Allow,
    Deny,
    AlwaysAllow,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityConfigurationRuleDirection {
    Inbound,
    Outbound,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemData {
    #[serde(rename = "createdBy", default, skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    #[serde(rename = "createdByType", default, skip_serializing_if = "Option::is_none")]
    pub created_by_type: Option<system_data::CreatedByType>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "lastModifiedByType", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by_type: Option<system_data::LastModifiedByType>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreatedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LastModifiedByType {
        User,
        Application,
        ManagedIdentity,
        Key,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsObject {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TagsObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserRule {
    #[serde(flatten)]
    pub base_user_rule: BaseUserRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<UserRulePropertiesFormat>,
}
impl UserRule {
    pub fn new(base_user_rule: BaseUserRule) -> Self {
        Self {
            base_user_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BaseUserRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UserRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserRulePropertiesFormat {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    pub protocol: RuleProtocol,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<AddressPrefixItem>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<AddressPrefixItem>,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    pub direction: SecurityConfigurationRuleDirection,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl UserRulePropertiesFormat {
    pub fn new(protocol: RuleProtocol, direction: SecurityConfigurationRuleDirection) -> Self {
        Self {
            display_name: None,
            description: None,
            protocol,
            sources: Vec::new(),
            destinations: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            direction,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityGroupItem {
    #[serde(rename = "networkGroupId", default, skip_serializing_if = "Option::is_none")]
    pub network_group_id: Option<String>,
    #[serde(rename = "useHubGateway", default, skip_serializing_if = "Option::is_none")]
    pub use_hub_gateway: Option<connectivity_group_item::UseHubGateway>,
    #[serde(rename = "isGlobal", default, skip_serializing_if = "Option::is_none")]
    pub is_global: Option<connectivity_group_item::IsGlobal>,
    #[serde(rename = "groupConnectivity", default, skip_serializing_if = "Option::is_none")]
    pub group_connectivity: Option<connectivity_group_item::GroupConnectivity>,
}
impl ConnectivityGroupItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_group_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum UseHubGateway {
        False,
        True,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum IsGlobal {
        False,
        True,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GroupConnectivity {
        None,
        DirectlyConnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GroupMembersItem {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl GroupMembersItem {
    pub fn new() -> Self {
        Self::default()
    }
}
