#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AadAuthenticationParameters {
    #[serde(rename = "aadTenant", default, skip_serializing_if = "Option::is_none")]
    pub aad_tenant: Option<String>,
    #[serde(rename = "aadAudience", default, skip_serializing_if = "Option::is_none")]
    pub aad_audience: Option<String>,
    #[serde(rename = "aadIssuer", default, skip_serializing_if = "Option::is_none")]
    pub aad_issuer: Option<String>,
}
impl AadAuthenticationParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Access {
    Allow,
    Deny,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddressSpace {
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
}
impl AddressSpace {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
}
impl ApplicationGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAuthenticationCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayAuthenticationCertificatePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayAuthenticationCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAuthenticationCertificatePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayAuthenticationCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayAutoscaleConfiguration {
    #[serde(rename = "minCapacity")]
    pub min_capacity: i32,
    #[serde(rename = "maxCapacity", default, skip_serializing_if = "Option::is_none")]
    pub max_capacity: Option<i32>,
}
impl ApplicationGatewayAutoscaleConfiguration {
    pub fn new(min_capacity: i32) -> Self {
        Self {
            min_capacity,
            max_capacity: None,
        }
    }
}
pub type ApplicationGatewayAvailableRequestHeadersResult = Vec<String>;
pub type ApplicationGatewayAvailableResponseHeadersResult = Vec<String>;
pub type ApplicationGatewayAvailableServerVariablesResult = Vec<String>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableSslOptions {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayAvailableSslOptionsPropertiesFormat>,
}
impl ApplicationGatewayAvailableSslOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableSslOptionsPropertiesFormat {
    #[serde(rename = "predefinedPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub predefined_policies: Vec<SubResource>,
    #[serde(rename = "defaultPolicy", default, skip_serializing_if = "Option::is_none")]
    pub default_policy: Option<PolicyNameEnum>,
    #[serde(rename = "availableCipherSuites", default, skip_serializing_if = "Vec::is_empty")]
    pub available_cipher_suites: Vec<CipherSuitesEnum>,
    #[serde(rename = "availableProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub available_protocols: Vec<ProtocolsEnum>,
}
impl ApplicationGatewayAvailableSslOptionsPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableSslPredefinedPolicies {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewaySslPredefinedPolicy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayAvailableSslPredefinedPolicies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayAvailableWafRuleSetsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewayFirewallRuleSet>,
}
impl ApplicationGatewayAvailableWafRuleSetsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddress {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
}
impl ApplicationGatewayBackendAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayBackendAddressPoolPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayBackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendAddressPoolPropertiesFormat {
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[serde(rename = "backendAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_addresses: Vec<ApplicationGatewayBackendAddress>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayBackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealth {
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<ApplicationGatewayBackendHealthPool>,
}
impl ApplicationGatewayBackendHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthHttpSettings {
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<ApplicationGatewayBackendHttpSettings>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub servers: Vec<ApplicationGatewayBackendHealthServer>,
}
impl ApplicationGatewayBackendHealthHttpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthOnDemand {
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<ApplicationGatewayBackendAddressPool>,
    #[serde(rename = "backendHealthHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_health_http_settings: Option<ApplicationGatewayBackendHealthHttpSettings>,
}
impl ApplicationGatewayBackendHealthOnDemand {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthPool {
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<ApplicationGatewayBackendAddressPool>,
    #[serde(rename = "backendHttpSettingsCollection", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_http_settings_collection: Vec<ApplicationGatewayBackendHealthHttpSettings>,
}
impl ApplicationGatewayBackendHealthPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHealthServer {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(rename = "ipConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub health: Option<application_gateway_backend_health_server::Health>,
    #[serde(rename = "healthProbeLog", default, skip_serializing_if = "Option::is_none")]
    pub health_probe_log: Option<String>,
}
impl ApplicationGatewayBackendHealthServer {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_backend_health_server {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Health {
        Unknown,
        Up,
        Down,
        Partial,
        Draining,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHttpSettings {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayBackendHttpSettingsPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayBackendHttpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayBackendHttpSettingsPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<ApplicationGatewayProtocol>,
    #[serde(rename = "cookieBasedAffinity", default, skip_serializing_if = "Option::is_none")]
    pub cookie_based_affinity: Option<application_gateway_backend_http_settings_properties_format::CookieBasedAffinity>,
    #[serde(rename = "requestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub request_timeout: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub probe: Option<SubResource>,
    #[serde(rename = "authenticationCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub authentication_certificates: Vec<SubResource>,
    #[serde(rename = "trustedRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_root_certificates: Vec<SubResource>,
    #[serde(rename = "connectionDraining", default, skip_serializing_if = "Option::is_none")]
    pub connection_draining: Option<ApplicationGatewayConnectionDraining>,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "pickHostNameFromBackendAddress", default, skip_serializing_if = "Option::is_none")]
    pub pick_host_name_from_backend_address: Option<bool>,
    #[serde(rename = "affinityCookieName", default, skip_serializing_if = "Option::is_none")]
    pub affinity_cookie_name: Option<String>,
    #[serde(rename = "probeEnabled", default, skip_serializing_if = "Option::is_none")]
    pub probe_enabled: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayBackendHttpSettingsPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_backend_http_settings_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CookieBasedAffinity {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayClientAuthConfiguration {
    #[serde(rename = "verifyClientCertIssuerDN", default, skip_serializing_if = "Option::is_none")]
    pub verify_client_cert_issuer_dn: Option<bool>,
}
impl ApplicationGatewayClientAuthConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayConnectionDraining {
    pub enabled: bool,
    #[serde(rename = "drainTimeoutInSec")]
    pub drain_timeout_in_sec: i32,
}
impl ApplicationGatewayConnectionDraining {
    pub fn new(enabled: bool, drain_timeout_in_sec: i32) -> Self {
        Self {
            enabled,
            drain_timeout_in_sec,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayCustomError {
    #[serde(rename = "statusCode", default, skip_serializing_if = "Option::is_none")]
    pub status_code: Option<application_gateway_custom_error::StatusCode>,
    #[serde(rename = "customErrorPageUrl", default, skip_serializing_if = "Option::is_none")]
    pub custom_error_page_url: Option<String>,
}
impl ApplicationGatewayCustomError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_custom_error {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StatusCode {
        HttpStatus403,
        HttpStatus502,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallDisabledRuleGroup {
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<i32>,
}
impl ApplicationGatewayFirewallDisabledRuleGroup {
    pub fn new(rule_group_name: String) -> Self {
        Self {
            rule_group_name,
            rules: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallExclusion {
    #[serde(rename = "matchVariable")]
    pub match_variable: String,
    #[serde(rename = "selectorMatchOperator")]
    pub selector_match_operator: String,
    pub selector: String,
}
impl ApplicationGatewayFirewallExclusion {
    pub fn new(match_variable: String, selector_match_operator: String, selector: String) -> Self {
        Self {
            match_variable,
            selector_match_operator,
            selector,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallRule {
    #[serde(rename = "ruleId")]
    pub rule_id: i32,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ApplicationGatewayFirewallRule {
    pub fn new(rule_id: i32) -> Self {
        Self {
            rule_id,
            description: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallRuleGroup {
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    pub rules: Vec<ApplicationGatewayFirewallRule>,
}
impl ApplicationGatewayFirewallRuleGroup {
    pub fn new(rule_group_name: String, rules: Vec<ApplicationGatewayFirewallRule>) -> Self {
        Self {
            rule_group_name,
            description: None,
            rules,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFirewallRuleSet {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFirewallRuleSetPropertiesFormat>,
}
impl ApplicationGatewayFirewallRuleSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayFirewallRuleSetPropertiesFormat {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[serde(rename = "ruleGroups")]
    pub rule_groups: Vec<ApplicationGatewayFirewallRuleGroup>,
}
impl ApplicationGatewayFirewallRuleSetPropertiesFormat {
    pub fn new(rule_set_type: String, rule_set_version: String, rule_groups: Vec<ApplicationGatewayFirewallRuleGroup>) -> Self {
        Self {
            provisioning_state: None,
            rule_set_type,
            rule_set_version,
            rule_groups,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFrontendIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayFrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendIpConfigurationPropertiesFormat {
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[serde(rename = "privateLinkConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub private_link_configuration: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayFrontendIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendPort {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayFrontendPortPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayFrontendPort {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayFrontendPortPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayFrontendPortPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHeaderConfiguration {
    #[serde(rename = "headerName", default, skip_serializing_if = "Option::is_none")]
    pub header_name: Option<String>,
    #[serde(rename = "headerValue", default, skip_serializing_if = "Option::is_none")]
    pub header_value: Option<String>,
}
impl ApplicationGatewayHeaderConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHttpListener {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayHttpListenerPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayHttpListener {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayHttpListenerPropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<ApplicationGatewayProtocol>,
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[serde(rename = "sslCertificate", default, skip_serializing_if = "Option::is_none")]
    pub ssl_certificate: Option<SubResource>,
    #[serde(rename = "sslProfile", default, skip_serializing_if = "Option::is_none")]
    pub ssl_profile: Option<SubResource>,
    #[serde(rename = "requireServerNameIndication", default, skip_serializing_if = "Option::is_none")]
    pub require_server_name_indication: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "customErrorConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_error_configurations: Vec<ApplicationGatewayCustomError>,
    #[serde(rename = "firewallPolicy", default, skip_serializing_if = "Option::is_none")]
    pub firewall_policy: Option<SubResource>,
    #[serde(rename = "hostNames", default, skip_serializing_if = "Vec::is_empty")]
    pub host_names: Vec<String>,
}
impl ApplicationGatewayHttpListenerPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayIpConfigurationPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGateway>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayOnDemandProbe {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<ApplicationGatewayProtocol>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[serde(rename = "pickHostNameFromBackendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub pick_host_name_from_backend_http_settings: Option<bool>,
    #[serde(rename = "match", default, skip_serializing_if = "Option::is_none")]
    pub match_: Option<ApplicationGatewayProbeHealthResponseMatch>,
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
}
impl ApplicationGatewayOnDemandProbe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPathRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPathRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPathRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPathRulePropertiesFormat {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub paths: Vec<String>,
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
    #[serde(rename = "redirectConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub redirect_configuration: Option<SubResource>,
    #[serde(rename = "rewriteRuleSet", default, skip_serializing_if = "Option::is_none")]
    pub rewrite_rule_set: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "firewallPolicy", default, skip_serializing_if = "Option::is_none")]
    pub firewall_policy: Option<SubResource>,
}
impl ApplicationGatewayPathRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateEndpointConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPrivateEndpointConnectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateEndpointConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewayPrivateEndpointConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayPrivateEndpointConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateEndpointConnectionProperties {
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "linkIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub link_identifier: Option<String>,
}
impl ApplicationGatewayPrivateEndpointConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPrivateLinkConfigurationProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPrivateLinkConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkConfigurationProperties {
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<ApplicationGatewayPrivateLinkIpConfiguration>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayPrivateLinkConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPrivateLinkIpConfigurationProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPrivateLinkIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkIpConfigurationProperties {
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayPrivateLinkIpConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayPrivateLinkResourceProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayPrivateLinkResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkResourceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationGatewayPrivateLinkResource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationGatewayPrivateLinkResourceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPrivateLinkResourceProperties {
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "requiredMembers", default, skip_serializing_if = "Vec::is_empty")]
    pub required_members: Vec<String>,
    #[serde(rename = "requiredZoneNames", default, skip_serializing_if = "Vec::is_empty")]
    pub required_zone_names: Vec<String>,
}
impl ApplicationGatewayPrivateLinkResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbe {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayProbePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayProbe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbeHealthResponseMatch {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    #[serde(rename = "statusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub status_codes: Vec<String>,
}
impl ApplicationGatewayProbeHealthResponseMatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayProbePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<ApplicationGatewayProtocol>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<i32>,
    #[serde(rename = "unhealthyThreshold", default, skip_serializing_if = "Option::is_none")]
    pub unhealthy_threshold: Option<i32>,
    #[serde(rename = "pickHostNameFromBackendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub pick_host_name_from_backend_http_settings: Option<bool>,
    #[serde(rename = "minServers", default, skip_serializing_if = "Option::is_none")]
    pub min_servers: Option<i32>,
    #[serde(rename = "match", default, skip_serializing_if = "Option::is_none")]
    pub match_: Option<ApplicationGatewayProbeHealthResponseMatch>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl ApplicationGatewayProbePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ApplicationGatewaySku>,
    #[serde(rename = "sslPolicy", default, skip_serializing_if = "Option::is_none")]
    pub ssl_policy: Option<ApplicationGatewaySslPolicy>,
    #[serde(rename = "operationalState", default, skip_serializing_if = "Option::is_none")]
    pub operational_state: Option<application_gateway_properties_format::OperationalState>,
    #[serde(rename = "gatewayIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub gateway_ip_configurations: Vec<ApplicationGatewayIpConfiguration>,
    #[serde(rename = "authenticationCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub authentication_certificates: Vec<ApplicationGatewayAuthenticationCertificate>,
    #[serde(rename = "trustedRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_root_certificates: Vec<ApplicationGatewayTrustedRootCertificate>,
    #[serde(rename = "trustedClientCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_client_certificates: Vec<ApplicationGatewayTrustedClientCertificate>,
    #[serde(rename = "sslCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub ssl_certificates: Vec<ApplicationGatewaySslCertificate>,
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<ApplicationGatewayFrontendIpConfiguration>,
    #[serde(rename = "frontendPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ports: Vec<ApplicationGatewayFrontendPort>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub probes: Vec<ApplicationGatewayProbe>,
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<ApplicationGatewayBackendAddressPool>,
    #[serde(rename = "backendHttpSettingsCollection", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_http_settings_collection: Vec<ApplicationGatewayBackendHttpSettings>,
    #[serde(rename = "httpListeners", default, skip_serializing_if = "Vec::is_empty")]
    pub http_listeners: Vec<ApplicationGatewayHttpListener>,
    #[serde(rename = "sslProfiles", default, skip_serializing_if = "Vec::is_empty")]
    pub ssl_profiles: Vec<ApplicationGatewaySslProfile>,
    #[serde(rename = "urlPathMaps", default, skip_serializing_if = "Vec::is_empty")]
    pub url_path_maps: Vec<ApplicationGatewayUrlPathMap>,
    #[serde(rename = "requestRoutingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub request_routing_rules: Vec<ApplicationGatewayRequestRoutingRule>,
    #[serde(rename = "rewriteRuleSets", default, skip_serializing_if = "Vec::is_empty")]
    pub rewrite_rule_sets: Vec<ApplicationGatewayRewriteRuleSet>,
    #[serde(rename = "redirectConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub redirect_configurations: Vec<ApplicationGatewayRedirectConfiguration>,
    #[serde(rename = "webApplicationFirewallConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub web_application_firewall_configuration: Option<ApplicationGatewayWebApplicationFirewallConfiguration>,
    #[serde(rename = "firewallPolicy", default, skip_serializing_if = "Option::is_none")]
    pub firewall_policy: Option<SubResource>,
    #[serde(rename = "enableHttp2", default, skip_serializing_if = "Option::is_none")]
    pub enable_http2: Option<bool>,
    #[serde(rename = "enableFips", default, skip_serializing_if = "Option::is_none")]
    pub enable_fips: Option<bool>,
    #[serde(rename = "autoscaleConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub autoscale_configuration: Option<ApplicationGatewayAutoscaleConfiguration>,
    #[serde(rename = "privateLinkConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub private_link_configurations: Vec<ApplicationGatewayPrivateLinkConfiguration>,
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<ApplicationGatewayPrivateEndpointConnection>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "customErrorConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_error_configurations: Vec<ApplicationGatewayCustomError>,
    #[serde(rename = "forceFirewallPolicyAssociation", default, skip_serializing_if = "Option::is_none")]
    pub force_firewall_policy_association: Option<bool>,
}
impl ApplicationGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OperationalState {
        Stopped,
        Starting,
        Running,
        Stopping,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ApplicationGatewayProtocol {
    Http,
    Https,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRedirectConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayRedirectConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayRedirectConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRedirectConfigurationPropertiesFormat {
    #[serde(rename = "redirectType", default, skip_serializing_if = "Option::is_none")]
    pub redirect_type: Option<RedirectTypeEnum>,
    #[serde(rename = "targetListener", default, skip_serializing_if = "Option::is_none")]
    pub target_listener: Option<SubResource>,
    #[serde(rename = "targetUrl", default, skip_serializing_if = "Option::is_none")]
    pub target_url: Option<String>,
    #[serde(rename = "includePath", default, skip_serializing_if = "Option::is_none")]
    pub include_path: Option<bool>,
    #[serde(rename = "includeQueryString", default, skip_serializing_if = "Option::is_none")]
    pub include_query_string: Option<bool>,
    #[serde(rename = "requestRoutingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub request_routing_rules: Vec<SubResource>,
    #[serde(rename = "urlPathMaps", default, skip_serializing_if = "Vec::is_empty")]
    pub url_path_maps: Vec<SubResource>,
    #[serde(rename = "pathRules", default, skip_serializing_if = "Vec::is_empty")]
    pub path_rules: Vec<SubResource>,
}
impl ApplicationGatewayRedirectConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRequestRoutingRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayRequestRoutingRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayRequestRoutingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRequestRoutingRulePropertiesFormat {
    #[serde(rename = "ruleType", default, skip_serializing_if = "Option::is_none")]
    pub rule_type: Option<application_gateway_request_routing_rule_properties_format::RuleType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[serde(rename = "backendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub backend_http_settings: Option<SubResource>,
    #[serde(rename = "httpListener", default, skip_serializing_if = "Option::is_none")]
    pub http_listener: Option<SubResource>,
    #[serde(rename = "urlPathMap", default, skip_serializing_if = "Option::is_none")]
    pub url_path_map: Option<SubResource>,
    #[serde(rename = "rewriteRuleSet", default, skip_serializing_if = "Option::is_none")]
    pub rewrite_rule_set: Option<SubResource>,
    #[serde(rename = "redirectConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub redirect_configuration: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayRequestRoutingRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_request_routing_rule_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleType {
        Basic,
        PathBasedRouting,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "ruleSequence", default, skip_serializing_if = "Option::is_none")]
    pub rule_sequence: Option<i64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub conditions: Vec<ApplicationGatewayRewriteRuleCondition>,
    #[serde(rename = "actionSet", default, skip_serializing_if = "Option::is_none")]
    pub action_set: Option<ApplicationGatewayRewriteRuleActionSet>,
}
impl ApplicationGatewayRewriteRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRuleActionSet {
    #[serde(rename = "requestHeaderConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub request_header_configurations: Vec<ApplicationGatewayHeaderConfiguration>,
    #[serde(rename = "responseHeaderConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub response_header_configurations: Vec<ApplicationGatewayHeaderConfiguration>,
    #[serde(rename = "urlConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub url_configuration: Option<ApplicationGatewayUrlConfiguration>,
}
impl ApplicationGatewayRewriteRuleActionSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRuleCondition {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub variable: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pattern: Option<String>,
    #[serde(rename = "ignoreCase", default, skip_serializing_if = "Option::is_none")]
    pub ignore_case: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub negate: Option<bool>,
}
impl ApplicationGatewayRewriteRuleCondition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRuleSet {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayRewriteRuleSetPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationGatewayRewriteRuleSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayRewriteRuleSetPropertiesFormat {
    #[serde(rename = "rewriteRules", default, skip_serializing_if = "Vec::is_empty")]
    pub rewrite_rules: Vec<ApplicationGatewayRewriteRule>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayRewriteRuleSetPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<application_gateway_sku::Name>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<application_gateway_sku::Tier>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl ApplicationGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "Standard_Small")]
        StandardSmall,
        #[serde(rename = "Standard_Medium")]
        StandardMedium,
        #[serde(rename = "Standard_Large")]
        StandardLarge,
        #[serde(rename = "WAF_Medium")]
        WafMedium,
        #[serde(rename = "WAF_Large")]
        WafLarge,
        #[serde(rename = "Standard_v2")]
        StandardV2,
        #[serde(rename = "WAF_v2")]
        WafV2,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        #[serde(rename = "WAF")]
        Waf,
        #[serde(rename = "Standard_v2")]
        StandardV2,
        #[serde(rename = "WAF_v2")]
        WafV2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewaySslCertificatePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewaySslCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslCertificatePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "publicCertData", default, skip_serializing_if = "Option::is_none")]
    pub public_cert_data: Option<String>,
    #[serde(rename = "keyVaultSecretId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_secret_id: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewaySslCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPolicy {
    #[serde(rename = "disabledSslProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub disabled_ssl_protocols: Vec<ProtocolsEnum>,
    #[serde(rename = "policyType", default, skip_serializing_if = "Option::is_none")]
    pub policy_type: Option<application_gateway_ssl_policy::PolicyType>,
    #[serde(rename = "policyName", default, skip_serializing_if = "Option::is_none")]
    pub policy_name: Option<PolicyNameEnum>,
    #[serde(rename = "cipherSuites", default, skip_serializing_if = "Vec::is_empty")]
    pub cipher_suites: Vec<CipherSuitesEnum>,
    #[serde(rename = "minProtocolVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_protocol_version: Option<ProtocolsEnum>,
}
impl ApplicationGatewaySslPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod application_gateway_ssl_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PolicyType {
        Predefined,
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPredefinedPolicy {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewaySslPredefinedPolicyPropertiesFormat>,
}
impl ApplicationGatewaySslPredefinedPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslPredefinedPolicyPropertiesFormat {
    #[serde(rename = "cipherSuites", default, skip_serializing_if = "Vec::is_empty")]
    pub cipher_suites: Vec<CipherSuitesEnum>,
    #[serde(rename = "minProtocolVersion", default, skip_serializing_if = "Option::is_none")]
    pub min_protocol_version: Option<ProtocolsEnum>,
}
impl ApplicationGatewaySslPredefinedPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslProfile {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewaySslProfilePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewaySslProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewaySslProfilePropertiesFormat {
    #[serde(rename = "trustedClientCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub trusted_client_certificates: Vec<SubResource>,
    #[serde(rename = "sslPolicy", default, skip_serializing_if = "Option::is_none")]
    pub ssl_policy: Option<ApplicationGatewaySslPolicy>,
    #[serde(rename = "clientAuthConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub client_auth_configuration: Option<ApplicationGatewayClientAuthConfiguration>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewaySslProfilePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayTrustedClientCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayTrustedClientCertificatePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayTrustedClientCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayTrustedClientCertificatePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayTrustedClientCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayTrustedRootCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayTrustedRootCertificatePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayTrustedRootCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayTrustedRootCertificatePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
    #[serde(rename = "keyVaultSecretId", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_secret_id: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayTrustedRootCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlConfiguration {
    #[serde(rename = "modifiedPath", default, skip_serializing_if = "Option::is_none")]
    pub modified_path: Option<String>,
    #[serde(rename = "modifiedQueryString", default, skip_serializing_if = "Option::is_none")]
    pub modified_query_string: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reroute: Option<bool>,
}
impl ApplicationGatewayUrlConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlPathMap {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationGatewayUrlPathMapPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ApplicationGatewayUrlPathMap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationGatewayUrlPathMapPropertiesFormat {
    #[serde(rename = "defaultBackendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub default_backend_address_pool: Option<SubResource>,
    #[serde(rename = "defaultBackendHttpSettings", default, skip_serializing_if = "Option::is_none")]
    pub default_backend_http_settings: Option<SubResource>,
    #[serde(rename = "defaultRewriteRuleSet", default, skip_serializing_if = "Option::is_none")]
    pub default_rewrite_rule_set: Option<SubResource>,
    #[serde(rename = "defaultRedirectConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub default_redirect_configuration: Option<SubResource>,
    #[serde(rename = "pathRules", default, skip_serializing_if = "Vec::is_empty")]
    pub path_rules: Vec<ApplicationGatewayPathRule>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationGatewayUrlPathMapPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGatewayWebApplicationFirewallConfiguration {
    pub enabled: bool,
    #[serde(rename = "firewallMode")]
    pub firewall_mode: application_gateway_web_application_firewall_configuration::FirewallMode,
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[serde(rename = "disabledRuleGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub disabled_rule_groups: Vec<ApplicationGatewayFirewallDisabledRuleGroup>,
    #[serde(rename = "requestBodyCheck", default, skip_serializing_if = "Option::is_none")]
    pub request_body_check: Option<bool>,
    #[serde(rename = "maxRequestBodySize", default, skip_serializing_if = "Option::is_none")]
    pub max_request_body_size: Option<i32>,
    #[serde(rename = "maxRequestBodySizeInKb", default, skip_serializing_if = "Option::is_none")]
    pub max_request_body_size_in_kb: Option<i32>,
    #[serde(rename = "fileUploadLimitInMb", default, skip_serializing_if = "Option::is_none")]
    pub file_upload_limit_in_mb: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub exclusions: Vec<ApplicationGatewayFirewallExclusion>,
}
impl ApplicationGatewayWebApplicationFirewallConfiguration {
    pub fn new(
        enabled: bool,
        firewall_mode: application_gateway_web_application_firewall_configuration::FirewallMode,
        rule_set_type: String,
        rule_set_version: String,
    ) -> Self {
        Self {
            enabled,
            firewall_mode,
            rule_set_type,
            rule_set_version,
            disabled_rule_groups: Vec::new(),
            request_body_check: None,
            max_request_body_size: None,
            max_request_body_size_in_kb: None,
            file_upload_limit_in_mb: None,
            exclusions: Vec::new(),
        }
    }
}
pub mod application_gateway_web_application_firewall_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FirewallMode {
        Detection,
        Prevention,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationRule {
    #[serde(flatten)]
    pub firewall_policy_rule: FirewallPolicyRule,
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<FirewallPolicyRuleApplicationProtocol>,
    #[serde(rename = "targetFqdns", default, skip_serializing_if = "Vec::is_empty")]
    pub target_fqdns: Vec<String>,
    #[serde(rename = "fqdnTags", default, skip_serializing_if = "Vec::is_empty")]
    pub fqdn_tags: Vec<String>,
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
}
impl ApplicationRule {
    pub fn new(firewall_policy_rule: FirewallPolicyRule) -> Self {
        Self {
            firewall_policy_rule,
            source_addresses: Vec::new(),
            destination_addresses: Vec::new(),
            protocols: Vec::new(),
            target_fqdns: Vec::new(),
            fqdn_tags: Vec::new(),
            source_ip_groups: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ApplicationSecurityGroupPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ApplicationSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationSecurityGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ApplicationSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationSecurityGroupPropertiesFormat {
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ApplicationSecurityGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AuthenticationMethod {
    #[serde(rename = "EAPTLS")]
    Eaptls,
    #[serde(rename = "EAPMSCHAPv2")]
    EapmschaPv2,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitAuthorization>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AuthorizationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizationPropertiesFormat {
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[serde(rename = "authorizationUseStatus", default, skip_serializing_if = "Option::is_none")]
    pub authorization_use_status: Option<authorization_properties_format::AuthorizationUseStatus>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AuthorizationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod authorization_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthorizationUseStatus {
        Available,
        InUse,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoApprovedPrivateLinkService {
    #[serde(rename = "privateLinkService", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service: Option<String>,
}
impl AutoApprovedPrivateLinkService {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoApprovedPrivateLinkServicesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AutoApprovedPrivateLinkService>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AutoApprovedPrivateLinkServicesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Availability {
    #[serde(rename = "timeGrain", default, skip_serializing_if = "Option::is_none")]
    pub time_grain: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retention: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl Availability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableDelegation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub actions: Vec<String>,
}
impl AvailableDelegation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableDelegationsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AvailableDelegation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailableDelegationsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailablePrivateEndpointType {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
    pub resource_name: Option<String>,
}
impl AvailablePrivateEndpointType {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailablePrivateEndpointTypesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AvailablePrivateEndpointType>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailablePrivateEndpointTypesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvailableProvidersList {
    pub countries: Vec<AvailableProvidersListCountry>,
}
impl AvailableProvidersList {
    pub fn new(countries: Vec<AvailableProvidersListCountry>) -> Self {
        Self { countries }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListCity {
    #[serde(rename = "cityName", default, skip_serializing_if = "Option::is_none")]
    pub city_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
}
impl AvailableProvidersListCity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListCountry {
    #[serde(rename = "countryName", default, skip_serializing_if = "Option::is_none")]
    pub country_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub states: Vec<AvailableProvidersListState>,
}
impl AvailableProvidersListCountry {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListParameters {
    #[serde(rename = "azureLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_locations: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
}
impl AvailableProvidersListParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableProvidersListState {
    #[serde(rename = "stateName", default, skip_serializing_if = "Option::is_none")]
    pub state_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub cities: Vec<AvailableProvidersListCity>,
}
impl AvailableProvidersListState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableServiceAlias {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
    pub resource_name: Option<String>,
}
impl AvailableServiceAlias {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailableServiceAliasesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AvailableServiceAlias>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AvailableServiceAliasesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureAsyncOperationResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<azure_async_operation_result::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Error>,
}
impl AzureAsyncOperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_async_operation_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        InProgress,
        Succeeded,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewall {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewall {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallAdditionalProperties {}
impl AzureFirewallAdditionalProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallApplicationRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<AzureFirewallApplicationRuleProtocol>,
    #[serde(rename = "targetFqdns", default, skip_serializing_if = "Vec::is_empty")]
    pub target_fqdns: Vec<String>,
    #[serde(rename = "fqdnTags", default, skip_serializing_if = "Vec::is_empty")]
    pub fqdn_tags: Vec<String>,
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
}
impl AzureFirewallApplicationRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallApplicationRuleCollection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallApplicationRuleCollectionPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewallApplicationRuleCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallApplicationRuleCollectionPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<AzureFirewallRcAction>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<AzureFirewallApplicationRule>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AzureFirewallApplicationRuleCollectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallApplicationRuleProtocol {
    #[serde(rename = "protocolType", default, skip_serializing_if = "Option::is_none")]
    pub protocol_type: Option<AzureFirewallApplicationRuleProtocolType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl AzureFirewallApplicationRuleProtocol {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallApplicationRuleProtocolType {
    Http,
    Https,
    Mssql,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallFqdnTag {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallFqdnTagPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewallFqdnTag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallFqdnTagListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AzureFirewallFqdnTag>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AzureFirewallFqdnTagListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallFqdnTagPropertiesFormat {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "fqdnTagName", default, skip_serializing_if = "Option::is_none")]
    pub fqdn_tag_name: Option<String>,
}
impl AzureFirewallFqdnTagPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl AzureFirewallIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallIpConfigurationPropertiesFormat {
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AzureFirewallIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallIpGroups {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "changeNumber", default, skip_serializing_if = "Option::is_none")]
    pub change_number: Option<String>,
}
impl AzureFirewallIpGroups {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AzureFirewall>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl AzureFirewallListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNatRcAction {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<AzureFirewallNatRcActionType>,
}
impl AzureFirewallNatRcAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallNatRcActionType {
    Snat,
    Dnat,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNatRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<AzureFirewallNetworkRuleProtocol>,
    #[serde(rename = "translatedAddress", default, skip_serializing_if = "Option::is_none")]
    pub translated_address: Option<String>,
    #[serde(rename = "translatedPort", default, skip_serializing_if = "Option::is_none")]
    pub translated_port: Option<String>,
    #[serde(rename = "translatedFqdn", default, skip_serializing_if = "Option::is_none")]
    pub translated_fqdn: Option<String>,
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
}
impl AzureFirewallNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNatRuleCollection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallNatRuleCollectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewallNatRuleCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNatRuleCollectionProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<AzureFirewallNatRcAction>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<AzureFirewallNatRule>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AzureFirewallNatRuleCollectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNetworkRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub protocols: Vec<AzureFirewallNetworkRuleProtocol>,
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<String>,
    #[serde(rename = "destinationFqdns", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_fqdns: Vec<String>,
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
    #[serde(rename = "destinationIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ip_groups: Vec<String>,
}
impl AzureFirewallNetworkRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNetworkRuleCollection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AzureFirewallNetworkRuleCollectionPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureFirewallNetworkRuleCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallNetworkRuleCollectionPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<AzureFirewallRcAction>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<AzureFirewallNetworkRule>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl AzureFirewallNetworkRuleCollectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallNetworkRuleProtocol {
    #[serde(rename = "TCP")]
    Tcp,
    #[serde(rename = "UDP")]
    Udp,
    Any,
    #[serde(rename = "ICMP")]
    Icmp,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallPropertiesFormat {
    #[serde(rename = "applicationRuleCollections", default, skip_serializing_if = "Vec::is_empty")]
    pub application_rule_collections: Vec<AzureFirewallApplicationRuleCollection>,
    #[serde(rename = "natRuleCollections", default, skip_serializing_if = "Vec::is_empty")]
    pub nat_rule_collections: Vec<AzureFirewallNatRuleCollection>,
    #[serde(rename = "networkRuleCollections", default, skip_serializing_if = "Vec::is_empty")]
    pub network_rule_collections: Vec<AzureFirewallNetworkRuleCollection>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<AzureFirewallIpConfiguration>,
    #[serde(rename = "managementIpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub management_ip_configuration: Option<AzureFirewallIpConfiguration>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "threatIntelMode", default, skip_serializing_if = "Option::is_none")]
    pub threat_intel_mode: Option<AzureFirewallThreatIntelMode>,
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
    #[serde(rename = "firewallPolicy", default, skip_serializing_if = "Option::is_none")]
    pub firewall_policy: Option<SubResource>,
    #[serde(rename = "hubIPAddresses", default, skip_serializing_if = "Option::is_none")]
    pub hub_ip_addresses: Option<HubIpAddresses>,
    #[serde(rename = "ipGroups", default, skip_serializing_if = "Option::is_none")]
    pub ip_groups: Option<IpGroups>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<AzureFirewallSku>,
    #[serde(rename = "additionalProperties", default, skip_serializing_if = "Option::is_none")]
    pub additional_properties: Option<AzureFirewallAdditionalProperties>,
}
impl AzureFirewallPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallPublicIpAddress {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
}
impl AzureFirewallPublicIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallRcAction {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<AzureFirewallRcActionType>,
}
impl AzureFirewallRcAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallRcActionType {
    Allow,
    Deny,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFirewallSku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<azure_firewall_sku::Name>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<azure_firewall_sku::Tier>,
}
impl AzureFirewallSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod azure_firewall_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        #[serde(rename = "AZFW_VNet")]
        AzfwVNet,
        #[serde(rename = "AZFW_Hub")]
        AzfwHub,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        Premium,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFirewallThreatIntelMode {
    Alert,
    Deny,
    Off,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureReachabilityReport {
    #[serde(rename = "aggregationLevel")]
    pub aggregation_level: String,
    #[serde(rename = "providerLocation")]
    pub provider_location: AzureReachabilityReportLocation,
    #[serde(rename = "reachabilityReport")]
    pub reachability_report: Vec<AzureReachabilityReportItem>,
}
impl AzureReachabilityReport {
    pub fn new(
        aggregation_level: String,
        provider_location: AzureReachabilityReportLocation,
        reachability_report: Vec<AzureReachabilityReportItem>,
    ) -> Self {
        Self {
            aggregation_level,
            provider_location,
            reachability_report,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureReachabilityReportItem {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(rename = "azureLocation", default, skip_serializing_if = "Option::is_none")]
    pub azure_location: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub latencies: Vec<AzureReachabilityReportLatencyInfo>,
}
impl AzureReachabilityReportItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureReachabilityReportLatencyInfo {
    #[serde(rename = "timeStamp", default, skip_serializing_if = "Option::is_none")]
    pub time_stamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub score: Option<i64>,
}
impl AzureReachabilityReportLatencyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureReachabilityReportLocation {
    pub country: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
}
impl AzureReachabilityReportLocation {
    pub fn new(country: String) -> Self {
        Self {
            country,
            state: None,
            city: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureReachabilityReportParameters {
    #[serde(rename = "providerLocation")]
    pub provider_location: AzureReachabilityReportLocation,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<String>,
    #[serde(rename = "azureLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub azure_locations: Vec<String>,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime")]
    pub end_time: String,
}
impl AzureReachabilityReportParameters {
    pub fn new(provider_location: AzureReachabilityReportLocation, start_time: String, end_time: String) -> Self {
        Self {
            provider_location,
            providers: Vec::new(),
            azure_locations: Vec::new(),
            start_time,
            end_time,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpCommunity {
    #[serde(rename = "serviceSupportedRegion", default, skip_serializing_if = "Option::is_none")]
    pub service_supported_region: Option<String>,
    #[serde(rename = "communityName", default, skip_serializing_if = "Option::is_none")]
    pub community_name: Option<String>,
    #[serde(rename = "communityValue", default, skip_serializing_if = "Option::is_none")]
    pub community_value: Option<String>,
    #[serde(rename = "communityPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub community_prefixes: Vec<String>,
    #[serde(rename = "isAuthorizedToUse", default, skip_serializing_if = "Option::is_none")]
    pub is_authorized_to_use: Option<bool>,
    #[serde(rename = "serviceGroup", default, skip_serializing_if = "Option::is_none")]
    pub service_group: Option<String>,
}
impl BgpCommunity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BackendAddressPoolPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl BackendAddressPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BackendAddressPoolPropertiesFormat {
    #[serde(rename = "loadBalancerBackendAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_addresses: Vec<LoadBalancerBackendAddress>,
    #[serde(rename = "backendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[serde(rename = "outboundRule", default, skip_serializing_if = "Option::is_none")]
    pub outbound_rule: Option<SubResource>,
    #[serde(rename = "outboundRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_rules: Vec<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl BackendAddressPoolPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionActiveSession {
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<serde_json::Value>,
    #[serde(rename = "targetSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub target_subscription_id: Option<String>,
    #[serde(rename = "resourceType", default, skip_serializing_if = "Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(rename = "targetHostName", default, skip_serializing_if = "Option::is_none")]
    pub target_host_name: Option<String>,
    #[serde(rename = "targetResourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(rename = "targetIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub target_ip_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<bastion_active_session::Protocol>,
    #[serde(rename = "targetResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_id: Option<String>,
    #[serde(rename = "sessionDurationInMins", default, skip_serializing_if = "Option::is_none")]
    pub session_duration_in_mins: Option<f64>,
}
impl BastionActiveSession {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bastion_active_session {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "SSH")]
        Ssh,
        #[serde(rename = "RDP")]
        Rdp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionActiveSessionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BastionActiveSession>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BastionActiveSessionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionHost {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BastionHostPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl BastionHost {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionHostIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BastionHostIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl BastionHostIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BastionHostIpConfigurationPropertiesFormat {
    pub subnet: SubResource,
    #[serde(rename = "publicIPAddress")]
    pub public_ip_address: SubResource,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
}
impl BastionHostIpConfigurationPropertiesFormat {
    pub fn new(subnet: SubResource, public_ip_address: SubResource) -> Self {
        Self {
            subnet,
            public_ip_address,
            provisioning_state: None,
            private_ip_allocation_method: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionHostListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BastionHost>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BastionHostListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionHostPropertiesFormat {
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<BastionHostIpConfiguration>,
    #[serde(rename = "dnsName", default, skip_serializing_if = "Option::is_none")]
    pub dns_name: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl BastionHostPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionSessionDeleteResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BastionSessionState>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BastionSessionDeleteResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionSessionState {
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}
impl BastionSessionState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BastionShareableLink {
    pub vm: Vm,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub bsl: Option<String>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl BastionShareableLink {
    pub fn new(vm: Vm) -> Self {
        Self {
            vm,
            bsl: None,
            created_at: None,
            message: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionShareableLinkListRequest {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub vms: Vec<BastionShareableLink>,
}
impl BastionShareableLinkListRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BastionShareableLinkListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BastionShareableLink>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BastionShareableLinkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BgpConnectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl BgpConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpConnectionProperties {
    #[serde(rename = "peerAsn", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[serde(rename = "peerIp", default, skip_serializing_if = "Option::is_none")]
    pub peer_ip: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "connectionState", default, skip_serializing_if = "Option::is_none")]
    pub connection_state: Option<bgp_connection_properties::ConnectionState>,
}
impl BgpConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bgp_connection_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionState {
        Unknown,
        Connecting,
        Connected,
        NotConnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpPeerStatus {
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<bgp_peer_status::State>,
    #[serde(rename = "connectedDuration", default, skip_serializing_if = "Option::is_none")]
    pub connected_duration: Option<String>,
    #[serde(rename = "routesReceived", default, skip_serializing_if = "Option::is_none")]
    pub routes_received: Option<i64>,
    #[serde(rename = "messagesSent", default, skip_serializing_if = "Option::is_none")]
    pub messages_sent: Option<i64>,
    #[serde(rename = "messagesReceived", default, skip_serializing_if = "Option::is_none")]
    pub messages_received: Option<i64>,
}
impl BgpPeerStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod bgp_peer_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Unknown,
        Stopped,
        Idle,
        Connecting,
        Connected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpPeerStatusListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BgpPeerStatus>,
}
impl BgpPeerStatusListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpServiceCommunity {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BgpServiceCommunityPropertiesFormat>,
}
impl BgpServiceCommunity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpServiceCommunityListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BgpServiceCommunity>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl BgpServiceCommunityListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpServiceCommunityPropertiesFormat {
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[serde(rename = "bgpCommunities", default, skip_serializing_if = "Vec::is_empty")]
    pub bgp_communities: Vec<BgpCommunity>,
}
impl BgpServiceCommunityPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BgpSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i64>,
    #[serde(rename = "bgpPeeringAddress", default, skip_serializing_if = "Option::is_none")]
    pub bgp_peering_address: Option<String>,
    #[serde(rename = "peerWeight", default, skip_serializing_if = "Option::is_none")]
    pub peer_weight: Option<i32>,
    #[serde(rename = "bgpPeeringAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub bgp_peering_addresses: Vec<IpConfigurationBgpPeeringAddress>,
}
impl BgpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BreakOutCategoryPolicies {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub allow: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub optimize: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<bool>,
}
impl BreakOutCategoryPolicies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CheckPrivateLinkServiceVisibilityRequest {
    #[serde(rename = "privateLinkServiceAlias", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_alias: Option<String>,
}
impl CheckPrivateLinkServiceVisibilityRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CipherSuitesEnum {
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384")]
    TlsEcdheRsaWithAes256CbcSha384,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256")]
    TlsEcdheRsaWithAes128CbcSha256,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA")]
    TlsEcdheRsaWithAes256CbcSha,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA")]
    TlsEcdheRsaWithAes128CbcSha,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384")]
    TlsDheRsaWithAes256GcmSha384,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256")]
    TlsDheRsaWithAes128GcmSha256,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_256_CBC_SHA")]
    TlsDheRsaWithAes256CbcSha,
    #[serde(rename = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA")]
    TlsDheRsaWithAes128CbcSha,
    #[serde(rename = "TLS_RSA_WITH_AES_256_GCM_SHA384")]
    TlsRsaWithAes256GcmSha384,
    #[serde(rename = "TLS_RSA_WITH_AES_128_GCM_SHA256")]
    TlsRsaWithAes128GcmSha256,
    #[serde(rename = "TLS_RSA_WITH_AES_256_CBC_SHA256")]
    TlsRsaWithAes256CbcSha256,
    #[serde(rename = "TLS_RSA_WITH_AES_128_CBC_SHA256")]
    TlsRsaWithAes128CbcSha256,
    #[serde(rename = "TLS_RSA_WITH_AES_256_CBC_SHA")]
    TlsRsaWithAes256CbcSha,
    #[serde(rename = "TLS_RSA_WITH_AES_128_CBC_SHA")]
    TlsRsaWithAes128CbcSha,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384")]
    TlsEcdheEcdsaWithAes256GcmSha384,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256")]
    TlsEcdheEcdsaWithAes128GcmSha256,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384")]
    TlsEcdheEcdsaWithAes256CbcSha384,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256")]
    TlsEcdheEcdsaWithAes128CbcSha256,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA")]
    TlsEcdheEcdsaWithAes256CbcSha,
    #[serde(rename = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA")]
    TlsEcdheEcdsaWithAes128CbcSha,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256")]
    TlsDheDssWithAes256CbcSha256,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256")]
    TlsDheDssWithAes128CbcSha256,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA")]
    TlsDheDssWithAes256CbcSha,
    #[serde(rename = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA")]
    TlsDheDssWithAes128CbcSha,
    #[serde(rename = "TLS_RSA_WITH_3DES_EDE_CBC_SHA")]
    TlsRsaWith3desEdeCbcSha,
    #[serde(rename = "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA")]
    TlsDheDssWith3desEdeCbcSha,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256")]
    TlsEcdheRsaWithAes128GcmSha256,
    #[serde(rename = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384")]
    TlsEcdheRsaWithAes256GcmSha384,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CircuitConnectionStatus {
    Connected,
    Connecting,
    Disconnected,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl CloudError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudErrorBody>,
}
impl CloudErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitor {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    pub properties: ConnectionMonitorParameters,
}
impl ConnectionMonitor {
    pub fn new(properties: ConnectionMonitorParameters) -> Self {
        Self {
            location: None,
            tags: None,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorDestination {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
}
impl ConnectionMonitorDestination {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorEndpoint {
    pub name: String,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connection_monitor_endpoint::Type>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<ConnectionMonitorEndpointFilter>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<ConnectionMonitorEndpointScope>,
    #[serde(rename = "coverageLevel", default, skip_serializing_if = "Option::is_none")]
    pub coverage_level: Option<connection_monitor_endpoint::CoverageLevel>,
}
impl ConnectionMonitorEndpoint {
    pub fn new(name: String) -> Self {
        Self {
            name,
            type_: None,
            resource_id: None,
            address: None,
            filter: None,
            scope: None,
            coverage_level: None,
        }
    }
}
pub mod connection_monitor_endpoint {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "AzureVM")]
        AzureVm,
        AzureVNet,
        AzureSubnet,
        ExternalAddress,
        #[serde(rename = "MMAWorkspaceMachine")]
        MmaWorkspaceMachine,
        #[serde(rename = "MMAWorkspaceNetwork")]
        MmaWorkspaceNetwork,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CoverageLevel {
        Default,
        Low,
        BelowAverage,
        Average,
        AboveAverage,
        Full,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorEndpointFilter {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connection_monitor_endpoint_filter::Type>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub items: Vec<ConnectionMonitorEndpointFilterItem>,
}
impl ConnectionMonitorEndpointFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_endpoint_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Include,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorEndpointFilterItem {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connection_monitor_endpoint_filter_item::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
}
impl ConnectionMonitorEndpointFilterItem {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_endpoint_filter_item {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        AgentAddress,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorEndpointScope {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub include: Vec<ConnectionMonitorEndpointScopeItem>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub exclude: Vec<ConnectionMonitorEndpointScopeItem>,
}
impl ConnectionMonitorEndpointScope {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorEndpointScopeItem {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
}
impl ConnectionMonitorEndpointScopeItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorHttpConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<connection_monitor_http_configuration::Method>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "requestHeaders", default, skip_serializing_if = "Vec::is_empty")]
    pub request_headers: Vec<HttpHeader>,
    #[serde(rename = "validStatusCodeRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub valid_status_code_ranges: Vec<String>,
    #[serde(rename = "preferHTTPS", default, skip_serializing_if = "Option::is_none")]
    pub prefer_https: Option<bool>,
}
impl ConnectionMonitorHttpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_http_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Method {
        Get,
        Post,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorIcmpConfiguration {
    #[serde(rename = "disableTraceRoute", default, skip_serializing_if = "Option::is_none")]
    pub disable_trace_route: Option<bool>,
}
impl ConnectionMonitorIcmpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ConnectionMonitorResult>,
}
impl ConnectionMonitorListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorOutput {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connection_monitor_output::Type>,
    #[serde(rename = "workspaceSettings", default, skip_serializing_if = "Option::is_none")]
    pub workspace_settings: Option<ConnectionMonitorWorkspaceSettings>,
}
impl ConnectionMonitorOutput {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_output {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Workspace,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<ConnectionMonitorSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub destination: Option<ConnectionMonitorDestination>,
    #[serde(rename = "autoStart", default, skip_serializing_if = "Option::is_none")]
    pub auto_start: Option<bool>,
    #[serde(rename = "monitoringIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_interval_in_seconds: Option<i64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub endpoints: Vec<ConnectionMonitorEndpoint>,
    #[serde(rename = "testConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub test_configurations: Vec<ConnectionMonitorTestConfiguration>,
    #[serde(rename = "testGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub test_groups: Vec<ConnectionMonitorTestGroup>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub outputs: Vec<ConnectionMonitorOutput>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
}
impl ConnectionMonitorParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorQueryResult {
    #[serde(rename = "sourceStatus", default, skip_serializing_if = "Option::is_none")]
    pub source_status: Option<connection_monitor_query_result::SourceStatus>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub states: Vec<ConnectionStateSnapshot>,
}
impl ConnectionMonitorQueryResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_query_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SourceStatus {
        Unknown,
        Active,
        Inactive,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ConnectionMonitorResultProperties>,
}
impl ConnectionMonitorResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorResultProperties {
    #[serde(flatten)]
    pub connection_monitor_parameters: ConnectionMonitorParameters,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "monitoringStatus", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_status: Option<String>,
    #[serde(rename = "connectionMonitorType", default, skip_serializing_if = "Option::is_none")]
    pub connection_monitor_type: Option<connection_monitor_result_properties::ConnectionMonitorType>,
}
impl ConnectionMonitorResultProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_result_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionMonitorType {
        MultiEndpoint,
        SingleSourceDestination,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorSource {
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
}
impl ConnectionMonitorSource {
    pub fn new(resource_id: String) -> Self {
        Self { resource_id, port: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorSuccessThreshold {
    #[serde(rename = "checksFailedPercent", default, skip_serializing_if = "Option::is_none")]
    pub checks_failed_percent: Option<i64>,
    #[serde(rename = "roundTripTimeMs", default, skip_serializing_if = "Option::is_none")]
    pub round_trip_time_ms: Option<f64>,
}
impl ConnectionMonitorSuccessThreshold {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorTcpConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
    #[serde(rename = "disableTraceRoute", default, skip_serializing_if = "Option::is_none")]
    pub disable_trace_route: Option<bool>,
    #[serde(rename = "destinationPortBehavior", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_behavior: Option<connection_monitor_tcp_configuration::DestinationPortBehavior>,
}
impl ConnectionMonitorTcpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_monitor_tcp_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DestinationPortBehavior {
        None,
        ListenIfAvailable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorTestConfiguration {
    pub name: String,
    #[serde(rename = "testFrequencySec", default, skip_serializing_if = "Option::is_none")]
    pub test_frequency_sec: Option<i64>,
    pub protocol: connection_monitor_test_configuration::Protocol,
    #[serde(rename = "preferredIPVersion", default, skip_serializing_if = "Option::is_none")]
    pub preferred_ip_version: Option<connection_monitor_test_configuration::PreferredIpVersion>,
    #[serde(rename = "httpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub http_configuration: Option<ConnectionMonitorHttpConfiguration>,
    #[serde(rename = "tcpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub tcp_configuration: Option<ConnectionMonitorTcpConfiguration>,
    #[serde(rename = "icmpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub icmp_configuration: Option<ConnectionMonitorIcmpConfiguration>,
    #[serde(rename = "successThreshold", default, skip_serializing_if = "Option::is_none")]
    pub success_threshold: Option<ConnectionMonitorSuccessThreshold>,
}
impl ConnectionMonitorTestConfiguration {
    pub fn new(name: String, protocol: connection_monitor_test_configuration::Protocol) -> Self {
        Self {
            name,
            test_frequency_sec: None,
            protocol,
            preferred_ip_version: None,
            http_configuration: None,
            tcp_configuration: None,
            icmp_configuration: None,
            success_threshold: None,
        }
    }
}
pub mod connection_monitor_test_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Http,
        Icmp,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreferredIpVersion {
        IPv4,
        IPv6,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionMonitorTestGroup {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub disable: Option<bool>,
    #[serde(rename = "testConfigurations")]
    pub test_configurations: Vec<String>,
    pub sources: Vec<String>,
    pub destinations: Vec<String>,
}
impl ConnectionMonitorTestGroup {
    pub fn new(name: String, test_configurations: Vec<String>, sources: Vec<String>, destinations: Vec<String>) -> Self {
        Self {
            name,
            disable: None,
            test_configurations,
            sources,
            destinations,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionMonitorWorkspaceSettings {
    #[serde(rename = "workspaceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_resource_id: Option<String>,
}
impl ConnectionMonitorWorkspaceSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConnectionProtocol {
    #[serde(rename = "IKEv2")]
    IkEv2,
    #[serde(rename = "IKEv1")]
    IkEv1,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionResetSharedKey {
    #[serde(rename = "keyLength")]
    pub key_length: i32,
}
impl ConnectionResetSharedKey {
    pub fn new(key_length: i32) -> Self {
        Self { key_length }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectionSharedKey {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub value: String,
}
impl ConnectionSharedKey {
    pub fn new(value: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            value,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectionStateSnapshot {
    #[serde(rename = "connectionState", default, skip_serializing_if = "Option::is_none")]
    pub connection_state: Option<connection_state_snapshot::ConnectionState>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "evaluationState", default, skip_serializing_if = "Option::is_none")]
    pub evaluation_state: Option<connection_state_snapshot::EvaluationState>,
    #[serde(rename = "avgLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub avg_latency_in_ms: Option<i64>,
    #[serde(rename = "minLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub min_latency_in_ms: Option<i64>,
    #[serde(rename = "maxLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub max_latency_in_ms: Option<i64>,
    #[serde(rename = "probesSent", default, skip_serializing_if = "Option::is_none")]
    pub probes_sent: Option<i64>,
    #[serde(rename = "probesFailed", default, skip_serializing_if = "Option::is_none")]
    pub probes_failed: Option<i64>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hops: Vec<ConnectivityHop>,
}
impl ConnectionStateSnapshot {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connection_state_snapshot {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionState {
        Reachable,
        Unreachable,
        Unknown,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EvaluationState {
        NotStarted,
        InProgress,
        Completed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityDestination {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
}
impl ConnectivityDestination {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityHop {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "nextHopIds", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hop_ids: Vec<String>,
    #[serde(rename = "previousHopIds", default, skip_serializing_if = "Vec::is_empty")]
    pub previous_hop_ids: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub links: Vec<HopLink>,
    #[serde(rename = "previousLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub previous_links: Vec<HopLink>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub issues: Vec<ConnectivityIssue>,
}
impl ConnectivityHop {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityInformation {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hops: Vec<ConnectivityHop>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<connectivity_information::ConnectionStatus>,
    #[serde(rename = "avgLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub avg_latency_in_ms: Option<i64>,
    #[serde(rename = "minLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub min_latency_in_ms: Option<i64>,
    #[serde(rename = "maxLatencyInMs", default, skip_serializing_if = "Option::is_none")]
    pub max_latency_in_ms: Option<i64>,
    #[serde(rename = "probesSent", default, skip_serializing_if = "Option::is_none")]
    pub probes_sent: Option<i64>,
    #[serde(rename = "probesFailed", default, skip_serializing_if = "Option::is_none")]
    pub probes_failed: Option<i64>,
}
impl ConnectivityInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_information {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectionStatus {
        Unknown,
        Connected,
        Disconnected,
        Degraded,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectivityIssue {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<connectivity_issue::Origin>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub severity: Option<connectivity_issue::Severity>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<connectivity_issue::Type>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub context: Vec<IssueContext>,
}
impl ConnectivityIssue {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod connectivity_issue {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Origin {
        Local,
        Inbound,
        Outbound,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Severity {
        Error,
        Warning,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Unknown,
        AgentStopped,
        GuestFirewall,
        DnsResolution,
        SocketBind,
        NetworkSecurityRule,
        UserDefinedRoute,
        PortThrottled,
        Platform,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivityParameters {
    pub source: ConnectivitySource,
    pub destination: ConnectivityDestination,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<connectivity_parameters::Protocol>,
    #[serde(rename = "protocolConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub protocol_configuration: Option<ProtocolConfiguration>,
    #[serde(rename = "preferredIPVersion", default, skip_serializing_if = "Option::is_none")]
    pub preferred_ip_version: Option<IpVersion>,
}
impl ConnectivityParameters {
    pub fn new(source: ConnectivitySource, destination: ConnectivityDestination) -> Self {
        Self {
            source,
            destination,
            protocol: None,
            protocol_configuration: None,
            preferred_ip_version: None,
        }
    }
}
pub mod connectivity_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Http,
        Https,
        Icmp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConnectivitySource {
    #[serde(rename = "resourceId")]
    pub resource_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i64>,
}
impl ConnectivitySource {
    pub fn new(resource_id: String) -> Self {
        Self { resource_id, port: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Container {
    #[serde(flatten)]
    pub sub_resource: SubResource,
}
impl Container {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterface {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContainerNetworkInterfacePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ContainerNetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfaceConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContainerNetworkInterfaceConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ContainerNetworkInterfaceConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfaceConfigurationPropertiesFormat {
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<IpConfigurationProfile>,
    #[serde(rename = "containerNetworkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub container_network_interfaces: Vec<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ContainerNetworkInterfaceConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfaceIpConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ContainerNetworkInterfaceIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ContainerNetworkInterfaceIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfaceIpConfigurationPropertiesFormat {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ContainerNetworkInterfaceIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerNetworkInterfacePropertiesFormat {
    #[serde(
        rename = "containerNetworkInterfaceConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub container_network_interface_configuration: Option<ContainerNetworkInterfaceConfiguration>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub container: Option<Container>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<ContainerNetworkInterfaceIpConfiguration>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ContainerNetworkInterfacePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomDnsConfigPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
}
impl CustomDnsConfigPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomIpPrefix {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Box<Option<CustomIpPrefixPropertiesFormat>>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl CustomIpPrefix {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomIpPrefixListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CustomIpPrefix>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CustomIpPrefixListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomIpPrefixPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cidr: Option<String>,
    #[serde(rename = "commissionedState", default, skip_serializing_if = "Option::is_none")]
    pub commissioned_state: Option<custom_ip_prefix_properties_format::CommissionedState>,
    #[serde(rename = "publicIpPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_prefixes: Vec<SubResource>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl CustomIpPrefixPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod custom_ip_prefix_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CommissionedState {
        Provisioning,
        Provisioned,
        Commissioning,
        Commissioned,
        Decommissioning,
        Deprovisioning,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosCustomPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DdosCustomPolicyPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl DdosCustomPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosCustomPolicyPropertiesFormat {
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "publicIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_addresses: Vec<SubResource>,
    #[serde(rename = "protocolCustomSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub protocol_custom_settings: Vec<ProtocolCustomSettingsFormat>,
}
impl DdosCustomPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosProtectionPlan {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DdosProtectionPlanPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl DdosProtectionPlan {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosProtectionPlanListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DdosProtectionPlan>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DdosProtectionPlanListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosProtectionPlanPropertiesFormat {
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "virtualNetworks", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_networks: Vec<SubResource>,
}
impl DdosProtectionPlanPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdosSettings {
    #[serde(rename = "ddosCustomPolicy", default, skip_serializing_if = "Option::is_none")]
    pub ddos_custom_policy: Option<SubResource>,
    #[serde(rename = "protectionCoverage", default, skip_serializing_if = "Option::is_none")]
    pub protection_coverage: Option<ddos_settings::ProtectionCoverage>,
    #[serde(rename = "protectedIP", default, skip_serializing_if = "Option::is_none")]
    pub protected_ip: Option<bool>,
}
impl DdosSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ddos_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProtectionCoverage {
        Basic,
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Delegation {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceDelegationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Delegation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceProperties {
    #[serde(rename = "deviceVendor", default, skip_serializing_if = "Option::is_none")]
    pub device_vendor: Option<String>,
    #[serde(rename = "deviceModel", default, skip_serializing_if = "Option::is_none")]
    pub device_model: Option<String>,
    #[serde(rename = "linkSpeedInMbps", default, skip_serializing_if = "Option::is_none")]
    pub link_speed_in_mbps: Option<i32>,
}
impl DeviceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DhGroup {
    None,
    #[serde(rename = "DHGroup1")]
    DhGroup1,
    #[serde(rename = "DHGroup2")]
    DhGroup2,
    #[serde(rename = "DHGroup14")]
    DhGroup14,
    #[serde(rename = "DHGroup2048")]
    DhGroup2048,
    #[serde(rename = "ECP256")]
    Ecp256,
    #[serde(rename = "ECP384")]
    Ecp384,
    #[serde(rename = "DHGroup24")]
    DhGroup24,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DhcpOptions {
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
}
impl DhcpOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "internalName", default, skip_serializing_if = "Option::is_none")]
    pub internal_name: Option<String>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Direction {
    Inbound,
    Outbound,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DnsNameAvailabilityResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
}
impl DnsNameAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DnsSettings {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub servers: Vec<String>,
    #[serde(rename = "enableProxy", default, skip_serializing_if = "Option::is_none")]
    pub enable_proxy: Option<bool>,
    #[serde(rename = "requireProxyForNetworkRules", default, skip_serializing_if = "Option::is_none")]
    pub require_proxy_for_network_rules: Option<bool>,
}
impl DnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DscpConfiguration {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<DscpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl DscpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DscpConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DscpConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DscpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DscpConfigurationPropertiesFormat {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub markings: Vec<i32>,
    #[serde(rename = "sourceIpRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_ranges: Vec<QosIpRange>,
    #[serde(rename = "destinationIpRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ip_ranges: Vec<QosIpRange>,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<QosPortRange>,
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<QosPortRange>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<dscp_configuration_properties_format::Protocol>,
    #[serde(rename = "qosCollectionId", default, skip_serializing_if = "Option::is_none")]
    pub qos_collection_id: Option<String>,
    #[serde(rename = "associatedNetworkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub associated_network_interfaces: Vec<NetworkInterface>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl DscpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod dscp_configuration_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        DoNotUse,
        Icmp,
        Tcp,
        Udp,
        Gre,
        Esp,
        Ah,
        Vxlan,
        All,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroup {
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub association: Option<EffectiveNetworkSecurityGroupAssociation>,
    #[serde(rename = "effectiveSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_security_rules: Vec<EffectiveNetworkSecurityRule>,
    #[serde(rename = "tagMap", default, skip_serializing_if = "Option::is_none")]
    pub tag_map: Option<String>,
}
impl EffectiveNetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupAssociation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "networkInterface", default, skip_serializing_if = "Option::is_none")]
    pub network_interface: Option<SubResource>,
}
impl EffectiveNetworkSecurityGroupAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveNetworkSecurityGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveNetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveNetworkSecurityRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<effective_network_security_rule::Protocol>,
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[serde(rename = "destinationAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub destination_address_prefix: Option<String>,
    #[serde(rename = "sourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub source_address_prefixes: Vec<String>,
    #[serde(rename = "destinationAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_address_prefixes: Vec<String>,
    #[serde(rename = "expandedSourceAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_source_address_prefix: Vec<String>,
    #[serde(rename = "expandedDestinationAddressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub expanded_destination_address_prefix: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<SecurityRuleAccess>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub direction: Option<SecurityRuleDirection>,
}
impl EffectiveNetworkSecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_network_security_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        All,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRoute {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "disableBgpRoutePropagation", default, skip_serializing_if = "Option::is_none")]
    pub disable_bgp_route_propagation: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<effective_route::Source>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<effective_route::State>,
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefix: Vec<String>,
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hop_ip_address: Vec<String>,
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<RouteNextHopType>,
}
impl EffectiveRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod effective_route {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        Unknown,
        User,
        VirtualNetworkGateway,
        Default,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Active,
        Invalid,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRouteListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EffectiveRoute>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EffectiveRouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EffectiveRoutesParameters {
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "virtualWanResourceType", default, skip_serializing_if = "Option::is_none")]
    pub virtual_wan_resource_type: Option<String>,
}
impl EffectiveRoutesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointServiceResult {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl EndpointServiceResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EndpointServicesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<EndpointServiceResult>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl EndpointServicesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Error {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorDetails>,
    #[serde(rename = "innerError", default, skip_serializing_if = "Option::is_none")]
    pub inner_error: Option<String>,
}
impl Error {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorDetails>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EvaluatedNetworkSecurityGroup {
    #[serde(rename = "networkSecurityGroupId", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group_id: Option<String>,
    #[serde(rename = "appliedTo", default, skip_serializing_if = "Option::is_none")]
    pub applied_to: Option<String>,
    #[serde(rename = "matchedRule", default, skip_serializing_if = "Option::is_none")]
    pub matched_rule: Option<MatchedRule>,
    #[serde(rename = "rulesEvaluationResult", default, skip_serializing_if = "Vec::is_empty")]
    pub rules_evaluation_result: Vec<NetworkSecurityRulesEvaluationResult>,
}
impl EvaluatedNetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuit {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<ExpressRouteCircuitSku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCircuit {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitArpTable {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub age: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interface: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
}
impl ExpressRouteCircuitArpTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitAuthorization {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AuthorizationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ExpressRouteCircuitAuthorization {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitConnectionPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ExpressRouteCircuitConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitConnectionPropertiesFormat {
    #[serde(rename = "expressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub express_route_circuit_peering: Option<SubResource>,
    #[serde(rename = "peerExpressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub peer_express_route_circuit_peering: Option<SubResource>,
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[serde(rename = "ipv6CircuitConnectionConfig", default, skip_serializing_if = "Option::is_none")]
    pub ipv6_circuit_connection_config: Option<Ipv6CircuitConnectionConfig>,
    #[serde(rename = "circuitConnectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub circuit_connection_status: Option<CircuitConnectionStatus>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ExpressRouteCircuitConnectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuit>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCircuitPeeringPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ExpressRouteCircuitPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringConfig {
    #[serde(rename = "advertisedPublicPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub advertised_public_prefixes: Vec<String>,
    #[serde(rename = "advertisedCommunities", default, skip_serializing_if = "Vec::is_empty")]
    pub advertised_communities: Vec<String>,
    #[serde(rename = "advertisedPublicPrefixesState", default, skip_serializing_if = "Option::is_none")]
    pub advertised_public_prefixes_state: Option<express_route_circuit_peering_config::AdvertisedPublicPrefixesState>,
    #[serde(rename = "legacyMode", default, skip_serializing_if = "Option::is_none")]
    pub legacy_mode: Option<i32>,
    #[serde(rename = "customerASN", default, skip_serializing_if = "Option::is_none")]
    pub customer_asn: Option<i32>,
    #[serde(rename = "routingRegistryName", default, skip_serializing_if = "Option::is_none")]
    pub routing_registry_name: Option<String>,
}
impl ExpressRouteCircuitPeeringConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_peering_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AdvertisedPublicPrefixesState {
        NotConfigured,
        Configuring,
        Configured,
        ValidationNeeded,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringId {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ExpressRouteCircuitPeeringId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitPeering>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPeeringPropertiesFormat {
    #[serde(rename = "peeringType", default, skip_serializing_if = "Option::is_none")]
    pub peering_type: Option<ExpressRoutePeeringType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ExpressRoutePeeringState>,
    #[serde(rename = "azureASN", default, skip_serializing_if = "Option::is_none")]
    pub azure_asn: Option<i32>,
    #[serde(rename = "peerASN", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[serde(rename = "vlanId", default, skip_serializing_if = "Option::is_none")]
    pub vlan_id: Option<i32>,
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stats: Option<ExpressRouteCircuitStats>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "routeFilter", default, skip_serializing_if = "Option::is_none")]
    pub route_filter: Option<SubResource>,
    #[serde(rename = "ipv6PeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub ipv6_peering_config: Option<Ipv6ExpressRouteCircuitPeeringConfig>,
    #[serde(rename = "expressRouteConnection", default, skip_serializing_if = "Option::is_none")]
    pub express_route_connection: Option<ExpressRouteConnectionId>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub connections: Vec<ExpressRouteCircuitConnection>,
    #[serde(rename = "peeredConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub peered_connections: Vec<PeerExpressRouteCircuitConnection>,
}
impl ExpressRouteCircuitPeeringPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitPropertiesFormat {
    #[serde(rename = "allowClassicOperations", default, skip_serializing_if = "Option::is_none")]
    pub allow_classic_operations: Option<bool>,
    #[serde(rename = "circuitProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub circuit_provisioning_state: Option<String>,
    #[serde(rename = "serviceProviderProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_provisioning_state: Option<ServiceProviderProvisioningState>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub authorizations: Vec<ExpressRouteCircuitAuthorization>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCircuitPeering>,
    #[serde(rename = "serviceKey", default, skip_serializing_if = "Option::is_none")]
    pub service_key: Option<String>,
    #[serde(rename = "serviceProviderNotes", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_notes: Option<String>,
    #[serde(rename = "serviceProviderProperties", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_properties: Option<ExpressRouteCircuitServiceProviderProperties>,
    #[serde(rename = "expressRoutePort", default, skip_serializing_if = "Option::is_none")]
    pub express_route_port: Option<SubResource>,
    #[serde(rename = "bandwidthInGbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_gbps: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stag: Option<i32>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
    #[serde(rename = "globalReachEnabled", default, skip_serializing_if = "Option::is_none")]
    pub global_reach_enabled: Option<bool>,
}
impl ExpressRouteCircuitPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ExpressRouteCircuitReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitRoutesTable {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[serde(rename = "locPrf", default, skip_serializing_if = "Option::is_none")]
    pub loc_prf: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
}
impl ExpressRouteCircuitRoutesTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitRoutesTableSummary {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub v: Option<i32>,
    #[serde(rename = "as", default, skip_serializing_if = "Option::is_none")]
    pub as_: Option<i32>,
    #[serde(rename = "upDown", default, skip_serializing_if = "Option::is_none")]
    pub up_down: Option<String>,
    #[serde(rename = "statePfxRcd", default, skip_serializing_if = "Option::is_none")]
    pub state_pfx_rcd: Option<String>,
}
impl ExpressRouteCircuitRoutesTableSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitServiceProviderProperties {
    #[serde(rename = "serviceProviderName", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_name: Option<String>,
    #[serde(rename = "peeringLocation", default, skip_serializing_if = "Option::is_none")]
    pub peering_location: Option<String>,
    #[serde(rename = "bandwidthInMbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_mbps: Option<i32>,
}
impl ExpressRouteCircuitServiceProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitSku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<express_route_circuit_sku::Tier>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub family: Option<express_route_circuit_sku::Family>,
}
impl ExpressRouteCircuitSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_circuit_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Standard,
        Premium,
        Basic,
        Local,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Family {
        UnlimitedData,
        MeteredData,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitStats {
    #[serde(rename = "primarybytesIn", default, skip_serializing_if = "Option::is_none")]
    pub primarybytes_in: Option<i64>,
    #[serde(rename = "primarybytesOut", default, skip_serializing_if = "Option::is_none")]
    pub primarybytes_out: Option<i64>,
    #[serde(rename = "secondarybytesIn", default, skip_serializing_if = "Option::is_none")]
    pub secondarybytes_in: Option<i64>,
    #[serde(rename = "secondarybytesOut", default, skip_serializing_if = "Option::is_none")]
    pub secondarybytes_out: Option<i64>,
}
impl ExpressRouteCircuitStats {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsArpTableListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitArpTable>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsArpTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsRoutesTableListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitRoutesTable>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsRoutesTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCircuitsRoutesTableSummaryListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCircuitRoutesTableSummary>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCircuitsRoutesTableSummaryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpressRouteConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteConnectionProperties>,
    pub name: String,
}
impl ExpressRouteConnection {
    pub fn new(name: String) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties: None,
            name,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteConnectionId {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ExpressRouteConnectionId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteConnectionList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteConnection>,
}
impl ExpressRouteConnectionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpressRouteConnectionProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "expressRouteCircuitPeering")]
    pub express_route_circuit_peering: ExpressRouteCircuitPeeringId,
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i64>,
    #[serde(rename = "enableInternetSecurity", default, skip_serializing_if = "Option::is_none")]
    pub enable_internet_security: Option<bool>,
    #[serde(rename = "routingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub routing_configuration: Option<RoutingConfiguration>,
}
impl ExpressRouteConnectionProperties {
    pub fn new(express_route_circuit_peering: ExpressRouteCircuitPeeringId) -> Self {
        Self {
            provisioning_state: None,
            express_route_circuit_peering,
            authorization_key: None,
            routing_weight: None,
            enable_internet_security: None,
            routing_configuration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnection {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCrossConnectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCrossConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCrossConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCrossConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteCrossConnectionPeeringProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteCrossConnectionPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionPeeringList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCrossConnectionPeering>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCrossConnectionPeeringList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionPeeringProperties {
    #[serde(rename = "peeringType", default, skip_serializing_if = "Option::is_none")]
    pub peering_type: Option<ExpressRoutePeeringType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ExpressRoutePeeringState>,
    #[serde(rename = "azureASN", default, skip_serializing_if = "Option::is_none")]
    pub azure_asn: Option<i32>,
    #[serde(rename = "peerASN", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[serde(rename = "vlanId", default, skip_serializing_if = "Option::is_none")]
    pub vlan_id: Option<i32>,
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "gatewayManagerEtag", default, skip_serializing_if = "Option::is_none")]
    pub gateway_manager_etag: Option<String>,
    #[serde(rename = "lastModifiedBy", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<String>,
    #[serde(rename = "ipv6PeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub ipv6_peering_config: Option<Ipv6ExpressRouteCircuitPeeringConfig>,
}
impl ExpressRouteCrossConnectionPeeringProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionProperties {
    #[serde(rename = "primaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub primary_azure_port: Option<String>,
    #[serde(rename = "secondaryAzurePort", default, skip_serializing_if = "Option::is_none")]
    pub secondary_azure_port: Option<String>,
    #[serde(rename = "sTag", default, skip_serializing_if = "Option::is_none")]
    pub s_tag: Option<i64>,
    #[serde(rename = "peeringLocation", default, skip_serializing_if = "Option::is_none")]
    pub peering_location: Option<String>,
    #[serde(rename = "bandwidthInMbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_mbps: Option<i32>,
    #[serde(rename = "expressRouteCircuit", default, skip_serializing_if = "Option::is_none")]
    pub express_route_circuit: Option<ExpressRouteCircuitReference>,
    #[serde(rename = "serviceProviderProvisioningState", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_provisioning_state: Option<ServiceProviderProvisioningState>,
    #[serde(rename = "serviceProviderNotes", default, skip_serializing_if = "Option::is_none")]
    pub service_provider_notes: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCrossConnectionPeering>,
}
impl ExpressRouteCrossConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionRoutesTableSummary {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub neighbor: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i32>,
    #[serde(rename = "upDown", default, skip_serializing_if = "Option::is_none")]
    pub up_down: Option<String>,
    #[serde(rename = "stateOrPrefixesReceived", default, skip_serializing_if = "Option::is_none")]
    pub state_or_prefixes_received: Option<String>,
}
impl ExpressRouteCrossConnectionRoutesTableSummary {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteCrossConnectionsRoutesTableSummaryListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteCrossConnectionRoutesTableSummary>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteCrossConnectionsRoutesTableSummaryListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteGatewayProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteGatewayList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteGateway>,
}
impl ExpressRouteGatewayList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpressRouteGatewayProperties {
    #[serde(rename = "autoScaleConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_configuration: Option<express_route_gateway_properties::AutoScaleConfiguration>,
    #[serde(rename = "expressRouteConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub express_route_connections: Vec<ExpressRouteConnection>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "virtualHub")]
    pub virtual_hub: VirtualHubId,
}
impl ExpressRouteGatewayProperties {
    pub fn new(virtual_hub: VirtualHubId) -> Self {
        Self {
            auto_scale_configuration: None,
            express_route_connections: Vec::new(),
            provisioning_state: None,
            virtual_hub,
        }
    }
}
pub mod express_route_gateway_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct AutoScaleConfiguration {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub bounds: Option<auto_scale_configuration::Bounds>,
    }
    impl AutoScaleConfiguration {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod auto_scale_configuration {
        use super::*;
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
        pub struct Bounds {
            #[serde(default, skip_serializing_if = "Option::is_none")]
            pub min: Option<i64>,
            #[serde(default, skip_serializing_if = "Option::is_none")]
            pub max: Option<i64>,
        }
        impl Bounds {
            pub fn new() -> Self {
                Self::default()
            }
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteLinkPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ExpressRouteLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteLinkListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteLink>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteLinkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteLinkMacSecConfig {
    #[serde(rename = "cknSecretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub ckn_secret_identifier: Option<String>,
    #[serde(rename = "cakSecretIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub cak_secret_identifier: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cipher: Option<express_route_link_mac_sec_config::Cipher>,
    #[serde(rename = "sciState", default, skip_serializing_if = "Option::is_none")]
    pub sci_state: Option<express_route_link_mac_sec_config::SciState>,
}
impl ExpressRouteLinkMacSecConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_link_mac_sec_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Cipher {
        GcmAes256,
        GcmAes128,
        GcmAesXpn128,
        GcmAesXpn256,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SciState {
        Disabled,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteLinkPropertiesFormat {
    #[serde(rename = "routerName", default, skip_serializing_if = "Option::is_none")]
    pub router_name: Option<String>,
    #[serde(rename = "interfaceName", default, skip_serializing_if = "Option::is_none")]
    pub interface_name: Option<String>,
    #[serde(rename = "patchPanelId", default, skip_serializing_if = "Option::is_none")]
    pub patch_panel_id: Option<String>,
    #[serde(rename = "rackId", default, skip_serializing_if = "Option::is_none")]
    pub rack_id: Option<String>,
    #[serde(rename = "connectorType", default, skip_serializing_if = "Option::is_none")]
    pub connector_type: Option<express_route_link_properties_format::ConnectorType>,
    #[serde(rename = "adminState", default, skip_serializing_if = "Option::is_none")]
    pub admin_state: Option<express_route_link_properties_format::AdminState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "macSecConfig", default, skip_serializing_if = "Option::is_none")]
    pub mac_sec_config: Option<ExpressRouteLinkMacSecConfig>,
}
impl ExpressRouteLinkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_link_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConnectorType {
        #[serde(rename = "LC")]
        Lc,
        #[serde(rename = "SC")]
        Sc,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AdminState {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ExpressRoutePeeringState {
    Disabled,
    Enabled,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ExpressRoutePeeringType {
    AzurePublicPeering,
    AzurePrivatePeering,
    MicrosoftPeering,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePort {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRoutePortPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
}
impl ExpressRoutePort {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRoutePort>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRoutePortListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortPropertiesFormat {
    #[serde(rename = "peeringLocation", default, skip_serializing_if = "Option::is_none")]
    pub peering_location: Option<String>,
    #[serde(rename = "bandwidthInGbps", default, skip_serializing_if = "Option::is_none")]
    pub bandwidth_in_gbps: Option<i64>,
    #[serde(rename = "provisionedBandwidthInGbps", default, skip_serializing_if = "Option::is_none")]
    pub provisioned_bandwidth_in_gbps: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mtu: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encapsulation: Option<express_route_port_properties_format::Encapsulation>,
    #[serde(rename = "etherType", default, skip_serializing_if = "Option::is_none")]
    pub ether_type: Option<String>,
    #[serde(rename = "allocationDate", default, skip_serializing_if = "Option::is_none")]
    pub allocation_date: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub links: Vec<ExpressRouteLink>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub circuits: Vec<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
}
impl ExpressRoutePortPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod express_route_port_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Encapsulation {
        Dot1Q,
        QinQ,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortsLocation {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRoutePortsLocationPropertiesFormat>,
}
impl ExpressRoutePortsLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortsLocationBandwidths {
    #[serde(rename = "offerName", default, skip_serializing_if = "Option::is_none")]
    pub offer_name: Option<String>,
    #[serde(rename = "valueInGbps", default, skip_serializing_if = "Option::is_none")]
    pub value_in_gbps: Option<i64>,
}
impl ExpressRoutePortsLocationBandwidths {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortsLocationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRoutePortsLocation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRoutePortsLocationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRoutePortsLocationPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub contact: Option<String>,
    #[serde(rename = "availableBandwidths", default, skip_serializing_if = "Vec::is_empty")]
    pub available_bandwidths: Vec<ExpressRoutePortsLocationBandwidths>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ExpressRoutePortsLocationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProvider {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ExpressRouteServiceProviderPropertiesFormat>,
}
impl ExpressRouteServiceProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderBandwidthsOffered {
    #[serde(rename = "offerName", default, skip_serializing_if = "Option::is_none")]
    pub offer_name: Option<String>,
    #[serde(rename = "valueInMbps", default, skip_serializing_if = "Option::is_none")]
    pub value_in_mbps: Option<i32>,
}
impl ExpressRouteServiceProviderBandwidthsOffered {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ExpressRouteServiceProvider>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ExpressRouteServiceProviderListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpressRouteServiceProviderPropertiesFormat {
    #[serde(rename = "peeringLocations", default, skip_serializing_if = "Vec::is_empty")]
    pub peering_locations: Vec<String>,
    #[serde(rename = "bandwidthsOffered", default, skip_serializing_if = "Vec::is_empty")]
    pub bandwidths_offered: Vec<ExpressRouteServiceProviderBandwidthsOffered>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ExpressRouteServiceProviderPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FirewallPolicyPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl FirewallPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallPolicyFilterRuleCollection {
    #[serde(flatten)]
    pub firewall_policy_rule_collection: FirewallPolicyRuleCollection,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<FirewallPolicyFilterRuleCollectionAction>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<FirewallPolicyRule>,
}
impl FirewallPolicyFilterRuleCollection {
    pub fn new(firewall_policy_rule_collection: FirewallPolicyRuleCollection) -> Self {
        Self {
            firewall_policy_rule_collection,
            action: None,
            rules: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyFilterRuleCollectionAction {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<FirewallPolicyFilterRuleCollectionActionType>,
}
impl FirewallPolicyFilterRuleCollectionAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyFilterRuleCollectionActionType {
    Allow,
    Deny,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FirewallPolicy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FirewallPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallPolicyNatRuleCollection {
    #[serde(flatten)]
    pub firewall_policy_rule_collection: FirewallPolicyRuleCollection,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<FirewallPolicyNatRuleCollectionAction>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<FirewallPolicyRule>,
}
impl FirewallPolicyNatRuleCollection {
    pub fn new(firewall_policy_rule_collection: FirewallPolicyRuleCollection) -> Self {
        Self {
            firewall_policy_rule_collection,
            action: None,
            rules: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyNatRuleCollectionAction {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<FirewallPolicyNatRuleCollectionActionType>,
}
impl FirewallPolicyNatRuleCollectionAction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyNatRuleCollectionActionType {
    #[serde(rename = "DNAT")]
    Dnat,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyPropertiesFormat {
    #[serde(rename = "ruleCollectionGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collection_groups: Vec<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "basePolicy", default, skip_serializing_if = "Option::is_none")]
    pub base_policy: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub firewalls: Vec<SubResource>,
    #[serde(rename = "childPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub child_policies: Vec<SubResource>,
    #[serde(rename = "threatIntelMode", default, skip_serializing_if = "Option::is_none")]
    pub threat_intel_mode: Option<AzureFirewallThreatIntelMode>,
    #[serde(rename = "threatIntelWhitelist", default, skip_serializing_if = "Option::is_none")]
    pub threat_intel_whitelist: Option<FirewallPolicyThreatIntelWhitelist>,
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<DnsSettings>,
}
impl FirewallPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallPolicyRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "ruleType")]
    pub rule_type: firewall_policy_rule::RuleType,
}
impl FirewallPolicyRule {
    pub fn new(rule_type: firewall_policy_rule::RuleType) -> Self {
        Self {
            name: None,
            description: None,
            rule_type,
        }
    }
}
pub mod firewall_policy_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleType {
        ApplicationRule,
        NetworkRule,
        NatRule,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyRuleApplicationProtocol {
    #[serde(rename = "protocolType", default, skip_serializing_if = "Option::is_none")]
    pub protocol_type: Option<FirewallPolicyRuleApplicationProtocolType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl FirewallPolicyRuleApplicationProtocol {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyRuleApplicationProtocolType {
    Http,
    Https,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FirewallPolicyRuleCollection {
    #[serde(rename = "ruleCollectionType")]
    pub rule_collection_type: firewall_policy_rule_collection::RuleCollectionType,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
}
impl FirewallPolicyRuleCollection {
    pub fn new(rule_collection_type: firewall_policy_rule_collection::RuleCollectionType) -> Self {
        Self {
            rule_collection_type,
            name: None,
            priority: None,
        }
    }
}
pub mod firewall_policy_rule_collection {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleCollectionType {
        FirewallPolicyNatRuleCollection,
        FirewallPolicyFilterRuleCollection,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyRuleCollectionGroup {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FirewallPolicyRuleCollectionGroupProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl FirewallPolicyRuleCollectionGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyRuleCollectionGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FirewallPolicyRuleCollectionGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FirewallPolicyRuleCollectionGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyRuleCollectionGroupProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(rename = "ruleCollections", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_collections: Vec<FirewallPolicyRuleCollection>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl FirewallPolicyRuleCollectionGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum FirewallPolicyRuleNetworkProtocol {
    #[serde(rename = "TCP")]
    Tcp,
    #[serde(rename = "UDP")]
    Udp,
    Any,
    #[serde(rename = "ICMP")]
    Icmp,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FirewallPolicyThreatIntelWhitelist {
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub fqdns: Vec<String>,
}
impl FirewallPolicyThreatIntelWhitelist {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FlowLog {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FlowLogPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl FlowLog {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FlowLogFormatParameters {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<flow_log_format_parameters::Type>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}
impl FlowLogFormatParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod flow_log_format_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "JSON")]
        Json,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogInformation {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    pub properties: FlowLogProperties,
    #[serde(rename = "flowAnalyticsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub flow_analytics_configuration: Option<TrafficAnalyticsProperties>,
}
impl FlowLogInformation {
    pub fn new(target_resource_id: String, properties: FlowLogProperties) -> Self {
        Self {
            target_resource_id,
            properties,
            flow_analytics_configuration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FlowLogListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FlowLog>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl FlowLogListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogProperties {
    #[serde(rename = "storageId")]
    pub storage_id: String,
    pub enabled: bool,
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicyParameters>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<FlowLogFormatParameters>,
}
impl FlowLogProperties {
    pub fn new(storage_id: String, enabled: bool) -> Self {
        Self {
            storage_id,
            enabled,
            retention_policy: None,
            format: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogPropertiesFormat {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[serde(rename = "targetResourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_guid: Option<String>,
    #[serde(rename = "storageId")]
    pub storage_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "retentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicyParameters>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<FlowLogFormatParameters>,
    #[serde(rename = "flowAnalyticsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub flow_analytics_configuration: Option<TrafficAnalyticsProperties>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl FlowLogPropertiesFormat {
    pub fn new(target_resource_id: String, storage_id: String) -> Self {
        Self {
            target_resource_id,
            target_resource_guid: None,
            storage_id,
            enabled: None,
            retention_policy: None,
            format: None,
            flow_analytics_configuration: None,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FlowLogStatusParameters {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
}
impl FlowLogStatusParameters {
    pub fn new(target_resource_id: String) -> Self {
        Self { target_resource_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FrontendIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl FrontendIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FrontendIpConfigurationPropertiesFormat {
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<SubResource>,
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<SubResource>,
    #[serde(rename = "outboundRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_rules: Vec<SubResource>,
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<IpVersion>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[serde(rename = "publicIPPrefix", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_prefix: Option<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl FrontendIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayRoute {
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[serde(rename = "sourcePeer", default, skip_serializing_if = "Option::is_none")]
    pub source_peer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(rename = "asPath", default, skip_serializing_if = "Option::is_none")]
    pub as_path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
}
impl GatewayRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GatewayRouteListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GatewayRoute>,
}
impl GatewayRouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenerateExpressRoutePortsLoaRequest {
    #[serde(rename = "customerName")]
    pub customer_name: String,
}
impl GenerateExpressRoutePortsLoaRequest {
    pub fn new(customer_name: String) -> Self {
        Self { customer_name }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenerateExpressRoutePortsLoaResult {
    #[serde(rename = "encodedContent", default, skip_serializing_if = "Option::is_none")]
    pub encoded_content: Option<String>,
}
impl GenerateExpressRoutePortsLoaResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetVpnSitesConfigurationRequest {
    #[serde(rename = "vpnSites", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_sites: Vec<String>,
    #[serde(rename = "outputBlobSasUrl")]
    pub output_blob_sas_url: String,
}
impl GetVpnSitesConfigurationRequest {
    pub fn new(output_blob_sas_url: String) -> Self {
        Self {
            vpn_sites: Vec::new(),
            output_blob_sas_url,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<http_configuration::Method>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub headers: Vec<HttpHeader>,
    #[serde(rename = "validStatusCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub valid_status_codes: Vec<i64>,
}
impl HttpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod http_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Method {
        Get,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpHeader {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl HttpHeader {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HopLink {
    #[serde(rename = "nextHopId", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_id: Option<String>,
    #[serde(rename = "linkType", default, skip_serializing_if = "Option::is_none")]
    pub link_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HopLinkProperties>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub issues: Vec<ConnectivityIssue>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub context: Option<serde_json::Value>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl HopLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HopLinkProperties {
    #[serde(rename = "roundTripTimeMin", default, skip_serializing_if = "Option::is_none")]
    pub round_trip_time_min: Option<i64>,
    #[serde(rename = "roundTripTimeAvg", default, skip_serializing_if = "Option::is_none")]
    pub round_trip_time_avg: Option<i64>,
    #[serde(rename = "roundTripTimeMax", default, skip_serializing_if = "Option::is_none")]
    pub round_trip_time_max: Option<i64>,
}
impl HopLinkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubIpAddresses {
    #[serde(rename = "publicIPs", default, skip_serializing_if = "Option::is_none")]
    pub public_i_ps: Option<HubPublicIpAddresses>,
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
}
impl HubIpAddresses {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubIpConfigurationPropertiesFormat {
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl HubIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HubIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl HubIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubPublicIpAddresses {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub addresses: Vec<AzureFirewallPublicIpAddress>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
}
impl HubPublicIpAddresses {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubRoute {
    pub name: String,
    #[serde(rename = "destinationType")]
    pub destination_type: String,
    pub destinations: Vec<String>,
    #[serde(rename = "nextHopType")]
    pub next_hop_type: String,
    #[serde(rename = "nextHop")]
    pub next_hop: String,
}
impl HubRoute {
    pub fn new(name: String, destination_type: String, destinations: Vec<String>, next_hop_type: String, next_hop: String) -> Self {
        Self {
            name,
            destination_type,
            destinations,
            next_hop_type,
            next_hop,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubRouteTable {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HubRouteTableProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl HubRouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubRouteTableProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<HubRoute>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<String>,
    #[serde(rename = "associatedConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub associated_connections: Vec<String>,
    #[serde(rename = "propagatingConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub propagating_connections: Vec<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl HubRouteTableProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubVirtualNetworkConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<HubVirtualNetworkConnectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl HubVirtualNetworkConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HubVirtualNetworkConnectionProperties {
    #[serde(rename = "remoteVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub remote_virtual_network: Option<SubResource>,
    #[serde(rename = "allowHubToRemoteVnetTransit", default, skip_serializing_if = "Option::is_none")]
    pub allow_hub_to_remote_vnet_transit: Option<bool>,
    #[serde(rename = "allowRemoteVnetToUseHubVnetGateways", default, skip_serializing_if = "Option::is_none")]
    pub allow_remote_vnet_to_use_hub_vnet_gateways: Option<bool>,
    #[serde(rename = "enableInternetSecurity", default, skip_serializing_if = "Option::is_none")]
    pub enable_internet_security: Option<bool>,
    #[serde(rename = "routingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub routing_configuration: Option<RoutingConfiguration>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl HubVirtualNetworkConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum HubVirtualNetworkConnectionStatus {
    Unknown,
    Connecting,
    Connected,
    NotConnected,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAddressAvailabilityResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub available: Option<bool>,
    #[serde(rename = "availableIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub available_ip_addresses: Vec<String>,
}
impl IpAddressAvailabilityResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpAllocationMethod {
    Static,
    Dynamic,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationBgpPeeringAddress {
    #[serde(rename = "ipconfigurationId", default, skip_serializing_if = "Option::is_none")]
    pub ipconfiguration_id: Option<String>,
    #[serde(rename = "defaultBgpIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub default_bgp_ip_addresses: Vec<String>,
    #[serde(rename = "customBgpIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_bgp_ip_addresses: Vec<String>,
    #[serde(rename = "tunnelIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_ip_addresses: Vec<String>,
}
impl IpConfigurationBgpPeeringAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationProfile {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpConfigurationProfilePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpConfigurationProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationProfilePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl IpConfigurationProfilePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpConfigurationPropertiesFormat {
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl IpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpVersion {
    IPv4,
    IPv6,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IkeEncryption {
    #[serde(rename = "DES")]
    Des,
    #[serde(rename = "DES3")]
    Des3,
    #[serde(rename = "AES128")]
    Aes128,
    #[serde(rename = "AES192")]
    Aes192,
    #[serde(rename = "AES256")]
    Aes256,
    #[serde(rename = "GCMAES256")]
    Gcmaes256,
    #[serde(rename = "GCMAES128")]
    Gcmaes128,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IkeIntegrity {
    #[serde(rename = "MD5")]
    Md5,
    #[serde(rename = "SHA1")]
    Sha1,
    #[serde(rename = "SHA256")]
    Sha256,
    #[serde(rename = "SHA384")]
    Sha384,
    #[serde(rename = "GCMAES256")]
    Gcmaes256,
    #[serde(rename = "GCMAES128")]
    Gcmaes128,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatPool {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatPoolPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl InboundNatPool {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundNatPoolPropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    pub protocol: TransportProtocol,
    #[serde(rename = "frontendPortRangeStart")]
    pub frontend_port_range_start: i32,
    #[serde(rename = "frontendPortRangeEnd")]
    pub frontend_port_range_end: i32,
    #[serde(rename = "backendPort")]
    pub backend_port: i32,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl InboundNatPoolPropertiesFormat {
    pub fn new(protocol: TransportProtocol, frontend_port_range_start: i32, frontend_port_range_end: i32, backend_port: i32) -> Self {
        Self {
            frontend_ip_configuration: None,
            protocol,
            frontend_port_range_start,
            frontend_port_range_end,
            backend_port,
            idle_timeout_in_minutes: None,
            enable_floating_ip: None,
            enable_tcp_reset: None,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundNatRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl InboundNatRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<InboundNatRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl InboundNatRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundNatRulePropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[serde(rename = "backendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub backend_ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<TransportProtocol>,
    #[serde(rename = "frontendPort", default, skip_serializing_if = "Option::is_none")]
    pub frontend_port: Option<i32>,
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl InboundNatRulePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundSecurityRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InboundSecurityRuleProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl InboundSecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundSecurityRuleProperties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<InboundSecurityRules>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl InboundSecurityRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InboundSecurityRules {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<inbound_security_rules::Protocol>,
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<i32>,
}
impl InboundSecurityRules {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod inbound_security_rules {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAllocation {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpAllocationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpAllocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAllocationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IpAllocation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IpAllocationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpAllocationPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "virtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network: Option<SubResource>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<IpAllocationType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<String>,
    #[serde(rename = "prefixLength", default, skip_serializing_if = "Option::is_none")]
    pub prefix_length: Option<i64>,
    #[serde(rename = "prefixType", default, skip_serializing_if = "Option::is_none")]
    pub prefix_type: Option<IpVersion>,
    #[serde(rename = "ipamAllocationId", default, skip_serializing_if = "Option::is_none")]
    pub ipam_allocation_id: Option<String>,
    #[serde(rename = "allocationTags", default, skip_serializing_if = "Option::is_none")]
    pub allocation_tags: Option<serde_json::Value>,
}
impl IpAllocationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpAllocationType {
    Undefined,
    Hypernet,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<IpGroupPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl IpGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<IpGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IpGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpGroupPropertiesFormat {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub firewalls: Vec<SubResource>,
}
impl IpGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type IpGroups = Vec<AzureFirewallIpGroups>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IpTag {
    #[serde(rename = "ipTagType", default, skip_serializing_if = "Option::is_none")]
    pub ip_tag_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
}
impl IpTag {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpsecEncryption {
    None,
    #[serde(rename = "DES")]
    Des,
    #[serde(rename = "DES3")]
    Des3,
    #[serde(rename = "AES128")]
    Aes128,
    #[serde(rename = "AES192")]
    Aes192,
    #[serde(rename = "AES256")]
    Aes256,
    #[serde(rename = "GCMAES128")]
    Gcmaes128,
    #[serde(rename = "GCMAES192")]
    Gcmaes192,
    #[serde(rename = "GCMAES256")]
    Gcmaes256,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IpsecIntegrity {
    #[serde(rename = "MD5")]
    Md5,
    #[serde(rename = "SHA1")]
    Sha1,
    #[serde(rename = "SHA256")]
    Sha256,
    #[serde(rename = "GCMAES128")]
    Gcmaes128,
    #[serde(rename = "GCMAES192")]
    Gcmaes192,
    #[serde(rename = "GCMAES256")]
    Gcmaes256,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IpsecPolicy {
    #[serde(rename = "saLifeTimeSeconds")]
    pub sa_life_time_seconds: i32,
    #[serde(rename = "saDataSizeKilobytes")]
    pub sa_data_size_kilobytes: i32,
    #[serde(rename = "ipsecEncryption")]
    pub ipsec_encryption: IpsecEncryption,
    #[serde(rename = "ipsecIntegrity")]
    pub ipsec_integrity: IpsecIntegrity,
    #[serde(rename = "ikeEncryption")]
    pub ike_encryption: IkeEncryption,
    #[serde(rename = "ikeIntegrity")]
    pub ike_integrity: IkeIntegrity,
    #[serde(rename = "dhGroup")]
    pub dh_group: DhGroup,
    #[serde(rename = "pfsGroup")]
    pub pfs_group: PfsGroup,
}
impl IpsecPolicy {
    pub fn new(
        sa_life_time_seconds: i32,
        sa_data_size_kilobytes: i32,
        ipsec_encryption: IpsecEncryption,
        ipsec_integrity: IpsecIntegrity,
        ike_encryption: IkeEncryption,
        ike_integrity: IkeIntegrity,
        dh_group: DhGroup,
        pfs_group: PfsGroup,
    ) -> Self {
        Self {
            sa_life_time_seconds,
            sa_data_size_kilobytes,
            ipsec_encryption,
            ipsec_integrity,
            ike_encryption,
            ike_integrity,
            dh_group,
            pfs_group,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Ipv6CircuitConnectionConfig {
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "circuitConnectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub circuit_connection_status: Option<CircuitConnectionStatus>,
}
impl Ipv6CircuitConnectionConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Ipv6ExpressRouteCircuitPeeringConfig {
    #[serde(rename = "primaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub primary_peer_address_prefix: Option<String>,
    #[serde(rename = "secondaryPeerAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub secondary_peer_address_prefix: Option<String>,
    #[serde(rename = "microsoftPeeringConfig", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_peering_config: Option<ExpressRouteCircuitPeeringConfig>,
    #[serde(rename = "routeFilter", default, skip_serializing_if = "Option::is_none")]
    pub route_filter: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<ipv6_express_route_circuit_peering_config::State>,
}
impl Ipv6ExpressRouteCircuitPeeringConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ipv6_express_route_circuit_peering_config {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
        Enabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IssueContext {}
impl IssueContext {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListHubRouteTablesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HubRouteTable>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListHubRouteTablesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListHubVirtualNetworkConnectionsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HubVirtualNetworkConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListHubVirtualNetworkConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListP2sVpnGatewaysResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<P2sVpnGateway>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListP2sVpnGatewaysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualHubBgpConnectionResults {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BgpConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualHubBgpConnectionResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualHubIpConfigurationResults {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<HubIpConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualHubIpConfigurationResults {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualHubRouteTableV2sResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualHubRouteTableV2>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualHubRouteTableV2sResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualHubsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualHub>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualHubsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVirtualWaNsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualWan>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVirtualWaNsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnConnectionsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnGatewaysResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnGateway>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnGatewaysResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnServerConfigurationsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnServerConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnServerConfigurationsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnSiteLinkConnectionsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnSiteLinkConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnSiteLinkConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnSiteLinksResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnSiteLink>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnSiteLinksResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ListVpnSitesResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnSite>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ListVpnSitesResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancer {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<LoadBalancerSku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancerPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LoadBalancer {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerBackendAddress {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancerBackendAddressPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl LoadBalancerBackendAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerBackendAddressPoolListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BackendAddressPool>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerBackendAddressPoolListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerBackendAddressPropertiesFormat {
    #[serde(rename = "virtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network: Option<SubResource>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "networkInterfaceIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub network_interface_ip_configuration: Option<SubResource>,
}
impl LoadBalancerBackendAddressPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerFrontendIpConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<FrontendIpConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerFrontendIpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancer>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerLoadBalancingRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancingRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerLoadBalancingRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerOutboundRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<OutboundRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerOutboundRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerProbeListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Probe>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LoadBalancerProbeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerPropertiesFormat {
    #[serde(rename = "frontendIPConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub frontend_ip_configurations: Vec<FrontendIpConfiguration>,
    #[serde(rename = "backendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub backend_address_pools: Vec<BackendAddressPool>,
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<LoadBalancingRule>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub probes: Vec<Probe>,
    #[serde(rename = "inboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_rules: Vec<InboundNatRule>,
    #[serde(rename = "inboundNatPools", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_nat_pools: Vec<InboundNatPool>,
    #[serde(rename = "outboundRules", default, skip_serializing_if = "Vec::is_empty")]
    pub outbound_rules: Vec<OutboundRule>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl LoadBalancerPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancerSku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<load_balancer_sku::Name>,
}
impl LoadBalancerSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod load_balancer_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LoadBalancingRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<LoadBalancingRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl LoadBalancingRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LoadBalancingRulePropertiesFormat {
    #[serde(rename = "frontendIPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub frontend_ip_configuration: Option<SubResource>,
    #[serde(rename = "backendAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub backend_address_pool: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub probe: Option<SubResource>,
    pub protocol: TransportProtocol,
    #[serde(rename = "loadDistribution", default, skip_serializing_if = "Option::is_none")]
    pub load_distribution: Option<load_balancing_rule_properties_format::LoadDistribution>,
    #[serde(rename = "frontendPort")]
    pub frontend_port: i32,
    #[serde(rename = "backendPort", default, skip_serializing_if = "Option::is_none")]
    pub backend_port: Option<i32>,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "enableFloatingIP", default, skip_serializing_if = "Option::is_none")]
    pub enable_floating_ip: Option<bool>,
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[serde(rename = "disableOutboundSnat", default, skip_serializing_if = "Option::is_none")]
    pub disable_outbound_snat: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl LoadBalancingRulePropertiesFormat {
    pub fn new(protocol: TransportProtocol, frontend_port: i32) -> Self {
        Self {
            frontend_ip_configuration: None,
            backend_address_pool: None,
            probe: None,
            protocol,
            load_distribution: None,
            frontend_port,
            backend_port: None,
            idle_timeout_in_minutes: None,
            enable_floating_ip: None,
            enable_tcp_reset: None,
            disable_outbound_snat: None,
            provisioning_state: None,
        }
    }
}
pub mod load_balancing_rule_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum LoadDistribution {
        Default,
        #[serde(rename = "SourceIP")]
        SourceIp,
        #[serde(rename = "SourceIPProtocol")]
        SourceIpProtocol,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LocalNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: LocalNetworkGatewayPropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl LocalNetworkGateway {
    pub fn new(properties: LocalNetworkGatewayPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LocalNetworkGateway>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LocalNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LocalNetworkGatewayPropertiesFormat {
    #[serde(rename = "localNetworkAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub local_network_address_space: Option<AddressSpace>,
    #[serde(rename = "gatewayIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub gateway_ip_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl LocalNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LogSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "blobDuration", default, skip_serializing_if = "Option::is_none")]
    pub blob_duration: Option<String>,
}
impl LogSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRuleGroupOverride {
    #[serde(rename = "ruleGroupName")]
    pub rule_group_name: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<ManagedRuleOverride>,
}
impl ManagedRuleGroupOverride {
    pub fn new(rule_group_name: String) -> Self {
        Self {
            rule_group_name,
            rules: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRuleOverride {
    #[serde(rename = "ruleId")]
    pub rule_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<managed_rule_override::State>,
}
impl ManagedRuleOverride {
    pub fn new(rule_id: String) -> Self {
        Self { rule_id, state: None }
    }
}
pub mod managed_rule_override {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRuleSet {
    #[serde(rename = "ruleSetType")]
    pub rule_set_type: String,
    #[serde(rename = "ruleSetVersion")]
    pub rule_set_version: String,
    #[serde(rename = "ruleGroupOverrides", default, skip_serializing_if = "Vec::is_empty")]
    pub rule_group_overrides: Vec<ManagedRuleGroupOverride>,
}
impl ManagedRuleSet {
    pub fn new(rule_set_type: String, rule_set_version: String) -> Self {
        Self {
            rule_set_type,
            rule_set_version,
            rule_group_overrides: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedRulesDefinition {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub exclusions: Vec<OwaspCrsExclusionEntry>,
    #[serde(rename = "managedRuleSets")]
    pub managed_rule_sets: Vec<ManagedRuleSet>,
}
impl ManagedRulesDefinition {
    pub fn new(managed_rule_sets: Vec<ManagedRuleSet>) -> Self {
        Self {
            exclusions: Vec::new(),
            managed_rule_sets,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedServiceIdentity {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<managed_service_identity::Type>,
    #[serde(rename = "userAssignedIdentities", default, skip_serializing_if = "Option::is_none")]
    pub user_assigned_identities: Option<serde_json::Value>,
}
impl ManagedServiceIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_service_identity {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
        UserAssigned,
        #[serde(rename = "SystemAssigned, UserAssigned")]
        SystemAssignedUserAssigned,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MatchCondition {
    #[serde(rename = "matchVariables")]
    pub match_variables: Vec<MatchVariable>,
    pub operator: match_condition::Operator,
    #[serde(rename = "negationConditon", default, skip_serializing_if = "Option::is_none")]
    pub negation_conditon: Option<bool>,
    #[serde(rename = "matchValues")]
    pub match_values: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transforms: Vec<Transform>,
}
impl MatchCondition {
    pub fn new(match_variables: Vec<MatchVariable>, operator: match_condition::Operator, match_values: Vec<String>) -> Self {
        Self {
            match_variables,
            operator,
            negation_conditon: None,
            match_values,
            transforms: Vec::new(),
        }
    }
}
pub mod match_condition {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        #[serde(rename = "IPMatch")]
        IpMatch,
        Equal,
        Contains,
        LessThan,
        GreaterThan,
        LessThanOrEqual,
        GreaterThanOrEqual,
        BeginsWith,
        EndsWith,
        Regex,
        GeoMatch,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MatchVariable {
    #[serde(rename = "variableName")]
    pub variable_name: match_variable::VariableName,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub selector: Option<String>,
}
impl MatchVariable {
    pub fn new(variable_name: match_variable::VariableName) -> Self {
        Self {
            variable_name,
            selector: None,
        }
    }
}
pub mod match_variable {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VariableName {
        RemoteAddr,
        RequestMethod,
        QueryString,
        PostArgs,
        RequestUri,
        RequestHeaders,
        RequestBody,
        RequestCookies,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MatchedRule {
    #[serde(rename = "ruleName", default, skip_serializing_if = "Option::is_none")]
    pub rule_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
}
impl MatchedRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub availabilities: Vec<Availability>,
    #[serde(rename = "enableRegionalMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub enable_regional_mdm_account: Option<bool>,
    #[serde(rename = "fillGapWithZero", default, skip_serializing_if = "Option::is_none")]
    pub fill_gap_with_zero: Option<bool>,
    #[serde(rename = "metricFilterPattern", default, skip_serializing_if = "Option::is_none")]
    pub metric_filter_pattern: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Dimension>,
    #[serde(rename = "isInternal", default, skip_serializing_if = "Option::is_none")]
    pub is_internal: Option<bool>,
    #[serde(rename = "sourceMdmAccount", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_account: Option<String>,
    #[serde(rename = "sourceMdmNamespace", default, skip_serializing_if = "Option::is_none")]
    pub source_mdm_namespace: Option<String>,
    #[serde(rename = "resourceIdDimensionNameOverride", default, skip_serializing_if = "Option::is_none")]
    pub resource_id_dimension_name_override: Option<String>,
}
impl MetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NatGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<NatGatewaySku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NatGatewayPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NatGateway {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NatGatewayListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NatGateway>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NatGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NatGatewayPropertiesFormat {
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "publicIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_addresses: Vec<SubResource>,
    #[serde(rename = "publicIpPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_prefixes: Vec<SubResource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<SubResource>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NatGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NatGatewaySku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<nat_gateway_sku::Name>,
}
impl NatGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod nat_gateway_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NatRule {
    #[serde(flatten)]
    pub firewall_policy_rule: FirewallPolicyRule,
    #[serde(rename = "ipProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_protocols: Vec<FirewallPolicyRuleNetworkProtocol>,
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<String>,
    #[serde(rename = "translatedAddress", default, skip_serializing_if = "Option::is_none")]
    pub translated_address: Option<String>,
    #[serde(rename = "translatedPort", default, skip_serializing_if = "Option::is_none")]
    pub translated_port: Option<String>,
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
}
impl NatRule {
    pub fn new(firewall_policy_rule: FirewallPolicyRule) -> Self {
        Self {
            firewall_policy_rule,
            ip_protocols: Vec::new(),
            source_addresses: Vec::new(),
            destination_addresses: Vec::new(),
            destination_ports: Vec::new(),
            translated_address: None,
            translated_port: None,
            source_ip_groups: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkConfigurationDiagnosticParameters {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[serde(rename = "verbosityLevel", default, skip_serializing_if = "Option::is_none")]
    pub verbosity_level: Option<network_configuration_diagnostic_parameters::VerbosityLevel>,
    pub profiles: Vec<NetworkConfigurationDiagnosticProfile>,
}
impl NetworkConfigurationDiagnosticParameters {
    pub fn new(target_resource_id: String, profiles: Vec<NetworkConfigurationDiagnosticProfile>) -> Self {
        Self {
            target_resource_id,
            verbosity_level: None,
            profiles,
        }
    }
}
pub mod network_configuration_diagnostic_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VerbosityLevel {
        Normal,
        Minimum,
        Full,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkConfigurationDiagnosticProfile {
    pub direction: Direction,
    pub protocol: String,
    pub source: String,
    pub destination: String,
    #[serde(rename = "destinationPort")]
    pub destination_port: String,
}
impl NetworkConfigurationDiagnosticProfile {
    pub fn new(direction: Direction, protocol: String, source: String, destination: String, destination_port: String) -> Self {
        Self {
            direction,
            protocol,
            source,
            destination,
            destination_port,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkConfigurationDiagnosticResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub results: Vec<NetworkConfigurationDiagnosticResult>,
}
impl NetworkConfigurationDiagnosticResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkConfigurationDiagnosticResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub profile: Option<NetworkConfigurationDiagnosticProfile>,
    #[serde(rename = "networkSecurityGroupResult", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group_result: Option<NetworkSecurityGroupResult>,
}
impl NetworkConfigurationDiagnosticResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkIntentPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkIntentPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkIntentPolicyConfiguration {
    #[serde(rename = "networkIntentPolicyName", default, skip_serializing_if = "Option::is_none")]
    pub network_intent_policy_name: Option<String>,
    #[serde(rename = "sourceNetworkIntentPolicy", default, skip_serializing_if = "Option::is_none")]
    pub source_network_intent_policy: Option<NetworkIntentPolicy>,
}
impl NetworkIntentPolicyConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterface {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfacePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceAssociation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
}
impl NetworkInterfaceAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceDnsSettings {
    #[serde(rename = "dnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub dns_servers: Vec<String>,
    #[serde(rename = "appliedDnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub applied_dns_servers: Vec<String>,
    #[serde(rename = "internalDnsNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub internal_dns_name_label: Option<String>,
    #[serde(rename = "internalFqdn", default, skip_serializing_if = "Option::is_none")]
    pub internal_fqdn: Option<String>,
    #[serde(rename = "internalDomainNameSuffix", default, skip_serializing_if = "Option::is_none")]
    pub internal_domain_name_suffix: Option<String>,
}
impl NetworkInterfaceDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkInterfaceIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterfaceIpConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceIpConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties {
    #[serde(rename = "groupId", default, skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "requiredMemberName", default, skip_serializing_if = "Option::is_none")]
    pub required_member_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub fqdns: Vec<String>,
}
impl NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceIpConfigurationPropertiesFormat {
    #[serde(rename = "virtualNetworkTaps", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_taps: Vec<VirtualNetworkTap>,
    #[serde(rename = "applicationGatewayBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateway_backend_address_pools: Vec<ApplicationGatewayBackendAddressPool>,
    #[serde(rename = "loadBalancerBackendAddressPools", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_backend_address_pools: Vec<BackendAddressPool>,
    #[serde(rename = "loadBalancerInboundNatRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_inbound_nat_rules: Vec<InboundNatRule>,
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<IpVersion>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<PublicIpAddress>,
    #[serde(rename = "applicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub application_security_groups: Vec<ApplicationSecurityGroup>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "privateLinkConnectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub private_link_connection_properties: Option<NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties>,
}
impl NetworkInterfaceIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterface>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceLoadBalancerListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LoadBalancer>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceLoadBalancerListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfacePropertiesFormat {
    #[serde(rename = "virtualMachine", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine: Option<SubResource>,
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<NetworkInterfaceIpConfiguration>,
    #[serde(rename = "tapConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub tap_configurations: Vec<NetworkInterfaceTapConfiguration>,
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<NetworkInterfaceDnsSettings>,
    #[serde(rename = "macAddress", default, skip_serializing_if = "Option::is_none")]
    pub mac_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "enableAcceleratedNetworking", default, skip_serializing_if = "Option::is_none")]
    pub enable_accelerated_networking: Option<bool>,
    #[serde(rename = "enableIPForwarding", default, skip_serializing_if = "Option::is_none")]
    pub enable_ip_forwarding: Option<bool>,
    #[serde(rename = "hostedWorkloads", default, skip_serializing_if = "Vec::is_empty")]
    pub hosted_workloads: Vec<String>,
    #[serde(rename = "dscpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub dscp_configuration: Option<SubResource>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkInterfacePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceTapConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkInterfaceTapConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl NetworkInterfaceTapConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceTapConfigurationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkInterfaceTapConfiguration>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkInterfaceTapConfigurationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkInterfaceTapConfigurationPropertiesFormat {
    #[serde(rename = "virtualNetworkTap", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_tap: Option<VirtualNetworkTap>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkInterfaceTapConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProfile {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkProfilePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProfileListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkProfile>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkProfileListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkProfilePropertiesFormat {
    #[serde(rename = "containerNetworkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub container_network_interfaces: Vec<ContainerNetworkInterface>,
    #[serde(rename = "containerNetworkInterfaceConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub container_network_interface_configurations: Vec<ContainerNetworkInterfaceConfiguration>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkProfilePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkRule {
    #[serde(flatten)]
    pub firewall_policy_rule: FirewallPolicyRule,
    #[serde(rename = "ipProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_protocols: Vec<FirewallPolicyRuleNetworkProtocol>,
    #[serde(rename = "sourceAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub source_addresses: Vec<String>,
    #[serde(rename = "destinationAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_addresses: Vec<String>,
    #[serde(rename = "destinationPorts", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ports: Vec<String>,
    #[serde(rename = "sourceIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_ip_groups: Vec<String>,
    #[serde(rename = "destinationIpGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_ip_groups: Vec<String>,
    #[serde(rename = "destinationFqdns", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_fqdns: Vec<String>,
}
impl NetworkRule {
    pub fn new(firewall_policy_rule: FirewallPolicyRule) -> Self {
        Self {
            firewall_policy_rule,
            ip_protocols: Vec::new(),
            source_addresses: Vec::new(),
            destination_addresses: Vec::new(),
            destination_ports: Vec::new(),
            source_ip_groups: Vec::new(),
            destination_ip_groups: Vec::new(),
            destination_fqdns: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroup {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkSecurityGroupPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkSecurityGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkSecurityGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkSecurityGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupPropertiesFormat {
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
    #[serde(rename = "defaultSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub default_security_rules: Vec<SecurityRule>,
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[serde(rename = "flowLogs", default, skip_serializing_if = "Vec::is_empty")]
    pub flow_logs: Vec<FlowLog>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkSecurityGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityGroupResult {
    #[serde(rename = "securityRuleAccessResult", default, skip_serializing_if = "Option::is_none")]
    pub security_rule_access_result: Option<SecurityRuleAccess>,
    #[serde(rename = "evaluatedNetworkSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub evaluated_network_security_groups: Vec<EvaluatedNetworkSecurityGroup>,
}
impl NetworkSecurityGroupResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkSecurityRulesEvaluationResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "protocolMatched", default, skip_serializing_if = "Option::is_none")]
    pub protocol_matched: Option<bool>,
    #[serde(rename = "sourceMatched", default, skip_serializing_if = "Option::is_none")]
    pub source_matched: Option<bool>,
    #[serde(rename = "sourcePortMatched", default, skip_serializing_if = "Option::is_none")]
    pub source_port_matched: Option<bool>,
    #[serde(rename = "destinationMatched", default, skip_serializing_if = "Option::is_none")]
    pub destination_matched: Option<bool>,
    #[serde(rename = "destinationPortMatched", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_matched: Option<bool>,
}
impl NetworkSecurityRulesEvaluationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualAppliance {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkVirtualAppliancePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedServiceIdentity>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkVirtualAppliance {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkVirtualAppliance>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkVirtualApplianceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualAppliancePropertiesFormat {
    #[serde(rename = "nvaSku", default, skip_serializing_if = "Option::is_none")]
    pub nva_sku: Option<VirtualApplianceSkuProperties>,
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "bootStrapConfigurationBlobs", default, skip_serializing_if = "Vec::is_empty")]
    pub boot_strap_configuration_blobs: Vec<String>,
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
    #[serde(rename = "cloudInitConfigurationBlobs", default, skip_serializing_if = "Vec::is_empty")]
    pub cloud_init_configuration_blobs: Vec<String>,
    #[serde(rename = "cloudInitConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub cloud_init_configuration: Option<String>,
    #[serde(rename = "virtualApplianceAsn", default, skip_serializing_if = "Option::is_none")]
    pub virtual_appliance_asn: Option<i64>,
    #[serde(rename = "virtualApplianceNics", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_appliance_nics: Vec<VirtualApplianceNicProperties>,
    #[serde(rename = "virtualApplianceSites", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_appliance_sites: Vec<SubResource>,
    #[serde(rename = "inboundSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub inbound_security_rules: Vec<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkVirtualAppliancePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSiteListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualApplianceSite>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkVirtualApplianceSiteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSku {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkVirtualApplianceSkuPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl NetworkVirtualApplianceSku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSkuInstances {
    #[serde(rename = "scaleUnit", default, skip_serializing_if = "Option::is_none")]
    pub scale_unit: Option<String>,
    #[serde(rename = "instanceCount", default, skip_serializing_if = "Option::is_none")]
    pub instance_count: Option<i32>,
}
impl NetworkVirtualApplianceSkuInstances {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSkuListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkVirtualApplianceSku>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NetworkVirtualApplianceSkuListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkVirtualApplianceSkuPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
    #[serde(rename = "availableVersions", default, skip_serializing_if = "Vec::is_empty")]
    pub available_versions: Vec<String>,
    #[serde(rename = "availableScaleUnits", default, skip_serializing_if = "Vec::is_empty")]
    pub available_scale_units: Vec<NetworkVirtualApplianceSkuInstances>,
}
impl NetworkVirtualApplianceSkuPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkWatcher {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<NetworkWatcherPropertiesFormat>,
}
impl NetworkWatcher {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkWatcherListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetworkWatcher>,
}
impl NetworkWatcherListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkWatcherPropertiesFormat {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl NetworkWatcherPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NextHopParameters {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    #[serde(rename = "sourceIPAddress")]
    pub source_ip_address: String,
    #[serde(rename = "destinationIPAddress")]
    pub destination_ip_address: String,
    #[serde(rename = "targetNicResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_resource_id: Option<String>,
}
impl NextHopParameters {
    pub fn new(target_resource_id: String, source_ip_address: String, destination_ip_address: String) -> Self {
        Self {
            target_resource_id,
            source_ip_address,
            destination_ip_address,
            target_nic_resource_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NextHopResult {
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<next_hop_result::NextHopType>,
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
    #[serde(rename = "routeTableId", default, skip_serializing_if = "Option::is_none")]
    pub route_table_id: Option<String>,
}
impl NextHopResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod next_hop_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NextHopType {
        Internet,
        VirtualAppliance,
        VirtualNetworkGateway,
        VnetLocal,
        HyperNetGateway,
        None,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct O365BreakOutCategoryPolicies {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub allow: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub optimize: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<bool>,
}
impl O365BreakOutCategoryPolicies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct O365PolicyProperties {
    #[serde(rename = "breakOutCategories", default, skip_serializing_if = "Option::is_none")]
    pub break_out_categories: Option<O365BreakOutCategoryPolicies>,
}
impl O365PolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Office365PolicyProperties {
    #[serde(rename = "breakOutCategories", default, skip_serializing_if = "Option::is_none")]
    pub break_out_categories: Option<BreakOutCategoryPolicies>,
}
impl Office365PolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OfficeTrafficCategory {
    Optimize,
    OptimizeAndAllow,
    All,
    None,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationPropertiesFormat>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationPropertiesFormat {
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<operation_properties_format::ServiceSpecification>,
}
impl OperationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ServiceSpecification {
        #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
        pub metric_specifications: Vec<MetricSpecification>,
        #[serde(rename = "logSpecifications", default, skip_serializing_if = "Vec::is_empty")]
        pub log_specifications: Vec<LogSpecification>,
    }
    impl ServiceSpecification {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OutboundRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OutboundRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl OutboundRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutboundRulePropertiesFormat {
    #[serde(rename = "allocatedOutboundPorts", default, skip_serializing_if = "Option::is_none")]
    pub allocated_outbound_ports: Option<i32>,
    #[serde(rename = "frontendIPConfigurations")]
    pub frontend_ip_configurations: Vec<SubResource>,
    #[serde(rename = "backendAddressPool")]
    pub backend_address_pool: SubResource,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    pub protocol: outbound_rule_properties_format::Protocol,
    #[serde(rename = "enableTcpReset", default, skip_serializing_if = "Option::is_none")]
    pub enable_tcp_reset: Option<bool>,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i64>,
}
impl OutboundRulePropertiesFormat {
    pub fn new(
        frontend_ip_configurations: Vec<SubResource>,
        backend_address_pool: SubResource,
        protocol: outbound_rule_properties_format::Protocol,
    ) -> Self {
        Self {
            allocated_outbound_ports: None,
            frontend_ip_configurations,
            backend_address_pool,
            provisioning_state: None,
            protocol,
            enable_tcp_reset: None,
            idle_timeout_in_minutes: None,
        }
    }
}
pub mod outbound_rule_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        All,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OwaspCrsExclusionEntry {
    #[serde(rename = "matchVariable")]
    pub match_variable: owasp_crs_exclusion_entry::MatchVariable,
    #[serde(rename = "selectorMatchOperator")]
    pub selector_match_operator: owasp_crs_exclusion_entry::SelectorMatchOperator,
    pub selector: String,
}
impl OwaspCrsExclusionEntry {
    pub fn new(
        match_variable: owasp_crs_exclusion_entry::MatchVariable,
        selector_match_operator: owasp_crs_exclusion_entry::SelectorMatchOperator,
        selector: String,
    ) -> Self {
        Self {
            match_variable,
            selector_match_operator,
            selector,
        }
    }
}
pub mod owasp_crs_exclusion_entry {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MatchVariable {
        RequestHeaderNames,
        RequestCookieNames,
        RequestArgNames,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SelectorMatchOperator {
        Equals,
        Contains,
        StartsWith,
        EndsWith,
        EqualsAny,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sConnectionConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<P2sConnectionConfigurationProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl P2sConnectionConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sConnectionConfigurationProperties {
    #[serde(rename = "vpnClientAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_address_pool: Option<AddressSpace>,
    #[serde(rename = "routingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub routing_configuration: Option<RoutingConfiguration>,
    #[serde(rename = "enableInternetSecurity", default, skip_serializing_if = "Option::is_none")]
    pub enable_internet_security: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl P2sConnectionConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnConnectionHealth {
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
}
impl P2sVpnConnectionHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnConnectionHealthRequest {
    #[serde(rename = "vpnUserNamesFilter", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_user_names_filter: Vec<String>,
    #[serde(rename = "outputBlobSasUrl", default, skip_serializing_if = "Option::is_none")]
    pub output_blob_sas_url: Option<String>,
}
impl P2sVpnConnectionHealthRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnConnectionRequest {
    #[serde(rename = "vpnConnectionIds", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_connection_ids: Vec<String>,
}
impl P2sVpnConnectionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct P2sVpnGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<P2sVpnGatewayProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl P2sVpnGateway {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnGatewayProperties {
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
    #[serde(rename = "p2SConnectionConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub p2_s_connection_configurations: Vec<P2sConnectionConfiguration>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "vpnGatewayScaleUnit", default, skip_serializing_if = "Option::is_none")]
    pub vpn_gateway_scale_unit: Option<i32>,
    #[serde(rename = "vpnServerConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_server_configuration: Option<SubResource>,
    #[serde(rename = "vpnClientConnectionHealth", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_connection_health: Option<VpnClientConnectionHealth>,
    #[serde(rename = "customDnsServers", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_dns_servers: Vec<String>,
}
impl P2sVpnGatewayProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct P2sVpnProfileParameters {
    #[serde(rename = "authenticationMethod", default, skip_serializing_if = "Option::is_none")]
    pub authentication_method: Option<AuthenticationMethod>,
}
impl P2sVpnProfileParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PacketCapture {
    pub properties: PacketCaptureParameters,
}
impl PacketCapture {
    pub fn new(properties: PacketCaptureParameters) -> Self {
        Self { properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureFilter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<packet_capture_filter::Protocol>,
    #[serde(rename = "localIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_ip_address: Option<String>,
    #[serde(rename = "remoteIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub remote_ip_address: Option<String>,
    #[serde(rename = "localPort", default, skip_serializing_if = "Option::is_none")]
    pub local_port: Option<String>,
    #[serde(rename = "remotePort", default, skip_serializing_if = "Option::is_none")]
    pub remote_port: Option<String>,
}
impl PacketCaptureFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod packet_capture_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
        Any,
    }
    impl Default for Protocol {
        fn default() -> Self {
            Self::Any
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PacketCaptureResult>,
}
impl PacketCaptureListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PacketCaptureParameters {
    pub target: String,
    #[serde(rename = "bytesToCapturePerPacket", default, skip_serializing_if = "Option::is_none")]
    pub bytes_to_capture_per_packet: Option<i64>,
    #[serde(rename = "totalBytesPerSession", default, skip_serializing_if = "Option::is_none")]
    pub total_bytes_per_session: Option<i64>,
    #[serde(rename = "timeLimitInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub time_limit_in_seconds: Option<i64>,
    #[serde(rename = "storageLocation")]
    pub storage_location: PacketCaptureStorageLocation,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub filters: Vec<PacketCaptureFilter>,
}
impl PacketCaptureParameters {
    pub fn new(target: String, storage_location: PacketCaptureStorageLocation) -> Self {
        Self {
            target,
            bytes_to_capture_per_packet: None,
            total_bytes_per_session: None,
            time_limit_in_seconds: None,
            storage_location,
            filters: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureQueryStatusResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "captureStartTime", default, skip_serializing_if = "Option::is_none")]
    pub capture_start_time: Option<String>,
    #[serde(rename = "packetCaptureStatus", default, skip_serializing_if = "Option::is_none")]
    pub packet_capture_status: Option<packet_capture_query_status_result::PacketCaptureStatus>,
    #[serde(rename = "stopReason", default, skip_serializing_if = "Option::is_none")]
    pub stop_reason: Option<String>,
    #[serde(rename = "packetCaptureError", default, skip_serializing_if = "Vec::is_empty")]
    pub packet_capture_error: Vec<String>,
}
impl PacketCaptureQueryStatusResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod packet_capture_query_status_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PacketCaptureStatus {
        NotStarted,
        Running,
        Stopped,
        Error,
        Unknown,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PacketCaptureResultProperties>,
}
impl PacketCaptureResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PacketCaptureResultProperties {
    #[serde(flatten)]
    pub packet_capture_parameters: PacketCaptureParameters,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl PacketCaptureResultProperties {
    pub fn new(packet_capture_parameters: PacketCaptureParameters) -> Self {
        Self {
            packet_capture_parameters,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PacketCaptureStorageLocation {
    #[serde(rename = "storageId", default, skip_serializing_if = "Option::is_none")]
    pub storage_id: Option<String>,
    #[serde(rename = "storagePath", default, skip_serializing_if = "Option::is_none")]
    pub storage_path: Option<String>,
    #[serde(rename = "filePath", default, skip_serializing_if = "Option::is_none")]
    pub file_path: Option<String>,
}
impl PacketCaptureStorageLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PatchRouteFilter {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl PatchRouteFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PatchRouteFilterRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PatchRouteFilterRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerExpressRouteCircuitConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PeerExpressRouteCircuitConnectionPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl PeerExpressRouteCircuitConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerExpressRouteCircuitConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PeerExpressRouteCircuitConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PeerExpressRouteCircuitConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerExpressRouteCircuitConnectionPropertiesFormat {
    #[serde(rename = "expressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub express_route_circuit_peering: Option<SubResource>,
    #[serde(rename = "peerExpressRouteCircuitPeering", default, skip_serializing_if = "Option::is_none")]
    pub peer_express_route_circuit_peering: Option<SubResource>,
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "circuitConnectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub circuit_connection_status: Option<CircuitConnectionStatus>,
    #[serde(rename = "connectionName", default, skip_serializing_if = "Option::is_none")]
    pub connection_name: Option<String>,
    #[serde(rename = "authResourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub auth_resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl PeerExpressRouteCircuitConnectionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerRoute {
    #[serde(rename = "localAddress", default, skip_serializing_if = "Option::is_none")]
    pub local_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub network: Option<String>,
    #[serde(rename = "nextHop", default, skip_serializing_if = "Option::is_none")]
    pub next_hop: Option<String>,
    #[serde(rename = "sourcePeer", default, skip_serializing_if = "Option::is_none")]
    pub source_peer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[serde(rename = "asPath", default, skip_serializing_if = "Option::is_none")]
    pub as_path: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub weight: Option<i32>,
}
impl PeerRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PeerRouteList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PeerRoute>,
}
impl PeerRouteList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PfsGroup {
    None,
    #[serde(rename = "PFS1")]
    Pfs1,
    #[serde(rename = "PFS2")]
    Pfs2,
    #[serde(rename = "PFS2048")]
    Pfs2048,
    #[serde(rename = "ECP256")]
    Ecp256,
    #[serde(rename = "ECP384")]
    Ecp384,
    #[serde(rename = "PFS24")]
    Pfs24,
    #[serde(rename = "PFS14")]
    Pfs14,
    #[serde(rename = "PFSMM")]
    Pfsmm,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PolicyNameEnum {
    AppGwSslPolicy20150501,
    AppGwSslPolicy20170401,
    AppGwSslPolicy20170401S,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicySettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<policy_settings::State>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mode: Option<policy_settings::Mode>,
    #[serde(rename = "requestBodyCheck", default, skip_serializing_if = "Option::is_none")]
    pub request_body_check: Option<bool>,
    #[serde(rename = "maxRequestBodySizeInKb", default, skip_serializing_if = "Option::is_none")]
    pub max_request_body_size_in_kb: Option<i32>,
    #[serde(rename = "fileUploadLimitInMb", default, skip_serializing_if = "Option::is_none")]
    pub file_upload_limit_in_mb: Option<i32>,
}
impl PolicySettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod policy_settings {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Disabled,
        Enabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        Prevention,
        Detection,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrepareNetworkPoliciesRequest {
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[serde(rename = "networkIntentPolicyConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_intent_policy_configurations: Vec<NetworkIntentPolicyConfiguration>,
}
impl PrepareNetworkPoliciesRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZoneConfig {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateDnsZonePropertiesFormat>,
}
impl PrivateDnsZoneConfig {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZoneGroup {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateDnsZoneGroupPropertiesFormat>,
}
impl PrivateDnsZoneGroup {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZoneGroupListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateDnsZoneGroup>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateDnsZoneGroupListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZoneGroupPropertiesFormat {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "privateDnsZoneConfigs", default, skip_serializing_if = "Vec::is_empty")]
    pub private_dns_zone_configs: Vec<PrivateDnsZoneConfig>,
}
impl PrivateDnsZoneGroupPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateDnsZonePropertiesFormat {
    #[serde(rename = "privateDnsZoneId", default, skip_serializing_if = "Option::is_none")]
    pub private_dns_zone_id: Option<String>,
    #[serde(rename = "recordSets", default, skip_serializing_if = "Vec::is_empty")]
    pub record_sets: Vec<RecordSet>,
}
impl PrivateDnsZonePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpointConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateEndpointConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionProperties {
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "linkIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub link_identifier: Option<String>,
}
impl PrivateEndpointConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateEndpoint>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateEndpointListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "privateLinkServiceConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_link_service_connections: Vec<PrivateLinkServiceConnection>,
    #[serde(rename = "manualPrivateLinkServiceConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub manual_private_link_service_connections: Vec<PrivateLinkServiceConnection>,
    #[serde(rename = "customDnsConfigs", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_dns_configs: Vec<CustomDnsConfigPropertiesFormat>,
}
impl PrivateEndpointProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkService {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkServiceProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PrivateLinkService {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkServiceConnectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl PrivateLinkServiceConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "privateLinkServiceId", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_id: Option<String>,
    #[serde(rename = "groupIds", default, skip_serializing_if = "Vec::is_empty")]
    pub group_ids: Vec<String>,
    #[serde(rename = "requestMessage", default, skip_serializing_if = "Option::is_none")]
    pub request_message: Option<String>,
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
}
impl PrivateLinkServiceConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionState {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateLinkServiceIpConfigurationProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl PrivateLinkServiceIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceIpConfigurationProperties {
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<Subnet>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "privateIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address_version: Option<IpVersion>,
}
impl PrivateLinkServiceIpConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PrivateLinkService>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PrivateLinkServiceListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceProperties {
    #[serde(rename = "loadBalancerFrontendIpConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancer_frontend_ip_configurations: Vec<FrontendIpConfiguration>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<PrivateLinkServiceIpConfiguration>,
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<NetworkInterface>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub visibility: Option<serde_json::Value>,
    #[serde(rename = "autoApproval", default, skip_serializing_if = "Option::is_none")]
    pub auto_approval: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub fqdns: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub alias: Option<String>,
    #[serde(rename = "enableProxyProtocol", default, skip_serializing_if = "Option::is_none")]
    pub enable_proxy_protocol: Option<bool>,
}
impl PrivateLinkServiceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceVisibility {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub visible: Option<bool>,
}
impl PrivateLinkServiceVisibility {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Probe {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ProbePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Probe {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ProbePropertiesFormat {
    #[serde(rename = "loadBalancingRules", default, skip_serializing_if = "Vec::is_empty")]
    pub load_balancing_rules: Vec<SubResource>,
    pub protocol: probe_properties_format::Protocol,
    pub port: i32,
    #[serde(rename = "intervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub interval_in_seconds: Option<i32>,
    #[serde(rename = "numberOfProbes", default, skip_serializing_if = "Option::is_none")]
    pub number_of_probes: Option<i32>,
    #[serde(rename = "requestPath", default, skip_serializing_if = "Option::is_none")]
    pub request_path: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ProbePropertiesFormat {
    pub fn new(protocol: probe_properties_format::Protocol, port: i32) -> Self {
        Self {
            load_balancing_rules: Vec::new(),
            protocol,
            port,
            interval_in_seconds: None,
            number_of_probes: None,
            request_path: None,
            provisioning_state: None,
        }
    }
}
pub mod probe_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Http,
        Tcp,
        Https,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PropagatedRouteTable {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub labels: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub ids: Vec<SubResource>,
}
impl PropagatedRouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtocolConfiguration {
    #[serde(rename = "HTTPConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub http_configuration: Option<HttpConfiguration>,
}
impl ProtocolConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProtocolCustomSettingsFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<protocol_custom_settings_format::Protocol>,
    #[serde(rename = "triggerRateOverride", default, skip_serializing_if = "Option::is_none")]
    pub trigger_rate_override: Option<String>,
    #[serde(rename = "sourceRateOverride", default, skip_serializing_if = "Option::is_none")]
    pub source_rate_override: Option<String>,
    #[serde(rename = "triggerSensitivityOverride", default, skip_serializing_if = "Option::is_none")]
    pub trigger_sensitivity_override: Option<protocol_custom_settings_format::TriggerSensitivityOverride>,
}
impl ProtocolCustomSettingsFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod protocol_custom_settings_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        Syn,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum TriggerSensitivityOverride {
        Relaxed,
        Low,
        Default,
        High,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProtocolsEnum {
    #[serde(rename = "TLSv1_0")]
    TlSv10,
    #[serde(rename = "TLSv1_1")]
    TlSv11,
    #[serde(rename = "TLSv1_2")]
    TlSv12,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ProvisioningState {
    Succeeded,
    Updating,
    Deleting,
    Failed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddress {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<PublicIpAddressSku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Box<Option<PublicIpAddressPropertiesFormat>>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl PublicIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressDnsSettings {
    #[serde(rename = "domainNameLabel", default, skip_serializing_if = "Option::is_none")]
    pub domain_name_label: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "reverseFqdn", default, skip_serializing_if = "Option::is_none")]
    pub reverse_fqdn: Option<String>,
}
impl PublicIpAddressDnsSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PublicIpAddress>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PublicIpAddressListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressPropertiesFormat {
    #[serde(rename = "publicIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_allocation_method: Option<IpAllocationMethod>,
    #[serde(rename = "publicIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_version: Option<IpVersion>,
    #[serde(rename = "ipConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ip_configuration: Option<IpConfiguration>,
    #[serde(rename = "dnsSettings", default, skip_serializing_if = "Option::is_none")]
    pub dns_settings: Option<PublicIpAddressDnsSettings>,
    #[serde(rename = "ddosSettings", default, skip_serializing_if = "Option::is_none")]
    pub ddos_settings: Option<DdosSettings>,
    #[serde(rename = "ipTags", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_tags: Vec<IpTag>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "publicIPPrefix", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_prefix: Option<SubResource>,
    #[serde(rename = "idleTimeoutInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub idle_timeout_in_minutes: Option<i32>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl PublicIpAddressPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpAddressSku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<public_ip_address_sku::Name>,
}
impl PublicIpAddressSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_address_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpPrefix {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<PublicIpPrefixSku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PublicIpPrefixPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub zones: Vec<String>,
}
impl PublicIpPrefix {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpPrefixListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PublicIpPrefix>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PublicIpPrefixListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpPrefixPropertiesFormat {
    #[serde(rename = "publicIPAddressVersion", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address_version: Option<IpVersion>,
    #[serde(rename = "ipTags", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_tags: Vec<IpTag>,
    #[serde(rename = "prefixLength", default, skip_serializing_if = "Option::is_none")]
    pub prefix_length: Option<i32>,
    #[serde(rename = "ipPrefix", default, skip_serializing_if = "Option::is_none")]
    pub ip_prefix: Option<String>,
    #[serde(rename = "publicIPAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub public_ip_addresses: Vec<ReferencedPublicIpAddress>,
    #[serde(rename = "loadBalancerFrontendIpConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub load_balancer_frontend_ip_configuration: Option<SubResource>,
    #[serde(rename = "customIPPrefix", default, skip_serializing_if = "Option::is_none")]
    pub custom_ip_prefix: Option<SubResource>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl PublicIpPrefixPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PublicIpPrefixSku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<public_ip_prefix_sku::Name>,
}
impl PublicIpPrefixSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod public_ip_prefix_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Standard,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QosIpRange {
    #[serde(rename = "startIP", default, skip_serializing_if = "Option::is_none")]
    pub start_ip: Option<String>,
    #[serde(rename = "endIP", default, skip_serializing_if = "Option::is_none")]
    pub end_ip: Option<String>,
}
impl QosIpRange {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QosPortRange {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub start: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub end: Option<i32>,
}
impl QosPortRange {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QueryTroubleshootingParameters {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
}
impl QueryTroubleshootingParameters {
    pub fn new(target_resource_id: String) -> Self {
        Self { target_resource_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RadiusServer {
    #[serde(rename = "radiusServerAddress")]
    pub radius_server_address: String,
    #[serde(rename = "radiusServerScore", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_score: Option<i64>,
    #[serde(rename = "radiusServerSecret", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_secret: Option<String>,
}
impl RadiusServer {
    pub fn new(radius_server_address: String) -> Self {
        Self {
            radius_server_address,
            radius_server_score: None,
            radius_server_secret: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecordSet {
    #[serde(rename = "recordType", default, skip_serializing_if = "Option::is_none")]
    pub record_type: Option<String>,
    #[serde(rename = "recordSetName", default, skip_serializing_if = "Option::is_none")]
    pub record_set_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub ttl: Option<i64>,
    #[serde(rename = "ipAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_addresses: Vec<String>,
}
impl RecordSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RedirectTypeEnum {
    Permanent,
    Found,
    SeeOther,
    Temporary,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReferencedPublicIpAddress {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ReferencedPublicIpAddress {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ResourceNavigationLinkFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ResourceNavigationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLinkFormat {
    #[serde(rename = "linkedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ResourceNavigationLinkFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNavigationLinksListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ResourceNavigationLink>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ResourceNavigationLinksListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceSet {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subscriptions: Vec<String>,
}
impl ResourceSet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetentionPolicyParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub days: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl RetentionPolicyParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Route {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RoutePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Route {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RouteFilter {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteFilter {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteFilter>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteFilterListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterPropertiesFormat {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub rules: Vec<RouteFilterRule>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<ExpressRouteCircuitPeering>,
    #[serde(rename = "ipv6Peerings", default, skip_serializing_if = "Vec::is_empty")]
    pub ipv6_peerings: Vec<ExpressRouteCircuitPeering>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RouteFilterPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteFilterRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteFilterRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteFilterRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteFilterRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteFilterRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RouteFilterRulePropertiesFormat {
    pub access: Access,
    #[serde(rename = "routeFilterRuleType")]
    pub route_filter_rule_type: route_filter_rule_properties_format::RouteFilterRuleType,
    pub communities: Vec<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RouteFilterRulePropertiesFormat {
    pub fn new(
        access: Access,
        route_filter_rule_type: route_filter_rule_properties_format::RouteFilterRuleType,
        communities: Vec<String>,
    ) -> Self {
        Self {
            access,
            route_filter_rule_type,
            communities,
            provisioning_state: None,
        }
    }
}
pub mod route_filter_rule_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RouteFilterRuleType {
        Community,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Route>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RouteNextHopType {
    VirtualNetworkGateway,
    VnetLocal,
    Internet,
    VirtualAppliance,
    None,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoutePropertiesFormat {
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "nextHopType")]
    pub next_hop_type: RouteNextHopType,
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RoutePropertiesFormat {
    pub fn new(next_hop_type: RouteNextHopType) -> Self {
        Self {
            address_prefix: None,
            next_hop_type,
            next_hop_ip_address: None,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTable {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<RouteTablePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl RouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTableListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<RouteTable>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RouteTableListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RouteTablePropertiesFormat {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<Route>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[serde(rename = "disableBgpRoutePropagation", default, skip_serializing_if = "Option::is_none")]
    pub disable_bgp_route_propagation: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl RouteTablePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoutingConfiguration {
    #[serde(rename = "associatedRouteTable", default, skip_serializing_if = "Option::is_none")]
    pub associated_route_table: Option<SubResource>,
    #[serde(rename = "propagatedRouteTables", default, skip_serializing_if = "Option::is_none")]
    pub propagated_route_tables: Option<PropagatedRouteTable>,
    #[serde(rename = "vnetRoutes", default, skip_serializing_if = "Option::is_none")]
    pub vnet_routes: Option<VnetRoute>,
}
impl RoutingConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RoutingState {
    None,
    Provisioned,
    Provisioning,
    Failed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityGroupNetworkInterface {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "securityRuleAssociations", default, skip_serializing_if = "Option::is_none")]
    pub security_rule_associations: Option<SecurityRuleAssociations>,
}
impl SecurityGroupNetworkInterface {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityGroupViewParameters {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
}
impl SecurityGroupViewParameters {
    pub fn new(target_resource_id: String) -> Self {
        Self { target_resource_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityGroupViewResult {
    #[serde(rename = "networkInterfaces", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interfaces: Vec<SecurityGroupNetworkInterface>,
}
impl SecurityGroupViewResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPartnerProvider {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityPartnerProviderPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl SecurityPartnerProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityPartnerProviderConnectionStatus {
    Unknown,
    PartiallyConnected,
    Connected,
    NotConnected,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPartnerProviderListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityPartnerProvider>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityPartnerProviderListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityPartnerProviderPropertiesFormat {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "securityProviderName", default, skip_serializing_if = "Option::is_none")]
    pub security_provider_name: Option<SecurityPartnerProvidersecurityProviderName>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<SecurityPartnerProviderConnectionStatus>,
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
}
impl SecurityPartnerProviderPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityPartnerProvidersecurityProviderName {
    ZScaler,
    IBoss,
    Checkpoint,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRule {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SecurityRulePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl SecurityRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityRuleAccess {
    Allow,
    Deny,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRuleAssociations {
    #[serde(rename = "networkInterfaceAssociation", default, skip_serializing_if = "Option::is_none")]
    pub network_interface_association: Option<NetworkInterfaceAssociation>,
    #[serde(rename = "subnetAssociation", default, skip_serializing_if = "Option::is_none")]
    pub subnet_association: Option<SubnetAssociation>,
    #[serde(rename = "defaultSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub default_security_rules: Vec<SecurityRule>,
    #[serde(rename = "effectiveSecurityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub effective_security_rules: Vec<EffectiveNetworkSecurityRule>,
}
impl SecurityRuleAssociations {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SecurityRuleDirection {
    Inbound,
    Outbound,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SecurityRuleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SecurityRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SecurityRuleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecurityRulePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    pub protocol: security_rule_properties_format::Protocol,
    #[serde(rename = "sourcePortRange", default, skip_serializing_if = "Option::is_none")]
    pub source_port_range: Option<String>,
    #[serde(rename = "destinationPortRange", default, skip_serializing_if = "Option::is_none")]
    pub destination_port_range: Option<String>,
    #[serde(rename = "sourceAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub source_address_prefix: Option<String>,
    #[serde(rename = "sourceAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub source_address_prefixes: Vec<String>,
    #[serde(rename = "sourceApplicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub source_application_security_groups: Vec<ApplicationSecurityGroup>,
    #[serde(rename = "destinationAddressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub destination_address_prefix: Option<String>,
    #[serde(rename = "destinationAddressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_address_prefixes: Vec<String>,
    #[serde(rename = "destinationApplicationSecurityGroups", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_application_security_groups: Vec<ApplicationSecurityGroup>,
    #[serde(rename = "sourcePortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub source_port_ranges: Vec<String>,
    #[serde(rename = "destinationPortRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub destination_port_ranges: Vec<String>,
    pub access: SecurityRuleAccess,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    pub direction: SecurityRuleDirection,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl SecurityRulePropertiesFormat {
    pub fn new(protocol: security_rule_properties_format::Protocol, access: SecurityRuleAccess, direction: SecurityRuleDirection) -> Self {
        Self {
            description: None,
            protocol,
            source_port_range: None,
            destination_port_range: None,
            source_address_prefix: None,
            source_address_prefixes: Vec::new(),
            source_application_security_groups: Vec::new(),
            destination_address_prefix: None,
            destination_address_prefixes: Vec::new(),
            destination_application_security_groups: Vec::new(),
            source_port_ranges: Vec::new(),
            destination_port_ranges: Vec::new(),
            access,
            priority: None,
            direction,
            provisioning_state: None,
        }
    }
}
pub mod security_rule_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        Tcp,
        Udp,
        Icmp,
        Esp,
        #[serde(rename = "*")]
        U2a,
        Ah,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceAssociationLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceAssociationLinkPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl ServiceAssociationLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceAssociationLinkPropertiesFormat {
    #[serde(rename = "linkedResourceType", default, skip_serializing_if = "Option::is_none")]
    pub linked_resource_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub link: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "allowDelete", default, skip_serializing_if = "Option::is_none")]
    pub allow_delete: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
}
impl ServiceAssociationLinkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceAssociationLinksListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceAssociationLink>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceAssociationLinksListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceDelegationPropertiesFormat {
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub actions: Vec<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ServiceDelegationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceEndpointPolicyPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ServiceEndpointPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyDefinition {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceEndpointPolicyDefinitionPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl ServiceEndpointPolicyDefinition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyDefinitionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceEndpointPolicyDefinition>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceEndpointPolicyDefinitionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyDefinitionPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub service: Option<String>,
    #[serde(rename = "serviceResources", default, skip_serializing_if = "Vec::is_empty")]
    pub service_resources: Vec<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ServiceEndpointPolicyDefinitionPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ServiceEndpointPolicy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ServiceEndpointPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPolicyPropertiesFormat {
    #[serde(rename = "serviceEndpointPolicyDefinitions", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoint_policy_definitions: Vec<ServiceEndpointPolicyDefinition>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ServiceEndpointPolicyPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceEndpointPropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub service: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub locations: Vec<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl ServiceEndpointPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ServiceProviderProvisioningState {
    NotProvisioned,
    Provisioning,
    Provisioned,
    Deprovisioning,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTagInformation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<ServiceTagInformationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl ServiceTagInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTagInformationPropertiesFormat {
    #[serde(rename = "changeNumber", default, skip_serializing_if = "Option::is_none")]
    pub change_number: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    #[serde(rename = "systemService", default, skip_serializing_if = "Option::is_none")]
    pub system_service: Option<String>,
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
}
impl ServiceTagInformationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceTagsListResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "changeNumber", default, skip_serializing_if = "Option::is_none")]
    pub change_number: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cloud: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<ServiceTagInformation>,
}
impl ServiceTagsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SessionIds {
    #[serde(rename = "sessionIds", default, skip_serializing_if = "Vec::is_empty")]
    pub session_ids: Vec<String>,
}
impl SessionIds {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StaticRoute {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
}
impl StaticRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Subnet {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SubnetPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl Subnet {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetAssociation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "securityRules", default, skip_serializing_if = "Vec::is_empty")]
    pub security_rules: Vec<SecurityRule>,
}
impl SubnetAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Subnet>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SubnetListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubnetPropertiesFormat {
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[serde(rename = "networkSecurityGroup", default, skip_serializing_if = "Option::is_none")]
    pub network_security_group: Option<NetworkSecurityGroup>,
    #[serde(rename = "routeTable", default, skip_serializing_if = "Option::is_none")]
    pub route_table: Option<RouteTable>,
    #[serde(rename = "natGateway", default, skip_serializing_if = "Option::is_none")]
    pub nat_gateway: Option<SubResource>,
    #[serde(rename = "serviceEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoints: Vec<ServiceEndpointPropertiesFormat>,
    #[serde(rename = "serviceEndpointPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub service_endpoint_policies: Vec<ServiceEndpointPolicy>,
    #[serde(rename = "privateEndpoints", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoints: Vec<PrivateEndpoint>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<IpConfiguration>,
    #[serde(rename = "ipConfigurationProfiles", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configuration_profiles: Vec<IpConfigurationProfile>,
    #[serde(rename = "ipAllocations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_allocations: Vec<SubResource>,
    #[serde(rename = "resourceNavigationLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_navigation_links: Vec<ResourceNavigationLink>,
    #[serde(rename = "serviceAssociationLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub service_association_links: Vec<ServiceAssociationLink>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub delegations: Vec<Delegation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub purpose: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "privateEndpointNetworkPolicies", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint_network_policies: Option<String>,
    #[serde(rename = "privateLinkServiceNetworkPolicies", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_network_policies: Option<String>,
}
impl SubnetPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TagsObject {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl TagsObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Topology {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "createdDateTime", default, skip_serializing_if = "Option::is_none")]
    pub created_date_time: Option<String>,
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<TopologyResource>,
}
impl Topology {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyAssociation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(rename = "associationType", default, skip_serializing_if = "Option::is_none")]
    pub association_type: Option<topology_association::AssociationType>,
}
impl TopologyAssociation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod topology_association {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AssociationType {
        Associated,
        Contains,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyParameters {
    #[serde(rename = "targetResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub target_resource_group_name: Option<String>,
    #[serde(rename = "targetVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub target_virtual_network: Option<SubResource>,
    #[serde(rename = "targetSubnet", default, skip_serializing_if = "Option::is_none")]
    pub target_subnet: Option<SubResource>,
}
impl TopologyParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TopologyResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub associations: Vec<TopologyAssociation>,
}
impl TopologyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrafficAnalyticsConfigurationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "workspaceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_id: Option<String>,
    #[serde(rename = "workspaceRegion", default, skip_serializing_if = "Option::is_none")]
    pub workspace_region: Option<String>,
    #[serde(rename = "workspaceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_resource_id: Option<String>,
    #[serde(rename = "trafficAnalyticsInterval", default, skip_serializing_if = "Option::is_none")]
    pub traffic_analytics_interval: Option<i64>,
}
impl TrafficAnalyticsConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TrafficAnalyticsProperties {
    #[serde(
        rename = "networkWatcherFlowAnalyticsConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub network_watcher_flow_analytics_configuration: Option<TrafficAnalyticsConfigurationProperties>,
}
impl TrafficAnalyticsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrafficSelectorPolicy {
    #[serde(rename = "localAddressRanges")]
    pub local_address_ranges: Vec<String>,
    #[serde(rename = "remoteAddressRanges")]
    pub remote_address_ranges: Vec<String>,
}
impl TrafficSelectorPolicy {
    pub fn new(local_address_ranges: Vec<String>, remote_address_ranges: Vec<String>) -> Self {
        Self {
            local_address_ranges,
            remote_address_ranges,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum Transform {
    Lowercase,
    Trim,
    UrlDecode,
    UrlEncode,
    RemoveNulls,
    HtmlEntityDecode,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TransportProtocol {
    Udp,
    Tcp,
    All,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TroubleshootingDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "reasonType", default, skip_serializing_if = "Option::is_none")]
    pub reason_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub summary: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub detail: Option<String>,
    #[serde(rename = "recommendedActions", default, skip_serializing_if = "Vec::is_empty")]
    pub recommended_actions: Vec<TroubleshootingRecommendedActions>,
}
impl TroubleshootingDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TroubleshootingParameters {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    pub properties: TroubleshootingProperties,
}
impl TroubleshootingParameters {
    pub fn new(target_resource_id: String, properties: TroubleshootingProperties) -> Self {
        Self {
            target_resource_id,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TroubleshootingProperties {
    #[serde(rename = "storageId")]
    pub storage_id: String,
    #[serde(rename = "storagePath")]
    pub storage_path: String,
}
impl TroubleshootingProperties {
    pub fn new(storage_id: String, storage_path: String) -> Self {
        Self { storage_id, storage_path }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TroubleshootingRecommendedActions {
    #[serde(rename = "actionId", default, skip_serializing_if = "Option::is_none")]
    pub action_id: Option<String>,
    #[serde(rename = "actionText", default, skip_serializing_if = "Option::is_none")]
    pub action_text: Option<String>,
    #[serde(rename = "actionUri", default, skip_serializing_if = "Option::is_none")]
    pub action_uri: Option<String>,
    #[serde(rename = "actionUriText", default, skip_serializing_if = "Option::is_none")]
    pub action_uri_text: Option<String>,
}
impl TroubleshootingRecommendedActions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TroubleshootingResult {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub results: Vec<TroubleshootingDetails>,
}
impl TroubleshootingResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TunnelConnectionHealth {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tunnel: Option<String>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VirtualNetworkGatewayConnectionStatus>,
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[serde(rename = "lastConnectionEstablishedUtcTime", default, skip_serializing_if = "Option::is_none")]
    pub last_connection_established_utc_time: Option<String>,
}
impl TunnelConnectionHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TunnelConnectionStatus {
    Unknown,
    Connecting,
    Connected,
    NotConnected,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UnprepareNetworkPoliciesRequest {
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
}
impl UnprepareNetworkPoliciesRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    pub unit: usage::Unit,
    #[serde(rename = "currentValue")]
    pub current_value: i64,
    pub limit: i64,
    pub name: UsageName,
}
impl Usage {
    pub fn new(unit: usage::Unit, current_value: i64, limit: i64, name: UsageName) -> Self {
        Self {
            id: None,
            unit,
            current_value,
            limit,
            name,
        }
    }
}
pub mod usage {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Unit {
        Count,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsageName {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
}
impl UsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UsagesListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Usage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl UsagesListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Vm {
    #[serde(flatten)]
    pub resource: Resource,
}
impl Vm {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerificationIpFlowParameters {
    #[serde(rename = "targetResourceId")]
    pub target_resource_id: String,
    pub direction: Direction,
    pub protocol: verification_ip_flow_parameters::Protocol,
    #[serde(rename = "localPort")]
    pub local_port: String,
    #[serde(rename = "remotePort")]
    pub remote_port: String,
    #[serde(rename = "localIPAddress")]
    pub local_ip_address: String,
    #[serde(rename = "remoteIPAddress")]
    pub remote_ip_address: String,
    #[serde(rename = "targetNicResourceId", default, skip_serializing_if = "Option::is_none")]
    pub target_nic_resource_id: Option<String>,
}
impl VerificationIpFlowParameters {
    pub fn new(
        target_resource_id: String,
        direction: Direction,
        protocol: verification_ip_flow_parameters::Protocol,
        local_port: String,
        remote_port: String,
        local_ip_address: String,
        remote_ip_address: String,
    ) -> Self {
        Self {
            target_resource_id,
            direction,
            protocol,
            local_port,
            remote_port,
            local_ip_address,
            remote_ip_address,
            target_nic_resource_id: None,
        }
    }
}
pub mod verification_ip_flow_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Protocol {
        #[serde(rename = "TCP")]
        Tcp,
        #[serde(rename = "UDP")]
        Udp,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VerificationIpFlowResult {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub access: Option<Access>,
    #[serde(rename = "ruleName", default, skip_serializing_if = "Option::is_none")]
    pub rule_name: Option<String>,
}
impl VerificationIpFlowResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplianceNicProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
}
impl VirtualApplianceNicProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplianceSite {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualApplianceSiteProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VirtualApplianceSite {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplianceSiteProperties {
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "o365Policy", default, skip_serializing_if = "Option::is_none")]
    pub o365_policy: Option<Office365PolicyProperties>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualApplianceSiteProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualApplianceSkuProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
    #[serde(rename = "bundledScaleUnit", default, skip_serializing_if = "Option::is_none")]
    pub bundled_scale_unit: Option<String>,
    #[serde(rename = "marketPlaceVersion", default, skip_serializing_if = "Option::is_none")]
    pub market_place_version: Option<String>,
}
impl VirtualApplianceSkuProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualHub {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualHubProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualHub {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubEffectiveRoute {
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[serde(rename = "nextHops", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hops: Vec<String>,
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<String>,
    #[serde(rename = "asPath", default, skip_serializing_if = "Option::is_none")]
    pub as_path: Option<String>,
    #[serde(rename = "routeOrigin", default, skip_serializing_if = "Option::is_none")]
    pub route_origin: Option<String>,
}
impl VirtualHubEffectiveRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubEffectiveRouteList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualHubEffectiveRoute>,
}
impl VirtualHubEffectiveRouteList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubId {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl VirtualHubId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubProperties {
    #[serde(rename = "virtualWan", default, skip_serializing_if = "Option::is_none")]
    pub virtual_wan: Option<SubResource>,
    #[serde(rename = "vpnGateway", default, skip_serializing_if = "Option::is_none")]
    pub vpn_gateway: Option<SubResource>,
    #[serde(rename = "p2SVpnGateway", default, skip_serializing_if = "Option::is_none")]
    pub p2_s_vpn_gateway: Option<SubResource>,
    #[serde(rename = "expressRouteGateway", default, skip_serializing_if = "Option::is_none")]
    pub express_route_gateway: Option<SubResource>,
    #[serde(rename = "azureFirewall", default, skip_serializing_if = "Option::is_none")]
    pub azure_firewall: Option<SubResource>,
    #[serde(rename = "securityPartnerProvider", default, skip_serializing_if = "Option::is_none")]
    pub security_partner_provider: Option<SubResource>,
    #[serde(rename = "addressPrefix", default, skip_serializing_if = "Option::is_none")]
    pub address_prefix: Option<String>,
    #[serde(rename = "routeTable", default, skip_serializing_if = "Option::is_none")]
    pub route_table: Option<VirtualHubRouteTable>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "securityProviderName", default, skip_serializing_if = "Option::is_none")]
    pub security_provider_name: Option<String>,
    #[serde(rename = "virtualHubRouteTableV2s", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_hub_route_table_v2s: Vec<VirtualHubRouteTableV2>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[serde(rename = "routingState", default, skip_serializing_if = "Option::is_none")]
    pub routing_state: Option<RoutingState>,
    #[serde(rename = "bgpConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub bgp_connections: Vec<SubResource>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<SubResource>,
    #[serde(rename = "virtualRouterAsn", default, skip_serializing_if = "Option::is_none")]
    pub virtual_router_asn: Option<i64>,
    #[serde(rename = "virtualRouterIps", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_router_ips: Vec<String>,
    #[serde(rename = "enableVirtualRouterRoutePropogation", default, skip_serializing_if = "Option::is_none")]
    pub enable_virtual_router_route_propogation: Option<bool>,
}
impl VirtualHubProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRoute {
    #[serde(rename = "addressPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub address_prefixes: Vec<String>,
    #[serde(rename = "nextHopIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_ip_address: Option<String>,
}
impl VirtualHubRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRouteTable {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<VirtualHubRoute>,
}
impl VirtualHubRouteTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRouteTableV2 {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualHubRouteTableV2Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualHubRouteTableV2 {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRouteTableV2Properties {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub routes: Vec<VirtualHubRouteV2>,
    #[serde(rename = "attachedConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub attached_connections: Vec<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualHubRouteTableV2Properties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualHubRouteV2 {
    #[serde(rename = "destinationType", default, skip_serializing_if = "Option::is_none")]
    pub destination_type: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub destinations: Vec<String>,
    #[serde(rename = "nextHopType", default, skip_serializing_if = "Option::is_none")]
    pub next_hop_type: Option<String>,
    #[serde(rename = "nextHops", default, skip_serializing_if = "Vec::is_empty")]
    pub next_hops: Vec<String>,
}
impl VirtualHubRouteV2 {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetwork {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetwork {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkBgpCommunities {
    #[serde(rename = "virtualNetworkCommunity")]
    pub virtual_network_community: String,
    #[serde(rename = "regionalCommunity", default, skip_serializing_if = "Option::is_none")]
    pub regional_community: Option<String>,
}
impl VirtualNetworkBgpCommunities {
    pub fn new(virtual_network_community: String) -> Self {
        Self {
            virtual_network_community,
            regional_community: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkConnectionGatewayReference {
    pub id: String,
}
impl VirtualNetworkConnectionGatewayReference {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGateway {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: VirtualNetworkGatewayPropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGateway {
    pub fn new(properties: VirtualNetworkGatewayPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnection {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: VirtualNetworkGatewayConnectionPropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayConnection {
    pub fn new(properties: VirtualNetworkGatewayConnectionPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionListEntity {
    #[serde(flatten)]
    pub resource: Resource,
    pub properties: VirtualNetworkGatewayConnectionListEntityPropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayConnectionListEntity {
    pub fn new(properties: VirtualNetworkGatewayConnectionListEntityPropertiesFormat) -> Self {
        Self {
            resource: Resource::default(),
            properties,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionListEntityPropertiesFormat {
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[serde(rename = "virtualNetworkGateway1")]
    pub virtual_network_gateway1: VirtualNetworkConnectionGatewayReference,
    #[serde(rename = "virtualNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway2: Option<VirtualNetworkConnectionGatewayReference>,
    #[serde(rename = "localNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub local_network_gateway2: Option<VirtualNetworkConnectionGatewayReference>,
    #[serde(rename = "connectionType")]
    pub connection_type: VirtualNetworkGatewayConnectionType,
    #[serde(rename = "connectionProtocol", default, skip_serializing_if = "Option::is_none")]
    pub connection_protocol: Option<ConnectionProtocol>,
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VirtualNetworkGatewayConnectionStatus>,
    #[serde(rename = "tunnelConnectionStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_connection_status: Vec<TunnelConnectionHealth>,
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub peer: Option<SubResource>,
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[serde(rename = "trafficSelectorPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub traffic_selector_policies: Vec<TrafficSelectorPolicy>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "expressRouteGatewayBypass", default, skip_serializing_if = "Option::is_none")]
    pub express_route_gateway_bypass: Option<bool>,
}
impl VirtualNetworkGatewayConnectionListEntityPropertiesFormat {
    pub fn new(
        virtual_network_gateway1: VirtualNetworkConnectionGatewayReference,
        connection_type: VirtualNetworkGatewayConnectionType,
    ) -> Self {
        Self {
            authorization_key: None,
            virtual_network_gateway1,
            virtual_network_gateway2: None,
            local_network_gateway2: None,
            connection_type,
            connection_protocol: None,
            routing_weight: None,
            shared_key: None,
            connection_status: None,
            tunnel_connection_status: Vec::new(),
            egress_bytes_transferred: None,
            ingress_bytes_transferred: None,
            peer: None,
            enable_bgp: None,
            use_policy_based_traffic_selectors: None,
            ipsec_policies: Vec::new(),
            traffic_selector_policies: Vec::new(),
            resource_guid: None,
            provisioning_state: None,
            express_route_gateway_bypass: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayConnectionListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayConnection>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayConnectionListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualNetworkGatewayConnectionPropertiesFormat {
    #[serde(rename = "authorizationKey", default, skip_serializing_if = "Option::is_none")]
    pub authorization_key: Option<String>,
    #[serde(rename = "virtualNetworkGateway1")]
    pub virtual_network_gateway1: VirtualNetworkGateway,
    #[serde(rename = "virtualNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_gateway2: Option<VirtualNetworkGateway>,
    #[serde(rename = "localNetworkGateway2", default, skip_serializing_if = "Option::is_none")]
    pub local_network_gateway2: Option<LocalNetworkGateway>,
    #[serde(rename = "connectionType")]
    pub connection_type: VirtualNetworkGatewayConnectionType,
    #[serde(rename = "connectionProtocol", default, skip_serializing_if = "Option::is_none")]
    pub connection_protocol: Option<ConnectionProtocol>,
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[serde(rename = "dpdTimeoutSeconds", default, skip_serializing_if = "Option::is_none")]
    pub dpd_timeout_seconds: Option<i32>,
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VirtualNetworkGatewayConnectionStatus>,
    #[serde(rename = "tunnelConnectionStatus", default, skip_serializing_if = "Vec::is_empty")]
    pub tunnel_connection_status: Vec<TunnelConnectionHealth>,
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub peer: Option<SubResource>,
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[serde(rename = "useLocalAzureIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub use_local_azure_ip_address: Option<bool>,
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[serde(rename = "trafficSelectorPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub traffic_selector_policies: Vec<TrafficSelectorPolicy>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "expressRouteGatewayBypass", default, skip_serializing_if = "Option::is_none")]
    pub express_route_gateway_bypass: Option<bool>,
}
impl VirtualNetworkGatewayConnectionPropertiesFormat {
    pub fn new(virtual_network_gateway1: VirtualNetworkGateway, connection_type: VirtualNetworkGatewayConnectionType) -> Self {
        Self {
            authorization_key: None,
            virtual_network_gateway1,
            virtual_network_gateway2: None,
            local_network_gateway2: None,
            connection_type,
            connection_protocol: None,
            routing_weight: None,
            dpd_timeout_seconds: None,
            shared_key: None,
            connection_status: None,
            tunnel_connection_status: Vec::new(),
            egress_bytes_transferred: None,
            ingress_bytes_transferred: None,
            peer: None,
            enable_bgp: None,
            use_local_azure_ip_address: None,
            use_policy_based_traffic_selectors: None,
            ipsec_policies: Vec::new(),
            traffic_selector_policies: Vec::new(),
            resource_guid: None,
            provisioning_state: None,
            express_route_gateway_bypass: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum VirtualNetworkGatewayConnectionStatus {
    Unknown,
    Connecting,
    Connected,
    NotConnected,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum VirtualNetworkGatewayConnectionType {
    IPsec,
    Vnet2Vnet,
    ExpressRoute,
    #[serde(rename = "VPNClient")]
    VpnClient,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfiguration {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkGatewayIpConfigurationPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    #[serde(rename = "privateIPAllocationMethod", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_allocation_method: Option<IpAllocationMethod>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<SubResource>,
    #[serde(rename = "publicIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<SubResource>,
    #[serde(rename = "privateIPAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualNetworkGatewayIpConfigurationPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayListConnectionsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGatewayConnectionListEntity>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayListConnectionsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkGateway>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkGatewayListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewayPropertiesFormat {
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<VirtualNetworkGatewayIpConfiguration>,
    #[serde(rename = "gatewayType", default, skip_serializing_if = "Option::is_none")]
    pub gateway_type: Option<virtual_network_gateway_properties_format::GatewayType>,
    #[serde(rename = "vpnType", default, skip_serializing_if = "Option::is_none")]
    pub vpn_type: Option<virtual_network_gateway_properties_format::VpnType>,
    #[serde(rename = "vpnGatewayGeneration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_gateway_generation: Option<virtual_network_gateway_properties_format::VpnGatewayGeneration>,
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[serde(rename = "enablePrivateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub enable_private_ip_address: Option<bool>,
    #[serde(rename = "activeActive", default, skip_serializing_if = "Option::is_none")]
    pub active_active: Option<bool>,
    #[serde(rename = "gatewayDefaultSite", default, skip_serializing_if = "Option::is_none")]
    pub gateway_default_site: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<VirtualNetworkGatewaySku>,
    #[serde(rename = "vpnClientConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_configuration: Option<VpnClientConfiguration>,
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[serde(rename = "customRoutes", default, skip_serializing_if = "Option::is_none")]
    pub custom_routes: Option<AddressSpace>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "enableDnsForwarding", default, skip_serializing_if = "Option::is_none")]
    pub enable_dns_forwarding: Option<bool>,
    #[serde(rename = "inboundDnsForwardingEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub inbound_dns_forwarding_endpoint: Option<String>,
}
impl VirtualNetworkGatewayPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum GatewayType {
        Vpn,
        ExpressRoute,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VpnType {
        PolicyBased,
        RouteBased,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum VpnGatewayGeneration {
        None,
        Generation1,
        Generation2,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkGatewaySku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<virtual_network_gateway_sku::Name>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<virtual_network_gateway_sku::Tier>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl VirtualNetworkGatewaySku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_gateway_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Name {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
        VpnGw4,
        VpnGw5,
        #[serde(rename = "VpnGw1AZ")]
        VpnGw1Az,
        #[serde(rename = "VpnGw2AZ")]
        VpnGw2Az,
        #[serde(rename = "VpnGw3AZ")]
        VpnGw3Az,
        #[serde(rename = "VpnGw4AZ")]
        VpnGw4Az,
        #[serde(rename = "VpnGw5AZ")]
        VpnGw5Az,
        #[serde(rename = "ErGw1AZ")]
        ErGw1Az,
        #[serde(rename = "ErGw2AZ")]
        ErGw2Az,
        #[serde(rename = "ErGw3AZ")]
        ErGw3Az,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Tier {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
        VpnGw4,
        VpnGw5,
        #[serde(rename = "VpnGw1AZ")]
        VpnGw1Az,
        #[serde(rename = "VpnGw2AZ")]
        VpnGw2Az,
        #[serde(rename = "VpnGw3AZ")]
        VpnGw3Az,
        #[serde(rename = "VpnGw4AZ")]
        VpnGw4Az,
        #[serde(rename = "VpnGw5AZ")]
        VpnGw5Az,
        #[serde(rename = "ErGw1AZ")]
        ErGw1Az,
        #[serde(rename = "ErGw2AZ")]
        ErGw2Az,
        #[serde(rename = "ErGw3AZ")]
        ErGw3Az,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetwork>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkListUsageResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkUsage>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkListUsageResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkPeeringPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkPeering>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPeeringPropertiesFormat {
    #[serde(rename = "allowVirtualNetworkAccess", default, skip_serializing_if = "Option::is_none")]
    pub allow_virtual_network_access: Option<bool>,
    #[serde(rename = "allowForwardedTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_forwarded_traffic: Option<bool>,
    #[serde(rename = "allowGatewayTransit", default, skip_serializing_if = "Option::is_none")]
    pub allow_gateway_transit: Option<bool>,
    #[serde(rename = "useRemoteGateways", default, skip_serializing_if = "Option::is_none")]
    pub use_remote_gateways: Option<bool>,
    #[serde(rename = "remoteVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub remote_virtual_network: Option<SubResource>,
    #[serde(rename = "remoteAddressSpace", default, skip_serializing_if = "Option::is_none")]
    pub remote_address_space: Option<AddressSpace>,
    #[serde(rename = "remoteBgpCommunities", default, skip_serializing_if = "Option::is_none")]
    pub remote_bgp_communities: Option<VirtualNetworkBgpCommunities>,
    #[serde(rename = "peeringState", default, skip_serializing_if = "Option::is_none")]
    pub peering_state: Option<virtual_network_peering_properties_format::PeeringState>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualNetworkPeeringPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod virtual_network_peering_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PeeringState {
        Initiated,
        Connected,
        Disconnected,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkPropertiesFormat {
    #[serde(rename = "addressSpace", default, skip_serializing_if = "Option::is_none")]
    pub address_space: Option<AddressSpace>,
    #[serde(rename = "dhcpOptions", default, skip_serializing_if = "Option::is_none")]
    pub dhcp_options: Option<DhcpOptions>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub subnets: Vec<Subnet>,
    #[serde(rename = "virtualNetworkPeerings", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_network_peerings: Vec<VirtualNetworkPeering>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "enableDdosProtection", default, skip_serializing_if = "Option::is_none")]
    pub enable_ddos_protection: Option<bool>,
    #[serde(rename = "enableVmProtection", default, skip_serializing_if = "Option::is_none")]
    pub enable_vm_protection: Option<bool>,
    #[serde(rename = "ddosProtectionPlan", default, skip_serializing_if = "Option::is_none")]
    pub ddos_protection_plan: Option<SubResource>,
    #[serde(rename = "bgpCommunities", default, skip_serializing_if = "Option::is_none")]
    pub bgp_communities: Option<VirtualNetworkBgpCommunities>,
    #[serde(rename = "ipAllocations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_allocations: Vec<SubResource>,
}
impl VirtualNetworkPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkTap {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualNetworkTapPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualNetworkTap {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkTapListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualNetworkTap>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualNetworkTapListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkTapPropertiesFormat {
    #[serde(rename = "networkInterfaceTapConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub network_interface_tap_configurations: Vec<NetworkInterfaceTapConfiguration>,
    #[serde(rename = "resourceGuid", default, skip_serializing_if = "Option::is_none")]
    pub resource_guid: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(
        rename = "destinationNetworkInterfaceIPConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub destination_network_interface_ip_configuration: Option<NetworkInterfaceIpConfiguration>,
    #[serde(
        rename = "destinationLoadBalancerFrontEndIPConfiguration",
        default,
        skip_serializing_if = "Option::is_none"
    )]
    pub destination_load_balancer_front_end_ip_configuration: Option<FrontendIpConfiguration>,
    #[serde(rename = "destinationPort", default, skip_serializing_if = "Option::is_none")]
    pub destination_port: Option<i64>,
}
impl VirtualNetworkTapPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkUsage {
    #[serde(rename = "currentValue", default, skip_serializing_if = "Option::is_none")]
    pub current_value: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<VirtualNetworkUsageName>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
}
impl VirtualNetworkUsage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkUsageName {
    #[serde(rename = "localizedValue", default, skip_serializing_if = "Option::is_none")]
    pub localized_value: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl VirtualNetworkUsageName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouter {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualRouterPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualRouter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualRouter>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualRouterListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterPeering {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualRouterPeeringProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VirtualRouterPeering {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterPeeringListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VirtualRouterPeering>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl VirtualRouterPeeringListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterPeeringProperties {
    #[serde(rename = "peerAsn", default, skip_serializing_if = "Option::is_none")]
    pub peer_asn: Option<i64>,
    #[serde(rename = "peerIp", default, skip_serializing_if = "Option::is_none")]
    pub peer_ip: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualRouterPeeringProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualRouterPropertiesFormat {
    #[serde(rename = "virtualRouterAsn", default, skip_serializing_if = "Option::is_none")]
    pub virtual_router_asn: Option<i64>,
    #[serde(rename = "virtualRouterIps", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_router_ips: Vec<String>,
    #[serde(rename = "hostedSubnet", default, skip_serializing_if = "Option::is_none")]
    pub hosted_subnet: Option<SubResource>,
    #[serde(rename = "hostedGateway", default, skip_serializing_if = "Option::is_none")]
    pub hosted_gateway: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub peerings: Vec<SubResource>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VirtualRouterPropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualWan {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VirtualWanProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VirtualWan {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualWanProperties {
    #[serde(rename = "disableVpnEncryption", default, skip_serializing_if = "Option::is_none")]
    pub disable_vpn_encryption: Option<bool>,
    #[serde(rename = "virtualHubs", default, skip_serializing_if = "Vec::is_empty")]
    pub virtual_hubs: Vec<SubResource>,
    #[serde(rename = "vpnSites", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_sites: Vec<SubResource>,
    #[serde(rename = "allowBranchToBranchTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_branch_to_branch_traffic: Option<bool>,
    #[serde(rename = "allowVnetToVnetTraffic", default, skip_serializing_if = "Option::is_none")]
    pub allow_vnet_to_vnet_traffic: Option<bool>,
    #[serde(rename = "office365LocalBreakoutCategory", default, skip_serializing_if = "Option::is_none")]
    pub office365_local_breakout_category: Option<OfficeTrafficCategory>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VirtualWanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualWanSecurityProvider {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<VirtualWanSecurityProviderType>,
}
impl VirtualWanSecurityProvider {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum VirtualWanSecurityProviderType {
    External,
    Native,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualWanSecurityProviders {
    #[serde(rename = "supportedProviders", default, skip_serializing_if = "Vec::is_empty")]
    pub supported_providers: Vec<VirtualWanSecurityProvider>,
}
impl VirtualWanSecurityProviders {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualWanVpnProfileParameters {
    #[serde(rename = "vpnServerConfigurationResourceId", default, skip_serializing_if = "Option::is_none")]
    pub vpn_server_configuration_resource_id: Option<String>,
    #[serde(rename = "authenticationMethod", default, skip_serializing_if = "Option::is_none")]
    pub authentication_method: Option<AuthenticationMethod>,
}
impl VirtualWanVpnProfileParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VnetRoute {
    #[serde(rename = "staticRoutes", default, skip_serializing_if = "Vec::is_empty")]
    pub static_routes: Vec<StaticRoute>,
}
impl VnetRoute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConfiguration {
    #[serde(rename = "vpnClientAddressPool", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_address_pool: Option<AddressSpace>,
    #[serde(rename = "vpnClientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_root_certificates: Vec<VpnClientRootCertificate>,
    #[serde(rename = "vpnClientRevokedCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_revoked_certificates: Vec<VpnClientRevokedCertificate>,
    #[serde(rename = "vpnClientProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_protocols: Vec<String>,
    #[serde(rename = "vpnClientIpsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_ipsec_policies: Vec<IpsecPolicy>,
    #[serde(rename = "radiusServerAddress", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_address: Option<String>,
    #[serde(rename = "radiusServerSecret", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_secret: Option<String>,
    #[serde(rename = "radiusServers", default, skip_serializing_if = "Vec::is_empty")]
    pub radius_servers: Vec<RadiusServer>,
    #[serde(rename = "aadTenant", default, skip_serializing_if = "Option::is_none")]
    pub aad_tenant: Option<String>,
    #[serde(rename = "aadAudience", default, skip_serializing_if = "Option::is_none")]
    pub aad_audience: Option<String>,
    #[serde(rename = "aadIssuer", default, skip_serializing_if = "Option::is_none")]
    pub aad_issuer: Option<String>,
}
impl VpnClientConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConnectionHealth {
    #[serde(rename = "totalIngressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub total_ingress_bytes_transferred: Option<i64>,
    #[serde(rename = "totalEgressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub total_egress_bytes_transferred: Option<i64>,
    #[serde(rename = "vpnClientConnectionsCount", default, skip_serializing_if = "Option::is_none")]
    pub vpn_client_connections_count: Option<i32>,
    #[serde(rename = "allocatedIpAddresses", default, skip_serializing_if = "Vec::is_empty")]
    pub allocated_ip_addresses: Vec<String>,
}
impl VpnClientConnectionHealth {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConnectionHealthDetail {
    #[serde(rename = "vpnConnectionId", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_id: Option<String>,
    #[serde(rename = "vpnConnectionDuration", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_duration: Option<i64>,
    #[serde(rename = "vpnConnectionTime", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_time: Option<String>,
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
    #[serde(rename = "vpnUserName", default, skip_serializing_if = "Option::is_none")]
    pub vpn_user_name: Option<String>,
    #[serde(rename = "maxBandwidth", default, skip_serializing_if = "Option::is_none")]
    pub max_bandwidth: Option<i64>,
    #[serde(rename = "egressPacketsTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_packets_transferred: Option<i64>,
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[serde(rename = "ingressPacketsTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_packets_transferred: Option<i64>,
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(rename = "maxPacketsPerSecond", default, skip_serializing_if = "Option::is_none")]
    pub max_packets_per_second: Option<i64>,
}
impl VpnClientConnectionHealthDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientConnectionHealthDetailListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<VpnClientConnectionHealthDetail>,
}
impl VpnClientConnectionHealthDetailListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientIPsecParameters {
    #[serde(rename = "saLifeTimeSeconds")]
    pub sa_life_time_seconds: i32,
    #[serde(rename = "saDataSizeKilobytes")]
    pub sa_data_size_kilobytes: i32,
    #[serde(rename = "ipsecEncryption")]
    pub ipsec_encryption: IpsecEncryption,
    #[serde(rename = "ipsecIntegrity")]
    pub ipsec_integrity: IpsecIntegrity,
    #[serde(rename = "ikeEncryption")]
    pub ike_encryption: IkeEncryption,
    #[serde(rename = "ikeIntegrity")]
    pub ike_integrity: IkeIntegrity,
    #[serde(rename = "dhGroup")]
    pub dh_group: DhGroup,
    #[serde(rename = "pfsGroup")]
    pub pfs_group: PfsGroup,
}
impl VpnClientIPsecParameters {
    pub fn new(
        sa_life_time_seconds: i32,
        sa_data_size_kilobytes: i32,
        ipsec_encryption: IpsecEncryption,
        ipsec_integrity: IpsecIntegrity,
        ike_encryption: IkeEncryption,
        ike_integrity: IkeIntegrity,
        dh_group: DhGroup,
        pfs_group: PfsGroup,
    ) -> Self {
        Self {
            sa_life_time_seconds,
            sa_data_size_kilobytes,
            ipsec_encryption,
            ipsec_integrity,
            ike_encryption,
            ike_integrity,
            dh_group,
            pfs_group,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientParameters {
    #[serde(rename = "processorArchitecture", default, skip_serializing_if = "Option::is_none")]
    pub processor_architecture: Option<vpn_client_parameters::ProcessorArchitecture>,
    #[serde(rename = "authenticationMethod", default, skip_serializing_if = "Option::is_none")]
    pub authentication_method: Option<AuthenticationMethod>,
    #[serde(rename = "radiusServerAuthCertificate", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_auth_certificate: Option<String>,
    #[serde(rename = "clientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub client_root_certificates: Vec<String>,
}
impl VpnClientParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod vpn_client_parameters {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProcessorArchitecture {
        Amd64,
        X86,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnClientRevokedCertificatePropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRevokedCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnClientRevokedCertificatePropertiesFormat {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VpnClientRevokedCertificatePropertiesFormat {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientRootCertificate {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    pub properties: VpnClientRootCertificatePropertiesFormat,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnClientRootCertificate {
    pub fn new(properties: VpnClientRootCertificatePropertiesFormat) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
            name: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnClientRootCertificatePropertiesFormat {
    #[serde(rename = "publicCertData")]
    pub public_cert_data: String,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VpnClientRootCertificatePropertiesFormat {
    pub fn new(public_cert_data: String) -> Self {
        Self {
            public_cert_data,
            provisioning_state: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnConnectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnConnectionPacketCaptureStartParameters {
    #[serde(rename = "filterData", default, skip_serializing_if = "Option::is_none")]
    pub filter_data: Option<String>,
    #[serde(rename = "linkConnectionNames", default, skip_serializing_if = "Vec::is_empty")]
    pub link_connection_names: Vec<String>,
}
impl VpnConnectionPacketCaptureStartParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnConnectionPacketCaptureStopParameters {
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
    #[serde(rename = "linkConnectionNames", default, skip_serializing_if = "Vec::is_empty")]
    pub link_connection_names: Vec<String>,
}
impl VpnConnectionPacketCaptureStopParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnConnectionProperties {
    #[serde(rename = "remoteVpnSite", default, skip_serializing_if = "Option::is_none")]
    pub remote_vpn_site: Option<SubResource>,
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[serde(rename = "dpdTimeoutSeconds", default, skip_serializing_if = "Option::is_none")]
    pub dpd_timeout_seconds: Option<i32>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VpnConnectionStatus>,
    #[serde(rename = "vpnConnectionProtocolType", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_protocol_type: Option<ConnectionProtocol>,
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[serde(rename = "connectionBandwidth", default, skip_serializing_if = "Option::is_none")]
    pub connection_bandwidth: Option<i32>,
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[serde(rename = "enableRateLimiting", default, skip_serializing_if = "Option::is_none")]
    pub enable_rate_limiting: Option<bool>,
    #[serde(rename = "enableInternetSecurity", default, skip_serializing_if = "Option::is_none")]
    pub enable_internet_security: Option<bool>,
    #[serde(rename = "useLocalAzureIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub use_local_azure_ip_address: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "vpnLinkConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_link_connections: Vec<VpnSiteLinkConnection>,
    #[serde(rename = "routingConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub routing_configuration: Option<RoutingConfiguration>,
}
impl VpnConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum VpnConnectionStatus {
    Unknown,
    Connecting,
    Connected,
    NotConnected,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnDeviceScriptParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
    #[serde(rename = "deviceFamily", default, skip_serializing_if = "Option::is_none")]
    pub device_family: Option<String>,
    #[serde(rename = "firmwareVersion", default, skip_serializing_if = "Option::is_none")]
    pub firmware_version: Option<String>,
}
impl VpnDeviceScriptParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnGateway {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnGatewayProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnGateway {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayIpConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "publicIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub public_ip_address: Option<String>,
    #[serde(rename = "privateIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub private_ip_address: Option<String>,
}
impl VpnGatewayIpConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayPacketCaptureStartParameters {
    #[serde(rename = "filterData", default, skip_serializing_if = "Option::is_none")]
    pub filter_data: Option<String>,
}
impl VpnGatewayPacketCaptureStartParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayPacketCaptureStopParameters {
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
}
impl VpnGatewayPacketCaptureStopParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnGatewayProperties {
    #[serde(rename = "virtualHub", default, skip_serializing_if = "Option::is_none")]
    pub virtual_hub: Option<SubResource>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub connections: Vec<VpnConnection>,
    #[serde(rename = "bgpSettings", default, skip_serializing_if = "Option::is_none")]
    pub bgp_settings: Option<BgpSettings>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "vpnGatewayScaleUnit", default, skip_serializing_if = "Option::is_none")]
    pub vpn_gateway_scale_unit: Option<i32>,
    #[serde(rename = "ipConfigurations", default, skip_serializing_if = "Vec::is_empty")]
    pub ip_configurations: Vec<VpnGatewayIpConfiguration>,
}
impl VpnGatewayProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnLinkBgpSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub asn: Option<i64>,
    #[serde(rename = "bgpPeeringAddress", default, skip_serializing_if = "Option::is_none")]
    pub bgp_peering_address: Option<String>,
}
impl VpnLinkBgpSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnLinkProviderProperties {
    #[serde(rename = "linkProviderName", default, skip_serializing_if = "Option::is_none")]
    pub link_provider_name: Option<String>,
    #[serde(rename = "linkSpeedInMbps", default, skip_serializing_if = "Option::is_none")]
    pub link_speed_in_mbps: Option<i32>,
}
impl VpnLinkProviderProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnPacketCaptureStartParameters {
    #[serde(rename = "filterData", default, skip_serializing_if = "Option::is_none")]
    pub filter_data: Option<String>,
}
impl VpnPacketCaptureStartParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnPacketCaptureStopParameters {
    #[serde(rename = "sasUrl", default, skip_serializing_if = "Option::is_none")]
    pub sas_url: Option<String>,
}
impl VpnPacketCaptureStopParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnProfileResponse {
    #[serde(rename = "profileUrl", default, skip_serializing_if = "Option::is_none")]
    pub profile_url: Option<String>,
}
impl VpnProfileResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigRadiusClientRootCertificate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
}
impl VpnServerConfigRadiusClientRootCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigRadiusServerRootCertificate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "publicCertData", default, skip_serializing_if = "Option::is_none")]
    pub public_cert_data: Option<String>,
}
impl VpnServerConfigRadiusServerRootCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigVpnClientRevokedCertificate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
}
impl VpnServerConfigVpnClientRevokedCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigVpnClientRootCertificate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "publicCertData", default, skip_serializing_if = "Option::is_none")]
    pub public_cert_data: Option<String>,
}
impl VpnServerConfigVpnClientRootCertificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfiguration {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnServerConfigurationProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnServerConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigurationProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "vpnProtocols", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_protocols: Vec<String>,
    #[serde(rename = "vpnAuthenticationTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_authentication_types: Vec<String>,
    #[serde(rename = "vpnClientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_root_certificates: Vec<VpnServerConfigVpnClientRootCertificate>,
    #[serde(rename = "vpnClientRevokedCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_revoked_certificates: Vec<VpnServerConfigVpnClientRevokedCertificate>,
    #[serde(rename = "radiusServerRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub radius_server_root_certificates: Vec<VpnServerConfigRadiusServerRootCertificate>,
    #[serde(rename = "radiusClientRootCertificates", default, skip_serializing_if = "Vec::is_empty")]
    pub radius_client_root_certificates: Vec<VpnServerConfigRadiusClientRootCertificate>,
    #[serde(rename = "vpnClientIpsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_client_ipsec_policies: Vec<IpsecPolicy>,
    #[serde(rename = "radiusServerAddress", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_address: Option<String>,
    #[serde(rename = "radiusServerSecret", default, skip_serializing_if = "Option::is_none")]
    pub radius_server_secret: Option<String>,
    #[serde(rename = "radiusServers", default, skip_serializing_if = "Vec::is_empty")]
    pub radius_servers: Vec<RadiusServer>,
    #[serde(rename = "aadAuthenticationParameters", default, skip_serializing_if = "Option::is_none")]
    pub aad_authentication_parameters: Option<AadAuthenticationParameters>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "p2SVpnGateways", default, skip_serializing_if = "Vec::is_empty")]
    pub p2_s_vpn_gateways: Vec<P2sVpnGateway>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnServerConfigurationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnServerConfigurationsResponse {
    #[serde(rename = "vpnServerConfigurationResourceIds", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_server_configuration_resource_ids: Vec<String>,
}
impl VpnServerConfigurationsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VpnSite {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnSiteProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl VpnSite {
    pub fn new() -> Self {
        Self {
            resource: Resource::default(),
            properties: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteId {
    #[serde(rename = "vpnSite", default, skip_serializing_if = "Option::is_none")]
    pub vpn_site: Option<String>,
}
impl VpnSiteId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteLink {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnSiteLinkProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VpnSiteLink {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteLinkConnection {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VpnSiteLinkConnectionProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl VpnSiteLinkConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteLinkConnectionProperties {
    #[serde(rename = "vpnSiteLink", default, skip_serializing_if = "Option::is_none")]
    pub vpn_site_link: Option<SubResource>,
    #[serde(rename = "routingWeight", default, skip_serializing_if = "Option::is_none")]
    pub routing_weight: Option<i32>,
    #[serde(rename = "connectionStatus", default, skip_serializing_if = "Option::is_none")]
    pub connection_status: Option<VpnConnectionStatus>,
    #[serde(rename = "vpnConnectionProtocolType", default, skip_serializing_if = "Option::is_none")]
    pub vpn_connection_protocol_type: Option<ConnectionProtocol>,
    #[serde(rename = "ingressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub ingress_bytes_transferred: Option<i64>,
    #[serde(rename = "egressBytesTransferred", default, skip_serializing_if = "Option::is_none")]
    pub egress_bytes_transferred: Option<i64>,
    #[serde(rename = "connectionBandwidth", default, skip_serializing_if = "Option::is_none")]
    pub connection_bandwidth: Option<i32>,
    #[serde(rename = "sharedKey", default, skip_serializing_if = "Option::is_none")]
    pub shared_key: Option<String>,
    #[serde(rename = "enableBgp", default, skip_serializing_if = "Option::is_none")]
    pub enable_bgp: Option<bool>,
    #[serde(rename = "usePolicyBasedTrafficSelectors", default, skip_serializing_if = "Option::is_none")]
    pub use_policy_based_traffic_selectors: Option<bool>,
    #[serde(rename = "ipsecPolicies", default, skip_serializing_if = "Vec::is_empty")]
    pub ipsec_policies: Vec<IpsecPolicy>,
    #[serde(rename = "enableRateLimiting", default, skip_serializing_if = "Option::is_none")]
    pub enable_rate_limiting: Option<bool>,
    #[serde(rename = "useLocalAzureIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub use_local_azure_ip_address: Option<bool>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VpnSiteLinkConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteLinkProperties {
    #[serde(rename = "linkProperties", default, skip_serializing_if = "Option::is_none")]
    pub link_properties: Option<VpnLinkProviderProperties>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fqdn: Option<String>,
    #[serde(rename = "bgpProperties", default, skip_serializing_if = "Option::is_none")]
    pub bgp_properties: Option<VpnLinkBgpSettings>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
}
impl VpnSiteLinkProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VpnSiteProperties {
    #[serde(rename = "virtualWan", default, skip_serializing_if = "Option::is_none")]
    pub virtual_wan: Option<SubResource>,
    #[serde(rename = "deviceProperties", default, skip_serializing_if = "Option::is_none")]
    pub device_properties: Option<DeviceProperties>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "siteKey", default, skip_serializing_if = "Option::is_none")]
    pub site_key: Option<String>,
    #[serde(rename = "addressSpace", default, skip_serializing_if = "Option::is_none")]
    pub address_space: Option<AddressSpace>,
    #[serde(rename = "bgpProperties", default, skip_serializing_if = "Option::is_none")]
    pub bgp_properties: Option<BgpSettings>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "isSecuritySite", default, skip_serializing_if = "Option::is_none")]
    pub is_security_site: Option<bool>,
    #[serde(rename = "vpnSiteLinks", default, skip_serializing_if = "Vec::is_empty")]
    pub vpn_site_links: Vec<VpnSiteLink>,
    #[serde(rename = "o365Policy", default, skip_serializing_if = "Option::is_none")]
    pub o365_policy: Option<O365PolicyProperties>,
}
impl VpnSiteProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebApplicationFirewallCustomRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    pub priority: i64,
    #[serde(rename = "ruleType")]
    pub rule_type: web_application_firewall_custom_rule::RuleType,
    #[serde(rename = "matchConditions")]
    pub match_conditions: Vec<MatchCondition>,
    pub action: web_application_firewall_custom_rule::Action,
}
impl WebApplicationFirewallCustomRule {
    pub fn new(
        priority: i64,
        rule_type: web_application_firewall_custom_rule::RuleType,
        match_conditions: Vec<MatchCondition>,
        action: web_application_firewall_custom_rule::Action,
    ) -> Self {
        Self {
            name: None,
            etag: None,
            priority,
            rule_type,
            match_conditions,
            action,
        }
    }
}
pub mod web_application_firewall_custom_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleType {
        MatchRule,
        Invalid,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Allow,
        Block,
        Log,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebApplicationFirewallPolicy {
    #[serde(flatten)]
    pub resource: Resource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WebApplicationFirewallPolicyPropertiesFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl WebApplicationFirewallPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebApplicationFirewallPolicyListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<WebApplicationFirewallPolicy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl WebApplicationFirewallPolicyListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebApplicationFirewallPolicyPropertiesFormat {
    #[serde(rename = "policySettings", default, skip_serializing_if = "Option::is_none")]
    pub policy_settings: Option<PolicySettings>,
    #[serde(rename = "customRules", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_rules: Vec<WebApplicationFirewallCustomRule>,
    #[serde(rename = "applicationGateways", default, skip_serializing_if = "Vec::is_empty")]
    pub application_gateways: Vec<ApplicationGateway>,
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<ProvisioningState>,
    #[serde(rename = "resourceState", default, skip_serializing_if = "Option::is_none")]
    pub resource_state: Option<web_application_firewall_policy_properties_format::ResourceState>,
    #[serde(rename = "managedRules")]
    pub managed_rules: ManagedRulesDefinition,
    #[serde(rename = "httpListeners", default, skip_serializing_if = "Vec::is_empty")]
    pub http_listeners: Vec<SubResource>,
    #[serde(rename = "pathBasedRules", default, skip_serializing_if = "Vec::is_empty")]
    pub path_based_rules: Vec<SubResource>,
}
impl WebApplicationFirewallPolicyPropertiesFormat {
    pub fn new(managed_rules: ManagedRulesDefinition) -> Self {
        Self {
            policy_settings: None,
            custom_rules: Vec::new(),
            application_gateways: Vec::new(),
            provisioning_state: None,
            resource_state: None,
            managed_rules,
            http_listeners: Vec::new(),
            path_based_rules: Vec::new(),
        }
    }
}
pub mod web_application_firewall_policy_properties_format {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ResourceState {
        Creating,
        Enabling,
        Enabled,
        Disabling,
        Disabled,
        Deleting,
    }
}
