#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Dimension of blobs, possibly be blob type or access tier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Dimension {
    #[doc = "Display name of dimension."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Display name of dimension."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
}
impl Dimension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Metric specification of operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetricSpecification {
    #[doc = "Name of metric specification."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Display name of metric specification."]
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[doc = "Display description of metric specification."]
    #[serde(rename = "displayDescription", default, skip_serializing_if = "Option::is_none")]
    pub display_description: Option<String>,
    #[doc = "Unit could be Bytes or Count."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub unit: Option<String>,
    #[doc = "Dimensions of blobs, including blob type and access tier."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dimensions: Vec<Dimension>,
    #[doc = "Aggregation type could be Average."]
    #[serde(rename = "aggregationType", default, skip_serializing_if = "Option::is_none")]
    pub aggregation_type: Option<String>,
    #[doc = "The property to decide fill gap with zero or not."]
    #[serde(rename = "fillGapWithZero", default, skip_serializing_if = "Option::is_none")]
    pub fill_gap_with_zero: Option<bool>,
    #[doc = "The category this metric specification belong to, could be Capacity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    #[doc = "Account Resource Id."]
    #[serde(rename = "resourceIdDimensionNameOverride", default, skip_serializing_if = "Option::is_none")]
    pub resource_id_dimension_name_override: Option<String>,
}
impl MetricSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Microsoft.NetApp REST API operation definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Operation {
    #[doc = "Operation name: {provider}/{resource}/{operation}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Display metadata associated with the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub display: Option<operation::Display>,
    #[doc = "The origin of operations."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub origin: Option<String>,
    #[doc = "Properties of operation, include metric specifications."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<OperationProperties>,
}
impl Operation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation {
    use super::*;
    #[doc = "Display metadata associated with the operation."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Display {
        #[doc = "Service provider: Microsoft NetApp."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub provider: Option<String>,
        #[doc = "Resource on which the operation is performed etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub resource: Option<String>,
        #[doc = "Type of operation: get, read, delete, etc."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub operation: Option<String>,
        #[doc = "Operation description."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
    }
    impl Display {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Result of the request to list Cloud Volume operations. It contains a list of operations and a URL link to get the next set of results."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationListResult {
    #[doc = "List of Storage operations supported by the Storage resource provider."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Operation>,
}
impl OperationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of operation, include metric specifications."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationProperties {
    #[doc = "One property of operation, include metric specifications."]
    #[serde(rename = "serviceSpecification", default, skip_serializing_if = "Option::is_none")]
    pub service_specification: Option<ServiceSpecification>,
}
impl OperationProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information regarding availability of a resource name."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNameAvailability {
    #[doc = "<code>true</code> indicates name is valid and available. <code>false</code> indicates the name is invalid, unavailable, or both."]
    #[serde(rename = "isAvailable", default, skip_serializing_if = "Option::is_none")]
    pub is_available: Option<bool>,
    #[doc = "<code>Invalid</code> indicates the name provided does not match Azure App Service naming requirements. <code>AlreadyExists</code> indicates that the name is already in use and is therefore unavailable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub reason: Option<resource_name_availability::Reason>,
    #[doc = "If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that resource name is already in use, and direct them to select a different name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ResourceNameAvailability {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_name_availability {
    use super::*;
    #[doc = "<code>Invalid</code> indicates the name provided does not match Azure App Service naming requirements. <code>AlreadyExists</code> indicates that the name is already in use and is therefore unavailable."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Reason {
        Invalid,
        AlreadyExists,
    }
}
#[doc = "Resource name availability request content."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceNameAvailabilityRequest {
    #[doc = "Resource name to verify."]
    pub name: String,
    #[doc = "Resource type used for verification."]
    #[serde(rename = "type")]
    pub type_: resource_name_availability_request::Type,
    #[doc = "Resource group name."]
    #[serde(rename = "resourceGroup")]
    pub resource_group: String,
}
impl ResourceNameAvailabilityRequest {
    pub fn new(name: String, type_: resource_name_availability_request::Type, resource_group: String) -> Self {
        Self {
            name,
            type_,
            resource_group,
        }
    }
}
pub mod resource_name_availability_request {
    use super::*;
    #[doc = "Resource type used for verification."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "Microsoft.NetApp/netAppAccounts")]
        MicrosoftNetAppNetAppAccounts,
        #[serde(rename = "Microsoft.NetApp/netAppAccounts/capacityPools")]
        MicrosoftNetAppNetAppAccountsCapacityPools,
        #[serde(rename = "Microsoft.NetApp/netAppAccounts/capacityPools/volumes")]
        MicrosoftNetAppNetAppAccountsCapacityPoolsVolumes,
        #[serde(rename = "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots")]
        MicrosoftNetAppNetAppAccountsCapacityPoolsVolumesSnapshots,
    }
}
#[doc = "One property of operation, include metric specifications."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceSpecification {
    #[doc = "Metric specifications of operation."]
    #[serde(rename = "metricSpecifications", default, skip_serializing_if = "Vec::is_empty")]
    pub metric_specifications: Vec<MetricSpecification>,
}
impl ServiceSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NetApp account properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccountProperties {
    #[doc = "Azure lifecycle management"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Active Directories"]
    #[serde(rename = "activeDirectories", default, skip_serializing_if = "Vec::is_empty")]
    pub active_directories: Vec<ActiveDirectory>,
}
impl AccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Active Directory"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActiveDirectory {
    #[doc = "Id of the Active Directory"]
    #[serde(rename = "activeDirectoryId", default, skip_serializing_if = "Option::is_none")]
    pub active_directory_id: Option<String>,
    #[doc = "Username of Active Directory domain administrator"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "Plain text password of Active Directory domain administrator"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[doc = "Name of the Active Directory domain"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub domain: Option<String>,
    #[doc = "Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dns: Option<String>,
    #[doc = "Status of the Active Directory"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes"]
    #[serde(rename = "smbServerName", default, skip_serializing_if = "Option::is_none")]
    pub smb_server_name: Option<String>,
    #[doc = "The Organizational Unit (OU) within the Windows Active Directory"]
    #[serde(rename = "organizationalUnit", default, skip_serializing_if = "Option::is_none")]
    pub organizational_unit: Option<String>,
    #[doc = "The Active Directory site the service will limit Domain Controller discovery to"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub site: Option<String>,
    #[doc = "Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier"]
    #[serde(rename = "backupOperators", default, skip_serializing_if = "Vec::is_empty")]
    pub backup_operators: Vec<String>,
}
impl ActiveDirectory {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Authorize request"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthorizeRequest {
    #[doc = "Resource id of the remote volume"]
    #[serde(rename = "remoteVolumeResourceId", default, skip_serializing_if = "Option::is_none")]
    pub remote_volume_resource_id: Option<String>,
}
impl AuthorizeRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Capacity pool resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CapacityPool {
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Tags are a list of key-value pairs that describe the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<ResourceTags>,
    #[doc = "Pool properties"]
    pub properties: PoolProperties,
}
impl CapacityPool {
    pub fn new(location: String, properties: PoolProperties) -> Self {
        Self {
            location,
            id: None,
            name: None,
            type_: None,
            tags: None,
            properties,
        }
    }
}
#[doc = "List of capacity pool resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CapacityPoolList {
    #[doc = "List of Capacity pools"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CapacityPool>,
}
impl CapacityPoolList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Capacity pool patch resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CapacityPoolPatch {
    #[doc = "Resource location"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Tags are a list of key-value pairs that describe the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<ResourceTags>,
    #[doc = "Patchable pool properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PoolPatchProperties>,
}
impl CapacityPoolPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Volume Export Policy Rule"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExportPolicyRule {
    #[doc = "Order index"]
    #[serde(rename = "ruleIndex", default, skip_serializing_if = "Option::is_none")]
    pub rule_index: Option<i64>,
    #[doc = "Read only access"]
    #[serde(rename = "unixReadOnly", default, skip_serializing_if = "Option::is_none")]
    pub unix_read_only: Option<bool>,
    #[doc = "Read and write access"]
    #[serde(rename = "unixReadWrite", default, skip_serializing_if = "Option::is_none")]
    pub unix_read_write: Option<bool>,
    #[doc = "Allows CIFS protocol"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cifs: Option<bool>,
    #[doc = "Allows NFSv3 protocol. Enable only for NFSv3 type volumes"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub nfsv3: Option<bool>,
    #[doc = "Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub nfsv41: Option<bool>,
    #[doc = "Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names"]
    #[serde(rename = "allowedClients", default, skip_serializing_if = "Option::is_none")]
    pub allowed_clients: Option<String>,
}
impl ExportPolicyRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Mount Target"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MountTarget {
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Tags are a list of key-value pairs that describe the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<ResourceTags>,
    #[doc = "Mount target properties"]
    pub properties: MountTargetProperties,
}
impl MountTarget {
    pub fn new(location: String, properties: MountTargetProperties) -> Self {
        Self {
            location,
            id: None,
            name: None,
            type_: None,
            tags: None,
            properties,
        }
    }
}
#[doc = "Mount target properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MountTargetProperties {
    #[doc = "UUID v4 used to identify the MountTarget"]
    #[serde(rename = "mountTargetId", default, skip_serializing_if = "Option::is_none")]
    pub mount_target_id: Option<String>,
    #[doc = "UUID v4 used to identify the MountTarget"]
    #[serde(rename = "fileSystemId")]
    pub file_system_id: String,
    #[doc = "The mount target's IPv4 address"]
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[doc = "The subnet"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subnet: Option<String>,
    #[doc = "The start of IPv4 address range to use when creating a new mount target"]
    #[serde(rename = "startIp", default, skip_serializing_if = "Option::is_none")]
    pub start_ip: Option<String>,
    #[doc = "The end of IPv4 address range to use when creating a new mount target"]
    #[serde(rename = "endIp", default, skip_serializing_if = "Option::is_none")]
    pub end_ip: Option<String>,
    #[doc = "The gateway of the IPv4 address range to use when creating a new mount target"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub gateway: Option<String>,
    #[doc = "The netmask of the IPv4 address range to use when creating a new mount target"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub netmask: Option<String>,
    #[doc = "The SMB server's Fully Qualified Domain Name, FQDN"]
    #[serde(rename = "smbServerFqdn", default, skip_serializing_if = "Option::is_none")]
    pub smb_server_fqdn: Option<String>,
}
impl MountTargetProperties {
    pub fn new(file_system_id: String) -> Self {
        Self {
            mount_target_id: None,
            file_system_id,
            ip_address: None,
            subnet: None,
            start_ip: None,
            end_ip: None,
            gateway: None,
            netmask: None,
            smb_server_fqdn: None,
        }
    }
}
#[doc = "NetApp account resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetAppAccount {
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Tags are a list of key-value pairs that describe the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<ResourceTags>,
    #[doc = "NetApp account properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AccountProperties>,
}
impl NetAppAccount {
    pub fn new(location: String) -> Self {
        Self {
            location,
            id: None,
            name: None,
            type_: None,
            tags: None,
            properties: None,
        }
    }
}
#[doc = "List of NetApp account resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetAppAccountList {
    #[doc = "Multiple NetApp accounts"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NetAppAccount>,
}
impl NetAppAccountList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "NetApp account patch resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetAppAccountPatch {
    #[doc = "Resource location"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Tags are a list of key-value pairs that describe the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<ResourceTags>,
    #[doc = "NetApp account properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<AccountProperties>,
}
impl NetAppAccountPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Patchable pool properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PoolPatchProperties {
    #[doc = "Provisioned size of the pool (in bytes). Allowed values are in 4TiB chunks (value must be multiply of 4398046511104)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<i64>,
    #[doc = "The service level of the file system"]
    #[serde(rename = "serviceLevel", default, skip_serializing_if = "Option::is_none")]
    pub service_level: Option<pool_patch_properties::ServiceLevel>,
}
impl PoolPatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pool_patch_properties {
    use super::*;
    #[doc = "The service level of the file system"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceLevel {
        Standard,
        Premium,
        Ultra,
    }
    impl Default for ServiceLevel {
        fn default() -> Self {
            Self::Premium
        }
    }
}
#[doc = "Pool properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolProperties {
    #[doc = "UUID v4 used to identify the Pool"]
    #[serde(rename = "poolId", default, skip_serializing_if = "Option::is_none")]
    pub pool_id: Option<String>,
    #[doc = "Provisioned size of the pool (in bytes). Allowed values are in 4TiB chunks (value must be multiply of 4398046511104)."]
    pub size: i64,
    #[doc = "The service level of the file system"]
    #[serde(rename = "serviceLevel")]
    pub service_level: pool_properties::ServiceLevel,
    #[doc = "Azure lifecycle management"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl PoolProperties {
    pub fn new(size: i64, service_level: pool_properties::ServiceLevel) -> Self {
        Self {
            pool_id: None,
            size,
            service_level,
            provisioning_state: None,
        }
    }
}
pub mod pool_properties {
    use super::*;
    #[doc = "The service level of the file system"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceLevel {
        Standard,
        Premium,
        Ultra,
    }
    impl Default for ServiceLevel {
        fn default() -> Self {
            Self::Premium
        }
    }
}
#[doc = "Replication properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReplicationObject {
    #[doc = "Id"]
    #[serde(rename = "replicationId", default, skip_serializing_if = "Option::is_none")]
    pub replication_id: Option<String>,
    #[doc = "Indicates whether the local volume is the source or destination for the Volume Replication"]
    #[serde(rename = "endpointType", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_type: Option<replication_object::EndpointType>,
    #[doc = "Schedule"]
    #[serde(rename = "replicationSchedule")]
    pub replication_schedule: replication_object::ReplicationSchedule,
    #[doc = "The resource ID of the remote volume."]
    #[serde(rename = "remoteVolumeResourceId")]
    pub remote_volume_resource_id: String,
    #[doc = "The remote region for the other end of the Volume Replication."]
    #[serde(rename = "remoteVolumeRegion", default, skip_serializing_if = "Option::is_none")]
    pub remote_volume_region: Option<String>,
}
impl ReplicationObject {
    pub fn new(replication_schedule: replication_object::ReplicationSchedule, remote_volume_resource_id: String) -> Self {
        Self {
            replication_id: None,
            endpoint_type: None,
            replication_schedule,
            remote_volume_resource_id,
            remote_volume_region: None,
        }
    }
}
pub mod replication_object {
    use super::*;
    #[doc = "Indicates whether the local volume is the source or destination for the Volume Replication"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum EndpointType {
        #[serde(rename = "src")]
        Src,
        #[serde(rename = "dst")]
        Dst,
    }
    #[doc = "Schedule"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReplicationSchedule {
        #[serde(rename = "_10minutely")]
        N10minutely,
        #[serde(rename = "hourly")]
        Hourly,
        #[serde(rename = "daily")]
        Daily,
    }
}
#[doc = "Replication status"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ReplicationStatus {
    #[doc = "Replication health check"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub healthy: Option<bool>,
    #[doc = "Status of the mirror relationship"]
    #[serde(rename = "relationshipStatus", default, skip_serializing_if = "Option::is_none")]
    pub relationship_status: Option<replication_status::RelationshipStatus>,
    #[doc = "The status of the replication"]
    #[serde(rename = "mirrorState", default, skip_serializing_if = "Option::is_none")]
    pub mirror_state: Option<replication_status::MirrorState>,
    #[doc = "The progress of the replication"]
    #[serde(rename = "totalProgress", default, skip_serializing_if = "Option::is_none")]
    pub total_progress: Option<String>,
    #[doc = "Displays error message if the replication is in an error state"]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}
impl ReplicationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod replication_status {
    use super::*;
    #[doc = "Status of the mirror relationship"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RelationshipStatus {
        Idle,
        Transferring,
    }
    #[doc = "The status of the replication"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum MirrorState {
        Uninitialized,
        Mirrored,
        Broken,
    }
}
#[doc = "Tags are a list of key-value pairs that describe the resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceTags {}
impl ResourceTags {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Snapshot of a Volume"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Snapshot {
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Snapshot properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SnapshotProperties>,
}
impl Snapshot {
    pub fn new(location: String) -> Self {
        Self {
            location,
            id: None,
            name: None,
            type_: None,
            properties: None,
        }
    }
}
#[doc = "Snapshot patch"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotPatch {}
impl SnapshotPatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Snapshot properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotProperties {
    #[doc = "UUID v4 used to identify the Snapshot"]
    #[serde(rename = "snapshotId", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_id: Option<String>,
    #[doc = "The creation date of the snapshot"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[doc = "Azure lifecycle management"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl SnapshotProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "List of Snapshots"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnapshotsList {
    #[doc = "A list of Snapshots"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Snapshot>,
}
impl SnapshotsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Volume resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Volume {
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Tags are a list of key-value pairs that describe the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<ResourceTags>,
    #[doc = "Volume properties"]
    pub properties: VolumeProperties,
}
impl Volume {
    pub fn new(location: String, properties: VolumeProperties) -> Self {
        Self {
            location,
            id: None,
            name: None,
            type_: None,
            tags: None,
            properties,
        }
    }
}
#[doc = "List of volume resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VolumeList {
    #[doc = "List of volumes"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Volume>,
}
impl VolumeList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Volume patch resource"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VolumePatch {
    #[doc = "Resource location"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[doc = "Resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Tags are a list of key-value pairs that describe the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<ResourceTags>,
    #[doc = "Patchable volume properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<VolumePatchProperties>,
}
impl VolumePatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Patchable volume properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VolumePatchProperties {
    #[doc = "The service level of the file system"]
    #[serde(rename = "serviceLevel", default, skip_serializing_if = "Option::is_none")]
    pub service_level: Option<volume_patch_properties::ServiceLevel>,
    #[doc = "Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in bytes."]
    #[serde(rename = "usageThreshold", default, skip_serializing_if = "Option::is_none")]
    pub usage_threshold: Option<i64>,
    #[doc = "Set of export policy rules"]
    #[serde(rename = "exportPolicy", default, skip_serializing_if = "Option::is_none")]
    pub export_policy: Option<volume_patch_properties::ExportPolicy>,
}
impl VolumePatchProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod volume_patch_properties {
    use super::*;
    #[doc = "The service level of the file system"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceLevel {
        Standard,
        Premium,
        Ultra,
    }
    impl Default for ServiceLevel {
        fn default() -> Self {
            Self::Premium
        }
    }
    #[doc = "Set of export policy rules"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ExportPolicy {
        #[doc = "Export policy rule"]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub rules: Vec<ExportPolicyRule>,
    }
    impl ExportPolicy {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Volume properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VolumeProperties {
    #[doc = "Unique FileSystem Identifier."]
    #[serde(rename = "fileSystemId", default, skip_serializing_if = "Option::is_none")]
    pub file_system_id: Option<String>,
    #[doc = "A unique file path for the volume. Used when creating mount targets"]
    #[serde(rename = "creationToken")]
    pub creation_token: String,
    #[doc = "The service level of the file system"]
    #[serde(rename = "serviceLevel", default, skip_serializing_if = "Option::is_none")]
    pub service_level: Option<volume_properties::ServiceLevel>,
    #[doc = "Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in bytes."]
    #[serde(rename = "usageThreshold")]
    pub usage_threshold: i64,
    #[doc = "Resource size in bytes, current storage usage for the volume in bytes"]
    #[serde(rename = "usedBytes", default, skip_serializing_if = "Option::is_none")]
    pub used_bytes: Option<i64>,
    #[doc = "Set of export policy rules"]
    #[serde(rename = "exportPolicy", default, skip_serializing_if = "Option::is_none")]
    pub export_policy: Option<volume_properties::ExportPolicy>,
    #[doc = "Set of protocol types, default NFSv3, CIFS for SMB protocol"]
    #[serde(rename = "protocolTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub protocol_types: Vec<String>,
    #[doc = "Azure lifecycle management"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "UUID v4 or resource identifier used to identify the Snapshot."]
    #[serde(rename = "snapshotId", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_id: Option<String>,
    #[doc = "Unique Baremetal Tenant Identifier."]
    #[serde(rename = "baremetalTenantId", default, skip_serializing_if = "Option::is_none")]
    pub baremetal_tenant_id: Option<String>,
    #[doc = "The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes"]
    #[serde(rename = "subnetId")]
    pub subnet_id: String,
    #[doc = "List of mount targets"]
    #[serde(rename = "mountTargets", default, skip_serializing_if = "Vec::is_empty")]
    pub mount_targets: Vec<MountTargetProperties>,
    #[doc = "What type of volume is this"]
    #[serde(rename = "volumeType", default, skip_serializing_if = "Option::is_none")]
    pub volume_type: Option<String>,
    #[doc = "DataProtection type volumes include an object containing details of the replication"]
    #[serde(rename = "dataProtection", default, skip_serializing_if = "Option::is_none")]
    pub data_protection: Option<volume_properties::DataProtection>,
    #[doc = "Restoring"]
    #[serde(rename = "isRestoring", default, skip_serializing_if = "Option::is_none")]
    pub is_restoring: Option<bool>,
    #[doc = "If enabled (true) the volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots (default to true)."]
    #[serde(rename = "snapshotDirectoryVisible", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_directory_visible: Option<bool>,
}
impl VolumeProperties {
    pub fn new(creation_token: String, usage_threshold: i64, subnet_id: String) -> Self {
        Self {
            file_system_id: None,
            creation_token,
            service_level: None,
            usage_threshold,
            used_bytes: None,
            export_policy: None,
            protocol_types: Vec::new(),
            provisioning_state: None,
            snapshot_id: None,
            baremetal_tenant_id: None,
            subnet_id,
            mount_targets: Vec::new(),
            volume_type: None,
            data_protection: None,
            is_restoring: None,
            snapshot_directory_visible: None,
        }
    }
}
pub mod volume_properties {
    use super::*;
    #[doc = "The service level of the file system"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServiceLevel {
        Standard,
        Premium,
        Ultra,
    }
    impl Default for ServiceLevel {
        fn default() -> Self {
            Self::Premium
        }
    }
    #[doc = "Set of export policy rules"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ExportPolicy {
        #[doc = "Export policy rule"]
        #[serde(default, skip_serializing_if = "Vec::is_empty")]
        pub rules: Vec<ExportPolicyRule>,
    }
    impl ExportPolicy {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[doc = "DataProtection type volumes include an object containing details of the replication"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct DataProtection {
        #[doc = "Replication properties"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub replication: Option<ReplicationObject>,
        #[doc = "Volume Snapshot Properties"]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub snapshot: Option<VolumeSnapshotProperties>,
    }
    impl DataProtection {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "revert a volume to the snapshot"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VolumeRevert {
    #[doc = "Resource id of the snapshot"]
    #[serde(rename = "snapshotId", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_id: Option<String>,
}
impl VolumeRevert {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Volume Snapshot Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VolumeSnapshotProperties {
    #[doc = "Snapshot Policy ResourceId"]
    #[serde(rename = "snapshotPolicyId", default, skip_serializing_if = "Option::is_none")]
    pub snapshot_policy_id: Option<String>,
}
impl VolumeSnapshotProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
