#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataSource {
    #[doc = "Datasource kind"]
    pub kind: data_source::Kind,
    pub configuration: DataSourceConfiguration,
    pub sinks: Vec<SinkConfiguration>,
}
impl DataSource {
    pub fn new(kind: data_source::Kind, configuration: DataSourceConfiguration, sinks: Vec<SinkConfiguration>) -> Self {
        Self {
            kind,
            configuration,
            sinks,
        }
    }
}
pub mod data_source {
    use super::*;
    #[doc = "Datasource kind"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        PerformanceCounter,
        #[serde(rename = "ETWProviders")]
        EtwProviders,
        WindowsEventLogs,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataSourceConfiguration {
    #[doc = "ETW providers configuration"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub providers: Vec<EtwProviderConfiguration>,
    #[doc = "Performance counter configuration"]
    #[serde(rename = "perfCounters", default, skip_serializing_if = "Vec::is_empty")]
    pub perf_counters: Vec<PerformanceCounterConfiguration>,
    #[doc = "Windows event logs configuration."]
    #[serde(rename = "eventLogs", default, skip_serializing_if = "Vec::is_empty")]
    pub event_logs: Vec<EventLogConfiguration>,
}
impl DataSourceConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Describes the format of Error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "Error code"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "Error message indicating why the operation failed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EtwEventConfiguration {
    pub name: String,
    pub id: i64,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<String>,
}
impl EtwEventConfiguration {
    pub fn new(name: String, id: i64) -> Self {
        Self { name, id, filter: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EtwProviderConfiguration {
    pub id: String,
    pub events: Vec<EtwEventConfiguration>,
}
impl EtwProviderConfiguration {
    pub fn new(id: String, events: Vec<EtwEventConfiguration>) -> Self {
        Self { id, events }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventLogConfiguration {
    #[serde(rename = "logName")]
    pub log_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<String>,
}
impl EventLogConfiguration {
    pub fn new(log_name: String) -> Self {
        Self { log_name, filter: None }
    }
}
#[doc = "Virtual machine diagnostic settings"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettings {
    #[doc = "Operating system type for the configuration"]
    #[serde(rename = "osType", default, skip_serializing_if = "Option::is_none")]
    pub os_type: Option<guest_diagnostic_settings::OsType>,
    #[doc = "the array of data source object which are configured to collect and send data"]
    #[serde(rename = "dataSources", default, skip_serializing_if = "Vec::is_empty")]
    pub data_sources: Vec<DataSource>,
    #[serde(rename = "proxySetting", default, skip_serializing_if = "Option::is_none")]
    pub proxy_setting: Option<String>,
}
impl GuestDiagnosticSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod guest_diagnostic_settings {
    use super::*;
    #[doc = "Operating system type for the configuration"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        Windows,
        Linux,
    }
}
#[doc = "A guest diagnostic settings association."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GuestDiagnosticSettingsAssociation {
    #[doc = "The guest diagnostic settings name."]
    #[serde(rename = "guestDiagnosticSettingsName")]
    pub guest_diagnostic_settings_name: String,
}
impl GuestDiagnosticSettingsAssociation {
    pub fn new(guest_diagnostic_settings_name: String) -> Self {
        Self {
            guest_diagnostic_settings_name,
        }
    }
}
#[doc = "A list of guest diagnostic settings association."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettingsAssociationList {
    #[doc = "The list of guest diagnostic settings association."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GuestDiagnosticSettingsAssociationResource>,
    #[doc = "Provides the link to retrieve the next set of elements."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GuestDiagnosticSettingsAssociationList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual machine guest diagnostic settings resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GuestDiagnosticSettingsAssociationResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "A guest diagnostic settings association."]
    pub properties: GuestDiagnosticSettingsAssociation,
}
impl GuestDiagnosticSettingsAssociationResource {
    pub fn new(resource: Resource, properties: GuestDiagnosticSettingsAssociation) -> Self {
        Self { resource, properties }
    }
}
#[doc = "Guest diagnostic setting resource for patch operations"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettingsAssociationResourcePatch {
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "A guest diagnostic settings association."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GuestDiagnosticSettingsAssociation>,
}
impl GuestDiagnosticSettingsAssociationResourcePatch {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of guest diagnostic settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettingsList {
    #[doc = "The list of guest diagnostic settings."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<GuestDiagnosticSettingsResource>,
    #[doc = "Provides the link to retrieve the next set of elements."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl GuestDiagnosticSettingsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "An diagnostic settings object for the body of patch operations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GuestDiagnosticSettingsPatchResource {
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Virtual machine diagnostic settings"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<GuestDiagnosticSettings>,
}
impl GuestDiagnosticSettingsPatchResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Virtual machine guest diagnostics settings resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GuestDiagnosticSettingsResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Virtual machine diagnostic settings"]
    pub properties: GuestDiagnosticSettings,
}
impl GuestDiagnosticSettingsResource {
    pub fn new(resource: Resource, properties: GuestDiagnosticSettings) -> Self {
        Self { resource, properties }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PerformanceCounterConfiguration {
    pub name: String,
    #[serde(rename = "samplingPeriod")]
    pub sampling_period: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub instance: Option<String>,
}
impl PerformanceCounterConfiguration {
    pub fn new(name: String, sampling_period: String) -> Self {
        Self {
            name,
            sampling_period,
            instance: None,
        }
    }
}
#[doc = "An azure resource object"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Resource {
    #[doc = "Azure resource Id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Azure resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Azure resource type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource location"]
    pub location: String,
    #[doc = "Resource tags"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
}
impl Resource {
    pub fn new(location: String) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            location,
            tags: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SinkConfiguration {
    pub kind: sink_configuration::Kind,
}
impl SinkConfiguration {
    pub fn new(kind: sink_configuration::Kind) -> Self {
        Self { kind }
    }
}
pub mod sink_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        EventHub,
        ApplicationInsights,
        LogAnalytics,
    }
}
